# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetVpcFirewallsResult',
    'AwaitableGetVpcFirewallsResult',
    'get_vpc_firewalls',
    'get_vpc_firewalls_output',
]

@pulumi.output_type
class GetVpcFirewallsResult:
    """
    A collection of values returned by getVpcFirewalls.
    """
    def __init__(__self__, firewalls=None, id=None, ids=None, lang=None, member_uid=None, name_regex=None, names=None, output_file=None, region_no=None, status=None, vpc_firewall_id=None, vpc_firewall_name=None, vpc_id=None):
        if firewalls and not isinstance(firewalls, list):
            raise TypeError("Expected argument 'firewalls' to be a list")
        pulumi.set(__self__, "firewalls", firewalls)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if lang and not isinstance(lang, str):
            raise TypeError("Expected argument 'lang' to be a str")
        pulumi.set(__self__, "lang", lang)
        if member_uid and not isinstance(member_uid, str):
            raise TypeError("Expected argument 'member_uid' to be a str")
        pulumi.set(__self__, "member_uid", member_uid)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if region_no and not isinstance(region_no, str):
            raise TypeError("Expected argument 'region_no' to be a str")
        pulumi.set(__self__, "region_no", region_no)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if vpc_firewall_id and not isinstance(vpc_firewall_id, str):
            raise TypeError("Expected argument 'vpc_firewall_id' to be a str")
        pulumi.set(__self__, "vpc_firewall_id", vpc_firewall_id)
        if vpc_firewall_name and not isinstance(vpc_firewall_name, str):
            raise TypeError("Expected argument 'vpc_firewall_name' to be a str")
        pulumi.set(__self__, "vpc_firewall_name", vpc_firewall_name)
        if vpc_id and not isinstance(vpc_id, str):
            raise TypeError("Expected argument 'vpc_id' to be a str")
        pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter
    def firewalls(self) -> Sequence['outputs.GetVpcFirewallsFirewallResult']:
        """
        A list of Vpc Firewall Entries. Each element contains the following attributes:
        """
        return pulumi.get(self, "firewalls")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        """
        A list of Vpc Firewall IDs.
        """
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter
    def lang(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "lang")

    @_builtins.property
    @pulumi.getter(name="memberUid")
    def member_uid(self) -> Optional[_builtins.str]:
        """
        The UID of the Alibaba Cloud member account.
        """
        return pulumi.get(self, "member_uid")

    @_builtins.property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name_regex")

    @_builtins.property
    @pulumi.getter
    def names(self) -> Sequence[_builtins.str]:
        """
        A list of name of Vpc Firewalls.
        """
        return pulumi.get(self, "names")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter(name="regionNo")
    def region_no(self) -> Optional[_builtins.str]:
        """
        The region ID of the peer VPC.
        """
        return pulumi.get(self, "region_no")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        The status of the resource
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="vpcFirewallId")
    def vpc_firewall_id(self) -> Optional[_builtins.str]:
        """
        The ID of the VPC firewall instance.
        """
        return pulumi.get(self, "vpc_firewall_id")

    @_builtins.property
    @pulumi.getter(name="vpcFirewallName")
    def vpc_firewall_name(self) -> Optional[_builtins.str]:
        """
        The name of the VPC firewall instance.
        """
        return pulumi.get(self, "vpc_firewall_name")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[_builtins.str]:
        """
        The ID of the peer VPC instance.
        """
        return pulumi.get(self, "vpc_id")


class AwaitableGetVpcFirewallsResult(GetVpcFirewallsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVpcFirewallsResult(
            firewalls=self.firewalls,
            id=self.id,
            ids=self.ids,
            lang=self.lang,
            member_uid=self.member_uid,
            name_regex=self.name_regex,
            names=self.names,
            output_file=self.output_file,
            region_no=self.region_no,
            status=self.status,
            vpc_firewall_id=self.vpc_firewall_id,
            vpc_firewall_name=self.vpc_firewall_name,
            vpc_id=self.vpc_id)


def get_vpc_firewalls(ids: Optional[Sequence[_builtins.str]] = None,
                      lang: Optional[_builtins.str] = None,
                      member_uid: Optional[_builtins.str] = None,
                      name_regex: Optional[_builtins.str] = None,
                      output_file: Optional[_builtins.str] = None,
                      region_no: Optional[_builtins.str] = None,
                      status: Optional[_builtins.str] = None,
                      vpc_firewall_id: Optional[_builtins.str] = None,
                      vpc_firewall_name: Optional[_builtins.str] = None,
                      vpc_id: Optional[_builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVpcFirewallsResult:
    """
    This data source provides Cloud Firewall Vpc Firewall available to the user.[What is Vpc Firewall](https://help.aliyun.com/document_detail/342932.html)

    > **NOTE:** Available since v1.194.0.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    default = alicloud.cloudfirewall.get_vpc_firewalls(ids=["id-example"],
        member_uid="1415189284827022",
        status="closed",
        vpc_firewall_name="tf-test")
    pulumi.export("alicloudCfwVpcFirewallExampleId", default.firewalls[0].id)
    ```


    :param Sequence[_builtins.str] ids: A list of Vpc Firewall IDs.
    :param _builtins.str lang: The language type of the requested and received messages. Value:-**zh** (default): Chinese.-**en**: English.
    :param _builtins.str member_uid: The UID of the Alibaba Cloud member account.
    :param _builtins.str name_regex: A regex string to filter results by Group Metric Rule name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str region_no: The region ID of the peer VPC.
    :param _builtins.str status: The status of the resource
    :param _builtins.str vpc_firewall_id: The ID of the VPC firewall instance.
    :param _builtins.str vpc_firewall_name: The name of the VPC firewall instance.
    :param _builtins.str vpc_id: The ID of the peer VPC instance.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['lang'] = lang
    __args__['memberUid'] = member_uid
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['regionNo'] = region_no
    __args__['status'] = status
    __args__['vpcFirewallId'] = vpc_firewall_id
    __args__['vpcFirewallName'] = vpc_firewall_name
    __args__['vpcId'] = vpc_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:cloudfirewall/getVpcFirewalls:getVpcFirewalls', __args__, opts=opts, typ=GetVpcFirewallsResult).value

    return AwaitableGetVpcFirewallsResult(
        firewalls=pulumi.get(__ret__, 'firewalls'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        lang=pulumi.get(__ret__, 'lang'),
        member_uid=pulumi.get(__ret__, 'member_uid'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        output_file=pulumi.get(__ret__, 'output_file'),
        region_no=pulumi.get(__ret__, 'region_no'),
        status=pulumi.get(__ret__, 'status'),
        vpc_firewall_id=pulumi.get(__ret__, 'vpc_firewall_id'),
        vpc_firewall_name=pulumi.get(__ret__, 'vpc_firewall_name'),
        vpc_id=pulumi.get(__ret__, 'vpc_id'))
def get_vpc_firewalls_output(ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                             lang: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             member_uid: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             name_regex: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             region_no: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             vpc_firewall_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             vpc_firewall_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             vpc_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVpcFirewallsResult]:
    """
    This data source provides Cloud Firewall Vpc Firewall available to the user.[What is Vpc Firewall](https://help.aliyun.com/document_detail/342932.html)

    > **NOTE:** Available since v1.194.0.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    default = alicloud.cloudfirewall.get_vpc_firewalls(ids=["id-example"],
        member_uid="1415189284827022",
        status="closed",
        vpc_firewall_name="tf-test")
    pulumi.export("alicloudCfwVpcFirewallExampleId", default.firewalls[0].id)
    ```


    :param Sequence[_builtins.str] ids: A list of Vpc Firewall IDs.
    :param _builtins.str lang: The language type of the requested and received messages. Value:-**zh** (default): Chinese.-**en**: English.
    :param _builtins.str member_uid: The UID of the Alibaba Cloud member account.
    :param _builtins.str name_regex: A regex string to filter results by Group Metric Rule name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str region_no: The region ID of the peer VPC.
    :param _builtins.str status: The status of the resource
    :param _builtins.str vpc_firewall_id: The ID of the VPC firewall instance.
    :param _builtins.str vpc_firewall_name: The name of the VPC firewall instance.
    :param _builtins.str vpc_id: The ID of the peer VPC instance.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['lang'] = lang
    __args__['memberUid'] = member_uid
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['regionNo'] = region_no
    __args__['status'] = status
    __args__['vpcFirewallId'] = vpc_firewall_id
    __args__['vpcFirewallName'] = vpc_firewall_name
    __args__['vpcId'] = vpc_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:cloudfirewall/getVpcFirewalls:getVpcFirewalls', __args__, opts=opts, typ=GetVpcFirewallsResult)
    return __ret__.apply(lambda __response__: GetVpcFirewallsResult(
        firewalls=pulumi.get(__response__, 'firewalls'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        lang=pulumi.get(__response__, 'lang'),
        member_uid=pulumi.get(__response__, 'member_uid'),
        name_regex=pulumi.get(__response__, 'name_regex'),
        names=pulumi.get(__response__, 'names'),
        output_file=pulumi.get(__response__, 'output_file'),
        region_no=pulumi.get(__response__, 'region_no'),
        status=pulumi.get(__response__, 'status'),
        vpc_firewall_id=pulumi.get(__response__, 'vpc_firewall_id'),
        vpc_firewall_name=pulumi.get(__response__, 'vpc_firewall_name'),
        vpc_id=pulumi.get(__response__, 'vpc_id')))
