# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['IpsConfigArgs', 'IpsConfig']

@pulumi.input_type
class IpsConfigArgs:
    def __init__(__self__, *,
                 basic_rules: Optional[pulumi.Input[_builtins.int]] = None,
                 cti_rules: Optional[pulumi.Input[_builtins.int]] = None,
                 lang: Optional[pulumi.Input[_builtins.str]] = None,
                 max_sdl: Optional[pulumi.Input[_builtins.int]] = None,
                 patch_rules: Optional[pulumi.Input[_builtins.int]] = None,
                 rule_class: Optional[pulumi.Input[_builtins.int]] = None,
                 run_mode: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a IpsConfig resource.
        :param pulumi.Input[_builtins.int] basic_rules: Basic rule switch. Value:
               - 1: Open.
               - 0: Closed (Default).
        :param pulumi.Input[_builtins.int] cti_rules: Threat intelligence. Value:
               - 1: Open.
               - 0: Closed (Default).
        :param pulumi.Input[_builtins.str] lang: Language
        :param pulumi.Input[_builtins.int] max_sdl: Sensitive data detection Daily detection traffic limit. Defaults to 0.
        :param pulumi.Input[_builtins.int] patch_rules: Virtual patch switch. Value:
               - 1: Open.
               - 0: Closed (Default).
        :param pulumi.Input[_builtins.int] rule_class: The IPS rule Group. Value:
               - 1: loose rule Group.
               - 2: Medium rule Group.
               - 3: Strict rule groups.
        :param pulumi.Input[_builtins.int] run_mode: IPS defense mode. Value:
               - 1: Intercept mode.
               - 0: Observation mode (Default).
        """
        if basic_rules is not None:
            pulumi.set(__self__, "basic_rules", basic_rules)
        if cti_rules is not None:
            pulumi.set(__self__, "cti_rules", cti_rules)
        if lang is not None:
            pulumi.set(__self__, "lang", lang)
        if max_sdl is not None:
            pulumi.set(__self__, "max_sdl", max_sdl)
        if patch_rules is not None:
            pulumi.set(__self__, "patch_rules", patch_rules)
        if rule_class is not None:
            pulumi.set(__self__, "rule_class", rule_class)
        if run_mode is not None:
            pulumi.set(__self__, "run_mode", run_mode)

    @_builtins.property
    @pulumi.getter(name="basicRules")
    def basic_rules(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Basic rule switch. Value:
        - 1: Open.
        - 0: Closed (Default).
        """
        return pulumi.get(self, "basic_rules")

    @basic_rules.setter
    def basic_rules(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "basic_rules", value)

    @_builtins.property
    @pulumi.getter(name="ctiRules")
    def cti_rules(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Threat intelligence. Value:
        - 1: Open.
        - 0: Closed (Default).
        """
        return pulumi.get(self, "cti_rules")

    @cti_rules.setter
    def cti_rules(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cti_rules", value)

    @_builtins.property
    @pulumi.getter
    def lang(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Language
        """
        return pulumi.get(self, "lang")

    @lang.setter
    def lang(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lang", value)

    @_builtins.property
    @pulumi.getter(name="maxSdl")
    def max_sdl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Sensitive data detection Daily detection traffic limit. Defaults to 0.
        """
        return pulumi.get(self, "max_sdl")

    @max_sdl.setter
    def max_sdl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_sdl", value)

    @_builtins.property
    @pulumi.getter(name="patchRules")
    def patch_rules(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Virtual patch switch. Value:
        - 1: Open.
        - 0: Closed (Default).
        """
        return pulumi.get(self, "patch_rules")

    @patch_rules.setter
    def patch_rules(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "patch_rules", value)

    @_builtins.property
    @pulumi.getter(name="ruleClass")
    def rule_class(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The IPS rule Group. Value:
        - 1: loose rule Group.
        - 2: Medium rule Group.
        - 3: Strict rule groups.
        """
        return pulumi.get(self, "rule_class")

    @rule_class.setter
    def rule_class(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "rule_class", value)

    @_builtins.property
    @pulumi.getter(name="runMode")
    def run_mode(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        IPS defense mode. Value:
        - 1: Intercept mode.
        - 0: Observation mode (Default).
        """
        return pulumi.get(self, "run_mode")

    @run_mode.setter
    def run_mode(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "run_mode", value)


@pulumi.input_type
class _IpsConfigState:
    def __init__(__self__, *,
                 basic_rules: Optional[pulumi.Input[_builtins.int]] = None,
                 cti_rules: Optional[pulumi.Input[_builtins.int]] = None,
                 lang: Optional[pulumi.Input[_builtins.str]] = None,
                 max_sdl: Optional[pulumi.Input[_builtins.int]] = None,
                 patch_rules: Optional[pulumi.Input[_builtins.int]] = None,
                 rule_class: Optional[pulumi.Input[_builtins.int]] = None,
                 run_mode: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering IpsConfig resources.
        :param pulumi.Input[_builtins.int] basic_rules: Basic rule switch. Value:
               - 1: Open.
               - 0: Closed (Default).
        :param pulumi.Input[_builtins.int] cti_rules: Threat intelligence. Value:
               - 1: Open.
               - 0: Closed (Default).
        :param pulumi.Input[_builtins.str] lang: Language
        :param pulumi.Input[_builtins.int] max_sdl: Sensitive data detection Daily detection traffic limit. Defaults to 0.
        :param pulumi.Input[_builtins.int] patch_rules: Virtual patch switch. Value:
               - 1: Open.
               - 0: Closed (Default).
        :param pulumi.Input[_builtins.int] rule_class: The IPS rule Group. Value:
               - 1: loose rule Group.
               - 2: Medium rule Group.
               - 3: Strict rule groups.
        :param pulumi.Input[_builtins.int] run_mode: IPS defense mode. Value:
               - 1: Intercept mode.
               - 0: Observation mode (Default).
        """
        if basic_rules is not None:
            pulumi.set(__self__, "basic_rules", basic_rules)
        if cti_rules is not None:
            pulumi.set(__self__, "cti_rules", cti_rules)
        if lang is not None:
            pulumi.set(__self__, "lang", lang)
        if max_sdl is not None:
            pulumi.set(__self__, "max_sdl", max_sdl)
        if patch_rules is not None:
            pulumi.set(__self__, "patch_rules", patch_rules)
        if rule_class is not None:
            pulumi.set(__self__, "rule_class", rule_class)
        if run_mode is not None:
            pulumi.set(__self__, "run_mode", run_mode)

    @_builtins.property
    @pulumi.getter(name="basicRules")
    def basic_rules(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Basic rule switch. Value:
        - 1: Open.
        - 0: Closed (Default).
        """
        return pulumi.get(self, "basic_rules")

    @basic_rules.setter
    def basic_rules(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "basic_rules", value)

    @_builtins.property
    @pulumi.getter(name="ctiRules")
    def cti_rules(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Threat intelligence. Value:
        - 1: Open.
        - 0: Closed (Default).
        """
        return pulumi.get(self, "cti_rules")

    @cti_rules.setter
    def cti_rules(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cti_rules", value)

    @_builtins.property
    @pulumi.getter
    def lang(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Language
        """
        return pulumi.get(self, "lang")

    @lang.setter
    def lang(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lang", value)

    @_builtins.property
    @pulumi.getter(name="maxSdl")
    def max_sdl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Sensitive data detection Daily detection traffic limit. Defaults to 0.
        """
        return pulumi.get(self, "max_sdl")

    @max_sdl.setter
    def max_sdl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_sdl", value)

    @_builtins.property
    @pulumi.getter(name="patchRules")
    def patch_rules(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Virtual patch switch. Value:
        - 1: Open.
        - 0: Closed (Default).
        """
        return pulumi.get(self, "patch_rules")

    @patch_rules.setter
    def patch_rules(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "patch_rules", value)

    @_builtins.property
    @pulumi.getter(name="ruleClass")
    def rule_class(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The IPS rule Group. Value:
        - 1: loose rule Group.
        - 2: Medium rule Group.
        - 3: Strict rule groups.
        """
        return pulumi.get(self, "rule_class")

    @rule_class.setter
    def rule_class(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "rule_class", value)

    @_builtins.property
    @pulumi.getter(name="runMode")
    def run_mode(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        IPS defense mode. Value:
        - 1: Intercept mode.
        - 0: Observation mode (Default).
        """
        return pulumi.get(self, "run_mode")

    @run_mode.setter
    def run_mode(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "run_mode", value)


@pulumi.type_token("alicloud:cloudfirewall/ipsConfig:IpsConfig")
class IpsConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 basic_rules: Optional[pulumi.Input[_builtins.int]] = None,
                 cti_rules: Optional[pulumi.Input[_builtins.int]] = None,
                 lang: Optional[pulumi.Input[_builtins.str]] = None,
                 max_sdl: Optional[pulumi.Input[_builtins.int]] = None,
                 patch_rules: Optional[pulumi.Input[_builtins.int]] = None,
                 rule_class: Optional[pulumi.Input[_builtins.int]] = None,
                 run_mode: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        ## Import

        Cloud Firewall IPS Config can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cloudfirewall/ipsConfig:IpsConfig example 
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] basic_rules: Basic rule switch. Value:
               - 1: Open.
               - 0: Closed (Default).
        :param pulumi.Input[_builtins.int] cti_rules: Threat intelligence. Value:
               - 1: Open.
               - 0: Closed (Default).
        :param pulumi.Input[_builtins.str] lang: Language
        :param pulumi.Input[_builtins.int] max_sdl: Sensitive data detection Daily detection traffic limit. Defaults to 0.
        :param pulumi.Input[_builtins.int] patch_rules: Virtual patch switch. Value:
               - 1: Open.
               - 0: Closed (Default).
        :param pulumi.Input[_builtins.int] rule_class: The IPS rule Group. Value:
               - 1: loose rule Group.
               - 2: Medium rule Group.
               - 3: Strict rule groups.
        :param pulumi.Input[_builtins.int] run_mode: IPS defense mode. Value:
               - 1: Intercept mode.
               - 0: Observation mode (Default).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[IpsConfigArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        Cloud Firewall IPS Config can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cloudfirewall/ipsConfig:IpsConfig example 
        ```

        :param str resource_name: The name of the resource.
        :param IpsConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IpsConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 basic_rules: Optional[pulumi.Input[_builtins.int]] = None,
                 cti_rules: Optional[pulumi.Input[_builtins.int]] = None,
                 lang: Optional[pulumi.Input[_builtins.str]] = None,
                 max_sdl: Optional[pulumi.Input[_builtins.int]] = None,
                 patch_rules: Optional[pulumi.Input[_builtins.int]] = None,
                 rule_class: Optional[pulumi.Input[_builtins.int]] = None,
                 run_mode: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IpsConfigArgs.__new__(IpsConfigArgs)

            __props__.__dict__["basic_rules"] = basic_rules
            __props__.__dict__["cti_rules"] = cti_rules
            __props__.__dict__["lang"] = lang
            __props__.__dict__["max_sdl"] = max_sdl
            __props__.__dict__["patch_rules"] = patch_rules
            __props__.__dict__["rule_class"] = rule_class
            __props__.__dict__["run_mode"] = run_mode
        super(IpsConfig, __self__).__init__(
            'alicloud:cloudfirewall/ipsConfig:IpsConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            basic_rules: Optional[pulumi.Input[_builtins.int]] = None,
            cti_rules: Optional[pulumi.Input[_builtins.int]] = None,
            lang: Optional[pulumi.Input[_builtins.str]] = None,
            max_sdl: Optional[pulumi.Input[_builtins.int]] = None,
            patch_rules: Optional[pulumi.Input[_builtins.int]] = None,
            rule_class: Optional[pulumi.Input[_builtins.int]] = None,
            run_mode: Optional[pulumi.Input[_builtins.int]] = None) -> 'IpsConfig':
        """
        Get an existing IpsConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] basic_rules: Basic rule switch. Value:
               - 1: Open.
               - 0: Closed (Default).
        :param pulumi.Input[_builtins.int] cti_rules: Threat intelligence. Value:
               - 1: Open.
               - 0: Closed (Default).
        :param pulumi.Input[_builtins.str] lang: Language
        :param pulumi.Input[_builtins.int] max_sdl: Sensitive data detection Daily detection traffic limit. Defaults to 0.
        :param pulumi.Input[_builtins.int] patch_rules: Virtual patch switch. Value:
               - 1: Open.
               - 0: Closed (Default).
        :param pulumi.Input[_builtins.int] rule_class: The IPS rule Group. Value:
               - 1: loose rule Group.
               - 2: Medium rule Group.
               - 3: Strict rule groups.
        :param pulumi.Input[_builtins.int] run_mode: IPS defense mode. Value:
               - 1: Intercept mode.
               - 0: Observation mode (Default).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IpsConfigState.__new__(_IpsConfigState)

        __props__.__dict__["basic_rules"] = basic_rules
        __props__.__dict__["cti_rules"] = cti_rules
        __props__.__dict__["lang"] = lang
        __props__.__dict__["max_sdl"] = max_sdl
        __props__.__dict__["patch_rules"] = patch_rules
        __props__.__dict__["rule_class"] = rule_class
        __props__.__dict__["run_mode"] = run_mode
        return IpsConfig(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="basicRules")
    def basic_rules(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Basic rule switch. Value:
        - 1: Open.
        - 0: Closed (Default).
        """
        return pulumi.get(self, "basic_rules")

    @_builtins.property
    @pulumi.getter(name="ctiRules")
    def cti_rules(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Threat intelligence. Value:
        - 1: Open.
        - 0: Closed (Default).
        """
        return pulumi.get(self, "cti_rules")

    @_builtins.property
    @pulumi.getter
    def lang(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Language
        """
        return pulumi.get(self, "lang")

    @_builtins.property
    @pulumi.getter(name="maxSdl")
    def max_sdl(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Sensitive data detection Daily detection traffic limit. Defaults to 0.
        """
        return pulumi.get(self, "max_sdl")

    @_builtins.property
    @pulumi.getter(name="patchRules")
    def patch_rules(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Virtual patch switch. Value:
        - 1: Open.
        - 0: Closed (Default).
        """
        return pulumi.get(self, "patch_rules")

    @_builtins.property
    @pulumi.getter(name="ruleClass")
    def rule_class(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The IPS rule Group. Value:
        - 1: loose rule Group.
        - 2: Medium rule Group.
        - 3: Strict rule groups.
        """
        return pulumi.get(self, "rule_class")

    @_builtins.property
    @pulumi.getter(name="runMode")
    def run_mode(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        IPS defense mode. Value:
        - 1: Intercept mode.
        - 0: Observation mode (Default).
        """
        return pulumi.get(self, "run_mode")

