# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'AddressBookEcsTag',
    'FirewallVpcFirewallCenLocalVpc',
    'FirewallVpcFirewallCenLocalVpcEniList',
    'FirewallVpcFirewallCenLocalVpcVpcCidrTableList',
    'FirewallVpcFirewallCenLocalVpcVpcCidrTableListRouteEntryList',
    'FirewallVpcFirewallLocalVpc',
    'FirewallVpcFirewallLocalVpcLocalVpcCidrTableList',
    'FirewallVpcFirewallLocalVpcLocalVpcCidrTableListLocalRouteEntryList',
    'FirewallVpcFirewallPeerVpc',
    'FirewallVpcFirewallPeerVpcPeerVpcCidrTableList',
    'FirewallVpcFirewallPeerVpcPeerVpcCidrTableListPeerRouteEntryList',
    'NatFirewallNatRouteEntryList',
    'GetAddressBooksBookResult',
    'GetAddressBooksBookEcsTagResult',
    'GetControlPoliciesPolicyResult',
    'GetInstanceMembersMemberResult',
    'GetInstancesInstanceResult',
    'GetNatFirewallsFirewallResult',
    'GetNatFirewallsFirewallNatRouteEntryListResult',
    'GetVpcCenTrFirewallsFirewallResult',
    'GetVpcCenTrFirewallsFirewallIpsConfigResult',
    'GetVpcFirewallCensCenResult',
    'GetVpcFirewallCensCenLocalVpcResult',
    'GetVpcFirewallCensCenLocalVpcEniListResult',
    'GetVpcFirewallCensCenLocalVpcVpcCidrTableListResult',
    'GetVpcFirewallCensCenLocalVpcVpcCidrTableListRouteEntryListResult',
    'GetVpcFirewallControlPoliciesPolicyResult',
    'GetVpcFirewallsFirewallResult',
    'GetVpcFirewallsFirewallLocalVpcResult',
    'GetVpcFirewallsFirewallLocalVpcLocalVpcCidrTableListResult',
    'GetVpcFirewallsFirewallLocalVpcLocalVpcCidrTableListLocalRouteEntryListResult',
    'GetVpcFirewallsFirewallPeerVpcResult',
    'GetVpcFirewallsFirewallPeerVpcPeerVpcCidrTableListResult',
    'GetVpcFirewallsFirewallPeerVpcPeerVpcCidrTableListPeerRouteEntryListResult',
]

@pulumi.output_type
class AddressBookEcsTag(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "tagKey":
            suggest = "tag_key"
        elif key == "tagValue":
            suggest = "tag_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AddressBookEcsTag. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AddressBookEcsTag.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AddressBookEcsTag.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 tag_key: Optional[_builtins.str] = None,
                 tag_value: Optional[_builtins.str] = None):
        """
        :param _builtins.str tag_key: The key of ECS tag that to be matched.
        :param _builtins.str tag_value: The value of ECS tag that to be matched.
        """
        if tag_key is not None:
            pulumi.set(__self__, "tag_key", tag_key)
        if tag_value is not None:
            pulumi.set(__self__, "tag_value", tag_value)

    @_builtins.property
    @pulumi.getter(name="tagKey")
    def tag_key(self) -> Optional[_builtins.str]:
        """
        The key of ECS tag that to be matched.
        """
        return pulumi.get(self, "tag_key")

    @_builtins.property
    @pulumi.getter(name="tagValue")
    def tag_value(self) -> Optional[_builtins.str]:
        """
        The value of ECS tag that to be matched.
        """
        return pulumi.get(self, "tag_value")


@pulumi.output_type
class FirewallVpcFirewallCenLocalVpc(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "networkInstanceId":
            suggest = "network_instance_id"
        elif key == "attachmentId":
            suggest = "attachment_id"
        elif key == "attachmentName":
            suggest = "attachment_name"
        elif key == "defendCidrLists":
            suggest = "defend_cidr_lists"
        elif key == "eniLists":
            suggest = "eni_lists"
        elif key == "manualVswitchId":
            suggest = "manual_vswitch_id"
        elif key == "networkInstanceName":
            suggest = "network_instance_name"
        elif key == "networkInstanceType":
            suggest = "network_instance_type"
        elif key == "ownerId":
            suggest = "owner_id"
        elif key == "regionNo":
            suggest = "region_no"
        elif key == "routeMode":
            suggest = "route_mode"
        elif key == "supportManualMode":
            suggest = "support_manual_mode"
        elif key == "transitRouterId":
            suggest = "transit_router_id"
        elif key == "transitRouterType":
            suggest = "transit_router_type"
        elif key == "vpcCidrTableLists":
            suggest = "vpc_cidr_table_lists"
        elif key == "vpcId":
            suggest = "vpc_id"
        elif key == "vpcName":
            suggest = "vpc_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FirewallVpcFirewallCenLocalVpc. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FirewallVpcFirewallCenLocalVpc.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FirewallVpcFirewallCenLocalVpc.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 network_instance_id: _builtins.str,
                 attachment_id: Optional[_builtins.str] = None,
                 attachment_name: Optional[_builtins.str] = None,
                 defend_cidr_lists: Optional[Sequence[_builtins.str]] = None,
                 eni_lists: Optional[Sequence['outputs.FirewallVpcFirewallCenLocalVpcEniList']] = None,
                 manual_vswitch_id: Optional[_builtins.str] = None,
                 network_instance_name: Optional[_builtins.str] = None,
                 network_instance_type: Optional[_builtins.str] = None,
                 owner_id: Optional[_builtins.str] = None,
                 region_no: Optional[_builtins.str] = None,
                 route_mode: Optional[_builtins.str] = None,
                 support_manual_mode: Optional[_builtins.str] = None,
                 transit_router_id: Optional[_builtins.str] = None,
                 transit_router_type: Optional[_builtins.str] = None,
                 vpc_cidr_table_lists: Optional[Sequence['outputs.FirewallVpcFirewallCenLocalVpcVpcCidrTableList']] = None,
                 vpc_id: Optional[_builtins.str] = None,
                 vpc_name: Optional[_builtins.str] = None):
        """
        :param _builtins.str network_instance_id: The ID of the VPC instance that created the VPC firewall.
        :param _builtins.str attachment_id: The connection ID of the network instance.
        :param _builtins.str attachment_name: The connection name of the network instance.
        :param Sequence[_builtins.str] defend_cidr_lists: The list of network segments protected by the VPC firewall.
        :param Sequence['FirewallVpcFirewallCenLocalVpcEniListArgs'] eni_lists: List of elastic network cards.
        :param _builtins.str manual_vswitch_id: The ID of the vSwitch specified when the routing mode is manual mode.
        :param _builtins.str network_instance_name: The name of the network instance.
        :param _builtins.str network_instance_type: The type of the network instance. Value: **VPC * *.
        :param _builtins.str owner_id: The UID of the Alibaba Cloud account to which the VPC belongs.
        :param _builtins.str region_no: The region ID of the VPC.
        :param _builtins.str route_mode: Routing mode,. Value:-auto: indicates automatic mode.-manual: indicates manual mode.
        :param _builtins.str support_manual_mode: Whether routing mode supports manual mode. Value:-**1**: Supported.-**0**: Not supported.
        :param _builtins.str transit_router_id: The ID of the CEN-TR instance.
        :param _builtins.str transit_router_type: The version of the cloud enterprise network forwarding router (CEN-TR). Value:-**Basic**: Basic Edition.-**Enterprise**: Enterprise Edition.
        :param Sequence['FirewallVpcFirewallCenLocalVpcVpcCidrTableListArgs'] vpc_cidr_table_lists: The VPC network segment list.
        :param _builtins.str vpc_id: The ID of the VPC instance.
        :param _builtins.str vpc_name: The instance name of the VPC.
        """
        pulumi.set(__self__, "network_instance_id", network_instance_id)
        if attachment_id is not None:
            pulumi.set(__self__, "attachment_id", attachment_id)
        if attachment_name is not None:
            pulumi.set(__self__, "attachment_name", attachment_name)
        if defend_cidr_lists is not None:
            pulumi.set(__self__, "defend_cidr_lists", defend_cidr_lists)
        if eni_lists is not None:
            pulumi.set(__self__, "eni_lists", eni_lists)
        if manual_vswitch_id is not None:
            pulumi.set(__self__, "manual_vswitch_id", manual_vswitch_id)
        if network_instance_name is not None:
            pulumi.set(__self__, "network_instance_name", network_instance_name)
        if network_instance_type is not None:
            pulumi.set(__self__, "network_instance_type", network_instance_type)
        if owner_id is not None:
            pulumi.set(__self__, "owner_id", owner_id)
        if region_no is not None:
            pulumi.set(__self__, "region_no", region_no)
        if route_mode is not None:
            pulumi.set(__self__, "route_mode", route_mode)
        if support_manual_mode is not None:
            pulumi.set(__self__, "support_manual_mode", support_manual_mode)
        if transit_router_id is not None:
            pulumi.set(__self__, "transit_router_id", transit_router_id)
        if transit_router_type is not None:
            pulumi.set(__self__, "transit_router_type", transit_router_type)
        if vpc_cidr_table_lists is not None:
            pulumi.set(__self__, "vpc_cidr_table_lists", vpc_cidr_table_lists)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vpc_name is not None:
            pulumi.set(__self__, "vpc_name", vpc_name)

    @_builtins.property
    @pulumi.getter(name="networkInstanceId")
    def network_instance_id(self) -> _builtins.str:
        """
        The ID of the VPC instance that created the VPC firewall.
        """
        return pulumi.get(self, "network_instance_id")

    @_builtins.property
    @pulumi.getter(name="attachmentId")
    def attachment_id(self) -> Optional[_builtins.str]:
        """
        The connection ID of the network instance.
        """
        return pulumi.get(self, "attachment_id")

    @_builtins.property
    @pulumi.getter(name="attachmentName")
    def attachment_name(self) -> Optional[_builtins.str]:
        """
        The connection name of the network instance.
        """
        return pulumi.get(self, "attachment_name")

    @_builtins.property
    @pulumi.getter(name="defendCidrLists")
    def defend_cidr_lists(self) -> Optional[Sequence[_builtins.str]]:
        """
        The list of network segments protected by the VPC firewall.
        """
        return pulumi.get(self, "defend_cidr_lists")

    @_builtins.property
    @pulumi.getter(name="eniLists")
    def eni_lists(self) -> Optional[Sequence['outputs.FirewallVpcFirewallCenLocalVpcEniList']]:
        """
        List of elastic network cards.
        """
        return pulumi.get(self, "eni_lists")

    @_builtins.property
    @pulumi.getter(name="manualVswitchId")
    def manual_vswitch_id(self) -> Optional[_builtins.str]:
        """
        The ID of the vSwitch specified when the routing mode is manual mode.
        """
        return pulumi.get(self, "manual_vswitch_id")

    @_builtins.property
    @pulumi.getter(name="networkInstanceName")
    def network_instance_name(self) -> Optional[_builtins.str]:
        """
        The name of the network instance.
        """
        return pulumi.get(self, "network_instance_name")

    @_builtins.property
    @pulumi.getter(name="networkInstanceType")
    def network_instance_type(self) -> Optional[_builtins.str]:
        """
        The type of the network instance. Value: **VPC * *.
        """
        return pulumi.get(self, "network_instance_type")

    @_builtins.property
    @pulumi.getter(name="ownerId")
    def owner_id(self) -> Optional[_builtins.str]:
        """
        The UID of the Alibaba Cloud account to which the VPC belongs.
        """
        return pulumi.get(self, "owner_id")

    @_builtins.property
    @pulumi.getter(name="regionNo")
    def region_no(self) -> Optional[_builtins.str]:
        """
        The region ID of the VPC.
        """
        return pulumi.get(self, "region_no")

    @_builtins.property
    @pulumi.getter(name="routeMode")
    def route_mode(self) -> Optional[_builtins.str]:
        """
        Routing mode,. Value:-auto: indicates automatic mode.-manual: indicates manual mode.
        """
        return pulumi.get(self, "route_mode")

    @_builtins.property
    @pulumi.getter(name="supportManualMode")
    def support_manual_mode(self) -> Optional[_builtins.str]:
        """
        Whether routing mode supports manual mode. Value:-**1**: Supported.-**0**: Not supported.
        """
        return pulumi.get(self, "support_manual_mode")

    @_builtins.property
    @pulumi.getter(name="transitRouterId")
    def transit_router_id(self) -> Optional[_builtins.str]:
        """
        The ID of the CEN-TR instance.
        """
        return pulumi.get(self, "transit_router_id")

    @_builtins.property
    @pulumi.getter(name="transitRouterType")
    def transit_router_type(self) -> Optional[_builtins.str]:
        """
        The version of the cloud enterprise network forwarding router (CEN-TR). Value:-**Basic**: Basic Edition.-**Enterprise**: Enterprise Edition.
        """
        return pulumi.get(self, "transit_router_type")

    @_builtins.property
    @pulumi.getter(name="vpcCidrTableLists")
    def vpc_cidr_table_lists(self) -> Optional[Sequence['outputs.FirewallVpcFirewallCenLocalVpcVpcCidrTableList']]:
        """
        The VPC network segment list.
        """
        return pulumi.get(self, "vpc_cidr_table_lists")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[_builtins.str]:
        """
        The ID of the VPC instance.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vpcName")
    def vpc_name(self) -> Optional[_builtins.str]:
        """
        The instance name of the VPC.
        """
        return pulumi.get(self, "vpc_name")


@pulumi.output_type
class FirewallVpcFirewallCenLocalVpcEniList(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "eniId":
            suggest = "eni_id"
        elif key == "eniPrivateIpAddress":
            suggest = "eni_private_ip_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FirewallVpcFirewallCenLocalVpcEniList. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FirewallVpcFirewallCenLocalVpcEniList.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FirewallVpcFirewallCenLocalVpcEniList.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 eni_id: Optional[_builtins.str] = None,
                 eni_private_ip_address: Optional[_builtins.str] = None):
        """
        :param _builtins.str eni_id: The ID of the instance of the ENI in the VPC.
        :param _builtins.str eni_private_ip_address: The private IP address of the ENI in the VPC.
        """
        if eni_id is not None:
            pulumi.set(__self__, "eni_id", eni_id)
        if eni_private_ip_address is not None:
            pulumi.set(__self__, "eni_private_ip_address", eni_private_ip_address)

    @_builtins.property
    @pulumi.getter(name="eniId")
    def eni_id(self) -> Optional[_builtins.str]:
        """
        The ID of the instance of the ENI in the VPC.
        """
        return pulumi.get(self, "eni_id")

    @_builtins.property
    @pulumi.getter(name="eniPrivateIpAddress")
    def eni_private_ip_address(self) -> Optional[_builtins.str]:
        """
        The private IP address of the ENI in the VPC.
        """
        return pulumi.get(self, "eni_private_ip_address")


@pulumi.output_type
class FirewallVpcFirewallCenLocalVpcVpcCidrTableList(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "routeEntryLists":
            suggest = "route_entry_lists"
        elif key == "routeTableId":
            suggest = "route_table_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FirewallVpcFirewallCenLocalVpcVpcCidrTableList. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FirewallVpcFirewallCenLocalVpcVpcCidrTableList.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FirewallVpcFirewallCenLocalVpcVpcCidrTableList.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 route_entry_lists: Optional[Sequence['outputs.FirewallVpcFirewallCenLocalVpcVpcCidrTableListRouteEntryList']] = None,
                 route_table_id: Optional[_builtins.str] = None):
        """
        :param Sequence['FirewallVpcFirewallCenLocalVpcVpcCidrTableListRouteEntryListArgs'] route_entry_lists: The list of route entries in the VPC.
        :param _builtins.str route_table_id: The ID of the route table of the VPC.
        """
        if route_entry_lists is not None:
            pulumi.set(__self__, "route_entry_lists", route_entry_lists)
        if route_table_id is not None:
            pulumi.set(__self__, "route_table_id", route_table_id)

    @_builtins.property
    @pulumi.getter(name="routeEntryLists")
    def route_entry_lists(self) -> Optional[Sequence['outputs.FirewallVpcFirewallCenLocalVpcVpcCidrTableListRouteEntryList']]:
        """
        The list of route entries in the VPC.
        """
        return pulumi.get(self, "route_entry_lists")

    @_builtins.property
    @pulumi.getter(name="routeTableId")
    def route_table_id(self) -> Optional[_builtins.str]:
        """
        The ID of the route table of the VPC.
        """
        return pulumi.get(self, "route_table_id")


@pulumi.output_type
class FirewallVpcFirewallCenLocalVpcVpcCidrTableListRouteEntryList(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destinationCidr":
            suggest = "destination_cidr"
        elif key == "nextHopInstanceId":
            suggest = "next_hop_instance_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FirewallVpcFirewallCenLocalVpcVpcCidrTableListRouteEntryList. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FirewallVpcFirewallCenLocalVpcVpcCidrTableListRouteEntryList.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FirewallVpcFirewallCenLocalVpcVpcCidrTableListRouteEntryList.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 destination_cidr: Optional[_builtins.str] = None,
                 next_hop_instance_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str destination_cidr: The target network segment of the VPC.
        :param _builtins.str next_hop_instance_id: The ID of the next hop instance in the VPC.
        """
        if destination_cidr is not None:
            pulumi.set(__self__, "destination_cidr", destination_cidr)
        if next_hop_instance_id is not None:
            pulumi.set(__self__, "next_hop_instance_id", next_hop_instance_id)

    @_builtins.property
    @pulumi.getter(name="destinationCidr")
    def destination_cidr(self) -> Optional[_builtins.str]:
        """
        The target network segment of the VPC.
        """
        return pulumi.get(self, "destination_cidr")

    @_builtins.property
    @pulumi.getter(name="nextHopInstanceId")
    def next_hop_instance_id(self) -> Optional[_builtins.str]:
        """
        The ID of the next hop instance in the VPC.
        """
        return pulumi.get(self, "next_hop_instance_id")


@pulumi.output_type
class FirewallVpcFirewallLocalVpc(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "localVpcCidrTableLists":
            suggest = "local_vpc_cidr_table_lists"
        elif key == "regionNo":
            suggest = "region_no"
        elif key == "vpcId":
            suggest = "vpc_id"
        elif key == "eniId":
            suggest = "eni_id"
        elif key == "eniPrivateIpAddress":
            suggest = "eni_private_ip_address"
        elif key == "routerInterfaceId":
            suggest = "router_interface_id"
        elif key == "vpcName":
            suggest = "vpc_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FirewallVpcFirewallLocalVpc. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FirewallVpcFirewallLocalVpc.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FirewallVpcFirewallLocalVpc.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 local_vpc_cidr_table_lists: Sequence['outputs.FirewallVpcFirewallLocalVpcLocalVpcCidrTableList'],
                 region_no: _builtins.str,
                 vpc_id: _builtins.str,
                 eni_id: Optional[_builtins.str] = None,
                 eni_private_ip_address: Optional[_builtins.str] = None,
                 router_interface_id: Optional[_builtins.str] = None,
                 vpc_name: Optional[_builtins.str] = None):
        """
        :param Sequence['FirewallVpcFirewallLocalVpcLocalVpcCidrTableListArgs'] local_vpc_cidr_table_lists: The network segment list of the local VPC. See `local_vpc_cidr_table_list` below.
        :param _builtins.str region_no: The region ID of the local VPC.
        :param _builtins.str vpc_id: The ID of the local VPC instance.
        :param _builtins.str eni_id: The ID of the instance of the ENI in the peer VPC.
        :param _builtins.str eni_private_ip_address: The private IP address of the elastic network card in the peer VPC.
        :param _builtins.str router_interface_id: The ID of the router interface in the peer VPC.
        :param _builtins.str vpc_name: The instance name of the peer VPC.
        """
        pulumi.set(__self__, "local_vpc_cidr_table_lists", local_vpc_cidr_table_lists)
        pulumi.set(__self__, "region_no", region_no)
        pulumi.set(__self__, "vpc_id", vpc_id)
        if eni_id is not None:
            pulumi.set(__self__, "eni_id", eni_id)
        if eni_private_ip_address is not None:
            pulumi.set(__self__, "eni_private_ip_address", eni_private_ip_address)
        if router_interface_id is not None:
            pulumi.set(__self__, "router_interface_id", router_interface_id)
        if vpc_name is not None:
            pulumi.set(__self__, "vpc_name", vpc_name)

    @_builtins.property
    @pulumi.getter(name="localVpcCidrTableLists")
    def local_vpc_cidr_table_lists(self) -> Sequence['outputs.FirewallVpcFirewallLocalVpcLocalVpcCidrTableList']:
        """
        The network segment list of the local VPC. See `local_vpc_cidr_table_list` below.
        """
        return pulumi.get(self, "local_vpc_cidr_table_lists")

    @_builtins.property
    @pulumi.getter(name="regionNo")
    def region_no(self) -> _builtins.str:
        """
        The region ID of the local VPC.
        """
        return pulumi.get(self, "region_no")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> _builtins.str:
        """
        The ID of the local VPC instance.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="eniId")
    def eni_id(self) -> Optional[_builtins.str]:
        """
        The ID of the instance of the ENI in the peer VPC.
        """
        return pulumi.get(self, "eni_id")

    @_builtins.property
    @pulumi.getter(name="eniPrivateIpAddress")
    def eni_private_ip_address(self) -> Optional[_builtins.str]:
        """
        The private IP address of the elastic network card in the peer VPC.
        """
        return pulumi.get(self, "eni_private_ip_address")

    @_builtins.property
    @pulumi.getter(name="routerInterfaceId")
    def router_interface_id(self) -> Optional[_builtins.str]:
        """
        The ID of the router interface in the peer VPC.
        """
        return pulumi.get(self, "router_interface_id")

    @_builtins.property
    @pulumi.getter(name="vpcName")
    def vpc_name(self) -> Optional[_builtins.str]:
        """
        The instance name of the peer VPC.
        """
        return pulumi.get(self, "vpc_name")


@pulumi.output_type
class FirewallVpcFirewallLocalVpcLocalVpcCidrTableList(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "localRouteEntryLists":
            suggest = "local_route_entry_lists"
        elif key == "localRouteTableId":
            suggest = "local_route_table_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FirewallVpcFirewallLocalVpcLocalVpcCidrTableList. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FirewallVpcFirewallLocalVpcLocalVpcCidrTableList.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FirewallVpcFirewallLocalVpcLocalVpcCidrTableList.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 local_route_entry_lists: Sequence['outputs.FirewallVpcFirewallLocalVpcLocalVpcCidrTableListLocalRouteEntryList'],
                 local_route_table_id: _builtins.str):
        """
        :param Sequence['FirewallVpcFirewallLocalVpcLocalVpcCidrTableListLocalRouteEntryListArgs'] local_route_entry_lists: The list of route entries of the local VPC. See `local_route_entry_list` below.
        :param _builtins.str local_route_table_id: The ID of the route table of the local VPC.
        """
        pulumi.set(__self__, "local_route_entry_lists", local_route_entry_lists)
        pulumi.set(__self__, "local_route_table_id", local_route_table_id)

    @_builtins.property
    @pulumi.getter(name="localRouteEntryLists")
    def local_route_entry_lists(self) -> Sequence['outputs.FirewallVpcFirewallLocalVpcLocalVpcCidrTableListLocalRouteEntryList']:
        """
        The list of route entries of the local VPC. See `local_route_entry_list` below.
        """
        return pulumi.get(self, "local_route_entry_lists")

    @_builtins.property
    @pulumi.getter(name="localRouteTableId")
    def local_route_table_id(self) -> _builtins.str:
        """
        The ID of the route table of the local VPC.
        """
        return pulumi.get(self, "local_route_table_id")


@pulumi.output_type
class FirewallVpcFirewallLocalVpcLocalVpcCidrTableListLocalRouteEntryList(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "localDestinationCidr":
            suggest = "local_destination_cidr"
        elif key == "localNextHopInstanceId":
            suggest = "local_next_hop_instance_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FirewallVpcFirewallLocalVpcLocalVpcCidrTableListLocalRouteEntryList. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FirewallVpcFirewallLocalVpcLocalVpcCidrTableListLocalRouteEntryList.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FirewallVpcFirewallLocalVpcLocalVpcCidrTableListLocalRouteEntryList.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 local_destination_cidr: _builtins.str,
                 local_next_hop_instance_id: _builtins.str):
        """
        :param _builtins.str local_destination_cidr: The target network segment of the local VPC.
        :param _builtins.str local_next_hop_instance_id: The ID of the next-hop instance in the local VPC.
        """
        pulumi.set(__self__, "local_destination_cidr", local_destination_cidr)
        pulumi.set(__self__, "local_next_hop_instance_id", local_next_hop_instance_id)

    @_builtins.property
    @pulumi.getter(name="localDestinationCidr")
    def local_destination_cidr(self) -> _builtins.str:
        """
        The target network segment of the local VPC.
        """
        return pulumi.get(self, "local_destination_cidr")

    @_builtins.property
    @pulumi.getter(name="localNextHopInstanceId")
    def local_next_hop_instance_id(self) -> _builtins.str:
        """
        The ID of the next-hop instance in the local VPC.
        """
        return pulumi.get(self, "local_next_hop_instance_id")


@pulumi.output_type
class FirewallVpcFirewallPeerVpc(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "peerVpcCidrTableLists":
            suggest = "peer_vpc_cidr_table_lists"
        elif key == "regionNo":
            suggest = "region_no"
        elif key == "vpcId":
            suggest = "vpc_id"
        elif key == "eniId":
            suggest = "eni_id"
        elif key == "eniPrivateIpAddress":
            suggest = "eni_private_ip_address"
        elif key == "routerInterfaceId":
            suggest = "router_interface_id"
        elif key == "vpcName":
            suggest = "vpc_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FirewallVpcFirewallPeerVpc. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FirewallVpcFirewallPeerVpc.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FirewallVpcFirewallPeerVpc.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 peer_vpc_cidr_table_lists: Sequence['outputs.FirewallVpcFirewallPeerVpcPeerVpcCidrTableList'],
                 region_no: _builtins.str,
                 vpc_id: _builtins.str,
                 eni_id: Optional[_builtins.str] = None,
                 eni_private_ip_address: Optional[_builtins.str] = None,
                 router_interface_id: Optional[_builtins.str] = None,
                 vpc_name: Optional[_builtins.str] = None):
        """
        :param Sequence['FirewallVpcFirewallPeerVpcPeerVpcCidrTableListArgs'] peer_vpc_cidr_table_lists: The network segment list of the peer VPC. See `peer_vpc_cidr_table_list` below.
        :param _builtins.str region_no: The region ID of the peer VPC.
        :param _builtins.str vpc_id: The ID of the peer VPC instance.
        :param _builtins.str eni_id: The ID of the instance of the ENI in the peer VPC.
        :param _builtins.str eni_private_ip_address: The private IP address of the elastic network card in the peer VPC.
        :param _builtins.str router_interface_id: The ID of the router interface in the peer VPC.
        :param _builtins.str vpc_name: The instance name of the peer VPC.
        """
        pulumi.set(__self__, "peer_vpc_cidr_table_lists", peer_vpc_cidr_table_lists)
        pulumi.set(__self__, "region_no", region_no)
        pulumi.set(__self__, "vpc_id", vpc_id)
        if eni_id is not None:
            pulumi.set(__self__, "eni_id", eni_id)
        if eni_private_ip_address is not None:
            pulumi.set(__self__, "eni_private_ip_address", eni_private_ip_address)
        if router_interface_id is not None:
            pulumi.set(__self__, "router_interface_id", router_interface_id)
        if vpc_name is not None:
            pulumi.set(__self__, "vpc_name", vpc_name)

    @_builtins.property
    @pulumi.getter(name="peerVpcCidrTableLists")
    def peer_vpc_cidr_table_lists(self) -> Sequence['outputs.FirewallVpcFirewallPeerVpcPeerVpcCidrTableList']:
        """
        The network segment list of the peer VPC. See `peer_vpc_cidr_table_list` below.
        """
        return pulumi.get(self, "peer_vpc_cidr_table_lists")

    @_builtins.property
    @pulumi.getter(name="regionNo")
    def region_no(self) -> _builtins.str:
        """
        The region ID of the peer VPC.
        """
        return pulumi.get(self, "region_no")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> _builtins.str:
        """
        The ID of the peer VPC instance.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="eniId")
    def eni_id(self) -> Optional[_builtins.str]:
        """
        The ID of the instance of the ENI in the peer VPC.
        """
        return pulumi.get(self, "eni_id")

    @_builtins.property
    @pulumi.getter(name="eniPrivateIpAddress")
    def eni_private_ip_address(self) -> Optional[_builtins.str]:
        """
        The private IP address of the elastic network card in the peer VPC.
        """
        return pulumi.get(self, "eni_private_ip_address")

    @_builtins.property
    @pulumi.getter(name="routerInterfaceId")
    def router_interface_id(self) -> Optional[_builtins.str]:
        """
        The ID of the router interface in the peer VPC.
        """
        return pulumi.get(self, "router_interface_id")

    @_builtins.property
    @pulumi.getter(name="vpcName")
    def vpc_name(self) -> Optional[_builtins.str]:
        """
        The instance name of the peer VPC.
        """
        return pulumi.get(self, "vpc_name")


@pulumi.output_type
class FirewallVpcFirewallPeerVpcPeerVpcCidrTableList(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "peerRouteEntryLists":
            suggest = "peer_route_entry_lists"
        elif key == "peerRouteTableId":
            suggest = "peer_route_table_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FirewallVpcFirewallPeerVpcPeerVpcCidrTableList. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FirewallVpcFirewallPeerVpcPeerVpcCidrTableList.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FirewallVpcFirewallPeerVpcPeerVpcCidrTableList.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 peer_route_entry_lists: Sequence['outputs.FirewallVpcFirewallPeerVpcPeerVpcCidrTableListPeerRouteEntryList'],
                 peer_route_table_id: _builtins.str):
        """
        :param Sequence['FirewallVpcFirewallPeerVpcPeerVpcCidrTableListPeerRouteEntryListArgs'] peer_route_entry_lists: Peer VPC route entry list information. See `peer_route_entry_list` below.
        :param _builtins.str peer_route_table_id: The ID of the route table of the peer VPC.
        """
        pulumi.set(__self__, "peer_route_entry_lists", peer_route_entry_lists)
        pulumi.set(__self__, "peer_route_table_id", peer_route_table_id)

    @_builtins.property
    @pulumi.getter(name="peerRouteEntryLists")
    def peer_route_entry_lists(self) -> Sequence['outputs.FirewallVpcFirewallPeerVpcPeerVpcCidrTableListPeerRouteEntryList']:
        """
        Peer VPC route entry list information. See `peer_route_entry_list` below.
        """
        return pulumi.get(self, "peer_route_entry_lists")

    @_builtins.property
    @pulumi.getter(name="peerRouteTableId")
    def peer_route_table_id(self) -> _builtins.str:
        """
        The ID of the route table of the peer VPC.
        """
        return pulumi.get(self, "peer_route_table_id")


@pulumi.output_type
class FirewallVpcFirewallPeerVpcPeerVpcCidrTableListPeerRouteEntryList(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "peerDestinationCidr":
            suggest = "peer_destination_cidr"
        elif key == "peerNextHopInstanceId":
            suggest = "peer_next_hop_instance_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FirewallVpcFirewallPeerVpcPeerVpcCidrTableListPeerRouteEntryList. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FirewallVpcFirewallPeerVpcPeerVpcCidrTableListPeerRouteEntryList.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FirewallVpcFirewallPeerVpcPeerVpcCidrTableListPeerRouteEntryList.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 peer_destination_cidr: _builtins.str,
                 peer_next_hop_instance_id: _builtins.str):
        """
        :param _builtins.str peer_destination_cidr: The target network segment of the peer VPC.
        :param _builtins.str peer_next_hop_instance_id: The ID of the next-hop instance in the peer VPC.
        """
        pulumi.set(__self__, "peer_destination_cidr", peer_destination_cidr)
        pulumi.set(__self__, "peer_next_hop_instance_id", peer_next_hop_instance_id)

    @_builtins.property
    @pulumi.getter(name="peerDestinationCidr")
    def peer_destination_cidr(self) -> _builtins.str:
        """
        The target network segment of the peer VPC.
        """
        return pulumi.get(self, "peer_destination_cidr")

    @_builtins.property
    @pulumi.getter(name="peerNextHopInstanceId")
    def peer_next_hop_instance_id(self) -> _builtins.str:
        """
        The ID of the next-hop instance in the peer VPC.
        """
        return pulumi.get(self, "peer_next_hop_instance_id")


@pulumi.output_type
class NatFirewallNatRouteEntryList(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destinationCidr":
            suggest = "destination_cidr"
        elif key == "nexthopId":
            suggest = "nexthop_id"
        elif key == "nexthopType":
            suggest = "nexthop_type"
        elif key == "routeTableId":
            suggest = "route_table_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NatFirewallNatRouteEntryList. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NatFirewallNatRouteEntryList.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NatFirewallNatRouteEntryList.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 destination_cidr: _builtins.str,
                 nexthop_id: _builtins.str,
                 nexthop_type: _builtins.str,
                 route_table_id: _builtins.str):
        """
        :param _builtins.str destination_cidr: The destination network segment of the default route.
        :param _builtins.str nexthop_id: The next hop address of the original NAT gateway.
        :param _builtins.str nexthop_type: The network type of the next hop. Value: NatGateway : NAT Gateway.
        :param _builtins.str route_table_id: The route table where the default route of the NAT gateway is located.
        """
        pulumi.set(__self__, "destination_cidr", destination_cidr)
        pulumi.set(__self__, "nexthop_id", nexthop_id)
        pulumi.set(__self__, "nexthop_type", nexthop_type)
        pulumi.set(__self__, "route_table_id", route_table_id)

    @_builtins.property
    @pulumi.getter(name="destinationCidr")
    def destination_cidr(self) -> _builtins.str:
        """
        The destination network segment of the default route.
        """
        return pulumi.get(self, "destination_cidr")

    @_builtins.property
    @pulumi.getter(name="nexthopId")
    def nexthop_id(self) -> _builtins.str:
        """
        The next hop address of the original NAT gateway.
        """
        return pulumi.get(self, "nexthop_id")

    @_builtins.property
    @pulumi.getter(name="nexthopType")
    def nexthop_type(self) -> _builtins.str:
        """
        The network type of the next hop. Value: NatGateway : NAT Gateway.
        """
        return pulumi.get(self, "nexthop_type")

    @_builtins.property
    @pulumi.getter(name="routeTableId")
    def route_table_id(self) -> _builtins.str:
        """
        The route table where the default route of the NAT gateway is located.
        """
        return pulumi.get(self, "route_table_id")


@pulumi.output_type
class GetAddressBooksBookResult(dict):
    def __init__(__self__, *,
                 address_lists: Sequence[_builtins.str],
                 auto_add_tag_ecs: _builtins.int,
                 description: _builtins.str,
                 ecs_tags: Sequence['outputs.GetAddressBooksBookEcsTagResult'],
                 group_name: _builtins.str,
                 group_type: _builtins.str,
                 group_uuid: _builtins.str,
                 id: _builtins.str,
                 tag_relation: _builtins.str):
        """
        :param Sequence[_builtins.str] address_lists: The addresses in the Address Book.
        :param _builtins.int auto_add_tag_ecs: Whether you want to automatically add new matching tags of the ECS IP address to the Address Book.
        :param _builtins.str description: The description of the Address Book.
        :param Sequence['GetAddressBooksBookEcsTagArgs'] ecs_tags: The logical relation among the ECS tags that to be matchedh.
        :param _builtins.str group_name: The name of the Address Book.
        :param _builtins.str group_type: The type of the Address Book. Valid values: `ip`, `ipv6`, `domain`, `port`, `tag`.
               **NOTE:** From version 1.213.1, `group_type` can be set to `ipv6`, `domain`, `port`.
        :param _builtins.str group_uuid: The ID of the Address Book.
        :param _builtins.str id: The ID of the Address Book.
        :param _builtins.str tag_relation: One or more tags for the relationship between.
        """
        pulumi.set(__self__, "address_lists", address_lists)
        pulumi.set(__self__, "auto_add_tag_ecs", auto_add_tag_ecs)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "ecs_tags", ecs_tags)
        pulumi.set(__self__, "group_name", group_name)
        pulumi.set(__self__, "group_type", group_type)
        pulumi.set(__self__, "group_uuid", group_uuid)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "tag_relation", tag_relation)

    @_builtins.property
    @pulumi.getter(name="addressLists")
    def address_lists(self) -> Sequence[_builtins.str]:
        """
        The addresses in the Address Book.
        """
        return pulumi.get(self, "address_lists")

    @_builtins.property
    @pulumi.getter(name="autoAddTagEcs")
    def auto_add_tag_ecs(self) -> _builtins.int:
        """
        Whether you want to automatically add new matching tags of the ECS IP address to the Address Book.
        """
        return pulumi.get(self, "auto_add_tag_ecs")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the Address Book.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="ecsTags")
    def ecs_tags(self) -> Sequence['outputs.GetAddressBooksBookEcsTagResult']:
        """
        The logical relation among the ECS tags that to be matchedh.
        """
        return pulumi.get(self, "ecs_tags")

    @_builtins.property
    @pulumi.getter(name="groupName")
    def group_name(self) -> _builtins.str:
        """
        The name of the Address Book.
        """
        return pulumi.get(self, "group_name")

    @_builtins.property
    @pulumi.getter(name="groupType")
    def group_type(self) -> _builtins.str:
        """
        The type of the Address Book. Valid values: `ip`, `ipv6`, `domain`, `port`, `tag`.
        **NOTE:** From version 1.213.1, `group_type` can be set to `ipv6`, `domain`, `port`.
        """
        return pulumi.get(self, "group_type")

    @_builtins.property
    @pulumi.getter(name="groupUuid")
    def group_uuid(self) -> _builtins.str:
        """
        The ID of the Address Book.
        """
        return pulumi.get(self, "group_uuid")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Address Book.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="tagRelation")
    def tag_relation(self) -> _builtins.str:
        """
        One or more tags for the relationship between.
        """
        return pulumi.get(self, "tag_relation")


@pulumi.output_type
class GetAddressBooksBookEcsTagResult(dict):
    def __init__(__self__, *,
                 tag_key: _builtins.str,
                 tag_value: _builtins.str):
        """
        :param _builtins.str tag_key: The key of ECS tag that to be matched.
        :param _builtins.str tag_value: The value of ECS tag that to be matched.
        """
        pulumi.set(__self__, "tag_key", tag_key)
        pulumi.set(__self__, "tag_value", tag_value)

    @_builtins.property
    @pulumi.getter(name="tagKey")
    def tag_key(self) -> _builtins.str:
        """
        The key of ECS tag that to be matched.
        """
        return pulumi.get(self, "tag_key")

    @_builtins.property
    @pulumi.getter(name="tagValue")
    def tag_value(self) -> _builtins.str:
        """
        The value of ECS tag that to be matched.
        """
        return pulumi.get(self, "tag_value")


@pulumi.output_type
class GetControlPoliciesPolicyResult(dict):
    def __init__(__self__, *,
                 acl_action: _builtins.str,
                 acl_uuid: _builtins.str,
                 application_id: _builtins.str,
                 application_name: _builtins.str,
                 description: _builtins.str,
                 dest_port: _builtins.str,
                 dest_port_group: _builtins.str,
                 dest_port_group_ports: Sequence[_builtins.str],
                 dest_port_type: _builtins.str,
                 destination: _builtins.str,
                 destination_group_cidrs: Sequence[_builtins.str],
                 destination_group_type: _builtins.str,
                 destination_type: _builtins.str,
                 direction: _builtins.str,
                 dns_result: _builtins.str,
                 dns_result_time: _builtins.str,
                 hit_times: _builtins.str,
                 id: _builtins.str,
                 order: _builtins.int,
                 proto: _builtins.str,
                 release: _builtins.bool,
                 source: _builtins.str,
                 source_group_cidrs: Sequence[_builtins.str],
                 source_group_type: _builtins.str,
                 source_type: _builtins.str):
        """
        :param _builtins.str acl_action: The action that Cloud Firewall performs on the traffic. Valid values: `accept`, `drop`, `log`.
        :param _builtins.str acl_uuid: The unique ID of the access control policy.
        :param _builtins.str application_id: The application ID in the access control policy.
        :param _builtins.str application_name: The type of the application that the access control policy supports.
        :param _builtins.str description: The description of the access control policy.
        :param _builtins.str dest_port: The destination port in the access control policy.
        :param _builtins.str dest_port_group: The name of the destination port address book in the access control policy.
        :param Sequence[_builtins.str] dest_port_group_ports: The ports in the destination port address book.
        :param _builtins.str dest_port_type: The type of the destination port in the access control policy.
        :param _builtins.str destination: The destination address defined in the access control policy.
        :param Sequence[_builtins.str] destination_group_cidrs: The CIDR blocks in the destination address book.
        :param _builtins.str destination_group_type: The type of the destination address book in the access control policy.
        :param _builtins.str destination_type: The type of the destination address in the access control policy.
        :param _builtins.str direction: The direction of the traffic to which the access control policy applies. Valid values: `in`, `out`.
        :param _builtins.str dns_result: The DNS resolution result.
        :param _builtins.str dns_result_time: The timestamp of the DNS resolution result.
        :param _builtins.str hit_times: The number of hits for the access control policy.
        :param _builtins.str id: The ID of the Control Policy. It formats as `<acl_uuid>:<direction>`.
        :param _builtins.int order: The priority of the access control policy.
        :param _builtins.str proto: The type of the protocol in the access control policy. Valid values: If `direction` is  `in`, the valid value is `ANY`. If `direction` is `out`, the valid values are `ANY`, `TCP`, `UDP`, `ICMP`.
        :param _builtins.bool release: Indicates whether the access control policy is enabled.
        :param _builtins.str source: The source address in the access control policy.
        :param Sequence[_builtins.str] source_group_cidrs: The CIDR blocks in the source address book.
        :param _builtins.str source_group_type: The type of the source address book in the access control policy.
        :param _builtins.str source_type: The type of the source address in the access control policy.
        """
        pulumi.set(__self__, "acl_action", acl_action)
        pulumi.set(__self__, "acl_uuid", acl_uuid)
        pulumi.set(__self__, "application_id", application_id)
        pulumi.set(__self__, "application_name", application_name)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "dest_port", dest_port)
        pulumi.set(__self__, "dest_port_group", dest_port_group)
        pulumi.set(__self__, "dest_port_group_ports", dest_port_group_ports)
        pulumi.set(__self__, "dest_port_type", dest_port_type)
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "destination_group_cidrs", destination_group_cidrs)
        pulumi.set(__self__, "destination_group_type", destination_group_type)
        pulumi.set(__self__, "destination_type", destination_type)
        pulumi.set(__self__, "direction", direction)
        pulumi.set(__self__, "dns_result", dns_result)
        pulumi.set(__self__, "dns_result_time", dns_result_time)
        pulumi.set(__self__, "hit_times", hit_times)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "order", order)
        pulumi.set(__self__, "proto", proto)
        pulumi.set(__self__, "release", release)
        pulumi.set(__self__, "source", source)
        pulumi.set(__self__, "source_group_cidrs", source_group_cidrs)
        pulumi.set(__self__, "source_group_type", source_group_type)
        pulumi.set(__self__, "source_type", source_type)

    @_builtins.property
    @pulumi.getter(name="aclAction")
    def acl_action(self) -> _builtins.str:
        """
        The action that Cloud Firewall performs on the traffic. Valid values: `accept`, `drop`, `log`.
        """
        return pulumi.get(self, "acl_action")

    @_builtins.property
    @pulumi.getter(name="aclUuid")
    def acl_uuid(self) -> _builtins.str:
        """
        The unique ID of the access control policy.
        """
        return pulumi.get(self, "acl_uuid")

    @_builtins.property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> _builtins.str:
        """
        The application ID in the access control policy.
        """
        return pulumi.get(self, "application_id")

    @_builtins.property
    @pulumi.getter(name="applicationName")
    def application_name(self) -> _builtins.str:
        """
        The type of the application that the access control policy supports.
        """
        return pulumi.get(self, "application_name")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the access control policy.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="destPort")
    def dest_port(self) -> _builtins.str:
        """
        The destination port in the access control policy.
        """
        return pulumi.get(self, "dest_port")

    @_builtins.property
    @pulumi.getter(name="destPortGroup")
    def dest_port_group(self) -> _builtins.str:
        """
        The name of the destination port address book in the access control policy.
        """
        return pulumi.get(self, "dest_port_group")

    @_builtins.property
    @pulumi.getter(name="destPortGroupPorts")
    def dest_port_group_ports(self) -> Sequence[_builtins.str]:
        """
        The ports in the destination port address book.
        """
        return pulumi.get(self, "dest_port_group_ports")

    @_builtins.property
    @pulumi.getter(name="destPortType")
    def dest_port_type(self) -> _builtins.str:
        """
        The type of the destination port in the access control policy.
        """
        return pulumi.get(self, "dest_port_type")

    @_builtins.property
    @pulumi.getter
    def destination(self) -> _builtins.str:
        """
        The destination address defined in the access control policy.
        """
        return pulumi.get(self, "destination")

    @_builtins.property
    @pulumi.getter(name="destinationGroupCidrs")
    def destination_group_cidrs(self) -> Sequence[_builtins.str]:
        """
        The CIDR blocks in the destination address book.
        """
        return pulumi.get(self, "destination_group_cidrs")

    @_builtins.property
    @pulumi.getter(name="destinationGroupType")
    def destination_group_type(self) -> _builtins.str:
        """
        The type of the destination address book in the access control policy.
        """
        return pulumi.get(self, "destination_group_type")

    @_builtins.property
    @pulumi.getter(name="destinationType")
    def destination_type(self) -> _builtins.str:
        """
        The type of the destination address in the access control policy.
        """
        return pulumi.get(self, "destination_type")

    @_builtins.property
    @pulumi.getter
    def direction(self) -> _builtins.str:
        """
        The direction of the traffic to which the access control policy applies. Valid values: `in`, `out`.
        """
        return pulumi.get(self, "direction")

    @_builtins.property
    @pulumi.getter(name="dnsResult")
    def dns_result(self) -> _builtins.str:
        """
        The DNS resolution result.
        """
        return pulumi.get(self, "dns_result")

    @_builtins.property
    @pulumi.getter(name="dnsResultTime")
    def dns_result_time(self) -> _builtins.str:
        """
        The timestamp of the DNS resolution result.
        """
        return pulumi.get(self, "dns_result_time")

    @_builtins.property
    @pulumi.getter(name="hitTimes")
    def hit_times(self) -> _builtins.str:
        """
        The number of hits for the access control policy.
        """
        return pulumi.get(self, "hit_times")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Control Policy. It formats as `<acl_uuid>:<direction>`.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def order(self) -> _builtins.int:
        """
        The priority of the access control policy.
        """
        return pulumi.get(self, "order")

    @_builtins.property
    @pulumi.getter
    def proto(self) -> _builtins.str:
        """
        The type of the protocol in the access control policy. Valid values: If `direction` is  `in`, the valid value is `ANY`. If `direction` is `out`, the valid values are `ANY`, `TCP`, `UDP`, `ICMP`.
        """
        return pulumi.get(self, "proto")

    @_builtins.property
    @pulumi.getter
    def release(self) -> _builtins.bool:
        """
        Indicates whether the access control policy is enabled.
        """
        return pulumi.get(self, "release")

    @_builtins.property
    @pulumi.getter
    def source(self) -> _builtins.str:
        """
        The source address in the access control policy.
        """
        return pulumi.get(self, "source")

    @_builtins.property
    @pulumi.getter(name="sourceGroupCidrs")
    def source_group_cidrs(self) -> Sequence[_builtins.str]:
        """
        The CIDR blocks in the source address book.
        """
        return pulumi.get(self, "source_group_cidrs")

    @_builtins.property
    @pulumi.getter(name="sourceGroupType")
    def source_group_type(self) -> _builtins.str:
        """
        The type of the source address book in the access control policy.
        """
        return pulumi.get(self, "source_group_type")

    @_builtins.property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> _builtins.str:
        """
        The type of the source address in the access control policy.
        """
        return pulumi.get(self, "source_type")


@pulumi.output_type
class GetInstanceMembersMemberResult(dict):
    def __init__(__self__, *,
                 create_time: _builtins.int,
                 id: _builtins.str,
                 member_desc: _builtins.str,
                 member_display_name: _builtins.str,
                 member_uid: _builtins.str,
                 modify_time: _builtins.int,
                 status: _builtins.str):
        """
        :param _builtins.int create_time: When the cloud firewall member account was added.> use second-level timestamp format.
        :param _builtins.str id: The instance id.
        :param _builtins.str member_desc: Remarks of cloud firewall member accounts.
        :param _builtins.str member_display_name: The name of the cloud firewall member account.
        :param _builtins.str member_uid: The UID of the cloud firewall member account.
        :param _builtins.int modify_time: The last modification time of the cloud firewall member account.> use second-level timestamp format.
        :param _builtins.str status: The resource attribute field that represents the resource status.
        """
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "member_desc", member_desc)
        pulumi.set(__self__, "member_display_name", member_display_name)
        pulumi.set(__self__, "member_uid", member_uid)
        pulumi.set(__self__, "modify_time", modify_time)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.int:
        """
        When the cloud firewall member account was added.> use second-level timestamp format.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The instance id.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="memberDesc")
    def member_desc(self) -> _builtins.str:
        """
        Remarks of cloud firewall member accounts.
        """
        return pulumi.get(self, "member_desc")

    @_builtins.property
    @pulumi.getter(name="memberDisplayName")
    def member_display_name(self) -> _builtins.str:
        """
        The name of the cloud firewall member account.
        """
        return pulumi.get(self, "member_display_name")

    @_builtins.property
    @pulumi.getter(name="memberUid")
    def member_uid(self) -> _builtins.str:
        """
        The UID of the cloud firewall member account.
        """
        return pulumi.get(self, "member_uid")

    @_builtins.property
    @pulumi.getter(name="modifyTime")
    def modify_time(self) -> _builtins.int:
        """
        The last modification time of the cloud firewall member account.> use second-level timestamp format.
        """
        return pulumi.get(self, "modify_time")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The resource attribute field that represents the resource status.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetInstancesInstanceResult(dict):
    def __init__(__self__, *,
                 create_time: _builtins.str,
                 end_time: _builtins.str,
                 id: _builtins.str,
                 instance_id: _builtins.str,
                 payment_type: _builtins.str,
                 renewal_duration_unit: _builtins.str,
                 renewal_status: _builtins.str,
                 status: _builtins.str):
        """
        :param _builtins.str create_time: The Creation time of the resource.
        :param _builtins.str end_time: The end time of the resource..
        :param _builtins.str id: The ID of the Instance.
        :param _builtins.str instance_id: The first ID of the resource.
        :param _builtins.str payment_type: The payment type of the resource. Valid values: `Subscription`.
        :param _builtins.str renewal_duration_unit: Automatic renewal period unit. Valid values: `Month`,`Year`.
        :param _builtins.str renewal_status: Automatic renewal status. Valid values: `AutoRenewal`,`ManualRenewal`. Default Value: `ManualRenewal`.
        :param _builtins.str status: The Status of Instance.
        """
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "payment_type", payment_type)
        pulumi.set(__self__, "renewal_duration_unit", renewal_duration_unit)
        pulumi.set(__self__, "renewal_status", renewal_status)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The Creation time of the resource.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> _builtins.str:
        """
        The end time of the resource..
        """
        return pulumi.get(self, "end_time")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Instance.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        """
        The first ID of the resource.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> _builtins.str:
        """
        The payment type of the resource. Valid values: `Subscription`.
        """
        return pulumi.get(self, "payment_type")

    @_builtins.property
    @pulumi.getter(name="renewalDurationUnit")
    def renewal_duration_unit(self) -> _builtins.str:
        """
        Automatic renewal period unit. Valid values: `Month`,`Year`.
        """
        return pulumi.get(self, "renewal_duration_unit")

    @_builtins.property
    @pulumi.getter(name="renewalStatus")
    def renewal_status(self) -> _builtins.str:
        """
        Automatic renewal status. Valid values: `AutoRenewal`,`ManualRenewal`. Default Value: `ManualRenewal`.
        """
        return pulumi.get(self, "renewal_status")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The Status of Instance.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetNatFirewallsFirewallResult(dict):
    def __init__(__self__, *,
                 ali_uid: _builtins.int,
                 id: _builtins.str,
                 member_uid: _builtins.int,
                 nat_gateway_id: _builtins.str,
                 nat_gateway_name: _builtins.str,
                 nat_route_entry_lists: Sequence['outputs.GetNatFirewallsFirewallNatRouteEntryListResult'],
                 proxy_id: _builtins.str,
                 proxy_name: _builtins.str,
                 strict_mode: _builtins.int,
                 vpc_id: _builtins.str):
        """
        :param _builtins.int ali_uid: Alibaba Cloud account ID
        :param _builtins.str id: The ID of the resource supplied above.
        :param _builtins.int member_uid: Member Account ID
        :param _builtins.str nat_gateway_id: NAT gateway ID
        :param _builtins.str nat_gateway_name: NAT Gateway name
        :param Sequence['GetNatFirewallsFirewallNatRouteEntryListArgs'] nat_route_entry_lists: The list of routes to be switched by the NAT gateway.
        :param _builtins.str proxy_id: NAT firewall ID
        :param _builtins.str proxy_name: NAT firewall name
        :param _builtins.int strict_mode: Whether strict mode is enabled1-Enable strict mode0-Disable strict mode
        :param _builtins.str vpc_id: The ID of the VPC instance.
        """
        pulumi.set(__self__, "ali_uid", ali_uid)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "member_uid", member_uid)
        pulumi.set(__self__, "nat_gateway_id", nat_gateway_id)
        pulumi.set(__self__, "nat_gateway_name", nat_gateway_name)
        pulumi.set(__self__, "nat_route_entry_lists", nat_route_entry_lists)
        pulumi.set(__self__, "proxy_id", proxy_id)
        pulumi.set(__self__, "proxy_name", proxy_name)
        pulumi.set(__self__, "strict_mode", strict_mode)
        pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter(name="aliUid")
    def ali_uid(self) -> _builtins.int:
        """
        Alibaba Cloud account ID
        """
        return pulumi.get(self, "ali_uid")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the resource supplied above.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="memberUid")
    def member_uid(self) -> _builtins.int:
        """
        Member Account ID
        """
        return pulumi.get(self, "member_uid")

    @_builtins.property
    @pulumi.getter(name="natGatewayId")
    def nat_gateway_id(self) -> _builtins.str:
        """
        NAT gateway ID
        """
        return pulumi.get(self, "nat_gateway_id")

    @_builtins.property
    @pulumi.getter(name="natGatewayName")
    def nat_gateway_name(self) -> _builtins.str:
        """
        NAT Gateway name
        """
        return pulumi.get(self, "nat_gateway_name")

    @_builtins.property
    @pulumi.getter(name="natRouteEntryLists")
    def nat_route_entry_lists(self) -> Sequence['outputs.GetNatFirewallsFirewallNatRouteEntryListResult']:
        """
        The list of routes to be switched by the NAT gateway.
        """
        return pulumi.get(self, "nat_route_entry_lists")

    @_builtins.property
    @pulumi.getter(name="proxyId")
    def proxy_id(self) -> _builtins.str:
        """
        NAT firewall ID
        """
        return pulumi.get(self, "proxy_id")

    @_builtins.property
    @pulumi.getter(name="proxyName")
    def proxy_name(self) -> _builtins.str:
        """
        NAT firewall name
        """
        return pulumi.get(self, "proxy_name")

    @_builtins.property
    @pulumi.getter(name="strictMode")
    def strict_mode(self) -> _builtins.int:
        """
        Whether strict mode is enabled1-Enable strict mode0-Disable strict mode
        """
        return pulumi.get(self, "strict_mode")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> _builtins.str:
        """
        The ID of the VPC instance.
        """
        return pulumi.get(self, "vpc_id")


@pulumi.output_type
class GetNatFirewallsFirewallNatRouteEntryListResult(dict):
    def __init__(__self__, *,
                 destination_cidr: _builtins.str,
                 nexthop_id: _builtins.str,
                 nexthop_type: _builtins.str,
                 route_table_id: _builtins.str):
        """
        :param _builtins.str destination_cidr: The destination network segment of the default route.
        :param _builtins.str nexthop_id: The next hop address of the original NAT gateway.
        :param _builtins.str nexthop_type: The network type of the next hop. Value: NatGateway : NAT Gateway.
        :param _builtins.str route_table_id: The route table where the default route of the NAT gateway is located.
        """
        pulumi.set(__self__, "destination_cidr", destination_cidr)
        pulumi.set(__self__, "nexthop_id", nexthop_id)
        pulumi.set(__self__, "nexthop_type", nexthop_type)
        pulumi.set(__self__, "route_table_id", route_table_id)

    @_builtins.property
    @pulumi.getter(name="destinationCidr")
    def destination_cidr(self) -> _builtins.str:
        """
        The destination network segment of the default route.
        """
        return pulumi.get(self, "destination_cidr")

    @_builtins.property
    @pulumi.getter(name="nexthopId")
    def nexthop_id(self) -> _builtins.str:
        """
        The next hop address of the original NAT gateway.
        """
        return pulumi.get(self, "nexthop_id")

    @_builtins.property
    @pulumi.getter(name="nexthopType")
    def nexthop_type(self) -> _builtins.str:
        """
        The network type of the next hop. Value: NatGateway : NAT Gateway.
        """
        return pulumi.get(self, "nexthop_type")

    @_builtins.property
    @pulumi.getter(name="routeTableId")
    def route_table_id(self) -> _builtins.str:
        """
        The route table where the default route of the NAT gateway is located.
        """
        return pulumi.get(self, "route_table_id")


@pulumi.output_type
class GetVpcCenTrFirewallsFirewallResult(dict):
    def __init__(__self__, *,
                 cen_id: _builtins.str,
                 cen_name: _builtins.str,
                 firewall_id: _builtins.str,
                 firewall_name: _builtins.str,
                 firewall_switch_status: _builtins.str,
                 id: _builtins.str,
                 ips_config: 'outputs.GetVpcCenTrFirewallsFirewallIpsConfigResult',
                 precheck_status: _builtins.str,
                 region_no: _builtins.str,
                 region_status: _builtins.str,
                 result_code: _builtins.str,
                 route_mode: _builtins.str,
                 transit_router_id: _builtins.str):
        """
        :param _builtins.str cen_id: The ID of the CEN instance.
        :param _builtins.str cen_name: The name of the CEN instance.
        :param _builtins.str firewall_id: Firewall ID
        :param _builtins.str firewall_name: The name of Cloud Firewall.
        :param _builtins.str firewall_switch_status: The status of the VPC boundary firewall. Value:-**opened**: opened-**closed**: closed-**notconfigured**: indicates that the VPC boundary firewall has not been configured yet.-**configured**: indicates that the VPC boundary firewall has been configured.-**creating**: indicates that a VPC boundary firewall is being created.-**opening**: indicates that the VPC border firewall is being enabled.-**deleting**: indicates that the VPC boundary firewall is being deleted.> If this parameter is not set, the VPC boundary firewall in all states is queried.
        :param _builtins.str id: The ID of the resource supplied above.
        :param 'GetVpcCenTrFirewallsFirewallIpsConfigArgs' ips_config: IPS configuration information.
        :param _builtins.str precheck_status: Whether the wall can be opened automatically. Value:-**passed**: can automatically open the wall-**failed**: The wall cannot be opened automatically-**unknown**: unknown status
        :param _builtins.str region_no: The region ID of the transit router instance.
        :param _builtins.str region_status: Geographically open. Value:-**enable**: enabled, indicating that the VPC border firewall can be configured for the region.-**disable**: Not enabled, indicating that the VPC boundary firewall is not allowed for the region.
        :param _builtins.str result_code: The operation result code of creating the VPC boundary firewall. Value:-**RegionDisable**: indicates that the region where the network instance is located is not supported by the VPC border firewall. You cannot create a VPC border firewall.-**Empty string**, indicating that the network instance can create a VPC firewall.
        :param _builtins.str route_mode: The routing pattern. Value: managed: indicates automatic mode
        :param _builtins.str transit_router_id: The ID of the transit router instance.
        """
        pulumi.set(__self__, "cen_id", cen_id)
        pulumi.set(__self__, "cen_name", cen_name)
        pulumi.set(__self__, "firewall_id", firewall_id)
        pulumi.set(__self__, "firewall_name", firewall_name)
        pulumi.set(__self__, "firewall_switch_status", firewall_switch_status)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ips_config", ips_config)
        pulumi.set(__self__, "precheck_status", precheck_status)
        pulumi.set(__self__, "region_no", region_no)
        pulumi.set(__self__, "region_status", region_status)
        pulumi.set(__self__, "result_code", result_code)
        pulumi.set(__self__, "route_mode", route_mode)
        pulumi.set(__self__, "transit_router_id", transit_router_id)

    @_builtins.property
    @pulumi.getter(name="cenId")
    def cen_id(self) -> _builtins.str:
        """
        The ID of the CEN instance.
        """
        return pulumi.get(self, "cen_id")

    @_builtins.property
    @pulumi.getter(name="cenName")
    def cen_name(self) -> _builtins.str:
        """
        The name of the CEN instance.
        """
        return pulumi.get(self, "cen_name")

    @_builtins.property
    @pulumi.getter(name="firewallId")
    def firewall_id(self) -> _builtins.str:
        """
        Firewall ID
        """
        return pulumi.get(self, "firewall_id")

    @_builtins.property
    @pulumi.getter(name="firewallName")
    def firewall_name(self) -> _builtins.str:
        """
        The name of Cloud Firewall.
        """
        return pulumi.get(self, "firewall_name")

    @_builtins.property
    @pulumi.getter(name="firewallSwitchStatus")
    def firewall_switch_status(self) -> _builtins.str:
        """
        The status of the VPC boundary firewall. Value:-**opened**: opened-**closed**: closed-**notconfigured**: indicates that the VPC boundary firewall has not been configured yet.-**configured**: indicates that the VPC boundary firewall has been configured.-**creating**: indicates that a VPC boundary firewall is being created.-**opening**: indicates that the VPC border firewall is being enabled.-**deleting**: indicates that the VPC boundary firewall is being deleted.> If this parameter is not set, the VPC boundary firewall in all states is queried.
        """
        return pulumi.get(self, "firewall_switch_status")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the resource supplied above.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ipsConfig")
    def ips_config(self) -> 'outputs.GetVpcCenTrFirewallsFirewallIpsConfigResult':
        """
        IPS configuration information.
        """
        return pulumi.get(self, "ips_config")

    @_builtins.property
    @pulumi.getter(name="precheckStatus")
    def precheck_status(self) -> _builtins.str:
        """
        Whether the wall can be opened automatically. Value:-**passed**: can automatically open the wall-**failed**: The wall cannot be opened automatically-**unknown**: unknown status
        """
        return pulumi.get(self, "precheck_status")

    @_builtins.property
    @pulumi.getter(name="regionNo")
    def region_no(self) -> _builtins.str:
        """
        The region ID of the transit router instance.
        """
        return pulumi.get(self, "region_no")

    @_builtins.property
    @pulumi.getter(name="regionStatus")
    def region_status(self) -> _builtins.str:
        """
        Geographically open. Value:-**enable**: enabled, indicating that the VPC border firewall can be configured for the region.-**disable**: Not enabled, indicating that the VPC boundary firewall is not allowed for the region.
        """
        return pulumi.get(self, "region_status")

    @_builtins.property
    @pulumi.getter(name="resultCode")
    def result_code(self) -> _builtins.str:
        """
        The operation result code of creating the VPC boundary firewall. Value:-**RegionDisable**: indicates that the region where the network instance is located is not supported by the VPC border firewall. You cannot create a VPC border firewall.-**Empty string**, indicating that the network instance can create a VPC firewall.
        """
        return pulumi.get(self, "result_code")

    @_builtins.property
    @pulumi.getter(name="routeMode")
    def route_mode(self) -> _builtins.str:
        """
        The routing pattern. Value: managed: indicates automatic mode
        """
        return pulumi.get(self, "route_mode")

    @_builtins.property
    @pulumi.getter(name="transitRouterId")
    def transit_router_id(self) -> _builtins.str:
        """
        The ID of the transit router instance.
        """
        return pulumi.get(self, "transit_router_id")


@pulumi.output_type
class GetVpcCenTrFirewallsFirewallIpsConfigResult(dict):
    def __init__(__self__, *,
                 basic_rules: _builtins.int,
                 enable_all_patch: _builtins.int,
                 run_mode: _builtins.int):
        """
        :param _builtins.int basic_rules: Basic rule switch. Value:-**1**: On-**0**: Closed state.
        :param _builtins.int enable_all_patch: Virtual patch switch. Value:-**1**: On-**0**: Closed state.
        :param _builtins.int run_mode: IPS defense mode. Value:-**1**: Intercept mode-**0**: Observation mode.
        """
        pulumi.set(__self__, "basic_rules", basic_rules)
        pulumi.set(__self__, "enable_all_patch", enable_all_patch)
        pulumi.set(__self__, "run_mode", run_mode)

    @_builtins.property
    @pulumi.getter(name="basicRules")
    def basic_rules(self) -> _builtins.int:
        """
        Basic rule switch. Value:-**1**: On-**0**: Closed state.
        """
        return pulumi.get(self, "basic_rules")

    @_builtins.property
    @pulumi.getter(name="enableAllPatch")
    def enable_all_patch(self) -> _builtins.int:
        """
        Virtual patch switch. Value:-**1**: On-**0**: Closed state.
        """
        return pulumi.get(self, "enable_all_patch")

    @_builtins.property
    @pulumi.getter(name="runMode")
    def run_mode(self) -> _builtins.int:
        """
        IPS defense mode. Value:-**1**: Intercept mode-**0**: Observation mode.
        """
        return pulumi.get(self, "run_mode")


@pulumi.output_type
class GetVpcFirewallCensCenResult(dict):
    def __init__(__self__, *,
                 cen_id: _builtins.str,
                 connect_type: _builtins.str,
                 id: _builtins.str,
                 local_vpcs: Sequence['outputs.GetVpcFirewallCensCenLocalVpcResult'],
                 network_instance_id: _builtins.str,
                 status: _builtins.str,
                 vpc_firewall_id: _builtins.str,
                 vpc_firewall_name: _builtins.str):
        """
        :param _builtins.str cen_id: The ID of the CEN instance.
        :param _builtins.str connect_type: Intercommunication type, value: `expressconnect`: Express Channel `cen`: Cloud Enterprise Network
        :param _builtins.str id: The ID of the CEN instance.
        :param Sequence['GetVpcFirewallCensCenLocalVpcArgs'] local_vpcs: The details of the VPC.
        :param _builtins.str network_instance_id: The ID of the VPC instance that created the VPC firewall.
        :param _builtins.str status: Firewall switch status
        :param _builtins.str vpc_firewall_id: VPC firewall ID
        :param _builtins.str vpc_firewall_name: The name of the VPC firewall instance.
        """
        pulumi.set(__self__, "cen_id", cen_id)
        pulumi.set(__self__, "connect_type", connect_type)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "local_vpcs", local_vpcs)
        pulumi.set(__self__, "network_instance_id", network_instance_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "vpc_firewall_id", vpc_firewall_id)
        pulumi.set(__self__, "vpc_firewall_name", vpc_firewall_name)

    @_builtins.property
    @pulumi.getter(name="cenId")
    def cen_id(self) -> _builtins.str:
        """
        The ID of the CEN instance.
        """
        return pulumi.get(self, "cen_id")

    @_builtins.property
    @pulumi.getter(name="connectType")
    def connect_type(self) -> _builtins.str:
        """
        Intercommunication type, value: `expressconnect`: Express Channel `cen`: Cloud Enterprise Network
        """
        return pulumi.get(self, "connect_type")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the CEN instance.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="localVpcs")
    def local_vpcs(self) -> Sequence['outputs.GetVpcFirewallCensCenLocalVpcResult']:
        """
        The details of the VPC.
        """
        return pulumi.get(self, "local_vpcs")

    @_builtins.property
    @pulumi.getter(name="networkInstanceId")
    def network_instance_id(self) -> _builtins.str:
        """
        The ID of the VPC instance that created the VPC firewall.
        """
        return pulumi.get(self, "network_instance_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Firewall switch status
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="vpcFirewallId")
    def vpc_firewall_id(self) -> _builtins.str:
        """
        VPC firewall ID
        """
        return pulumi.get(self, "vpc_firewall_id")

    @_builtins.property
    @pulumi.getter(name="vpcFirewallName")
    def vpc_firewall_name(self) -> _builtins.str:
        """
        The name of the VPC firewall instance.
        """
        return pulumi.get(self, "vpc_firewall_name")


@pulumi.output_type
class GetVpcFirewallCensCenLocalVpcResult(dict):
    def __init__(__self__, *,
                 attachment_id: _builtins.str,
                 attachment_name: _builtins.str,
                 defend_cidr_lists: Sequence[_builtins.str],
                 eni_lists: Sequence['outputs.GetVpcFirewallCensCenLocalVpcEniListResult'],
                 manual_vswitch_id: _builtins.str,
                 network_instance_id: _builtins.str,
                 network_instance_name: _builtins.str,
                 network_instance_type: _builtins.str,
                 owner_id: _builtins.str,
                 region_no: _builtins.str,
                 route_mode: _builtins.str,
                 support_manual_mode: _builtins.str,
                 transit_router_id: _builtins.str,
                 transit_router_type: _builtins.str,
                 vpc_cidr_table_lists: Sequence['outputs.GetVpcFirewallCensCenLocalVpcVpcCidrTableListResult'],
                 vpc_id: _builtins.str,
                 vpc_name: _builtins.str):
        """
        :param Sequence[_builtins.str] defend_cidr_lists: The list of network segments protected by the VPC firewall.
        :param _builtins.str network_instance_id: The ID of the VPC instance that created the VPC firewall.
        :param _builtins.str network_instance_name: The name of the network instance.
        :param _builtins.str network_instance_type: The type of the network instance. Value: **VPC * *.
        :param _builtins.str owner_id: The UID of the Alibaba Cloud account to which the VPC belongs.
        :param _builtins.str region_no: The region ID of the VPC.
        :param _builtins.str route_mode: Routing mode,. Value:-auto: indicates automatic mode.-manual: indicates manual mode.
        :param _builtins.str support_manual_mode: Whether routing mode supports manual mode. Value:-**1**: Supported.-**0**: Not supported.
        :param _builtins.str transit_router_type: The version of the cloud enterprise network forwarding router (CEN-TR). Value:-**Basic**: Basic Edition.-**Enterprise**: Enterprise Edition.
        :param Sequence['GetVpcFirewallCensCenLocalVpcVpcCidrTableListArgs'] vpc_cidr_table_lists: The VPC network segment list.
        :param _builtins.str vpc_id: The ID of the VPC instance.
        :param _builtins.str vpc_name: The instance name of the VPC.
        """
        pulumi.set(__self__, "attachment_id", attachment_id)
        pulumi.set(__self__, "attachment_name", attachment_name)
        pulumi.set(__self__, "defend_cidr_lists", defend_cidr_lists)
        pulumi.set(__self__, "eni_lists", eni_lists)
        pulumi.set(__self__, "manual_vswitch_id", manual_vswitch_id)
        pulumi.set(__self__, "network_instance_id", network_instance_id)
        pulumi.set(__self__, "network_instance_name", network_instance_name)
        pulumi.set(__self__, "network_instance_type", network_instance_type)
        pulumi.set(__self__, "owner_id", owner_id)
        pulumi.set(__self__, "region_no", region_no)
        pulumi.set(__self__, "route_mode", route_mode)
        pulumi.set(__self__, "support_manual_mode", support_manual_mode)
        pulumi.set(__self__, "transit_router_id", transit_router_id)
        pulumi.set(__self__, "transit_router_type", transit_router_type)
        pulumi.set(__self__, "vpc_cidr_table_lists", vpc_cidr_table_lists)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vpc_name", vpc_name)

    @_builtins.property
    @pulumi.getter(name="attachmentId")
    def attachment_id(self) -> _builtins.str:
        return pulumi.get(self, "attachment_id")

    @_builtins.property
    @pulumi.getter(name="attachmentName")
    def attachment_name(self) -> _builtins.str:
        return pulumi.get(self, "attachment_name")

    @_builtins.property
    @pulumi.getter(name="defendCidrLists")
    def defend_cidr_lists(self) -> Sequence[_builtins.str]:
        """
        The list of network segments protected by the VPC firewall.
        """
        return pulumi.get(self, "defend_cidr_lists")

    @_builtins.property
    @pulumi.getter(name="eniLists")
    def eni_lists(self) -> Sequence['outputs.GetVpcFirewallCensCenLocalVpcEniListResult']:
        return pulumi.get(self, "eni_lists")

    @_builtins.property
    @pulumi.getter(name="manualVswitchId")
    def manual_vswitch_id(self) -> _builtins.str:
        return pulumi.get(self, "manual_vswitch_id")

    @_builtins.property
    @pulumi.getter(name="networkInstanceId")
    def network_instance_id(self) -> _builtins.str:
        """
        The ID of the VPC instance that created the VPC firewall.
        """
        return pulumi.get(self, "network_instance_id")

    @_builtins.property
    @pulumi.getter(name="networkInstanceName")
    def network_instance_name(self) -> _builtins.str:
        """
        The name of the network instance.
        """
        return pulumi.get(self, "network_instance_name")

    @_builtins.property
    @pulumi.getter(name="networkInstanceType")
    def network_instance_type(self) -> _builtins.str:
        """
        The type of the network instance. Value: **VPC * *.
        """
        return pulumi.get(self, "network_instance_type")

    @_builtins.property
    @pulumi.getter(name="ownerId")
    def owner_id(self) -> _builtins.str:
        """
        The UID of the Alibaba Cloud account to which the VPC belongs.
        """
        return pulumi.get(self, "owner_id")

    @_builtins.property
    @pulumi.getter(name="regionNo")
    def region_no(self) -> _builtins.str:
        """
        The region ID of the VPC.
        """
        return pulumi.get(self, "region_no")

    @_builtins.property
    @pulumi.getter(name="routeMode")
    def route_mode(self) -> _builtins.str:
        """
        Routing mode,. Value:-auto: indicates automatic mode.-manual: indicates manual mode.
        """
        return pulumi.get(self, "route_mode")

    @_builtins.property
    @pulumi.getter(name="supportManualMode")
    def support_manual_mode(self) -> _builtins.str:
        """
        Whether routing mode supports manual mode. Value:-**1**: Supported.-**0**: Not supported.
        """
        return pulumi.get(self, "support_manual_mode")

    @_builtins.property
    @pulumi.getter(name="transitRouterId")
    def transit_router_id(self) -> _builtins.str:
        return pulumi.get(self, "transit_router_id")

    @_builtins.property
    @pulumi.getter(name="transitRouterType")
    def transit_router_type(self) -> _builtins.str:
        """
        The version of the cloud enterprise network forwarding router (CEN-TR). Value:-**Basic**: Basic Edition.-**Enterprise**: Enterprise Edition.
        """
        return pulumi.get(self, "transit_router_type")

    @_builtins.property
    @pulumi.getter(name="vpcCidrTableLists")
    def vpc_cidr_table_lists(self) -> Sequence['outputs.GetVpcFirewallCensCenLocalVpcVpcCidrTableListResult']:
        """
        The VPC network segment list.
        """
        return pulumi.get(self, "vpc_cidr_table_lists")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> _builtins.str:
        """
        The ID of the VPC instance.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vpcName")
    def vpc_name(self) -> _builtins.str:
        """
        The instance name of the VPC.
        """
        return pulumi.get(self, "vpc_name")


@pulumi.output_type
class GetVpcFirewallCensCenLocalVpcEniListResult(dict):
    def __init__(__self__, *,
                 eni_id: _builtins.str,
                 eni_private_ip_address: _builtins.str):
        pulumi.set(__self__, "eni_id", eni_id)
        pulumi.set(__self__, "eni_private_ip_address", eni_private_ip_address)

    @_builtins.property
    @pulumi.getter(name="eniId")
    def eni_id(self) -> _builtins.str:
        return pulumi.get(self, "eni_id")

    @_builtins.property
    @pulumi.getter(name="eniPrivateIpAddress")
    def eni_private_ip_address(self) -> _builtins.str:
        return pulumi.get(self, "eni_private_ip_address")


@pulumi.output_type
class GetVpcFirewallCensCenLocalVpcVpcCidrTableListResult(dict):
    def __init__(__self__, *,
                 route_entry_lists: Sequence['outputs.GetVpcFirewallCensCenLocalVpcVpcCidrTableListRouteEntryListResult'],
                 route_table_id: _builtins.str):
        """
        :param Sequence['GetVpcFirewallCensCenLocalVpcVpcCidrTableListRouteEntryListArgs'] route_entry_lists: The list of route entries in the VPC.
        :param _builtins.str route_table_id: The ID of the route table of the VPC.
        """
        pulumi.set(__self__, "route_entry_lists", route_entry_lists)
        pulumi.set(__self__, "route_table_id", route_table_id)

    @_builtins.property
    @pulumi.getter(name="routeEntryLists")
    def route_entry_lists(self) -> Sequence['outputs.GetVpcFirewallCensCenLocalVpcVpcCidrTableListRouteEntryListResult']:
        """
        The list of route entries in the VPC.
        """
        return pulumi.get(self, "route_entry_lists")

    @_builtins.property
    @pulumi.getter(name="routeTableId")
    def route_table_id(self) -> _builtins.str:
        """
        The ID of the route table of the VPC.
        """
        return pulumi.get(self, "route_table_id")


@pulumi.output_type
class GetVpcFirewallCensCenLocalVpcVpcCidrTableListRouteEntryListResult(dict):
    def __init__(__self__, *,
                 destination_cidr: _builtins.str,
                 next_hop_instance_id: _builtins.str):
        """
        :param _builtins.str destination_cidr: The target network segment of the VPC.
        :param _builtins.str next_hop_instance_id: The ID of the next hop instance in the VPC.
        """
        pulumi.set(__self__, "destination_cidr", destination_cidr)
        pulumi.set(__self__, "next_hop_instance_id", next_hop_instance_id)

    @_builtins.property
    @pulumi.getter(name="destinationCidr")
    def destination_cidr(self) -> _builtins.str:
        """
        The target network segment of the VPC.
        """
        return pulumi.get(self, "destination_cidr")

    @_builtins.property
    @pulumi.getter(name="nextHopInstanceId")
    def next_hop_instance_id(self) -> _builtins.str:
        """
        The ID of the next hop instance in the VPC.
        """
        return pulumi.get(self, "next_hop_instance_id")


@pulumi.output_type
class GetVpcFirewallControlPoliciesPolicyResult(dict):
    def __init__(__self__, *,
                 acl_action: _builtins.str,
                 acl_uuid: _builtins.str,
                 application_id: _builtins.str,
                 application_name: _builtins.str,
                 description: _builtins.str,
                 dest_port: _builtins.str,
                 dest_port_group: _builtins.str,
                 dest_port_group_ports: Sequence[_builtins.str],
                 dest_port_type: _builtins.str,
                 destination: _builtins.str,
                 destination_group_cidrs: Sequence[_builtins.str],
                 destination_group_type: _builtins.str,
                 destination_type: _builtins.str,
                 hit_times: _builtins.int,
                 id: _builtins.str,
                 member_uid: _builtins.str,
                 order: _builtins.int,
                 proto: _builtins.str,
                 release: _builtins.bool,
                 source: _builtins.str,
                 source_group_cidrs: Sequence[_builtins.str],
                 source_group_type: _builtins.str,
                 source_type: _builtins.str,
                 vpc_firewall_id: _builtins.str):
        """
        :param _builtins.str acl_action: The action that Cloud Firewall performs on the traffic. Valid values: `accept`, `drop`, `log`.
        :param _builtins.str acl_uuid: Access control over VPC firewalls strategy unique identifier.
        :param _builtins.str application_id: Policy specifies the application ID.
        :param _builtins.str application_name: Access control over VPC firewalls policies support the application types.
        :param _builtins.str description: Access control over VPC firewalls description of the strategy information.
        :param _builtins.str dest_port: Access control over VPC firewalls strategy access traffic of the destination port.
        :param _builtins.str dest_port_group: Access control policy in the access traffic of the destination port address book name.
        :param Sequence[_builtins.str] dest_port_group_ports: Port Address Book port list.
        :param _builtins.str dest_port_type: Access control over VPC firewalls strategy access traffic of the destination port type.
        :param _builtins.str destination: Access control over VPC firewalls strategy the destination address in.
        :param Sequence[_builtins.str] destination_group_cidrs: Destination address book defined in the address list.
        :param _builtins.str destination_group_type: The destination address book type in the access control policy. Value: `ip`, `domain`.
        :param _builtins.str destination_type: Access control over VPC firewalls strategy in the destination address of the type.
        :param _builtins.int hit_times: Control strategy of hits per second.
        :param _builtins.str id: The ID of the Cloud Firewall Vpc Firewall Control Policy.
        :param _builtins.str member_uid: The UID of the member account of the current Alibaba cloud account.
        :param _builtins.int order: Access control over VPC firewalls policies will go into effect of priority. The priority value starts from 1, the smaller the priority number, the higher the priority. -1 represents the lowest priority.
        :param _builtins.str proto: Access control over VPC firewalls strategy access traffic of the protocol type.
        :param _builtins.bool release: The enabled status of the access control policy. The policy is enabled by default after it is created. Value:
               - **true**: Enable access control policies
               - **false**: does not enable access control policies.
        :param _builtins.str source: Access control over VPC firewalls strategy in the source address.
        :param Sequence[_builtins.str] source_group_cidrs: SOURCE address of the address list.
        :param _builtins.str source_group_type: The source address type in the access control policy. Unique value: **ip**. The IP address book contains one or more IP address segments.
        :param _builtins.str source_type: Access control over VPC firewalls policy source address type.
        :param _builtins.str vpc_firewall_id: The ID of the VPC firewall instance. Value:
               - When the VPC firewall protects traffic between two VPCs connected through the cloud enterprise network, the policy group ID uses the cloud enterprise network instance ID.
               - When the VPC firewall protects traffic between two VPCs connected through the express connection, the policy group ID uses the ID of the VPC firewall instance.
        """
        pulumi.set(__self__, "acl_action", acl_action)
        pulumi.set(__self__, "acl_uuid", acl_uuid)
        pulumi.set(__self__, "application_id", application_id)
        pulumi.set(__self__, "application_name", application_name)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "dest_port", dest_port)
        pulumi.set(__self__, "dest_port_group", dest_port_group)
        pulumi.set(__self__, "dest_port_group_ports", dest_port_group_ports)
        pulumi.set(__self__, "dest_port_type", dest_port_type)
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "destination_group_cidrs", destination_group_cidrs)
        pulumi.set(__self__, "destination_group_type", destination_group_type)
        pulumi.set(__self__, "destination_type", destination_type)
        pulumi.set(__self__, "hit_times", hit_times)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "member_uid", member_uid)
        pulumi.set(__self__, "order", order)
        pulumi.set(__self__, "proto", proto)
        pulumi.set(__self__, "release", release)
        pulumi.set(__self__, "source", source)
        pulumi.set(__self__, "source_group_cidrs", source_group_cidrs)
        pulumi.set(__self__, "source_group_type", source_group_type)
        pulumi.set(__self__, "source_type", source_type)
        pulumi.set(__self__, "vpc_firewall_id", vpc_firewall_id)

    @_builtins.property
    @pulumi.getter(name="aclAction")
    def acl_action(self) -> _builtins.str:
        """
        The action that Cloud Firewall performs on the traffic. Valid values: `accept`, `drop`, `log`.
        """
        return pulumi.get(self, "acl_action")

    @_builtins.property
    @pulumi.getter(name="aclUuid")
    def acl_uuid(self) -> _builtins.str:
        """
        Access control over VPC firewalls strategy unique identifier.
        """
        return pulumi.get(self, "acl_uuid")

    @_builtins.property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> _builtins.str:
        """
        Policy specifies the application ID.
        """
        return pulumi.get(self, "application_id")

    @_builtins.property
    @pulumi.getter(name="applicationName")
    def application_name(self) -> _builtins.str:
        """
        Access control over VPC firewalls policies support the application types.
        """
        return pulumi.get(self, "application_name")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Access control over VPC firewalls description of the strategy information.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="destPort")
    def dest_port(self) -> _builtins.str:
        """
        Access control over VPC firewalls strategy access traffic of the destination port.
        """
        return pulumi.get(self, "dest_port")

    @_builtins.property
    @pulumi.getter(name="destPortGroup")
    def dest_port_group(self) -> _builtins.str:
        """
        Access control policy in the access traffic of the destination port address book name.
        """
        return pulumi.get(self, "dest_port_group")

    @_builtins.property
    @pulumi.getter(name="destPortGroupPorts")
    def dest_port_group_ports(self) -> Sequence[_builtins.str]:
        """
        Port Address Book port list.
        """
        return pulumi.get(self, "dest_port_group_ports")

    @_builtins.property
    @pulumi.getter(name="destPortType")
    def dest_port_type(self) -> _builtins.str:
        """
        Access control over VPC firewalls strategy access traffic of the destination port type.
        """
        return pulumi.get(self, "dest_port_type")

    @_builtins.property
    @pulumi.getter
    def destination(self) -> _builtins.str:
        """
        Access control over VPC firewalls strategy the destination address in.
        """
        return pulumi.get(self, "destination")

    @_builtins.property
    @pulumi.getter(name="destinationGroupCidrs")
    def destination_group_cidrs(self) -> Sequence[_builtins.str]:
        """
        Destination address book defined in the address list.
        """
        return pulumi.get(self, "destination_group_cidrs")

    @_builtins.property
    @pulumi.getter(name="destinationGroupType")
    def destination_group_type(self) -> _builtins.str:
        """
        The destination address book type in the access control policy. Value: `ip`, `domain`.
        """
        return pulumi.get(self, "destination_group_type")

    @_builtins.property
    @pulumi.getter(name="destinationType")
    def destination_type(self) -> _builtins.str:
        """
        Access control over VPC firewalls strategy in the destination address of the type.
        """
        return pulumi.get(self, "destination_type")

    @_builtins.property
    @pulumi.getter(name="hitTimes")
    def hit_times(self) -> _builtins.int:
        """
        Control strategy of hits per second.
        """
        return pulumi.get(self, "hit_times")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Cloud Firewall Vpc Firewall Control Policy.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="memberUid")
    def member_uid(self) -> _builtins.str:
        """
        The UID of the member account of the current Alibaba cloud account.
        """
        return pulumi.get(self, "member_uid")

    @_builtins.property
    @pulumi.getter
    def order(self) -> _builtins.int:
        """
        Access control over VPC firewalls policies will go into effect of priority. The priority value starts from 1, the smaller the priority number, the higher the priority. -1 represents the lowest priority.
        """
        return pulumi.get(self, "order")

    @_builtins.property
    @pulumi.getter
    def proto(self) -> _builtins.str:
        """
        Access control over VPC firewalls strategy access traffic of the protocol type.
        """
        return pulumi.get(self, "proto")

    @_builtins.property
    @pulumi.getter
    def release(self) -> _builtins.bool:
        """
        The enabled status of the access control policy. The policy is enabled by default after it is created. Value:
        - **true**: Enable access control policies
        - **false**: does not enable access control policies.
        """
        return pulumi.get(self, "release")

    @_builtins.property
    @pulumi.getter
    def source(self) -> _builtins.str:
        """
        Access control over VPC firewalls strategy in the source address.
        """
        return pulumi.get(self, "source")

    @_builtins.property
    @pulumi.getter(name="sourceGroupCidrs")
    def source_group_cidrs(self) -> Sequence[_builtins.str]:
        """
        SOURCE address of the address list.
        """
        return pulumi.get(self, "source_group_cidrs")

    @_builtins.property
    @pulumi.getter(name="sourceGroupType")
    def source_group_type(self) -> _builtins.str:
        """
        The source address type in the access control policy. Unique value: **ip**. The IP address book contains one or more IP address segments.
        """
        return pulumi.get(self, "source_group_type")

    @_builtins.property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> _builtins.str:
        """
        Access control over VPC firewalls policy source address type.
        """
        return pulumi.get(self, "source_type")

    @_builtins.property
    @pulumi.getter(name="vpcFirewallId")
    def vpc_firewall_id(self) -> _builtins.str:
        """
        The ID of the VPC firewall instance. Value:
        - When the VPC firewall protects traffic between two VPCs connected through the cloud enterprise network, the policy group ID uses the cloud enterprise network instance ID.
        - When the VPC firewall protects traffic between two VPCs connected through the express connection, the policy group ID uses the ID of the VPC firewall instance.
        """
        return pulumi.get(self, "vpc_firewall_id")


@pulumi.output_type
class GetVpcFirewallsFirewallResult(dict):
    def __init__(__self__, *,
                 bandwidth: _builtins.int,
                 connect_type: _builtins.str,
                 id: _builtins.str,
                 local_vpcs: Sequence['outputs.GetVpcFirewallsFirewallLocalVpcResult'],
                 peer_vpcs: Sequence['outputs.GetVpcFirewallsFirewallPeerVpcResult'],
                 region_status: _builtins.str,
                 status: _builtins.str,
                 vpc_firewall_id: _builtins.str,
                 vpc_firewall_name: _builtins.str):
        """
        :param _builtins.int bandwidth: Bandwidth specifications for high-speed channels. Unit: Mbps.
        :param _builtins.str connect_type: The communication type of the VPC firewall. Valid value: **expressconnect**, which indicates Express Connect.
        :param _builtins.str id: The name of the VPC firewall instance and the value same as `vpc_firewall_id`.
        :param Sequence['GetVpcFirewallsFirewallLocalVpcArgs'] local_vpcs: The details of the local VPC.
        :param Sequence['GetVpcFirewallsFirewallPeerVpcArgs'] peer_vpcs: The details of the peer VPC.
        :param _builtins.str region_status: The region is open. Value:-**enable**: is enabled, indicating that VPC firewall can be configured in this region.-**disable**: indicates that VPC firewall cannot be configured in this region.
        :param _builtins.str status: The status of the resource
        :param _builtins.str vpc_firewall_id: The ID of the VPC firewall instance.
        :param _builtins.str vpc_firewall_name: The name of the VPC firewall instance.
        """
        pulumi.set(__self__, "bandwidth", bandwidth)
        pulumi.set(__self__, "connect_type", connect_type)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "local_vpcs", local_vpcs)
        pulumi.set(__self__, "peer_vpcs", peer_vpcs)
        pulumi.set(__self__, "region_status", region_status)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "vpc_firewall_id", vpc_firewall_id)
        pulumi.set(__self__, "vpc_firewall_name", vpc_firewall_name)

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> _builtins.int:
        """
        Bandwidth specifications for high-speed channels. Unit: Mbps.
        """
        return pulumi.get(self, "bandwidth")

    @_builtins.property
    @pulumi.getter(name="connectType")
    def connect_type(self) -> _builtins.str:
        """
        The communication type of the VPC firewall. Valid value: **expressconnect**, which indicates Express Connect.
        """
        return pulumi.get(self, "connect_type")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The name of the VPC firewall instance and the value same as `vpc_firewall_id`.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="localVpcs")
    def local_vpcs(self) -> Sequence['outputs.GetVpcFirewallsFirewallLocalVpcResult']:
        """
        The details of the local VPC.
        """
        return pulumi.get(self, "local_vpcs")

    @_builtins.property
    @pulumi.getter(name="peerVpcs")
    def peer_vpcs(self) -> Sequence['outputs.GetVpcFirewallsFirewallPeerVpcResult']:
        """
        The details of the peer VPC.
        """
        return pulumi.get(self, "peer_vpcs")

    @_builtins.property
    @pulumi.getter(name="regionStatus")
    def region_status(self) -> _builtins.str:
        """
        The region is open. Value:-**enable**: is enabled, indicating that VPC firewall can be configured in this region.-**disable**: indicates that VPC firewall cannot be configured in this region.
        """
        return pulumi.get(self, "region_status")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the resource
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="vpcFirewallId")
    def vpc_firewall_id(self) -> _builtins.str:
        """
        The ID of the VPC firewall instance.
        """
        return pulumi.get(self, "vpc_firewall_id")

    @_builtins.property
    @pulumi.getter(name="vpcFirewallName")
    def vpc_firewall_name(self) -> _builtins.str:
        """
        The name of the VPC firewall instance.
        """
        return pulumi.get(self, "vpc_firewall_name")


@pulumi.output_type
class GetVpcFirewallsFirewallLocalVpcResult(dict):
    def __init__(__self__, *,
                 eni_id: _builtins.str,
                 eni_private_ip_address: _builtins.str,
                 local_vpc_cidr_table_lists: Sequence['outputs.GetVpcFirewallsFirewallLocalVpcLocalVpcCidrTableListResult'],
                 region_no: _builtins.str,
                 router_interface_id: _builtins.str,
                 vpc_id: _builtins.str,
                 vpc_name: _builtins.str):
        """
        :param Sequence['GetVpcFirewallsFirewallLocalVpcLocalVpcCidrTableListArgs'] local_vpc_cidr_table_lists: The network segment list of the local VPC.
        :param _builtins.str region_no: The region ID of the peer VPC.
        :param _builtins.str vpc_id: The ID of the peer VPC instance.
        :param _builtins.str vpc_name: The instance name of the peer VPC.
        """
        pulumi.set(__self__, "eni_id", eni_id)
        pulumi.set(__self__, "eni_private_ip_address", eni_private_ip_address)
        pulumi.set(__self__, "local_vpc_cidr_table_lists", local_vpc_cidr_table_lists)
        pulumi.set(__self__, "region_no", region_no)
        pulumi.set(__self__, "router_interface_id", router_interface_id)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vpc_name", vpc_name)

    @_builtins.property
    @pulumi.getter(name="eniId")
    def eni_id(self) -> _builtins.str:
        return pulumi.get(self, "eni_id")

    @_builtins.property
    @pulumi.getter(name="eniPrivateIpAddress")
    def eni_private_ip_address(self) -> _builtins.str:
        return pulumi.get(self, "eni_private_ip_address")

    @_builtins.property
    @pulumi.getter(name="localVpcCidrTableLists")
    def local_vpc_cidr_table_lists(self) -> Sequence['outputs.GetVpcFirewallsFirewallLocalVpcLocalVpcCidrTableListResult']:
        """
        The network segment list of the local VPC.
        """
        return pulumi.get(self, "local_vpc_cidr_table_lists")

    @_builtins.property
    @pulumi.getter(name="regionNo")
    def region_no(self) -> _builtins.str:
        """
        The region ID of the peer VPC.
        """
        return pulumi.get(self, "region_no")

    @_builtins.property
    @pulumi.getter(name="routerInterfaceId")
    def router_interface_id(self) -> _builtins.str:
        return pulumi.get(self, "router_interface_id")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> _builtins.str:
        """
        The ID of the peer VPC instance.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vpcName")
    def vpc_name(self) -> _builtins.str:
        """
        The instance name of the peer VPC.
        """
        return pulumi.get(self, "vpc_name")


@pulumi.output_type
class GetVpcFirewallsFirewallLocalVpcLocalVpcCidrTableListResult(dict):
    def __init__(__self__, *,
                 local_route_entry_lists: Sequence['outputs.GetVpcFirewallsFirewallLocalVpcLocalVpcCidrTableListLocalRouteEntryListResult'],
                 local_route_table_id: _builtins.str):
        """
        :param Sequence['GetVpcFirewallsFirewallLocalVpcLocalVpcCidrTableListLocalRouteEntryListArgs'] local_route_entry_lists: The list of route entries of the local VPC.
        :param _builtins.str local_route_table_id: The ID of the route table of the local VPC.
        """
        pulumi.set(__self__, "local_route_entry_lists", local_route_entry_lists)
        pulumi.set(__self__, "local_route_table_id", local_route_table_id)

    @_builtins.property
    @pulumi.getter(name="localRouteEntryLists")
    def local_route_entry_lists(self) -> Sequence['outputs.GetVpcFirewallsFirewallLocalVpcLocalVpcCidrTableListLocalRouteEntryListResult']:
        """
        The list of route entries of the local VPC.
        """
        return pulumi.get(self, "local_route_entry_lists")

    @_builtins.property
    @pulumi.getter(name="localRouteTableId")
    def local_route_table_id(self) -> _builtins.str:
        """
        The ID of the route table of the local VPC.
        """
        return pulumi.get(self, "local_route_table_id")


@pulumi.output_type
class GetVpcFirewallsFirewallLocalVpcLocalVpcCidrTableListLocalRouteEntryListResult(dict):
    def __init__(__self__, *,
                 local_destination_cidr: _builtins.str,
                 local_next_hop_instance_id: _builtins.str):
        """
        :param _builtins.str local_destination_cidr: The target network segment of the local VPC.
        :param _builtins.str local_next_hop_instance_id: The ID of the next-hop instance in the local VPC.
        """
        pulumi.set(__self__, "local_destination_cidr", local_destination_cidr)
        pulumi.set(__self__, "local_next_hop_instance_id", local_next_hop_instance_id)

    @_builtins.property
    @pulumi.getter(name="localDestinationCidr")
    def local_destination_cidr(self) -> _builtins.str:
        """
        The target network segment of the local VPC.
        """
        return pulumi.get(self, "local_destination_cidr")

    @_builtins.property
    @pulumi.getter(name="localNextHopInstanceId")
    def local_next_hop_instance_id(self) -> _builtins.str:
        """
        The ID of the next-hop instance in the local VPC.
        """
        return pulumi.get(self, "local_next_hop_instance_id")


@pulumi.output_type
class GetVpcFirewallsFirewallPeerVpcResult(dict):
    def __init__(__self__, *,
                 eni_id: _builtins.str,
                 eni_private_ip_address: _builtins.str,
                 peer_vpc_cidr_table_lists: Sequence['outputs.GetVpcFirewallsFirewallPeerVpcPeerVpcCidrTableListResult'],
                 region_no: _builtins.str,
                 router_interface_id: _builtins.str,
                 vpc_id: _builtins.str,
                 vpc_name: _builtins.str):
        """
        :param Sequence['GetVpcFirewallsFirewallPeerVpcPeerVpcCidrTableListArgs'] peer_vpc_cidr_table_lists: The network segment list of the peer VPC.
        :param _builtins.str region_no: The region ID of the peer VPC.
        :param _builtins.str vpc_id: The ID of the peer VPC instance.
        :param _builtins.str vpc_name: The instance name of the peer VPC.
        """
        pulumi.set(__self__, "eni_id", eni_id)
        pulumi.set(__self__, "eni_private_ip_address", eni_private_ip_address)
        pulumi.set(__self__, "peer_vpc_cidr_table_lists", peer_vpc_cidr_table_lists)
        pulumi.set(__self__, "region_no", region_no)
        pulumi.set(__self__, "router_interface_id", router_interface_id)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vpc_name", vpc_name)

    @_builtins.property
    @pulumi.getter(name="eniId")
    def eni_id(self) -> _builtins.str:
        return pulumi.get(self, "eni_id")

    @_builtins.property
    @pulumi.getter(name="eniPrivateIpAddress")
    def eni_private_ip_address(self) -> _builtins.str:
        return pulumi.get(self, "eni_private_ip_address")

    @_builtins.property
    @pulumi.getter(name="peerVpcCidrTableLists")
    def peer_vpc_cidr_table_lists(self) -> Sequence['outputs.GetVpcFirewallsFirewallPeerVpcPeerVpcCidrTableListResult']:
        """
        The network segment list of the peer VPC.
        """
        return pulumi.get(self, "peer_vpc_cidr_table_lists")

    @_builtins.property
    @pulumi.getter(name="regionNo")
    def region_no(self) -> _builtins.str:
        """
        The region ID of the peer VPC.
        """
        return pulumi.get(self, "region_no")

    @_builtins.property
    @pulumi.getter(name="routerInterfaceId")
    def router_interface_id(self) -> _builtins.str:
        return pulumi.get(self, "router_interface_id")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> _builtins.str:
        """
        The ID of the peer VPC instance.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vpcName")
    def vpc_name(self) -> _builtins.str:
        """
        The instance name of the peer VPC.
        """
        return pulumi.get(self, "vpc_name")


@pulumi.output_type
class GetVpcFirewallsFirewallPeerVpcPeerVpcCidrTableListResult(dict):
    def __init__(__self__, *,
                 peer_route_entry_lists: Sequence['outputs.GetVpcFirewallsFirewallPeerVpcPeerVpcCidrTableListPeerRouteEntryListResult'],
                 peer_route_table_id: _builtins.str):
        """
        :param Sequence['GetVpcFirewallsFirewallPeerVpcPeerVpcCidrTableListPeerRouteEntryListArgs'] peer_route_entry_lists: Peer VPC route entry list information.
        :param _builtins.str peer_route_table_id: The ID of the route table of the peer VPC.
        """
        pulumi.set(__self__, "peer_route_entry_lists", peer_route_entry_lists)
        pulumi.set(__self__, "peer_route_table_id", peer_route_table_id)

    @_builtins.property
    @pulumi.getter(name="peerRouteEntryLists")
    def peer_route_entry_lists(self) -> Sequence['outputs.GetVpcFirewallsFirewallPeerVpcPeerVpcCidrTableListPeerRouteEntryListResult']:
        """
        Peer VPC route entry list information.
        """
        return pulumi.get(self, "peer_route_entry_lists")

    @_builtins.property
    @pulumi.getter(name="peerRouteTableId")
    def peer_route_table_id(self) -> _builtins.str:
        """
        The ID of the route table of the peer VPC.
        """
        return pulumi.get(self, "peer_route_table_id")


@pulumi.output_type
class GetVpcFirewallsFirewallPeerVpcPeerVpcCidrTableListPeerRouteEntryListResult(dict):
    def __init__(__self__, *,
                 peer_destination_cidr: _builtins.str,
                 peer_next_hop_instance_id: _builtins.str):
        """
        :param _builtins.str peer_destination_cidr: The target network segment of the peer VPC.
        :param _builtins.str peer_next_hop_instance_id: The ID of the next-hop instance in the peer VPC.
        """
        pulumi.set(__self__, "peer_destination_cidr", peer_destination_cidr)
        pulumi.set(__self__, "peer_next_hop_instance_id", peer_next_hop_instance_id)

    @_builtins.property
    @pulumi.getter(name="peerDestinationCidr")
    def peer_destination_cidr(self) -> _builtins.str:
        """
        The target network segment of the peer VPC.
        """
        return pulumi.get(self, "peer_destination_cidr")

    @_builtins.property
    @pulumi.getter(name="peerNextHopInstanceId")
    def peer_next_hop_instance_id(self) -> _builtins.str:
        """
        The ID of the next-hop instance in the peer VPC.
        """
        return pulumi.get(self, "peer_next_hop_instance_id")


