# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['GatewayBlockVolumeArgs', 'GatewayBlockVolume']

@pulumi.input_type
class GatewayBlockVolumeArgs:
    def __init__(__self__, *,
                 gateway_block_volume_name: pulumi.Input[_builtins.str],
                 gateway_id: pulumi.Input[_builtins.str],
                 oss_bucket_name: pulumi.Input[_builtins.str],
                 oss_endpoint: pulumi.Input[_builtins.str],
                 protocol: pulumi.Input[_builtins.str],
                 cache_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 chap_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 chap_in_password: Optional[pulumi.Input[_builtins.str]] = None,
                 chap_in_user: Optional[pulumi.Input[_builtins.str]] = None,
                 chunk_size: Optional[pulumi.Input[_builtins.int]] = None,
                 is_source_deletion: Optional[pulumi.Input[_builtins.bool]] = None,
                 local_path: Optional[pulumi.Input[_builtins.str]] = None,
                 oss_bucket_ssl: Optional[pulumi.Input[_builtins.bool]] = None,
                 recovery: Optional[pulumi.Input[_builtins.bool]] = None,
                 size: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a GatewayBlockVolume resource.
        :param pulumi.Input[_builtins.str] gateway_block_volume_name: The Block volume name. The name must be 1 to 32 characters in length, and can contain lower case letters and digits.
        :param pulumi.Input[_builtins.str] gateway_id: The Gateway ID.
        :param pulumi.Input[_builtins.str] oss_bucket_name: The name of the OSS Bucket.
        :param pulumi.Input[_builtins.str] oss_endpoint: The endpoint of the OSS Bucket.
        :param pulumi.Input[_builtins.str] protocol: The Protocol. Valid values: `iSCSI`.
        :param pulumi.Input[_builtins.str] cache_mode: The Block volume set mode to cache mode. Valid values: `Cache`, `WriteThrough`.
        :param pulumi.Input[_builtins.bool] chap_enabled: Whether to enable iSCSI access of CHAP authentication, which currently supports both CHAP inbound authentication.  Default value: `false`.
        :param pulumi.Input[_builtins.str] chap_in_password: The password for inbound authentication when the block volume enables iSCSI access to CHAP authentication. **NOTE:** When the `chap_enabled` is  `true` is,The `chap_in_password` is valid.
        :param pulumi.Input[_builtins.str] chap_in_user: The Inbound CHAP user. The `chap_in_user` must be 1 to 32 characters in length, and can contain letters and digits. **NOTE:** When the `chap_enabled` is  `true` is,The `chap_in_password` is valid.
        :param pulumi.Input[_builtins.int] chunk_size: The Block volume storage allocation unit.  Valid values: `8192`, `16384`, `32768`, `65536`, `131072`. Default value: `32768`. Unit: `Byte`.
        :param pulumi.Input[_builtins.bool] is_source_deletion: Whether to delete the source data. Default value `true`. **NOTE:** When `is_source_deletion` is `true`, the data in the OSS Bucket on the cloud is also deleted when deleting the block gateway volume. Please operate with caution.
        :param pulumi.Input[_builtins.str] local_path: The Cache disk to local path. **NOTE:**  When the `cache_mode` is  `Cache` is,The `chap_in_password` is valid.
        :param pulumi.Input[_builtins.bool] oss_bucket_ssl: Whether to enable SSL access your OSS Buckets. Default value: `true`.
        :param pulumi.Input[_builtins.bool] recovery: The recovery.
        :param pulumi.Input[_builtins.int] size: The Volume size. Valid values: `1` to `262144`. Unit: `Byte`.
        """
        pulumi.set(__self__, "gateway_block_volume_name", gateway_block_volume_name)
        pulumi.set(__self__, "gateway_id", gateway_id)
        pulumi.set(__self__, "oss_bucket_name", oss_bucket_name)
        pulumi.set(__self__, "oss_endpoint", oss_endpoint)
        pulumi.set(__self__, "protocol", protocol)
        if cache_mode is not None:
            pulumi.set(__self__, "cache_mode", cache_mode)
        if chap_enabled is not None:
            pulumi.set(__self__, "chap_enabled", chap_enabled)
        if chap_in_password is not None:
            pulumi.set(__self__, "chap_in_password", chap_in_password)
        if chap_in_user is not None:
            pulumi.set(__self__, "chap_in_user", chap_in_user)
        if chunk_size is not None:
            pulumi.set(__self__, "chunk_size", chunk_size)
        if is_source_deletion is not None:
            pulumi.set(__self__, "is_source_deletion", is_source_deletion)
        if local_path is not None:
            pulumi.set(__self__, "local_path", local_path)
        if oss_bucket_ssl is not None:
            pulumi.set(__self__, "oss_bucket_ssl", oss_bucket_ssl)
        if recovery is not None:
            pulumi.set(__self__, "recovery", recovery)
        if size is not None:
            pulumi.set(__self__, "size", size)

    @_builtins.property
    @pulumi.getter(name="gatewayBlockVolumeName")
    def gateway_block_volume_name(self) -> pulumi.Input[_builtins.str]:
        """
        The Block volume name. The name must be 1 to 32 characters in length, and can contain lower case letters and digits.
        """
        return pulumi.get(self, "gateway_block_volume_name")

    @gateway_block_volume_name.setter
    def gateway_block_volume_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "gateway_block_volume_name", value)

    @_builtins.property
    @pulumi.getter(name="gatewayId")
    def gateway_id(self) -> pulumi.Input[_builtins.str]:
        """
        The Gateway ID.
        """
        return pulumi.get(self, "gateway_id")

    @gateway_id.setter
    def gateway_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "gateway_id", value)

    @_builtins.property
    @pulumi.getter(name="ossBucketName")
    def oss_bucket_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the OSS Bucket.
        """
        return pulumi.get(self, "oss_bucket_name")

    @oss_bucket_name.setter
    def oss_bucket_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "oss_bucket_name", value)

    @_builtins.property
    @pulumi.getter(name="ossEndpoint")
    def oss_endpoint(self) -> pulumi.Input[_builtins.str]:
        """
        The endpoint of the OSS Bucket.
        """
        return pulumi.get(self, "oss_endpoint")

    @oss_endpoint.setter
    def oss_endpoint(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "oss_endpoint", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[_builtins.str]:
        """
        The Protocol. Valid values: `iSCSI`.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter(name="cacheMode")
    def cache_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Block volume set mode to cache mode. Valid values: `Cache`, `WriteThrough`.
        """
        return pulumi.get(self, "cache_mode")

    @cache_mode.setter
    def cache_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cache_mode", value)

    @_builtins.property
    @pulumi.getter(name="chapEnabled")
    def chap_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable iSCSI access of CHAP authentication, which currently supports both CHAP inbound authentication.  Default value: `false`.
        """
        return pulumi.get(self, "chap_enabled")

    @chap_enabled.setter
    def chap_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "chap_enabled", value)

    @_builtins.property
    @pulumi.getter(name="chapInPassword")
    def chap_in_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password for inbound authentication when the block volume enables iSCSI access to CHAP authentication. **NOTE:** When the `chap_enabled` is  `true` is,The `chap_in_password` is valid.
        """
        return pulumi.get(self, "chap_in_password")

    @chap_in_password.setter
    def chap_in_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "chap_in_password", value)

    @_builtins.property
    @pulumi.getter(name="chapInUser")
    def chap_in_user(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Inbound CHAP user. The `chap_in_user` must be 1 to 32 characters in length, and can contain letters and digits. **NOTE:** When the `chap_enabled` is  `true` is,The `chap_in_password` is valid.
        """
        return pulumi.get(self, "chap_in_user")

    @chap_in_user.setter
    def chap_in_user(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "chap_in_user", value)

    @_builtins.property
    @pulumi.getter(name="chunkSize")
    def chunk_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The Block volume storage allocation unit.  Valid values: `8192`, `16384`, `32768`, `65536`, `131072`. Default value: `32768`. Unit: `Byte`.
        """
        return pulumi.get(self, "chunk_size")

    @chunk_size.setter
    def chunk_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "chunk_size", value)

    @_builtins.property
    @pulumi.getter(name="isSourceDeletion")
    def is_source_deletion(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to delete the source data. Default value `true`. **NOTE:** When `is_source_deletion` is `true`, the data in the OSS Bucket on the cloud is also deleted when deleting the block gateway volume. Please operate with caution.
        """
        return pulumi.get(self, "is_source_deletion")

    @is_source_deletion.setter
    def is_source_deletion(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_source_deletion", value)

    @_builtins.property
    @pulumi.getter(name="localPath")
    def local_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Cache disk to local path. **NOTE:**  When the `cache_mode` is  `Cache` is,The `chap_in_password` is valid.
        """
        return pulumi.get(self, "local_path")

    @local_path.setter
    def local_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "local_path", value)

    @_builtins.property
    @pulumi.getter(name="ossBucketSsl")
    def oss_bucket_ssl(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable SSL access your OSS Buckets. Default value: `true`.
        """
        return pulumi.get(self, "oss_bucket_ssl")

    @oss_bucket_ssl.setter
    def oss_bucket_ssl(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "oss_bucket_ssl", value)

    @_builtins.property
    @pulumi.getter
    def recovery(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The recovery.
        """
        return pulumi.get(self, "recovery")

    @recovery.setter
    def recovery(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "recovery", value)

    @_builtins.property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The Volume size. Valid values: `1` to `262144`. Unit: `Byte`.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "size", value)


@pulumi.input_type
class _GatewayBlockVolumeState:
    def __init__(__self__, *,
                 cache_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 chap_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 chap_in_password: Optional[pulumi.Input[_builtins.str]] = None,
                 chap_in_user: Optional[pulumi.Input[_builtins.str]] = None,
                 chunk_size: Optional[pulumi.Input[_builtins.int]] = None,
                 gateway_block_volume_name: Optional[pulumi.Input[_builtins.str]] = None,
                 gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
                 index_id: Optional[pulumi.Input[_builtins.str]] = None,
                 is_source_deletion: Optional[pulumi.Input[_builtins.bool]] = None,
                 local_path: Optional[pulumi.Input[_builtins.str]] = None,
                 oss_bucket_name: Optional[pulumi.Input[_builtins.str]] = None,
                 oss_bucket_ssl: Optional[pulumi.Input[_builtins.bool]] = None,
                 oss_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 recovery: Optional[pulumi.Input[_builtins.bool]] = None,
                 size: Optional[pulumi.Input[_builtins.int]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering GatewayBlockVolume resources.
        :param pulumi.Input[_builtins.str] cache_mode: The Block volume set mode to cache mode. Valid values: `Cache`, `WriteThrough`.
        :param pulumi.Input[_builtins.bool] chap_enabled: Whether to enable iSCSI access of CHAP authentication, which currently supports both CHAP inbound authentication.  Default value: `false`.
        :param pulumi.Input[_builtins.str] chap_in_password: The password for inbound authentication when the block volume enables iSCSI access to CHAP authentication. **NOTE:** When the `chap_enabled` is  `true` is,The `chap_in_password` is valid.
        :param pulumi.Input[_builtins.str] chap_in_user: The Inbound CHAP user. The `chap_in_user` must be 1 to 32 characters in length, and can contain letters and digits. **NOTE:** When the `chap_enabled` is  `true` is,The `chap_in_password` is valid.
        :param pulumi.Input[_builtins.int] chunk_size: The Block volume storage allocation unit.  Valid values: `8192`, `16384`, `32768`, `65536`, `131072`. Default value: `32768`. Unit: `Byte`.
        :param pulumi.Input[_builtins.str] gateway_block_volume_name: The Block volume name. The name must be 1 to 32 characters in length, and can contain lower case letters and digits.
        :param pulumi.Input[_builtins.str] gateway_id: The Gateway ID.
        :param pulumi.Input[_builtins.str] index_id: The ID of the index.
        :param pulumi.Input[_builtins.bool] is_source_deletion: Whether to delete the source data. Default value `true`. **NOTE:** When `is_source_deletion` is `true`, the data in the OSS Bucket on the cloud is also deleted when deleting the block gateway volume. Please operate with caution.
        :param pulumi.Input[_builtins.str] local_path: The Cache disk to local path. **NOTE:**  When the `cache_mode` is  `Cache` is,The `chap_in_password` is valid.
        :param pulumi.Input[_builtins.str] oss_bucket_name: The name of the OSS Bucket.
        :param pulumi.Input[_builtins.bool] oss_bucket_ssl: Whether to enable SSL access your OSS Buckets. Default value: `true`.
        :param pulumi.Input[_builtins.str] oss_endpoint: The endpoint of the OSS Bucket.
        :param pulumi.Input[_builtins.str] protocol: The Protocol. Valid values: `iSCSI`.
        :param pulumi.Input[_builtins.bool] recovery: The recovery.
        :param pulumi.Input[_builtins.int] size: The Volume size. Valid values: `1` to `262144`. Unit: `Byte`.
        :param pulumi.Input[_builtins.str] status: The status of volume. Valid values:
        """
        if cache_mode is not None:
            pulumi.set(__self__, "cache_mode", cache_mode)
        if chap_enabled is not None:
            pulumi.set(__self__, "chap_enabled", chap_enabled)
        if chap_in_password is not None:
            pulumi.set(__self__, "chap_in_password", chap_in_password)
        if chap_in_user is not None:
            pulumi.set(__self__, "chap_in_user", chap_in_user)
        if chunk_size is not None:
            pulumi.set(__self__, "chunk_size", chunk_size)
        if gateway_block_volume_name is not None:
            pulumi.set(__self__, "gateway_block_volume_name", gateway_block_volume_name)
        if gateway_id is not None:
            pulumi.set(__self__, "gateway_id", gateway_id)
        if index_id is not None:
            pulumi.set(__self__, "index_id", index_id)
        if is_source_deletion is not None:
            pulumi.set(__self__, "is_source_deletion", is_source_deletion)
        if local_path is not None:
            pulumi.set(__self__, "local_path", local_path)
        if oss_bucket_name is not None:
            pulumi.set(__self__, "oss_bucket_name", oss_bucket_name)
        if oss_bucket_ssl is not None:
            pulumi.set(__self__, "oss_bucket_ssl", oss_bucket_ssl)
        if oss_endpoint is not None:
            pulumi.set(__self__, "oss_endpoint", oss_endpoint)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if recovery is not None:
            pulumi.set(__self__, "recovery", recovery)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="cacheMode")
    def cache_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Block volume set mode to cache mode. Valid values: `Cache`, `WriteThrough`.
        """
        return pulumi.get(self, "cache_mode")

    @cache_mode.setter
    def cache_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cache_mode", value)

    @_builtins.property
    @pulumi.getter(name="chapEnabled")
    def chap_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable iSCSI access of CHAP authentication, which currently supports both CHAP inbound authentication.  Default value: `false`.
        """
        return pulumi.get(self, "chap_enabled")

    @chap_enabled.setter
    def chap_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "chap_enabled", value)

    @_builtins.property
    @pulumi.getter(name="chapInPassword")
    def chap_in_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password for inbound authentication when the block volume enables iSCSI access to CHAP authentication. **NOTE:** When the `chap_enabled` is  `true` is,The `chap_in_password` is valid.
        """
        return pulumi.get(self, "chap_in_password")

    @chap_in_password.setter
    def chap_in_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "chap_in_password", value)

    @_builtins.property
    @pulumi.getter(name="chapInUser")
    def chap_in_user(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Inbound CHAP user. The `chap_in_user` must be 1 to 32 characters in length, and can contain letters and digits. **NOTE:** When the `chap_enabled` is  `true` is,The `chap_in_password` is valid.
        """
        return pulumi.get(self, "chap_in_user")

    @chap_in_user.setter
    def chap_in_user(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "chap_in_user", value)

    @_builtins.property
    @pulumi.getter(name="chunkSize")
    def chunk_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The Block volume storage allocation unit.  Valid values: `8192`, `16384`, `32768`, `65536`, `131072`. Default value: `32768`. Unit: `Byte`.
        """
        return pulumi.get(self, "chunk_size")

    @chunk_size.setter
    def chunk_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "chunk_size", value)

    @_builtins.property
    @pulumi.getter(name="gatewayBlockVolumeName")
    def gateway_block_volume_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Block volume name. The name must be 1 to 32 characters in length, and can contain lower case letters and digits.
        """
        return pulumi.get(self, "gateway_block_volume_name")

    @gateway_block_volume_name.setter
    def gateway_block_volume_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gateway_block_volume_name", value)

    @_builtins.property
    @pulumi.getter(name="gatewayId")
    def gateway_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Gateway ID.
        """
        return pulumi.get(self, "gateway_id")

    @gateway_id.setter
    def gateway_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gateway_id", value)

    @_builtins.property
    @pulumi.getter(name="indexId")
    def index_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the index.
        """
        return pulumi.get(self, "index_id")

    @index_id.setter
    def index_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "index_id", value)

    @_builtins.property
    @pulumi.getter(name="isSourceDeletion")
    def is_source_deletion(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to delete the source data. Default value `true`. **NOTE:** When `is_source_deletion` is `true`, the data in the OSS Bucket on the cloud is also deleted when deleting the block gateway volume. Please operate with caution.
        """
        return pulumi.get(self, "is_source_deletion")

    @is_source_deletion.setter
    def is_source_deletion(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_source_deletion", value)

    @_builtins.property
    @pulumi.getter(name="localPath")
    def local_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Cache disk to local path. **NOTE:**  When the `cache_mode` is  `Cache` is,The `chap_in_password` is valid.
        """
        return pulumi.get(self, "local_path")

    @local_path.setter
    def local_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "local_path", value)

    @_builtins.property
    @pulumi.getter(name="ossBucketName")
    def oss_bucket_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the OSS Bucket.
        """
        return pulumi.get(self, "oss_bucket_name")

    @oss_bucket_name.setter
    def oss_bucket_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "oss_bucket_name", value)

    @_builtins.property
    @pulumi.getter(name="ossBucketSsl")
    def oss_bucket_ssl(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable SSL access your OSS Buckets. Default value: `true`.
        """
        return pulumi.get(self, "oss_bucket_ssl")

    @oss_bucket_ssl.setter
    def oss_bucket_ssl(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "oss_bucket_ssl", value)

    @_builtins.property
    @pulumi.getter(name="ossEndpoint")
    def oss_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The endpoint of the OSS Bucket.
        """
        return pulumi.get(self, "oss_endpoint")

    @oss_endpoint.setter
    def oss_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "oss_endpoint", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Protocol. Valid values: `iSCSI`.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter
    def recovery(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The recovery.
        """
        return pulumi.get(self, "recovery")

    @recovery.setter
    def recovery(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "recovery", value)

    @_builtins.property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The Volume size. Valid values: `1` to `262144`. Unit: `Byte`.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "size", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of volume. Valid values:
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("alicloud:cloudstoragegateway/gatewayBlockVolume:GatewayBlockVolume")
class GatewayBlockVolume(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cache_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 chap_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 chap_in_password: Optional[pulumi.Input[_builtins.str]] = None,
                 chap_in_user: Optional[pulumi.Input[_builtins.str]] = None,
                 chunk_size: Optional[pulumi.Input[_builtins.int]] = None,
                 gateway_block_volume_name: Optional[pulumi.Input[_builtins.str]] = None,
                 gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
                 is_source_deletion: Optional[pulumi.Input[_builtins.bool]] = None,
                 local_path: Optional[pulumi.Input[_builtins.str]] = None,
                 oss_bucket_name: Optional[pulumi.Input[_builtins.str]] = None,
                 oss_bucket_ssl: Optional[pulumi.Input[_builtins.bool]] = None,
                 oss_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 recovery: Optional[pulumi.Input[_builtins.bool]] = None,
                 size: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Provides a Cloud Storage Gateway Gateway Block Volume resource.

        For information about Cloud Storage Gateway Gateway Block Volume and how to use it, see [What is Gateway Block Volume](https://www.alibabacloud.com/help/en/cloud-storage-gateway/latest/creategatewayblockvolume).

        > **NOTE:** Available since v1.144.0.

        ## Import

        Cloud Storage Gateway Gateway Block Volume can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cloudstoragegateway/gatewayBlockVolume:GatewayBlockVolume example <gateway_id>:<index_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cache_mode: The Block volume set mode to cache mode. Valid values: `Cache`, `WriteThrough`.
        :param pulumi.Input[_builtins.bool] chap_enabled: Whether to enable iSCSI access of CHAP authentication, which currently supports both CHAP inbound authentication.  Default value: `false`.
        :param pulumi.Input[_builtins.str] chap_in_password: The password for inbound authentication when the block volume enables iSCSI access to CHAP authentication. **NOTE:** When the `chap_enabled` is  `true` is,The `chap_in_password` is valid.
        :param pulumi.Input[_builtins.str] chap_in_user: The Inbound CHAP user. The `chap_in_user` must be 1 to 32 characters in length, and can contain letters and digits. **NOTE:** When the `chap_enabled` is  `true` is,The `chap_in_password` is valid.
        :param pulumi.Input[_builtins.int] chunk_size: The Block volume storage allocation unit.  Valid values: `8192`, `16384`, `32768`, `65536`, `131072`. Default value: `32768`. Unit: `Byte`.
        :param pulumi.Input[_builtins.str] gateway_block_volume_name: The Block volume name. The name must be 1 to 32 characters in length, and can contain lower case letters and digits.
        :param pulumi.Input[_builtins.str] gateway_id: The Gateway ID.
        :param pulumi.Input[_builtins.bool] is_source_deletion: Whether to delete the source data. Default value `true`. **NOTE:** When `is_source_deletion` is `true`, the data in the OSS Bucket on the cloud is also deleted when deleting the block gateway volume. Please operate with caution.
        :param pulumi.Input[_builtins.str] local_path: The Cache disk to local path. **NOTE:**  When the `cache_mode` is  `Cache` is,The `chap_in_password` is valid.
        :param pulumi.Input[_builtins.str] oss_bucket_name: The name of the OSS Bucket.
        :param pulumi.Input[_builtins.bool] oss_bucket_ssl: Whether to enable SSL access your OSS Buckets. Default value: `true`.
        :param pulumi.Input[_builtins.str] oss_endpoint: The endpoint of the OSS Bucket.
        :param pulumi.Input[_builtins.str] protocol: The Protocol. Valid values: `iSCSI`.
        :param pulumi.Input[_builtins.bool] recovery: The recovery.
        :param pulumi.Input[_builtins.int] size: The Volume size. Valid values: `1` to `262144`. Unit: `Byte`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GatewayBlockVolumeArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Cloud Storage Gateway Gateway Block Volume resource.

        For information about Cloud Storage Gateway Gateway Block Volume and how to use it, see [What is Gateway Block Volume](https://www.alibabacloud.com/help/en/cloud-storage-gateway/latest/creategatewayblockvolume).

        > **NOTE:** Available since v1.144.0.

        ## Import

        Cloud Storage Gateway Gateway Block Volume can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cloudstoragegateway/gatewayBlockVolume:GatewayBlockVolume example <gateway_id>:<index_id>
        ```

        :param str resource_name: The name of the resource.
        :param GatewayBlockVolumeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GatewayBlockVolumeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cache_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 chap_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 chap_in_password: Optional[pulumi.Input[_builtins.str]] = None,
                 chap_in_user: Optional[pulumi.Input[_builtins.str]] = None,
                 chunk_size: Optional[pulumi.Input[_builtins.int]] = None,
                 gateway_block_volume_name: Optional[pulumi.Input[_builtins.str]] = None,
                 gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
                 is_source_deletion: Optional[pulumi.Input[_builtins.bool]] = None,
                 local_path: Optional[pulumi.Input[_builtins.str]] = None,
                 oss_bucket_name: Optional[pulumi.Input[_builtins.str]] = None,
                 oss_bucket_ssl: Optional[pulumi.Input[_builtins.bool]] = None,
                 oss_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 recovery: Optional[pulumi.Input[_builtins.bool]] = None,
                 size: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GatewayBlockVolumeArgs.__new__(GatewayBlockVolumeArgs)

            __props__.__dict__["cache_mode"] = cache_mode
            __props__.__dict__["chap_enabled"] = chap_enabled
            __props__.__dict__["chap_in_password"] = chap_in_password
            __props__.__dict__["chap_in_user"] = chap_in_user
            __props__.__dict__["chunk_size"] = chunk_size
            if gateway_block_volume_name is None and not opts.urn:
                raise TypeError("Missing required property 'gateway_block_volume_name'")
            __props__.__dict__["gateway_block_volume_name"] = gateway_block_volume_name
            if gateway_id is None and not opts.urn:
                raise TypeError("Missing required property 'gateway_id'")
            __props__.__dict__["gateway_id"] = gateway_id
            __props__.__dict__["is_source_deletion"] = is_source_deletion
            __props__.__dict__["local_path"] = local_path
            if oss_bucket_name is None and not opts.urn:
                raise TypeError("Missing required property 'oss_bucket_name'")
            __props__.__dict__["oss_bucket_name"] = oss_bucket_name
            __props__.__dict__["oss_bucket_ssl"] = oss_bucket_ssl
            if oss_endpoint is None and not opts.urn:
                raise TypeError("Missing required property 'oss_endpoint'")
            __props__.__dict__["oss_endpoint"] = oss_endpoint
            if protocol is None and not opts.urn:
                raise TypeError("Missing required property 'protocol'")
            __props__.__dict__["protocol"] = protocol
            __props__.__dict__["recovery"] = recovery
            __props__.__dict__["size"] = size
            __props__.__dict__["index_id"] = None
            __props__.__dict__["status"] = None
        super(GatewayBlockVolume, __self__).__init__(
            'alicloud:cloudstoragegateway/gatewayBlockVolume:GatewayBlockVolume',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cache_mode: Optional[pulumi.Input[_builtins.str]] = None,
            chap_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            chap_in_password: Optional[pulumi.Input[_builtins.str]] = None,
            chap_in_user: Optional[pulumi.Input[_builtins.str]] = None,
            chunk_size: Optional[pulumi.Input[_builtins.int]] = None,
            gateway_block_volume_name: Optional[pulumi.Input[_builtins.str]] = None,
            gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
            index_id: Optional[pulumi.Input[_builtins.str]] = None,
            is_source_deletion: Optional[pulumi.Input[_builtins.bool]] = None,
            local_path: Optional[pulumi.Input[_builtins.str]] = None,
            oss_bucket_name: Optional[pulumi.Input[_builtins.str]] = None,
            oss_bucket_ssl: Optional[pulumi.Input[_builtins.bool]] = None,
            oss_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            protocol: Optional[pulumi.Input[_builtins.str]] = None,
            recovery: Optional[pulumi.Input[_builtins.bool]] = None,
            size: Optional[pulumi.Input[_builtins.int]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None) -> 'GatewayBlockVolume':
        """
        Get an existing GatewayBlockVolume resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cache_mode: The Block volume set mode to cache mode. Valid values: `Cache`, `WriteThrough`.
        :param pulumi.Input[_builtins.bool] chap_enabled: Whether to enable iSCSI access of CHAP authentication, which currently supports both CHAP inbound authentication.  Default value: `false`.
        :param pulumi.Input[_builtins.str] chap_in_password: The password for inbound authentication when the block volume enables iSCSI access to CHAP authentication. **NOTE:** When the `chap_enabled` is  `true` is,The `chap_in_password` is valid.
        :param pulumi.Input[_builtins.str] chap_in_user: The Inbound CHAP user. The `chap_in_user` must be 1 to 32 characters in length, and can contain letters and digits. **NOTE:** When the `chap_enabled` is  `true` is,The `chap_in_password` is valid.
        :param pulumi.Input[_builtins.int] chunk_size: The Block volume storage allocation unit.  Valid values: `8192`, `16384`, `32768`, `65536`, `131072`. Default value: `32768`. Unit: `Byte`.
        :param pulumi.Input[_builtins.str] gateway_block_volume_name: The Block volume name. The name must be 1 to 32 characters in length, and can contain lower case letters and digits.
        :param pulumi.Input[_builtins.str] gateway_id: The Gateway ID.
        :param pulumi.Input[_builtins.str] index_id: The ID of the index.
        :param pulumi.Input[_builtins.bool] is_source_deletion: Whether to delete the source data. Default value `true`. **NOTE:** When `is_source_deletion` is `true`, the data in the OSS Bucket on the cloud is also deleted when deleting the block gateway volume. Please operate with caution.
        :param pulumi.Input[_builtins.str] local_path: The Cache disk to local path. **NOTE:**  When the `cache_mode` is  `Cache` is,The `chap_in_password` is valid.
        :param pulumi.Input[_builtins.str] oss_bucket_name: The name of the OSS Bucket.
        :param pulumi.Input[_builtins.bool] oss_bucket_ssl: Whether to enable SSL access your OSS Buckets. Default value: `true`.
        :param pulumi.Input[_builtins.str] oss_endpoint: The endpoint of the OSS Bucket.
        :param pulumi.Input[_builtins.str] protocol: The Protocol. Valid values: `iSCSI`.
        :param pulumi.Input[_builtins.bool] recovery: The recovery.
        :param pulumi.Input[_builtins.int] size: The Volume size. Valid values: `1` to `262144`. Unit: `Byte`.
        :param pulumi.Input[_builtins.str] status: The status of volume. Valid values:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GatewayBlockVolumeState.__new__(_GatewayBlockVolumeState)

        __props__.__dict__["cache_mode"] = cache_mode
        __props__.__dict__["chap_enabled"] = chap_enabled
        __props__.__dict__["chap_in_password"] = chap_in_password
        __props__.__dict__["chap_in_user"] = chap_in_user
        __props__.__dict__["chunk_size"] = chunk_size
        __props__.__dict__["gateway_block_volume_name"] = gateway_block_volume_name
        __props__.__dict__["gateway_id"] = gateway_id
        __props__.__dict__["index_id"] = index_id
        __props__.__dict__["is_source_deletion"] = is_source_deletion
        __props__.__dict__["local_path"] = local_path
        __props__.__dict__["oss_bucket_name"] = oss_bucket_name
        __props__.__dict__["oss_bucket_ssl"] = oss_bucket_ssl
        __props__.__dict__["oss_endpoint"] = oss_endpoint
        __props__.__dict__["protocol"] = protocol
        __props__.__dict__["recovery"] = recovery
        __props__.__dict__["size"] = size
        __props__.__dict__["status"] = status
        return GatewayBlockVolume(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="cacheMode")
    def cache_mode(self) -> pulumi.Output[_builtins.str]:
        """
        The Block volume set mode to cache mode. Valid values: `Cache`, `WriteThrough`.
        """
        return pulumi.get(self, "cache_mode")

    @_builtins.property
    @pulumi.getter(name="chapEnabled")
    def chap_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether to enable iSCSI access of CHAP authentication, which currently supports both CHAP inbound authentication.  Default value: `false`.
        """
        return pulumi.get(self, "chap_enabled")

    @_builtins.property
    @pulumi.getter(name="chapInPassword")
    def chap_in_password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The password for inbound authentication when the block volume enables iSCSI access to CHAP authentication. **NOTE:** When the `chap_enabled` is  `true` is,The `chap_in_password` is valid.
        """
        return pulumi.get(self, "chap_in_password")

    @_builtins.property
    @pulumi.getter(name="chapInUser")
    def chap_in_user(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Inbound CHAP user. The `chap_in_user` must be 1 to 32 characters in length, and can contain letters and digits. **NOTE:** When the `chap_enabled` is  `true` is,The `chap_in_password` is valid.
        """
        return pulumi.get(self, "chap_in_user")

    @_builtins.property
    @pulumi.getter(name="chunkSize")
    def chunk_size(self) -> pulumi.Output[_builtins.int]:
        """
        The Block volume storage allocation unit.  Valid values: `8192`, `16384`, `32768`, `65536`, `131072`. Default value: `32768`. Unit: `Byte`.
        """
        return pulumi.get(self, "chunk_size")

    @_builtins.property
    @pulumi.getter(name="gatewayBlockVolumeName")
    def gateway_block_volume_name(self) -> pulumi.Output[_builtins.str]:
        """
        The Block volume name. The name must be 1 to 32 characters in length, and can contain lower case letters and digits.
        """
        return pulumi.get(self, "gateway_block_volume_name")

    @_builtins.property
    @pulumi.getter(name="gatewayId")
    def gateway_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Gateway ID.
        """
        return pulumi.get(self, "gateway_id")

    @_builtins.property
    @pulumi.getter(name="indexId")
    def index_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the index.
        """
        return pulumi.get(self, "index_id")

    @_builtins.property
    @pulumi.getter(name="isSourceDeletion")
    def is_source_deletion(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to delete the source data. Default value `true`. **NOTE:** When `is_source_deletion` is `true`, the data in the OSS Bucket on the cloud is also deleted when deleting the block gateway volume. Please operate with caution.
        """
        return pulumi.get(self, "is_source_deletion")

    @_builtins.property
    @pulumi.getter(name="localPath")
    def local_path(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Cache disk to local path. **NOTE:**  When the `cache_mode` is  `Cache` is,The `chap_in_password` is valid.
        """
        return pulumi.get(self, "local_path")

    @_builtins.property
    @pulumi.getter(name="ossBucketName")
    def oss_bucket_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the OSS Bucket.
        """
        return pulumi.get(self, "oss_bucket_name")

    @_builtins.property
    @pulumi.getter(name="ossBucketSsl")
    def oss_bucket_ssl(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether to enable SSL access your OSS Buckets. Default value: `true`.
        """
        return pulumi.get(self, "oss_bucket_ssl")

    @_builtins.property
    @pulumi.getter(name="ossEndpoint")
    def oss_endpoint(self) -> pulumi.Output[_builtins.str]:
        """
        The endpoint of the OSS Bucket.
        """
        return pulumi.get(self, "oss_endpoint")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[_builtins.str]:
        """
        The Protocol. Valid values: `iSCSI`.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter
    def recovery(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        The recovery.
        """
        return pulumi.get(self, "recovery")

    @_builtins.property
    @pulumi.getter
    def size(self) -> pulumi.Output[_builtins.int]:
        """
        The Volume size. Valid values: `1` to `262144`. Unit: `Byte`.
        """
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of volume. Valid values:
        """
        return pulumi.get(self, "status")

