# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['EdgeKubernetesArgs', 'EdgeKubernetes']

@pulumi.input_type
class EdgeKubernetesArgs:
    def __init__(__self__, *,
                 worker_instance_types: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 worker_number: pulumi.Input[_builtins.int],
                 worker_vswitch_ids: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 addons: Optional[pulumi.Input[Sequence[pulumi.Input['EdgeKubernetesAddonArgs']]]] = None,
                 availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 client_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 client_key: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_ca_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_spec: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 install_cloud_monitor: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_enterprise_security_group: Optional[pulumi.Input[_builtins.bool]] = None,
                 key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 kube_config: Optional[pulumi.Input[_builtins.str]] = None,
                 load_balancer_spec: Optional[pulumi.Input[_builtins.str]] = None,
                 log_config: Optional[pulumi.Input['EdgeKubernetesLogConfigArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 new_nat_gateway: Optional[pulumi.Input[_builtins.bool]] = None,
                 node_cidr_mask: Optional[pulumi.Input[_builtins.int]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 pod_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 proxy_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 rds_instances: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 retain_resources: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 runtime: Optional[pulumi.Input['EdgeKubernetesRuntimeArgs']] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 service_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_set_certificate_authority: Optional[pulumi.Input[_builtins.bool]] = None,
                 slb_internet_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 user_data: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 worker_data_disks: Optional[pulumi.Input[Sequence[pulumi.Input['EdgeKubernetesWorkerDataDiskArgs']]]] = None,
                 worker_disk_category: Optional[pulumi.Input[_builtins.str]] = None,
                 worker_disk_performance_level: Optional[pulumi.Input[_builtins.str]] = None,
                 worker_disk_size: Optional[pulumi.Input[_builtins.int]] = None,
                 worker_disk_snapshot_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 worker_instance_charge_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a EdgeKubernetes resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] worker_instance_types: The instance types of worker node, you can set multiple types to avoid NoStock of a certain type.
        :param pulumi.Input[_builtins.int] worker_number: The cloud worker node number of the edge kubernetes cluster. Default to 1. It is limited up to 50 and if you want to enlarge it, please apply white list or contact with us.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] worker_vswitch_ids: The vswitches used by workers.
        :param pulumi.Input[Sequence[pulumi.Input['EdgeKubernetesAddonArgs']]] addons: The addon you want to install in cluster. See `addons` below.
        :param pulumi.Input[_builtins.str] availability_zone: The ID of availability zone.
        :param pulumi.Input[_builtins.str] client_cert: From version 1.248.0, new DataSource `cs_get_cluster_credential` is recommended to manage cluster's kubeconfig, you can also save the certificate_authority.client_cert attribute content of new DataSource `cs_get_cluster_credential` to an appropriate path(like ~/.kube/client-cert.pem) for replace it.
        :param pulumi.Input[_builtins.str] client_key: From version 1.248.0, new DataSource `cs_get_cluster_credential` is recommended to manage cluster's kubeconfig, you can also save the certificate_authority.client_key attribute content of new DataSource `cs_get_cluster_credential` to an appropriate path(like ~/.kube/client-key.pem) for replace it.
        :param pulumi.Input[_builtins.str] cluster_ca_cert: From version 1.248.0, new DataSource `cs_get_cluster_credential` is recommended to manage cluster's kubeconfig, you can also save the certificate_authority.cluster_cert attribute content of new DataSource `cs_get_cluster_credential` to an appropriate path(like ~/.kube/cluster-ca-cert.pem) for replace it.
               
               *Removed params*
        :param pulumi.Input[_builtins.str] cluster_spec: The cluster specifications of kubernetes cluster,which can be empty. Valid values:
               * ack.standard : Standard edge clusters.
               * ack.pro.small : Professional edge clusters.
        :param pulumi.Input[_builtins.bool] deletion_protection: Whether to enable cluster deletion protection.
        :param pulumi.Input[_builtins.bool] install_cloud_monitor: Install cloud monitor agent on ECS. default: `true`.
        :param pulumi.Input[_builtins.bool] is_enterprise_security_group: Enable to create advanced security group. default: false. See [Advanced security group](https://www.alibabacloud.com/help/doc-detail/120621.htm).
        :param pulumi.Input[_builtins.str] key_name: The keypair of ssh login cluster node, you have to create it first. You have to specify one of `password` `key_name` `kms_encrypted_password` fields.
        :param pulumi.Input[_builtins.str] kube_config: The path of kube config, like ~/.kube/config. Please use the attribute output_file of new DataSource `cs_get_cluster_credential` to replace it.
        :param pulumi.Input[_builtins.str] load_balancer_spec: The cluster api server load balance instance specification. For more information on how to select a LB instance specification, see [SLB instance overview](https://help.aliyun.com/document_detail/85931.html).
               ->NOTE: If you want to use `Flannel` as CNI network plugin, You need to specific the `pod_cidr` field and addons with `flannel`.
               
               *Worker params*
        :param pulumi.Input['EdgeKubernetesLogConfigArgs'] log_config: A list of one element containing information about the associated log store. See `log_config` below.
        :param pulumi.Input[_builtins.str] name: The kubernetes cluster's name. It is unique in one Alicloud account.
        :param pulumi.Input[_builtins.bool] new_nat_gateway: Whether to create a new nat gateway while creating kubernetes cluster. Default to true. Then openapi in Alibaba Cloud are not all on intranet, So turn this option on is a good choice.
        :param pulumi.Input[_builtins.int] node_cidr_mask: The node cidr block to specific how many pods can run on single node. 24-28 is allowed. 24 means 2^(32-24)-1=255 and the node can run at most 255 pods. default: 24
        :param pulumi.Input[_builtins.str] password: The password of ssh login cluster node. You have to specify one of `password`, `key_name` `kms_encrypted_password` fields.
        :param pulumi.Input[_builtins.str] pod_cidr: [Flannel Specific] The CIDR block for the pod network when using Flannel.
        :param pulumi.Input[_builtins.str] proxy_mode: Proxy mode is option of kube-proxy. options: iptables|ipvs. default: ipvs.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] rds_instances: RDS instance list, You can choose which RDS instances whitelist to add instances to.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group,by default these cloud resources are automatically assigned to the default resource group.
        :param pulumi.Input['EdgeKubernetesRuntimeArgs'] runtime: The runtime of containers. If you select another container runtime, see [Comparison of Docker, containerd, and Sandboxed-Container](https://www.alibabacloud.com/help/doc-detail/160313.htm). See `runtime` below.
        :param pulumi.Input[_builtins.str] security_group_id: The ID of the security group to which the ECS instances in the cluster belong. If it is not specified, a new Security group will be built.
        :param pulumi.Input[_builtins.str] service_cidr: The CIDR block for the service network. It cannot be duplicated with the VPC CIDR and CIDR used by Kubernetes cluster in VPC, cannot be modified after creation.
        :param pulumi.Input[_builtins.bool] skip_set_certificate_authority: Configure whether to save certificate authority data for your cluster to attribute `certificate_authority`. For cluster security, recommended configuration as `true`. Will be removed with attribute certificate_authority removed.
               
               *Network params*
        :param pulumi.Input[_builtins.bool] slb_internet_enabled: Whether to create internet load balancer for API Server. Default to true.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Default nil, A map of tags assigned to the kubernetes cluster and work node.
        :param pulumi.Input[_builtins.str] user_data: Windows instances support batch and PowerShell scripts. If your script file is larger than 1 KB, we recommend that you upload the script to Object Storage Service (OSS) and pull it through the internal endpoint of your OSS bucket.
        :param pulumi.Input[_builtins.str] version: Desired Kubernetes version. If you do not specify a value, the latest available version at resource creation is used and no upgrades will occur except you set a higher version number. The value must be configured and increased to upgrade the version when desired. Downgrades are not supported by ACK.
        :param pulumi.Input[Sequence[pulumi.Input['EdgeKubernetesWorkerDataDiskArgs']]] worker_data_disks: The data disk configurations of worker nodes, such as the disk type and disk size. See `worker_data_disks` below.
        :param pulumi.Input[_builtins.str] worker_disk_category: The system disk category of worker node. Its valid value are `cloud_efficiency`, `cloud_ssd` and `cloud_essd` and . Default to `cloud_efficiency`.
        :param pulumi.Input[_builtins.str] worker_disk_performance_level: Worker node system disk performance level, when `worker_disk_category` values `cloud_essd`, the optional values are `PL0`, `PL1`, `PL2` or `PL3`, but the specific performance level is related to the disk capacity. For more information, see [Enhanced SSDs](https://www.alibabacloud.com/help/doc-detail/122389.htm). Default is `PL1`.
        :param pulumi.Input[_builtins.int] worker_disk_size: The system disk size of worker node. Its valid value range [20~32768] in GB. Default to 40.
        :param pulumi.Input[_builtins.str] worker_disk_snapshot_policy_id: Worker node system disk auto snapshot policy.
               
               *Computed params*
               
               You can set some file paths to save kube_config information, but this way is cumbersome. Since version 1.105.0, we've written it to tf state file. About its use，see export attribute certificate_authority. From version 1.187.0+, new DataSource `cs_get_cluster_credential` is recommended to manage cluster's kube_config.
        :param pulumi.Input[_builtins.str] worker_instance_charge_type: Worker payment type, its valid value is `PostPaid`. Defaults to `PostPaid`. More charge details in [ACK@edge charge](https://help.aliyun.com/document_detail/178718.html).
        """
        pulumi.set(__self__, "worker_instance_types", worker_instance_types)
        pulumi.set(__self__, "worker_number", worker_number)
        pulumi.set(__self__, "worker_vswitch_ids", worker_vswitch_ids)
        if addons is not None:
            pulumi.set(__self__, "addons", addons)
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if client_cert is not None:
            warnings.warn("""Field 'client_cert' has been deprecated from provider version 1.248.0. From version 1.248.0, new DataSource 'alicloud_cs_cluster_credential' is recommended to manage cluster's kubeconfig, you can also save the 'certificate_authority.client_cert' attribute content of new DataSource 'alicloud_cs_cluster_credential' to an appropriate path(like ~/.kube/client-cert.pem) for replace it.""", DeprecationWarning)
            pulumi.log.warn("""client_cert is deprecated: Field 'client_cert' has been deprecated from provider version 1.248.0. From version 1.248.0, new DataSource 'alicloud_cs_cluster_credential' is recommended to manage cluster's kubeconfig, you can also save the 'certificate_authority.client_cert' attribute content of new DataSource 'alicloud_cs_cluster_credential' to an appropriate path(like ~/.kube/client-cert.pem) for replace it.""")
        if client_cert is not None:
            pulumi.set(__self__, "client_cert", client_cert)
        if client_key is not None:
            warnings.warn("""Field 'client_key' has been deprecated from provider version 1.248.0. From version 1.248.0, new DataSource 'alicloud_cs_cluster_credential' is recommended to manage cluster's kubeconfig, you can also save the 'certificate_authority.client_key' attribute content of new DataSource 'alicloud_cs_cluster_credential' to an appropriate path(like ~/.kube/client-key.pem) for replace it.""", DeprecationWarning)
            pulumi.log.warn("""client_key is deprecated: Field 'client_key' has been deprecated from provider version 1.248.0. From version 1.248.0, new DataSource 'alicloud_cs_cluster_credential' is recommended to manage cluster's kubeconfig, you can also save the 'certificate_authority.client_key' attribute content of new DataSource 'alicloud_cs_cluster_credential' to an appropriate path(like ~/.kube/client-key.pem) for replace it.""")
        if client_key is not None:
            pulumi.set(__self__, "client_key", client_key)
        if cluster_ca_cert is not None:
            warnings.warn("""Field 'cluster_ca_cert' has been deprecated from provider version 1.248.0. From version 1.248.0, new DataSource 'alicloud_cs_cluster_credential' is recommended to manage cluster's kubeconfig, you can also save the 'certificate_authority.cluster_cert' attribute content of new DataSource 'alicloud_cs_cluster_credential' to an appropriate path(like ~/.kube/cluster-ca-cert.pem) for replace it.""", DeprecationWarning)
            pulumi.log.warn("""cluster_ca_cert is deprecated: Field 'cluster_ca_cert' has been deprecated from provider version 1.248.0. From version 1.248.0, new DataSource 'alicloud_cs_cluster_credential' is recommended to manage cluster's kubeconfig, you can also save the 'certificate_authority.cluster_cert' attribute content of new DataSource 'alicloud_cs_cluster_credential' to an appropriate path(like ~/.kube/cluster-ca-cert.pem) for replace it.""")
        if cluster_ca_cert is not None:
            pulumi.set(__self__, "cluster_ca_cert", cluster_ca_cert)
        if cluster_spec is not None:
            pulumi.set(__self__, "cluster_spec", cluster_spec)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if install_cloud_monitor is not None:
            pulumi.set(__self__, "install_cloud_monitor", install_cloud_monitor)
        if is_enterprise_security_group is not None:
            pulumi.set(__self__, "is_enterprise_security_group", is_enterprise_security_group)
        if key_name is not None:
            pulumi.set(__self__, "key_name", key_name)
        if kube_config is not None:
            warnings.warn("""Field 'kube_config' has been deprecated from provider version 1.187.0. Please use the attribute 'output_file' of new DataSource 'alicloud_cs_cluster_credential' to replace it.""", DeprecationWarning)
            pulumi.log.warn("""kube_config is deprecated: Field 'kube_config' has been deprecated from provider version 1.187.0. Please use the attribute 'output_file' of new DataSource 'alicloud_cs_cluster_credential' to replace it.""")
        if kube_config is not None:
            pulumi.set(__self__, "kube_config", kube_config)
        if load_balancer_spec is not None:
            pulumi.set(__self__, "load_balancer_spec", load_balancer_spec)
        if log_config is not None:
            warnings.warn("""Field 'log_config' has been removed from provider version 1.103.0. New field 'addons' replaces it.""", DeprecationWarning)
            pulumi.log.warn("""log_config is deprecated: Field 'log_config' has been removed from provider version 1.103.0. New field 'addons' replaces it.""")
        if log_config is not None:
            pulumi.set(__self__, "log_config", log_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if name_prefix is not None:
            pulumi.set(__self__, "name_prefix", name_prefix)
        if new_nat_gateway is not None:
            pulumi.set(__self__, "new_nat_gateway", new_nat_gateway)
        if node_cidr_mask is not None:
            pulumi.set(__self__, "node_cidr_mask", node_cidr_mask)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if pod_cidr is not None:
            pulumi.set(__self__, "pod_cidr", pod_cidr)
        if proxy_mode is not None:
            pulumi.set(__self__, "proxy_mode", proxy_mode)
        if rds_instances is not None:
            pulumi.set(__self__, "rds_instances", rds_instances)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if retain_resources is not None:
            pulumi.set(__self__, "retain_resources", retain_resources)
        if runtime is not None:
            pulumi.set(__self__, "runtime", runtime)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if service_cidr is not None:
            pulumi.set(__self__, "service_cidr", service_cidr)
        if skip_set_certificate_authority is not None:
            pulumi.set(__self__, "skip_set_certificate_authority", skip_set_certificate_authority)
        if slb_internet_enabled is not None:
            pulumi.set(__self__, "slb_internet_enabled", slb_internet_enabled)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if worker_data_disks is not None:
            pulumi.set(__self__, "worker_data_disks", worker_data_disks)
        if worker_disk_category is not None:
            pulumi.set(__self__, "worker_disk_category", worker_disk_category)
        if worker_disk_performance_level is not None:
            pulumi.set(__self__, "worker_disk_performance_level", worker_disk_performance_level)
        if worker_disk_size is not None:
            pulumi.set(__self__, "worker_disk_size", worker_disk_size)
        if worker_disk_snapshot_policy_id is not None:
            pulumi.set(__self__, "worker_disk_snapshot_policy_id", worker_disk_snapshot_policy_id)
        if worker_instance_charge_type is not None:
            pulumi.set(__self__, "worker_instance_charge_type", worker_instance_charge_type)

    @_builtins.property
    @pulumi.getter(name="workerInstanceTypes")
    def worker_instance_types(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The instance types of worker node, you can set multiple types to avoid NoStock of a certain type.
        """
        return pulumi.get(self, "worker_instance_types")

    @worker_instance_types.setter
    def worker_instance_types(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "worker_instance_types", value)

    @_builtins.property
    @pulumi.getter(name="workerNumber")
    def worker_number(self) -> pulumi.Input[_builtins.int]:
        """
        The cloud worker node number of the edge kubernetes cluster. Default to 1. It is limited up to 50 and if you want to enlarge it, please apply white list or contact with us.
        """
        return pulumi.get(self, "worker_number")

    @worker_number.setter
    def worker_number(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "worker_number", value)

    @_builtins.property
    @pulumi.getter(name="workerVswitchIds")
    def worker_vswitch_ids(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The vswitches used by workers.
        """
        return pulumi.get(self, "worker_vswitch_ids")

    @worker_vswitch_ids.setter
    def worker_vswitch_ids(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "worker_vswitch_ids", value)

    @_builtins.property
    @pulumi.getter
    def addons(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EdgeKubernetesAddonArgs']]]]:
        """
        The addon you want to install in cluster. See `addons` below.
        """
        return pulumi.get(self, "addons")

    @addons.setter
    def addons(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EdgeKubernetesAddonArgs']]]]):
        pulumi.set(self, "addons", value)

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of availability zone.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "availability_zone", value)

    @_builtins.property
    @pulumi.getter(name="clientCert")
    @_utilities.deprecated("""Field 'client_cert' has been deprecated from provider version 1.248.0. From version 1.248.0, new DataSource 'alicloud_cs_cluster_credential' is recommended to manage cluster's kubeconfig, you can also save the 'certificate_authority.client_cert' attribute content of new DataSource 'alicloud_cs_cluster_credential' to an appropriate path(like ~/.kube/client-cert.pem) for replace it.""")
    def client_cert(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        From version 1.248.0, new DataSource `cs_get_cluster_credential` is recommended to manage cluster's kubeconfig, you can also save the certificate_authority.client_cert attribute content of new DataSource `cs_get_cluster_credential` to an appropriate path(like ~/.kube/client-cert.pem) for replace it.
        """
        return pulumi.get(self, "client_cert")

    @client_cert.setter
    def client_cert(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_cert", value)

    @_builtins.property
    @pulumi.getter(name="clientKey")
    @_utilities.deprecated("""Field 'client_key' has been deprecated from provider version 1.248.0. From version 1.248.0, new DataSource 'alicloud_cs_cluster_credential' is recommended to manage cluster's kubeconfig, you can also save the 'certificate_authority.client_key' attribute content of new DataSource 'alicloud_cs_cluster_credential' to an appropriate path(like ~/.kube/client-key.pem) for replace it.""")
    def client_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        From version 1.248.0, new DataSource `cs_get_cluster_credential` is recommended to manage cluster's kubeconfig, you can also save the certificate_authority.client_key attribute content of new DataSource `cs_get_cluster_credential` to an appropriate path(like ~/.kube/client-key.pem) for replace it.
        """
        return pulumi.get(self, "client_key")

    @client_key.setter
    def client_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_key", value)

    @_builtins.property
    @pulumi.getter(name="clusterCaCert")
    @_utilities.deprecated("""Field 'cluster_ca_cert' has been deprecated from provider version 1.248.0. From version 1.248.0, new DataSource 'alicloud_cs_cluster_credential' is recommended to manage cluster's kubeconfig, you can also save the 'certificate_authority.cluster_cert' attribute content of new DataSource 'alicloud_cs_cluster_credential' to an appropriate path(like ~/.kube/cluster-ca-cert.pem) for replace it.""")
    def cluster_ca_cert(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        From version 1.248.0, new DataSource `cs_get_cluster_credential` is recommended to manage cluster's kubeconfig, you can also save the certificate_authority.cluster_cert attribute content of new DataSource `cs_get_cluster_credential` to an appropriate path(like ~/.kube/cluster-ca-cert.pem) for replace it.

        *Removed params*
        """
        return pulumi.get(self, "cluster_ca_cert")

    @cluster_ca_cert.setter
    def cluster_ca_cert(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_ca_cert", value)

    @_builtins.property
    @pulumi.getter(name="clusterSpec")
    def cluster_spec(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The cluster specifications of kubernetes cluster,which can be empty. Valid values:
        * ack.standard : Standard edge clusters.
        * ack.pro.small : Professional edge clusters.
        """
        return pulumi.get(self, "cluster_spec")

    @cluster_spec.setter
    def cluster_spec(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_spec", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable cluster deletion protection.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection", value)

    @_builtins.property
    @pulumi.getter(name="installCloudMonitor")
    def install_cloud_monitor(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Install cloud monitor agent on ECS. default: `true`.
        """
        return pulumi.get(self, "install_cloud_monitor")

    @install_cloud_monitor.setter
    def install_cloud_monitor(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "install_cloud_monitor", value)

    @_builtins.property
    @pulumi.getter(name="isEnterpriseSecurityGroup")
    def is_enterprise_security_group(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable to create advanced security group. default: false. See [Advanced security group](https://www.alibabacloud.com/help/doc-detail/120621.htm).
        """
        return pulumi.get(self, "is_enterprise_security_group")

    @is_enterprise_security_group.setter
    def is_enterprise_security_group(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_enterprise_security_group", value)

    @_builtins.property
    @pulumi.getter(name="keyName")
    def key_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The keypair of ssh login cluster node, you have to create it first. You have to specify one of `password` `key_name` `kms_encrypted_password` fields.
        """
        return pulumi.get(self, "key_name")

    @key_name.setter
    def key_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_name", value)

    @_builtins.property
    @pulumi.getter(name="kubeConfig")
    @_utilities.deprecated("""Field 'kube_config' has been deprecated from provider version 1.187.0. Please use the attribute 'output_file' of new DataSource 'alicloud_cs_cluster_credential' to replace it.""")
    def kube_config(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The path of kube config, like ~/.kube/config. Please use the attribute output_file of new DataSource `cs_get_cluster_credential` to replace it.
        """
        return pulumi.get(self, "kube_config")

    @kube_config.setter
    def kube_config(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kube_config", value)

    @_builtins.property
    @pulumi.getter(name="loadBalancerSpec")
    def load_balancer_spec(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The cluster api server load balance instance specification. For more information on how to select a LB instance specification, see [SLB instance overview](https://help.aliyun.com/document_detail/85931.html).
        ->NOTE: If you want to use `Flannel` as CNI network plugin, You need to specific the `pod_cidr` field and addons with `flannel`.

        *Worker params*
        """
        return pulumi.get(self, "load_balancer_spec")

    @load_balancer_spec.setter
    def load_balancer_spec(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "load_balancer_spec", value)

    @_builtins.property
    @pulumi.getter(name="logConfig")
    @_utilities.deprecated("""Field 'log_config' has been removed from provider version 1.103.0. New field 'addons' replaces it.""")
    def log_config(self) -> Optional[pulumi.Input['EdgeKubernetesLogConfigArgs']]:
        """
        A list of one element containing information about the associated log store. See `log_config` below.
        """
        return pulumi.get(self, "log_config")

    @log_config.setter
    def log_config(self, value: Optional[pulumi.Input['EdgeKubernetesLogConfigArgs']]):
        pulumi.set(self, "log_config", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The kubernetes cluster's name. It is unique in one Alicloud account.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "name_prefix")

    @name_prefix.setter
    def name_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name_prefix", value)

    @_builtins.property
    @pulumi.getter(name="newNatGateway")
    def new_nat_gateway(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to create a new nat gateway while creating kubernetes cluster. Default to true. Then openapi in Alibaba Cloud are not all on intranet, So turn this option on is a good choice.
        """
        return pulumi.get(self, "new_nat_gateway")

    @new_nat_gateway.setter
    def new_nat_gateway(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "new_nat_gateway", value)

    @_builtins.property
    @pulumi.getter(name="nodeCidrMask")
    def node_cidr_mask(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The node cidr block to specific how many pods can run on single node. 24-28 is allowed. 24 means 2^(32-24)-1=255 and the node can run at most 255 pods. default: 24
        """
        return pulumi.get(self, "node_cidr_mask")

    @node_cidr_mask.setter
    def node_cidr_mask(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "node_cidr_mask", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password of ssh login cluster node. You have to specify one of `password`, `key_name` `kms_encrypted_password` fields.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter(name="podCidr")
    def pod_cidr(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        [Flannel Specific] The CIDR block for the pod network when using Flannel.
        """
        return pulumi.get(self, "pod_cidr")

    @pod_cidr.setter
    def pod_cidr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pod_cidr", value)

    @_builtins.property
    @pulumi.getter(name="proxyMode")
    def proxy_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Proxy mode is option of kube-proxy. options: iptables|ipvs. default: ipvs.
        """
        return pulumi.get(self, "proxy_mode")

    @proxy_mode.setter
    def proxy_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "proxy_mode", value)

    @_builtins.property
    @pulumi.getter(name="rdsInstances")
    def rds_instances(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        RDS instance list, You can choose which RDS instances whitelist to add instances to.
        """
        return pulumi.get(self, "rds_instances")

    @rds_instances.setter
    def rds_instances(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "rds_instances", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group,by default these cloud resources are automatically assigned to the default resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="retainResources")
    def retain_resources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "retain_resources")

    @retain_resources.setter
    def retain_resources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "retain_resources", value)

    @_builtins.property
    @pulumi.getter
    def runtime(self) -> Optional[pulumi.Input['EdgeKubernetesRuntimeArgs']]:
        """
        The runtime of containers. If you select another container runtime, see [Comparison of Docker, containerd, and Sandboxed-Container](https://www.alibabacloud.com/help/doc-detail/160313.htm). See `runtime` below.
        """
        return pulumi.get(self, "runtime")

    @runtime.setter
    def runtime(self, value: Optional[pulumi.Input['EdgeKubernetesRuntimeArgs']]):
        pulumi.set(self, "runtime", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the security group to which the ECS instances in the cluster belong. If it is not specified, a new Security group will be built.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_group_id", value)

    @_builtins.property
    @pulumi.getter(name="serviceCidr")
    def service_cidr(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The CIDR block for the service network. It cannot be duplicated with the VPC CIDR and CIDR used by Kubernetes cluster in VPC, cannot be modified after creation.
        """
        return pulumi.get(self, "service_cidr")

    @service_cidr.setter
    def service_cidr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_cidr", value)

    @_builtins.property
    @pulumi.getter(name="skipSetCertificateAuthority")
    def skip_set_certificate_authority(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Configure whether to save certificate authority data for your cluster to attribute `certificate_authority`. For cluster security, recommended configuration as `true`. Will be removed with attribute certificate_authority removed.

        *Network params*
        """
        return pulumi.get(self, "skip_set_certificate_authority")

    @skip_set_certificate_authority.setter
    def skip_set_certificate_authority(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "skip_set_certificate_authority", value)

    @_builtins.property
    @pulumi.getter(name="slbInternetEnabled")
    def slb_internet_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to create internet load balancer for API Server. Default to true.
        """
        return pulumi.get(self, "slb_internet_enabled")

    @slb_internet_enabled.setter
    def slb_internet_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "slb_internet_enabled", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Default nil, A map of tags assigned to the kubernetes cluster and work node.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Windows instances support batch and PowerShell scripts. If your script file is larger than 1 KB, we recommend that you upload the script to Object Storage Service (OSS) and pull it through the internal endpoint of your OSS bucket.
        """
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_data", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Desired Kubernetes version. If you do not specify a value, the latest available version at resource creation is used and no upgrades will occur except you set a higher version number. The value must be configured and increased to upgrade the version when desired. Downgrades are not supported by ACK.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)

    @_builtins.property
    @pulumi.getter(name="workerDataDisks")
    def worker_data_disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EdgeKubernetesWorkerDataDiskArgs']]]]:
        """
        The data disk configurations of worker nodes, such as the disk type and disk size. See `worker_data_disks` below.
        """
        return pulumi.get(self, "worker_data_disks")

    @worker_data_disks.setter
    def worker_data_disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EdgeKubernetesWorkerDataDiskArgs']]]]):
        pulumi.set(self, "worker_data_disks", value)

    @_builtins.property
    @pulumi.getter(name="workerDiskCategory")
    def worker_disk_category(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The system disk category of worker node. Its valid value are `cloud_efficiency`, `cloud_ssd` and `cloud_essd` and . Default to `cloud_efficiency`.
        """
        return pulumi.get(self, "worker_disk_category")

    @worker_disk_category.setter
    def worker_disk_category(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "worker_disk_category", value)

    @_builtins.property
    @pulumi.getter(name="workerDiskPerformanceLevel")
    def worker_disk_performance_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Worker node system disk performance level, when `worker_disk_category` values `cloud_essd`, the optional values are `PL0`, `PL1`, `PL2` or `PL3`, but the specific performance level is related to the disk capacity. For more information, see [Enhanced SSDs](https://www.alibabacloud.com/help/doc-detail/122389.htm). Default is `PL1`.
        """
        return pulumi.get(self, "worker_disk_performance_level")

    @worker_disk_performance_level.setter
    def worker_disk_performance_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "worker_disk_performance_level", value)

    @_builtins.property
    @pulumi.getter(name="workerDiskSize")
    def worker_disk_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The system disk size of worker node. Its valid value range [20~32768] in GB. Default to 40.
        """
        return pulumi.get(self, "worker_disk_size")

    @worker_disk_size.setter
    def worker_disk_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "worker_disk_size", value)

    @_builtins.property
    @pulumi.getter(name="workerDiskSnapshotPolicyId")
    def worker_disk_snapshot_policy_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Worker node system disk auto snapshot policy.

        *Computed params*

        You can set some file paths to save kube_config information, but this way is cumbersome. Since version 1.105.0, we've written it to tf state file. About its use，see export attribute certificate_authority. From version 1.187.0+, new DataSource `cs_get_cluster_credential` is recommended to manage cluster's kube_config.
        """
        return pulumi.get(self, "worker_disk_snapshot_policy_id")

    @worker_disk_snapshot_policy_id.setter
    def worker_disk_snapshot_policy_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "worker_disk_snapshot_policy_id", value)

    @_builtins.property
    @pulumi.getter(name="workerInstanceChargeType")
    def worker_instance_charge_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Worker payment type, its valid value is `PostPaid`. Defaults to `PostPaid`. More charge details in [ACK@edge charge](https://help.aliyun.com/document_detail/178718.html).
        """
        return pulumi.get(self, "worker_instance_charge_type")

    @worker_instance_charge_type.setter
    def worker_instance_charge_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "worker_instance_charge_type", value)


@pulumi.input_type
class _EdgeKubernetesState:
    def __init__(__self__, *,
                 addons: Optional[pulumi.Input[Sequence[pulumi.Input['EdgeKubernetesAddonArgs']]]] = None,
                 availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate_authority: Optional[pulumi.Input['EdgeKubernetesCertificateAuthorityArgs']] = None,
                 client_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 client_key: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_ca_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_spec: Optional[pulumi.Input[_builtins.str]] = None,
                 connections: Optional[pulumi.Input['EdgeKubernetesConnectionsArgs']] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 install_cloud_monitor: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_enterprise_security_group: Optional[pulumi.Input[_builtins.bool]] = None,
                 key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 kube_config: Optional[pulumi.Input[_builtins.str]] = None,
                 load_balancer_spec: Optional[pulumi.Input[_builtins.str]] = None,
                 log_config: Optional[pulumi.Input['EdgeKubernetesLogConfigArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 nat_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
                 new_nat_gateway: Optional[pulumi.Input[_builtins.bool]] = None,
                 node_cidr_mask: Optional[pulumi.Input[_builtins.int]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 pod_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 proxy_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 rds_instances: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 retain_resources: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 runtime: Optional[pulumi.Input['EdgeKubernetesRuntimeArgs']] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 service_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_set_certificate_authority: Optional[pulumi.Input[_builtins.bool]] = None,
                 slb_internet: Optional[pulumi.Input[_builtins.str]] = None,
                 slb_internet_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 slb_intranet: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 user_data: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 worker_data_disks: Optional[pulumi.Input[Sequence[pulumi.Input['EdgeKubernetesWorkerDataDiskArgs']]]] = None,
                 worker_disk_category: Optional[pulumi.Input[_builtins.str]] = None,
                 worker_disk_performance_level: Optional[pulumi.Input[_builtins.str]] = None,
                 worker_disk_size: Optional[pulumi.Input[_builtins.int]] = None,
                 worker_disk_snapshot_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 worker_instance_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 worker_instance_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 worker_nodes: Optional[pulumi.Input[Sequence[pulumi.Input['EdgeKubernetesWorkerNodeArgs']]]] = None,
                 worker_number: Optional[pulumi.Input[_builtins.int]] = None,
                 worker_ram_role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 worker_vswitch_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering EdgeKubernetes resources.
        :param pulumi.Input[Sequence[pulumi.Input['EdgeKubernetesAddonArgs']]] addons: The addon you want to install in cluster. See `addons` below.
        :param pulumi.Input[_builtins.str] availability_zone: The ID of availability zone.
        :param pulumi.Input['EdgeKubernetesCertificateAuthorityArgs'] certificate_authority: (Map, Deprecated from v1.248.0) Nested attribute containing certificate authority data for your cluster. Please use the attribute certificate_authority of new DataSource `cs_get_cluster_credential` to replace it.
        :param pulumi.Input[_builtins.str] client_cert: From version 1.248.0, new DataSource `cs_get_cluster_credential` is recommended to manage cluster's kubeconfig, you can also save the certificate_authority.client_cert attribute content of new DataSource `cs_get_cluster_credential` to an appropriate path(like ~/.kube/client-cert.pem) for replace it.
        :param pulumi.Input[_builtins.str] client_key: From version 1.248.0, new DataSource `cs_get_cluster_credential` is recommended to manage cluster's kubeconfig, you can also save the certificate_authority.client_key attribute content of new DataSource `cs_get_cluster_credential` to an appropriate path(like ~/.kube/client-key.pem) for replace it.
        :param pulumi.Input[_builtins.str] cluster_ca_cert: From version 1.248.0, new DataSource `cs_get_cluster_credential` is recommended to manage cluster's kubeconfig, you can also save the certificate_authority.cluster_cert attribute content of new DataSource `cs_get_cluster_credential` to an appropriate path(like ~/.kube/cluster-ca-cert.pem) for replace it.
               
               *Removed params*
        :param pulumi.Input[_builtins.str] cluster_spec: The cluster specifications of kubernetes cluster,which can be empty. Valid values:
               * ack.standard : Standard edge clusters.
               * ack.pro.small : Professional edge clusters.
        :param pulumi.Input['EdgeKubernetesConnectionsArgs'] connections: (Map) Map of kubernetes cluster connection information.
        :param pulumi.Input[_builtins.bool] deletion_protection: Whether to enable cluster deletion protection.
        :param pulumi.Input[_builtins.bool] install_cloud_monitor: Install cloud monitor agent on ECS. default: `true`.
        :param pulumi.Input[_builtins.bool] is_enterprise_security_group: Enable to create advanced security group. default: false. See [Advanced security group](https://www.alibabacloud.com/help/doc-detail/120621.htm).
        :param pulumi.Input[_builtins.str] key_name: The keypair of ssh login cluster node, you have to create it first. You have to specify one of `password` `key_name` `kms_encrypted_password` fields.
        :param pulumi.Input[_builtins.str] kube_config: The path of kube config, like ~/.kube/config. Please use the attribute output_file of new DataSource `cs_get_cluster_credential` to replace it.
        :param pulumi.Input[_builtins.str] load_balancer_spec: The cluster api server load balance instance specification. For more information on how to select a LB instance specification, see [SLB instance overview](https://help.aliyun.com/document_detail/85931.html).
               ->NOTE: If you want to use `Flannel` as CNI network plugin, You need to specific the `pod_cidr` field and addons with `flannel`.
               
               *Worker params*
        :param pulumi.Input['EdgeKubernetesLogConfigArgs'] log_config: A list of one element containing information about the associated log store. See `log_config` below.
        :param pulumi.Input[_builtins.str] name: The kubernetes cluster's name. It is unique in one Alicloud account.
        :param pulumi.Input[_builtins.str] nat_gateway_id: The ID of nat gateway used to launch kubernetes cluster.
        :param pulumi.Input[_builtins.bool] new_nat_gateway: Whether to create a new nat gateway while creating kubernetes cluster. Default to true. Then openapi in Alibaba Cloud are not all on intranet, So turn this option on is a good choice.
        :param pulumi.Input[_builtins.int] node_cidr_mask: The node cidr block to specific how many pods can run on single node. 24-28 is allowed. 24 means 2^(32-24)-1=255 and the node can run at most 255 pods. default: 24
        :param pulumi.Input[_builtins.str] password: The password of ssh login cluster node. You have to specify one of `password`, `key_name` `kms_encrypted_password` fields.
        :param pulumi.Input[_builtins.str] pod_cidr: [Flannel Specific] The CIDR block for the pod network when using Flannel.
        :param pulumi.Input[_builtins.str] proxy_mode: Proxy mode is option of kube-proxy. options: iptables|ipvs. default: ipvs.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] rds_instances: RDS instance list, You can choose which RDS instances whitelist to add instances to.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group,by default these cloud resources are automatically assigned to the default resource group.
        :param pulumi.Input['EdgeKubernetesRuntimeArgs'] runtime: The runtime of containers. If you select another container runtime, see [Comparison of Docker, containerd, and Sandboxed-Container](https://www.alibabacloud.com/help/doc-detail/160313.htm). See `runtime` below.
        :param pulumi.Input[_builtins.str] security_group_id: The ID of the security group to which the ECS instances in the cluster belong. If it is not specified, a new Security group will be built.
        :param pulumi.Input[_builtins.str] service_cidr: The CIDR block for the service network. It cannot be duplicated with the VPC CIDR and CIDR used by Kubernetes cluster in VPC, cannot be modified after creation.
        :param pulumi.Input[_builtins.bool] skip_set_certificate_authority: Configure whether to save certificate authority data for your cluster to attribute `certificate_authority`. For cluster security, recommended configuration as `true`. Will be removed with attribute certificate_authority removed.
               
               *Network params*
        :param pulumi.Input[_builtins.str] slb_internet: The public ip of load balancer.
        :param pulumi.Input[_builtins.bool] slb_internet_enabled: Whether to create internet load balancer for API Server. Default to true.
        :param pulumi.Input[_builtins.str] slb_intranet: The ID of private load balancer where the current cluster master node is located.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Default nil, A map of tags assigned to the kubernetes cluster and work node.
        :param pulumi.Input[_builtins.str] user_data: Windows instances support batch and PowerShell scripts. If your script file is larger than 1 KB, we recommend that you upload the script to Object Storage Service (OSS) and pull it through the internal endpoint of your OSS bucket.
        :param pulumi.Input[_builtins.str] version: Desired Kubernetes version. If you do not specify a value, the latest available version at resource creation is used and no upgrades will occur except you set a higher version number. The value must be configured and increased to upgrade the version when desired. Downgrades are not supported by ACK.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of VPC where the current cluster is located.
        :param pulumi.Input[Sequence[pulumi.Input['EdgeKubernetesWorkerDataDiskArgs']]] worker_data_disks: The data disk configurations of worker nodes, such as the disk type and disk size. See `worker_data_disks` below.
        :param pulumi.Input[_builtins.str] worker_disk_category: The system disk category of worker node. Its valid value are `cloud_efficiency`, `cloud_ssd` and `cloud_essd` and . Default to `cloud_efficiency`.
        :param pulumi.Input[_builtins.str] worker_disk_performance_level: Worker node system disk performance level, when `worker_disk_category` values `cloud_essd`, the optional values are `PL0`, `PL1`, `PL2` or `PL3`, but the specific performance level is related to the disk capacity. For more information, see [Enhanced SSDs](https://www.alibabacloud.com/help/doc-detail/122389.htm). Default is `PL1`.
        :param pulumi.Input[_builtins.int] worker_disk_size: The system disk size of worker node. Its valid value range [20~32768] in GB. Default to 40.
        :param pulumi.Input[_builtins.str] worker_disk_snapshot_policy_id: Worker node system disk auto snapshot policy.
               
               *Computed params*
               
               You can set some file paths to save kube_config information, but this way is cumbersome. Since version 1.105.0, we've written it to tf state file. About its use，see export attribute certificate_authority. From version 1.187.0+, new DataSource `cs_get_cluster_credential` is recommended to manage cluster's kube_config.
        :param pulumi.Input[_builtins.str] worker_instance_charge_type: Worker payment type, its valid value is `PostPaid`. Defaults to `PostPaid`. More charge details in [ACK@edge charge](https://help.aliyun.com/document_detail/178718.html).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] worker_instance_types: The instance types of worker node, you can set multiple types to avoid NoStock of a certain type.
        :param pulumi.Input[Sequence[pulumi.Input['EdgeKubernetesWorkerNodeArgs']]] worker_nodes: List of cluster worker nodes.
        :param pulumi.Input[_builtins.int] worker_number: The cloud worker node number of the edge kubernetes cluster. Default to 1. It is limited up to 50 and if you want to enlarge it, please apply white list or contact with us.
        :param pulumi.Input[_builtins.str] worker_ram_role_name: The RamRole Name attached to worker node.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] worker_vswitch_ids: The vswitches used by workers.
        """
        if addons is not None:
            pulumi.set(__self__, "addons", addons)
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if certificate_authority is not None:
            warnings.warn("""Field 'certificate_authority' has been deprecated from provider version 1.248.0. Please use the attribute 'certificate_authority' of new DataSource 'alicloud_cs_cluster_credential' to replace it.""", DeprecationWarning)
            pulumi.log.warn("""certificate_authority is deprecated: Field 'certificate_authority' has been deprecated from provider version 1.248.0. Please use the attribute 'certificate_authority' of new DataSource 'alicloud_cs_cluster_credential' to replace it.""")
        if certificate_authority is not None:
            pulumi.set(__self__, "certificate_authority", certificate_authority)
        if client_cert is not None:
            warnings.warn("""Field 'client_cert' has been deprecated from provider version 1.248.0. From version 1.248.0, new DataSource 'alicloud_cs_cluster_credential' is recommended to manage cluster's kubeconfig, you can also save the 'certificate_authority.client_cert' attribute content of new DataSource 'alicloud_cs_cluster_credential' to an appropriate path(like ~/.kube/client-cert.pem) for replace it.""", DeprecationWarning)
            pulumi.log.warn("""client_cert is deprecated: Field 'client_cert' has been deprecated from provider version 1.248.0. From version 1.248.0, new DataSource 'alicloud_cs_cluster_credential' is recommended to manage cluster's kubeconfig, you can also save the 'certificate_authority.client_cert' attribute content of new DataSource 'alicloud_cs_cluster_credential' to an appropriate path(like ~/.kube/client-cert.pem) for replace it.""")
        if client_cert is not None:
            pulumi.set(__self__, "client_cert", client_cert)
        if client_key is not None:
            warnings.warn("""Field 'client_key' has been deprecated from provider version 1.248.0. From version 1.248.0, new DataSource 'alicloud_cs_cluster_credential' is recommended to manage cluster's kubeconfig, you can also save the 'certificate_authority.client_key' attribute content of new DataSource 'alicloud_cs_cluster_credential' to an appropriate path(like ~/.kube/client-key.pem) for replace it.""", DeprecationWarning)
            pulumi.log.warn("""client_key is deprecated: Field 'client_key' has been deprecated from provider version 1.248.0. From version 1.248.0, new DataSource 'alicloud_cs_cluster_credential' is recommended to manage cluster's kubeconfig, you can also save the 'certificate_authority.client_key' attribute content of new DataSource 'alicloud_cs_cluster_credential' to an appropriate path(like ~/.kube/client-key.pem) for replace it.""")
        if client_key is not None:
            pulumi.set(__self__, "client_key", client_key)
        if cluster_ca_cert is not None:
            warnings.warn("""Field 'cluster_ca_cert' has been deprecated from provider version 1.248.0. From version 1.248.0, new DataSource 'alicloud_cs_cluster_credential' is recommended to manage cluster's kubeconfig, you can also save the 'certificate_authority.cluster_cert' attribute content of new DataSource 'alicloud_cs_cluster_credential' to an appropriate path(like ~/.kube/cluster-ca-cert.pem) for replace it.""", DeprecationWarning)
            pulumi.log.warn("""cluster_ca_cert is deprecated: Field 'cluster_ca_cert' has been deprecated from provider version 1.248.0. From version 1.248.0, new DataSource 'alicloud_cs_cluster_credential' is recommended to manage cluster's kubeconfig, you can also save the 'certificate_authority.cluster_cert' attribute content of new DataSource 'alicloud_cs_cluster_credential' to an appropriate path(like ~/.kube/cluster-ca-cert.pem) for replace it.""")
        if cluster_ca_cert is not None:
            pulumi.set(__self__, "cluster_ca_cert", cluster_ca_cert)
        if cluster_spec is not None:
            pulumi.set(__self__, "cluster_spec", cluster_spec)
        if connections is not None:
            pulumi.set(__self__, "connections", connections)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if install_cloud_monitor is not None:
            pulumi.set(__self__, "install_cloud_monitor", install_cloud_monitor)
        if is_enterprise_security_group is not None:
            pulumi.set(__self__, "is_enterprise_security_group", is_enterprise_security_group)
        if key_name is not None:
            pulumi.set(__self__, "key_name", key_name)
        if kube_config is not None:
            warnings.warn("""Field 'kube_config' has been deprecated from provider version 1.187.0. Please use the attribute 'output_file' of new DataSource 'alicloud_cs_cluster_credential' to replace it.""", DeprecationWarning)
            pulumi.log.warn("""kube_config is deprecated: Field 'kube_config' has been deprecated from provider version 1.187.0. Please use the attribute 'output_file' of new DataSource 'alicloud_cs_cluster_credential' to replace it.""")
        if kube_config is not None:
            pulumi.set(__self__, "kube_config", kube_config)
        if load_balancer_spec is not None:
            pulumi.set(__self__, "load_balancer_spec", load_balancer_spec)
        if log_config is not None:
            warnings.warn("""Field 'log_config' has been removed from provider version 1.103.0. New field 'addons' replaces it.""", DeprecationWarning)
            pulumi.log.warn("""log_config is deprecated: Field 'log_config' has been removed from provider version 1.103.0. New field 'addons' replaces it.""")
        if log_config is not None:
            pulumi.set(__self__, "log_config", log_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if name_prefix is not None:
            pulumi.set(__self__, "name_prefix", name_prefix)
        if nat_gateway_id is not None:
            pulumi.set(__self__, "nat_gateway_id", nat_gateway_id)
        if new_nat_gateway is not None:
            pulumi.set(__self__, "new_nat_gateway", new_nat_gateway)
        if node_cidr_mask is not None:
            pulumi.set(__self__, "node_cidr_mask", node_cidr_mask)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if pod_cidr is not None:
            pulumi.set(__self__, "pod_cidr", pod_cidr)
        if proxy_mode is not None:
            pulumi.set(__self__, "proxy_mode", proxy_mode)
        if rds_instances is not None:
            pulumi.set(__self__, "rds_instances", rds_instances)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if retain_resources is not None:
            pulumi.set(__self__, "retain_resources", retain_resources)
        if runtime is not None:
            pulumi.set(__self__, "runtime", runtime)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if service_cidr is not None:
            pulumi.set(__self__, "service_cidr", service_cidr)
        if skip_set_certificate_authority is not None:
            pulumi.set(__self__, "skip_set_certificate_authority", skip_set_certificate_authority)
        if slb_internet is not None:
            pulumi.set(__self__, "slb_internet", slb_internet)
        if slb_internet_enabled is not None:
            pulumi.set(__self__, "slb_internet_enabled", slb_internet_enabled)
        if slb_intranet is not None:
            pulumi.set(__self__, "slb_intranet", slb_intranet)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if worker_data_disks is not None:
            pulumi.set(__self__, "worker_data_disks", worker_data_disks)
        if worker_disk_category is not None:
            pulumi.set(__self__, "worker_disk_category", worker_disk_category)
        if worker_disk_performance_level is not None:
            pulumi.set(__self__, "worker_disk_performance_level", worker_disk_performance_level)
        if worker_disk_size is not None:
            pulumi.set(__self__, "worker_disk_size", worker_disk_size)
        if worker_disk_snapshot_policy_id is not None:
            pulumi.set(__self__, "worker_disk_snapshot_policy_id", worker_disk_snapshot_policy_id)
        if worker_instance_charge_type is not None:
            pulumi.set(__self__, "worker_instance_charge_type", worker_instance_charge_type)
        if worker_instance_types is not None:
            pulumi.set(__self__, "worker_instance_types", worker_instance_types)
        if worker_nodes is not None:
            pulumi.set(__self__, "worker_nodes", worker_nodes)
        if worker_number is not None:
            pulumi.set(__self__, "worker_number", worker_number)
        if worker_ram_role_name is not None:
            pulumi.set(__self__, "worker_ram_role_name", worker_ram_role_name)
        if worker_vswitch_ids is not None:
            pulumi.set(__self__, "worker_vswitch_ids", worker_vswitch_ids)

    @_builtins.property
    @pulumi.getter
    def addons(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EdgeKubernetesAddonArgs']]]]:
        """
        The addon you want to install in cluster. See `addons` below.
        """
        return pulumi.get(self, "addons")

    @addons.setter
    def addons(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EdgeKubernetesAddonArgs']]]]):
        pulumi.set(self, "addons", value)

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of availability zone.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "availability_zone", value)

    @_builtins.property
    @pulumi.getter(name="certificateAuthority")
    @_utilities.deprecated("""Field 'certificate_authority' has been deprecated from provider version 1.248.0. Please use the attribute 'certificate_authority' of new DataSource 'alicloud_cs_cluster_credential' to replace it.""")
    def certificate_authority(self) -> Optional[pulumi.Input['EdgeKubernetesCertificateAuthorityArgs']]:
        """
        (Map, Deprecated from v1.248.0) Nested attribute containing certificate authority data for your cluster. Please use the attribute certificate_authority of new DataSource `cs_get_cluster_credential` to replace it.
        """
        return pulumi.get(self, "certificate_authority")

    @certificate_authority.setter
    def certificate_authority(self, value: Optional[pulumi.Input['EdgeKubernetesCertificateAuthorityArgs']]):
        pulumi.set(self, "certificate_authority", value)

    @_builtins.property
    @pulumi.getter(name="clientCert")
    @_utilities.deprecated("""Field 'client_cert' has been deprecated from provider version 1.248.0. From version 1.248.0, new DataSource 'alicloud_cs_cluster_credential' is recommended to manage cluster's kubeconfig, you can also save the 'certificate_authority.client_cert' attribute content of new DataSource 'alicloud_cs_cluster_credential' to an appropriate path(like ~/.kube/client-cert.pem) for replace it.""")
    def client_cert(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        From version 1.248.0, new DataSource `cs_get_cluster_credential` is recommended to manage cluster's kubeconfig, you can also save the certificate_authority.client_cert attribute content of new DataSource `cs_get_cluster_credential` to an appropriate path(like ~/.kube/client-cert.pem) for replace it.
        """
        return pulumi.get(self, "client_cert")

    @client_cert.setter
    def client_cert(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_cert", value)

    @_builtins.property
    @pulumi.getter(name="clientKey")
    @_utilities.deprecated("""Field 'client_key' has been deprecated from provider version 1.248.0. From version 1.248.0, new DataSource 'alicloud_cs_cluster_credential' is recommended to manage cluster's kubeconfig, you can also save the 'certificate_authority.client_key' attribute content of new DataSource 'alicloud_cs_cluster_credential' to an appropriate path(like ~/.kube/client-key.pem) for replace it.""")
    def client_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        From version 1.248.0, new DataSource `cs_get_cluster_credential` is recommended to manage cluster's kubeconfig, you can also save the certificate_authority.client_key attribute content of new DataSource `cs_get_cluster_credential` to an appropriate path(like ~/.kube/client-key.pem) for replace it.
        """
        return pulumi.get(self, "client_key")

    @client_key.setter
    def client_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_key", value)

    @_builtins.property
    @pulumi.getter(name="clusterCaCert")
    @_utilities.deprecated("""Field 'cluster_ca_cert' has been deprecated from provider version 1.248.0. From version 1.248.0, new DataSource 'alicloud_cs_cluster_credential' is recommended to manage cluster's kubeconfig, you can also save the 'certificate_authority.cluster_cert' attribute content of new DataSource 'alicloud_cs_cluster_credential' to an appropriate path(like ~/.kube/cluster-ca-cert.pem) for replace it.""")
    def cluster_ca_cert(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        From version 1.248.0, new DataSource `cs_get_cluster_credential` is recommended to manage cluster's kubeconfig, you can also save the certificate_authority.cluster_cert attribute content of new DataSource `cs_get_cluster_credential` to an appropriate path(like ~/.kube/cluster-ca-cert.pem) for replace it.

        *Removed params*
        """
        return pulumi.get(self, "cluster_ca_cert")

    @cluster_ca_cert.setter
    def cluster_ca_cert(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_ca_cert", value)

    @_builtins.property
    @pulumi.getter(name="clusterSpec")
    def cluster_spec(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The cluster specifications of kubernetes cluster,which can be empty. Valid values:
        * ack.standard : Standard edge clusters.
        * ack.pro.small : Professional edge clusters.
        """
        return pulumi.get(self, "cluster_spec")

    @cluster_spec.setter
    def cluster_spec(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_spec", value)

    @_builtins.property
    @pulumi.getter
    def connections(self) -> Optional[pulumi.Input['EdgeKubernetesConnectionsArgs']]:
        """
        (Map) Map of kubernetes cluster connection information.
        """
        return pulumi.get(self, "connections")

    @connections.setter
    def connections(self, value: Optional[pulumi.Input['EdgeKubernetesConnectionsArgs']]):
        pulumi.set(self, "connections", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable cluster deletion protection.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection", value)

    @_builtins.property
    @pulumi.getter(name="installCloudMonitor")
    def install_cloud_monitor(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Install cloud monitor agent on ECS. default: `true`.
        """
        return pulumi.get(self, "install_cloud_monitor")

    @install_cloud_monitor.setter
    def install_cloud_monitor(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "install_cloud_monitor", value)

    @_builtins.property
    @pulumi.getter(name="isEnterpriseSecurityGroup")
    def is_enterprise_security_group(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable to create advanced security group. default: false. See [Advanced security group](https://www.alibabacloud.com/help/doc-detail/120621.htm).
        """
        return pulumi.get(self, "is_enterprise_security_group")

    @is_enterprise_security_group.setter
    def is_enterprise_security_group(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_enterprise_security_group", value)

    @_builtins.property
    @pulumi.getter(name="keyName")
    def key_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The keypair of ssh login cluster node, you have to create it first. You have to specify one of `password` `key_name` `kms_encrypted_password` fields.
        """
        return pulumi.get(self, "key_name")

    @key_name.setter
    def key_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_name", value)

    @_builtins.property
    @pulumi.getter(name="kubeConfig")
    @_utilities.deprecated("""Field 'kube_config' has been deprecated from provider version 1.187.0. Please use the attribute 'output_file' of new DataSource 'alicloud_cs_cluster_credential' to replace it.""")
    def kube_config(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The path of kube config, like ~/.kube/config. Please use the attribute output_file of new DataSource `cs_get_cluster_credential` to replace it.
        """
        return pulumi.get(self, "kube_config")

    @kube_config.setter
    def kube_config(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kube_config", value)

    @_builtins.property
    @pulumi.getter(name="loadBalancerSpec")
    def load_balancer_spec(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The cluster api server load balance instance specification. For more information on how to select a LB instance specification, see [SLB instance overview](https://help.aliyun.com/document_detail/85931.html).
        ->NOTE: If you want to use `Flannel` as CNI network plugin, You need to specific the `pod_cidr` field and addons with `flannel`.

        *Worker params*
        """
        return pulumi.get(self, "load_balancer_spec")

    @load_balancer_spec.setter
    def load_balancer_spec(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "load_balancer_spec", value)

    @_builtins.property
    @pulumi.getter(name="logConfig")
    @_utilities.deprecated("""Field 'log_config' has been removed from provider version 1.103.0. New field 'addons' replaces it.""")
    def log_config(self) -> Optional[pulumi.Input['EdgeKubernetesLogConfigArgs']]:
        """
        A list of one element containing information about the associated log store. See `log_config` below.
        """
        return pulumi.get(self, "log_config")

    @log_config.setter
    def log_config(self, value: Optional[pulumi.Input['EdgeKubernetesLogConfigArgs']]):
        pulumi.set(self, "log_config", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The kubernetes cluster's name. It is unique in one Alicloud account.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "name_prefix")

    @name_prefix.setter
    def name_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name_prefix", value)

    @_builtins.property
    @pulumi.getter(name="natGatewayId")
    def nat_gateway_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of nat gateway used to launch kubernetes cluster.
        """
        return pulumi.get(self, "nat_gateway_id")

    @nat_gateway_id.setter
    def nat_gateway_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "nat_gateway_id", value)

    @_builtins.property
    @pulumi.getter(name="newNatGateway")
    def new_nat_gateway(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to create a new nat gateway while creating kubernetes cluster. Default to true. Then openapi in Alibaba Cloud are not all on intranet, So turn this option on is a good choice.
        """
        return pulumi.get(self, "new_nat_gateway")

    @new_nat_gateway.setter
    def new_nat_gateway(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "new_nat_gateway", value)

    @_builtins.property
    @pulumi.getter(name="nodeCidrMask")
    def node_cidr_mask(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The node cidr block to specific how many pods can run on single node. 24-28 is allowed. 24 means 2^(32-24)-1=255 and the node can run at most 255 pods. default: 24
        """
        return pulumi.get(self, "node_cidr_mask")

    @node_cidr_mask.setter
    def node_cidr_mask(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "node_cidr_mask", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password of ssh login cluster node. You have to specify one of `password`, `key_name` `kms_encrypted_password` fields.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter(name="podCidr")
    def pod_cidr(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        [Flannel Specific] The CIDR block for the pod network when using Flannel.
        """
        return pulumi.get(self, "pod_cidr")

    @pod_cidr.setter
    def pod_cidr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pod_cidr", value)

    @_builtins.property
    @pulumi.getter(name="proxyMode")
    def proxy_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Proxy mode is option of kube-proxy. options: iptables|ipvs. default: ipvs.
        """
        return pulumi.get(self, "proxy_mode")

    @proxy_mode.setter
    def proxy_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "proxy_mode", value)

    @_builtins.property
    @pulumi.getter(name="rdsInstances")
    def rds_instances(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        RDS instance list, You can choose which RDS instances whitelist to add instances to.
        """
        return pulumi.get(self, "rds_instances")

    @rds_instances.setter
    def rds_instances(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "rds_instances", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group,by default these cloud resources are automatically assigned to the default resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="retainResources")
    def retain_resources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "retain_resources")

    @retain_resources.setter
    def retain_resources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "retain_resources", value)

    @_builtins.property
    @pulumi.getter
    def runtime(self) -> Optional[pulumi.Input['EdgeKubernetesRuntimeArgs']]:
        """
        The runtime of containers. If you select another container runtime, see [Comparison of Docker, containerd, and Sandboxed-Container](https://www.alibabacloud.com/help/doc-detail/160313.htm). See `runtime` below.
        """
        return pulumi.get(self, "runtime")

    @runtime.setter
    def runtime(self, value: Optional[pulumi.Input['EdgeKubernetesRuntimeArgs']]):
        pulumi.set(self, "runtime", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the security group to which the ECS instances in the cluster belong. If it is not specified, a new Security group will be built.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_group_id", value)

    @_builtins.property
    @pulumi.getter(name="serviceCidr")
    def service_cidr(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The CIDR block for the service network. It cannot be duplicated with the VPC CIDR and CIDR used by Kubernetes cluster in VPC, cannot be modified after creation.
        """
        return pulumi.get(self, "service_cidr")

    @service_cidr.setter
    def service_cidr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_cidr", value)

    @_builtins.property
    @pulumi.getter(name="skipSetCertificateAuthority")
    def skip_set_certificate_authority(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Configure whether to save certificate authority data for your cluster to attribute `certificate_authority`. For cluster security, recommended configuration as `true`. Will be removed with attribute certificate_authority removed.

        *Network params*
        """
        return pulumi.get(self, "skip_set_certificate_authority")

    @skip_set_certificate_authority.setter
    def skip_set_certificate_authority(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "skip_set_certificate_authority", value)

    @_builtins.property
    @pulumi.getter(name="slbInternet")
    def slb_internet(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The public ip of load balancer.
        """
        return pulumi.get(self, "slb_internet")

    @slb_internet.setter
    def slb_internet(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "slb_internet", value)

    @_builtins.property
    @pulumi.getter(name="slbInternetEnabled")
    def slb_internet_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to create internet load balancer for API Server. Default to true.
        """
        return pulumi.get(self, "slb_internet_enabled")

    @slb_internet_enabled.setter
    def slb_internet_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "slb_internet_enabled", value)

    @_builtins.property
    @pulumi.getter(name="slbIntranet")
    def slb_intranet(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of private load balancer where the current cluster master node is located.
        """
        return pulumi.get(self, "slb_intranet")

    @slb_intranet.setter
    def slb_intranet(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "slb_intranet", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Default nil, A map of tags assigned to the kubernetes cluster and work node.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Windows instances support batch and PowerShell scripts. If your script file is larger than 1 KB, we recommend that you upload the script to Object Storage Service (OSS) and pull it through the internal endpoint of your OSS bucket.
        """
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_data", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Desired Kubernetes version. If you do not specify a value, the latest available version at resource creation is used and no upgrades will occur except you set a higher version number. The value must be configured and increased to upgrade the version when desired. Downgrades are not supported by ACK.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of VPC where the current cluster is located.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="workerDataDisks")
    def worker_data_disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EdgeKubernetesWorkerDataDiskArgs']]]]:
        """
        The data disk configurations of worker nodes, such as the disk type and disk size. See `worker_data_disks` below.
        """
        return pulumi.get(self, "worker_data_disks")

    @worker_data_disks.setter
    def worker_data_disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EdgeKubernetesWorkerDataDiskArgs']]]]):
        pulumi.set(self, "worker_data_disks", value)

    @_builtins.property
    @pulumi.getter(name="workerDiskCategory")
    def worker_disk_category(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The system disk category of worker node. Its valid value are `cloud_efficiency`, `cloud_ssd` and `cloud_essd` and . Default to `cloud_efficiency`.
        """
        return pulumi.get(self, "worker_disk_category")

    @worker_disk_category.setter
    def worker_disk_category(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "worker_disk_category", value)

    @_builtins.property
    @pulumi.getter(name="workerDiskPerformanceLevel")
    def worker_disk_performance_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Worker node system disk performance level, when `worker_disk_category` values `cloud_essd`, the optional values are `PL0`, `PL1`, `PL2` or `PL3`, but the specific performance level is related to the disk capacity. For more information, see [Enhanced SSDs](https://www.alibabacloud.com/help/doc-detail/122389.htm). Default is `PL1`.
        """
        return pulumi.get(self, "worker_disk_performance_level")

    @worker_disk_performance_level.setter
    def worker_disk_performance_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "worker_disk_performance_level", value)

    @_builtins.property
    @pulumi.getter(name="workerDiskSize")
    def worker_disk_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The system disk size of worker node. Its valid value range [20~32768] in GB. Default to 40.
        """
        return pulumi.get(self, "worker_disk_size")

    @worker_disk_size.setter
    def worker_disk_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "worker_disk_size", value)

    @_builtins.property
    @pulumi.getter(name="workerDiskSnapshotPolicyId")
    def worker_disk_snapshot_policy_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Worker node system disk auto snapshot policy.

        *Computed params*

        You can set some file paths to save kube_config information, but this way is cumbersome. Since version 1.105.0, we've written it to tf state file. About its use，see export attribute certificate_authority. From version 1.187.0+, new DataSource `cs_get_cluster_credential` is recommended to manage cluster's kube_config.
        """
        return pulumi.get(self, "worker_disk_snapshot_policy_id")

    @worker_disk_snapshot_policy_id.setter
    def worker_disk_snapshot_policy_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "worker_disk_snapshot_policy_id", value)

    @_builtins.property
    @pulumi.getter(name="workerInstanceChargeType")
    def worker_instance_charge_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Worker payment type, its valid value is `PostPaid`. Defaults to `PostPaid`. More charge details in [ACK@edge charge](https://help.aliyun.com/document_detail/178718.html).
        """
        return pulumi.get(self, "worker_instance_charge_type")

    @worker_instance_charge_type.setter
    def worker_instance_charge_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "worker_instance_charge_type", value)

    @_builtins.property
    @pulumi.getter(name="workerInstanceTypes")
    def worker_instance_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The instance types of worker node, you can set multiple types to avoid NoStock of a certain type.
        """
        return pulumi.get(self, "worker_instance_types")

    @worker_instance_types.setter
    def worker_instance_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "worker_instance_types", value)

    @_builtins.property
    @pulumi.getter(name="workerNodes")
    def worker_nodes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EdgeKubernetesWorkerNodeArgs']]]]:
        """
        List of cluster worker nodes.
        """
        return pulumi.get(self, "worker_nodes")

    @worker_nodes.setter
    def worker_nodes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EdgeKubernetesWorkerNodeArgs']]]]):
        pulumi.set(self, "worker_nodes", value)

    @_builtins.property
    @pulumi.getter(name="workerNumber")
    def worker_number(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The cloud worker node number of the edge kubernetes cluster. Default to 1. It is limited up to 50 and if you want to enlarge it, please apply white list or contact with us.
        """
        return pulumi.get(self, "worker_number")

    @worker_number.setter
    def worker_number(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "worker_number", value)

    @_builtins.property
    @pulumi.getter(name="workerRamRoleName")
    def worker_ram_role_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The RamRole Name attached to worker node.
        """
        return pulumi.get(self, "worker_ram_role_name")

    @worker_ram_role_name.setter
    def worker_ram_role_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "worker_ram_role_name", value)

    @_builtins.property
    @pulumi.getter(name="workerVswitchIds")
    def worker_vswitch_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The vswitches used by workers.
        """
        return pulumi.get(self, "worker_vswitch_ids")

    @worker_vswitch_ids.setter
    def worker_vswitch_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "worker_vswitch_ids", value)


@pulumi.type_token("alicloud:cs/edgeKubernetes:EdgeKubernetes")
class EdgeKubernetes(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 addons: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EdgeKubernetesAddonArgs', 'EdgeKubernetesAddonArgsDict']]]]] = None,
                 availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 client_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 client_key: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_ca_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_spec: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 install_cloud_monitor: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_enterprise_security_group: Optional[pulumi.Input[_builtins.bool]] = None,
                 key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 kube_config: Optional[pulumi.Input[_builtins.str]] = None,
                 load_balancer_spec: Optional[pulumi.Input[_builtins.str]] = None,
                 log_config: Optional[pulumi.Input[Union['EdgeKubernetesLogConfigArgs', 'EdgeKubernetesLogConfigArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 new_nat_gateway: Optional[pulumi.Input[_builtins.bool]] = None,
                 node_cidr_mask: Optional[pulumi.Input[_builtins.int]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 pod_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 proxy_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 rds_instances: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 retain_resources: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 runtime: Optional[pulumi.Input[Union['EdgeKubernetesRuntimeArgs', 'EdgeKubernetesRuntimeArgsDict']]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 service_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_set_certificate_authority: Optional[pulumi.Input[_builtins.bool]] = None,
                 slb_internet_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 user_data: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 worker_data_disks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EdgeKubernetesWorkerDataDiskArgs', 'EdgeKubernetesWorkerDataDiskArgsDict']]]]] = None,
                 worker_disk_category: Optional[pulumi.Input[_builtins.str]] = None,
                 worker_disk_performance_level: Optional[pulumi.Input[_builtins.str]] = None,
                 worker_disk_size: Optional[pulumi.Input[_builtins.int]] = None,
                 worker_disk_snapshot_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 worker_instance_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 worker_instance_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 worker_number: Optional[pulumi.Input[_builtins.int]] = None,
                 worker_vswitch_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        This resource will help you to manage a Edge Kubernetes Cluster in Alibaba Cloud Kubernetes Service, see [What is edge kubernetes](https://www.alibabacloud.com/help/en/ack/ack-managed-and-ack-dedicated/developer-reference/create-an-ack-edge-cluster).

        > **NOTE:** Kubernetes cluster only supports VPC network and it can access internet while creating kubernetes cluster.
        A Nat Gateway and configuring a SNAT for it can ensure one VPC network access internet. If there is no nat gateway in the
        VPC, you can set `new_nat_gateway` to "true" to create one automatically.

        > **NOTE:** Creating kubernetes cluster need to install several packages and it will cost about 15 minutes. Please be patient.

        > **NOTE:** The provider supports to download kube config, client certificate, client key and cluster ca certificate
        after creating cluster successfully, and you can put them into the specified location, like '~/.kube/config'.

        > **NOTE:** The provider supports disabling internet load balancer for API Server by setting `false` to `slb_internet_enabled`.

        > **NOTE:** If you want to manage Kubernetes, you can use Kubernetes Provider.

        > **NOTE:** Available since v1.103.0.

        > **NOTE:** From version 1.185.0+, support new fields `cluster_spec`, `runtime` and `load_balancer_spec`.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default = alicloud.get_zones(available_resource_creation="VSwitch")
        default_get_instance_types = alicloud.ecs.get_instance_types(availability_zone=default.zones[0].id,
            cpu_core_count=4,
            memory_size=8,
            kubernetes_node_role="Master")
        default_network = alicloud.vpc.Network("default",
            vpc_name=name,
            cidr_block="10.4.0.0/16")
        default_switch = alicloud.vpc.Switch("default",
            vswitch_name=name,
            cidr_block="10.4.0.0/24",
            vpc_id=default_network.id,
            zone_id=default.zones[0].id)
        default_edge_kubernetes = alicloud.cs.EdgeKubernetes("default",
            name_prefix=name,
            worker_vswitch_ids=[default_switch.id],
            worker_instance_types=[default_get_instance_types.instance_types[0].id],
            version="1.26.3-aliyun.1",
            worker_number=1,
            password="Test12345",
            pod_cidr="10.99.0.0/16",
            service_cidr="172.16.0.0/16",
            worker_instance_charge_type="PostPaid",
            new_nat_gateway=True,
            node_cidr_mask=24,
            install_cloud_monitor=True,
            slb_internet_enabled=True,
            is_enterprise_security_group=True,
            skip_set_certificate_authority=True,
            worker_data_disks=[{
                "category": "cloud_ssd",
                "size": "200",
                "encrypted": "false",
            }])
        ```

        You could create a professional kubernetes edge cluster now.

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf_example"
        default = alicloud.get_zones(available_resource_creation="VSwitch")
        default_get_instance_types = alicloud.ecs.get_instance_types(availability_zone=default.zones[0].id,
            cpu_core_count=4,
            memory_size=8,
            kubernetes_node_role="Master")
        default_network = alicloud.vpc.Network("default",
            vpc_name=name,
            cidr_block="10.4.0.0/16")
        default_switch = alicloud.vpc.Switch("default",
            vswitch_name=name,
            cidr_block="10.4.0.0/24",
            vpc_id=default_network.id,
            zone_id=default.zones[0].id)
        default_edge_kubernetes = alicloud.cs.EdgeKubernetes("default",
            name_prefix=name,
            worker_vswitch_ids=[default_switch.id],
            worker_instance_types=[default_get_instance_types.instance_types[0].id],
            cluster_spec="ack.pro.small",
            worker_number=1,
            password="Test12345",
            pod_cidr="10.99.0.0/16",
            service_cidr="172.16.0.0/16",
            worker_instance_charge_type="PostPaid",
            new_nat_gateway=True,
            node_cidr_mask=24,
            load_balancer_spec="slb.s2.small",
            install_cloud_monitor=True,
            slb_internet_enabled=True,
            is_enterprise_security_group=True,
            skip_set_certificate_authority=True,
            worker_data_disks=[{
                "category": "cloud_ssd",
                "size": "200",
                "encrypted": "false",
            }])
        ```

        ## Import

        Kubernetes edge cluster can be imported using the id, e.g. Then complete the main.tf accords to the result of `pulumi preview`.

        ```sh
        $ pulumi import alicloud:cs/edgeKubernetes:EdgeKubernetes main cluster-id
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EdgeKubernetesAddonArgs', 'EdgeKubernetesAddonArgsDict']]]] addons: The addon you want to install in cluster. See `addons` below.
        :param pulumi.Input[_builtins.str] availability_zone: The ID of availability zone.
        :param pulumi.Input[_builtins.str] client_cert: From version 1.248.0, new DataSource `cs_get_cluster_credential` is recommended to manage cluster's kubeconfig, you can also save the certificate_authority.client_cert attribute content of new DataSource `cs_get_cluster_credential` to an appropriate path(like ~/.kube/client-cert.pem) for replace it.
        :param pulumi.Input[_builtins.str] client_key: From version 1.248.0, new DataSource `cs_get_cluster_credential` is recommended to manage cluster's kubeconfig, you can also save the certificate_authority.client_key attribute content of new DataSource `cs_get_cluster_credential` to an appropriate path(like ~/.kube/client-key.pem) for replace it.
        :param pulumi.Input[_builtins.str] cluster_ca_cert: From version 1.248.0, new DataSource `cs_get_cluster_credential` is recommended to manage cluster's kubeconfig, you can also save the certificate_authority.cluster_cert attribute content of new DataSource `cs_get_cluster_credential` to an appropriate path(like ~/.kube/cluster-ca-cert.pem) for replace it.
               
               *Removed params*
        :param pulumi.Input[_builtins.str] cluster_spec: The cluster specifications of kubernetes cluster,which can be empty. Valid values:
               * ack.standard : Standard edge clusters.
               * ack.pro.small : Professional edge clusters.
        :param pulumi.Input[_builtins.bool] deletion_protection: Whether to enable cluster deletion protection.
        :param pulumi.Input[_builtins.bool] install_cloud_monitor: Install cloud monitor agent on ECS. default: `true`.
        :param pulumi.Input[_builtins.bool] is_enterprise_security_group: Enable to create advanced security group. default: false. See [Advanced security group](https://www.alibabacloud.com/help/doc-detail/120621.htm).
        :param pulumi.Input[_builtins.str] key_name: The keypair of ssh login cluster node, you have to create it first. You have to specify one of `password` `key_name` `kms_encrypted_password` fields.
        :param pulumi.Input[_builtins.str] kube_config: The path of kube config, like ~/.kube/config. Please use the attribute output_file of new DataSource `cs_get_cluster_credential` to replace it.
        :param pulumi.Input[_builtins.str] load_balancer_spec: The cluster api server load balance instance specification. For more information on how to select a LB instance specification, see [SLB instance overview](https://help.aliyun.com/document_detail/85931.html).
               ->NOTE: If you want to use `Flannel` as CNI network plugin, You need to specific the `pod_cidr` field and addons with `flannel`.
               
               *Worker params*
        :param pulumi.Input[Union['EdgeKubernetesLogConfigArgs', 'EdgeKubernetesLogConfigArgsDict']] log_config: A list of one element containing information about the associated log store. See `log_config` below.
        :param pulumi.Input[_builtins.str] name: The kubernetes cluster's name. It is unique in one Alicloud account.
        :param pulumi.Input[_builtins.bool] new_nat_gateway: Whether to create a new nat gateway while creating kubernetes cluster. Default to true. Then openapi in Alibaba Cloud are not all on intranet, So turn this option on is a good choice.
        :param pulumi.Input[_builtins.int] node_cidr_mask: The node cidr block to specific how many pods can run on single node. 24-28 is allowed. 24 means 2^(32-24)-1=255 and the node can run at most 255 pods. default: 24
        :param pulumi.Input[_builtins.str] password: The password of ssh login cluster node. You have to specify one of `password`, `key_name` `kms_encrypted_password` fields.
        :param pulumi.Input[_builtins.str] pod_cidr: [Flannel Specific] The CIDR block for the pod network when using Flannel.
        :param pulumi.Input[_builtins.str] proxy_mode: Proxy mode is option of kube-proxy. options: iptables|ipvs. default: ipvs.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] rds_instances: RDS instance list, You can choose which RDS instances whitelist to add instances to.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group,by default these cloud resources are automatically assigned to the default resource group.
        :param pulumi.Input[Union['EdgeKubernetesRuntimeArgs', 'EdgeKubernetesRuntimeArgsDict']] runtime: The runtime of containers. If you select another container runtime, see [Comparison of Docker, containerd, and Sandboxed-Container](https://www.alibabacloud.com/help/doc-detail/160313.htm). See `runtime` below.
        :param pulumi.Input[_builtins.str] security_group_id: The ID of the security group to which the ECS instances in the cluster belong. If it is not specified, a new Security group will be built.
        :param pulumi.Input[_builtins.str] service_cidr: The CIDR block for the service network. It cannot be duplicated with the VPC CIDR and CIDR used by Kubernetes cluster in VPC, cannot be modified after creation.
        :param pulumi.Input[_builtins.bool] skip_set_certificate_authority: Configure whether to save certificate authority data for your cluster to attribute `certificate_authority`. For cluster security, recommended configuration as `true`. Will be removed with attribute certificate_authority removed.
               
               *Network params*
        :param pulumi.Input[_builtins.bool] slb_internet_enabled: Whether to create internet load balancer for API Server. Default to true.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Default nil, A map of tags assigned to the kubernetes cluster and work node.
        :param pulumi.Input[_builtins.str] user_data: Windows instances support batch and PowerShell scripts. If your script file is larger than 1 KB, we recommend that you upload the script to Object Storage Service (OSS) and pull it through the internal endpoint of your OSS bucket.
        :param pulumi.Input[_builtins.str] version: Desired Kubernetes version. If you do not specify a value, the latest available version at resource creation is used and no upgrades will occur except you set a higher version number. The value must be configured and increased to upgrade the version when desired. Downgrades are not supported by ACK.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EdgeKubernetesWorkerDataDiskArgs', 'EdgeKubernetesWorkerDataDiskArgsDict']]]] worker_data_disks: The data disk configurations of worker nodes, such as the disk type and disk size. See `worker_data_disks` below.
        :param pulumi.Input[_builtins.str] worker_disk_category: The system disk category of worker node. Its valid value are `cloud_efficiency`, `cloud_ssd` and `cloud_essd` and . Default to `cloud_efficiency`.
        :param pulumi.Input[_builtins.str] worker_disk_performance_level: Worker node system disk performance level, when `worker_disk_category` values `cloud_essd`, the optional values are `PL0`, `PL1`, `PL2` or `PL3`, but the specific performance level is related to the disk capacity. For more information, see [Enhanced SSDs](https://www.alibabacloud.com/help/doc-detail/122389.htm). Default is `PL1`.
        :param pulumi.Input[_builtins.int] worker_disk_size: The system disk size of worker node. Its valid value range [20~32768] in GB. Default to 40.
        :param pulumi.Input[_builtins.str] worker_disk_snapshot_policy_id: Worker node system disk auto snapshot policy.
               
               *Computed params*
               
               You can set some file paths to save kube_config information, but this way is cumbersome. Since version 1.105.0, we've written it to tf state file. About its use，see export attribute certificate_authority. From version 1.187.0+, new DataSource `cs_get_cluster_credential` is recommended to manage cluster's kube_config.
        :param pulumi.Input[_builtins.str] worker_instance_charge_type: Worker payment type, its valid value is `PostPaid`. Defaults to `PostPaid`. More charge details in [ACK@edge charge](https://help.aliyun.com/document_detail/178718.html).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] worker_instance_types: The instance types of worker node, you can set multiple types to avoid NoStock of a certain type.
        :param pulumi.Input[_builtins.int] worker_number: The cloud worker node number of the edge kubernetes cluster. Default to 1. It is limited up to 50 and if you want to enlarge it, please apply white list or contact with us.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] worker_vswitch_ids: The vswitches used by workers.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EdgeKubernetesArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource will help you to manage a Edge Kubernetes Cluster in Alibaba Cloud Kubernetes Service, see [What is edge kubernetes](https://www.alibabacloud.com/help/en/ack/ack-managed-and-ack-dedicated/developer-reference/create-an-ack-edge-cluster).

        > **NOTE:** Kubernetes cluster only supports VPC network and it can access internet while creating kubernetes cluster.
        A Nat Gateway and configuring a SNAT for it can ensure one VPC network access internet. If there is no nat gateway in the
        VPC, you can set `new_nat_gateway` to "true" to create one automatically.

        > **NOTE:** Creating kubernetes cluster need to install several packages and it will cost about 15 minutes. Please be patient.

        > **NOTE:** The provider supports to download kube config, client certificate, client key and cluster ca certificate
        after creating cluster successfully, and you can put them into the specified location, like '~/.kube/config'.

        > **NOTE:** The provider supports disabling internet load balancer for API Server by setting `false` to `slb_internet_enabled`.

        > **NOTE:** If you want to manage Kubernetes, you can use Kubernetes Provider.

        > **NOTE:** Available since v1.103.0.

        > **NOTE:** From version 1.185.0+, support new fields `cluster_spec`, `runtime` and `load_balancer_spec`.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default = alicloud.get_zones(available_resource_creation="VSwitch")
        default_get_instance_types = alicloud.ecs.get_instance_types(availability_zone=default.zones[0].id,
            cpu_core_count=4,
            memory_size=8,
            kubernetes_node_role="Master")
        default_network = alicloud.vpc.Network("default",
            vpc_name=name,
            cidr_block="10.4.0.0/16")
        default_switch = alicloud.vpc.Switch("default",
            vswitch_name=name,
            cidr_block="10.4.0.0/24",
            vpc_id=default_network.id,
            zone_id=default.zones[0].id)
        default_edge_kubernetes = alicloud.cs.EdgeKubernetes("default",
            name_prefix=name,
            worker_vswitch_ids=[default_switch.id],
            worker_instance_types=[default_get_instance_types.instance_types[0].id],
            version="1.26.3-aliyun.1",
            worker_number=1,
            password="Test12345",
            pod_cidr="10.99.0.0/16",
            service_cidr="172.16.0.0/16",
            worker_instance_charge_type="PostPaid",
            new_nat_gateway=True,
            node_cidr_mask=24,
            install_cloud_monitor=True,
            slb_internet_enabled=True,
            is_enterprise_security_group=True,
            skip_set_certificate_authority=True,
            worker_data_disks=[{
                "category": "cloud_ssd",
                "size": "200",
                "encrypted": "false",
            }])
        ```

        You could create a professional kubernetes edge cluster now.

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf_example"
        default = alicloud.get_zones(available_resource_creation="VSwitch")
        default_get_instance_types = alicloud.ecs.get_instance_types(availability_zone=default.zones[0].id,
            cpu_core_count=4,
            memory_size=8,
            kubernetes_node_role="Master")
        default_network = alicloud.vpc.Network("default",
            vpc_name=name,
            cidr_block="10.4.0.0/16")
        default_switch = alicloud.vpc.Switch("default",
            vswitch_name=name,
            cidr_block="10.4.0.0/24",
            vpc_id=default_network.id,
            zone_id=default.zones[0].id)
        default_edge_kubernetes = alicloud.cs.EdgeKubernetes("default",
            name_prefix=name,
            worker_vswitch_ids=[default_switch.id],
            worker_instance_types=[default_get_instance_types.instance_types[0].id],
            cluster_spec="ack.pro.small",
            worker_number=1,
            password="Test12345",
            pod_cidr="10.99.0.0/16",
            service_cidr="172.16.0.0/16",
            worker_instance_charge_type="PostPaid",
            new_nat_gateway=True,
            node_cidr_mask=24,
            load_balancer_spec="slb.s2.small",
            install_cloud_monitor=True,
            slb_internet_enabled=True,
            is_enterprise_security_group=True,
            skip_set_certificate_authority=True,
            worker_data_disks=[{
                "category": "cloud_ssd",
                "size": "200",
                "encrypted": "false",
            }])
        ```

        ## Import

        Kubernetes edge cluster can be imported using the id, e.g. Then complete the main.tf accords to the result of `pulumi preview`.

        ```sh
        $ pulumi import alicloud:cs/edgeKubernetes:EdgeKubernetes main cluster-id
        ```

        :param str resource_name: The name of the resource.
        :param EdgeKubernetesArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EdgeKubernetesArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 addons: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EdgeKubernetesAddonArgs', 'EdgeKubernetesAddonArgsDict']]]]] = None,
                 availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 client_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 client_key: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_ca_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_spec: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 install_cloud_monitor: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_enterprise_security_group: Optional[pulumi.Input[_builtins.bool]] = None,
                 key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 kube_config: Optional[pulumi.Input[_builtins.str]] = None,
                 load_balancer_spec: Optional[pulumi.Input[_builtins.str]] = None,
                 log_config: Optional[pulumi.Input[Union['EdgeKubernetesLogConfigArgs', 'EdgeKubernetesLogConfigArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 new_nat_gateway: Optional[pulumi.Input[_builtins.bool]] = None,
                 node_cidr_mask: Optional[pulumi.Input[_builtins.int]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 pod_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 proxy_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 rds_instances: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 retain_resources: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 runtime: Optional[pulumi.Input[Union['EdgeKubernetesRuntimeArgs', 'EdgeKubernetesRuntimeArgsDict']]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 service_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_set_certificate_authority: Optional[pulumi.Input[_builtins.bool]] = None,
                 slb_internet_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 user_data: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 worker_data_disks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EdgeKubernetesWorkerDataDiskArgs', 'EdgeKubernetesWorkerDataDiskArgsDict']]]]] = None,
                 worker_disk_category: Optional[pulumi.Input[_builtins.str]] = None,
                 worker_disk_performance_level: Optional[pulumi.Input[_builtins.str]] = None,
                 worker_disk_size: Optional[pulumi.Input[_builtins.int]] = None,
                 worker_disk_snapshot_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 worker_instance_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 worker_instance_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 worker_number: Optional[pulumi.Input[_builtins.int]] = None,
                 worker_vswitch_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EdgeKubernetesArgs.__new__(EdgeKubernetesArgs)

            __props__.__dict__["addons"] = addons
            __props__.__dict__["availability_zone"] = availability_zone
            __props__.__dict__["client_cert"] = client_cert
            __props__.__dict__["client_key"] = client_key
            __props__.__dict__["cluster_ca_cert"] = cluster_ca_cert
            __props__.__dict__["cluster_spec"] = cluster_spec
            __props__.__dict__["deletion_protection"] = deletion_protection
            __props__.__dict__["install_cloud_monitor"] = install_cloud_monitor
            __props__.__dict__["is_enterprise_security_group"] = is_enterprise_security_group
            __props__.__dict__["key_name"] = key_name
            __props__.__dict__["kube_config"] = kube_config
            __props__.__dict__["load_balancer_spec"] = load_balancer_spec
            __props__.__dict__["log_config"] = log_config
            __props__.__dict__["name"] = name
            __props__.__dict__["name_prefix"] = name_prefix
            __props__.__dict__["new_nat_gateway"] = new_nat_gateway
            __props__.__dict__["node_cidr_mask"] = node_cidr_mask
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            __props__.__dict__["pod_cidr"] = pod_cidr
            __props__.__dict__["proxy_mode"] = proxy_mode
            __props__.__dict__["rds_instances"] = rds_instances
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["retain_resources"] = retain_resources
            __props__.__dict__["runtime"] = runtime
            __props__.__dict__["security_group_id"] = security_group_id
            __props__.__dict__["service_cidr"] = service_cidr
            __props__.__dict__["skip_set_certificate_authority"] = skip_set_certificate_authority
            __props__.__dict__["slb_internet_enabled"] = slb_internet_enabled
            __props__.__dict__["tags"] = tags
            __props__.__dict__["user_data"] = user_data
            __props__.__dict__["version"] = version
            __props__.__dict__["worker_data_disks"] = worker_data_disks
            __props__.__dict__["worker_disk_category"] = worker_disk_category
            __props__.__dict__["worker_disk_performance_level"] = worker_disk_performance_level
            __props__.__dict__["worker_disk_size"] = worker_disk_size
            __props__.__dict__["worker_disk_snapshot_policy_id"] = worker_disk_snapshot_policy_id
            __props__.__dict__["worker_instance_charge_type"] = worker_instance_charge_type
            if worker_instance_types is None and not opts.urn:
                raise TypeError("Missing required property 'worker_instance_types'")
            __props__.__dict__["worker_instance_types"] = worker_instance_types
            if worker_number is None and not opts.urn:
                raise TypeError("Missing required property 'worker_number'")
            __props__.__dict__["worker_number"] = worker_number
            if worker_vswitch_ids is None and not opts.urn:
                raise TypeError("Missing required property 'worker_vswitch_ids'")
            __props__.__dict__["worker_vswitch_ids"] = worker_vswitch_ids
            __props__.__dict__["certificate_authority"] = None
            __props__.__dict__["connections"] = None
            __props__.__dict__["nat_gateway_id"] = None
            __props__.__dict__["slb_internet"] = None
            __props__.__dict__["slb_intranet"] = None
            __props__.__dict__["vpc_id"] = None
            __props__.__dict__["worker_nodes"] = None
            __props__.__dict__["worker_ram_role_name"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(EdgeKubernetes, __self__).__init__(
            'alicloud:cs/edgeKubernetes:EdgeKubernetes',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            addons: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EdgeKubernetesAddonArgs', 'EdgeKubernetesAddonArgsDict']]]]] = None,
            availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
            certificate_authority: Optional[pulumi.Input[Union['EdgeKubernetesCertificateAuthorityArgs', 'EdgeKubernetesCertificateAuthorityArgsDict']]] = None,
            client_cert: Optional[pulumi.Input[_builtins.str]] = None,
            client_key: Optional[pulumi.Input[_builtins.str]] = None,
            cluster_ca_cert: Optional[pulumi.Input[_builtins.str]] = None,
            cluster_spec: Optional[pulumi.Input[_builtins.str]] = None,
            connections: Optional[pulumi.Input[Union['EdgeKubernetesConnectionsArgs', 'EdgeKubernetesConnectionsArgsDict']]] = None,
            deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
            install_cloud_monitor: Optional[pulumi.Input[_builtins.bool]] = None,
            is_enterprise_security_group: Optional[pulumi.Input[_builtins.bool]] = None,
            key_name: Optional[pulumi.Input[_builtins.str]] = None,
            kube_config: Optional[pulumi.Input[_builtins.str]] = None,
            load_balancer_spec: Optional[pulumi.Input[_builtins.str]] = None,
            log_config: Optional[pulumi.Input[Union['EdgeKubernetesLogConfigArgs', 'EdgeKubernetesLogConfigArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
            nat_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
            new_nat_gateway: Optional[pulumi.Input[_builtins.bool]] = None,
            node_cidr_mask: Optional[pulumi.Input[_builtins.int]] = None,
            password: Optional[pulumi.Input[_builtins.str]] = None,
            pod_cidr: Optional[pulumi.Input[_builtins.str]] = None,
            proxy_mode: Optional[pulumi.Input[_builtins.str]] = None,
            rds_instances: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            retain_resources: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            runtime: Optional[pulumi.Input[Union['EdgeKubernetesRuntimeArgs', 'EdgeKubernetesRuntimeArgsDict']]] = None,
            security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            service_cidr: Optional[pulumi.Input[_builtins.str]] = None,
            skip_set_certificate_authority: Optional[pulumi.Input[_builtins.bool]] = None,
            slb_internet: Optional[pulumi.Input[_builtins.str]] = None,
            slb_internet_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            slb_intranet: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            user_data: Optional[pulumi.Input[_builtins.str]] = None,
            version: Optional[pulumi.Input[_builtins.str]] = None,
            vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
            worker_data_disks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EdgeKubernetesWorkerDataDiskArgs', 'EdgeKubernetesWorkerDataDiskArgsDict']]]]] = None,
            worker_disk_category: Optional[pulumi.Input[_builtins.str]] = None,
            worker_disk_performance_level: Optional[pulumi.Input[_builtins.str]] = None,
            worker_disk_size: Optional[pulumi.Input[_builtins.int]] = None,
            worker_disk_snapshot_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
            worker_instance_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
            worker_instance_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            worker_nodes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EdgeKubernetesWorkerNodeArgs', 'EdgeKubernetesWorkerNodeArgsDict']]]]] = None,
            worker_number: Optional[pulumi.Input[_builtins.int]] = None,
            worker_ram_role_name: Optional[pulumi.Input[_builtins.str]] = None,
            worker_vswitch_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'EdgeKubernetes':
        """
        Get an existing EdgeKubernetes resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EdgeKubernetesAddonArgs', 'EdgeKubernetesAddonArgsDict']]]] addons: The addon you want to install in cluster. See `addons` below.
        :param pulumi.Input[_builtins.str] availability_zone: The ID of availability zone.
        :param pulumi.Input[Union['EdgeKubernetesCertificateAuthorityArgs', 'EdgeKubernetesCertificateAuthorityArgsDict']] certificate_authority: (Map, Deprecated from v1.248.0) Nested attribute containing certificate authority data for your cluster. Please use the attribute certificate_authority of new DataSource `cs_get_cluster_credential` to replace it.
        :param pulumi.Input[_builtins.str] client_cert: From version 1.248.0, new DataSource `cs_get_cluster_credential` is recommended to manage cluster's kubeconfig, you can also save the certificate_authority.client_cert attribute content of new DataSource `cs_get_cluster_credential` to an appropriate path(like ~/.kube/client-cert.pem) for replace it.
        :param pulumi.Input[_builtins.str] client_key: From version 1.248.0, new DataSource `cs_get_cluster_credential` is recommended to manage cluster's kubeconfig, you can also save the certificate_authority.client_key attribute content of new DataSource `cs_get_cluster_credential` to an appropriate path(like ~/.kube/client-key.pem) for replace it.
        :param pulumi.Input[_builtins.str] cluster_ca_cert: From version 1.248.0, new DataSource `cs_get_cluster_credential` is recommended to manage cluster's kubeconfig, you can also save the certificate_authority.cluster_cert attribute content of new DataSource `cs_get_cluster_credential` to an appropriate path(like ~/.kube/cluster-ca-cert.pem) for replace it.
               
               *Removed params*
        :param pulumi.Input[_builtins.str] cluster_spec: The cluster specifications of kubernetes cluster,which can be empty. Valid values:
               * ack.standard : Standard edge clusters.
               * ack.pro.small : Professional edge clusters.
        :param pulumi.Input[Union['EdgeKubernetesConnectionsArgs', 'EdgeKubernetesConnectionsArgsDict']] connections: (Map) Map of kubernetes cluster connection information.
        :param pulumi.Input[_builtins.bool] deletion_protection: Whether to enable cluster deletion protection.
        :param pulumi.Input[_builtins.bool] install_cloud_monitor: Install cloud monitor agent on ECS. default: `true`.
        :param pulumi.Input[_builtins.bool] is_enterprise_security_group: Enable to create advanced security group. default: false. See [Advanced security group](https://www.alibabacloud.com/help/doc-detail/120621.htm).
        :param pulumi.Input[_builtins.str] key_name: The keypair of ssh login cluster node, you have to create it first. You have to specify one of `password` `key_name` `kms_encrypted_password` fields.
        :param pulumi.Input[_builtins.str] kube_config: The path of kube config, like ~/.kube/config. Please use the attribute output_file of new DataSource `cs_get_cluster_credential` to replace it.
        :param pulumi.Input[_builtins.str] load_balancer_spec: The cluster api server load balance instance specification. For more information on how to select a LB instance specification, see [SLB instance overview](https://help.aliyun.com/document_detail/85931.html).
               ->NOTE: If you want to use `Flannel` as CNI network plugin, You need to specific the `pod_cidr` field and addons with `flannel`.
               
               *Worker params*
        :param pulumi.Input[Union['EdgeKubernetesLogConfigArgs', 'EdgeKubernetesLogConfigArgsDict']] log_config: A list of one element containing information about the associated log store. See `log_config` below.
        :param pulumi.Input[_builtins.str] name: The kubernetes cluster's name. It is unique in one Alicloud account.
        :param pulumi.Input[_builtins.str] nat_gateway_id: The ID of nat gateway used to launch kubernetes cluster.
        :param pulumi.Input[_builtins.bool] new_nat_gateway: Whether to create a new nat gateway while creating kubernetes cluster. Default to true. Then openapi in Alibaba Cloud are not all on intranet, So turn this option on is a good choice.
        :param pulumi.Input[_builtins.int] node_cidr_mask: The node cidr block to specific how many pods can run on single node. 24-28 is allowed. 24 means 2^(32-24)-1=255 and the node can run at most 255 pods. default: 24
        :param pulumi.Input[_builtins.str] password: The password of ssh login cluster node. You have to specify one of `password`, `key_name` `kms_encrypted_password` fields.
        :param pulumi.Input[_builtins.str] pod_cidr: [Flannel Specific] The CIDR block for the pod network when using Flannel.
        :param pulumi.Input[_builtins.str] proxy_mode: Proxy mode is option of kube-proxy. options: iptables|ipvs. default: ipvs.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] rds_instances: RDS instance list, You can choose which RDS instances whitelist to add instances to.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group,by default these cloud resources are automatically assigned to the default resource group.
        :param pulumi.Input[Union['EdgeKubernetesRuntimeArgs', 'EdgeKubernetesRuntimeArgsDict']] runtime: The runtime of containers. If you select another container runtime, see [Comparison of Docker, containerd, and Sandboxed-Container](https://www.alibabacloud.com/help/doc-detail/160313.htm). See `runtime` below.
        :param pulumi.Input[_builtins.str] security_group_id: The ID of the security group to which the ECS instances in the cluster belong. If it is not specified, a new Security group will be built.
        :param pulumi.Input[_builtins.str] service_cidr: The CIDR block for the service network. It cannot be duplicated with the VPC CIDR and CIDR used by Kubernetes cluster in VPC, cannot be modified after creation.
        :param pulumi.Input[_builtins.bool] skip_set_certificate_authority: Configure whether to save certificate authority data for your cluster to attribute `certificate_authority`. For cluster security, recommended configuration as `true`. Will be removed with attribute certificate_authority removed.
               
               *Network params*
        :param pulumi.Input[_builtins.str] slb_internet: The public ip of load balancer.
        :param pulumi.Input[_builtins.bool] slb_internet_enabled: Whether to create internet load balancer for API Server. Default to true.
        :param pulumi.Input[_builtins.str] slb_intranet: The ID of private load balancer where the current cluster master node is located.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Default nil, A map of tags assigned to the kubernetes cluster and work node.
        :param pulumi.Input[_builtins.str] user_data: Windows instances support batch and PowerShell scripts. If your script file is larger than 1 KB, we recommend that you upload the script to Object Storage Service (OSS) and pull it through the internal endpoint of your OSS bucket.
        :param pulumi.Input[_builtins.str] version: Desired Kubernetes version. If you do not specify a value, the latest available version at resource creation is used and no upgrades will occur except you set a higher version number. The value must be configured and increased to upgrade the version when desired. Downgrades are not supported by ACK.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of VPC where the current cluster is located.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EdgeKubernetesWorkerDataDiskArgs', 'EdgeKubernetesWorkerDataDiskArgsDict']]]] worker_data_disks: The data disk configurations of worker nodes, such as the disk type and disk size. See `worker_data_disks` below.
        :param pulumi.Input[_builtins.str] worker_disk_category: The system disk category of worker node. Its valid value are `cloud_efficiency`, `cloud_ssd` and `cloud_essd` and . Default to `cloud_efficiency`.
        :param pulumi.Input[_builtins.str] worker_disk_performance_level: Worker node system disk performance level, when `worker_disk_category` values `cloud_essd`, the optional values are `PL0`, `PL1`, `PL2` or `PL3`, but the specific performance level is related to the disk capacity. For more information, see [Enhanced SSDs](https://www.alibabacloud.com/help/doc-detail/122389.htm). Default is `PL1`.
        :param pulumi.Input[_builtins.int] worker_disk_size: The system disk size of worker node. Its valid value range [20~32768] in GB. Default to 40.
        :param pulumi.Input[_builtins.str] worker_disk_snapshot_policy_id: Worker node system disk auto snapshot policy.
               
               *Computed params*
               
               You can set some file paths to save kube_config information, but this way is cumbersome. Since version 1.105.0, we've written it to tf state file. About its use，see export attribute certificate_authority. From version 1.187.0+, new DataSource `cs_get_cluster_credential` is recommended to manage cluster's kube_config.
        :param pulumi.Input[_builtins.str] worker_instance_charge_type: Worker payment type, its valid value is `PostPaid`. Defaults to `PostPaid`. More charge details in [ACK@edge charge](https://help.aliyun.com/document_detail/178718.html).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] worker_instance_types: The instance types of worker node, you can set multiple types to avoid NoStock of a certain type.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EdgeKubernetesWorkerNodeArgs', 'EdgeKubernetesWorkerNodeArgsDict']]]] worker_nodes: List of cluster worker nodes.
        :param pulumi.Input[_builtins.int] worker_number: The cloud worker node number of the edge kubernetes cluster. Default to 1. It is limited up to 50 and if you want to enlarge it, please apply white list or contact with us.
        :param pulumi.Input[_builtins.str] worker_ram_role_name: The RamRole Name attached to worker node.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] worker_vswitch_ids: The vswitches used by workers.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EdgeKubernetesState.__new__(_EdgeKubernetesState)

        __props__.__dict__["addons"] = addons
        __props__.__dict__["availability_zone"] = availability_zone
        __props__.__dict__["certificate_authority"] = certificate_authority
        __props__.__dict__["client_cert"] = client_cert
        __props__.__dict__["client_key"] = client_key
        __props__.__dict__["cluster_ca_cert"] = cluster_ca_cert
        __props__.__dict__["cluster_spec"] = cluster_spec
        __props__.__dict__["connections"] = connections
        __props__.__dict__["deletion_protection"] = deletion_protection
        __props__.__dict__["install_cloud_monitor"] = install_cloud_monitor
        __props__.__dict__["is_enterprise_security_group"] = is_enterprise_security_group
        __props__.__dict__["key_name"] = key_name
        __props__.__dict__["kube_config"] = kube_config
        __props__.__dict__["load_balancer_spec"] = load_balancer_spec
        __props__.__dict__["log_config"] = log_config
        __props__.__dict__["name"] = name
        __props__.__dict__["name_prefix"] = name_prefix
        __props__.__dict__["nat_gateway_id"] = nat_gateway_id
        __props__.__dict__["new_nat_gateway"] = new_nat_gateway
        __props__.__dict__["node_cidr_mask"] = node_cidr_mask
        __props__.__dict__["password"] = password
        __props__.__dict__["pod_cidr"] = pod_cidr
        __props__.__dict__["proxy_mode"] = proxy_mode
        __props__.__dict__["rds_instances"] = rds_instances
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["retain_resources"] = retain_resources
        __props__.__dict__["runtime"] = runtime
        __props__.__dict__["security_group_id"] = security_group_id
        __props__.__dict__["service_cidr"] = service_cidr
        __props__.__dict__["skip_set_certificate_authority"] = skip_set_certificate_authority
        __props__.__dict__["slb_internet"] = slb_internet
        __props__.__dict__["slb_internet_enabled"] = slb_internet_enabled
        __props__.__dict__["slb_intranet"] = slb_intranet
        __props__.__dict__["tags"] = tags
        __props__.__dict__["user_data"] = user_data
        __props__.__dict__["version"] = version
        __props__.__dict__["vpc_id"] = vpc_id
        __props__.__dict__["worker_data_disks"] = worker_data_disks
        __props__.__dict__["worker_disk_category"] = worker_disk_category
        __props__.__dict__["worker_disk_performance_level"] = worker_disk_performance_level
        __props__.__dict__["worker_disk_size"] = worker_disk_size
        __props__.__dict__["worker_disk_snapshot_policy_id"] = worker_disk_snapshot_policy_id
        __props__.__dict__["worker_instance_charge_type"] = worker_instance_charge_type
        __props__.__dict__["worker_instance_types"] = worker_instance_types
        __props__.__dict__["worker_nodes"] = worker_nodes
        __props__.__dict__["worker_number"] = worker_number
        __props__.__dict__["worker_ram_role_name"] = worker_ram_role_name
        __props__.__dict__["worker_vswitch_ids"] = worker_vswitch_ids
        return EdgeKubernetes(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def addons(self) -> pulumi.Output[Optional[Sequence['outputs.EdgeKubernetesAddon']]]:
        """
        The addon you want to install in cluster. See `addons` below.
        """
        return pulumi.get(self, "addons")

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of availability zone.
        """
        return pulumi.get(self, "availability_zone")

    @_builtins.property
    @pulumi.getter(name="certificateAuthority")
    @_utilities.deprecated("""Field 'certificate_authority' has been deprecated from provider version 1.248.0. Please use the attribute 'certificate_authority' of new DataSource 'alicloud_cs_cluster_credential' to replace it.""")
    def certificate_authority(self) -> pulumi.Output['outputs.EdgeKubernetesCertificateAuthority']:
        """
        (Map, Deprecated from v1.248.0) Nested attribute containing certificate authority data for your cluster. Please use the attribute certificate_authority of new DataSource `cs_get_cluster_credential` to replace it.
        """
        return pulumi.get(self, "certificate_authority")

    @_builtins.property
    @pulumi.getter(name="clientCert")
    @_utilities.deprecated("""Field 'client_cert' has been deprecated from provider version 1.248.0. From version 1.248.0, new DataSource 'alicloud_cs_cluster_credential' is recommended to manage cluster's kubeconfig, you can also save the 'certificate_authority.client_cert' attribute content of new DataSource 'alicloud_cs_cluster_credential' to an appropriate path(like ~/.kube/client-cert.pem) for replace it.""")
    def client_cert(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        From version 1.248.0, new DataSource `cs_get_cluster_credential` is recommended to manage cluster's kubeconfig, you can also save the certificate_authority.client_cert attribute content of new DataSource `cs_get_cluster_credential` to an appropriate path(like ~/.kube/client-cert.pem) for replace it.
        """
        return pulumi.get(self, "client_cert")

    @_builtins.property
    @pulumi.getter(name="clientKey")
    @_utilities.deprecated("""Field 'client_key' has been deprecated from provider version 1.248.0. From version 1.248.0, new DataSource 'alicloud_cs_cluster_credential' is recommended to manage cluster's kubeconfig, you can also save the 'certificate_authority.client_key' attribute content of new DataSource 'alicloud_cs_cluster_credential' to an appropriate path(like ~/.kube/client-key.pem) for replace it.""")
    def client_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        From version 1.248.0, new DataSource `cs_get_cluster_credential` is recommended to manage cluster's kubeconfig, you can also save the certificate_authority.client_key attribute content of new DataSource `cs_get_cluster_credential` to an appropriate path(like ~/.kube/client-key.pem) for replace it.
        """
        return pulumi.get(self, "client_key")

    @_builtins.property
    @pulumi.getter(name="clusterCaCert")
    @_utilities.deprecated("""Field 'cluster_ca_cert' has been deprecated from provider version 1.248.0. From version 1.248.0, new DataSource 'alicloud_cs_cluster_credential' is recommended to manage cluster's kubeconfig, you can also save the 'certificate_authority.cluster_cert' attribute content of new DataSource 'alicloud_cs_cluster_credential' to an appropriate path(like ~/.kube/cluster-ca-cert.pem) for replace it.""")
    def cluster_ca_cert(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        From version 1.248.0, new DataSource `cs_get_cluster_credential` is recommended to manage cluster's kubeconfig, you can also save the certificate_authority.cluster_cert attribute content of new DataSource `cs_get_cluster_credential` to an appropriate path(like ~/.kube/cluster-ca-cert.pem) for replace it.

        *Removed params*
        """
        return pulumi.get(self, "cluster_ca_cert")

    @_builtins.property
    @pulumi.getter(name="clusterSpec")
    def cluster_spec(self) -> pulumi.Output[_builtins.str]:
        """
        The cluster specifications of kubernetes cluster,which can be empty. Valid values:
        * ack.standard : Standard edge clusters.
        * ack.pro.small : Professional edge clusters.
        """
        return pulumi.get(self, "cluster_spec")

    @_builtins.property
    @pulumi.getter
    def connections(self) -> pulumi.Output['outputs.EdgeKubernetesConnections']:
        """
        (Map) Map of kubernetes cluster connection information.
        """
        return pulumi.get(self, "connections")

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to enable cluster deletion protection.
        """
        return pulumi.get(self, "deletion_protection")

    @_builtins.property
    @pulumi.getter(name="installCloudMonitor")
    def install_cloud_monitor(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Install cloud monitor agent on ECS. default: `true`.
        """
        return pulumi.get(self, "install_cloud_monitor")

    @_builtins.property
    @pulumi.getter(name="isEnterpriseSecurityGroup")
    def is_enterprise_security_group(self) -> pulumi.Output[_builtins.bool]:
        """
        Enable to create advanced security group. default: false. See [Advanced security group](https://www.alibabacloud.com/help/doc-detail/120621.htm).
        """
        return pulumi.get(self, "is_enterprise_security_group")

    @_builtins.property
    @pulumi.getter(name="keyName")
    def key_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The keypair of ssh login cluster node, you have to create it first. You have to specify one of `password` `key_name` `kms_encrypted_password` fields.
        """
        return pulumi.get(self, "key_name")

    @_builtins.property
    @pulumi.getter(name="kubeConfig")
    @_utilities.deprecated("""Field 'kube_config' has been deprecated from provider version 1.187.0. Please use the attribute 'output_file' of new DataSource 'alicloud_cs_cluster_credential' to replace it.""")
    def kube_config(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The path of kube config, like ~/.kube/config. Please use the attribute output_file of new DataSource `cs_get_cluster_credential` to replace it.
        """
        return pulumi.get(self, "kube_config")

    @_builtins.property
    @pulumi.getter(name="loadBalancerSpec")
    def load_balancer_spec(self) -> pulumi.Output[_builtins.str]:
        """
        The cluster api server load balance instance specification. For more information on how to select a LB instance specification, see [SLB instance overview](https://help.aliyun.com/document_detail/85931.html).
        ->NOTE: If you want to use `Flannel` as CNI network plugin, You need to specific the `pod_cidr` field and addons with `flannel`.

        *Worker params*
        """
        return pulumi.get(self, "load_balancer_spec")

    @_builtins.property
    @pulumi.getter(name="logConfig")
    @_utilities.deprecated("""Field 'log_config' has been removed from provider version 1.103.0. New field 'addons' replaces it.""")
    def log_config(self) -> pulumi.Output[Optional['outputs.EdgeKubernetesLogConfig']]:
        """
        A list of one element containing information about the associated log store. See `log_config` below.
        """
        return pulumi.get(self, "log_config")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The kubernetes cluster's name. It is unique in one Alicloud account.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "name_prefix")

    @_builtins.property
    @pulumi.getter(name="natGatewayId")
    def nat_gateway_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of nat gateway used to launch kubernetes cluster.
        """
        return pulumi.get(self, "nat_gateway_id")

    @_builtins.property
    @pulumi.getter(name="newNatGateway")
    def new_nat_gateway(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to create a new nat gateway while creating kubernetes cluster. Default to true. Then openapi in Alibaba Cloud are not all on intranet, So turn this option on is a good choice.
        """
        return pulumi.get(self, "new_nat_gateway")

    @_builtins.property
    @pulumi.getter(name="nodeCidrMask")
    def node_cidr_mask(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The node cidr block to specific how many pods can run on single node. 24-28 is allowed. 24 means 2^(32-24)-1=255 and the node can run at most 255 pods. default: 24
        """
        return pulumi.get(self, "node_cidr_mask")

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The password of ssh login cluster node. You have to specify one of `password`, `key_name` `kms_encrypted_password` fields.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter(name="podCidr")
    def pod_cidr(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        [Flannel Specific] The CIDR block for the pod network when using Flannel.
        """
        return pulumi.get(self, "pod_cidr")

    @_builtins.property
    @pulumi.getter(name="proxyMode")
    def proxy_mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Proxy mode is option of kube-proxy. options: iptables|ipvs. default: ipvs.
        """
        return pulumi.get(self, "proxy_mode")

    @_builtins.property
    @pulumi.getter(name="rdsInstances")
    def rds_instances(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        RDS instance list, You can choose which RDS instances whitelist to add instances to.
        """
        return pulumi.get(self, "rds_instances")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the resource group,by default these cloud resources are automatically assigned to the default resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="retainResources")
    def retain_resources(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        return pulumi.get(self, "retain_resources")

    @_builtins.property
    @pulumi.getter
    def runtime(self) -> pulumi.Output[Optional['outputs.EdgeKubernetesRuntime']]:
        """
        The runtime of containers. If you select another container runtime, see [Comparison of Docker, containerd, and Sandboxed-Container](https://www.alibabacloud.com/help/doc-detail/160313.htm). See `runtime` below.
        """
        return pulumi.get(self, "runtime")

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the security group to which the ECS instances in the cluster belong. If it is not specified, a new Security group will be built.
        """
        return pulumi.get(self, "security_group_id")

    @_builtins.property
    @pulumi.getter(name="serviceCidr")
    def service_cidr(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The CIDR block for the service network. It cannot be duplicated with the VPC CIDR and CIDR used by Kubernetes cluster in VPC, cannot be modified after creation.
        """
        return pulumi.get(self, "service_cidr")

    @_builtins.property
    @pulumi.getter(name="skipSetCertificateAuthority")
    def skip_set_certificate_authority(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Configure whether to save certificate authority data for your cluster to attribute `certificate_authority`. For cluster security, recommended configuration as `true`. Will be removed with attribute certificate_authority removed.

        *Network params*
        """
        return pulumi.get(self, "skip_set_certificate_authority")

    @_builtins.property
    @pulumi.getter(name="slbInternet")
    def slb_internet(self) -> pulumi.Output[_builtins.str]:
        """
        The public ip of load balancer.
        """
        return pulumi.get(self, "slb_internet")

    @_builtins.property
    @pulumi.getter(name="slbInternetEnabled")
    def slb_internet_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to create internet load balancer for API Server. Default to true.
        """
        return pulumi.get(self, "slb_internet_enabled")

    @_builtins.property
    @pulumi.getter(name="slbIntranet")
    def slb_intranet(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of private load balancer where the current cluster master node is located.
        """
        return pulumi.get(self, "slb_intranet")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Default nil, A map of tags assigned to the kubernetes cluster and work node.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="userData")
    def user_data(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Windows instances support batch and PowerShell scripts. If your script file is larger than 1 KB, we recommend that you upload the script to Object Storage Service (OSS) and pull it through the internal endpoint of your OSS bucket.
        """
        return pulumi.get(self, "user_data")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[_builtins.str]:
        """
        Desired Kubernetes version. If you do not specify a value, the latest available version at resource creation is used and no upgrades will occur except you set a higher version number. The value must be configured and increased to upgrade the version when desired. Downgrades are not supported by ACK.
        """
        return pulumi.get(self, "version")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of VPC where the current cluster is located.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="workerDataDisks")
    def worker_data_disks(self) -> pulumi.Output[Optional[Sequence['outputs.EdgeKubernetesWorkerDataDisk']]]:
        """
        The data disk configurations of worker nodes, such as the disk type and disk size. See `worker_data_disks` below.
        """
        return pulumi.get(self, "worker_data_disks")

    @_builtins.property
    @pulumi.getter(name="workerDiskCategory")
    def worker_disk_category(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The system disk category of worker node. Its valid value are `cloud_efficiency`, `cloud_ssd` and `cloud_essd` and . Default to `cloud_efficiency`.
        """
        return pulumi.get(self, "worker_disk_category")

    @_builtins.property
    @pulumi.getter(name="workerDiskPerformanceLevel")
    def worker_disk_performance_level(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Worker node system disk performance level, when `worker_disk_category` values `cloud_essd`, the optional values are `PL0`, `PL1`, `PL2` or `PL3`, but the specific performance level is related to the disk capacity. For more information, see [Enhanced SSDs](https://www.alibabacloud.com/help/doc-detail/122389.htm). Default is `PL1`.
        """
        return pulumi.get(self, "worker_disk_performance_level")

    @_builtins.property
    @pulumi.getter(name="workerDiskSize")
    def worker_disk_size(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The system disk size of worker node. Its valid value range [20~32768] in GB. Default to 40.
        """
        return pulumi.get(self, "worker_disk_size")

    @_builtins.property
    @pulumi.getter(name="workerDiskSnapshotPolicyId")
    def worker_disk_snapshot_policy_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Worker node system disk auto snapshot policy.

        *Computed params*

        You can set some file paths to save kube_config information, but this way is cumbersome. Since version 1.105.0, we've written it to tf state file. About its use，see export attribute certificate_authority. From version 1.187.0+, new DataSource `cs_get_cluster_credential` is recommended to manage cluster's kube_config.
        """
        return pulumi.get(self, "worker_disk_snapshot_policy_id")

    @_builtins.property
    @pulumi.getter(name="workerInstanceChargeType")
    def worker_instance_charge_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Worker payment type, its valid value is `PostPaid`. Defaults to `PostPaid`. More charge details in [ACK@edge charge](https://help.aliyun.com/document_detail/178718.html).
        """
        return pulumi.get(self, "worker_instance_charge_type")

    @_builtins.property
    @pulumi.getter(name="workerInstanceTypes")
    def worker_instance_types(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The instance types of worker node, you can set multiple types to avoid NoStock of a certain type.
        """
        return pulumi.get(self, "worker_instance_types")

    @_builtins.property
    @pulumi.getter(name="workerNodes")
    def worker_nodes(self) -> pulumi.Output[Sequence['outputs.EdgeKubernetesWorkerNode']]:
        """
        List of cluster worker nodes.
        """
        return pulumi.get(self, "worker_nodes")

    @_builtins.property
    @pulumi.getter(name="workerNumber")
    def worker_number(self) -> pulumi.Output[_builtins.int]:
        """
        The cloud worker node number of the edge kubernetes cluster. Default to 1. It is limited up to 50 and if you want to enlarge it, please apply white list or contact with us.
        """
        return pulumi.get(self, "worker_number")

    @_builtins.property
    @pulumi.getter(name="workerRamRoleName")
    def worker_ram_role_name(self) -> pulumi.Output[_builtins.str]:
        """
        The RamRole Name attached to worker node.
        """
        return pulumi.get(self, "worker_ram_role_name")

    @_builtins.property
    @pulumi.getter(name="workerVswitchIds")
    def worker_vswitch_ids(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The vswitches used by workers.
        """
        return pulumi.get(self, "worker_vswitch_ids")

