# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetKubernetesClustersResult',
    'AwaitableGetKubernetesClustersResult',
    'get_kubernetes_clusters',
    'get_kubernetes_clusters_output',
]

@pulumi.output_type
class GetKubernetesClustersResult:
    """
    A collection of values returned by getKubernetesClusters.
    """
    def __init__(__self__, clusters=None, enable_details=None, id=None, ids=None, kube_config_file_prefix=None, name_regex=None, names=None, output_file=None):
        if clusters and not isinstance(clusters, list):
            raise TypeError("Expected argument 'clusters' to be a list")
        pulumi.set(__self__, "clusters", clusters)
        if enable_details and not isinstance(enable_details, bool):
            raise TypeError("Expected argument 'enable_details' to be a bool")
        pulumi.set(__self__, "enable_details", enable_details)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if kube_config_file_prefix and not isinstance(kube_config_file_prefix, str):
            raise TypeError("Expected argument 'kube_config_file_prefix' to be a str")
        pulumi.set(__self__, "kube_config_file_prefix", kube_config_file_prefix)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)

    @_builtins.property
    @pulumi.getter
    def clusters(self) -> Sequence['outputs.GetKubernetesClustersClusterResult']:
        """
        A list of matched Kubernetes clusters. Each element contains the following attributes:
        """
        return pulumi.get(self, "clusters")

    @_builtins.property
    @pulumi.getter(name="enableDetails")
    def enable_details(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "enable_details")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        """
        A list of matched Kubernetes clusters' ids.
        """
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="kubeConfigFilePrefix")
    @_utilities.deprecated("""Field 'kube_config_file_prefix' has been deprecated from provider version 1.243.0. From version 1.243.0, please use the attribute 'output_file' of new DataSource 'alicloud_cs_cluster_credential' to replace it.""")
    def kube_config_file_prefix(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "kube_config_file_prefix")

    @_builtins.property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name_regex")

    @_builtins.property
    @pulumi.getter
    def names(self) -> Sequence[_builtins.str]:
        """
        A list of matched Kubernetes clusters' names.
        """
        return pulumi.get(self, "names")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")


class AwaitableGetKubernetesClustersResult(GetKubernetesClustersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetKubernetesClustersResult(
            clusters=self.clusters,
            enable_details=self.enable_details,
            id=self.id,
            ids=self.ids,
            kube_config_file_prefix=self.kube_config_file_prefix,
            name_regex=self.name_regex,
            names=self.names,
            output_file=self.output_file)


def get_kubernetes_clusters(enable_details: Optional[_builtins.bool] = None,
                            ids: Optional[Sequence[_builtins.str]] = None,
                            kube_config_file_prefix: Optional[_builtins.str] = None,
                            name_regex: Optional[_builtins.str] = None,
                            output_file: Optional[_builtins.str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetKubernetesClustersResult:
    """
    This data source provides a list Container Service Kubernetes Clusters on Alibaba Cloud.

    > **NOTE:** Available since v1.34.0.

    > **NOTE:** From version 1.177.0+, We supported batch export of clusters' kube config information by `kube_config_file_prefix`.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    # Declare the data source
    k8s_clusters = alicloud.cs.get_kubernetes_clusters(name_regex="my-first-k8s",
        output_file="my-first-k8s-json",
        kube_config_file_prefix="~/.kube/k8s")
    pulumi.export("output", k8s_clusters.clusters)
    ```


    :param _builtins.bool enable_details: Boolean, false by default, only `id` and `name` are exported. Set to true if more details are needed, e.g., `master_disk_category`, `slb_internet_enabled`, `connections`. See full list in attributes.
    :param Sequence[_builtins.str] ids: Cluster IDs to filter.
    :param _builtins.str kube_config_file_prefix: The path prefix of kube config. You could store kube config in a specified directory by specifying this field, like `~/.kube/k8s`, then it will be named with `~/.kube/k8s-clusterID-kubeconfig`. From version 1.243.0, kube_config will not export kube_config if this field is not set. Please use the attribute output_file of new DataSource `cs_get_cluster_credential` to replace it.
    :param _builtins.str name_regex: A regex string to filter results by cluster name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    """
    __args__ = dict()
    __args__['enableDetails'] = enable_details
    __args__['ids'] = ids
    __args__['kubeConfigFilePrefix'] = kube_config_file_prefix
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:cs/getKubernetesClusters:getKubernetesClusters', __args__, opts=opts, typ=GetKubernetesClustersResult).value

    return AwaitableGetKubernetesClustersResult(
        clusters=pulumi.get(__ret__, 'clusters'),
        enable_details=pulumi.get(__ret__, 'enable_details'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        kube_config_file_prefix=pulumi.get(__ret__, 'kube_config_file_prefix'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        output_file=pulumi.get(__ret__, 'output_file'))
def get_kubernetes_clusters_output(enable_details: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                                   ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                   kube_config_file_prefix: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                   name_regex: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                   output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetKubernetesClustersResult]:
    """
    This data source provides a list Container Service Kubernetes Clusters on Alibaba Cloud.

    > **NOTE:** Available since v1.34.0.

    > **NOTE:** From version 1.177.0+, We supported batch export of clusters' kube config information by `kube_config_file_prefix`.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    # Declare the data source
    k8s_clusters = alicloud.cs.get_kubernetes_clusters(name_regex="my-first-k8s",
        output_file="my-first-k8s-json",
        kube_config_file_prefix="~/.kube/k8s")
    pulumi.export("output", k8s_clusters.clusters)
    ```


    :param _builtins.bool enable_details: Boolean, false by default, only `id` and `name` are exported. Set to true if more details are needed, e.g., `master_disk_category`, `slb_internet_enabled`, `connections`. See full list in attributes.
    :param Sequence[_builtins.str] ids: Cluster IDs to filter.
    :param _builtins.str kube_config_file_prefix: The path prefix of kube config. You could store kube config in a specified directory by specifying this field, like `~/.kube/k8s`, then it will be named with `~/.kube/k8s-clusterID-kubeconfig`. From version 1.243.0, kube_config will not export kube_config if this field is not set. Please use the attribute output_file of new DataSource `cs_get_cluster_credential` to replace it.
    :param _builtins.str name_regex: A regex string to filter results by cluster name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    """
    __args__ = dict()
    __args__['enableDetails'] = enable_details
    __args__['ids'] = ids
    __args__['kubeConfigFilePrefix'] = kube_config_file_prefix
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:cs/getKubernetesClusters:getKubernetesClusters', __args__, opts=opts, typ=GetKubernetesClustersResult)
    return __ret__.apply(lambda __response__: GetKubernetesClustersResult(
        clusters=pulumi.get(__response__, 'clusters'),
        enable_details=pulumi.get(__response__, 'enable_details'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        kube_config_file_prefix=pulumi.get(__response__, 'kube_config_file_prefix'),
        name_regex=pulumi.get(__response__, 'name_regex'),
        names=pulumi.get(__response__, 'names'),
        output_file=pulumi.get(__response__, 'output_file')))
