# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ApplicationService',
    'ClusterNode',
    'EdgeKubernetesAddon',
    'EdgeKubernetesCertificateAuthority',
    'EdgeKubernetesConnections',
    'EdgeKubernetesLogConfig',
    'EdgeKubernetesRuntime',
    'EdgeKubernetesWorkerDataDisk',
    'EdgeKubernetesWorkerNode',
    'KubernetesAddon',
    'KubernetesAutoscalerNodepool',
    'KubernetesCertificateAuthority',
    'KubernetesConnections',
    'KubernetesDeleteOption',
    'KubernetesMasterNode',
    'KubernetesPermissionPermission',
    'KubernetesRuntime',
    'ManagedKubernetesAddon',
    'ManagedKubernetesAuditLogConfig',
    'ManagedKubernetesCertificateAuthority',
    'ManagedKubernetesConnections',
    'ManagedKubernetesDeleteOption',
    'ManagedKubernetesMaintenanceWindow',
    'ManagedKubernetesOperationPolicy',
    'ManagedKubernetesOperationPolicyClusterAutoUpgrade',
    'ManagedKubernetesRrsaMetadata',
    'NodePoolDataDisk',
    'NodePoolEfloNodeGroup',
    'NodePoolKubeletConfiguration',
    'NodePoolKubeletConfigurationReservedMemory',
    'NodePoolKubeletConfigurationTracing',
    'NodePoolLabel',
    'NodePoolManagement',
    'NodePoolManagementAutoRepairPolicy',
    'NodePoolManagementAutoUpgradePolicy',
    'NodePoolManagementAutoVulFixPolicy',
    'NodePoolPrivatePoolOptions',
    'NodePoolRollingPolicy',
    'NodePoolScalingConfig',
    'NodePoolSpotPriceLimit',
    'NodePoolTaint',
    'NodePoolTeeConfig',
    'ServerlessKubernetesAddon',
    'ServerlessKubernetesDeleteOption',
    'ServerlessKubernetesMaintenanceWindow',
    'ServerlessKubernetesOperationPolicy',
    'ServerlessKubernetesOperationPolicyClusterAutoUpgrade',
    'ServerlessKubernetesRrsaMetadata',
    'SwarmNode',
    'GetClusterCredentialCertificateAuthorityResult',
    'GetEdgeKubernetesClustersClusterResult',
    'GetEdgeKubernetesClustersClusterConnectionsResult',
    'GetEdgeKubernetesClustersClusterWorkerNodeResult',
    'GetKubernetesAddonsAddonResult',
    'GetKubernetesClustersClusterResult',
    'GetKubernetesClustersClusterConnectionsResult',
    'GetKubernetesClustersClusterLogConfigResult',
    'GetKubernetesClustersClusterMasterNodeResult',
    'GetKubernetesClustersClusterWorkerNodeResult',
    'GetKubernetesNodePoolsNodepoolResult',
    'GetKubernetesNodePoolsNodepoolDataDiskResult',
    'GetKubernetesNodePoolsNodepoolKubeletConfigurationResult',
    'GetKubernetesNodePoolsNodepoolKubeletConfigurationReservedMemoryResult',
    'GetKubernetesNodePoolsNodepoolKubeletConfigurationTracingResult',
    'GetKubernetesNodePoolsNodepoolLabelResult',
    'GetKubernetesNodePoolsNodepoolManagementResult',
    'GetKubernetesNodePoolsNodepoolManagementAutoRepairPolicyResult',
    'GetKubernetesNodePoolsNodepoolManagementAutoUpgradePolicyResult',
    'GetKubernetesNodePoolsNodepoolManagementAutoVulFixPolicyResult',
    'GetKubernetesNodePoolsNodepoolPrivatePoolOptionsResult',
    'GetKubernetesNodePoolsNodepoolScalingConfigResult',
    'GetKubernetesNodePoolsNodepoolSpotPriceLimitResult',
    'GetKubernetesNodePoolsNodepoolTaintResult',
    'GetKubernetesNodePoolsNodepoolTeeConfigResult',
    'GetKubernetesPermissionPermissionResult',
    'GetKubernetesVersionMetadataResult',
    'GetKubernetesVersionMetadataRuntimeResult',
    'GetManagedKubernetesClustersClusterResult',
    'GetManagedKubernetesClustersClusterConnectionsResult',
    'GetManagedKubernetesClustersClusterLogConfigResult',
    'GetManagedKubernetesClustersClusterRrsaConfigResult',
    'GetManagedKubernetesClustersClusterWorkerNodeResult',
    'GetRegistryEnterpriseInstancesInstanceResult',
    'GetRegistryEnterpriseNamespacesNamespaceResult',
    'GetRegistryEnterpriseReposRepoResult',
    'GetRegistryEnterpriseReposRepoTagResult',
    'GetRegistryEnterpriseSyncRulesRuleResult',
    'GetServerlessKubernetesClustersClusterResult',
    'GetServerlessKubernetesClustersClusterConnectionsResult',
]

@pulumi.output_type
class ApplicationService(dict):
    def __init__(__self__, *,
                 id: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 status: Optional[_builtins.str] = None,
                 version: Optional[_builtins.str] = None):
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "version")


@pulumi.output_type
class ClusterNode(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateIp":
            suggest = "private_ip"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterNode. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterNode.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterNode.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 eip: Optional[_builtins.str] = None,
                 id: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 private_ip: Optional[_builtins.str] = None,
                 status: Optional[_builtins.str] = None):
        if eip is not None:
            pulumi.set(__self__, "eip", eip)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_ip is not None:
            pulumi.set(__self__, "private_ip", private_ip)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def eip(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "eip")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "private_ip")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "status")


@pulumi.output_type
class EdgeKubernetesAddon(dict):
    def __init__(__self__, *,
                 config: Optional[_builtins.str] = None,
                 disabled: Optional[_builtins.bool] = None,
                 name: Optional[_builtins.str] = None,
                 version: Optional[_builtins.str] = None):
        """
        :param _builtins.str config: The ACK add-on configurations. For more config information, see cs_kubernetes_addon_metadata.
        :param _builtins.bool disabled: Disables the automatic installation of a component. Default is `false`.
               
               The following example is the definition of addons block, The type of this field is list:
               
               ```
               # install nginx ingress, conflict with SLB ingress
               addons {
               name = "nginx-ingress-controller"
               # use internet
               config = "{\\"IngressSlbNetworkType\\":\\"internet",\\"IngressSlbSpec\\":\\"slb.s2.small\\"}"
               # if use intranet, detail below.
               # config = "{\\"IngressSlbNetworkType\\":\\"intranet",\\"IngressSlbSpec\\":\\"slb.s2.small\\"}"
               }
               ```
        :param _builtins.str name: Name of the ACK add-on. The name must match one of the names returned by [DescribeAddons](https://help.aliyun.com/document_detail/171524.html).
        :param _builtins.str version: It specifies the version of the component.
        """
        if config is not None:
            pulumi.set(__self__, "config", config)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def config(self) -> Optional[_builtins.str]:
        """
        The ACK add-on configurations. For more config information, see cs_kubernetes_addon_metadata.
        """
        return pulumi.get(self, "config")

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> Optional[_builtins.bool]:
        """
        Disables the automatic installation of a component. Default is `false`.

        The following example is the definition of addons block, The type of this field is list:

        ```
        # install nginx ingress, conflict with SLB ingress
        addons {
        name = "nginx-ingress-controller"
        # use internet
        config = "{\\"IngressSlbNetworkType\\":\\"internet",\\"IngressSlbSpec\\":\\"slb.s2.small\\"}"
        # if use intranet, detail below.
        # config = "{\\"IngressSlbNetworkType\\":\\"intranet",\\"IngressSlbSpec\\":\\"slb.s2.small\\"}"
        }
        ```
        """
        return pulumi.get(self, "disabled")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Name of the ACK add-on. The name must match one of the names returned by [DescribeAddons](https://help.aliyun.com/document_detail/171524.html).
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[_builtins.str]:
        """
        It specifies the version of the component.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class EdgeKubernetesCertificateAuthority(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientCert":
            suggest = "client_cert"
        elif key == "clientKey":
            suggest = "client_key"
        elif key == "clusterCert":
            suggest = "cluster_cert"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EdgeKubernetesCertificateAuthority. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EdgeKubernetesCertificateAuthority.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EdgeKubernetesCertificateAuthority.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_cert: Optional[_builtins.str] = None,
                 client_key: Optional[_builtins.str] = None,
                 cluster_cert: Optional[_builtins.str] = None):
        """
        :param _builtins.str client_cert: From version 1.248.0, new DataSource `cs_get_cluster_credential` is recommended to manage cluster's kubeconfig, you can also save the certificate_authority.client_cert attribute content of new DataSource `cs_get_cluster_credential` to an appropriate path(like ~/.kube/client-cert.pem) for replace it.
        :param _builtins.str client_key: From version 1.248.0, new DataSource `cs_get_cluster_credential` is recommended to manage cluster's kubeconfig, you can also save the certificate_authority.client_key attribute content of new DataSource `cs_get_cluster_credential` to an appropriate path(like ~/.kube/client-key.pem) for replace it.
        :param _builtins.str cluster_cert: The base64 encoded cluster certificate data required to communicate with your cluster. Add this to the certificate-authority-data section of the kubeconfig file for your cluster.
        """
        if client_cert is not None:
            pulumi.set(__self__, "client_cert", client_cert)
        if client_key is not None:
            pulumi.set(__self__, "client_key", client_key)
        if cluster_cert is not None:
            pulumi.set(__self__, "cluster_cert", cluster_cert)

    @_builtins.property
    @pulumi.getter(name="clientCert")
    def client_cert(self) -> Optional[_builtins.str]:
        """
        From version 1.248.0, new DataSource `cs_get_cluster_credential` is recommended to manage cluster's kubeconfig, you can also save the certificate_authority.client_cert attribute content of new DataSource `cs_get_cluster_credential` to an appropriate path(like ~/.kube/client-cert.pem) for replace it.
        """
        return pulumi.get(self, "client_cert")

    @_builtins.property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> Optional[_builtins.str]:
        """
        From version 1.248.0, new DataSource `cs_get_cluster_credential` is recommended to manage cluster's kubeconfig, you can also save the certificate_authority.client_key attribute content of new DataSource `cs_get_cluster_credential` to an appropriate path(like ~/.kube/client-key.pem) for replace it.
        """
        return pulumi.get(self, "client_key")

    @_builtins.property
    @pulumi.getter(name="clusterCert")
    def cluster_cert(self) -> Optional[_builtins.str]:
        """
        The base64 encoded cluster certificate data required to communicate with your cluster. Add this to the certificate-authority-data section of the kubeconfig file for your cluster.
        """
        return pulumi.get(self, "cluster_cert")


@pulumi.output_type
class EdgeKubernetesConnections(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiServerInternet":
            suggest = "api_server_internet"
        elif key == "apiServerIntranet":
            suggest = "api_server_intranet"
        elif key == "masterPublicIp":
            suggest = "master_public_ip"
        elif key == "serviceDomain":
            suggest = "service_domain"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EdgeKubernetesConnections. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EdgeKubernetesConnections.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EdgeKubernetesConnections.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_server_internet: Optional[_builtins.str] = None,
                 api_server_intranet: Optional[_builtins.str] = None,
                 master_public_ip: Optional[_builtins.str] = None,
                 service_domain: Optional[_builtins.str] = None):
        """
        :param _builtins.str api_server_internet: API Server Internet endpoint.
        :param _builtins.str api_server_intranet: API Server Intranet endpoint.
        :param _builtins.str master_public_ip: Master node SSH IP address.
        :param _builtins.str service_domain: Service Access Domain.
        """
        if api_server_internet is not None:
            pulumi.set(__self__, "api_server_internet", api_server_internet)
        if api_server_intranet is not None:
            pulumi.set(__self__, "api_server_intranet", api_server_intranet)
        if master_public_ip is not None:
            pulumi.set(__self__, "master_public_ip", master_public_ip)
        if service_domain is not None:
            pulumi.set(__self__, "service_domain", service_domain)

    @_builtins.property
    @pulumi.getter(name="apiServerInternet")
    def api_server_internet(self) -> Optional[_builtins.str]:
        """
        API Server Internet endpoint.
        """
        return pulumi.get(self, "api_server_internet")

    @_builtins.property
    @pulumi.getter(name="apiServerIntranet")
    def api_server_intranet(self) -> Optional[_builtins.str]:
        """
        API Server Intranet endpoint.
        """
        return pulumi.get(self, "api_server_intranet")

    @_builtins.property
    @pulumi.getter(name="masterPublicIp")
    def master_public_ip(self) -> Optional[_builtins.str]:
        """
        Master node SSH IP address.
        """
        return pulumi.get(self, "master_public_ip")

    @_builtins.property
    @pulumi.getter(name="serviceDomain")
    def service_domain(self) -> Optional[_builtins.str]:
        """
        Service Access Domain.
        """
        return pulumi.get(self, "service_domain")


@pulumi.output_type
class EdgeKubernetesLogConfig(dict):
    def __init__(__self__, *,
                 type: _builtins.str,
                 project: Optional[_builtins.str] = None):
        """
        :param _builtins.str type: Type of collecting logs, only `SLS` are supported currently.
        :param _builtins.str project: Log Service project name, cluster logs will output to this project.
        """
        pulumi.set(__self__, "type", type)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of collecting logs, only `SLS` are supported currently.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[_builtins.str]:
        """
        Log Service project name, cluster logs will output to this project.
        """
        return pulumi.get(self, "project")


@pulumi.output_type
class EdgeKubernetesRuntime(dict):
    def __init__(__self__, *,
                 name: Optional[_builtins.str] = None,
                 version: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The name of the runtime. Supported runtimes can be queried by data source alicloud_cs_kubernetes_version.
        :param _builtins.str version: The version of the runtime.
               
               The following example is the definition of runtime block:
               
               ```
               runtime = {
               name = "containerd"
               version = "1.6.28"
               }
               ```
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The name of the runtime. Supported runtimes can be queried by data source alicloud_cs_kubernetes_version.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[_builtins.str]:
        """
        The version of the runtime.

        The following example is the definition of runtime block:

        ```
        runtime = {
        name = "containerd"
        version = "1.6.28"
        }
        ```
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class EdgeKubernetesWorkerDataDisk(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoSnapshotPolicyId":
            suggest = "auto_snapshot_policy_id"
        elif key == "kmsKeyId":
            suggest = "kms_key_id"
        elif key == "performanceLevel":
            suggest = "performance_level"
        elif key == "snapshotId":
            suggest = "snapshot_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EdgeKubernetesWorkerDataDisk. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EdgeKubernetesWorkerDataDisk.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EdgeKubernetesWorkerDataDisk.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auto_snapshot_policy_id: Optional[_builtins.str] = None,
                 category: Optional[_builtins.str] = None,
                 device: Optional[_builtins.str] = None,
                 encrypted: Optional[_builtins.str] = None,
                 kms_key_id: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 performance_level: Optional[_builtins.str] = None,
                 size: Optional[_builtins.str] = None,
                 snapshot_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str auto_snapshot_policy_id: Worker node data disk auto snapshot policy.
        :param _builtins.str category: The type of the data disks. Valid values: `cloud`, `cloud_efficiency`, `cloud_ssd` and `cloud_essd`. Default to `cloud_efficiency`.
        :param _builtins.str device: The device of the data disks.
        :param _builtins.str encrypted: Specifies whether to encrypt data disks. Valid values: true and false. Default is `false`.
        :param _builtins.str kms_key_id: The id of the kms key.
        :param _builtins.str name: The name of the data disks.
        :param _builtins.str performance_level: Worker node data disk performance level, when `category` values `cloud_essd`, the optional values are `PL0`, `PL1`, `PL2` or `PL3`, but the specific performance level is related to the disk capacity. For more information, see [Enhanced SSDs](https://www.alibabacloud.com/help/doc-detail/122389.htm). Default is `PL1`.
        :param _builtins.str size: The size of a data disk, at least 40. Unit: GiB.
        :param _builtins.str snapshot_id: The id of snapshot.
        """
        if auto_snapshot_policy_id is not None:
            pulumi.set(__self__, "auto_snapshot_policy_id", auto_snapshot_policy_id)
        if category is not None:
            pulumi.set(__self__, "category", category)
        if device is not None:
            pulumi.set(__self__, "device", device)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if performance_level is not None:
            pulumi.set(__self__, "performance_level", performance_level)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)

    @_builtins.property
    @pulumi.getter(name="autoSnapshotPolicyId")
    def auto_snapshot_policy_id(self) -> Optional[_builtins.str]:
        """
        Worker node data disk auto snapshot policy.
        """
        return pulumi.get(self, "auto_snapshot_policy_id")

    @_builtins.property
    @pulumi.getter
    def category(self) -> Optional[_builtins.str]:
        """
        The type of the data disks. Valid values: `cloud`, `cloud_efficiency`, `cloud_ssd` and `cloud_essd`. Default to `cloud_efficiency`.
        """
        return pulumi.get(self, "category")

    @_builtins.property
    @pulumi.getter
    def device(self) -> Optional[_builtins.str]:
        """
        The device of the data disks.
        """
        return pulumi.get(self, "device")

    @_builtins.property
    @pulumi.getter
    def encrypted(self) -> Optional[_builtins.str]:
        """
        Specifies whether to encrypt data disks. Valid values: true and false. Default is `false`.
        """
        return pulumi.get(self, "encrypted")

    @_builtins.property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[_builtins.str]:
        """
        The id of the kms key.
        """
        return pulumi.get(self, "kms_key_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The name of the data disks.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="performanceLevel")
    def performance_level(self) -> Optional[_builtins.str]:
        """
        Worker node data disk performance level, when `category` values `cloud_essd`, the optional values are `PL0`, `PL1`, `PL2` or `PL3`, but the specific performance level is related to the disk capacity. For more information, see [Enhanced SSDs](https://www.alibabacloud.com/help/doc-detail/122389.htm). Default is `PL1`.
        """
        return pulumi.get(self, "performance_level")

    @_builtins.property
    @pulumi.getter
    def size(self) -> Optional[_builtins.str]:
        """
        The size of a data disk, at least 40. Unit: GiB.
        """
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[_builtins.str]:
        """
        The id of snapshot.
        """
        return pulumi.get(self, "snapshot_id")


@pulumi.output_type
class EdgeKubernetesWorkerNode(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateIp":
            suggest = "private_ip"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EdgeKubernetesWorkerNode. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EdgeKubernetesWorkerNode.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EdgeKubernetesWorkerNode.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 private_ip: Optional[_builtins.str] = None):
        """
        :param _builtins.str id: ID of the node.
        :param _builtins.str name: The kubernetes cluster's name. It is unique in one Alicloud account.
        :param _builtins.str private_ip: The private IP address of node.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_ip is not None:
            pulumi.set(__self__, "private_ip", private_ip)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        ID of the node.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The kubernetes cluster's name. It is unique in one Alicloud account.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> Optional[_builtins.str]:
        """
        The private IP address of node.
        """
        return pulumi.get(self, "private_ip")


@pulumi.output_type
class KubernetesAddon(dict):
    def __init__(__self__, *,
                 config: Optional[_builtins.str] = None,
                 disabled: Optional[_builtins.bool] = None,
                 name: Optional[_builtins.str] = None,
                 version: Optional[_builtins.str] = None):
        """
        :param _builtins.str config: The ACK add-on configurations. For more config information, see cs_kubernetes_addon_metadata.
        :param _builtins.bool disabled: Disables the automatic installation of a component. Default is `false`.
               
               The following example is the definition of addons block, The type of this field is list:
               
               ```
               # install nginx ingress, conflict with SLB ingress
               addons {
               name = "nginx-ingress-controller"
               # use internet
               config = "{\\"IngressSlbNetworkType\\":\\"internet",\\"IngressSlbSpec\\":\\"slb.s2.small\\"}"
               # if use intranet, detail below.
               # config = "{\\"IngressSlbNetworkType\\":\\"intranet",\\"IngressSlbSpec\\":\\"slb.s2.small\\"}"
               }
               ```
        :param _builtins.str name: Name of the ACK add-on. The name must match one of the names returned by [DescribeAddons](https://help.aliyun.com/document_detail/171524.html).
        :param _builtins.str version: The version of the component.
        """
        if config is not None:
            pulumi.set(__self__, "config", config)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def config(self) -> Optional[_builtins.str]:
        """
        The ACK add-on configurations. For more config information, see cs_kubernetes_addon_metadata.
        """
        return pulumi.get(self, "config")

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> Optional[_builtins.bool]:
        """
        Disables the automatic installation of a component. Default is `false`.

        The following example is the definition of addons block, The type of this field is list:

        ```
        # install nginx ingress, conflict with SLB ingress
        addons {
        name = "nginx-ingress-controller"
        # use internet
        config = "{\\"IngressSlbNetworkType\\":\\"internet",\\"IngressSlbSpec\\":\\"slb.s2.small\\"}"
        # if use intranet, detail below.
        # config = "{\\"IngressSlbNetworkType\\":\\"intranet",\\"IngressSlbSpec\\":\\"slb.s2.small\\"}"
        }
        ```
        """
        return pulumi.get(self, "disabled")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Name of the ACK add-on. The name must match one of the names returned by [DescribeAddons](https://help.aliyun.com/document_detail/171524.html).
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[_builtins.str]:
        """
        The version of the component.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class KubernetesAutoscalerNodepool(dict):
    def __init__(__self__, *,
                 id: Optional[_builtins.str] = None,
                 labels: Optional[_builtins.str] = None,
                 taints: Optional[_builtins.str] = None):
        """
        :param _builtins.str id: The scaling group id of the groups configured for cluster-autoscaler.
        :param _builtins.str labels: The labels for the nodes in scaling group.
        :param _builtins.str taints: The taints for the nodes in scaling group.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if taints is not None:
            pulumi.set(__self__, "taints", taints)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The scaling group id of the groups configured for cluster-autoscaler.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[_builtins.str]:
        """
        The labels for the nodes in scaling group.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def taints(self) -> Optional[_builtins.str]:
        """
        The taints for the nodes in scaling group.
        """
        return pulumi.get(self, "taints")


@pulumi.output_type
class KubernetesCertificateAuthority(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientCert":
            suggest = "client_cert"
        elif key == "clientKey":
            suggest = "client_key"
        elif key == "clusterCert":
            suggest = "cluster_cert"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KubernetesCertificateAuthority. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KubernetesCertificateAuthority.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KubernetesCertificateAuthority.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_cert: Optional[_builtins.str] = None,
                 client_key: Optional[_builtins.str] = None,
                 cluster_cert: Optional[_builtins.str] = None):
        """
        :param _builtins.str client_cert: From version 1.248.0, new DataSource `cs_get_cluster_credential` is recommended to manage cluster's kubeconfig, you can also save the certificate_authority.client_cert attribute content of new DataSource `cs_get_cluster_credential` to an appropriate path(like ~/.kube/client-cert.pem) for replace it.
        :param _builtins.str client_key: From version 1.248.0, new DataSource `cs_get_cluster_credential` is recommended to manage cluster's kubeconfig, you can also save the certificate_authority.client_key attribute content of new DataSource `cs_get_cluster_credential` to an appropriate path(like ~/.kube/client-key.pem) for replace it.
        :param _builtins.str cluster_cert: The base64 encoded cluster certificate data required to communicate with your cluster. Add this to the certificate-authority-data section of the kubeconfig file for your cluster.
        """
        if client_cert is not None:
            pulumi.set(__self__, "client_cert", client_cert)
        if client_key is not None:
            pulumi.set(__self__, "client_key", client_key)
        if cluster_cert is not None:
            pulumi.set(__self__, "cluster_cert", cluster_cert)

    @_builtins.property
    @pulumi.getter(name="clientCert")
    def client_cert(self) -> Optional[_builtins.str]:
        """
        From version 1.248.0, new DataSource `cs_get_cluster_credential` is recommended to manage cluster's kubeconfig, you can also save the certificate_authority.client_cert attribute content of new DataSource `cs_get_cluster_credential` to an appropriate path(like ~/.kube/client-cert.pem) for replace it.
        """
        return pulumi.get(self, "client_cert")

    @_builtins.property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> Optional[_builtins.str]:
        """
        From version 1.248.0, new DataSource `cs_get_cluster_credential` is recommended to manage cluster's kubeconfig, you can also save the certificate_authority.client_key attribute content of new DataSource `cs_get_cluster_credential` to an appropriate path(like ~/.kube/client-key.pem) for replace it.
        """
        return pulumi.get(self, "client_key")

    @_builtins.property
    @pulumi.getter(name="clusterCert")
    def cluster_cert(self) -> Optional[_builtins.str]:
        """
        The base64 encoded cluster certificate data required to communicate with your cluster. Add this to the certificate-authority-data section of the kubeconfig file for your cluster.
        """
        return pulumi.get(self, "cluster_cert")


@pulumi.output_type
class KubernetesConnections(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiServerInternet":
            suggest = "api_server_internet"
        elif key == "apiServerIntranet":
            suggest = "api_server_intranet"
        elif key == "masterPublicIp":
            suggest = "master_public_ip"
        elif key == "serviceDomain":
            suggest = "service_domain"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KubernetesConnections. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KubernetesConnections.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KubernetesConnections.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_server_internet: Optional[_builtins.str] = None,
                 api_server_intranet: Optional[_builtins.str] = None,
                 master_public_ip: Optional[_builtins.str] = None,
                 service_domain: Optional[_builtins.str] = None):
        """
        :param _builtins.str api_server_internet: API Server Internet endpoint.
        :param _builtins.str api_server_intranet: API Server Intranet endpoint.
        :param _builtins.str master_public_ip: Master node SSH IP address.
        :param _builtins.str service_domain: Service Access Domain.
        """
        if api_server_internet is not None:
            pulumi.set(__self__, "api_server_internet", api_server_internet)
        if api_server_intranet is not None:
            pulumi.set(__self__, "api_server_intranet", api_server_intranet)
        if master_public_ip is not None:
            pulumi.set(__self__, "master_public_ip", master_public_ip)
        if service_domain is not None:
            pulumi.set(__self__, "service_domain", service_domain)

    @_builtins.property
    @pulumi.getter(name="apiServerInternet")
    def api_server_internet(self) -> Optional[_builtins.str]:
        """
        API Server Internet endpoint.
        """
        return pulumi.get(self, "api_server_internet")

    @_builtins.property
    @pulumi.getter(name="apiServerIntranet")
    def api_server_intranet(self) -> Optional[_builtins.str]:
        """
        API Server Intranet endpoint.
        """
        return pulumi.get(self, "api_server_intranet")

    @_builtins.property
    @pulumi.getter(name="masterPublicIp")
    def master_public_ip(self) -> Optional[_builtins.str]:
        """
        Master node SSH IP address.
        """
        return pulumi.get(self, "master_public_ip")

    @_builtins.property
    @pulumi.getter(name="serviceDomain")
    def service_domain(self) -> Optional[_builtins.str]:
        """
        Service Access Domain.
        """
        return pulumi.get(self, "service_domain")


@pulumi.output_type
class KubernetesDeleteOption(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deleteMode":
            suggest = "delete_mode"
        elif key == "resourceType":
            suggest = "resource_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KubernetesDeleteOption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KubernetesDeleteOption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KubernetesDeleteOption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 delete_mode: Optional[_builtins.str] = None,
                 resource_type: Optional[_builtins.str] = None):
        """
        :param _builtins.str delete_mode: The deletion mode of the cluster. Different resources may have different default behavior, see `resource_type` for details. Valid values:
        :param _builtins.str resource_type: The type of resources that are created by cluster. Valid values:
               - `SLB`: SLB resources created by the Nginx Ingress Service, default behavior is to delete, option to retain is available.
               - `ALB`: ALB resources created by the ALB Ingress Controller, default behavior is to retain, option to delete is available.
               - `SLS_Data`: SLS Project used by the cluster logging feature, default behavior is to retain, option to delete is available.
               - `SLS_ControlPlane`: SLS Project used for the managed cluster control plane logs, default behavior is to retain, option to delete is available.
               
               ```
               ...
               // Specify delete_options as below when deleting cluster
               // delete SLB resources created by the Nginx Ingress Service
               delete_options {
               delete_mode = "delete"
               resource_type = "SLB"
               }
               // delete ALB resources created by the ALB Ingress Controller
               delete_options {
               delete_mode = "delete"
               resource_type = "ALB"
               }
               // delete SLS Project used by the cluster logging feature
               delete_options {
               delete_mode = "delete"
               resource_type = "SLS_Data"
               }
               // delete SLS Project used for the managed cluster control plane logs
               delete_options {
               delete_mode = "delete"
               resource_type = "SLS_ControlPlane"
               }
               ```
        """
        if delete_mode is not None:
            pulumi.set(__self__, "delete_mode", delete_mode)
        if resource_type is not None:
            pulumi.set(__self__, "resource_type", resource_type)

    @_builtins.property
    @pulumi.getter(name="deleteMode")
    def delete_mode(self) -> Optional[_builtins.str]:
        """
        The deletion mode of the cluster. Different resources may have different default behavior, see `resource_type` for details. Valid values:
        """
        return pulumi.get(self, "delete_mode")

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[_builtins.str]:
        """
        The type of resources that are created by cluster. Valid values:
        - `SLB`: SLB resources created by the Nginx Ingress Service, default behavior is to delete, option to retain is available.
        - `ALB`: ALB resources created by the ALB Ingress Controller, default behavior is to retain, option to delete is available.
        - `SLS_Data`: SLS Project used by the cluster logging feature, default behavior is to retain, option to delete is available.
        - `SLS_ControlPlane`: SLS Project used for the managed cluster control plane logs, default behavior is to retain, option to delete is available.

        ```
        ...
        // Specify delete_options as below when deleting cluster
        // delete SLB resources created by the Nginx Ingress Service
        delete_options {
        delete_mode = "delete"
        resource_type = "SLB"
        }
        // delete ALB resources created by the ALB Ingress Controller
        delete_options {
        delete_mode = "delete"
        resource_type = "ALB"
        }
        // delete SLS Project used by the cluster logging feature
        delete_options {
        delete_mode = "delete"
        resource_type = "SLS_Data"
        }
        // delete SLS Project used for the managed cluster control plane logs
        delete_options {
        delete_mode = "delete"
        resource_type = "SLS_ControlPlane"
        }
        ```
        """
        return pulumi.get(self, "resource_type")


@pulumi.output_type
class KubernetesMasterNode(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateIp":
            suggest = "private_ip"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KubernetesMasterNode. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KubernetesMasterNode.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KubernetesMasterNode.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 private_ip: Optional[_builtins.str] = None):
        """
        :param _builtins.str id: ID of the node.
        :param _builtins.str name: The kubernetes cluster's name. It is unique in one Alicloud account.
        :param _builtins.str private_ip: The private IP address of node.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_ip is not None:
            pulumi.set(__self__, "private_ip", private_ip)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        ID of the node.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The kubernetes cluster's name. It is unique in one Alicloud account.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> Optional[_builtins.str]:
        """
        The private IP address of node.
        """
        return pulumi.get(self, "private_ip")


@pulumi.output_type
class KubernetesPermissionPermission(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "roleName":
            suggest = "role_name"
        elif key == "roleType":
            suggest = "role_type"
        elif key == "isCustom":
            suggest = "is_custom"
        elif key == "isRamRole":
            suggest = "is_ram_role"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KubernetesPermissionPermission. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KubernetesPermissionPermission.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KubernetesPermissionPermission.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster: _builtins.str,
                 role_name: _builtins.str,
                 role_type: _builtins.str,
                 is_custom: Optional[_builtins.bool] = None,
                 is_ram_role: Optional[_builtins.bool] = None,
                 namespace: Optional[_builtins.str] = None):
        """
        :param _builtins.str cluster: The ID of the cluster that you want to manage, When `role_type` value is `all-clusters`, the value of `cluster` must be `""`.
        :param _builtins.str role_name: Specifies the predefined role that you want to assign. Valid values `admin`, `ops`, `dev`, `restricted` and the custom cluster roles.
        :param _builtins.str role_type: The authorization type. Valid values `cluster`, `namespace` and `all-clusters`.
        :param _builtins.bool is_custom: Specifies whether to perform a custom authorization. To perform a custom authorization, the value of `is_custom` must be `true`, and set `role_name` to a custom cluster role.
        :param _builtins.bool is_ram_role: Specifies whether the permissions are granted to a RAM role. When `uid` is ram role id, the value of `is_ram_role` must be `true`.
        :param _builtins.str namespace: The namespace to which the permissions are scoped. This parameter is required only if you set role_type to namespace.
        """
        pulumi.set(__self__, "cluster", cluster)
        pulumi.set(__self__, "role_name", role_name)
        pulumi.set(__self__, "role_type", role_type)
        if is_custom is not None:
            pulumi.set(__self__, "is_custom", is_custom)
        if is_ram_role is not None:
            pulumi.set(__self__, "is_ram_role", is_ram_role)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)

    @_builtins.property
    @pulumi.getter
    def cluster(self) -> _builtins.str:
        """
        The ID of the cluster that you want to manage, When `role_type` value is `all-clusters`, the value of `cluster` must be `""`.
        """
        return pulumi.get(self, "cluster")

    @_builtins.property
    @pulumi.getter(name="roleName")
    def role_name(self) -> _builtins.str:
        """
        Specifies the predefined role that you want to assign. Valid values `admin`, `ops`, `dev`, `restricted` and the custom cluster roles.
        """
        return pulumi.get(self, "role_name")

    @_builtins.property
    @pulumi.getter(name="roleType")
    def role_type(self) -> _builtins.str:
        """
        The authorization type. Valid values `cluster`, `namespace` and `all-clusters`.
        """
        return pulumi.get(self, "role_type")

    @_builtins.property
    @pulumi.getter(name="isCustom")
    def is_custom(self) -> Optional[_builtins.bool]:
        """
        Specifies whether to perform a custom authorization. To perform a custom authorization, the value of `is_custom` must be `true`, and set `role_name` to a custom cluster role.
        """
        return pulumi.get(self, "is_custom")

    @_builtins.property
    @pulumi.getter(name="isRamRole")
    def is_ram_role(self) -> Optional[_builtins.bool]:
        """
        Specifies whether the permissions are granted to a RAM role. When `uid` is ram role id, the value of `is_ram_role` must be `true`.
        """
        return pulumi.get(self, "is_ram_role")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[_builtins.str]:
        """
        The namespace to which the permissions are scoped. This parameter is required only if you set role_type to namespace.
        """
        return pulumi.get(self, "namespace")


@pulumi.output_type
class KubernetesRuntime(dict):
    def __init__(__self__, *,
                 name: Optional[_builtins.str] = None,
                 version: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The name of the runtime. Supported runtimes can be queried by data source alicloud_cs_kubernetes_version.
        :param _builtins.str version: The version of the runtime.
               
               The following example is the definition of runtime block:
               
               ```
               runtime = {
               name = "containerd"
               version = "1.6.28"
               }
               ```
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The name of the runtime. Supported runtimes can be queried by data source alicloud_cs_kubernetes_version.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[_builtins.str]:
        """
        The version of the runtime.

        The following example is the definition of runtime block:

        ```
        runtime = {
        name = "containerd"
        version = "1.6.28"
        }
        ```
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class ManagedKubernetesAddon(dict):
    def __init__(__self__, *,
                 config: Optional[_builtins.str] = None,
                 disabled: Optional[_builtins.bool] = None,
                 name: Optional[_builtins.str] = None,
                 version: Optional[_builtins.str] = None):
        """
        :param _builtins.str config: If this parameter is left empty, no configurations are required. For more config information, see cs_kubernetes_addon_metadata.
        :param _builtins.bool disabled: It specifies whether to disable automatic installation. 
               
               It is a new field since 1.75.0. You can specific network plugin, log component,ingress component and so on.
               
               You can get more information about addons on ACK web console. When you create a ACK cluster. You can get openapi-spec before creating the cluster on submission page.
               
               `logtail-ds` - You can specify `IngressDashboardEnabled` and `sls_project_name` in config. If you switch on `IngressDashboardEnabled` and `sls_project_name`,then logtail-ds would use `sls_project_name` as default log store.
               
               `nginx-ingress-controller` - You can specific `IngressSlbNetworkType` in config. Options: internet|intranet.
               
               The `main.tf`:
        :param _builtins.str name: This parameter specifies the name of the component.
        :param _builtins.str version: It specifies the version of the component.
        """
        if config is not None:
            pulumi.set(__self__, "config", config)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def config(self) -> Optional[_builtins.str]:
        """
        If this parameter is left empty, no configurations are required. For more config information, see cs_kubernetes_addon_metadata.
        """
        return pulumi.get(self, "config")

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> Optional[_builtins.bool]:
        """
        It specifies whether to disable automatic installation. 

        It is a new field since 1.75.0. You can specific network plugin, log component,ingress component and so on.

        You can get more information about addons on ACK web console. When you create a ACK cluster. You can get openapi-spec before creating the cluster on submission page.

        `logtail-ds` - You can specify `IngressDashboardEnabled` and `sls_project_name` in config. If you switch on `IngressDashboardEnabled` and `sls_project_name`,then logtail-ds would use `sls_project_name` as default log store.

        `nginx-ingress-controller` - You can specific `IngressSlbNetworkType` in config. Options: internet|intranet.

        The `main.tf`:
        """
        return pulumi.get(self, "disabled")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        This parameter specifies the name of the component.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[_builtins.str]:
        """
        It specifies the version of the component.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class ManagedKubernetesAuditLogConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "slsProjectName":
            suggest = "sls_project_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedKubernetesAuditLogConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedKubernetesAuditLogConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedKubernetesAuditLogConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: Optional[_builtins.bool] = None,
                 sls_project_name: Optional[_builtins.str] = None):
        """
        :param _builtins.bool enabled: Whether to enable audit logging. Valid values: `true`, `false`.
        :param _builtins.str sls_project_name: The SLS project to which the Logstore storing the cluster audit logs belongs.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if sls_project_name is not None:
            pulumi.set(__self__, "sls_project_name", sls_project_name)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        Whether to enable audit logging. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="slsProjectName")
    def sls_project_name(self) -> Optional[_builtins.str]:
        """
        The SLS project to which the Logstore storing the cluster audit logs belongs.
        """
        return pulumi.get(self, "sls_project_name")


@pulumi.output_type
class ManagedKubernetesCertificateAuthority(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientCert":
            suggest = "client_cert"
        elif key == "clientKey":
            suggest = "client_key"
        elif key == "clusterCert":
            suggest = "cluster_cert"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedKubernetesCertificateAuthority. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedKubernetesCertificateAuthority.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedKubernetesCertificateAuthority.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_cert: Optional[_builtins.str] = None,
                 client_key: Optional[_builtins.str] = None,
                 cluster_cert: Optional[_builtins.str] = None):
        """
        :param _builtins.str client_cert: From version 1.248.0, new DataSource `cs_get_cluster_credential` is recommended to manage cluster's kubeconfig, you can also save the certificate_authority.client_cert attribute content of new DataSource `cs_get_cluster_credential` to an appropriate path(like ~/.kube/client-cert.pem) for replace it.
        :param _builtins.str client_key: From version 1.248.0, new DataSource `cs_get_cluster_credential` is recommended to manage cluster's kubeconfig, you can also save the certificate_authority.client_key attribute content of new DataSource `cs_get_cluster_credential` to an appropriate path(like ~/.kube/client-key.pem) for replace it.
        :param _builtins.str cluster_cert: The base64 encoded cluster certificate data required to communicate with your cluster. Add this to the certificate-authority-data section of the kubeconfig file for your cluster.
        """
        if client_cert is not None:
            pulumi.set(__self__, "client_cert", client_cert)
        if client_key is not None:
            pulumi.set(__self__, "client_key", client_key)
        if cluster_cert is not None:
            pulumi.set(__self__, "cluster_cert", cluster_cert)

    @_builtins.property
    @pulumi.getter(name="clientCert")
    def client_cert(self) -> Optional[_builtins.str]:
        """
        From version 1.248.0, new DataSource `cs_get_cluster_credential` is recommended to manage cluster's kubeconfig, you can also save the certificate_authority.client_cert attribute content of new DataSource `cs_get_cluster_credential` to an appropriate path(like ~/.kube/client-cert.pem) for replace it.
        """
        return pulumi.get(self, "client_cert")

    @_builtins.property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> Optional[_builtins.str]:
        """
        From version 1.248.0, new DataSource `cs_get_cluster_credential` is recommended to manage cluster's kubeconfig, you can also save the certificate_authority.client_key attribute content of new DataSource `cs_get_cluster_credential` to an appropriate path(like ~/.kube/client-key.pem) for replace it.
        """
        return pulumi.get(self, "client_key")

    @_builtins.property
    @pulumi.getter(name="clusterCert")
    def cluster_cert(self) -> Optional[_builtins.str]:
        """
        The base64 encoded cluster certificate data required to communicate with your cluster. Add this to the certificate-authority-data section of the kubeconfig file for your cluster.
        """
        return pulumi.get(self, "cluster_cert")


@pulumi.output_type
class ManagedKubernetesConnections(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiServerInternet":
            suggest = "api_server_internet"
        elif key == "apiServerIntranet":
            suggest = "api_server_intranet"
        elif key == "masterPublicIp":
            suggest = "master_public_ip"
        elif key == "serviceDomain":
            suggest = "service_domain"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedKubernetesConnections. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedKubernetesConnections.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedKubernetesConnections.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_server_internet: Optional[_builtins.str] = None,
                 api_server_intranet: Optional[_builtins.str] = None,
                 master_public_ip: Optional[_builtins.str] = None,
                 service_domain: Optional[_builtins.str] = None):
        """
        :param _builtins.str api_server_internet: API Server Internet endpoint.
        :param _builtins.str api_server_intranet: API Server Intranet endpoint.
        :param _builtins.str master_public_ip: Master node SSH IP address.
        :param _builtins.str service_domain: Service Access Domain.
        """
        if api_server_internet is not None:
            pulumi.set(__self__, "api_server_internet", api_server_internet)
        if api_server_intranet is not None:
            pulumi.set(__self__, "api_server_intranet", api_server_intranet)
        if master_public_ip is not None:
            pulumi.set(__self__, "master_public_ip", master_public_ip)
        if service_domain is not None:
            pulumi.set(__self__, "service_domain", service_domain)

    @_builtins.property
    @pulumi.getter(name="apiServerInternet")
    def api_server_internet(self) -> Optional[_builtins.str]:
        """
        API Server Internet endpoint.
        """
        return pulumi.get(self, "api_server_internet")

    @_builtins.property
    @pulumi.getter(name="apiServerIntranet")
    def api_server_intranet(self) -> Optional[_builtins.str]:
        """
        API Server Intranet endpoint.
        """
        return pulumi.get(self, "api_server_intranet")

    @_builtins.property
    @pulumi.getter(name="masterPublicIp")
    def master_public_ip(self) -> Optional[_builtins.str]:
        """
        Master node SSH IP address.
        """
        return pulumi.get(self, "master_public_ip")

    @_builtins.property
    @pulumi.getter(name="serviceDomain")
    def service_domain(self) -> Optional[_builtins.str]:
        """
        Service Access Domain.
        """
        return pulumi.get(self, "service_domain")


@pulumi.output_type
class ManagedKubernetesDeleteOption(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deleteMode":
            suggest = "delete_mode"
        elif key == "resourceType":
            suggest = "resource_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedKubernetesDeleteOption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedKubernetesDeleteOption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedKubernetesDeleteOption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 delete_mode: Optional[_builtins.str] = None,
                 resource_type: Optional[_builtins.str] = None):
        """
        :param _builtins.str delete_mode: The deletion mode of the cluster. Different resources may have different default behavior, see `resource_type` for details. Valid values:
        :param _builtins.str resource_type: The type of resources that are created by cluster. Valid values:
               - `SLB`: SLB resources created by the Nginx Ingress Service, default behavior is to delete, option to retain is available.
               - `ALB`: ALB resources created by the ALB Ingress Controller, default behavior is to retain, option to delete is available.
               - `SLS_Data`: SLS Project used by the cluster logging feature, default behavior is to retain, option to delete is available.
               - `SLS_ControlPlane`: SLS Project used for the managed cluster control plane logs, default behavior is to retain, option to delete is available.
               
               ```
               ...
               // Specify delete_options as below when deleting cluster
               // delete SLB resources created by the Nginx Ingress Service
               delete_options {
               delete_mode = "delete"
               resource_type = "SLB"
               }
               // delete ALB resources created by the ALB Ingress Controller
               delete_options {
               delete_mode = "delete"
               resource_type = "ALB"
               }
               // delete SLS Project used by the cluster logging feature
               delete_options {
               delete_mode = "delete"
               resource_type = "SLS_Data"
               }
               // delete SLS Project used for the managed cluster control plane logs
               delete_options {
               delete_mode = "delete"
               resource_type = "SLS_ControlPlane"
               }
               ```
        """
        if delete_mode is not None:
            pulumi.set(__self__, "delete_mode", delete_mode)
        if resource_type is not None:
            pulumi.set(__self__, "resource_type", resource_type)

    @_builtins.property
    @pulumi.getter(name="deleteMode")
    def delete_mode(self) -> Optional[_builtins.str]:
        """
        The deletion mode of the cluster. Different resources may have different default behavior, see `resource_type` for details. Valid values:
        """
        return pulumi.get(self, "delete_mode")

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[_builtins.str]:
        """
        The type of resources that are created by cluster. Valid values:
        - `SLB`: SLB resources created by the Nginx Ingress Service, default behavior is to delete, option to retain is available.
        - `ALB`: ALB resources created by the ALB Ingress Controller, default behavior is to retain, option to delete is available.
        - `SLS_Data`: SLS Project used by the cluster logging feature, default behavior is to retain, option to delete is available.
        - `SLS_ControlPlane`: SLS Project used for the managed cluster control plane logs, default behavior is to retain, option to delete is available.

        ```
        ...
        // Specify delete_options as below when deleting cluster
        // delete SLB resources created by the Nginx Ingress Service
        delete_options {
        delete_mode = "delete"
        resource_type = "SLB"
        }
        // delete ALB resources created by the ALB Ingress Controller
        delete_options {
        delete_mode = "delete"
        resource_type = "ALB"
        }
        // delete SLS Project used by the cluster logging feature
        delete_options {
        delete_mode = "delete"
        resource_type = "SLS_Data"
        }
        // delete SLS Project used for the managed cluster control plane logs
        delete_options {
        delete_mode = "delete"
        resource_type = "SLS_ControlPlane"
        }
        ```
        """
        return pulumi.get(self, "resource_type")


@pulumi.output_type
class ManagedKubernetesMaintenanceWindow(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maintenanceTime":
            suggest = "maintenance_time"
        elif key == "weeklyPeriod":
            suggest = "weekly_period"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedKubernetesMaintenanceWindow. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedKubernetesMaintenanceWindow.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedKubernetesMaintenanceWindow.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 duration: Optional[_builtins.str] = None,
                 enable: Optional[_builtins.bool] = None,
                 maintenance_time: Optional[_builtins.str] = None,
                 weekly_period: Optional[_builtins.str] = None):
        """
        :param _builtins.str duration: The maintenance time, values range from 1 to 24,unit is hour. For example: "3h".
        :param _builtins.bool enable: Whether to open the maintenance window. The following parameters take effect only `enable = true`.
        :param _builtins.str maintenance_time: Initial maintenance time, RFC3339 format. For example: "2024-10-15T12:31:00.000+08:00".
        :param _builtins.str weekly_period: Maintenance cycle, you can set the values from Monday to Sunday, separated by commas when the values are multiple. The default is Thursday.
               
               for example:
               ```
               maintenance_window {
               enable            = true
               maintenance_time  = "2024-10-15T12:31:00.000+08:00"
               duration          = "3h"
               weekly_period     = "Monday,Friday"
               }
               ```
        """
        if duration is not None:
            pulumi.set(__self__, "duration", duration)
        if enable is not None:
            pulumi.set(__self__, "enable", enable)
        if maintenance_time is not None:
            pulumi.set(__self__, "maintenance_time", maintenance_time)
        if weekly_period is not None:
            pulumi.set(__self__, "weekly_period", weekly_period)

    @_builtins.property
    @pulumi.getter
    def duration(self) -> Optional[_builtins.str]:
        """
        The maintenance time, values range from 1 to 24,unit is hour. For example: "3h".
        """
        return pulumi.get(self, "duration")

    @_builtins.property
    @pulumi.getter
    def enable(self) -> Optional[_builtins.bool]:
        """
        Whether to open the maintenance window. The following parameters take effect only `enable = true`.
        """
        return pulumi.get(self, "enable")

    @_builtins.property
    @pulumi.getter(name="maintenanceTime")
    def maintenance_time(self) -> Optional[_builtins.str]:
        """
        Initial maintenance time, RFC3339 format. For example: "2024-10-15T12:31:00.000+08:00".
        """
        return pulumi.get(self, "maintenance_time")

    @_builtins.property
    @pulumi.getter(name="weeklyPeriod")
    def weekly_period(self) -> Optional[_builtins.str]:
        """
        Maintenance cycle, you can set the values from Monday to Sunday, separated by commas when the values are multiple. The default is Thursday.

        for example:
        ```
        maintenance_window {
        enable            = true
        maintenance_time  = "2024-10-15T12:31:00.000+08:00"
        duration          = "3h"
        weekly_period     = "Monday,Friday"
        }
        ```
        """
        return pulumi.get(self, "weekly_period")


@pulumi.output_type
class ManagedKubernetesOperationPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterAutoUpgrade":
            suggest = "cluster_auto_upgrade"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedKubernetesOperationPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedKubernetesOperationPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedKubernetesOperationPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster_auto_upgrade: Optional['outputs.ManagedKubernetesOperationPolicyClusterAutoUpgrade'] = None):
        """
        :param 'ManagedKubernetesOperationPolicyClusterAutoUpgradeArgs' cluster_auto_upgrade: Automatic cluster upgrade policy. See `cluster_auto_upgrade` below.
        """
        if cluster_auto_upgrade is not None:
            pulumi.set(__self__, "cluster_auto_upgrade", cluster_auto_upgrade)

    @_builtins.property
    @pulumi.getter(name="clusterAutoUpgrade")
    def cluster_auto_upgrade(self) -> Optional['outputs.ManagedKubernetesOperationPolicyClusterAutoUpgrade']:
        """
        Automatic cluster upgrade policy. See `cluster_auto_upgrade` below.
        """
        return pulumi.get(self, "cluster_auto_upgrade")


@pulumi.output_type
class ManagedKubernetesOperationPolicyClusterAutoUpgrade(dict):
    def __init__(__self__, *,
                 channel: Optional[_builtins.str] = None,
                 enabled: Optional[_builtins.bool] = None):
        """
        :param _builtins.str channel: The automatic cluster upgrade channel. Valid values: `patch`, `stable`, `rapid`.
               
               for example:
               ```
               operation_policy {
               cluster_auto_upgrade {
               enabled = true
               channel = "stable"
               }
               }
               ```
        :param _builtins.bool enabled: Whether the RRSA feature has been enabled.
        """
        if channel is not None:
            pulumi.set(__self__, "channel", channel)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @_builtins.property
    @pulumi.getter
    def channel(self) -> Optional[_builtins.str]:
        """
        The automatic cluster upgrade channel. Valid values: `patch`, `stable`, `rapid`.

        for example:
        ```
        operation_policy {
        cluster_auto_upgrade {
        enabled = true
        channel = "stable"
        }
        }
        ```
        """
        return pulumi.get(self, "channel")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        Whether the RRSA feature has been enabled.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class ManagedKubernetesRrsaMetadata(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ramOidcProviderArn":
            suggest = "ram_oidc_provider_arn"
        elif key == "ramOidcProviderName":
            suggest = "ram_oidc_provider_name"
        elif key == "rrsaOidcIssuerUrl":
            suggest = "rrsa_oidc_issuer_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedKubernetesRrsaMetadata. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedKubernetesRrsaMetadata.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedKubernetesRrsaMetadata.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: Optional[_builtins.bool] = None,
                 ram_oidc_provider_arn: Optional[_builtins.str] = None,
                 ram_oidc_provider_name: Optional[_builtins.str] = None,
                 rrsa_oidc_issuer_url: Optional[_builtins.str] = None):
        """
        :param _builtins.bool enabled: Whether the RRSA feature has been enabled.
        :param _builtins.str ram_oidc_provider_arn: The arn of OIDC provider that was registered in RAM.
        :param _builtins.str ram_oidc_provider_name: The name of OIDC Provider that was registered in RAM.
        :param _builtins.str rrsa_oidc_issuer_url: The issuer URL of RRSA OIDC Token.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if ram_oidc_provider_arn is not None:
            pulumi.set(__self__, "ram_oidc_provider_arn", ram_oidc_provider_arn)
        if ram_oidc_provider_name is not None:
            pulumi.set(__self__, "ram_oidc_provider_name", ram_oidc_provider_name)
        if rrsa_oidc_issuer_url is not None:
            pulumi.set(__self__, "rrsa_oidc_issuer_url", rrsa_oidc_issuer_url)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        Whether the RRSA feature has been enabled.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="ramOidcProviderArn")
    def ram_oidc_provider_arn(self) -> Optional[_builtins.str]:
        """
        The arn of OIDC provider that was registered in RAM.
        """
        return pulumi.get(self, "ram_oidc_provider_arn")

    @_builtins.property
    @pulumi.getter(name="ramOidcProviderName")
    def ram_oidc_provider_name(self) -> Optional[_builtins.str]:
        """
        The name of OIDC Provider that was registered in RAM.
        """
        return pulumi.get(self, "ram_oidc_provider_name")

    @_builtins.property
    @pulumi.getter(name="rrsaOidcIssuerUrl")
    def rrsa_oidc_issuer_url(self) -> Optional[_builtins.str]:
        """
        The issuer URL of RRSA OIDC Token.
        """
        return pulumi.get(self, "rrsa_oidc_issuer_url")


@pulumi.output_type
class NodePoolDataDisk(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoFormat":
            suggest = "auto_format"
        elif key == "autoSnapshotPolicyId":
            suggest = "auto_snapshot_policy_id"
        elif key == "burstingEnabled":
            suggest = "bursting_enabled"
        elif key == "fileSystem":
            suggest = "file_system"
        elif key == "kmsKeyId":
            suggest = "kms_key_id"
        elif key == "mountTarget":
            suggest = "mount_target"
        elif key == "performanceLevel":
            suggest = "performance_level"
        elif key == "provisionedIops":
            suggest = "provisioned_iops"
        elif key == "snapshotId":
            suggest = "snapshot_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodePoolDataDisk. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodePoolDataDisk.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodePoolDataDisk.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auto_format: Optional[_builtins.str] = None,
                 auto_snapshot_policy_id: Optional[_builtins.str] = None,
                 bursting_enabled: Optional[_builtins.bool] = None,
                 category: Optional[_builtins.str] = None,
                 device: Optional[_builtins.str] = None,
                 encrypted: Optional[_builtins.str] = None,
                 file_system: Optional[_builtins.str] = None,
                 kms_key_id: Optional[_builtins.str] = None,
                 mount_target: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 performance_level: Optional[_builtins.str] = None,
                 provisioned_iops: Optional[_builtins.int] = None,
                 size: Optional[_builtins.int] = None,
                 snapshot_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str auto_format: Whether to automatically mount the data disk. Valid values: true and false.
        :param _builtins.str auto_snapshot_policy_id: The ID of the automatic snapshot policy that you want to apply to the system disk.
        :param _builtins.bool bursting_enabled: Whether the data disk is enabled with Burst (performance Burst). This is configured when the disk type is cloud_auto.
        :param _builtins.str category: The type of data disk. Default value: `cloud_efficiency`. Valid values:
        :param _builtins.str device: The mount target of data disk N. Valid values of N: 1 to 16. If you do not specify this parameter, the system automatically assigns a mount target when Auto Scaling creates ECS instances. The name of the mount target ranges from /dev/xvdb to /dev/xvdz.
        :param _builtins.str encrypted: Specifies whether to encrypt data disks. Valid values: true and false. Default to `false`.
        :param _builtins.str file_system: The type of the mounted file system. Works when auto_format is true. Optional value: `ext4`, `xfs`.
        :param _builtins.str kms_key_id: The kms key id used to encrypt the data disk. It takes effect when `encrypted` is true.
        :param _builtins.str mount_target: The Mount path. Works when auto_format is true.
        :param _builtins.str name: The length is 2~128 English or Chinese characters. It must start with an uppercase or lowr letter or a Chinese character and cannot start with http:// or https. Can contain numbers, colons (:), underscores (_), or dashes (-). It will be overwritten if auto_format is set.
        :param _builtins.str performance_level: Worker node data disk performance level, when `category` values `cloud_essd`, the optional values are `PL0`, `PL1`, `PL2` or `PL3`, but the specific performance level is related to the disk capacity. For more information, see [Enhanced SSDs](https://www.alibabacloud.com/help/doc-detail/122389.htm). Default is `PL1`.
        :param _builtins.int provisioned_iops: The read/write IOPS preconfigured for the data disk, which is configured when the disk type is cloud_auto.
        :param _builtins.int size: The size of a data disk, Its valid value range [40~32768] in GB. Default to `40`.
        :param _builtins.str snapshot_id: The ID of the snapshot that you want to use to create data disk N. Valid values of N: 1 to 16. If you specify this parameter, DataDisk.N.Size is ignored. The size of the disk is the same as the size of the specified snapshot. If you specify a snapshot that is created on or before July 15, 2013, the operation fails and InvalidSnapshot.TooOld is returned.
        """
        if auto_format is not None:
            pulumi.set(__self__, "auto_format", auto_format)
        if auto_snapshot_policy_id is not None:
            pulumi.set(__self__, "auto_snapshot_policy_id", auto_snapshot_policy_id)
        if bursting_enabled is not None:
            pulumi.set(__self__, "bursting_enabled", bursting_enabled)
        if category is not None:
            pulumi.set(__self__, "category", category)
        if device is not None:
            pulumi.set(__self__, "device", device)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if file_system is not None:
            pulumi.set(__self__, "file_system", file_system)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if mount_target is not None:
            pulumi.set(__self__, "mount_target", mount_target)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if performance_level is not None:
            pulumi.set(__self__, "performance_level", performance_level)
        if provisioned_iops is not None:
            pulumi.set(__self__, "provisioned_iops", provisioned_iops)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)

    @_builtins.property
    @pulumi.getter(name="autoFormat")
    def auto_format(self) -> Optional[_builtins.str]:
        """
        Whether to automatically mount the data disk. Valid values: true and false.
        """
        return pulumi.get(self, "auto_format")

    @_builtins.property
    @pulumi.getter(name="autoSnapshotPolicyId")
    def auto_snapshot_policy_id(self) -> Optional[_builtins.str]:
        """
        The ID of the automatic snapshot policy that you want to apply to the system disk.
        """
        return pulumi.get(self, "auto_snapshot_policy_id")

    @_builtins.property
    @pulumi.getter(name="burstingEnabled")
    def bursting_enabled(self) -> Optional[_builtins.bool]:
        """
        Whether the data disk is enabled with Burst (performance Burst). This is configured when the disk type is cloud_auto.
        """
        return pulumi.get(self, "bursting_enabled")

    @_builtins.property
    @pulumi.getter
    def category(self) -> Optional[_builtins.str]:
        """
        The type of data disk. Default value: `cloud_efficiency`. Valid values:
        """
        return pulumi.get(self, "category")

    @_builtins.property
    @pulumi.getter
    def device(self) -> Optional[_builtins.str]:
        """
        The mount target of data disk N. Valid values of N: 1 to 16. If you do not specify this parameter, the system automatically assigns a mount target when Auto Scaling creates ECS instances. The name of the mount target ranges from /dev/xvdb to /dev/xvdz.
        """
        return pulumi.get(self, "device")

    @_builtins.property
    @pulumi.getter
    def encrypted(self) -> Optional[_builtins.str]:
        """
        Specifies whether to encrypt data disks. Valid values: true and false. Default to `false`.
        """
        return pulumi.get(self, "encrypted")

    @_builtins.property
    @pulumi.getter(name="fileSystem")
    def file_system(self) -> Optional[_builtins.str]:
        """
        The type of the mounted file system. Works when auto_format is true. Optional value: `ext4`, `xfs`.
        """
        return pulumi.get(self, "file_system")

    @_builtins.property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[_builtins.str]:
        """
        The kms key id used to encrypt the data disk. It takes effect when `encrypted` is true.
        """
        return pulumi.get(self, "kms_key_id")

    @_builtins.property
    @pulumi.getter(name="mountTarget")
    def mount_target(self) -> Optional[_builtins.str]:
        """
        The Mount path. Works when auto_format is true.
        """
        return pulumi.get(self, "mount_target")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The length is 2~128 English or Chinese characters. It must start with an uppercase or lowr letter or a Chinese character and cannot start with http:// or https. Can contain numbers, colons (:), underscores (_), or dashes (-). It will be overwritten if auto_format is set.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="performanceLevel")
    def performance_level(self) -> Optional[_builtins.str]:
        """
        Worker node data disk performance level, when `category` values `cloud_essd`, the optional values are `PL0`, `PL1`, `PL2` or `PL3`, but the specific performance level is related to the disk capacity. For more information, see [Enhanced SSDs](https://www.alibabacloud.com/help/doc-detail/122389.htm). Default is `PL1`.
        """
        return pulumi.get(self, "performance_level")

    @_builtins.property
    @pulumi.getter(name="provisionedIops")
    def provisioned_iops(self) -> Optional[_builtins.int]:
        """
        The read/write IOPS preconfigured for the data disk, which is configured when the disk type is cloud_auto.
        """
        return pulumi.get(self, "provisioned_iops")

    @_builtins.property
    @pulumi.getter
    def size(self) -> Optional[_builtins.int]:
        """
        The size of a data disk, Its valid value range [40~32768] in GB. Default to `40`.
        """
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[_builtins.str]:
        """
        The ID of the snapshot that you want to use to create data disk N. Valid values of N: 1 to 16. If you specify this parameter, DataDisk.N.Size is ignored. The size of the disk is the same as the size of the specified snapshot. If you specify a snapshot that is created on or before July 15, 2013, the operation fails and InvalidSnapshot.TooOld is returned.
        """
        return pulumi.get(self, "snapshot_id")


@pulumi.output_type
class NodePoolEfloNodeGroup(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterId":
            suggest = "cluster_id"
        elif key == "groupId":
            suggest = "group_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodePoolEfloNodeGroup. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodePoolEfloNodeGroup.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodePoolEfloNodeGroup.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster_id: Optional[_builtins.str] = None,
                 group_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str cluster_id: The ID of the associated Lingjun cluster is required when creating a Lingjun node pool.
        :param _builtins.str group_id: When creating a Lingjun node pool, you need the Lingjun group ID of the associated Lingjun cluster.
        """
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[_builtins.str]:
        """
        The ID of the associated Lingjun cluster is required when creating a Lingjun node pool.
        """
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[_builtins.str]:
        """
        When creating a Lingjun node pool, you need the Lingjun group ID of the associated Lingjun cluster.
        """
        return pulumi.get(self, "group_id")


@pulumi.output_type
class NodePoolKubeletConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedUnsafeSysctls":
            suggest = "allowed_unsafe_sysctls"
        elif key == "clusterDns":
            suggest = "cluster_dns"
        elif key == "containerLogMaxFiles":
            suggest = "container_log_max_files"
        elif key == "containerLogMaxSize":
            suggest = "container_log_max_size"
        elif key == "containerLogMaxWorkers":
            suggest = "container_log_max_workers"
        elif key == "containerLogMonitorInterval":
            suggest = "container_log_monitor_interval"
        elif key == "cpuCfsQuota":
            suggest = "cpu_cfs_quota"
        elif key == "cpuCfsQuotaPeriod":
            suggest = "cpu_cfs_quota_period"
        elif key == "cpuManagerPolicy":
            suggest = "cpu_manager_policy"
        elif key == "eventBurst":
            suggest = "event_burst"
        elif key == "eventRecordQps":
            suggest = "event_record_qps"
        elif key == "evictionHard":
            suggest = "eviction_hard"
        elif key == "evictionSoft":
            suggest = "eviction_soft"
        elif key == "evictionSoftGracePeriod":
            suggest = "eviction_soft_grace_period"
        elif key == "featureGates":
            suggest = "feature_gates"
        elif key == "imageGcHighThresholdPercent":
            suggest = "image_gc_high_threshold_percent"
        elif key == "imageGcLowThresholdPercent":
            suggest = "image_gc_low_threshold_percent"
        elif key == "kubeApiBurst":
            suggest = "kube_api_burst"
        elif key == "kubeApiQps":
            suggest = "kube_api_qps"
        elif key == "kubeReserved":
            suggest = "kube_reserved"
        elif key == "maxPods":
            suggest = "max_pods"
        elif key == "memoryManagerPolicy":
            suggest = "memory_manager_policy"
        elif key == "podPidsLimit":
            suggest = "pod_pids_limit"
        elif key == "readOnlyPort":
            suggest = "read_only_port"
        elif key == "registryBurst":
            suggest = "registry_burst"
        elif key == "registryPullQps":
            suggest = "registry_pull_qps"
        elif key == "reservedMemories":
            suggest = "reserved_memories"
        elif key == "serializeImagePulls":
            suggest = "serialize_image_pulls"
        elif key == "systemReserved":
            suggest = "system_reserved"
        elif key == "topologyManagerPolicy":
            suggest = "topology_manager_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodePoolKubeletConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodePoolKubeletConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodePoolKubeletConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_unsafe_sysctls: Optional[Sequence[_builtins.str]] = None,
                 cluster_dns: Optional[Sequence[_builtins.str]] = None,
                 container_log_max_files: Optional[_builtins.str] = None,
                 container_log_max_size: Optional[_builtins.str] = None,
                 container_log_max_workers: Optional[_builtins.str] = None,
                 container_log_monitor_interval: Optional[_builtins.str] = None,
                 cpu_cfs_quota: Optional[_builtins.str] = None,
                 cpu_cfs_quota_period: Optional[_builtins.str] = None,
                 cpu_manager_policy: Optional[_builtins.str] = None,
                 event_burst: Optional[_builtins.str] = None,
                 event_record_qps: Optional[_builtins.str] = None,
                 eviction_hard: Optional[Mapping[str, _builtins.str]] = None,
                 eviction_soft: Optional[Mapping[str, _builtins.str]] = None,
                 eviction_soft_grace_period: Optional[Mapping[str, _builtins.str]] = None,
                 feature_gates: Optional[Mapping[str, _builtins.bool]] = None,
                 image_gc_high_threshold_percent: Optional[_builtins.str] = None,
                 image_gc_low_threshold_percent: Optional[_builtins.str] = None,
                 kube_api_burst: Optional[_builtins.str] = None,
                 kube_api_qps: Optional[_builtins.str] = None,
                 kube_reserved: Optional[Mapping[str, _builtins.str]] = None,
                 max_pods: Optional[_builtins.str] = None,
                 memory_manager_policy: Optional[_builtins.str] = None,
                 pod_pids_limit: Optional[_builtins.str] = None,
                 read_only_port: Optional[_builtins.str] = None,
                 registry_burst: Optional[_builtins.str] = None,
                 registry_pull_qps: Optional[_builtins.str] = None,
                 reserved_memories: Optional[Sequence['outputs.NodePoolKubeletConfigurationReservedMemory']] = None,
                 serialize_image_pulls: Optional[_builtins.str] = None,
                 system_reserved: Optional[Mapping[str, _builtins.str]] = None,
                 topology_manager_policy: Optional[_builtins.str] = None,
                 tracing: Optional['outputs.NodePoolKubeletConfigurationTracing'] = None):
        """
        :param Sequence[_builtins.str] allowed_unsafe_sysctls: Allowed sysctl mode whitelist.
        :param Sequence[_builtins.str] cluster_dns: The list of IP addresses of the cluster DNS servers.
        :param _builtins.str container_log_max_files: The maximum number of log files that can exist in each container.
        :param _builtins.str container_log_max_size: The maximum size that can be reached before a log file is rotated.
        :param _builtins.str container_log_max_workers: Specifies the maximum number of concurrent workers required to perform log rotation operations.
        :param _builtins.str container_log_monitor_interval: Specifies the duration for which container logs are monitored for log rotation.
        :param _builtins.str cpu_cfs_quota: CPU CFS quota constraint switch.
        :param _builtins.str cpu_cfs_quota_period: CPU CFS quota period value.
        :param _builtins.str cpu_manager_policy: Same as cpuManagerPolicy. The name of the policy to use. Requires the CPUManager feature gate to be enabled. Valid value is `none` or `static`.
        :param _builtins.str event_burst: Same as eventBurst. The maximum size of a burst of event creations, temporarily allows event creations to burst to this number, while still not exceeding `event_record_qps`. It is only used when `event_record_qps` is greater than 0. Valid value is `[0-100]`.
        :param _builtins.str event_record_qps: Same as eventRecordQPS. The maximum event creations per second. If 0, there is no limit enforced. Valid value is `[0-50]`.
        :param Mapping[str, _builtins.str] eviction_hard: Same as evictionHard. The map of signal names to quantities that defines hard eviction thresholds. For example: `{"memory.available" = "300Mi"}`.
        :param Mapping[str, _builtins.str] eviction_soft: Same as evictionSoft. The map of signal names to quantities that defines soft eviction thresholds. For example: `{"memory.available" = "300Mi"}`.
        :param Mapping[str, _builtins.str] eviction_soft_grace_period: Same as evictionSoftGracePeriod. The map of signal names to quantities that defines grace periods for each soft eviction signal. For example: `{"memory.available" = "30s"}`.
        :param Mapping[str, _builtins.bool] feature_gates: Feature switch to enable configuration of experimental features.
        :param _builtins.str image_gc_high_threshold_percent: If the image usage exceeds this threshold, image garbage collection will continue.
        :param _builtins.str image_gc_low_threshold_percent: Image garbage collection is not performed when the image usage is below this threshold.
        :param _builtins.str kube_api_burst: Same as kubeAPIBurst. The burst to allow while talking with kubernetes api-server. Valid value is `[0-100]`.
        :param _builtins.str kube_api_qps: Same as kubeAPIQPS. The QPS to use while talking with kubernetes api-server. Valid value is `[0-50]`.
        :param Mapping[str, _builtins.str] kube_reserved: Same as kubeReserved. The set of ResourceName=ResourceQuantity (e.g. cpu=200m,memory=150G) pairs that describe resources reserved for kubernetes system components. Currently, cpu, memory and local storage for root file system are supported. See [compute resources](https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/) for more details.
        :param _builtins.str max_pods: The maximum number of running pods.
        :param _builtins.str memory_manager_policy: The policy to be used by the memory manager.
        :param _builtins.str pod_pids_limit: The maximum number of PIDs that can be used in a Pod.
        :param _builtins.str read_only_port: Read-only port number.
        :param _builtins.str registry_burst: Same as registryBurst. The maximum size of burst pulls, temporarily allows pulls to burst to this number, while still not exceeding `registry_pull_qps`. Only used if `registry_pull_qps` is greater than 0. Valid value is `[0-100]`.
        :param _builtins.str registry_pull_qps: Same as registryPullQPS. The limit of registry pulls per second. Setting it to `0` means no limit. Valid value is `[0-50]`.
        :param Sequence['NodePoolKubeletConfigurationReservedMemoryArgs'] reserved_memories: Reserve memory for NUMA nodes. See `reserved_memory` below.
        :param _builtins.str serialize_image_pulls: Same as serializeImagePulls. When enabled, it tells the Kubelet to pull images one at a time. We recommend not changing the default value on nodes that run docker daemon with version < 1.9 or an Aufs storage backend. Valid value is `true` or `false`.
        :param Mapping[str, _builtins.str] system_reserved: Same as systemReserved. The set of ResourceName=ResourceQuantity (e.g. cpu=200m,memory=150G) pairs that describe resources reserved for non-kubernetes components. Currently, only cpu and memory are supported. See [compute resources](https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/) for more details.
        :param _builtins.str topology_manager_policy: Name of the Topology Manager policy used.
        :param 'NodePoolKubeletConfigurationTracingArgs' tracing: OpenTelemetry tracks the configuration information for client settings versioning. See `tracing` below.
        """
        if allowed_unsafe_sysctls is not None:
            pulumi.set(__self__, "allowed_unsafe_sysctls", allowed_unsafe_sysctls)
        if cluster_dns is not None:
            pulumi.set(__self__, "cluster_dns", cluster_dns)
        if container_log_max_files is not None:
            pulumi.set(__self__, "container_log_max_files", container_log_max_files)
        if container_log_max_size is not None:
            pulumi.set(__self__, "container_log_max_size", container_log_max_size)
        if container_log_max_workers is not None:
            pulumi.set(__self__, "container_log_max_workers", container_log_max_workers)
        if container_log_monitor_interval is not None:
            pulumi.set(__self__, "container_log_monitor_interval", container_log_monitor_interval)
        if cpu_cfs_quota is not None:
            pulumi.set(__self__, "cpu_cfs_quota", cpu_cfs_quota)
        if cpu_cfs_quota_period is not None:
            pulumi.set(__self__, "cpu_cfs_quota_period", cpu_cfs_quota_period)
        if cpu_manager_policy is not None:
            pulumi.set(__self__, "cpu_manager_policy", cpu_manager_policy)
        if event_burst is not None:
            pulumi.set(__self__, "event_burst", event_burst)
        if event_record_qps is not None:
            pulumi.set(__self__, "event_record_qps", event_record_qps)
        if eviction_hard is not None:
            pulumi.set(__self__, "eviction_hard", eviction_hard)
        if eviction_soft is not None:
            pulumi.set(__self__, "eviction_soft", eviction_soft)
        if eviction_soft_grace_period is not None:
            pulumi.set(__self__, "eviction_soft_grace_period", eviction_soft_grace_period)
        if feature_gates is not None:
            pulumi.set(__self__, "feature_gates", feature_gates)
        if image_gc_high_threshold_percent is not None:
            pulumi.set(__self__, "image_gc_high_threshold_percent", image_gc_high_threshold_percent)
        if image_gc_low_threshold_percent is not None:
            pulumi.set(__self__, "image_gc_low_threshold_percent", image_gc_low_threshold_percent)
        if kube_api_burst is not None:
            pulumi.set(__self__, "kube_api_burst", kube_api_burst)
        if kube_api_qps is not None:
            pulumi.set(__self__, "kube_api_qps", kube_api_qps)
        if kube_reserved is not None:
            pulumi.set(__self__, "kube_reserved", kube_reserved)
        if max_pods is not None:
            pulumi.set(__self__, "max_pods", max_pods)
        if memory_manager_policy is not None:
            pulumi.set(__self__, "memory_manager_policy", memory_manager_policy)
        if pod_pids_limit is not None:
            pulumi.set(__self__, "pod_pids_limit", pod_pids_limit)
        if read_only_port is not None:
            pulumi.set(__self__, "read_only_port", read_only_port)
        if registry_burst is not None:
            pulumi.set(__self__, "registry_burst", registry_burst)
        if registry_pull_qps is not None:
            pulumi.set(__self__, "registry_pull_qps", registry_pull_qps)
        if reserved_memories is not None:
            pulumi.set(__self__, "reserved_memories", reserved_memories)
        if serialize_image_pulls is not None:
            pulumi.set(__self__, "serialize_image_pulls", serialize_image_pulls)
        if system_reserved is not None:
            pulumi.set(__self__, "system_reserved", system_reserved)
        if topology_manager_policy is not None:
            pulumi.set(__self__, "topology_manager_policy", topology_manager_policy)
        if tracing is not None:
            pulumi.set(__self__, "tracing", tracing)

    @_builtins.property
    @pulumi.getter(name="allowedUnsafeSysctls")
    def allowed_unsafe_sysctls(self) -> Optional[Sequence[_builtins.str]]:
        """
        Allowed sysctl mode whitelist.
        """
        return pulumi.get(self, "allowed_unsafe_sysctls")

    @_builtins.property
    @pulumi.getter(name="clusterDns")
    def cluster_dns(self) -> Optional[Sequence[_builtins.str]]:
        """
        The list of IP addresses of the cluster DNS servers.
        """
        return pulumi.get(self, "cluster_dns")

    @_builtins.property
    @pulumi.getter(name="containerLogMaxFiles")
    def container_log_max_files(self) -> Optional[_builtins.str]:
        """
        The maximum number of log files that can exist in each container.
        """
        return pulumi.get(self, "container_log_max_files")

    @_builtins.property
    @pulumi.getter(name="containerLogMaxSize")
    def container_log_max_size(self) -> Optional[_builtins.str]:
        """
        The maximum size that can be reached before a log file is rotated.
        """
        return pulumi.get(self, "container_log_max_size")

    @_builtins.property
    @pulumi.getter(name="containerLogMaxWorkers")
    def container_log_max_workers(self) -> Optional[_builtins.str]:
        """
        Specifies the maximum number of concurrent workers required to perform log rotation operations.
        """
        return pulumi.get(self, "container_log_max_workers")

    @_builtins.property
    @pulumi.getter(name="containerLogMonitorInterval")
    def container_log_monitor_interval(self) -> Optional[_builtins.str]:
        """
        Specifies the duration for which container logs are monitored for log rotation.
        """
        return pulumi.get(self, "container_log_monitor_interval")

    @_builtins.property
    @pulumi.getter(name="cpuCfsQuota")
    def cpu_cfs_quota(self) -> Optional[_builtins.str]:
        """
        CPU CFS quota constraint switch.
        """
        return pulumi.get(self, "cpu_cfs_quota")

    @_builtins.property
    @pulumi.getter(name="cpuCfsQuotaPeriod")
    def cpu_cfs_quota_period(self) -> Optional[_builtins.str]:
        """
        CPU CFS quota period value.
        """
        return pulumi.get(self, "cpu_cfs_quota_period")

    @_builtins.property
    @pulumi.getter(name="cpuManagerPolicy")
    def cpu_manager_policy(self) -> Optional[_builtins.str]:
        """
        Same as cpuManagerPolicy. The name of the policy to use. Requires the CPUManager feature gate to be enabled. Valid value is `none` or `static`.
        """
        return pulumi.get(self, "cpu_manager_policy")

    @_builtins.property
    @pulumi.getter(name="eventBurst")
    def event_burst(self) -> Optional[_builtins.str]:
        """
        Same as eventBurst. The maximum size of a burst of event creations, temporarily allows event creations to burst to this number, while still not exceeding `event_record_qps`. It is only used when `event_record_qps` is greater than 0. Valid value is `[0-100]`.
        """
        return pulumi.get(self, "event_burst")

    @_builtins.property
    @pulumi.getter(name="eventRecordQps")
    def event_record_qps(self) -> Optional[_builtins.str]:
        """
        Same as eventRecordQPS. The maximum event creations per second. If 0, there is no limit enforced. Valid value is `[0-50]`.
        """
        return pulumi.get(self, "event_record_qps")

    @_builtins.property
    @pulumi.getter(name="evictionHard")
    def eviction_hard(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Same as evictionHard. The map of signal names to quantities that defines hard eviction thresholds. For example: `{"memory.available" = "300Mi"}`.
        """
        return pulumi.get(self, "eviction_hard")

    @_builtins.property
    @pulumi.getter(name="evictionSoft")
    def eviction_soft(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Same as evictionSoft. The map of signal names to quantities that defines soft eviction thresholds. For example: `{"memory.available" = "300Mi"}`.
        """
        return pulumi.get(self, "eviction_soft")

    @_builtins.property
    @pulumi.getter(name="evictionSoftGracePeriod")
    def eviction_soft_grace_period(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Same as evictionSoftGracePeriod. The map of signal names to quantities that defines grace periods for each soft eviction signal. For example: `{"memory.available" = "30s"}`.
        """
        return pulumi.get(self, "eviction_soft_grace_period")

    @_builtins.property
    @pulumi.getter(name="featureGates")
    def feature_gates(self) -> Optional[Mapping[str, _builtins.bool]]:
        """
        Feature switch to enable configuration of experimental features.
        """
        return pulumi.get(self, "feature_gates")

    @_builtins.property
    @pulumi.getter(name="imageGcHighThresholdPercent")
    def image_gc_high_threshold_percent(self) -> Optional[_builtins.str]:
        """
        If the image usage exceeds this threshold, image garbage collection will continue.
        """
        return pulumi.get(self, "image_gc_high_threshold_percent")

    @_builtins.property
    @pulumi.getter(name="imageGcLowThresholdPercent")
    def image_gc_low_threshold_percent(self) -> Optional[_builtins.str]:
        """
        Image garbage collection is not performed when the image usage is below this threshold.
        """
        return pulumi.get(self, "image_gc_low_threshold_percent")

    @_builtins.property
    @pulumi.getter(name="kubeApiBurst")
    def kube_api_burst(self) -> Optional[_builtins.str]:
        """
        Same as kubeAPIBurst. The burst to allow while talking with kubernetes api-server. Valid value is `[0-100]`.
        """
        return pulumi.get(self, "kube_api_burst")

    @_builtins.property
    @pulumi.getter(name="kubeApiQps")
    def kube_api_qps(self) -> Optional[_builtins.str]:
        """
        Same as kubeAPIQPS. The QPS to use while talking with kubernetes api-server. Valid value is `[0-50]`.
        """
        return pulumi.get(self, "kube_api_qps")

    @_builtins.property
    @pulumi.getter(name="kubeReserved")
    def kube_reserved(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Same as kubeReserved. The set of ResourceName=ResourceQuantity (e.g. cpu=200m,memory=150G) pairs that describe resources reserved for kubernetes system components. Currently, cpu, memory and local storage for root file system are supported. See [compute resources](https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/) for more details.
        """
        return pulumi.get(self, "kube_reserved")

    @_builtins.property
    @pulumi.getter(name="maxPods")
    def max_pods(self) -> Optional[_builtins.str]:
        """
        The maximum number of running pods.
        """
        return pulumi.get(self, "max_pods")

    @_builtins.property
    @pulumi.getter(name="memoryManagerPolicy")
    def memory_manager_policy(self) -> Optional[_builtins.str]:
        """
        The policy to be used by the memory manager.
        """
        return pulumi.get(self, "memory_manager_policy")

    @_builtins.property
    @pulumi.getter(name="podPidsLimit")
    def pod_pids_limit(self) -> Optional[_builtins.str]:
        """
        The maximum number of PIDs that can be used in a Pod.
        """
        return pulumi.get(self, "pod_pids_limit")

    @_builtins.property
    @pulumi.getter(name="readOnlyPort")
    def read_only_port(self) -> Optional[_builtins.str]:
        """
        Read-only port number.
        """
        return pulumi.get(self, "read_only_port")

    @_builtins.property
    @pulumi.getter(name="registryBurst")
    def registry_burst(self) -> Optional[_builtins.str]:
        """
        Same as registryBurst. The maximum size of burst pulls, temporarily allows pulls to burst to this number, while still not exceeding `registry_pull_qps`. Only used if `registry_pull_qps` is greater than 0. Valid value is `[0-100]`.
        """
        return pulumi.get(self, "registry_burst")

    @_builtins.property
    @pulumi.getter(name="registryPullQps")
    def registry_pull_qps(self) -> Optional[_builtins.str]:
        """
        Same as registryPullQPS. The limit of registry pulls per second. Setting it to `0` means no limit. Valid value is `[0-50]`.
        """
        return pulumi.get(self, "registry_pull_qps")

    @_builtins.property
    @pulumi.getter(name="reservedMemories")
    def reserved_memories(self) -> Optional[Sequence['outputs.NodePoolKubeletConfigurationReservedMemory']]:
        """
        Reserve memory for NUMA nodes. See `reserved_memory` below.
        """
        return pulumi.get(self, "reserved_memories")

    @_builtins.property
    @pulumi.getter(name="serializeImagePulls")
    def serialize_image_pulls(self) -> Optional[_builtins.str]:
        """
        Same as serializeImagePulls. When enabled, it tells the Kubelet to pull images one at a time. We recommend not changing the default value on nodes that run docker daemon with version < 1.9 or an Aufs storage backend. Valid value is `true` or `false`.
        """
        return pulumi.get(self, "serialize_image_pulls")

    @_builtins.property
    @pulumi.getter(name="systemReserved")
    def system_reserved(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Same as systemReserved. The set of ResourceName=ResourceQuantity (e.g. cpu=200m,memory=150G) pairs that describe resources reserved for non-kubernetes components. Currently, only cpu and memory are supported. See [compute resources](https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/) for more details.
        """
        return pulumi.get(self, "system_reserved")

    @_builtins.property
    @pulumi.getter(name="topologyManagerPolicy")
    def topology_manager_policy(self) -> Optional[_builtins.str]:
        """
        Name of the Topology Manager policy used.
        """
        return pulumi.get(self, "topology_manager_policy")

    @_builtins.property
    @pulumi.getter
    def tracing(self) -> Optional['outputs.NodePoolKubeletConfigurationTracing']:
        """
        OpenTelemetry tracks the configuration information for client settings versioning. See `tracing` below.
        """
        return pulumi.get(self, "tracing")


@pulumi.output_type
class NodePoolKubeletConfigurationReservedMemory(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "numaNode":
            suggest = "numa_node"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodePoolKubeletConfigurationReservedMemory. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodePoolKubeletConfigurationReservedMemory.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodePoolKubeletConfigurationReservedMemory.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 limits: Optional[Mapping[str, _builtins.str]] = None,
                 numa_node: Optional[_builtins.int] = None):
        """
        :param Mapping[str, _builtins.str] limits: Memory resource limit.
        :param _builtins.int numa_node: The NUMA node.
        """
        if limits is not None:
            pulumi.set(__self__, "limits", limits)
        if numa_node is not None:
            pulumi.set(__self__, "numa_node", numa_node)

    @_builtins.property
    @pulumi.getter
    def limits(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Memory resource limit.
        """
        return pulumi.get(self, "limits")

    @_builtins.property
    @pulumi.getter(name="numaNode")
    def numa_node(self) -> Optional[_builtins.int]:
        """
        The NUMA node.
        """
        return pulumi.get(self, "numa_node")


@pulumi.output_type
class NodePoolKubeletConfigurationTracing(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "samplingRatePerMillion":
            suggest = "sampling_rate_per_million"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodePoolKubeletConfigurationTracing. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodePoolKubeletConfigurationTracing.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodePoolKubeletConfigurationTracing.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint: Optional[_builtins.str] = None,
                 sampling_rate_per_million: Optional[_builtins.str] = None):
        """
        :param _builtins.str endpoint: The endpoint of the collector.
        :param _builtins.str sampling_rate_per_million: Number of samples to be collected per million span.
        """
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if sampling_rate_per_million is not None:
            pulumi.set(__self__, "sampling_rate_per_million", sampling_rate_per_million)

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> Optional[_builtins.str]:
        """
        The endpoint of the collector.
        """
        return pulumi.get(self, "endpoint")

    @_builtins.property
    @pulumi.getter(name="samplingRatePerMillion")
    def sampling_rate_per_million(self) -> Optional[_builtins.str]:
        """
        Number of samples to be collected per million span.
        """
        return pulumi.get(self, "sampling_rate_per_million")


@pulumi.output_type
class NodePoolLabel(dict):
    def __init__(__self__, *,
                 key: _builtins.str,
                 value: Optional[_builtins.str] = None):
        """
        :param _builtins.str key: The label key.
        :param _builtins.str value: The label value.
        """
        pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        The label key.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        The label value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class NodePoolManagement(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoRepair":
            suggest = "auto_repair"
        elif key == "autoRepairPolicy":
            suggest = "auto_repair_policy"
        elif key == "autoUpgrade":
            suggest = "auto_upgrade"
        elif key == "autoUpgradePolicy":
            suggest = "auto_upgrade_policy"
        elif key == "autoVulFix":
            suggest = "auto_vul_fix"
        elif key == "autoVulFixPolicy":
            suggest = "auto_vul_fix_policy"
        elif key == "maxUnavailable":
            suggest = "max_unavailable"
        elif key == "surgePercentage":
            suggest = "surge_percentage"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodePoolManagement. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodePoolManagement.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodePoolManagement.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auto_repair: Optional[_builtins.bool] = None,
                 auto_repair_policy: Optional['outputs.NodePoolManagementAutoRepairPolicy'] = None,
                 auto_upgrade: Optional[_builtins.bool] = None,
                 auto_upgrade_policy: Optional['outputs.NodePoolManagementAutoUpgradePolicy'] = None,
                 auto_vul_fix: Optional[_builtins.bool] = None,
                 auto_vul_fix_policy: Optional['outputs.NodePoolManagementAutoVulFixPolicy'] = None,
                 enable: Optional[_builtins.bool] = None,
                 max_unavailable: Optional[_builtins.int] = None,
                 surge: Optional[_builtins.int] = None,
                 surge_percentage: Optional[_builtins.int] = None):
        """
        :param _builtins.bool auto_repair: Whether to enable automatic repair. Valid values: `true`: Automatic repair. `false`: not automatically repaired.
        :param 'NodePoolManagementAutoRepairPolicyArgs' auto_repair_policy: Automatic repair node policy. See `auto_repair_policy` below.
        :param _builtins.bool auto_upgrade: Specifies whether to enable auto update. Valid values: `true`: enables auto update. `false`: disables auto update.
        :param 'NodePoolManagementAutoUpgradePolicyArgs' auto_upgrade_policy: The auto update policy. See `auto_upgrade_policy` below.
        :param _builtins.bool auto_vul_fix: Specifies whether to automatically patch CVE vulnerabilities. Valid values: `true`, `false`.
        :param 'NodePoolManagementAutoVulFixPolicyArgs' auto_vul_fix_policy: The auto CVE patching policy. See `auto_vul_fix_policy` below.
        :param _builtins.bool enable: Specifies whether to enable the managed node pool feature. Valid values: `true`: enables the managed node pool feature. `false`: disables the managed node pool feature. Other parameters in this section take effect only when you specify enable=true.
        :param _builtins.int max_unavailable: Maximum number of unavailable nodes. Default value: 1. Value range:\\[1,1000\\].
        :param _builtins.int surge: Number of additional nodes. You have to specify one of surge, surge_percentage.
        :param _builtins.int surge_percentage: Proportion of additional nodes. You have to specify one of surge, surge_percentage.
        """
        if auto_repair is not None:
            pulumi.set(__self__, "auto_repair", auto_repair)
        if auto_repair_policy is not None:
            pulumi.set(__self__, "auto_repair_policy", auto_repair_policy)
        if auto_upgrade is not None:
            pulumi.set(__self__, "auto_upgrade", auto_upgrade)
        if auto_upgrade_policy is not None:
            pulumi.set(__self__, "auto_upgrade_policy", auto_upgrade_policy)
        if auto_vul_fix is not None:
            pulumi.set(__self__, "auto_vul_fix", auto_vul_fix)
        if auto_vul_fix_policy is not None:
            pulumi.set(__self__, "auto_vul_fix_policy", auto_vul_fix_policy)
        if enable is not None:
            pulumi.set(__self__, "enable", enable)
        if max_unavailable is not None:
            pulumi.set(__self__, "max_unavailable", max_unavailable)
        if surge is not None:
            pulumi.set(__self__, "surge", surge)
        if surge_percentage is not None:
            pulumi.set(__self__, "surge_percentage", surge_percentage)

    @_builtins.property
    @pulumi.getter(name="autoRepair")
    def auto_repair(self) -> Optional[_builtins.bool]:
        """
        Whether to enable automatic repair. Valid values: `true`: Automatic repair. `false`: not automatically repaired.
        """
        return pulumi.get(self, "auto_repair")

    @_builtins.property
    @pulumi.getter(name="autoRepairPolicy")
    def auto_repair_policy(self) -> Optional['outputs.NodePoolManagementAutoRepairPolicy']:
        """
        Automatic repair node policy. See `auto_repair_policy` below.
        """
        return pulumi.get(self, "auto_repair_policy")

    @_builtins.property
    @pulumi.getter(name="autoUpgrade")
    def auto_upgrade(self) -> Optional[_builtins.bool]:
        """
        Specifies whether to enable auto update. Valid values: `true`: enables auto update. `false`: disables auto update.
        """
        return pulumi.get(self, "auto_upgrade")

    @_builtins.property
    @pulumi.getter(name="autoUpgradePolicy")
    def auto_upgrade_policy(self) -> Optional['outputs.NodePoolManagementAutoUpgradePolicy']:
        """
        The auto update policy. See `auto_upgrade_policy` below.
        """
        return pulumi.get(self, "auto_upgrade_policy")

    @_builtins.property
    @pulumi.getter(name="autoVulFix")
    def auto_vul_fix(self) -> Optional[_builtins.bool]:
        """
        Specifies whether to automatically patch CVE vulnerabilities. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "auto_vul_fix")

    @_builtins.property
    @pulumi.getter(name="autoVulFixPolicy")
    def auto_vul_fix_policy(self) -> Optional['outputs.NodePoolManagementAutoVulFixPolicy']:
        """
        The auto CVE patching policy. See `auto_vul_fix_policy` below.
        """
        return pulumi.get(self, "auto_vul_fix_policy")

    @_builtins.property
    @pulumi.getter
    def enable(self) -> Optional[_builtins.bool]:
        """
        Specifies whether to enable the managed node pool feature. Valid values: `true`: enables the managed node pool feature. `false`: disables the managed node pool feature. Other parameters in this section take effect only when you specify enable=true.
        """
        return pulumi.get(self, "enable")

    @_builtins.property
    @pulumi.getter(name="maxUnavailable")
    def max_unavailable(self) -> Optional[_builtins.int]:
        """
        Maximum number of unavailable nodes. Default value: 1. Value range:\\[1,1000\\].
        """
        return pulumi.get(self, "max_unavailable")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'surge' has been deprecated from provider version 1.219.0. Number of additional nodes. You have to specify one of surge, surge_percentage.""")
    def surge(self) -> Optional[_builtins.int]:
        """
        Number of additional nodes. You have to specify one of surge, surge_percentage.
        """
        return pulumi.get(self, "surge")

    @_builtins.property
    @pulumi.getter(name="surgePercentage")
    @_utilities.deprecated("""Field 'surge_percentage' has been deprecated from provider version 1.219.0. Proportion of additional nodes. You have to specify one of surge, surge_percentage.""")
    def surge_percentage(self) -> Optional[_builtins.int]:
        """
        Proportion of additional nodes. You have to specify one of surge, surge_percentage.
        """
        return pulumi.get(self, "surge_percentage")


@pulumi.output_type
class NodePoolManagementAutoRepairPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "restartNode":
            suggest = "restart_node"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodePoolManagementAutoRepairPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodePoolManagementAutoRepairPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodePoolManagementAutoRepairPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 restart_node: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool restart_node: Specifies whether to automatically restart nodes after patching CVE vulnerabilities. Valid values: `true`, `false`.
        """
        if restart_node is not None:
            pulumi.set(__self__, "restart_node", restart_node)

    @_builtins.property
    @pulumi.getter(name="restartNode")
    def restart_node(self) -> Optional[_builtins.bool]:
        """
        Specifies whether to automatically restart nodes after patching CVE vulnerabilities. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "restart_node")


@pulumi.output_type
class NodePoolManagementAutoUpgradePolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoUpgradeKubelet":
            suggest = "auto_upgrade_kubelet"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodePoolManagementAutoUpgradePolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodePoolManagementAutoUpgradePolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodePoolManagementAutoUpgradePolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auto_upgrade_kubelet: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool auto_upgrade_kubelet: Specifies whether  to automatically update the kubelet. Valid values: `true`: yes; `false`: no.
        """
        if auto_upgrade_kubelet is not None:
            pulumi.set(__self__, "auto_upgrade_kubelet", auto_upgrade_kubelet)

    @_builtins.property
    @pulumi.getter(name="autoUpgradeKubelet")
    def auto_upgrade_kubelet(self) -> Optional[_builtins.bool]:
        """
        Specifies whether  to automatically update the kubelet. Valid values: `true`: yes; `false`: no.
        """
        return pulumi.get(self, "auto_upgrade_kubelet")


@pulumi.output_type
class NodePoolManagementAutoVulFixPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "restartNode":
            suggest = "restart_node"
        elif key == "vulLevel":
            suggest = "vul_level"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodePoolManagementAutoVulFixPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodePoolManagementAutoVulFixPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodePoolManagementAutoVulFixPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 restart_node: Optional[_builtins.bool] = None,
                 vul_level: Optional[_builtins.str] = None):
        """
        :param _builtins.bool restart_node: Specifies whether to automatically restart nodes after patching CVE vulnerabilities. Valid values: `true`, `false`.
        :param _builtins.str vul_level: The severity levels of vulnerabilities that is allowed to automatically patch. Multiple severity levels are separated by commas (,).
        """
        if restart_node is not None:
            pulumi.set(__self__, "restart_node", restart_node)
        if vul_level is not None:
            pulumi.set(__self__, "vul_level", vul_level)

    @_builtins.property
    @pulumi.getter(name="restartNode")
    def restart_node(self) -> Optional[_builtins.bool]:
        """
        Specifies whether to automatically restart nodes after patching CVE vulnerabilities. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "restart_node")

    @_builtins.property
    @pulumi.getter(name="vulLevel")
    def vul_level(self) -> Optional[_builtins.str]:
        """
        The severity levels of vulnerabilities that is allowed to automatically patch. Multiple severity levels are separated by commas (,).
        """
        return pulumi.get(self, "vul_level")


@pulumi.output_type
class NodePoolPrivatePoolOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privatePoolOptionsId":
            suggest = "private_pool_options_id"
        elif key == "privatePoolOptionsMatchCriteria":
            suggest = "private_pool_options_match_criteria"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodePoolPrivatePoolOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodePoolPrivatePoolOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodePoolPrivatePoolOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 private_pool_options_id: Optional[_builtins.str] = None,
                 private_pool_options_match_criteria: Optional[_builtins.str] = None):
        """
        :param _builtins.str private_pool_options_id: The ID of the private node pool.
        :param _builtins.str private_pool_options_match_criteria: The type of private node pool. This parameter specifies the type of the private pool that you want to use to create instances. A private node pool is generated when an elasticity assurance or a capacity reservation service takes effect. The system selects a private node pool to launch instances. Valid values: `Open`: specifies an open private node pool. The system selects an open private node pool to launch instances. If no matching open private node pool is available, the resources in the public node pool are used. `Target`: specifies a private node pool. The system uses the resources of the specified private node pool to launch instances. If the specified private node pool is unavailable, instances cannot be started. `None`: no private node pool is used. The resources of private node pools are not used to launch the instances.
        """
        if private_pool_options_id is not None:
            pulumi.set(__self__, "private_pool_options_id", private_pool_options_id)
        if private_pool_options_match_criteria is not None:
            pulumi.set(__self__, "private_pool_options_match_criteria", private_pool_options_match_criteria)

    @_builtins.property
    @pulumi.getter(name="privatePoolOptionsId")
    def private_pool_options_id(self) -> Optional[_builtins.str]:
        """
        The ID of the private node pool.
        """
        return pulumi.get(self, "private_pool_options_id")

    @_builtins.property
    @pulumi.getter(name="privatePoolOptionsMatchCriteria")
    def private_pool_options_match_criteria(self) -> Optional[_builtins.str]:
        """
        The type of private node pool. This parameter specifies the type of the private pool that you want to use to create instances. A private node pool is generated when an elasticity assurance or a capacity reservation service takes effect. The system selects a private node pool to launch instances. Valid values: `Open`: specifies an open private node pool. The system selects an open private node pool to launch instances. If no matching open private node pool is available, the resources in the public node pool are used. `Target`: specifies a private node pool. The system uses the resources of the specified private node pool to launch instances. If the specified private node pool is unavailable, instances cannot be started. `None`: no private node pool is used. The resources of private node pools are not used to launch the instances.
        """
        return pulumi.get(self, "private_pool_options_match_criteria")


@pulumi.output_type
class NodePoolRollingPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxParallelism":
            suggest = "max_parallelism"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodePoolRollingPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodePoolRollingPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodePoolRollingPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_parallelism: Optional[_builtins.int] = None):
        """
        :param _builtins.int max_parallelism: The maximum number of unusable nodes.
        """
        if max_parallelism is not None:
            pulumi.set(__self__, "max_parallelism", max_parallelism)

    @_builtins.property
    @pulumi.getter(name="maxParallelism")
    def max_parallelism(self) -> Optional[_builtins.int]:
        """
        The maximum number of unusable nodes.
        """
        return pulumi.get(self, "max_parallelism")


@pulumi.output_type
class NodePoolScalingConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "eipBandwidth":
            suggest = "eip_bandwidth"
        elif key == "eipInternetChargeType":
            suggest = "eip_internet_charge_type"
        elif key == "isBondEip":
            suggest = "is_bond_eip"
        elif key == "maxSize":
            suggest = "max_size"
        elif key == "minSize":
            suggest = "min_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodePoolScalingConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodePoolScalingConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodePoolScalingConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 eip_bandwidth: Optional[_builtins.int] = None,
                 eip_internet_charge_type: Optional[_builtins.str] = None,
                 enable: Optional[_builtins.bool] = None,
                 is_bond_eip: Optional[_builtins.bool] = None,
                 max_size: Optional[_builtins.int] = None,
                 min_size: Optional[_builtins.int] = None,
                 type: Optional[_builtins.str] = None):
        """
        :param _builtins.int eip_bandwidth: Peak EIP bandwidth. Its valid value range [1~500] in Mbps. It works if `is_bond_eip=true`. Default to `5`.
        :param _builtins.str eip_internet_charge_type: EIP billing type. `PayByBandwidth`: Charged at fixed bandwidth. `PayByTraffic`: Billed as used traffic. Default: `PayByBandwidth`. It works if `is_bond_eip=true`, conflict with `internet_charge_type`. EIP and public network IP can only choose one.
        :param _builtins.bool enable: Whether to enable automatic scaling. Value:
        :param _builtins.bool is_bond_eip: Whether to bind EIP for an instance. Default: `false`.
        :param _builtins.int max_size: Max number of instances in a auto scaling group, its valid value range [0~1000]. `max_size` has to be greater than `min_size`.
        :param _builtins.int min_size: Min number of instances in a auto scaling group, its valid value range [0~1000].
        :param _builtins.str type: Instance classification, not required. Vaild value: `cpu`, `gpu`, `gpushare` and `spot`. Default: `cpu`. The actual instance type is determined by `instance_types`.
        """
        if eip_bandwidth is not None:
            pulumi.set(__self__, "eip_bandwidth", eip_bandwidth)
        if eip_internet_charge_type is not None:
            pulumi.set(__self__, "eip_internet_charge_type", eip_internet_charge_type)
        if enable is not None:
            pulumi.set(__self__, "enable", enable)
        if is_bond_eip is not None:
            pulumi.set(__self__, "is_bond_eip", is_bond_eip)
        if max_size is not None:
            pulumi.set(__self__, "max_size", max_size)
        if min_size is not None:
            pulumi.set(__self__, "min_size", min_size)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="eipBandwidth")
    def eip_bandwidth(self) -> Optional[_builtins.int]:
        """
        Peak EIP bandwidth. Its valid value range [1~500] in Mbps. It works if `is_bond_eip=true`. Default to `5`.
        """
        return pulumi.get(self, "eip_bandwidth")

    @_builtins.property
    @pulumi.getter(name="eipInternetChargeType")
    def eip_internet_charge_type(self) -> Optional[_builtins.str]:
        """
        EIP billing type. `PayByBandwidth`: Charged at fixed bandwidth. `PayByTraffic`: Billed as used traffic. Default: `PayByBandwidth`. It works if `is_bond_eip=true`, conflict with `internet_charge_type`. EIP and public network IP can only choose one.
        """
        return pulumi.get(self, "eip_internet_charge_type")

    @_builtins.property
    @pulumi.getter
    def enable(self) -> Optional[_builtins.bool]:
        """
        Whether to enable automatic scaling. Value:
        """
        return pulumi.get(self, "enable")

    @_builtins.property
    @pulumi.getter(name="isBondEip")
    def is_bond_eip(self) -> Optional[_builtins.bool]:
        """
        Whether to bind EIP for an instance. Default: `false`.
        """
        return pulumi.get(self, "is_bond_eip")

    @_builtins.property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> Optional[_builtins.int]:
        """
        Max number of instances in a auto scaling group, its valid value range [0~1000]. `max_size` has to be greater than `min_size`.
        """
        return pulumi.get(self, "max_size")

    @_builtins.property
    @pulumi.getter(name="minSize")
    def min_size(self) -> Optional[_builtins.int]:
        """
        Min number of instances in a auto scaling group, its valid value range [0~1000].
        """
        return pulumi.get(self, "min_size")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        Instance classification, not required. Vaild value: `cpu`, `gpu`, `gpushare` and `spot`. Default: `cpu`. The actual instance type is determined by `instance_types`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class NodePoolSpotPriceLimit(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceType":
            suggest = "instance_type"
        elif key == "priceLimit":
            suggest = "price_limit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodePoolSpotPriceLimit. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodePoolSpotPriceLimit.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodePoolSpotPriceLimit.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_type: Optional[_builtins.str] = None,
                 price_limit: Optional[_builtins.str] = None):
        """
        :param _builtins.str instance_type: The type of the preemptible instance.
        :param _builtins.str price_limit: The maximum price of a single instance.
        """
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if price_limit is not None:
            pulumi.set(__self__, "price_limit", price_limit)

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[_builtins.str]:
        """
        The type of the preemptible instance.
        """
        return pulumi.get(self, "instance_type")

    @_builtins.property
    @pulumi.getter(name="priceLimit")
    def price_limit(self) -> Optional[_builtins.str]:
        """
        The maximum price of a single instance.
        """
        return pulumi.get(self, "price_limit")


@pulumi.output_type
class NodePoolTaint(dict):
    def __init__(__self__, *,
                 key: _builtins.str,
                 effect: Optional[_builtins.str] = None,
                 value: Optional[_builtins.str] = None):
        """
        :param _builtins.str key: The key of a taint.
        :param _builtins.str effect: The scheduling policy.
        :param _builtins.str value: The value of a taint.
        """
        pulumi.set(__self__, "key", key)
        if effect is not None:
            pulumi.set(__self__, "effect", effect)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        The key of a taint.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def effect(self) -> Optional[_builtins.str]:
        """
        The scheduling policy.
        """
        return pulumi.get(self, "effect")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        The value of a taint.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class NodePoolTeeConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "teeEnable":
            suggest = "tee_enable"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodePoolTeeConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodePoolTeeConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodePoolTeeConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 tee_enable: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool tee_enable: Specifies whether to enable confidential computing for the cluster.
        """
        if tee_enable is not None:
            pulumi.set(__self__, "tee_enable", tee_enable)

    @_builtins.property
    @pulumi.getter(name="teeEnable")
    def tee_enable(self) -> Optional[_builtins.bool]:
        """
        Specifies whether to enable confidential computing for the cluster.
        """
        return pulumi.get(self, "tee_enable")


@pulumi.output_type
class ServerlessKubernetesAddon(dict):
    def __init__(__self__, *,
                 config: Optional[_builtins.str] = None,
                 disabled: Optional[_builtins.bool] = None,
                 name: Optional[_builtins.str] = None,
                 version: Optional[_builtins.str] = None):
        """
        :param _builtins.str config: The ACK add-on configurations. For more config information, see cs_kubernetes_addon_metadata.
        :param _builtins.bool disabled: Disables the automatic installation of a component. Default is `false`.
               
               The following example is the definition of addons block, The type of this field is list:
               
               ```
               # install nginx ingress, conflict with ALB ingress
               addons {
               name = "nginx-ingress-controller"
               # use internet
               config = "{\\"IngressSlbNetworkType\\":\\"internet",\\"IngressSlbSpec\\":\\"slb.s2.small\\"}"
               # if use intranet, detail below.
               # config = "{\\"IngressSlbNetworkType\\":\\"intranet",\\"IngressSlbSpec\\":\\"slb.s2.small\\"}"
               }
               # install ALB ingress, conflict with nginx ingress
               addons {
               name = "alb-ingress-controller"
               }
               # install metric server
               addons {
               name = "metrics-server"
               }
               # install knative
               addons {
               name = "knative"
               }
               # install prometheus
               addons {
               name = "arms-prometheus"
               }
               ```
        :param _builtins.str name: Name of the ACK add-on. The name must match one of the names returned by [DescribeAddons](https://help.aliyun.com/document_detail/171524.html).
        :param _builtins.str version: It specifies the version of the component.
        """
        if config is not None:
            pulumi.set(__self__, "config", config)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def config(self) -> Optional[_builtins.str]:
        """
        The ACK add-on configurations. For more config information, see cs_kubernetes_addon_metadata.
        """
        return pulumi.get(self, "config")

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> Optional[_builtins.bool]:
        """
        Disables the automatic installation of a component. Default is `false`.

        The following example is the definition of addons block, The type of this field is list:

        ```
        # install nginx ingress, conflict with ALB ingress
        addons {
        name = "nginx-ingress-controller"
        # use internet
        config = "{\\"IngressSlbNetworkType\\":\\"internet",\\"IngressSlbSpec\\":\\"slb.s2.small\\"}"
        # if use intranet, detail below.
        # config = "{\\"IngressSlbNetworkType\\":\\"intranet",\\"IngressSlbSpec\\":\\"slb.s2.small\\"}"
        }
        # install ALB ingress, conflict with nginx ingress
        addons {
        name = "alb-ingress-controller"
        }
        # install metric server
        addons {
        name = "metrics-server"
        }
        # install knative
        addons {
        name = "knative"
        }
        # install prometheus
        addons {
        name = "arms-prometheus"
        }
        ```
        """
        return pulumi.get(self, "disabled")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Name of the ACK add-on. The name must match one of the names returned by [DescribeAddons](https://help.aliyun.com/document_detail/171524.html).
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[_builtins.str]:
        """
        It specifies the version of the component.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class ServerlessKubernetesDeleteOption(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deleteMode":
            suggest = "delete_mode"
        elif key == "resourceType":
            suggest = "resource_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerlessKubernetesDeleteOption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerlessKubernetesDeleteOption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerlessKubernetesDeleteOption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 delete_mode: Optional[_builtins.str] = None,
                 resource_type: Optional[_builtins.str] = None):
        """
        :param _builtins.str delete_mode: The deletion mode of the cluster. Different resources may have different default behavior, see `resource_type` for details. Valid values:
        :param _builtins.str resource_type: The type of resources that are created by cluster. Valid values:
               - `SLB`: SLB resources created by the Nginx Ingress Service, default behavior is to delete, option to retain is available.
               - `ALB`: ALB resources created by the ALB Ingress Controller, default behavior is to retain, option to delete is available.
               - `SLS_Data`: SLS Project used by the cluster logging feature, default behavior is to retain, option to delete is available.
               - `SLS_ControlPlane`: SLS Project used for the managed cluster control plane logs, default behavior is to retain, option to delete is available.
               - `PrivateZone`: PrivateZone resources created by the cluster, default behavior is to retain, option to delete is available.
               ```
               ...
               // Specify delete_options as below when deleting cluster
               // delete SLB resources created by the Nginx Ingress Service
               delete_options {
               delete_mode = "delete"
               resource_type = "SLB"
               }
               // delete ALB resources created by the ALB Ingress Controller
               delete_options {
               delete_mode = "delete"
               resource_type = "ALB"
               }
               // delete SLS Project used by the cluster logging feature
               delete_options {
               delete_mode = "delete"
               resource_type = "SLS_Data"
               }
               // delete SLS Project used for the managed cluster control plane logs
               delete_options {
               delete_mode = "delete"
               resource_type = "SLS_ControlPlane"
               }
               // delete PrivateZone resources created by the cluster
               delete_options {
               delete_mode = "delete"
               resource_type = "PrivateZone"
               }
               ```
        """
        if delete_mode is not None:
            pulumi.set(__self__, "delete_mode", delete_mode)
        if resource_type is not None:
            pulumi.set(__self__, "resource_type", resource_type)

    @_builtins.property
    @pulumi.getter(name="deleteMode")
    def delete_mode(self) -> Optional[_builtins.str]:
        """
        The deletion mode of the cluster. Different resources may have different default behavior, see `resource_type` for details. Valid values:
        """
        return pulumi.get(self, "delete_mode")

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[_builtins.str]:
        """
        The type of resources that are created by cluster. Valid values:
        - `SLB`: SLB resources created by the Nginx Ingress Service, default behavior is to delete, option to retain is available.
        - `ALB`: ALB resources created by the ALB Ingress Controller, default behavior is to retain, option to delete is available.
        - `SLS_Data`: SLS Project used by the cluster logging feature, default behavior is to retain, option to delete is available.
        - `SLS_ControlPlane`: SLS Project used for the managed cluster control plane logs, default behavior is to retain, option to delete is available.
        - `PrivateZone`: PrivateZone resources created by the cluster, default behavior is to retain, option to delete is available.
        ```
        ...
        // Specify delete_options as below when deleting cluster
        // delete SLB resources created by the Nginx Ingress Service
        delete_options {
        delete_mode = "delete"
        resource_type = "SLB"
        }
        // delete ALB resources created by the ALB Ingress Controller
        delete_options {
        delete_mode = "delete"
        resource_type = "ALB"
        }
        // delete SLS Project used by the cluster logging feature
        delete_options {
        delete_mode = "delete"
        resource_type = "SLS_Data"
        }
        // delete SLS Project used for the managed cluster control plane logs
        delete_options {
        delete_mode = "delete"
        resource_type = "SLS_ControlPlane"
        }
        // delete PrivateZone resources created by the cluster
        delete_options {
        delete_mode = "delete"
        resource_type = "PrivateZone"
        }
        ```
        """
        return pulumi.get(self, "resource_type")


@pulumi.output_type
class ServerlessKubernetesMaintenanceWindow(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maintenanceTime":
            suggest = "maintenance_time"
        elif key == "weeklyPeriod":
            suggest = "weekly_period"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerlessKubernetesMaintenanceWindow. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerlessKubernetesMaintenanceWindow.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerlessKubernetesMaintenanceWindow.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 duration: Optional[_builtins.str] = None,
                 enable: Optional[_builtins.bool] = None,
                 maintenance_time: Optional[_builtins.str] = None,
                 weekly_period: Optional[_builtins.str] = None):
        """
        :param _builtins.str duration: The maintenance time, values range from 1 to 24,unit is hour. For example: "3h".
        :param _builtins.bool enable: Whether to open the maintenance window. The following parameters take effect only `enable = true`.
        :param _builtins.str maintenance_time: Initial maintenance time, RFC3339 format. For example: "2024-10-15T12:31:00.000+08:00".
        :param _builtins.str weekly_period: Maintenance cycle, you can set the values from Monday to Sunday, separated by commas when the values are multiple. The default is Thursday.
               
               for example:
               ```
               maintenance_window {
               enable            = true
               maintenance_time  = "2024-10-15T12:31:00.000+08:00"
               duration          = "3h"
               weekly_period     = "Monday,Friday"
               }
               ```
        """
        if duration is not None:
            pulumi.set(__self__, "duration", duration)
        if enable is not None:
            pulumi.set(__self__, "enable", enable)
        if maintenance_time is not None:
            pulumi.set(__self__, "maintenance_time", maintenance_time)
        if weekly_period is not None:
            pulumi.set(__self__, "weekly_period", weekly_period)

    @_builtins.property
    @pulumi.getter
    def duration(self) -> Optional[_builtins.str]:
        """
        The maintenance time, values range from 1 to 24,unit is hour. For example: "3h".
        """
        return pulumi.get(self, "duration")

    @_builtins.property
    @pulumi.getter
    def enable(self) -> Optional[_builtins.bool]:
        """
        Whether to open the maintenance window. The following parameters take effect only `enable = true`.
        """
        return pulumi.get(self, "enable")

    @_builtins.property
    @pulumi.getter(name="maintenanceTime")
    def maintenance_time(self) -> Optional[_builtins.str]:
        """
        Initial maintenance time, RFC3339 format. For example: "2024-10-15T12:31:00.000+08:00".
        """
        return pulumi.get(self, "maintenance_time")

    @_builtins.property
    @pulumi.getter(name="weeklyPeriod")
    def weekly_period(self) -> Optional[_builtins.str]:
        """
        Maintenance cycle, you can set the values from Monday to Sunday, separated by commas when the values are multiple. The default is Thursday.

        for example:
        ```
        maintenance_window {
        enable            = true
        maintenance_time  = "2024-10-15T12:31:00.000+08:00"
        duration          = "3h"
        weekly_period     = "Monday,Friday"
        }
        ```
        """
        return pulumi.get(self, "weekly_period")


@pulumi.output_type
class ServerlessKubernetesOperationPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterAutoUpgrade":
            suggest = "cluster_auto_upgrade"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerlessKubernetesOperationPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerlessKubernetesOperationPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerlessKubernetesOperationPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster_auto_upgrade: Optional['outputs.ServerlessKubernetesOperationPolicyClusterAutoUpgrade'] = None):
        """
        :param 'ServerlessKubernetesOperationPolicyClusterAutoUpgradeArgs' cluster_auto_upgrade: Automatic cluster upgrade policy. See `cluster_auto_upgrade` below.
        """
        if cluster_auto_upgrade is not None:
            pulumi.set(__self__, "cluster_auto_upgrade", cluster_auto_upgrade)

    @_builtins.property
    @pulumi.getter(name="clusterAutoUpgrade")
    def cluster_auto_upgrade(self) -> Optional['outputs.ServerlessKubernetesOperationPolicyClusterAutoUpgrade']:
        """
        Automatic cluster upgrade policy. See `cluster_auto_upgrade` below.
        """
        return pulumi.get(self, "cluster_auto_upgrade")


@pulumi.output_type
class ServerlessKubernetesOperationPolicyClusterAutoUpgrade(dict):
    def __init__(__self__, *,
                 channel: Optional[_builtins.str] = None,
                 enabled: Optional[_builtins.bool] = None):
        """
        :param _builtins.str channel: The automatic cluster upgrade channel. Valid values: `patch`, `stable`, `rapid`.
               
               for example:
               ```
               operation_policy {
               cluster_auto_upgrade {
               enabled = true
               channel = "stable"
               }
               }
               ```
        :param _builtins.bool enabled: Whether the RRSA feature has been enabled.
        """
        if channel is not None:
            pulumi.set(__self__, "channel", channel)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @_builtins.property
    @pulumi.getter
    def channel(self) -> Optional[_builtins.str]:
        """
        The automatic cluster upgrade channel. Valid values: `patch`, `stable`, `rapid`.

        for example:
        ```
        operation_policy {
        cluster_auto_upgrade {
        enabled = true
        channel = "stable"
        }
        }
        ```
        """
        return pulumi.get(self, "channel")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        Whether the RRSA feature has been enabled.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class ServerlessKubernetesRrsaMetadata(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ramOidcProviderArn":
            suggest = "ram_oidc_provider_arn"
        elif key == "ramOidcProviderName":
            suggest = "ram_oidc_provider_name"
        elif key == "rrsaOidcIssuerUrl":
            suggest = "rrsa_oidc_issuer_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerlessKubernetesRrsaMetadata. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerlessKubernetesRrsaMetadata.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerlessKubernetesRrsaMetadata.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: Optional[_builtins.bool] = None,
                 ram_oidc_provider_arn: Optional[_builtins.str] = None,
                 ram_oidc_provider_name: Optional[_builtins.str] = None,
                 rrsa_oidc_issuer_url: Optional[_builtins.str] = None):
        """
        :param _builtins.bool enabled: Whether the RRSA feature has been enabled.
        :param _builtins.str ram_oidc_provider_arn: The arn of OIDC provider that was registered in RAM.
        :param _builtins.str ram_oidc_provider_name: The name of OIDC Provider that was registered in RAM.
        :param _builtins.str rrsa_oidc_issuer_url: The issuer URL of RRSA OIDC Token.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if ram_oidc_provider_arn is not None:
            pulumi.set(__self__, "ram_oidc_provider_arn", ram_oidc_provider_arn)
        if ram_oidc_provider_name is not None:
            pulumi.set(__self__, "ram_oidc_provider_name", ram_oidc_provider_name)
        if rrsa_oidc_issuer_url is not None:
            pulumi.set(__self__, "rrsa_oidc_issuer_url", rrsa_oidc_issuer_url)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        Whether the RRSA feature has been enabled.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="ramOidcProviderArn")
    def ram_oidc_provider_arn(self) -> Optional[_builtins.str]:
        """
        The arn of OIDC provider that was registered in RAM.
        """
        return pulumi.get(self, "ram_oidc_provider_arn")

    @_builtins.property
    @pulumi.getter(name="ramOidcProviderName")
    def ram_oidc_provider_name(self) -> Optional[_builtins.str]:
        """
        The name of OIDC Provider that was registered in RAM.
        """
        return pulumi.get(self, "ram_oidc_provider_name")

    @_builtins.property
    @pulumi.getter(name="rrsaOidcIssuerUrl")
    def rrsa_oidc_issuer_url(self) -> Optional[_builtins.str]:
        """
        The issuer URL of RRSA OIDC Token.
        """
        return pulumi.get(self, "rrsa_oidc_issuer_url")


@pulumi.output_type
class SwarmNode(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateIp":
            suggest = "private_ip"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SwarmNode. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SwarmNode.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SwarmNode.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 eip: Optional[_builtins.str] = None,
                 id: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 private_ip: Optional[_builtins.str] = None,
                 status: Optional[_builtins.str] = None):
        if eip is not None:
            pulumi.set(__self__, "eip", eip)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_ip is not None:
            pulumi.set(__self__, "private_ip", private_ip)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def eip(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "eip")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "private_ip")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "status")


@pulumi.output_type
class GetClusterCredentialCertificateAuthorityResult(dict):
    def __init__(__self__, *,
                 client_cert: _builtins.str,
                 client_key: _builtins.str,
                 cluster_cert: _builtins.str):
        """
        :param _builtins.str client_cert: The base64 encoded client certificate data required to communicate with your cluster. Add this to the client-certificate-data section of the kube config file for your cluster.
        :param _builtins.str client_key: The base64 encoded client key data required to communicate with your cluster. Add this to the client-key-data section of the kube config file for your cluster.
        :param _builtins.str cluster_cert: The base64 encoded cluster certificate data required to communicate with your cluster. Add this to the certificate-authority-data section of the kube config file for your cluster.
        """
        pulumi.set(__self__, "client_cert", client_cert)
        pulumi.set(__self__, "client_key", client_key)
        pulumi.set(__self__, "cluster_cert", cluster_cert)

    @_builtins.property
    @pulumi.getter(name="clientCert")
    def client_cert(self) -> _builtins.str:
        """
        The base64 encoded client certificate data required to communicate with your cluster. Add this to the client-certificate-data section of the kube config file for your cluster.
        """
        return pulumi.get(self, "client_cert")

    @_builtins.property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> _builtins.str:
        """
        The base64 encoded client key data required to communicate with your cluster. Add this to the client-key-data section of the kube config file for your cluster.
        """
        return pulumi.get(self, "client_key")

    @_builtins.property
    @pulumi.getter(name="clusterCert")
    def cluster_cert(self) -> _builtins.str:
        """
        The base64 encoded cluster certificate data required to communicate with your cluster. Add this to the certificate-authority-data section of the kube config file for your cluster.
        """
        return pulumi.get(self, "cluster_cert")


@pulumi.output_type
class GetEdgeKubernetesClustersClusterResult(dict):
    def __init__(__self__, *,
                 availability_zone: _builtins.str,
                 connections: 'outputs.GetEdgeKubernetesClustersClusterConnectionsResult',
                 id: _builtins.str,
                 name: _builtins.str,
                 nat_gateway_id: _builtins.str,
                 security_group_id: _builtins.str,
                 vpc_id: _builtins.str,
                 worker_nodes: Sequence['outputs.GetEdgeKubernetesClustersClusterWorkerNodeResult']):
        """
        :param _builtins.str availability_zone: The ID of availability zone.
        :param 'GetEdgeKubernetesClustersClusterConnectionsArgs' connections: Map of kubernetes cluster connection information. It contains several attributes to `Block Connections`.
        :param _builtins.str id: ID of the node.
        :param _builtins.str name: Node name.
        :param _builtins.str nat_gateway_id: The ID of nat gateway used to launch kubernetes cluster.
        :param _builtins.str security_group_id: The ID of security group where the current cluster worker node is located.
        :param _builtins.str vpc_id: The ID of VPC where the current cluster is located.
        :param Sequence['GetEdgeKubernetesClustersClusterWorkerNodeArgs'] worker_nodes: List of cluster worker nodes. It contains several attributes to `Block Nodes`.
        """
        pulumi.set(__self__, "availability_zone", availability_zone)
        pulumi.set(__self__, "connections", connections)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "nat_gateway_id", nat_gateway_id)
        pulumi.set(__self__, "security_group_id", security_group_id)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "worker_nodes", worker_nodes)

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> _builtins.str:
        """
        The ID of availability zone.
        """
        return pulumi.get(self, "availability_zone")

    @_builtins.property
    @pulumi.getter
    def connections(self) -> 'outputs.GetEdgeKubernetesClustersClusterConnectionsResult':
        """
        Map of kubernetes cluster connection information. It contains several attributes to `Block Connections`.
        """
        return pulumi.get(self, "connections")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        ID of the node.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Node name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="natGatewayId")
    def nat_gateway_id(self) -> _builtins.str:
        """
        The ID of nat gateway used to launch kubernetes cluster.
        """
        return pulumi.get(self, "nat_gateway_id")

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> _builtins.str:
        """
        The ID of security group where the current cluster worker node is located.
        """
        return pulumi.get(self, "security_group_id")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> _builtins.str:
        """
        The ID of VPC where the current cluster is located.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="workerNodes")
    def worker_nodes(self) -> Sequence['outputs.GetEdgeKubernetesClustersClusterWorkerNodeResult']:
        """
        List of cluster worker nodes. It contains several attributes to `Block Nodes`.
        """
        return pulumi.get(self, "worker_nodes")


@pulumi.output_type
class GetEdgeKubernetesClustersClusterConnectionsResult(dict):
    def __init__(__self__, *,
                 api_server_internet: _builtins.str,
                 api_server_intranet: _builtins.str):
        """
        :param _builtins.str api_server_internet: API Server Internet endpoint.
        :param _builtins.str api_server_intranet: API Server Intranet endpoint.
        """
        pulumi.set(__self__, "api_server_internet", api_server_internet)
        pulumi.set(__self__, "api_server_intranet", api_server_intranet)

    @_builtins.property
    @pulumi.getter(name="apiServerInternet")
    def api_server_internet(self) -> _builtins.str:
        """
        API Server Internet endpoint.
        """
        return pulumi.get(self, "api_server_internet")

    @_builtins.property
    @pulumi.getter(name="apiServerIntranet")
    def api_server_intranet(self) -> _builtins.str:
        """
        API Server Intranet endpoint.
        """
        return pulumi.get(self, "api_server_intranet")


@pulumi.output_type
class GetEdgeKubernetesClustersClusterWorkerNodeResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 name: _builtins.str,
                 private_ip: _builtins.str):
        """
        :param _builtins.str id: ID of the node.
        :param _builtins.str name: Node name.
        :param _builtins.str private_ip: The private IP address of node.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "private_ip", private_ip)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        ID of the node.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Node name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> _builtins.str:
        """
        The private IP address of node.
        """
        return pulumi.get(self, "private_ip")


@pulumi.output_type
class GetKubernetesAddonsAddonResult(dict):
    def __init__(__self__, *,
                 current_config: _builtins.str,
                 current_version: _builtins.str,
                 name: _builtins.str,
                 next_version: _builtins.str,
                 required: _builtins.bool):
        """
        :param _builtins.str current_config: The current custom configuration of the addon. **Note:** Available in v1.166.0+
        :param _builtins.str current_version: The current version of addon, if this field is an empty string, it means that the addon is not installed.
        :param _builtins.str name: The name of addon.
        :param _builtins.str next_version: The next version of this addon can be upgraded to.
        :param _builtins.bool required: Whether the addon is a system addon.
        """
        pulumi.set(__self__, "current_config", current_config)
        pulumi.set(__self__, "current_version", current_version)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "next_version", next_version)
        pulumi.set(__self__, "required", required)

    @_builtins.property
    @pulumi.getter(name="currentConfig")
    def current_config(self) -> _builtins.str:
        """
        The current custom configuration of the addon. **Note:** Available in v1.166.0+
        """
        return pulumi.get(self, "current_config")

    @_builtins.property
    @pulumi.getter(name="currentVersion")
    def current_version(self) -> _builtins.str:
        """
        The current version of addon, if this field is an empty string, it means that the addon is not installed.
        """
        return pulumi.get(self, "current_version")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of addon.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="nextVersion")
    def next_version(self) -> _builtins.str:
        """
        The next version of this addon can be upgraded to.
        """
        return pulumi.get(self, "next_version")

    @_builtins.property
    @pulumi.getter
    def required(self) -> _builtins.bool:
        """
        Whether the addon is a system addon.
        """
        return pulumi.get(self, "required")


@pulumi.output_type
class GetKubernetesClustersClusterResult(dict):
    def __init__(__self__, *,
                 availability_zone: _builtins.str,
                 cluster_network_type: _builtins.str,
                 connections: 'outputs.GetKubernetesClustersClusterConnectionsResult',
                 id: _builtins.str,
                 image_id: _builtins.str,
                 key_name: _builtins.str,
                 log_configs: Sequence['outputs.GetKubernetesClustersClusterLogConfigResult'],
                 master_auto_renew: _builtins.bool,
                 master_auto_renew_period: _builtins.int,
                 master_disk_category: _builtins.str,
                 master_disk_size: _builtins.int,
                 master_instance_charge_type: _builtins.str,
                 master_instance_types: Sequence[_builtins.str],
                 master_nodes: Sequence['outputs.GetKubernetesClustersClusterMasterNodeResult'],
                 master_period: _builtins.int,
                 master_period_unit: _builtins.str,
                 name: _builtins.str,
                 nat_gateway_id: _builtins.str,
                 node_cidr_mask: _builtins.int,
                 pod_cidr: _builtins.str,
                 security_group_id: _builtins.str,
                 service_cidr: _builtins.str,
                 slb_internet_enabled: _builtins.bool,
                 vpc_id: _builtins.str,
                 vswitch_ids: Sequence[_builtins.str],
                 worker_auto_renew: _builtins.bool,
                 worker_auto_renew_period: _builtins.int,
                 worker_data_disk_category: _builtins.str,
                 worker_data_disk_size: _builtins.int,
                 worker_disk_category: _builtins.str,
                 worker_disk_size: _builtins.int,
                 worker_instance_charge_type: _builtins.str,
                 worker_instance_types: Sequence[_builtins.str],
                 worker_nodes: Sequence['outputs.GetKubernetesClustersClusterWorkerNodeResult'],
                 worker_numbers: Sequence[_builtins.int],
                 worker_period: _builtins.int,
                 worker_period_unit: _builtins.str):
        """
        :param _builtins.str availability_zone: The ID of availability zone.
        :param 'GetKubernetesClustersClusterConnectionsArgs' connections: Map of kubernetes cluster connection information. It contains several attributes to `Block Connections`.
        :param _builtins.str id: ID of the node.
        :param _builtins.str image_id: The ID of node image.
        :param _builtins.str key_name: The keypair of ssh login cluster node, you have to create it first.
        :param Sequence['GetKubernetesClustersClusterLogConfigArgs'] log_configs: A list of one element containing information about the associated log store. It contains the following attributes:
        :param _builtins.str master_disk_category: The system disk category of master node.
        :param _builtins.int master_disk_size: The system disk size of master node.
        :param Sequence[_builtins.str] master_instance_types: The instance type of master node.
        :param Sequence['GetKubernetesClustersClusterMasterNodeArgs'] master_nodes: List of cluster master nodes. It contains several attributes to `Block Nodes`.
        :param _builtins.str name: Node name.
        :param _builtins.str nat_gateway_id: The ID of nat gateway used to launch kubernetes cluster.
        :param _builtins.int node_cidr_mask: The network mask used on pods for each node.
        :param _builtins.str security_group_id: The ID of security group where the current cluster worker node is located.
        :param _builtins.bool slb_internet_enabled: Whether internet load balancer for API Server is created
        :param _builtins.str vpc_id: The ID of VPC where the current cluster is located.
        :param Sequence[_builtins.str] vswitch_ids: The ID of VSwitches where the current cluster is located.
        :param _builtins.str worker_data_disk_category: The data disk size of worker node.
        :param _builtins.int worker_data_disk_size: The data disk category of worker node.
        :param _builtins.str worker_disk_category: The system disk category of worker node.
        :param _builtins.int worker_disk_size: The system disk size of worker node.
        :param Sequence[_builtins.str] worker_instance_types: The instance type of worker node.
        :param Sequence['GetKubernetesClustersClusterWorkerNodeArgs'] worker_nodes: List of cluster worker nodes. It contains several attributes to `Block Nodes`.
        :param Sequence[_builtins.int] worker_numbers: The ECS instance node number in the current container cluster.
        """
        pulumi.set(__self__, "availability_zone", availability_zone)
        pulumi.set(__self__, "cluster_network_type", cluster_network_type)
        pulumi.set(__self__, "connections", connections)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "image_id", image_id)
        pulumi.set(__self__, "key_name", key_name)
        pulumi.set(__self__, "log_configs", log_configs)
        pulumi.set(__self__, "master_auto_renew", master_auto_renew)
        pulumi.set(__self__, "master_auto_renew_period", master_auto_renew_period)
        pulumi.set(__self__, "master_disk_category", master_disk_category)
        pulumi.set(__self__, "master_disk_size", master_disk_size)
        pulumi.set(__self__, "master_instance_charge_type", master_instance_charge_type)
        pulumi.set(__self__, "master_instance_types", master_instance_types)
        pulumi.set(__self__, "master_nodes", master_nodes)
        pulumi.set(__self__, "master_period", master_period)
        pulumi.set(__self__, "master_period_unit", master_period_unit)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "nat_gateway_id", nat_gateway_id)
        pulumi.set(__self__, "node_cidr_mask", node_cidr_mask)
        pulumi.set(__self__, "pod_cidr", pod_cidr)
        pulumi.set(__self__, "security_group_id", security_group_id)
        pulumi.set(__self__, "service_cidr", service_cidr)
        pulumi.set(__self__, "slb_internet_enabled", slb_internet_enabled)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vswitch_ids", vswitch_ids)
        pulumi.set(__self__, "worker_auto_renew", worker_auto_renew)
        pulumi.set(__self__, "worker_auto_renew_period", worker_auto_renew_period)
        pulumi.set(__self__, "worker_data_disk_category", worker_data_disk_category)
        pulumi.set(__self__, "worker_data_disk_size", worker_data_disk_size)
        pulumi.set(__self__, "worker_disk_category", worker_disk_category)
        pulumi.set(__self__, "worker_disk_size", worker_disk_size)
        pulumi.set(__self__, "worker_instance_charge_type", worker_instance_charge_type)
        pulumi.set(__self__, "worker_instance_types", worker_instance_types)
        pulumi.set(__self__, "worker_nodes", worker_nodes)
        pulumi.set(__self__, "worker_numbers", worker_numbers)
        pulumi.set(__self__, "worker_period", worker_period)
        pulumi.set(__self__, "worker_period_unit", worker_period_unit)

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> _builtins.str:
        """
        The ID of availability zone.
        """
        return pulumi.get(self, "availability_zone")

    @_builtins.property
    @pulumi.getter(name="clusterNetworkType")
    def cluster_network_type(self) -> _builtins.str:
        return pulumi.get(self, "cluster_network_type")

    @_builtins.property
    @pulumi.getter
    def connections(self) -> 'outputs.GetKubernetesClustersClusterConnectionsResult':
        """
        Map of kubernetes cluster connection information. It contains several attributes to `Block Connections`.
        """
        return pulumi.get(self, "connections")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        ID of the node.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> _builtins.str:
        """
        The ID of node image.
        """
        return pulumi.get(self, "image_id")

    @_builtins.property
    @pulumi.getter(name="keyName")
    def key_name(self) -> _builtins.str:
        """
        The keypair of ssh login cluster node, you have to create it first.
        """
        return pulumi.get(self, "key_name")

    @_builtins.property
    @pulumi.getter(name="logConfigs")
    def log_configs(self) -> Sequence['outputs.GetKubernetesClustersClusterLogConfigResult']:
        """
        A list of one element containing information about the associated log store. It contains the following attributes:
        """
        return pulumi.get(self, "log_configs")

    @_builtins.property
    @pulumi.getter(name="masterAutoRenew")
    def master_auto_renew(self) -> _builtins.bool:
        return pulumi.get(self, "master_auto_renew")

    @_builtins.property
    @pulumi.getter(name="masterAutoRenewPeriod")
    def master_auto_renew_period(self) -> _builtins.int:
        return pulumi.get(self, "master_auto_renew_period")

    @_builtins.property
    @pulumi.getter(name="masterDiskCategory")
    def master_disk_category(self) -> _builtins.str:
        """
        The system disk category of master node.
        """
        return pulumi.get(self, "master_disk_category")

    @_builtins.property
    @pulumi.getter(name="masterDiskSize")
    def master_disk_size(self) -> _builtins.int:
        """
        The system disk size of master node.
        """
        return pulumi.get(self, "master_disk_size")

    @_builtins.property
    @pulumi.getter(name="masterInstanceChargeType")
    def master_instance_charge_type(self) -> _builtins.str:
        return pulumi.get(self, "master_instance_charge_type")

    @_builtins.property
    @pulumi.getter(name="masterInstanceTypes")
    def master_instance_types(self) -> Sequence[_builtins.str]:
        """
        The instance type of master node.
        """
        return pulumi.get(self, "master_instance_types")

    @_builtins.property
    @pulumi.getter(name="masterNodes")
    def master_nodes(self) -> Sequence['outputs.GetKubernetesClustersClusterMasterNodeResult']:
        """
        List of cluster master nodes. It contains several attributes to `Block Nodes`.
        """
        return pulumi.get(self, "master_nodes")

    @_builtins.property
    @pulumi.getter(name="masterPeriod")
    def master_period(self) -> _builtins.int:
        return pulumi.get(self, "master_period")

    @_builtins.property
    @pulumi.getter(name="masterPeriodUnit")
    def master_period_unit(self) -> _builtins.str:
        return pulumi.get(self, "master_period_unit")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Node name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="natGatewayId")
    def nat_gateway_id(self) -> _builtins.str:
        """
        The ID of nat gateway used to launch kubernetes cluster.
        """
        return pulumi.get(self, "nat_gateway_id")

    @_builtins.property
    @pulumi.getter(name="nodeCidrMask")
    def node_cidr_mask(self) -> _builtins.int:
        """
        The network mask used on pods for each node.
        """
        return pulumi.get(self, "node_cidr_mask")

    @_builtins.property
    @pulumi.getter(name="podCidr")
    def pod_cidr(self) -> _builtins.str:
        return pulumi.get(self, "pod_cidr")

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> _builtins.str:
        """
        The ID of security group where the current cluster worker node is located.
        """
        return pulumi.get(self, "security_group_id")

    @_builtins.property
    @pulumi.getter(name="serviceCidr")
    def service_cidr(self) -> _builtins.str:
        return pulumi.get(self, "service_cidr")

    @_builtins.property
    @pulumi.getter(name="slbInternetEnabled")
    def slb_internet_enabled(self) -> _builtins.bool:
        """
        Whether internet load balancer for API Server is created
        """
        return pulumi.get(self, "slb_internet_enabled")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> _builtins.str:
        """
        The ID of VPC where the current cluster is located.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vswitchIds")
    def vswitch_ids(self) -> Sequence[_builtins.str]:
        """
        The ID of VSwitches where the current cluster is located.
        """
        return pulumi.get(self, "vswitch_ids")

    @_builtins.property
    @pulumi.getter(name="workerAutoRenew")
    def worker_auto_renew(self) -> _builtins.bool:
        return pulumi.get(self, "worker_auto_renew")

    @_builtins.property
    @pulumi.getter(name="workerAutoRenewPeriod")
    def worker_auto_renew_period(self) -> _builtins.int:
        return pulumi.get(self, "worker_auto_renew_period")

    @_builtins.property
    @pulumi.getter(name="workerDataDiskCategory")
    def worker_data_disk_category(self) -> _builtins.str:
        """
        The data disk size of worker node.
        """
        return pulumi.get(self, "worker_data_disk_category")

    @_builtins.property
    @pulumi.getter(name="workerDataDiskSize")
    def worker_data_disk_size(self) -> _builtins.int:
        """
        The data disk category of worker node.
        """
        return pulumi.get(self, "worker_data_disk_size")

    @_builtins.property
    @pulumi.getter(name="workerDiskCategory")
    def worker_disk_category(self) -> _builtins.str:
        """
        The system disk category of worker node.
        """
        return pulumi.get(self, "worker_disk_category")

    @_builtins.property
    @pulumi.getter(name="workerDiskSize")
    def worker_disk_size(self) -> _builtins.int:
        """
        The system disk size of worker node.
        """
        return pulumi.get(self, "worker_disk_size")

    @_builtins.property
    @pulumi.getter(name="workerInstanceChargeType")
    def worker_instance_charge_type(self) -> _builtins.str:
        return pulumi.get(self, "worker_instance_charge_type")

    @_builtins.property
    @pulumi.getter(name="workerInstanceTypes")
    def worker_instance_types(self) -> Sequence[_builtins.str]:
        """
        The instance type of worker node.
        """
        return pulumi.get(self, "worker_instance_types")

    @_builtins.property
    @pulumi.getter(name="workerNodes")
    def worker_nodes(self) -> Sequence['outputs.GetKubernetesClustersClusterWorkerNodeResult']:
        """
        List of cluster worker nodes. It contains several attributes to `Block Nodes`.
        """
        return pulumi.get(self, "worker_nodes")

    @_builtins.property
    @pulumi.getter(name="workerNumbers")
    def worker_numbers(self) -> Sequence[_builtins.int]:
        """
        The ECS instance node number in the current container cluster.
        """
        return pulumi.get(self, "worker_numbers")

    @_builtins.property
    @pulumi.getter(name="workerPeriod")
    def worker_period(self) -> _builtins.int:
        return pulumi.get(self, "worker_period")

    @_builtins.property
    @pulumi.getter(name="workerPeriodUnit")
    def worker_period_unit(self) -> _builtins.str:
        return pulumi.get(self, "worker_period_unit")


@pulumi.output_type
class GetKubernetesClustersClusterConnectionsResult(dict):
    def __init__(__self__, *,
                 api_server_internet: _builtins.str,
                 api_server_intranet: _builtins.str,
                 master_public_ip: _builtins.str,
                 service_domain: _builtins.str):
        """
        :param _builtins.str api_server_internet: API Server Internet endpoint.
        :param _builtins.str api_server_intranet: API Server Intranet endpoint.
        :param _builtins.str master_public_ip: Master node SSH IP address.
        :param _builtins.str service_domain: Service Access Domain.
        """
        pulumi.set(__self__, "api_server_internet", api_server_internet)
        pulumi.set(__self__, "api_server_intranet", api_server_intranet)
        pulumi.set(__self__, "master_public_ip", master_public_ip)
        pulumi.set(__self__, "service_domain", service_domain)

    @_builtins.property
    @pulumi.getter(name="apiServerInternet")
    def api_server_internet(self) -> _builtins.str:
        """
        API Server Internet endpoint.
        """
        return pulumi.get(self, "api_server_internet")

    @_builtins.property
    @pulumi.getter(name="apiServerIntranet")
    def api_server_intranet(self) -> _builtins.str:
        """
        API Server Intranet endpoint.
        """
        return pulumi.get(self, "api_server_intranet")

    @_builtins.property
    @pulumi.getter(name="masterPublicIp")
    def master_public_ip(self) -> _builtins.str:
        """
        Master node SSH IP address.
        """
        return pulumi.get(self, "master_public_ip")

    @_builtins.property
    @pulumi.getter(name="serviceDomain")
    def service_domain(self) -> _builtins.str:
        """
        Service Access Domain.
        """
        return pulumi.get(self, "service_domain")


@pulumi.output_type
class GetKubernetesClustersClusterLogConfigResult(dict):
    def __init__(__self__, *,
                 project: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str project: Log Service project name.
        :param _builtins.str type: Type of collecting logs.
        """
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def project(self) -> _builtins.str:
        """
        Log Service project name.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of collecting logs.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetKubernetesClustersClusterMasterNodeResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 name: _builtins.str,
                 private_ip: _builtins.str):
        """
        :param _builtins.str id: ID of the node.
        :param _builtins.str name: Node name.
        :param _builtins.str private_ip: The private IP address of node.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "private_ip", private_ip)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        ID of the node.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Node name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> _builtins.str:
        """
        The private IP address of node.
        """
        return pulumi.get(self, "private_ip")


@pulumi.output_type
class GetKubernetesClustersClusterWorkerNodeResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 name: _builtins.str,
                 private_ip: _builtins.str):
        """
        :param _builtins.str id: ID of the node.
        :param _builtins.str name: Node name.
        :param _builtins.str private_ip: The private IP address of node.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "private_ip", private_ip)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        ID of the node.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Node name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> _builtins.str:
        """
        The private IP address of node.
        """
        return pulumi.get(self, "private_ip")


@pulumi.output_type
class GetKubernetesNodePoolsNodepoolResult(dict):
    def __init__(__self__, *,
                 auto_renew: _builtins.bool,
                 auto_renew_period: _builtins.int,
                 cis_enabled: _builtins.bool,
                 compensate_with_on_demand: _builtins.bool,
                 cpu_policy: _builtins.str,
                 data_disks: Sequence['outputs.GetKubernetesNodePoolsNodepoolDataDiskResult'],
                 deployment_set_id: _builtins.str,
                 desired_size: _builtins.str,
                 image_id: _builtins.str,
                 image_type: _builtins.str,
                 install_cloud_monitor: _builtins.bool,
                 instance_charge_type: _builtins.str,
                 instance_types: Sequence[_builtins.str],
                 internet_charge_type: _builtins.str,
                 internet_max_bandwidth_out: _builtins.int,
                 key_name: _builtins.str,
                 kubelet_configuration: 'outputs.GetKubernetesNodePoolsNodepoolKubeletConfigurationResult',
                 labels: Sequence['outputs.GetKubernetesNodePoolsNodepoolLabelResult'],
                 login_as_non_root: _builtins.bool,
                 management: 'outputs.GetKubernetesNodePoolsNodepoolManagementResult',
                 multi_az_policy: _builtins.str,
                 node_name_mode: _builtins.str,
                 node_pool_id: _builtins.str,
                 node_pool_name: _builtins.str,
                 on_demand_base_capacity: _builtins.str,
                 on_demand_percentage_above_base_capacity: _builtins.str,
                 password: _builtins.str,
                 period: _builtins.int,
                 period_unit: _builtins.str,
                 platform: _builtins.str,
                 pre_user_data: _builtins.str,
                 private_pool_options: 'outputs.GetKubernetesNodePoolsNodepoolPrivatePoolOptionsResult',
                 ram_role_name: _builtins.str,
                 rds_instances: Sequence[_builtins.str],
                 resource_group_id: _builtins.str,
                 runtime_name: _builtins.str,
                 runtime_version: _builtins.str,
                 scaling_config: 'outputs.GetKubernetesNodePoolsNodepoolScalingConfigResult',
                 scaling_group_id: _builtins.str,
                 scaling_policy: _builtins.str,
                 security_group_id: _builtins.str,
                 security_group_ids: Sequence[_builtins.str],
                 security_hardening_os: _builtins.bool,
                 soc_enabled: _builtins.bool,
                 spot_instance_pools: _builtins.int,
                 spot_instance_remedy: _builtins.bool,
                 spot_price_limits: Sequence['outputs.GetKubernetesNodePoolsNodepoolSpotPriceLimitResult'],
                 spot_strategy: _builtins.str,
                 system_disk_bursting_enabled: _builtins.bool,
                 system_disk_categories: Sequence[_builtins.str],
                 system_disk_category: _builtins.str,
                 system_disk_encrypt_algorithm: _builtins.str,
                 system_disk_encrypted: _builtins.bool,
                 system_disk_kms_key: _builtins.str,
                 system_disk_performance_level: _builtins.str,
                 system_disk_provisioned_iops: _builtins.int,
                 system_disk_size: _builtins.int,
                 system_disk_snapshot_policy_id: _builtins.str,
                 tags: Mapping[str, _builtins.str],
                 taints: Sequence['outputs.GetKubernetesNodePoolsNodepoolTaintResult'],
                 tee_config: 'outputs.GetKubernetesNodePoolsNodepoolTeeConfigResult',
                 unschedulable: _builtins.bool,
                 user_data: _builtins.str,
                 vswitch_ids: Sequence[_builtins.str]):
        """
        :param _builtins.bool auto_renew: Whether to enable automatic renewal for nodes in the node pool takes effect only when `instance_charge_type` is set to `PrePaid`. Default value: `false`. Valid values:- `true`: Automatic renewal. - `false`: Do not renew automatically.
        :param _builtins.int auto_renew_period: The automatic renewal period of nodes in the node pool takes effect only when you select Prepaid and Automatic Renewal, and is a required value. When `PeriodUnit = Month`, the value range is {1, 2, 3, 6, 12}. Default value: 1.
        :param _builtins.bool cis_enabled: Whether enable worker node to support cis security reinforcement, its valid value `true` or `false`. Default to `false` and apply to AliyunLinux series. Use `security_hardening_os` instead.
        :param _builtins.bool compensate_with_on_demand: Specifies whether to automatically create pay-as-you-go instances to meet the required number of ECS instances if preemptible instances cannot be created due to reasons such as cost or insufficient inventory. This parameter takes effect when you set `multi_az_policy` to `COST_OPTIMIZED`. Valid values: `true`: automatically creates pay-as-you-go instances to meet the required number of ECS instances if preemptible instances cannot be created. `false`: does not create pay-as-you-go instances to meet the required number of ECS instances if preemptible instances cannot be created.
        :param _builtins.str cpu_policy: Node CPU management policies. Default value: `none`. When the cluster version is 1.12.6 or later, the following two policies are supported:- `static`: allows pods with certain resource characteristics on the node to enhance its CPU affinity and exclusivity.- `none`: Enables the existing default CPU affinity scheme.
        :param Sequence['GetKubernetesNodePoolsNodepoolDataDiskArgs'] data_disks: Configure the data disk of the node in the node pool.
        :param _builtins.str deployment_set_id: The deployment set of node pool. Specify the deploymentSet to ensure that the nodes in the node pool can be distributed on different physical machines.
        :param _builtins.str desired_size: Number of expected nodes in the node pool.
        :param _builtins.str image_id: The custom image ID. The system-provided image is used by default.
        :param _builtins.str image_type: The operating system image type and the `platform` parameter can be selected from the following values:- `AliyunLinux` : Alinux2 image.- `AliyunLinux3` : Alinux3 image.- `AliyunLinux3Arm64` : Alinux3 mirror ARM version.- `AliyunLinuxUEFI` : Alinux2 Image UEFI version.- `CentOS` : CentOS image.- `Windows` : Windows image.- `WindowsCore` : WindowsCore image.- `ContainerOS` : container-optimized image.- `Ubuntu`: Ubuntu image.
        :param _builtins.bool install_cloud_monitor: Whether to install cloud monitoring on the ECS node. After installation, you can view the monitoring information of the created ECS instance in the cloud monitoring console and recommend enable it. Default value: `false`. Valid values:- `true` : install cloud monitoring on the ECS node.- `false` : does not install cloud monitoring on the ECS node.
        :param _builtins.str instance_charge_type: Node payment type. Valid values: `PostPaid`, `PrePaid`, default is `PostPaid`. If value is `PrePaid`, the arguments `period`, `period_unit`, `auto_renew` and `auto_renew_period` are required.
        :param Sequence[_builtins.str] instance_types: In the node instance specification list, you can select multiple instance specifications as alternatives. When each node is created, it will try to purchase from the first specification until it is created successfully. The final purchased instance specifications may vary with inventory changes.
        :param _builtins.str internet_charge_type: The billing method for network usage. Valid values `PayByBandwidth` and `PayByTraffic`. Conflict with `eip_internet_charge_type`, EIP and public network IP can only choose one.
        :param _builtins.int internet_max_bandwidth_out: The maximum bandwidth of the public IP address of the node. The unit is Mbps(Mega bit per second). The value range is:\\[1,100\\]
        :param _builtins.str key_name: The name of the key pair. When the node pool is a managed node pool, only `key_name` is supported.
        :param 'GetKubernetesNodePoolsNodepoolKubeletConfigurationArgs' kubelet_configuration: Kubelet configuration parameters for worker nodes. See `kubelet_configuration` below. More information in [Kubelet Configuration](https://kubernetes.io/docs/reference/config-api/kubelet-config.v1beta1/).
        :param Sequence['GetKubernetesNodePoolsNodepoolLabelArgs'] labels: A List of Kubernetes labels to assign to the nodes . Only labels that are applied with the ACK API are managed by this argument. Detailed below. More information in [Labels](https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/).
        :param _builtins.bool login_as_non_root: Whether the ECS instance is logged on as a ecs-user user. Valid value: `true` and `false`.
        :param 'GetKubernetesNodePoolsNodepoolManagementArgs' management: Managed node pool configuration.
        :param _builtins.str multi_az_policy: The scaling policy for ECS instances in a multi-zone scaling group. Valid value: `PRIORITY`, `COST_OPTIMIZED` and `BALANCE`. `PRIORITY`: scales the capacity according to the virtual switches you define (VSwitchIds.N). When an ECS instance cannot be created in the zone where the higher-priority vSwitch is located, the next-priority vSwitch is automatically used to create an ECS instance. `COST_OPTIMIZED`: try to create by vCPU unit price from low to high. When the scaling configuration is configured with multiple instances of preemptible billing, preemptible instances are created first. You can continue to use the `CompensateWithOnDemand` parameter to specify whether to automatically try to create a preemptible instance by paying for it. It takes effect only when the scaling configuration has multi-instance specifications or preemptible instances. `BALANCE`: distributes ECS instances evenly among the multi-zone specified by the scaling group. If the zones become unbalanced due to insufficient inventory, you can use the API RebalanceInstances to balance resources.
        :param _builtins.str node_name_mode: Each node name consists of a prefix, its private network IP, and a suffix, separated by commas. The input format is `customized,,ip,`.- The prefix and suffix can be composed of one or more parts separated by '.', each part can use lowercase letters, numbers and '-', and the beginning and end of the node name must be lowercase letters and numbers.- The node IP address is the complete private IP address of the node.- For example, if the string `customized,aliyun,ip,com` is passed in (where 'customized' and 'ip' are fixed strings, 'aliyun' is the prefix, and 'com' is the suffix), the name of the node is `aliyun192.168.xxx.xxxcom`.
        :param _builtins.str node_pool_id: The first ID of the resource.
        :param _builtins.str node_pool_name: The name of node pool.
        :param _builtins.str on_demand_base_capacity: The minimum number of pay-as-you-go instances that must be kept in the scaling group. Valid values: 0 to 1000. If the number of pay-as-you-go instances is less than the value of this parameter, Auto Scaling preferably creates pay-as-you-go instances.
        :param _builtins.str on_demand_percentage_above_base_capacity: The percentage of pay-as-you-go instances among the extra instances that exceed the number specified by `on_demand_base_capacity`. Valid values: 0 to 100.
        :param _builtins.str password: The password of ssh login. You have to specify one of `password` and `key_name` fields. The password rule is 8 to 30 characters and contains at least three items (upper and lower case letters, numbers, and special symbols).
        :param _builtins.int period: Node payment period. Its valid value is one of {1, 2, 3, 6, 12}.
        :param _builtins.str period_unit: Node payment period unit, valid value: `Month`. Default is `Month`.
        :param _builtins.str platform: Operating system release, using `image_type` instead.
        :param _builtins.str pre_user_data: Node pre custom data, base64-encoded, the script executed before the node is initialized.
        :param 'GetKubernetesNodePoolsNodepoolPrivatePoolOptionsArgs' private_pool_options: Private node pool configuration.
        :param _builtins.str ram_role_name: The name of the Worker RAM role.* If it is empty, the default Worker RAM role created in the cluster will be used.* If the specified RAM role is not empty, the specified RAM role must be a **Common Service role**, and its **trusted service** configuration must be **cloud server**. For more information, see [Create a common service role](https://help.aliyun.com/document_detail/116800.html). If the specified RAM role is not the default Worker RAM role created in the cluster, the role name cannot start with 'KubernetesMasterRole-'or 'KubernetesWorkerRole.> **NOTE:**  This parameter is only supported for ACK-managed clusters of 1.22 or later versions.
        :param Sequence[_builtins.str] rds_instances: The list of RDS instances.
        :param _builtins.str resource_group_id: The ID of the resource group
        :param _builtins.str runtime_name: The runtime name of containers. If not set, the cluster runtime will be used as the node pool runtime. If you select another container runtime, see [Comparison of Docker, containerd, and Sandboxed-Container](https://www.alibabacloud.com/help/doc-detail/160313.htm).
        :param _builtins.str runtime_version: The runtime version of containers. If not set, the cluster runtime will be used as the node pool runtime.
        :param 'GetKubernetesNodePoolsNodepoolScalingConfigArgs' scaling_config: Automatic scaling configuration.
        :param _builtins.str scaling_group_id: The ID of the scaling group.
        :param _builtins.str scaling_policy: Scaling group mode, default value: `release`. Valid values:- `release`: in the standard mode, scaling is performed by creating and releasing ECS instances based on the usage of the application resource value.- `recycle`: in the speed mode, scaling is performed through creation, shutdown, and startup to increase the speed of scaling again (computing resources are not charged during shutdown, only storage fees are charged, except for local disk models).
        :param _builtins.str security_group_id: The security group ID of the node pool. This field has been replaced by `security_group_ids`, please use the `security_group_ids` field instead.
        :param Sequence[_builtins.str] security_group_ids: Multiple security groups can be configured for a node pool. If both `security_group_ids` and `security_group_id` are configured, `security_group_ids` takes effect. This field cannot be modified.
        :param _builtins.bool security_hardening_os: Alibaba Cloud OS security reinforcement. Default value: `false`. Value:-`true`: enable Alibaba Cloud OS security reinforcement.-`false`: does not enable Alibaba Cloud OS security reinforcement.
        :param _builtins.bool soc_enabled: Whether enable worker node to support soc security reinforcement, its valid value `true` or `false`. Default to `false` and apply to AliyunLinux series. See [SOC Reinforcement](https://help.aliyun.com/document_detail/196148.html).> It is forbidden to set both `security_hardening_os` and `soc_enabled` to `true` at the same time.
        :param _builtins.int spot_instance_pools: The number of instance types that are available. Auto Scaling creates preemptible instances of multiple instance types that are available at the lowest cost. Valid values: 1 to 10.
        :param _builtins.bool spot_instance_remedy: Specifies whether to supplement preemptible instances when the number of preemptible instances drops below the specified minimum number. If you set the value to true, Auto Scaling attempts to create a new preemptible instance when the system notifies that an existing preemptible instance is about to be reclaimed. Valid values: `true`: enables the supplementation of preemptible instances. `false`: disables the supplementation of preemptible instances.
        :param Sequence['GetKubernetesNodePoolsNodepoolSpotPriceLimitArgs'] spot_price_limits: The current single preemptible instance type market price range configuration.
        :param _builtins.str spot_strategy: The preemptible instance type. Value:- `NoSpot` : Non-preemptible instance.- `SpotWithPriceLimit` : Set the upper limit of the preemptible instance price.- `SpotAsPriceGo` : The system automatically bids, following the actual price of the current market.
        :param _builtins.bool system_disk_bursting_enabled: Specifies whether to enable the burst feature for system disks. Valid values:`true`: enables the burst feature. `false`: disables the burst feature. This parameter is supported only when `system_disk_category` is set to `cloud_auto`.
        :param Sequence[_builtins.str] system_disk_categories: The multi-disk categories of the system disk. When a high-priority disk type cannot be used, Auto Scaling automatically tries to create a system disk with the next priority disk category. Valid values see `system_disk_category`.
        :param _builtins.str system_disk_category: The category of the system disk for nodes. Default value: `cloud_efficiency`. Valid values:- `cloud`: basic disk.- `cloud_efficiency`: ultra disk.- `cloud_ssd`: standard SSD.- `cloud_essd`: ESSD.- `cloud_auto`: ESSD AutoPL disk.- `cloud_essd_entry`: ESSD Entry disk.
        :param _builtins.str system_disk_encrypt_algorithm: The encryption algorithm used by the system disk. Value range: aes-256.
        :param _builtins.bool system_disk_encrypted: Whether to encrypt the system disk. Value range: `true`: encryption. `false`: Do not encrypt.
        :param _builtins.str system_disk_kms_key: The ID of the KMS key used by the system disk.
        :param _builtins.str system_disk_performance_level: The system disk performance of the node takes effect only for the ESSD disk.- `PL0`: maximum random read/write IOPS 10000 for a single disk.- `PL1`: maximum random read/write IOPS 50000 for a single disk.- `PL2`: highest random read/write IOPS 100000 for a single disk.- `PL3`: maximum random read/write IOPS 1 million for a single disk.
        :param _builtins.int system_disk_provisioned_iops: The predefined IOPS of a system disk. Valid values: 0 to min{50,000, 1,000 × Capacity - Baseline IOPS}. Baseline IOPS = min{1,800 + 50 × Capacity, 50,000}. This parameter is supported only when `system_disk_category` is set to `cloud_auto`.
        :param _builtins.int system_disk_size: The size of the system disk. Unit: GiB. The value of this parameter must be at least 1 and greater than or equal to the image size. Default value: 40 or the size of the image, whichever is larger.- Basic disk: 20 to 500.- ESSD (cloud_essd): The valid values vary based on the performance level of the ESSD. PL0 ESSD: 1 to 2048. PL1 ESSD: 20 to 2048. PL2 ESSD: 461 to 2048. PL3 ESSD: 1261 to 2048.- ESSD AutoPL disk (cloud_auto): 1 to 2048.- Other disk categories: 20 to 2048.
        :param _builtins.str system_disk_snapshot_policy_id: The ID of the automatic snapshot policy used by the system disk.
        :param Mapping[str, _builtins.str] tags: Add tags only for ECS instances. The maximum length of the tag key is 128 characters. The tag key and value cannot start with aliyun or acs:, or contain https:// or http://.
        :param Sequence['GetKubernetesNodePoolsNodepoolTaintArgs'] taints: A List of Kubernetes taints to assign to the nodes. Detailed below. More information in [Taints and Toleration](https://kubernetes.io/docs/concepts/scheduling-eviction/taint-and-toleration/).
        :param 'GetKubernetesNodePoolsNodepoolTeeConfigArgs' tee_config: The configuration about confidential computing for the cluster.
        :param _builtins.bool unschedulable: Whether the node after expansion can be scheduled.
        :param _builtins.str user_data: Node custom data, base64-encoded.
        :param Sequence[_builtins.str] vswitch_ids: The vswitches used by node pool workers.
        """
        pulumi.set(__self__, "auto_renew", auto_renew)
        pulumi.set(__self__, "auto_renew_period", auto_renew_period)
        pulumi.set(__self__, "cis_enabled", cis_enabled)
        pulumi.set(__self__, "compensate_with_on_demand", compensate_with_on_demand)
        pulumi.set(__self__, "cpu_policy", cpu_policy)
        pulumi.set(__self__, "data_disks", data_disks)
        pulumi.set(__self__, "deployment_set_id", deployment_set_id)
        pulumi.set(__self__, "desired_size", desired_size)
        pulumi.set(__self__, "image_id", image_id)
        pulumi.set(__self__, "image_type", image_type)
        pulumi.set(__self__, "install_cloud_monitor", install_cloud_monitor)
        pulumi.set(__self__, "instance_charge_type", instance_charge_type)
        pulumi.set(__self__, "instance_types", instance_types)
        pulumi.set(__self__, "internet_charge_type", internet_charge_type)
        pulumi.set(__self__, "internet_max_bandwidth_out", internet_max_bandwidth_out)
        pulumi.set(__self__, "key_name", key_name)
        pulumi.set(__self__, "kubelet_configuration", kubelet_configuration)
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "login_as_non_root", login_as_non_root)
        pulumi.set(__self__, "management", management)
        pulumi.set(__self__, "multi_az_policy", multi_az_policy)
        pulumi.set(__self__, "node_name_mode", node_name_mode)
        pulumi.set(__self__, "node_pool_id", node_pool_id)
        pulumi.set(__self__, "node_pool_name", node_pool_name)
        pulumi.set(__self__, "on_demand_base_capacity", on_demand_base_capacity)
        pulumi.set(__self__, "on_demand_percentage_above_base_capacity", on_demand_percentage_above_base_capacity)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "period", period)
        pulumi.set(__self__, "period_unit", period_unit)
        pulumi.set(__self__, "platform", platform)
        pulumi.set(__self__, "pre_user_data", pre_user_data)
        pulumi.set(__self__, "private_pool_options", private_pool_options)
        pulumi.set(__self__, "ram_role_name", ram_role_name)
        pulumi.set(__self__, "rds_instances", rds_instances)
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        pulumi.set(__self__, "runtime_name", runtime_name)
        pulumi.set(__self__, "runtime_version", runtime_version)
        pulumi.set(__self__, "scaling_config", scaling_config)
        pulumi.set(__self__, "scaling_group_id", scaling_group_id)
        pulumi.set(__self__, "scaling_policy", scaling_policy)
        pulumi.set(__self__, "security_group_id", security_group_id)
        pulumi.set(__self__, "security_group_ids", security_group_ids)
        pulumi.set(__self__, "security_hardening_os", security_hardening_os)
        pulumi.set(__self__, "soc_enabled", soc_enabled)
        pulumi.set(__self__, "spot_instance_pools", spot_instance_pools)
        pulumi.set(__self__, "spot_instance_remedy", spot_instance_remedy)
        pulumi.set(__self__, "spot_price_limits", spot_price_limits)
        pulumi.set(__self__, "spot_strategy", spot_strategy)
        pulumi.set(__self__, "system_disk_bursting_enabled", system_disk_bursting_enabled)
        pulumi.set(__self__, "system_disk_categories", system_disk_categories)
        pulumi.set(__self__, "system_disk_category", system_disk_category)
        pulumi.set(__self__, "system_disk_encrypt_algorithm", system_disk_encrypt_algorithm)
        pulumi.set(__self__, "system_disk_encrypted", system_disk_encrypted)
        pulumi.set(__self__, "system_disk_kms_key", system_disk_kms_key)
        pulumi.set(__self__, "system_disk_performance_level", system_disk_performance_level)
        pulumi.set(__self__, "system_disk_provisioned_iops", system_disk_provisioned_iops)
        pulumi.set(__self__, "system_disk_size", system_disk_size)
        pulumi.set(__self__, "system_disk_snapshot_policy_id", system_disk_snapshot_policy_id)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "taints", taints)
        pulumi.set(__self__, "tee_config", tee_config)
        pulumi.set(__self__, "unschedulable", unschedulable)
        pulumi.set(__self__, "user_data", user_data)
        pulumi.set(__self__, "vswitch_ids", vswitch_ids)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> _builtins.bool:
        """
        Whether to enable automatic renewal for nodes in the node pool takes effect only when `instance_charge_type` is set to `PrePaid`. Default value: `false`. Valid values:- `true`: Automatic renewal. - `false`: Do not renew automatically.
        """
        return pulumi.get(self, "auto_renew")

    @_builtins.property
    @pulumi.getter(name="autoRenewPeriod")
    def auto_renew_period(self) -> _builtins.int:
        """
        The automatic renewal period of nodes in the node pool takes effect only when you select Prepaid and Automatic Renewal, and is a required value. When `PeriodUnit = Month`, the value range is {1, 2, 3, 6, 12}. Default value: 1.
        """
        return pulumi.get(self, "auto_renew_period")

    @_builtins.property
    @pulumi.getter(name="cisEnabled")
    def cis_enabled(self) -> _builtins.bool:
        """
        Whether enable worker node to support cis security reinforcement, its valid value `true` or `false`. Default to `false` and apply to AliyunLinux series. Use `security_hardening_os` instead.
        """
        return pulumi.get(self, "cis_enabled")

    @_builtins.property
    @pulumi.getter(name="compensateWithOnDemand")
    def compensate_with_on_demand(self) -> _builtins.bool:
        """
        Specifies whether to automatically create pay-as-you-go instances to meet the required number of ECS instances if preemptible instances cannot be created due to reasons such as cost or insufficient inventory. This parameter takes effect when you set `multi_az_policy` to `COST_OPTIMIZED`. Valid values: `true`: automatically creates pay-as-you-go instances to meet the required number of ECS instances if preemptible instances cannot be created. `false`: does not create pay-as-you-go instances to meet the required number of ECS instances if preemptible instances cannot be created.
        """
        return pulumi.get(self, "compensate_with_on_demand")

    @_builtins.property
    @pulumi.getter(name="cpuPolicy")
    def cpu_policy(self) -> _builtins.str:
        """
        Node CPU management policies. Default value: `none`. When the cluster version is 1.12.6 or later, the following two policies are supported:- `static`: allows pods with certain resource characteristics on the node to enhance its CPU affinity and exclusivity.- `none`: Enables the existing default CPU affinity scheme.
        """
        return pulumi.get(self, "cpu_policy")

    @_builtins.property
    @pulumi.getter(name="dataDisks")
    def data_disks(self) -> Sequence['outputs.GetKubernetesNodePoolsNodepoolDataDiskResult']:
        """
        Configure the data disk of the node in the node pool.
        """
        return pulumi.get(self, "data_disks")

    @_builtins.property
    @pulumi.getter(name="deploymentSetId")
    def deployment_set_id(self) -> _builtins.str:
        """
        The deployment set of node pool. Specify the deploymentSet to ensure that the nodes in the node pool can be distributed on different physical machines.
        """
        return pulumi.get(self, "deployment_set_id")

    @_builtins.property
    @pulumi.getter(name="desiredSize")
    def desired_size(self) -> _builtins.str:
        """
        Number of expected nodes in the node pool.
        """
        return pulumi.get(self, "desired_size")

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> _builtins.str:
        """
        The custom image ID. The system-provided image is used by default.
        """
        return pulumi.get(self, "image_id")

    @_builtins.property
    @pulumi.getter(name="imageType")
    def image_type(self) -> _builtins.str:
        """
        The operating system image type and the `platform` parameter can be selected from the following values:- `AliyunLinux` : Alinux2 image.- `AliyunLinux3` : Alinux3 image.- `AliyunLinux3Arm64` : Alinux3 mirror ARM version.- `AliyunLinuxUEFI` : Alinux2 Image UEFI version.- `CentOS` : CentOS image.- `Windows` : Windows image.- `WindowsCore` : WindowsCore image.- `ContainerOS` : container-optimized image.- `Ubuntu`: Ubuntu image.
        """
        return pulumi.get(self, "image_type")

    @_builtins.property
    @pulumi.getter(name="installCloudMonitor")
    def install_cloud_monitor(self) -> _builtins.bool:
        """
        Whether to install cloud monitoring on the ECS node. After installation, you can view the monitoring information of the created ECS instance in the cloud monitoring console and recommend enable it. Default value: `false`. Valid values:- `true` : install cloud monitoring on the ECS node.- `false` : does not install cloud monitoring on the ECS node.
        """
        return pulumi.get(self, "install_cloud_monitor")

    @_builtins.property
    @pulumi.getter(name="instanceChargeType")
    def instance_charge_type(self) -> _builtins.str:
        """
        Node payment type. Valid values: `PostPaid`, `PrePaid`, default is `PostPaid`. If value is `PrePaid`, the arguments `period`, `period_unit`, `auto_renew` and `auto_renew_period` are required.
        """
        return pulumi.get(self, "instance_charge_type")

    @_builtins.property
    @pulumi.getter(name="instanceTypes")
    def instance_types(self) -> Sequence[_builtins.str]:
        """
        In the node instance specification list, you can select multiple instance specifications as alternatives. When each node is created, it will try to purchase from the first specification until it is created successfully. The final purchased instance specifications may vary with inventory changes.
        """
        return pulumi.get(self, "instance_types")

    @_builtins.property
    @pulumi.getter(name="internetChargeType")
    def internet_charge_type(self) -> _builtins.str:
        """
        The billing method for network usage. Valid values `PayByBandwidth` and `PayByTraffic`. Conflict with `eip_internet_charge_type`, EIP and public network IP can only choose one.
        """
        return pulumi.get(self, "internet_charge_type")

    @_builtins.property
    @pulumi.getter(name="internetMaxBandwidthOut")
    def internet_max_bandwidth_out(self) -> _builtins.int:
        """
        The maximum bandwidth of the public IP address of the node. The unit is Mbps(Mega bit per second). The value range is:\\[1,100\\]
        """
        return pulumi.get(self, "internet_max_bandwidth_out")

    @_builtins.property
    @pulumi.getter(name="keyName")
    def key_name(self) -> _builtins.str:
        """
        The name of the key pair. When the node pool is a managed node pool, only `key_name` is supported.
        """
        return pulumi.get(self, "key_name")

    @_builtins.property
    @pulumi.getter(name="kubeletConfiguration")
    def kubelet_configuration(self) -> 'outputs.GetKubernetesNodePoolsNodepoolKubeletConfigurationResult':
        """
        Kubelet configuration parameters for worker nodes. See `kubelet_configuration` below. More information in [Kubelet Configuration](https://kubernetes.io/docs/reference/config-api/kubelet-config.v1beta1/).
        """
        return pulumi.get(self, "kubelet_configuration")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Sequence['outputs.GetKubernetesNodePoolsNodepoolLabelResult']:
        """
        A List of Kubernetes labels to assign to the nodes . Only labels that are applied with the ACK API are managed by this argument. Detailed below. More information in [Labels](https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/).
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter(name="loginAsNonRoot")
    def login_as_non_root(self) -> _builtins.bool:
        """
        Whether the ECS instance is logged on as a ecs-user user. Valid value: `true` and `false`.
        """
        return pulumi.get(self, "login_as_non_root")

    @_builtins.property
    @pulumi.getter
    def management(self) -> 'outputs.GetKubernetesNodePoolsNodepoolManagementResult':
        """
        Managed node pool configuration.
        """
        return pulumi.get(self, "management")

    @_builtins.property
    @pulumi.getter(name="multiAzPolicy")
    def multi_az_policy(self) -> _builtins.str:
        """
        The scaling policy for ECS instances in a multi-zone scaling group. Valid value: `PRIORITY`, `COST_OPTIMIZED` and `BALANCE`. `PRIORITY`: scales the capacity according to the virtual switches you define (VSwitchIds.N). When an ECS instance cannot be created in the zone where the higher-priority vSwitch is located, the next-priority vSwitch is automatically used to create an ECS instance. `COST_OPTIMIZED`: try to create by vCPU unit price from low to high. When the scaling configuration is configured with multiple instances of preemptible billing, preemptible instances are created first. You can continue to use the `CompensateWithOnDemand` parameter to specify whether to automatically try to create a preemptible instance by paying for it. It takes effect only when the scaling configuration has multi-instance specifications or preemptible instances. `BALANCE`: distributes ECS instances evenly among the multi-zone specified by the scaling group. If the zones become unbalanced due to insufficient inventory, you can use the API RebalanceInstances to balance resources.
        """
        return pulumi.get(self, "multi_az_policy")

    @_builtins.property
    @pulumi.getter(name="nodeNameMode")
    def node_name_mode(self) -> _builtins.str:
        """
        Each node name consists of a prefix, its private network IP, and a suffix, separated by commas. The input format is `customized,,ip,`.- The prefix and suffix can be composed of one or more parts separated by '.', each part can use lowercase letters, numbers and '-', and the beginning and end of the node name must be lowercase letters and numbers.- The node IP address is the complete private IP address of the node.- For example, if the string `customized,aliyun,ip,com` is passed in (where 'customized' and 'ip' are fixed strings, 'aliyun' is the prefix, and 'com' is the suffix), the name of the node is `aliyun192.168.xxx.xxxcom`.
        """
        return pulumi.get(self, "node_name_mode")

    @_builtins.property
    @pulumi.getter(name="nodePoolId")
    def node_pool_id(self) -> _builtins.str:
        """
        The first ID of the resource.
        """
        return pulumi.get(self, "node_pool_id")

    @_builtins.property
    @pulumi.getter(name="nodePoolName")
    def node_pool_name(self) -> _builtins.str:
        """
        The name of node pool.
        """
        return pulumi.get(self, "node_pool_name")

    @_builtins.property
    @pulumi.getter(name="onDemandBaseCapacity")
    def on_demand_base_capacity(self) -> _builtins.str:
        """
        The minimum number of pay-as-you-go instances that must be kept in the scaling group. Valid values: 0 to 1000. If the number of pay-as-you-go instances is less than the value of this parameter, Auto Scaling preferably creates pay-as-you-go instances.
        """
        return pulumi.get(self, "on_demand_base_capacity")

    @_builtins.property
    @pulumi.getter(name="onDemandPercentageAboveBaseCapacity")
    def on_demand_percentage_above_base_capacity(self) -> _builtins.str:
        """
        The percentage of pay-as-you-go instances among the extra instances that exceed the number specified by `on_demand_base_capacity`. Valid values: 0 to 100.
        """
        return pulumi.get(self, "on_demand_percentage_above_base_capacity")

    @_builtins.property
    @pulumi.getter
    def password(self) -> _builtins.str:
        """
        The password of ssh login. You have to specify one of `password` and `key_name` fields. The password rule is 8 to 30 characters and contains at least three items (upper and lower case letters, numbers, and special symbols).
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def period(self) -> _builtins.int:
        """
        Node payment period. Its valid value is one of {1, 2, 3, 6, 12}.
        """
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> _builtins.str:
        """
        Node payment period unit, valid value: `Month`. Default is `Month`.
        """
        return pulumi.get(self, "period_unit")

    @_builtins.property
    @pulumi.getter
    def platform(self) -> _builtins.str:
        """
        Operating system release, using `image_type` instead.
        """
        return pulumi.get(self, "platform")

    @_builtins.property
    @pulumi.getter(name="preUserData")
    def pre_user_data(self) -> _builtins.str:
        """
        Node pre custom data, base64-encoded, the script executed before the node is initialized.
        """
        return pulumi.get(self, "pre_user_data")

    @_builtins.property
    @pulumi.getter(name="privatePoolOptions")
    def private_pool_options(self) -> 'outputs.GetKubernetesNodePoolsNodepoolPrivatePoolOptionsResult':
        """
        Private node pool configuration.
        """
        return pulumi.get(self, "private_pool_options")

    @_builtins.property
    @pulumi.getter(name="ramRoleName")
    def ram_role_name(self) -> _builtins.str:
        """
        The name of the Worker RAM role.* If it is empty, the default Worker RAM role created in the cluster will be used.* If the specified RAM role is not empty, the specified RAM role must be a **Common Service role**, and its **trusted service** configuration must be **cloud server**. For more information, see [Create a common service role](https://help.aliyun.com/document_detail/116800.html). If the specified RAM role is not the default Worker RAM role created in the cluster, the role name cannot start with 'KubernetesMasterRole-'or 'KubernetesWorkerRole.> **NOTE:**  This parameter is only supported for ACK-managed clusters of 1.22 or later versions.
        """
        return pulumi.get(self, "ram_role_name")

    @_builtins.property
    @pulumi.getter(name="rdsInstances")
    def rds_instances(self) -> Sequence[_builtins.str]:
        """
        The list of RDS instances.
        """
        return pulumi.get(self, "rds_instances")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> _builtins.str:
        """
        The ID of the resource group
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="runtimeName")
    def runtime_name(self) -> _builtins.str:
        """
        The runtime name of containers. If not set, the cluster runtime will be used as the node pool runtime. If you select another container runtime, see [Comparison of Docker, containerd, and Sandboxed-Container](https://www.alibabacloud.com/help/doc-detail/160313.htm).
        """
        return pulumi.get(self, "runtime_name")

    @_builtins.property
    @pulumi.getter(name="runtimeVersion")
    def runtime_version(self) -> _builtins.str:
        """
        The runtime version of containers. If not set, the cluster runtime will be used as the node pool runtime.
        """
        return pulumi.get(self, "runtime_version")

    @_builtins.property
    @pulumi.getter(name="scalingConfig")
    def scaling_config(self) -> 'outputs.GetKubernetesNodePoolsNodepoolScalingConfigResult':
        """
        Automatic scaling configuration.
        """
        return pulumi.get(self, "scaling_config")

    @_builtins.property
    @pulumi.getter(name="scalingGroupId")
    def scaling_group_id(self) -> _builtins.str:
        """
        The ID of the scaling group.
        """
        return pulumi.get(self, "scaling_group_id")

    @_builtins.property
    @pulumi.getter(name="scalingPolicy")
    def scaling_policy(self) -> _builtins.str:
        """
        Scaling group mode, default value: `release`. Valid values:- `release`: in the standard mode, scaling is performed by creating and releasing ECS instances based on the usage of the application resource value.- `recycle`: in the speed mode, scaling is performed through creation, shutdown, and startup to increase the speed of scaling again (computing resources are not charged during shutdown, only storage fees are charged, except for local disk models).
        """
        return pulumi.get(self, "scaling_policy")

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> _builtins.str:
        """
        The security group ID of the node pool. This field has been replaced by `security_group_ids`, please use the `security_group_ids` field instead.
        """
        return pulumi.get(self, "security_group_id")

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Sequence[_builtins.str]:
        """
        Multiple security groups can be configured for a node pool. If both `security_group_ids` and `security_group_id` are configured, `security_group_ids` takes effect. This field cannot be modified.
        """
        return pulumi.get(self, "security_group_ids")

    @_builtins.property
    @pulumi.getter(name="securityHardeningOs")
    def security_hardening_os(self) -> _builtins.bool:
        """
        Alibaba Cloud OS security reinforcement. Default value: `false`. Value:-`true`: enable Alibaba Cloud OS security reinforcement.-`false`: does not enable Alibaba Cloud OS security reinforcement.
        """
        return pulumi.get(self, "security_hardening_os")

    @_builtins.property
    @pulumi.getter(name="socEnabled")
    def soc_enabled(self) -> _builtins.bool:
        """
        Whether enable worker node to support soc security reinforcement, its valid value `true` or `false`. Default to `false` and apply to AliyunLinux series. See [SOC Reinforcement](https://help.aliyun.com/document_detail/196148.html).> It is forbidden to set both `security_hardening_os` and `soc_enabled` to `true` at the same time.
        """
        return pulumi.get(self, "soc_enabled")

    @_builtins.property
    @pulumi.getter(name="spotInstancePools")
    def spot_instance_pools(self) -> _builtins.int:
        """
        The number of instance types that are available. Auto Scaling creates preemptible instances of multiple instance types that are available at the lowest cost. Valid values: 1 to 10.
        """
        return pulumi.get(self, "spot_instance_pools")

    @_builtins.property
    @pulumi.getter(name="spotInstanceRemedy")
    def spot_instance_remedy(self) -> _builtins.bool:
        """
        Specifies whether to supplement preemptible instances when the number of preemptible instances drops below the specified minimum number. If you set the value to true, Auto Scaling attempts to create a new preemptible instance when the system notifies that an existing preemptible instance is about to be reclaimed. Valid values: `true`: enables the supplementation of preemptible instances. `false`: disables the supplementation of preemptible instances.
        """
        return pulumi.get(self, "spot_instance_remedy")

    @_builtins.property
    @pulumi.getter(name="spotPriceLimits")
    def spot_price_limits(self) -> Sequence['outputs.GetKubernetesNodePoolsNodepoolSpotPriceLimitResult']:
        """
        The current single preemptible instance type market price range configuration.
        """
        return pulumi.get(self, "spot_price_limits")

    @_builtins.property
    @pulumi.getter(name="spotStrategy")
    def spot_strategy(self) -> _builtins.str:
        """
        The preemptible instance type. Value:- `NoSpot` : Non-preemptible instance.- `SpotWithPriceLimit` : Set the upper limit of the preemptible instance price.- `SpotAsPriceGo` : The system automatically bids, following the actual price of the current market.
        """
        return pulumi.get(self, "spot_strategy")

    @_builtins.property
    @pulumi.getter(name="systemDiskBurstingEnabled")
    def system_disk_bursting_enabled(self) -> _builtins.bool:
        """
        Specifies whether to enable the burst feature for system disks. Valid values:`true`: enables the burst feature. `false`: disables the burst feature. This parameter is supported only when `system_disk_category` is set to `cloud_auto`.
        """
        return pulumi.get(self, "system_disk_bursting_enabled")

    @_builtins.property
    @pulumi.getter(name="systemDiskCategories")
    def system_disk_categories(self) -> Sequence[_builtins.str]:
        """
        The multi-disk categories of the system disk. When a high-priority disk type cannot be used, Auto Scaling automatically tries to create a system disk with the next priority disk category. Valid values see `system_disk_category`.
        """
        return pulumi.get(self, "system_disk_categories")

    @_builtins.property
    @pulumi.getter(name="systemDiskCategory")
    def system_disk_category(self) -> _builtins.str:
        """
        The category of the system disk for nodes. Default value: `cloud_efficiency`. Valid values:- `cloud`: basic disk.- `cloud_efficiency`: ultra disk.- `cloud_ssd`: standard SSD.- `cloud_essd`: ESSD.- `cloud_auto`: ESSD AutoPL disk.- `cloud_essd_entry`: ESSD Entry disk.
        """
        return pulumi.get(self, "system_disk_category")

    @_builtins.property
    @pulumi.getter(name="systemDiskEncryptAlgorithm")
    def system_disk_encrypt_algorithm(self) -> _builtins.str:
        """
        The encryption algorithm used by the system disk. Value range: aes-256.
        """
        return pulumi.get(self, "system_disk_encrypt_algorithm")

    @_builtins.property
    @pulumi.getter(name="systemDiskEncrypted")
    def system_disk_encrypted(self) -> _builtins.bool:
        """
        Whether to encrypt the system disk. Value range: `true`: encryption. `false`: Do not encrypt.
        """
        return pulumi.get(self, "system_disk_encrypted")

    @_builtins.property
    @pulumi.getter(name="systemDiskKmsKey")
    def system_disk_kms_key(self) -> _builtins.str:
        """
        The ID of the KMS key used by the system disk.
        """
        return pulumi.get(self, "system_disk_kms_key")

    @_builtins.property
    @pulumi.getter(name="systemDiskPerformanceLevel")
    def system_disk_performance_level(self) -> _builtins.str:
        """
        The system disk performance of the node takes effect only for the ESSD disk.- `PL0`: maximum random read/write IOPS 10000 for a single disk.- `PL1`: maximum random read/write IOPS 50000 for a single disk.- `PL2`: highest random read/write IOPS 100000 for a single disk.- `PL3`: maximum random read/write IOPS 1 million for a single disk.
        """
        return pulumi.get(self, "system_disk_performance_level")

    @_builtins.property
    @pulumi.getter(name="systemDiskProvisionedIops")
    def system_disk_provisioned_iops(self) -> _builtins.int:
        """
        The predefined IOPS of a system disk. Valid values: 0 to min{50,000, 1,000 × Capacity - Baseline IOPS}. Baseline IOPS = min{1,800 + 50 × Capacity, 50,000}. This parameter is supported only when `system_disk_category` is set to `cloud_auto`.
        """
        return pulumi.get(self, "system_disk_provisioned_iops")

    @_builtins.property
    @pulumi.getter(name="systemDiskSize")
    def system_disk_size(self) -> _builtins.int:
        """
        The size of the system disk. Unit: GiB. The value of this parameter must be at least 1 and greater than or equal to the image size. Default value: 40 or the size of the image, whichever is larger.- Basic disk: 20 to 500.- ESSD (cloud_essd): The valid values vary based on the performance level of the ESSD. PL0 ESSD: 1 to 2048. PL1 ESSD: 20 to 2048. PL2 ESSD: 461 to 2048. PL3 ESSD: 1261 to 2048.- ESSD AutoPL disk (cloud_auto): 1 to 2048.- Other disk categories: 20 to 2048.
        """
        return pulumi.get(self, "system_disk_size")

    @_builtins.property
    @pulumi.getter(name="systemDiskSnapshotPolicyId")
    def system_disk_snapshot_policy_id(self) -> _builtins.str:
        """
        The ID of the automatic snapshot policy used by the system disk.
        """
        return pulumi.get(self, "system_disk_snapshot_policy_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        Add tags only for ECS instances. The maximum length of the tag key is 128 characters. The tag key and value cannot start with aliyun or acs:, or contain https:// or http://.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def taints(self) -> Sequence['outputs.GetKubernetesNodePoolsNodepoolTaintResult']:
        """
        A List of Kubernetes taints to assign to the nodes. Detailed below. More information in [Taints and Toleration](https://kubernetes.io/docs/concepts/scheduling-eviction/taint-and-toleration/).
        """
        return pulumi.get(self, "taints")

    @_builtins.property
    @pulumi.getter(name="teeConfig")
    def tee_config(self) -> 'outputs.GetKubernetesNodePoolsNodepoolTeeConfigResult':
        """
        The configuration about confidential computing for the cluster.
        """
        return pulumi.get(self, "tee_config")

    @_builtins.property
    @pulumi.getter
    def unschedulable(self) -> _builtins.bool:
        """
        Whether the node after expansion can be scheduled.
        """
        return pulumi.get(self, "unschedulable")

    @_builtins.property
    @pulumi.getter(name="userData")
    def user_data(self) -> _builtins.str:
        """
        Node custom data, base64-encoded.
        """
        return pulumi.get(self, "user_data")

    @_builtins.property
    @pulumi.getter(name="vswitchIds")
    def vswitch_ids(self) -> Sequence[_builtins.str]:
        """
        The vswitches used by node pool workers.
        """
        return pulumi.get(self, "vswitch_ids")


@pulumi.output_type
class GetKubernetesNodePoolsNodepoolDataDiskResult(dict):
    def __init__(__self__, *,
                 auto_format: _builtins.str,
                 auto_snapshot_policy_id: _builtins.str,
                 bursting_enabled: _builtins.bool,
                 category: _builtins.str,
                 device: _builtins.str,
                 encrypted: _builtins.str,
                 file_system: _builtins.str,
                 kms_key_id: _builtins.str,
                 mount_target: _builtins.str,
                 name: _builtins.str,
                 performance_level: _builtins.str,
                 provisioned_iops: _builtins.int,
                 size: _builtins.int,
                 snapshot_id: _builtins.str):
        """
        :param _builtins.str auto_format: Whether to automatically mount the data disk. Valid values: true and false.
        :param _builtins.str auto_snapshot_policy_id: The ID of the automatic snapshot policy that you want to apply to the system disk.
        :param _builtins.bool bursting_enabled: Whether the data disk is enabled with Burst (performance Burst). This is configured when the disk type is cloud_auto.
        :param _builtins.str category: The type of data disk. Default value: `cloud_efficiency`. Valid values:- `cloud`: basic disk.- `cloud_efficiency`: ultra disk.- `cloud_ssd`: standard SSD.- `cloud_essd`: Enterprise SSD (ESSD).- `cloud_auto`: ESSD AutoPL disk.- `cloud_essd_entry`: ESSD Entry disk.- `elastic_ephemeral_disk_premium`: premium elastic ephemeral disk.- `elastic_ephemeral_disk_standard`: standard elastic ephemeral disk.
        :param _builtins.str device: The mount target of data disk N. Valid values of N: 1 to 16. If you do not specify this parameter, the system automatically assigns a mount target when Auto Scaling creates ECS instances. The name of the mount target ranges from /dev/xvdb to /dev/xvdz.
        :param _builtins.str encrypted: Specifies whether to encrypt data disks. Valid values: true and false. Default to `false`.
        :param _builtins.str file_system: The type of the mounted file system. Works when auto_format is true. Optional value: `ext4`, `xfs`.
        :param _builtins.str kms_key_id: The kms key id used to encrypt the data disk. It takes effect when `encrypted` is true.
        :param _builtins.str mount_target: The Mount path. Works when auto_format is true.
        :param _builtins.str name: The length is 2~128 English or Chinese characters. It must start with an uppercase or lowr letter or a Chinese character and cannot start with http:// or https. Can contain numbers, colons (:), underscores (_), or dashes (-). It will be overwritten if auto_format is set.
        :param _builtins.str performance_level: Worker node data disk performance level, when `category` values `cloud_essd`, the optional values are `PL0`, `PL1`, `PL2` or `PL3`, but the specific performance level is related to the disk capacity. For more information, see [Enhanced SSDs](https://www.alibabacloud.com/help/doc-detail/122389.htm). Default is `PL1`.
        :param _builtins.int provisioned_iops: The read/write IOPS preconfigured for the data disk, which is configured when the disk type is cloud_auto.
        :param _builtins.int size: The size of a data disk, Its valid value range [40~32768] in GB. Default to `40`.
        :param _builtins.str snapshot_id: The ID of the snapshot that you want to use to create data disk N. Valid values of N: 1 to 16. If you specify this parameter, DataDisk.N.Size is ignored. The size of the disk is the same as the size of the specified snapshot. If you specify a snapshot that is created on or before July 15, 2013, the operation fails and InvalidSnapshot.TooOld is returned.
        """
        pulumi.set(__self__, "auto_format", auto_format)
        pulumi.set(__self__, "auto_snapshot_policy_id", auto_snapshot_policy_id)
        pulumi.set(__self__, "bursting_enabled", bursting_enabled)
        pulumi.set(__self__, "category", category)
        pulumi.set(__self__, "device", device)
        pulumi.set(__self__, "encrypted", encrypted)
        pulumi.set(__self__, "file_system", file_system)
        pulumi.set(__self__, "kms_key_id", kms_key_id)
        pulumi.set(__self__, "mount_target", mount_target)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "performance_level", performance_level)
        pulumi.set(__self__, "provisioned_iops", provisioned_iops)
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "snapshot_id", snapshot_id)

    @_builtins.property
    @pulumi.getter(name="autoFormat")
    def auto_format(self) -> _builtins.str:
        """
        Whether to automatically mount the data disk. Valid values: true and false.
        """
        return pulumi.get(self, "auto_format")

    @_builtins.property
    @pulumi.getter(name="autoSnapshotPolicyId")
    def auto_snapshot_policy_id(self) -> _builtins.str:
        """
        The ID of the automatic snapshot policy that you want to apply to the system disk.
        """
        return pulumi.get(self, "auto_snapshot_policy_id")

    @_builtins.property
    @pulumi.getter(name="burstingEnabled")
    def bursting_enabled(self) -> _builtins.bool:
        """
        Whether the data disk is enabled with Burst (performance Burst). This is configured when the disk type is cloud_auto.
        """
        return pulumi.get(self, "bursting_enabled")

    @_builtins.property
    @pulumi.getter
    def category(self) -> _builtins.str:
        """
        The type of data disk. Default value: `cloud_efficiency`. Valid values:- `cloud`: basic disk.- `cloud_efficiency`: ultra disk.- `cloud_ssd`: standard SSD.- `cloud_essd`: Enterprise SSD (ESSD).- `cloud_auto`: ESSD AutoPL disk.- `cloud_essd_entry`: ESSD Entry disk.- `elastic_ephemeral_disk_premium`: premium elastic ephemeral disk.- `elastic_ephemeral_disk_standard`: standard elastic ephemeral disk.
        """
        return pulumi.get(self, "category")

    @_builtins.property
    @pulumi.getter
    def device(self) -> _builtins.str:
        """
        The mount target of data disk N. Valid values of N: 1 to 16. If you do not specify this parameter, the system automatically assigns a mount target when Auto Scaling creates ECS instances. The name of the mount target ranges from /dev/xvdb to /dev/xvdz.
        """
        return pulumi.get(self, "device")

    @_builtins.property
    @pulumi.getter
    def encrypted(self) -> _builtins.str:
        """
        Specifies whether to encrypt data disks. Valid values: true and false. Default to `false`.
        """
        return pulumi.get(self, "encrypted")

    @_builtins.property
    @pulumi.getter(name="fileSystem")
    def file_system(self) -> _builtins.str:
        """
        The type of the mounted file system. Works when auto_format is true. Optional value: `ext4`, `xfs`.
        """
        return pulumi.get(self, "file_system")

    @_builtins.property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> _builtins.str:
        """
        The kms key id used to encrypt the data disk. It takes effect when `encrypted` is true.
        """
        return pulumi.get(self, "kms_key_id")

    @_builtins.property
    @pulumi.getter(name="mountTarget")
    def mount_target(self) -> _builtins.str:
        """
        The Mount path. Works when auto_format is true.
        """
        return pulumi.get(self, "mount_target")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The length is 2~128 English or Chinese characters. It must start with an uppercase or lowr letter or a Chinese character and cannot start with http:// or https. Can contain numbers, colons (:), underscores (_), or dashes (-). It will be overwritten if auto_format is set.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="performanceLevel")
    def performance_level(self) -> _builtins.str:
        """
        Worker node data disk performance level, when `category` values `cloud_essd`, the optional values are `PL0`, `PL1`, `PL2` or `PL3`, but the specific performance level is related to the disk capacity. For more information, see [Enhanced SSDs](https://www.alibabacloud.com/help/doc-detail/122389.htm). Default is `PL1`.
        """
        return pulumi.get(self, "performance_level")

    @_builtins.property
    @pulumi.getter(name="provisionedIops")
    def provisioned_iops(self) -> _builtins.int:
        """
        The read/write IOPS preconfigured for the data disk, which is configured when the disk type is cloud_auto.
        """
        return pulumi.get(self, "provisioned_iops")

    @_builtins.property
    @pulumi.getter
    def size(self) -> _builtins.int:
        """
        The size of a data disk, Its valid value range [40~32768] in GB. Default to `40`.
        """
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> _builtins.str:
        """
        The ID of the snapshot that you want to use to create data disk N. Valid values of N: 1 to 16. If you specify this parameter, DataDisk.N.Size is ignored. The size of the disk is the same as the size of the specified snapshot. If you specify a snapshot that is created on or before July 15, 2013, the operation fails and InvalidSnapshot.TooOld is returned.
        """
        return pulumi.get(self, "snapshot_id")


@pulumi.output_type
class GetKubernetesNodePoolsNodepoolKubeletConfigurationResult(dict):
    def __init__(__self__, *,
                 allowed_unsafe_sysctls: Sequence[_builtins.str],
                 cluster_dns: Sequence[_builtins.str],
                 container_log_max_files: _builtins.str,
                 container_log_max_size: _builtins.str,
                 container_log_max_workers: _builtins.str,
                 container_log_monitor_interval: _builtins.str,
                 cpu_cfs_quota: _builtins.str,
                 cpu_cfs_quota_period: _builtins.str,
                 cpu_manager_policy: _builtins.str,
                 event_burst: _builtins.str,
                 event_record_qps: _builtins.str,
                 eviction_hard: Mapping[str, _builtins.str],
                 eviction_soft: Mapping[str, _builtins.str],
                 eviction_soft_grace_period: Mapping[str, _builtins.str],
                 feature_gates: Mapping[str, _builtins.str],
                 image_gc_high_threshold_percent: _builtins.str,
                 image_gc_low_threshold_percent: _builtins.str,
                 kube_api_burst: _builtins.str,
                 kube_api_qps: _builtins.str,
                 kube_reserved: Mapping[str, _builtins.str],
                 max_pods: _builtins.str,
                 memory_manager_policy: _builtins.str,
                 pod_pids_limit: _builtins.str,
                 read_only_port: _builtins.str,
                 registry_burst: _builtins.str,
                 registry_pull_qps: _builtins.str,
                 reserved_memories: Sequence['outputs.GetKubernetesNodePoolsNodepoolKubeletConfigurationReservedMemoryResult'],
                 serialize_image_pulls: _builtins.str,
                 system_reserved: Mapping[str, _builtins.str],
                 topology_manager_policy: _builtins.str,
                 tracing: 'outputs.GetKubernetesNodePoolsNodepoolKubeletConfigurationTracingResult'):
        """
        :param Sequence[_builtins.str] allowed_unsafe_sysctls: Allowed sysctl mode whitelist.
        :param Sequence[_builtins.str] cluster_dns: The list of IP addresses of the cluster DNS servers.
        :param _builtins.str container_log_max_files: The maximum number of log files that can exist in each container.
        :param _builtins.str container_log_max_size: The maximum size that can be reached before a log file is rotated.
        :param _builtins.str container_log_max_workers: Specifies the maximum number of concurrent workers required to perform log rotation operations.
        :param _builtins.str container_log_monitor_interval: Specifies the duration for which container logs are monitored for log rotation.
        :param _builtins.str cpu_cfs_quota: CPU CFS quota constraint switch.
        :param _builtins.str cpu_cfs_quota_period: CPU CFS quota period value.
        :param _builtins.str cpu_manager_policy: Same as cpuManagerPolicy. The name of the policy to use. Requires the CPUManager feature gate to be enabled. Valid value is `none` or `static`.
        :param _builtins.str event_burst: Same as eventBurst. The maximum size of a burst of event creations, temporarily allows event creations to burst to this number, while still not exceeding `event_record_qps`. It is only used when `event_record_qps` is greater than 0. Valid value is `[0-100]`.
        :param _builtins.str event_record_qps: Same as eventRecordQPS. The maximum event creations per second. If 0, there is no limit enforced. Valid value is `[0-50]`.
        :param Mapping[str, _builtins.str] eviction_hard: Same as evictionHard. The map of signal names to quantities that defines hard eviction thresholds. For example: `{"memory.available" = "300Mi"}`.
        :param Mapping[str, _builtins.str] eviction_soft: Same as evictionSoft. The map of signal names to quantities that defines soft eviction thresholds. For example: `{"memory.available" = "300Mi"}`.
        :param Mapping[str, _builtins.str] eviction_soft_grace_period: Same as evictionSoftGracePeriod. The map of signal names to quantities that defines grace periods for each soft eviction signal. For example: `{"memory.available" = "30s"}`.
        :param Mapping[str, _builtins.str] feature_gates: Feature switch to enable configuration of experimental features.
        :param _builtins.str image_gc_high_threshold_percent: If the image usage exceeds this threshold, image garbage collection will continue.
        :param _builtins.str image_gc_low_threshold_percent: Image garbage collection is not performed when the image usage is below this threshold.
        :param _builtins.str kube_api_burst: Same as kubeAPIBurst. The burst to allow while talking with kubernetes api-server. Valid value is `[0-100]`.
        :param _builtins.str kube_api_qps: Same as kubeAPIQPS. The QPS to use while talking with kubernetes api-server. Valid value is `[0-50]`.
        :param Mapping[str, _builtins.str] kube_reserved: Same as kubeReserved. The set of ResourceName=ResourceQuantity (e.g. cpu=200m,memory=150G) pairs that describe resources reserved for kubernetes system components. Currently, cpu, memory and local storage for root file system are supported. See [compute resources](https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/) for more details.
        :param _builtins.str max_pods: The maximum number of running pods.
        :param _builtins.str memory_manager_policy: The policy to be used by the memory manager.
        :param _builtins.str pod_pids_limit: The maximum number of PIDs that can be used in a Pod.
        :param _builtins.str read_only_port: Read-only port number.
        :param _builtins.str registry_burst: Same as registryBurst. The maximum size of burst pulls, temporarily allows pulls to burst to this number, while still not exceeding `registry_pull_qps`. Only used if `registry_pull_qps` is greater than 0. Valid value is `[0-100]`.
        :param _builtins.str registry_pull_qps: Same as registryPullQPS. The limit of registry pulls per second. Setting it to `0` means no limit. Valid value is `[0-50]`.
        :param Sequence['GetKubernetesNodePoolsNodepoolKubeletConfigurationReservedMemoryArgs'] reserved_memories: Reserve memory for NUMA nodes.
        :param _builtins.str serialize_image_pulls: Same as serializeImagePulls. When enabled, it tells the Kubelet to pull images one at a time. We recommend not changing the default value on nodes that run docker daemon with version < 1.9 or an Aufs storage backend. Valid value is `true` or `false`.
        :param Mapping[str, _builtins.str] system_reserved: Same as systemReserved. The set of ResourceName=ResourceQuantity (e.g. cpu=200m,memory=150G) pairs that describe resources reserved for non-kubernetes components. Currently, only cpu and memory are supported. See [compute resources](https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/) for more details.
        :param _builtins.str topology_manager_policy: Name of the Topology Manager policy used.
        :param 'GetKubernetesNodePoolsNodepoolKubeletConfigurationTracingArgs' tracing: OpenTelemetry tracks the configuration information for client settings versioning.
        """
        pulumi.set(__self__, "allowed_unsafe_sysctls", allowed_unsafe_sysctls)
        pulumi.set(__self__, "cluster_dns", cluster_dns)
        pulumi.set(__self__, "container_log_max_files", container_log_max_files)
        pulumi.set(__self__, "container_log_max_size", container_log_max_size)
        pulumi.set(__self__, "container_log_max_workers", container_log_max_workers)
        pulumi.set(__self__, "container_log_monitor_interval", container_log_monitor_interval)
        pulumi.set(__self__, "cpu_cfs_quota", cpu_cfs_quota)
        pulumi.set(__self__, "cpu_cfs_quota_period", cpu_cfs_quota_period)
        pulumi.set(__self__, "cpu_manager_policy", cpu_manager_policy)
        pulumi.set(__self__, "event_burst", event_burst)
        pulumi.set(__self__, "event_record_qps", event_record_qps)
        pulumi.set(__self__, "eviction_hard", eviction_hard)
        pulumi.set(__self__, "eviction_soft", eviction_soft)
        pulumi.set(__self__, "eviction_soft_grace_period", eviction_soft_grace_period)
        pulumi.set(__self__, "feature_gates", feature_gates)
        pulumi.set(__self__, "image_gc_high_threshold_percent", image_gc_high_threshold_percent)
        pulumi.set(__self__, "image_gc_low_threshold_percent", image_gc_low_threshold_percent)
        pulumi.set(__self__, "kube_api_burst", kube_api_burst)
        pulumi.set(__self__, "kube_api_qps", kube_api_qps)
        pulumi.set(__self__, "kube_reserved", kube_reserved)
        pulumi.set(__self__, "max_pods", max_pods)
        pulumi.set(__self__, "memory_manager_policy", memory_manager_policy)
        pulumi.set(__self__, "pod_pids_limit", pod_pids_limit)
        pulumi.set(__self__, "read_only_port", read_only_port)
        pulumi.set(__self__, "registry_burst", registry_burst)
        pulumi.set(__self__, "registry_pull_qps", registry_pull_qps)
        pulumi.set(__self__, "reserved_memories", reserved_memories)
        pulumi.set(__self__, "serialize_image_pulls", serialize_image_pulls)
        pulumi.set(__self__, "system_reserved", system_reserved)
        pulumi.set(__self__, "topology_manager_policy", topology_manager_policy)
        pulumi.set(__self__, "tracing", tracing)

    @_builtins.property
    @pulumi.getter(name="allowedUnsafeSysctls")
    def allowed_unsafe_sysctls(self) -> Sequence[_builtins.str]:
        """
        Allowed sysctl mode whitelist.
        """
        return pulumi.get(self, "allowed_unsafe_sysctls")

    @_builtins.property
    @pulumi.getter(name="clusterDns")
    def cluster_dns(self) -> Sequence[_builtins.str]:
        """
        The list of IP addresses of the cluster DNS servers.
        """
        return pulumi.get(self, "cluster_dns")

    @_builtins.property
    @pulumi.getter(name="containerLogMaxFiles")
    def container_log_max_files(self) -> _builtins.str:
        """
        The maximum number of log files that can exist in each container.
        """
        return pulumi.get(self, "container_log_max_files")

    @_builtins.property
    @pulumi.getter(name="containerLogMaxSize")
    def container_log_max_size(self) -> _builtins.str:
        """
        The maximum size that can be reached before a log file is rotated.
        """
        return pulumi.get(self, "container_log_max_size")

    @_builtins.property
    @pulumi.getter(name="containerLogMaxWorkers")
    def container_log_max_workers(self) -> _builtins.str:
        """
        Specifies the maximum number of concurrent workers required to perform log rotation operations.
        """
        return pulumi.get(self, "container_log_max_workers")

    @_builtins.property
    @pulumi.getter(name="containerLogMonitorInterval")
    def container_log_monitor_interval(self) -> _builtins.str:
        """
        Specifies the duration for which container logs are monitored for log rotation.
        """
        return pulumi.get(self, "container_log_monitor_interval")

    @_builtins.property
    @pulumi.getter(name="cpuCfsQuota")
    def cpu_cfs_quota(self) -> _builtins.str:
        """
        CPU CFS quota constraint switch.
        """
        return pulumi.get(self, "cpu_cfs_quota")

    @_builtins.property
    @pulumi.getter(name="cpuCfsQuotaPeriod")
    def cpu_cfs_quota_period(self) -> _builtins.str:
        """
        CPU CFS quota period value.
        """
        return pulumi.get(self, "cpu_cfs_quota_period")

    @_builtins.property
    @pulumi.getter(name="cpuManagerPolicy")
    def cpu_manager_policy(self) -> _builtins.str:
        """
        Same as cpuManagerPolicy. The name of the policy to use. Requires the CPUManager feature gate to be enabled. Valid value is `none` or `static`.
        """
        return pulumi.get(self, "cpu_manager_policy")

    @_builtins.property
    @pulumi.getter(name="eventBurst")
    def event_burst(self) -> _builtins.str:
        """
        Same as eventBurst. The maximum size of a burst of event creations, temporarily allows event creations to burst to this number, while still not exceeding `event_record_qps`. It is only used when `event_record_qps` is greater than 0. Valid value is `[0-100]`.
        """
        return pulumi.get(self, "event_burst")

    @_builtins.property
    @pulumi.getter(name="eventRecordQps")
    def event_record_qps(self) -> _builtins.str:
        """
        Same as eventRecordQPS. The maximum event creations per second. If 0, there is no limit enforced. Valid value is `[0-50]`.
        """
        return pulumi.get(self, "event_record_qps")

    @_builtins.property
    @pulumi.getter(name="evictionHard")
    def eviction_hard(self) -> Mapping[str, _builtins.str]:
        """
        Same as evictionHard. The map of signal names to quantities that defines hard eviction thresholds. For example: `{"memory.available" = "300Mi"}`.
        """
        return pulumi.get(self, "eviction_hard")

    @_builtins.property
    @pulumi.getter(name="evictionSoft")
    def eviction_soft(self) -> Mapping[str, _builtins.str]:
        """
        Same as evictionSoft. The map of signal names to quantities that defines soft eviction thresholds. For example: `{"memory.available" = "300Mi"}`.
        """
        return pulumi.get(self, "eviction_soft")

    @_builtins.property
    @pulumi.getter(name="evictionSoftGracePeriod")
    def eviction_soft_grace_period(self) -> Mapping[str, _builtins.str]:
        """
        Same as evictionSoftGracePeriod. The map of signal names to quantities that defines grace periods for each soft eviction signal. For example: `{"memory.available" = "30s"}`.
        """
        return pulumi.get(self, "eviction_soft_grace_period")

    @_builtins.property
    @pulumi.getter(name="featureGates")
    def feature_gates(self) -> Mapping[str, _builtins.str]:
        """
        Feature switch to enable configuration of experimental features.
        """
        return pulumi.get(self, "feature_gates")

    @_builtins.property
    @pulumi.getter(name="imageGcHighThresholdPercent")
    def image_gc_high_threshold_percent(self) -> _builtins.str:
        """
        If the image usage exceeds this threshold, image garbage collection will continue.
        """
        return pulumi.get(self, "image_gc_high_threshold_percent")

    @_builtins.property
    @pulumi.getter(name="imageGcLowThresholdPercent")
    def image_gc_low_threshold_percent(self) -> _builtins.str:
        """
        Image garbage collection is not performed when the image usage is below this threshold.
        """
        return pulumi.get(self, "image_gc_low_threshold_percent")

    @_builtins.property
    @pulumi.getter(name="kubeApiBurst")
    def kube_api_burst(self) -> _builtins.str:
        """
        Same as kubeAPIBurst. The burst to allow while talking with kubernetes api-server. Valid value is `[0-100]`.
        """
        return pulumi.get(self, "kube_api_burst")

    @_builtins.property
    @pulumi.getter(name="kubeApiQps")
    def kube_api_qps(self) -> _builtins.str:
        """
        Same as kubeAPIQPS. The QPS to use while talking with kubernetes api-server. Valid value is `[0-50]`.
        """
        return pulumi.get(self, "kube_api_qps")

    @_builtins.property
    @pulumi.getter(name="kubeReserved")
    def kube_reserved(self) -> Mapping[str, _builtins.str]:
        """
        Same as kubeReserved. The set of ResourceName=ResourceQuantity (e.g. cpu=200m,memory=150G) pairs that describe resources reserved for kubernetes system components. Currently, cpu, memory and local storage for root file system are supported. See [compute resources](https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/) for more details.
        """
        return pulumi.get(self, "kube_reserved")

    @_builtins.property
    @pulumi.getter(name="maxPods")
    def max_pods(self) -> _builtins.str:
        """
        The maximum number of running pods.
        """
        return pulumi.get(self, "max_pods")

    @_builtins.property
    @pulumi.getter(name="memoryManagerPolicy")
    def memory_manager_policy(self) -> _builtins.str:
        """
        The policy to be used by the memory manager.
        """
        return pulumi.get(self, "memory_manager_policy")

    @_builtins.property
    @pulumi.getter(name="podPidsLimit")
    def pod_pids_limit(self) -> _builtins.str:
        """
        The maximum number of PIDs that can be used in a Pod.
        """
        return pulumi.get(self, "pod_pids_limit")

    @_builtins.property
    @pulumi.getter(name="readOnlyPort")
    def read_only_port(self) -> _builtins.str:
        """
        Read-only port number.
        """
        return pulumi.get(self, "read_only_port")

    @_builtins.property
    @pulumi.getter(name="registryBurst")
    def registry_burst(self) -> _builtins.str:
        """
        Same as registryBurst. The maximum size of burst pulls, temporarily allows pulls to burst to this number, while still not exceeding `registry_pull_qps`. Only used if `registry_pull_qps` is greater than 0. Valid value is `[0-100]`.
        """
        return pulumi.get(self, "registry_burst")

    @_builtins.property
    @pulumi.getter(name="registryPullQps")
    def registry_pull_qps(self) -> _builtins.str:
        """
        Same as registryPullQPS. The limit of registry pulls per second. Setting it to `0` means no limit. Valid value is `[0-50]`.
        """
        return pulumi.get(self, "registry_pull_qps")

    @_builtins.property
    @pulumi.getter(name="reservedMemories")
    def reserved_memories(self) -> Sequence['outputs.GetKubernetesNodePoolsNodepoolKubeletConfigurationReservedMemoryResult']:
        """
        Reserve memory for NUMA nodes.
        """
        return pulumi.get(self, "reserved_memories")

    @_builtins.property
    @pulumi.getter(name="serializeImagePulls")
    def serialize_image_pulls(self) -> _builtins.str:
        """
        Same as serializeImagePulls. When enabled, it tells the Kubelet to pull images one at a time. We recommend not changing the default value on nodes that run docker daemon with version < 1.9 or an Aufs storage backend. Valid value is `true` or `false`.
        """
        return pulumi.get(self, "serialize_image_pulls")

    @_builtins.property
    @pulumi.getter(name="systemReserved")
    def system_reserved(self) -> Mapping[str, _builtins.str]:
        """
        Same as systemReserved. The set of ResourceName=ResourceQuantity (e.g. cpu=200m,memory=150G) pairs that describe resources reserved for non-kubernetes components. Currently, only cpu and memory are supported. See [compute resources](https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/) for more details.
        """
        return pulumi.get(self, "system_reserved")

    @_builtins.property
    @pulumi.getter(name="topologyManagerPolicy")
    def topology_manager_policy(self) -> _builtins.str:
        """
        Name of the Topology Manager policy used.
        """
        return pulumi.get(self, "topology_manager_policy")

    @_builtins.property
    @pulumi.getter
    def tracing(self) -> 'outputs.GetKubernetesNodePoolsNodepoolKubeletConfigurationTracingResult':
        """
        OpenTelemetry tracks the configuration information for client settings versioning.
        """
        return pulumi.get(self, "tracing")


@pulumi.output_type
class GetKubernetesNodePoolsNodepoolKubeletConfigurationReservedMemoryResult(dict):
    def __init__(__self__, *,
                 limits: Mapping[str, _builtins.str],
                 numa_node: _builtins.int):
        """
        :param Mapping[str, _builtins.str] limits: Memory resource limit.
        :param _builtins.int numa_node: The NUMA node.
        """
        pulumi.set(__self__, "limits", limits)
        pulumi.set(__self__, "numa_node", numa_node)

    @_builtins.property
    @pulumi.getter
    def limits(self) -> Mapping[str, _builtins.str]:
        """
        Memory resource limit.
        """
        return pulumi.get(self, "limits")

    @_builtins.property
    @pulumi.getter(name="numaNode")
    def numa_node(self) -> _builtins.int:
        """
        The NUMA node.
        """
        return pulumi.get(self, "numa_node")


@pulumi.output_type
class GetKubernetesNodePoolsNodepoolKubeletConfigurationTracingResult(dict):
    def __init__(__self__, *,
                 endpoint: _builtins.str,
                 sampling_rate_per_million: _builtins.str):
        """
        :param _builtins.str endpoint: The endpoint of the collector.
        :param _builtins.str sampling_rate_per_million: Number of samples to be collected per million span.
        """
        pulumi.set(__self__, "endpoint", endpoint)
        pulumi.set(__self__, "sampling_rate_per_million", sampling_rate_per_million)

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> _builtins.str:
        """
        The endpoint of the collector.
        """
        return pulumi.get(self, "endpoint")

    @_builtins.property
    @pulumi.getter(name="samplingRatePerMillion")
    def sampling_rate_per_million(self) -> _builtins.str:
        """
        Number of samples to be collected per million span.
        """
        return pulumi.get(self, "sampling_rate_per_million")


@pulumi.output_type
class GetKubernetesNodePoolsNodepoolLabelResult(dict):
    def __init__(__self__, *,
                 key: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str key: The key of a taint.
        :param _builtins.str value: The value of a taint.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        The key of a taint.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The value of a taint.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetKubernetesNodePoolsNodepoolManagementResult(dict):
    def __init__(__self__, *,
                 auto_repair: _builtins.bool,
                 auto_repair_policy: 'outputs.GetKubernetesNodePoolsNodepoolManagementAutoRepairPolicyResult',
                 auto_upgrade: _builtins.bool,
                 auto_upgrade_policy: 'outputs.GetKubernetesNodePoolsNodepoolManagementAutoUpgradePolicyResult',
                 auto_vul_fix: _builtins.bool,
                 auto_vul_fix_policy: 'outputs.GetKubernetesNodePoolsNodepoolManagementAutoVulFixPolicyResult',
                 enable: _builtins.bool,
                 max_unavailable: _builtins.int,
                 surge: _builtins.int,
                 surge_percentage: _builtins.int):
        """
        :param _builtins.bool auto_repair: Whether to enable automatic repair. Valid values: `true`: Automatic repair. `false`: not automatically repaired.
        :param 'GetKubernetesNodePoolsNodepoolManagementAutoRepairPolicyArgs' auto_repair_policy: Automatic repair node policy.
        :param _builtins.bool auto_upgrade: Specifies whether to enable auto update. Valid values: `true`: enables auto update. `false`: disables auto update.
        :param 'GetKubernetesNodePoolsNodepoolManagementAutoUpgradePolicyArgs' auto_upgrade_policy: The auto update policy.
        :param _builtins.bool auto_vul_fix: Specifies whether to automatically patch CVE vulnerabilities. Valid values: `true`, `false`.
        :param 'GetKubernetesNodePoolsNodepoolManagementAutoVulFixPolicyArgs' auto_vul_fix_policy: The auto CVE patching policy.
        :param _builtins.bool enable: Whether to enable automatic scaling. Value:- `true`: enables the node pool auto-scaling function.- `false`: Auto scaling is not enabled. When the value is false, other `auto_scaling` configuration parameters do not take effect.
        :param _builtins.int max_unavailable: Maximum number of unavailable nodes. Default value: 1. Value range:\\[1,1000\\].
        :param _builtins.int surge: Number of additional nodes. You have to specify one of surge, surge_percentage.
        :param _builtins.int surge_percentage: Proportion of additional nodes. You have to specify one of surge, surge_percentage.
        """
        pulumi.set(__self__, "auto_repair", auto_repair)
        pulumi.set(__self__, "auto_repair_policy", auto_repair_policy)
        pulumi.set(__self__, "auto_upgrade", auto_upgrade)
        pulumi.set(__self__, "auto_upgrade_policy", auto_upgrade_policy)
        pulumi.set(__self__, "auto_vul_fix", auto_vul_fix)
        pulumi.set(__self__, "auto_vul_fix_policy", auto_vul_fix_policy)
        pulumi.set(__self__, "enable", enable)
        pulumi.set(__self__, "max_unavailable", max_unavailable)
        pulumi.set(__self__, "surge", surge)
        pulumi.set(__self__, "surge_percentage", surge_percentage)

    @_builtins.property
    @pulumi.getter(name="autoRepair")
    def auto_repair(self) -> _builtins.bool:
        """
        Whether to enable automatic repair. Valid values: `true`: Automatic repair. `false`: not automatically repaired.
        """
        return pulumi.get(self, "auto_repair")

    @_builtins.property
    @pulumi.getter(name="autoRepairPolicy")
    def auto_repair_policy(self) -> 'outputs.GetKubernetesNodePoolsNodepoolManagementAutoRepairPolicyResult':
        """
        Automatic repair node policy.
        """
        return pulumi.get(self, "auto_repair_policy")

    @_builtins.property
    @pulumi.getter(name="autoUpgrade")
    def auto_upgrade(self) -> _builtins.bool:
        """
        Specifies whether to enable auto update. Valid values: `true`: enables auto update. `false`: disables auto update.
        """
        return pulumi.get(self, "auto_upgrade")

    @_builtins.property
    @pulumi.getter(name="autoUpgradePolicy")
    def auto_upgrade_policy(self) -> 'outputs.GetKubernetesNodePoolsNodepoolManagementAutoUpgradePolicyResult':
        """
        The auto update policy.
        """
        return pulumi.get(self, "auto_upgrade_policy")

    @_builtins.property
    @pulumi.getter(name="autoVulFix")
    def auto_vul_fix(self) -> _builtins.bool:
        """
        Specifies whether to automatically patch CVE vulnerabilities. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "auto_vul_fix")

    @_builtins.property
    @pulumi.getter(name="autoVulFixPolicy")
    def auto_vul_fix_policy(self) -> 'outputs.GetKubernetesNodePoolsNodepoolManagementAutoVulFixPolicyResult':
        """
        The auto CVE patching policy.
        """
        return pulumi.get(self, "auto_vul_fix_policy")

    @_builtins.property
    @pulumi.getter
    def enable(self) -> _builtins.bool:
        """
        Whether to enable automatic scaling. Value:- `true`: enables the node pool auto-scaling function.- `false`: Auto scaling is not enabled. When the value is false, other `auto_scaling` configuration parameters do not take effect.
        """
        return pulumi.get(self, "enable")

    @_builtins.property
    @pulumi.getter(name="maxUnavailable")
    def max_unavailable(self) -> _builtins.int:
        """
        Maximum number of unavailable nodes. Default value: 1. Value range:\\[1,1000\\].
        """
        return pulumi.get(self, "max_unavailable")

    @_builtins.property
    @pulumi.getter
    def surge(self) -> _builtins.int:
        """
        Number of additional nodes. You have to specify one of surge, surge_percentage.
        """
        return pulumi.get(self, "surge")

    @_builtins.property
    @pulumi.getter(name="surgePercentage")
    def surge_percentage(self) -> _builtins.int:
        """
        Proportion of additional nodes. You have to specify one of surge, surge_percentage.
        """
        return pulumi.get(self, "surge_percentage")


@pulumi.output_type
class GetKubernetesNodePoolsNodepoolManagementAutoRepairPolicyResult(dict):
    def __init__(__self__, *,
                 restart_node: _builtins.bool):
        """
        :param _builtins.bool restart_node: Specifies whether to automatically restart nodes after patching CVE vulnerabilities. Valid values: `true`, `false`.
        """
        pulumi.set(__self__, "restart_node", restart_node)

    @_builtins.property
    @pulumi.getter(name="restartNode")
    def restart_node(self) -> _builtins.bool:
        """
        Specifies whether to automatically restart nodes after patching CVE vulnerabilities. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "restart_node")


@pulumi.output_type
class GetKubernetesNodePoolsNodepoolManagementAutoUpgradePolicyResult(dict):
    def __init__(__self__, *,
                 auto_upgrade_kubelet: _builtins.bool):
        """
        :param _builtins.bool auto_upgrade_kubelet: Specifies whether  to automatically update the kubelet. Valid values: `true`: yes; `false`: no.
        """
        pulumi.set(__self__, "auto_upgrade_kubelet", auto_upgrade_kubelet)

    @_builtins.property
    @pulumi.getter(name="autoUpgradeKubelet")
    def auto_upgrade_kubelet(self) -> _builtins.bool:
        """
        Specifies whether  to automatically update the kubelet. Valid values: `true`: yes; `false`: no.
        """
        return pulumi.get(self, "auto_upgrade_kubelet")


@pulumi.output_type
class GetKubernetesNodePoolsNodepoolManagementAutoVulFixPolicyResult(dict):
    def __init__(__self__, *,
                 restart_node: _builtins.bool,
                 vul_level: _builtins.str):
        """
        :param _builtins.bool restart_node: Specifies whether to automatically restart nodes after patching CVE vulnerabilities. Valid values: `true`, `false`.
        :param _builtins.str vul_level: The severity levels of vulnerabilities that is allowed to automatically patch. Multiple severity levels are separated by commas (,).
        """
        pulumi.set(__self__, "restart_node", restart_node)
        pulumi.set(__self__, "vul_level", vul_level)

    @_builtins.property
    @pulumi.getter(name="restartNode")
    def restart_node(self) -> _builtins.bool:
        """
        Specifies whether to automatically restart nodes after patching CVE vulnerabilities. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "restart_node")

    @_builtins.property
    @pulumi.getter(name="vulLevel")
    def vul_level(self) -> _builtins.str:
        """
        The severity levels of vulnerabilities that is allowed to automatically patch. Multiple severity levels are separated by commas (,).
        """
        return pulumi.get(self, "vul_level")


@pulumi.output_type
class GetKubernetesNodePoolsNodepoolPrivatePoolOptionsResult(dict):
    def __init__(__self__, *,
                 private_pool_options_id: _builtins.str,
                 private_pool_options_match_criteria: _builtins.str):
        """
        :param _builtins.str private_pool_options_id: The ID of the private node pool.
        :param _builtins.str private_pool_options_match_criteria: The type of private node pool. This parameter specifies the type of the private pool that you want to use to create instances. A private node pool is generated when an elasticity assurance or a capacity reservation service takes effect. The system selects a private node pool to launch instances. Valid values: `Open`: specifies an open private node pool. The system selects an open private node pool to launch instances. If no matching open private node pool is available, the resources in the public node pool are used. `Target`: specifies a private node pool. The system uses the resources of the specified private node pool to launch instances. If the specified private node pool is unavailable, instances cannot be started. `None`: no private node pool is used. The resources of private node pools are not used to launch the instances.
        """
        pulumi.set(__self__, "private_pool_options_id", private_pool_options_id)
        pulumi.set(__self__, "private_pool_options_match_criteria", private_pool_options_match_criteria)

    @_builtins.property
    @pulumi.getter(name="privatePoolOptionsId")
    def private_pool_options_id(self) -> _builtins.str:
        """
        The ID of the private node pool.
        """
        return pulumi.get(self, "private_pool_options_id")

    @_builtins.property
    @pulumi.getter(name="privatePoolOptionsMatchCriteria")
    def private_pool_options_match_criteria(self) -> _builtins.str:
        """
        The type of private node pool. This parameter specifies the type of the private pool that you want to use to create instances. A private node pool is generated when an elasticity assurance or a capacity reservation service takes effect. The system selects a private node pool to launch instances. Valid values: `Open`: specifies an open private node pool. The system selects an open private node pool to launch instances. If no matching open private node pool is available, the resources in the public node pool are used. `Target`: specifies a private node pool. The system uses the resources of the specified private node pool to launch instances. If the specified private node pool is unavailable, instances cannot be started. `None`: no private node pool is used. The resources of private node pools are not used to launch the instances.
        """
        return pulumi.get(self, "private_pool_options_match_criteria")


@pulumi.output_type
class GetKubernetesNodePoolsNodepoolScalingConfigResult(dict):
    def __init__(__self__, *,
                 eip_bandwidth: _builtins.int,
                 eip_internet_charge_type: _builtins.str,
                 enable: _builtins.bool,
                 is_bond_eip: _builtins.bool,
                 max_size: _builtins.int,
                 min_size: _builtins.int,
                 type: _builtins.str):
        """
        :param _builtins.int eip_bandwidth: Peak EIP bandwidth. Its valid value range [1~500] in Mbps. It works if `is_bond_eip=true`. Default to `5`.
        :param _builtins.str eip_internet_charge_type: EIP billing type. `PayByBandwidth`: Charged at fixed bandwidth. `PayByTraffic`: Billed as used traffic. Default: `PayByBandwidth`. It works if `is_bond_eip=true`, conflict with `internet_charge_type`. EIP and public network IP can only choose one.
        :param _builtins.bool enable: Whether to enable automatic scaling. Value:- `true`: enables the node pool auto-scaling function.- `false`: Auto scaling is not enabled. When the value is false, other `auto_scaling` configuration parameters do not take effect.
        :param _builtins.bool is_bond_eip: Whether to bind EIP for an instance. Default: `false`.
        :param _builtins.int max_size: Max number of instances in a auto scaling group, its valid value range [0~1000]. `max_size` has to be greater than `min_size`.
        :param _builtins.int min_size: Min number of instances in a auto scaling group, its valid value range [0~1000].
        :param _builtins.str type: Instance classification, not required. Vaild value: `cpu`, `gpu`, `gpushare` and `spot`. Default: `cpu`. The actual instance type is determined by `instance_types`.
        """
        pulumi.set(__self__, "eip_bandwidth", eip_bandwidth)
        pulumi.set(__self__, "eip_internet_charge_type", eip_internet_charge_type)
        pulumi.set(__self__, "enable", enable)
        pulumi.set(__self__, "is_bond_eip", is_bond_eip)
        pulumi.set(__self__, "max_size", max_size)
        pulumi.set(__self__, "min_size", min_size)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="eipBandwidth")
    def eip_bandwidth(self) -> _builtins.int:
        """
        Peak EIP bandwidth. Its valid value range [1~500] in Mbps. It works if `is_bond_eip=true`. Default to `5`.
        """
        return pulumi.get(self, "eip_bandwidth")

    @_builtins.property
    @pulumi.getter(name="eipInternetChargeType")
    def eip_internet_charge_type(self) -> _builtins.str:
        """
        EIP billing type. `PayByBandwidth`: Charged at fixed bandwidth. `PayByTraffic`: Billed as used traffic. Default: `PayByBandwidth`. It works if `is_bond_eip=true`, conflict with `internet_charge_type`. EIP and public network IP can only choose one.
        """
        return pulumi.get(self, "eip_internet_charge_type")

    @_builtins.property
    @pulumi.getter
    def enable(self) -> _builtins.bool:
        """
        Whether to enable automatic scaling. Value:- `true`: enables the node pool auto-scaling function.- `false`: Auto scaling is not enabled. When the value is false, other `auto_scaling` configuration parameters do not take effect.
        """
        return pulumi.get(self, "enable")

    @_builtins.property
    @pulumi.getter(name="isBondEip")
    def is_bond_eip(self) -> _builtins.bool:
        """
        Whether to bind EIP for an instance. Default: `false`.
        """
        return pulumi.get(self, "is_bond_eip")

    @_builtins.property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> _builtins.int:
        """
        Max number of instances in a auto scaling group, its valid value range [0~1000]. `max_size` has to be greater than `min_size`.
        """
        return pulumi.get(self, "max_size")

    @_builtins.property
    @pulumi.getter(name="minSize")
    def min_size(self) -> _builtins.int:
        """
        Min number of instances in a auto scaling group, its valid value range [0~1000].
        """
        return pulumi.get(self, "min_size")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Instance classification, not required. Vaild value: `cpu`, `gpu`, `gpushare` and `spot`. Default: `cpu`. The actual instance type is determined by `instance_types`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetKubernetesNodePoolsNodepoolSpotPriceLimitResult(dict):
    def __init__(__self__, *,
                 instance_type: _builtins.str,
                 price_limit: _builtins.str):
        """
        :param _builtins.str instance_type: The type of the preemptible instance.
        :param _builtins.str price_limit: The maximum price of a single instance.
        """
        pulumi.set(__self__, "instance_type", instance_type)
        pulumi.set(__self__, "price_limit", price_limit)

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> _builtins.str:
        """
        The type of the preemptible instance.
        """
        return pulumi.get(self, "instance_type")

    @_builtins.property
    @pulumi.getter(name="priceLimit")
    def price_limit(self) -> _builtins.str:
        """
        The maximum price of a single instance.
        """
        return pulumi.get(self, "price_limit")


@pulumi.output_type
class GetKubernetesNodePoolsNodepoolTaintResult(dict):
    def __init__(__self__, *,
                 effect: _builtins.str,
                 key: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str effect: The scheduling policy.
        :param _builtins.str key: The key of a taint.
        :param _builtins.str value: The value of a taint.
        """
        pulumi.set(__self__, "effect", effect)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def effect(self) -> _builtins.str:
        """
        The scheduling policy.
        """
        return pulumi.get(self, "effect")

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        The key of a taint.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The value of a taint.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetKubernetesNodePoolsNodepoolTeeConfigResult(dict):
    def __init__(__self__, *,
                 tee_enable: _builtins.bool):
        """
        :param _builtins.bool tee_enable: Specifies whether to enable confidential computing for the cluster.
        """
        pulumi.set(__self__, "tee_enable", tee_enable)

    @_builtins.property
    @pulumi.getter(name="teeEnable")
    def tee_enable(self) -> _builtins.bool:
        """
        Specifies whether to enable confidential computing for the cluster.
        """
        return pulumi.get(self, "tee_enable")


@pulumi.output_type
class GetKubernetesPermissionPermissionResult(dict):
    def __init__(__self__, *,
                 is_owner: _builtins.bool,
                 is_ram_role: _builtins.bool,
                 resource_id: _builtins.str,
                 resource_type: _builtins.str,
                 role_name: _builtins.str,
                 role_type: _builtins.str):
        """
        :param _builtins.bool is_owner: Indicates whether the permissions are granted to the cluster owner. Valid values `false`, `true`.
        :param _builtins.bool is_ram_role: Indicates whether the permissions are granted to the RAM role. Valid values `false`, `true`.
        :param _builtins.str resource_id: The permission settings to manage ACK clusters.
        :param _builtins.str resource_type: The authorization type. Valid values `cluster`, `namespace` and `console`.
        :param _builtins.str role_name: The name of the predefined role. If a custom role is assigned, the value is the name of the assigined custom role.
        :param _builtins.str role_type: The predefined role. Valid values `admin`,`ops`,`dev`,`restricted` and `custom`.
        """
        pulumi.set(__self__, "is_owner", is_owner)
        pulumi.set(__self__, "is_ram_role", is_ram_role)
        pulumi.set(__self__, "resource_id", resource_id)
        pulumi.set(__self__, "resource_type", resource_type)
        pulumi.set(__self__, "role_name", role_name)
        pulumi.set(__self__, "role_type", role_type)

    @_builtins.property
    @pulumi.getter(name="isOwner")
    def is_owner(self) -> _builtins.bool:
        """
        Indicates whether the permissions are granted to the cluster owner. Valid values `false`, `true`.
        """
        return pulumi.get(self, "is_owner")

    @_builtins.property
    @pulumi.getter(name="isRamRole")
    def is_ram_role(self) -> _builtins.bool:
        """
        Indicates whether the permissions are granted to the RAM role. Valid values `false`, `true`.
        """
        return pulumi.get(self, "is_ram_role")

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> _builtins.str:
        """
        The permission settings to manage ACK clusters.
        """
        return pulumi.get(self, "resource_id")

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> _builtins.str:
        """
        The authorization type. Valid values `cluster`, `namespace` and `console`.
        """
        return pulumi.get(self, "resource_type")

    @_builtins.property
    @pulumi.getter(name="roleName")
    def role_name(self) -> _builtins.str:
        """
        The name of the predefined role. If a custom role is assigned, the value is the name of the assigined custom role.
        """
        return pulumi.get(self, "role_name")

    @_builtins.property
    @pulumi.getter(name="roleType")
    def role_type(self) -> _builtins.str:
        """
        The predefined role. Valid values `admin`,`ops`,`dev`,`restricted` and `custom`.
        """
        return pulumi.get(self, "role_type")


@pulumi.output_type
class GetKubernetesVersionMetadataResult(dict):
    def __init__(__self__, *,
                 runtimes: Sequence['outputs.GetKubernetesVersionMetadataRuntimeResult'],
                 version: _builtins.str):
        """
        :param Sequence['GetKubernetesVersionMetadataRuntimeArgs'] runtimes: The list of supported runtime.
        :param _builtins.str version: The runtime version.
        """
        pulumi.set(__self__, "runtimes", runtimes)
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def runtimes(self) -> Sequence['outputs.GetKubernetesVersionMetadataRuntimeResult']:
        """
        The list of supported runtime.
        """
        return pulumi.get(self, "runtimes")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        The runtime version.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetKubernetesVersionMetadataRuntimeResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 version: _builtins.str):
        """
        :param _builtins.str name: The runtime name.
        :param _builtins.str version: The runtime version.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The runtime name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        The runtime version.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetManagedKubernetesClustersClusterResult(dict):
    def __init__(__self__, *,
                 availability_zone: _builtins.str,
                 cluster_network_type: _builtins.str,
                 connections: 'outputs.GetManagedKubernetesClustersClusterConnectionsResult',
                 id: _builtins.str,
                 image_id: _builtins.str,
                 key_name: _builtins.str,
                 log_configs: Sequence['outputs.GetManagedKubernetesClustersClusterLogConfigResult'],
                 name: _builtins.str,
                 nat_gateway_id: _builtins.str,
                 pod_cidr: _builtins.str,
                 rrsa_config: 'outputs.GetManagedKubernetesClustersClusterRrsaConfigResult',
                 security_group_id: _builtins.str,
                 service_cidr: _builtins.str,
                 slb_internet_enabled: _builtins.bool,
                 state: _builtins.str,
                 vpc_id: _builtins.str,
                 vswitch_ids: Sequence[_builtins.str],
                 worker_auto_renew: _builtins.bool,
                 worker_auto_renew_period: _builtins.int,
                 worker_data_disk_category: _builtins.str,
                 worker_data_disk_size: _builtins.int,
                 worker_disk_category: _builtins.str,
                 worker_disk_size: _builtins.int,
                 worker_instance_charge_type: _builtins.str,
                 worker_instance_types: Sequence[_builtins.str],
                 worker_nodes: Sequence['outputs.GetManagedKubernetesClustersClusterWorkerNodeResult'],
                 worker_numbers: Sequence[_builtins.int],
                 worker_period: _builtins.int,
                 worker_period_unit: _builtins.str):
        """
        :param _builtins.str availability_zone: The ID of availability zone.
        :param 'GetManagedKubernetesClustersClusterConnectionsArgs' connections: Map of kubernetes cluster connection information.
        :param _builtins.str id: ID of the node.
        :param _builtins.str key_name: The keypair of ssh login cluster node, you have to create it first.
        :param Sequence['GetManagedKubernetesClustersClusterLogConfigArgs'] log_configs: A list of one element containing information about the associated log store. It contains the following attributes:
        :param _builtins.str name: Node name.
        :param _builtins.str nat_gateway_id: The ID of nat gateway used to launch kubernetes cluster.
        :param 'GetManagedKubernetesClustersClusterRrsaConfigArgs' rrsa_config: (Available since v1.245.0) Nested attribute containing RRSA related data for your cluster.
        :param _builtins.str security_group_id: The ID of security group where the current cluster worker node is located.
        :param _builtins.str state: (Available since v1.245.0) The state of cluster.
        :param _builtins.str vpc_id: The ID of VPC where the current cluster is located.
        :param Sequence[_builtins.str] vswitch_ids: The ID of VSwitches where the current cluster is located.
        :param Sequence['GetManagedKubernetesClustersClusterWorkerNodeArgs'] worker_nodes: List of cluster worker nodes.
        :param Sequence[_builtins.int] worker_numbers: The ECS instance node number in the current container cluster.
        """
        pulumi.set(__self__, "availability_zone", availability_zone)
        pulumi.set(__self__, "cluster_network_type", cluster_network_type)
        pulumi.set(__self__, "connections", connections)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "image_id", image_id)
        pulumi.set(__self__, "key_name", key_name)
        pulumi.set(__self__, "log_configs", log_configs)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "nat_gateway_id", nat_gateway_id)
        pulumi.set(__self__, "pod_cidr", pod_cidr)
        pulumi.set(__self__, "rrsa_config", rrsa_config)
        pulumi.set(__self__, "security_group_id", security_group_id)
        pulumi.set(__self__, "service_cidr", service_cidr)
        pulumi.set(__self__, "slb_internet_enabled", slb_internet_enabled)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vswitch_ids", vswitch_ids)
        pulumi.set(__self__, "worker_auto_renew", worker_auto_renew)
        pulumi.set(__self__, "worker_auto_renew_period", worker_auto_renew_period)
        pulumi.set(__self__, "worker_data_disk_category", worker_data_disk_category)
        pulumi.set(__self__, "worker_data_disk_size", worker_data_disk_size)
        pulumi.set(__self__, "worker_disk_category", worker_disk_category)
        pulumi.set(__self__, "worker_disk_size", worker_disk_size)
        pulumi.set(__self__, "worker_instance_charge_type", worker_instance_charge_type)
        pulumi.set(__self__, "worker_instance_types", worker_instance_types)
        pulumi.set(__self__, "worker_nodes", worker_nodes)
        pulumi.set(__self__, "worker_numbers", worker_numbers)
        pulumi.set(__self__, "worker_period", worker_period)
        pulumi.set(__self__, "worker_period_unit", worker_period_unit)

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> _builtins.str:
        """
        The ID of availability zone.
        """
        return pulumi.get(self, "availability_zone")

    @_builtins.property
    @pulumi.getter(name="clusterNetworkType")
    def cluster_network_type(self) -> _builtins.str:
        return pulumi.get(self, "cluster_network_type")

    @_builtins.property
    @pulumi.getter
    def connections(self) -> 'outputs.GetManagedKubernetesClustersClusterConnectionsResult':
        """
        Map of kubernetes cluster connection information.
        """
        return pulumi.get(self, "connections")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        ID of the node.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> _builtins.str:
        return pulumi.get(self, "image_id")

    @_builtins.property
    @pulumi.getter(name="keyName")
    def key_name(self) -> _builtins.str:
        """
        The keypair of ssh login cluster node, you have to create it first.
        """
        return pulumi.get(self, "key_name")

    @_builtins.property
    @pulumi.getter(name="logConfigs")
    def log_configs(self) -> Sequence['outputs.GetManagedKubernetesClustersClusterLogConfigResult']:
        """
        A list of one element containing information about the associated log store. It contains the following attributes:
        """
        return pulumi.get(self, "log_configs")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Node name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="natGatewayId")
    def nat_gateway_id(self) -> _builtins.str:
        """
        The ID of nat gateway used to launch kubernetes cluster.
        """
        return pulumi.get(self, "nat_gateway_id")

    @_builtins.property
    @pulumi.getter(name="podCidr")
    def pod_cidr(self) -> _builtins.str:
        return pulumi.get(self, "pod_cidr")

    @_builtins.property
    @pulumi.getter(name="rrsaConfig")
    def rrsa_config(self) -> 'outputs.GetManagedKubernetesClustersClusterRrsaConfigResult':
        """
        (Available since v1.245.0) Nested attribute containing RRSA related data for your cluster.
        """
        return pulumi.get(self, "rrsa_config")

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> _builtins.str:
        """
        The ID of security group where the current cluster worker node is located.
        """
        return pulumi.get(self, "security_group_id")

    @_builtins.property
    @pulumi.getter(name="serviceCidr")
    def service_cidr(self) -> _builtins.str:
        return pulumi.get(self, "service_cidr")

    @_builtins.property
    @pulumi.getter(name="slbInternetEnabled")
    def slb_internet_enabled(self) -> _builtins.bool:
        return pulumi.get(self, "slb_internet_enabled")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        (Available since v1.245.0) The state of cluster.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> _builtins.str:
        """
        The ID of VPC where the current cluster is located.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vswitchIds")
    def vswitch_ids(self) -> Sequence[_builtins.str]:
        """
        The ID of VSwitches where the current cluster is located.
        """
        return pulumi.get(self, "vswitch_ids")

    @_builtins.property
    @pulumi.getter(name="workerAutoRenew")
    def worker_auto_renew(self) -> _builtins.bool:
        return pulumi.get(self, "worker_auto_renew")

    @_builtins.property
    @pulumi.getter(name="workerAutoRenewPeriod")
    def worker_auto_renew_period(self) -> _builtins.int:
        return pulumi.get(self, "worker_auto_renew_period")

    @_builtins.property
    @pulumi.getter(name="workerDataDiskCategory")
    def worker_data_disk_category(self) -> _builtins.str:
        return pulumi.get(self, "worker_data_disk_category")

    @_builtins.property
    @pulumi.getter(name="workerDataDiskSize")
    def worker_data_disk_size(self) -> _builtins.int:
        return pulumi.get(self, "worker_data_disk_size")

    @_builtins.property
    @pulumi.getter(name="workerDiskCategory")
    def worker_disk_category(self) -> _builtins.str:
        return pulumi.get(self, "worker_disk_category")

    @_builtins.property
    @pulumi.getter(name="workerDiskSize")
    def worker_disk_size(self) -> _builtins.int:
        return pulumi.get(self, "worker_disk_size")

    @_builtins.property
    @pulumi.getter(name="workerInstanceChargeType")
    def worker_instance_charge_type(self) -> _builtins.str:
        return pulumi.get(self, "worker_instance_charge_type")

    @_builtins.property
    @pulumi.getter(name="workerInstanceTypes")
    def worker_instance_types(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "worker_instance_types")

    @_builtins.property
    @pulumi.getter(name="workerNodes")
    def worker_nodes(self) -> Sequence['outputs.GetManagedKubernetesClustersClusterWorkerNodeResult']:
        """
        List of cluster worker nodes.
        """
        return pulumi.get(self, "worker_nodes")

    @_builtins.property
    @pulumi.getter(name="workerNumbers")
    def worker_numbers(self) -> Sequence[_builtins.int]:
        """
        The ECS instance node number in the current container cluster.
        """
        return pulumi.get(self, "worker_numbers")

    @_builtins.property
    @pulumi.getter(name="workerPeriod")
    def worker_period(self) -> _builtins.int:
        return pulumi.get(self, "worker_period")

    @_builtins.property
    @pulumi.getter(name="workerPeriodUnit")
    def worker_period_unit(self) -> _builtins.str:
        return pulumi.get(self, "worker_period_unit")


@pulumi.output_type
class GetManagedKubernetesClustersClusterConnectionsResult(dict):
    def __init__(__self__, *,
                 api_server_internet: _builtins.str,
                 api_server_intranet: _builtins.str,
                 master_public_ip: _builtins.str,
                 service_domain: _builtins.str):
        """
        :param _builtins.str api_server_internet: API Server Internet endpoint.
        :param _builtins.str api_server_intranet: API Server Intranet endpoint.
        :param _builtins.str master_public_ip: Master node SSH IP address.
        :param _builtins.str service_domain: Service Access Domain.
        """
        pulumi.set(__self__, "api_server_internet", api_server_internet)
        pulumi.set(__self__, "api_server_intranet", api_server_intranet)
        pulumi.set(__self__, "master_public_ip", master_public_ip)
        pulumi.set(__self__, "service_domain", service_domain)

    @_builtins.property
    @pulumi.getter(name="apiServerInternet")
    def api_server_internet(self) -> _builtins.str:
        """
        API Server Internet endpoint.
        """
        return pulumi.get(self, "api_server_internet")

    @_builtins.property
    @pulumi.getter(name="apiServerIntranet")
    def api_server_intranet(self) -> _builtins.str:
        """
        API Server Intranet endpoint.
        """
        return pulumi.get(self, "api_server_intranet")

    @_builtins.property
    @pulumi.getter(name="masterPublicIp")
    def master_public_ip(self) -> _builtins.str:
        """
        Master node SSH IP address.
        """
        return pulumi.get(self, "master_public_ip")

    @_builtins.property
    @pulumi.getter(name="serviceDomain")
    def service_domain(self) -> _builtins.str:
        """
        Service Access Domain.
        """
        return pulumi.get(self, "service_domain")


@pulumi.output_type
class GetManagedKubernetesClustersClusterLogConfigResult(dict):
    def __init__(__self__, *,
                 project: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str project: Log Service project name.
        :param _builtins.str type: Type of collecting logs.
        """
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def project(self) -> _builtins.str:
        """
        Log Service project name.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of collecting logs.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetManagedKubernetesClustersClusterRrsaConfigResult(dict):
    def __init__(__self__, *,
                 enabled: _builtins.bool,
                 ram_oidc_provider_arn: _builtins.str,
                 ram_oidc_provider_name: _builtins.str,
                 rrsa_oidc_issuer_url: _builtins.str):
        """
        :param _builtins.bool enabled: Whether the RRSA feature has been enabled.
        :param _builtins.str ram_oidc_provider_arn: The arn of OIDC provider that was registered in RAM.
        :param _builtins.str ram_oidc_provider_name: The name of OIDC Provider that was registered in RAM.
        :param _builtins.str rrsa_oidc_issuer_url: The issuer URL of RRSA OIDC Token.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "ram_oidc_provider_arn", ram_oidc_provider_arn)
        pulumi.set(__self__, "ram_oidc_provider_name", ram_oidc_provider_name)
        pulumi.set(__self__, "rrsa_oidc_issuer_url", rrsa_oidc_issuer_url)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Whether the RRSA feature has been enabled.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="ramOidcProviderArn")
    def ram_oidc_provider_arn(self) -> _builtins.str:
        """
        The arn of OIDC provider that was registered in RAM.
        """
        return pulumi.get(self, "ram_oidc_provider_arn")

    @_builtins.property
    @pulumi.getter(name="ramOidcProviderName")
    def ram_oidc_provider_name(self) -> _builtins.str:
        """
        The name of OIDC Provider that was registered in RAM.
        """
        return pulumi.get(self, "ram_oidc_provider_name")

    @_builtins.property
    @pulumi.getter(name="rrsaOidcIssuerUrl")
    def rrsa_oidc_issuer_url(self) -> _builtins.str:
        """
        The issuer URL of RRSA OIDC Token.
        """
        return pulumi.get(self, "rrsa_oidc_issuer_url")


@pulumi.output_type
class GetManagedKubernetesClustersClusterWorkerNodeResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 name: _builtins.str,
                 private_ip: _builtins.str):
        """
        :param _builtins.str id: ID of the node.
        :param _builtins.str name: Node name.
        :param _builtins.str private_ip: The private IP address of node.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "private_ip", private_ip)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        ID of the node.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Node name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> _builtins.str:
        """
        The private IP address of node.
        """
        return pulumi.get(self, "private_ip")


@pulumi.output_type
class GetRegistryEnterpriseInstancesInstanceResult(dict):
    def __init__(__self__, *,
                 authorization_token: _builtins.str,
                 id: _builtins.str,
                 name: _builtins.str,
                 namespace_quota: _builtins.str,
                 namespace_usage: _builtins.str,
                 public_endpoints: Sequence[_builtins.str],
                 region: _builtins.str,
                 repo_quota: _builtins.str,
                 repo_usage: _builtins.str,
                 specification: _builtins.str,
                 temp_username: _builtins.str,
                 vpc_endpoints: Sequence[_builtins.str]):
        """
        :param _builtins.str authorization_token: The password that was used to log on to the registry.
        :param _builtins.str id: ID of Container Registry Enterprise Edition instance.
        :param _builtins.str name: Name of Container Registry Enterprise Edition instance.
        :param _builtins.str namespace_quota: The max number of namespaces that an instance can create.
        :param _builtins.str namespace_usage: The number of namespaces already created.
        :param Sequence[_builtins.str] public_endpoints: A list of domains for access on internet network.
        :param _builtins.str region: Region of Container Registry Enterprise Edition instance.
        :param _builtins.str repo_quota: The max number of repos that an instance can create.
        :param _builtins.str repo_usage: The number of repos already created.
        :param _builtins.str specification: Specification of Container Registry Enterprise Edition instance.
        :param _builtins.str temp_username: The username that was used to log on to the registry.
        :param Sequence[_builtins.str] vpc_endpoints: A list of domains for access on vpc network.
        """
        pulumi.set(__self__, "authorization_token", authorization_token)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "namespace_quota", namespace_quota)
        pulumi.set(__self__, "namespace_usage", namespace_usage)
        pulumi.set(__self__, "public_endpoints", public_endpoints)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "repo_quota", repo_quota)
        pulumi.set(__self__, "repo_usage", repo_usage)
        pulumi.set(__self__, "specification", specification)
        pulumi.set(__self__, "temp_username", temp_username)
        pulumi.set(__self__, "vpc_endpoints", vpc_endpoints)

    @_builtins.property
    @pulumi.getter(name="authorizationToken")
    def authorization_token(self) -> _builtins.str:
        """
        The password that was used to log on to the registry.
        """
        return pulumi.get(self, "authorization_token")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        ID of Container Registry Enterprise Edition instance.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of Container Registry Enterprise Edition instance.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="namespaceQuota")
    def namespace_quota(self) -> _builtins.str:
        """
        The max number of namespaces that an instance can create.
        """
        return pulumi.get(self, "namespace_quota")

    @_builtins.property
    @pulumi.getter(name="namespaceUsage")
    def namespace_usage(self) -> _builtins.str:
        """
        The number of namespaces already created.
        """
        return pulumi.get(self, "namespace_usage")

    @_builtins.property
    @pulumi.getter(name="publicEndpoints")
    def public_endpoints(self) -> Sequence[_builtins.str]:
        """
        A list of domains for access on internet network.
        """
        return pulumi.get(self, "public_endpoints")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        Region of Container Registry Enterprise Edition instance.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="repoQuota")
    def repo_quota(self) -> _builtins.str:
        """
        The max number of repos that an instance can create.
        """
        return pulumi.get(self, "repo_quota")

    @_builtins.property
    @pulumi.getter(name="repoUsage")
    def repo_usage(self) -> _builtins.str:
        """
        The number of repos already created.
        """
        return pulumi.get(self, "repo_usage")

    @_builtins.property
    @pulumi.getter
    def specification(self) -> _builtins.str:
        """
        Specification of Container Registry Enterprise Edition instance.
        """
        return pulumi.get(self, "specification")

    @_builtins.property
    @pulumi.getter(name="tempUsername")
    def temp_username(self) -> _builtins.str:
        """
        The username that was used to log on to the registry.
        """
        return pulumi.get(self, "temp_username")

    @_builtins.property
    @pulumi.getter(name="vpcEndpoints")
    def vpc_endpoints(self) -> Sequence[_builtins.str]:
        """
        A list of domains for access on vpc network.
        """
        return pulumi.get(self, "vpc_endpoints")


@pulumi.output_type
class GetRegistryEnterpriseNamespacesNamespaceResult(dict):
    def __init__(__self__, *,
                 auto_create: _builtins.bool,
                 default_visibility: _builtins.str,
                 id: _builtins.str,
                 instance_id: _builtins.str,
                 name: _builtins.str,
                 namespace_id: _builtins.str,
                 namespace_name: _builtins.str):
        """
        :param _builtins.bool auto_create: Boolean, when it set to true, repositories are automatically created when pushing new images. If it set to false, you create repository for images before pushing.
        :param _builtins.str default_visibility: `PUBLIC` or `PRIVATE`, default repository visibility in this namespace.
        :param _builtins.str id: ID of Container Registry Enterprise Edition namespace. It formats as `<instance_id>:<namespace_name>`. Before 1.161.0, it is a namespace uuid.
        :param _builtins.str instance_id: ID of Container Registry Enterprise Edition instance.
        :param _builtins.str name: Name of Container Registry Enterprise Edition namespace.
        :param _builtins.str namespace_id: Container Registry Enterprise Edition namespace id. It is a uuid.
        :param _builtins.str namespace_name: Name of Container Registry Enterprise Edition namespace.
        """
        pulumi.set(__self__, "auto_create", auto_create)
        pulumi.set(__self__, "default_visibility", default_visibility)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "namespace_id", namespace_id)
        pulumi.set(__self__, "namespace_name", namespace_name)

    @_builtins.property
    @pulumi.getter(name="autoCreate")
    def auto_create(self) -> _builtins.bool:
        """
        Boolean, when it set to true, repositories are automatically created when pushing new images. If it set to false, you create repository for images before pushing.
        """
        return pulumi.get(self, "auto_create")

    @_builtins.property
    @pulumi.getter(name="defaultVisibility")
    def default_visibility(self) -> _builtins.str:
        """
        `PUBLIC` or `PRIVATE`, default repository visibility in this namespace.
        """
        return pulumi.get(self, "default_visibility")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        ID of Container Registry Enterprise Edition namespace. It formats as `<instance_id>:<namespace_name>`. Before 1.161.0, it is a namespace uuid.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        """
        ID of Container Registry Enterprise Edition instance.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of Container Registry Enterprise Edition namespace.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="namespaceId")
    def namespace_id(self) -> _builtins.str:
        """
        Container Registry Enterprise Edition namespace id. It is a uuid.
        """
        return pulumi.get(self, "namespace_id")

    @_builtins.property
    @pulumi.getter(name="namespaceName")
    def namespace_name(self) -> _builtins.str:
        """
        Name of Container Registry Enterprise Edition namespace.
        """
        return pulumi.get(self, "namespace_name")


@pulumi.output_type
class GetRegistryEnterpriseReposRepoResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 instance_id: _builtins.str,
                 name: _builtins.str,
                 namespace: _builtins.str,
                 repo_type: _builtins.str,
                 summary: _builtins.str,
                 tags: Sequence['outputs.GetRegistryEnterpriseReposRepoTagResult']):
        """
        :param _builtins.str id: ID of Container Registry Enterprise Edition repository.
        :param _builtins.str instance_id: ID of Container Registry Enterprise Edition instance.
        :param _builtins.str name: Name of Container Registry Enterprise Edition repository.
        :param _builtins.str namespace: Name of Container Registry Enterprise Edition namespace where the repositories are located in.
        :param _builtins.str repo_type: `PUBLIC` or `PRIVATE`, repository's visibility.
        :param _builtins.str summary: The repository general information.
        :param Sequence['GetRegistryEnterpriseReposRepoTagArgs'] tags: A list of image tags belong to this repository. Each contains several attributes, see `Block Tag`.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "repo_type", repo_type)
        pulumi.set(__self__, "summary", summary)
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        ID of Container Registry Enterprise Edition repository.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        """
        ID of Container Registry Enterprise Edition instance.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of Container Registry Enterprise Edition repository.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> _builtins.str:
        """
        Name of Container Registry Enterprise Edition namespace where the repositories are located in.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter(name="repoType")
    def repo_type(self) -> _builtins.str:
        """
        `PUBLIC` or `PRIVATE`, repository's visibility.
        """
        return pulumi.get(self, "repo_type")

    @_builtins.property
    @pulumi.getter
    def summary(self) -> _builtins.str:
        """
        The repository general information.
        """
        return pulumi.get(self, "summary")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Sequence['outputs.GetRegistryEnterpriseReposRepoTagResult']:
        """
        A list of image tags belong to this repository. Each contains several attributes, see `Block Tag`.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class GetRegistryEnterpriseReposRepoTagResult(dict):
    def __init__(__self__, *,
                 digest: _builtins.str,
                 image_create: _builtins.str,
                 image_id: _builtins.str,
                 image_size: _builtins.int,
                 image_update: _builtins.str,
                 status: _builtins.str,
                 tag: _builtins.str):
        """
        :param _builtins.str digest: Digest of this image.
        :param _builtins.str image_create: Create time of this image, unix time in nanoseconds.
        :param _builtins.str image_id: Id of this image.
        :param _builtins.int image_size: Status of this image, in bytes.
        :param _builtins.str image_update: Last update time of this image, unix time in nanoseconds.
        :param _builtins.str status: Status of this image.
        :param _builtins.str tag: Tag of this image.
        """
        pulumi.set(__self__, "digest", digest)
        pulumi.set(__self__, "image_create", image_create)
        pulumi.set(__self__, "image_id", image_id)
        pulumi.set(__self__, "image_size", image_size)
        pulumi.set(__self__, "image_update", image_update)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "tag", tag)

    @_builtins.property
    @pulumi.getter
    def digest(self) -> _builtins.str:
        """
        Digest of this image.
        """
        return pulumi.get(self, "digest")

    @_builtins.property
    @pulumi.getter(name="imageCreate")
    def image_create(self) -> _builtins.str:
        """
        Create time of this image, unix time in nanoseconds.
        """
        return pulumi.get(self, "image_create")

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> _builtins.str:
        """
        Id of this image.
        """
        return pulumi.get(self, "image_id")

    @_builtins.property
    @pulumi.getter(name="imageSize")
    def image_size(self) -> _builtins.int:
        """
        Status of this image, in bytes.
        """
        return pulumi.get(self, "image_size")

    @_builtins.property
    @pulumi.getter(name="imageUpdate")
    def image_update(self) -> _builtins.str:
        """
        Last update time of this image, unix time in nanoseconds.
        """
        return pulumi.get(self, "image_update")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Status of this image.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tag(self) -> _builtins.str:
        """
        Tag of this image.
        """
        return pulumi.get(self, "tag")


@pulumi.output_type
class GetRegistryEnterpriseSyncRulesRuleResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 instance_id: _builtins.str,
                 name: _builtins.str,
                 namespace_name: _builtins.str,
                 region_id: _builtins.str,
                 repo_name: _builtins.str,
                 sync_direction: _builtins.str,
                 sync_scope: _builtins.str,
                 sync_trigger: _builtins.str,
                 tag_filter: _builtins.str,
                 target_instance_id: _builtins.str,
                 target_namespace_name: _builtins.str,
                 target_region_id: _builtins.str,
                 target_repo_name: _builtins.str):
        """
        :param _builtins.str id: ID of Container Registry Enterprise Edition sync rule.
        :param _builtins.str instance_id: ID of Container Registry Enterprise Edition local instance.
        :param _builtins.str name: Name of Container Registry Enterprise Edition sync rule.
        :param _builtins.str namespace_name: Name of Container Registry Enterprise Edition local namespace.
        :param _builtins.str region_id: Region of Container Registry Enterprise Edition local instance.
        :param _builtins.str repo_name: Name of Container Registry Enterprise Edition local repo.
        :param _builtins.str sync_direction: `FROM` or `TO`, the direction of synchronization. `FROM` indicates that the local instance is the source instance. `TO` indicates that the local instance is the target instance to be synchronized.
        :param _builtins.str sync_scope: `REPO` or `NAMESPACE`,the scope that the synchronization rule applies.
        :param _builtins.str sync_trigger: `PASSIVE` or `INITIATIVE`, the policy configured to trigger the synchronization rule.
        :param _builtins.str tag_filter: The regular expression used to filter image tags for synchronization in the source repository.
        :param _builtins.str target_instance_id: ID of Container Registry Enterprise Edition target instance.
        :param _builtins.str target_namespace_name: Name of Container Registry Enterprise Edition target namespace.
        :param _builtins.str target_region_id: Region of Container Registry Enterprise Edition target instance.
        :param _builtins.str target_repo_name: Name of Container Registry Enterprise Edition target repo.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "namespace_name", namespace_name)
        pulumi.set(__self__, "region_id", region_id)
        pulumi.set(__self__, "repo_name", repo_name)
        pulumi.set(__self__, "sync_direction", sync_direction)
        pulumi.set(__self__, "sync_scope", sync_scope)
        pulumi.set(__self__, "sync_trigger", sync_trigger)
        pulumi.set(__self__, "tag_filter", tag_filter)
        pulumi.set(__self__, "target_instance_id", target_instance_id)
        pulumi.set(__self__, "target_namespace_name", target_namespace_name)
        pulumi.set(__self__, "target_region_id", target_region_id)
        pulumi.set(__self__, "target_repo_name", target_repo_name)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        ID of Container Registry Enterprise Edition sync rule.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        """
        ID of Container Registry Enterprise Edition local instance.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of Container Registry Enterprise Edition sync rule.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="namespaceName")
    def namespace_name(self) -> _builtins.str:
        """
        Name of Container Registry Enterprise Edition local namespace.
        """
        return pulumi.get(self, "namespace_name")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> _builtins.str:
        """
        Region of Container Registry Enterprise Edition local instance.
        """
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter(name="repoName")
    def repo_name(self) -> _builtins.str:
        """
        Name of Container Registry Enterprise Edition local repo.
        """
        return pulumi.get(self, "repo_name")

    @_builtins.property
    @pulumi.getter(name="syncDirection")
    def sync_direction(self) -> _builtins.str:
        """
        `FROM` or `TO`, the direction of synchronization. `FROM` indicates that the local instance is the source instance. `TO` indicates that the local instance is the target instance to be synchronized.
        """
        return pulumi.get(self, "sync_direction")

    @_builtins.property
    @pulumi.getter(name="syncScope")
    def sync_scope(self) -> _builtins.str:
        """
        `REPO` or `NAMESPACE`,the scope that the synchronization rule applies.
        """
        return pulumi.get(self, "sync_scope")

    @_builtins.property
    @pulumi.getter(name="syncTrigger")
    def sync_trigger(self) -> _builtins.str:
        """
        `PASSIVE` or `INITIATIVE`, the policy configured to trigger the synchronization rule.
        """
        return pulumi.get(self, "sync_trigger")

    @_builtins.property
    @pulumi.getter(name="tagFilter")
    def tag_filter(self) -> _builtins.str:
        """
        The regular expression used to filter image tags for synchronization in the source repository.
        """
        return pulumi.get(self, "tag_filter")

    @_builtins.property
    @pulumi.getter(name="targetInstanceId")
    def target_instance_id(self) -> _builtins.str:
        """
        ID of Container Registry Enterprise Edition target instance.
        """
        return pulumi.get(self, "target_instance_id")

    @_builtins.property
    @pulumi.getter(name="targetNamespaceName")
    def target_namespace_name(self) -> _builtins.str:
        """
        Name of Container Registry Enterprise Edition target namespace.
        """
        return pulumi.get(self, "target_namespace_name")

    @_builtins.property
    @pulumi.getter(name="targetRegionId")
    def target_region_id(self) -> _builtins.str:
        """
        Region of Container Registry Enterprise Edition target instance.
        """
        return pulumi.get(self, "target_region_id")

    @_builtins.property
    @pulumi.getter(name="targetRepoName")
    def target_repo_name(self) -> _builtins.str:
        """
        Name of Container Registry Enterprise Edition target repo.
        """
        return pulumi.get(self, "target_repo_name")


@pulumi.output_type
class GetServerlessKubernetesClustersClusterResult(dict):
    def __init__(__self__, *,
                 connections: 'outputs.GetServerlessKubernetesClustersClusterConnectionsResult',
                 deletion_protection: _builtins.bool,
                 endpoint_public_access_enabled: _builtins.bool,
                 id: _builtins.str,
                 name: _builtins.str,
                 nat_gateway_id: _builtins.str,
                 security_group_id: _builtins.str,
                 tags: Mapping[str, _builtins.str],
                 vpc_id: _builtins.str,
                 vswitch_id: _builtins.str):
        """
        :param 'GetServerlessKubernetesClustersClusterConnectionsArgs' connections: Map of serverless cluster connection information. It contains several attributes to `Block Connections`.
        :param _builtins.bool deletion_protection: Whether the cluster support delete protection.
        :param _builtins.str id: The ID of the container cluster.
        :param _builtins.str name: The name of the container cluster.
        :param _builtins.str nat_gateway_id: The ID of nat gateway used to launch kubernetes cluster.
        :param _builtins.str security_group_id: The ID of security group where the current cluster  is located.
        :param _builtins.str vpc_id: The ID of VPC where the current cluster is located.
        :param _builtins.str vswitch_id: The ID of vSwitch where the current cluster is located.
        """
        pulumi.set(__self__, "connections", connections)
        pulumi.set(__self__, "deletion_protection", deletion_protection)
        pulumi.set(__self__, "endpoint_public_access_enabled", endpoint_public_access_enabled)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "nat_gateway_id", nat_gateway_id)
        pulumi.set(__self__, "security_group_id", security_group_id)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vswitch_id", vswitch_id)

    @_builtins.property
    @pulumi.getter
    def connections(self) -> 'outputs.GetServerlessKubernetesClustersClusterConnectionsResult':
        """
        Map of serverless cluster connection information. It contains several attributes to `Block Connections`.
        """
        return pulumi.get(self, "connections")

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> _builtins.bool:
        """
        Whether the cluster support delete protection.
        """
        return pulumi.get(self, "deletion_protection")

    @_builtins.property
    @pulumi.getter(name="endpointPublicAccessEnabled")
    def endpoint_public_access_enabled(self) -> _builtins.bool:
        return pulumi.get(self, "endpoint_public_access_enabled")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the container cluster.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the container cluster.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="natGatewayId")
    def nat_gateway_id(self) -> _builtins.str:
        """
        The ID of nat gateway used to launch kubernetes cluster.
        """
        return pulumi.get(self, "nat_gateway_id")

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> _builtins.str:
        """
        The ID of security group where the current cluster  is located.
        """
        return pulumi.get(self, "security_group_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> _builtins.str:
        """
        The ID of VPC where the current cluster is located.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> _builtins.str:
        """
        The ID of vSwitch where the current cluster is located.
        """
        return pulumi.get(self, "vswitch_id")


@pulumi.output_type
class GetServerlessKubernetesClustersClusterConnectionsResult(dict):
    def __init__(__self__, *,
                 api_server_internet: _builtins.str,
                 api_server_intranet: _builtins.str,
                 master_public_ip: _builtins.str):
        """
        :param _builtins.str api_server_internet: API Server Internet endpoint.
        :param _builtins.str api_server_intranet: API Server Intranet endpoint.
        :param _builtins.str master_public_ip: Master node SSH IP address.
        """
        pulumi.set(__self__, "api_server_internet", api_server_internet)
        pulumi.set(__self__, "api_server_intranet", api_server_intranet)
        pulumi.set(__self__, "master_public_ip", master_public_ip)

    @_builtins.property
    @pulumi.getter(name="apiServerInternet")
    def api_server_internet(self) -> _builtins.str:
        """
        API Server Internet endpoint.
        """
        return pulumi.get(self, "api_server_internet")

    @_builtins.property
    @pulumi.getter(name="apiServerIntranet")
    def api_server_intranet(self) -> _builtins.str:
        """
        API Server Intranet endpoint.
        """
        return pulumi.get(self, "api_server_intranet")

    @_builtins.property
    @pulumi.getter(name="masterPublicIp")
    def master_public_ip(self) -> _builtins.str:
        """
        Master node SSH IP address.
        """
        return pulumi.get(self, "master_public_ip")


