# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['BackupPlanArgs', 'BackupPlan']

@pulumi.input_type
class BackupPlanArgs:
    def __init__(__self__, *,
                 backup_method: pulumi.Input[_builtins.str],
                 backup_plan_name: pulumi.Input[_builtins.str],
                 database_type: pulumi.Input[_builtins.str],
                 instance_class: pulumi.Input[_builtins.str],
                 source_endpoint_instance_type: pulumi.Input[_builtins.str],
                 backup_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_log_interval_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 backup_objects: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_period: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_rate_limit: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_retention_period: Optional[pulumi.Input[_builtins.int]] = None,
                 backup_speed_limit: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_start_time: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_storage_type: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_strategy_type: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_aliyun_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 database_region: Optional[pulumi.Input[_builtins.str]] = None,
                 duplication_archive_period: Optional[pulumi.Input[_builtins.int]] = None,
                 duplication_infrequent_access_period: Optional[pulumi.Input[_builtins.int]] = None,
                 enable_backup_log: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 oss_bucket_name: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_oracle_sid: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_password: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_port: Optional[pulumi.Input[_builtins.int]] = None,
                 source_endpoint_region: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_sid: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_user_name: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_region: Optional[pulumi.Input[_builtins.str]] = None,
                 used_time: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a BackupPlan resource.
        :param pulumi.Input[_builtins.str] backup_method: Backup method. Valid values: `duplication`, `logical`, `physical`.
        :param pulumi.Input[_builtins.str] backup_plan_name: The name of the resource.
        :param pulumi.Input[_builtins.str] database_type: Database type. Valid values: `DRDS`, `FIle`, `MSSQL`, `MariaDB`, `MongoDB`, `MySQL`, `Oracle`, `PPAS`, `PostgreSQL`, `Redis`.
        :param pulumi.Input[_builtins.str] instance_class: The instance class. Valid values: `large`, `medium`, `micro`, `small`, `xlarge`.
        :param pulumi.Input[_builtins.str] source_endpoint_instance_type: The location of the database. Valid values: `RDS`, `ECS`, `Express`, `Agent`, `DDS`, `Other`.
        :param pulumi.Input[_builtins.str] backup_gateway_id: The ID of the backup gateway. This parameter is required when the `source_endpoint_instance_type` is `Agent`.
        :param pulumi.Input[_builtins.int] backup_log_interval_seconds: The backup log interval seconds.
        :param pulumi.Input[_builtins.str] backup_objects: The backup object.
        :param pulumi.Input[_builtins.str] backup_period: Full backup cycle, Valid values: `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday`, `Saturday`, `Sunday`. supports the selection of multiple fetch values, separated by English commas (,).
        :param pulumi.Input[_builtins.str] backup_rate_limit: The backup rate limit.
        :param pulumi.Input[_builtins.int] backup_retention_period: The retention time of backup data. Valid values: 0 to 1825. Default value: 730 days.
        :param pulumi.Input[_builtins.str] backup_speed_limit: The backup speed limit.
        :param pulumi.Input[_builtins.str] backup_start_time: The start time of full Backup. The format is `<I> HH:mm</I>` Z(UTC time).
        :param pulumi.Input[_builtins.str] backup_storage_type: Built-in storage type, Valid values: `system`.
        :param pulumi.Input[_builtins.str] backup_strategy_type: The backup strategy type. Valid values: `simple`, `manual`.
        :param pulumi.Input[_builtins.str] cross_aliyun_id: The UID that is backed up across Alibaba cloud accounts.
        :param pulumi.Input[_builtins.str] cross_role_name: The name of the RAM role that is backed up across Alibaba cloud accounts.
        :param pulumi.Input[_builtins.str] database_region: The database region.
        :param pulumi.Input[_builtins.int] duplication_archive_period: The storage time for conversion to archive cold standby is 365 days by default.
        :param pulumi.Input[_builtins.int] duplication_infrequent_access_period: The storage time is converted to low-frequency access. The default time is 180 days.
        :param pulumi.Input[_builtins.bool] enable_backup_log: Whether to enable incremental log Backup.
        :param pulumi.Input[_builtins.str] instance_type: The instance type. Valid values: `RDS`, `PolarDB`, `DDS`, `Kvstore`, `Other`.
        :param pulumi.Input[_builtins.str] oss_bucket_name: The OSS Bucket name. The system automatically generates a new name by default.
        :param pulumi.Input[_builtins.str] payment_type: The payment type of the resource. Valid values: `PayAsYouGo`, `Subscription`.
        :param pulumi.Input[_builtins.str] period: Specify that the prepaid instance is of the package year or monthly type. Valid values: `Month`, `Year`.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[_builtins.str] source_endpoint_database_name: The name of the database. This parameter is required when the `database_type` is `PostgreSQL` or `MongoDB`.
        :param pulumi.Input[_builtins.str] source_endpoint_instance_id: The ID of the database instance. This parameter is required when the `source_endpoint_instance_type` is `RDS`, `ECS`, `DDS`, or `Express`.
        :param pulumi.Input[_builtins.str] source_endpoint_ip: The source endpoint ip.
        :param pulumi.Input[_builtins.str] source_endpoint_oracle_sid: Oracle SID name. This parameter is required when the `database_type` is `Oracle`.
        :param pulumi.Input[_builtins.str] source_endpoint_password: The source endpoint password.  This parameter is not required when the `database_type` is `Redis`, or when the `source_endpoint_instance_type` is `Agent` and the `database_type` is `MSSQL`. This parameter is required in other scenarios.
        :param pulumi.Input[_builtins.int] source_endpoint_port: The source endpoint port.
        :param pulumi.Input[_builtins.str] source_endpoint_region: The region of the database. This parameter is required when the `source_endpoint_instance_type` is `RDS`, `ECS`, `DDS`, `Express`, or `Agent`.
        :param pulumi.Input[_builtins.str] source_endpoint_sid: Oracle SID name. This parameter is required when the `database_type` is `Oracle`.
        :param pulumi.Input[_builtins.str] source_endpoint_user_name: The source endpoint username. This parameter is not required when the `database_type` is `Redis`, or when the `source_endpoint_instance_type` is `Agent` and the `database_type` is `MSSQL`. This parameter is required in other scenarios.
        :param pulumi.Input[_builtins.str] status: The status of the resource. Valid values: `pause`, `running`.
        :param pulumi.Input[_builtins.str] storage_region: The storage region.
        :param pulumi.Input[_builtins.int] used_time: Specify purchase duration. When the parameter `period` is `Year`, the `used_time` value is 1 to 9. When the parameter `period` is `Month`, the `used_time` value is 1 to 11.
        """
        pulumi.set(__self__, "backup_method", backup_method)
        pulumi.set(__self__, "backup_plan_name", backup_plan_name)
        pulumi.set(__self__, "database_type", database_type)
        pulumi.set(__self__, "instance_class", instance_class)
        pulumi.set(__self__, "source_endpoint_instance_type", source_endpoint_instance_type)
        if backup_gateway_id is not None:
            pulumi.set(__self__, "backup_gateway_id", backup_gateway_id)
        if backup_log_interval_seconds is not None:
            pulumi.set(__self__, "backup_log_interval_seconds", backup_log_interval_seconds)
        if backup_objects is not None:
            pulumi.set(__self__, "backup_objects", backup_objects)
        if backup_period is not None:
            pulumi.set(__self__, "backup_period", backup_period)
        if backup_rate_limit is not None:
            pulumi.set(__self__, "backup_rate_limit", backup_rate_limit)
        if backup_retention_period is not None:
            pulumi.set(__self__, "backup_retention_period", backup_retention_period)
        if backup_speed_limit is not None:
            pulumi.set(__self__, "backup_speed_limit", backup_speed_limit)
        if backup_start_time is not None:
            pulumi.set(__self__, "backup_start_time", backup_start_time)
        if backup_storage_type is not None:
            pulumi.set(__self__, "backup_storage_type", backup_storage_type)
        if backup_strategy_type is not None:
            pulumi.set(__self__, "backup_strategy_type", backup_strategy_type)
        if cross_aliyun_id is not None:
            pulumi.set(__self__, "cross_aliyun_id", cross_aliyun_id)
        if cross_role_name is not None:
            pulumi.set(__self__, "cross_role_name", cross_role_name)
        if database_region is not None:
            pulumi.set(__self__, "database_region", database_region)
        if duplication_archive_period is not None:
            pulumi.set(__self__, "duplication_archive_period", duplication_archive_period)
        if duplication_infrequent_access_period is not None:
            pulumi.set(__self__, "duplication_infrequent_access_period", duplication_infrequent_access_period)
        if enable_backup_log is not None:
            pulumi.set(__self__, "enable_backup_log", enable_backup_log)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if oss_bucket_name is not None:
            pulumi.set(__self__, "oss_bucket_name", oss_bucket_name)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if source_endpoint_database_name is not None:
            pulumi.set(__self__, "source_endpoint_database_name", source_endpoint_database_name)
        if source_endpoint_instance_id is not None:
            pulumi.set(__self__, "source_endpoint_instance_id", source_endpoint_instance_id)
        if source_endpoint_ip is not None:
            pulumi.set(__self__, "source_endpoint_ip", source_endpoint_ip)
        if source_endpoint_oracle_sid is not None:
            pulumi.set(__self__, "source_endpoint_oracle_sid", source_endpoint_oracle_sid)
        if source_endpoint_password is not None:
            pulumi.set(__self__, "source_endpoint_password", source_endpoint_password)
        if source_endpoint_port is not None:
            pulumi.set(__self__, "source_endpoint_port", source_endpoint_port)
        if source_endpoint_region is not None:
            pulumi.set(__self__, "source_endpoint_region", source_endpoint_region)
        if source_endpoint_sid is not None:
            pulumi.set(__self__, "source_endpoint_sid", source_endpoint_sid)
        if source_endpoint_user_name is not None:
            pulumi.set(__self__, "source_endpoint_user_name", source_endpoint_user_name)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if storage_region is not None:
            pulumi.set(__self__, "storage_region", storage_region)
        if used_time is not None:
            pulumi.set(__self__, "used_time", used_time)

    @_builtins.property
    @pulumi.getter(name="backupMethod")
    def backup_method(self) -> pulumi.Input[_builtins.str]:
        """
        Backup method. Valid values: `duplication`, `logical`, `physical`.
        """
        return pulumi.get(self, "backup_method")

    @backup_method.setter
    def backup_method(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "backup_method", value)

    @_builtins.property
    @pulumi.getter(name="backupPlanName")
    def backup_plan_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the resource.
        """
        return pulumi.get(self, "backup_plan_name")

    @backup_plan_name.setter
    def backup_plan_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "backup_plan_name", value)

    @_builtins.property
    @pulumi.getter(name="databaseType")
    def database_type(self) -> pulumi.Input[_builtins.str]:
        """
        Database type. Valid values: `DRDS`, `FIle`, `MSSQL`, `MariaDB`, `MongoDB`, `MySQL`, `Oracle`, `PPAS`, `PostgreSQL`, `Redis`.
        """
        return pulumi.get(self, "database_type")

    @database_type.setter
    def database_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "database_type", value)

    @_builtins.property
    @pulumi.getter(name="instanceClass")
    def instance_class(self) -> pulumi.Input[_builtins.str]:
        """
        The instance class. Valid values: `large`, `medium`, `micro`, `small`, `xlarge`.
        """
        return pulumi.get(self, "instance_class")

    @instance_class.setter
    def instance_class(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_class", value)

    @_builtins.property
    @pulumi.getter(name="sourceEndpointInstanceType")
    def source_endpoint_instance_type(self) -> pulumi.Input[_builtins.str]:
        """
        The location of the database. Valid values: `RDS`, `ECS`, `Express`, `Agent`, `DDS`, `Other`.
        """
        return pulumi.get(self, "source_endpoint_instance_type")

    @source_endpoint_instance_type.setter
    def source_endpoint_instance_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "source_endpoint_instance_type", value)

    @_builtins.property
    @pulumi.getter(name="backupGatewayId")
    def backup_gateway_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the backup gateway. This parameter is required when the `source_endpoint_instance_type` is `Agent`.
        """
        return pulumi.get(self, "backup_gateway_id")

    @backup_gateway_id.setter
    def backup_gateway_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_gateway_id", value)

    @_builtins.property
    @pulumi.getter(name="backupLogIntervalSeconds")
    def backup_log_interval_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The backup log interval seconds.
        """
        return pulumi.get(self, "backup_log_interval_seconds")

    @backup_log_interval_seconds.setter
    def backup_log_interval_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "backup_log_interval_seconds", value)

    @_builtins.property
    @pulumi.getter(name="backupObjects")
    def backup_objects(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The backup object.
        """
        return pulumi.get(self, "backup_objects")

    @backup_objects.setter
    def backup_objects(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_objects", value)

    @_builtins.property
    @pulumi.getter(name="backupPeriod")
    def backup_period(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Full backup cycle, Valid values: `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday`, `Saturday`, `Sunday`. supports the selection of multiple fetch values, separated by English commas (,).
        """
        return pulumi.get(self, "backup_period")

    @backup_period.setter
    def backup_period(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_period", value)

    @_builtins.property
    @pulumi.getter(name="backupRateLimit")
    def backup_rate_limit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The backup rate limit.
        """
        return pulumi.get(self, "backup_rate_limit")

    @backup_rate_limit.setter
    def backup_rate_limit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_rate_limit", value)

    @_builtins.property
    @pulumi.getter(name="backupRetentionPeriod")
    def backup_retention_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The retention time of backup data. Valid values: 0 to 1825. Default value: 730 days.
        """
        return pulumi.get(self, "backup_retention_period")

    @backup_retention_period.setter
    def backup_retention_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "backup_retention_period", value)

    @_builtins.property
    @pulumi.getter(name="backupSpeedLimit")
    def backup_speed_limit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The backup speed limit.
        """
        return pulumi.get(self, "backup_speed_limit")

    @backup_speed_limit.setter
    def backup_speed_limit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_speed_limit", value)

    @_builtins.property
    @pulumi.getter(name="backupStartTime")
    def backup_start_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The start time of full Backup. The format is `<I> HH:mm</I>` Z(UTC time).
        """
        return pulumi.get(self, "backup_start_time")

    @backup_start_time.setter
    def backup_start_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_start_time", value)

    @_builtins.property
    @pulumi.getter(name="backupStorageType")
    def backup_storage_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Built-in storage type, Valid values: `system`.
        """
        return pulumi.get(self, "backup_storage_type")

    @backup_storage_type.setter
    def backup_storage_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_storage_type", value)

    @_builtins.property
    @pulumi.getter(name="backupStrategyType")
    def backup_strategy_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The backup strategy type. Valid values: `simple`, `manual`.
        """
        return pulumi.get(self, "backup_strategy_type")

    @backup_strategy_type.setter
    def backup_strategy_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_strategy_type", value)

    @_builtins.property
    @pulumi.getter(name="crossAliyunId")
    def cross_aliyun_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The UID that is backed up across Alibaba cloud accounts.
        """
        return pulumi.get(self, "cross_aliyun_id")

    @cross_aliyun_id.setter
    def cross_aliyun_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cross_aliyun_id", value)

    @_builtins.property
    @pulumi.getter(name="crossRoleName")
    def cross_role_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the RAM role that is backed up across Alibaba cloud accounts.
        """
        return pulumi.get(self, "cross_role_name")

    @cross_role_name.setter
    def cross_role_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cross_role_name", value)

    @_builtins.property
    @pulumi.getter(name="databaseRegion")
    def database_region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The database region.
        """
        return pulumi.get(self, "database_region")

    @database_region.setter
    def database_region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_region", value)

    @_builtins.property
    @pulumi.getter(name="duplicationArchivePeriod")
    def duplication_archive_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The storage time for conversion to archive cold standby is 365 days by default.
        """
        return pulumi.get(self, "duplication_archive_period")

    @duplication_archive_period.setter
    def duplication_archive_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "duplication_archive_period", value)

    @_builtins.property
    @pulumi.getter(name="duplicationInfrequentAccessPeriod")
    def duplication_infrequent_access_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The storage time is converted to low-frequency access. The default time is 180 days.
        """
        return pulumi.get(self, "duplication_infrequent_access_period")

    @duplication_infrequent_access_period.setter
    def duplication_infrequent_access_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "duplication_infrequent_access_period", value)

    @_builtins.property
    @pulumi.getter(name="enableBackupLog")
    def enable_backup_log(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable incremental log Backup.
        """
        return pulumi.get(self, "enable_backup_log")

    @enable_backup_log.setter
    def enable_backup_log(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_backup_log", value)

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The instance type. Valid values: `RDS`, `PolarDB`, `DDS`, `Kvstore`, `Other`.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_type", value)

    @_builtins.property
    @pulumi.getter(name="ossBucketName")
    def oss_bucket_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OSS Bucket name. The system automatically generates a new name by default.
        """
        return pulumi.get(self, "oss_bucket_name")

    @oss_bucket_name.setter
    def oss_bucket_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "oss_bucket_name", value)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The payment type of the resource. Valid values: `PayAsYouGo`, `Subscription`.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specify that the prepaid instance is of the package year or monthly type. Valid values: `Month`, `Year`.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="sourceEndpointDatabaseName")
    def source_endpoint_database_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the database. This parameter is required when the `database_type` is `PostgreSQL` or `MongoDB`.
        """
        return pulumi.get(self, "source_endpoint_database_name")

    @source_endpoint_database_name.setter
    def source_endpoint_database_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_endpoint_database_name", value)

    @_builtins.property
    @pulumi.getter(name="sourceEndpointInstanceId")
    def source_endpoint_instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the database instance. This parameter is required when the `source_endpoint_instance_type` is `RDS`, `ECS`, `DDS`, or `Express`.
        """
        return pulumi.get(self, "source_endpoint_instance_id")

    @source_endpoint_instance_id.setter
    def source_endpoint_instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_endpoint_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="sourceEndpointIp")
    def source_endpoint_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The source endpoint ip.
        """
        return pulumi.get(self, "source_endpoint_ip")

    @source_endpoint_ip.setter
    def source_endpoint_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_endpoint_ip", value)

    @_builtins.property
    @pulumi.getter(name="sourceEndpointOracleSid")
    def source_endpoint_oracle_sid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Oracle SID name. This parameter is required when the `database_type` is `Oracle`.
        """
        return pulumi.get(self, "source_endpoint_oracle_sid")

    @source_endpoint_oracle_sid.setter
    def source_endpoint_oracle_sid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_endpoint_oracle_sid", value)

    @_builtins.property
    @pulumi.getter(name="sourceEndpointPassword")
    def source_endpoint_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The source endpoint password.  This parameter is not required when the `database_type` is `Redis`, or when the `source_endpoint_instance_type` is `Agent` and the `database_type` is `MSSQL`. This parameter is required in other scenarios.
        """
        return pulumi.get(self, "source_endpoint_password")

    @source_endpoint_password.setter
    def source_endpoint_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_endpoint_password", value)

    @_builtins.property
    @pulumi.getter(name="sourceEndpointPort")
    def source_endpoint_port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The source endpoint port.
        """
        return pulumi.get(self, "source_endpoint_port")

    @source_endpoint_port.setter
    def source_endpoint_port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "source_endpoint_port", value)

    @_builtins.property
    @pulumi.getter(name="sourceEndpointRegion")
    def source_endpoint_region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region of the database. This parameter is required when the `source_endpoint_instance_type` is `RDS`, `ECS`, `DDS`, `Express`, or `Agent`.
        """
        return pulumi.get(self, "source_endpoint_region")

    @source_endpoint_region.setter
    def source_endpoint_region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_endpoint_region", value)

    @_builtins.property
    @pulumi.getter(name="sourceEndpointSid")
    def source_endpoint_sid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Oracle SID name. This parameter is required when the `database_type` is `Oracle`.
        """
        return pulumi.get(self, "source_endpoint_sid")

    @source_endpoint_sid.setter
    def source_endpoint_sid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_endpoint_sid", value)

    @_builtins.property
    @pulumi.getter(name="sourceEndpointUserName")
    def source_endpoint_user_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The source endpoint username. This parameter is not required when the `database_type` is `Redis`, or when the `source_endpoint_instance_type` is `Agent` and the `database_type` is `MSSQL`. This parameter is required in other scenarios.
        """
        return pulumi.get(self, "source_endpoint_user_name")

    @source_endpoint_user_name.setter
    def source_endpoint_user_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_endpoint_user_name", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the resource. Valid values: `pause`, `running`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="storageRegion")
    def storage_region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The storage region.
        """
        return pulumi.get(self, "storage_region")

    @storage_region.setter
    def storage_region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_region", value)

    @_builtins.property
    @pulumi.getter(name="usedTime")
    def used_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specify purchase duration. When the parameter `period` is `Year`, the `used_time` value is 1 to 9. When the parameter `period` is `Month`, the `used_time` value is 1 to 11.
        """
        return pulumi.get(self, "used_time")

    @used_time.setter
    def used_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "used_time", value)


@pulumi.input_type
class _BackupPlanState:
    def __init__(__self__, *,
                 backup_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_log_interval_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 backup_method: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_objects: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_period: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_plan_name: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_rate_limit: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_retention_period: Optional[pulumi.Input[_builtins.int]] = None,
                 backup_speed_limit: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_start_time: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_storage_type: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_strategy_type: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_aliyun_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 database_region: Optional[pulumi.Input[_builtins.str]] = None,
                 database_type: Optional[pulumi.Input[_builtins.str]] = None,
                 duplication_archive_period: Optional[pulumi.Input[_builtins.int]] = None,
                 duplication_infrequent_access_period: Optional[pulumi.Input[_builtins.int]] = None,
                 enable_backup_log: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_class: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 oss_bucket_name: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_oracle_sid: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_password: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_port: Optional[pulumi.Input[_builtins.int]] = None,
                 source_endpoint_region: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_sid: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_user_name: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_region: Optional[pulumi.Input[_builtins.str]] = None,
                 used_time: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering BackupPlan resources.
        :param pulumi.Input[_builtins.str] backup_gateway_id: The ID of the backup gateway. This parameter is required when the `source_endpoint_instance_type` is `Agent`.
        :param pulumi.Input[_builtins.int] backup_log_interval_seconds: The backup log interval seconds.
        :param pulumi.Input[_builtins.str] backup_method: Backup method. Valid values: `duplication`, `logical`, `physical`.
        :param pulumi.Input[_builtins.str] backup_objects: The backup object.
        :param pulumi.Input[_builtins.str] backup_period: Full backup cycle, Valid values: `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday`, `Saturday`, `Sunday`. supports the selection of multiple fetch values, separated by English commas (,).
        :param pulumi.Input[_builtins.str] backup_plan_name: The name of the resource.
        :param pulumi.Input[_builtins.str] backup_rate_limit: The backup rate limit.
        :param pulumi.Input[_builtins.int] backup_retention_period: The retention time of backup data. Valid values: 0 to 1825. Default value: 730 days.
        :param pulumi.Input[_builtins.str] backup_speed_limit: The backup speed limit.
        :param pulumi.Input[_builtins.str] backup_start_time: The start time of full Backup. The format is `<I> HH:mm</I>` Z(UTC time).
        :param pulumi.Input[_builtins.str] backup_storage_type: Built-in storage type, Valid values: `system`.
        :param pulumi.Input[_builtins.str] backup_strategy_type: The backup strategy type. Valid values: `simple`, `manual`.
        :param pulumi.Input[_builtins.str] cross_aliyun_id: The UID that is backed up across Alibaba cloud accounts.
        :param pulumi.Input[_builtins.str] cross_role_name: The name of the RAM role that is backed up across Alibaba cloud accounts.
        :param pulumi.Input[_builtins.str] database_region: The database region.
        :param pulumi.Input[_builtins.str] database_type: Database type. Valid values: `DRDS`, `FIle`, `MSSQL`, `MariaDB`, `MongoDB`, `MySQL`, `Oracle`, `PPAS`, `PostgreSQL`, `Redis`.
        :param pulumi.Input[_builtins.int] duplication_archive_period: The storage time for conversion to archive cold standby is 365 days by default.
        :param pulumi.Input[_builtins.int] duplication_infrequent_access_period: The storage time is converted to low-frequency access. The default time is 180 days.
        :param pulumi.Input[_builtins.bool] enable_backup_log: Whether to enable incremental log Backup.
        :param pulumi.Input[_builtins.str] instance_class: The instance class. Valid values: `large`, `medium`, `micro`, `small`, `xlarge`.
        :param pulumi.Input[_builtins.str] instance_type: The instance type. Valid values: `RDS`, `PolarDB`, `DDS`, `Kvstore`, `Other`.
        :param pulumi.Input[_builtins.str] oss_bucket_name: The OSS Bucket name. The system automatically generates a new name by default.
        :param pulumi.Input[_builtins.str] payment_type: The payment type of the resource. Valid values: `PayAsYouGo`, `Subscription`.
        :param pulumi.Input[_builtins.str] period: Specify that the prepaid instance is of the package year or monthly type. Valid values: `Month`, `Year`.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[_builtins.str] source_endpoint_database_name: The name of the database. This parameter is required when the `database_type` is `PostgreSQL` or `MongoDB`.
        :param pulumi.Input[_builtins.str] source_endpoint_instance_id: The ID of the database instance. This parameter is required when the `source_endpoint_instance_type` is `RDS`, `ECS`, `DDS`, or `Express`.
        :param pulumi.Input[_builtins.str] source_endpoint_instance_type: The location of the database. Valid values: `RDS`, `ECS`, `Express`, `Agent`, `DDS`, `Other`.
        :param pulumi.Input[_builtins.str] source_endpoint_ip: The source endpoint ip.
        :param pulumi.Input[_builtins.str] source_endpoint_oracle_sid: Oracle SID name. This parameter is required when the `database_type` is `Oracle`.
        :param pulumi.Input[_builtins.str] source_endpoint_password: The source endpoint password.  This parameter is not required when the `database_type` is `Redis`, or when the `source_endpoint_instance_type` is `Agent` and the `database_type` is `MSSQL`. This parameter is required in other scenarios.
        :param pulumi.Input[_builtins.int] source_endpoint_port: The source endpoint port.
        :param pulumi.Input[_builtins.str] source_endpoint_region: The region of the database. This parameter is required when the `source_endpoint_instance_type` is `RDS`, `ECS`, `DDS`, `Express`, or `Agent`.
        :param pulumi.Input[_builtins.str] source_endpoint_sid: Oracle SID name. This parameter is required when the `database_type` is `Oracle`.
        :param pulumi.Input[_builtins.str] source_endpoint_user_name: The source endpoint username. This parameter is not required when the `database_type` is `Redis`, or when the `source_endpoint_instance_type` is `Agent` and the `database_type` is `MSSQL`. This parameter is required in other scenarios.
        :param pulumi.Input[_builtins.str] status: The status of the resource. Valid values: `pause`, `running`.
        :param pulumi.Input[_builtins.str] storage_region: The storage region.
        :param pulumi.Input[_builtins.int] used_time: Specify purchase duration. When the parameter `period` is `Year`, the `used_time` value is 1 to 9. When the parameter `period` is `Month`, the `used_time` value is 1 to 11.
        """
        if backup_gateway_id is not None:
            pulumi.set(__self__, "backup_gateway_id", backup_gateway_id)
        if backup_log_interval_seconds is not None:
            pulumi.set(__self__, "backup_log_interval_seconds", backup_log_interval_seconds)
        if backup_method is not None:
            pulumi.set(__self__, "backup_method", backup_method)
        if backup_objects is not None:
            pulumi.set(__self__, "backup_objects", backup_objects)
        if backup_period is not None:
            pulumi.set(__self__, "backup_period", backup_period)
        if backup_plan_name is not None:
            pulumi.set(__self__, "backup_plan_name", backup_plan_name)
        if backup_rate_limit is not None:
            pulumi.set(__self__, "backup_rate_limit", backup_rate_limit)
        if backup_retention_period is not None:
            pulumi.set(__self__, "backup_retention_period", backup_retention_period)
        if backup_speed_limit is not None:
            pulumi.set(__self__, "backup_speed_limit", backup_speed_limit)
        if backup_start_time is not None:
            pulumi.set(__self__, "backup_start_time", backup_start_time)
        if backup_storage_type is not None:
            pulumi.set(__self__, "backup_storage_type", backup_storage_type)
        if backup_strategy_type is not None:
            pulumi.set(__self__, "backup_strategy_type", backup_strategy_type)
        if cross_aliyun_id is not None:
            pulumi.set(__self__, "cross_aliyun_id", cross_aliyun_id)
        if cross_role_name is not None:
            pulumi.set(__self__, "cross_role_name", cross_role_name)
        if database_region is not None:
            pulumi.set(__self__, "database_region", database_region)
        if database_type is not None:
            pulumi.set(__self__, "database_type", database_type)
        if duplication_archive_period is not None:
            pulumi.set(__self__, "duplication_archive_period", duplication_archive_period)
        if duplication_infrequent_access_period is not None:
            pulumi.set(__self__, "duplication_infrequent_access_period", duplication_infrequent_access_period)
        if enable_backup_log is not None:
            pulumi.set(__self__, "enable_backup_log", enable_backup_log)
        if instance_class is not None:
            pulumi.set(__self__, "instance_class", instance_class)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if oss_bucket_name is not None:
            pulumi.set(__self__, "oss_bucket_name", oss_bucket_name)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if source_endpoint_database_name is not None:
            pulumi.set(__self__, "source_endpoint_database_name", source_endpoint_database_name)
        if source_endpoint_instance_id is not None:
            pulumi.set(__self__, "source_endpoint_instance_id", source_endpoint_instance_id)
        if source_endpoint_instance_type is not None:
            pulumi.set(__self__, "source_endpoint_instance_type", source_endpoint_instance_type)
        if source_endpoint_ip is not None:
            pulumi.set(__self__, "source_endpoint_ip", source_endpoint_ip)
        if source_endpoint_oracle_sid is not None:
            pulumi.set(__self__, "source_endpoint_oracle_sid", source_endpoint_oracle_sid)
        if source_endpoint_password is not None:
            pulumi.set(__self__, "source_endpoint_password", source_endpoint_password)
        if source_endpoint_port is not None:
            pulumi.set(__self__, "source_endpoint_port", source_endpoint_port)
        if source_endpoint_region is not None:
            pulumi.set(__self__, "source_endpoint_region", source_endpoint_region)
        if source_endpoint_sid is not None:
            pulumi.set(__self__, "source_endpoint_sid", source_endpoint_sid)
        if source_endpoint_user_name is not None:
            pulumi.set(__self__, "source_endpoint_user_name", source_endpoint_user_name)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if storage_region is not None:
            pulumi.set(__self__, "storage_region", storage_region)
        if used_time is not None:
            pulumi.set(__self__, "used_time", used_time)

    @_builtins.property
    @pulumi.getter(name="backupGatewayId")
    def backup_gateway_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the backup gateway. This parameter is required when the `source_endpoint_instance_type` is `Agent`.
        """
        return pulumi.get(self, "backup_gateway_id")

    @backup_gateway_id.setter
    def backup_gateway_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_gateway_id", value)

    @_builtins.property
    @pulumi.getter(name="backupLogIntervalSeconds")
    def backup_log_interval_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The backup log interval seconds.
        """
        return pulumi.get(self, "backup_log_interval_seconds")

    @backup_log_interval_seconds.setter
    def backup_log_interval_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "backup_log_interval_seconds", value)

    @_builtins.property
    @pulumi.getter(name="backupMethod")
    def backup_method(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Backup method. Valid values: `duplication`, `logical`, `physical`.
        """
        return pulumi.get(self, "backup_method")

    @backup_method.setter
    def backup_method(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_method", value)

    @_builtins.property
    @pulumi.getter(name="backupObjects")
    def backup_objects(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The backup object.
        """
        return pulumi.get(self, "backup_objects")

    @backup_objects.setter
    def backup_objects(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_objects", value)

    @_builtins.property
    @pulumi.getter(name="backupPeriod")
    def backup_period(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Full backup cycle, Valid values: `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday`, `Saturday`, `Sunday`. supports the selection of multiple fetch values, separated by English commas (,).
        """
        return pulumi.get(self, "backup_period")

    @backup_period.setter
    def backup_period(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_period", value)

    @_builtins.property
    @pulumi.getter(name="backupPlanName")
    def backup_plan_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource.
        """
        return pulumi.get(self, "backup_plan_name")

    @backup_plan_name.setter
    def backup_plan_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_plan_name", value)

    @_builtins.property
    @pulumi.getter(name="backupRateLimit")
    def backup_rate_limit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The backup rate limit.
        """
        return pulumi.get(self, "backup_rate_limit")

    @backup_rate_limit.setter
    def backup_rate_limit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_rate_limit", value)

    @_builtins.property
    @pulumi.getter(name="backupRetentionPeriod")
    def backup_retention_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The retention time of backup data. Valid values: 0 to 1825. Default value: 730 days.
        """
        return pulumi.get(self, "backup_retention_period")

    @backup_retention_period.setter
    def backup_retention_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "backup_retention_period", value)

    @_builtins.property
    @pulumi.getter(name="backupSpeedLimit")
    def backup_speed_limit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The backup speed limit.
        """
        return pulumi.get(self, "backup_speed_limit")

    @backup_speed_limit.setter
    def backup_speed_limit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_speed_limit", value)

    @_builtins.property
    @pulumi.getter(name="backupStartTime")
    def backup_start_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The start time of full Backup. The format is `<I> HH:mm</I>` Z(UTC time).
        """
        return pulumi.get(self, "backup_start_time")

    @backup_start_time.setter
    def backup_start_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_start_time", value)

    @_builtins.property
    @pulumi.getter(name="backupStorageType")
    def backup_storage_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Built-in storage type, Valid values: `system`.
        """
        return pulumi.get(self, "backup_storage_type")

    @backup_storage_type.setter
    def backup_storage_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_storage_type", value)

    @_builtins.property
    @pulumi.getter(name="backupStrategyType")
    def backup_strategy_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The backup strategy type. Valid values: `simple`, `manual`.
        """
        return pulumi.get(self, "backup_strategy_type")

    @backup_strategy_type.setter
    def backup_strategy_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_strategy_type", value)

    @_builtins.property
    @pulumi.getter(name="crossAliyunId")
    def cross_aliyun_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The UID that is backed up across Alibaba cloud accounts.
        """
        return pulumi.get(self, "cross_aliyun_id")

    @cross_aliyun_id.setter
    def cross_aliyun_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cross_aliyun_id", value)

    @_builtins.property
    @pulumi.getter(name="crossRoleName")
    def cross_role_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the RAM role that is backed up across Alibaba cloud accounts.
        """
        return pulumi.get(self, "cross_role_name")

    @cross_role_name.setter
    def cross_role_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cross_role_name", value)

    @_builtins.property
    @pulumi.getter(name="databaseRegion")
    def database_region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The database region.
        """
        return pulumi.get(self, "database_region")

    @database_region.setter
    def database_region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_region", value)

    @_builtins.property
    @pulumi.getter(name="databaseType")
    def database_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Database type. Valid values: `DRDS`, `FIle`, `MSSQL`, `MariaDB`, `MongoDB`, `MySQL`, `Oracle`, `PPAS`, `PostgreSQL`, `Redis`.
        """
        return pulumi.get(self, "database_type")

    @database_type.setter
    def database_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_type", value)

    @_builtins.property
    @pulumi.getter(name="duplicationArchivePeriod")
    def duplication_archive_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The storage time for conversion to archive cold standby is 365 days by default.
        """
        return pulumi.get(self, "duplication_archive_period")

    @duplication_archive_period.setter
    def duplication_archive_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "duplication_archive_period", value)

    @_builtins.property
    @pulumi.getter(name="duplicationInfrequentAccessPeriod")
    def duplication_infrequent_access_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The storage time is converted to low-frequency access. The default time is 180 days.
        """
        return pulumi.get(self, "duplication_infrequent_access_period")

    @duplication_infrequent_access_period.setter
    def duplication_infrequent_access_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "duplication_infrequent_access_period", value)

    @_builtins.property
    @pulumi.getter(name="enableBackupLog")
    def enable_backup_log(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable incremental log Backup.
        """
        return pulumi.get(self, "enable_backup_log")

    @enable_backup_log.setter
    def enable_backup_log(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_backup_log", value)

    @_builtins.property
    @pulumi.getter(name="instanceClass")
    def instance_class(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The instance class. Valid values: `large`, `medium`, `micro`, `small`, `xlarge`.
        """
        return pulumi.get(self, "instance_class")

    @instance_class.setter
    def instance_class(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_class", value)

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The instance type. Valid values: `RDS`, `PolarDB`, `DDS`, `Kvstore`, `Other`.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_type", value)

    @_builtins.property
    @pulumi.getter(name="ossBucketName")
    def oss_bucket_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OSS Bucket name. The system automatically generates a new name by default.
        """
        return pulumi.get(self, "oss_bucket_name")

    @oss_bucket_name.setter
    def oss_bucket_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "oss_bucket_name", value)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The payment type of the resource. Valid values: `PayAsYouGo`, `Subscription`.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specify that the prepaid instance is of the package year or monthly type. Valid values: `Month`, `Year`.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="sourceEndpointDatabaseName")
    def source_endpoint_database_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the database. This parameter is required when the `database_type` is `PostgreSQL` or `MongoDB`.
        """
        return pulumi.get(self, "source_endpoint_database_name")

    @source_endpoint_database_name.setter
    def source_endpoint_database_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_endpoint_database_name", value)

    @_builtins.property
    @pulumi.getter(name="sourceEndpointInstanceId")
    def source_endpoint_instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the database instance. This parameter is required when the `source_endpoint_instance_type` is `RDS`, `ECS`, `DDS`, or `Express`.
        """
        return pulumi.get(self, "source_endpoint_instance_id")

    @source_endpoint_instance_id.setter
    def source_endpoint_instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_endpoint_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="sourceEndpointInstanceType")
    def source_endpoint_instance_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The location of the database. Valid values: `RDS`, `ECS`, `Express`, `Agent`, `DDS`, `Other`.
        """
        return pulumi.get(self, "source_endpoint_instance_type")

    @source_endpoint_instance_type.setter
    def source_endpoint_instance_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_endpoint_instance_type", value)

    @_builtins.property
    @pulumi.getter(name="sourceEndpointIp")
    def source_endpoint_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The source endpoint ip.
        """
        return pulumi.get(self, "source_endpoint_ip")

    @source_endpoint_ip.setter
    def source_endpoint_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_endpoint_ip", value)

    @_builtins.property
    @pulumi.getter(name="sourceEndpointOracleSid")
    def source_endpoint_oracle_sid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Oracle SID name. This parameter is required when the `database_type` is `Oracle`.
        """
        return pulumi.get(self, "source_endpoint_oracle_sid")

    @source_endpoint_oracle_sid.setter
    def source_endpoint_oracle_sid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_endpoint_oracle_sid", value)

    @_builtins.property
    @pulumi.getter(name="sourceEndpointPassword")
    def source_endpoint_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The source endpoint password.  This parameter is not required when the `database_type` is `Redis`, or when the `source_endpoint_instance_type` is `Agent` and the `database_type` is `MSSQL`. This parameter is required in other scenarios.
        """
        return pulumi.get(self, "source_endpoint_password")

    @source_endpoint_password.setter
    def source_endpoint_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_endpoint_password", value)

    @_builtins.property
    @pulumi.getter(name="sourceEndpointPort")
    def source_endpoint_port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The source endpoint port.
        """
        return pulumi.get(self, "source_endpoint_port")

    @source_endpoint_port.setter
    def source_endpoint_port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "source_endpoint_port", value)

    @_builtins.property
    @pulumi.getter(name="sourceEndpointRegion")
    def source_endpoint_region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region of the database. This parameter is required when the `source_endpoint_instance_type` is `RDS`, `ECS`, `DDS`, `Express`, or `Agent`.
        """
        return pulumi.get(self, "source_endpoint_region")

    @source_endpoint_region.setter
    def source_endpoint_region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_endpoint_region", value)

    @_builtins.property
    @pulumi.getter(name="sourceEndpointSid")
    def source_endpoint_sid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Oracle SID name. This parameter is required when the `database_type` is `Oracle`.
        """
        return pulumi.get(self, "source_endpoint_sid")

    @source_endpoint_sid.setter
    def source_endpoint_sid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_endpoint_sid", value)

    @_builtins.property
    @pulumi.getter(name="sourceEndpointUserName")
    def source_endpoint_user_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The source endpoint username. This parameter is not required when the `database_type` is `Redis`, or when the `source_endpoint_instance_type` is `Agent` and the `database_type` is `MSSQL`. This parameter is required in other scenarios.
        """
        return pulumi.get(self, "source_endpoint_user_name")

    @source_endpoint_user_name.setter
    def source_endpoint_user_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_endpoint_user_name", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the resource. Valid values: `pause`, `running`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="storageRegion")
    def storage_region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The storage region.
        """
        return pulumi.get(self, "storage_region")

    @storage_region.setter
    def storage_region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_region", value)

    @_builtins.property
    @pulumi.getter(name="usedTime")
    def used_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specify purchase duration. When the parameter `period` is `Year`, the `used_time` value is 1 to 9. When the parameter `period` is `Month`, the `used_time` value is 1 to 11.
        """
        return pulumi.get(self, "used_time")

    @used_time.setter
    def used_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "used_time", value)


@pulumi.type_token("alicloud:dbs/backupPlan:BackupPlan")
class BackupPlan(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_log_interval_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 backup_method: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_objects: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_period: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_plan_name: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_rate_limit: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_retention_period: Optional[pulumi.Input[_builtins.int]] = None,
                 backup_speed_limit: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_start_time: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_storage_type: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_strategy_type: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_aliyun_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 database_region: Optional[pulumi.Input[_builtins.str]] = None,
                 database_type: Optional[pulumi.Input[_builtins.str]] = None,
                 duplication_archive_period: Optional[pulumi.Input[_builtins.int]] = None,
                 duplication_infrequent_access_period: Optional[pulumi.Input[_builtins.int]] = None,
                 enable_backup_log: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_class: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 oss_bucket_name: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_oracle_sid: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_password: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_port: Optional[pulumi.Input[_builtins.int]] = None,
                 source_endpoint_region: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_sid: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_user_name: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_region: Optional[pulumi.Input[_builtins.str]] = None,
                 used_time: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Provides a DBS Backup Plan resource.

        For information about DBS Backup Plan and how to use it, see [What is Backup Plan](https://www.alibabacloud.com/help/en/dms/developer-reference/api-dbs-2019-03-06-createandstartbackupplan).

        > **NOTE:** Available since v1.185.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.resourcemanager.get_resource_groups(status="OK")
        default_get_zones = alicloud.rds.get_zones(engine="MySQL",
            engine_version="8.0",
            instance_charge_type="PostPaid",
            category="HighAvailability",
            db_instance_storage_type="cloud_essd")
        default_get_instance_classes = alicloud.rds.get_instance_classes(zone_id=default_get_zones.zones[1].id,
            engine="MySQL",
            engine_version="8.0",
            category="HighAvailability",
            db_instance_storage_type="cloud_essd",
            instance_charge_type="PostPaid")
        default_get_networks = alicloud.vpc.get_networks(name_regex="^default-NODELETING")
        default_get_switches = alicloud.vpc.get_switches(vpc_id=default_get_networks.ids[0],
            zone_id=default_get_zones.zones[1].id)
        vswitch_id = default_get_switches.ids[0]
        zone_id = default_get_zones.ids[1]
        default_security_group = alicloud.ecs.SecurityGroup("default",
            name=name,
            vpc_id=default_get_networks.ids[0])
        default_instance = alicloud.rds.Instance("default",
            engine="MySQL",
            engine_version="8.0",
            db_instance_storage_type="cloud_essd",
            instance_type=default_get_instance_classes.instance_classes[0].instance_class,
            instance_storage=default_get_instance_classes.instance_classes[0].storage_range.min,
            vswitch_id=vswitch_id,
            instance_name=name)
        default_database = alicloud.rds.Database("default",
            instance_id=default_instance.id,
            name="tfdatabase")
        default_rds_account = alicloud.rds.RdsAccount("default",
            db_instance_id=default_instance.id,
            account_name="tfnormal000",
            account_password="Test12345")
        default_account_privilege = alicloud.rds.AccountPrivilege("default",
            instance_id=default_instance.id,
            account_name=default_rds_account.account_name,
            privilege="ReadWrite",
            db_names=[default_database.name])
        default_backup_plan = alicloud.dbs.BackupPlan("default",
            backup_plan_name=name,
            payment_type="PayAsYouGo",
            instance_class="xlarge",
            backup_method="logical",
            database_type="MySQL",
            database_region="cn-hangzhou",
            storage_region="cn-hangzhou",
            instance_type="RDS",
            source_endpoint_instance_type="RDS",
            resource_group_id=default.ids[0],
            source_endpoint_region="cn-hangzhou",
            source_endpoint_instance_id=default_instance.id,
            source_endpoint_user_name=default_account_privilege.account_name,
            source_endpoint_password=default_rds_account.account_password,
            backup_objects=default_database.name.apply(lambda name: f"[{{\\"DBName\\":\\"{name}\\"}}]"),
            backup_period="Monday",
            backup_start_time="14:22",
            backup_storage_type="system",
            backup_retention_period=740)
        ```

        ## Import

        DBS Backup Plan can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:dbs/backupPlan:BackupPlan example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] backup_gateway_id: The ID of the backup gateway. This parameter is required when the `source_endpoint_instance_type` is `Agent`.
        :param pulumi.Input[_builtins.int] backup_log_interval_seconds: The backup log interval seconds.
        :param pulumi.Input[_builtins.str] backup_method: Backup method. Valid values: `duplication`, `logical`, `physical`.
        :param pulumi.Input[_builtins.str] backup_objects: The backup object.
        :param pulumi.Input[_builtins.str] backup_period: Full backup cycle, Valid values: `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday`, `Saturday`, `Sunday`. supports the selection of multiple fetch values, separated by English commas (,).
        :param pulumi.Input[_builtins.str] backup_plan_name: The name of the resource.
        :param pulumi.Input[_builtins.str] backup_rate_limit: The backup rate limit.
        :param pulumi.Input[_builtins.int] backup_retention_period: The retention time of backup data. Valid values: 0 to 1825. Default value: 730 days.
        :param pulumi.Input[_builtins.str] backup_speed_limit: The backup speed limit.
        :param pulumi.Input[_builtins.str] backup_start_time: The start time of full Backup. The format is `<I> HH:mm</I>` Z(UTC time).
        :param pulumi.Input[_builtins.str] backup_storage_type: Built-in storage type, Valid values: `system`.
        :param pulumi.Input[_builtins.str] backup_strategy_type: The backup strategy type. Valid values: `simple`, `manual`.
        :param pulumi.Input[_builtins.str] cross_aliyun_id: The UID that is backed up across Alibaba cloud accounts.
        :param pulumi.Input[_builtins.str] cross_role_name: The name of the RAM role that is backed up across Alibaba cloud accounts.
        :param pulumi.Input[_builtins.str] database_region: The database region.
        :param pulumi.Input[_builtins.str] database_type: Database type. Valid values: `DRDS`, `FIle`, `MSSQL`, `MariaDB`, `MongoDB`, `MySQL`, `Oracle`, `PPAS`, `PostgreSQL`, `Redis`.
        :param pulumi.Input[_builtins.int] duplication_archive_period: The storage time for conversion to archive cold standby is 365 days by default.
        :param pulumi.Input[_builtins.int] duplication_infrequent_access_period: The storage time is converted to low-frequency access. The default time is 180 days.
        :param pulumi.Input[_builtins.bool] enable_backup_log: Whether to enable incremental log Backup.
        :param pulumi.Input[_builtins.str] instance_class: The instance class. Valid values: `large`, `medium`, `micro`, `small`, `xlarge`.
        :param pulumi.Input[_builtins.str] instance_type: The instance type. Valid values: `RDS`, `PolarDB`, `DDS`, `Kvstore`, `Other`.
        :param pulumi.Input[_builtins.str] oss_bucket_name: The OSS Bucket name. The system automatically generates a new name by default.
        :param pulumi.Input[_builtins.str] payment_type: The payment type of the resource. Valid values: `PayAsYouGo`, `Subscription`.
        :param pulumi.Input[_builtins.str] period: Specify that the prepaid instance is of the package year or monthly type. Valid values: `Month`, `Year`.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[_builtins.str] source_endpoint_database_name: The name of the database. This parameter is required when the `database_type` is `PostgreSQL` or `MongoDB`.
        :param pulumi.Input[_builtins.str] source_endpoint_instance_id: The ID of the database instance. This parameter is required when the `source_endpoint_instance_type` is `RDS`, `ECS`, `DDS`, or `Express`.
        :param pulumi.Input[_builtins.str] source_endpoint_instance_type: The location of the database. Valid values: `RDS`, `ECS`, `Express`, `Agent`, `DDS`, `Other`.
        :param pulumi.Input[_builtins.str] source_endpoint_ip: The source endpoint ip.
        :param pulumi.Input[_builtins.str] source_endpoint_oracle_sid: Oracle SID name. This parameter is required when the `database_type` is `Oracle`.
        :param pulumi.Input[_builtins.str] source_endpoint_password: The source endpoint password.  This parameter is not required when the `database_type` is `Redis`, or when the `source_endpoint_instance_type` is `Agent` and the `database_type` is `MSSQL`. This parameter is required in other scenarios.
        :param pulumi.Input[_builtins.int] source_endpoint_port: The source endpoint port.
        :param pulumi.Input[_builtins.str] source_endpoint_region: The region of the database. This parameter is required when the `source_endpoint_instance_type` is `RDS`, `ECS`, `DDS`, `Express`, or `Agent`.
        :param pulumi.Input[_builtins.str] source_endpoint_sid: Oracle SID name. This parameter is required when the `database_type` is `Oracle`.
        :param pulumi.Input[_builtins.str] source_endpoint_user_name: The source endpoint username. This parameter is not required when the `database_type` is `Redis`, or when the `source_endpoint_instance_type` is `Agent` and the `database_type` is `MSSQL`. This parameter is required in other scenarios.
        :param pulumi.Input[_builtins.str] status: The status of the resource. Valid values: `pause`, `running`.
        :param pulumi.Input[_builtins.str] storage_region: The storage region.
        :param pulumi.Input[_builtins.int] used_time: Specify purchase duration. When the parameter `period` is `Year`, the `used_time` value is 1 to 9. When the parameter `period` is `Month`, the `used_time` value is 1 to 11.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BackupPlanArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a DBS Backup Plan resource.

        For information about DBS Backup Plan and how to use it, see [What is Backup Plan](https://www.alibabacloud.com/help/en/dms/developer-reference/api-dbs-2019-03-06-createandstartbackupplan).

        > **NOTE:** Available since v1.185.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.resourcemanager.get_resource_groups(status="OK")
        default_get_zones = alicloud.rds.get_zones(engine="MySQL",
            engine_version="8.0",
            instance_charge_type="PostPaid",
            category="HighAvailability",
            db_instance_storage_type="cloud_essd")
        default_get_instance_classes = alicloud.rds.get_instance_classes(zone_id=default_get_zones.zones[1].id,
            engine="MySQL",
            engine_version="8.0",
            category="HighAvailability",
            db_instance_storage_type="cloud_essd",
            instance_charge_type="PostPaid")
        default_get_networks = alicloud.vpc.get_networks(name_regex="^default-NODELETING")
        default_get_switches = alicloud.vpc.get_switches(vpc_id=default_get_networks.ids[0],
            zone_id=default_get_zones.zones[1].id)
        vswitch_id = default_get_switches.ids[0]
        zone_id = default_get_zones.ids[1]
        default_security_group = alicloud.ecs.SecurityGroup("default",
            name=name,
            vpc_id=default_get_networks.ids[0])
        default_instance = alicloud.rds.Instance("default",
            engine="MySQL",
            engine_version="8.0",
            db_instance_storage_type="cloud_essd",
            instance_type=default_get_instance_classes.instance_classes[0].instance_class,
            instance_storage=default_get_instance_classes.instance_classes[0].storage_range.min,
            vswitch_id=vswitch_id,
            instance_name=name)
        default_database = alicloud.rds.Database("default",
            instance_id=default_instance.id,
            name="tfdatabase")
        default_rds_account = alicloud.rds.RdsAccount("default",
            db_instance_id=default_instance.id,
            account_name="tfnormal000",
            account_password="Test12345")
        default_account_privilege = alicloud.rds.AccountPrivilege("default",
            instance_id=default_instance.id,
            account_name=default_rds_account.account_name,
            privilege="ReadWrite",
            db_names=[default_database.name])
        default_backup_plan = alicloud.dbs.BackupPlan("default",
            backup_plan_name=name,
            payment_type="PayAsYouGo",
            instance_class="xlarge",
            backup_method="logical",
            database_type="MySQL",
            database_region="cn-hangzhou",
            storage_region="cn-hangzhou",
            instance_type="RDS",
            source_endpoint_instance_type="RDS",
            resource_group_id=default.ids[0],
            source_endpoint_region="cn-hangzhou",
            source_endpoint_instance_id=default_instance.id,
            source_endpoint_user_name=default_account_privilege.account_name,
            source_endpoint_password=default_rds_account.account_password,
            backup_objects=default_database.name.apply(lambda name: f"[{{\\"DBName\\":\\"{name}\\"}}]"),
            backup_period="Monday",
            backup_start_time="14:22",
            backup_storage_type="system",
            backup_retention_period=740)
        ```

        ## Import

        DBS Backup Plan can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:dbs/backupPlan:BackupPlan example <id>
        ```

        :param str resource_name: The name of the resource.
        :param BackupPlanArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BackupPlanArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_log_interval_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 backup_method: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_objects: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_period: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_plan_name: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_rate_limit: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_retention_period: Optional[pulumi.Input[_builtins.int]] = None,
                 backup_speed_limit: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_start_time: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_storage_type: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_strategy_type: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_aliyun_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 database_region: Optional[pulumi.Input[_builtins.str]] = None,
                 database_type: Optional[pulumi.Input[_builtins.str]] = None,
                 duplication_archive_period: Optional[pulumi.Input[_builtins.int]] = None,
                 duplication_infrequent_access_period: Optional[pulumi.Input[_builtins.int]] = None,
                 enable_backup_log: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_class: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 oss_bucket_name: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_oracle_sid: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_password: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_port: Optional[pulumi.Input[_builtins.int]] = None,
                 source_endpoint_region: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_sid: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_user_name: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_region: Optional[pulumi.Input[_builtins.str]] = None,
                 used_time: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BackupPlanArgs.__new__(BackupPlanArgs)

            __props__.__dict__["backup_gateway_id"] = backup_gateway_id
            __props__.__dict__["backup_log_interval_seconds"] = backup_log_interval_seconds
            if backup_method is None and not opts.urn:
                raise TypeError("Missing required property 'backup_method'")
            __props__.__dict__["backup_method"] = backup_method
            __props__.__dict__["backup_objects"] = backup_objects
            __props__.__dict__["backup_period"] = backup_period
            if backup_plan_name is None and not opts.urn:
                raise TypeError("Missing required property 'backup_plan_name'")
            __props__.__dict__["backup_plan_name"] = backup_plan_name
            __props__.__dict__["backup_rate_limit"] = backup_rate_limit
            __props__.__dict__["backup_retention_period"] = backup_retention_period
            __props__.__dict__["backup_speed_limit"] = backup_speed_limit
            __props__.__dict__["backup_start_time"] = backup_start_time
            __props__.__dict__["backup_storage_type"] = backup_storage_type
            __props__.__dict__["backup_strategy_type"] = backup_strategy_type
            __props__.__dict__["cross_aliyun_id"] = cross_aliyun_id
            __props__.__dict__["cross_role_name"] = cross_role_name
            __props__.__dict__["database_region"] = database_region
            if database_type is None and not opts.urn:
                raise TypeError("Missing required property 'database_type'")
            __props__.__dict__["database_type"] = database_type
            __props__.__dict__["duplication_archive_period"] = duplication_archive_period
            __props__.__dict__["duplication_infrequent_access_period"] = duplication_infrequent_access_period
            __props__.__dict__["enable_backup_log"] = enable_backup_log
            if instance_class is None and not opts.urn:
                raise TypeError("Missing required property 'instance_class'")
            __props__.__dict__["instance_class"] = instance_class
            __props__.__dict__["instance_type"] = instance_type
            __props__.__dict__["oss_bucket_name"] = oss_bucket_name
            __props__.__dict__["payment_type"] = payment_type
            __props__.__dict__["period"] = period
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["source_endpoint_database_name"] = source_endpoint_database_name
            __props__.__dict__["source_endpoint_instance_id"] = source_endpoint_instance_id
            if source_endpoint_instance_type is None and not opts.urn:
                raise TypeError("Missing required property 'source_endpoint_instance_type'")
            __props__.__dict__["source_endpoint_instance_type"] = source_endpoint_instance_type
            __props__.__dict__["source_endpoint_ip"] = source_endpoint_ip
            __props__.__dict__["source_endpoint_oracle_sid"] = source_endpoint_oracle_sid
            __props__.__dict__["source_endpoint_password"] = None if source_endpoint_password is None else pulumi.Output.secret(source_endpoint_password)
            __props__.__dict__["source_endpoint_port"] = source_endpoint_port
            __props__.__dict__["source_endpoint_region"] = source_endpoint_region
            __props__.__dict__["source_endpoint_sid"] = source_endpoint_sid
            __props__.__dict__["source_endpoint_user_name"] = source_endpoint_user_name
            __props__.__dict__["status"] = status
            __props__.__dict__["storage_region"] = storage_region
            __props__.__dict__["used_time"] = used_time
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["sourceEndpointPassword"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(BackupPlan, __self__).__init__(
            'alicloud:dbs/backupPlan:BackupPlan',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            backup_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
            backup_log_interval_seconds: Optional[pulumi.Input[_builtins.int]] = None,
            backup_method: Optional[pulumi.Input[_builtins.str]] = None,
            backup_objects: Optional[pulumi.Input[_builtins.str]] = None,
            backup_period: Optional[pulumi.Input[_builtins.str]] = None,
            backup_plan_name: Optional[pulumi.Input[_builtins.str]] = None,
            backup_rate_limit: Optional[pulumi.Input[_builtins.str]] = None,
            backup_retention_period: Optional[pulumi.Input[_builtins.int]] = None,
            backup_speed_limit: Optional[pulumi.Input[_builtins.str]] = None,
            backup_start_time: Optional[pulumi.Input[_builtins.str]] = None,
            backup_storage_type: Optional[pulumi.Input[_builtins.str]] = None,
            backup_strategy_type: Optional[pulumi.Input[_builtins.str]] = None,
            cross_aliyun_id: Optional[pulumi.Input[_builtins.str]] = None,
            cross_role_name: Optional[pulumi.Input[_builtins.str]] = None,
            database_region: Optional[pulumi.Input[_builtins.str]] = None,
            database_type: Optional[pulumi.Input[_builtins.str]] = None,
            duplication_archive_period: Optional[pulumi.Input[_builtins.int]] = None,
            duplication_infrequent_access_period: Optional[pulumi.Input[_builtins.int]] = None,
            enable_backup_log: Optional[pulumi.Input[_builtins.bool]] = None,
            instance_class: Optional[pulumi.Input[_builtins.str]] = None,
            instance_type: Optional[pulumi.Input[_builtins.str]] = None,
            oss_bucket_name: Optional[pulumi.Input[_builtins.str]] = None,
            payment_type: Optional[pulumi.Input[_builtins.str]] = None,
            period: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            source_endpoint_database_name: Optional[pulumi.Input[_builtins.str]] = None,
            source_endpoint_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            source_endpoint_instance_type: Optional[pulumi.Input[_builtins.str]] = None,
            source_endpoint_ip: Optional[pulumi.Input[_builtins.str]] = None,
            source_endpoint_oracle_sid: Optional[pulumi.Input[_builtins.str]] = None,
            source_endpoint_password: Optional[pulumi.Input[_builtins.str]] = None,
            source_endpoint_port: Optional[pulumi.Input[_builtins.int]] = None,
            source_endpoint_region: Optional[pulumi.Input[_builtins.str]] = None,
            source_endpoint_sid: Optional[pulumi.Input[_builtins.str]] = None,
            source_endpoint_user_name: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            storage_region: Optional[pulumi.Input[_builtins.str]] = None,
            used_time: Optional[pulumi.Input[_builtins.int]] = None) -> 'BackupPlan':
        """
        Get an existing BackupPlan resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] backup_gateway_id: The ID of the backup gateway. This parameter is required when the `source_endpoint_instance_type` is `Agent`.
        :param pulumi.Input[_builtins.int] backup_log_interval_seconds: The backup log interval seconds.
        :param pulumi.Input[_builtins.str] backup_method: Backup method. Valid values: `duplication`, `logical`, `physical`.
        :param pulumi.Input[_builtins.str] backup_objects: The backup object.
        :param pulumi.Input[_builtins.str] backup_period: Full backup cycle, Valid values: `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday`, `Saturday`, `Sunday`. supports the selection of multiple fetch values, separated by English commas (,).
        :param pulumi.Input[_builtins.str] backup_plan_name: The name of the resource.
        :param pulumi.Input[_builtins.str] backup_rate_limit: The backup rate limit.
        :param pulumi.Input[_builtins.int] backup_retention_period: The retention time of backup data. Valid values: 0 to 1825. Default value: 730 days.
        :param pulumi.Input[_builtins.str] backup_speed_limit: The backup speed limit.
        :param pulumi.Input[_builtins.str] backup_start_time: The start time of full Backup. The format is `<I> HH:mm</I>` Z(UTC time).
        :param pulumi.Input[_builtins.str] backup_storage_type: Built-in storage type, Valid values: `system`.
        :param pulumi.Input[_builtins.str] backup_strategy_type: The backup strategy type. Valid values: `simple`, `manual`.
        :param pulumi.Input[_builtins.str] cross_aliyun_id: The UID that is backed up across Alibaba cloud accounts.
        :param pulumi.Input[_builtins.str] cross_role_name: The name of the RAM role that is backed up across Alibaba cloud accounts.
        :param pulumi.Input[_builtins.str] database_region: The database region.
        :param pulumi.Input[_builtins.str] database_type: Database type. Valid values: `DRDS`, `FIle`, `MSSQL`, `MariaDB`, `MongoDB`, `MySQL`, `Oracle`, `PPAS`, `PostgreSQL`, `Redis`.
        :param pulumi.Input[_builtins.int] duplication_archive_period: The storage time for conversion to archive cold standby is 365 days by default.
        :param pulumi.Input[_builtins.int] duplication_infrequent_access_period: The storage time is converted to low-frequency access. The default time is 180 days.
        :param pulumi.Input[_builtins.bool] enable_backup_log: Whether to enable incremental log Backup.
        :param pulumi.Input[_builtins.str] instance_class: The instance class. Valid values: `large`, `medium`, `micro`, `small`, `xlarge`.
        :param pulumi.Input[_builtins.str] instance_type: The instance type. Valid values: `RDS`, `PolarDB`, `DDS`, `Kvstore`, `Other`.
        :param pulumi.Input[_builtins.str] oss_bucket_name: The OSS Bucket name. The system automatically generates a new name by default.
        :param pulumi.Input[_builtins.str] payment_type: The payment type of the resource. Valid values: `PayAsYouGo`, `Subscription`.
        :param pulumi.Input[_builtins.str] period: Specify that the prepaid instance is of the package year or monthly type. Valid values: `Month`, `Year`.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[_builtins.str] source_endpoint_database_name: The name of the database. This parameter is required when the `database_type` is `PostgreSQL` or `MongoDB`.
        :param pulumi.Input[_builtins.str] source_endpoint_instance_id: The ID of the database instance. This parameter is required when the `source_endpoint_instance_type` is `RDS`, `ECS`, `DDS`, or `Express`.
        :param pulumi.Input[_builtins.str] source_endpoint_instance_type: The location of the database. Valid values: `RDS`, `ECS`, `Express`, `Agent`, `DDS`, `Other`.
        :param pulumi.Input[_builtins.str] source_endpoint_ip: The source endpoint ip.
        :param pulumi.Input[_builtins.str] source_endpoint_oracle_sid: Oracle SID name. This parameter is required when the `database_type` is `Oracle`.
        :param pulumi.Input[_builtins.str] source_endpoint_password: The source endpoint password.  This parameter is not required when the `database_type` is `Redis`, or when the `source_endpoint_instance_type` is `Agent` and the `database_type` is `MSSQL`. This parameter is required in other scenarios.
        :param pulumi.Input[_builtins.int] source_endpoint_port: The source endpoint port.
        :param pulumi.Input[_builtins.str] source_endpoint_region: The region of the database. This parameter is required when the `source_endpoint_instance_type` is `RDS`, `ECS`, `DDS`, `Express`, or `Agent`.
        :param pulumi.Input[_builtins.str] source_endpoint_sid: Oracle SID name. This parameter is required when the `database_type` is `Oracle`.
        :param pulumi.Input[_builtins.str] source_endpoint_user_name: The source endpoint username. This parameter is not required when the `database_type` is `Redis`, or when the `source_endpoint_instance_type` is `Agent` and the `database_type` is `MSSQL`. This parameter is required in other scenarios.
        :param pulumi.Input[_builtins.str] status: The status of the resource. Valid values: `pause`, `running`.
        :param pulumi.Input[_builtins.str] storage_region: The storage region.
        :param pulumi.Input[_builtins.int] used_time: Specify purchase duration. When the parameter `period` is `Year`, the `used_time` value is 1 to 9. When the parameter `period` is `Month`, the `used_time` value is 1 to 11.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BackupPlanState.__new__(_BackupPlanState)

        __props__.__dict__["backup_gateway_id"] = backup_gateway_id
        __props__.__dict__["backup_log_interval_seconds"] = backup_log_interval_seconds
        __props__.__dict__["backup_method"] = backup_method
        __props__.__dict__["backup_objects"] = backup_objects
        __props__.__dict__["backup_period"] = backup_period
        __props__.__dict__["backup_plan_name"] = backup_plan_name
        __props__.__dict__["backup_rate_limit"] = backup_rate_limit
        __props__.__dict__["backup_retention_period"] = backup_retention_period
        __props__.__dict__["backup_speed_limit"] = backup_speed_limit
        __props__.__dict__["backup_start_time"] = backup_start_time
        __props__.__dict__["backup_storage_type"] = backup_storage_type
        __props__.__dict__["backup_strategy_type"] = backup_strategy_type
        __props__.__dict__["cross_aliyun_id"] = cross_aliyun_id
        __props__.__dict__["cross_role_name"] = cross_role_name
        __props__.__dict__["database_region"] = database_region
        __props__.__dict__["database_type"] = database_type
        __props__.__dict__["duplication_archive_period"] = duplication_archive_period
        __props__.__dict__["duplication_infrequent_access_period"] = duplication_infrequent_access_period
        __props__.__dict__["enable_backup_log"] = enable_backup_log
        __props__.__dict__["instance_class"] = instance_class
        __props__.__dict__["instance_type"] = instance_type
        __props__.__dict__["oss_bucket_name"] = oss_bucket_name
        __props__.__dict__["payment_type"] = payment_type
        __props__.__dict__["period"] = period
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["source_endpoint_database_name"] = source_endpoint_database_name
        __props__.__dict__["source_endpoint_instance_id"] = source_endpoint_instance_id
        __props__.__dict__["source_endpoint_instance_type"] = source_endpoint_instance_type
        __props__.__dict__["source_endpoint_ip"] = source_endpoint_ip
        __props__.__dict__["source_endpoint_oracle_sid"] = source_endpoint_oracle_sid
        __props__.__dict__["source_endpoint_password"] = source_endpoint_password
        __props__.__dict__["source_endpoint_port"] = source_endpoint_port
        __props__.__dict__["source_endpoint_region"] = source_endpoint_region
        __props__.__dict__["source_endpoint_sid"] = source_endpoint_sid
        __props__.__dict__["source_endpoint_user_name"] = source_endpoint_user_name
        __props__.__dict__["status"] = status
        __props__.__dict__["storage_region"] = storage_region
        __props__.__dict__["used_time"] = used_time
        return BackupPlan(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="backupGatewayId")
    def backup_gateway_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the backup gateway. This parameter is required when the `source_endpoint_instance_type` is `Agent`.
        """
        return pulumi.get(self, "backup_gateway_id")

    @_builtins.property
    @pulumi.getter(name="backupLogIntervalSeconds")
    def backup_log_interval_seconds(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The backup log interval seconds.
        """
        return pulumi.get(self, "backup_log_interval_seconds")

    @_builtins.property
    @pulumi.getter(name="backupMethod")
    def backup_method(self) -> pulumi.Output[_builtins.str]:
        """
        Backup method. Valid values: `duplication`, `logical`, `physical`.
        """
        return pulumi.get(self, "backup_method")

    @_builtins.property
    @pulumi.getter(name="backupObjects")
    def backup_objects(self) -> pulumi.Output[_builtins.str]:
        """
        The backup object.
        """
        return pulumi.get(self, "backup_objects")

    @_builtins.property
    @pulumi.getter(name="backupPeriod")
    def backup_period(self) -> pulumi.Output[_builtins.str]:
        """
        Full backup cycle, Valid values: `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday`, `Saturday`, `Sunday`. supports the selection of multiple fetch values, separated by English commas (,).
        """
        return pulumi.get(self, "backup_period")

    @_builtins.property
    @pulumi.getter(name="backupPlanName")
    def backup_plan_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the resource.
        """
        return pulumi.get(self, "backup_plan_name")

    @_builtins.property
    @pulumi.getter(name="backupRateLimit")
    def backup_rate_limit(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The backup rate limit.
        """
        return pulumi.get(self, "backup_rate_limit")

    @_builtins.property
    @pulumi.getter(name="backupRetentionPeriod")
    def backup_retention_period(self) -> pulumi.Output[_builtins.int]:
        """
        The retention time of backup data. Valid values: 0 to 1825. Default value: 730 days.
        """
        return pulumi.get(self, "backup_retention_period")

    @_builtins.property
    @pulumi.getter(name="backupSpeedLimit")
    def backup_speed_limit(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The backup speed limit.
        """
        return pulumi.get(self, "backup_speed_limit")

    @_builtins.property
    @pulumi.getter(name="backupStartTime")
    def backup_start_time(self) -> pulumi.Output[_builtins.str]:
        """
        The start time of full Backup. The format is `<I> HH:mm</I>` Z(UTC time).
        """
        return pulumi.get(self, "backup_start_time")

    @_builtins.property
    @pulumi.getter(name="backupStorageType")
    def backup_storage_type(self) -> pulumi.Output[_builtins.str]:
        """
        Built-in storage type, Valid values: `system`.
        """
        return pulumi.get(self, "backup_storage_type")

    @_builtins.property
    @pulumi.getter(name="backupStrategyType")
    def backup_strategy_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The backup strategy type. Valid values: `simple`, `manual`.
        """
        return pulumi.get(self, "backup_strategy_type")

    @_builtins.property
    @pulumi.getter(name="crossAliyunId")
    def cross_aliyun_id(self) -> pulumi.Output[_builtins.str]:
        """
        The UID that is backed up across Alibaba cloud accounts.
        """
        return pulumi.get(self, "cross_aliyun_id")

    @_builtins.property
    @pulumi.getter(name="crossRoleName")
    def cross_role_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the RAM role that is backed up across Alibaba cloud accounts.
        """
        return pulumi.get(self, "cross_role_name")

    @_builtins.property
    @pulumi.getter(name="databaseRegion")
    def database_region(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The database region.
        """
        return pulumi.get(self, "database_region")

    @_builtins.property
    @pulumi.getter(name="databaseType")
    def database_type(self) -> pulumi.Output[_builtins.str]:
        """
        Database type. Valid values: `DRDS`, `FIle`, `MSSQL`, `MariaDB`, `MongoDB`, `MySQL`, `Oracle`, `PPAS`, `PostgreSQL`, `Redis`.
        """
        return pulumi.get(self, "database_type")

    @_builtins.property
    @pulumi.getter(name="duplicationArchivePeriod")
    def duplication_archive_period(self) -> pulumi.Output[_builtins.int]:
        """
        The storage time for conversion to archive cold standby is 365 days by default.
        """
        return pulumi.get(self, "duplication_archive_period")

    @_builtins.property
    @pulumi.getter(name="duplicationInfrequentAccessPeriod")
    def duplication_infrequent_access_period(self) -> pulumi.Output[_builtins.int]:
        """
        The storage time is converted to low-frequency access. The default time is 180 days.
        """
        return pulumi.get(self, "duplication_infrequent_access_period")

    @_builtins.property
    @pulumi.getter(name="enableBackupLog")
    def enable_backup_log(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether to enable incremental log Backup.
        """
        return pulumi.get(self, "enable_backup_log")

    @_builtins.property
    @pulumi.getter(name="instanceClass")
    def instance_class(self) -> pulumi.Output[_builtins.str]:
        """
        The instance class. Valid values: `large`, `medium`, `micro`, `small`, `xlarge`.
        """
        return pulumi.get(self, "instance_class")

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The instance type. Valid values: `RDS`, `PolarDB`, `DDS`, `Kvstore`, `Other`.
        """
        return pulumi.get(self, "instance_type")

    @_builtins.property
    @pulumi.getter(name="ossBucketName")
    def oss_bucket_name(self) -> pulumi.Output[_builtins.str]:
        """
        The OSS Bucket name. The system automatically generates a new name by default.
        """
        return pulumi.get(self, "oss_bucket_name")

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Output[_builtins.str]:
        """
        The payment type of the resource. Valid values: `PayAsYouGo`, `Subscription`.
        """
        return pulumi.get(self, "payment_type")

    @_builtins.property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specify that the prepaid instance is of the package year or monthly type. Valid values: `Month`, `Year`.
        """
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="sourceEndpointDatabaseName")
    def source_endpoint_database_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the database. This parameter is required when the `database_type` is `PostgreSQL` or `MongoDB`.
        """
        return pulumi.get(self, "source_endpoint_database_name")

    @_builtins.property
    @pulumi.getter(name="sourceEndpointInstanceId")
    def source_endpoint_instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the database instance. This parameter is required when the `source_endpoint_instance_type` is `RDS`, `ECS`, `DDS`, or `Express`.
        """
        return pulumi.get(self, "source_endpoint_instance_id")

    @_builtins.property
    @pulumi.getter(name="sourceEndpointInstanceType")
    def source_endpoint_instance_type(self) -> pulumi.Output[_builtins.str]:
        """
        The location of the database. Valid values: `RDS`, `ECS`, `Express`, `Agent`, `DDS`, `Other`.
        """
        return pulumi.get(self, "source_endpoint_instance_type")

    @_builtins.property
    @pulumi.getter(name="sourceEndpointIp")
    def source_endpoint_ip(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The source endpoint ip.
        """
        return pulumi.get(self, "source_endpoint_ip")

    @_builtins.property
    @pulumi.getter(name="sourceEndpointOracleSid")
    def source_endpoint_oracle_sid(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Oracle SID name. This parameter is required when the `database_type` is `Oracle`.
        """
        return pulumi.get(self, "source_endpoint_oracle_sid")

    @_builtins.property
    @pulumi.getter(name="sourceEndpointPassword")
    def source_endpoint_password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The source endpoint password.  This parameter is not required when the `database_type` is `Redis`, or when the `source_endpoint_instance_type` is `Agent` and the `database_type` is `MSSQL`. This parameter is required in other scenarios.
        """
        return pulumi.get(self, "source_endpoint_password")

    @_builtins.property
    @pulumi.getter(name="sourceEndpointPort")
    def source_endpoint_port(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The source endpoint port.
        """
        return pulumi.get(self, "source_endpoint_port")

    @_builtins.property
    @pulumi.getter(name="sourceEndpointRegion")
    def source_endpoint_region(self) -> pulumi.Output[_builtins.str]:
        """
        The region of the database. This parameter is required when the `source_endpoint_instance_type` is `RDS`, `ECS`, `DDS`, `Express`, or `Agent`.
        """
        return pulumi.get(self, "source_endpoint_region")

    @_builtins.property
    @pulumi.getter(name="sourceEndpointSid")
    def source_endpoint_sid(self) -> pulumi.Output[_builtins.str]:
        """
        Oracle SID name. This parameter is required when the `database_type` is `Oracle`.
        """
        return pulumi.get(self, "source_endpoint_sid")

    @_builtins.property
    @pulumi.getter(name="sourceEndpointUserName")
    def source_endpoint_user_name(self) -> pulumi.Output[_builtins.str]:
        """
        The source endpoint username. This parameter is not required when the `database_type` is `Redis`, or when the `source_endpoint_instance_type` is `Agent` and the `database_type` is `MSSQL`. This parameter is required in other scenarios.
        """
        return pulumi.get(self, "source_endpoint_user_name")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the resource. Valid values: `pause`, `running`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="storageRegion")
    def storage_region(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The storage region.
        """
        return pulumi.get(self, "storage_region")

    @_builtins.property
    @pulumi.getter(name="usedTime")
    def used_time(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Specify purchase duration. When the parameter `period` is `Year`, the `used_time` value is 1 to 9. When the parameter `period` is `Month`, the `used_time` value is 1 to 11.
        """
        return pulumi.get(self, "used_time")

