# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'VscMountPointInstance',
    'VscMountPointInstanceVsc',
    'GetAccessGroupsGroupResult',
    'GetAccessRulesRuleResult',
    'GetFileSystemsSystemResult',
    'GetMountPointsPointResult',
    'GetZonesZoneResult',
    'GetZonesZoneOptionResult',
]

@pulumi.output_type
class VscMountPointInstance(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceId":
            suggest = "instance_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VscMountPointInstance. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VscMountPointInstance.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VscMountPointInstance.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_id: Optional[_builtins.str] = None,
                 status: Optional[_builtins.str] = None,
                 vscs: Optional[Sequence['outputs.VscMountPointInstanceVsc']] = None):
        """
        :param _builtins.str instance_id: The ID of the ECS instance to which the HDFS file system is mounted.
        :param _builtins.str status: The status of the ECS instance on which the HDFS file system is mounted.
        :param Sequence['VscMountPointInstanceVscArgs'] vscs: The VSC list of mounted HDFS file systems.
        """
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if vscs is not None:
            pulumi.set(__self__, "vscs", vscs)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[_builtins.str]:
        """
        The ID of the ECS instance to which the HDFS file system is mounted.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        The status of the ECS instance on which the HDFS file system is mounted.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def vscs(self) -> Optional[Sequence['outputs.VscMountPointInstanceVsc']]:
        """
        The VSC list of mounted HDFS file systems.
        """
        return pulumi.get(self, "vscs")


@pulumi.output_type
class VscMountPointInstanceVsc(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "vscId":
            suggest = "vsc_id"
        elif key == "vscStatus":
            suggest = "vsc_status"
        elif key == "vscType":
            suggest = "vsc_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VscMountPointInstanceVsc. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VscMountPointInstanceVsc.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VscMountPointInstanceVsc.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 vsc_id: Optional[_builtins.str] = None,
                 vsc_status: Optional[_builtins.str] = None,
                 vsc_type: Optional[_builtins.str] = None):
        """
        :param _builtins.str vsc_id: VSC Channel primary key representation, used to retrieve the specified VSC Channel.
        :param _builtins.str vsc_status: VSC Mount status.
        :param _builtins.str vsc_type: The VSC type.
        """
        if vsc_id is not None:
            pulumi.set(__self__, "vsc_id", vsc_id)
        if vsc_status is not None:
            pulumi.set(__self__, "vsc_status", vsc_status)
        if vsc_type is not None:
            pulumi.set(__self__, "vsc_type", vsc_type)

    @_builtins.property
    @pulumi.getter(name="vscId")
    def vsc_id(self) -> Optional[_builtins.str]:
        """
        VSC Channel primary key representation, used to retrieve the specified VSC Channel.
        """
        return pulumi.get(self, "vsc_id")

    @_builtins.property
    @pulumi.getter(name="vscStatus")
    def vsc_status(self) -> Optional[_builtins.str]:
        """
        VSC Mount status.
        """
        return pulumi.get(self, "vsc_status")

    @_builtins.property
    @pulumi.getter(name="vscType")
    def vsc_type(self) -> Optional[_builtins.str]:
        """
        The VSC type.
        """
        return pulumi.get(self, "vsc_type")


@pulumi.output_type
class GetAccessGroupsGroupResult(dict):
    def __init__(__self__, *,
                 access_group_id: _builtins.str,
                 access_group_name: _builtins.str,
                 create_time: _builtins.str,
                 description: _builtins.str,
                 id: _builtins.str,
                 mount_point_count: _builtins.int,
                 network_type: _builtins.str,
                 rule_count: _builtins.int):
        """
        :param _builtins.str access_group_id: The length of `description` does not exceed 100 bytes.
        :param _builtins.str access_group_name: The Name of Access Group. The length Of `access_group_name` does not exceed 100 bytes.
        :param _builtins.str create_time: The CreateTime of Access Group.
        :param _builtins.str description: The Description of Access Group. The length Of `description` does not exceed 100 bytes.
        :param _builtins.str id: The ID of the Access Group.
        :param _builtins.int mount_point_count: The Number of attached mountpoint.
        :param _builtins.str network_type: The NetworkType of Access Group. Valid values: `VPC`.
        :param _builtins.int rule_count: The Number of access rule.
        """
        pulumi.set(__self__, "access_group_id", access_group_id)
        pulumi.set(__self__, "access_group_name", access_group_name)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "mount_point_count", mount_point_count)
        pulumi.set(__self__, "network_type", network_type)
        pulumi.set(__self__, "rule_count", rule_count)

    @_builtins.property
    @pulumi.getter(name="accessGroupId")
    def access_group_id(self) -> _builtins.str:
        """
        The length of `description` does not exceed 100 bytes.
        """
        return pulumi.get(self, "access_group_id")

    @_builtins.property
    @pulumi.getter(name="accessGroupName")
    def access_group_name(self) -> _builtins.str:
        """
        The Name of Access Group. The length Of `access_group_name` does not exceed 100 bytes.
        """
        return pulumi.get(self, "access_group_name")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The CreateTime of Access Group.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The Description of Access Group. The length Of `description` does not exceed 100 bytes.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Access Group.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="mountPointCount")
    def mount_point_count(self) -> _builtins.int:
        """
        The Number of attached mountpoint.
        """
        return pulumi.get(self, "mount_point_count")

    @_builtins.property
    @pulumi.getter(name="networkType")
    def network_type(self) -> _builtins.str:
        """
        The NetworkType of Access Group. Valid values: `VPC`.
        """
        return pulumi.get(self, "network_type")

    @_builtins.property
    @pulumi.getter(name="ruleCount")
    def rule_count(self) -> _builtins.int:
        """
        The Number of access rule.
        """
        return pulumi.get(self, "rule_count")


@pulumi.output_type
class GetAccessRulesRuleResult(dict):
    def __init__(__self__, *,
                 access_group_id: _builtins.str,
                 access_rule_id: _builtins.str,
                 create_time: _builtins.str,
                 description: _builtins.str,
                 id: _builtins.str,
                 network_segment: _builtins.str,
                 priority: _builtins.int,
                 rw_access_type: _builtins.str):
        """
        :param _builtins.str access_group_id: The resource ID of the Access Group.
        :param _builtins.str access_rule_id: The ID of the Access Rule.
        :param _builtins.str create_time: The created time of the Access Rule.
        :param _builtins.str description: The description of the Access Rule.
        :param _builtins.str id: The resource ID of Access Rule.
        :param _builtins.str network_segment: The NetworkSegment of the Access Rule.
        :param _builtins.int priority: The priority of the Access Rule.
        :param _builtins.str rw_access_type: RWAccessType of the Access Rule. Valid values: `RDONLY`, `RDWR`.
        """
        pulumi.set(__self__, "access_group_id", access_group_id)
        pulumi.set(__self__, "access_rule_id", access_rule_id)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "network_segment", network_segment)
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "rw_access_type", rw_access_type)

    @_builtins.property
    @pulumi.getter(name="accessGroupId")
    def access_group_id(self) -> _builtins.str:
        """
        The resource ID of the Access Group.
        """
        return pulumi.get(self, "access_group_id")

    @_builtins.property
    @pulumi.getter(name="accessRuleId")
    def access_rule_id(self) -> _builtins.str:
        """
        The ID of the Access Rule.
        """
        return pulumi.get(self, "access_rule_id")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The created time of the Access Rule.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the Access Rule.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The resource ID of Access Rule.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="networkSegment")
    def network_segment(self) -> _builtins.str:
        """
        The NetworkSegment of the Access Rule.
        """
        return pulumi.get(self, "network_segment")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> _builtins.int:
        """
        The priority of the Access Rule.
        """
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter(name="rwAccessType")
    def rw_access_type(self) -> _builtins.str:
        """
        RWAccessType of the Access Rule. Valid values: `RDONLY`, `RDWR`.
        """
        return pulumi.get(self, "rw_access_type")


@pulumi.output_type
class GetFileSystemsSystemResult(dict):
    def __init__(__self__, *,
                 create_time: _builtins.str,
                 description: _builtins.str,
                 file_system_id: _builtins.str,
                 file_system_name: _builtins.str,
                 id: _builtins.str,
                 mount_point_count: _builtins.int,
                 number_of_directories: _builtins.int,
                 number_of_files: _builtins.int,
                 protocol_type: _builtins.str,
                 provisioned_throughput_in_mi_bps: _builtins.int,
                 space_capacity: _builtins.int,
                 storage_package_id: _builtins.str,
                 storage_type: _builtins.str,
                 throughput_mode: _builtins.str,
                 used_space_size: _builtins.float,
                 zone_id: _builtins.str):
        """
        :param _builtins.str create_time: The creation time of the File system.
        :param _builtins.str description: The description of the File system.
        :param _builtins.str file_system_id: The ID of the File System.
        :param _builtins.str file_system_name: The name of the File system.
        :param _builtins.str id: The ID of the File System.
        :param _builtins.int mount_point_count: The number of Mount points.
        :param _builtins.int number_of_directories: The number of directories.
        :param _builtins.int number_of_files: The number of files.
        :param _builtins.str protocol_type: The protocol type. Valid values: `HDFS`.
        :param _builtins.int provisioned_throughput_in_mi_bps: The preset throughput of the File system. Valid values: `1` to `1024`, Unit: MB/s.
        :param _builtins.int space_capacity: The capacity budget of the File system.
        :param _builtins.str storage_package_id: Storage package Id.
        :param _builtins.str storage_type: The storage specifications of the File system. Valid values: `PERFORMANCE`, `STANDARD`.
        :param _builtins.str throughput_mode: The throughput mode of the File system. Valid values: `Provisioned`, `Standard`.
        :param _builtins.float used_space_size: The used space of the File system.
        :param _builtins.str zone_id: The zone ID of the File system.
        """
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "file_system_id", file_system_id)
        pulumi.set(__self__, "file_system_name", file_system_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "mount_point_count", mount_point_count)
        pulumi.set(__self__, "number_of_directories", number_of_directories)
        pulumi.set(__self__, "number_of_files", number_of_files)
        pulumi.set(__self__, "protocol_type", protocol_type)
        pulumi.set(__self__, "provisioned_throughput_in_mi_bps", provisioned_throughput_in_mi_bps)
        pulumi.set(__self__, "space_capacity", space_capacity)
        pulumi.set(__self__, "storage_package_id", storage_package_id)
        pulumi.set(__self__, "storage_type", storage_type)
        pulumi.set(__self__, "throughput_mode", throughput_mode)
        pulumi.set(__self__, "used_space_size", used_space_size)
        pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The creation time of the File system.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the File system.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> _builtins.str:
        """
        The ID of the File System.
        """
        return pulumi.get(self, "file_system_id")

    @_builtins.property
    @pulumi.getter(name="fileSystemName")
    def file_system_name(self) -> _builtins.str:
        """
        The name of the File system.
        """
        return pulumi.get(self, "file_system_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the File System.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="mountPointCount")
    def mount_point_count(self) -> _builtins.int:
        """
        The number of Mount points.
        """
        return pulumi.get(self, "mount_point_count")

    @_builtins.property
    @pulumi.getter(name="numberOfDirectories")
    def number_of_directories(self) -> _builtins.int:
        """
        The number of directories.
        """
        return pulumi.get(self, "number_of_directories")

    @_builtins.property
    @pulumi.getter(name="numberOfFiles")
    def number_of_files(self) -> _builtins.int:
        """
        The number of files.
        """
        return pulumi.get(self, "number_of_files")

    @_builtins.property
    @pulumi.getter(name="protocolType")
    def protocol_type(self) -> _builtins.str:
        """
        The protocol type. Valid values: `HDFS`.
        """
        return pulumi.get(self, "protocol_type")

    @_builtins.property
    @pulumi.getter(name="provisionedThroughputInMiBps")
    def provisioned_throughput_in_mi_bps(self) -> _builtins.int:
        """
        The preset throughput of the File system. Valid values: `1` to `1024`, Unit: MB/s.
        """
        return pulumi.get(self, "provisioned_throughput_in_mi_bps")

    @_builtins.property
    @pulumi.getter(name="spaceCapacity")
    def space_capacity(self) -> _builtins.int:
        """
        The capacity budget of the File system.
        """
        return pulumi.get(self, "space_capacity")

    @_builtins.property
    @pulumi.getter(name="storagePackageId")
    def storage_package_id(self) -> _builtins.str:
        """
        Storage package Id.
        """
        return pulumi.get(self, "storage_package_id")

    @_builtins.property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> _builtins.str:
        """
        The storage specifications of the File system. Valid values: `PERFORMANCE`, `STANDARD`.
        """
        return pulumi.get(self, "storage_type")

    @_builtins.property
    @pulumi.getter(name="throughputMode")
    def throughput_mode(self) -> _builtins.str:
        """
        The throughput mode of the File system. Valid values: `Provisioned`, `Standard`.
        """
        return pulumi.get(self, "throughput_mode")

    @_builtins.property
    @pulumi.getter(name="usedSpaceSize")
    def used_space_size(self) -> _builtins.float:
        """
        The used space of the File system.
        """
        return pulumi.get(self, "used_space_size")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> _builtins.str:
        """
        The zone ID of the File system.
        """
        return pulumi.get(self, "zone_id")


@pulumi.output_type
class GetMountPointsPointResult(dict):
    def __init__(__self__, *,
                 access_group_id: _builtins.str,
                 create_time: _builtins.str,
                 description: _builtins.str,
                 file_system_id: _builtins.str,
                 id: _builtins.str,
                 mount_point_domain: _builtins.str,
                 mount_point_id: _builtins.str,
                 network_type: _builtins.str,
                 status: _builtins.str,
                 vpc_id: _builtins.str,
                 vswitch_id: _builtins.str):
        """
        :param _builtins.str access_group_id: The ID of the Access Group.
        :param _builtins.str create_time: The created time of the Mount Point.
        :param _builtins.str description: The description of the Mount Point.
        :param _builtins.str file_system_id: The ID of the File System.
        :param _builtins.str id: The ID of the Mount Point.
        :param _builtins.str mount_point_domain: The domain name of the Mount Point.
        :param _builtins.str mount_point_id: The ID of the Mount Point.
        :param _builtins.str network_type: The network type of the Mount Point. Valid values: `VPC`.
        :param _builtins.str status: The status of the Mount Point. Valid values: `Active`, `Inactive`.
        :param _builtins.str vpc_id: The ID of the VPC network.
        :param _builtins.str vswitch_id: The vswitch id.
        """
        pulumi.set(__self__, "access_group_id", access_group_id)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "file_system_id", file_system_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "mount_point_domain", mount_point_domain)
        pulumi.set(__self__, "mount_point_id", mount_point_id)
        pulumi.set(__self__, "network_type", network_type)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vswitch_id", vswitch_id)

    @_builtins.property
    @pulumi.getter(name="accessGroupId")
    def access_group_id(self) -> _builtins.str:
        """
        The ID of the Access Group.
        """
        return pulumi.get(self, "access_group_id")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The created time of the Mount Point.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the Mount Point.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> _builtins.str:
        """
        The ID of the File System.
        """
        return pulumi.get(self, "file_system_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Mount Point.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="mountPointDomain")
    def mount_point_domain(self) -> _builtins.str:
        """
        The domain name of the Mount Point.
        """
        return pulumi.get(self, "mount_point_domain")

    @_builtins.property
    @pulumi.getter(name="mountPointId")
    def mount_point_id(self) -> _builtins.str:
        """
        The ID of the Mount Point.
        """
        return pulumi.get(self, "mount_point_id")

    @_builtins.property
    @pulumi.getter(name="networkType")
    def network_type(self) -> _builtins.str:
        """
        The network type of the Mount Point. Valid values: `VPC`.
        """
        return pulumi.get(self, "network_type")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the Mount Point. Valid values: `Active`, `Inactive`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> _builtins.str:
        """
        The ID of the VPC network.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> _builtins.str:
        """
        The vswitch id.
        """
        return pulumi.get(self, "vswitch_id")


@pulumi.output_type
class GetZonesZoneResult(dict):
    def __init__(__self__, *,
                 options: Sequence['outputs.GetZonesZoneOptionResult'],
                 zone_id: _builtins.str):
        """
        :param Sequence['GetZonesZoneOptionArgs'] options: A list of available configurations of the Zone.
        :param _builtins.str zone_id: The zone ID.
        """
        pulumi.set(__self__, "options", options)
        pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter
    def options(self) -> Sequence['outputs.GetZonesZoneOptionResult']:
        """
        A list of available configurations of the Zone.
        """
        return pulumi.get(self, "options")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> _builtins.str:
        """
        The zone ID.
        """
        return pulumi.get(self, "zone_id")


@pulumi.output_type
class GetZonesZoneOptionResult(dict):
    def __init__(__self__, *,
                 protocol_type: _builtins.str,
                 storage_type: _builtins.str):
        """
        :param _builtins.str protocol_type: The protocol type. Valid values: `HDFS`.
        :param _builtins.str storage_type: The storage specifications of the File system. Valid values: `PERFORMANCE`, `STANDARD`.
        """
        pulumi.set(__self__, "protocol_type", protocol_type)
        pulumi.set(__self__, "storage_type", storage_type)

    @_builtins.property
    @pulumi.getter(name="protocolType")
    def protocol_type(self) -> _builtins.str:
        """
        The protocol type. Valid values: `HDFS`.
        """
        return pulumi.get(self, "protocol_type")

    @_builtins.property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> _builtins.str:
        """
        The storage specifications of the File system. Valid values: `PERFORMANCE`, `STANDARD`.
        """
        return pulumi.get(self, "storage_type")


