# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['InstanceArgs', 'Instance']

@pulumi.input_type
class InstanceArgs:
    def __init__(__self__, *,
                 auto_pay: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_start: Optional[pulumi.Input[_builtins.bool]] = None,
                 compute_unit: Optional[pulumi.Input[_builtins.int]] = None,
                 database_count: Optional[pulumi.Input[_builtins.int]] = None,
                 destination_endpoint_engine_name: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_region: Optional[pulumi.Input[_builtins.str]] = None,
                 du: Optional[pulumi.Input[_builtins.int]] = None,
                 fee_type: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_class: Optional[pulumi.Input[_builtins.str]] = None,
                 job_id: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_engine_name: Optional[pulumi.Input[_builtins.str]] = None,
                 source_region: Optional[pulumi.Input[_builtins.str]] = None,
                 sync_architecture: Optional[pulumi.Input[_builtins.str]] = None,
                 synchronization_direction: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 used_time: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a Instance resource.
        :param pulumi.Input[_builtins.bool] auto_pay: Whether to automatically renew the fee when it expires. Valid values:
               - **false**: No, the default value.
               - **true**: Yes.
        :param pulumi.Input[_builtins.bool] auto_start: Whether to start the task automatically after the purchase is completed. Value:
               - **false**: No, the default value.
               - **true**: Yes.
        :param pulumi.Input[_builtins.int] compute_unit: Specifications of ETL. The unit is compute unit (CU),1CU = 1vCPU +4GB of memory. The value range is an integer greater than or equal to 2. **NOTE:** Enter this parameter and enable ETL to clean and convert data.
        :param pulumi.Input[_builtins.int] database_count: The number of private custom RDS instances in the PolarDB-X. The default value is **1**. **NOTE:** This parameter is required only when **source_endpoint_engine_name** is **DRDS**.
        :param pulumi.Input[_builtins.str] destination_endpoint_engine_name: The target database engine type.
               - **MySQL**:MySQL databases (including RDS MySQL and self-built MySQL).
               - **PolarDB**:PolarDB MySQL.
               - **polardb_o**:PolarDB O engine.
               - **polardb_pg**:PolarDB PostgreSQL.
               - **Redis**:Redis databases (including apsaradb for Redis and user-created Redis).
               - **DRDS**: cloud-native distributed database PolarDB-X 1.0 and 2.0.
               - **PostgreSQL**: User-created PostgreSQL.
               - **ODPS**:MaxCompute project.
               - **oracle**: self-built Oracle.
               - **mongodb**:MongoDB databases (including apsaradb for MongoDB and user-created MongoDB).
               - **tidb**:TiDB database.
               - **ADS**: Cloud native data warehouse AnalyticDB MySQL 2.0.
               - **ADB30**: Cloud native data warehouse AnalyticDB MySQL 3.0.
               - **Greenplum**: Cloud native data warehouse AnalyticDB PostgreSQL.
               - **MSSQL**:SQL Server databases (including RDS SQL Server and self-built SQL Server).
               - **kafka**:Kafka databases (including Kafka and self-built Kafka).
               - **DataHub**: DataHub, an Alibaba cloud streaming data service.
               - **clickhouse**: ClickHouse.
               - **DB2**: self-built DB2 LUW.
               - **as400**:AS/400.
               - **Tablestore**: Tablestore.
               - **NOTE:**
               - The default value is **MySQL**.
               - For more information about the supported source and destination databases, see [Database, Synchronization Initialization Type, and Synchronization Topology](https://www.alibabacloud.com/help/en/data-transmission-service/latest/overview-of-data-synchronization-scenarios-1) and [Supported Database and Migration Type](https://www.alibabacloud.com/help/en/data-transmission-service/latest/overview-of-data-migration-scenarios).
               - This parameter or **job_id** must be passed in.
        :param pulumi.Input[_builtins.str] destination_region: The target instance region. For more information, see [List of supported regions](https://www.alibabacloud.com/help/en/data-transmission-service/latest/list-of-supported-regions). **NOTE:** This parameter or **job_id** must be passed in.
        :param pulumi.Input[_builtins.int] du: Assign a specified number of DU resources to DTS tasks in the DTS exclusive cluster. Valid values: **1** ~ **100**. **NOTE:** The value of this parameter must be within the range of the number of DUs available for the DTS dedicated cluster.
        :param pulumi.Input[_builtins.str] fee_type: Subscription billing type, Valid values: `ONLY_CONFIGURATION_FEE`: charges only configuration fees; `CONFIGURATION_FEE_AND_DATA_FEE`: charges configuration fees and data traffic fees.
        :param pulumi.Input[_builtins.str] instance_class: The type of the migration or synchronization instance.
               - The specifications of the migration instance: **xxlarge**, **xlarge**, **large**, **medium**, **small**.
               - The types of synchronization instances: **large**, **medium**, **small**, **micro**.
               - **NOTE:** For performance descriptions of different specifications, see [Data Migration Link Specifications](https://www.alibabacloud.com/help/en/data-transmission-service/latest/cd773b) and [Data Synchronization Link Specifications](https://www.alibabacloud.com/help/en/data-transmission-service/latest/6bce7c).
        :param pulumi.Input[_builtins.str] job_id: The ID of the task obtained by calling the **ConfigureDtsJob** operation (**DtsJobId**).> After you pass in this parameter, you do not need to pass the **source_region**, **destination_region**, **type**, **source_endpoint_engine_name**, or **destination_endpoint_engine_name** parameters. Even if the input is passed in, the configuration in **job_id** shall prevail.
        :param pulumi.Input[_builtins.str] payment_type: The payment type of the resource. Valid values: `Subscription`, `PayAsYouGo`.
        :param pulumi.Input[_builtins.str] period: The billing method of the subscription instance. Value: `Year`, `Month`. **NOTE:** This parameter is valid and must be passed in only when `payment_type` is `Subscription`.
        :param pulumi.Input[_builtins.str] resource_group_id: Resource Group ID.
        :param pulumi.Input[_builtins.str] source_endpoint_engine_name: Source instance database engine type.
               - **MySQL**:MySQL databases (including RDS MySQL and self-built MySQL).
               - **PolarDB**:PolarDB MySQL.
               - **polardb_o**:PolarDB O engine.
               - **polardb_pg**:PolarDB PostgreSQL.
               - **Redis**:Redis databases (including apsaradb for Redis and user-created Redis).
               - **DRDS**: cloud-native distributed database PolarDB-X 1.0 and 2.0.
               - **PostgreSQL**: User-created PostgreSQL.
               - **ODPS**:MaxCompute.
               - **oracle**: self-built Oracle.
               - **mongodb**:MongoDB databases (including apsaradb for MongoDB and user-created MongoDB).
               - **tidb**:TiDB database.
               - **ADS**: Cloud native data warehouse AnalyticDB MySQL 2.0.
               - **ADB30**: Cloud native data warehouse AnalyticDB MySQL 3.0.
               - **Greenplum**: Cloud native data warehouse AnalyticDB PostgreSQL.
               - **MSSQL**:SQL Server databases (including RDS SQL Server and self-built SQL Server).
               - **kafka**:Kafka databases (including Kafka and self-built Kafka).
               - **DataHub**: DataHub, an Alibaba cloud streaming data service.
               - **clickhouse**: ClickHouse.
               - **DB2**: self-built DB2 LUW.
               - **as400**:AS/400.
               - **Tablestore**: Tablestore.
               - **NOTE:**
               - The default value is **MySQL**.
               - For more information about the supported source and destination databases, see [Database, Synchronization Initialization Type, and Synchronization Topology](https://www.alibabacloud.com/help/en/data-transmission-service/latest/overview-of-data-synchronization-scenarios-1) and [Supported Database and Migration Type](https://www.alibabacloud.com/help/en/data-transmission-service/latest/overview-of-data-migration-scenarios).
               - This parameter or **job_id** must be passed in.
        :param pulumi.Input[_builtins.str] source_region: The source instance region. For more information, see [List of supported regions](https://www.alibabacloud.com/help/en/data-transmission-service/latest/list-of-supported-regions). **NOTE:** This parameter or **job_id** must be passed in.
        :param pulumi.Input[_builtins.str] sync_architecture: Synchronization topology, value:
               - **oneway**: one-way synchronization, the default value.
               - **bidirectional**: two-way synchronization.
        :param pulumi.Input[_builtins.str] synchronization_direction: The synchronization direction. Default value: `Forward`. Valid values:
               - `Forward`: Data is synchronized from the source database to the destination database.
               - `Reverse`: Data is synchronized from the destination database to the source database.
               - **NOTE:** You can set this parameter to Reverse to delete the reverse synchronization task only if the topology is two-way synchronization.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag value corresponding to the tag key.See the following `Block Tags`.
        :param pulumi.Input[_builtins.str] type: The instance type. Valid values:
               - **migration**: MIGRATION.
               - **sync**: synchronization.
               - **subscribe**: SUBSCRIBE.
               - **NOTE:** This parameter or **job_id** must be passed in.
        :param pulumi.Input[_builtins.int] used_time: Prepaid instance purchase duration.
               - When **period** is **Month**, the values are: 1, 2, 3, 4, 5, 6, 7, 8, and 9.
               - When **Period** is **Year**, the values are 1, 2, 3, and 5.
               - **NOTE:**
               - This parameter is valid and must be passed in only when **payment_type** is `Subscription`.
               - The billing method of the subscription instance. You can set the parameter `period`.
        """
        if auto_pay is not None:
            pulumi.set(__self__, "auto_pay", auto_pay)
        if auto_start is not None:
            pulumi.set(__self__, "auto_start", auto_start)
        if compute_unit is not None:
            pulumi.set(__self__, "compute_unit", compute_unit)
        if database_count is not None:
            pulumi.set(__self__, "database_count", database_count)
        if destination_endpoint_engine_name is not None:
            pulumi.set(__self__, "destination_endpoint_engine_name", destination_endpoint_engine_name)
        if destination_region is not None:
            pulumi.set(__self__, "destination_region", destination_region)
        if du is not None:
            pulumi.set(__self__, "du", du)
        if fee_type is not None:
            pulumi.set(__self__, "fee_type", fee_type)
        if instance_class is not None:
            pulumi.set(__self__, "instance_class", instance_class)
        if job_id is not None:
            pulumi.set(__self__, "job_id", job_id)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if source_endpoint_engine_name is not None:
            pulumi.set(__self__, "source_endpoint_engine_name", source_endpoint_engine_name)
        if source_region is not None:
            pulumi.set(__self__, "source_region", source_region)
        if sync_architecture is not None:
            pulumi.set(__self__, "sync_architecture", sync_architecture)
        if synchronization_direction is not None:
            pulumi.set(__self__, "synchronization_direction", synchronization_direction)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if used_time is not None:
            pulumi.set(__self__, "used_time", used_time)

    @_builtins.property
    @pulumi.getter(name="autoPay")
    def auto_pay(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to automatically renew the fee when it expires. Valid values:
        - **false**: No, the default value.
        - **true**: Yes.
        """
        return pulumi.get(self, "auto_pay")

    @auto_pay.setter
    def auto_pay(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_pay", value)

    @_builtins.property
    @pulumi.getter(name="autoStart")
    def auto_start(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to start the task automatically after the purchase is completed. Value:
        - **false**: No, the default value.
        - **true**: Yes.
        """
        return pulumi.get(self, "auto_start")

    @auto_start.setter
    def auto_start(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_start", value)

    @_builtins.property
    @pulumi.getter(name="computeUnit")
    def compute_unit(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifications of ETL. The unit is compute unit (CU),1CU = 1vCPU +4GB of memory. The value range is an integer greater than or equal to 2. **NOTE:** Enter this parameter and enable ETL to clean and convert data.
        """
        return pulumi.get(self, "compute_unit")

    @compute_unit.setter
    def compute_unit(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "compute_unit", value)

    @_builtins.property
    @pulumi.getter(name="databaseCount")
    def database_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of private custom RDS instances in the PolarDB-X. The default value is **1**. **NOTE:** This parameter is required only when **source_endpoint_engine_name** is **DRDS**.
        """
        return pulumi.get(self, "database_count")

    @database_count.setter
    def database_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "database_count", value)

    @_builtins.property
    @pulumi.getter(name="destinationEndpointEngineName")
    def destination_endpoint_engine_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The target database engine type.
        - **MySQL**:MySQL databases (including RDS MySQL and self-built MySQL).
        - **PolarDB**:PolarDB MySQL.
        - **polardb_o**:PolarDB O engine.
        - **polardb_pg**:PolarDB PostgreSQL.
        - **Redis**:Redis databases (including apsaradb for Redis and user-created Redis).
        - **DRDS**: cloud-native distributed database PolarDB-X 1.0 and 2.0.
        - **PostgreSQL**: User-created PostgreSQL.
        - **ODPS**:MaxCompute project.
        - **oracle**: self-built Oracle.
        - **mongodb**:MongoDB databases (including apsaradb for MongoDB and user-created MongoDB).
        - **tidb**:TiDB database.
        - **ADS**: Cloud native data warehouse AnalyticDB MySQL 2.0.
        - **ADB30**: Cloud native data warehouse AnalyticDB MySQL 3.0.
        - **Greenplum**: Cloud native data warehouse AnalyticDB PostgreSQL.
        - **MSSQL**:SQL Server databases (including RDS SQL Server and self-built SQL Server).
        - **kafka**:Kafka databases (including Kafka and self-built Kafka).
        - **DataHub**: DataHub, an Alibaba cloud streaming data service.
        - **clickhouse**: ClickHouse.
        - **DB2**: self-built DB2 LUW.
        - **as400**:AS/400.
        - **Tablestore**: Tablestore.
        - **NOTE:**
        - The default value is **MySQL**.
        - For more information about the supported source and destination databases, see [Database, Synchronization Initialization Type, and Synchronization Topology](https://www.alibabacloud.com/help/en/data-transmission-service/latest/overview-of-data-synchronization-scenarios-1) and [Supported Database and Migration Type](https://www.alibabacloud.com/help/en/data-transmission-service/latest/overview-of-data-migration-scenarios).
        - This parameter or **job_id** must be passed in.
        """
        return pulumi.get(self, "destination_endpoint_engine_name")

    @destination_endpoint_engine_name.setter
    def destination_endpoint_engine_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "destination_endpoint_engine_name", value)

    @_builtins.property
    @pulumi.getter(name="destinationRegion")
    def destination_region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The target instance region. For more information, see [List of supported regions](https://www.alibabacloud.com/help/en/data-transmission-service/latest/list-of-supported-regions). **NOTE:** This parameter or **job_id** must be passed in.
        """
        return pulumi.get(self, "destination_region")

    @destination_region.setter
    def destination_region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "destination_region", value)

    @_builtins.property
    @pulumi.getter
    def du(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Assign a specified number of DU resources to DTS tasks in the DTS exclusive cluster. Valid values: **1** ~ **100**. **NOTE:** The value of this parameter must be within the range of the number of DUs available for the DTS dedicated cluster.
        """
        return pulumi.get(self, "du")

    @du.setter
    def du(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "du", value)

    @_builtins.property
    @pulumi.getter(name="feeType")
    def fee_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Subscription billing type, Valid values: `ONLY_CONFIGURATION_FEE`: charges only configuration fees; `CONFIGURATION_FEE_AND_DATA_FEE`: charges configuration fees and data traffic fees.
        """
        return pulumi.get(self, "fee_type")

    @fee_type.setter
    def fee_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fee_type", value)

    @_builtins.property
    @pulumi.getter(name="instanceClass")
    def instance_class(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the migration or synchronization instance.
        - The specifications of the migration instance: **xxlarge**, **xlarge**, **large**, **medium**, **small**.
        - The types of synchronization instances: **large**, **medium**, **small**, **micro**.
        - **NOTE:** For performance descriptions of different specifications, see [Data Migration Link Specifications](https://www.alibabacloud.com/help/en/data-transmission-service/latest/cd773b) and [Data Synchronization Link Specifications](https://www.alibabacloud.com/help/en/data-transmission-service/latest/6bce7c).
        """
        return pulumi.get(self, "instance_class")

    @instance_class.setter
    def instance_class(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_class", value)

    @_builtins.property
    @pulumi.getter(name="jobId")
    def job_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the task obtained by calling the **ConfigureDtsJob** operation (**DtsJobId**).> After you pass in this parameter, you do not need to pass the **source_region**, **destination_region**, **type**, **source_endpoint_engine_name**, or **destination_endpoint_engine_name** parameters. Even if the input is passed in, the configuration in **job_id** shall prevail.
        """
        return pulumi.get(self, "job_id")

    @job_id.setter
    def job_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "job_id", value)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The payment type of the resource. Valid values: `Subscription`, `PayAsYouGo`.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The billing method of the subscription instance. Value: `Year`, `Month`. **NOTE:** This parameter is valid and must be passed in only when `payment_type` is `Subscription`.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource Group ID.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="sourceEndpointEngineName")
    def source_endpoint_engine_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Source instance database engine type.
        - **MySQL**:MySQL databases (including RDS MySQL and self-built MySQL).
        - **PolarDB**:PolarDB MySQL.
        - **polardb_o**:PolarDB O engine.
        - **polardb_pg**:PolarDB PostgreSQL.
        - **Redis**:Redis databases (including apsaradb for Redis and user-created Redis).
        - **DRDS**: cloud-native distributed database PolarDB-X 1.0 and 2.0.
        - **PostgreSQL**: User-created PostgreSQL.
        - **ODPS**:MaxCompute.
        - **oracle**: self-built Oracle.
        - **mongodb**:MongoDB databases (including apsaradb for MongoDB and user-created MongoDB).
        - **tidb**:TiDB database.
        - **ADS**: Cloud native data warehouse AnalyticDB MySQL 2.0.
        - **ADB30**: Cloud native data warehouse AnalyticDB MySQL 3.0.
        - **Greenplum**: Cloud native data warehouse AnalyticDB PostgreSQL.
        - **MSSQL**:SQL Server databases (including RDS SQL Server and self-built SQL Server).
        - **kafka**:Kafka databases (including Kafka and self-built Kafka).
        - **DataHub**: DataHub, an Alibaba cloud streaming data service.
        - **clickhouse**: ClickHouse.
        - **DB2**: self-built DB2 LUW.
        - **as400**:AS/400.
        - **Tablestore**: Tablestore.
        - **NOTE:**
        - The default value is **MySQL**.
        - For more information about the supported source and destination databases, see [Database, Synchronization Initialization Type, and Synchronization Topology](https://www.alibabacloud.com/help/en/data-transmission-service/latest/overview-of-data-synchronization-scenarios-1) and [Supported Database and Migration Type](https://www.alibabacloud.com/help/en/data-transmission-service/latest/overview-of-data-migration-scenarios).
        - This parameter or **job_id** must be passed in.
        """
        return pulumi.get(self, "source_endpoint_engine_name")

    @source_endpoint_engine_name.setter
    def source_endpoint_engine_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_endpoint_engine_name", value)

    @_builtins.property
    @pulumi.getter(name="sourceRegion")
    def source_region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The source instance region. For more information, see [List of supported regions](https://www.alibabacloud.com/help/en/data-transmission-service/latest/list-of-supported-regions). **NOTE:** This parameter or **job_id** must be passed in.
        """
        return pulumi.get(self, "source_region")

    @source_region.setter
    def source_region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_region", value)

    @_builtins.property
    @pulumi.getter(name="syncArchitecture")
    def sync_architecture(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Synchronization topology, value:
        - **oneway**: one-way synchronization, the default value.
        - **bidirectional**: two-way synchronization.
        """
        return pulumi.get(self, "sync_architecture")

    @sync_architecture.setter
    def sync_architecture(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sync_architecture", value)

    @_builtins.property
    @pulumi.getter(name="synchronizationDirection")
    def synchronization_direction(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The synchronization direction. Default value: `Forward`. Valid values:
        - `Forward`: Data is synchronized from the source database to the destination database.
        - `Reverse`: Data is synchronized from the destination database to the source database.
        - **NOTE:** You can set this parameter to Reverse to delete the reverse synchronization task only if the topology is two-way synchronization.
        """
        return pulumi.get(self, "synchronization_direction")

    @synchronization_direction.setter
    def synchronization_direction(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "synchronization_direction", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tag value corresponding to the tag key.See the following `Block Tags`.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The instance type. Valid values:
        - **migration**: MIGRATION.
        - **sync**: synchronization.
        - **subscribe**: SUBSCRIBE.
        - **NOTE:** This parameter or **job_id** must be passed in.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="usedTime")
    def used_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Prepaid instance purchase duration.
        - When **period** is **Month**, the values are: 1, 2, 3, 4, 5, 6, 7, 8, and 9.
        - When **Period** is **Year**, the values are 1, 2, 3, and 5.
        - **NOTE:**
        - This parameter is valid and must be passed in only when **payment_type** is `Subscription`.
        - The billing method of the subscription instance. You can set the parameter `period`.
        """
        return pulumi.get(self, "used_time")

    @used_time.setter
    def used_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "used_time", value)


@pulumi.input_type
class _InstanceState:
    def __init__(__self__, *,
                 auto_pay: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_start: Optional[pulumi.Input[_builtins.bool]] = None,
                 compute_unit: Optional[pulumi.Input[_builtins.int]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 database_count: Optional[pulumi.Input[_builtins.int]] = None,
                 destination_endpoint_engine_name: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_region: Optional[pulumi.Input[_builtins.str]] = None,
                 dts_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 du: Optional[pulumi.Input[_builtins.int]] = None,
                 fee_type: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_class: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 job_id: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_engine_name: Optional[pulumi.Input[_builtins.str]] = None,
                 source_region: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 sync_architecture: Optional[pulumi.Input[_builtins.str]] = None,
                 synchronization_direction: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 used_time: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering Instance resources.
        :param pulumi.Input[_builtins.bool] auto_pay: Whether to automatically renew the fee when it expires. Valid values:
               - **false**: No, the default value.
               - **true**: Yes.
        :param pulumi.Input[_builtins.bool] auto_start: Whether to start the task automatically after the purchase is completed. Value:
               - **false**: No, the default value.
               - **true**: Yes.
        :param pulumi.Input[_builtins.int] compute_unit: Specifications of ETL. The unit is compute unit (CU),1CU = 1vCPU +4GB of memory. The value range is an integer greater than or equal to 2. **NOTE:** Enter this parameter and enable ETL to clean and convert data.
        :param pulumi.Input[_builtins.str] create_time: Instance creation time
        :param pulumi.Input[_builtins.int] database_count: The number of private custom RDS instances in the PolarDB-X. The default value is **1**. **NOTE:** This parameter is required only when **source_endpoint_engine_name** is **DRDS**.
        :param pulumi.Input[_builtins.str] destination_endpoint_engine_name: The target database engine type.
               - **MySQL**:MySQL databases (including RDS MySQL and self-built MySQL).
               - **PolarDB**:PolarDB MySQL.
               - **polardb_o**:PolarDB O engine.
               - **polardb_pg**:PolarDB PostgreSQL.
               - **Redis**:Redis databases (including apsaradb for Redis and user-created Redis).
               - **DRDS**: cloud-native distributed database PolarDB-X 1.0 and 2.0.
               - **PostgreSQL**: User-created PostgreSQL.
               - **ODPS**:MaxCompute project.
               - **oracle**: self-built Oracle.
               - **mongodb**:MongoDB databases (including apsaradb for MongoDB and user-created MongoDB).
               - **tidb**:TiDB database.
               - **ADS**: Cloud native data warehouse AnalyticDB MySQL 2.0.
               - **ADB30**: Cloud native data warehouse AnalyticDB MySQL 3.0.
               - **Greenplum**: Cloud native data warehouse AnalyticDB PostgreSQL.
               - **MSSQL**:SQL Server databases (including RDS SQL Server and self-built SQL Server).
               - **kafka**:Kafka databases (including Kafka and self-built Kafka).
               - **DataHub**: DataHub, an Alibaba cloud streaming data service.
               - **clickhouse**: ClickHouse.
               - **DB2**: self-built DB2 LUW.
               - **as400**:AS/400.
               - **Tablestore**: Tablestore.
               - **NOTE:**
               - The default value is **MySQL**.
               - For more information about the supported source and destination databases, see [Database, Synchronization Initialization Type, and Synchronization Topology](https://www.alibabacloud.com/help/en/data-transmission-service/latest/overview-of-data-synchronization-scenarios-1) and [Supported Database and Migration Type](https://www.alibabacloud.com/help/en/data-transmission-service/latest/overview-of-data-migration-scenarios).
               - This parameter or **job_id** must be passed in.
        :param pulumi.Input[_builtins.str] destination_region: The target instance region. For more information, see [List of supported regions](https://www.alibabacloud.com/help/en/data-transmission-service/latest/list-of-supported-regions). **NOTE:** This parameter or **job_id** must be passed in.
        :param pulumi.Input[_builtins.str] dts_instance_id: The ID of the subscription instance.
        :param pulumi.Input[_builtins.int] du: Assign a specified number of DU resources to DTS tasks in the DTS exclusive cluster. Valid values: **1** ~ **100**. **NOTE:** The value of this parameter must be within the range of the number of DUs available for the DTS dedicated cluster.
        :param pulumi.Input[_builtins.str] fee_type: Subscription billing type, Valid values: `ONLY_CONFIGURATION_FEE`: charges only configuration fees; `CONFIGURATION_FEE_AND_DATA_FEE`: charges configuration fees and data traffic fees.
        :param pulumi.Input[_builtins.str] instance_class: The type of the migration or synchronization instance.
               - The specifications of the migration instance: **xxlarge**, **xlarge**, **large**, **medium**, **small**.
               - The types of synchronization instances: **large**, **medium**, **small**, **micro**.
               - **NOTE:** For performance descriptions of different specifications, see [Data Migration Link Specifications](https://www.alibabacloud.com/help/en/data-transmission-service/latest/cd773b) and [Data Synchronization Link Specifications](https://www.alibabacloud.com/help/en/data-transmission-service/latest/6bce7c).
        :param pulumi.Input[_builtins.str] instance_name: The name of Dts instance.
        :param pulumi.Input[_builtins.str] job_id: The ID of the task obtained by calling the **ConfigureDtsJob** operation (**DtsJobId**).> After you pass in this parameter, you do not need to pass the **source_region**, **destination_region**, **type**, **source_endpoint_engine_name**, or **destination_endpoint_engine_name** parameters. Even if the input is passed in, the configuration in **job_id** shall prevail.
        :param pulumi.Input[_builtins.str] payment_type: The payment type of the resource. Valid values: `Subscription`, `PayAsYouGo`.
        :param pulumi.Input[_builtins.str] period: The billing method of the subscription instance. Value: `Year`, `Month`. **NOTE:** This parameter is valid and must be passed in only when `payment_type` is `Subscription`.
        :param pulumi.Input[_builtins.str] resource_group_id: Resource Group ID.
        :param pulumi.Input[_builtins.str] source_endpoint_engine_name: Source instance database engine type.
               - **MySQL**:MySQL databases (including RDS MySQL and self-built MySQL).
               - **PolarDB**:PolarDB MySQL.
               - **polardb_o**:PolarDB O engine.
               - **polardb_pg**:PolarDB PostgreSQL.
               - **Redis**:Redis databases (including apsaradb for Redis and user-created Redis).
               - **DRDS**: cloud-native distributed database PolarDB-X 1.0 and 2.0.
               - **PostgreSQL**: User-created PostgreSQL.
               - **ODPS**:MaxCompute.
               - **oracle**: self-built Oracle.
               - **mongodb**:MongoDB databases (including apsaradb for MongoDB and user-created MongoDB).
               - **tidb**:TiDB database.
               - **ADS**: Cloud native data warehouse AnalyticDB MySQL 2.0.
               - **ADB30**: Cloud native data warehouse AnalyticDB MySQL 3.0.
               - **Greenplum**: Cloud native data warehouse AnalyticDB PostgreSQL.
               - **MSSQL**:SQL Server databases (including RDS SQL Server and self-built SQL Server).
               - **kafka**:Kafka databases (including Kafka and self-built Kafka).
               - **DataHub**: DataHub, an Alibaba cloud streaming data service.
               - **clickhouse**: ClickHouse.
               - **DB2**: self-built DB2 LUW.
               - **as400**:AS/400.
               - **Tablestore**: Tablestore.
               - **NOTE:**
               - The default value is **MySQL**.
               - For more information about the supported source and destination databases, see [Database, Synchronization Initialization Type, and Synchronization Topology](https://www.alibabacloud.com/help/en/data-transmission-service/latest/overview-of-data-synchronization-scenarios-1) and [Supported Database and Migration Type](https://www.alibabacloud.com/help/en/data-transmission-service/latest/overview-of-data-migration-scenarios).
               - This parameter or **job_id** must be passed in.
        :param pulumi.Input[_builtins.str] source_region: The source instance region. For more information, see [List of supported regions](https://www.alibabacloud.com/help/en/data-transmission-service/latest/list-of-supported-regions). **NOTE:** This parameter or **job_id** must be passed in.
        :param pulumi.Input[_builtins.str] status: Instance status.
        :param pulumi.Input[_builtins.str] sync_architecture: Synchronization topology, value:
               - **oneway**: one-way synchronization, the default value.
               - **bidirectional**: two-way synchronization.
        :param pulumi.Input[_builtins.str] synchronization_direction: The synchronization direction. Default value: `Forward`. Valid values:
               - `Forward`: Data is synchronized from the source database to the destination database.
               - `Reverse`: Data is synchronized from the destination database to the source database.
               - **NOTE:** You can set this parameter to Reverse to delete the reverse synchronization task only if the topology is two-way synchronization.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag value corresponding to the tag key.See the following `Block Tags`.
        :param pulumi.Input[_builtins.str] type: The instance type. Valid values:
               - **migration**: MIGRATION.
               - **sync**: synchronization.
               - **subscribe**: SUBSCRIBE.
               - **NOTE:** This parameter or **job_id** must be passed in.
        :param pulumi.Input[_builtins.int] used_time: Prepaid instance purchase duration.
               - When **period** is **Month**, the values are: 1, 2, 3, 4, 5, 6, 7, 8, and 9.
               - When **Period** is **Year**, the values are 1, 2, 3, and 5.
               - **NOTE:**
               - This parameter is valid and must be passed in only when **payment_type** is `Subscription`.
               - The billing method of the subscription instance. You can set the parameter `period`.
        """
        if auto_pay is not None:
            pulumi.set(__self__, "auto_pay", auto_pay)
        if auto_start is not None:
            pulumi.set(__self__, "auto_start", auto_start)
        if compute_unit is not None:
            pulumi.set(__self__, "compute_unit", compute_unit)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if database_count is not None:
            pulumi.set(__self__, "database_count", database_count)
        if destination_endpoint_engine_name is not None:
            pulumi.set(__self__, "destination_endpoint_engine_name", destination_endpoint_engine_name)
        if destination_region is not None:
            pulumi.set(__self__, "destination_region", destination_region)
        if dts_instance_id is not None:
            pulumi.set(__self__, "dts_instance_id", dts_instance_id)
        if du is not None:
            pulumi.set(__self__, "du", du)
        if fee_type is not None:
            pulumi.set(__self__, "fee_type", fee_type)
        if instance_class is not None:
            pulumi.set(__self__, "instance_class", instance_class)
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if job_id is not None:
            pulumi.set(__self__, "job_id", job_id)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if source_endpoint_engine_name is not None:
            pulumi.set(__self__, "source_endpoint_engine_name", source_endpoint_engine_name)
        if source_region is not None:
            pulumi.set(__self__, "source_region", source_region)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if sync_architecture is not None:
            pulumi.set(__self__, "sync_architecture", sync_architecture)
        if synchronization_direction is not None:
            pulumi.set(__self__, "synchronization_direction", synchronization_direction)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if used_time is not None:
            pulumi.set(__self__, "used_time", used_time)

    @_builtins.property
    @pulumi.getter(name="autoPay")
    def auto_pay(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to automatically renew the fee when it expires. Valid values:
        - **false**: No, the default value.
        - **true**: Yes.
        """
        return pulumi.get(self, "auto_pay")

    @auto_pay.setter
    def auto_pay(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_pay", value)

    @_builtins.property
    @pulumi.getter(name="autoStart")
    def auto_start(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to start the task automatically after the purchase is completed. Value:
        - **false**: No, the default value.
        - **true**: Yes.
        """
        return pulumi.get(self, "auto_start")

    @auto_start.setter
    def auto_start(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_start", value)

    @_builtins.property
    @pulumi.getter(name="computeUnit")
    def compute_unit(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifications of ETL. The unit is compute unit (CU),1CU = 1vCPU +4GB of memory. The value range is an integer greater than or equal to 2. **NOTE:** Enter this parameter and enable ETL to clean and convert data.
        """
        return pulumi.get(self, "compute_unit")

    @compute_unit.setter
    def compute_unit(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "compute_unit", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instance creation time
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="databaseCount")
    def database_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of private custom RDS instances in the PolarDB-X. The default value is **1**. **NOTE:** This parameter is required only when **source_endpoint_engine_name** is **DRDS**.
        """
        return pulumi.get(self, "database_count")

    @database_count.setter
    def database_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "database_count", value)

    @_builtins.property
    @pulumi.getter(name="destinationEndpointEngineName")
    def destination_endpoint_engine_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The target database engine type.
        - **MySQL**:MySQL databases (including RDS MySQL and self-built MySQL).
        - **PolarDB**:PolarDB MySQL.
        - **polardb_o**:PolarDB O engine.
        - **polardb_pg**:PolarDB PostgreSQL.
        - **Redis**:Redis databases (including apsaradb for Redis and user-created Redis).
        - **DRDS**: cloud-native distributed database PolarDB-X 1.0 and 2.0.
        - **PostgreSQL**: User-created PostgreSQL.
        - **ODPS**:MaxCompute project.
        - **oracle**: self-built Oracle.
        - **mongodb**:MongoDB databases (including apsaradb for MongoDB and user-created MongoDB).
        - **tidb**:TiDB database.
        - **ADS**: Cloud native data warehouse AnalyticDB MySQL 2.0.
        - **ADB30**: Cloud native data warehouse AnalyticDB MySQL 3.0.
        - **Greenplum**: Cloud native data warehouse AnalyticDB PostgreSQL.
        - **MSSQL**:SQL Server databases (including RDS SQL Server and self-built SQL Server).
        - **kafka**:Kafka databases (including Kafka and self-built Kafka).
        - **DataHub**: DataHub, an Alibaba cloud streaming data service.
        - **clickhouse**: ClickHouse.
        - **DB2**: self-built DB2 LUW.
        - **as400**:AS/400.
        - **Tablestore**: Tablestore.
        - **NOTE:**
        - The default value is **MySQL**.
        - For more information about the supported source and destination databases, see [Database, Synchronization Initialization Type, and Synchronization Topology](https://www.alibabacloud.com/help/en/data-transmission-service/latest/overview-of-data-synchronization-scenarios-1) and [Supported Database and Migration Type](https://www.alibabacloud.com/help/en/data-transmission-service/latest/overview-of-data-migration-scenarios).
        - This parameter or **job_id** must be passed in.
        """
        return pulumi.get(self, "destination_endpoint_engine_name")

    @destination_endpoint_engine_name.setter
    def destination_endpoint_engine_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "destination_endpoint_engine_name", value)

    @_builtins.property
    @pulumi.getter(name="destinationRegion")
    def destination_region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The target instance region. For more information, see [List of supported regions](https://www.alibabacloud.com/help/en/data-transmission-service/latest/list-of-supported-regions). **NOTE:** This parameter or **job_id** must be passed in.
        """
        return pulumi.get(self, "destination_region")

    @destination_region.setter
    def destination_region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "destination_region", value)

    @_builtins.property
    @pulumi.getter(name="dtsInstanceId")
    def dts_instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the subscription instance.
        """
        return pulumi.get(self, "dts_instance_id")

    @dts_instance_id.setter
    def dts_instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dts_instance_id", value)

    @_builtins.property
    @pulumi.getter
    def du(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Assign a specified number of DU resources to DTS tasks in the DTS exclusive cluster. Valid values: **1** ~ **100**. **NOTE:** The value of this parameter must be within the range of the number of DUs available for the DTS dedicated cluster.
        """
        return pulumi.get(self, "du")

    @du.setter
    def du(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "du", value)

    @_builtins.property
    @pulumi.getter(name="feeType")
    def fee_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Subscription billing type, Valid values: `ONLY_CONFIGURATION_FEE`: charges only configuration fees; `CONFIGURATION_FEE_AND_DATA_FEE`: charges configuration fees and data traffic fees.
        """
        return pulumi.get(self, "fee_type")

    @fee_type.setter
    def fee_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fee_type", value)

    @_builtins.property
    @pulumi.getter(name="instanceClass")
    def instance_class(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the migration or synchronization instance.
        - The specifications of the migration instance: **xxlarge**, **xlarge**, **large**, **medium**, **small**.
        - The types of synchronization instances: **large**, **medium**, **small**, **micro**.
        - **NOTE:** For performance descriptions of different specifications, see [Data Migration Link Specifications](https://www.alibabacloud.com/help/en/data-transmission-service/latest/cd773b) and [Data Synchronization Link Specifications](https://www.alibabacloud.com/help/en/data-transmission-service/latest/6bce7c).
        """
        return pulumi.get(self, "instance_class")

    @instance_class.setter
    def instance_class(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_class", value)

    @_builtins.property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of Dts instance.
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_name", value)

    @_builtins.property
    @pulumi.getter(name="jobId")
    def job_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the task obtained by calling the **ConfigureDtsJob** operation (**DtsJobId**).> After you pass in this parameter, you do not need to pass the **source_region**, **destination_region**, **type**, **source_endpoint_engine_name**, or **destination_endpoint_engine_name** parameters. Even if the input is passed in, the configuration in **job_id** shall prevail.
        """
        return pulumi.get(self, "job_id")

    @job_id.setter
    def job_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "job_id", value)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The payment type of the resource. Valid values: `Subscription`, `PayAsYouGo`.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The billing method of the subscription instance. Value: `Year`, `Month`. **NOTE:** This parameter is valid and must be passed in only when `payment_type` is `Subscription`.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource Group ID.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="sourceEndpointEngineName")
    def source_endpoint_engine_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Source instance database engine type.
        - **MySQL**:MySQL databases (including RDS MySQL and self-built MySQL).
        - **PolarDB**:PolarDB MySQL.
        - **polardb_o**:PolarDB O engine.
        - **polardb_pg**:PolarDB PostgreSQL.
        - **Redis**:Redis databases (including apsaradb for Redis and user-created Redis).
        - **DRDS**: cloud-native distributed database PolarDB-X 1.0 and 2.0.
        - **PostgreSQL**: User-created PostgreSQL.
        - **ODPS**:MaxCompute.
        - **oracle**: self-built Oracle.
        - **mongodb**:MongoDB databases (including apsaradb for MongoDB and user-created MongoDB).
        - **tidb**:TiDB database.
        - **ADS**: Cloud native data warehouse AnalyticDB MySQL 2.0.
        - **ADB30**: Cloud native data warehouse AnalyticDB MySQL 3.0.
        - **Greenplum**: Cloud native data warehouse AnalyticDB PostgreSQL.
        - **MSSQL**:SQL Server databases (including RDS SQL Server and self-built SQL Server).
        - **kafka**:Kafka databases (including Kafka and self-built Kafka).
        - **DataHub**: DataHub, an Alibaba cloud streaming data service.
        - **clickhouse**: ClickHouse.
        - **DB2**: self-built DB2 LUW.
        - **as400**:AS/400.
        - **Tablestore**: Tablestore.
        - **NOTE:**
        - The default value is **MySQL**.
        - For more information about the supported source and destination databases, see [Database, Synchronization Initialization Type, and Synchronization Topology](https://www.alibabacloud.com/help/en/data-transmission-service/latest/overview-of-data-synchronization-scenarios-1) and [Supported Database and Migration Type](https://www.alibabacloud.com/help/en/data-transmission-service/latest/overview-of-data-migration-scenarios).
        - This parameter or **job_id** must be passed in.
        """
        return pulumi.get(self, "source_endpoint_engine_name")

    @source_endpoint_engine_name.setter
    def source_endpoint_engine_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_endpoint_engine_name", value)

    @_builtins.property
    @pulumi.getter(name="sourceRegion")
    def source_region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The source instance region. For more information, see [List of supported regions](https://www.alibabacloud.com/help/en/data-transmission-service/latest/list-of-supported-regions). **NOTE:** This parameter or **job_id** must be passed in.
        """
        return pulumi.get(self, "source_region")

    @source_region.setter
    def source_region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_region", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instance status.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="syncArchitecture")
    def sync_architecture(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Synchronization topology, value:
        - **oneway**: one-way synchronization, the default value.
        - **bidirectional**: two-way synchronization.
        """
        return pulumi.get(self, "sync_architecture")

    @sync_architecture.setter
    def sync_architecture(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sync_architecture", value)

    @_builtins.property
    @pulumi.getter(name="synchronizationDirection")
    def synchronization_direction(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The synchronization direction. Default value: `Forward`. Valid values:
        - `Forward`: Data is synchronized from the source database to the destination database.
        - `Reverse`: Data is synchronized from the destination database to the source database.
        - **NOTE:** You can set this parameter to Reverse to delete the reverse synchronization task only if the topology is two-way synchronization.
        """
        return pulumi.get(self, "synchronization_direction")

    @synchronization_direction.setter
    def synchronization_direction(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "synchronization_direction", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tag value corresponding to the tag key.See the following `Block Tags`.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The instance type. Valid values:
        - **migration**: MIGRATION.
        - **sync**: synchronization.
        - **subscribe**: SUBSCRIBE.
        - **NOTE:** This parameter or **job_id** must be passed in.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="usedTime")
    def used_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Prepaid instance purchase duration.
        - When **period** is **Month**, the values are: 1, 2, 3, 4, 5, 6, 7, 8, and 9.
        - When **Period** is **Year**, the values are 1, 2, 3, and 5.
        - **NOTE:**
        - This parameter is valid and must be passed in only when **payment_type** is `Subscription`.
        - The billing method of the subscription instance. You can set the parameter `period`.
        """
        return pulumi.get(self, "used_time")

    @used_time.setter
    def used_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "used_time", value)


@pulumi.type_token("alicloud:dts/instance:Instance")
class Instance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_pay: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_start: Optional[pulumi.Input[_builtins.bool]] = None,
                 compute_unit: Optional[pulumi.Input[_builtins.int]] = None,
                 database_count: Optional[pulumi.Input[_builtins.int]] = None,
                 destination_endpoint_engine_name: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_region: Optional[pulumi.Input[_builtins.str]] = None,
                 du: Optional[pulumi.Input[_builtins.int]] = None,
                 fee_type: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_class: Optional[pulumi.Input[_builtins.str]] = None,
                 job_id: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_engine_name: Optional[pulumi.Input[_builtins.str]] = None,
                 source_region: Optional[pulumi.Input[_builtins.str]] = None,
                 sync_architecture: Optional[pulumi.Input[_builtins.str]] = None,
                 synchronization_direction: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 used_time: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Provides a Dts Instance resource.

        For information about Dts Instance and how to use it, see [What is Instance](https://www.alibabacloud.com/help/en/data-transmission-service/latest/createdtsinstance).

        > **NOTE:** Available since v1.198.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.resourcemanager.get_resource_groups(status="OK")
        default_get_regions = alicloud.get_regions(current=True)
        default_instance = alicloud.dts.Instance("default",
            type="sync",
            resource_group_id=default.ids[0],
            payment_type="Subscription",
            instance_class="large",
            source_endpoint_engine_name="MySQL",
            source_region=default_get_regions.regions[0].id,
            destination_endpoint_engine_name="MySQL",
            destination_region=default_get_regions.regions[0].id)
        ```

        ## Import

        Dts Instance can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:dts/instance:Instance example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] auto_pay: Whether to automatically renew the fee when it expires. Valid values:
               - **false**: No, the default value.
               - **true**: Yes.
        :param pulumi.Input[_builtins.bool] auto_start: Whether to start the task automatically after the purchase is completed. Value:
               - **false**: No, the default value.
               - **true**: Yes.
        :param pulumi.Input[_builtins.int] compute_unit: Specifications of ETL. The unit is compute unit (CU),1CU = 1vCPU +4GB of memory. The value range is an integer greater than or equal to 2. **NOTE:** Enter this parameter and enable ETL to clean and convert data.
        :param pulumi.Input[_builtins.int] database_count: The number of private custom RDS instances in the PolarDB-X. The default value is **1**. **NOTE:** This parameter is required only when **source_endpoint_engine_name** is **DRDS**.
        :param pulumi.Input[_builtins.str] destination_endpoint_engine_name: The target database engine type.
               - **MySQL**:MySQL databases (including RDS MySQL and self-built MySQL).
               - **PolarDB**:PolarDB MySQL.
               - **polardb_o**:PolarDB O engine.
               - **polardb_pg**:PolarDB PostgreSQL.
               - **Redis**:Redis databases (including apsaradb for Redis and user-created Redis).
               - **DRDS**: cloud-native distributed database PolarDB-X 1.0 and 2.0.
               - **PostgreSQL**: User-created PostgreSQL.
               - **ODPS**:MaxCompute project.
               - **oracle**: self-built Oracle.
               - **mongodb**:MongoDB databases (including apsaradb for MongoDB and user-created MongoDB).
               - **tidb**:TiDB database.
               - **ADS**: Cloud native data warehouse AnalyticDB MySQL 2.0.
               - **ADB30**: Cloud native data warehouse AnalyticDB MySQL 3.0.
               - **Greenplum**: Cloud native data warehouse AnalyticDB PostgreSQL.
               - **MSSQL**:SQL Server databases (including RDS SQL Server and self-built SQL Server).
               - **kafka**:Kafka databases (including Kafka and self-built Kafka).
               - **DataHub**: DataHub, an Alibaba cloud streaming data service.
               - **clickhouse**: ClickHouse.
               - **DB2**: self-built DB2 LUW.
               - **as400**:AS/400.
               - **Tablestore**: Tablestore.
               - **NOTE:**
               - The default value is **MySQL**.
               - For more information about the supported source and destination databases, see [Database, Synchronization Initialization Type, and Synchronization Topology](https://www.alibabacloud.com/help/en/data-transmission-service/latest/overview-of-data-synchronization-scenarios-1) and [Supported Database and Migration Type](https://www.alibabacloud.com/help/en/data-transmission-service/latest/overview-of-data-migration-scenarios).
               - This parameter or **job_id** must be passed in.
        :param pulumi.Input[_builtins.str] destination_region: The target instance region. For more information, see [List of supported regions](https://www.alibabacloud.com/help/en/data-transmission-service/latest/list-of-supported-regions). **NOTE:** This parameter or **job_id** must be passed in.
        :param pulumi.Input[_builtins.int] du: Assign a specified number of DU resources to DTS tasks in the DTS exclusive cluster. Valid values: **1** ~ **100**. **NOTE:** The value of this parameter must be within the range of the number of DUs available for the DTS dedicated cluster.
        :param pulumi.Input[_builtins.str] fee_type: Subscription billing type, Valid values: `ONLY_CONFIGURATION_FEE`: charges only configuration fees; `CONFIGURATION_FEE_AND_DATA_FEE`: charges configuration fees and data traffic fees.
        :param pulumi.Input[_builtins.str] instance_class: The type of the migration or synchronization instance.
               - The specifications of the migration instance: **xxlarge**, **xlarge**, **large**, **medium**, **small**.
               - The types of synchronization instances: **large**, **medium**, **small**, **micro**.
               - **NOTE:** For performance descriptions of different specifications, see [Data Migration Link Specifications](https://www.alibabacloud.com/help/en/data-transmission-service/latest/cd773b) and [Data Synchronization Link Specifications](https://www.alibabacloud.com/help/en/data-transmission-service/latest/6bce7c).
        :param pulumi.Input[_builtins.str] job_id: The ID of the task obtained by calling the **ConfigureDtsJob** operation (**DtsJobId**).> After you pass in this parameter, you do not need to pass the **source_region**, **destination_region**, **type**, **source_endpoint_engine_name**, or **destination_endpoint_engine_name** parameters. Even if the input is passed in, the configuration in **job_id** shall prevail.
        :param pulumi.Input[_builtins.str] payment_type: The payment type of the resource. Valid values: `Subscription`, `PayAsYouGo`.
        :param pulumi.Input[_builtins.str] period: The billing method of the subscription instance. Value: `Year`, `Month`. **NOTE:** This parameter is valid and must be passed in only when `payment_type` is `Subscription`.
        :param pulumi.Input[_builtins.str] resource_group_id: Resource Group ID.
        :param pulumi.Input[_builtins.str] source_endpoint_engine_name: Source instance database engine type.
               - **MySQL**:MySQL databases (including RDS MySQL and self-built MySQL).
               - **PolarDB**:PolarDB MySQL.
               - **polardb_o**:PolarDB O engine.
               - **polardb_pg**:PolarDB PostgreSQL.
               - **Redis**:Redis databases (including apsaradb for Redis and user-created Redis).
               - **DRDS**: cloud-native distributed database PolarDB-X 1.0 and 2.0.
               - **PostgreSQL**: User-created PostgreSQL.
               - **ODPS**:MaxCompute.
               - **oracle**: self-built Oracle.
               - **mongodb**:MongoDB databases (including apsaradb for MongoDB and user-created MongoDB).
               - **tidb**:TiDB database.
               - **ADS**: Cloud native data warehouse AnalyticDB MySQL 2.0.
               - **ADB30**: Cloud native data warehouse AnalyticDB MySQL 3.0.
               - **Greenplum**: Cloud native data warehouse AnalyticDB PostgreSQL.
               - **MSSQL**:SQL Server databases (including RDS SQL Server and self-built SQL Server).
               - **kafka**:Kafka databases (including Kafka and self-built Kafka).
               - **DataHub**: DataHub, an Alibaba cloud streaming data service.
               - **clickhouse**: ClickHouse.
               - **DB2**: self-built DB2 LUW.
               - **as400**:AS/400.
               - **Tablestore**: Tablestore.
               - **NOTE:**
               - The default value is **MySQL**.
               - For more information about the supported source and destination databases, see [Database, Synchronization Initialization Type, and Synchronization Topology](https://www.alibabacloud.com/help/en/data-transmission-service/latest/overview-of-data-synchronization-scenarios-1) and [Supported Database and Migration Type](https://www.alibabacloud.com/help/en/data-transmission-service/latest/overview-of-data-migration-scenarios).
               - This parameter or **job_id** must be passed in.
        :param pulumi.Input[_builtins.str] source_region: The source instance region. For more information, see [List of supported regions](https://www.alibabacloud.com/help/en/data-transmission-service/latest/list-of-supported-regions). **NOTE:** This parameter or **job_id** must be passed in.
        :param pulumi.Input[_builtins.str] sync_architecture: Synchronization topology, value:
               - **oneway**: one-way synchronization, the default value.
               - **bidirectional**: two-way synchronization.
        :param pulumi.Input[_builtins.str] synchronization_direction: The synchronization direction. Default value: `Forward`. Valid values:
               - `Forward`: Data is synchronized from the source database to the destination database.
               - `Reverse`: Data is synchronized from the destination database to the source database.
               - **NOTE:** You can set this parameter to Reverse to delete the reverse synchronization task only if the topology is two-way synchronization.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag value corresponding to the tag key.See the following `Block Tags`.
        :param pulumi.Input[_builtins.str] type: The instance type. Valid values:
               - **migration**: MIGRATION.
               - **sync**: synchronization.
               - **subscribe**: SUBSCRIBE.
               - **NOTE:** This parameter or **job_id** must be passed in.
        :param pulumi.Input[_builtins.int] used_time: Prepaid instance purchase duration.
               - When **period** is **Month**, the values are: 1, 2, 3, 4, 5, 6, 7, 8, and 9.
               - When **Period** is **Year**, the values are 1, 2, 3, and 5.
               - **NOTE:**
               - This parameter is valid and must be passed in only when **payment_type** is `Subscription`.
               - The billing method of the subscription instance. You can set the parameter `period`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[InstanceArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Dts Instance resource.

        For information about Dts Instance and how to use it, see [What is Instance](https://www.alibabacloud.com/help/en/data-transmission-service/latest/createdtsinstance).

        > **NOTE:** Available since v1.198.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.resourcemanager.get_resource_groups(status="OK")
        default_get_regions = alicloud.get_regions(current=True)
        default_instance = alicloud.dts.Instance("default",
            type="sync",
            resource_group_id=default.ids[0],
            payment_type="Subscription",
            instance_class="large",
            source_endpoint_engine_name="MySQL",
            source_region=default_get_regions.regions[0].id,
            destination_endpoint_engine_name="MySQL",
            destination_region=default_get_regions.regions[0].id)
        ```

        ## Import

        Dts Instance can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:dts/instance:Instance example <id>
        ```

        :param str resource_name: The name of the resource.
        :param InstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_pay: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_start: Optional[pulumi.Input[_builtins.bool]] = None,
                 compute_unit: Optional[pulumi.Input[_builtins.int]] = None,
                 database_count: Optional[pulumi.Input[_builtins.int]] = None,
                 destination_endpoint_engine_name: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_region: Optional[pulumi.Input[_builtins.str]] = None,
                 du: Optional[pulumi.Input[_builtins.int]] = None,
                 fee_type: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_class: Optional[pulumi.Input[_builtins.str]] = None,
                 job_id: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_engine_name: Optional[pulumi.Input[_builtins.str]] = None,
                 source_region: Optional[pulumi.Input[_builtins.str]] = None,
                 sync_architecture: Optional[pulumi.Input[_builtins.str]] = None,
                 synchronization_direction: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 used_time: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceArgs.__new__(InstanceArgs)

            __props__.__dict__["auto_pay"] = auto_pay
            __props__.__dict__["auto_start"] = auto_start
            __props__.__dict__["compute_unit"] = compute_unit
            __props__.__dict__["database_count"] = database_count
            __props__.__dict__["destination_endpoint_engine_name"] = destination_endpoint_engine_name
            __props__.__dict__["destination_region"] = destination_region
            __props__.__dict__["du"] = du
            __props__.__dict__["fee_type"] = fee_type
            __props__.__dict__["instance_class"] = instance_class
            __props__.__dict__["job_id"] = job_id
            __props__.__dict__["payment_type"] = payment_type
            __props__.__dict__["period"] = period
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["source_endpoint_engine_name"] = source_endpoint_engine_name
            __props__.__dict__["source_region"] = source_region
            __props__.__dict__["sync_architecture"] = sync_architecture
            __props__.__dict__["synchronization_direction"] = synchronization_direction
            __props__.__dict__["tags"] = tags
            __props__.__dict__["type"] = type
            __props__.__dict__["used_time"] = used_time
            __props__.__dict__["create_time"] = None
            __props__.__dict__["dts_instance_id"] = None
            __props__.__dict__["instance_name"] = None
            __props__.__dict__["status"] = None
        super(Instance, __self__).__init__(
            'alicloud:dts/instance:Instance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_pay: Optional[pulumi.Input[_builtins.bool]] = None,
            auto_start: Optional[pulumi.Input[_builtins.bool]] = None,
            compute_unit: Optional[pulumi.Input[_builtins.int]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            database_count: Optional[pulumi.Input[_builtins.int]] = None,
            destination_endpoint_engine_name: Optional[pulumi.Input[_builtins.str]] = None,
            destination_region: Optional[pulumi.Input[_builtins.str]] = None,
            dts_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            du: Optional[pulumi.Input[_builtins.int]] = None,
            fee_type: Optional[pulumi.Input[_builtins.str]] = None,
            instance_class: Optional[pulumi.Input[_builtins.str]] = None,
            instance_name: Optional[pulumi.Input[_builtins.str]] = None,
            job_id: Optional[pulumi.Input[_builtins.str]] = None,
            payment_type: Optional[pulumi.Input[_builtins.str]] = None,
            period: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            source_endpoint_engine_name: Optional[pulumi.Input[_builtins.str]] = None,
            source_region: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            sync_architecture: Optional[pulumi.Input[_builtins.str]] = None,
            synchronization_direction: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            used_time: Optional[pulumi.Input[_builtins.int]] = None) -> 'Instance':
        """
        Get an existing Instance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] auto_pay: Whether to automatically renew the fee when it expires. Valid values:
               - **false**: No, the default value.
               - **true**: Yes.
        :param pulumi.Input[_builtins.bool] auto_start: Whether to start the task automatically after the purchase is completed. Value:
               - **false**: No, the default value.
               - **true**: Yes.
        :param pulumi.Input[_builtins.int] compute_unit: Specifications of ETL. The unit is compute unit (CU),1CU = 1vCPU +4GB of memory. The value range is an integer greater than or equal to 2. **NOTE:** Enter this parameter and enable ETL to clean and convert data.
        :param pulumi.Input[_builtins.str] create_time: Instance creation time
        :param pulumi.Input[_builtins.int] database_count: The number of private custom RDS instances in the PolarDB-X. The default value is **1**. **NOTE:** This parameter is required only when **source_endpoint_engine_name** is **DRDS**.
        :param pulumi.Input[_builtins.str] destination_endpoint_engine_name: The target database engine type.
               - **MySQL**:MySQL databases (including RDS MySQL and self-built MySQL).
               - **PolarDB**:PolarDB MySQL.
               - **polardb_o**:PolarDB O engine.
               - **polardb_pg**:PolarDB PostgreSQL.
               - **Redis**:Redis databases (including apsaradb for Redis and user-created Redis).
               - **DRDS**: cloud-native distributed database PolarDB-X 1.0 and 2.0.
               - **PostgreSQL**: User-created PostgreSQL.
               - **ODPS**:MaxCompute project.
               - **oracle**: self-built Oracle.
               - **mongodb**:MongoDB databases (including apsaradb for MongoDB and user-created MongoDB).
               - **tidb**:TiDB database.
               - **ADS**: Cloud native data warehouse AnalyticDB MySQL 2.0.
               - **ADB30**: Cloud native data warehouse AnalyticDB MySQL 3.0.
               - **Greenplum**: Cloud native data warehouse AnalyticDB PostgreSQL.
               - **MSSQL**:SQL Server databases (including RDS SQL Server and self-built SQL Server).
               - **kafka**:Kafka databases (including Kafka and self-built Kafka).
               - **DataHub**: DataHub, an Alibaba cloud streaming data service.
               - **clickhouse**: ClickHouse.
               - **DB2**: self-built DB2 LUW.
               - **as400**:AS/400.
               - **Tablestore**: Tablestore.
               - **NOTE:**
               - The default value is **MySQL**.
               - For more information about the supported source and destination databases, see [Database, Synchronization Initialization Type, and Synchronization Topology](https://www.alibabacloud.com/help/en/data-transmission-service/latest/overview-of-data-synchronization-scenarios-1) and [Supported Database and Migration Type](https://www.alibabacloud.com/help/en/data-transmission-service/latest/overview-of-data-migration-scenarios).
               - This parameter or **job_id** must be passed in.
        :param pulumi.Input[_builtins.str] destination_region: The target instance region. For more information, see [List of supported regions](https://www.alibabacloud.com/help/en/data-transmission-service/latest/list-of-supported-regions). **NOTE:** This parameter or **job_id** must be passed in.
        :param pulumi.Input[_builtins.str] dts_instance_id: The ID of the subscription instance.
        :param pulumi.Input[_builtins.int] du: Assign a specified number of DU resources to DTS tasks in the DTS exclusive cluster. Valid values: **1** ~ **100**. **NOTE:** The value of this parameter must be within the range of the number of DUs available for the DTS dedicated cluster.
        :param pulumi.Input[_builtins.str] fee_type: Subscription billing type, Valid values: `ONLY_CONFIGURATION_FEE`: charges only configuration fees; `CONFIGURATION_FEE_AND_DATA_FEE`: charges configuration fees and data traffic fees.
        :param pulumi.Input[_builtins.str] instance_class: The type of the migration or synchronization instance.
               - The specifications of the migration instance: **xxlarge**, **xlarge**, **large**, **medium**, **small**.
               - The types of synchronization instances: **large**, **medium**, **small**, **micro**.
               - **NOTE:** For performance descriptions of different specifications, see [Data Migration Link Specifications](https://www.alibabacloud.com/help/en/data-transmission-service/latest/cd773b) and [Data Synchronization Link Specifications](https://www.alibabacloud.com/help/en/data-transmission-service/latest/6bce7c).
        :param pulumi.Input[_builtins.str] instance_name: The name of Dts instance.
        :param pulumi.Input[_builtins.str] job_id: The ID of the task obtained by calling the **ConfigureDtsJob** operation (**DtsJobId**).> After you pass in this parameter, you do not need to pass the **source_region**, **destination_region**, **type**, **source_endpoint_engine_name**, or **destination_endpoint_engine_name** parameters. Even if the input is passed in, the configuration in **job_id** shall prevail.
        :param pulumi.Input[_builtins.str] payment_type: The payment type of the resource. Valid values: `Subscription`, `PayAsYouGo`.
        :param pulumi.Input[_builtins.str] period: The billing method of the subscription instance. Value: `Year`, `Month`. **NOTE:** This parameter is valid and must be passed in only when `payment_type` is `Subscription`.
        :param pulumi.Input[_builtins.str] resource_group_id: Resource Group ID.
        :param pulumi.Input[_builtins.str] source_endpoint_engine_name: Source instance database engine type.
               - **MySQL**:MySQL databases (including RDS MySQL and self-built MySQL).
               - **PolarDB**:PolarDB MySQL.
               - **polardb_o**:PolarDB O engine.
               - **polardb_pg**:PolarDB PostgreSQL.
               - **Redis**:Redis databases (including apsaradb for Redis and user-created Redis).
               - **DRDS**: cloud-native distributed database PolarDB-X 1.0 and 2.0.
               - **PostgreSQL**: User-created PostgreSQL.
               - **ODPS**:MaxCompute.
               - **oracle**: self-built Oracle.
               - **mongodb**:MongoDB databases (including apsaradb for MongoDB and user-created MongoDB).
               - **tidb**:TiDB database.
               - **ADS**: Cloud native data warehouse AnalyticDB MySQL 2.0.
               - **ADB30**: Cloud native data warehouse AnalyticDB MySQL 3.0.
               - **Greenplum**: Cloud native data warehouse AnalyticDB PostgreSQL.
               - **MSSQL**:SQL Server databases (including RDS SQL Server and self-built SQL Server).
               - **kafka**:Kafka databases (including Kafka and self-built Kafka).
               - **DataHub**: DataHub, an Alibaba cloud streaming data service.
               - **clickhouse**: ClickHouse.
               - **DB2**: self-built DB2 LUW.
               - **as400**:AS/400.
               - **Tablestore**: Tablestore.
               - **NOTE:**
               - The default value is **MySQL**.
               - For more information about the supported source and destination databases, see [Database, Synchronization Initialization Type, and Synchronization Topology](https://www.alibabacloud.com/help/en/data-transmission-service/latest/overview-of-data-synchronization-scenarios-1) and [Supported Database and Migration Type](https://www.alibabacloud.com/help/en/data-transmission-service/latest/overview-of-data-migration-scenarios).
               - This parameter or **job_id** must be passed in.
        :param pulumi.Input[_builtins.str] source_region: The source instance region. For more information, see [List of supported regions](https://www.alibabacloud.com/help/en/data-transmission-service/latest/list-of-supported-regions). **NOTE:** This parameter or **job_id** must be passed in.
        :param pulumi.Input[_builtins.str] status: Instance status.
        :param pulumi.Input[_builtins.str] sync_architecture: Synchronization topology, value:
               - **oneway**: one-way synchronization, the default value.
               - **bidirectional**: two-way synchronization.
        :param pulumi.Input[_builtins.str] synchronization_direction: The synchronization direction. Default value: `Forward`. Valid values:
               - `Forward`: Data is synchronized from the source database to the destination database.
               - `Reverse`: Data is synchronized from the destination database to the source database.
               - **NOTE:** You can set this parameter to Reverse to delete the reverse synchronization task only if the topology is two-way synchronization.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag value corresponding to the tag key.See the following `Block Tags`.
        :param pulumi.Input[_builtins.str] type: The instance type. Valid values:
               - **migration**: MIGRATION.
               - **sync**: synchronization.
               - **subscribe**: SUBSCRIBE.
               - **NOTE:** This parameter or **job_id** must be passed in.
        :param pulumi.Input[_builtins.int] used_time: Prepaid instance purchase duration.
               - When **period** is **Month**, the values are: 1, 2, 3, 4, 5, 6, 7, 8, and 9.
               - When **Period** is **Year**, the values are 1, 2, 3, and 5.
               - **NOTE:**
               - This parameter is valid and must be passed in only when **payment_type** is `Subscription`.
               - The billing method of the subscription instance. You can set the parameter `period`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceState.__new__(_InstanceState)

        __props__.__dict__["auto_pay"] = auto_pay
        __props__.__dict__["auto_start"] = auto_start
        __props__.__dict__["compute_unit"] = compute_unit
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["database_count"] = database_count
        __props__.__dict__["destination_endpoint_engine_name"] = destination_endpoint_engine_name
        __props__.__dict__["destination_region"] = destination_region
        __props__.__dict__["dts_instance_id"] = dts_instance_id
        __props__.__dict__["du"] = du
        __props__.__dict__["fee_type"] = fee_type
        __props__.__dict__["instance_class"] = instance_class
        __props__.__dict__["instance_name"] = instance_name
        __props__.__dict__["job_id"] = job_id
        __props__.__dict__["payment_type"] = payment_type
        __props__.__dict__["period"] = period
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["source_endpoint_engine_name"] = source_endpoint_engine_name
        __props__.__dict__["source_region"] = source_region
        __props__.__dict__["status"] = status
        __props__.__dict__["sync_architecture"] = sync_architecture
        __props__.__dict__["synchronization_direction"] = synchronization_direction
        __props__.__dict__["tags"] = tags
        __props__.__dict__["type"] = type
        __props__.__dict__["used_time"] = used_time
        return Instance(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="autoPay")
    def auto_pay(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to automatically renew the fee when it expires. Valid values:
        - **false**: No, the default value.
        - **true**: Yes.
        """
        return pulumi.get(self, "auto_pay")

    @_builtins.property
    @pulumi.getter(name="autoStart")
    def auto_start(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to start the task automatically after the purchase is completed. Value:
        - **false**: No, the default value.
        - **true**: Yes.
        """
        return pulumi.get(self, "auto_start")

    @_builtins.property
    @pulumi.getter(name="computeUnit")
    def compute_unit(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Specifications of ETL. The unit is compute unit (CU),1CU = 1vCPU +4GB of memory. The value range is an integer greater than or equal to 2. **NOTE:** Enter this parameter and enable ETL to clean and convert data.
        """
        return pulumi.get(self, "compute_unit")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        Instance creation time
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="databaseCount")
    def database_count(self) -> pulumi.Output[_builtins.int]:
        """
        The number of private custom RDS instances in the PolarDB-X. The default value is **1**. **NOTE:** This parameter is required only when **source_endpoint_engine_name** is **DRDS**.
        """
        return pulumi.get(self, "database_count")

    @_builtins.property
    @pulumi.getter(name="destinationEndpointEngineName")
    def destination_endpoint_engine_name(self) -> pulumi.Output[_builtins.str]:
        """
        The target database engine type.
        - **MySQL**:MySQL databases (including RDS MySQL and self-built MySQL).
        - **PolarDB**:PolarDB MySQL.
        - **polardb_o**:PolarDB O engine.
        - **polardb_pg**:PolarDB PostgreSQL.
        - **Redis**:Redis databases (including apsaradb for Redis and user-created Redis).
        - **DRDS**: cloud-native distributed database PolarDB-X 1.0 and 2.0.
        - **PostgreSQL**: User-created PostgreSQL.
        - **ODPS**:MaxCompute project.
        - **oracle**: self-built Oracle.
        - **mongodb**:MongoDB databases (including apsaradb for MongoDB and user-created MongoDB).
        - **tidb**:TiDB database.
        - **ADS**: Cloud native data warehouse AnalyticDB MySQL 2.0.
        - **ADB30**: Cloud native data warehouse AnalyticDB MySQL 3.0.
        - **Greenplum**: Cloud native data warehouse AnalyticDB PostgreSQL.
        - **MSSQL**:SQL Server databases (including RDS SQL Server and self-built SQL Server).
        - **kafka**:Kafka databases (including Kafka and self-built Kafka).
        - **DataHub**: DataHub, an Alibaba cloud streaming data service.
        - **clickhouse**: ClickHouse.
        - **DB2**: self-built DB2 LUW.
        - **as400**:AS/400.
        - **Tablestore**: Tablestore.
        - **NOTE:**
        - The default value is **MySQL**.
        - For more information about the supported source and destination databases, see [Database, Synchronization Initialization Type, and Synchronization Topology](https://www.alibabacloud.com/help/en/data-transmission-service/latest/overview-of-data-synchronization-scenarios-1) and [Supported Database and Migration Type](https://www.alibabacloud.com/help/en/data-transmission-service/latest/overview-of-data-migration-scenarios).
        - This parameter or **job_id** must be passed in.
        """
        return pulumi.get(self, "destination_endpoint_engine_name")

    @_builtins.property
    @pulumi.getter(name="destinationRegion")
    def destination_region(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The target instance region. For more information, see [List of supported regions](https://www.alibabacloud.com/help/en/data-transmission-service/latest/list-of-supported-regions). **NOTE:** This parameter or **job_id** must be passed in.
        """
        return pulumi.get(self, "destination_region")

    @_builtins.property
    @pulumi.getter(name="dtsInstanceId")
    def dts_instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the subscription instance.
        """
        return pulumi.get(self, "dts_instance_id")

    @_builtins.property
    @pulumi.getter
    def du(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Assign a specified number of DU resources to DTS tasks in the DTS exclusive cluster. Valid values: **1** ~ **100**. **NOTE:** The value of this parameter must be within the range of the number of DUs available for the DTS dedicated cluster.
        """
        return pulumi.get(self, "du")

    @_builtins.property
    @pulumi.getter(name="feeType")
    def fee_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Subscription billing type, Valid values: `ONLY_CONFIGURATION_FEE`: charges only configuration fees; `CONFIGURATION_FEE_AND_DATA_FEE`: charges configuration fees and data traffic fees.
        """
        return pulumi.get(self, "fee_type")

    @_builtins.property
    @pulumi.getter(name="instanceClass")
    def instance_class(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The type of the migration or synchronization instance.
        - The specifications of the migration instance: **xxlarge**, **xlarge**, **large**, **medium**, **small**.
        - The types of synchronization instances: **large**, **medium**, **small**, **micro**.
        - **NOTE:** For performance descriptions of different specifications, see [Data Migration Link Specifications](https://www.alibabacloud.com/help/en/data-transmission-service/latest/cd773b) and [Data Synchronization Link Specifications](https://www.alibabacloud.com/help/en/data-transmission-service/latest/6bce7c).
        """
        return pulumi.get(self, "instance_class")

    @_builtins.property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of Dts instance.
        """
        return pulumi.get(self, "instance_name")

    @_builtins.property
    @pulumi.getter(name="jobId")
    def job_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the task obtained by calling the **ConfigureDtsJob** operation (**DtsJobId**).> After you pass in this parameter, you do not need to pass the **source_region**, **destination_region**, **type**, **source_endpoint_engine_name**, or **destination_endpoint_engine_name** parameters. Even if the input is passed in, the configuration in **job_id** shall prevail.
        """
        return pulumi.get(self, "job_id")

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The payment type of the resource. Valid values: `Subscription`, `PayAsYouGo`.
        """
        return pulumi.get(self, "payment_type")

    @_builtins.property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The billing method of the subscription instance. Value: `Year`, `Month`. **NOTE:** This parameter is valid and must be passed in only when `payment_type` is `Subscription`.
        """
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        Resource Group ID.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="sourceEndpointEngineName")
    def source_endpoint_engine_name(self) -> pulumi.Output[_builtins.str]:
        """
        Source instance database engine type.
        - **MySQL**:MySQL databases (including RDS MySQL and self-built MySQL).
        - **PolarDB**:PolarDB MySQL.
        - **polardb_o**:PolarDB O engine.
        - **polardb_pg**:PolarDB PostgreSQL.
        - **Redis**:Redis databases (including apsaradb for Redis and user-created Redis).
        - **DRDS**: cloud-native distributed database PolarDB-X 1.0 and 2.0.
        - **PostgreSQL**: User-created PostgreSQL.
        - **ODPS**:MaxCompute.
        - **oracle**: self-built Oracle.
        - **mongodb**:MongoDB databases (including apsaradb for MongoDB and user-created MongoDB).
        - **tidb**:TiDB database.
        - **ADS**: Cloud native data warehouse AnalyticDB MySQL 2.0.
        - **ADB30**: Cloud native data warehouse AnalyticDB MySQL 3.0.
        - **Greenplum**: Cloud native data warehouse AnalyticDB PostgreSQL.
        - **MSSQL**:SQL Server databases (including RDS SQL Server and self-built SQL Server).
        - **kafka**:Kafka databases (including Kafka and self-built Kafka).
        - **DataHub**: DataHub, an Alibaba cloud streaming data service.
        - **clickhouse**: ClickHouse.
        - **DB2**: self-built DB2 LUW.
        - **as400**:AS/400.
        - **Tablestore**: Tablestore.
        - **NOTE:**
        - The default value is **MySQL**.
        - For more information about the supported source and destination databases, see [Database, Synchronization Initialization Type, and Synchronization Topology](https://www.alibabacloud.com/help/en/data-transmission-service/latest/overview-of-data-synchronization-scenarios-1) and [Supported Database and Migration Type](https://www.alibabacloud.com/help/en/data-transmission-service/latest/overview-of-data-migration-scenarios).
        - This parameter or **job_id** must be passed in.
        """
        return pulumi.get(self, "source_endpoint_engine_name")

    @_builtins.property
    @pulumi.getter(name="sourceRegion")
    def source_region(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The source instance region. For more information, see [List of supported regions](https://www.alibabacloud.com/help/en/data-transmission-service/latest/list-of-supported-regions). **NOTE:** This parameter or **job_id** must be passed in.
        """
        return pulumi.get(self, "source_region")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Instance status.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="syncArchitecture")
    def sync_architecture(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Synchronization topology, value:
        - **oneway**: one-way synchronization, the default value.
        - **bidirectional**: two-way synchronization.
        """
        return pulumi.get(self, "sync_architecture")

    @_builtins.property
    @pulumi.getter(name="synchronizationDirection")
    def synchronization_direction(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The synchronization direction. Default value: `Forward`. Valid values:
        - `Forward`: Data is synchronized from the source database to the destination database.
        - `Reverse`: Data is synchronized from the destination database to the source database.
        - **NOTE:** You can set this parameter to Reverse to delete the reverse synchronization task only if the topology is two-way synchronization.
        """
        return pulumi.get(self, "synchronization_direction")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The tag value corresponding to the tag key.See the following `Block Tags`.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The instance type. Valid values:
        - **migration**: MIGRATION.
        - **sync**: synchronization.
        - **subscribe**: SUBSCRIBE.
        - **NOTE:** This parameter or **job_id** must be passed in.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="usedTime")
    def used_time(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Prepaid instance purchase duration.
        - When **period** is **Month**, the values are: 1, 2, 3, 4, 5, 6, 7, 8, and 9.
        - When **Period** is **Year**, the values are 1, 2, 3, and 5.
        - **NOTE:**
        - This parameter is valid and must be passed in only when **payment_type** is `Subscription`.
        - The billing method of the subscription instance. You can set the parameter `period`.
        """
        return pulumi.get(self, "used_time")

