# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetVirtualNodesResult',
    'AwaitableGetVirtualNodesResult',
    'get_virtual_nodes',
    'get_virtual_nodes_output',
]

@pulumi.output_type
class GetVirtualNodesResult:
    """
    A collection of values returned by getVirtualNodes.
    """
    def __init__(__self__, id=None, ids=None, name_regex=None, names=None, nodes=None, output_file=None, resource_group_id=None, security_group_id=None, status=None, tags=None, virtual_node_name=None, vswitch_id=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if nodes and not isinstance(nodes, list):
            raise TypeError("Expected argument 'nodes' to be a list")
        pulumi.set(__self__, "nodes", nodes)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if resource_group_id and not isinstance(resource_group_id, str):
            raise TypeError("Expected argument 'resource_group_id' to be a str")
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        if security_group_id and not isinstance(security_group_id, str):
            raise TypeError("Expected argument 'security_group_id' to be a str")
        pulumi.set(__self__, "security_group_id", security_group_id)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if virtual_node_name and not isinstance(virtual_node_name, str):
            raise TypeError("Expected argument 'virtual_node_name' to be a str")
        pulumi.set(__self__, "virtual_node_name", virtual_node_name)
        if vswitch_id and not isinstance(vswitch_id, str):
            raise TypeError("Expected argument 'vswitch_id' to be a str")
        pulumi.set(__self__, "vswitch_id", vswitch_id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name_regex")

    @_builtins.property
    @pulumi.getter
    def names(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "names")

    @_builtins.property
    @pulumi.getter
    def nodes(self) -> Sequence['outputs.GetVirtualNodesNodeResult']:
        return pulumi.get(self, "nodes")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "security_group_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, _builtins.str]]:
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="virtualNodeName")
    def virtual_node_name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "virtual_node_name")

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "vswitch_id")


class AwaitableGetVirtualNodesResult(GetVirtualNodesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVirtualNodesResult(
            id=self.id,
            ids=self.ids,
            name_regex=self.name_regex,
            names=self.names,
            nodes=self.nodes,
            output_file=self.output_file,
            resource_group_id=self.resource_group_id,
            security_group_id=self.security_group_id,
            status=self.status,
            tags=self.tags,
            virtual_node_name=self.virtual_node_name,
            vswitch_id=self.vswitch_id)


def get_virtual_nodes(ids: Optional[Sequence[_builtins.str]] = None,
                      name_regex: Optional[_builtins.str] = None,
                      output_file: Optional[_builtins.str] = None,
                      resource_group_id: Optional[_builtins.str] = None,
                      security_group_id: Optional[_builtins.str] = None,
                      status: Optional[_builtins.str] = None,
                      tags: Optional[Mapping[str, _builtins.str]] = None,
                      virtual_node_name: Optional[_builtins.str] = None,
                      vswitch_id: Optional[_builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVirtualNodesResult:
    """
    This data source provides the Eci Virtual Nodes of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.145.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.eci.get_virtual_nodes(ids=[
        "example_value-1",
        "example_value-2",
    ])
    pulumi.export("eciVirtualNodeId1", ids.nodes[0].id)
    name_regex = alicloud.eci.get_virtual_nodes(name_regex="^my-VirtualNode")
    pulumi.export("eciVirtualNodeId2", name_regex.nodes[0].id)
    ```


    :param Sequence[_builtins.str] ids: A list of Virtual Node IDs.
    :param _builtins.str name_regex: A regex string to filter results by Virtual Node name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str resource_group_id: The resource group ID. If when you create a GPU does not specify a resource group instance will automatically add the account's default resource group.
    :param _builtins.str security_group_id: VNode itself and by VNode created (ECI) the security group used by.
    :param _builtins.str status: The Status of the virtual node. Valid values: `Cleaned`, `Failed`, `Pending`, `Ready`.
    :param Mapping[str, _builtins.str] tags: A mapping of tags to assign to the resource.
    :param _builtins.str virtual_node_name: The name of the virtual node.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['resourceGroupId'] = resource_group_id
    __args__['securityGroupId'] = security_group_id
    __args__['status'] = status
    __args__['tags'] = tags
    __args__['virtualNodeName'] = virtual_node_name
    __args__['vswitchId'] = vswitch_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:eci/getVirtualNodes:getVirtualNodes', __args__, opts=opts, typ=GetVirtualNodesResult).value

    return AwaitableGetVirtualNodesResult(
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        nodes=pulumi.get(__ret__, 'nodes'),
        output_file=pulumi.get(__ret__, 'output_file'),
        resource_group_id=pulumi.get(__ret__, 'resource_group_id'),
        security_group_id=pulumi.get(__ret__, 'security_group_id'),
        status=pulumi.get(__ret__, 'status'),
        tags=pulumi.get(__ret__, 'tags'),
        virtual_node_name=pulumi.get(__ret__, 'virtual_node_name'),
        vswitch_id=pulumi.get(__ret__, 'vswitch_id'))
def get_virtual_nodes_output(ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                             name_regex: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             resource_group_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             security_group_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             tags: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                             virtual_node_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             vswitch_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVirtualNodesResult]:
    """
    This data source provides the Eci Virtual Nodes of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.145.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.eci.get_virtual_nodes(ids=[
        "example_value-1",
        "example_value-2",
    ])
    pulumi.export("eciVirtualNodeId1", ids.nodes[0].id)
    name_regex = alicloud.eci.get_virtual_nodes(name_regex="^my-VirtualNode")
    pulumi.export("eciVirtualNodeId2", name_regex.nodes[0].id)
    ```


    :param Sequence[_builtins.str] ids: A list of Virtual Node IDs.
    :param _builtins.str name_regex: A regex string to filter results by Virtual Node name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str resource_group_id: The resource group ID. If when you create a GPU does not specify a resource group instance will automatically add the account's default resource group.
    :param _builtins.str security_group_id: VNode itself and by VNode created (ECI) the security group used by.
    :param _builtins.str status: The Status of the virtual node. Valid values: `Cleaned`, `Failed`, `Pending`, `Ready`.
    :param Mapping[str, _builtins.str] tags: A mapping of tags to assign to the resource.
    :param _builtins.str virtual_node_name: The name of the virtual node.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['resourceGroupId'] = resource_group_id
    __args__['securityGroupId'] = security_group_id
    __args__['status'] = status
    __args__['tags'] = tags
    __args__['virtualNodeName'] = virtual_node_name
    __args__['vswitchId'] = vswitch_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:eci/getVirtualNodes:getVirtualNodes', __args__, opts=opts, typ=GetVirtualNodesResult)
    return __ret__.apply(lambda __response__: GetVirtualNodesResult(
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        name_regex=pulumi.get(__response__, 'name_regex'),
        names=pulumi.get(__response__, 'names'),
        nodes=pulumi.get(__response__, 'nodes'),
        output_file=pulumi.get(__response__, 'output_file'),
        resource_group_id=pulumi.get(__response__, 'resource_group_id'),
        security_group_id=pulumi.get(__response__, 'security_group_id'),
        status=pulumi.get(__response__, 'status'),
        tags=pulumi.get(__response__, 'tags'),
        virtual_node_name=pulumi.get(__response__, 'virtual_node_name'),
        vswitch_id=pulumi.get(__response__, 'vswitch_id')))
