# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['InstanceArgs', 'Instance']

@pulumi.input_type
class InstanceArgs:
    def __init__(__self__, *,
                 image_id: pulumi.Input[_builtins.str],
                 instance_type: pulumi.Input[_builtins.str],
                 security_group_id: pulumi.Input[_builtins.str],
                 vswitch_id: pulumi.Input[_builtins.str],
                 auto_pay: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 eip_bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 force: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 key_pair_name: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.str]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 resolution: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 vnc_password: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Instance resource.
        :param pulumi.Input[_builtins.str] image_id: The ID of the image.
        :param pulumi.Input[_builtins.str] instance_type: The specifications of the ECP instance.
        :param pulumi.Input[_builtins.str] security_group_id: The ID of the security group.
        :param pulumi.Input[_builtins.str] vswitch_id: The ID of the vSwitch.
        :param pulumi.Input[_builtins.bool] auto_pay: Specifies whether to enable the auto-payment feature. Valid values:
        :param pulumi.Input[_builtins.bool] auto_renew: Specifies whether to enable the auto-renewal feature. Valid values:
        :param pulumi.Input[_builtins.str] description: The description of the ECP instance. The description must be `2` to `256` characters in length and cannot start with `http://` or `https://`.
        :param pulumi.Input[_builtins.int] eip_bandwidth: The bandwidth of the elastic IP address (EIP). **NOTE:** From version 1.232.0, `eip_bandwidth` cannot be modified.
        :param pulumi.Input[_builtins.bool] force: Specifies whether to forcefully stop and release the instance. Default value: `false`. Valid values:
        :param pulumi.Input[_builtins.str] instance_name: The name of the ECP instance. The name must be `2` to `128` characters in length. It must start with a letter but cannot start with `http://` or `https://`. It can contain letters, digits, colons (:), underscores (_), periods (.), and hyphens (-).
        :param pulumi.Input[_builtins.str] key_pair_name: The name of the key pair that you want to use to connect to the instance.
        :param pulumi.Input[_builtins.str] payment_type: The billing method of the ECP instance. Default value: `PayAsYouGo`. Valid values: `PayAsYouGo`,`Subscription`. **NOTE:** From version 1.232.0, `payment_type` cannot be modified.
        :param pulumi.Input[_builtins.str] period: The subscription duration. Default value: `1`. Valid values:
               - If `period_unit` is set to `Month`. Valid values: `1`, `2`, `3`, and `6`.
               - If `period_unit` is set to `Year`. Valid values: `1` to `5`.
        :param pulumi.Input[_builtins.str] period_unit: The unit of the subscription duration. Default value: `Month`. Valid values: `Month`, `Year`.
        :param pulumi.Input[_builtins.str] resolution: The resolution that you want to select for the ECP instance. **NOTE:** From version 1.232.0, `resolution` can be modified.
        :param pulumi.Input[_builtins.str] status: The status of the Instance. Valid values: `Running`, `Stopped`.
        :param pulumi.Input[_builtins.str] vnc_password: The VNC password of the instance. The password must be `6` characters in length and can contain only uppercase letters, lowercase letters, and digits.
        """
        pulumi.set(__self__, "image_id", image_id)
        pulumi.set(__self__, "instance_type", instance_type)
        pulumi.set(__self__, "security_group_id", security_group_id)
        pulumi.set(__self__, "vswitch_id", vswitch_id)
        if auto_pay is not None:
            pulumi.set(__self__, "auto_pay", auto_pay)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if eip_bandwidth is not None:
            pulumi.set(__self__, "eip_bandwidth", eip_bandwidth)
        if force is not None:
            pulumi.set(__self__, "force", force)
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if key_pair_name is not None:
            pulumi.set(__self__, "key_pair_name", key_pair_name)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if resolution is not None:
            pulumi.set(__self__, "resolution", resolution)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if vnc_password is not None:
            pulumi.set(__self__, "vnc_password", vnc_password)

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the image.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "image_id", value)

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Input[_builtins.str]:
        """
        The specifications of the ECP instance.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_type", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the security group.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "security_group_id", value)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the vSwitch.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vswitch_id", value)

    @_builtins.property
    @pulumi.getter(name="autoPay")
    def auto_pay(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable the auto-payment feature. Valid values:
        """
        return pulumi.get(self, "auto_pay")

    @auto_pay.setter
    def auto_pay(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_pay", value)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable the auto-renewal feature. Valid values:
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_renew", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the ECP instance. The description must be `2` to `256` characters in length and cannot start with `http://` or `https://`.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="eipBandwidth")
    def eip_bandwidth(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The bandwidth of the elastic IP address (EIP). **NOTE:** From version 1.232.0, `eip_bandwidth` cannot be modified.
        """
        return pulumi.get(self, "eip_bandwidth")

    @eip_bandwidth.setter
    def eip_bandwidth(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "eip_bandwidth", value)

    @_builtins.property
    @pulumi.getter
    def force(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to forcefully stop and release the instance. Default value: `false`. Valid values:
        """
        return pulumi.get(self, "force")

    @force.setter
    def force(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force", value)

    @_builtins.property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the ECP instance. The name must be `2` to `128` characters in length. It must start with a letter but cannot start with `http://` or `https://`. It can contain letters, digits, colons (:), underscores (_), periods (.), and hyphens (-).
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_name", value)

    @_builtins.property
    @pulumi.getter(name="keyPairName")
    def key_pair_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the key pair that you want to use to connect to the instance.
        """
        return pulumi.get(self, "key_pair_name")

    @key_pair_name.setter
    def key_pair_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_pair_name", value)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The billing method of the ECP instance. Default value: `PayAsYouGo`. Valid values: `PayAsYouGo`,`Subscription`. **NOTE:** From version 1.232.0, `payment_type` cannot be modified.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The subscription duration. Default value: `1`. Valid values:
        - If `period_unit` is set to `Month`. Valid values: `1`, `2`, `3`, and `6`.
        - If `period_unit` is set to `Year`. Valid values: `1` to `5`.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unit of the subscription duration. Default value: `Month`. Valid values: `Month`, `Year`.
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "period_unit", value)

    @_builtins.property
    @pulumi.getter
    def resolution(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resolution that you want to select for the ECP instance. **NOTE:** From version 1.232.0, `resolution` can be modified.
        """
        return pulumi.get(self, "resolution")

    @resolution.setter
    def resolution(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resolution", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the Instance. Valid values: `Running`, `Stopped`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="vncPassword")
    def vnc_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The VNC password of the instance. The password must be `6` characters in length and can contain only uppercase letters, lowercase letters, and digits.
        """
        return pulumi.get(self, "vnc_password")

    @vnc_password.setter
    def vnc_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vnc_password", value)


@pulumi.input_type
class _InstanceState:
    def __init__(__self__, *,
                 auto_pay: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 eip_bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 force: Optional[pulumi.Input[_builtins.bool]] = None,
                 image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 key_pair_name: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.str]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 resolution: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 vnc_password: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Instance resources.
        :param pulumi.Input[_builtins.bool] auto_pay: Specifies whether to enable the auto-payment feature. Valid values:
        :param pulumi.Input[_builtins.bool] auto_renew: Specifies whether to enable the auto-renewal feature. Valid values:
        :param pulumi.Input[_builtins.str] description: The description of the ECP instance. The description must be `2` to `256` characters in length and cannot start with `http://` or `https://`.
        :param pulumi.Input[_builtins.int] eip_bandwidth: The bandwidth of the elastic IP address (EIP). **NOTE:** From version 1.232.0, `eip_bandwidth` cannot be modified.
        :param pulumi.Input[_builtins.bool] force: Specifies whether to forcefully stop and release the instance. Default value: `false`. Valid values:
        :param pulumi.Input[_builtins.str] image_id: The ID of the image.
        :param pulumi.Input[_builtins.str] instance_name: The name of the ECP instance. The name must be `2` to `128` characters in length. It must start with a letter but cannot start with `http://` or `https://`. It can contain letters, digits, colons (:), underscores (_), periods (.), and hyphens (-).
        :param pulumi.Input[_builtins.str] instance_type: The specifications of the ECP instance.
        :param pulumi.Input[_builtins.str] key_pair_name: The name of the key pair that you want to use to connect to the instance.
        :param pulumi.Input[_builtins.str] payment_type: The billing method of the ECP instance. Default value: `PayAsYouGo`. Valid values: `PayAsYouGo`,`Subscription`. **NOTE:** From version 1.232.0, `payment_type` cannot be modified.
        :param pulumi.Input[_builtins.str] period: The subscription duration. Default value: `1`. Valid values:
               - If `period_unit` is set to `Month`. Valid values: `1`, `2`, `3`, and `6`.
               - If `period_unit` is set to `Year`. Valid values: `1` to `5`.
        :param pulumi.Input[_builtins.str] period_unit: The unit of the subscription duration. Default value: `Month`. Valid values: `Month`, `Year`.
        :param pulumi.Input[_builtins.str] resolution: The resolution that you want to select for the ECP instance. **NOTE:** From version 1.232.0, `resolution` can be modified.
        :param pulumi.Input[_builtins.str] security_group_id: The ID of the security group.
        :param pulumi.Input[_builtins.str] status: The status of the Instance. Valid values: `Running`, `Stopped`.
        :param pulumi.Input[_builtins.str] vnc_password: The VNC password of the instance. The password must be `6` characters in length and can contain only uppercase letters, lowercase letters, and digits.
        :param pulumi.Input[_builtins.str] vswitch_id: The ID of the vSwitch.
        """
        if auto_pay is not None:
            pulumi.set(__self__, "auto_pay", auto_pay)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if eip_bandwidth is not None:
            pulumi.set(__self__, "eip_bandwidth", eip_bandwidth)
        if force is not None:
            pulumi.set(__self__, "force", force)
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if key_pair_name is not None:
            pulumi.set(__self__, "key_pair_name", key_pair_name)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if resolution is not None:
            pulumi.set(__self__, "resolution", resolution)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if vnc_password is not None:
            pulumi.set(__self__, "vnc_password", vnc_password)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)

    @_builtins.property
    @pulumi.getter(name="autoPay")
    def auto_pay(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable the auto-payment feature. Valid values:
        """
        return pulumi.get(self, "auto_pay")

    @auto_pay.setter
    def auto_pay(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_pay", value)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable the auto-renewal feature. Valid values:
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_renew", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the ECP instance. The description must be `2` to `256` characters in length and cannot start with `http://` or `https://`.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="eipBandwidth")
    def eip_bandwidth(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The bandwidth of the elastic IP address (EIP). **NOTE:** From version 1.232.0, `eip_bandwidth` cannot be modified.
        """
        return pulumi.get(self, "eip_bandwidth")

    @eip_bandwidth.setter
    def eip_bandwidth(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "eip_bandwidth", value)

    @_builtins.property
    @pulumi.getter
    def force(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to forcefully stop and release the instance. Default value: `false`. Valid values:
        """
        return pulumi.get(self, "force")

    @force.setter
    def force(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force", value)

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the image.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_id", value)

    @_builtins.property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the ECP instance. The name must be `2` to `128` characters in length. It must start with a letter but cannot start with `http://` or `https://`. It can contain letters, digits, colons (:), underscores (_), periods (.), and hyphens (-).
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_name", value)

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The specifications of the ECP instance.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_type", value)

    @_builtins.property
    @pulumi.getter(name="keyPairName")
    def key_pair_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the key pair that you want to use to connect to the instance.
        """
        return pulumi.get(self, "key_pair_name")

    @key_pair_name.setter
    def key_pair_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_pair_name", value)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The billing method of the ECP instance. Default value: `PayAsYouGo`. Valid values: `PayAsYouGo`,`Subscription`. **NOTE:** From version 1.232.0, `payment_type` cannot be modified.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The subscription duration. Default value: `1`. Valid values:
        - If `period_unit` is set to `Month`. Valid values: `1`, `2`, `3`, and `6`.
        - If `period_unit` is set to `Year`. Valid values: `1` to `5`.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unit of the subscription duration. Default value: `Month`. Valid values: `Month`, `Year`.
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "period_unit", value)

    @_builtins.property
    @pulumi.getter
    def resolution(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resolution that you want to select for the ECP instance. **NOTE:** From version 1.232.0, `resolution` can be modified.
        """
        return pulumi.get(self, "resolution")

    @resolution.setter
    def resolution(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resolution", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the security group.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_group_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the Instance. Valid values: `Running`, `Stopped`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="vncPassword")
    def vnc_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The VNC password of the instance. The password must be `6` characters in length and can contain only uppercase letters, lowercase letters, and digits.
        """
        return pulumi.get(self, "vnc_password")

    @vnc_password.setter
    def vnc_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vnc_password", value)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the vSwitch.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vswitch_id", value)


@pulumi.type_token("alicloud:ecp/instance:Instance")
class Instance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_pay: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 eip_bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 force: Optional[pulumi.Input[_builtins.bool]] = None,
                 image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 key_pair_name: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.str]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 resolution: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 vnc_password: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Elastic Cloud Phone (ECP) Instance resource.

        For information about Elastic Cloud Phone (ECP) Instance and how to use it, see [What is Instance](https://next.api.aliyun.com/document/cloudphone/2020-12-30/RunInstances).

        > **NOTE:** Available since v1.158.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.ecp.get_zones()
        default_get_instance_types = alicloud.ecp.get_instance_types()
        default_integer = random.index.Integer("default",
            min=10000,
            max=99999)
        default_network = alicloud.vpc.Network("default",
            vpc_name=f"{name}-{default_integer['result']}",
            cidr_block="192.168.0.0/16")
        default_switch = alicloud.vpc.Switch("default",
            vswitch_name=f"{name}-{default_integer['result']}",
            vpc_id=default_network.id,
            cidr_block="192.168.192.0/24",
            zone_id=default.zones[0].zone_id)
        default_security_group = alicloud.ecs.SecurityGroup("default",
            name=f"{name}-{default_integer['result']}",
            vpc_id=default_network.id)
        default_key_pair = alicloud.ecp.KeyPair("default",
            key_pair_name=f"{name}-{default_integer['result']}",
            public_key_body="ssh-rsa AAAAB3Nza12345678qwertyuudsfsg")
        default_instance = alicloud.ecp.Instance("default",
            instance_type=default_get_instance_types.instance_types[0].instance_type,
            image_id="android-image-release5501072_a11_20240530.raw",
            vswitch_id=default_switch.id,
            security_group_id=default_security_group.id,
            key_pair_name=default_key_pair.key_pair_name,
            vnc_password="Ecp123",
            payment_type="PayAsYouGo",
            instance_name=name,
            description=name,
            force=True)
        ```

        ## Import

        Elastic Cloud Phone (ECP) Instance can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ecp/instance:Instance example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] auto_pay: Specifies whether to enable the auto-payment feature. Valid values:
        :param pulumi.Input[_builtins.bool] auto_renew: Specifies whether to enable the auto-renewal feature. Valid values:
        :param pulumi.Input[_builtins.str] description: The description of the ECP instance. The description must be `2` to `256` characters in length and cannot start with `http://` or `https://`.
        :param pulumi.Input[_builtins.int] eip_bandwidth: The bandwidth of the elastic IP address (EIP). **NOTE:** From version 1.232.0, `eip_bandwidth` cannot be modified.
        :param pulumi.Input[_builtins.bool] force: Specifies whether to forcefully stop and release the instance. Default value: `false`. Valid values:
        :param pulumi.Input[_builtins.str] image_id: The ID of the image.
        :param pulumi.Input[_builtins.str] instance_name: The name of the ECP instance. The name must be `2` to `128` characters in length. It must start with a letter but cannot start with `http://` or `https://`. It can contain letters, digits, colons (:), underscores (_), periods (.), and hyphens (-).
        :param pulumi.Input[_builtins.str] instance_type: The specifications of the ECP instance.
        :param pulumi.Input[_builtins.str] key_pair_name: The name of the key pair that you want to use to connect to the instance.
        :param pulumi.Input[_builtins.str] payment_type: The billing method of the ECP instance. Default value: `PayAsYouGo`. Valid values: `PayAsYouGo`,`Subscription`. **NOTE:** From version 1.232.0, `payment_type` cannot be modified.
        :param pulumi.Input[_builtins.str] period: The subscription duration. Default value: `1`. Valid values:
               - If `period_unit` is set to `Month`. Valid values: `1`, `2`, `3`, and `6`.
               - If `period_unit` is set to `Year`. Valid values: `1` to `5`.
        :param pulumi.Input[_builtins.str] period_unit: The unit of the subscription duration. Default value: `Month`. Valid values: `Month`, `Year`.
        :param pulumi.Input[_builtins.str] resolution: The resolution that you want to select for the ECP instance. **NOTE:** From version 1.232.0, `resolution` can be modified.
        :param pulumi.Input[_builtins.str] security_group_id: The ID of the security group.
        :param pulumi.Input[_builtins.str] status: The status of the Instance. Valid values: `Running`, `Stopped`.
        :param pulumi.Input[_builtins.str] vnc_password: The VNC password of the instance. The password must be `6` characters in length and can contain only uppercase letters, lowercase letters, and digits.
        :param pulumi.Input[_builtins.str] vswitch_id: The ID of the vSwitch.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Elastic Cloud Phone (ECP) Instance resource.

        For information about Elastic Cloud Phone (ECP) Instance and how to use it, see [What is Instance](https://next.api.aliyun.com/document/cloudphone/2020-12-30/RunInstances).

        > **NOTE:** Available since v1.158.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.ecp.get_zones()
        default_get_instance_types = alicloud.ecp.get_instance_types()
        default_integer = random.index.Integer("default",
            min=10000,
            max=99999)
        default_network = alicloud.vpc.Network("default",
            vpc_name=f"{name}-{default_integer['result']}",
            cidr_block="192.168.0.0/16")
        default_switch = alicloud.vpc.Switch("default",
            vswitch_name=f"{name}-{default_integer['result']}",
            vpc_id=default_network.id,
            cidr_block="192.168.192.0/24",
            zone_id=default.zones[0].zone_id)
        default_security_group = alicloud.ecs.SecurityGroup("default",
            name=f"{name}-{default_integer['result']}",
            vpc_id=default_network.id)
        default_key_pair = alicloud.ecp.KeyPair("default",
            key_pair_name=f"{name}-{default_integer['result']}",
            public_key_body="ssh-rsa AAAAB3Nza12345678qwertyuudsfsg")
        default_instance = alicloud.ecp.Instance("default",
            instance_type=default_get_instance_types.instance_types[0].instance_type,
            image_id="android-image-release5501072_a11_20240530.raw",
            vswitch_id=default_switch.id,
            security_group_id=default_security_group.id,
            key_pair_name=default_key_pair.key_pair_name,
            vnc_password="Ecp123",
            payment_type="PayAsYouGo",
            instance_name=name,
            description=name,
            force=True)
        ```

        ## Import

        Elastic Cloud Phone (ECP) Instance can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ecp/instance:Instance example <id>
        ```

        :param str resource_name: The name of the resource.
        :param InstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_pay: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 eip_bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 force: Optional[pulumi.Input[_builtins.bool]] = None,
                 image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 key_pair_name: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.str]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 resolution: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 vnc_password: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceArgs.__new__(InstanceArgs)

            __props__.__dict__["auto_pay"] = auto_pay
            __props__.__dict__["auto_renew"] = auto_renew
            __props__.__dict__["description"] = description
            __props__.__dict__["eip_bandwidth"] = eip_bandwidth
            __props__.__dict__["force"] = force
            if image_id is None and not opts.urn:
                raise TypeError("Missing required property 'image_id'")
            __props__.__dict__["image_id"] = image_id
            __props__.__dict__["instance_name"] = instance_name
            if instance_type is None and not opts.urn:
                raise TypeError("Missing required property 'instance_type'")
            __props__.__dict__["instance_type"] = instance_type
            __props__.__dict__["key_pair_name"] = key_pair_name
            __props__.__dict__["payment_type"] = payment_type
            __props__.__dict__["period"] = period
            __props__.__dict__["period_unit"] = period_unit
            __props__.__dict__["resolution"] = resolution
            if security_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'security_group_id'")
            __props__.__dict__["security_group_id"] = security_group_id
            __props__.__dict__["status"] = status
            __props__.__dict__["vnc_password"] = None if vnc_password is None else pulumi.Output.secret(vnc_password)
            if vswitch_id is None and not opts.urn:
                raise TypeError("Missing required property 'vswitch_id'")
            __props__.__dict__["vswitch_id"] = vswitch_id
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["vncPassword"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Instance, __self__).__init__(
            'alicloud:ecp/instance:Instance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_pay: Optional[pulumi.Input[_builtins.bool]] = None,
            auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            eip_bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
            force: Optional[pulumi.Input[_builtins.bool]] = None,
            image_id: Optional[pulumi.Input[_builtins.str]] = None,
            instance_name: Optional[pulumi.Input[_builtins.str]] = None,
            instance_type: Optional[pulumi.Input[_builtins.str]] = None,
            key_pair_name: Optional[pulumi.Input[_builtins.str]] = None,
            payment_type: Optional[pulumi.Input[_builtins.str]] = None,
            period: Optional[pulumi.Input[_builtins.str]] = None,
            period_unit: Optional[pulumi.Input[_builtins.str]] = None,
            resolution: Optional[pulumi.Input[_builtins.str]] = None,
            security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            vnc_password: Optional[pulumi.Input[_builtins.str]] = None,
            vswitch_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'Instance':
        """
        Get an existing Instance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] auto_pay: Specifies whether to enable the auto-payment feature. Valid values:
        :param pulumi.Input[_builtins.bool] auto_renew: Specifies whether to enable the auto-renewal feature. Valid values:
        :param pulumi.Input[_builtins.str] description: The description of the ECP instance. The description must be `2` to `256` characters in length and cannot start with `http://` or `https://`.
        :param pulumi.Input[_builtins.int] eip_bandwidth: The bandwidth of the elastic IP address (EIP). **NOTE:** From version 1.232.0, `eip_bandwidth` cannot be modified.
        :param pulumi.Input[_builtins.bool] force: Specifies whether to forcefully stop and release the instance. Default value: `false`. Valid values:
        :param pulumi.Input[_builtins.str] image_id: The ID of the image.
        :param pulumi.Input[_builtins.str] instance_name: The name of the ECP instance. The name must be `2` to `128` characters in length. It must start with a letter but cannot start with `http://` or `https://`. It can contain letters, digits, colons (:), underscores (_), periods (.), and hyphens (-).
        :param pulumi.Input[_builtins.str] instance_type: The specifications of the ECP instance.
        :param pulumi.Input[_builtins.str] key_pair_name: The name of the key pair that you want to use to connect to the instance.
        :param pulumi.Input[_builtins.str] payment_type: The billing method of the ECP instance. Default value: `PayAsYouGo`. Valid values: `PayAsYouGo`,`Subscription`. **NOTE:** From version 1.232.0, `payment_type` cannot be modified.
        :param pulumi.Input[_builtins.str] period: The subscription duration. Default value: `1`. Valid values:
               - If `period_unit` is set to `Month`. Valid values: `1`, `2`, `3`, and `6`.
               - If `period_unit` is set to `Year`. Valid values: `1` to `5`.
        :param pulumi.Input[_builtins.str] period_unit: The unit of the subscription duration. Default value: `Month`. Valid values: `Month`, `Year`.
        :param pulumi.Input[_builtins.str] resolution: The resolution that you want to select for the ECP instance. **NOTE:** From version 1.232.0, `resolution` can be modified.
        :param pulumi.Input[_builtins.str] security_group_id: The ID of the security group.
        :param pulumi.Input[_builtins.str] status: The status of the Instance. Valid values: `Running`, `Stopped`.
        :param pulumi.Input[_builtins.str] vnc_password: The VNC password of the instance. The password must be `6` characters in length and can contain only uppercase letters, lowercase letters, and digits.
        :param pulumi.Input[_builtins.str] vswitch_id: The ID of the vSwitch.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceState.__new__(_InstanceState)

        __props__.__dict__["auto_pay"] = auto_pay
        __props__.__dict__["auto_renew"] = auto_renew
        __props__.__dict__["description"] = description
        __props__.__dict__["eip_bandwidth"] = eip_bandwidth
        __props__.__dict__["force"] = force
        __props__.__dict__["image_id"] = image_id
        __props__.__dict__["instance_name"] = instance_name
        __props__.__dict__["instance_type"] = instance_type
        __props__.__dict__["key_pair_name"] = key_pair_name
        __props__.__dict__["payment_type"] = payment_type
        __props__.__dict__["period"] = period
        __props__.__dict__["period_unit"] = period_unit
        __props__.__dict__["resolution"] = resolution
        __props__.__dict__["security_group_id"] = security_group_id
        __props__.__dict__["status"] = status
        __props__.__dict__["vnc_password"] = vnc_password
        __props__.__dict__["vswitch_id"] = vswitch_id
        return Instance(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="autoPay")
    def auto_pay(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to enable the auto-payment feature. Valid values:
        """
        return pulumi.get(self, "auto_pay")

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to enable the auto-renewal feature. Valid values:
        """
        return pulumi.get(self, "auto_renew")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the ECP instance. The description must be `2` to `256` characters in length and cannot start with `http://` or `https://`.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="eipBandwidth")
    def eip_bandwidth(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The bandwidth of the elastic IP address (EIP). **NOTE:** From version 1.232.0, `eip_bandwidth` cannot be modified.
        """
        return pulumi.get(self, "eip_bandwidth")

    @_builtins.property
    @pulumi.getter
    def force(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to forcefully stop and release the instance. Default value: `false`. Valid values:
        """
        return pulumi.get(self, "force")

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the image.
        """
        return pulumi.get(self, "image_id")

    @_builtins.property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the ECP instance. The name must be `2` to `128` characters in length. It must start with a letter but cannot start with `http://` or `https://`. It can contain letters, digits, colons (:), underscores (_), periods (.), and hyphens (-).
        """
        return pulumi.get(self, "instance_name")

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Output[_builtins.str]:
        """
        The specifications of the ECP instance.
        """
        return pulumi.get(self, "instance_type")

    @_builtins.property
    @pulumi.getter(name="keyPairName")
    def key_pair_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the key pair that you want to use to connect to the instance.
        """
        return pulumi.get(self, "key_pair_name")

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Output[_builtins.str]:
        """
        The billing method of the ECP instance. Default value: `PayAsYouGo`. Valid values: `PayAsYouGo`,`Subscription`. **NOTE:** From version 1.232.0, `payment_type` cannot be modified.
        """
        return pulumi.get(self, "payment_type")

    @_builtins.property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The subscription duration. Default value: `1`. Valid values:
        - If `period_unit` is set to `Month`. Valid values: `1`, `2`, `3`, and `6`.
        - If `period_unit` is set to `Year`. Valid values: `1` to `5`.
        """
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The unit of the subscription duration. Default value: `Month`. Valid values: `Month`, `Year`.
        """
        return pulumi.get(self, "period_unit")

    @_builtins.property
    @pulumi.getter
    def resolution(self) -> pulumi.Output[_builtins.str]:
        """
        The resolution that you want to select for the ECP instance. **NOTE:** From version 1.232.0, `resolution` can be modified.
        """
        return pulumi.get(self, "resolution")

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the security group.
        """
        return pulumi.get(self, "security_group_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the Instance. Valid values: `Running`, `Stopped`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="vncPassword")
    def vnc_password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The VNC password of the instance. The password must be `6` characters in length and can contain only uppercase letters, lowercase letters, and digits.
        """
        return pulumi.get(self, "vnc_password")

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the vSwitch.
        """
        return pulumi.get(self, "vswitch_id")

