# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AutoSnapshotPolicyArgs', 'AutoSnapshotPolicy']

@pulumi.input_type
class AutoSnapshotPolicyArgs:
    def __init__(__self__, *,
                 repeat_weekdays: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 retention_days: pulumi.Input[_builtins.int],
                 time_points: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 auto_snapshot_policy_name: Optional[pulumi.Input[_builtins.str]] = None,
                 copied_snapshots_retention_days: Optional[pulumi.Input[_builtins.int]] = None,
                 copy_encryption_configuration: Optional[pulumi.Input['AutoSnapshotPolicyCopyEncryptionConfigurationArgs']] = None,
                 enable_cross_region_copy: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 target_copy_regions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a AutoSnapshotPolicy resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] repeat_weekdays: The days of the week on which to create automatic snapshots. Valid values: `1` to `7`, which correspond to the days of the week. For example, `1` indicates Monday. One or more days can be specified.
        :param pulumi.Input[_builtins.int] retention_days: The retention period of the automatic snapshots. Unit: days. Valid values:
               - `-1`: Automatic snapshots are retained until they are deleted.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] time_points: The points in time of the day at which to create automatic snapshots.
               
               The time is displayed in UTC+8. Unit: hours. Valid values: `0` to `23`, which correspond to the 24 points in time on the hour from 00:00:00 to 23:00:00. For example, 1 indicates 01:00:00. Multiple points in time can be specified.
               
               The parameter value is a JSON array that contains up to 24 points in time separated by commas (,). Example: ["0", "1", ... "23"].
               
               The following arguments will be discarded. Please use new fields as soon as possible:
        :param pulumi.Input[_builtins.str] auto_snapshot_policy_name: The name of the automatic snapshot policy. The name must be 2 to 128 characters in length. The name must start with a letter and cannot start with http:// or https://. The name can contain letters, digits, colons (:), underscores (_), and hyphens (-).
        :param pulumi.Input[_builtins.int] copied_snapshots_retention_days: The retention period of the snapshot copy in the destination region. Unit: days. Valid values:
               - `-1`: The snapshot copy is retained until it is deleted.
        :param pulumi.Input['AutoSnapshotPolicyCopyEncryptionConfigurationArgs'] copy_encryption_configuration: The encryption parameters for cross-region snapshot replication. See `copy_encryption_configuration` below.
        :param pulumi.Input[_builtins.bool] enable_cross_region_copy: Specifies whether to enable cross-region replication for snapshots. Valid values: `true`, `false`.
        :param pulumi.Input[_builtins.str] name: . Field `name` has been deprecated from provider version 1.236.0. New field `auto_snapshot_policy_name` instead.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group. If this parameter is specified to query resources, up to 1,000 resources that belong to the specified resource group can be displayed in the response.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] target_copy_regions: The destination region to which to copy the snapshot. You can specify only a single destination region.
        """
        pulumi.set(__self__, "repeat_weekdays", repeat_weekdays)
        pulumi.set(__self__, "retention_days", retention_days)
        pulumi.set(__self__, "time_points", time_points)
        if auto_snapshot_policy_name is not None:
            pulumi.set(__self__, "auto_snapshot_policy_name", auto_snapshot_policy_name)
        if copied_snapshots_retention_days is not None:
            pulumi.set(__self__, "copied_snapshots_retention_days", copied_snapshots_retention_days)
        if copy_encryption_configuration is not None:
            pulumi.set(__self__, "copy_encryption_configuration", copy_encryption_configuration)
        if enable_cross_region_copy is not None:
            pulumi.set(__self__, "enable_cross_region_copy", enable_cross_region_copy)
        if name is not None:
            warnings.warn("""Field `name` has been deprecated from provider version 1.236.0. New field `auto_snapshot_policy_name` instead.""", DeprecationWarning)
            pulumi.log.warn("""name is deprecated: Field `name` has been deprecated from provider version 1.236.0. New field `auto_snapshot_policy_name` instead.""")
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if target_copy_regions is not None:
            pulumi.set(__self__, "target_copy_regions", target_copy_regions)

    @_builtins.property
    @pulumi.getter(name="repeatWeekdays")
    def repeat_weekdays(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The days of the week on which to create automatic snapshots. Valid values: `1` to `7`, which correspond to the days of the week. For example, `1` indicates Monday. One or more days can be specified.
        """
        return pulumi.get(self, "repeat_weekdays")

    @repeat_weekdays.setter
    def repeat_weekdays(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "repeat_weekdays", value)

    @_builtins.property
    @pulumi.getter(name="retentionDays")
    def retention_days(self) -> pulumi.Input[_builtins.int]:
        """
        The retention period of the automatic snapshots. Unit: days. Valid values:
        - `-1`: Automatic snapshots are retained until they are deleted.
        """
        return pulumi.get(self, "retention_days")

    @retention_days.setter
    def retention_days(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "retention_days", value)

    @_builtins.property
    @pulumi.getter(name="timePoints")
    def time_points(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The points in time of the day at which to create automatic snapshots.

        The time is displayed in UTC+8. Unit: hours. Valid values: `0` to `23`, which correspond to the 24 points in time on the hour from 00:00:00 to 23:00:00. For example, 1 indicates 01:00:00. Multiple points in time can be specified.

        The parameter value is a JSON array that contains up to 24 points in time separated by commas (,). Example: ["0", "1", ... "23"].

        The following arguments will be discarded. Please use new fields as soon as possible:
        """
        return pulumi.get(self, "time_points")

    @time_points.setter
    def time_points(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "time_points", value)

    @_builtins.property
    @pulumi.getter(name="autoSnapshotPolicyName")
    def auto_snapshot_policy_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the automatic snapshot policy. The name must be 2 to 128 characters in length. The name must start with a letter and cannot start with http:// or https://. The name can contain letters, digits, colons (:), underscores (_), and hyphens (-).
        """
        return pulumi.get(self, "auto_snapshot_policy_name")

    @auto_snapshot_policy_name.setter
    def auto_snapshot_policy_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_snapshot_policy_name", value)

    @_builtins.property
    @pulumi.getter(name="copiedSnapshotsRetentionDays")
    def copied_snapshots_retention_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The retention period of the snapshot copy in the destination region. Unit: days. Valid values:
        - `-1`: The snapshot copy is retained until it is deleted.
        """
        return pulumi.get(self, "copied_snapshots_retention_days")

    @copied_snapshots_retention_days.setter
    def copied_snapshots_retention_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "copied_snapshots_retention_days", value)

    @_builtins.property
    @pulumi.getter(name="copyEncryptionConfiguration")
    def copy_encryption_configuration(self) -> Optional[pulumi.Input['AutoSnapshotPolicyCopyEncryptionConfigurationArgs']]:
        """
        The encryption parameters for cross-region snapshot replication. See `copy_encryption_configuration` below.
        """
        return pulumi.get(self, "copy_encryption_configuration")

    @copy_encryption_configuration.setter
    def copy_encryption_configuration(self, value: Optional[pulumi.Input['AutoSnapshotPolicyCopyEncryptionConfigurationArgs']]):
        pulumi.set(self, "copy_encryption_configuration", value)

    @_builtins.property
    @pulumi.getter(name="enableCrossRegionCopy")
    def enable_cross_region_copy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable cross-region replication for snapshots. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "enable_cross_region_copy")

    @enable_cross_region_copy.setter
    def enable_cross_region_copy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_cross_region_copy", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field `name` has been deprecated from provider version 1.236.0. New field `auto_snapshot_policy_name` instead.""")
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        . Field `name` has been deprecated from provider version 1.236.0. New field `auto_snapshot_policy_name` instead.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group. If this parameter is specified to query resources, up to 1,000 resources that belong to the specified resource group can be displayed in the response.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="targetCopyRegions")
    def target_copy_regions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The destination region to which to copy the snapshot. You can specify only a single destination region.
        """
        return pulumi.get(self, "target_copy_regions")

    @target_copy_regions.setter
    def target_copy_regions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "target_copy_regions", value)


@pulumi.input_type
class _AutoSnapshotPolicyState:
    def __init__(__self__, *,
                 auto_snapshot_policy_name: Optional[pulumi.Input[_builtins.str]] = None,
                 copied_snapshots_retention_days: Optional[pulumi.Input[_builtins.int]] = None,
                 copy_encryption_configuration: Optional[pulumi.Input['AutoSnapshotPolicyCopyEncryptionConfigurationArgs']] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_cross_region_copy: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 repeat_weekdays: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_days: Optional[pulumi.Input[_builtins.int]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 target_copy_regions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 time_points: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering AutoSnapshotPolicy resources.
        :param pulumi.Input[_builtins.str] auto_snapshot_policy_name: The name of the automatic snapshot policy. The name must be 2 to 128 characters in length. The name must start with a letter and cannot start with http:// or https://. The name can contain letters, digits, colons (:), underscores (_), and hyphens (-).
        :param pulumi.Input[_builtins.int] copied_snapshots_retention_days: The retention period of the snapshot copy in the destination region. Unit: days. Valid values:
               - `-1`: The snapshot copy is retained until it is deleted.
        :param pulumi.Input['AutoSnapshotPolicyCopyEncryptionConfigurationArgs'] copy_encryption_configuration: The encryption parameters for cross-region snapshot replication. See `copy_encryption_configuration` below.
        :param pulumi.Input[_builtins.str] create_time: (Available since v1.236.0) The time when the automatic snapshot policy was created. The time follows the ISO 8601 standard in the yyyy-MM-ddThh:mm:ssZ format. The time is displayed in UTC.
        :param pulumi.Input[_builtins.bool] enable_cross_region_copy: Specifies whether to enable cross-region replication for snapshots. Valid values: `true`, `false`.
        :param pulumi.Input[_builtins.str] name: . Field `name` has been deprecated from provider version 1.236.0. New field `auto_snapshot_policy_name` instead.
        :param pulumi.Input[_builtins.str] region_id: (Available since v1.236.0) The region ID of the automatic snapshot policy.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] repeat_weekdays: The days of the week on which to create automatic snapshots. Valid values: `1` to `7`, which correspond to the days of the week. For example, `1` indicates Monday. One or more days can be specified.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group. If this parameter is specified to query resources, up to 1,000 resources that belong to the specified resource group can be displayed in the response.
        :param pulumi.Input[_builtins.int] retention_days: The retention period of the automatic snapshots. Unit: days. Valid values:
               - `-1`: Automatic snapshots are retained until they are deleted.
        :param pulumi.Input[_builtins.str] status: The status of the automatic snapshot policy.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] target_copy_regions: The destination region to which to copy the snapshot. You can specify only a single destination region.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] time_points: The points in time of the day at which to create automatic snapshots.
               
               The time is displayed in UTC+8. Unit: hours. Valid values: `0` to `23`, which correspond to the 24 points in time on the hour from 00:00:00 to 23:00:00. For example, 1 indicates 01:00:00. Multiple points in time can be specified.
               
               The parameter value is a JSON array that contains up to 24 points in time separated by commas (,). Example: ["0", "1", ... "23"].
               
               The following arguments will be discarded. Please use new fields as soon as possible:
        """
        if auto_snapshot_policy_name is not None:
            pulumi.set(__self__, "auto_snapshot_policy_name", auto_snapshot_policy_name)
        if copied_snapshots_retention_days is not None:
            pulumi.set(__self__, "copied_snapshots_retention_days", copied_snapshots_retention_days)
        if copy_encryption_configuration is not None:
            pulumi.set(__self__, "copy_encryption_configuration", copy_encryption_configuration)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if enable_cross_region_copy is not None:
            pulumi.set(__self__, "enable_cross_region_copy", enable_cross_region_copy)
        if name is not None:
            warnings.warn("""Field `name` has been deprecated from provider version 1.236.0. New field `auto_snapshot_policy_name` instead.""", DeprecationWarning)
            pulumi.log.warn("""name is deprecated: Field `name` has been deprecated from provider version 1.236.0. New field `auto_snapshot_policy_name` instead.""")
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region_id is not None:
            pulumi.set(__self__, "region_id", region_id)
        if repeat_weekdays is not None:
            pulumi.set(__self__, "repeat_weekdays", repeat_weekdays)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if retention_days is not None:
            pulumi.set(__self__, "retention_days", retention_days)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if target_copy_regions is not None:
            pulumi.set(__self__, "target_copy_regions", target_copy_regions)
        if time_points is not None:
            pulumi.set(__self__, "time_points", time_points)

    @_builtins.property
    @pulumi.getter(name="autoSnapshotPolicyName")
    def auto_snapshot_policy_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the automatic snapshot policy. The name must be 2 to 128 characters in length. The name must start with a letter and cannot start with http:// or https://. The name can contain letters, digits, colons (:), underscores (_), and hyphens (-).
        """
        return pulumi.get(self, "auto_snapshot_policy_name")

    @auto_snapshot_policy_name.setter
    def auto_snapshot_policy_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_snapshot_policy_name", value)

    @_builtins.property
    @pulumi.getter(name="copiedSnapshotsRetentionDays")
    def copied_snapshots_retention_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The retention period of the snapshot copy in the destination region. Unit: days. Valid values:
        - `-1`: The snapshot copy is retained until it is deleted.
        """
        return pulumi.get(self, "copied_snapshots_retention_days")

    @copied_snapshots_retention_days.setter
    def copied_snapshots_retention_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "copied_snapshots_retention_days", value)

    @_builtins.property
    @pulumi.getter(name="copyEncryptionConfiguration")
    def copy_encryption_configuration(self) -> Optional[pulumi.Input['AutoSnapshotPolicyCopyEncryptionConfigurationArgs']]:
        """
        The encryption parameters for cross-region snapshot replication. See `copy_encryption_configuration` below.
        """
        return pulumi.get(self, "copy_encryption_configuration")

    @copy_encryption_configuration.setter
    def copy_encryption_configuration(self, value: Optional[pulumi.Input['AutoSnapshotPolicyCopyEncryptionConfigurationArgs']]):
        pulumi.set(self, "copy_encryption_configuration", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Available since v1.236.0) The time when the automatic snapshot policy was created. The time follows the ISO 8601 standard in the yyyy-MM-ddThh:mm:ssZ format. The time is displayed in UTC.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="enableCrossRegionCopy")
    def enable_cross_region_copy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable cross-region replication for snapshots. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "enable_cross_region_copy")

    @enable_cross_region_copy.setter
    def enable_cross_region_copy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_cross_region_copy", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field `name` has been deprecated from provider version 1.236.0. New field `auto_snapshot_policy_name` instead.""")
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        . Field `name` has been deprecated from provider version 1.236.0. New field `auto_snapshot_policy_name` instead.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Available since v1.236.0) The region ID of the automatic snapshot policy.
        """
        return pulumi.get(self, "region_id")

    @region_id.setter
    def region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region_id", value)

    @_builtins.property
    @pulumi.getter(name="repeatWeekdays")
    def repeat_weekdays(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The days of the week on which to create automatic snapshots. Valid values: `1` to `7`, which correspond to the days of the week. For example, `1` indicates Monday. One or more days can be specified.
        """
        return pulumi.get(self, "repeat_weekdays")

    @repeat_weekdays.setter
    def repeat_weekdays(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "repeat_weekdays", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group. If this parameter is specified to query resources, up to 1,000 resources that belong to the specified resource group can be displayed in the response.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="retentionDays")
    def retention_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The retention period of the automatic snapshots. Unit: days. Valid values:
        - `-1`: Automatic snapshots are retained until they are deleted.
        """
        return pulumi.get(self, "retention_days")

    @retention_days.setter
    def retention_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "retention_days", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the automatic snapshot policy.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="targetCopyRegions")
    def target_copy_regions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The destination region to which to copy the snapshot. You can specify only a single destination region.
        """
        return pulumi.get(self, "target_copy_regions")

    @target_copy_regions.setter
    def target_copy_regions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "target_copy_regions", value)

    @_builtins.property
    @pulumi.getter(name="timePoints")
    def time_points(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The points in time of the day at which to create automatic snapshots.

        The time is displayed in UTC+8. Unit: hours. Valid values: `0` to `23`, which correspond to the 24 points in time on the hour from 00:00:00 to 23:00:00. For example, 1 indicates 01:00:00. Multiple points in time can be specified.

        The parameter value is a JSON array that contains up to 24 points in time separated by commas (,). Example: ["0", "1", ... "23"].

        The following arguments will be discarded. Please use new fields as soon as possible:
        """
        return pulumi.get(self, "time_points")

    @time_points.setter
    def time_points(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "time_points", value)


@pulumi.type_token("alicloud:ecs/autoSnapshotPolicy:AutoSnapshotPolicy")
class AutoSnapshotPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_snapshot_policy_name: Optional[pulumi.Input[_builtins.str]] = None,
                 copied_snapshots_retention_days: Optional[pulumi.Input[_builtins.int]] = None,
                 copy_encryption_configuration: Optional[pulumi.Input[Union['AutoSnapshotPolicyCopyEncryptionConfigurationArgs', 'AutoSnapshotPolicyCopyEncryptionConfigurationArgsDict']]] = None,
                 enable_cross_region_copy: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 repeat_weekdays: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_days: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 target_copy_regions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 time_points: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Provides a ECS Auto Snapshot Policy resource.

        For information about ECS Auto Snapshot Policy and how to use it, see [What is Auto Snapshot Policy](https://www.alibabacloud.com/help/en/doc-detail/25527.htm).

        > **NOTE:** Available since v1.117.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        example = alicloud.ecs.AutoSnapshotPolicy("example",
            name="terraform-example",
            repeat_weekdays=[
                "1",
                "2",
                "3",
            ],
            retention_days=-1,
            time_points=[
                "1",
                "22",
                "23",
            ])
        ```

        ## Import

        ECS Auto Snapshot Policy can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ecs/autoSnapshotPolicy:AutoSnapshotPolicy example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] auto_snapshot_policy_name: The name of the automatic snapshot policy. The name must be 2 to 128 characters in length. The name must start with a letter and cannot start with http:// or https://. The name can contain letters, digits, colons (:), underscores (_), and hyphens (-).
        :param pulumi.Input[_builtins.int] copied_snapshots_retention_days: The retention period of the snapshot copy in the destination region. Unit: days. Valid values:
               - `-1`: The snapshot copy is retained until it is deleted.
        :param pulumi.Input[Union['AutoSnapshotPolicyCopyEncryptionConfigurationArgs', 'AutoSnapshotPolicyCopyEncryptionConfigurationArgsDict']] copy_encryption_configuration: The encryption parameters for cross-region snapshot replication. See `copy_encryption_configuration` below.
        :param pulumi.Input[_builtins.bool] enable_cross_region_copy: Specifies whether to enable cross-region replication for snapshots. Valid values: `true`, `false`.
        :param pulumi.Input[_builtins.str] name: . Field `name` has been deprecated from provider version 1.236.0. New field `auto_snapshot_policy_name` instead.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] repeat_weekdays: The days of the week on which to create automatic snapshots. Valid values: `1` to `7`, which correspond to the days of the week. For example, `1` indicates Monday. One or more days can be specified.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group. If this parameter is specified to query resources, up to 1,000 resources that belong to the specified resource group can be displayed in the response.
        :param pulumi.Input[_builtins.int] retention_days: The retention period of the automatic snapshots. Unit: days. Valid values:
               - `-1`: Automatic snapshots are retained until they are deleted.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] target_copy_regions: The destination region to which to copy the snapshot. You can specify only a single destination region.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] time_points: The points in time of the day at which to create automatic snapshots.
               
               The time is displayed in UTC+8. Unit: hours. Valid values: `0` to `23`, which correspond to the 24 points in time on the hour from 00:00:00 to 23:00:00. For example, 1 indicates 01:00:00. Multiple points in time can be specified.
               
               The parameter value is a JSON array that contains up to 24 points in time separated by commas (,). Example: ["0", "1", ... "23"].
               
               The following arguments will be discarded. Please use new fields as soon as possible:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AutoSnapshotPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a ECS Auto Snapshot Policy resource.

        For information about ECS Auto Snapshot Policy and how to use it, see [What is Auto Snapshot Policy](https://www.alibabacloud.com/help/en/doc-detail/25527.htm).

        > **NOTE:** Available since v1.117.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        example = alicloud.ecs.AutoSnapshotPolicy("example",
            name="terraform-example",
            repeat_weekdays=[
                "1",
                "2",
                "3",
            ],
            retention_days=-1,
            time_points=[
                "1",
                "22",
                "23",
            ])
        ```

        ## Import

        ECS Auto Snapshot Policy can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ecs/autoSnapshotPolicy:AutoSnapshotPolicy example <id>
        ```

        :param str resource_name: The name of the resource.
        :param AutoSnapshotPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AutoSnapshotPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_snapshot_policy_name: Optional[pulumi.Input[_builtins.str]] = None,
                 copied_snapshots_retention_days: Optional[pulumi.Input[_builtins.int]] = None,
                 copy_encryption_configuration: Optional[pulumi.Input[Union['AutoSnapshotPolicyCopyEncryptionConfigurationArgs', 'AutoSnapshotPolicyCopyEncryptionConfigurationArgsDict']]] = None,
                 enable_cross_region_copy: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 repeat_weekdays: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_days: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 target_copy_regions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 time_points: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AutoSnapshotPolicyArgs.__new__(AutoSnapshotPolicyArgs)

            __props__.__dict__["auto_snapshot_policy_name"] = auto_snapshot_policy_name
            __props__.__dict__["copied_snapshots_retention_days"] = copied_snapshots_retention_days
            __props__.__dict__["copy_encryption_configuration"] = copy_encryption_configuration
            __props__.__dict__["enable_cross_region_copy"] = enable_cross_region_copy
            __props__.__dict__["name"] = name
            if repeat_weekdays is None and not opts.urn:
                raise TypeError("Missing required property 'repeat_weekdays'")
            __props__.__dict__["repeat_weekdays"] = repeat_weekdays
            __props__.__dict__["resource_group_id"] = resource_group_id
            if retention_days is None and not opts.urn:
                raise TypeError("Missing required property 'retention_days'")
            __props__.__dict__["retention_days"] = retention_days
            __props__.__dict__["tags"] = tags
            __props__.__dict__["target_copy_regions"] = target_copy_regions
            if time_points is None and not opts.urn:
                raise TypeError("Missing required property 'time_points'")
            __props__.__dict__["time_points"] = time_points
            __props__.__dict__["create_time"] = None
            __props__.__dict__["region_id"] = None
            __props__.__dict__["status"] = None
        super(AutoSnapshotPolicy, __self__).__init__(
            'alicloud:ecs/autoSnapshotPolicy:AutoSnapshotPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_snapshot_policy_name: Optional[pulumi.Input[_builtins.str]] = None,
            copied_snapshots_retention_days: Optional[pulumi.Input[_builtins.int]] = None,
            copy_encryption_configuration: Optional[pulumi.Input[Union['AutoSnapshotPolicyCopyEncryptionConfigurationArgs', 'AutoSnapshotPolicyCopyEncryptionConfigurationArgsDict']]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            enable_cross_region_copy: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            region_id: Optional[pulumi.Input[_builtins.str]] = None,
            repeat_weekdays: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            retention_days: Optional[pulumi.Input[_builtins.int]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            target_copy_regions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            time_points: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'AutoSnapshotPolicy':
        """
        Get an existing AutoSnapshotPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] auto_snapshot_policy_name: The name of the automatic snapshot policy. The name must be 2 to 128 characters in length. The name must start with a letter and cannot start with http:// or https://. The name can contain letters, digits, colons (:), underscores (_), and hyphens (-).
        :param pulumi.Input[_builtins.int] copied_snapshots_retention_days: The retention period of the snapshot copy in the destination region. Unit: days. Valid values:
               - `-1`: The snapshot copy is retained until it is deleted.
        :param pulumi.Input[Union['AutoSnapshotPolicyCopyEncryptionConfigurationArgs', 'AutoSnapshotPolicyCopyEncryptionConfigurationArgsDict']] copy_encryption_configuration: The encryption parameters for cross-region snapshot replication. See `copy_encryption_configuration` below.
        :param pulumi.Input[_builtins.str] create_time: (Available since v1.236.0) The time when the automatic snapshot policy was created. The time follows the ISO 8601 standard in the yyyy-MM-ddThh:mm:ssZ format. The time is displayed in UTC.
        :param pulumi.Input[_builtins.bool] enable_cross_region_copy: Specifies whether to enable cross-region replication for snapshots. Valid values: `true`, `false`.
        :param pulumi.Input[_builtins.str] name: . Field `name` has been deprecated from provider version 1.236.0. New field `auto_snapshot_policy_name` instead.
        :param pulumi.Input[_builtins.str] region_id: (Available since v1.236.0) The region ID of the automatic snapshot policy.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] repeat_weekdays: The days of the week on which to create automatic snapshots. Valid values: `1` to `7`, which correspond to the days of the week. For example, `1` indicates Monday. One or more days can be specified.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group. If this parameter is specified to query resources, up to 1,000 resources that belong to the specified resource group can be displayed in the response.
        :param pulumi.Input[_builtins.int] retention_days: The retention period of the automatic snapshots. Unit: days. Valid values:
               - `-1`: Automatic snapshots are retained until they are deleted.
        :param pulumi.Input[_builtins.str] status: The status of the automatic snapshot policy.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] target_copy_regions: The destination region to which to copy the snapshot. You can specify only a single destination region.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] time_points: The points in time of the day at which to create automatic snapshots.
               
               The time is displayed in UTC+8. Unit: hours. Valid values: `0` to `23`, which correspond to the 24 points in time on the hour from 00:00:00 to 23:00:00. For example, 1 indicates 01:00:00. Multiple points in time can be specified.
               
               The parameter value is a JSON array that contains up to 24 points in time separated by commas (,). Example: ["0", "1", ... "23"].
               
               The following arguments will be discarded. Please use new fields as soon as possible:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AutoSnapshotPolicyState.__new__(_AutoSnapshotPolicyState)

        __props__.__dict__["auto_snapshot_policy_name"] = auto_snapshot_policy_name
        __props__.__dict__["copied_snapshots_retention_days"] = copied_snapshots_retention_days
        __props__.__dict__["copy_encryption_configuration"] = copy_encryption_configuration
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["enable_cross_region_copy"] = enable_cross_region_copy
        __props__.__dict__["name"] = name
        __props__.__dict__["region_id"] = region_id
        __props__.__dict__["repeat_weekdays"] = repeat_weekdays
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["retention_days"] = retention_days
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["target_copy_regions"] = target_copy_regions
        __props__.__dict__["time_points"] = time_points
        return AutoSnapshotPolicy(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="autoSnapshotPolicyName")
    def auto_snapshot_policy_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the automatic snapshot policy. The name must be 2 to 128 characters in length. The name must start with a letter and cannot start with http:// or https://. The name can contain letters, digits, colons (:), underscores (_), and hyphens (-).
        """
        return pulumi.get(self, "auto_snapshot_policy_name")

    @_builtins.property
    @pulumi.getter(name="copiedSnapshotsRetentionDays")
    def copied_snapshots_retention_days(self) -> pulumi.Output[_builtins.int]:
        """
        The retention period of the snapshot copy in the destination region. Unit: days. Valid values:
        - `-1`: The snapshot copy is retained until it is deleted.
        """
        return pulumi.get(self, "copied_snapshots_retention_days")

    @_builtins.property
    @pulumi.getter(name="copyEncryptionConfiguration")
    def copy_encryption_configuration(self) -> pulumi.Output[Optional['outputs.AutoSnapshotPolicyCopyEncryptionConfiguration']]:
        """
        The encryption parameters for cross-region snapshot replication. See `copy_encryption_configuration` below.
        """
        return pulumi.get(self, "copy_encryption_configuration")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        (Available since v1.236.0) The time when the automatic snapshot policy was created. The time follows the ISO 8601 standard in the yyyy-MM-ddThh:mm:ssZ format. The time is displayed in UTC.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="enableCrossRegionCopy")
    def enable_cross_region_copy(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to enable cross-region replication for snapshots. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "enable_cross_region_copy")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field `name` has been deprecated from provider version 1.236.0. New field `auto_snapshot_policy_name` instead.""")
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        . Field `name` has been deprecated from provider version 1.236.0. New field `auto_snapshot_policy_name` instead.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Available since v1.236.0) The region ID of the automatic snapshot policy.
        """
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter(name="repeatWeekdays")
    def repeat_weekdays(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The days of the week on which to create automatic snapshots. Valid values: `1` to `7`, which correspond to the days of the week. For example, `1` indicates Monday. One or more days can be specified.
        """
        return pulumi.get(self, "repeat_weekdays")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the resource group. If this parameter is specified to query resources, up to 1,000 resources that belong to the specified resource group can be displayed in the response.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="retentionDays")
    def retention_days(self) -> pulumi.Output[_builtins.int]:
        """
        The retention period of the automatic snapshots. Unit: days. Valid values:
        - `-1`: Automatic snapshots are retained until they are deleted.
        """
        return pulumi.get(self, "retention_days")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the automatic snapshot policy.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="targetCopyRegions")
    def target_copy_regions(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The destination region to which to copy the snapshot. You can specify only a single destination region.
        """
        return pulumi.get(self, "target_copy_regions")

    @_builtins.property
    @pulumi.getter(name="timePoints")
    def time_points(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The points in time of the day at which to create automatic snapshots.

        The time is displayed in UTC+8. Unit: hours. Valid values: `0` to `23`, which correspond to the 24 points in time on the hour from 00:00:00 to 23:00:00. For example, 1 indicates 01:00:00. Multiple points in time can be specified.

        The parameter value is a JSON array that contains up to 24 points in time separated by commas (,). Example: ["0", "1", ... "23"].

        The following arguments will be discarded. Please use new fields as soon as possible:
        """
        return pulumi.get(self, "time_points")

