# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetInstanceKeywordsResult',
    'AwaitableGetInstanceKeywordsResult',
    'get_instance_keywords',
    'get_instance_keywords_output',
]

@pulumi.output_type
class GetInstanceKeywordsResult:
    """
    A collection of values returned by getInstanceKeywords.
    """
    def __init__(__self__, id=None, ids=None, key=None, keywords=None, output_file=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if key and not isinstance(key, str):
            raise TypeError("Expected argument 'key' to be a str")
        pulumi.set(__self__, "key", key)
        if keywords and not isinstance(keywords, list):
            raise TypeError("Expected argument 'keywords' to be a list")
        pulumi.set(__self__, "keywords", keywords)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        """
        A list of keywords.
        """
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def keywords(self) -> Sequence[_builtins.str]:
        """
        An array that consists of reserved keywords.
        """
        return pulumi.get(self, "keywords")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")


class AwaitableGetInstanceKeywordsResult(GetInstanceKeywordsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetInstanceKeywordsResult(
            id=self.id,
            ids=self.ids,
            key=self.key,
            keywords=self.keywords,
            output_file=self.output_file)


def get_instance_keywords(key: Optional[_builtins.str] = None,
                          output_file: Optional[_builtins.str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetInstanceKeywordsResult:
    """
    Operation to query the reserved keywords of an ApsaraDB RDS instance. The reserved keywords cannot be used for the usernames of accounts or the names of databases.

    > **NOTE:** Available in v1.196.0+

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    resources = alicloud.ecs.get_instance_keywords(key="account",
        output_file="./classes.txt")
    pulumi.export("accountKeywords", resources.keywords[0])
    ```


    :param _builtins.str key: The type of reserved keyword to query. Valid values: `account`, `database`.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi up`).
    """
    __args__ = dict()
    __args__['key'] = key
    __args__['outputFile'] = output_file
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:ecs/getInstanceKeywords:getInstanceKeywords', __args__, opts=opts, typ=GetInstanceKeywordsResult).value

    return AwaitableGetInstanceKeywordsResult(
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        key=pulumi.get(__ret__, 'key'),
        keywords=pulumi.get(__ret__, 'keywords'),
        output_file=pulumi.get(__ret__, 'output_file'))
def get_instance_keywords_output(key: Optional[pulumi.Input[_builtins.str]] = None,
                                 output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetInstanceKeywordsResult]:
    """
    Operation to query the reserved keywords of an ApsaraDB RDS instance. The reserved keywords cannot be used for the usernames of accounts or the names of databases.

    > **NOTE:** Available in v1.196.0+

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    resources = alicloud.ecs.get_instance_keywords(key="account",
        output_file="./classes.txt")
    pulumi.export("accountKeywords", resources.keywords[0])
    ```


    :param _builtins.str key: The type of reserved keyword to query. Valid values: `account`, `database`.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi up`).
    """
    __args__ = dict()
    __args__['key'] = key
    __args__['outputFile'] = output_file
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:ecs/getInstanceKeywords:getInstanceKeywords', __args__, opts=opts, typ=GetInstanceKeywordsResult)
    return __ret__.apply(lambda __response__: GetInstanceKeywordsResult(
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        key=pulumi.get(__response__, 'key'),
        keywords=pulumi.get(__response__, 'keywords'),
        output_file=pulumi.get(__response__, 'output_file')))
