# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['K8sClusterArgs', 'K8sCluster']

@pulumi.input_type
class K8sClusterArgs:
    def __init__(__self__, *,
                 cs_cluster_id: pulumi.Input[_builtins.str],
                 namespace_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a K8sCluster resource.
        :param pulumi.Input[_builtins.str] cs_cluster_id: The ID of the alicloud container service kubernetes cluster that you want to import.
        :param pulumi.Input[_builtins.str] namespace_id: The ID of the namespace where you want to import. You can call the [ListUserDefineRegion](https://www.alibabacloud.com/help/en/doc-detail/149377.htm?spm=a2c63.p38356.879954.34.331054faK2yNvC#doc-api-Edas-ListUserDefineRegion) operation to query the namespace ID.
        """
        pulumi.set(__self__, "cs_cluster_id", cs_cluster_id)
        if namespace_id is not None:
            pulumi.set(__self__, "namespace_id", namespace_id)

    @_builtins.property
    @pulumi.getter(name="csClusterId")
    def cs_cluster_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the alicloud container service kubernetes cluster that you want to import.
        """
        return pulumi.get(self, "cs_cluster_id")

    @cs_cluster_id.setter
    def cs_cluster_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cs_cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="namespaceId")
    def namespace_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the namespace where you want to import. You can call the [ListUserDefineRegion](https://www.alibabacloud.com/help/en/doc-detail/149377.htm?spm=a2c63.p38356.879954.34.331054faK2yNvC#doc-api-Edas-ListUserDefineRegion) operation to query the namespace ID.
        """
        return pulumi.get(self, "namespace_id")

    @namespace_id.setter
    def namespace_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace_id", value)


@pulumi.input_type
class _K8sClusterState:
    def __init__(__self__, *,
                 cluster_import_status: Optional[pulumi.Input[_builtins.int]] = None,
                 cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_type: Optional[pulumi.Input[_builtins.int]] = None,
                 cs_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 network_mode: Optional[pulumi.Input[_builtins.int]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering K8sCluster resources.
        :param pulumi.Input[_builtins.int] cluster_import_status: The import status of cluster: 
               `1`: success.
               `2`: failed.
               `3`: importing.
               `4`: deleted.
        :param pulumi.Input[_builtins.str] cluster_name: The name of the cluster that you want to create.
        :param pulumi.Input[_builtins.int] cluster_type: The type of the cluster that you want to create. Valid values only: 5: K8s cluster.
        :param pulumi.Input[_builtins.str] cs_cluster_id: The ID of the alicloud container service kubernetes cluster that you want to import.
        :param pulumi.Input[_builtins.str] namespace_id: The ID of the namespace where you want to import. You can call the [ListUserDefineRegion](https://www.alibabacloud.com/help/en/doc-detail/149377.htm?spm=a2c63.p38356.879954.34.331054faK2yNvC#doc-api-Edas-ListUserDefineRegion) operation to query the namespace ID.
        :param pulumi.Input[_builtins.int] network_mode: The network type of the cluster that you want to create. Valid values: 1: classic network. 2: VPC.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the Virtual Private Cloud (VPC) for the cluster.
        """
        if cluster_import_status is not None:
            pulumi.set(__self__, "cluster_import_status", cluster_import_status)
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if cluster_type is not None:
            pulumi.set(__self__, "cluster_type", cluster_type)
        if cs_cluster_id is not None:
            pulumi.set(__self__, "cs_cluster_id", cs_cluster_id)
        if namespace_id is not None:
            pulumi.set(__self__, "namespace_id", namespace_id)
        if network_mode is not None:
            pulumi.set(__self__, "network_mode", network_mode)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter(name="clusterImportStatus")
    def cluster_import_status(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The import status of cluster: 
        `1`: success.
        `2`: failed.
        `3`: importing.
        `4`: deleted.
        """
        return pulumi.get(self, "cluster_import_status")

    @cluster_import_status.setter
    def cluster_import_status(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cluster_import_status", value)

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the cluster that you want to create.
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_name", value)

    @_builtins.property
    @pulumi.getter(name="clusterType")
    def cluster_type(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The type of the cluster that you want to create. Valid values only: 5: K8s cluster.
        """
        return pulumi.get(self, "cluster_type")

    @cluster_type.setter
    def cluster_type(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cluster_type", value)

    @_builtins.property
    @pulumi.getter(name="csClusterId")
    def cs_cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the alicloud container service kubernetes cluster that you want to import.
        """
        return pulumi.get(self, "cs_cluster_id")

    @cs_cluster_id.setter
    def cs_cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cs_cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="namespaceId")
    def namespace_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the namespace where you want to import. You can call the [ListUserDefineRegion](https://www.alibabacloud.com/help/en/doc-detail/149377.htm?spm=a2c63.p38356.879954.34.331054faK2yNvC#doc-api-Edas-ListUserDefineRegion) operation to query the namespace ID.
        """
        return pulumi.get(self, "namespace_id")

    @namespace_id.setter
    def namespace_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace_id", value)

    @_builtins.property
    @pulumi.getter(name="networkMode")
    def network_mode(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The network type of the cluster that you want to create. Valid values: 1: classic network. 2: VPC.
        """
        return pulumi.get(self, "network_mode")

    @network_mode.setter
    def network_mode(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "network_mode", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Virtual Private Cloud (VPC) for the cluster.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)


@pulumi.type_token("alicloud:edas/k8sCluster:K8sCluster")
class K8sCluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cs_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides an EDAS K8s cluster resource. For information about EDAS K8s Cluster and how to use it, see[What is EDAS K8s Cluster](https://www.alibabacloud.com/help/en/doc-detail/85108.htm).

        > **NOTE:** Available since v1.93.0.

        ## Import

        EDAS cluster can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:edas/k8sCluster:K8sCluster cluster cluster_id
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cs_cluster_id: The ID of the alicloud container service kubernetes cluster that you want to import.
        :param pulumi.Input[_builtins.str] namespace_id: The ID of the namespace where you want to import. You can call the [ListUserDefineRegion](https://www.alibabacloud.com/help/en/doc-detail/149377.htm?spm=a2c63.p38356.879954.34.331054faK2yNvC#doc-api-Edas-ListUserDefineRegion) operation to query the namespace ID.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: K8sClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an EDAS K8s cluster resource. For information about EDAS K8s Cluster and how to use it, see[What is EDAS K8s Cluster](https://www.alibabacloud.com/help/en/doc-detail/85108.htm).

        > **NOTE:** Available since v1.93.0.

        ## Import

        EDAS cluster can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:edas/k8sCluster:K8sCluster cluster cluster_id
        ```

        :param str resource_name: The name of the resource.
        :param K8sClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(K8sClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cs_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = K8sClusterArgs.__new__(K8sClusterArgs)

            if cs_cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'cs_cluster_id'")
            __props__.__dict__["cs_cluster_id"] = cs_cluster_id
            __props__.__dict__["namespace_id"] = namespace_id
            __props__.__dict__["cluster_import_status"] = None
            __props__.__dict__["cluster_name"] = None
            __props__.__dict__["cluster_type"] = None
            __props__.__dict__["network_mode"] = None
            __props__.__dict__["vpc_id"] = None
        super(K8sCluster, __self__).__init__(
            'alicloud:edas/k8sCluster:K8sCluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cluster_import_status: Optional[pulumi.Input[_builtins.int]] = None,
            cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
            cluster_type: Optional[pulumi.Input[_builtins.int]] = None,
            cs_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
            namespace_id: Optional[pulumi.Input[_builtins.str]] = None,
            network_mode: Optional[pulumi.Input[_builtins.int]] = None,
            vpc_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'K8sCluster':
        """
        Get an existing K8sCluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] cluster_import_status: The import status of cluster: 
               `1`: success.
               `2`: failed.
               `3`: importing.
               `4`: deleted.
        :param pulumi.Input[_builtins.str] cluster_name: The name of the cluster that you want to create.
        :param pulumi.Input[_builtins.int] cluster_type: The type of the cluster that you want to create. Valid values only: 5: K8s cluster.
        :param pulumi.Input[_builtins.str] cs_cluster_id: The ID of the alicloud container service kubernetes cluster that you want to import.
        :param pulumi.Input[_builtins.str] namespace_id: The ID of the namespace where you want to import. You can call the [ListUserDefineRegion](https://www.alibabacloud.com/help/en/doc-detail/149377.htm?spm=a2c63.p38356.879954.34.331054faK2yNvC#doc-api-Edas-ListUserDefineRegion) operation to query the namespace ID.
        :param pulumi.Input[_builtins.int] network_mode: The network type of the cluster that you want to create. Valid values: 1: classic network. 2: VPC.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the Virtual Private Cloud (VPC) for the cluster.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _K8sClusterState.__new__(_K8sClusterState)

        __props__.__dict__["cluster_import_status"] = cluster_import_status
        __props__.__dict__["cluster_name"] = cluster_name
        __props__.__dict__["cluster_type"] = cluster_type
        __props__.__dict__["cs_cluster_id"] = cs_cluster_id
        __props__.__dict__["namespace_id"] = namespace_id
        __props__.__dict__["network_mode"] = network_mode
        __props__.__dict__["vpc_id"] = vpc_id
        return K8sCluster(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="clusterImportStatus")
    def cluster_import_status(self) -> pulumi.Output[_builtins.int]:
        """
        The import status of cluster: 
        `1`: success.
        `2`: failed.
        `3`: importing.
        `4`: deleted.
        """
        return pulumi.get(self, "cluster_import_status")

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the cluster that you want to create.
        """
        return pulumi.get(self, "cluster_name")

    @_builtins.property
    @pulumi.getter(name="clusterType")
    def cluster_type(self) -> pulumi.Output[_builtins.int]:
        """
        The type of the cluster that you want to create. Valid values only: 5: K8s cluster.
        """
        return pulumi.get(self, "cluster_type")

    @_builtins.property
    @pulumi.getter(name="csClusterId")
    def cs_cluster_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the alicloud container service kubernetes cluster that you want to import.
        """
        return pulumi.get(self, "cs_cluster_id")

    @_builtins.property
    @pulumi.getter(name="namespaceId")
    def namespace_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the namespace where you want to import. You can call the [ListUserDefineRegion](https://www.alibabacloud.com/help/en/doc-detail/149377.htm?spm=a2c63.p38356.879954.34.331054faK2yNvC#doc-api-Edas-ListUserDefineRegion) operation to query the namespace ID.
        """
        return pulumi.get(self, "namespace_id")

    @_builtins.property
    @pulumi.getter(name="networkMode")
    def network_mode(self) -> pulumi.Output[_builtins.int]:
        """
        The network type of the cluster that you want to create. Valid values: 1: classic network. 2: VPC.
        """
        return pulumi.get(self, "network_mode")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Virtual Private Cloud (VPC) for the cluster.
        """
        return pulumi.get(self, "vpc_id")

