# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ClusterArgs', 'Cluster']

@pulumi.input_type
class ClusterArgs:
    def __init__(__self__, *,
                 cluster_type: pulumi.Input[_builtins.str],
                 emr_ver: pulumi.Input[_builtins.str],
                 zone_id: pulumi.Input[_builtins.str],
                 bootstrap_actions: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterBootstrapActionArgs']]]] = None,
                 charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 configs: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterConfigArgs']]]] = None,
                 deposit_type: Optional[pulumi.Input[_builtins.str]] = None,
                 eas_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 high_availability_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 host_groups: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterHostGroupArgs']]]] = None,
                 is_open_public_ip: Optional[pulumi.Input[_builtins.bool]] = None,
                 key_pair_name: Optional[pulumi.Input[_builtins.str]] = None,
                 master_pwd: Optional[pulumi.Input[_builtins.str]] = None,
                 meta_store_conf: Optional[pulumi.Input['ClusterMetaStoreConfArgs']] = None,
                 meta_store_type: Optional[pulumi.Input[_builtins.str]] = None,
                 modify_cluster_service_config: Optional[pulumi.Input['ClusterModifyClusterServiceConfigArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 option_software_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 related_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ssh_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 use_local_metadb: Optional[pulumi.Input[_builtins.bool]] = None,
                 user_defined_emr_ecs_role: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Cluster resource.
        :param pulumi.Input[_builtins.str] cluster_type: EMR Cluster Type, e.g. HADOOP, KAFKA, DRUID, GATEWAY etc. You can find all valid EMR cluster type in emr web console. Supported 'GATEWAY' available in 1.61.0+.
        :param pulumi.Input[_builtins.str] emr_ver: EMR Version, e.g. EMR-3.22.0. You can find the all valid EMR Version in emr web console.
        :param pulumi.Input[_builtins.str] zone_id: Zone ID, e.g. cn-huhehaote-a
        :param pulumi.Input[Sequence[pulumi.Input['ClusterBootstrapActionArgs']]] bootstrap_actions: Boot action parameters.
        :param pulumi.Input[_builtins.str] charge_type: Charge Type for this cluster. Supported value: PostPaid or PrePaid. Default value: PostPaid.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterConfigArgs']]] configs: The custom configurations of emr-cluster service.
        :param pulumi.Input[_builtins.str] deposit_type: Cluster deposit type, HALF_MANAGED or FULL_MANAGED.
        :param pulumi.Input[_builtins.bool] eas_enable: High security cluster (true) or not. Default value is false.
        :param pulumi.Input[_builtins.bool] high_availability_enable: High Available for HDFS and YARN. If this is set true, MASTER group must have two nodes.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterHostGroupArgs']]] host_groups: Groups of Host, You can specify MASTER as a group, CORE as a group (just like the above example).
        :param pulumi.Input[_builtins.bool] is_open_public_ip: Whether the MASTER node has a public IP address enabled. Default value is false.
        :param pulumi.Input[_builtins.str] key_pair_name: Ssh key pair.
        :param pulumi.Input[_builtins.str] master_pwd: Master ssh password.
        :param pulumi.Input['ClusterMetaStoreConfArgs'] meta_store_conf: The configuration of emr-cluster service component metadata storage. If meta store type is ’user_rds’, this should be specified.
        :param pulumi.Input[_builtins.str] meta_store_type: The type of emr-cluster service component metadata storage. ’dlf’ or ’local’ or ’user_rds’ .
        :param pulumi.Input['ClusterModifyClusterServiceConfigArgs'] modify_cluster_service_config: The configurations of emr-cluster service modification after cluster created.
        :param pulumi.Input[_builtins.str] name: The name of emr cluster. The name length must be less than 64. Supported characters: chinese character, english character, number, "-", "_".
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] option_software_lists: Optional software list.
        :param pulumi.Input[_builtins.int] period: If charge type is PrePaid, this should be specified, unit is month. Supported value: 1、2、3、4、5、6、7、8、9、12、24、36.
        :param pulumi.Input[_builtins.str] related_cluster_id: This specify the related cluster id, if this cluster is a Gateway.
        :param pulumi.Input[_builtins.str] resource_group_id: The Id of resource group which the emr-cluster belongs.
        :param pulumi.Input[_builtins.str] security_group_id: Security Group ID for Cluster, you can also specify this key for each host group.
        :param pulumi.Input[_builtins.bool] ssh_enable: If this is set true, we can ssh into cluster. Default value is false.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.bool] use_local_metadb: Use local metadb. Default is false.
        :param pulumi.Input[_builtins.str] user_defined_emr_ecs_role: Alicloud EMR uses roles to perform actions on your behalf when provisioning cluster resources, running applications, dynamically scaling resources. EMR uses the following roles when interacting with other Alicloud services. Default value is AliyunEmrEcsDefaultRole.
        :param pulumi.Input[_builtins.str] vswitch_id: Global vswitch id, you can also specify it in host group.
        """
        pulumi.set(__self__, "cluster_type", cluster_type)
        pulumi.set(__self__, "emr_ver", emr_ver)
        pulumi.set(__self__, "zone_id", zone_id)
        if bootstrap_actions is not None:
            pulumi.set(__self__, "bootstrap_actions", bootstrap_actions)
        if charge_type is not None:
            pulumi.set(__self__, "charge_type", charge_type)
        if configs is not None:
            pulumi.set(__self__, "configs", configs)
        if deposit_type is not None:
            pulumi.set(__self__, "deposit_type", deposit_type)
        if eas_enable is not None:
            pulumi.set(__self__, "eas_enable", eas_enable)
        if high_availability_enable is not None:
            pulumi.set(__self__, "high_availability_enable", high_availability_enable)
        if host_groups is not None:
            pulumi.set(__self__, "host_groups", host_groups)
        if is_open_public_ip is not None:
            pulumi.set(__self__, "is_open_public_ip", is_open_public_ip)
        if key_pair_name is not None:
            pulumi.set(__self__, "key_pair_name", key_pair_name)
        if master_pwd is not None:
            pulumi.set(__self__, "master_pwd", master_pwd)
        if meta_store_conf is not None:
            pulumi.set(__self__, "meta_store_conf", meta_store_conf)
        if meta_store_type is not None:
            pulumi.set(__self__, "meta_store_type", meta_store_type)
        if modify_cluster_service_config is not None:
            pulumi.set(__self__, "modify_cluster_service_config", modify_cluster_service_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if option_software_lists is not None:
            pulumi.set(__self__, "option_software_lists", option_software_lists)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if related_cluster_id is not None:
            pulumi.set(__self__, "related_cluster_id", related_cluster_id)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if ssh_enable is not None:
            pulumi.set(__self__, "ssh_enable", ssh_enable)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if use_local_metadb is not None:
            pulumi.set(__self__, "use_local_metadb", use_local_metadb)
        if user_defined_emr_ecs_role is not None:
            pulumi.set(__self__, "user_defined_emr_ecs_role", user_defined_emr_ecs_role)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)

    @_builtins.property
    @pulumi.getter(name="clusterType")
    def cluster_type(self) -> pulumi.Input[_builtins.str]:
        """
        EMR Cluster Type, e.g. HADOOP, KAFKA, DRUID, GATEWAY etc. You can find all valid EMR cluster type in emr web console. Supported 'GATEWAY' available in 1.61.0+.
        """
        return pulumi.get(self, "cluster_type")

    @cluster_type.setter
    def cluster_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cluster_type", value)

    @_builtins.property
    @pulumi.getter(name="emrVer")
    def emr_ver(self) -> pulumi.Input[_builtins.str]:
        """
        EMR Version, e.g. EMR-3.22.0. You can find the all valid EMR Version in emr web console.
        """
        return pulumi.get(self, "emr_ver")

    @emr_ver.setter
    def emr_ver(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "emr_ver", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Input[_builtins.str]:
        """
        Zone ID, e.g. cn-huhehaote-a
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "zone_id", value)

    @_builtins.property
    @pulumi.getter(name="bootstrapActions")
    def bootstrap_actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterBootstrapActionArgs']]]]:
        """
        Boot action parameters.
        """
        return pulumi.get(self, "bootstrap_actions")

    @bootstrap_actions.setter
    def bootstrap_actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterBootstrapActionArgs']]]]):
        pulumi.set(self, "bootstrap_actions", value)

    @_builtins.property
    @pulumi.getter(name="chargeType")
    def charge_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Charge Type for this cluster. Supported value: PostPaid or PrePaid. Default value: PostPaid.
        """
        return pulumi.get(self, "charge_type")

    @charge_type.setter
    def charge_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "charge_type", value)

    @_builtins.property
    @pulumi.getter
    def configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterConfigArgs']]]]:
        """
        The custom configurations of emr-cluster service.
        """
        return pulumi.get(self, "configs")

    @configs.setter
    def configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterConfigArgs']]]]):
        pulumi.set(self, "configs", value)

    @_builtins.property
    @pulumi.getter(name="depositType")
    def deposit_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Cluster deposit type, HALF_MANAGED or FULL_MANAGED.
        """
        return pulumi.get(self, "deposit_type")

    @deposit_type.setter
    def deposit_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "deposit_type", value)

    @_builtins.property
    @pulumi.getter(name="easEnable")
    def eas_enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        High security cluster (true) or not. Default value is false.
        """
        return pulumi.get(self, "eas_enable")

    @eas_enable.setter
    def eas_enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "eas_enable", value)

    @_builtins.property
    @pulumi.getter(name="highAvailabilityEnable")
    def high_availability_enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        High Available for HDFS and YARN. If this is set true, MASTER group must have two nodes.
        """
        return pulumi.get(self, "high_availability_enable")

    @high_availability_enable.setter
    def high_availability_enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "high_availability_enable", value)

    @_builtins.property
    @pulumi.getter(name="hostGroups")
    def host_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterHostGroupArgs']]]]:
        """
        Groups of Host, You can specify MASTER as a group, CORE as a group (just like the above example).
        """
        return pulumi.get(self, "host_groups")

    @host_groups.setter
    def host_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterHostGroupArgs']]]]):
        pulumi.set(self, "host_groups", value)

    @_builtins.property
    @pulumi.getter(name="isOpenPublicIp")
    def is_open_public_ip(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the MASTER node has a public IP address enabled. Default value is false.
        """
        return pulumi.get(self, "is_open_public_ip")

    @is_open_public_ip.setter
    def is_open_public_ip(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_open_public_ip", value)

    @_builtins.property
    @pulumi.getter(name="keyPairName")
    def key_pair_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Ssh key pair.
        """
        return pulumi.get(self, "key_pair_name")

    @key_pair_name.setter
    def key_pair_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_pair_name", value)

    @_builtins.property
    @pulumi.getter(name="masterPwd")
    def master_pwd(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Master ssh password.
        """
        return pulumi.get(self, "master_pwd")

    @master_pwd.setter
    def master_pwd(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "master_pwd", value)

    @_builtins.property
    @pulumi.getter(name="metaStoreConf")
    def meta_store_conf(self) -> Optional[pulumi.Input['ClusterMetaStoreConfArgs']]:
        """
        The configuration of emr-cluster service component metadata storage. If meta store type is ’user_rds’, this should be specified.
        """
        return pulumi.get(self, "meta_store_conf")

    @meta_store_conf.setter
    def meta_store_conf(self, value: Optional[pulumi.Input['ClusterMetaStoreConfArgs']]):
        pulumi.set(self, "meta_store_conf", value)

    @_builtins.property
    @pulumi.getter(name="metaStoreType")
    def meta_store_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of emr-cluster service component metadata storage. ’dlf’ or ’local’ or ’user_rds’ .
        """
        return pulumi.get(self, "meta_store_type")

    @meta_store_type.setter
    def meta_store_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "meta_store_type", value)

    @_builtins.property
    @pulumi.getter(name="modifyClusterServiceConfig")
    def modify_cluster_service_config(self) -> Optional[pulumi.Input['ClusterModifyClusterServiceConfigArgs']]:
        """
        The configurations of emr-cluster service modification after cluster created.
        """
        return pulumi.get(self, "modify_cluster_service_config")

    @modify_cluster_service_config.setter
    def modify_cluster_service_config(self, value: Optional[pulumi.Input['ClusterModifyClusterServiceConfigArgs']]):
        pulumi.set(self, "modify_cluster_service_config", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of emr cluster. The name length must be less than 64. Supported characters: chinese character, english character, number, "-", "_".
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="optionSoftwareLists")
    def option_software_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Optional software list.
        """
        return pulumi.get(self, "option_software_lists")

    @option_software_lists.setter
    def option_software_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "option_software_lists", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        If charge type is PrePaid, this should be specified, unit is month. Supported value: 1、2、3、4、5、6、7、8、9、12、24、36.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="relatedClusterId")
    def related_cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This specify the related cluster id, if this cluster is a Gateway.
        """
        return pulumi.get(self, "related_cluster_id")

    @related_cluster_id.setter
    def related_cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "related_cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Id of resource group which the emr-cluster belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Security Group ID for Cluster, you can also specify this key for each host group.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_group_id", value)

    @_builtins.property
    @pulumi.getter(name="sshEnable")
    def ssh_enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If this is set true, we can ssh into cluster. Default value is false.
        """
        return pulumi.get(self, "ssh_enable")

    @ssh_enable.setter
    def ssh_enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ssh_enable", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="useLocalMetadb")
    def use_local_metadb(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Use local metadb. Default is false.
        """
        return pulumi.get(self, "use_local_metadb")

    @use_local_metadb.setter
    def use_local_metadb(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_local_metadb", value)

    @_builtins.property
    @pulumi.getter(name="userDefinedEmrEcsRole")
    def user_defined_emr_ecs_role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Alicloud EMR uses roles to perform actions on your behalf when provisioning cluster resources, running applications, dynamically scaling resources. EMR uses the following roles when interacting with other Alicloud services. Default value is AliyunEmrEcsDefaultRole.
        """
        return pulumi.get(self, "user_defined_emr_ecs_role")

    @user_defined_emr_ecs_role.setter
    def user_defined_emr_ecs_role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_defined_emr_ecs_role", value)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Global vswitch id, you can also specify it in host group.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vswitch_id", value)


@pulumi.input_type
class _ClusterState:
    def __init__(__self__, *,
                 bootstrap_actions: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterBootstrapActionArgs']]]] = None,
                 charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_type: Optional[pulumi.Input[_builtins.str]] = None,
                 configs: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterConfigArgs']]]] = None,
                 deposit_type: Optional[pulumi.Input[_builtins.str]] = None,
                 eas_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 emr_ver: Optional[pulumi.Input[_builtins.str]] = None,
                 high_availability_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 host_groups: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterHostGroupArgs']]]] = None,
                 is_open_public_ip: Optional[pulumi.Input[_builtins.bool]] = None,
                 key_pair_name: Optional[pulumi.Input[_builtins.str]] = None,
                 master_pwd: Optional[pulumi.Input[_builtins.str]] = None,
                 meta_store_conf: Optional[pulumi.Input['ClusterMetaStoreConfArgs']] = None,
                 meta_store_type: Optional[pulumi.Input[_builtins.str]] = None,
                 modify_cluster_service_config: Optional[pulumi.Input['ClusterModifyClusterServiceConfigArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 option_software_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 related_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ssh_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 use_local_metadb: Optional[pulumi.Input[_builtins.bool]] = None,
                 user_defined_emr_ecs_role: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Cluster resources.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterBootstrapActionArgs']]] bootstrap_actions: Boot action parameters.
        :param pulumi.Input[_builtins.str] charge_type: Charge Type for this cluster. Supported value: PostPaid or PrePaid. Default value: PostPaid.
        :param pulumi.Input[_builtins.str] cluster_type: EMR Cluster Type, e.g. HADOOP, KAFKA, DRUID, GATEWAY etc. You can find all valid EMR cluster type in emr web console. Supported 'GATEWAY' available in 1.61.0+.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterConfigArgs']]] configs: The custom configurations of emr-cluster service.
        :param pulumi.Input[_builtins.str] deposit_type: Cluster deposit type, HALF_MANAGED or FULL_MANAGED.
        :param pulumi.Input[_builtins.bool] eas_enable: High security cluster (true) or not. Default value is false.
        :param pulumi.Input[_builtins.str] emr_ver: EMR Version, e.g. EMR-3.22.0. You can find the all valid EMR Version in emr web console.
        :param pulumi.Input[_builtins.bool] high_availability_enable: High Available for HDFS and YARN. If this is set true, MASTER group must have two nodes.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterHostGroupArgs']]] host_groups: Groups of Host, You can specify MASTER as a group, CORE as a group (just like the above example).
        :param pulumi.Input[_builtins.bool] is_open_public_ip: Whether the MASTER node has a public IP address enabled. Default value is false.
        :param pulumi.Input[_builtins.str] key_pair_name: Ssh key pair.
        :param pulumi.Input[_builtins.str] master_pwd: Master ssh password.
        :param pulumi.Input['ClusterMetaStoreConfArgs'] meta_store_conf: The configuration of emr-cluster service component metadata storage. If meta store type is ’user_rds’, this should be specified.
        :param pulumi.Input[_builtins.str] meta_store_type: The type of emr-cluster service component metadata storage. ’dlf’ or ’local’ or ’user_rds’ .
        :param pulumi.Input['ClusterModifyClusterServiceConfigArgs'] modify_cluster_service_config: The configurations of emr-cluster service modification after cluster created.
        :param pulumi.Input[_builtins.str] name: The name of emr cluster. The name length must be less than 64. Supported characters: chinese character, english character, number, "-", "_".
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] option_software_lists: Optional software list.
        :param pulumi.Input[_builtins.int] period: If charge type is PrePaid, this should be specified, unit is month. Supported value: 1、2、3、4、5、6、7、8、9、12、24、36.
        :param pulumi.Input[_builtins.str] related_cluster_id: This specify the related cluster id, if this cluster is a Gateway.
        :param pulumi.Input[_builtins.str] resource_group_id: The Id of resource group which the emr-cluster belongs.
        :param pulumi.Input[_builtins.str] security_group_id: Security Group ID for Cluster, you can also specify this key for each host group.
        :param pulumi.Input[_builtins.bool] ssh_enable: If this is set true, we can ssh into cluster. Default value is false.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.bool] use_local_metadb: Use local metadb. Default is false.
        :param pulumi.Input[_builtins.str] user_defined_emr_ecs_role: Alicloud EMR uses roles to perform actions on your behalf when provisioning cluster resources, running applications, dynamically scaling resources. EMR uses the following roles when interacting with other Alicloud services. Default value is AliyunEmrEcsDefaultRole.
        :param pulumi.Input[_builtins.str] vswitch_id: Global vswitch id, you can also specify it in host group.
        :param pulumi.Input[_builtins.str] zone_id: Zone ID, e.g. cn-huhehaote-a
        """
        if bootstrap_actions is not None:
            pulumi.set(__self__, "bootstrap_actions", bootstrap_actions)
        if charge_type is not None:
            pulumi.set(__self__, "charge_type", charge_type)
        if cluster_type is not None:
            pulumi.set(__self__, "cluster_type", cluster_type)
        if configs is not None:
            pulumi.set(__self__, "configs", configs)
        if deposit_type is not None:
            pulumi.set(__self__, "deposit_type", deposit_type)
        if eas_enable is not None:
            pulumi.set(__self__, "eas_enable", eas_enable)
        if emr_ver is not None:
            pulumi.set(__self__, "emr_ver", emr_ver)
        if high_availability_enable is not None:
            pulumi.set(__self__, "high_availability_enable", high_availability_enable)
        if host_groups is not None:
            pulumi.set(__self__, "host_groups", host_groups)
        if is_open_public_ip is not None:
            pulumi.set(__self__, "is_open_public_ip", is_open_public_ip)
        if key_pair_name is not None:
            pulumi.set(__self__, "key_pair_name", key_pair_name)
        if master_pwd is not None:
            pulumi.set(__self__, "master_pwd", master_pwd)
        if meta_store_conf is not None:
            pulumi.set(__self__, "meta_store_conf", meta_store_conf)
        if meta_store_type is not None:
            pulumi.set(__self__, "meta_store_type", meta_store_type)
        if modify_cluster_service_config is not None:
            pulumi.set(__self__, "modify_cluster_service_config", modify_cluster_service_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if option_software_lists is not None:
            pulumi.set(__self__, "option_software_lists", option_software_lists)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if related_cluster_id is not None:
            pulumi.set(__self__, "related_cluster_id", related_cluster_id)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if ssh_enable is not None:
            pulumi.set(__self__, "ssh_enable", ssh_enable)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if use_local_metadb is not None:
            pulumi.set(__self__, "use_local_metadb", use_local_metadb)
        if user_defined_emr_ecs_role is not None:
            pulumi.set(__self__, "user_defined_emr_ecs_role", user_defined_emr_ecs_role)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="bootstrapActions")
    def bootstrap_actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterBootstrapActionArgs']]]]:
        """
        Boot action parameters.
        """
        return pulumi.get(self, "bootstrap_actions")

    @bootstrap_actions.setter
    def bootstrap_actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterBootstrapActionArgs']]]]):
        pulumi.set(self, "bootstrap_actions", value)

    @_builtins.property
    @pulumi.getter(name="chargeType")
    def charge_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Charge Type for this cluster. Supported value: PostPaid or PrePaid. Default value: PostPaid.
        """
        return pulumi.get(self, "charge_type")

    @charge_type.setter
    def charge_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "charge_type", value)

    @_builtins.property
    @pulumi.getter(name="clusterType")
    def cluster_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        EMR Cluster Type, e.g. HADOOP, KAFKA, DRUID, GATEWAY etc. You can find all valid EMR cluster type in emr web console. Supported 'GATEWAY' available in 1.61.0+.
        """
        return pulumi.get(self, "cluster_type")

    @cluster_type.setter
    def cluster_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_type", value)

    @_builtins.property
    @pulumi.getter
    def configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterConfigArgs']]]]:
        """
        The custom configurations of emr-cluster service.
        """
        return pulumi.get(self, "configs")

    @configs.setter
    def configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterConfigArgs']]]]):
        pulumi.set(self, "configs", value)

    @_builtins.property
    @pulumi.getter(name="depositType")
    def deposit_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Cluster deposit type, HALF_MANAGED or FULL_MANAGED.
        """
        return pulumi.get(self, "deposit_type")

    @deposit_type.setter
    def deposit_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "deposit_type", value)

    @_builtins.property
    @pulumi.getter(name="easEnable")
    def eas_enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        High security cluster (true) or not. Default value is false.
        """
        return pulumi.get(self, "eas_enable")

    @eas_enable.setter
    def eas_enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "eas_enable", value)

    @_builtins.property
    @pulumi.getter(name="emrVer")
    def emr_ver(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        EMR Version, e.g. EMR-3.22.0. You can find the all valid EMR Version in emr web console.
        """
        return pulumi.get(self, "emr_ver")

    @emr_ver.setter
    def emr_ver(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "emr_ver", value)

    @_builtins.property
    @pulumi.getter(name="highAvailabilityEnable")
    def high_availability_enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        High Available for HDFS and YARN. If this is set true, MASTER group must have two nodes.
        """
        return pulumi.get(self, "high_availability_enable")

    @high_availability_enable.setter
    def high_availability_enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "high_availability_enable", value)

    @_builtins.property
    @pulumi.getter(name="hostGroups")
    def host_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterHostGroupArgs']]]]:
        """
        Groups of Host, You can specify MASTER as a group, CORE as a group (just like the above example).
        """
        return pulumi.get(self, "host_groups")

    @host_groups.setter
    def host_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterHostGroupArgs']]]]):
        pulumi.set(self, "host_groups", value)

    @_builtins.property
    @pulumi.getter(name="isOpenPublicIp")
    def is_open_public_ip(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the MASTER node has a public IP address enabled. Default value is false.
        """
        return pulumi.get(self, "is_open_public_ip")

    @is_open_public_ip.setter
    def is_open_public_ip(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_open_public_ip", value)

    @_builtins.property
    @pulumi.getter(name="keyPairName")
    def key_pair_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Ssh key pair.
        """
        return pulumi.get(self, "key_pair_name")

    @key_pair_name.setter
    def key_pair_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_pair_name", value)

    @_builtins.property
    @pulumi.getter(name="masterPwd")
    def master_pwd(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Master ssh password.
        """
        return pulumi.get(self, "master_pwd")

    @master_pwd.setter
    def master_pwd(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "master_pwd", value)

    @_builtins.property
    @pulumi.getter(name="metaStoreConf")
    def meta_store_conf(self) -> Optional[pulumi.Input['ClusterMetaStoreConfArgs']]:
        """
        The configuration of emr-cluster service component metadata storage. If meta store type is ’user_rds’, this should be specified.
        """
        return pulumi.get(self, "meta_store_conf")

    @meta_store_conf.setter
    def meta_store_conf(self, value: Optional[pulumi.Input['ClusterMetaStoreConfArgs']]):
        pulumi.set(self, "meta_store_conf", value)

    @_builtins.property
    @pulumi.getter(name="metaStoreType")
    def meta_store_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of emr-cluster service component metadata storage. ’dlf’ or ’local’ or ’user_rds’ .
        """
        return pulumi.get(self, "meta_store_type")

    @meta_store_type.setter
    def meta_store_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "meta_store_type", value)

    @_builtins.property
    @pulumi.getter(name="modifyClusterServiceConfig")
    def modify_cluster_service_config(self) -> Optional[pulumi.Input['ClusterModifyClusterServiceConfigArgs']]:
        """
        The configurations of emr-cluster service modification after cluster created.
        """
        return pulumi.get(self, "modify_cluster_service_config")

    @modify_cluster_service_config.setter
    def modify_cluster_service_config(self, value: Optional[pulumi.Input['ClusterModifyClusterServiceConfigArgs']]):
        pulumi.set(self, "modify_cluster_service_config", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of emr cluster. The name length must be less than 64. Supported characters: chinese character, english character, number, "-", "_".
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="optionSoftwareLists")
    def option_software_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Optional software list.
        """
        return pulumi.get(self, "option_software_lists")

    @option_software_lists.setter
    def option_software_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "option_software_lists", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        If charge type is PrePaid, this should be specified, unit is month. Supported value: 1、2、3、4、5、6、7、8、9、12、24、36.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="relatedClusterId")
    def related_cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This specify the related cluster id, if this cluster is a Gateway.
        """
        return pulumi.get(self, "related_cluster_id")

    @related_cluster_id.setter
    def related_cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "related_cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Id of resource group which the emr-cluster belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Security Group ID for Cluster, you can also specify this key for each host group.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_group_id", value)

    @_builtins.property
    @pulumi.getter(name="sshEnable")
    def ssh_enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If this is set true, we can ssh into cluster. Default value is false.
        """
        return pulumi.get(self, "ssh_enable")

    @ssh_enable.setter
    def ssh_enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ssh_enable", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="useLocalMetadb")
    def use_local_metadb(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Use local metadb. Default is false.
        """
        return pulumi.get(self, "use_local_metadb")

    @use_local_metadb.setter
    def use_local_metadb(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_local_metadb", value)

    @_builtins.property
    @pulumi.getter(name="userDefinedEmrEcsRole")
    def user_defined_emr_ecs_role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Alicloud EMR uses roles to perform actions on your behalf when provisioning cluster resources, running applications, dynamically scaling resources. EMR uses the following roles when interacting with other Alicloud services. Default value is AliyunEmrEcsDefaultRole.
        """
        return pulumi.get(self, "user_defined_emr_ecs_role")

    @user_defined_emr_ecs_role.setter
    def user_defined_emr_ecs_role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_defined_emr_ecs_role", value)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Global vswitch id, you can also specify it in host group.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vswitch_id", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Zone ID, e.g. cn-huhehaote-a
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.type_token("alicloud:emr/cluster:Cluster")
class Cluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bootstrap_actions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterBootstrapActionArgs', 'ClusterBootstrapActionArgsDict']]]]] = None,
                 charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_type: Optional[pulumi.Input[_builtins.str]] = None,
                 configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterConfigArgs', 'ClusterConfigArgsDict']]]]] = None,
                 deposit_type: Optional[pulumi.Input[_builtins.str]] = None,
                 eas_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 emr_ver: Optional[pulumi.Input[_builtins.str]] = None,
                 high_availability_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 host_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterHostGroupArgs', 'ClusterHostGroupArgsDict']]]]] = None,
                 is_open_public_ip: Optional[pulumi.Input[_builtins.bool]] = None,
                 key_pair_name: Optional[pulumi.Input[_builtins.str]] = None,
                 master_pwd: Optional[pulumi.Input[_builtins.str]] = None,
                 meta_store_conf: Optional[pulumi.Input[Union['ClusterMetaStoreConfArgs', 'ClusterMetaStoreConfArgsDict']]] = None,
                 meta_store_type: Optional[pulumi.Input[_builtins.str]] = None,
                 modify_cluster_service_config: Optional[pulumi.Input[Union['ClusterModifyClusterServiceConfigArgs', 'ClusterModifyClusterServiceConfigArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 option_software_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 related_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ssh_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 use_local_metadb: Optional[pulumi.Input[_builtins.bool]] = None,
                 user_defined_emr_ecs_role: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a EMR Cluster resource. With this you can create, read, and release  EMR Cluster.

        > **DEPRECATED:**  This resource has been deprecated from version `1.204.0`. Please use new resource emrv2_cluster.

        > **NOTE:** Available since v1.57.0.

        ## Example Usage

        ### 1. Create A Cluster

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.emr.get_main_versions()
        default_get_instance_types = alicloud.emr.get_instance_types(destination_resource="InstanceType",
            cluster_type=default.main_versions[0].cluster_types[0],
            support_local_storage=False,
            instance_charge_type="PostPaid",
            support_node_types=[
                "MASTER",
                "CORE",
                "TASK",
            ])
        data_disk = alicloud.emr.get_disk_types(destination_resource="DataDisk",
            cluster_type=default.main_versions[0].cluster_types[0],
            instance_charge_type="PostPaid",
            instance_type=default_get_instance_types.types[0].id,
            zone_id=default_get_instance_types.types[0].zone_id)
        system_disk = alicloud.emr.get_disk_types(destination_resource="SystemDisk",
            cluster_type=default.main_versions[0].cluster_types[0],
            instance_charge_type="PostPaid",
            instance_type=default_get_instance_types.types[0].id,
            zone_id=default_get_instance_types.types[0].zone_id)
        vpc = []
        for range in [{"value": i} for i in range(0, 1 if vpc_id ==  else 0)]:
            vpc.append(alicloud.vpc.Network(f"vpc-{range['value']}",
                name=vpc_name,
                cidr_block=vpc_cidr))
        default_security_group = []
        for range in [{"value": i} for i in range(0, 1 if security_group_id ==  else 0)]:
            default_security_group.append(alicloud.ecs.SecurityGroup(f"default-{range['value']}",
                name=security_group_name,
                vpc_id=vpc[0].id if vpc_id == "" else vpc_id))
        # VSwitch Resource for Module
        vswitch = []
        for range in [{"value": i} for i in range(0, 1 if vswitch_id ==  else 0)]:
            vswitch.append(alicloud.vpc.Switch(f"vswitch-{range['value']}",
                availability_zone=default_get_instance_types.types[0].zone_id if availability_zone == "" else availability_zone,
                vswitch_name=vswitch_name,
                cidr_block=vswitch_cidr,
                vpc_id=vpc[0].id if vpc_id == "" else vpc_id))
        # Ram role Resource for Module
        default_role = alicloud.ram.Role("default",
            name=ram_name,
            document=\"\"\"    {
                "Statement": [
                {
                    "Action": "sts:AssumeRole",
                    "Effect": "Allow",
                    "Principal": {
                    "Service": [
                        "emr.aliyuncs.com",
                        "ecs.aliyuncs.com"
                    ]
                    }
                }
                ],
                "Version": "1"
            }
        \"\"\",
            description="this is a role test.",
            force=True)
        default_cluster = alicloud.emr.Cluster("default",
            name="terraform-create-cluster-test",
            emr_ver=default.main_versions[0].emr_version,
            cluster_type=default.main_versions[0].cluster_types[0],
            host_groups=[
                {
                    "host_group_name": "master_group",
                    "host_group_type": "MASTER",
                    "node_count": "2",
                    "instance_type": default_get_instance_types.types[0].id,
                    "disk_type": data_disk.types[0].value,
                    "disk_capacity": data_disk.types[0].min if data_disk.types[0].min > 160 else "160",
                    "disk_count": "1",
                    "sys_disk_type": system_disk.types[0].value,
                    "sys_disk_capacity": system_disk.types[0].min if system_disk.types[0].min > 160 else "160",
                },
                {
                    "host_group_name": "core_group",
                    "host_group_type": "CORE",
                    "node_count": "3",
                    "instance_type": default_get_instance_types.types[0].id,
                    "disk_type": data_disk.types[0].value,
                    "disk_capacity": data_disk.types[0].min if data_disk.types[0].min > 160 else "160",
                    "disk_count": "4",
                    "sys_disk_type": system_disk.types[0].value,
                    "sys_disk_capacity": system_disk.types[0].min if system_disk.types[0].min > 160 else "160",
                },
                {
                    "host_group_name": "task_group",
                    "host_group_type": "TASK",
                    "node_count": "2",
                    "instance_type": default_get_instance_types.types[0].id,
                    "disk_type": data_disk.types[0].value,
                    "disk_capacity": data_disk.types[0].min if data_disk.types[0].min > 160 else "160",
                    "disk_count": "4",
                    "sys_disk_type": system_disk.types[0].value,
                    "sys_disk_capacity": system_disk.types[0].min if system_disk.types[0].min > 160 else "160",
                },
            ],
            high_availability_enable=True,
            zone_id=default_get_instance_types.types[0].zone_id,
            security_group_id=default_security_group[0].id if security_group_id == "" else security_group_id,
            is_open_public_ip=True,
            charge_type="PostPaid",
            vswitch_id=vswitch[0].id if vswitch_id == "" else vswitch_id,
            user_defined_emr_ecs_role=default_role.name,
            ssh_enable=True,
            master_pwd="ABCtest1234!")
        ```

        ### 2. Scale Up
        The hosts of EMR Cluster are orginized as host group. Scaling up/down is operating host group.

        In the case of scaling up cluster, we should add the node_count of some host group.

        > **NOTE:** Scaling up is only applicable to CORE and TASK group. Cost time of scaling up will vary with the number of scaling-up nodes.
        Scaling down is only applicable to TASK group. If you want to scale down CORE group, please submit tickets or contact EMR support team.

        As the following case, we scale up the TASK group 2 nodes by increasing host_group.node_count by 2.

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.emr.get_main_versions()
        default_get_instance_types = alicloud.emr.get_instance_types(destination_resource="InstanceType",
            cluster_type=default.main_versions[0].cluster_types[0],
            support_local_storage=False,
            instance_charge_type="PostPaid",
            support_node_types=[
                "MASTER",
                "CORE",
                "TASK",
            ])
        data_disk = alicloud.emr.get_disk_types(destination_resource="DataDisk",
            cluster_type=default.main_versions[0].cluster_types[0],
            instance_charge_type="PostPaid",
            instance_type=default_get_instance_types.types[0].id,
            zone_id=default_get_instance_types.types[0].zone_id)
        system_disk = alicloud.emr.get_disk_types(destination_resource="SystemDisk",
            cluster_type=default.main_versions[0].cluster_types[0],
            instance_charge_type="PostPaid",
            instance_type=default_get_instance_types.types[0].id,
            zone_id=default_get_instance_types.types[0].zone_id)
        vpc = []
        for range in [{"value": i} for i in range(0, 1 if vpc_id ==  else 0)]:
            vpc.append(alicloud.vpc.Network(f"vpc-{range['value']}",
                name=vpc_name,
                cidr_block=vpc_cidr))
        default_security_group = []
        for range in [{"value": i} for i in range(0, 1 if security_group_id ==  else 0)]:
            default_security_group.append(alicloud.ecs.SecurityGroup(f"default-{range['value']}",
                name=security_group_name,
                vpc_id=vpc[0].id if vpc_id == "" else vpc_id))
        # VSwitch Resource for Module
        vswitch = []
        for range in [{"value": i} for i in range(0, 1 if vswitch_id ==  else 0)]:
            vswitch.append(alicloud.vpc.Switch(f"vswitch-{range['value']}",
                availability_zone=default_get_instance_types.types[0].zone_id if availability_zone == "" else availability_zone,
                vswitch_name=vswitch_name,
                cidr_block=vswitch_cidr,
                vpc_id=vpc[0].id if vpc_id == "" else vpc_id))
        # Ram role Resource for Module
        default_role = alicloud.ram.Role("default",
            name=ram_name,
            document=\"\"\"    {
                "Statement": [
                {
                    "Action": "sts:AssumeRole",
                    "Effect": "Allow",
                    "Principal": {
                    "Service": [
                        "emr.aliyuncs.com",
                        "ecs.aliyuncs.com"
                    ]
                    }
                }
                ],
                "Version": "1"
            }
        \"\"\",
            description="this is a role test.",
            force=True)
        default_cluster = alicloud.emr.Cluster("default",
            name="terraform-resize-cluster-test",
            emr_ver=default.main_versions[0].emr_version,
            cluster_type=default.main_versions[0].cluster_types[0],
            host_groups=[
                {
                    "host_group_name": "master_group",
                    "host_group_type": "MASTER",
                    "node_count": "2",
                    "instance_type": default_get_instance_types.types[0].id,
                    "disk_type": data_disk.types[0].value,
                    "disk_capacity": data_disk.types[0].min if data_disk.types[0].min > 160 else "160",
                    "disk_count": "1",
                    "sys_disk_type": system_disk.types[0].value,
                    "sys_disk_capacity": system_disk.types[0].min if system_disk.types[0].min > 160 else "160",
                },
                {
                    "host_group_name": "core_group",
                    "host_group_type": "CORE",
                    "node_count": "3",
                    "instance_type": default_get_instance_types.types[0].id,
                    "disk_type": data_disk.types[0].value,
                    "disk_capacity": data_disk.types[0].min if data_disk.types[0].min > 160 else "160",
                    "disk_count": "4",
                    "sys_disk_type": system_disk.types[0].value,
                    "sys_disk_capacity": system_disk.types[0].min if system_disk.types[0].min > 160 else "160",
                },
                {
                    "host_group_name": "task_group",
                    "host_group_type": "TASK",
                    "node_count": "4",
                    "instance_type": default_get_instance_types.types[0].id,
                    "disk_type": data_disk.types[0].value,
                    "disk_capacity": data_disk.types[0].min if data_disk.types[0].min > 160 else "160",
                    "disk_count": "4",
                    "sys_disk_type": system_disk.types[0].value,
                    "sys_disk_capacity": system_disk.types[0].min if system_disk.types[0].min > 160 else "160",
                },
            ],
            high_availability_enable=True,
            zone_id=default_get_instance_types.types[0].zone_id,
            security_group_id=default_security_group[0].id if security_group_id == "" else security_group_id,
            is_open_public_ip=True,
            charge_type="PostPaid",
            vswitch_id=vswitch[0].id if vswitch_id == "" else vswitch_id,
            user_defined_emr_ecs_role=default_role.name,
            ssh_enable=True,
            master_pwd="ABCtest1234!")
        ```

        ### 3. Scale Down

        In the case of scaling down a cluster, we need to specified the host group and the instance list.

        > **NOTE:** Graceful decommission of hadoop cluster has been supported Available since v1.168.0.

        The following is an example. We scale down the cluster by decreasing the node count by 2, and specifying the scale-down instance list.

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.emr.get_main_versions()
        default_get_instance_types = alicloud.emr.get_instance_types(destination_resource="InstanceType",
            cluster_type=default.main_versions[0].cluster_types[0],
            support_local_storage=False,
            instance_charge_type="PostPaid",
            support_node_types=[
                "MASTER",
                "CORE",
                "TASK",
            ])
        data_disk = alicloud.emr.get_disk_types(destination_resource="DataDisk",
            cluster_type=default.main_versions[0].cluster_types[0],
            instance_charge_type="PostPaid",
            instance_type=default_get_instance_types.types[0].id,
            zone_id=default_get_instance_types.types[0].zone_id)
        system_disk = alicloud.emr.get_disk_types(destination_resource="SystemDisk",
            cluster_type=default.main_versions[0].cluster_types[0],
            instance_charge_type="PostPaid",
            instance_type=default_get_instance_types.types[0].id,
            zone_id=default_get_instance_types.types[0].zone_id)
        vpc = []
        for range in [{"value": i} for i in range(0, 1 if vpc_id ==  else 0)]:
            vpc.append(alicloud.vpc.Network(f"vpc-{range['value']}",
                name=vpc_name,
                cidr_block=vpc_cidr))
        default_security_group = []
        for range in [{"value": i} for i in range(0, 1 if security_group_id ==  else 0)]:
            default_security_group.append(alicloud.ecs.SecurityGroup(f"default-{range['value']}",
                name=security_group_name,
                vpc_id=vpc[0].id if vpc_id == "" else vpc_id))
        # VSwitch Resource for Module
        vswitch = []
        for range in [{"value": i} for i in range(0, 1 if vswitch_id ==  else 0)]:
            vswitch.append(alicloud.vpc.Switch(f"vswitch-{range['value']}",
                availability_zone=default_get_instance_types.types[0].zone_id if availability_zone == "" else availability_zone,
                vswitch_name=vswitch_name,
                cidr_block=vswitch_cidr,
                vpc_id=vpc[0].id if vpc_id == "" else vpc_id))
        # Ram role Resource for Module
        default_role = alicloud.ram.Role("default",
            name=ram_name,
            document=\"\"\"    {
                "Statement": [
                {
                    "Action": "sts:AssumeRole",
                    "Effect": "Allow",
                    "Principal": {
                    "Service": [
                        "emr.aliyuncs.com",
                        "ecs.aliyuncs.com"
                    ]
                    }
                }
                ],
                "Version": "1"
            }
        \"\"\",
            description="this is a role test.",
            force=True)
        default_cluster = alicloud.emr.Cluster("default",
            name="terraform-resize-cluster-test",
            emr_ver=default.main_versions[0].emr_version,
            cluster_type=default.main_versions[0].cluster_types[0],
            host_groups=[
                {
                    "host_group_name": "master_group",
                    "host_group_type": "MASTER",
                    "node_count": "2",
                    "instance_type": default_get_instance_types.types[0].id,
                    "disk_type": data_disk.types[0].value,
                    "disk_capacity": data_disk.types[0].min if data_disk.types[0].min > 160 else "160",
                    "disk_count": "1",
                    "sys_disk_type": system_disk.types[0].value,
                    "sys_disk_capacity": system_disk.types[0].min if system_disk.types[0].min > 160 else "160",
                },
                {
                    "host_group_name": "core_group",
                    "host_group_type": "CORE",
                    "node_count": "3",
                    "instance_type": default_get_instance_types.types[0].id,
                    "disk_type": data_disk.types[0].value,
                    "disk_capacity": data_disk.types[0].min if data_disk.types[0].min > 160 else "160",
                    "disk_count": "4",
                    "sys_disk_type": system_disk.types[0].value,
                    "sys_disk_capacity": system_disk.types[0].min if system_disk.types[0].min > 160 else "160",
                },
                {
                    "host_group_name": "task_group",
                    "host_group_type": "TASK",
                    "node_count": "2",
                    "instance_type": default_get_instance_types.types[0].id,
                    "disk_type": data_disk.types[0].value,
                    "disk_capacity": data_disk.types[0].min if data_disk.types[0].min > 160 else "160",
                    "disk_count": "4",
                    "sys_disk_type": system_disk.types[0].value,
                    "sys_disk_capacity": system_disk.types[0].min if system_disk.types[0].min > 160 else "160",
                },
            ],
            high_availability_enable=True,
            zone_id=default_get_instance_types.types[0].zone_id,
            security_group_id=default_security_group[0].id if security_group_id == "" else security_group_id,
            is_open_public_ip=True,
            charge_type="PostPaid",
            vswitch_id=vswitch[0].id if vswitch_id == "" else vswitch_id,
            user_defined_emr_ecs_role=default_role.name,
            ssh_enable=True,
            master_pwd="ABCtest1234!")
        ```

        ### 4. Create a emr gateway cluster

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.emr.get_main_versions()
        default_get_instance_types = alicloud.emr.get_instance_types(destination_resource="InstanceType",
            cluster_type=default.main_versions[0].cluster_types[0],
            support_local_storage=False,
            instance_charge_type="PostPaid",
            support_node_types=["GATEWAY"])
        data_disk = alicloud.emr.get_disk_types(destination_resource="DataDisk",
            cluster_type=default.main_versions[0].cluster_types[0],
            instance_charge_type="PostPaid",
            instance_type=default_get_instance_types.types[0].id,
            zone_id=default_get_instance_types.types[0].zone_id)
        system_disk = alicloud.emr.get_disk_types(destination_resource="SystemDisk",
            cluster_type=default.main_versions[0].cluster_types[0],
            instance_charge_type="PostPaid",
            instance_type=default_get_instance_types.types[0].id,
            zone_id=default_get_instance_types.types[0].zone_id)
        vpc = []
        for range in [{"value": i} for i in range(0, 1 if vpc_id ==  else 0)]:
            vpc.append(alicloud.vpc.Network(f"vpc-{range['value']}",
                name=vpc_name,
                cidr_block=vpc_cidr))
        default_security_group = []
        for range in [{"value": i} for i in range(0, 1 if security_group_id ==  else 0)]:
            default_security_group.append(alicloud.ecs.SecurityGroup(f"default-{range['value']}",
                name=security_group_name,
                vpc_id=vpc[0].id if vpc_id == "" else vpc_id))
        # VSwitch Resource for Module
        vswitch = []
        for range in [{"value": i} for i in range(0, 1 if vswitch_id ==  else 0)]:
            vswitch.append(alicloud.vpc.Switch(f"vswitch-{range['value']}",
                availability_zone=default_get_instance_types.types[0].zone_id if availability_zone == "" else availability_zone,
                vswitch_name=vswitch_name,
                cidr_block=vswitch_cidr,
                vpc_id=vpc[0].id if vpc_id == "" else vpc_id))
        # Ram role Resource for Module
        default_role = alicloud.ram.Role("default",
            name=ram_name,
            document=\"\"\"    {
                "Statement": [
                {
                    "Action": "sts:AssumeRole",
                    "Effect": "Allow",
                    "Principal": {
                    "Service": [
                        "emr.aliyuncs.com",
                        "ecs.aliyuncs.com"
                    ]
                    }
                }
                ],
                "Version": "1"
            }
        \"\"\",
            description="this is a role test.",
            force=True)
        gateway = alicloud.emr.Cluster("gateway",
            name="terraform-gateway-cluster-test",
            emr_ver=default.main_versions[0].emr_version,
            cluster_type="GATEWAY",
            host_groups=[{
                "host_group_name": "master_group",
                "host_group_type": "GATEWAY",
                "node_count": "1",
                "instance_type": default_get_instance_types.types[0].id,
                "disk_type": data_disk.types[0].value,
                "disk_capacity": data_disk.types[0].min if data_disk.types[0].min > 160 else "160",
                "disk_count": "1",
                "sys_disk_type": system_disk.types[0].value,
                "sys_disk_capacity": system_disk.types[0].min if system_disk.types[0].min > 160 else "160",
            }],
            high_availability_enable=True,
            zone_id=default_get_instance_types.types[0].zone_id,
            security_group_id=default_security_group[0].id if security_group_id == "" else security_group_id,
            is_open_public_ip=True,
            charge_type="PostPaid",
            vswitch_id=vswitch[0].id if vswitch_id == "" else vswitch_id,
            user_defined_emr_ecs_role=default_role.name,
            ssh_enable=True,
            master_pwd="ABCtest1234!",
            related_cluster_id=related_cluster_id)
        ```

        ## Import

        Aliclioud E-MapReduce cluster can be imported using the id e.g.

        ```sh
        $ pulumi import alicloud:emr/cluster:Cluster default C-B47FB8FE96C67XXXX
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterBootstrapActionArgs', 'ClusterBootstrapActionArgsDict']]]] bootstrap_actions: Boot action parameters.
        :param pulumi.Input[_builtins.str] charge_type: Charge Type for this cluster. Supported value: PostPaid or PrePaid. Default value: PostPaid.
        :param pulumi.Input[_builtins.str] cluster_type: EMR Cluster Type, e.g. HADOOP, KAFKA, DRUID, GATEWAY etc. You can find all valid EMR cluster type in emr web console. Supported 'GATEWAY' available in 1.61.0+.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterConfigArgs', 'ClusterConfigArgsDict']]]] configs: The custom configurations of emr-cluster service.
        :param pulumi.Input[_builtins.str] deposit_type: Cluster deposit type, HALF_MANAGED or FULL_MANAGED.
        :param pulumi.Input[_builtins.bool] eas_enable: High security cluster (true) or not. Default value is false.
        :param pulumi.Input[_builtins.str] emr_ver: EMR Version, e.g. EMR-3.22.0. You can find the all valid EMR Version in emr web console.
        :param pulumi.Input[_builtins.bool] high_availability_enable: High Available for HDFS and YARN. If this is set true, MASTER group must have two nodes.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterHostGroupArgs', 'ClusterHostGroupArgsDict']]]] host_groups: Groups of Host, You can specify MASTER as a group, CORE as a group (just like the above example).
        :param pulumi.Input[_builtins.bool] is_open_public_ip: Whether the MASTER node has a public IP address enabled. Default value is false.
        :param pulumi.Input[_builtins.str] key_pair_name: Ssh key pair.
        :param pulumi.Input[_builtins.str] master_pwd: Master ssh password.
        :param pulumi.Input[Union['ClusterMetaStoreConfArgs', 'ClusterMetaStoreConfArgsDict']] meta_store_conf: The configuration of emr-cluster service component metadata storage. If meta store type is ’user_rds’, this should be specified.
        :param pulumi.Input[_builtins.str] meta_store_type: The type of emr-cluster service component metadata storage. ’dlf’ or ’local’ or ’user_rds’ .
        :param pulumi.Input[Union['ClusterModifyClusterServiceConfigArgs', 'ClusterModifyClusterServiceConfigArgsDict']] modify_cluster_service_config: The configurations of emr-cluster service modification after cluster created.
        :param pulumi.Input[_builtins.str] name: The name of emr cluster. The name length must be less than 64. Supported characters: chinese character, english character, number, "-", "_".
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] option_software_lists: Optional software list.
        :param pulumi.Input[_builtins.int] period: If charge type is PrePaid, this should be specified, unit is month. Supported value: 1、2、3、4、5、6、7、8、9、12、24、36.
        :param pulumi.Input[_builtins.str] related_cluster_id: This specify the related cluster id, if this cluster is a Gateway.
        :param pulumi.Input[_builtins.str] resource_group_id: The Id of resource group which the emr-cluster belongs.
        :param pulumi.Input[_builtins.str] security_group_id: Security Group ID for Cluster, you can also specify this key for each host group.
        :param pulumi.Input[_builtins.bool] ssh_enable: If this is set true, we can ssh into cluster. Default value is false.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.bool] use_local_metadb: Use local metadb. Default is false.
        :param pulumi.Input[_builtins.str] user_defined_emr_ecs_role: Alicloud EMR uses roles to perform actions on your behalf when provisioning cluster resources, running applications, dynamically scaling resources. EMR uses the following roles when interacting with other Alicloud services. Default value is AliyunEmrEcsDefaultRole.
        :param pulumi.Input[_builtins.str] vswitch_id: Global vswitch id, you can also specify it in host group.
        :param pulumi.Input[_builtins.str] zone_id: Zone ID, e.g. cn-huhehaote-a
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a EMR Cluster resource. With this you can create, read, and release  EMR Cluster.

        > **DEPRECATED:**  This resource has been deprecated from version `1.204.0`. Please use new resource emrv2_cluster.

        > **NOTE:** Available since v1.57.0.

        ## Example Usage

        ### 1. Create A Cluster

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.emr.get_main_versions()
        default_get_instance_types = alicloud.emr.get_instance_types(destination_resource="InstanceType",
            cluster_type=default.main_versions[0].cluster_types[0],
            support_local_storage=False,
            instance_charge_type="PostPaid",
            support_node_types=[
                "MASTER",
                "CORE",
                "TASK",
            ])
        data_disk = alicloud.emr.get_disk_types(destination_resource="DataDisk",
            cluster_type=default.main_versions[0].cluster_types[0],
            instance_charge_type="PostPaid",
            instance_type=default_get_instance_types.types[0].id,
            zone_id=default_get_instance_types.types[0].zone_id)
        system_disk = alicloud.emr.get_disk_types(destination_resource="SystemDisk",
            cluster_type=default.main_versions[0].cluster_types[0],
            instance_charge_type="PostPaid",
            instance_type=default_get_instance_types.types[0].id,
            zone_id=default_get_instance_types.types[0].zone_id)
        vpc = []
        for range in [{"value": i} for i in range(0, 1 if vpc_id ==  else 0)]:
            vpc.append(alicloud.vpc.Network(f"vpc-{range['value']}",
                name=vpc_name,
                cidr_block=vpc_cidr))
        default_security_group = []
        for range in [{"value": i} for i in range(0, 1 if security_group_id ==  else 0)]:
            default_security_group.append(alicloud.ecs.SecurityGroup(f"default-{range['value']}",
                name=security_group_name,
                vpc_id=vpc[0].id if vpc_id == "" else vpc_id))
        # VSwitch Resource for Module
        vswitch = []
        for range in [{"value": i} for i in range(0, 1 if vswitch_id ==  else 0)]:
            vswitch.append(alicloud.vpc.Switch(f"vswitch-{range['value']}",
                availability_zone=default_get_instance_types.types[0].zone_id if availability_zone == "" else availability_zone,
                vswitch_name=vswitch_name,
                cidr_block=vswitch_cidr,
                vpc_id=vpc[0].id if vpc_id == "" else vpc_id))
        # Ram role Resource for Module
        default_role = alicloud.ram.Role("default",
            name=ram_name,
            document=\"\"\"    {
                "Statement": [
                {
                    "Action": "sts:AssumeRole",
                    "Effect": "Allow",
                    "Principal": {
                    "Service": [
                        "emr.aliyuncs.com",
                        "ecs.aliyuncs.com"
                    ]
                    }
                }
                ],
                "Version": "1"
            }
        \"\"\",
            description="this is a role test.",
            force=True)
        default_cluster = alicloud.emr.Cluster("default",
            name="terraform-create-cluster-test",
            emr_ver=default.main_versions[0].emr_version,
            cluster_type=default.main_versions[0].cluster_types[0],
            host_groups=[
                {
                    "host_group_name": "master_group",
                    "host_group_type": "MASTER",
                    "node_count": "2",
                    "instance_type": default_get_instance_types.types[0].id,
                    "disk_type": data_disk.types[0].value,
                    "disk_capacity": data_disk.types[0].min if data_disk.types[0].min > 160 else "160",
                    "disk_count": "1",
                    "sys_disk_type": system_disk.types[0].value,
                    "sys_disk_capacity": system_disk.types[0].min if system_disk.types[0].min > 160 else "160",
                },
                {
                    "host_group_name": "core_group",
                    "host_group_type": "CORE",
                    "node_count": "3",
                    "instance_type": default_get_instance_types.types[0].id,
                    "disk_type": data_disk.types[0].value,
                    "disk_capacity": data_disk.types[0].min if data_disk.types[0].min > 160 else "160",
                    "disk_count": "4",
                    "sys_disk_type": system_disk.types[0].value,
                    "sys_disk_capacity": system_disk.types[0].min if system_disk.types[0].min > 160 else "160",
                },
                {
                    "host_group_name": "task_group",
                    "host_group_type": "TASK",
                    "node_count": "2",
                    "instance_type": default_get_instance_types.types[0].id,
                    "disk_type": data_disk.types[0].value,
                    "disk_capacity": data_disk.types[0].min if data_disk.types[0].min > 160 else "160",
                    "disk_count": "4",
                    "sys_disk_type": system_disk.types[0].value,
                    "sys_disk_capacity": system_disk.types[0].min if system_disk.types[0].min > 160 else "160",
                },
            ],
            high_availability_enable=True,
            zone_id=default_get_instance_types.types[0].zone_id,
            security_group_id=default_security_group[0].id if security_group_id == "" else security_group_id,
            is_open_public_ip=True,
            charge_type="PostPaid",
            vswitch_id=vswitch[0].id if vswitch_id == "" else vswitch_id,
            user_defined_emr_ecs_role=default_role.name,
            ssh_enable=True,
            master_pwd="ABCtest1234!")
        ```

        ### 2. Scale Up
        The hosts of EMR Cluster are orginized as host group. Scaling up/down is operating host group.

        In the case of scaling up cluster, we should add the node_count of some host group.

        > **NOTE:** Scaling up is only applicable to CORE and TASK group. Cost time of scaling up will vary with the number of scaling-up nodes.
        Scaling down is only applicable to TASK group. If you want to scale down CORE group, please submit tickets or contact EMR support team.

        As the following case, we scale up the TASK group 2 nodes by increasing host_group.node_count by 2.

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.emr.get_main_versions()
        default_get_instance_types = alicloud.emr.get_instance_types(destination_resource="InstanceType",
            cluster_type=default.main_versions[0].cluster_types[0],
            support_local_storage=False,
            instance_charge_type="PostPaid",
            support_node_types=[
                "MASTER",
                "CORE",
                "TASK",
            ])
        data_disk = alicloud.emr.get_disk_types(destination_resource="DataDisk",
            cluster_type=default.main_versions[0].cluster_types[0],
            instance_charge_type="PostPaid",
            instance_type=default_get_instance_types.types[0].id,
            zone_id=default_get_instance_types.types[0].zone_id)
        system_disk = alicloud.emr.get_disk_types(destination_resource="SystemDisk",
            cluster_type=default.main_versions[0].cluster_types[0],
            instance_charge_type="PostPaid",
            instance_type=default_get_instance_types.types[0].id,
            zone_id=default_get_instance_types.types[0].zone_id)
        vpc = []
        for range in [{"value": i} for i in range(0, 1 if vpc_id ==  else 0)]:
            vpc.append(alicloud.vpc.Network(f"vpc-{range['value']}",
                name=vpc_name,
                cidr_block=vpc_cidr))
        default_security_group = []
        for range in [{"value": i} for i in range(0, 1 if security_group_id ==  else 0)]:
            default_security_group.append(alicloud.ecs.SecurityGroup(f"default-{range['value']}",
                name=security_group_name,
                vpc_id=vpc[0].id if vpc_id == "" else vpc_id))
        # VSwitch Resource for Module
        vswitch = []
        for range in [{"value": i} for i in range(0, 1 if vswitch_id ==  else 0)]:
            vswitch.append(alicloud.vpc.Switch(f"vswitch-{range['value']}",
                availability_zone=default_get_instance_types.types[0].zone_id if availability_zone == "" else availability_zone,
                vswitch_name=vswitch_name,
                cidr_block=vswitch_cidr,
                vpc_id=vpc[0].id if vpc_id == "" else vpc_id))
        # Ram role Resource for Module
        default_role = alicloud.ram.Role("default",
            name=ram_name,
            document=\"\"\"    {
                "Statement": [
                {
                    "Action": "sts:AssumeRole",
                    "Effect": "Allow",
                    "Principal": {
                    "Service": [
                        "emr.aliyuncs.com",
                        "ecs.aliyuncs.com"
                    ]
                    }
                }
                ],
                "Version": "1"
            }
        \"\"\",
            description="this is a role test.",
            force=True)
        default_cluster = alicloud.emr.Cluster("default",
            name="terraform-resize-cluster-test",
            emr_ver=default.main_versions[0].emr_version,
            cluster_type=default.main_versions[0].cluster_types[0],
            host_groups=[
                {
                    "host_group_name": "master_group",
                    "host_group_type": "MASTER",
                    "node_count": "2",
                    "instance_type": default_get_instance_types.types[0].id,
                    "disk_type": data_disk.types[0].value,
                    "disk_capacity": data_disk.types[0].min if data_disk.types[0].min > 160 else "160",
                    "disk_count": "1",
                    "sys_disk_type": system_disk.types[0].value,
                    "sys_disk_capacity": system_disk.types[0].min if system_disk.types[0].min > 160 else "160",
                },
                {
                    "host_group_name": "core_group",
                    "host_group_type": "CORE",
                    "node_count": "3",
                    "instance_type": default_get_instance_types.types[0].id,
                    "disk_type": data_disk.types[0].value,
                    "disk_capacity": data_disk.types[0].min if data_disk.types[0].min > 160 else "160",
                    "disk_count": "4",
                    "sys_disk_type": system_disk.types[0].value,
                    "sys_disk_capacity": system_disk.types[0].min if system_disk.types[0].min > 160 else "160",
                },
                {
                    "host_group_name": "task_group",
                    "host_group_type": "TASK",
                    "node_count": "4",
                    "instance_type": default_get_instance_types.types[0].id,
                    "disk_type": data_disk.types[0].value,
                    "disk_capacity": data_disk.types[0].min if data_disk.types[0].min > 160 else "160",
                    "disk_count": "4",
                    "sys_disk_type": system_disk.types[0].value,
                    "sys_disk_capacity": system_disk.types[0].min if system_disk.types[0].min > 160 else "160",
                },
            ],
            high_availability_enable=True,
            zone_id=default_get_instance_types.types[0].zone_id,
            security_group_id=default_security_group[0].id if security_group_id == "" else security_group_id,
            is_open_public_ip=True,
            charge_type="PostPaid",
            vswitch_id=vswitch[0].id if vswitch_id == "" else vswitch_id,
            user_defined_emr_ecs_role=default_role.name,
            ssh_enable=True,
            master_pwd="ABCtest1234!")
        ```

        ### 3. Scale Down

        In the case of scaling down a cluster, we need to specified the host group and the instance list.

        > **NOTE:** Graceful decommission of hadoop cluster has been supported Available since v1.168.0.

        The following is an example. We scale down the cluster by decreasing the node count by 2, and specifying the scale-down instance list.

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.emr.get_main_versions()
        default_get_instance_types = alicloud.emr.get_instance_types(destination_resource="InstanceType",
            cluster_type=default.main_versions[0].cluster_types[0],
            support_local_storage=False,
            instance_charge_type="PostPaid",
            support_node_types=[
                "MASTER",
                "CORE",
                "TASK",
            ])
        data_disk = alicloud.emr.get_disk_types(destination_resource="DataDisk",
            cluster_type=default.main_versions[0].cluster_types[0],
            instance_charge_type="PostPaid",
            instance_type=default_get_instance_types.types[0].id,
            zone_id=default_get_instance_types.types[0].zone_id)
        system_disk = alicloud.emr.get_disk_types(destination_resource="SystemDisk",
            cluster_type=default.main_versions[0].cluster_types[0],
            instance_charge_type="PostPaid",
            instance_type=default_get_instance_types.types[0].id,
            zone_id=default_get_instance_types.types[0].zone_id)
        vpc = []
        for range in [{"value": i} for i in range(0, 1 if vpc_id ==  else 0)]:
            vpc.append(alicloud.vpc.Network(f"vpc-{range['value']}",
                name=vpc_name,
                cidr_block=vpc_cidr))
        default_security_group = []
        for range in [{"value": i} for i in range(0, 1 if security_group_id ==  else 0)]:
            default_security_group.append(alicloud.ecs.SecurityGroup(f"default-{range['value']}",
                name=security_group_name,
                vpc_id=vpc[0].id if vpc_id == "" else vpc_id))
        # VSwitch Resource for Module
        vswitch = []
        for range in [{"value": i} for i in range(0, 1 if vswitch_id ==  else 0)]:
            vswitch.append(alicloud.vpc.Switch(f"vswitch-{range['value']}",
                availability_zone=default_get_instance_types.types[0].zone_id if availability_zone == "" else availability_zone,
                vswitch_name=vswitch_name,
                cidr_block=vswitch_cidr,
                vpc_id=vpc[0].id if vpc_id == "" else vpc_id))
        # Ram role Resource for Module
        default_role = alicloud.ram.Role("default",
            name=ram_name,
            document=\"\"\"    {
                "Statement": [
                {
                    "Action": "sts:AssumeRole",
                    "Effect": "Allow",
                    "Principal": {
                    "Service": [
                        "emr.aliyuncs.com",
                        "ecs.aliyuncs.com"
                    ]
                    }
                }
                ],
                "Version": "1"
            }
        \"\"\",
            description="this is a role test.",
            force=True)
        default_cluster = alicloud.emr.Cluster("default",
            name="terraform-resize-cluster-test",
            emr_ver=default.main_versions[0].emr_version,
            cluster_type=default.main_versions[0].cluster_types[0],
            host_groups=[
                {
                    "host_group_name": "master_group",
                    "host_group_type": "MASTER",
                    "node_count": "2",
                    "instance_type": default_get_instance_types.types[0].id,
                    "disk_type": data_disk.types[0].value,
                    "disk_capacity": data_disk.types[0].min if data_disk.types[0].min > 160 else "160",
                    "disk_count": "1",
                    "sys_disk_type": system_disk.types[0].value,
                    "sys_disk_capacity": system_disk.types[0].min if system_disk.types[0].min > 160 else "160",
                },
                {
                    "host_group_name": "core_group",
                    "host_group_type": "CORE",
                    "node_count": "3",
                    "instance_type": default_get_instance_types.types[0].id,
                    "disk_type": data_disk.types[0].value,
                    "disk_capacity": data_disk.types[0].min if data_disk.types[0].min > 160 else "160",
                    "disk_count": "4",
                    "sys_disk_type": system_disk.types[0].value,
                    "sys_disk_capacity": system_disk.types[0].min if system_disk.types[0].min > 160 else "160",
                },
                {
                    "host_group_name": "task_group",
                    "host_group_type": "TASK",
                    "node_count": "2",
                    "instance_type": default_get_instance_types.types[0].id,
                    "disk_type": data_disk.types[0].value,
                    "disk_capacity": data_disk.types[0].min if data_disk.types[0].min > 160 else "160",
                    "disk_count": "4",
                    "sys_disk_type": system_disk.types[0].value,
                    "sys_disk_capacity": system_disk.types[0].min if system_disk.types[0].min > 160 else "160",
                },
            ],
            high_availability_enable=True,
            zone_id=default_get_instance_types.types[0].zone_id,
            security_group_id=default_security_group[0].id if security_group_id == "" else security_group_id,
            is_open_public_ip=True,
            charge_type="PostPaid",
            vswitch_id=vswitch[0].id if vswitch_id == "" else vswitch_id,
            user_defined_emr_ecs_role=default_role.name,
            ssh_enable=True,
            master_pwd="ABCtest1234!")
        ```

        ### 4. Create a emr gateway cluster

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.emr.get_main_versions()
        default_get_instance_types = alicloud.emr.get_instance_types(destination_resource="InstanceType",
            cluster_type=default.main_versions[0].cluster_types[0],
            support_local_storage=False,
            instance_charge_type="PostPaid",
            support_node_types=["GATEWAY"])
        data_disk = alicloud.emr.get_disk_types(destination_resource="DataDisk",
            cluster_type=default.main_versions[0].cluster_types[0],
            instance_charge_type="PostPaid",
            instance_type=default_get_instance_types.types[0].id,
            zone_id=default_get_instance_types.types[0].zone_id)
        system_disk = alicloud.emr.get_disk_types(destination_resource="SystemDisk",
            cluster_type=default.main_versions[0].cluster_types[0],
            instance_charge_type="PostPaid",
            instance_type=default_get_instance_types.types[0].id,
            zone_id=default_get_instance_types.types[0].zone_id)
        vpc = []
        for range in [{"value": i} for i in range(0, 1 if vpc_id ==  else 0)]:
            vpc.append(alicloud.vpc.Network(f"vpc-{range['value']}",
                name=vpc_name,
                cidr_block=vpc_cidr))
        default_security_group = []
        for range in [{"value": i} for i in range(0, 1 if security_group_id ==  else 0)]:
            default_security_group.append(alicloud.ecs.SecurityGroup(f"default-{range['value']}",
                name=security_group_name,
                vpc_id=vpc[0].id if vpc_id == "" else vpc_id))
        # VSwitch Resource for Module
        vswitch = []
        for range in [{"value": i} for i in range(0, 1 if vswitch_id ==  else 0)]:
            vswitch.append(alicloud.vpc.Switch(f"vswitch-{range['value']}",
                availability_zone=default_get_instance_types.types[0].zone_id if availability_zone == "" else availability_zone,
                vswitch_name=vswitch_name,
                cidr_block=vswitch_cidr,
                vpc_id=vpc[0].id if vpc_id == "" else vpc_id))
        # Ram role Resource for Module
        default_role = alicloud.ram.Role("default",
            name=ram_name,
            document=\"\"\"    {
                "Statement": [
                {
                    "Action": "sts:AssumeRole",
                    "Effect": "Allow",
                    "Principal": {
                    "Service": [
                        "emr.aliyuncs.com",
                        "ecs.aliyuncs.com"
                    ]
                    }
                }
                ],
                "Version": "1"
            }
        \"\"\",
            description="this is a role test.",
            force=True)
        gateway = alicloud.emr.Cluster("gateway",
            name="terraform-gateway-cluster-test",
            emr_ver=default.main_versions[0].emr_version,
            cluster_type="GATEWAY",
            host_groups=[{
                "host_group_name": "master_group",
                "host_group_type": "GATEWAY",
                "node_count": "1",
                "instance_type": default_get_instance_types.types[0].id,
                "disk_type": data_disk.types[0].value,
                "disk_capacity": data_disk.types[0].min if data_disk.types[0].min > 160 else "160",
                "disk_count": "1",
                "sys_disk_type": system_disk.types[0].value,
                "sys_disk_capacity": system_disk.types[0].min if system_disk.types[0].min > 160 else "160",
            }],
            high_availability_enable=True,
            zone_id=default_get_instance_types.types[0].zone_id,
            security_group_id=default_security_group[0].id if security_group_id == "" else security_group_id,
            is_open_public_ip=True,
            charge_type="PostPaid",
            vswitch_id=vswitch[0].id if vswitch_id == "" else vswitch_id,
            user_defined_emr_ecs_role=default_role.name,
            ssh_enable=True,
            master_pwd="ABCtest1234!",
            related_cluster_id=related_cluster_id)
        ```

        ## Import

        Aliclioud E-MapReduce cluster can be imported using the id e.g.

        ```sh
        $ pulumi import alicloud:emr/cluster:Cluster default C-B47FB8FE96C67XXXX
        ```

        :param str resource_name: The name of the resource.
        :param ClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bootstrap_actions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterBootstrapActionArgs', 'ClusterBootstrapActionArgsDict']]]]] = None,
                 charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_type: Optional[pulumi.Input[_builtins.str]] = None,
                 configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterConfigArgs', 'ClusterConfigArgsDict']]]]] = None,
                 deposit_type: Optional[pulumi.Input[_builtins.str]] = None,
                 eas_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 emr_ver: Optional[pulumi.Input[_builtins.str]] = None,
                 high_availability_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 host_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterHostGroupArgs', 'ClusterHostGroupArgsDict']]]]] = None,
                 is_open_public_ip: Optional[pulumi.Input[_builtins.bool]] = None,
                 key_pair_name: Optional[pulumi.Input[_builtins.str]] = None,
                 master_pwd: Optional[pulumi.Input[_builtins.str]] = None,
                 meta_store_conf: Optional[pulumi.Input[Union['ClusterMetaStoreConfArgs', 'ClusterMetaStoreConfArgsDict']]] = None,
                 meta_store_type: Optional[pulumi.Input[_builtins.str]] = None,
                 modify_cluster_service_config: Optional[pulumi.Input[Union['ClusterModifyClusterServiceConfigArgs', 'ClusterModifyClusterServiceConfigArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 option_software_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 related_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ssh_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 use_local_metadb: Optional[pulumi.Input[_builtins.bool]] = None,
                 user_defined_emr_ecs_role: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClusterArgs.__new__(ClusterArgs)

            __props__.__dict__["bootstrap_actions"] = bootstrap_actions
            __props__.__dict__["charge_type"] = charge_type
            if cluster_type is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_type'")
            __props__.__dict__["cluster_type"] = cluster_type
            __props__.__dict__["configs"] = configs
            __props__.__dict__["deposit_type"] = deposit_type
            __props__.__dict__["eas_enable"] = eas_enable
            if emr_ver is None and not opts.urn:
                raise TypeError("Missing required property 'emr_ver'")
            __props__.__dict__["emr_ver"] = emr_ver
            __props__.__dict__["high_availability_enable"] = high_availability_enable
            __props__.__dict__["host_groups"] = host_groups
            __props__.__dict__["is_open_public_ip"] = is_open_public_ip
            __props__.__dict__["key_pair_name"] = key_pair_name
            __props__.__dict__["master_pwd"] = master_pwd
            __props__.__dict__["meta_store_conf"] = meta_store_conf
            __props__.__dict__["meta_store_type"] = meta_store_type
            __props__.__dict__["modify_cluster_service_config"] = modify_cluster_service_config
            __props__.__dict__["name"] = name
            __props__.__dict__["option_software_lists"] = option_software_lists
            __props__.__dict__["period"] = period
            __props__.__dict__["related_cluster_id"] = related_cluster_id
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["security_group_id"] = security_group_id
            __props__.__dict__["ssh_enable"] = ssh_enable
            __props__.__dict__["tags"] = tags
            __props__.__dict__["use_local_metadb"] = use_local_metadb
            __props__.__dict__["user_defined_emr_ecs_role"] = user_defined_emr_ecs_role
            __props__.__dict__["vswitch_id"] = vswitch_id
            if zone_id is None and not opts.urn:
                raise TypeError("Missing required property 'zone_id'")
            __props__.__dict__["zone_id"] = zone_id
        super(Cluster, __self__).__init__(
            'alicloud:emr/cluster:Cluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bootstrap_actions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterBootstrapActionArgs', 'ClusterBootstrapActionArgsDict']]]]] = None,
            charge_type: Optional[pulumi.Input[_builtins.str]] = None,
            cluster_type: Optional[pulumi.Input[_builtins.str]] = None,
            configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterConfigArgs', 'ClusterConfigArgsDict']]]]] = None,
            deposit_type: Optional[pulumi.Input[_builtins.str]] = None,
            eas_enable: Optional[pulumi.Input[_builtins.bool]] = None,
            emr_ver: Optional[pulumi.Input[_builtins.str]] = None,
            high_availability_enable: Optional[pulumi.Input[_builtins.bool]] = None,
            host_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterHostGroupArgs', 'ClusterHostGroupArgsDict']]]]] = None,
            is_open_public_ip: Optional[pulumi.Input[_builtins.bool]] = None,
            key_pair_name: Optional[pulumi.Input[_builtins.str]] = None,
            master_pwd: Optional[pulumi.Input[_builtins.str]] = None,
            meta_store_conf: Optional[pulumi.Input[Union['ClusterMetaStoreConfArgs', 'ClusterMetaStoreConfArgsDict']]] = None,
            meta_store_type: Optional[pulumi.Input[_builtins.str]] = None,
            modify_cluster_service_config: Optional[pulumi.Input[Union['ClusterModifyClusterServiceConfigArgs', 'ClusterModifyClusterServiceConfigArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            option_software_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            period: Optional[pulumi.Input[_builtins.int]] = None,
            related_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            ssh_enable: Optional[pulumi.Input[_builtins.bool]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            use_local_metadb: Optional[pulumi.Input[_builtins.bool]] = None,
            user_defined_emr_ecs_role: Optional[pulumi.Input[_builtins.str]] = None,
            vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
            zone_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'Cluster':
        """
        Get an existing Cluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterBootstrapActionArgs', 'ClusterBootstrapActionArgsDict']]]] bootstrap_actions: Boot action parameters.
        :param pulumi.Input[_builtins.str] charge_type: Charge Type for this cluster. Supported value: PostPaid or PrePaid. Default value: PostPaid.
        :param pulumi.Input[_builtins.str] cluster_type: EMR Cluster Type, e.g. HADOOP, KAFKA, DRUID, GATEWAY etc. You can find all valid EMR cluster type in emr web console. Supported 'GATEWAY' available in 1.61.0+.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterConfigArgs', 'ClusterConfigArgsDict']]]] configs: The custom configurations of emr-cluster service.
        :param pulumi.Input[_builtins.str] deposit_type: Cluster deposit type, HALF_MANAGED or FULL_MANAGED.
        :param pulumi.Input[_builtins.bool] eas_enable: High security cluster (true) or not. Default value is false.
        :param pulumi.Input[_builtins.str] emr_ver: EMR Version, e.g. EMR-3.22.0. You can find the all valid EMR Version in emr web console.
        :param pulumi.Input[_builtins.bool] high_availability_enable: High Available for HDFS and YARN. If this is set true, MASTER group must have two nodes.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterHostGroupArgs', 'ClusterHostGroupArgsDict']]]] host_groups: Groups of Host, You can specify MASTER as a group, CORE as a group (just like the above example).
        :param pulumi.Input[_builtins.bool] is_open_public_ip: Whether the MASTER node has a public IP address enabled. Default value is false.
        :param pulumi.Input[_builtins.str] key_pair_name: Ssh key pair.
        :param pulumi.Input[_builtins.str] master_pwd: Master ssh password.
        :param pulumi.Input[Union['ClusterMetaStoreConfArgs', 'ClusterMetaStoreConfArgsDict']] meta_store_conf: The configuration of emr-cluster service component metadata storage. If meta store type is ’user_rds’, this should be specified.
        :param pulumi.Input[_builtins.str] meta_store_type: The type of emr-cluster service component metadata storage. ’dlf’ or ’local’ or ’user_rds’ .
        :param pulumi.Input[Union['ClusterModifyClusterServiceConfigArgs', 'ClusterModifyClusterServiceConfigArgsDict']] modify_cluster_service_config: The configurations of emr-cluster service modification after cluster created.
        :param pulumi.Input[_builtins.str] name: The name of emr cluster. The name length must be less than 64. Supported characters: chinese character, english character, number, "-", "_".
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] option_software_lists: Optional software list.
        :param pulumi.Input[_builtins.int] period: If charge type is PrePaid, this should be specified, unit is month. Supported value: 1、2、3、4、5、6、7、8、9、12、24、36.
        :param pulumi.Input[_builtins.str] related_cluster_id: This specify the related cluster id, if this cluster is a Gateway.
        :param pulumi.Input[_builtins.str] resource_group_id: The Id of resource group which the emr-cluster belongs.
        :param pulumi.Input[_builtins.str] security_group_id: Security Group ID for Cluster, you can also specify this key for each host group.
        :param pulumi.Input[_builtins.bool] ssh_enable: If this is set true, we can ssh into cluster. Default value is false.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.bool] use_local_metadb: Use local metadb. Default is false.
        :param pulumi.Input[_builtins.str] user_defined_emr_ecs_role: Alicloud EMR uses roles to perform actions on your behalf when provisioning cluster resources, running applications, dynamically scaling resources. EMR uses the following roles when interacting with other Alicloud services. Default value is AliyunEmrEcsDefaultRole.
        :param pulumi.Input[_builtins.str] vswitch_id: Global vswitch id, you can also specify it in host group.
        :param pulumi.Input[_builtins.str] zone_id: Zone ID, e.g. cn-huhehaote-a
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClusterState.__new__(_ClusterState)

        __props__.__dict__["bootstrap_actions"] = bootstrap_actions
        __props__.__dict__["charge_type"] = charge_type
        __props__.__dict__["cluster_type"] = cluster_type
        __props__.__dict__["configs"] = configs
        __props__.__dict__["deposit_type"] = deposit_type
        __props__.__dict__["eas_enable"] = eas_enable
        __props__.__dict__["emr_ver"] = emr_ver
        __props__.__dict__["high_availability_enable"] = high_availability_enable
        __props__.__dict__["host_groups"] = host_groups
        __props__.__dict__["is_open_public_ip"] = is_open_public_ip
        __props__.__dict__["key_pair_name"] = key_pair_name
        __props__.__dict__["master_pwd"] = master_pwd
        __props__.__dict__["meta_store_conf"] = meta_store_conf
        __props__.__dict__["meta_store_type"] = meta_store_type
        __props__.__dict__["modify_cluster_service_config"] = modify_cluster_service_config
        __props__.__dict__["name"] = name
        __props__.__dict__["option_software_lists"] = option_software_lists
        __props__.__dict__["period"] = period
        __props__.__dict__["related_cluster_id"] = related_cluster_id
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["security_group_id"] = security_group_id
        __props__.__dict__["ssh_enable"] = ssh_enable
        __props__.__dict__["tags"] = tags
        __props__.__dict__["use_local_metadb"] = use_local_metadb
        __props__.__dict__["user_defined_emr_ecs_role"] = user_defined_emr_ecs_role
        __props__.__dict__["vswitch_id"] = vswitch_id
        __props__.__dict__["zone_id"] = zone_id
        return Cluster(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="bootstrapActions")
    def bootstrap_actions(self) -> pulumi.Output[Optional[Sequence['outputs.ClusterBootstrapAction']]]:
        """
        Boot action parameters.
        """
        return pulumi.get(self, "bootstrap_actions")

    @_builtins.property
    @pulumi.getter(name="chargeType")
    def charge_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Charge Type for this cluster. Supported value: PostPaid or PrePaid. Default value: PostPaid.
        """
        return pulumi.get(self, "charge_type")

    @_builtins.property
    @pulumi.getter(name="clusterType")
    def cluster_type(self) -> pulumi.Output[_builtins.str]:
        """
        EMR Cluster Type, e.g. HADOOP, KAFKA, DRUID, GATEWAY etc. You can find all valid EMR cluster type in emr web console. Supported 'GATEWAY' available in 1.61.0+.
        """
        return pulumi.get(self, "cluster_type")

    @_builtins.property
    @pulumi.getter
    def configs(self) -> pulumi.Output[Optional[Sequence['outputs.ClusterConfig']]]:
        """
        The custom configurations of emr-cluster service.
        """
        return pulumi.get(self, "configs")

    @_builtins.property
    @pulumi.getter(name="depositType")
    def deposit_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Cluster deposit type, HALF_MANAGED or FULL_MANAGED.
        """
        return pulumi.get(self, "deposit_type")

    @_builtins.property
    @pulumi.getter(name="easEnable")
    def eas_enable(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        High security cluster (true) or not. Default value is false.
        """
        return pulumi.get(self, "eas_enable")

    @_builtins.property
    @pulumi.getter(name="emrVer")
    def emr_ver(self) -> pulumi.Output[_builtins.str]:
        """
        EMR Version, e.g. EMR-3.22.0. You can find the all valid EMR Version in emr web console.
        """
        return pulumi.get(self, "emr_ver")

    @_builtins.property
    @pulumi.getter(name="highAvailabilityEnable")
    def high_availability_enable(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        High Available for HDFS and YARN. If this is set true, MASTER group must have two nodes.
        """
        return pulumi.get(self, "high_availability_enable")

    @_builtins.property
    @pulumi.getter(name="hostGroups")
    def host_groups(self) -> pulumi.Output[Optional[Sequence['outputs.ClusterHostGroup']]]:
        """
        Groups of Host, You can specify MASTER as a group, CORE as a group (just like the above example).
        """
        return pulumi.get(self, "host_groups")

    @_builtins.property
    @pulumi.getter(name="isOpenPublicIp")
    def is_open_public_ip(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether the MASTER node has a public IP address enabled. Default value is false.
        """
        return pulumi.get(self, "is_open_public_ip")

    @_builtins.property
    @pulumi.getter(name="keyPairName")
    def key_pair_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Ssh key pair.
        """
        return pulumi.get(self, "key_pair_name")

    @_builtins.property
    @pulumi.getter(name="masterPwd")
    def master_pwd(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Master ssh password.
        """
        return pulumi.get(self, "master_pwd")

    @_builtins.property
    @pulumi.getter(name="metaStoreConf")
    def meta_store_conf(self) -> pulumi.Output[Optional['outputs.ClusterMetaStoreConf']]:
        """
        The configuration of emr-cluster service component metadata storage. If meta store type is ’user_rds’, this should be specified.
        """
        return pulumi.get(self, "meta_store_conf")

    @_builtins.property
    @pulumi.getter(name="metaStoreType")
    def meta_store_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of emr-cluster service component metadata storage. ’dlf’ or ’local’ or ’user_rds’ .
        """
        return pulumi.get(self, "meta_store_type")

    @_builtins.property
    @pulumi.getter(name="modifyClusterServiceConfig")
    def modify_cluster_service_config(self) -> pulumi.Output[Optional['outputs.ClusterModifyClusterServiceConfig']]:
        """
        The configurations of emr-cluster service modification after cluster created.
        """
        return pulumi.get(self, "modify_cluster_service_config")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of emr cluster. The name length must be less than 64. Supported characters: chinese character, english character, number, "-", "_".
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="optionSoftwareLists")
    def option_software_lists(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Optional software list.
        """
        return pulumi.get(self, "option_software_lists")

    @_builtins.property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        If charge type is PrePaid, this should be specified, unit is month. Supported value: 1、2、3、4、5、6、7、8、9、12、24、36.
        """
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter(name="relatedClusterId")
    def related_cluster_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        This specify the related cluster id, if this cluster is a Gateway.
        """
        return pulumi.get(self, "related_cluster_id")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Id of resource group which the emr-cluster belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Security Group ID for Cluster, you can also specify this key for each host group.
        """
        return pulumi.get(self, "security_group_id")

    @_builtins.property
    @pulumi.getter(name="sshEnable")
    def ssh_enable(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If this is set true, we can ssh into cluster. Default value is false.
        """
        return pulumi.get(self, "ssh_enable")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="useLocalMetadb")
    def use_local_metadb(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Use local metadb. Default is false.
        """
        return pulumi.get(self, "use_local_metadb")

    @_builtins.property
    @pulumi.getter(name="userDefinedEmrEcsRole")
    def user_defined_emr_ecs_role(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Alicloud EMR uses roles to perform actions on your behalf when provisioning cluster resources, running applications, dynamically scaling resources. EMR uses the following roles when interacting with other Alicloud services. Default value is AliyunEmrEcsDefaultRole.
        """
        return pulumi.get(self, "user_defined_emr_ecs_role")

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Global vswitch id, you can also specify it in host group.
        """
        return pulumi.get(self, "vswitch_id")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[_builtins.str]:
        """
        Zone ID, e.g. cn-huhehaote-a
        """
        return pulumi.get(self, "zone_id")

