# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['EipArgs', 'Eip']

@pulumi.input_type
class EipArgs:
    def __init__(__self__, *,
                 ens_region_id: pulumi.Input[_builtins.str],
                 internet_charge_type: pulumi.Input[_builtins.str],
                 payment_type: pulumi.Input[_builtins.str],
                 bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 eip_name: Optional[pulumi.Input[_builtins.str]] = None,
                 isp: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Eip resource.
        :param pulumi.Input[_builtins.str] ens_region_id: Ens node ID.
        :param pulumi.Input[_builtins.str] internet_charge_type: The metering method of the EIP. Valid value: `95BandwidthByMonth`.
        :param pulumi.Input[_builtins.str] payment_type: The billing method of the EIP. Valid value: `PayAsYouGo`.
        :param pulumi.Input[_builtins.int] bandwidth: The maximum bandwidth of the EIP. Default value: `5`. Valid values: `5` to `10000`. Unit: Mbit/s.
        :param pulumi.Input[_builtins.str] description: The description of the EIP.
        :param pulumi.Input[_builtins.str] eip_name: The name of the EIP.
        :param pulumi.Input[_builtins.str] isp: The Internet service provider. Valid value: `cmcc`, `unicom`, `telecom`.
        """
        pulumi.set(__self__, "ens_region_id", ens_region_id)
        pulumi.set(__self__, "internet_charge_type", internet_charge_type)
        pulumi.set(__self__, "payment_type", payment_type)
        if bandwidth is not None:
            pulumi.set(__self__, "bandwidth", bandwidth)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if eip_name is not None:
            pulumi.set(__self__, "eip_name", eip_name)
        if isp is not None:
            pulumi.set(__self__, "isp", isp)

    @_builtins.property
    @pulumi.getter(name="ensRegionId")
    def ens_region_id(self) -> pulumi.Input[_builtins.str]:
        """
        Ens node ID.
        """
        return pulumi.get(self, "ens_region_id")

    @ens_region_id.setter
    def ens_region_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "ens_region_id", value)

    @_builtins.property
    @pulumi.getter(name="internetChargeType")
    def internet_charge_type(self) -> pulumi.Input[_builtins.str]:
        """
        The metering method of the EIP. Valid value: `95BandwidthByMonth`.
        """
        return pulumi.get(self, "internet_charge_type")

    @internet_charge_type.setter
    def internet_charge_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "internet_charge_type", value)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Input[_builtins.str]:
        """
        The billing method of the EIP. Valid value: `PayAsYouGo`.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum bandwidth of the EIP. Default value: `5`. Valid values: `5` to `10000`. Unit: Mbit/s.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "bandwidth", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the EIP.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="eipName")
    def eip_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the EIP.
        """
        return pulumi.get(self, "eip_name")

    @eip_name.setter
    def eip_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "eip_name", value)

    @_builtins.property
    @pulumi.getter
    def isp(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Internet service provider. Valid value: `cmcc`, `unicom`, `telecom`.
        """
        return pulumi.get(self, "isp")

    @isp.setter
    def isp(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "isp", value)


@pulumi.input_type
class _EipState:
    def __init__(__self__, *,
                 bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 eip_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ens_region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 internet_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 isp: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Eip resources.
        :param pulumi.Input[_builtins.int] bandwidth: The maximum bandwidth of the EIP. Default value: `5`. Valid values: `5` to `10000`. Unit: Mbit/s.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the EIP instance.
        :param pulumi.Input[_builtins.str] description: The description of the EIP.
        :param pulumi.Input[_builtins.str] eip_name: The name of the EIP.
        :param pulumi.Input[_builtins.str] ens_region_id: Ens node ID.
        :param pulumi.Input[_builtins.str] internet_charge_type: The metering method of the EIP. Valid value: `95BandwidthByMonth`.
        :param pulumi.Input[_builtins.str] isp: The Internet service provider. Valid value: `cmcc`, `unicom`, `telecom`.
        :param pulumi.Input[_builtins.str] payment_type: The billing method of the EIP. Valid value: `PayAsYouGo`.
        :param pulumi.Input[_builtins.str] status: The status of the EIP.
        """
        if bandwidth is not None:
            pulumi.set(__self__, "bandwidth", bandwidth)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if eip_name is not None:
            pulumi.set(__self__, "eip_name", eip_name)
        if ens_region_id is not None:
            pulumi.set(__self__, "ens_region_id", ens_region_id)
        if internet_charge_type is not None:
            pulumi.set(__self__, "internet_charge_type", internet_charge_type)
        if isp is not None:
            pulumi.set(__self__, "isp", isp)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum bandwidth of the EIP. Default value: `5`. Valid values: `5` to `10000`. Unit: Mbit/s.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "bandwidth", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation time of the EIP instance.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the EIP.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="eipName")
    def eip_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the EIP.
        """
        return pulumi.get(self, "eip_name")

    @eip_name.setter
    def eip_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "eip_name", value)

    @_builtins.property
    @pulumi.getter(name="ensRegionId")
    def ens_region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Ens node ID.
        """
        return pulumi.get(self, "ens_region_id")

    @ens_region_id.setter
    def ens_region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ens_region_id", value)

    @_builtins.property
    @pulumi.getter(name="internetChargeType")
    def internet_charge_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The metering method of the EIP. Valid value: `95BandwidthByMonth`.
        """
        return pulumi.get(self, "internet_charge_type")

    @internet_charge_type.setter
    def internet_charge_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "internet_charge_type", value)

    @_builtins.property
    @pulumi.getter
    def isp(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Internet service provider. Valid value: `cmcc`, `unicom`, `telecom`.
        """
        return pulumi.get(self, "isp")

    @isp.setter
    def isp(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "isp", value)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The billing method of the EIP. Valid value: `PayAsYouGo`.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the EIP.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("alicloud:ens/eip:Eip")
class Eip(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 eip_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ens_region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 internet_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 isp: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a ENS Eip resource.

        Edge elastic public network IP. When you use it for the first time, please contact the product classmates to add a resource whitelist.

        For information about ENS Eip and how to use it, see [What is Eip](https://www.alibabacloud.com/help/en/ens/developer-reference/api-createeipinstance).

        > **NOTE:** Available since v1.213.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.ens.Eip("default",
            description="EipDescription_autotest",
            bandwidth=5,
            isp="cmcc",
            payment_type="PayAsYouGo",
            ens_region_id="cn-chenzhou-telecom_unicom_cmcc",
            eip_name=name,
            internet_charge_type="95BandwidthByMonth")
        ```

        ## Import

        ENS Eip can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ens/eip:Eip example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] bandwidth: The maximum bandwidth of the EIP. Default value: `5`. Valid values: `5` to `10000`. Unit: Mbit/s.
        :param pulumi.Input[_builtins.str] description: The description of the EIP.
        :param pulumi.Input[_builtins.str] eip_name: The name of the EIP.
        :param pulumi.Input[_builtins.str] ens_region_id: Ens node ID.
        :param pulumi.Input[_builtins.str] internet_charge_type: The metering method of the EIP. Valid value: `95BandwidthByMonth`.
        :param pulumi.Input[_builtins.str] isp: The Internet service provider. Valid value: `cmcc`, `unicom`, `telecom`.
        :param pulumi.Input[_builtins.str] payment_type: The billing method of the EIP. Valid value: `PayAsYouGo`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EipArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a ENS Eip resource.

        Edge elastic public network IP. When you use it for the first time, please contact the product classmates to add a resource whitelist.

        For information about ENS Eip and how to use it, see [What is Eip](https://www.alibabacloud.com/help/en/ens/developer-reference/api-createeipinstance).

        > **NOTE:** Available since v1.213.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.ens.Eip("default",
            description="EipDescription_autotest",
            bandwidth=5,
            isp="cmcc",
            payment_type="PayAsYouGo",
            ens_region_id="cn-chenzhou-telecom_unicom_cmcc",
            eip_name=name,
            internet_charge_type="95BandwidthByMonth")
        ```

        ## Import

        ENS Eip can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ens/eip:Eip example <id>
        ```

        :param str resource_name: The name of the resource.
        :param EipArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EipArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 eip_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ens_region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 internet_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 isp: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EipArgs.__new__(EipArgs)

            __props__.__dict__["bandwidth"] = bandwidth
            __props__.__dict__["description"] = description
            __props__.__dict__["eip_name"] = eip_name
            if ens_region_id is None and not opts.urn:
                raise TypeError("Missing required property 'ens_region_id'")
            __props__.__dict__["ens_region_id"] = ens_region_id
            if internet_charge_type is None and not opts.urn:
                raise TypeError("Missing required property 'internet_charge_type'")
            __props__.__dict__["internet_charge_type"] = internet_charge_type
            __props__.__dict__["isp"] = isp
            if payment_type is None and not opts.urn:
                raise TypeError("Missing required property 'payment_type'")
            __props__.__dict__["payment_type"] = payment_type
            __props__.__dict__["create_time"] = None
            __props__.__dict__["status"] = None
        super(Eip, __self__).__init__(
            'alicloud:ens/eip:Eip',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            eip_name: Optional[pulumi.Input[_builtins.str]] = None,
            ens_region_id: Optional[pulumi.Input[_builtins.str]] = None,
            internet_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
            isp: Optional[pulumi.Input[_builtins.str]] = None,
            payment_type: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None) -> 'Eip':
        """
        Get an existing Eip resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] bandwidth: The maximum bandwidth of the EIP. Default value: `5`. Valid values: `5` to `10000`. Unit: Mbit/s.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the EIP instance.
        :param pulumi.Input[_builtins.str] description: The description of the EIP.
        :param pulumi.Input[_builtins.str] eip_name: The name of the EIP.
        :param pulumi.Input[_builtins.str] ens_region_id: Ens node ID.
        :param pulumi.Input[_builtins.str] internet_charge_type: The metering method of the EIP. Valid value: `95BandwidthByMonth`.
        :param pulumi.Input[_builtins.str] isp: The Internet service provider. Valid value: `cmcc`, `unicom`, `telecom`.
        :param pulumi.Input[_builtins.str] payment_type: The billing method of the EIP. Valid value: `PayAsYouGo`.
        :param pulumi.Input[_builtins.str] status: The status of the EIP.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EipState.__new__(_EipState)

        __props__.__dict__["bandwidth"] = bandwidth
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["eip_name"] = eip_name
        __props__.__dict__["ens_region_id"] = ens_region_id
        __props__.__dict__["internet_charge_type"] = internet_charge_type
        __props__.__dict__["isp"] = isp
        __props__.__dict__["payment_type"] = payment_type
        __props__.__dict__["status"] = status
        return Eip(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> pulumi.Output[_builtins.int]:
        """
        The maximum bandwidth of the EIP. Default value: `5`. Valid values: `5` to `10000`. Unit: Mbit/s.
        """
        return pulumi.get(self, "bandwidth")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The creation time of the EIP instance.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the EIP.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="eipName")
    def eip_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the EIP.
        """
        return pulumi.get(self, "eip_name")

    @_builtins.property
    @pulumi.getter(name="ensRegionId")
    def ens_region_id(self) -> pulumi.Output[_builtins.str]:
        """
        Ens node ID.
        """
        return pulumi.get(self, "ens_region_id")

    @_builtins.property
    @pulumi.getter(name="internetChargeType")
    def internet_charge_type(self) -> pulumi.Output[_builtins.str]:
        """
        The metering method of the EIP. Valid value: `95BandwidthByMonth`.
        """
        return pulumi.get(self, "internet_charge_type")

    @_builtins.property
    @pulumi.getter
    def isp(self) -> pulumi.Output[_builtins.str]:
        """
        The Internet service provider. Valid value: `cmcc`, `unicom`, `telecom`.
        """
        return pulumi.get(self, "isp")

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Output[_builtins.str]:
        """
        The billing method of the EIP. Valid value: `PayAsYouGo`.
        """
        return pulumi.get(self, "payment_type")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the EIP.
        """
        return pulumi.get(self, "status")

