# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ImageArgs', 'Image']

@pulumi.input_type
class ImageArgs:
    def __init__(__self__, *,
                 image_name: pulumi.Input[_builtins.str],
                 delete_after_image_upload: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 target_oss_region_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Image resource.
        :param pulumi.Input[_builtins.str] image_name: The name of the image. The name must be 2 to 128 characters in length. The name can contain letters, digits, colons (:), underscores (_), and hyphens (-). It must start with a letter but cannot start with http:// or https://. The name can contain letters, digits, colons (:), underscores (_), and hyphens (-).
        :param pulumi.Input[_builtins.str] delete_after_image_upload: Specifies whether to automatically release the instance after the image is packaged and uploaded. Only image builders are supported. Default value: `false`. Valid values:
        :param pulumi.Input[_builtins.str] instance_id: The ID of the instance.
        :param pulumi.Input[_builtins.str] target_oss_region_id: The region of the target OSS where the image is to be stored.
        """
        pulumi.set(__self__, "image_name", image_name)
        if delete_after_image_upload is not None:
            pulumi.set(__self__, "delete_after_image_upload", delete_after_image_upload)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if target_oss_region_id is not None:
            pulumi.set(__self__, "target_oss_region_id", target_oss_region_id)

    @_builtins.property
    @pulumi.getter(name="imageName")
    def image_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the image. The name must be 2 to 128 characters in length. The name can contain letters, digits, colons (:), underscores (_), and hyphens (-). It must start with a letter but cannot start with http:// or https://. The name can contain letters, digits, colons (:), underscores (_), and hyphens (-).
        """
        return pulumi.get(self, "image_name")

    @image_name.setter
    def image_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "image_name", value)

    @_builtins.property
    @pulumi.getter(name="deleteAfterImageUpload")
    def delete_after_image_upload(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether to automatically release the instance after the image is packaged and uploaded. Only image builders are supported. Default value: `false`. Valid values:
        """
        return pulumi.get(self, "delete_after_image_upload")

    @delete_after_image_upload.setter
    def delete_after_image_upload(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "delete_after_image_upload", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="targetOssRegionId")
    def target_oss_region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region of the target OSS where the image is to be stored.
        """
        return pulumi.get(self, "target_oss_region_id")

    @target_oss_region_id.setter
    def target_oss_region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_oss_region_id", value)


@pulumi.input_type
class _ImageState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_after_image_upload: Optional[pulumi.Input[_builtins.str]] = None,
                 image_name: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 target_oss_region_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Image resources.
        :param pulumi.Input[_builtins.str] create_time: The image creation time.
        :param pulumi.Input[_builtins.str] delete_after_image_upload: Specifies whether to automatically release the instance after the image is packaged and uploaded. Only image builders are supported. Default value: `false`. Valid values:
        :param pulumi.Input[_builtins.str] image_name: The name of the image. The name must be 2 to 128 characters in length. The name can contain letters, digits, colons (:), underscores (_), and hyphens (-). It must start with a letter but cannot start with http:// or https://. The name can contain letters, digits, colons (:), underscores (_), and hyphens (-).
        :param pulumi.Input[_builtins.str] instance_id: The ID of the instance.
        :param pulumi.Input[_builtins.str] status: The state of the image.
        :param pulumi.Input[_builtins.str] target_oss_region_id: The region of the target OSS where the image is to be stored.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if delete_after_image_upload is not None:
            pulumi.set(__self__, "delete_after_image_upload", delete_after_image_upload)
        if image_name is not None:
            pulumi.set(__self__, "image_name", image_name)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if target_oss_region_id is not None:
            pulumi.set(__self__, "target_oss_region_id", target_oss_region_id)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The image creation time.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="deleteAfterImageUpload")
    def delete_after_image_upload(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether to automatically release the instance after the image is packaged and uploaded. Only image builders are supported. Default value: `false`. Valid values:
        """
        return pulumi.get(self, "delete_after_image_upload")

    @delete_after_image_upload.setter
    def delete_after_image_upload(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "delete_after_image_upload", value)

    @_builtins.property
    @pulumi.getter(name="imageName")
    def image_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the image. The name must be 2 to 128 characters in length. The name can contain letters, digits, colons (:), underscores (_), and hyphens (-). It must start with a letter but cannot start with http:// or https://. The name can contain letters, digits, colons (:), underscores (_), and hyphens (-).
        """
        return pulumi.get(self, "image_name")

    @image_name.setter
    def image_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_name", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The state of the image.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="targetOssRegionId")
    def target_oss_region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region of the target OSS where the image is to be stored.
        """
        return pulumi.get(self, "target_oss_region_id")

    @target_oss_region_id.setter
    def target_oss_region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_oss_region_id", value)


@pulumi.type_token("alicloud:ens/image:Image")
class Image(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 delete_after_image_upload: Optional[pulumi.Input[_builtins.str]] = None,
                 image_name: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 target_oss_region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a ENS Image resource.

        For information about ENS Image and how to use it, see [What is Image](https://www.alibabacloud.com/help/en/ens/developer-reference/api-ens-2017-11-10-createimage).

        > **NOTE:** Available since v1.216.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.ens.Instance("default",
            system_disk={
                "size": 20,
            },
            schedule_area_level="Region",
            image_id="centos_6_08_64_20G_alibase_20171208",
            payment_type="PayAsYouGo",
            password="12345678ABCabc",
            amount=1,
            internet_max_bandwidth_out=10,
            public_ip_identification=True,
            ens_region_id="cn-chenzhou-telecom_unicom_cmcc",
            period_unit="Month",
            instance_type="ens.sn1.stiny",
            status="Stopped")
        default_image = alicloud.ens.Image("default",
            image_name=name,
            instance_id=default.id,
            delete_after_image_upload="false")
        ```

        ## Import

        ENS Image can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ens/image:Image example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] delete_after_image_upload: Specifies whether to automatically release the instance after the image is packaged and uploaded. Only image builders are supported. Default value: `false`. Valid values:
        :param pulumi.Input[_builtins.str] image_name: The name of the image. The name must be 2 to 128 characters in length. The name can contain letters, digits, colons (:), underscores (_), and hyphens (-). It must start with a letter but cannot start with http:// or https://. The name can contain letters, digits, colons (:), underscores (_), and hyphens (-).
        :param pulumi.Input[_builtins.str] instance_id: The ID of the instance.
        :param pulumi.Input[_builtins.str] target_oss_region_id: The region of the target OSS where the image is to be stored.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ImageArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a ENS Image resource.

        For information about ENS Image and how to use it, see [What is Image](https://www.alibabacloud.com/help/en/ens/developer-reference/api-ens-2017-11-10-createimage).

        > **NOTE:** Available since v1.216.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.ens.Instance("default",
            system_disk={
                "size": 20,
            },
            schedule_area_level="Region",
            image_id="centos_6_08_64_20G_alibase_20171208",
            payment_type="PayAsYouGo",
            password="12345678ABCabc",
            amount=1,
            internet_max_bandwidth_out=10,
            public_ip_identification=True,
            ens_region_id="cn-chenzhou-telecom_unicom_cmcc",
            period_unit="Month",
            instance_type="ens.sn1.stiny",
            status="Stopped")
        default_image = alicloud.ens.Image("default",
            image_name=name,
            instance_id=default.id,
            delete_after_image_upload="false")
        ```

        ## Import

        ENS Image can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ens/image:Image example <id>
        ```

        :param str resource_name: The name of the resource.
        :param ImageArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ImageArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 delete_after_image_upload: Optional[pulumi.Input[_builtins.str]] = None,
                 image_name: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 target_oss_region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ImageArgs.__new__(ImageArgs)

            __props__.__dict__["delete_after_image_upload"] = delete_after_image_upload
            if image_name is None and not opts.urn:
                raise TypeError("Missing required property 'image_name'")
            __props__.__dict__["image_name"] = image_name
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["target_oss_region_id"] = target_oss_region_id
            __props__.__dict__["create_time"] = None
            __props__.__dict__["status"] = None
        super(Image, __self__).__init__(
            'alicloud:ens/image:Image',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            delete_after_image_upload: Optional[pulumi.Input[_builtins.str]] = None,
            image_name: Optional[pulumi.Input[_builtins.str]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            target_oss_region_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'Image':
        """
        Get an existing Image resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] create_time: The image creation time.
        :param pulumi.Input[_builtins.str] delete_after_image_upload: Specifies whether to automatically release the instance after the image is packaged and uploaded. Only image builders are supported. Default value: `false`. Valid values:
        :param pulumi.Input[_builtins.str] image_name: The name of the image. The name must be 2 to 128 characters in length. The name can contain letters, digits, colons (:), underscores (_), and hyphens (-). It must start with a letter but cannot start with http:// or https://. The name can contain letters, digits, colons (:), underscores (_), and hyphens (-).
        :param pulumi.Input[_builtins.str] instance_id: The ID of the instance.
        :param pulumi.Input[_builtins.str] status: The state of the image.
        :param pulumi.Input[_builtins.str] target_oss_region_id: The region of the target OSS where the image is to be stored.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ImageState.__new__(_ImageState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["delete_after_image_upload"] = delete_after_image_upload
        __props__.__dict__["image_name"] = image_name
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["status"] = status
        __props__.__dict__["target_oss_region_id"] = target_oss_region_id
        return Image(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The image creation time.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="deleteAfterImageUpload")
    def delete_after_image_upload(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies whether to automatically release the instance after the image is packaged and uploaded. Only image builders are supported. Default value: `false`. Valid values:
        """
        return pulumi.get(self, "delete_after_image_upload")

    @_builtins.property
    @pulumi.getter(name="imageName")
    def image_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the image. The name must be 2 to 128 characters in length. The name can contain letters, digits, colons (:), underscores (_), and hyphens (-). It must start with a letter but cannot start with http:// or https://. The name can contain letters, digits, colons (:), underscores (_), and hyphens (-).
        """
        return pulumi.get(self, "image_name")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the instance.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The state of the image.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="targetOssRegionId")
    def target_oss_region_id(self) -> pulumi.Output[_builtins.str]:
        """
        The region of the target OSS where the image is to be stored.
        """
        return pulumi.get(self, "target_oss_region_id")

