# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['KvArgs', 'Kv']

@pulumi.input_type
class KvArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[_builtins.str],
                 namespace: pulumi.Input[_builtins.str],
                 expiration: Optional[pulumi.Input[_builtins.int]] = None,
                 expiration_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 isbase: Optional[pulumi.Input[_builtins.bool]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None,
                 value: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Kv resource.
        :param pulumi.Input[_builtins.str] key: kv
        :param pulumi.Input[_builtins.str] namespace: The name specified when calling [CreatevNamespace](https://help.aliyun.com/document_detail/2850317.html).
        :param pulumi.Input[_builtins.int] expiration: The content of the key, which can be up to 2 MB (2 × 1000 × 1000). If the content is larger than 2 MB, call [PutKvWithHighCapacity](https://www.alibabacloud.com/help/en/doc-detail/2850486.html).
        :param pulumi.Input[_builtins.int] expiration_ttl: The time when the key-value pair expires, which cannot be earlier than the current time. The value is a timestamp in seconds. If you specify both Expiration and ExpirationTtl, only ExpirationTtl takes effect.
        :param pulumi.Input[_builtins.bool] isbase: The relative expiration time. Unit: seconds. If you specify both Expiration and ExpirationTtl, only ExpirationTtl takes effect.
        :param pulumi.Input[_builtins.str] url: The key name. The name can be up to 512 characters in length and cannot contain spaces or backslashes (\\\\).
        :param pulumi.Input[_builtins.str] value: The content of the key. If the content has more than 256 characters in length, the system displays the first 100 and the last 100 characters, and omits the middle part.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "namespace", namespace)
        if expiration is not None:
            pulumi.set(__self__, "expiration", expiration)
        if expiration_ttl is not None:
            pulumi.set(__self__, "expiration_ttl", expiration_ttl)
        if isbase is not None:
            pulumi.set(__self__, "isbase", isbase)
        if url is not None:
            pulumi.set(__self__, "url", url)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> pulumi.Input[_builtins.str]:
        """
        kv
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "key", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> pulumi.Input[_builtins.str]:
        """
        The name specified when calling [CreatevNamespace](https://help.aliyun.com/document_detail/2850317.html).
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter
    def expiration(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The content of the key, which can be up to 2 MB (2 × 1000 × 1000). If the content is larger than 2 MB, call [PutKvWithHighCapacity](https://www.alibabacloud.com/help/en/doc-detail/2850486.html).
        """
        return pulumi.get(self, "expiration")

    @expiration.setter
    def expiration(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "expiration", value)

    @_builtins.property
    @pulumi.getter(name="expirationTtl")
    def expiration_ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The time when the key-value pair expires, which cannot be earlier than the current time. The value is a timestamp in seconds. If you specify both Expiration and ExpirationTtl, only ExpirationTtl takes effect.
        """
        return pulumi.get(self, "expiration_ttl")

    @expiration_ttl.setter
    def expiration_ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "expiration_ttl", value)

    @_builtins.property
    @pulumi.getter
    def isbase(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The relative expiration time. Unit: seconds. If you specify both Expiration and ExpirationTtl, only ExpirationTtl takes effect.
        """
        return pulumi.get(self, "isbase")

    @isbase.setter
    def isbase(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "isbase", value)

    @_builtins.property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The key name. The name can be up to 512 characters in length and cannot contain spaces or backslashes (\\\\).
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "url", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The content of the key. If the content has more than 256 characters in length, the system displays the first 100 and the last 100 characters, and omits the middle part.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class _KvState:
    def __init__(__self__, *,
                 expiration: Optional[pulumi.Input[_builtins.int]] = None,
                 expiration_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 isbase: Optional[pulumi.Input[_builtins.bool]] = None,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None,
                 value: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Kv resources.
        :param pulumi.Input[_builtins.int] expiration: The content of the key, which can be up to 2 MB (2 × 1000 × 1000). If the content is larger than 2 MB, call [PutKvWithHighCapacity](https://www.alibabacloud.com/help/en/doc-detail/2850486.html).
        :param pulumi.Input[_builtins.int] expiration_ttl: The time when the key-value pair expires, which cannot be earlier than the current time. The value is a timestamp in seconds. If you specify both Expiration and ExpirationTtl, only ExpirationTtl takes effect.
        :param pulumi.Input[_builtins.bool] isbase: The relative expiration time. Unit: seconds. If you specify both Expiration and ExpirationTtl, only ExpirationTtl takes effect.
        :param pulumi.Input[_builtins.str] key: kv
        :param pulumi.Input[_builtins.str] namespace: The name specified when calling [CreatevNamespace](https://help.aliyun.com/document_detail/2850317.html).
        :param pulumi.Input[_builtins.str] url: The key name. The name can be up to 512 characters in length and cannot contain spaces or backslashes (\\\\).
        :param pulumi.Input[_builtins.str] value: The content of the key. If the content has more than 256 characters in length, the system displays the first 100 and the last 100 characters, and omits the middle part.
        """
        if expiration is not None:
            pulumi.set(__self__, "expiration", expiration)
        if expiration_ttl is not None:
            pulumi.set(__self__, "expiration_ttl", expiration_ttl)
        if isbase is not None:
            pulumi.set(__self__, "isbase", isbase)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if url is not None:
            pulumi.set(__self__, "url", url)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def expiration(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The content of the key, which can be up to 2 MB (2 × 1000 × 1000). If the content is larger than 2 MB, call [PutKvWithHighCapacity](https://www.alibabacloud.com/help/en/doc-detail/2850486.html).
        """
        return pulumi.get(self, "expiration")

    @expiration.setter
    def expiration(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "expiration", value)

    @_builtins.property
    @pulumi.getter(name="expirationTtl")
    def expiration_ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The time when the key-value pair expires, which cannot be earlier than the current time. The value is a timestamp in seconds. If you specify both Expiration and ExpirationTtl, only ExpirationTtl takes effect.
        """
        return pulumi.get(self, "expiration_ttl")

    @expiration_ttl.setter
    def expiration_ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "expiration_ttl", value)

    @_builtins.property
    @pulumi.getter
    def isbase(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The relative expiration time. Unit: seconds. If you specify both Expiration and ExpirationTtl, only ExpirationTtl takes effect.
        """
        return pulumi.get(self, "isbase")

    @isbase.setter
    def isbase(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "isbase", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        kv
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name specified when calling [CreatevNamespace](https://help.aliyun.com/document_detail/2850317.html).
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The key name. The name can be up to 512 characters in length and cannot contain spaces or backslashes (\\\\).
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "url", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The content of the key. If the content has more than 256 characters in length, the system displays the first 100 and the last 100 characters, and omits the middle part.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "value", value)


@pulumi.type_token("alicloud:esa/kv:Kv")
class Kv(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 expiration: Optional[pulumi.Input[_builtins.int]] = None,
                 expiration_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 isbase: Optional[pulumi.Input[_builtins.bool]] = None,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None,
                 value: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a ESA Kv resource.

        For information about ESA Kv and how to use it, see [What is Kv](https://next.api.alibabacloud.com/document/ESA/2024-09-10/PutKv).

        > **NOTE:** Available since v1.251.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.esa.KvNamespace("default",
            description="this is a example namespace.",
            kv_namespace="namespace1")
        default_kv = alicloud.esa.Kv("default",
            isbase=False,
            expiration_ttl=360,
            value="example_value",
            expiration=1690,
            namespace=default.id,
            key="example_key")
        ```

        ## Import

        ESA Kv can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:esa/kv:Kv example <namespace>:<key>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] expiration: The content of the key, which can be up to 2 MB (2 × 1000 × 1000). If the content is larger than 2 MB, call [PutKvWithHighCapacity](https://www.alibabacloud.com/help/en/doc-detail/2850486.html).
        :param pulumi.Input[_builtins.int] expiration_ttl: The time when the key-value pair expires, which cannot be earlier than the current time. The value is a timestamp in seconds. If you specify both Expiration and ExpirationTtl, only ExpirationTtl takes effect.
        :param pulumi.Input[_builtins.bool] isbase: The relative expiration time. Unit: seconds. If you specify both Expiration and ExpirationTtl, only ExpirationTtl takes effect.
        :param pulumi.Input[_builtins.str] key: kv
        :param pulumi.Input[_builtins.str] namespace: The name specified when calling [CreatevNamespace](https://help.aliyun.com/document_detail/2850317.html).
        :param pulumi.Input[_builtins.str] url: The key name. The name can be up to 512 characters in length and cannot contain spaces or backslashes (\\\\).
        :param pulumi.Input[_builtins.str] value: The content of the key. If the content has more than 256 characters in length, the system displays the first 100 and the last 100 characters, and omits the middle part.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: KvArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a ESA Kv resource.

        For information about ESA Kv and how to use it, see [What is Kv](https://next.api.alibabacloud.com/document/ESA/2024-09-10/PutKv).

        > **NOTE:** Available since v1.251.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.esa.KvNamespace("default",
            description="this is a example namespace.",
            kv_namespace="namespace1")
        default_kv = alicloud.esa.Kv("default",
            isbase=False,
            expiration_ttl=360,
            value="example_value",
            expiration=1690,
            namespace=default.id,
            key="example_key")
        ```

        ## Import

        ESA Kv can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:esa/kv:Kv example <namespace>:<key>
        ```

        :param str resource_name: The name of the resource.
        :param KvArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(KvArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 expiration: Optional[pulumi.Input[_builtins.int]] = None,
                 expiration_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 isbase: Optional[pulumi.Input[_builtins.bool]] = None,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None,
                 value: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = KvArgs.__new__(KvArgs)

            __props__.__dict__["expiration"] = expiration
            __props__.__dict__["expiration_ttl"] = expiration_ttl
            __props__.__dict__["isbase"] = isbase
            if key is None and not opts.urn:
                raise TypeError("Missing required property 'key'")
            __props__.__dict__["key"] = key
            if namespace is None and not opts.urn:
                raise TypeError("Missing required property 'namespace'")
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["url"] = url
            __props__.__dict__["value"] = value
        super(Kv, __self__).__init__(
            'alicloud:esa/kv:Kv',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            expiration: Optional[pulumi.Input[_builtins.int]] = None,
            expiration_ttl: Optional[pulumi.Input[_builtins.int]] = None,
            isbase: Optional[pulumi.Input[_builtins.bool]] = None,
            key: Optional[pulumi.Input[_builtins.str]] = None,
            namespace: Optional[pulumi.Input[_builtins.str]] = None,
            url: Optional[pulumi.Input[_builtins.str]] = None,
            value: Optional[pulumi.Input[_builtins.str]] = None) -> 'Kv':
        """
        Get an existing Kv resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] expiration: The content of the key, which can be up to 2 MB (2 × 1000 × 1000). If the content is larger than 2 MB, call [PutKvWithHighCapacity](https://www.alibabacloud.com/help/en/doc-detail/2850486.html).
        :param pulumi.Input[_builtins.int] expiration_ttl: The time when the key-value pair expires, which cannot be earlier than the current time. The value is a timestamp in seconds. If you specify both Expiration and ExpirationTtl, only ExpirationTtl takes effect.
        :param pulumi.Input[_builtins.bool] isbase: The relative expiration time. Unit: seconds. If you specify both Expiration and ExpirationTtl, only ExpirationTtl takes effect.
        :param pulumi.Input[_builtins.str] key: kv
        :param pulumi.Input[_builtins.str] namespace: The name specified when calling [CreatevNamespace](https://help.aliyun.com/document_detail/2850317.html).
        :param pulumi.Input[_builtins.str] url: The key name. The name can be up to 512 characters in length and cannot contain spaces or backslashes (\\\\).
        :param pulumi.Input[_builtins.str] value: The content of the key. If the content has more than 256 characters in length, the system displays the first 100 and the last 100 characters, and omits the middle part.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _KvState.__new__(_KvState)

        __props__.__dict__["expiration"] = expiration
        __props__.__dict__["expiration_ttl"] = expiration_ttl
        __props__.__dict__["isbase"] = isbase
        __props__.__dict__["key"] = key
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["url"] = url
        __props__.__dict__["value"] = value
        return Kv(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def expiration(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The content of the key, which can be up to 2 MB (2 × 1000 × 1000). If the content is larger than 2 MB, call [PutKvWithHighCapacity](https://www.alibabacloud.com/help/en/doc-detail/2850486.html).
        """
        return pulumi.get(self, "expiration")

    @_builtins.property
    @pulumi.getter(name="expirationTtl")
    def expiration_ttl(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The time when the key-value pair expires, which cannot be earlier than the current time. The value is a timestamp in seconds. If you specify both Expiration and ExpirationTtl, only ExpirationTtl takes effect.
        """
        return pulumi.get(self, "expiration_ttl")

    @_builtins.property
    @pulumi.getter
    def isbase(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        The relative expiration time. Unit: seconds. If you specify both Expiration and ExpirationTtl, only ExpirationTtl takes effect.
        """
        return pulumi.get(self, "isbase")

    @_builtins.property
    @pulumi.getter
    def key(self) -> pulumi.Output[_builtins.str]:
        """
        kv
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[_builtins.str]:
        """
        The name specified when calling [CreatevNamespace](https://help.aliyun.com/document_detail/2850317.html).
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def url(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The key name. The name can be up to 512 characters in length and cannot contain spaces or backslashes (\\\\).
        """
        return pulumi.get(self, "url")

    @_builtins.property
    @pulumi.getter
    def value(self) -> pulumi.Output[_builtins.str]:
        """
        The content of the key. If the content has more than 256 characters in length, the system displays the first 100 and the last 100 characters, and omits the middle part.
        """
        return pulumi.get(self, "value")

