# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['OriginRuleArgs', 'OriginRule']

@pulumi.input_type
class OriginRuleArgs:
    def __init__(__self__, *,
                 site_id: pulumi.Input[_builtins.int],
                 dns_record: Optional[pulumi.Input[_builtins.str]] = None,
                 origin_host: Optional[pulumi.Input[_builtins.str]] = None,
                 origin_http_port: Optional[pulumi.Input[_builtins.str]] = None,
                 origin_https_port: Optional[pulumi.Input[_builtins.str]] = None,
                 origin_scheme: Optional[pulumi.Input[_builtins.str]] = None,
                 origin_sni: Optional[pulumi.Input[_builtins.str]] = None,
                 range: Optional[pulumi.Input[_builtins.str]] = None,
                 rule: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_enable: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 site_version: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a OriginRule resource.
        :param pulumi.Input[_builtins.int] site_id: The site ID.
        :param pulumi.Input[_builtins.str] dns_record: Overwrite the DNS resolution record of the origin request.
        :param pulumi.Input[_builtins.str] origin_host: The HOST carried in the back-to-origin request.
        :param pulumi.Input[_builtins.str] origin_http_port: The port of the origin station accessed when the HTTP protocol is used to return to the origin.
        :param pulumi.Input[_builtins.str] origin_https_port: The port of the origin station accessed when the HTTPS protocol is used to return to the origin.
        :param pulumi.Input[_builtins.str] origin_scheme: The protocol used by the back-to-origin request. Value range:
        :param pulumi.Input[_builtins.str] origin_sni: SNI carried in the back-to-origin request.
        :param pulumi.Input[_builtins.str] range: Use the range sharding method to download the file from the source. Value range:
        :param pulumi.Input[_builtins.str] rule: Rule content, using conditional expressions to match user requests. When adding global configuration, this parameter does not need to be set. There are two usage scenarios:
               - Match all incoming requests: value set to true
               - Match specified request: Set the value to a custom expression, for example: (http.host eq \\"video.example.com\\")
        :param pulumi.Input[_builtins.str] rule_enable: Rule switch. When adding global configuration, this parameter does not need to be set. Value range:
               - on: open.
               - off: close.
        :param pulumi.Input[_builtins.str] rule_name: Rule name. When adding global configuration, this parameter does not need to be set.
        :param pulumi.Input[_builtins.int] site_version: The version number of the site configuration. For sites that have enabled configuration version management, this parameter can be used to specify the effective version of the configuration site, which defaults to version 0.
        """
        pulumi.set(__self__, "site_id", site_id)
        if dns_record is not None:
            pulumi.set(__self__, "dns_record", dns_record)
        if origin_host is not None:
            pulumi.set(__self__, "origin_host", origin_host)
        if origin_http_port is not None:
            pulumi.set(__self__, "origin_http_port", origin_http_port)
        if origin_https_port is not None:
            pulumi.set(__self__, "origin_https_port", origin_https_port)
        if origin_scheme is not None:
            pulumi.set(__self__, "origin_scheme", origin_scheme)
        if origin_sni is not None:
            pulumi.set(__self__, "origin_sni", origin_sni)
        if range is not None:
            pulumi.set(__self__, "range", range)
        if rule is not None:
            pulumi.set(__self__, "rule", rule)
        if rule_enable is not None:
            pulumi.set(__self__, "rule_enable", rule_enable)
        if rule_name is not None:
            pulumi.set(__self__, "rule_name", rule_name)
        if site_version is not None:
            pulumi.set(__self__, "site_version", site_version)

    @_builtins.property
    @pulumi.getter(name="siteId")
    def site_id(self) -> pulumi.Input[_builtins.int]:
        """
        The site ID.
        """
        return pulumi.get(self, "site_id")

    @site_id.setter
    def site_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "site_id", value)

    @_builtins.property
    @pulumi.getter(name="dnsRecord")
    def dns_record(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Overwrite the DNS resolution record of the origin request.
        """
        return pulumi.get(self, "dns_record")

    @dns_record.setter
    def dns_record(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dns_record", value)

    @_builtins.property
    @pulumi.getter(name="originHost")
    def origin_host(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The HOST carried in the back-to-origin request.
        """
        return pulumi.get(self, "origin_host")

    @origin_host.setter
    def origin_host(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "origin_host", value)

    @_builtins.property
    @pulumi.getter(name="originHttpPort")
    def origin_http_port(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The port of the origin station accessed when the HTTP protocol is used to return to the origin.
        """
        return pulumi.get(self, "origin_http_port")

    @origin_http_port.setter
    def origin_http_port(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "origin_http_port", value)

    @_builtins.property
    @pulumi.getter(name="originHttpsPort")
    def origin_https_port(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The port of the origin station accessed when the HTTPS protocol is used to return to the origin.
        """
        return pulumi.get(self, "origin_https_port")

    @origin_https_port.setter
    def origin_https_port(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "origin_https_port", value)

    @_builtins.property
    @pulumi.getter(name="originScheme")
    def origin_scheme(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The protocol used by the back-to-origin request. Value range:
        """
        return pulumi.get(self, "origin_scheme")

    @origin_scheme.setter
    def origin_scheme(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "origin_scheme", value)

    @_builtins.property
    @pulumi.getter(name="originSni")
    def origin_sni(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        SNI carried in the back-to-origin request.
        """
        return pulumi.get(self, "origin_sni")

    @origin_sni.setter
    def origin_sni(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "origin_sni", value)

    @_builtins.property
    @pulumi.getter
    def range(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Use the range sharding method to download the file from the source. Value range:
        """
        return pulumi.get(self, "range")

    @range.setter
    def range(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "range", value)

    @_builtins.property
    @pulumi.getter
    def rule(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Rule content, using conditional expressions to match user requests. When adding global configuration, this parameter does not need to be set. There are two usage scenarios:
        - Match all incoming requests: value set to true
        - Match specified request: Set the value to a custom expression, for example: (http.host eq \\"video.example.com\\")
        """
        return pulumi.get(self, "rule")

    @rule.setter
    def rule(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule", value)

    @_builtins.property
    @pulumi.getter(name="ruleEnable")
    def rule_enable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Rule switch. When adding global configuration, this parameter does not need to be set. Value range:
        - on: open.
        - off: close.
        """
        return pulumi.get(self, "rule_enable")

    @rule_enable.setter
    def rule_enable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule_enable", value)

    @_builtins.property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Rule name. When adding global configuration, this parameter does not need to be set.
        """
        return pulumi.get(self, "rule_name")

    @rule_name.setter
    def rule_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule_name", value)

    @_builtins.property
    @pulumi.getter(name="siteVersion")
    def site_version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The version number of the site configuration. For sites that have enabled configuration version management, this parameter can be used to specify the effective version of the configuration site, which defaults to version 0.
        """
        return pulumi.get(self, "site_version")

    @site_version.setter
    def site_version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "site_version", value)


@pulumi.input_type
class _OriginRuleState:
    def __init__(__self__, *,
                 config_id: Optional[pulumi.Input[_builtins.int]] = None,
                 dns_record: Optional[pulumi.Input[_builtins.str]] = None,
                 origin_host: Optional[pulumi.Input[_builtins.str]] = None,
                 origin_http_port: Optional[pulumi.Input[_builtins.str]] = None,
                 origin_https_port: Optional[pulumi.Input[_builtins.str]] = None,
                 origin_scheme: Optional[pulumi.Input[_builtins.str]] = None,
                 origin_sni: Optional[pulumi.Input[_builtins.str]] = None,
                 range: Optional[pulumi.Input[_builtins.str]] = None,
                 rule: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_enable: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 site_id: Optional[pulumi.Input[_builtins.int]] = None,
                 site_version: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering OriginRule resources.
        :param pulumi.Input[_builtins.int] config_id: Back-to-source rule configuration ID
        :param pulumi.Input[_builtins.str] dns_record: Overwrite the DNS resolution record of the origin request.
        :param pulumi.Input[_builtins.str] origin_host: The HOST carried in the back-to-origin request.
        :param pulumi.Input[_builtins.str] origin_http_port: The port of the origin station accessed when the HTTP protocol is used to return to the origin.
        :param pulumi.Input[_builtins.str] origin_https_port: The port of the origin station accessed when the HTTPS protocol is used to return to the origin.
        :param pulumi.Input[_builtins.str] origin_scheme: The protocol used by the back-to-origin request. Value range:
        :param pulumi.Input[_builtins.str] origin_sni: SNI carried in the back-to-origin request.
        :param pulumi.Input[_builtins.str] range: Use the range sharding method to download the file from the source. Value range:
        :param pulumi.Input[_builtins.str] rule: Rule content, using conditional expressions to match user requests. When adding global configuration, this parameter does not need to be set. There are two usage scenarios:
               - Match all incoming requests: value set to true
               - Match specified request: Set the value to a custom expression, for example: (http.host eq \\"video.example.com\\")
        :param pulumi.Input[_builtins.str] rule_enable: Rule switch. When adding global configuration, this parameter does not need to be set. Value range:
               - on: open.
               - off: close.
        :param pulumi.Input[_builtins.str] rule_name: Rule name. When adding global configuration, this parameter does not need to be set.
        :param pulumi.Input[_builtins.int] site_id: The site ID.
        :param pulumi.Input[_builtins.int] site_version: The version number of the site configuration. For sites that have enabled configuration version management, this parameter can be used to specify the effective version of the configuration site, which defaults to version 0.
        """
        if config_id is not None:
            pulumi.set(__self__, "config_id", config_id)
        if dns_record is not None:
            pulumi.set(__self__, "dns_record", dns_record)
        if origin_host is not None:
            pulumi.set(__self__, "origin_host", origin_host)
        if origin_http_port is not None:
            pulumi.set(__self__, "origin_http_port", origin_http_port)
        if origin_https_port is not None:
            pulumi.set(__self__, "origin_https_port", origin_https_port)
        if origin_scheme is not None:
            pulumi.set(__self__, "origin_scheme", origin_scheme)
        if origin_sni is not None:
            pulumi.set(__self__, "origin_sni", origin_sni)
        if range is not None:
            pulumi.set(__self__, "range", range)
        if rule is not None:
            pulumi.set(__self__, "rule", rule)
        if rule_enable is not None:
            pulumi.set(__self__, "rule_enable", rule_enable)
        if rule_name is not None:
            pulumi.set(__self__, "rule_name", rule_name)
        if site_id is not None:
            pulumi.set(__self__, "site_id", site_id)
        if site_version is not None:
            pulumi.set(__self__, "site_version", site_version)

    @_builtins.property
    @pulumi.getter(name="configId")
    def config_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Back-to-source rule configuration ID
        """
        return pulumi.get(self, "config_id")

    @config_id.setter
    def config_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "config_id", value)

    @_builtins.property
    @pulumi.getter(name="dnsRecord")
    def dns_record(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Overwrite the DNS resolution record of the origin request.
        """
        return pulumi.get(self, "dns_record")

    @dns_record.setter
    def dns_record(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dns_record", value)

    @_builtins.property
    @pulumi.getter(name="originHost")
    def origin_host(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The HOST carried in the back-to-origin request.
        """
        return pulumi.get(self, "origin_host")

    @origin_host.setter
    def origin_host(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "origin_host", value)

    @_builtins.property
    @pulumi.getter(name="originHttpPort")
    def origin_http_port(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The port of the origin station accessed when the HTTP protocol is used to return to the origin.
        """
        return pulumi.get(self, "origin_http_port")

    @origin_http_port.setter
    def origin_http_port(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "origin_http_port", value)

    @_builtins.property
    @pulumi.getter(name="originHttpsPort")
    def origin_https_port(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The port of the origin station accessed when the HTTPS protocol is used to return to the origin.
        """
        return pulumi.get(self, "origin_https_port")

    @origin_https_port.setter
    def origin_https_port(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "origin_https_port", value)

    @_builtins.property
    @pulumi.getter(name="originScheme")
    def origin_scheme(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The protocol used by the back-to-origin request. Value range:
        """
        return pulumi.get(self, "origin_scheme")

    @origin_scheme.setter
    def origin_scheme(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "origin_scheme", value)

    @_builtins.property
    @pulumi.getter(name="originSni")
    def origin_sni(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        SNI carried in the back-to-origin request.
        """
        return pulumi.get(self, "origin_sni")

    @origin_sni.setter
    def origin_sni(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "origin_sni", value)

    @_builtins.property
    @pulumi.getter
    def range(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Use the range sharding method to download the file from the source. Value range:
        """
        return pulumi.get(self, "range")

    @range.setter
    def range(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "range", value)

    @_builtins.property
    @pulumi.getter
    def rule(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Rule content, using conditional expressions to match user requests. When adding global configuration, this parameter does not need to be set. There are two usage scenarios:
        - Match all incoming requests: value set to true
        - Match specified request: Set the value to a custom expression, for example: (http.host eq \\"video.example.com\\")
        """
        return pulumi.get(self, "rule")

    @rule.setter
    def rule(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule", value)

    @_builtins.property
    @pulumi.getter(name="ruleEnable")
    def rule_enable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Rule switch. When adding global configuration, this parameter does not need to be set. Value range:
        - on: open.
        - off: close.
        """
        return pulumi.get(self, "rule_enable")

    @rule_enable.setter
    def rule_enable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule_enable", value)

    @_builtins.property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Rule name. When adding global configuration, this parameter does not need to be set.
        """
        return pulumi.get(self, "rule_name")

    @rule_name.setter
    def rule_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule_name", value)

    @_builtins.property
    @pulumi.getter(name="siteId")
    def site_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The site ID.
        """
        return pulumi.get(self, "site_id")

    @site_id.setter
    def site_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "site_id", value)

    @_builtins.property
    @pulumi.getter(name="siteVersion")
    def site_version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The version number of the site configuration. For sites that have enabled configuration version management, this parameter can be used to specify the effective version of the configuration site, which defaults to version 0.
        """
        return pulumi.get(self, "site_version")

    @site_version.setter
    def site_version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "site_version", value)


@pulumi.type_token("alicloud:esa/originRule:OriginRule")
class OriginRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dns_record: Optional[pulumi.Input[_builtins.str]] = None,
                 origin_host: Optional[pulumi.Input[_builtins.str]] = None,
                 origin_http_port: Optional[pulumi.Input[_builtins.str]] = None,
                 origin_https_port: Optional[pulumi.Input[_builtins.str]] = None,
                 origin_scheme: Optional[pulumi.Input[_builtins.str]] = None,
                 origin_sni: Optional[pulumi.Input[_builtins.str]] = None,
                 range: Optional[pulumi.Input[_builtins.str]] = None,
                 rule: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_enable: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 site_id: Optional[pulumi.Input[_builtins.int]] = None,
                 site_version: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Provides a ESA Origin Rule resource.

        For information about ESA Origin Rule and how to use it, see [What is Origin Rule](https://next.api.alibabacloud.com/document/ESA/2024-09-10/CreateOriginRule).

        > **NOTE:** Available since v1.244.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.esa.get_sites(plan_subscribe_type="enterpriseplan")
        default_origin_rule = alicloud.esa.OriginRule("default",
            origin_sni="origin.example.com",
            site_id=default.sites[0].id,
            origin_host="origin.example.com",
            dns_record="tf.example.com",
            site_version=0,
            rule_name="tf",
            origin_https_port="443",
            origin_scheme="http",
            range="on",
            origin_http_port="8080",
            rule="(http.host eq \\"video.example.com\\")",
            rule_enable="on")
        ```

        ## Import

        ESA Origin Rule can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:esa/originRule:OriginRule example <site_id>:<config_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] dns_record: Overwrite the DNS resolution record of the origin request.
        :param pulumi.Input[_builtins.str] origin_host: The HOST carried in the back-to-origin request.
        :param pulumi.Input[_builtins.str] origin_http_port: The port of the origin station accessed when the HTTP protocol is used to return to the origin.
        :param pulumi.Input[_builtins.str] origin_https_port: The port of the origin station accessed when the HTTPS protocol is used to return to the origin.
        :param pulumi.Input[_builtins.str] origin_scheme: The protocol used by the back-to-origin request. Value range:
        :param pulumi.Input[_builtins.str] origin_sni: SNI carried in the back-to-origin request.
        :param pulumi.Input[_builtins.str] range: Use the range sharding method to download the file from the source. Value range:
        :param pulumi.Input[_builtins.str] rule: Rule content, using conditional expressions to match user requests. When adding global configuration, this parameter does not need to be set. There are two usage scenarios:
               - Match all incoming requests: value set to true
               - Match specified request: Set the value to a custom expression, for example: (http.host eq \\"video.example.com\\")
        :param pulumi.Input[_builtins.str] rule_enable: Rule switch. When adding global configuration, this parameter does not need to be set. Value range:
               - on: open.
               - off: close.
        :param pulumi.Input[_builtins.str] rule_name: Rule name. When adding global configuration, this parameter does not need to be set.
        :param pulumi.Input[_builtins.int] site_id: The site ID.
        :param pulumi.Input[_builtins.int] site_version: The version number of the site configuration. For sites that have enabled configuration version management, this parameter can be used to specify the effective version of the configuration site, which defaults to version 0.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OriginRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a ESA Origin Rule resource.

        For information about ESA Origin Rule and how to use it, see [What is Origin Rule](https://next.api.alibabacloud.com/document/ESA/2024-09-10/CreateOriginRule).

        > **NOTE:** Available since v1.244.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.esa.get_sites(plan_subscribe_type="enterpriseplan")
        default_origin_rule = alicloud.esa.OriginRule("default",
            origin_sni="origin.example.com",
            site_id=default.sites[0].id,
            origin_host="origin.example.com",
            dns_record="tf.example.com",
            site_version=0,
            rule_name="tf",
            origin_https_port="443",
            origin_scheme="http",
            range="on",
            origin_http_port="8080",
            rule="(http.host eq \\"video.example.com\\")",
            rule_enable="on")
        ```

        ## Import

        ESA Origin Rule can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:esa/originRule:OriginRule example <site_id>:<config_id>
        ```

        :param str resource_name: The name of the resource.
        :param OriginRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OriginRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dns_record: Optional[pulumi.Input[_builtins.str]] = None,
                 origin_host: Optional[pulumi.Input[_builtins.str]] = None,
                 origin_http_port: Optional[pulumi.Input[_builtins.str]] = None,
                 origin_https_port: Optional[pulumi.Input[_builtins.str]] = None,
                 origin_scheme: Optional[pulumi.Input[_builtins.str]] = None,
                 origin_sni: Optional[pulumi.Input[_builtins.str]] = None,
                 range: Optional[pulumi.Input[_builtins.str]] = None,
                 rule: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_enable: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 site_id: Optional[pulumi.Input[_builtins.int]] = None,
                 site_version: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OriginRuleArgs.__new__(OriginRuleArgs)

            __props__.__dict__["dns_record"] = dns_record
            __props__.__dict__["origin_host"] = origin_host
            __props__.__dict__["origin_http_port"] = origin_http_port
            __props__.__dict__["origin_https_port"] = origin_https_port
            __props__.__dict__["origin_scheme"] = origin_scheme
            __props__.__dict__["origin_sni"] = origin_sni
            __props__.__dict__["range"] = range
            __props__.__dict__["rule"] = rule
            __props__.__dict__["rule_enable"] = rule_enable
            __props__.__dict__["rule_name"] = rule_name
            if site_id is None and not opts.urn:
                raise TypeError("Missing required property 'site_id'")
            __props__.__dict__["site_id"] = site_id
            __props__.__dict__["site_version"] = site_version
            __props__.__dict__["config_id"] = None
        super(OriginRule, __self__).__init__(
            'alicloud:esa/originRule:OriginRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            config_id: Optional[pulumi.Input[_builtins.int]] = None,
            dns_record: Optional[pulumi.Input[_builtins.str]] = None,
            origin_host: Optional[pulumi.Input[_builtins.str]] = None,
            origin_http_port: Optional[pulumi.Input[_builtins.str]] = None,
            origin_https_port: Optional[pulumi.Input[_builtins.str]] = None,
            origin_scheme: Optional[pulumi.Input[_builtins.str]] = None,
            origin_sni: Optional[pulumi.Input[_builtins.str]] = None,
            range: Optional[pulumi.Input[_builtins.str]] = None,
            rule: Optional[pulumi.Input[_builtins.str]] = None,
            rule_enable: Optional[pulumi.Input[_builtins.str]] = None,
            rule_name: Optional[pulumi.Input[_builtins.str]] = None,
            site_id: Optional[pulumi.Input[_builtins.int]] = None,
            site_version: Optional[pulumi.Input[_builtins.int]] = None) -> 'OriginRule':
        """
        Get an existing OriginRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] config_id: Back-to-source rule configuration ID
        :param pulumi.Input[_builtins.str] dns_record: Overwrite the DNS resolution record of the origin request.
        :param pulumi.Input[_builtins.str] origin_host: The HOST carried in the back-to-origin request.
        :param pulumi.Input[_builtins.str] origin_http_port: The port of the origin station accessed when the HTTP protocol is used to return to the origin.
        :param pulumi.Input[_builtins.str] origin_https_port: The port of the origin station accessed when the HTTPS protocol is used to return to the origin.
        :param pulumi.Input[_builtins.str] origin_scheme: The protocol used by the back-to-origin request. Value range:
        :param pulumi.Input[_builtins.str] origin_sni: SNI carried in the back-to-origin request.
        :param pulumi.Input[_builtins.str] range: Use the range sharding method to download the file from the source. Value range:
        :param pulumi.Input[_builtins.str] rule: Rule content, using conditional expressions to match user requests. When adding global configuration, this parameter does not need to be set. There are two usage scenarios:
               - Match all incoming requests: value set to true
               - Match specified request: Set the value to a custom expression, for example: (http.host eq \\"video.example.com\\")
        :param pulumi.Input[_builtins.str] rule_enable: Rule switch. When adding global configuration, this parameter does not need to be set. Value range:
               - on: open.
               - off: close.
        :param pulumi.Input[_builtins.str] rule_name: Rule name. When adding global configuration, this parameter does not need to be set.
        :param pulumi.Input[_builtins.int] site_id: The site ID.
        :param pulumi.Input[_builtins.int] site_version: The version number of the site configuration. For sites that have enabled configuration version management, this parameter can be used to specify the effective version of the configuration site, which defaults to version 0.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OriginRuleState.__new__(_OriginRuleState)

        __props__.__dict__["config_id"] = config_id
        __props__.__dict__["dns_record"] = dns_record
        __props__.__dict__["origin_host"] = origin_host
        __props__.__dict__["origin_http_port"] = origin_http_port
        __props__.__dict__["origin_https_port"] = origin_https_port
        __props__.__dict__["origin_scheme"] = origin_scheme
        __props__.__dict__["origin_sni"] = origin_sni
        __props__.__dict__["range"] = range
        __props__.__dict__["rule"] = rule
        __props__.__dict__["rule_enable"] = rule_enable
        __props__.__dict__["rule_name"] = rule_name
        __props__.__dict__["site_id"] = site_id
        __props__.__dict__["site_version"] = site_version
        return OriginRule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="configId")
    def config_id(self) -> pulumi.Output[_builtins.int]:
        """
        Back-to-source rule configuration ID
        """
        return pulumi.get(self, "config_id")

    @_builtins.property
    @pulumi.getter(name="dnsRecord")
    def dns_record(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Overwrite the DNS resolution record of the origin request.
        """
        return pulumi.get(self, "dns_record")

    @_builtins.property
    @pulumi.getter(name="originHost")
    def origin_host(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The HOST carried in the back-to-origin request.
        """
        return pulumi.get(self, "origin_host")

    @_builtins.property
    @pulumi.getter(name="originHttpPort")
    def origin_http_port(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The port of the origin station accessed when the HTTP protocol is used to return to the origin.
        """
        return pulumi.get(self, "origin_http_port")

    @_builtins.property
    @pulumi.getter(name="originHttpsPort")
    def origin_https_port(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The port of the origin station accessed when the HTTPS protocol is used to return to the origin.
        """
        return pulumi.get(self, "origin_https_port")

    @_builtins.property
    @pulumi.getter(name="originScheme")
    def origin_scheme(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The protocol used by the back-to-origin request. Value range:
        """
        return pulumi.get(self, "origin_scheme")

    @_builtins.property
    @pulumi.getter(name="originSni")
    def origin_sni(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        SNI carried in the back-to-origin request.
        """
        return pulumi.get(self, "origin_sni")

    @_builtins.property
    @pulumi.getter
    def range(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Use the range sharding method to download the file from the source. Value range:
        """
        return pulumi.get(self, "range")

    @_builtins.property
    @pulumi.getter
    def rule(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Rule content, using conditional expressions to match user requests. When adding global configuration, this parameter does not need to be set. There are two usage scenarios:
        - Match all incoming requests: value set to true
        - Match specified request: Set the value to a custom expression, for example: (http.host eq \\"video.example.com\\")
        """
        return pulumi.get(self, "rule")

    @_builtins.property
    @pulumi.getter(name="ruleEnable")
    def rule_enable(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Rule switch. When adding global configuration, this parameter does not need to be set. Value range:
        - on: open.
        - off: close.
        """
        return pulumi.get(self, "rule_enable")

    @_builtins.property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Rule name. When adding global configuration, this parameter does not need to be set.
        """
        return pulumi.get(self, "rule_name")

    @_builtins.property
    @pulumi.getter(name="siteId")
    def site_id(self) -> pulumi.Output[_builtins.int]:
        """
        The site ID.
        """
        return pulumi.get(self, "site_id")

    @_builtins.property
    @pulumi.getter(name="siteVersion")
    def site_version(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The version number of the site configuration. For sites that have enabled configuration version management, this parameter can be used to specify the effective version of the configuration site, which defaults to version 0.
        """
        return pulumi.get(self, "site_version")

