# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['RoutineRouteArgs', 'RoutineRoute']

@pulumi.input_type
class RoutineRouteArgs:
    def __init__(__self__, *,
                 routine_name: pulumi.Input[_builtins.str],
                 site_id: pulumi.Input[_builtins.int],
                 bypass: Optional[pulumi.Input[_builtins.str]] = None,
                 route_enable: Optional[pulumi.Input[_builtins.str]] = None,
                 route_name: Optional[pulumi.Input[_builtins.str]] = None,
                 rule: Optional[pulumi.Input[_builtins.str]] = None,
                 sequence: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a RoutineRoute resource.
        :param pulumi.Input[_builtins.str] routine_name: The edge function Routine name.
        :param pulumi.Input[_builtins.int] site_id: Site Id
        :param pulumi.Input[_builtins.str] bypass: Bypass mode. Value range:
               - on: Open
               - off: off
        :param pulumi.Input[_builtins.str] route_enable: Routing switch. Value range:
               - on: Open
               - off: off
        :param pulumi.Input[_builtins.str] route_name: The route name.
        :param pulumi.Input[_builtins.str] rule: The rule content.
        :param pulumi.Input[_builtins.int] sequence: Rule execution order.
        """
        pulumi.set(__self__, "routine_name", routine_name)
        pulumi.set(__self__, "site_id", site_id)
        if bypass is not None:
            pulumi.set(__self__, "bypass", bypass)
        if route_enable is not None:
            pulumi.set(__self__, "route_enable", route_enable)
        if route_name is not None:
            pulumi.set(__self__, "route_name", route_name)
        if rule is not None:
            pulumi.set(__self__, "rule", rule)
        if sequence is not None:
            pulumi.set(__self__, "sequence", sequence)

    @_builtins.property
    @pulumi.getter(name="routineName")
    def routine_name(self) -> pulumi.Input[_builtins.str]:
        """
        The edge function Routine name.
        """
        return pulumi.get(self, "routine_name")

    @routine_name.setter
    def routine_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "routine_name", value)

    @_builtins.property
    @pulumi.getter(name="siteId")
    def site_id(self) -> pulumi.Input[_builtins.int]:
        """
        Site Id
        """
        return pulumi.get(self, "site_id")

    @site_id.setter
    def site_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "site_id", value)

    @_builtins.property
    @pulumi.getter
    def bypass(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Bypass mode. Value range:
        - on: Open
        - off: off
        """
        return pulumi.get(self, "bypass")

    @bypass.setter
    def bypass(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bypass", value)

    @_builtins.property
    @pulumi.getter(name="routeEnable")
    def route_enable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Routing switch. Value range:
        - on: Open
        - off: off
        """
        return pulumi.get(self, "route_enable")

    @route_enable.setter
    def route_enable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "route_enable", value)

    @_builtins.property
    @pulumi.getter(name="routeName")
    def route_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The route name.
        """
        return pulumi.get(self, "route_name")

    @route_name.setter
    def route_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "route_name", value)

    @_builtins.property
    @pulumi.getter
    def rule(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The rule content.
        """
        return pulumi.get(self, "rule")

    @rule.setter
    def rule(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule", value)

    @_builtins.property
    @pulumi.getter
    def sequence(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Rule execution order.
        """
        return pulumi.get(self, "sequence")

    @sequence.setter
    def sequence(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "sequence", value)


@pulumi.input_type
class _RoutineRouteState:
    def __init__(__self__, *,
                 bypass: Optional[pulumi.Input[_builtins.str]] = None,
                 config_id: Optional[pulumi.Input[_builtins.int]] = None,
                 route_enable: Optional[pulumi.Input[_builtins.str]] = None,
                 route_name: Optional[pulumi.Input[_builtins.str]] = None,
                 routine_name: Optional[pulumi.Input[_builtins.str]] = None,
                 rule: Optional[pulumi.Input[_builtins.str]] = None,
                 sequence: Optional[pulumi.Input[_builtins.int]] = None,
                 site_id: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering RoutineRoute resources.
        :param pulumi.Input[_builtins.str] bypass: Bypass mode. Value range:
               - on: Open
               - off: off
        :param pulumi.Input[_builtins.int] config_id: Config Id
        :param pulumi.Input[_builtins.str] route_enable: Routing switch. Value range:
               - on: Open
               - off: off
        :param pulumi.Input[_builtins.str] route_name: The route name.
        :param pulumi.Input[_builtins.str] routine_name: The edge function Routine name.
        :param pulumi.Input[_builtins.str] rule: The rule content.
        :param pulumi.Input[_builtins.int] sequence: Rule execution order.
        :param pulumi.Input[_builtins.int] site_id: Site Id
        """
        if bypass is not None:
            pulumi.set(__self__, "bypass", bypass)
        if config_id is not None:
            pulumi.set(__self__, "config_id", config_id)
        if route_enable is not None:
            pulumi.set(__self__, "route_enable", route_enable)
        if route_name is not None:
            pulumi.set(__self__, "route_name", route_name)
        if routine_name is not None:
            pulumi.set(__self__, "routine_name", routine_name)
        if rule is not None:
            pulumi.set(__self__, "rule", rule)
        if sequence is not None:
            pulumi.set(__self__, "sequence", sequence)
        if site_id is not None:
            pulumi.set(__self__, "site_id", site_id)

    @_builtins.property
    @pulumi.getter
    def bypass(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Bypass mode. Value range:
        - on: Open
        - off: off
        """
        return pulumi.get(self, "bypass")

    @bypass.setter
    def bypass(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bypass", value)

    @_builtins.property
    @pulumi.getter(name="configId")
    def config_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Config Id
        """
        return pulumi.get(self, "config_id")

    @config_id.setter
    def config_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "config_id", value)

    @_builtins.property
    @pulumi.getter(name="routeEnable")
    def route_enable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Routing switch. Value range:
        - on: Open
        - off: off
        """
        return pulumi.get(self, "route_enable")

    @route_enable.setter
    def route_enable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "route_enable", value)

    @_builtins.property
    @pulumi.getter(name="routeName")
    def route_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The route name.
        """
        return pulumi.get(self, "route_name")

    @route_name.setter
    def route_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "route_name", value)

    @_builtins.property
    @pulumi.getter(name="routineName")
    def routine_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The edge function Routine name.
        """
        return pulumi.get(self, "routine_name")

    @routine_name.setter
    def routine_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "routine_name", value)

    @_builtins.property
    @pulumi.getter
    def rule(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The rule content.
        """
        return pulumi.get(self, "rule")

    @rule.setter
    def rule(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule", value)

    @_builtins.property
    @pulumi.getter
    def sequence(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Rule execution order.
        """
        return pulumi.get(self, "sequence")

    @sequence.setter
    def sequence(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "sequence", value)

    @_builtins.property
    @pulumi.getter(name="siteId")
    def site_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Site Id
        """
        return pulumi.get(self, "site_id")

    @site_id.setter
    def site_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "site_id", value)


@pulumi.type_token("alicloud:esa/routineRoute:RoutineRoute")
class RoutineRoute(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bypass: Optional[pulumi.Input[_builtins.str]] = None,
                 route_enable: Optional[pulumi.Input[_builtins.str]] = None,
                 route_name: Optional[pulumi.Input[_builtins.str]] = None,
                 routine_name: Optional[pulumi.Input[_builtins.str]] = None,
                 rule: Optional[pulumi.Input[_builtins.str]] = None,
                 sequence: Optional[pulumi.Input[_builtins.int]] = None,
                 site_id: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Provides a ESA Routine Route resource.

        For information about ESA Routine Route and how to use it, see [What is Routine Route](https://next.api.alibabacloud.com/document/ESA/2024-09-10/CreateRoutineRoute).

        > **NOTE:** Available since v1.251.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.esa.get_sites(plan_subscribe_type="enterpriseplan")
        default_site = alicloud.esa.Site("default",
            site_name="chenxin0116.site",
            instance_id=default.sites[0].instance_id,
            coverage="overseas",
            access_type="NS")
        default_routine = alicloud.esa.Routine("default",
            description="example-routine2",
            name="example-routine2")
        default_routine_route = alicloud.esa.RoutineRoute("default",
            route_enable="on",
            rule="(http.host eq \\"video.example1.com\\")",
            sequence=1,
            routine_name=default_routine.name,
            site_id=default_site.id,
            bypass="off",
            route_name="example_routine")
        ```

        ## Import

        ESA Routine Route can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:esa/routineRoute:RoutineRoute example <site_id>:<routine_name>:<config_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] bypass: Bypass mode. Value range:
               - on: Open
               - off: off
        :param pulumi.Input[_builtins.str] route_enable: Routing switch. Value range:
               - on: Open
               - off: off
        :param pulumi.Input[_builtins.str] route_name: The route name.
        :param pulumi.Input[_builtins.str] routine_name: The edge function Routine name.
        :param pulumi.Input[_builtins.str] rule: The rule content.
        :param pulumi.Input[_builtins.int] sequence: Rule execution order.
        :param pulumi.Input[_builtins.int] site_id: Site Id
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RoutineRouteArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a ESA Routine Route resource.

        For information about ESA Routine Route and how to use it, see [What is Routine Route](https://next.api.alibabacloud.com/document/ESA/2024-09-10/CreateRoutineRoute).

        > **NOTE:** Available since v1.251.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.esa.get_sites(plan_subscribe_type="enterpriseplan")
        default_site = alicloud.esa.Site("default",
            site_name="chenxin0116.site",
            instance_id=default.sites[0].instance_id,
            coverage="overseas",
            access_type="NS")
        default_routine = alicloud.esa.Routine("default",
            description="example-routine2",
            name="example-routine2")
        default_routine_route = alicloud.esa.RoutineRoute("default",
            route_enable="on",
            rule="(http.host eq \\"video.example1.com\\")",
            sequence=1,
            routine_name=default_routine.name,
            site_id=default_site.id,
            bypass="off",
            route_name="example_routine")
        ```

        ## Import

        ESA Routine Route can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:esa/routineRoute:RoutineRoute example <site_id>:<routine_name>:<config_id>
        ```

        :param str resource_name: The name of the resource.
        :param RoutineRouteArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RoutineRouteArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bypass: Optional[pulumi.Input[_builtins.str]] = None,
                 route_enable: Optional[pulumi.Input[_builtins.str]] = None,
                 route_name: Optional[pulumi.Input[_builtins.str]] = None,
                 routine_name: Optional[pulumi.Input[_builtins.str]] = None,
                 rule: Optional[pulumi.Input[_builtins.str]] = None,
                 sequence: Optional[pulumi.Input[_builtins.int]] = None,
                 site_id: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RoutineRouteArgs.__new__(RoutineRouteArgs)

            __props__.__dict__["bypass"] = bypass
            __props__.__dict__["route_enable"] = route_enable
            __props__.__dict__["route_name"] = route_name
            if routine_name is None and not opts.urn:
                raise TypeError("Missing required property 'routine_name'")
            __props__.__dict__["routine_name"] = routine_name
            __props__.__dict__["rule"] = rule
            __props__.__dict__["sequence"] = sequence
            if site_id is None and not opts.urn:
                raise TypeError("Missing required property 'site_id'")
            __props__.__dict__["site_id"] = site_id
            __props__.__dict__["config_id"] = None
        super(RoutineRoute, __self__).__init__(
            'alicloud:esa/routineRoute:RoutineRoute',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bypass: Optional[pulumi.Input[_builtins.str]] = None,
            config_id: Optional[pulumi.Input[_builtins.int]] = None,
            route_enable: Optional[pulumi.Input[_builtins.str]] = None,
            route_name: Optional[pulumi.Input[_builtins.str]] = None,
            routine_name: Optional[pulumi.Input[_builtins.str]] = None,
            rule: Optional[pulumi.Input[_builtins.str]] = None,
            sequence: Optional[pulumi.Input[_builtins.int]] = None,
            site_id: Optional[pulumi.Input[_builtins.int]] = None) -> 'RoutineRoute':
        """
        Get an existing RoutineRoute resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] bypass: Bypass mode. Value range:
               - on: Open
               - off: off
        :param pulumi.Input[_builtins.int] config_id: Config Id
        :param pulumi.Input[_builtins.str] route_enable: Routing switch. Value range:
               - on: Open
               - off: off
        :param pulumi.Input[_builtins.str] route_name: The route name.
        :param pulumi.Input[_builtins.str] routine_name: The edge function Routine name.
        :param pulumi.Input[_builtins.str] rule: The rule content.
        :param pulumi.Input[_builtins.int] sequence: Rule execution order.
        :param pulumi.Input[_builtins.int] site_id: Site Id
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RoutineRouteState.__new__(_RoutineRouteState)

        __props__.__dict__["bypass"] = bypass
        __props__.__dict__["config_id"] = config_id
        __props__.__dict__["route_enable"] = route_enable
        __props__.__dict__["route_name"] = route_name
        __props__.__dict__["routine_name"] = routine_name
        __props__.__dict__["rule"] = rule
        __props__.__dict__["sequence"] = sequence
        __props__.__dict__["site_id"] = site_id
        return RoutineRoute(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def bypass(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Bypass mode. Value range:
        - on: Open
        - off: off
        """
        return pulumi.get(self, "bypass")

    @_builtins.property
    @pulumi.getter(name="configId")
    def config_id(self) -> pulumi.Output[_builtins.int]:
        """
        Config Id
        """
        return pulumi.get(self, "config_id")

    @_builtins.property
    @pulumi.getter(name="routeEnable")
    def route_enable(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Routing switch. Value range:
        - on: Open
        - off: off
        """
        return pulumi.get(self, "route_enable")

    @_builtins.property
    @pulumi.getter(name="routeName")
    def route_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The route name.
        """
        return pulumi.get(self, "route_name")

    @_builtins.property
    @pulumi.getter(name="routineName")
    def routine_name(self) -> pulumi.Output[_builtins.str]:
        """
        The edge function Routine name.
        """
        return pulumi.get(self, "routine_name")

    @_builtins.property
    @pulumi.getter
    def rule(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The rule content.
        """
        return pulumi.get(self, "rule")

    @_builtins.property
    @pulumi.getter
    def sequence(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Rule execution order.
        """
        return pulumi.get(self, "sequence")

    @_builtins.property
    @pulumi.getter(name="siteId")
    def site_id(self) -> pulumi.Output[_builtins.int]:
        """
        Site Id
        """
        return pulumi.get(self, "site_id")

