# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ScheduledPreloadExecutionArgs', 'ScheduledPreloadExecution']

@pulumi.input_type
class ScheduledPreloadExecutionArgs:
    def __init__(__self__, *,
                 interval: pulumi.Input[_builtins.int],
                 scheduled_preload_job_id: pulumi.Input[_builtins.str],
                 slice_len: pulumi.Input[_builtins.int],
                 end_time: Optional[pulumi.Input[_builtins.str]] = None,
                 start_time: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ScheduledPreloadExecution resource.
        :param pulumi.Input[_builtins.int] interval: The time interval between each batch execution. Unit: seconds.
        :param pulumi.Input[_builtins.str] scheduled_preload_job_id: The ID of the prefetch task.
        :param pulumi.Input[_builtins.int] slice_len: The number of URLs prefetched in each batch.
        :param pulumi.Input[_builtins.str] end_time: The end time of the prefetch plan.
        :param pulumi.Input[_builtins.str] start_time: The start time of the prefetch plan.
        """
        pulumi.set(__self__, "interval", interval)
        pulumi.set(__self__, "scheduled_preload_job_id", scheduled_preload_job_id)
        pulumi.set(__self__, "slice_len", slice_len)
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)

    @_builtins.property
    @pulumi.getter
    def interval(self) -> pulumi.Input[_builtins.int]:
        """
        The time interval between each batch execution. Unit: seconds.
        """
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "interval", value)

    @_builtins.property
    @pulumi.getter(name="scheduledPreloadJobId")
    def scheduled_preload_job_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the prefetch task.
        """
        return pulumi.get(self, "scheduled_preload_job_id")

    @scheduled_preload_job_id.setter
    def scheduled_preload_job_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "scheduled_preload_job_id", value)

    @_builtins.property
    @pulumi.getter(name="sliceLen")
    def slice_len(self) -> pulumi.Input[_builtins.int]:
        """
        The number of URLs prefetched in each batch.
        """
        return pulumi.get(self, "slice_len")

    @slice_len.setter
    def slice_len(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "slice_len", value)

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The end time of the prefetch plan.
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "end_time", value)

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The start time of the prefetch plan.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "start_time", value)


@pulumi.input_type
class _ScheduledPreloadExecutionState:
    def __init__(__self__, *,
                 end_time: Optional[pulumi.Input[_builtins.str]] = None,
                 interval: Optional[pulumi.Input[_builtins.int]] = None,
                 scheduled_preload_execution_id: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduled_preload_job_id: Optional[pulumi.Input[_builtins.str]] = None,
                 slice_len: Optional[pulumi.Input[_builtins.int]] = None,
                 start_time: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ScheduledPreloadExecution resources.
        :param pulumi.Input[_builtins.str] end_time: The end time of the prefetch plan.
        :param pulumi.Input[_builtins.int] interval: The time interval between each batch execution. Unit: seconds.
        :param pulumi.Input[_builtins.str] scheduled_preload_execution_id: The ID of the prefetch plan.
        :param pulumi.Input[_builtins.str] scheduled_preload_job_id: The ID of the prefetch task.
        :param pulumi.Input[_builtins.int] slice_len: The number of URLs prefetched in each batch.
        :param pulumi.Input[_builtins.str] start_time: The start time of the prefetch plan.
        :param pulumi.Input[_builtins.str] status: The status of the prefetch plan, including the following statuses.
        """
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if scheduled_preload_execution_id is not None:
            pulumi.set(__self__, "scheduled_preload_execution_id", scheduled_preload_execution_id)
        if scheduled_preload_job_id is not None:
            pulumi.set(__self__, "scheduled_preload_job_id", scheduled_preload_job_id)
        if slice_len is not None:
            pulumi.set(__self__, "slice_len", slice_len)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The end time of the prefetch plan.
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "end_time", value)

    @_builtins.property
    @pulumi.getter
    def interval(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The time interval between each batch execution. Unit: seconds.
        """
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "interval", value)

    @_builtins.property
    @pulumi.getter(name="scheduledPreloadExecutionId")
    def scheduled_preload_execution_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the prefetch plan.
        """
        return pulumi.get(self, "scheduled_preload_execution_id")

    @scheduled_preload_execution_id.setter
    def scheduled_preload_execution_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scheduled_preload_execution_id", value)

    @_builtins.property
    @pulumi.getter(name="scheduledPreloadJobId")
    def scheduled_preload_job_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the prefetch task.
        """
        return pulumi.get(self, "scheduled_preload_job_id")

    @scheduled_preload_job_id.setter
    def scheduled_preload_job_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scheduled_preload_job_id", value)

    @_builtins.property
    @pulumi.getter(name="sliceLen")
    def slice_len(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of URLs prefetched in each batch.
        """
        return pulumi.get(self, "slice_len")

    @slice_len.setter
    def slice_len(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "slice_len", value)

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The start time of the prefetch plan.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "start_time", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the prefetch plan, including the following statuses.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("alicloud:esa/scheduledPreloadExecution:ScheduledPreloadExecution")
class ScheduledPreloadExecution(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 end_time: Optional[pulumi.Input[_builtins.str]] = None,
                 interval: Optional[pulumi.Input[_builtins.int]] = None,
                 scheduled_preload_job_id: Optional[pulumi.Input[_builtins.str]] = None,
                 slice_len: Optional[pulumi.Input[_builtins.int]] = None,
                 start_time: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a ESA Scheduled Preload Execution resource.

        For information about ESA Scheduled Preload Execution and how to use it, see [What is Scheduled Preload Execution](https://next.api.alibabacloud.com/document/ESA/2024-09-10/CreateScheduledPreloadExecutions).

        > **NOTE:** Available since v1.248.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.esa.get_sites(plan_subscribe_type="enterpriseplan")
        default_site = alicloud.esa.Site("default",
            site_name="terraform.cn",
            instance_id=default.sites[0].instance_id,
            coverage="overseas",
            access_type="NS")
        default_scheduled_preload_job = alicloud.esa.ScheduledPreloadJob("default",
            insert_way="textBox",
            site_id=default_site.id,
            scheduled_preload_job_name="example_scheduledpreloadexecution_job",
            url_list="http://example.gositecdn.cn/example/example.txt")
        default_scheduled_preload_execution = alicloud.esa.ScheduledPreloadExecution("default",
            slice_len=5,
            end_time="2024-06-04T10:02:09.000+08:00",
            start_time="2024-06-04T00:00:00.000+08:00",
            scheduled_preload_job_id=default_scheduled_preload_job.scheduled_preload_job_id,
            interval=30)
        ```

        ## Import

        ESA Scheduled Preload Execution can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:esa/scheduledPreloadExecution:ScheduledPreloadExecution example <scheduled_preload_job_id>:<scheduled_preload_execution_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] end_time: The end time of the prefetch plan.
        :param pulumi.Input[_builtins.int] interval: The time interval between each batch execution. Unit: seconds.
        :param pulumi.Input[_builtins.str] scheduled_preload_job_id: The ID of the prefetch task.
        :param pulumi.Input[_builtins.int] slice_len: The number of URLs prefetched in each batch.
        :param pulumi.Input[_builtins.str] start_time: The start time of the prefetch plan.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ScheduledPreloadExecutionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a ESA Scheduled Preload Execution resource.

        For information about ESA Scheduled Preload Execution and how to use it, see [What is Scheduled Preload Execution](https://next.api.alibabacloud.com/document/ESA/2024-09-10/CreateScheduledPreloadExecutions).

        > **NOTE:** Available since v1.248.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.esa.get_sites(plan_subscribe_type="enterpriseplan")
        default_site = alicloud.esa.Site("default",
            site_name="terraform.cn",
            instance_id=default.sites[0].instance_id,
            coverage="overseas",
            access_type="NS")
        default_scheduled_preload_job = alicloud.esa.ScheduledPreloadJob("default",
            insert_way="textBox",
            site_id=default_site.id,
            scheduled_preload_job_name="example_scheduledpreloadexecution_job",
            url_list="http://example.gositecdn.cn/example/example.txt")
        default_scheduled_preload_execution = alicloud.esa.ScheduledPreloadExecution("default",
            slice_len=5,
            end_time="2024-06-04T10:02:09.000+08:00",
            start_time="2024-06-04T00:00:00.000+08:00",
            scheduled_preload_job_id=default_scheduled_preload_job.scheduled_preload_job_id,
            interval=30)
        ```

        ## Import

        ESA Scheduled Preload Execution can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:esa/scheduledPreloadExecution:ScheduledPreloadExecution example <scheduled_preload_job_id>:<scheduled_preload_execution_id>
        ```

        :param str resource_name: The name of the resource.
        :param ScheduledPreloadExecutionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ScheduledPreloadExecutionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 end_time: Optional[pulumi.Input[_builtins.str]] = None,
                 interval: Optional[pulumi.Input[_builtins.int]] = None,
                 scheduled_preload_job_id: Optional[pulumi.Input[_builtins.str]] = None,
                 slice_len: Optional[pulumi.Input[_builtins.int]] = None,
                 start_time: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ScheduledPreloadExecutionArgs.__new__(ScheduledPreloadExecutionArgs)

            __props__.__dict__["end_time"] = end_time
            if interval is None and not opts.urn:
                raise TypeError("Missing required property 'interval'")
            __props__.__dict__["interval"] = interval
            if scheduled_preload_job_id is None and not opts.urn:
                raise TypeError("Missing required property 'scheduled_preload_job_id'")
            __props__.__dict__["scheduled_preload_job_id"] = scheduled_preload_job_id
            if slice_len is None and not opts.urn:
                raise TypeError("Missing required property 'slice_len'")
            __props__.__dict__["slice_len"] = slice_len
            __props__.__dict__["start_time"] = start_time
            __props__.__dict__["scheduled_preload_execution_id"] = None
            __props__.__dict__["status"] = None
        super(ScheduledPreloadExecution, __self__).__init__(
            'alicloud:esa/scheduledPreloadExecution:ScheduledPreloadExecution',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            end_time: Optional[pulumi.Input[_builtins.str]] = None,
            interval: Optional[pulumi.Input[_builtins.int]] = None,
            scheduled_preload_execution_id: Optional[pulumi.Input[_builtins.str]] = None,
            scheduled_preload_job_id: Optional[pulumi.Input[_builtins.str]] = None,
            slice_len: Optional[pulumi.Input[_builtins.int]] = None,
            start_time: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None) -> 'ScheduledPreloadExecution':
        """
        Get an existing ScheduledPreloadExecution resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] end_time: The end time of the prefetch plan.
        :param pulumi.Input[_builtins.int] interval: The time interval between each batch execution. Unit: seconds.
        :param pulumi.Input[_builtins.str] scheduled_preload_execution_id: The ID of the prefetch plan.
        :param pulumi.Input[_builtins.str] scheduled_preload_job_id: The ID of the prefetch task.
        :param pulumi.Input[_builtins.int] slice_len: The number of URLs prefetched in each batch.
        :param pulumi.Input[_builtins.str] start_time: The start time of the prefetch plan.
        :param pulumi.Input[_builtins.str] status: The status of the prefetch plan, including the following statuses.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ScheduledPreloadExecutionState.__new__(_ScheduledPreloadExecutionState)

        __props__.__dict__["end_time"] = end_time
        __props__.__dict__["interval"] = interval
        __props__.__dict__["scheduled_preload_execution_id"] = scheduled_preload_execution_id
        __props__.__dict__["scheduled_preload_job_id"] = scheduled_preload_job_id
        __props__.__dict__["slice_len"] = slice_len
        __props__.__dict__["start_time"] = start_time
        __props__.__dict__["status"] = status
        return ScheduledPreloadExecution(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The end time of the prefetch plan.
        """
        return pulumi.get(self, "end_time")

    @_builtins.property
    @pulumi.getter
    def interval(self) -> pulumi.Output[_builtins.int]:
        """
        The time interval between each batch execution. Unit: seconds.
        """
        return pulumi.get(self, "interval")

    @_builtins.property
    @pulumi.getter(name="scheduledPreloadExecutionId")
    def scheduled_preload_execution_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the prefetch plan.
        """
        return pulumi.get(self, "scheduled_preload_execution_id")

    @_builtins.property
    @pulumi.getter(name="scheduledPreloadJobId")
    def scheduled_preload_job_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the prefetch task.
        """
        return pulumi.get(self, "scheduled_preload_job_id")

    @_builtins.property
    @pulumi.getter(name="sliceLen")
    def slice_len(self) -> pulumi.Output[_builtins.int]:
        """
        The number of URLs prefetched in each batch.
        """
        return pulumi.get(self, "slice_len")

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The start time of the prefetch plan.
        """
        return pulumi.get(self, "start_time")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the prefetch plan, including the following statuses.
        """
        return pulumi.get(self, "status")

