# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ScalingGroupArgs', 'ScalingGroup']

@pulumi.input_type
class ScalingGroupArgs:
    def __init__(__self__, *,
                 max_size: pulumi.Input[_builtins.int],
                 min_size: pulumi.Input[_builtins.int],
                 alb_server_groups: Optional[pulumi.Input[Sequence[pulumi.Input['ScalingGroupAlbServerGroupArgs']]]] = None,
                 allocation_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 az_balance: Optional[pulumi.Input[_builtins.bool]] = None,
                 capacity_options_compensate_with_on_demand: Optional[pulumi.Input[_builtins.bool]] = None,
                 capacity_options_on_demand_base_capacity: Optional[pulumi.Input[_builtins.int]] = None,
                 capacity_options_on_demand_percentage_above_base_capacity: Optional[pulumi.Input[_builtins.int]] = None,
                 capacity_options_price_comparison_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 capacity_options_spot_auto_replace_on_demand: Optional[pulumi.Input[_builtins.bool]] = None,
                 compensate_with_on_demand: Optional[pulumi.Input[_builtins.bool]] = None,
                 container_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 db_instance_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 default_cooldown: Optional[pulumi.Input[_builtins.int]] = None,
                 desired_capacity: Optional[pulumi.Input[_builtins.int]] = None,
                 group_deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 group_type: Optional[pulumi.Input[_builtins.str]] = None,
                 health_check_type: Optional[pulumi.Input[_builtins.str]] = None,
                 health_check_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 launch_template_id: Optional[pulumi.Input[_builtins.str]] = None,
                 launch_template_overrides: Optional[pulumi.Input[Sequence[pulumi.Input['ScalingGroupLaunchTemplateOverrideArgs']]]] = None,
                 launch_template_version: Optional[pulumi.Input[_builtins.str]] = None,
                 loadbalancer_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 max_instance_lifetime: Optional[pulumi.Input[_builtins.int]] = None,
                 multi_az_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 on_demand_base_capacity: Optional[pulumi.Input[_builtins.int]] = None,
                 on_demand_percentage_above_base_capacity: Optional[pulumi.Input[_builtins.int]] = None,
                 protected_instances: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 removal_policies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 scaling_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 scaling_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 spot_allocation_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 spot_instance_pools: Optional[pulumi.Input[_builtins.int]] = None,
                 spot_instance_remedy: Optional[pulumi.Input[_builtins.bool]] = None,
                 stop_instance_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a ScalingGroup resource.
        :param pulumi.Input[_builtins.int] max_size: Maximum number of ECS instances in the scaling group. Value range: [0, 2000].
               **NOTE:** From version 1.204.1, `max_size` can be set to `2000`.
        :param pulumi.Input[_builtins.int] min_size: Minimum number of ECS instances in the scaling group. Value range: [0, 2000].
               **NOTE:** From version 1.204.1, `min_size` can be set to `2000`.
        :param pulumi.Input[Sequence[pulumi.Input['ScalingGroupAlbServerGroupArgs']]] alb_server_groups: If a Serve ALB instance is specified in the scaling group, the scaling group automatically attaches its ECS instances to the Server ALB instance.  See `alb_server_group` below for details.
        :param pulumi.Input[_builtins.str] allocation_strategy: The allocation policy of instances. Auto Scaling selects instance types based on the allocation policy to create instances. The policy can be applied to pay-as-you-go instances and preemptible instances. This parameter takes effect only if you set MultiAZPolicy to COMPOSABLE.
        :param pulumi.Input[_builtins.bool] az_balance: Specifies whether to evenly distribute instances in the scaling group across multiple zones. This parameter takes effect only if you set MultiAZPolicy to COMPOSABLE.
        :param pulumi.Input[_builtins.bool] capacity_options_compensate_with_on_demand: Specifies whether to automatically create pay-as-you-go instances to meet the requirement on the number of ECS instances when the expected capacity of preemptible instances cannot be provided due to reasons such as cost-related issues and insufficient resources. This parameter is supported only if you set 'multi_az_policy' to COST_OPTIMIZED. Valid values: true, false.
        :param pulumi.Input[_builtins.int] capacity_options_on_demand_base_capacity: The minimum number of pay-as-you-go instances that must be contained in the scaling group. When the actual number of pay-as-you-go instances in the scaling group drops below the value of this parameter, Auto Scaling preferentially creates pay-as-you-go instances. Valid values: 0 to 1000. If you set 'multi_az_policy' to COMPOSABLE, the default value of this parameter is 0.
        :param pulumi.Input[_builtins.int] capacity_options_on_demand_percentage_above_base_capacity: The percentage of pay-as-you-go instances in the excess instances when the minimum number of pay-as-you-go instances is reached. 'on_demand_base_capacity' specifies the minimum number of pay-as-you-go instances that must be contained in the scaling group. Valid values: 0 to 100. If you set 'multi_az_policy' to COMPOSABLE, the default value of this parameter is 100.
        :param pulumi.Input[_builtins.str] capacity_options_price_comparison_mode: The price comparison mode. Valid values: PricePerUnit,PricePerVCpu. Default value: PricePerUnit.
        :param pulumi.Input[_builtins.bool] capacity_options_spot_auto_replace_on_demand: Specifies whether to replace pay-as-you-go instances with preemptible instances. If you specify 'compensate_with_on_demand', it may result in a higher percentage of pay-as-you-go instances compared to the value of 'on_demand_percentage_above_base_capacity'. If you specify this parameter, Auto Scaling preferentially deploys preemptible instances to replace the surplus pay-as-you-go instances when preemptible instance types are available. If you specify 'compensate_with_on_demand', Auto Scaling creates pay-as-you-go instances when preemptible instance types are insufficient. To avoid retaining these pay-as-you-go instances for extended periods, Auto Scaling attempts to replace them with preemptible instances when sufficient preemptible instance types become available. Valid values: true, false.
        :param pulumi.Input[_builtins.bool] compensate_with_on_demand: Specifies whether to automatically create pay-as-you-go instances to meet the requirement on the number of ECS instances when the expected capacity of preemptible instances cannot be provided due to reasons such as cost-related issues and insufficient resources. This parameter is supported only if you set 'multi_az_policy' to COST_OPTIMIZED. Valid values: true, false.
        :param pulumi.Input[_builtins.str] container_group_id: The ID of the elastic container instance.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] db_instance_ids: If an RDS instance is specified in the scaling group, the scaling group automatically attaches the Intranet IP addresses of its ECS instances to the RDS access whitelist.
               - The specified RDS instance must be in running status.
               - The specified RDS instance’s whitelist must have room for more IP addresses.
        :param pulumi.Input[_builtins.int] default_cooldown: Default cool-down time (in seconds) of the scaling group. Value range: [0, 86400]. The default value is 300s.
        :param pulumi.Input[_builtins.int] desired_capacity: Expected number of ECS instances in the scaling group. Value range: [min_size, max_size].
        :param pulumi.Input[_builtins.bool] group_deletion_protection: Specifies whether the scaling group deletion protection is enabled. `true` or `false`, Default value: `false`.
        :param pulumi.Input[_builtins.str] group_type: Resource type within scaling group. Optional values: ECS, ECI. Default to ECS.
        :param pulumi.Input[_builtins.str] health_check_type: Resource type within scaling group. Optional values: ECS, ECI, NONE, LOAD_BALANCER. Default to ECS.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] health_check_types: The health check modes of the scaling group. Valid values: ECS, NONE, LOAD_BALANCER.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the instance from which Auto Scaling obtains the required configuration information and uses the information to automatically create a scaling configuration.
        :param pulumi.Input[_builtins.str] launch_template_id: Instance launch template ID, scaling group obtains launch configuration from instance launch template, see [Launch Template](https://www.alibabacloud.com/help/doc-detail/73916.html). Creating scaling group from launch template enable group automatically.
        :param pulumi.Input[Sequence[pulumi.Input['ScalingGroupLaunchTemplateOverrideArgs']]] launch_template_overrides: The details of the instance types that are specified by using the Extend Instance Type of Launch Template feature.  See `launch_template_override` below for details.
        :param pulumi.Input[_builtins.str] launch_template_version: The version number of the launch template. Valid values are the version number, `Latest`, or `Default`, Default value: `Default`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] loadbalancer_ids: If a Server Load Balancer instance is specified in the scaling group, the scaling group automatically attaches its ECS instances to the Server Load Balancer instance.
               - The Server Load Balancer instance must be enabled.
               - At least one listener must be configured for each Server Load Balancer and it HealthCheck must be on. Otherwise, creation will fail (it may be useful to add a `depends_on` argument
               targeting your `slb.Listener` in order to make sure the listener with its HealthCheck configuration is ready before creating your scaling group).
               - The Server Load Balancer instance attached with VPC-type ECS instances cannot be attached to the scaling group.
               - The default weight of an ECS instance attached to the Server Load Balancer instance is 50.
        :param pulumi.Input[_builtins.int] max_instance_lifetime: The maximum life span of an instance in the scaling group. Unit: seconds.
        :param pulumi.Input[_builtins.str] multi_az_policy: Multi-AZ scaling group ECS instance expansion and contraction strategy. PRIORITY, COMPOSABLE, BALANCE or COST_OPTIMIZED(Available since v1.54.0).
        :param pulumi.Input[_builtins.int] on_demand_base_capacity: The minimum amount of the Auto Scaling group's capacity that must be fulfilled by On-Demand Instances. This base portion is provisioned first as your group scales.
        :param pulumi.Input[_builtins.int] on_demand_percentage_above_base_capacity: Controls the percentages of On-Demand Instances and Spot Instances for your additional capacity beyond OnDemandBaseCapacity.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] protected_instances: Set or unset instances within group into protected status.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] removal_policies: RemovalPolicy is used to select the ECS instances you want to remove from the scaling group when multiple candidates for removal exist. Optional values:
               - OldestInstance: removes the ECS instance that is added to the scaling group at the earliest point in time.
               - NewestInstance: removes the ECS instance that is added to the scaling group at the latest point in time.
               - OldestScalingConfiguration: removes the ECS instance that is created based on the earliest scaling configuration.
               - Default values: Default value of RemovalPolicy.1: OldestScalingConfiguration. Default value of RemovalPolicy.2: OldestInstance.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group to which you want to add the scaling group.
        :param pulumi.Input[_builtins.str] scaling_group_name: Name shown for the scaling group, which must contain 2-64 characters (English or Chinese), starting with numbers, English letters or Chinese characters, and can contain numbers, underscores `_`, hyphens `-`, and decimal points `.`. If this parameter is not specified, the default value is ScalingGroupId.
        :param pulumi.Input[_builtins.str] scaling_policy: The reclaim mode of the scaling group. Optional values: recycle, release, forceRecycle, forceRelease.
        :param pulumi.Input[_builtins.str] spot_allocation_strategy: The allocation policy of preemptible instances. You can use this parameter to individually specify the allocation policy for preemptible instances. This parameter takes effect only if you set MultiAZPolicy to COMPOSABLE.
        :param pulumi.Input[_builtins.int] spot_instance_pools: The number of Spot pools to use to allocate your Spot capacity. The Spot pools is composed of instance types of lowest price.
        :param pulumi.Input[_builtins.bool] spot_instance_remedy: Whether to replace spot instances with newly created spot/onDemand instance when receive a spot recycling message.
        :param pulumi.Input[_builtins.int] stop_instance_timeout: The period of time required by the ECS instance to enter the Stopped state. Unit: seconds. Valid values: 30 to 240.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
               - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
               - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
        :param pulumi.Input[_builtins.str] vswitch_id: It has been deprecated from version 1.7.1 and new field 'vswitch_ids' replaces it.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] vswitch_ids: List of virtual switch IDs in which the ecs instances to be launched.
        """
        pulumi.set(__self__, "max_size", max_size)
        pulumi.set(__self__, "min_size", min_size)
        if alb_server_groups is not None:
            pulumi.set(__self__, "alb_server_groups", alb_server_groups)
        if allocation_strategy is not None:
            pulumi.set(__self__, "allocation_strategy", allocation_strategy)
        if az_balance is not None:
            pulumi.set(__self__, "az_balance", az_balance)
        if capacity_options_compensate_with_on_demand is not None:
            pulumi.set(__self__, "capacity_options_compensate_with_on_demand", capacity_options_compensate_with_on_demand)
        if capacity_options_on_demand_base_capacity is not None:
            pulumi.set(__self__, "capacity_options_on_demand_base_capacity", capacity_options_on_demand_base_capacity)
        if capacity_options_on_demand_percentage_above_base_capacity is not None:
            pulumi.set(__self__, "capacity_options_on_demand_percentage_above_base_capacity", capacity_options_on_demand_percentage_above_base_capacity)
        if capacity_options_price_comparison_mode is not None:
            pulumi.set(__self__, "capacity_options_price_comparison_mode", capacity_options_price_comparison_mode)
        if capacity_options_spot_auto_replace_on_demand is not None:
            pulumi.set(__self__, "capacity_options_spot_auto_replace_on_demand", capacity_options_spot_auto_replace_on_demand)
        if compensate_with_on_demand is not None:
            pulumi.set(__self__, "compensate_with_on_demand", compensate_with_on_demand)
        if container_group_id is not None:
            pulumi.set(__self__, "container_group_id", container_group_id)
        if db_instance_ids is not None:
            pulumi.set(__self__, "db_instance_ids", db_instance_ids)
        if default_cooldown is not None:
            pulumi.set(__self__, "default_cooldown", default_cooldown)
        if desired_capacity is not None:
            pulumi.set(__self__, "desired_capacity", desired_capacity)
        if group_deletion_protection is not None:
            pulumi.set(__self__, "group_deletion_protection", group_deletion_protection)
        if group_type is not None:
            pulumi.set(__self__, "group_type", group_type)
        if health_check_type is not None:
            pulumi.set(__self__, "health_check_type", health_check_type)
        if health_check_types is not None:
            pulumi.set(__self__, "health_check_types", health_check_types)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if launch_template_id is not None:
            pulumi.set(__self__, "launch_template_id", launch_template_id)
        if launch_template_overrides is not None:
            pulumi.set(__self__, "launch_template_overrides", launch_template_overrides)
        if launch_template_version is not None:
            pulumi.set(__self__, "launch_template_version", launch_template_version)
        if loadbalancer_ids is not None:
            pulumi.set(__self__, "loadbalancer_ids", loadbalancer_ids)
        if max_instance_lifetime is not None:
            pulumi.set(__self__, "max_instance_lifetime", max_instance_lifetime)
        if multi_az_policy is not None:
            pulumi.set(__self__, "multi_az_policy", multi_az_policy)
        if on_demand_base_capacity is not None:
            pulumi.set(__self__, "on_demand_base_capacity", on_demand_base_capacity)
        if on_demand_percentage_above_base_capacity is not None:
            pulumi.set(__self__, "on_demand_percentage_above_base_capacity", on_demand_percentage_above_base_capacity)
        if protected_instances is not None:
            pulumi.set(__self__, "protected_instances", protected_instances)
        if removal_policies is not None:
            pulumi.set(__self__, "removal_policies", removal_policies)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if scaling_group_name is not None:
            pulumi.set(__self__, "scaling_group_name", scaling_group_name)
        if scaling_policy is not None:
            pulumi.set(__self__, "scaling_policy", scaling_policy)
        if spot_allocation_strategy is not None:
            pulumi.set(__self__, "spot_allocation_strategy", spot_allocation_strategy)
        if spot_instance_pools is not None:
            pulumi.set(__self__, "spot_instance_pools", spot_instance_pools)
        if spot_instance_remedy is not None:
            pulumi.set(__self__, "spot_instance_remedy", spot_instance_remedy)
        if stop_instance_timeout is not None:
            pulumi.set(__self__, "stop_instance_timeout", stop_instance_timeout)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vswitch_id is not None:
            warnings.warn("""Field 'vswitch_id' has been deprecated from provider version 1.7.1, and new field 'vswitch_ids' can replace it.""", DeprecationWarning)
            pulumi.log.warn("""vswitch_id is deprecated: Field 'vswitch_id' has been deprecated from provider version 1.7.1, and new field 'vswitch_ids' can replace it.""")
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)
        if vswitch_ids is not None:
            pulumi.set(__self__, "vswitch_ids", vswitch_ids)

    @_builtins.property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> pulumi.Input[_builtins.int]:
        """
        Maximum number of ECS instances in the scaling group. Value range: [0, 2000].
        **NOTE:** From version 1.204.1, `max_size` can be set to `2000`.
        """
        return pulumi.get(self, "max_size")

    @max_size.setter
    def max_size(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "max_size", value)

    @_builtins.property
    @pulumi.getter(name="minSize")
    def min_size(self) -> pulumi.Input[_builtins.int]:
        """
        Minimum number of ECS instances in the scaling group. Value range: [0, 2000].
        **NOTE:** From version 1.204.1, `min_size` can be set to `2000`.
        """
        return pulumi.get(self, "min_size")

    @min_size.setter
    def min_size(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "min_size", value)

    @_builtins.property
    @pulumi.getter(name="albServerGroups")
    def alb_server_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ScalingGroupAlbServerGroupArgs']]]]:
        """
        If a Serve ALB instance is specified in the scaling group, the scaling group automatically attaches its ECS instances to the Server ALB instance.  See `alb_server_group` below for details.
        """
        return pulumi.get(self, "alb_server_groups")

    @alb_server_groups.setter
    def alb_server_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ScalingGroupAlbServerGroupArgs']]]]):
        pulumi.set(self, "alb_server_groups", value)

    @_builtins.property
    @pulumi.getter(name="allocationStrategy")
    def allocation_strategy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The allocation policy of instances. Auto Scaling selects instance types based on the allocation policy to create instances. The policy can be applied to pay-as-you-go instances and preemptible instances. This parameter takes effect only if you set MultiAZPolicy to COMPOSABLE.
        """
        return pulumi.get(self, "allocation_strategy")

    @allocation_strategy.setter
    def allocation_strategy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "allocation_strategy", value)

    @_builtins.property
    @pulumi.getter(name="azBalance")
    def az_balance(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to evenly distribute instances in the scaling group across multiple zones. This parameter takes effect only if you set MultiAZPolicy to COMPOSABLE.
        """
        return pulumi.get(self, "az_balance")

    @az_balance.setter
    def az_balance(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "az_balance", value)

    @_builtins.property
    @pulumi.getter(name="capacityOptionsCompensateWithOnDemand")
    def capacity_options_compensate_with_on_demand(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to automatically create pay-as-you-go instances to meet the requirement on the number of ECS instances when the expected capacity of preemptible instances cannot be provided due to reasons such as cost-related issues and insufficient resources. This parameter is supported only if you set 'multi_az_policy' to COST_OPTIMIZED. Valid values: true, false.
        """
        return pulumi.get(self, "capacity_options_compensate_with_on_demand")

    @capacity_options_compensate_with_on_demand.setter
    def capacity_options_compensate_with_on_demand(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "capacity_options_compensate_with_on_demand", value)

    @_builtins.property
    @pulumi.getter(name="capacityOptionsOnDemandBaseCapacity")
    def capacity_options_on_demand_base_capacity(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The minimum number of pay-as-you-go instances that must be contained in the scaling group. When the actual number of pay-as-you-go instances in the scaling group drops below the value of this parameter, Auto Scaling preferentially creates pay-as-you-go instances. Valid values: 0 to 1000. If you set 'multi_az_policy' to COMPOSABLE, the default value of this parameter is 0.
        """
        return pulumi.get(self, "capacity_options_on_demand_base_capacity")

    @capacity_options_on_demand_base_capacity.setter
    def capacity_options_on_demand_base_capacity(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "capacity_options_on_demand_base_capacity", value)

    @_builtins.property
    @pulumi.getter(name="capacityOptionsOnDemandPercentageAboveBaseCapacity")
    def capacity_options_on_demand_percentage_above_base_capacity(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The percentage of pay-as-you-go instances in the excess instances when the minimum number of pay-as-you-go instances is reached. 'on_demand_base_capacity' specifies the minimum number of pay-as-you-go instances that must be contained in the scaling group. Valid values: 0 to 100. If you set 'multi_az_policy' to COMPOSABLE, the default value of this parameter is 100.
        """
        return pulumi.get(self, "capacity_options_on_demand_percentage_above_base_capacity")

    @capacity_options_on_demand_percentage_above_base_capacity.setter
    def capacity_options_on_demand_percentage_above_base_capacity(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "capacity_options_on_demand_percentage_above_base_capacity", value)

    @_builtins.property
    @pulumi.getter(name="capacityOptionsPriceComparisonMode")
    def capacity_options_price_comparison_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The price comparison mode. Valid values: PricePerUnit,PricePerVCpu. Default value: PricePerUnit.
        """
        return pulumi.get(self, "capacity_options_price_comparison_mode")

    @capacity_options_price_comparison_mode.setter
    def capacity_options_price_comparison_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "capacity_options_price_comparison_mode", value)

    @_builtins.property
    @pulumi.getter(name="capacityOptionsSpotAutoReplaceOnDemand")
    def capacity_options_spot_auto_replace_on_demand(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to replace pay-as-you-go instances with preemptible instances. If you specify 'compensate_with_on_demand', it may result in a higher percentage of pay-as-you-go instances compared to the value of 'on_demand_percentage_above_base_capacity'. If you specify this parameter, Auto Scaling preferentially deploys preemptible instances to replace the surplus pay-as-you-go instances when preemptible instance types are available. If you specify 'compensate_with_on_demand', Auto Scaling creates pay-as-you-go instances when preemptible instance types are insufficient. To avoid retaining these pay-as-you-go instances for extended periods, Auto Scaling attempts to replace them with preemptible instances when sufficient preemptible instance types become available. Valid values: true, false.
        """
        return pulumi.get(self, "capacity_options_spot_auto_replace_on_demand")

    @capacity_options_spot_auto_replace_on_demand.setter
    def capacity_options_spot_auto_replace_on_demand(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "capacity_options_spot_auto_replace_on_demand", value)

    @_builtins.property
    @pulumi.getter(name="compensateWithOnDemand")
    def compensate_with_on_demand(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to automatically create pay-as-you-go instances to meet the requirement on the number of ECS instances when the expected capacity of preemptible instances cannot be provided due to reasons such as cost-related issues and insufficient resources. This parameter is supported only if you set 'multi_az_policy' to COST_OPTIMIZED. Valid values: true, false.
        """
        return pulumi.get(self, "compensate_with_on_demand")

    @compensate_with_on_demand.setter
    def compensate_with_on_demand(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "compensate_with_on_demand", value)

    @_builtins.property
    @pulumi.getter(name="containerGroupId")
    def container_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the elastic container instance.
        """
        return pulumi.get(self, "container_group_id")

    @container_group_id.setter
    def container_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "container_group_id", value)

    @_builtins.property
    @pulumi.getter(name="dbInstanceIds")
    def db_instance_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        If an RDS instance is specified in the scaling group, the scaling group automatically attaches the Intranet IP addresses of its ECS instances to the RDS access whitelist.
        - The specified RDS instance must be in running status.
        - The specified RDS instance’s whitelist must have room for more IP addresses.
        """
        return pulumi.get(self, "db_instance_ids")

    @db_instance_ids.setter
    def db_instance_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "db_instance_ids", value)

    @_builtins.property
    @pulumi.getter(name="defaultCooldown")
    def default_cooldown(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Default cool-down time (in seconds) of the scaling group. Value range: [0, 86400]. The default value is 300s.
        """
        return pulumi.get(self, "default_cooldown")

    @default_cooldown.setter
    def default_cooldown(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "default_cooldown", value)

    @_builtins.property
    @pulumi.getter(name="desiredCapacity")
    def desired_capacity(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Expected number of ECS instances in the scaling group. Value range: [min_size, max_size].
        """
        return pulumi.get(self, "desired_capacity")

    @desired_capacity.setter
    def desired_capacity(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "desired_capacity", value)

    @_builtins.property
    @pulumi.getter(name="groupDeletionProtection")
    def group_deletion_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether the scaling group deletion protection is enabled. `true` or `false`, Default value: `false`.
        """
        return pulumi.get(self, "group_deletion_protection")

    @group_deletion_protection.setter
    def group_deletion_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "group_deletion_protection", value)

    @_builtins.property
    @pulumi.getter(name="groupType")
    def group_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource type within scaling group. Optional values: ECS, ECI. Default to ECS.
        """
        return pulumi.get(self, "group_type")

    @group_type.setter
    def group_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group_type", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckType")
    def health_check_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource type within scaling group. Optional values: ECS, ECI, NONE, LOAD_BALANCER. Default to ECS.
        """
        return pulumi.get(self, "health_check_type")

    @health_check_type.setter
    def health_check_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "health_check_type", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckTypes")
    def health_check_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The health check modes of the scaling group. Valid values: ECS, NONE, LOAD_BALANCER.
        """
        return pulumi.get(self, "health_check_types")

    @health_check_types.setter
    def health_check_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "health_check_types", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the instance from which Auto Scaling obtains the required configuration information and uses the information to automatically create a scaling configuration.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="launchTemplateId")
    def launch_template_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instance launch template ID, scaling group obtains launch configuration from instance launch template, see [Launch Template](https://www.alibabacloud.com/help/doc-detail/73916.html). Creating scaling group from launch template enable group automatically.
        """
        return pulumi.get(self, "launch_template_id")

    @launch_template_id.setter
    def launch_template_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "launch_template_id", value)

    @_builtins.property
    @pulumi.getter(name="launchTemplateOverrides")
    def launch_template_overrides(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ScalingGroupLaunchTemplateOverrideArgs']]]]:
        """
        The details of the instance types that are specified by using the Extend Instance Type of Launch Template feature.  See `launch_template_override` below for details.
        """
        return pulumi.get(self, "launch_template_overrides")

    @launch_template_overrides.setter
    def launch_template_overrides(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ScalingGroupLaunchTemplateOverrideArgs']]]]):
        pulumi.set(self, "launch_template_overrides", value)

    @_builtins.property
    @pulumi.getter(name="launchTemplateVersion")
    def launch_template_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version number of the launch template. Valid values are the version number, `Latest`, or `Default`, Default value: `Default`.
        """
        return pulumi.get(self, "launch_template_version")

    @launch_template_version.setter
    def launch_template_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "launch_template_version", value)

    @_builtins.property
    @pulumi.getter(name="loadbalancerIds")
    def loadbalancer_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        If a Server Load Balancer instance is specified in the scaling group, the scaling group automatically attaches its ECS instances to the Server Load Balancer instance.
        - The Server Load Balancer instance must be enabled.
        - At least one listener must be configured for each Server Load Balancer and it HealthCheck must be on. Otherwise, creation will fail (it may be useful to add a `depends_on` argument
        targeting your `slb.Listener` in order to make sure the listener with its HealthCheck configuration is ready before creating your scaling group).
        - The Server Load Balancer instance attached with VPC-type ECS instances cannot be attached to the scaling group.
        - The default weight of an ECS instance attached to the Server Load Balancer instance is 50.
        """
        return pulumi.get(self, "loadbalancer_ids")

    @loadbalancer_ids.setter
    def loadbalancer_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "loadbalancer_ids", value)

    @_builtins.property
    @pulumi.getter(name="maxInstanceLifetime")
    def max_instance_lifetime(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum life span of an instance in the scaling group. Unit: seconds.
        """
        return pulumi.get(self, "max_instance_lifetime")

    @max_instance_lifetime.setter
    def max_instance_lifetime(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_instance_lifetime", value)

    @_builtins.property
    @pulumi.getter(name="multiAzPolicy")
    def multi_az_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Multi-AZ scaling group ECS instance expansion and contraction strategy. PRIORITY, COMPOSABLE, BALANCE or COST_OPTIMIZED(Available since v1.54.0).
        """
        return pulumi.get(self, "multi_az_policy")

    @multi_az_policy.setter
    def multi_az_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "multi_az_policy", value)

    @_builtins.property
    @pulumi.getter(name="onDemandBaseCapacity")
    def on_demand_base_capacity(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The minimum amount of the Auto Scaling group's capacity that must be fulfilled by On-Demand Instances. This base portion is provisioned first as your group scales.
        """
        return pulumi.get(self, "on_demand_base_capacity")

    @on_demand_base_capacity.setter
    def on_demand_base_capacity(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "on_demand_base_capacity", value)

    @_builtins.property
    @pulumi.getter(name="onDemandPercentageAboveBaseCapacity")
    def on_demand_percentage_above_base_capacity(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Controls the percentages of On-Demand Instances and Spot Instances for your additional capacity beyond OnDemandBaseCapacity.
        """
        return pulumi.get(self, "on_demand_percentage_above_base_capacity")

    @on_demand_percentage_above_base_capacity.setter
    def on_demand_percentage_above_base_capacity(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "on_demand_percentage_above_base_capacity", value)

    @_builtins.property
    @pulumi.getter(name="protectedInstances")
    def protected_instances(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Set or unset instances within group into protected status.
        """
        return pulumi.get(self, "protected_instances")

    @protected_instances.setter
    def protected_instances(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "protected_instances", value)

    @_builtins.property
    @pulumi.getter(name="removalPolicies")
    def removal_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        RemovalPolicy is used to select the ECS instances you want to remove from the scaling group when multiple candidates for removal exist. Optional values:
        - OldestInstance: removes the ECS instance that is added to the scaling group at the earliest point in time.
        - NewestInstance: removes the ECS instance that is added to the scaling group at the latest point in time.
        - OldestScalingConfiguration: removes the ECS instance that is created based on the earliest scaling configuration.
        - Default values: Default value of RemovalPolicy.1: OldestScalingConfiguration. Default value of RemovalPolicy.2: OldestInstance.
        """
        return pulumi.get(self, "removal_policies")

    @removal_policies.setter
    def removal_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "removal_policies", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group to which you want to add the scaling group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="scalingGroupName")
    def scaling_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name shown for the scaling group, which must contain 2-64 characters (English or Chinese), starting with numbers, English letters or Chinese characters, and can contain numbers, underscores `_`, hyphens `-`, and decimal points `.`. If this parameter is not specified, the default value is ScalingGroupId.
        """
        return pulumi.get(self, "scaling_group_name")

    @scaling_group_name.setter
    def scaling_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scaling_group_name", value)

    @_builtins.property
    @pulumi.getter(name="scalingPolicy")
    def scaling_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The reclaim mode of the scaling group. Optional values: recycle, release, forceRecycle, forceRelease.
        """
        return pulumi.get(self, "scaling_policy")

    @scaling_policy.setter
    def scaling_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scaling_policy", value)

    @_builtins.property
    @pulumi.getter(name="spotAllocationStrategy")
    def spot_allocation_strategy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The allocation policy of preemptible instances. You can use this parameter to individually specify the allocation policy for preemptible instances. This parameter takes effect only if you set MultiAZPolicy to COMPOSABLE.
        """
        return pulumi.get(self, "spot_allocation_strategy")

    @spot_allocation_strategy.setter
    def spot_allocation_strategy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "spot_allocation_strategy", value)

    @_builtins.property
    @pulumi.getter(name="spotInstancePools")
    def spot_instance_pools(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of Spot pools to use to allocate your Spot capacity. The Spot pools is composed of instance types of lowest price.
        """
        return pulumi.get(self, "spot_instance_pools")

    @spot_instance_pools.setter
    def spot_instance_pools(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "spot_instance_pools", value)

    @_builtins.property
    @pulumi.getter(name="spotInstanceRemedy")
    def spot_instance_remedy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to replace spot instances with newly created spot/onDemand instance when receive a spot recycling message.
        """
        return pulumi.get(self, "spot_instance_remedy")

    @spot_instance_remedy.setter
    def spot_instance_remedy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "spot_instance_remedy", value)

    @_builtins.property
    @pulumi.getter(name="stopInstanceTimeout")
    def stop_instance_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The period of time required by the ECS instance to enter the Stopped state. Unit: seconds. Valid values: 30 to 240.
        """
        return pulumi.get(self, "stop_instance_timeout")

    @stop_instance_timeout.setter
    def stop_instance_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "stop_instance_timeout", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
        - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    @_utilities.deprecated("""Field 'vswitch_id' has been deprecated from provider version 1.7.1, and new field 'vswitch_ids' can replace it.""")
    def vswitch_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        It has been deprecated from version 1.7.1 and new field 'vswitch_ids' replaces it.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vswitch_id", value)

    @_builtins.property
    @pulumi.getter(name="vswitchIds")
    def vswitch_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of virtual switch IDs in which the ecs instances to be launched.
        """
        return pulumi.get(self, "vswitch_ids")

    @vswitch_ids.setter
    def vswitch_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "vswitch_ids", value)


@pulumi.input_type
class _ScalingGroupState:
    def __init__(__self__, *,
                 alb_server_groups: Optional[pulumi.Input[Sequence[pulumi.Input['ScalingGroupAlbServerGroupArgs']]]] = None,
                 allocation_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 az_balance: Optional[pulumi.Input[_builtins.bool]] = None,
                 capacity_options_compensate_with_on_demand: Optional[pulumi.Input[_builtins.bool]] = None,
                 capacity_options_on_demand_base_capacity: Optional[pulumi.Input[_builtins.int]] = None,
                 capacity_options_on_demand_percentage_above_base_capacity: Optional[pulumi.Input[_builtins.int]] = None,
                 capacity_options_price_comparison_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 capacity_options_spot_auto_replace_on_demand: Optional[pulumi.Input[_builtins.bool]] = None,
                 compensate_with_on_demand: Optional[pulumi.Input[_builtins.bool]] = None,
                 container_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 db_instance_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 default_cooldown: Optional[pulumi.Input[_builtins.int]] = None,
                 desired_capacity: Optional[pulumi.Input[_builtins.int]] = None,
                 group_deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 group_type: Optional[pulumi.Input[_builtins.str]] = None,
                 health_check_type: Optional[pulumi.Input[_builtins.str]] = None,
                 health_check_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 launch_template_id: Optional[pulumi.Input[_builtins.str]] = None,
                 launch_template_overrides: Optional[pulumi.Input[Sequence[pulumi.Input['ScalingGroupLaunchTemplateOverrideArgs']]]] = None,
                 launch_template_version: Optional[pulumi.Input[_builtins.str]] = None,
                 loadbalancer_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 max_instance_lifetime: Optional[pulumi.Input[_builtins.int]] = None,
                 max_size: Optional[pulumi.Input[_builtins.int]] = None,
                 min_size: Optional[pulumi.Input[_builtins.int]] = None,
                 multi_az_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 on_demand_base_capacity: Optional[pulumi.Input[_builtins.int]] = None,
                 on_demand_percentage_above_base_capacity: Optional[pulumi.Input[_builtins.int]] = None,
                 protected_instances: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 removal_policies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 scaling_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 scaling_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 spot_allocation_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 spot_instance_pools: Optional[pulumi.Input[_builtins.int]] = None,
                 spot_instance_remedy: Optional[pulumi.Input[_builtins.bool]] = None,
                 stop_instance_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering ScalingGroup resources.
        :param pulumi.Input[Sequence[pulumi.Input['ScalingGroupAlbServerGroupArgs']]] alb_server_groups: If a Serve ALB instance is specified in the scaling group, the scaling group automatically attaches its ECS instances to the Server ALB instance.  See `alb_server_group` below for details.
        :param pulumi.Input[_builtins.str] allocation_strategy: The allocation policy of instances. Auto Scaling selects instance types based on the allocation policy to create instances. The policy can be applied to pay-as-you-go instances and preemptible instances. This parameter takes effect only if you set MultiAZPolicy to COMPOSABLE.
        :param pulumi.Input[_builtins.bool] az_balance: Specifies whether to evenly distribute instances in the scaling group across multiple zones. This parameter takes effect only if you set MultiAZPolicy to COMPOSABLE.
        :param pulumi.Input[_builtins.bool] capacity_options_compensate_with_on_demand: Specifies whether to automatically create pay-as-you-go instances to meet the requirement on the number of ECS instances when the expected capacity of preemptible instances cannot be provided due to reasons such as cost-related issues and insufficient resources. This parameter is supported only if you set 'multi_az_policy' to COST_OPTIMIZED. Valid values: true, false.
        :param pulumi.Input[_builtins.int] capacity_options_on_demand_base_capacity: The minimum number of pay-as-you-go instances that must be contained in the scaling group. When the actual number of pay-as-you-go instances in the scaling group drops below the value of this parameter, Auto Scaling preferentially creates pay-as-you-go instances. Valid values: 0 to 1000. If you set 'multi_az_policy' to COMPOSABLE, the default value of this parameter is 0.
        :param pulumi.Input[_builtins.int] capacity_options_on_demand_percentage_above_base_capacity: The percentage of pay-as-you-go instances in the excess instances when the minimum number of pay-as-you-go instances is reached. 'on_demand_base_capacity' specifies the minimum number of pay-as-you-go instances that must be contained in the scaling group. Valid values: 0 to 100. If you set 'multi_az_policy' to COMPOSABLE, the default value of this parameter is 100.
        :param pulumi.Input[_builtins.str] capacity_options_price_comparison_mode: The price comparison mode. Valid values: PricePerUnit,PricePerVCpu. Default value: PricePerUnit.
        :param pulumi.Input[_builtins.bool] capacity_options_spot_auto_replace_on_demand: Specifies whether to replace pay-as-you-go instances with preemptible instances. If you specify 'compensate_with_on_demand', it may result in a higher percentage of pay-as-you-go instances compared to the value of 'on_demand_percentage_above_base_capacity'. If you specify this parameter, Auto Scaling preferentially deploys preemptible instances to replace the surplus pay-as-you-go instances when preemptible instance types are available. If you specify 'compensate_with_on_demand', Auto Scaling creates pay-as-you-go instances when preemptible instance types are insufficient. To avoid retaining these pay-as-you-go instances for extended periods, Auto Scaling attempts to replace them with preemptible instances when sufficient preemptible instance types become available. Valid values: true, false.
        :param pulumi.Input[_builtins.bool] compensate_with_on_demand: Specifies whether to automatically create pay-as-you-go instances to meet the requirement on the number of ECS instances when the expected capacity of preemptible instances cannot be provided due to reasons such as cost-related issues and insufficient resources. This parameter is supported only if you set 'multi_az_policy' to COST_OPTIMIZED. Valid values: true, false.
        :param pulumi.Input[_builtins.str] container_group_id: The ID of the elastic container instance.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] db_instance_ids: If an RDS instance is specified in the scaling group, the scaling group automatically attaches the Intranet IP addresses of its ECS instances to the RDS access whitelist.
               - The specified RDS instance must be in running status.
               - The specified RDS instance’s whitelist must have room for more IP addresses.
        :param pulumi.Input[_builtins.int] default_cooldown: Default cool-down time (in seconds) of the scaling group. Value range: [0, 86400]. The default value is 300s.
        :param pulumi.Input[_builtins.int] desired_capacity: Expected number of ECS instances in the scaling group. Value range: [min_size, max_size].
        :param pulumi.Input[_builtins.bool] group_deletion_protection: Specifies whether the scaling group deletion protection is enabled. `true` or `false`, Default value: `false`.
        :param pulumi.Input[_builtins.str] group_type: Resource type within scaling group. Optional values: ECS, ECI. Default to ECS.
        :param pulumi.Input[_builtins.str] health_check_type: Resource type within scaling group. Optional values: ECS, ECI, NONE, LOAD_BALANCER. Default to ECS.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] health_check_types: The health check modes of the scaling group. Valid values: ECS, NONE, LOAD_BALANCER.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the instance from which Auto Scaling obtains the required configuration information and uses the information to automatically create a scaling configuration.
        :param pulumi.Input[_builtins.str] launch_template_id: Instance launch template ID, scaling group obtains launch configuration from instance launch template, see [Launch Template](https://www.alibabacloud.com/help/doc-detail/73916.html). Creating scaling group from launch template enable group automatically.
        :param pulumi.Input[Sequence[pulumi.Input['ScalingGroupLaunchTemplateOverrideArgs']]] launch_template_overrides: The details of the instance types that are specified by using the Extend Instance Type of Launch Template feature.  See `launch_template_override` below for details.
        :param pulumi.Input[_builtins.str] launch_template_version: The version number of the launch template. Valid values are the version number, `Latest`, or `Default`, Default value: `Default`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] loadbalancer_ids: If a Server Load Balancer instance is specified in the scaling group, the scaling group automatically attaches its ECS instances to the Server Load Balancer instance.
               - The Server Load Balancer instance must be enabled.
               - At least one listener must be configured for each Server Load Balancer and it HealthCheck must be on. Otherwise, creation will fail (it may be useful to add a `depends_on` argument
               targeting your `slb.Listener` in order to make sure the listener with its HealthCheck configuration is ready before creating your scaling group).
               - The Server Load Balancer instance attached with VPC-type ECS instances cannot be attached to the scaling group.
               - The default weight of an ECS instance attached to the Server Load Balancer instance is 50.
        :param pulumi.Input[_builtins.int] max_instance_lifetime: The maximum life span of an instance in the scaling group. Unit: seconds.
        :param pulumi.Input[_builtins.int] max_size: Maximum number of ECS instances in the scaling group. Value range: [0, 2000].
               **NOTE:** From version 1.204.1, `max_size` can be set to `2000`.
        :param pulumi.Input[_builtins.int] min_size: Minimum number of ECS instances in the scaling group. Value range: [0, 2000].
               **NOTE:** From version 1.204.1, `min_size` can be set to `2000`.
        :param pulumi.Input[_builtins.str] multi_az_policy: Multi-AZ scaling group ECS instance expansion and contraction strategy. PRIORITY, COMPOSABLE, BALANCE or COST_OPTIMIZED(Available since v1.54.0).
        :param pulumi.Input[_builtins.int] on_demand_base_capacity: The minimum amount of the Auto Scaling group's capacity that must be fulfilled by On-Demand Instances. This base portion is provisioned first as your group scales.
        :param pulumi.Input[_builtins.int] on_demand_percentage_above_base_capacity: Controls the percentages of On-Demand Instances and Spot Instances for your additional capacity beyond OnDemandBaseCapacity.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] protected_instances: Set or unset instances within group into protected status.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] removal_policies: RemovalPolicy is used to select the ECS instances you want to remove from the scaling group when multiple candidates for removal exist. Optional values:
               - OldestInstance: removes the ECS instance that is added to the scaling group at the earliest point in time.
               - NewestInstance: removes the ECS instance that is added to the scaling group at the latest point in time.
               - OldestScalingConfiguration: removes the ECS instance that is created based on the earliest scaling configuration.
               - Default values: Default value of RemovalPolicy.1: OldestScalingConfiguration. Default value of RemovalPolicy.2: OldestInstance.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group to which you want to add the scaling group.
        :param pulumi.Input[_builtins.str] scaling_group_name: Name shown for the scaling group, which must contain 2-64 characters (English or Chinese), starting with numbers, English letters or Chinese characters, and can contain numbers, underscores `_`, hyphens `-`, and decimal points `.`. If this parameter is not specified, the default value is ScalingGroupId.
        :param pulumi.Input[_builtins.str] scaling_policy: The reclaim mode of the scaling group. Optional values: recycle, release, forceRecycle, forceRelease.
        :param pulumi.Input[_builtins.str] spot_allocation_strategy: The allocation policy of preemptible instances. You can use this parameter to individually specify the allocation policy for preemptible instances. This parameter takes effect only if you set MultiAZPolicy to COMPOSABLE.
        :param pulumi.Input[_builtins.int] spot_instance_pools: The number of Spot pools to use to allocate your Spot capacity. The Spot pools is composed of instance types of lowest price.
        :param pulumi.Input[_builtins.bool] spot_instance_remedy: Whether to replace spot instances with newly created spot/onDemand instance when receive a spot recycling message.
        :param pulumi.Input[_builtins.int] stop_instance_timeout: The period of time required by the ECS instance to enter the Stopped state. Unit: seconds. Valid values: 30 to 240.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
               - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
               - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
        :param pulumi.Input[_builtins.str] vswitch_id: It has been deprecated from version 1.7.1 and new field 'vswitch_ids' replaces it.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] vswitch_ids: List of virtual switch IDs in which the ecs instances to be launched.
        """
        if alb_server_groups is not None:
            pulumi.set(__self__, "alb_server_groups", alb_server_groups)
        if allocation_strategy is not None:
            pulumi.set(__self__, "allocation_strategy", allocation_strategy)
        if az_balance is not None:
            pulumi.set(__self__, "az_balance", az_balance)
        if capacity_options_compensate_with_on_demand is not None:
            pulumi.set(__self__, "capacity_options_compensate_with_on_demand", capacity_options_compensate_with_on_demand)
        if capacity_options_on_demand_base_capacity is not None:
            pulumi.set(__self__, "capacity_options_on_demand_base_capacity", capacity_options_on_demand_base_capacity)
        if capacity_options_on_demand_percentage_above_base_capacity is not None:
            pulumi.set(__self__, "capacity_options_on_demand_percentage_above_base_capacity", capacity_options_on_demand_percentage_above_base_capacity)
        if capacity_options_price_comparison_mode is not None:
            pulumi.set(__self__, "capacity_options_price_comparison_mode", capacity_options_price_comparison_mode)
        if capacity_options_spot_auto_replace_on_demand is not None:
            pulumi.set(__self__, "capacity_options_spot_auto_replace_on_demand", capacity_options_spot_auto_replace_on_demand)
        if compensate_with_on_demand is not None:
            pulumi.set(__self__, "compensate_with_on_demand", compensate_with_on_demand)
        if container_group_id is not None:
            pulumi.set(__self__, "container_group_id", container_group_id)
        if db_instance_ids is not None:
            pulumi.set(__self__, "db_instance_ids", db_instance_ids)
        if default_cooldown is not None:
            pulumi.set(__self__, "default_cooldown", default_cooldown)
        if desired_capacity is not None:
            pulumi.set(__self__, "desired_capacity", desired_capacity)
        if group_deletion_protection is not None:
            pulumi.set(__self__, "group_deletion_protection", group_deletion_protection)
        if group_type is not None:
            pulumi.set(__self__, "group_type", group_type)
        if health_check_type is not None:
            pulumi.set(__self__, "health_check_type", health_check_type)
        if health_check_types is not None:
            pulumi.set(__self__, "health_check_types", health_check_types)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if launch_template_id is not None:
            pulumi.set(__self__, "launch_template_id", launch_template_id)
        if launch_template_overrides is not None:
            pulumi.set(__self__, "launch_template_overrides", launch_template_overrides)
        if launch_template_version is not None:
            pulumi.set(__self__, "launch_template_version", launch_template_version)
        if loadbalancer_ids is not None:
            pulumi.set(__self__, "loadbalancer_ids", loadbalancer_ids)
        if max_instance_lifetime is not None:
            pulumi.set(__self__, "max_instance_lifetime", max_instance_lifetime)
        if max_size is not None:
            pulumi.set(__self__, "max_size", max_size)
        if min_size is not None:
            pulumi.set(__self__, "min_size", min_size)
        if multi_az_policy is not None:
            pulumi.set(__self__, "multi_az_policy", multi_az_policy)
        if on_demand_base_capacity is not None:
            pulumi.set(__self__, "on_demand_base_capacity", on_demand_base_capacity)
        if on_demand_percentage_above_base_capacity is not None:
            pulumi.set(__self__, "on_demand_percentage_above_base_capacity", on_demand_percentage_above_base_capacity)
        if protected_instances is not None:
            pulumi.set(__self__, "protected_instances", protected_instances)
        if removal_policies is not None:
            pulumi.set(__self__, "removal_policies", removal_policies)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if scaling_group_name is not None:
            pulumi.set(__self__, "scaling_group_name", scaling_group_name)
        if scaling_policy is not None:
            pulumi.set(__self__, "scaling_policy", scaling_policy)
        if spot_allocation_strategy is not None:
            pulumi.set(__self__, "spot_allocation_strategy", spot_allocation_strategy)
        if spot_instance_pools is not None:
            pulumi.set(__self__, "spot_instance_pools", spot_instance_pools)
        if spot_instance_remedy is not None:
            pulumi.set(__self__, "spot_instance_remedy", spot_instance_remedy)
        if stop_instance_timeout is not None:
            pulumi.set(__self__, "stop_instance_timeout", stop_instance_timeout)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vswitch_id is not None:
            warnings.warn("""Field 'vswitch_id' has been deprecated from provider version 1.7.1, and new field 'vswitch_ids' can replace it.""", DeprecationWarning)
            pulumi.log.warn("""vswitch_id is deprecated: Field 'vswitch_id' has been deprecated from provider version 1.7.1, and new field 'vswitch_ids' can replace it.""")
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)
        if vswitch_ids is not None:
            pulumi.set(__self__, "vswitch_ids", vswitch_ids)

    @_builtins.property
    @pulumi.getter(name="albServerGroups")
    def alb_server_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ScalingGroupAlbServerGroupArgs']]]]:
        """
        If a Serve ALB instance is specified in the scaling group, the scaling group automatically attaches its ECS instances to the Server ALB instance.  See `alb_server_group` below for details.
        """
        return pulumi.get(self, "alb_server_groups")

    @alb_server_groups.setter
    def alb_server_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ScalingGroupAlbServerGroupArgs']]]]):
        pulumi.set(self, "alb_server_groups", value)

    @_builtins.property
    @pulumi.getter(name="allocationStrategy")
    def allocation_strategy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The allocation policy of instances. Auto Scaling selects instance types based on the allocation policy to create instances. The policy can be applied to pay-as-you-go instances and preemptible instances. This parameter takes effect only if you set MultiAZPolicy to COMPOSABLE.
        """
        return pulumi.get(self, "allocation_strategy")

    @allocation_strategy.setter
    def allocation_strategy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "allocation_strategy", value)

    @_builtins.property
    @pulumi.getter(name="azBalance")
    def az_balance(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to evenly distribute instances in the scaling group across multiple zones. This parameter takes effect only if you set MultiAZPolicy to COMPOSABLE.
        """
        return pulumi.get(self, "az_balance")

    @az_balance.setter
    def az_balance(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "az_balance", value)

    @_builtins.property
    @pulumi.getter(name="capacityOptionsCompensateWithOnDemand")
    def capacity_options_compensate_with_on_demand(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to automatically create pay-as-you-go instances to meet the requirement on the number of ECS instances when the expected capacity of preemptible instances cannot be provided due to reasons such as cost-related issues and insufficient resources. This parameter is supported only if you set 'multi_az_policy' to COST_OPTIMIZED. Valid values: true, false.
        """
        return pulumi.get(self, "capacity_options_compensate_with_on_demand")

    @capacity_options_compensate_with_on_demand.setter
    def capacity_options_compensate_with_on_demand(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "capacity_options_compensate_with_on_demand", value)

    @_builtins.property
    @pulumi.getter(name="capacityOptionsOnDemandBaseCapacity")
    def capacity_options_on_demand_base_capacity(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The minimum number of pay-as-you-go instances that must be contained in the scaling group. When the actual number of pay-as-you-go instances in the scaling group drops below the value of this parameter, Auto Scaling preferentially creates pay-as-you-go instances. Valid values: 0 to 1000. If you set 'multi_az_policy' to COMPOSABLE, the default value of this parameter is 0.
        """
        return pulumi.get(self, "capacity_options_on_demand_base_capacity")

    @capacity_options_on_demand_base_capacity.setter
    def capacity_options_on_demand_base_capacity(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "capacity_options_on_demand_base_capacity", value)

    @_builtins.property
    @pulumi.getter(name="capacityOptionsOnDemandPercentageAboveBaseCapacity")
    def capacity_options_on_demand_percentage_above_base_capacity(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The percentage of pay-as-you-go instances in the excess instances when the minimum number of pay-as-you-go instances is reached. 'on_demand_base_capacity' specifies the minimum number of pay-as-you-go instances that must be contained in the scaling group. Valid values: 0 to 100. If you set 'multi_az_policy' to COMPOSABLE, the default value of this parameter is 100.
        """
        return pulumi.get(self, "capacity_options_on_demand_percentage_above_base_capacity")

    @capacity_options_on_demand_percentage_above_base_capacity.setter
    def capacity_options_on_demand_percentage_above_base_capacity(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "capacity_options_on_demand_percentage_above_base_capacity", value)

    @_builtins.property
    @pulumi.getter(name="capacityOptionsPriceComparisonMode")
    def capacity_options_price_comparison_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The price comparison mode. Valid values: PricePerUnit,PricePerVCpu. Default value: PricePerUnit.
        """
        return pulumi.get(self, "capacity_options_price_comparison_mode")

    @capacity_options_price_comparison_mode.setter
    def capacity_options_price_comparison_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "capacity_options_price_comparison_mode", value)

    @_builtins.property
    @pulumi.getter(name="capacityOptionsSpotAutoReplaceOnDemand")
    def capacity_options_spot_auto_replace_on_demand(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to replace pay-as-you-go instances with preemptible instances. If you specify 'compensate_with_on_demand', it may result in a higher percentage of pay-as-you-go instances compared to the value of 'on_demand_percentage_above_base_capacity'. If you specify this parameter, Auto Scaling preferentially deploys preemptible instances to replace the surplus pay-as-you-go instances when preemptible instance types are available. If you specify 'compensate_with_on_demand', Auto Scaling creates pay-as-you-go instances when preemptible instance types are insufficient. To avoid retaining these pay-as-you-go instances for extended periods, Auto Scaling attempts to replace them with preemptible instances when sufficient preemptible instance types become available. Valid values: true, false.
        """
        return pulumi.get(self, "capacity_options_spot_auto_replace_on_demand")

    @capacity_options_spot_auto_replace_on_demand.setter
    def capacity_options_spot_auto_replace_on_demand(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "capacity_options_spot_auto_replace_on_demand", value)

    @_builtins.property
    @pulumi.getter(name="compensateWithOnDemand")
    def compensate_with_on_demand(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to automatically create pay-as-you-go instances to meet the requirement on the number of ECS instances when the expected capacity of preemptible instances cannot be provided due to reasons such as cost-related issues and insufficient resources. This parameter is supported only if you set 'multi_az_policy' to COST_OPTIMIZED. Valid values: true, false.
        """
        return pulumi.get(self, "compensate_with_on_demand")

    @compensate_with_on_demand.setter
    def compensate_with_on_demand(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "compensate_with_on_demand", value)

    @_builtins.property
    @pulumi.getter(name="containerGroupId")
    def container_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the elastic container instance.
        """
        return pulumi.get(self, "container_group_id")

    @container_group_id.setter
    def container_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "container_group_id", value)

    @_builtins.property
    @pulumi.getter(name="dbInstanceIds")
    def db_instance_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        If an RDS instance is specified in the scaling group, the scaling group automatically attaches the Intranet IP addresses of its ECS instances to the RDS access whitelist.
        - The specified RDS instance must be in running status.
        - The specified RDS instance’s whitelist must have room for more IP addresses.
        """
        return pulumi.get(self, "db_instance_ids")

    @db_instance_ids.setter
    def db_instance_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "db_instance_ids", value)

    @_builtins.property
    @pulumi.getter(name="defaultCooldown")
    def default_cooldown(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Default cool-down time (in seconds) of the scaling group. Value range: [0, 86400]. The default value is 300s.
        """
        return pulumi.get(self, "default_cooldown")

    @default_cooldown.setter
    def default_cooldown(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "default_cooldown", value)

    @_builtins.property
    @pulumi.getter(name="desiredCapacity")
    def desired_capacity(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Expected number of ECS instances in the scaling group. Value range: [min_size, max_size].
        """
        return pulumi.get(self, "desired_capacity")

    @desired_capacity.setter
    def desired_capacity(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "desired_capacity", value)

    @_builtins.property
    @pulumi.getter(name="groupDeletionProtection")
    def group_deletion_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether the scaling group deletion protection is enabled. `true` or `false`, Default value: `false`.
        """
        return pulumi.get(self, "group_deletion_protection")

    @group_deletion_protection.setter
    def group_deletion_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "group_deletion_protection", value)

    @_builtins.property
    @pulumi.getter(name="groupType")
    def group_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource type within scaling group. Optional values: ECS, ECI. Default to ECS.
        """
        return pulumi.get(self, "group_type")

    @group_type.setter
    def group_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group_type", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckType")
    def health_check_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource type within scaling group. Optional values: ECS, ECI, NONE, LOAD_BALANCER. Default to ECS.
        """
        return pulumi.get(self, "health_check_type")

    @health_check_type.setter
    def health_check_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "health_check_type", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckTypes")
    def health_check_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The health check modes of the scaling group. Valid values: ECS, NONE, LOAD_BALANCER.
        """
        return pulumi.get(self, "health_check_types")

    @health_check_types.setter
    def health_check_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "health_check_types", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the instance from which Auto Scaling obtains the required configuration information and uses the information to automatically create a scaling configuration.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="launchTemplateId")
    def launch_template_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instance launch template ID, scaling group obtains launch configuration from instance launch template, see [Launch Template](https://www.alibabacloud.com/help/doc-detail/73916.html). Creating scaling group from launch template enable group automatically.
        """
        return pulumi.get(self, "launch_template_id")

    @launch_template_id.setter
    def launch_template_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "launch_template_id", value)

    @_builtins.property
    @pulumi.getter(name="launchTemplateOverrides")
    def launch_template_overrides(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ScalingGroupLaunchTemplateOverrideArgs']]]]:
        """
        The details of the instance types that are specified by using the Extend Instance Type of Launch Template feature.  See `launch_template_override` below for details.
        """
        return pulumi.get(self, "launch_template_overrides")

    @launch_template_overrides.setter
    def launch_template_overrides(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ScalingGroupLaunchTemplateOverrideArgs']]]]):
        pulumi.set(self, "launch_template_overrides", value)

    @_builtins.property
    @pulumi.getter(name="launchTemplateVersion")
    def launch_template_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version number of the launch template. Valid values are the version number, `Latest`, or `Default`, Default value: `Default`.
        """
        return pulumi.get(self, "launch_template_version")

    @launch_template_version.setter
    def launch_template_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "launch_template_version", value)

    @_builtins.property
    @pulumi.getter(name="loadbalancerIds")
    def loadbalancer_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        If a Server Load Balancer instance is specified in the scaling group, the scaling group automatically attaches its ECS instances to the Server Load Balancer instance.
        - The Server Load Balancer instance must be enabled.
        - At least one listener must be configured for each Server Load Balancer and it HealthCheck must be on. Otherwise, creation will fail (it may be useful to add a `depends_on` argument
        targeting your `slb.Listener` in order to make sure the listener with its HealthCheck configuration is ready before creating your scaling group).
        - The Server Load Balancer instance attached with VPC-type ECS instances cannot be attached to the scaling group.
        - The default weight of an ECS instance attached to the Server Load Balancer instance is 50.
        """
        return pulumi.get(self, "loadbalancer_ids")

    @loadbalancer_ids.setter
    def loadbalancer_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "loadbalancer_ids", value)

    @_builtins.property
    @pulumi.getter(name="maxInstanceLifetime")
    def max_instance_lifetime(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum life span of an instance in the scaling group. Unit: seconds.
        """
        return pulumi.get(self, "max_instance_lifetime")

    @max_instance_lifetime.setter
    def max_instance_lifetime(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_instance_lifetime", value)

    @_builtins.property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum number of ECS instances in the scaling group. Value range: [0, 2000].
        **NOTE:** From version 1.204.1, `max_size` can be set to `2000`.
        """
        return pulumi.get(self, "max_size")

    @max_size.setter
    def max_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_size", value)

    @_builtins.property
    @pulumi.getter(name="minSize")
    def min_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Minimum number of ECS instances in the scaling group. Value range: [0, 2000].
        **NOTE:** From version 1.204.1, `min_size` can be set to `2000`.
        """
        return pulumi.get(self, "min_size")

    @min_size.setter
    def min_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_size", value)

    @_builtins.property
    @pulumi.getter(name="multiAzPolicy")
    def multi_az_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Multi-AZ scaling group ECS instance expansion and contraction strategy. PRIORITY, COMPOSABLE, BALANCE or COST_OPTIMIZED(Available since v1.54.0).
        """
        return pulumi.get(self, "multi_az_policy")

    @multi_az_policy.setter
    def multi_az_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "multi_az_policy", value)

    @_builtins.property
    @pulumi.getter(name="onDemandBaseCapacity")
    def on_demand_base_capacity(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The minimum amount of the Auto Scaling group's capacity that must be fulfilled by On-Demand Instances. This base portion is provisioned first as your group scales.
        """
        return pulumi.get(self, "on_demand_base_capacity")

    @on_demand_base_capacity.setter
    def on_demand_base_capacity(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "on_demand_base_capacity", value)

    @_builtins.property
    @pulumi.getter(name="onDemandPercentageAboveBaseCapacity")
    def on_demand_percentage_above_base_capacity(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Controls the percentages of On-Demand Instances and Spot Instances for your additional capacity beyond OnDemandBaseCapacity.
        """
        return pulumi.get(self, "on_demand_percentage_above_base_capacity")

    @on_demand_percentage_above_base_capacity.setter
    def on_demand_percentage_above_base_capacity(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "on_demand_percentage_above_base_capacity", value)

    @_builtins.property
    @pulumi.getter(name="protectedInstances")
    def protected_instances(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Set or unset instances within group into protected status.
        """
        return pulumi.get(self, "protected_instances")

    @protected_instances.setter
    def protected_instances(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "protected_instances", value)

    @_builtins.property
    @pulumi.getter(name="removalPolicies")
    def removal_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        RemovalPolicy is used to select the ECS instances you want to remove from the scaling group when multiple candidates for removal exist. Optional values:
        - OldestInstance: removes the ECS instance that is added to the scaling group at the earliest point in time.
        - NewestInstance: removes the ECS instance that is added to the scaling group at the latest point in time.
        - OldestScalingConfiguration: removes the ECS instance that is created based on the earliest scaling configuration.
        - Default values: Default value of RemovalPolicy.1: OldestScalingConfiguration. Default value of RemovalPolicy.2: OldestInstance.
        """
        return pulumi.get(self, "removal_policies")

    @removal_policies.setter
    def removal_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "removal_policies", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group to which you want to add the scaling group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="scalingGroupName")
    def scaling_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name shown for the scaling group, which must contain 2-64 characters (English or Chinese), starting with numbers, English letters or Chinese characters, and can contain numbers, underscores `_`, hyphens `-`, and decimal points `.`. If this parameter is not specified, the default value is ScalingGroupId.
        """
        return pulumi.get(self, "scaling_group_name")

    @scaling_group_name.setter
    def scaling_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scaling_group_name", value)

    @_builtins.property
    @pulumi.getter(name="scalingPolicy")
    def scaling_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The reclaim mode of the scaling group. Optional values: recycle, release, forceRecycle, forceRelease.
        """
        return pulumi.get(self, "scaling_policy")

    @scaling_policy.setter
    def scaling_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scaling_policy", value)

    @_builtins.property
    @pulumi.getter(name="spotAllocationStrategy")
    def spot_allocation_strategy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The allocation policy of preemptible instances. You can use this parameter to individually specify the allocation policy for preemptible instances. This parameter takes effect only if you set MultiAZPolicy to COMPOSABLE.
        """
        return pulumi.get(self, "spot_allocation_strategy")

    @spot_allocation_strategy.setter
    def spot_allocation_strategy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "spot_allocation_strategy", value)

    @_builtins.property
    @pulumi.getter(name="spotInstancePools")
    def spot_instance_pools(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of Spot pools to use to allocate your Spot capacity. The Spot pools is composed of instance types of lowest price.
        """
        return pulumi.get(self, "spot_instance_pools")

    @spot_instance_pools.setter
    def spot_instance_pools(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "spot_instance_pools", value)

    @_builtins.property
    @pulumi.getter(name="spotInstanceRemedy")
    def spot_instance_remedy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to replace spot instances with newly created spot/onDemand instance when receive a spot recycling message.
        """
        return pulumi.get(self, "spot_instance_remedy")

    @spot_instance_remedy.setter
    def spot_instance_remedy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "spot_instance_remedy", value)

    @_builtins.property
    @pulumi.getter(name="stopInstanceTimeout")
    def stop_instance_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The period of time required by the ECS instance to enter the Stopped state. Unit: seconds. Valid values: 30 to 240.
        """
        return pulumi.get(self, "stop_instance_timeout")

    @stop_instance_timeout.setter
    def stop_instance_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "stop_instance_timeout", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
        - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    @_utilities.deprecated("""Field 'vswitch_id' has been deprecated from provider version 1.7.1, and new field 'vswitch_ids' can replace it.""")
    def vswitch_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        It has been deprecated from version 1.7.1 and new field 'vswitch_ids' replaces it.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vswitch_id", value)

    @_builtins.property
    @pulumi.getter(name="vswitchIds")
    def vswitch_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of virtual switch IDs in which the ecs instances to be launched.
        """
        return pulumi.get(self, "vswitch_ids")

    @vswitch_ids.setter
    def vswitch_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "vswitch_ids", value)


@pulumi.type_token("alicloud:ess/scalingGroup:ScalingGroup")
class ScalingGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alb_server_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ScalingGroupAlbServerGroupArgs', 'ScalingGroupAlbServerGroupArgsDict']]]]] = None,
                 allocation_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 az_balance: Optional[pulumi.Input[_builtins.bool]] = None,
                 capacity_options_compensate_with_on_demand: Optional[pulumi.Input[_builtins.bool]] = None,
                 capacity_options_on_demand_base_capacity: Optional[pulumi.Input[_builtins.int]] = None,
                 capacity_options_on_demand_percentage_above_base_capacity: Optional[pulumi.Input[_builtins.int]] = None,
                 capacity_options_price_comparison_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 capacity_options_spot_auto_replace_on_demand: Optional[pulumi.Input[_builtins.bool]] = None,
                 compensate_with_on_demand: Optional[pulumi.Input[_builtins.bool]] = None,
                 container_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 db_instance_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 default_cooldown: Optional[pulumi.Input[_builtins.int]] = None,
                 desired_capacity: Optional[pulumi.Input[_builtins.int]] = None,
                 group_deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 group_type: Optional[pulumi.Input[_builtins.str]] = None,
                 health_check_type: Optional[pulumi.Input[_builtins.str]] = None,
                 health_check_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 launch_template_id: Optional[pulumi.Input[_builtins.str]] = None,
                 launch_template_overrides: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ScalingGroupLaunchTemplateOverrideArgs', 'ScalingGroupLaunchTemplateOverrideArgsDict']]]]] = None,
                 launch_template_version: Optional[pulumi.Input[_builtins.str]] = None,
                 loadbalancer_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 max_instance_lifetime: Optional[pulumi.Input[_builtins.int]] = None,
                 max_size: Optional[pulumi.Input[_builtins.int]] = None,
                 min_size: Optional[pulumi.Input[_builtins.int]] = None,
                 multi_az_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 on_demand_base_capacity: Optional[pulumi.Input[_builtins.int]] = None,
                 on_demand_percentage_above_base_capacity: Optional[pulumi.Input[_builtins.int]] = None,
                 protected_instances: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 removal_policies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 scaling_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 scaling_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 spot_allocation_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 spot_instance_pools: Optional[pulumi.Input[_builtins.int]] = None,
                 spot_instance_remedy: Optional[pulumi.Input[_builtins.bool]] = None,
                 stop_instance_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Provides a ESS scaling group resource which is a collection of ECS instances with the same application scenarios.

        It defines the maximum and minimum numbers of ECS instances in the group, and their associated Server Load Balancer instances, RDS instances, and other attributes.

        > **NOTE:** You can launch an ESS scaling group for a VPC network via specifying parameter `vswitch_ids`.

        For information about ess scaling rule, see [CreateScalingGroup](https://www.alibabacloud.com/help/en/auto-scaling/latest/createscalinggroup).

        > **NOTE:** Available since v1.39.0.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default_integer = random.index.Integer("default",
            min=10000,
            max=99999)
        my_name = f"{name}-{default_integer['result']}"
        default = alicloud.get_zones(available_disk_category="cloud_efficiency",
            available_resource_creation="VSwitch")
        default_get_instance_types = alicloud.ecs.get_instance_types(availability_zone=default.zones[0].id,
            cpu_core_count=2,
            memory_size=4)
        default_get_images = alicloud.ecs.get_images(name_regex="^ubuntu_18.*64",
            most_recent=True,
            owners="system")
        default_network = alicloud.vpc.Network("default",
            vpc_name=my_name,
            cidr_block="172.16.0.0/16")
        default_switch = alicloud.vpc.Switch("default",
            vpc_id=default_network.id,
            cidr_block="172.16.0.0/24",
            zone_id=default.zones[0].id,
            vswitch_name=my_name)
        default_security_group = alicloud.ecs.SecurityGroup("default",
            security_group_name=my_name,
            vpc_id=default_network.id)
        default_security_group_rule = alicloud.ecs.SecurityGroupRule("default",
            type="ingress",
            ip_protocol="tcp",
            nic_type="intranet",
            policy="accept",
            port_range="22/22",
            priority=1,
            security_group_id=default_security_group.id,
            cidr_ip="172.16.0.0/24")
        default2 = alicloud.vpc.Switch("default2",
            vpc_id=default_network.id,
            cidr_block="172.16.1.0/24",
            zone_id=default.zones[0].id,
            vswitch_name=f"{name}-bar")
        default_scaling_group = alicloud.ess.ScalingGroup("default",
            min_size=1,
            max_size=1,
            scaling_group_name=my_name,
            default_cooldown=20,
            vswitch_ids=[
                default_switch.id,
                default2.id,
            ],
            removal_policies=[
                "OldestInstance",
                "NewestInstance",
            ])
        ```

        ## Module Support

        You can use to the existing autoscaling module
        to create a scaling group, configuration and lifecycle hook one-click.

        ## Import

        ESS scaling group can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ess/scalingGroup:ScalingGroup example asg-abc123456
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ScalingGroupAlbServerGroupArgs', 'ScalingGroupAlbServerGroupArgsDict']]]] alb_server_groups: If a Serve ALB instance is specified in the scaling group, the scaling group automatically attaches its ECS instances to the Server ALB instance.  See `alb_server_group` below for details.
        :param pulumi.Input[_builtins.str] allocation_strategy: The allocation policy of instances. Auto Scaling selects instance types based on the allocation policy to create instances. The policy can be applied to pay-as-you-go instances and preemptible instances. This parameter takes effect only if you set MultiAZPolicy to COMPOSABLE.
        :param pulumi.Input[_builtins.bool] az_balance: Specifies whether to evenly distribute instances in the scaling group across multiple zones. This parameter takes effect only if you set MultiAZPolicy to COMPOSABLE.
        :param pulumi.Input[_builtins.bool] capacity_options_compensate_with_on_demand: Specifies whether to automatically create pay-as-you-go instances to meet the requirement on the number of ECS instances when the expected capacity of preemptible instances cannot be provided due to reasons such as cost-related issues and insufficient resources. This parameter is supported only if you set 'multi_az_policy' to COST_OPTIMIZED. Valid values: true, false.
        :param pulumi.Input[_builtins.int] capacity_options_on_demand_base_capacity: The minimum number of pay-as-you-go instances that must be contained in the scaling group. When the actual number of pay-as-you-go instances in the scaling group drops below the value of this parameter, Auto Scaling preferentially creates pay-as-you-go instances. Valid values: 0 to 1000. If you set 'multi_az_policy' to COMPOSABLE, the default value of this parameter is 0.
        :param pulumi.Input[_builtins.int] capacity_options_on_demand_percentage_above_base_capacity: The percentage of pay-as-you-go instances in the excess instances when the minimum number of pay-as-you-go instances is reached. 'on_demand_base_capacity' specifies the minimum number of pay-as-you-go instances that must be contained in the scaling group. Valid values: 0 to 100. If you set 'multi_az_policy' to COMPOSABLE, the default value of this parameter is 100.
        :param pulumi.Input[_builtins.str] capacity_options_price_comparison_mode: The price comparison mode. Valid values: PricePerUnit,PricePerVCpu. Default value: PricePerUnit.
        :param pulumi.Input[_builtins.bool] capacity_options_spot_auto_replace_on_demand: Specifies whether to replace pay-as-you-go instances with preemptible instances. If you specify 'compensate_with_on_demand', it may result in a higher percentage of pay-as-you-go instances compared to the value of 'on_demand_percentage_above_base_capacity'. If you specify this parameter, Auto Scaling preferentially deploys preemptible instances to replace the surplus pay-as-you-go instances when preemptible instance types are available. If you specify 'compensate_with_on_demand', Auto Scaling creates pay-as-you-go instances when preemptible instance types are insufficient. To avoid retaining these pay-as-you-go instances for extended periods, Auto Scaling attempts to replace them with preemptible instances when sufficient preemptible instance types become available. Valid values: true, false.
        :param pulumi.Input[_builtins.bool] compensate_with_on_demand: Specifies whether to automatically create pay-as-you-go instances to meet the requirement on the number of ECS instances when the expected capacity of preemptible instances cannot be provided due to reasons such as cost-related issues and insufficient resources. This parameter is supported only if you set 'multi_az_policy' to COST_OPTIMIZED. Valid values: true, false.
        :param pulumi.Input[_builtins.str] container_group_id: The ID of the elastic container instance.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] db_instance_ids: If an RDS instance is specified in the scaling group, the scaling group automatically attaches the Intranet IP addresses of its ECS instances to the RDS access whitelist.
               - The specified RDS instance must be in running status.
               - The specified RDS instance’s whitelist must have room for more IP addresses.
        :param pulumi.Input[_builtins.int] default_cooldown: Default cool-down time (in seconds) of the scaling group. Value range: [0, 86400]. The default value is 300s.
        :param pulumi.Input[_builtins.int] desired_capacity: Expected number of ECS instances in the scaling group. Value range: [min_size, max_size].
        :param pulumi.Input[_builtins.bool] group_deletion_protection: Specifies whether the scaling group deletion protection is enabled. `true` or `false`, Default value: `false`.
        :param pulumi.Input[_builtins.str] group_type: Resource type within scaling group. Optional values: ECS, ECI. Default to ECS.
        :param pulumi.Input[_builtins.str] health_check_type: Resource type within scaling group. Optional values: ECS, ECI, NONE, LOAD_BALANCER. Default to ECS.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] health_check_types: The health check modes of the scaling group. Valid values: ECS, NONE, LOAD_BALANCER.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the instance from which Auto Scaling obtains the required configuration information and uses the information to automatically create a scaling configuration.
        :param pulumi.Input[_builtins.str] launch_template_id: Instance launch template ID, scaling group obtains launch configuration from instance launch template, see [Launch Template](https://www.alibabacloud.com/help/doc-detail/73916.html). Creating scaling group from launch template enable group automatically.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ScalingGroupLaunchTemplateOverrideArgs', 'ScalingGroupLaunchTemplateOverrideArgsDict']]]] launch_template_overrides: The details of the instance types that are specified by using the Extend Instance Type of Launch Template feature.  See `launch_template_override` below for details.
        :param pulumi.Input[_builtins.str] launch_template_version: The version number of the launch template. Valid values are the version number, `Latest`, or `Default`, Default value: `Default`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] loadbalancer_ids: If a Server Load Balancer instance is specified in the scaling group, the scaling group automatically attaches its ECS instances to the Server Load Balancer instance.
               - The Server Load Balancer instance must be enabled.
               - At least one listener must be configured for each Server Load Balancer and it HealthCheck must be on. Otherwise, creation will fail (it may be useful to add a `depends_on` argument
               targeting your `slb.Listener` in order to make sure the listener with its HealthCheck configuration is ready before creating your scaling group).
               - The Server Load Balancer instance attached with VPC-type ECS instances cannot be attached to the scaling group.
               - The default weight of an ECS instance attached to the Server Load Balancer instance is 50.
        :param pulumi.Input[_builtins.int] max_instance_lifetime: The maximum life span of an instance in the scaling group. Unit: seconds.
        :param pulumi.Input[_builtins.int] max_size: Maximum number of ECS instances in the scaling group. Value range: [0, 2000].
               **NOTE:** From version 1.204.1, `max_size` can be set to `2000`.
        :param pulumi.Input[_builtins.int] min_size: Minimum number of ECS instances in the scaling group. Value range: [0, 2000].
               **NOTE:** From version 1.204.1, `min_size` can be set to `2000`.
        :param pulumi.Input[_builtins.str] multi_az_policy: Multi-AZ scaling group ECS instance expansion and contraction strategy. PRIORITY, COMPOSABLE, BALANCE or COST_OPTIMIZED(Available since v1.54.0).
        :param pulumi.Input[_builtins.int] on_demand_base_capacity: The minimum amount of the Auto Scaling group's capacity that must be fulfilled by On-Demand Instances. This base portion is provisioned first as your group scales.
        :param pulumi.Input[_builtins.int] on_demand_percentage_above_base_capacity: Controls the percentages of On-Demand Instances and Spot Instances for your additional capacity beyond OnDemandBaseCapacity.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] protected_instances: Set or unset instances within group into protected status.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] removal_policies: RemovalPolicy is used to select the ECS instances you want to remove from the scaling group when multiple candidates for removal exist. Optional values:
               - OldestInstance: removes the ECS instance that is added to the scaling group at the earliest point in time.
               - NewestInstance: removes the ECS instance that is added to the scaling group at the latest point in time.
               - OldestScalingConfiguration: removes the ECS instance that is created based on the earliest scaling configuration.
               - Default values: Default value of RemovalPolicy.1: OldestScalingConfiguration. Default value of RemovalPolicy.2: OldestInstance.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group to which you want to add the scaling group.
        :param pulumi.Input[_builtins.str] scaling_group_name: Name shown for the scaling group, which must contain 2-64 characters (English or Chinese), starting with numbers, English letters or Chinese characters, and can contain numbers, underscores `_`, hyphens `-`, and decimal points `.`. If this parameter is not specified, the default value is ScalingGroupId.
        :param pulumi.Input[_builtins.str] scaling_policy: The reclaim mode of the scaling group. Optional values: recycle, release, forceRecycle, forceRelease.
        :param pulumi.Input[_builtins.str] spot_allocation_strategy: The allocation policy of preemptible instances. You can use this parameter to individually specify the allocation policy for preemptible instances. This parameter takes effect only if you set MultiAZPolicy to COMPOSABLE.
        :param pulumi.Input[_builtins.int] spot_instance_pools: The number of Spot pools to use to allocate your Spot capacity. The Spot pools is composed of instance types of lowest price.
        :param pulumi.Input[_builtins.bool] spot_instance_remedy: Whether to replace spot instances with newly created spot/onDemand instance when receive a spot recycling message.
        :param pulumi.Input[_builtins.int] stop_instance_timeout: The period of time required by the ECS instance to enter the Stopped state. Unit: seconds. Valid values: 30 to 240.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
               - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
               - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
        :param pulumi.Input[_builtins.str] vswitch_id: It has been deprecated from version 1.7.1 and new field 'vswitch_ids' replaces it.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] vswitch_ids: List of virtual switch IDs in which the ecs instances to be launched.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ScalingGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a ESS scaling group resource which is a collection of ECS instances with the same application scenarios.

        It defines the maximum and minimum numbers of ECS instances in the group, and their associated Server Load Balancer instances, RDS instances, and other attributes.

        > **NOTE:** You can launch an ESS scaling group for a VPC network via specifying parameter `vswitch_ids`.

        For information about ess scaling rule, see [CreateScalingGroup](https://www.alibabacloud.com/help/en/auto-scaling/latest/createscalinggroup).

        > **NOTE:** Available since v1.39.0.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default_integer = random.index.Integer("default",
            min=10000,
            max=99999)
        my_name = f"{name}-{default_integer['result']}"
        default = alicloud.get_zones(available_disk_category="cloud_efficiency",
            available_resource_creation="VSwitch")
        default_get_instance_types = alicloud.ecs.get_instance_types(availability_zone=default.zones[0].id,
            cpu_core_count=2,
            memory_size=4)
        default_get_images = alicloud.ecs.get_images(name_regex="^ubuntu_18.*64",
            most_recent=True,
            owners="system")
        default_network = alicloud.vpc.Network("default",
            vpc_name=my_name,
            cidr_block="172.16.0.0/16")
        default_switch = alicloud.vpc.Switch("default",
            vpc_id=default_network.id,
            cidr_block="172.16.0.0/24",
            zone_id=default.zones[0].id,
            vswitch_name=my_name)
        default_security_group = alicloud.ecs.SecurityGroup("default",
            security_group_name=my_name,
            vpc_id=default_network.id)
        default_security_group_rule = alicloud.ecs.SecurityGroupRule("default",
            type="ingress",
            ip_protocol="tcp",
            nic_type="intranet",
            policy="accept",
            port_range="22/22",
            priority=1,
            security_group_id=default_security_group.id,
            cidr_ip="172.16.0.0/24")
        default2 = alicloud.vpc.Switch("default2",
            vpc_id=default_network.id,
            cidr_block="172.16.1.0/24",
            zone_id=default.zones[0].id,
            vswitch_name=f"{name}-bar")
        default_scaling_group = alicloud.ess.ScalingGroup("default",
            min_size=1,
            max_size=1,
            scaling_group_name=my_name,
            default_cooldown=20,
            vswitch_ids=[
                default_switch.id,
                default2.id,
            ],
            removal_policies=[
                "OldestInstance",
                "NewestInstance",
            ])
        ```

        ## Module Support

        You can use to the existing autoscaling module
        to create a scaling group, configuration and lifecycle hook one-click.

        ## Import

        ESS scaling group can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ess/scalingGroup:ScalingGroup example asg-abc123456
        ```

        :param str resource_name: The name of the resource.
        :param ScalingGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ScalingGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alb_server_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ScalingGroupAlbServerGroupArgs', 'ScalingGroupAlbServerGroupArgsDict']]]]] = None,
                 allocation_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 az_balance: Optional[pulumi.Input[_builtins.bool]] = None,
                 capacity_options_compensate_with_on_demand: Optional[pulumi.Input[_builtins.bool]] = None,
                 capacity_options_on_demand_base_capacity: Optional[pulumi.Input[_builtins.int]] = None,
                 capacity_options_on_demand_percentage_above_base_capacity: Optional[pulumi.Input[_builtins.int]] = None,
                 capacity_options_price_comparison_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 capacity_options_spot_auto_replace_on_demand: Optional[pulumi.Input[_builtins.bool]] = None,
                 compensate_with_on_demand: Optional[pulumi.Input[_builtins.bool]] = None,
                 container_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 db_instance_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 default_cooldown: Optional[pulumi.Input[_builtins.int]] = None,
                 desired_capacity: Optional[pulumi.Input[_builtins.int]] = None,
                 group_deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 group_type: Optional[pulumi.Input[_builtins.str]] = None,
                 health_check_type: Optional[pulumi.Input[_builtins.str]] = None,
                 health_check_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 launch_template_id: Optional[pulumi.Input[_builtins.str]] = None,
                 launch_template_overrides: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ScalingGroupLaunchTemplateOverrideArgs', 'ScalingGroupLaunchTemplateOverrideArgsDict']]]]] = None,
                 launch_template_version: Optional[pulumi.Input[_builtins.str]] = None,
                 loadbalancer_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 max_instance_lifetime: Optional[pulumi.Input[_builtins.int]] = None,
                 max_size: Optional[pulumi.Input[_builtins.int]] = None,
                 min_size: Optional[pulumi.Input[_builtins.int]] = None,
                 multi_az_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 on_demand_base_capacity: Optional[pulumi.Input[_builtins.int]] = None,
                 on_demand_percentage_above_base_capacity: Optional[pulumi.Input[_builtins.int]] = None,
                 protected_instances: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 removal_policies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 scaling_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 scaling_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 spot_allocation_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 spot_instance_pools: Optional[pulumi.Input[_builtins.int]] = None,
                 spot_instance_remedy: Optional[pulumi.Input[_builtins.bool]] = None,
                 stop_instance_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ScalingGroupArgs.__new__(ScalingGroupArgs)

            __props__.__dict__["alb_server_groups"] = alb_server_groups
            __props__.__dict__["allocation_strategy"] = allocation_strategy
            __props__.__dict__["az_balance"] = az_balance
            __props__.__dict__["capacity_options_compensate_with_on_demand"] = capacity_options_compensate_with_on_demand
            __props__.__dict__["capacity_options_on_demand_base_capacity"] = capacity_options_on_demand_base_capacity
            __props__.__dict__["capacity_options_on_demand_percentage_above_base_capacity"] = capacity_options_on_demand_percentage_above_base_capacity
            __props__.__dict__["capacity_options_price_comparison_mode"] = capacity_options_price_comparison_mode
            __props__.__dict__["capacity_options_spot_auto_replace_on_demand"] = capacity_options_spot_auto_replace_on_demand
            __props__.__dict__["compensate_with_on_demand"] = compensate_with_on_demand
            __props__.__dict__["container_group_id"] = container_group_id
            __props__.__dict__["db_instance_ids"] = db_instance_ids
            __props__.__dict__["default_cooldown"] = default_cooldown
            __props__.__dict__["desired_capacity"] = desired_capacity
            __props__.__dict__["group_deletion_protection"] = group_deletion_protection
            __props__.__dict__["group_type"] = group_type
            __props__.__dict__["health_check_type"] = health_check_type
            __props__.__dict__["health_check_types"] = health_check_types
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["launch_template_id"] = launch_template_id
            __props__.__dict__["launch_template_overrides"] = launch_template_overrides
            __props__.__dict__["launch_template_version"] = launch_template_version
            __props__.__dict__["loadbalancer_ids"] = loadbalancer_ids
            __props__.__dict__["max_instance_lifetime"] = max_instance_lifetime
            if max_size is None and not opts.urn:
                raise TypeError("Missing required property 'max_size'")
            __props__.__dict__["max_size"] = max_size
            if min_size is None and not opts.urn:
                raise TypeError("Missing required property 'min_size'")
            __props__.__dict__["min_size"] = min_size
            __props__.__dict__["multi_az_policy"] = multi_az_policy
            __props__.__dict__["on_demand_base_capacity"] = on_demand_base_capacity
            __props__.__dict__["on_demand_percentage_above_base_capacity"] = on_demand_percentage_above_base_capacity
            __props__.__dict__["protected_instances"] = protected_instances
            __props__.__dict__["removal_policies"] = removal_policies
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["scaling_group_name"] = scaling_group_name
            __props__.__dict__["scaling_policy"] = scaling_policy
            __props__.__dict__["spot_allocation_strategy"] = spot_allocation_strategy
            __props__.__dict__["spot_instance_pools"] = spot_instance_pools
            __props__.__dict__["spot_instance_remedy"] = spot_instance_remedy
            __props__.__dict__["stop_instance_timeout"] = stop_instance_timeout
            __props__.__dict__["tags"] = tags
            __props__.__dict__["vswitch_id"] = vswitch_id
            __props__.__dict__["vswitch_ids"] = vswitch_ids
        super(ScalingGroup, __self__).__init__(
            'alicloud:ess/scalingGroup:ScalingGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            alb_server_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ScalingGroupAlbServerGroupArgs', 'ScalingGroupAlbServerGroupArgsDict']]]]] = None,
            allocation_strategy: Optional[pulumi.Input[_builtins.str]] = None,
            az_balance: Optional[pulumi.Input[_builtins.bool]] = None,
            capacity_options_compensate_with_on_demand: Optional[pulumi.Input[_builtins.bool]] = None,
            capacity_options_on_demand_base_capacity: Optional[pulumi.Input[_builtins.int]] = None,
            capacity_options_on_demand_percentage_above_base_capacity: Optional[pulumi.Input[_builtins.int]] = None,
            capacity_options_price_comparison_mode: Optional[pulumi.Input[_builtins.str]] = None,
            capacity_options_spot_auto_replace_on_demand: Optional[pulumi.Input[_builtins.bool]] = None,
            compensate_with_on_demand: Optional[pulumi.Input[_builtins.bool]] = None,
            container_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            db_instance_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            default_cooldown: Optional[pulumi.Input[_builtins.int]] = None,
            desired_capacity: Optional[pulumi.Input[_builtins.int]] = None,
            group_deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
            group_type: Optional[pulumi.Input[_builtins.str]] = None,
            health_check_type: Optional[pulumi.Input[_builtins.str]] = None,
            health_check_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            launch_template_id: Optional[pulumi.Input[_builtins.str]] = None,
            launch_template_overrides: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ScalingGroupLaunchTemplateOverrideArgs', 'ScalingGroupLaunchTemplateOverrideArgsDict']]]]] = None,
            launch_template_version: Optional[pulumi.Input[_builtins.str]] = None,
            loadbalancer_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            max_instance_lifetime: Optional[pulumi.Input[_builtins.int]] = None,
            max_size: Optional[pulumi.Input[_builtins.int]] = None,
            min_size: Optional[pulumi.Input[_builtins.int]] = None,
            multi_az_policy: Optional[pulumi.Input[_builtins.str]] = None,
            on_demand_base_capacity: Optional[pulumi.Input[_builtins.int]] = None,
            on_demand_percentage_above_base_capacity: Optional[pulumi.Input[_builtins.int]] = None,
            protected_instances: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            removal_policies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            scaling_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            scaling_policy: Optional[pulumi.Input[_builtins.str]] = None,
            spot_allocation_strategy: Optional[pulumi.Input[_builtins.str]] = None,
            spot_instance_pools: Optional[pulumi.Input[_builtins.int]] = None,
            spot_instance_remedy: Optional[pulumi.Input[_builtins.bool]] = None,
            stop_instance_timeout: Optional[pulumi.Input[_builtins.int]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
            vswitch_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'ScalingGroup':
        """
        Get an existing ScalingGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ScalingGroupAlbServerGroupArgs', 'ScalingGroupAlbServerGroupArgsDict']]]] alb_server_groups: If a Serve ALB instance is specified in the scaling group, the scaling group automatically attaches its ECS instances to the Server ALB instance.  See `alb_server_group` below for details.
        :param pulumi.Input[_builtins.str] allocation_strategy: The allocation policy of instances. Auto Scaling selects instance types based on the allocation policy to create instances. The policy can be applied to pay-as-you-go instances and preemptible instances. This parameter takes effect only if you set MultiAZPolicy to COMPOSABLE.
        :param pulumi.Input[_builtins.bool] az_balance: Specifies whether to evenly distribute instances in the scaling group across multiple zones. This parameter takes effect only if you set MultiAZPolicy to COMPOSABLE.
        :param pulumi.Input[_builtins.bool] capacity_options_compensate_with_on_demand: Specifies whether to automatically create pay-as-you-go instances to meet the requirement on the number of ECS instances when the expected capacity of preemptible instances cannot be provided due to reasons such as cost-related issues and insufficient resources. This parameter is supported only if you set 'multi_az_policy' to COST_OPTIMIZED. Valid values: true, false.
        :param pulumi.Input[_builtins.int] capacity_options_on_demand_base_capacity: The minimum number of pay-as-you-go instances that must be contained in the scaling group. When the actual number of pay-as-you-go instances in the scaling group drops below the value of this parameter, Auto Scaling preferentially creates pay-as-you-go instances. Valid values: 0 to 1000. If you set 'multi_az_policy' to COMPOSABLE, the default value of this parameter is 0.
        :param pulumi.Input[_builtins.int] capacity_options_on_demand_percentage_above_base_capacity: The percentage of pay-as-you-go instances in the excess instances when the minimum number of pay-as-you-go instances is reached. 'on_demand_base_capacity' specifies the minimum number of pay-as-you-go instances that must be contained in the scaling group. Valid values: 0 to 100. If you set 'multi_az_policy' to COMPOSABLE, the default value of this parameter is 100.
        :param pulumi.Input[_builtins.str] capacity_options_price_comparison_mode: The price comparison mode. Valid values: PricePerUnit,PricePerVCpu. Default value: PricePerUnit.
        :param pulumi.Input[_builtins.bool] capacity_options_spot_auto_replace_on_demand: Specifies whether to replace pay-as-you-go instances with preemptible instances. If you specify 'compensate_with_on_demand', it may result in a higher percentage of pay-as-you-go instances compared to the value of 'on_demand_percentage_above_base_capacity'. If you specify this parameter, Auto Scaling preferentially deploys preemptible instances to replace the surplus pay-as-you-go instances when preemptible instance types are available. If you specify 'compensate_with_on_demand', Auto Scaling creates pay-as-you-go instances when preemptible instance types are insufficient. To avoid retaining these pay-as-you-go instances for extended periods, Auto Scaling attempts to replace them with preemptible instances when sufficient preemptible instance types become available. Valid values: true, false.
        :param pulumi.Input[_builtins.bool] compensate_with_on_demand: Specifies whether to automatically create pay-as-you-go instances to meet the requirement on the number of ECS instances when the expected capacity of preemptible instances cannot be provided due to reasons such as cost-related issues and insufficient resources. This parameter is supported only if you set 'multi_az_policy' to COST_OPTIMIZED. Valid values: true, false.
        :param pulumi.Input[_builtins.str] container_group_id: The ID of the elastic container instance.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] db_instance_ids: If an RDS instance is specified in the scaling group, the scaling group automatically attaches the Intranet IP addresses of its ECS instances to the RDS access whitelist.
               - The specified RDS instance must be in running status.
               - The specified RDS instance’s whitelist must have room for more IP addresses.
        :param pulumi.Input[_builtins.int] default_cooldown: Default cool-down time (in seconds) of the scaling group. Value range: [0, 86400]. The default value is 300s.
        :param pulumi.Input[_builtins.int] desired_capacity: Expected number of ECS instances in the scaling group. Value range: [min_size, max_size].
        :param pulumi.Input[_builtins.bool] group_deletion_protection: Specifies whether the scaling group deletion protection is enabled. `true` or `false`, Default value: `false`.
        :param pulumi.Input[_builtins.str] group_type: Resource type within scaling group. Optional values: ECS, ECI. Default to ECS.
        :param pulumi.Input[_builtins.str] health_check_type: Resource type within scaling group. Optional values: ECS, ECI, NONE, LOAD_BALANCER. Default to ECS.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] health_check_types: The health check modes of the scaling group. Valid values: ECS, NONE, LOAD_BALANCER.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the instance from which Auto Scaling obtains the required configuration information and uses the information to automatically create a scaling configuration.
        :param pulumi.Input[_builtins.str] launch_template_id: Instance launch template ID, scaling group obtains launch configuration from instance launch template, see [Launch Template](https://www.alibabacloud.com/help/doc-detail/73916.html). Creating scaling group from launch template enable group automatically.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ScalingGroupLaunchTemplateOverrideArgs', 'ScalingGroupLaunchTemplateOverrideArgsDict']]]] launch_template_overrides: The details of the instance types that are specified by using the Extend Instance Type of Launch Template feature.  See `launch_template_override` below for details.
        :param pulumi.Input[_builtins.str] launch_template_version: The version number of the launch template. Valid values are the version number, `Latest`, or `Default`, Default value: `Default`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] loadbalancer_ids: If a Server Load Balancer instance is specified in the scaling group, the scaling group automatically attaches its ECS instances to the Server Load Balancer instance.
               - The Server Load Balancer instance must be enabled.
               - At least one listener must be configured for each Server Load Balancer and it HealthCheck must be on. Otherwise, creation will fail (it may be useful to add a `depends_on` argument
               targeting your `slb.Listener` in order to make sure the listener with its HealthCheck configuration is ready before creating your scaling group).
               - The Server Load Balancer instance attached with VPC-type ECS instances cannot be attached to the scaling group.
               - The default weight of an ECS instance attached to the Server Load Balancer instance is 50.
        :param pulumi.Input[_builtins.int] max_instance_lifetime: The maximum life span of an instance in the scaling group. Unit: seconds.
        :param pulumi.Input[_builtins.int] max_size: Maximum number of ECS instances in the scaling group. Value range: [0, 2000].
               **NOTE:** From version 1.204.1, `max_size` can be set to `2000`.
        :param pulumi.Input[_builtins.int] min_size: Minimum number of ECS instances in the scaling group. Value range: [0, 2000].
               **NOTE:** From version 1.204.1, `min_size` can be set to `2000`.
        :param pulumi.Input[_builtins.str] multi_az_policy: Multi-AZ scaling group ECS instance expansion and contraction strategy. PRIORITY, COMPOSABLE, BALANCE or COST_OPTIMIZED(Available since v1.54.0).
        :param pulumi.Input[_builtins.int] on_demand_base_capacity: The minimum amount of the Auto Scaling group's capacity that must be fulfilled by On-Demand Instances. This base portion is provisioned first as your group scales.
        :param pulumi.Input[_builtins.int] on_demand_percentage_above_base_capacity: Controls the percentages of On-Demand Instances and Spot Instances for your additional capacity beyond OnDemandBaseCapacity.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] protected_instances: Set or unset instances within group into protected status.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] removal_policies: RemovalPolicy is used to select the ECS instances you want to remove from the scaling group when multiple candidates for removal exist. Optional values:
               - OldestInstance: removes the ECS instance that is added to the scaling group at the earliest point in time.
               - NewestInstance: removes the ECS instance that is added to the scaling group at the latest point in time.
               - OldestScalingConfiguration: removes the ECS instance that is created based on the earliest scaling configuration.
               - Default values: Default value of RemovalPolicy.1: OldestScalingConfiguration. Default value of RemovalPolicy.2: OldestInstance.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group to which you want to add the scaling group.
        :param pulumi.Input[_builtins.str] scaling_group_name: Name shown for the scaling group, which must contain 2-64 characters (English or Chinese), starting with numbers, English letters or Chinese characters, and can contain numbers, underscores `_`, hyphens `-`, and decimal points `.`. If this parameter is not specified, the default value is ScalingGroupId.
        :param pulumi.Input[_builtins.str] scaling_policy: The reclaim mode of the scaling group. Optional values: recycle, release, forceRecycle, forceRelease.
        :param pulumi.Input[_builtins.str] spot_allocation_strategy: The allocation policy of preemptible instances. You can use this parameter to individually specify the allocation policy for preemptible instances. This parameter takes effect only if you set MultiAZPolicy to COMPOSABLE.
        :param pulumi.Input[_builtins.int] spot_instance_pools: The number of Spot pools to use to allocate your Spot capacity. The Spot pools is composed of instance types of lowest price.
        :param pulumi.Input[_builtins.bool] spot_instance_remedy: Whether to replace spot instances with newly created spot/onDemand instance when receive a spot recycling message.
        :param pulumi.Input[_builtins.int] stop_instance_timeout: The period of time required by the ECS instance to enter the Stopped state. Unit: seconds. Valid values: 30 to 240.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
               - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
               - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
        :param pulumi.Input[_builtins.str] vswitch_id: It has been deprecated from version 1.7.1 and new field 'vswitch_ids' replaces it.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] vswitch_ids: List of virtual switch IDs in which the ecs instances to be launched.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ScalingGroupState.__new__(_ScalingGroupState)

        __props__.__dict__["alb_server_groups"] = alb_server_groups
        __props__.__dict__["allocation_strategy"] = allocation_strategy
        __props__.__dict__["az_balance"] = az_balance
        __props__.__dict__["capacity_options_compensate_with_on_demand"] = capacity_options_compensate_with_on_demand
        __props__.__dict__["capacity_options_on_demand_base_capacity"] = capacity_options_on_demand_base_capacity
        __props__.__dict__["capacity_options_on_demand_percentage_above_base_capacity"] = capacity_options_on_demand_percentage_above_base_capacity
        __props__.__dict__["capacity_options_price_comparison_mode"] = capacity_options_price_comparison_mode
        __props__.__dict__["capacity_options_spot_auto_replace_on_demand"] = capacity_options_spot_auto_replace_on_demand
        __props__.__dict__["compensate_with_on_demand"] = compensate_with_on_demand
        __props__.__dict__["container_group_id"] = container_group_id
        __props__.__dict__["db_instance_ids"] = db_instance_ids
        __props__.__dict__["default_cooldown"] = default_cooldown
        __props__.__dict__["desired_capacity"] = desired_capacity
        __props__.__dict__["group_deletion_protection"] = group_deletion_protection
        __props__.__dict__["group_type"] = group_type
        __props__.__dict__["health_check_type"] = health_check_type
        __props__.__dict__["health_check_types"] = health_check_types
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["launch_template_id"] = launch_template_id
        __props__.__dict__["launch_template_overrides"] = launch_template_overrides
        __props__.__dict__["launch_template_version"] = launch_template_version
        __props__.__dict__["loadbalancer_ids"] = loadbalancer_ids
        __props__.__dict__["max_instance_lifetime"] = max_instance_lifetime
        __props__.__dict__["max_size"] = max_size
        __props__.__dict__["min_size"] = min_size
        __props__.__dict__["multi_az_policy"] = multi_az_policy
        __props__.__dict__["on_demand_base_capacity"] = on_demand_base_capacity
        __props__.__dict__["on_demand_percentage_above_base_capacity"] = on_demand_percentage_above_base_capacity
        __props__.__dict__["protected_instances"] = protected_instances
        __props__.__dict__["removal_policies"] = removal_policies
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["scaling_group_name"] = scaling_group_name
        __props__.__dict__["scaling_policy"] = scaling_policy
        __props__.__dict__["spot_allocation_strategy"] = spot_allocation_strategy
        __props__.__dict__["spot_instance_pools"] = spot_instance_pools
        __props__.__dict__["spot_instance_remedy"] = spot_instance_remedy
        __props__.__dict__["stop_instance_timeout"] = stop_instance_timeout
        __props__.__dict__["tags"] = tags
        __props__.__dict__["vswitch_id"] = vswitch_id
        __props__.__dict__["vswitch_ids"] = vswitch_ids
        return ScalingGroup(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="albServerGroups")
    def alb_server_groups(self) -> pulumi.Output[Optional[Sequence['outputs.ScalingGroupAlbServerGroup']]]:
        """
        If a Serve ALB instance is specified in the scaling group, the scaling group automatically attaches its ECS instances to the Server ALB instance.  See `alb_server_group` below for details.
        """
        return pulumi.get(self, "alb_server_groups")

    @_builtins.property
    @pulumi.getter(name="allocationStrategy")
    def allocation_strategy(self) -> pulumi.Output[_builtins.str]:
        """
        The allocation policy of instances. Auto Scaling selects instance types based on the allocation policy to create instances. The policy can be applied to pay-as-you-go instances and preemptible instances. This parameter takes effect only if you set MultiAZPolicy to COMPOSABLE.
        """
        return pulumi.get(self, "allocation_strategy")

    @_builtins.property
    @pulumi.getter(name="azBalance")
    def az_balance(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to evenly distribute instances in the scaling group across multiple zones. This parameter takes effect only if you set MultiAZPolicy to COMPOSABLE.
        """
        return pulumi.get(self, "az_balance")

    @_builtins.property
    @pulumi.getter(name="capacityOptionsCompensateWithOnDemand")
    def capacity_options_compensate_with_on_demand(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies whether to automatically create pay-as-you-go instances to meet the requirement on the number of ECS instances when the expected capacity of preemptible instances cannot be provided due to reasons such as cost-related issues and insufficient resources. This parameter is supported only if you set 'multi_az_policy' to COST_OPTIMIZED. Valid values: true, false.
        """
        return pulumi.get(self, "capacity_options_compensate_with_on_demand")

    @_builtins.property
    @pulumi.getter(name="capacityOptionsOnDemandBaseCapacity")
    def capacity_options_on_demand_base_capacity(self) -> pulumi.Output[_builtins.int]:
        """
        The minimum number of pay-as-you-go instances that must be contained in the scaling group. When the actual number of pay-as-you-go instances in the scaling group drops below the value of this parameter, Auto Scaling preferentially creates pay-as-you-go instances. Valid values: 0 to 1000. If you set 'multi_az_policy' to COMPOSABLE, the default value of this parameter is 0.
        """
        return pulumi.get(self, "capacity_options_on_demand_base_capacity")

    @_builtins.property
    @pulumi.getter(name="capacityOptionsOnDemandPercentageAboveBaseCapacity")
    def capacity_options_on_demand_percentage_above_base_capacity(self) -> pulumi.Output[_builtins.int]:
        """
        The percentage of pay-as-you-go instances in the excess instances when the minimum number of pay-as-you-go instances is reached. 'on_demand_base_capacity' specifies the minimum number of pay-as-you-go instances that must be contained in the scaling group. Valid values: 0 to 100. If you set 'multi_az_policy' to COMPOSABLE, the default value of this parameter is 100.
        """
        return pulumi.get(self, "capacity_options_on_demand_percentage_above_base_capacity")

    @_builtins.property
    @pulumi.getter(name="capacityOptionsPriceComparisonMode")
    def capacity_options_price_comparison_mode(self) -> pulumi.Output[_builtins.str]:
        """
        The price comparison mode. Valid values: PricePerUnit,PricePerVCpu. Default value: PricePerUnit.
        """
        return pulumi.get(self, "capacity_options_price_comparison_mode")

    @_builtins.property
    @pulumi.getter(name="capacityOptionsSpotAutoReplaceOnDemand")
    def capacity_options_spot_auto_replace_on_demand(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies whether to replace pay-as-you-go instances with preemptible instances. If you specify 'compensate_with_on_demand', it may result in a higher percentage of pay-as-you-go instances compared to the value of 'on_demand_percentage_above_base_capacity'. If you specify this parameter, Auto Scaling preferentially deploys preemptible instances to replace the surplus pay-as-you-go instances when preemptible instance types are available. If you specify 'compensate_with_on_demand', Auto Scaling creates pay-as-you-go instances when preemptible instance types are insufficient. To avoid retaining these pay-as-you-go instances for extended periods, Auto Scaling attempts to replace them with preemptible instances when sufficient preemptible instance types become available. Valid values: true, false.
        """
        return pulumi.get(self, "capacity_options_spot_auto_replace_on_demand")

    @_builtins.property
    @pulumi.getter(name="compensateWithOnDemand")
    def compensate_with_on_demand(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies whether to automatically create pay-as-you-go instances to meet the requirement on the number of ECS instances when the expected capacity of preemptible instances cannot be provided due to reasons such as cost-related issues and insufficient resources. This parameter is supported only if you set 'multi_az_policy' to COST_OPTIMIZED. Valid values: true, false.
        """
        return pulumi.get(self, "compensate_with_on_demand")

    @_builtins.property
    @pulumi.getter(name="containerGroupId")
    def container_group_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the elastic container instance.
        """
        return pulumi.get(self, "container_group_id")

    @_builtins.property
    @pulumi.getter(name="dbInstanceIds")
    def db_instance_ids(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        If an RDS instance is specified in the scaling group, the scaling group automatically attaches the Intranet IP addresses of its ECS instances to the RDS access whitelist.
        - The specified RDS instance must be in running status.
        - The specified RDS instance’s whitelist must have room for more IP addresses.
        """
        return pulumi.get(self, "db_instance_ids")

    @_builtins.property
    @pulumi.getter(name="defaultCooldown")
    def default_cooldown(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Default cool-down time (in seconds) of the scaling group. Value range: [0, 86400]. The default value is 300s.
        """
        return pulumi.get(self, "default_cooldown")

    @_builtins.property
    @pulumi.getter(name="desiredCapacity")
    def desired_capacity(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Expected number of ECS instances in the scaling group. Value range: [min_size, max_size].
        """
        return pulumi.get(self, "desired_capacity")

    @_builtins.property
    @pulumi.getter(name="groupDeletionProtection")
    def group_deletion_protection(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether the scaling group deletion protection is enabled. `true` or `false`, Default value: `false`.
        """
        return pulumi.get(self, "group_deletion_protection")

    @_builtins.property
    @pulumi.getter(name="groupType")
    def group_type(self) -> pulumi.Output[_builtins.str]:
        """
        Resource type within scaling group. Optional values: ECS, ECI. Default to ECS.
        """
        return pulumi.get(self, "group_type")

    @_builtins.property
    @pulumi.getter(name="healthCheckType")
    def health_check_type(self) -> pulumi.Output[_builtins.str]:
        """
        Resource type within scaling group. Optional values: ECS, ECI, NONE, LOAD_BALANCER. Default to ECS.
        """
        return pulumi.get(self, "health_check_type")

    @_builtins.property
    @pulumi.getter(name="healthCheckTypes")
    def health_check_types(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The health check modes of the scaling group. Valid values: ECS, NONE, LOAD_BALANCER.
        """
        return pulumi.get(self, "health_check_types")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the instance from which Auto Scaling obtains the required configuration information and uses the information to automatically create a scaling configuration.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="launchTemplateId")
    def launch_template_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Instance launch template ID, scaling group obtains launch configuration from instance launch template, see [Launch Template](https://www.alibabacloud.com/help/doc-detail/73916.html). Creating scaling group from launch template enable group automatically.
        """
        return pulumi.get(self, "launch_template_id")

    @_builtins.property
    @pulumi.getter(name="launchTemplateOverrides")
    def launch_template_overrides(self) -> pulumi.Output[Optional[Sequence['outputs.ScalingGroupLaunchTemplateOverride']]]:
        """
        The details of the instance types that are specified by using the Extend Instance Type of Launch Template feature.  See `launch_template_override` below for details.
        """
        return pulumi.get(self, "launch_template_overrides")

    @_builtins.property
    @pulumi.getter(name="launchTemplateVersion")
    def launch_template_version(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The version number of the launch template. Valid values are the version number, `Latest`, or `Default`, Default value: `Default`.
        """
        return pulumi.get(self, "launch_template_version")

    @_builtins.property
    @pulumi.getter(name="loadbalancerIds")
    def loadbalancer_ids(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        If a Server Load Balancer instance is specified in the scaling group, the scaling group automatically attaches its ECS instances to the Server Load Balancer instance.
        - The Server Load Balancer instance must be enabled.
        - At least one listener must be configured for each Server Load Balancer and it HealthCheck must be on. Otherwise, creation will fail (it may be useful to add a `depends_on` argument
        targeting your `slb.Listener` in order to make sure the listener with its HealthCheck configuration is ready before creating your scaling group).
        - The Server Load Balancer instance attached with VPC-type ECS instances cannot be attached to the scaling group.
        - The default weight of an ECS instance attached to the Server Load Balancer instance is 50.
        """
        return pulumi.get(self, "loadbalancer_ids")

    @_builtins.property
    @pulumi.getter(name="maxInstanceLifetime")
    def max_instance_lifetime(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The maximum life span of an instance in the scaling group. Unit: seconds.
        """
        return pulumi.get(self, "max_instance_lifetime")

    @_builtins.property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> pulumi.Output[_builtins.int]:
        """
        Maximum number of ECS instances in the scaling group. Value range: [0, 2000].
        **NOTE:** From version 1.204.1, `max_size` can be set to `2000`.
        """
        return pulumi.get(self, "max_size")

    @_builtins.property
    @pulumi.getter(name="minSize")
    def min_size(self) -> pulumi.Output[_builtins.int]:
        """
        Minimum number of ECS instances in the scaling group. Value range: [0, 2000].
        **NOTE:** From version 1.204.1, `min_size` can be set to `2000`.
        """
        return pulumi.get(self, "min_size")

    @_builtins.property
    @pulumi.getter(name="multiAzPolicy")
    def multi_az_policy(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Multi-AZ scaling group ECS instance expansion and contraction strategy. PRIORITY, COMPOSABLE, BALANCE or COST_OPTIMIZED(Available since v1.54.0).
        """
        return pulumi.get(self, "multi_az_policy")

    @_builtins.property
    @pulumi.getter(name="onDemandBaseCapacity")
    def on_demand_base_capacity(self) -> pulumi.Output[_builtins.int]:
        """
        The minimum amount of the Auto Scaling group's capacity that must be fulfilled by On-Demand Instances. This base portion is provisioned first as your group scales.
        """
        return pulumi.get(self, "on_demand_base_capacity")

    @_builtins.property
    @pulumi.getter(name="onDemandPercentageAboveBaseCapacity")
    def on_demand_percentage_above_base_capacity(self) -> pulumi.Output[_builtins.int]:
        """
        Controls the percentages of On-Demand Instances and Spot Instances for your additional capacity beyond OnDemandBaseCapacity.
        """
        return pulumi.get(self, "on_demand_percentage_above_base_capacity")

    @_builtins.property
    @pulumi.getter(name="protectedInstances")
    def protected_instances(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Set or unset instances within group into protected status.
        """
        return pulumi.get(self, "protected_instances")

    @_builtins.property
    @pulumi.getter(name="removalPolicies")
    def removal_policies(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        RemovalPolicy is used to select the ECS instances you want to remove from the scaling group when multiple candidates for removal exist. Optional values:
        - OldestInstance: removes the ECS instance that is added to the scaling group at the earliest point in time.
        - NewestInstance: removes the ECS instance that is added to the scaling group at the latest point in time.
        - OldestScalingConfiguration: removes the ECS instance that is created based on the earliest scaling configuration.
        - Default values: Default value of RemovalPolicy.1: OldestScalingConfiguration. Default value of RemovalPolicy.2: OldestInstance.
        """
        return pulumi.get(self, "removal_policies")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the resource group to which you want to add the scaling group.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="scalingGroupName")
    def scaling_group_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Name shown for the scaling group, which must contain 2-64 characters (English or Chinese), starting with numbers, English letters or Chinese characters, and can contain numbers, underscores `_`, hyphens `-`, and decimal points `.`. If this parameter is not specified, the default value is ScalingGroupId.
        """
        return pulumi.get(self, "scaling_group_name")

    @_builtins.property
    @pulumi.getter(name="scalingPolicy")
    def scaling_policy(self) -> pulumi.Output[_builtins.str]:
        """
        The reclaim mode of the scaling group. Optional values: recycle, release, forceRecycle, forceRelease.
        """
        return pulumi.get(self, "scaling_policy")

    @_builtins.property
    @pulumi.getter(name="spotAllocationStrategy")
    def spot_allocation_strategy(self) -> pulumi.Output[_builtins.str]:
        """
        The allocation policy of preemptible instances. You can use this parameter to individually specify the allocation policy for preemptible instances. This parameter takes effect only if you set MultiAZPolicy to COMPOSABLE.
        """
        return pulumi.get(self, "spot_allocation_strategy")

    @_builtins.property
    @pulumi.getter(name="spotInstancePools")
    def spot_instance_pools(self) -> pulumi.Output[_builtins.int]:
        """
        The number of Spot pools to use to allocate your Spot capacity. The Spot pools is composed of instance types of lowest price.
        """
        return pulumi.get(self, "spot_instance_pools")

    @_builtins.property
    @pulumi.getter(name="spotInstanceRemedy")
    def spot_instance_remedy(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether to replace spot instances with newly created spot/onDemand instance when receive a spot recycling message.
        """
        return pulumi.get(self, "spot_instance_remedy")

    @_builtins.property
    @pulumi.getter(name="stopInstanceTimeout")
    def stop_instance_timeout(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The period of time required by the ECS instance to enter the Stopped state. Unit: seconds. Valid values: 30 to 240.
        """
        return pulumi.get(self, "stop_instance_timeout")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
        - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    @_utilities.deprecated("""Field 'vswitch_id' has been deprecated from provider version 1.7.1, and new field 'vswitch_ids' can replace it.""")
    def vswitch_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        It has been deprecated from version 1.7.1 and new field 'vswitch_ids' replaces it.
        """
        return pulumi.get(self, "vswitch_id")

    @_builtins.property
    @pulumi.getter(name="vswitchIds")
    def vswitch_ids(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of virtual switch IDs in which the ecs instances to be launched.
        """
        return pulumi.get(self, "vswitch_ids")

