# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ScalingGroupVServerGroupsArgs', 'ScalingGroupVServerGroups']

@pulumi.input_type
class ScalingGroupVServerGroupsArgs:
    def __init__(__self__, *,
                 scaling_group_id: pulumi.Input[_builtins.str],
                 vserver_groups: pulumi.Input[Sequence[pulumi.Input['ScalingGroupVServerGroupsVserverGroupArgs']]],
                 force: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a ScalingGroupVServerGroups resource.
        :param pulumi.Input[_builtins.str] scaling_group_id: ID of the scaling group.
        :param pulumi.Input[Sequence[pulumi.Input['ScalingGroupVServerGroupsVserverGroupArgs']]] vserver_groups: A list of vserver groups attached on scaling group. See `vserver_groups` below.
        :param pulumi.Input[_builtins.bool] force: If instances of scaling group are attached/removed from slb backend server when attach/detach vserver group from scaling group. Default to true.
        """
        pulumi.set(__self__, "scaling_group_id", scaling_group_id)
        pulumi.set(__self__, "vserver_groups", vserver_groups)
        if force is not None:
            pulumi.set(__self__, "force", force)

    @_builtins.property
    @pulumi.getter(name="scalingGroupId")
    def scaling_group_id(self) -> pulumi.Input[_builtins.str]:
        """
        ID of the scaling group.
        """
        return pulumi.get(self, "scaling_group_id")

    @scaling_group_id.setter
    def scaling_group_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "scaling_group_id", value)

    @_builtins.property
    @pulumi.getter(name="vserverGroups")
    def vserver_groups(self) -> pulumi.Input[Sequence[pulumi.Input['ScalingGroupVServerGroupsVserverGroupArgs']]]:
        """
        A list of vserver groups attached on scaling group. See `vserver_groups` below.
        """
        return pulumi.get(self, "vserver_groups")

    @vserver_groups.setter
    def vserver_groups(self, value: pulumi.Input[Sequence[pulumi.Input['ScalingGroupVServerGroupsVserverGroupArgs']]]):
        pulumi.set(self, "vserver_groups", value)

    @_builtins.property
    @pulumi.getter
    def force(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If instances of scaling group are attached/removed from slb backend server when attach/detach vserver group from scaling group. Default to true.
        """
        return pulumi.get(self, "force")

    @force.setter
    def force(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force", value)


@pulumi.input_type
class _ScalingGroupVServerGroupsState:
    def __init__(__self__, *,
                 force: Optional[pulumi.Input[_builtins.bool]] = None,
                 scaling_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vserver_groups: Optional[pulumi.Input[Sequence[pulumi.Input['ScalingGroupVServerGroupsVserverGroupArgs']]]] = None):
        """
        Input properties used for looking up and filtering ScalingGroupVServerGroups resources.
        :param pulumi.Input[_builtins.bool] force: If instances of scaling group are attached/removed from slb backend server when attach/detach vserver group from scaling group. Default to true.
        :param pulumi.Input[_builtins.str] scaling_group_id: ID of the scaling group.
        :param pulumi.Input[Sequence[pulumi.Input['ScalingGroupVServerGroupsVserverGroupArgs']]] vserver_groups: A list of vserver groups attached on scaling group. See `vserver_groups` below.
        """
        if force is not None:
            pulumi.set(__self__, "force", force)
        if scaling_group_id is not None:
            pulumi.set(__self__, "scaling_group_id", scaling_group_id)
        if vserver_groups is not None:
            pulumi.set(__self__, "vserver_groups", vserver_groups)

    @_builtins.property
    @pulumi.getter
    def force(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If instances of scaling group are attached/removed from slb backend server when attach/detach vserver group from scaling group. Default to true.
        """
        return pulumi.get(self, "force")

    @force.setter
    def force(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force", value)

    @_builtins.property
    @pulumi.getter(name="scalingGroupId")
    def scaling_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the scaling group.
        """
        return pulumi.get(self, "scaling_group_id")

    @scaling_group_id.setter
    def scaling_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scaling_group_id", value)

    @_builtins.property
    @pulumi.getter(name="vserverGroups")
    def vserver_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ScalingGroupVServerGroupsVserverGroupArgs']]]]:
        """
        A list of vserver groups attached on scaling group. See `vserver_groups` below.
        """
        return pulumi.get(self, "vserver_groups")

    @vserver_groups.setter
    def vserver_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ScalingGroupVServerGroupsVserverGroupArgs']]]]):
        pulumi.set(self, "vserver_groups", value)


@pulumi.type_token("alicloud:ess/scalingGroupVServerGroups:ScalingGroupVServerGroups")
class ScalingGroupVServerGroups(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 force: Optional[pulumi.Input[_builtins.bool]] = None,
                 scaling_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vserver_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ScalingGroupVServerGroupsVserverGroupArgs', 'ScalingGroupVServerGroupsVserverGroupArgsDict']]]]] = None,
                 __props__=None):
        """
        Attaches/Detaches vserver groups to a specified scaling group.

        > **NOTE:** The load balancer of which vserver groups belongs to must be in `active` status.

        > **NOTE:** If scaling group's network type is `VPC`, the vserver groups must be in the same `VPC`.

        > **NOTE:** A scaling group can have at most 5 vserver groups attached by default.

        > **NOTE:** Vserver groups and the default group of loadbalancer share the same backend server quota.

        > **NOTE:** When attach vserver groups to scaling group, existing ECS instances will be added to vserver groups; Instead, ECS instances will be removed from vserver group when detach.

        > **NOTE:** Detach action will be executed before attach action.

        > **NOTE:** Vserver group is defined uniquely by `loadbalancer_id`, `vserver_group_id`, `port`.

        > **NOTE:** Modifing `weight` attribute means detach vserver group first and then, attach with new weight parameter.

        > **NOTE:** Available since v1.53.0.

        ## Import

        ESS vserver groups can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ess/scalingGroupVServerGroups:ScalingGroupVServerGroups example abc123456
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] force: If instances of scaling group are attached/removed from slb backend server when attach/detach vserver group from scaling group. Default to true.
        :param pulumi.Input[_builtins.str] scaling_group_id: ID of the scaling group.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ScalingGroupVServerGroupsVserverGroupArgs', 'ScalingGroupVServerGroupsVserverGroupArgsDict']]]] vserver_groups: A list of vserver groups attached on scaling group. See `vserver_groups` below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ScalingGroupVServerGroupsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Attaches/Detaches vserver groups to a specified scaling group.

        > **NOTE:** The load balancer of which vserver groups belongs to must be in `active` status.

        > **NOTE:** If scaling group's network type is `VPC`, the vserver groups must be in the same `VPC`.

        > **NOTE:** A scaling group can have at most 5 vserver groups attached by default.

        > **NOTE:** Vserver groups and the default group of loadbalancer share the same backend server quota.

        > **NOTE:** When attach vserver groups to scaling group, existing ECS instances will be added to vserver groups; Instead, ECS instances will be removed from vserver group when detach.

        > **NOTE:** Detach action will be executed before attach action.

        > **NOTE:** Vserver group is defined uniquely by `loadbalancer_id`, `vserver_group_id`, `port`.

        > **NOTE:** Modifing `weight` attribute means detach vserver group first and then, attach with new weight parameter.

        > **NOTE:** Available since v1.53.0.

        ## Import

        ESS vserver groups can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ess/scalingGroupVServerGroups:ScalingGroupVServerGroups example abc123456
        ```

        :param str resource_name: The name of the resource.
        :param ScalingGroupVServerGroupsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ScalingGroupVServerGroupsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 force: Optional[pulumi.Input[_builtins.bool]] = None,
                 scaling_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vserver_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ScalingGroupVServerGroupsVserverGroupArgs', 'ScalingGroupVServerGroupsVserverGroupArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ScalingGroupVServerGroupsArgs.__new__(ScalingGroupVServerGroupsArgs)

            __props__.__dict__["force"] = force
            if scaling_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'scaling_group_id'")
            __props__.__dict__["scaling_group_id"] = scaling_group_id
            if vserver_groups is None and not opts.urn:
                raise TypeError("Missing required property 'vserver_groups'")
            __props__.__dict__["vserver_groups"] = vserver_groups
        super(ScalingGroupVServerGroups, __self__).__init__(
            'alicloud:ess/scalingGroupVServerGroups:ScalingGroupVServerGroups',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            force: Optional[pulumi.Input[_builtins.bool]] = None,
            scaling_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            vserver_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ScalingGroupVServerGroupsVserverGroupArgs', 'ScalingGroupVServerGroupsVserverGroupArgsDict']]]]] = None) -> 'ScalingGroupVServerGroups':
        """
        Get an existing ScalingGroupVServerGroups resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] force: If instances of scaling group are attached/removed from slb backend server when attach/detach vserver group from scaling group. Default to true.
        :param pulumi.Input[_builtins.str] scaling_group_id: ID of the scaling group.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ScalingGroupVServerGroupsVserverGroupArgs', 'ScalingGroupVServerGroupsVserverGroupArgsDict']]]] vserver_groups: A list of vserver groups attached on scaling group. See `vserver_groups` below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ScalingGroupVServerGroupsState.__new__(_ScalingGroupVServerGroupsState)

        __props__.__dict__["force"] = force
        __props__.__dict__["scaling_group_id"] = scaling_group_id
        __props__.__dict__["vserver_groups"] = vserver_groups
        return ScalingGroupVServerGroups(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def force(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If instances of scaling group are attached/removed from slb backend server when attach/detach vserver group from scaling group. Default to true.
        """
        return pulumi.get(self, "force")

    @_builtins.property
    @pulumi.getter(name="scalingGroupId")
    def scaling_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the scaling group.
        """
        return pulumi.get(self, "scaling_group_id")

    @_builtins.property
    @pulumi.getter(name="vserverGroups")
    def vserver_groups(self) -> pulumi.Output[Sequence['outputs.ScalingGroupVServerGroupsVserverGroup']]:
        """
        A list of vserver groups attached on scaling group. See `vserver_groups` below.
        """
        return pulumi.get(self, "vserver_groups")

