# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ScalingRuleArgs', 'ScalingRule']

@pulumi.input_type
class ScalingRuleArgs:
    def __init__(__self__, *,
                 scaling_group_id: pulumi.Input[_builtins.str],
                 adjustment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 adjustment_value: Optional[pulumi.Input[_builtins.int]] = None,
                 alarm_dimension: Optional[pulumi.Input['ScalingRuleAlarmDimensionArgs']] = None,
                 cooldown: Optional[pulumi.Input[_builtins.int]] = None,
                 disable_scale_in: Optional[pulumi.Input[_builtins.bool]] = None,
                 estimated_instance_warmup: Optional[pulumi.Input[_builtins.int]] = None,
                 hybrid_metrics: Optional[pulumi.Input[Sequence[pulumi.Input['ScalingRuleHybridMetricArgs']]]] = None,
                 hybrid_monitor_namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 initial_max_size: Optional[pulumi.Input[_builtins.int]] = None,
                 metric_name: Optional[pulumi.Input[_builtins.str]] = None,
                 metric_type: Optional[pulumi.Input[_builtins.str]] = None,
                 min_adjustment_magnitude: Optional[pulumi.Input[_builtins.int]] = None,
                 predictive_scaling_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 predictive_task_buffer_time: Optional[pulumi.Input[_builtins.int]] = None,
                 predictive_value_behavior: Optional[pulumi.Input[_builtins.str]] = None,
                 predictive_value_buffer: Optional[pulumi.Input[_builtins.int]] = None,
                 scale_in_evaluation_count: Optional[pulumi.Input[_builtins.int]] = None,
                 scale_out_evaluation_count: Optional[pulumi.Input[_builtins.int]] = None,
                 scaling_rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 scaling_rule_type: Optional[pulumi.Input[_builtins.str]] = None,
                 step_adjustments: Optional[pulumi.Input[Sequence[pulumi.Input['ScalingRuleStepAdjustmentArgs']]]] = None,
                 target_value: Optional[pulumi.Input[_builtins.float]] = None):
        """
        The set of arguments for constructing a ScalingRule resource.
        :param pulumi.Input[_builtins.str] scaling_group_id: ID of the scaling group of a scaling rule.
        :param pulumi.Input[_builtins.str] adjustment_type: Adjustment mode of a scaling rule. Optional values:
               - QuantityChangeInCapacity: It is used to increase or decrease a specified number of ECS instances.
               - PercentChangeInCapacity: It is used to increase or decrease a specified proportion of ECS instances.
               - TotalCapacity: It is used to adjust the quantity of ECS instances in the current scaling group to a specified value.
        :param pulumi.Input[_builtins.int] adjustment_value: The number of ECS instances to be adjusted in the scaling rule. This parameter is required and applicable only to simple scaling rules. The number of ECS instances to be adjusted in a single scaling activity cannot exceed 500. Value range:
               - QuantityChangeInCapacity：(0, 500] U (-500, 0]
               - PercentChangeInCapacity：[0, 10000] U [-100, 0]
               - TotalCapacity：[0, 1000]
        :param pulumi.Input['ScalingRuleAlarmDimensionArgs'] alarm_dimension: AlarmDimension for StepScalingRule. See `alarm_dimension` below.
        :param pulumi.Input[_builtins.int] cooldown: The cooldown time of the scaling rule. This parameter is applicable only to simple scaling rules. Value range: [0, 86,400], in seconds. The default value is empty，if not set, the return value will be 0, which is the default value of integer.
        :param pulumi.Input[_builtins.bool] disable_scale_in: Indicates whether scale in by the target tracking policy is disabled. Default to false.
        :param pulumi.Input[_builtins.int] estimated_instance_warmup: The estimated time, in seconds, until a newly launched instance will contribute CloudMonitor metrics. Default to 300.
        :param pulumi.Input[Sequence[pulumi.Input['ScalingRuleHybridMetricArgs']]] hybrid_metrics: The Hybrid Cloud Monitoring metrics. See `hybrid_metrics` below.
        :param pulumi.Input[_builtins.str] hybrid_monitor_namespace: The ID of the Hybrid Cloud Monitoring metric repository.
        :param pulumi.Input[_builtins.int] initial_max_size: The maximum number of ECS instances that can be added to the scaling group. If you specify InitialMaxSize, you must also specify PredictiveValueBehavior.
        :param pulumi.Input[_builtins.str] metric_name: A CloudMonitor metric name.
        :param pulumi.Input[_builtins.str] metric_type: The type of the metric. Valid values: system, custom, hybrid.
        :param pulumi.Input[_builtins.int] min_adjustment_magnitude: The minimum number of instances that must be scaled. This parameter takes effect if you set ScalingRuleType to SimpleScalingRule or StepScalingRule, and AdjustmentType to PercentChangeInCapacity.
        :param pulumi.Input[_builtins.str] predictive_scaling_mode: The mode of the predictive scaling rule. Valid values: PredictAndScale, PredictOnly.
        :param pulumi.Input[_builtins.int] predictive_task_buffer_time: The amount of buffer time before the prediction task runs. By default, all prediction tasks that are automatically created by a predictive scaling rule run on the hour. You can specify a buffer time to run prediction tasks and prepare resources in advance. Valid values: 0 to 60. Unit: minutes.
        :param pulumi.Input[_builtins.str] predictive_value_behavior: The action on the predicted maximum value. Valid values: MaxOverridePredictiveValue, PredictiveValueOverrideMax, PredictiveValueOverrideMaxWithBuffer.
        :param pulumi.Input[_builtins.int] predictive_value_buffer: The ratio based on which the predicted value is increased if you set PredictiveValueBehavior to PredictiveValueOverrideMaxWithBuffer. If the predicted value increased by this ratio is greater than the initial maximum capacity, the increased value is used as the maximum value for prediction tasks. Valid values: 0 to 100.
        :param pulumi.Input[_builtins.int] scale_in_evaluation_count: The number of consecutive times that the event-triggered task created for scale-ins must meet the threshold conditions before an alert is triggered. After a target tracking scaling rule is created, an event-triggered task is automatically created and associated with the target tracking scaling rule.
        :param pulumi.Input[_builtins.int] scale_out_evaluation_count: The number of consecutive times that the event-triggered task created for scale-outs must meet the threshold conditions before an alert is triggered. After a target tracking scaling rule is created, an event-triggered task is automatically created and associated with the target tracking scaling rule.
        :param pulumi.Input[_builtins.str] scaling_rule_name: Name shown for the scaling rule, which must contain 2-64 characters (English or Chinese), starting with numbers, English letters or Chinese characters, and can contain number, underscores `_`, hypens `-`, and decimal point `.`. If this parameter value is not specified, the default value is scaling rule id.
        :param pulumi.Input[_builtins.str] scaling_rule_type: The scaling rule type, either "SimpleScalingRule", "TargetTrackingScalingRule", "StepScalingRule", "PredictiveScalingRule". Default to "SimpleScalingRule".
        :param pulumi.Input[Sequence[pulumi.Input['ScalingRuleStepAdjustmentArgs']]] step_adjustments: Steps for StepScalingRule. See `step_adjustment` below.
        :param pulumi.Input[_builtins.float] target_value: The target value for the metric.
        """
        pulumi.set(__self__, "scaling_group_id", scaling_group_id)
        if adjustment_type is not None:
            pulumi.set(__self__, "adjustment_type", adjustment_type)
        if adjustment_value is not None:
            pulumi.set(__self__, "adjustment_value", adjustment_value)
        if alarm_dimension is not None:
            pulumi.set(__self__, "alarm_dimension", alarm_dimension)
        if cooldown is not None:
            pulumi.set(__self__, "cooldown", cooldown)
        if disable_scale_in is not None:
            pulumi.set(__self__, "disable_scale_in", disable_scale_in)
        if estimated_instance_warmup is not None:
            pulumi.set(__self__, "estimated_instance_warmup", estimated_instance_warmup)
        if hybrid_metrics is not None:
            pulumi.set(__self__, "hybrid_metrics", hybrid_metrics)
        if hybrid_monitor_namespace is not None:
            pulumi.set(__self__, "hybrid_monitor_namespace", hybrid_monitor_namespace)
        if initial_max_size is not None:
            pulumi.set(__self__, "initial_max_size", initial_max_size)
        if metric_name is not None:
            pulumi.set(__self__, "metric_name", metric_name)
        if metric_type is not None:
            pulumi.set(__self__, "metric_type", metric_type)
        if min_adjustment_magnitude is not None:
            pulumi.set(__self__, "min_adjustment_magnitude", min_adjustment_magnitude)
        if predictive_scaling_mode is not None:
            pulumi.set(__self__, "predictive_scaling_mode", predictive_scaling_mode)
        if predictive_task_buffer_time is not None:
            pulumi.set(__self__, "predictive_task_buffer_time", predictive_task_buffer_time)
        if predictive_value_behavior is not None:
            pulumi.set(__self__, "predictive_value_behavior", predictive_value_behavior)
        if predictive_value_buffer is not None:
            pulumi.set(__self__, "predictive_value_buffer", predictive_value_buffer)
        if scale_in_evaluation_count is not None:
            pulumi.set(__self__, "scale_in_evaluation_count", scale_in_evaluation_count)
        if scale_out_evaluation_count is not None:
            pulumi.set(__self__, "scale_out_evaluation_count", scale_out_evaluation_count)
        if scaling_rule_name is not None:
            pulumi.set(__self__, "scaling_rule_name", scaling_rule_name)
        if scaling_rule_type is not None:
            pulumi.set(__self__, "scaling_rule_type", scaling_rule_type)
        if step_adjustments is not None:
            pulumi.set(__self__, "step_adjustments", step_adjustments)
        if target_value is not None:
            pulumi.set(__self__, "target_value", target_value)

    @_builtins.property
    @pulumi.getter(name="scalingGroupId")
    def scaling_group_id(self) -> pulumi.Input[_builtins.str]:
        """
        ID of the scaling group of a scaling rule.
        """
        return pulumi.get(self, "scaling_group_id")

    @scaling_group_id.setter
    def scaling_group_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "scaling_group_id", value)

    @_builtins.property
    @pulumi.getter(name="adjustmentType")
    def adjustment_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Adjustment mode of a scaling rule. Optional values:
        - QuantityChangeInCapacity: It is used to increase or decrease a specified number of ECS instances.
        - PercentChangeInCapacity: It is used to increase or decrease a specified proportion of ECS instances.
        - TotalCapacity: It is used to adjust the quantity of ECS instances in the current scaling group to a specified value.
        """
        return pulumi.get(self, "adjustment_type")

    @adjustment_type.setter
    def adjustment_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "adjustment_type", value)

    @_builtins.property
    @pulumi.getter(name="adjustmentValue")
    def adjustment_value(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of ECS instances to be adjusted in the scaling rule. This parameter is required and applicable only to simple scaling rules. The number of ECS instances to be adjusted in a single scaling activity cannot exceed 500. Value range:
        - QuantityChangeInCapacity：(0, 500] U (-500, 0]
        - PercentChangeInCapacity：[0, 10000] U [-100, 0]
        - TotalCapacity：[0, 1000]
        """
        return pulumi.get(self, "adjustment_value")

    @adjustment_value.setter
    def adjustment_value(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "adjustment_value", value)

    @_builtins.property
    @pulumi.getter(name="alarmDimension")
    def alarm_dimension(self) -> Optional[pulumi.Input['ScalingRuleAlarmDimensionArgs']]:
        """
        AlarmDimension for StepScalingRule. See `alarm_dimension` below.
        """
        return pulumi.get(self, "alarm_dimension")

    @alarm_dimension.setter
    def alarm_dimension(self, value: Optional[pulumi.Input['ScalingRuleAlarmDimensionArgs']]):
        pulumi.set(self, "alarm_dimension", value)

    @_builtins.property
    @pulumi.getter
    def cooldown(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The cooldown time of the scaling rule. This parameter is applicable only to simple scaling rules. Value range: [0, 86,400], in seconds. The default value is empty，if not set, the return value will be 0, which is the default value of integer.
        """
        return pulumi.get(self, "cooldown")

    @cooldown.setter
    def cooldown(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cooldown", value)

    @_builtins.property
    @pulumi.getter(name="disableScaleIn")
    def disable_scale_in(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether scale in by the target tracking policy is disabled. Default to false.
        """
        return pulumi.get(self, "disable_scale_in")

    @disable_scale_in.setter
    def disable_scale_in(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_scale_in", value)

    @_builtins.property
    @pulumi.getter(name="estimatedInstanceWarmup")
    def estimated_instance_warmup(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The estimated time, in seconds, until a newly launched instance will contribute CloudMonitor metrics. Default to 300.
        """
        return pulumi.get(self, "estimated_instance_warmup")

    @estimated_instance_warmup.setter
    def estimated_instance_warmup(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "estimated_instance_warmup", value)

    @_builtins.property
    @pulumi.getter(name="hybridMetrics")
    def hybrid_metrics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ScalingRuleHybridMetricArgs']]]]:
        """
        The Hybrid Cloud Monitoring metrics. See `hybrid_metrics` below.
        """
        return pulumi.get(self, "hybrid_metrics")

    @hybrid_metrics.setter
    def hybrid_metrics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ScalingRuleHybridMetricArgs']]]]):
        pulumi.set(self, "hybrid_metrics", value)

    @_builtins.property
    @pulumi.getter(name="hybridMonitorNamespace")
    def hybrid_monitor_namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Hybrid Cloud Monitoring metric repository.
        """
        return pulumi.get(self, "hybrid_monitor_namespace")

    @hybrid_monitor_namespace.setter
    def hybrid_monitor_namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hybrid_monitor_namespace", value)

    @_builtins.property
    @pulumi.getter(name="initialMaxSize")
    def initial_max_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum number of ECS instances that can be added to the scaling group. If you specify InitialMaxSize, you must also specify PredictiveValueBehavior.
        """
        return pulumi.get(self, "initial_max_size")

    @initial_max_size.setter
    def initial_max_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "initial_max_size", value)

    @_builtins.property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A CloudMonitor metric name.
        """
        return pulumi.get(self, "metric_name")

    @metric_name.setter
    def metric_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "metric_name", value)

    @_builtins.property
    @pulumi.getter(name="metricType")
    def metric_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the metric. Valid values: system, custom, hybrid.
        """
        return pulumi.get(self, "metric_type")

    @metric_type.setter
    def metric_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "metric_type", value)

    @_builtins.property
    @pulumi.getter(name="minAdjustmentMagnitude")
    def min_adjustment_magnitude(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The minimum number of instances that must be scaled. This parameter takes effect if you set ScalingRuleType to SimpleScalingRule or StepScalingRule, and AdjustmentType to PercentChangeInCapacity.
        """
        return pulumi.get(self, "min_adjustment_magnitude")

    @min_adjustment_magnitude.setter
    def min_adjustment_magnitude(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_adjustment_magnitude", value)

    @_builtins.property
    @pulumi.getter(name="predictiveScalingMode")
    def predictive_scaling_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The mode of the predictive scaling rule. Valid values: PredictAndScale, PredictOnly.
        """
        return pulumi.get(self, "predictive_scaling_mode")

    @predictive_scaling_mode.setter
    def predictive_scaling_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "predictive_scaling_mode", value)

    @_builtins.property
    @pulumi.getter(name="predictiveTaskBufferTime")
    def predictive_task_buffer_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The amount of buffer time before the prediction task runs. By default, all prediction tasks that are automatically created by a predictive scaling rule run on the hour. You can specify a buffer time to run prediction tasks and prepare resources in advance. Valid values: 0 to 60. Unit: minutes.
        """
        return pulumi.get(self, "predictive_task_buffer_time")

    @predictive_task_buffer_time.setter
    def predictive_task_buffer_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "predictive_task_buffer_time", value)

    @_builtins.property
    @pulumi.getter(name="predictiveValueBehavior")
    def predictive_value_behavior(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The action on the predicted maximum value. Valid values: MaxOverridePredictiveValue, PredictiveValueOverrideMax, PredictiveValueOverrideMaxWithBuffer.
        """
        return pulumi.get(self, "predictive_value_behavior")

    @predictive_value_behavior.setter
    def predictive_value_behavior(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "predictive_value_behavior", value)

    @_builtins.property
    @pulumi.getter(name="predictiveValueBuffer")
    def predictive_value_buffer(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The ratio based on which the predicted value is increased if you set PredictiveValueBehavior to PredictiveValueOverrideMaxWithBuffer. If the predicted value increased by this ratio is greater than the initial maximum capacity, the increased value is used as the maximum value for prediction tasks. Valid values: 0 to 100.
        """
        return pulumi.get(self, "predictive_value_buffer")

    @predictive_value_buffer.setter
    def predictive_value_buffer(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "predictive_value_buffer", value)

    @_builtins.property
    @pulumi.getter(name="scaleInEvaluationCount")
    def scale_in_evaluation_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of consecutive times that the event-triggered task created for scale-ins must meet the threshold conditions before an alert is triggered. After a target tracking scaling rule is created, an event-triggered task is automatically created and associated with the target tracking scaling rule.
        """
        return pulumi.get(self, "scale_in_evaluation_count")

    @scale_in_evaluation_count.setter
    def scale_in_evaluation_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "scale_in_evaluation_count", value)

    @_builtins.property
    @pulumi.getter(name="scaleOutEvaluationCount")
    def scale_out_evaluation_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of consecutive times that the event-triggered task created for scale-outs must meet the threshold conditions before an alert is triggered. After a target tracking scaling rule is created, an event-triggered task is automatically created and associated with the target tracking scaling rule.
        """
        return pulumi.get(self, "scale_out_evaluation_count")

    @scale_out_evaluation_count.setter
    def scale_out_evaluation_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "scale_out_evaluation_count", value)

    @_builtins.property
    @pulumi.getter(name="scalingRuleName")
    def scaling_rule_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name shown for the scaling rule, which must contain 2-64 characters (English or Chinese), starting with numbers, English letters or Chinese characters, and can contain number, underscores `_`, hypens `-`, and decimal point `.`. If this parameter value is not specified, the default value is scaling rule id.
        """
        return pulumi.get(self, "scaling_rule_name")

    @scaling_rule_name.setter
    def scaling_rule_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scaling_rule_name", value)

    @_builtins.property
    @pulumi.getter(name="scalingRuleType")
    def scaling_rule_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The scaling rule type, either "SimpleScalingRule", "TargetTrackingScalingRule", "StepScalingRule", "PredictiveScalingRule". Default to "SimpleScalingRule".
        """
        return pulumi.get(self, "scaling_rule_type")

    @scaling_rule_type.setter
    def scaling_rule_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scaling_rule_type", value)

    @_builtins.property
    @pulumi.getter(name="stepAdjustments")
    def step_adjustments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ScalingRuleStepAdjustmentArgs']]]]:
        """
        Steps for StepScalingRule. See `step_adjustment` below.
        """
        return pulumi.get(self, "step_adjustments")

    @step_adjustments.setter
    def step_adjustments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ScalingRuleStepAdjustmentArgs']]]]):
        pulumi.set(self, "step_adjustments", value)

    @_builtins.property
    @pulumi.getter(name="targetValue")
    def target_value(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The target value for the metric.
        """
        return pulumi.get(self, "target_value")

    @target_value.setter
    def target_value(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "target_value", value)


@pulumi.input_type
class _ScalingRuleState:
    def __init__(__self__, *,
                 adjustment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 adjustment_value: Optional[pulumi.Input[_builtins.int]] = None,
                 alarm_dimension: Optional[pulumi.Input['ScalingRuleAlarmDimensionArgs']] = None,
                 ari: Optional[pulumi.Input[_builtins.str]] = None,
                 cooldown: Optional[pulumi.Input[_builtins.int]] = None,
                 disable_scale_in: Optional[pulumi.Input[_builtins.bool]] = None,
                 estimated_instance_warmup: Optional[pulumi.Input[_builtins.int]] = None,
                 hybrid_metrics: Optional[pulumi.Input[Sequence[pulumi.Input['ScalingRuleHybridMetricArgs']]]] = None,
                 hybrid_monitor_namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 initial_max_size: Optional[pulumi.Input[_builtins.int]] = None,
                 metric_name: Optional[pulumi.Input[_builtins.str]] = None,
                 metric_type: Optional[pulumi.Input[_builtins.str]] = None,
                 min_adjustment_magnitude: Optional[pulumi.Input[_builtins.int]] = None,
                 predictive_scaling_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 predictive_task_buffer_time: Optional[pulumi.Input[_builtins.int]] = None,
                 predictive_value_behavior: Optional[pulumi.Input[_builtins.str]] = None,
                 predictive_value_buffer: Optional[pulumi.Input[_builtins.int]] = None,
                 scale_in_evaluation_count: Optional[pulumi.Input[_builtins.int]] = None,
                 scale_out_evaluation_count: Optional[pulumi.Input[_builtins.int]] = None,
                 scaling_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 scaling_rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 scaling_rule_type: Optional[pulumi.Input[_builtins.str]] = None,
                 step_adjustments: Optional[pulumi.Input[Sequence[pulumi.Input['ScalingRuleStepAdjustmentArgs']]]] = None,
                 target_value: Optional[pulumi.Input[_builtins.float]] = None):
        """
        Input properties used for looking up and filtering ScalingRule resources.
        :param pulumi.Input[_builtins.str] adjustment_type: Adjustment mode of a scaling rule. Optional values:
               - QuantityChangeInCapacity: It is used to increase or decrease a specified number of ECS instances.
               - PercentChangeInCapacity: It is used to increase or decrease a specified proportion of ECS instances.
               - TotalCapacity: It is used to adjust the quantity of ECS instances in the current scaling group to a specified value.
        :param pulumi.Input[_builtins.int] adjustment_value: The number of ECS instances to be adjusted in the scaling rule. This parameter is required and applicable only to simple scaling rules. The number of ECS instances to be adjusted in a single scaling activity cannot exceed 500. Value range:
               - QuantityChangeInCapacity：(0, 500] U (-500, 0]
               - PercentChangeInCapacity：[0, 10000] U [-100, 0]
               - TotalCapacity：[0, 1000]
        :param pulumi.Input['ScalingRuleAlarmDimensionArgs'] alarm_dimension: AlarmDimension for StepScalingRule. See `alarm_dimension` below.
        :param pulumi.Input[_builtins.str] ari: The unique identifier of the scaling rule.
        :param pulumi.Input[_builtins.int] cooldown: The cooldown time of the scaling rule. This parameter is applicable only to simple scaling rules. Value range: [0, 86,400], in seconds. The default value is empty，if not set, the return value will be 0, which is the default value of integer.
        :param pulumi.Input[_builtins.bool] disable_scale_in: Indicates whether scale in by the target tracking policy is disabled. Default to false.
        :param pulumi.Input[_builtins.int] estimated_instance_warmup: The estimated time, in seconds, until a newly launched instance will contribute CloudMonitor metrics. Default to 300.
        :param pulumi.Input[Sequence[pulumi.Input['ScalingRuleHybridMetricArgs']]] hybrid_metrics: The Hybrid Cloud Monitoring metrics. See `hybrid_metrics` below.
        :param pulumi.Input[_builtins.str] hybrid_monitor_namespace: The ID of the Hybrid Cloud Monitoring metric repository.
        :param pulumi.Input[_builtins.int] initial_max_size: The maximum number of ECS instances that can be added to the scaling group. If you specify InitialMaxSize, you must also specify PredictiveValueBehavior.
        :param pulumi.Input[_builtins.str] metric_name: A CloudMonitor metric name.
        :param pulumi.Input[_builtins.str] metric_type: The type of the metric. Valid values: system, custom, hybrid.
        :param pulumi.Input[_builtins.int] min_adjustment_magnitude: The minimum number of instances that must be scaled. This parameter takes effect if you set ScalingRuleType to SimpleScalingRule or StepScalingRule, and AdjustmentType to PercentChangeInCapacity.
        :param pulumi.Input[_builtins.str] predictive_scaling_mode: The mode of the predictive scaling rule. Valid values: PredictAndScale, PredictOnly.
        :param pulumi.Input[_builtins.int] predictive_task_buffer_time: The amount of buffer time before the prediction task runs. By default, all prediction tasks that are automatically created by a predictive scaling rule run on the hour. You can specify a buffer time to run prediction tasks and prepare resources in advance. Valid values: 0 to 60. Unit: minutes.
        :param pulumi.Input[_builtins.str] predictive_value_behavior: The action on the predicted maximum value. Valid values: MaxOverridePredictiveValue, PredictiveValueOverrideMax, PredictiveValueOverrideMaxWithBuffer.
        :param pulumi.Input[_builtins.int] predictive_value_buffer: The ratio based on which the predicted value is increased if you set PredictiveValueBehavior to PredictiveValueOverrideMaxWithBuffer. If the predicted value increased by this ratio is greater than the initial maximum capacity, the increased value is used as the maximum value for prediction tasks. Valid values: 0 to 100.
        :param pulumi.Input[_builtins.int] scale_in_evaluation_count: The number of consecutive times that the event-triggered task created for scale-ins must meet the threshold conditions before an alert is triggered. After a target tracking scaling rule is created, an event-triggered task is automatically created and associated with the target tracking scaling rule.
        :param pulumi.Input[_builtins.int] scale_out_evaluation_count: The number of consecutive times that the event-triggered task created for scale-outs must meet the threshold conditions before an alert is triggered. After a target tracking scaling rule is created, an event-triggered task is automatically created and associated with the target tracking scaling rule.
        :param pulumi.Input[_builtins.str] scaling_group_id: ID of the scaling group of a scaling rule.
        :param pulumi.Input[_builtins.str] scaling_rule_name: Name shown for the scaling rule, which must contain 2-64 characters (English or Chinese), starting with numbers, English letters or Chinese characters, and can contain number, underscores `_`, hypens `-`, and decimal point `.`. If this parameter value is not specified, the default value is scaling rule id.
        :param pulumi.Input[_builtins.str] scaling_rule_type: The scaling rule type, either "SimpleScalingRule", "TargetTrackingScalingRule", "StepScalingRule", "PredictiveScalingRule". Default to "SimpleScalingRule".
        :param pulumi.Input[Sequence[pulumi.Input['ScalingRuleStepAdjustmentArgs']]] step_adjustments: Steps for StepScalingRule. See `step_adjustment` below.
        :param pulumi.Input[_builtins.float] target_value: The target value for the metric.
        """
        if adjustment_type is not None:
            pulumi.set(__self__, "adjustment_type", adjustment_type)
        if adjustment_value is not None:
            pulumi.set(__self__, "adjustment_value", adjustment_value)
        if alarm_dimension is not None:
            pulumi.set(__self__, "alarm_dimension", alarm_dimension)
        if ari is not None:
            pulumi.set(__self__, "ari", ari)
        if cooldown is not None:
            pulumi.set(__self__, "cooldown", cooldown)
        if disable_scale_in is not None:
            pulumi.set(__self__, "disable_scale_in", disable_scale_in)
        if estimated_instance_warmup is not None:
            pulumi.set(__self__, "estimated_instance_warmup", estimated_instance_warmup)
        if hybrid_metrics is not None:
            pulumi.set(__self__, "hybrid_metrics", hybrid_metrics)
        if hybrid_monitor_namespace is not None:
            pulumi.set(__self__, "hybrid_monitor_namespace", hybrid_monitor_namespace)
        if initial_max_size is not None:
            pulumi.set(__self__, "initial_max_size", initial_max_size)
        if metric_name is not None:
            pulumi.set(__self__, "metric_name", metric_name)
        if metric_type is not None:
            pulumi.set(__self__, "metric_type", metric_type)
        if min_adjustment_magnitude is not None:
            pulumi.set(__self__, "min_adjustment_magnitude", min_adjustment_magnitude)
        if predictive_scaling_mode is not None:
            pulumi.set(__self__, "predictive_scaling_mode", predictive_scaling_mode)
        if predictive_task_buffer_time is not None:
            pulumi.set(__self__, "predictive_task_buffer_time", predictive_task_buffer_time)
        if predictive_value_behavior is not None:
            pulumi.set(__self__, "predictive_value_behavior", predictive_value_behavior)
        if predictive_value_buffer is not None:
            pulumi.set(__self__, "predictive_value_buffer", predictive_value_buffer)
        if scale_in_evaluation_count is not None:
            pulumi.set(__self__, "scale_in_evaluation_count", scale_in_evaluation_count)
        if scale_out_evaluation_count is not None:
            pulumi.set(__self__, "scale_out_evaluation_count", scale_out_evaluation_count)
        if scaling_group_id is not None:
            pulumi.set(__self__, "scaling_group_id", scaling_group_id)
        if scaling_rule_name is not None:
            pulumi.set(__self__, "scaling_rule_name", scaling_rule_name)
        if scaling_rule_type is not None:
            pulumi.set(__self__, "scaling_rule_type", scaling_rule_type)
        if step_adjustments is not None:
            pulumi.set(__self__, "step_adjustments", step_adjustments)
        if target_value is not None:
            pulumi.set(__self__, "target_value", target_value)

    @_builtins.property
    @pulumi.getter(name="adjustmentType")
    def adjustment_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Adjustment mode of a scaling rule. Optional values:
        - QuantityChangeInCapacity: It is used to increase or decrease a specified number of ECS instances.
        - PercentChangeInCapacity: It is used to increase or decrease a specified proportion of ECS instances.
        - TotalCapacity: It is used to adjust the quantity of ECS instances in the current scaling group to a specified value.
        """
        return pulumi.get(self, "adjustment_type")

    @adjustment_type.setter
    def adjustment_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "adjustment_type", value)

    @_builtins.property
    @pulumi.getter(name="adjustmentValue")
    def adjustment_value(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of ECS instances to be adjusted in the scaling rule. This parameter is required and applicable only to simple scaling rules. The number of ECS instances to be adjusted in a single scaling activity cannot exceed 500. Value range:
        - QuantityChangeInCapacity：(0, 500] U (-500, 0]
        - PercentChangeInCapacity：[0, 10000] U [-100, 0]
        - TotalCapacity：[0, 1000]
        """
        return pulumi.get(self, "adjustment_value")

    @adjustment_value.setter
    def adjustment_value(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "adjustment_value", value)

    @_builtins.property
    @pulumi.getter(name="alarmDimension")
    def alarm_dimension(self) -> Optional[pulumi.Input['ScalingRuleAlarmDimensionArgs']]:
        """
        AlarmDimension for StepScalingRule. See `alarm_dimension` below.
        """
        return pulumi.get(self, "alarm_dimension")

    @alarm_dimension.setter
    def alarm_dimension(self, value: Optional[pulumi.Input['ScalingRuleAlarmDimensionArgs']]):
        pulumi.set(self, "alarm_dimension", value)

    @_builtins.property
    @pulumi.getter
    def ari(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique identifier of the scaling rule.
        """
        return pulumi.get(self, "ari")

    @ari.setter
    def ari(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ari", value)

    @_builtins.property
    @pulumi.getter
    def cooldown(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The cooldown time of the scaling rule. This parameter is applicable only to simple scaling rules. Value range: [0, 86,400], in seconds. The default value is empty，if not set, the return value will be 0, which is the default value of integer.
        """
        return pulumi.get(self, "cooldown")

    @cooldown.setter
    def cooldown(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cooldown", value)

    @_builtins.property
    @pulumi.getter(name="disableScaleIn")
    def disable_scale_in(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether scale in by the target tracking policy is disabled. Default to false.
        """
        return pulumi.get(self, "disable_scale_in")

    @disable_scale_in.setter
    def disable_scale_in(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_scale_in", value)

    @_builtins.property
    @pulumi.getter(name="estimatedInstanceWarmup")
    def estimated_instance_warmup(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The estimated time, in seconds, until a newly launched instance will contribute CloudMonitor metrics. Default to 300.
        """
        return pulumi.get(self, "estimated_instance_warmup")

    @estimated_instance_warmup.setter
    def estimated_instance_warmup(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "estimated_instance_warmup", value)

    @_builtins.property
    @pulumi.getter(name="hybridMetrics")
    def hybrid_metrics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ScalingRuleHybridMetricArgs']]]]:
        """
        The Hybrid Cloud Monitoring metrics. See `hybrid_metrics` below.
        """
        return pulumi.get(self, "hybrid_metrics")

    @hybrid_metrics.setter
    def hybrid_metrics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ScalingRuleHybridMetricArgs']]]]):
        pulumi.set(self, "hybrid_metrics", value)

    @_builtins.property
    @pulumi.getter(name="hybridMonitorNamespace")
    def hybrid_monitor_namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Hybrid Cloud Monitoring metric repository.
        """
        return pulumi.get(self, "hybrid_monitor_namespace")

    @hybrid_monitor_namespace.setter
    def hybrid_monitor_namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hybrid_monitor_namespace", value)

    @_builtins.property
    @pulumi.getter(name="initialMaxSize")
    def initial_max_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum number of ECS instances that can be added to the scaling group. If you specify InitialMaxSize, you must also specify PredictiveValueBehavior.
        """
        return pulumi.get(self, "initial_max_size")

    @initial_max_size.setter
    def initial_max_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "initial_max_size", value)

    @_builtins.property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A CloudMonitor metric name.
        """
        return pulumi.get(self, "metric_name")

    @metric_name.setter
    def metric_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "metric_name", value)

    @_builtins.property
    @pulumi.getter(name="metricType")
    def metric_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the metric. Valid values: system, custom, hybrid.
        """
        return pulumi.get(self, "metric_type")

    @metric_type.setter
    def metric_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "metric_type", value)

    @_builtins.property
    @pulumi.getter(name="minAdjustmentMagnitude")
    def min_adjustment_magnitude(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The minimum number of instances that must be scaled. This parameter takes effect if you set ScalingRuleType to SimpleScalingRule or StepScalingRule, and AdjustmentType to PercentChangeInCapacity.
        """
        return pulumi.get(self, "min_adjustment_magnitude")

    @min_adjustment_magnitude.setter
    def min_adjustment_magnitude(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_adjustment_magnitude", value)

    @_builtins.property
    @pulumi.getter(name="predictiveScalingMode")
    def predictive_scaling_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The mode of the predictive scaling rule. Valid values: PredictAndScale, PredictOnly.
        """
        return pulumi.get(self, "predictive_scaling_mode")

    @predictive_scaling_mode.setter
    def predictive_scaling_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "predictive_scaling_mode", value)

    @_builtins.property
    @pulumi.getter(name="predictiveTaskBufferTime")
    def predictive_task_buffer_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The amount of buffer time before the prediction task runs. By default, all prediction tasks that are automatically created by a predictive scaling rule run on the hour. You can specify a buffer time to run prediction tasks and prepare resources in advance. Valid values: 0 to 60. Unit: minutes.
        """
        return pulumi.get(self, "predictive_task_buffer_time")

    @predictive_task_buffer_time.setter
    def predictive_task_buffer_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "predictive_task_buffer_time", value)

    @_builtins.property
    @pulumi.getter(name="predictiveValueBehavior")
    def predictive_value_behavior(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The action on the predicted maximum value. Valid values: MaxOverridePredictiveValue, PredictiveValueOverrideMax, PredictiveValueOverrideMaxWithBuffer.
        """
        return pulumi.get(self, "predictive_value_behavior")

    @predictive_value_behavior.setter
    def predictive_value_behavior(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "predictive_value_behavior", value)

    @_builtins.property
    @pulumi.getter(name="predictiveValueBuffer")
    def predictive_value_buffer(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The ratio based on which the predicted value is increased if you set PredictiveValueBehavior to PredictiveValueOverrideMaxWithBuffer. If the predicted value increased by this ratio is greater than the initial maximum capacity, the increased value is used as the maximum value for prediction tasks. Valid values: 0 to 100.
        """
        return pulumi.get(self, "predictive_value_buffer")

    @predictive_value_buffer.setter
    def predictive_value_buffer(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "predictive_value_buffer", value)

    @_builtins.property
    @pulumi.getter(name="scaleInEvaluationCount")
    def scale_in_evaluation_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of consecutive times that the event-triggered task created for scale-ins must meet the threshold conditions before an alert is triggered. After a target tracking scaling rule is created, an event-triggered task is automatically created and associated with the target tracking scaling rule.
        """
        return pulumi.get(self, "scale_in_evaluation_count")

    @scale_in_evaluation_count.setter
    def scale_in_evaluation_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "scale_in_evaluation_count", value)

    @_builtins.property
    @pulumi.getter(name="scaleOutEvaluationCount")
    def scale_out_evaluation_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of consecutive times that the event-triggered task created for scale-outs must meet the threshold conditions before an alert is triggered. After a target tracking scaling rule is created, an event-triggered task is automatically created and associated with the target tracking scaling rule.
        """
        return pulumi.get(self, "scale_out_evaluation_count")

    @scale_out_evaluation_count.setter
    def scale_out_evaluation_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "scale_out_evaluation_count", value)

    @_builtins.property
    @pulumi.getter(name="scalingGroupId")
    def scaling_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the scaling group of a scaling rule.
        """
        return pulumi.get(self, "scaling_group_id")

    @scaling_group_id.setter
    def scaling_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scaling_group_id", value)

    @_builtins.property
    @pulumi.getter(name="scalingRuleName")
    def scaling_rule_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name shown for the scaling rule, which must contain 2-64 characters (English or Chinese), starting with numbers, English letters or Chinese characters, and can contain number, underscores `_`, hypens `-`, and decimal point `.`. If this parameter value is not specified, the default value is scaling rule id.
        """
        return pulumi.get(self, "scaling_rule_name")

    @scaling_rule_name.setter
    def scaling_rule_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scaling_rule_name", value)

    @_builtins.property
    @pulumi.getter(name="scalingRuleType")
    def scaling_rule_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The scaling rule type, either "SimpleScalingRule", "TargetTrackingScalingRule", "StepScalingRule", "PredictiveScalingRule". Default to "SimpleScalingRule".
        """
        return pulumi.get(self, "scaling_rule_type")

    @scaling_rule_type.setter
    def scaling_rule_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scaling_rule_type", value)

    @_builtins.property
    @pulumi.getter(name="stepAdjustments")
    def step_adjustments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ScalingRuleStepAdjustmentArgs']]]]:
        """
        Steps for StepScalingRule. See `step_adjustment` below.
        """
        return pulumi.get(self, "step_adjustments")

    @step_adjustments.setter
    def step_adjustments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ScalingRuleStepAdjustmentArgs']]]]):
        pulumi.set(self, "step_adjustments", value)

    @_builtins.property
    @pulumi.getter(name="targetValue")
    def target_value(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The target value for the metric.
        """
        return pulumi.get(self, "target_value")

    @target_value.setter
    def target_value(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "target_value", value)


@pulumi.type_token("alicloud:ess/scalingRule:ScalingRule")
class ScalingRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 adjustment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 adjustment_value: Optional[pulumi.Input[_builtins.int]] = None,
                 alarm_dimension: Optional[pulumi.Input[Union['ScalingRuleAlarmDimensionArgs', 'ScalingRuleAlarmDimensionArgsDict']]] = None,
                 cooldown: Optional[pulumi.Input[_builtins.int]] = None,
                 disable_scale_in: Optional[pulumi.Input[_builtins.bool]] = None,
                 estimated_instance_warmup: Optional[pulumi.Input[_builtins.int]] = None,
                 hybrid_metrics: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ScalingRuleHybridMetricArgs', 'ScalingRuleHybridMetricArgsDict']]]]] = None,
                 hybrid_monitor_namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 initial_max_size: Optional[pulumi.Input[_builtins.int]] = None,
                 metric_name: Optional[pulumi.Input[_builtins.str]] = None,
                 metric_type: Optional[pulumi.Input[_builtins.str]] = None,
                 min_adjustment_magnitude: Optional[pulumi.Input[_builtins.int]] = None,
                 predictive_scaling_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 predictive_task_buffer_time: Optional[pulumi.Input[_builtins.int]] = None,
                 predictive_value_behavior: Optional[pulumi.Input[_builtins.str]] = None,
                 predictive_value_buffer: Optional[pulumi.Input[_builtins.int]] = None,
                 scale_in_evaluation_count: Optional[pulumi.Input[_builtins.int]] = None,
                 scale_out_evaluation_count: Optional[pulumi.Input[_builtins.int]] = None,
                 scaling_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 scaling_rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 scaling_rule_type: Optional[pulumi.Input[_builtins.str]] = None,
                 step_adjustments: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ScalingRuleStepAdjustmentArgs', 'ScalingRuleStepAdjustmentArgsDict']]]]] = None,
                 target_value: Optional[pulumi.Input[_builtins.float]] = None,
                 __props__=None):
        """
        Provides a ESS scaling rule resource.

        For information about ess scaling rule, see [CreateScalingRule](https://www.alibabacloud.com/help/en/auto-scaling/latest/createscalingrule).

        > **NOTE:** Available since v1.39.0.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default_integer = random.index.Integer("default",
            min=10000,
            max=99999)
        my_name = f"{name}-{default_integer['result']}"
        default = alicloud.get_zones(available_disk_category="cloud_efficiency",
            available_resource_creation="VSwitch")
        default_get_instance_types = alicloud.ecs.get_instance_types(availability_zone=default.zones[0].id,
            cpu_core_count=2,
            memory_size=4)
        default_get_images = alicloud.ecs.get_images(name_regex="^ubuntu_18.*64",
            most_recent=True,
            owners="system")
        default_network = alicloud.vpc.Network("default",
            vpc_name=my_name,
            cidr_block="172.16.0.0/16")
        default_switch = alicloud.vpc.Switch("default",
            vpc_id=default_network.id,
            cidr_block="172.16.0.0/24",
            zone_id=default.zones[0].id,
            vswitch_name=my_name)
        default_security_group = alicloud.ecs.SecurityGroup("default",
            security_group_name=my_name,
            vpc_id=default_network.id)
        default_security_group_rule = alicloud.ecs.SecurityGroupRule("default",
            type="ingress",
            ip_protocol="tcp",
            nic_type="intranet",
            policy="accept",
            port_range="22/22",
            priority=1,
            security_group_id=default_security_group.id,
            cidr_ip="172.16.0.0/24")
        default_scaling_group = alicloud.ess.ScalingGroup("default",
            min_size=1,
            max_size=1,
            scaling_group_name=my_name,
            vswitch_ids=[default_switch.id],
            removal_policies=[
                "OldestInstance",
                "NewestInstance",
            ])
        default_scaling_configuration = alicloud.ess.ScalingConfiguration("default",
            scaling_group_id=default_scaling_group.id,
            image_id=default_get_images.images[0].id,
            instance_type=default_get_instance_types.instance_types[0].id,
            security_group_id=default_security_group.id,
            force_delete=True)
        default_scaling_rule = alicloud.ess.ScalingRule("default",
            scaling_group_id=default_scaling_group.id,
            adjustment_type="TotalCapacity",
            adjustment_value=1)
        ```

        ## Module Support

        You can use to the existing autoscaling-rule module
        to create different type rules, alarm task and scheduled task one-click.

        ## Import

        ESS scaling rule can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ess/scalingRule:ScalingRule example abc123456
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] adjustment_type: Adjustment mode of a scaling rule. Optional values:
               - QuantityChangeInCapacity: It is used to increase or decrease a specified number of ECS instances.
               - PercentChangeInCapacity: It is used to increase or decrease a specified proportion of ECS instances.
               - TotalCapacity: It is used to adjust the quantity of ECS instances in the current scaling group to a specified value.
        :param pulumi.Input[_builtins.int] adjustment_value: The number of ECS instances to be adjusted in the scaling rule. This parameter is required and applicable only to simple scaling rules. The number of ECS instances to be adjusted in a single scaling activity cannot exceed 500. Value range:
               - QuantityChangeInCapacity：(0, 500] U (-500, 0]
               - PercentChangeInCapacity：[0, 10000] U [-100, 0]
               - TotalCapacity：[0, 1000]
        :param pulumi.Input[Union['ScalingRuleAlarmDimensionArgs', 'ScalingRuleAlarmDimensionArgsDict']] alarm_dimension: AlarmDimension for StepScalingRule. See `alarm_dimension` below.
        :param pulumi.Input[_builtins.int] cooldown: The cooldown time of the scaling rule. This parameter is applicable only to simple scaling rules. Value range: [0, 86,400], in seconds. The default value is empty，if not set, the return value will be 0, which is the default value of integer.
        :param pulumi.Input[_builtins.bool] disable_scale_in: Indicates whether scale in by the target tracking policy is disabled. Default to false.
        :param pulumi.Input[_builtins.int] estimated_instance_warmup: The estimated time, in seconds, until a newly launched instance will contribute CloudMonitor metrics. Default to 300.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ScalingRuleHybridMetricArgs', 'ScalingRuleHybridMetricArgsDict']]]] hybrid_metrics: The Hybrid Cloud Monitoring metrics. See `hybrid_metrics` below.
        :param pulumi.Input[_builtins.str] hybrid_monitor_namespace: The ID of the Hybrid Cloud Monitoring metric repository.
        :param pulumi.Input[_builtins.int] initial_max_size: The maximum number of ECS instances that can be added to the scaling group. If you specify InitialMaxSize, you must also specify PredictiveValueBehavior.
        :param pulumi.Input[_builtins.str] metric_name: A CloudMonitor metric name.
        :param pulumi.Input[_builtins.str] metric_type: The type of the metric. Valid values: system, custom, hybrid.
        :param pulumi.Input[_builtins.int] min_adjustment_magnitude: The minimum number of instances that must be scaled. This parameter takes effect if you set ScalingRuleType to SimpleScalingRule or StepScalingRule, and AdjustmentType to PercentChangeInCapacity.
        :param pulumi.Input[_builtins.str] predictive_scaling_mode: The mode of the predictive scaling rule. Valid values: PredictAndScale, PredictOnly.
        :param pulumi.Input[_builtins.int] predictive_task_buffer_time: The amount of buffer time before the prediction task runs. By default, all prediction tasks that are automatically created by a predictive scaling rule run on the hour. You can specify a buffer time to run prediction tasks and prepare resources in advance. Valid values: 0 to 60. Unit: minutes.
        :param pulumi.Input[_builtins.str] predictive_value_behavior: The action on the predicted maximum value. Valid values: MaxOverridePredictiveValue, PredictiveValueOverrideMax, PredictiveValueOverrideMaxWithBuffer.
        :param pulumi.Input[_builtins.int] predictive_value_buffer: The ratio based on which the predicted value is increased if you set PredictiveValueBehavior to PredictiveValueOverrideMaxWithBuffer. If the predicted value increased by this ratio is greater than the initial maximum capacity, the increased value is used as the maximum value for prediction tasks. Valid values: 0 to 100.
        :param pulumi.Input[_builtins.int] scale_in_evaluation_count: The number of consecutive times that the event-triggered task created for scale-ins must meet the threshold conditions before an alert is triggered. After a target tracking scaling rule is created, an event-triggered task is automatically created and associated with the target tracking scaling rule.
        :param pulumi.Input[_builtins.int] scale_out_evaluation_count: The number of consecutive times that the event-triggered task created for scale-outs must meet the threshold conditions before an alert is triggered. After a target tracking scaling rule is created, an event-triggered task is automatically created and associated with the target tracking scaling rule.
        :param pulumi.Input[_builtins.str] scaling_group_id: ID of the scaling group of a scaling rule.
        :param pulumi.Input[_builtins.str] scaling_rule_name: Name shown for the scaling rule, which must contain 2-64 characters (English or Chinese), starting with numbers, English letters or Chinese characters, and can contain number, underscores `_`, hypens `-`, and decimal point `.`. If this parameter value is not specified, the default value is scaling rule id.
        :param pulumi.Input[_builtins.str] scaling_rule_type: The scaling rule type, either "SimpleScalingRule", "TargetTrackingScalingRule", "StepScalingRule", "PredictiveScalingRule". Default to "SimpleScalingRule".
        :param pulumi.Input[Sequence[pulumi.Input[Union['ScalingRuleStepAdjustmentArgs', 'ScalingRuleStepAdjustmentArgsDict']]]] step_adjustments: Steps for StepScalingRule. See `step_adjustment` below.
        :param pulumi.Input[_builtins.float] target_value: The target value for the metric.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ScalingRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a ESS scaling rule resource.

        For information about ess scaling rule, see [CreateScalingRule](https://www.alibabacloud.com/help/en/auto-scaling/latest/createscalingrule).

        > **NOTE:** Available since v1.39.0.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default_integer = random.index.Integer("default",
            min=10000,
            max=99999)
        my_name = f"{name}-{default_integer['result']}"
        default = alicloud.get_zones(available_disk_category="cloud_efficiency",
            available_resource_creation="VSwitch")
        default_get_instance_types = alicloud.ecs.get_instance_types(availability_zone=default.zones[0].id,
            cpu_core_count=2,
            memory_size=4)
        default_get_images = alicloud.ecs.get_images(name_regex="^ubuntu_18.*64",
            most_recent=True,
            owners="system")
        default_network = alicloud.vpc.Network("default",
            vpc_name=my_name,
            cidr_block="172.16.0.0/16")
        default_switch = alicloud.vpc.Switch("default",
            vpc_id=default_network.id,
            cidr_block="172.16.0.0/24",
            zone_id=default.zones[0].id,
            vswitch_name=my_name)
        default_security_group = alicloud.ecs.SecurityGroup("default",
            security_group_name=my_name,
            vpc_id=default_network.id)
        default_security_group_rule = alicloud.ecs.SecurityGroupRule("default",
            type="ingress",
            ip_protocol="tcp",
            nic_type="intranet",
            policy="accept",
            port_range="22/22",
            priority=1,
            security_group_id=default_security_group.id,
            cidr_ip="172.16.0.0/24")
        default_scaling_group = alicloud.ess.ScalingGroup("default",
            min_size=1,
            max_size=1,
            scaling_group_name=my_name,
            vswitch_ids=[default_switch.id],
            removal_policies=[
                "OldestInstance",
                "NewestInstance",
            ])
        default_scaling_configuration = alicloud.ess.ScalingConfiguration("default",
            scaling_group_id=default_scaling_group.id,
            image_id=default_get_images.images[0].id,
            instance_type=default_get_instance_types.instance_types[0].id,
            security_group_id=default_security_group.id,
            force_delete=True)
        default_scaling_rule = alicloud.ess.ScalingRule("default",
            scaling_group_id=default_scaling_group.id,
            adjustment_type="TotalCapacity",
            adjustment_value=1)
        ```

        ## Module Support

        You can use to the existing autoscaling-rule module
        to create different type rules, alarm task and scheduled task one-click.

        ## Import

        ESS scaling rule can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ess/scalingRule:ScalingRule example abc123456
        ```

        :param str resource_name: The name of the resource.
        :param ScalingRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ScalingRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 adjustment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 adjustment_value: Optional[pulumi.Input[_builtins.int]] = None,
                 alarm_dimension: Optional[pulumi.Input[Union['ScalingRuleAlarmDimensionArgs', 'ScalingRuleAlarmDimensionArgsDict']]] = None,
                 cooldown: Optional[pulumi.Input[_builtins.int]] = None,
                 disable_scale_in: Optional[pulumi.Input[_builtins.bool]] = None,
                 estimated_instance_warmup: Optional[pulumi.Input[_builtins.int]] = None,
                 hybrid_metrics: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ScalingRuleHybridMetricArgs', 'ScalingRuleHybridMetricArgsDict']]]]] = None,
                 hybrid_monitor_namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 initial_max_size: Optional[pulumi.Input[_builtins.int]] = None,
                 metric_name: Optional[pulumi.Input[_builtins.str]] = None,
                 metric_type: Optional[pulumi.Input[_builtins.str]] = None,
                 min_adjustment_magnitude: Optional[pulumi.Input[_builtins.int]] = None,
                 predictive_scaling_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 predictive_task_buffer_time: Optional[pulumi.Input[_builtins.int]] = None,
                 predictive_value_behavior: Optional[pulumi.Input[_builtins.str]] = None,
                 predictive_value_buffer: Optional[pulumi.Input[_builtins.int]] = None,
                 scale_in_evaluation_count: Optional[pulumi.Input[_builtins.int]] = None,
                 scale_out_evaluation_count: Optional[pulumi.Input[_builtins.int]] = None,
                 scaling_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 scaling_rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 scaling_rule_type: Optional[pulumi.Input[_builtins.str]] = None,
                 step_adjustments: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ScalingRuleStepAdjustmentArgs', 'ScalingRuleStepAdjustmentArgsDict']]]]] = None,
                 target_value: Optional[pulumi.Input[_builtins.float]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ScalingRuleArgs.__new__(ScalingRuleArgs)

            __props__.__dict__["adjustment_type"] = adjustment_type
            __props__.__dict__["adjustment_value"] = adjustment_value
            __props__.__dict__["alarm_dimension"] = alarm_dimension
            __props__.__dict__["cooldown"] = cooldown
            __props__.__dict__["disable_scale_in"] = disable_scale_in
            __props__.__dict__["estimated_instance_warmup"] = estimated_instance_warmup
            __props__.__dict__["hybrid_metrics"] = hybrid_metrics
            __props__.__dict__["hybrid_monitor_namespace"] = hybrid_monitor_namespace
            __props__.__dict__["initial_max_size"] = initial_max_size
            __props__.__dict__["metric_name"] = metric_name
            __props__.__dict__["metric_type"] = metric_type
            __props__.__dict__["min_adjustment_magnitude"] = min_adjustment_magnitude
            __props__.__dict__["predictive_scaling_mode"] = predictive_scaling_mode
            __props__.__dict__["predictive_task_buffer_time"] = predictive_task_buffer_time
            __props__.__dict__["predictive_value_behavior"] = predictive_value_behavior
            __props__.__dict__["predictive_value_buffer"] = predictive_value_buffer
            __props__.__dict__["scale_in_evaluation_count"] = scale_in_evaluation_count
            __props__.__dict__["scale_out_evaluation_count"] = scale_out_evaluation_count
            if scaling_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'scaling_group_id'")
            __props__.__dict__["scaling_group_id"] = scaling_group_id
            __props__.__dict__["scaling_rule_name"] = scaling_rule_name
            __props__.__dict__["scaling_rule_type"] = scaling_rule_type
            __props__.__dict__["step_adjustments"] = step_adjustments
            __props__.__dict__["target_value"] = target_value
            __props__.__dict__["ari"] = None
        super(ScalingRule, __self__).__init__(
            'alicloud:ess/scalingRule:ScalingRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            adjustment_type: Optional[pulumi.Input[_builtins.str]] = None,
            adjustment_value: Optional[pulumi.Input[_builtins.int]] = None,
            alarm_dimension: Optional[pulumi.Input[Union['ScalingRuleAlarmDimensionArgs', 'ScalingRuleAlarmDimensionArgsDict']]] = None,
            ari: Optional[pulumi.Input[_builtins.str]] = None,
            cooldown: Optional[pulumi.Input[_builtins.int]] = None,
            disable_scale_in: Optional[pulumi.Input[_builtins.bool]] = None,
            estimated_instance_warmup: Optional[pulumi.Input[_builtins.int]] = None,
            hybrid_metrics: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ScalingRuleHybridMetricArgs', 'ScalingRuleHybridMetricArgsDict']]]]] = None,
            hybrid_monitor_namespace: Optional[pulumi.Input[_builtins.str]] = None,
            initial_max_size: Optional[pulumi.Input[_builtins.int]] = None,
            metric_name: Optional[pulumi.Input[_builtins.str]] = None,
            metric_type: Optional[pulumi.Input[_builtins.str]] = None,
            min_adjustment_magnitude: Optional[pulumi.Input[_builtins.int]] = None,
            predictive_scaling_mode: Optional[pulumi.Input[_builtins.str]] = None,
            predictive_task_buffer_time: Optional[pulumi.Input[_builtins.int]] = None,
            predictive_value_behavior: Optional[pulumi.Input[_builtins.str]] = None,
            predictive_value_buffer: Optional[pulumi.Input[_builtins.int]] = None,
            scale_in_evaluation_count: Optional[pulumi.Input[_builtins.int]] = None,
            scale_out_evaluation_count: Optional[pulumi.Input[_builtins.int]] = None,
            scaling_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            scaling_rule_name: Optional[pulumi.Input[_builtins.str]] = None,
            scaling_rule_type: Optional[pulumi.Input[_builtins.str]] = None,
            step_adjustments: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ScalingRuleStepAdjustmentArgs', 'ScalingRuleStepAdjustmentArgsDict']]]]] = None,
            target_value: Optional[pulumi.Input[_builtins.float]] = None) -> 'ScalingRule':
        """
        Get an existing ScalingRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] adjustment_type: Adjustment mode of a scaling rule. Optional values:
               - QuantityChangeInCapacity: It is used to increase or decrease a specified number of ECS instances.
               - PercentChangeInCapacity: It is used to increase or decrease a specified proportion of ECS instances.
               - TotalCapacity: It is used to adjust the quantity of ECS instances in the current scaling group to a specified value.
        :param pulumi.Input[_builtins.int] adjustment_value: The number of ECS instances to be adjusted in the scaling rule. This parameter is required and applicable only to simple scaling rules. The number of ECS instances to be adjusted in a single scaling activity cannot exceed 500. Value range:
               - QuantityChangeInCapacity：(0, 500] U (-500, 0]
               - PercentChangeInCapacity：[0, 10000] U [-100, 0]
               - TotalCapacity：[0, 1000]
        :param pulumi.Input[Union['ScalingRuleAlarmDimensionArgs', 'ScalingRuleAlarmDimensionArgsDict']] alarm_dimension: AlarmDimension for StepScalingRule. See `alarm_dimension` below.
        :param pulumi.Input[_builtins.str] ari: The unique identifier of the scaling rule.
        :param pulumi.Input[_builtins.int] cooldown: The cooldown time of the scaling rule. This parameter is applicable only to simple scaling rules. Value range: [0, 86,400], in seconds. The default value is empty，if not set, the return value will be 0, which is the default value of integer.
        :param pulumi.Input[_builtins.bool] disable_scale_in: Indicates whether scale in by the target tracking policy is disabled. Default to false.
        :param pulumi.Input[_builtins.int] estimated_instance_warmup: The estimated time, in seconds, until a newly launched instance will contribute CloudMonitor metrics. Default to 300.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ScalingRuleHybridMetricArgs', 'ScalingRuleHybridMetricArgsDict']]]] hybrid_metrics: The Hybrid Cloud Monitoring metrics. See `hybrid_metrics` below.
        :param pulumi.Input[_builtins.str] hybrid_monitor_namespace: The ID of the Hybrid Cloud Monitoring metric repository.
        :param pulumi.Input[_builtins.int] initial_max_size: The maximum number of ECS instances that can be added to the scaling group. If you specify InitialMaxSize, you must also specify PredictiveValueBehavior.
        :param pulumi.Input[_builtins.str] metric_name: A CloudMonitor metric name.
        :param pulumi.Input[_builtins.str] metric_type: The type of the metric. Valid values: system, custom, hybrid.
        :param pulumi.Input[_builtins.int] min_adjustment_magnitude: The minimum number of instances that must be scaled. This parameter takes effect if you set ScalingRuleType to SimpleScalingRule or StepScalingRule, and AdjustmentType to PercentChangeInCapacity.
        :param pulumi.Input[_builtins.str] predictive_scaling_mode: The mode of the predictive scaling rule. Valid values: PredictAndScale, PredictOnly.
        :param pulumi.Input[_builtins.int] predictive_task_buffer_time: The amount of buffer time before the prediction task runs. By default, all prediction tasks that are automatically created by a predictive scaling rule run on the hour. You can specify a buffer time to run prediction tasks and prepare resources in advance. Valid values: 0 to 60. Unit: minutes.
        :param pulumi.Input[_builtins.str] predictive_value_behavior: The action on the predicted maximum value. Valid values: MaxOverridePredictiveValue, PredictiveValueOverrideMax, PredictiveValueOverrideMaxWithBuffer.
        :param pulumi.Input[_builtins.int] predictive_value_buffer: The ratio based on which the predicted value is increased if you set PredictiveValueBehavior to PredictiveValueOverrideMaxWithBuffer. If the predicted value increased by this ratio is greater than the initial maximum capacity, the increased value is used as the maximum value for prediction tasks. Valid values: 0 to 100.
        :param pulumi.Input[_builtins.int] scale_in_evaluation_count: The number of consecutive times that the event-triggered task created for scale-ins must meet the threshold conditions before an alert is triggered. After a target tracking scaling rule is created, an event-triggered task is automatically created and associated with the target tracking scaling rule.
        :param pulumi.Input[_builtins.int] scale_out_evaluation_count: The number of consecutive times that the event-triggered task created for scale-outs must meet the threshold conditions before an alert is triggered. After a target tracking scaling rule is created, an event-triggered task is automatically created and associated with the target tracking scaling rule.
        :param pulumi.Input[_builtins.str] scaling_group_id: ID of the scaling group of a scaling rule.
        :param pulumi.Input[_builtins.str] scaling_rule_name: Name shown for the scaling rule, which must contain 2-64 characters (English or Chinese), starting with numbers, English letters or Chinese characters, and can contain number, underscores `_`, hypens `-`, and decimal point `.`. If this parameter value is not specified, the default value is scaling rule id.
        :param pulumi.Input[_builtins.str] scaling_rule_type: The scaling rule type, either "SimpleScalingRule", "TargetTrackingScalingRule", "StepScalingRule", "PredictiveScalingRule". Default to "SimpleScalingRule".
        :param pulumi.Input[Sequence[pulumi.Input[Union['ScalingRuleStepAdjustmentArgs', 'ScalingRuleStepAdjustmentArgsDict']]]] step_adjustments: Steps for StepScalingRule. See `step_adjustment` below.
        :param pulumi.Input[_builtins.float] target_value: The target value for the metric.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ScalingRuleState.__new__(_ScalingRuleState)

        __props__.__dict__["adjustment_type"] = adjustment_type
        __props__.__dict__["adjustment_value"] = adjustment_value
        __props__.__dict__["alarm_dimension"] = alarm_dimension
        __props__.__dict__["ari"] = ari
        __props__.__dict__["cooldown"] = cooldown
        __props__.__dict__["disable_scale_in"] = disable_scale_in
        __props__.__dict__["estimated_instance_warmup"] = estimated_instance_warmup
        __props__.__dict__["hybrid_metrics"] = hybrid_metrics
        __props__.__dict__["hybrid_monitor_namespace"] = hybrid_monitor_namespace
        __props__.__dict__["initial_max_size"] = initial_max_size
        __props__.__dict__["metric_name"] = metric_name
        __props__.__dict__["metric_type"] = metric_type
        __props__.__dict__["min_adjustment_magnitude"] = min_adjustment_magnitude
        __props__.__dict__["predictive_scaling_mode"] = predictive_scaling_mode
        __props__.__dict__["predictive_task_buffer_time"] = predictive_task_buffer_time
        __props__.__dict__["predictive_value_behavior"] = predictive_value_behavior
        __props__.__dict__["predictive_value_buffer"] = predictive_value_buffer
        __props__.__dict__["scale_in_evaluation_count"] = scale_in_evaluation_count
        __props__.__dict__["scale_out_evaluation_count"] = scale_out_evaluation_count
        __props__.__dict__["scaling_group_id"] = scaling_group_id
        __props__.__dict__["scaling_rule_name"] = scaling_rule_name
        __props__.__dict__["scaling_rule_type"] = scaling_rule_type
        __props__.__dict__["step_adjustments"] = step_adjustments
        __props__.__dict__["target_value"] = target_value
        return ScalingRule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="adjustmentType")
    def adjustment_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Adjustment mode of a scaling rule. Optional values:
        - QuantityChangeInCapacity: It is used to increase or decrease a specified number of ECS instances.
        - PercentChangeInCapacity: It is used to increase or decrease a specified proportion of ECS instances.
        - TotalCapacity: It is used to adjust the quantity of ECS instances in the current scaling group to a specified value.
        """
        return pulumi.get(self, "adjustment_type")

    @_builtins.property
    @pulumi.getter(name="adjustmentValue")
    def adjustment_value(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The number of ECS instances to be adjusted in the scaling rule. This parameter is required and applicable only to simple scaling rules. The number of ECS instances to be adjusted in a single scaling activity cannot exceed 500. Value range:
        - QuantityChangeInCapacity：(0, 500] U (-500, 0]
        - PercentChangeInCapacity：[0, 10000] U [-100, 0]
        - TotalCapacity：[0, 1000]
        """
        return pulumi.get(self, "adjustment_value")

    @_builtins.property
    @pulumi.getter(name="alarmDimension")
    def alarm_dimension(self) -> pulumi.Output[Optional['outputs.ScalingRuleAlarmDimension']]:
        """
        AlarmDimension for StepScalingRule. See `alarm_dimension` below.
        """
        return pulumi.get(self, "alarm_dimension")

    @_builtins.property
    @pulumi.getter
    def ari(self) -> pulumi.Output[_builtins.str]:
        """
        The unique identifier of the scaling rule.
        """
        return pulumi.get(self, "ari")

    @_builtins.property
    @pulumi.getter
    def cooldown(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The cooldown time of the scaling rule. This parameter is applicable only to simple scaling rules. Value range: [0, 86,400], in seconds. The default value is empty，if not set, the return value will be 0, which is the default value of integer.
        """
        return pulumi.get(self, "cooldown")

    @_builtins.property
    @pulumi.getter(name="disableScaleIn")
    def disable_scale_in(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Indicates whether scale in by the target tracking policy is disabled. Default to false.
        """
        return pulumi.get(self, "disable_scale_in")

    @_builtins.property
    @pulumi.getter(name="estimatedInstanceWarmup")
    def estimated_instance_warmup(self) -> pulumi.Output[_builtins.int]:
        """
        The estimated time, in seconds, until a newly launched instance will contribute CloudMonitor metrics. Default to 300.
        """
        return pulumi.get(self, "estimated_instance_warmup")

    @_builtins.property
    @pulumi.getter(name="hybridMetrics")
    def hybrid_metrics(self) -> pulumi.Output[Optional[Sequence['outputs.ScalingRuleHybridMetric']]]:
        """
        The Hybrid Cloud Monitoring metrics. See `hybrid_metrics` below.
        """
        return pulumi.get(self, "hybrid_metrics")

    @_builtins.property
    @pulumi.getter(name="hybridMonitorNamespace")
    def hybrid_monitor_namespace(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the Hybrid Cloud Monitoring metric repository.
        """
        return pulumi.get(self, "hybrid_monitor_namespace")

    @_builtins.property
    @pulumi.getter(name="initialMaxSize")
    def initial_max_size(self) -> pulumi.Output[_builtins.int]:
        """
        The maximum number of ECS instances that can be added to the scaling group. If you specify InitialMaxSize, you must also specify PredictiveValueBehavior.
        """
        return pulumi.get(self, "initial_max_size")

    @_builtins.property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A CloudMonitor metric name.
        """
        return pulumi.get(self, "metric_name")

    @_builtins.property
    @pulumi.getter(name="metricType")
    def metric_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the metric. Valid values: system, custom, hybrid.
        """
        return pulumi.get(self, "metric_type")

    @_builtins.property
    @pulumi.getter(name="minAdjustmentMagnitude")
    def min_adjustment_magnitude(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The minimum number of instances that must be scaled. This parameter takes effect if you set ScalingRuleType to SimpleScalingRule or StepScalingRule, and AdjustmentType to PercentChangeInCapacity.
        """
        return pulumi.get(self, "min_adjustment_magnitude")

    @_builtins.property
    @pulumi.getter(name="predictiveScalingMode")
    def predictive_scaling_mode(self) -> pulumi.Output[_builtins.str]:
        """
        The mode of the predictive scaling rule. Valid values: PredictAndScale, PredictOnly.
        """
        return pulumi.get(self, "predictive_scaling_mode")

    @_builtins.property
    @pulumi.getter(name="predictiveTaskBufferTime")
    def predictive_task_buffer_time(self) -> pulumi.Output[_builtins.int]:
        """
        The amount of buffer time before the prediction task runs. By default, all prediction tasks that are automatically created by a predictive scaling rule run on the hour. You can specify a buffer time to run prediction tasks and prepare resources in advance. Valid values: 0 to 60. Unit: minutes.
        """
        return pulumi.get(self, "predictive_task_buffer_time")

    @_builtins.property
    @pulumi.getter(name="predictiveValueBehavior")
    def predictive_value_behavior(self) -> pulumi.Output[_builtins.str]:
        """
        The action on the predicted maximum value. Valid values: MaxOverridePredictiveValue, PredictiveValueOverrideMax, PredictiveValueOverrideMaxWithBuffer.
        """
        return pulumi.get(self, "predictive_value_behavior")

    @_builtins.property
    @pulumi.getter(name="predictiveValueBuffer")
    def predictive_value_buffer(self) -> pulumi.Output[_builtins.int]:
        """
        The ratio based on which the predicted value is increased if you set PredictiveValueBehavior to PredictiveValueOverrideMaxWithBuffer. If the predicted value increased by this ratio is greater than the initial maximum capacity, the increased value is used as the maximum value for prediction tasks. Valid values: 0 to 100.
        """
        return pulumi.get(self, "predictive_value_buffer")

    @_builtins.property
    @pulumi.getter(name="scaleInEvaluationCount")
    def scale_in_evaluation_count(self) -> pulumi.Output[_builtins.int]:
        """
        The number of consecutive times that the event-triggered task created for scale-ins must meet the threshold conditions before an alert is triggered. After a target tracking scaling rule is created, an event-triggered task is automatically created and associated with the target tracking scaling rule.
        """
        return pulumi.get(self, "scale_in_evaluation_count")

    @_builtins.property
    @pulumi.getter(name="scaleOutEvaluationCount")
    def scale_out_evaluation_count(self) -> pulumi.Output[_builtins.int]:
        """
        The number of consecutive times that the event-triggered task created for scale-outs must meet the threshold conditions before an alert is triggered. After a target tracking scaling rule is created, an event-triggered task is automatically created and associated with the target tracking scaling rule.
        """
        return pulumi.get(self, "scale_out_evaluation_count")

    @_builtins.property
    @pulumi.getter(name="scalingGroupId")
    def scaling_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the scaling group of a scaling rule.
        """
        return pulumi.get(self, "scaling_group_id")

    @_builtins.property
    @pulumi.getter(name="scalingRuleName")
    def scaling_rule_name(self) -> pulumi.Output[_builtins.str]:
        """
        Name shown for the scaling rule, which must contain 2-64 characters (English or Chinese), starting with numbers, English letters or Chinese characters, and can contain number, underscores `_`, hypens `-`, and decimal point `.`. If this parameter value is not specified, the default value is scaling rule id.
        """
        return pulumi.get(self, "scaling_rule_name")

    @_builtins.property
    @pulumi.getter(name="scalingRuleType")
    def scaling_rule_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The scaling rule type, either "SimpleScalingRule", "TargetTrackingScalingRule", "StepScalingRule", "PredictiveScalingRule". Default to "SimpleScalingRule".
        """
        return pulumi.get(self, "scaling_rule_type")

    @_builtins.property
    @pulumi.getter(name="stepAdjustments")
    def step_adjustments(self) -> pulumi.Output[Optional[Sequence['outputs.ScalingRuleStepAdjustment']]]:
        """
        Steps for StepScalingRule. See `step_adjustment` below.
        """
        return pulumi.get(self, "step_adjustments")

    @_builtins.property
    @pulumi.getter(name="targetValue")
    def target_value(self) -> pulumi.Output[Optional[_builtins.float]]:
        """
        The target value for the metric.
        """
        return pulumi.get(self, "target_value")

