# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['V3LayerVersionArgs', 'V3LayerVersion']

@pulumi.input_type
class V3LayerVersionArgs:
    def __init__(__self__, *,
                 layer_name: pulumi.Input[_builtins.str],
                 acl: Optional[pulumi.Input[_builtins.str]] = None,
                 code: Optional[pulumi.Input['V3LayerVersionCodeArgs']] = None,
                 compatible_runtimes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 license: Optional[pulumi.Input[_builtins.str]] = None,
                 public: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a V3LayerVersion resource.
        :param pulumi.Input[_builtins.str] layer_name: Name of the layer
        :param pulumi.Input[_builtins.str] acl: The access permission of the layer, 1: public, 0: private, default is private
        :param pulumi.Input['V3LayerVersionCodeArgs'] code: Layer code configuration See `code` below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] compatible_runtimes: List of runtime environments supported by the layer
        :param pulumi.Input[_builtins.str] description: Description of the version
        :param pulumi.Input[_builtins.str] license: Layer License Agreement
        :param pulumi.Input[_builtins.str] public: Whether to expose the layer. Enumeration values: true, false. (Deprecated, please use acl instead)
        """
        pulumi.set(__self__, "layer_name", layer_name)
        if acl is not None:
            pulumi.set(__self__, "acl", acl)
        if code is not None:
            pulumi.set(__self__, "code", code)
        if compatible_runtimes is not None:
            pulumi.set(__self__, "compatible_runtimes", compatible_runtimes)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if license is not None:
            pulumi.set(__self__, "license", license)
        if public is not None:
            pulumi.set(__self__, "public", public)

    @_builtins.property
    @pulumi.getter(name="layerName")
    def layer_name(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the layer
        """
        return pulumi.get(self, "layer_name")

    @layer_name.setter
    def layer_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "layer_name", value)

    @_builtins.property
    @pulumi.getter
    def acl(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The access permission of the layer, 1: public, 0: private, default is private
        """
        return pulumi.get(self, "acl")

    @acl.setter
    def acl(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "acl", value)

    @_builtins.property
    @pulumi.getter
    def code(self) -> Optional[pulumi.Input['V3LayerVersionCodeArgs']]:
        """
        Layer code configuration See `code` below.
        """
        return pulumi.get(self, "code")

    @code.setter
    def code(self, value: Optional[pulumi.Input['V3LayerVersionCodeArgs']]):
        pulumi.set(self, "code", value)

    @_builtins.property
    @pulumi.getter(name="compatibleRuntimes")
    def compatible_runtimes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of runtime environments supported by the layer
        """
        return pulumi.get(self, "compatible_runtimes")

    @compatible_runtimes.setter
    def compatible_runtimes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "compatible_runtimes", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the version
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def license(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Layer License Agreement
        """
        return pulumi.get(self, "license")

    @license.setter
    def license(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "license", value)

    @_builtins.property
    @pulumi.getter
    def public(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to expose the layer. Enumeration values: true, false. (Deprecated, please use acl instead)
        """
        return pulumi.get(self, "public")

    @public.setter
    def public(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public", value)


@pulumi.input_type
class _V3LayerVersionState:
    def __init__(__self__, *,
                 acl: Optional[pulumi.Input[_builtins.str]] = None,
                 code: Optional[pulumi.Input['V3LayerVersionCodeArgs']] = None,
                 code_size: Optional[pulumi.Input[_builtins.str]] = None,
                 compatible_runtimes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 layer_name: Optional[pulumi.Input[_builtins.str]] = None,
                 layer_version_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 license: Optional[pulumi.Input[_builtins.str]] = None,
                 public: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering V3LayerVersion resources.
        :param pulumi.Input[_builtins.str] acl: The access permission of the layer, 1: public, 0: private, default is private
        :param pulumi.Input['V3LayerVersionCodeArgs'] code: Layer code configuration See `code` below.
        :param pulumi.Input[_builtins.str] code_size: (Available since v1.234.0) The code package size of the layer, in bytes.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] compatible_runtimes: List of runtime environments supported by the layer
        :param pulumi.Input[_builtins.str] create_time: The creation time of the resource
        :param pulumi.Input[_builtins.str] description: Description of the version
        :param pulumi.Input[_builtins.str] layer_name: Name of the layer
        :param pulumi.Input[_builtins.str] layer_version_arn: (Available since v1.234.0) Layer version ARN. The format is acs:fc:{region }:{ accountID}:layers/{layerName}/versions/{layerVersion}.
        :param pulumi.Input[_builtins.str] license: Layer License Agreement
        :param pulumi.Input[_builtins.str] public: Whether to expose the layer. Enumeration values: true, false. (Deprecated, please use acl instead)
        :param pulumi.Input[_builtins.str] version: The version of the layer
        """
        if acl is not None:
            pulumi.set(__self__, "acl", acl)
        if code is not None:
            pulumi.set(__self__, "code", code)
        if code_size is not None:
            pulumi.set(__self__, "code_size", code_size)
        if compatible_runtimes is not None:
            pulumi.set(__self__, "compatible_runtimes", compatible_runtimes)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if layer_name is not None:
            pulumi.set(__self__, "layer_name", layer_name)
        if layer_version_arn is not None:
            pulumi.set(__self__, "layer_version_arn", layer_version_arn)
        if license is not None:
            pulumi.set(__self__, "license", license)
        if public is not None:
            pulumi.set(__self__, "public", public)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def acl(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The access permission of the layer, 1: public, 0: private, default is private
        """
        return pulumi.get(self, "acl")

    @acl.setter
    def acl(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "acl", value)

    @_builtins.property
    @pulumi.getter
    def code(self) -> Optional[pulumi.Input['V3LayerVersionCodeArgs']]:
        """
        Layer code configuration See `code` below.
        """
        return pulumi.get(self, "code")

    @code.setter
    def code(self, value: Optional[pulumi.Input['V3LayerVersionCodeArgs']]):
        pulumi.set(self, "code", value)

    @_builtins.property
    @pulumi.getter(name="codeSize")
    def code_size(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Available since v1.234.0) The code package size of the layer, in bytes.
        """
        return pulumi.get(self, "code_size")

    @code_size.setter
    def code_size(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "code_size", value)

    @_builtins.property
    @pulumi.getter(name="compatibleRuntimes")
    def compatible_runtimes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of runtime environments supported by the layer
        """
        return pulumi.get(self, "compatible_runtimes")

    @compatible_runtimes.setter
    def compatible_runtimes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "compatible_runtimes", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation time of the resource
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the version
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="layerName")
    def layer_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the layer
        """
        return pulumi.get(self, "layer_name")

    @layer_name.setter
    def layer_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "layer_name", value)

    @_builtins.property
    @pulumi.getter(name="layerVersionArn")
    def layer_version_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Available since v1.234.0) Layer version ARN. The format is acs:fc:{region }:{ accountID}:layers/{layerName}/versions/{layerVersion}.
        """
        return pulumi.get(self, "layer_version_arn")

    @layer_version_arn.setter
    def layer_version_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "layer_version_arn", value)

    @_builtins.property
    @pulumi.getter
    def license(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Layer License Agreement
        """
        return pulumi.get(self, "license")

    @license.setter
    def license(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "license", value)

    @_builtins.property
    @pulumi.getter
    def public(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to expose the layer. Enumeration values: true, false. (Deprecated, please use acl instead)
        """
        return pulumi.get(self, "public")

    @public.setter
    def public(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version of the layer
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("alicloud:fc/v3LayerVersion:V3LayerVersion")
class V3LayerVersion(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl: Optional[pulumi.Input[_builtins.str]] = None,
                 code: Optional[pulumi.Input[Union['V3LayerVersionCodeArgs', 'V3LayerVersionCodeArgsDict']]] = None,
                 compatible_runtimes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 layer_name: Optional[pulumi.Input[_builtins.str]] = None,
                 license: Optional[pulumi.Input[_builtins.str]] = None,
                 public: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a FCV3 Layer Version resource.

        Layer provides you with the ability to publish and deploy common dependency libraries, runtime environments, and function extensions.

        For information about FCV3 Layer Version and how to use it, see [What is Layer Version](https://www.alibabacloud.com/help/en/functioncompute/api-fc-2023-03-30-createlayerversion).

        > **NOTE:** Available since v1.230.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.fc.V3LayerVersion("default",
            description=name,
            layer_name="FC3LayerResouceTest_ZIP_2024SepWed",
            license="Apache2.0",
            acl="0",
            code={
                "zip_file": "UEsDBBQACAAIAAAAAAAAAAAAAAAAAAAAAAAIAAAAaW5kZXgucHmEkEFKxEAQRfd9ig9ZTCJOooIwDMwNXLqXnnQlaalUhU5lRj2KZ/FOXkESGR114bJ/P/7jV4b1xRq1hijtFpM1682cuNgPmgysbRulPT0fRxXnMtwrSPyeCdYRokSLnuMLJTTkbUqEvDMbxm1VdcRD6Tk+T1LW2ldB66knsYdA5iNX17ebm6tN2VnPhcswMPmREPuBacb+CiapLarAj9gT6/H97dVlCNScY3mtYvRkxdZlwDKDEnanPWVLdrdkeXEGlFEazVdfPVHaVeHc3N15CUwppwOJXeK7HshAB8NuOU7J6sP4SRXuH/EvbUfMiqMmDqv5M5FNSfAj/wgAAP//UEsHCPl//NYAAQAArwEAAFBLAQIUABQACAAIAAAAAAD5f/zWAAEAAK8BAAAIAAAAAAAAAAAAAAAAAAAAAABpbmRleC5weVBLBQYAAAAAAQABADYAAAA2AQAAAAA=",
            })
        ```

        ## Import

        FCV3 Layer Version can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:fc/v3LayerVersion:V3LayerVersion example <layer_name>:<version>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] acl: The access permission of the layer, 1: public, 0: private, default is private
        :param pulumi.Input[Union['V3LayerVersionCodeArgs', 'V3LayerVersionCodeArgsDict']] code: Layer code configuration See `code` below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] compatible_runtimes: List of runtime environments supported by the layer
        :param pulumi.Input[_builtins.str] description: Description of the version
        :param pulumi.Input[_builtins.str] layer_name: Name of the layer
        :param pulumi.Input[_builtins.str] license: Layer License Agreement
        :param pulumi.Input[_builtins.str] public: Whether to expose the layer. Enumeration values: true, false. (Deprecated, please use acl instead)
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: V3LayerVersionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a FCV3 Layer Version resource.

        Layer provides you with the ability to publish and deploy common dependency libraries, runtime environments, and function extensions.

        For information about FCV3 Layer Version and how to use it, see [What is Layer Version](https://www.alibabacloud.com/help/en/functioncompute/api-fc-2023-03-30-createlayerversion).

        > **NOTE:** Available since v1.230.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.fc.V3LayerVersion("default",
            description=name,
            layer_name="FC3LayerResouceTest_ZIP_2024SepWed",
            license="Apache2.0",
            acl="0",
            code={
                "zip_file": "UEsDBBQACAAIAAAAAAAAAAAAAAAAAAAAAAAIAAAAaW5kZXgucHmEkEFKxEAQRfd9ig9ZTCJOooIwDMwNXLqXnnQlaalUhU5lRj2KZ/FOXkESGR114bJ/P/7jV4b1xRq1hijtFpM1682cuNgPmgysbRulPT0fRxXnMtwrSPyeCdYRokSLnuMLJTTkbUqEvDMbxm1VdcRD6Tk+T1LW2ldB66knsYdA5iNX17ebm6tN2VnPhcswMPmREPuBacb+CiapLarAj9gT6/H97dVlCNScY3mtYvRkxdZlwDKDEnanPWVLdrdkeXEGlFEazVdfPVHaVeHc3N15CUwppwOJXeK7HshAB8NuOU7J6sP4SRXuH/EvbUfMiqMmDqv5M5FNSfAj/wgAAP//UEsHCPl//NYAAQAArwEAAFBLAQIUABQACAAIAAAAAAD5f/zWAAEAAK8BAAAIAAAAAAAAAAAAAAAAAAAAAABpbmRleC5weVBLBQYAAAAAAQABADYAAAA2AQAAAAA=",
            })
        ```

        ## Import

        FCV3 Layer Version can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:fc/v3LayerVersion:V3LayerVersion example <layer_name>:<version>
        ```

        :param str resource_name: The name of the resource.
        :param V3LayerVersionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(V3LayerVersionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl: Optional[pulumi.Input[_builtins.str]] = None,
                 code: Optional[pulumi.Input[Union['V3LayerVersionCodeArgs', 'V3LayerVersionCodeArgsDict']]] = None,
                 compatible_runtimes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 layer_name: Optional[pulumi.Input[_builtins.str]] = None,
                 license: Optional[pulumi.Input[_builtins.str]] = None,
                 public: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = V3LayerVersionArgs.__new__(V3LayerVersionArgs)

            __props__.__dict__["acl"] = acl
            __props__.__dict__["code"] = code
            __props__.__dict__["compatible_runtimes"] = compatible_runtimes
            __props__.__dict__["description"] = description
            if layer_name is None and not opts.urn:
                raise TypeError("Missing required property 'layer_name'")
            __props__.__dict__["layer_name"] = layer_name
            __props__.__dict__["license"] = license
            __props__.__dict__["public"] = public
            __props__.__dict__["code_size"] = None
            __props__.__dict__["create_time"] = None
            __props__.__dict__["layer_version_arn"] = None
            __props__.__dict__["version"] = None
        super(V3LayerVersion, __self__).__init__(
            'alicloud:fc/v3LayerVersion:V3LayerVersion',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            acl: Optional[pulumi.Input[_builtins.str]] = None,
            code: Optional[pulumi.Input[Union['V3LayerVersionCodeArgs', 'V3LayerVersionCodeArgsDict']]] = None,
            code_size: Optional[pulumi.Input[_builtins.str]] = None,
            compatible_runtimes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            layer_name: Optional[pulumi.Input[_builtins.str]] = None,
            layer_version_arn: Optional[pulumi.Input[_builtins.str]] = None,
            license: Optional[pulumi.Input[_builtins.str]] = None,
            public: Optional[pulumi.Input[_builtins.str]] = None,
            version: Optional[pulumi.Input[_builtins.str]] = None) -> 'V3LayerVersion':
        """
        Get an existing V3LayerVersion resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] acl: The access permission of the layer, 1: public, 0: private, default is private
        :param pulumi.Input[Union['V3LayerVersionCodeArgs', 'V3LayerVersionCodeArgsDict']] code: Layer code configuration See `code` below.
        :param pulumi.Input[_builtins.str] code_size: (Available since v1.234.0) The code package size of the layer, in bytes.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] compatible_runtimes: List of runtime environments supported by the layer
        :param pulumi.Input[_builtins.str] create_time: The creation time of the resource
        :param pulumi.Input[_builtins.str] description: Description of the version
        :param pulumi.Input[_builtins.str] layer_name: Name of the layer
        :param pulumi.Input[_builtins.str] layer_version_arn: (Available since v1.234.0) Layer version ARN. The format is acs:fc:{region }:{ accountID}:layers/{layerName}/versions/{layerVersion}.
        :param pulumi.Input[_builtins.str] license: Layer License Agreement
        :param pulumi.Input[_builtins.str] public: Whether to expose the layer. Enumeration values: true, false. (Deprecated, please use acl instead)
        :param pulumi.Input[_builtins.str] version: The version of the layer
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _V3LayerVersionState.__new__(_V3LayerVersionState)

        __props__.__dict__["acl"] = acl
        __props__.__dict__["code"] = code
        __props__.__dict__["code_size"] = code_size
        __props__.__dict__["compatible_runtimes"] = compatible_runtimes
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["layer_name"] = layer_name
        __props__.__dict__["layer_version_arn"] = layer_version_arn
        __props__.__dict__["license"] = license
        __props__.__dict__["public"] = public
        __props__.__dict__["version"] = version
        return V3LayerVersion(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def acl(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The access permission of the layer, 1: public, 0: private, default is private
        """
        return pulumi.get(self, "acl")

    @_builtins.property
    @pulumi.getter
    def code(self) -> pulumi.Output[Optional['outputs.V3LayerVersionCode']]:
        """
        Layer code configuration See `code` below.
        """
        return pulumi.get(self, "code")

    @_builtins.property
    @pulumi.getter(name="codeSize")
    def code_size(self) -> pulumi.Output[_builtins.str]:
        """
        (Available since v1.234.0) The code package size of the layer, in bytes.
        """
        return pulumi.get(self, "code_size")

    @_builtins.property
    @pulumi.getter(name="compatibleRuntimes")
    def compatible_runtimes(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of runtime environments supported by the layer
        """
        return pulumi.get(self, "compatible_runtimes")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The creation time of the resource
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description of the version
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="layerName")
    def layer_name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the layer
        """
        return pulumi.get(self, "layer_name")

    @_builtins.property
    @pulumi.getter(name="layerVersionArn")
    def layer_version_arn(self) -> pulumi.Output[_builtins.str]:
        """
        (Available since v1.234.0) Layer version ARN. The format is acs:fc:{region }:{ accountID}:layers/{layerName}/versions/{layerVersion}.
        """
        return pulumi.get(self, "layer_version_arn")

    @_builtins.property
    @pulumi.getter
    def license(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Layer License Agreement
        """
        return pulumi.get(self, "license")

    @_builtins.property
    @pulumi.getter
    def public(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Whether to expose the layer. Enumeration values: true, false. (Deprecated, please use acl instead)
        """
        return pulumi.get(self, "public")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[_builtins.str]:
        """
        The version of the layer
        """
        return pulumi.get(self, "version")

