# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AclArgs', 'Acl']

@pulumi.input_type
class AclArgs:
    def __init__(__self__, *,
                 address_ip_version: pulumi.Input[_builtins.str],
                 acl_entries: Optional[pulumi.Input[Sequence[pulumi.Input['AclAclEntryArgs']]]] = None,
                 acl_name: Optional[pulumi.Input[_builtins.str]] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Acl resource.
        :param pulumi.Input[_builtins.str] address_ip_version: The IP version. Valid values: `IPv4` and `IPv6`.
        :param pulumi.Input[Sequence[pulumi.Input['AclAclEntryArgs']]] acl_entries: The entries of the Acl. See `acl_entries` below. **NOTE:** "Field `acl_entries` has been deprecated from provider version 1.190.0 and it will be removed in the future version. Please use the new resource `ga.AclEntryAttachment`."
        :param pulumi.Input[_builtins.str] acl_name: The name of the ACL. The name must be `2` to `128` characters in length, and can contain letters, digits, periods (.), hyphens (-) and underscores (_). It must start with a letter.
        :param pulumi.Input[_builtins.bool] dry_run: The dry run.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group. **Note:** Once you set a value of this property, you cannot set it to an empty string anymore.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        pulumi.set(__self__, "address_ip_version", address_ip_version)
        if acl_entries is not None:
            warnings.warn("""Field `acl_entries` has been deprecated from provider version 1.190.0 and it will be removed in the future version. Please use the new resource `ga.AclEntryAttachment`.""", DeprecationWarning)
            pulumi.log.warn("""acl_entries is deprecated: Field `acl_entries` has been deprecated from provider version 1.190.0 and it will be removed in the future version. Please use the new resource `ga.AclEntryAttachment`.""")
        if acl_entries is not None:
            pulumi.set(__self__, "acl_entries", acl_entries)
        if acl_name is not None:
            pulumi.set(__self__, "acl_name", acl_name)
        if dry_run is not None:
            pulumi.set(__self__, "dry_run", dry_run)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="addressIpVersion")
    def address_ip_version(self) -> pulumi.Input[_builtins.str]:
        """
        The IP version. Valid values: `IPv4` and `IPv6`.
        """
        return pulumi.get(self, "address_ip_version")

    @address_ip_version.setter
    def address_ip_version(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "address_ip_version", value)

    @_builtins.property
    @pulumi.getter(name="aclEntries")
    @_utilities.deprecated("""Field `acl_entries` has been deprecated from provider version 1.190.0 and it will be removed in the future version. Please use the new resource `ga.AclEntryAttachment`.""")
    def acl_entries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AclAclEntryArgs']]]]:
        """
        The entries of the Acl. See `acl_entries` below. **NOTE:** "Field `acl_entries` has been deprecated from provider version 1.190.0 and it will be removed in the future version. Please use the new resource `ga.AclEntryAttachment`."
        """
        return pulumi.get(self, "acl_entries")

    @acl_entries.setter
    def acl_entries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AclAclEntryArgs']]]]):
        pulumi.set(self, "acl_entries", value)

    @_builtins.property
    @pulumi.getter(name="aclName")
    def acl_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the ACL. The name must be `2` to `128` characters in length, and can contain letters, digits, periods (.), hyphens (-) and underscores (_). It must start with a letter.
        """
        return pulumi.get(self, "acl_name")

    @acl_name.setter
    def acl_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "acl_name", value)

    @_builtins.property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The dry run.
        """
        return pulumi.get(self, "dry_run")

    @dry_run.setter
    def dry_run(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dry_run", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group. **Note:** Once you set a value of this property, you cannot set it to an empty string anymore.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _AclState:
    def __init__(__self__, *,
                 acl_entries: Optional[pulumi.Input[Sequence[pulumi.Input['AclAclEntryArgs']]]] = None,
                 acl_name: Optional[pulumi.Input[_builtins.str]] = None,
                 address_ip_version: Optional[pulumi.Input[_builtins.str]] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Acl resources.
        :param pulumi.Input[Sequence[pulumi.Input['AclAclEntryArgs']]] acl_entries: The entries of the Acl. See `acl_entries` below. **NOTE:** "Field `acl_entries` has been deprecated from provider version 1.190.0 and it will be removed in the future version. Please use the new resource `ga.AclEntryAttachment`."
        :param pulumi.Input[_builtins.str] acl_name: The name of the ACL. The name must be `2` to `128` characters in length, and can contain letters, digits, periods (.), hyphens (-) and underscores (_). It must start with a letter.
        :param pulumi.Input[_builtins.str] address_ip_version: The IP version. Valid values: `IPv4` and `IPv6`.
        :param pulumi.Input[_builtins.bool] dry_run: The dry run.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group. **Note:** Once you set a value of this property, you cannot set it to an empty string anymore.
        :param pulumi.Input[_builtins.str] status: The status of the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        if acl_entries is not None:
            warnings.warn("""Field `acl_entries` has been deprecated from provider version 1.190.0 and it will be removed in the future version. Please use the new resource `ga.AclEntryAttachment`.""", DeprecationWarning)
            pulumi.log.warn("""acl_entries is deprecated: Field `acl_entries` has been deprecated from provider version 1.190.0 and it will be removed in the future version. Please use the new resource `ga.AclEntryAttachment`.""")
        if acl_entries is not None:
            pulumi.set(__self__, "acl_entries", acl_entries)
        if acl_name is not None:
            pulumi.set(__self__, "acl_name", acl_name)
        if address_ip_version is not None:
            pulumi.set(__self__, "address_ip_version", address_ip_version)
        if dry_run is not None:
            pulumi.set(__self__, "dry_run", dry_run)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="aclEntries")
    @_utilities.deprecated("""Field `acl_entries` has been deprecated from provider version 1.190.0 and it will be removed in the future version. Please use the new resource `ga.AclEntryAttachment`.""")
    def acl_entries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AclAclEntryArgs']]]]:
        """
        The entries of the Acl. See `acl_entries` below. **NOTE:** "Field `acl_entries` has been deprecated from provider version 1.190.0 and it will be removed in the future version. Please use the new resource `ga.AclEntryAttachment`."
        """
        return pulumi.get(self, "acl_entries")

    @acl_entries.setter
    def acl_entries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AclAclEntryArgs']]]]):
        pulumi.set(self, "acl_entries", value)

    @_builtins.property
    @pulumi.getter(name="aclName")
    def acl_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the ACL. The name must be `2` to `128` characters in length, and can contain letters, digits, periods (.), hyphens (-) and underscores (_). It must start with a letter.
        """
        return pulumi.get(self, "acl_name")

    @acl_name.setter
    def acl_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "acl_name", value)

    @_builtins.property
    @pulumi.getter(name="addressIpVersion")
    def address_ip_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP version. Valid values: `IPv4` and `IPv6`.
        """
        return pulumi.get(self, "address_ip_version")

    @address_ip_version.setter
    def address_ip_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "address_ip_version", value)

    @_builtins.property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The dry run.
        """
        return pulumi.get(self, "dry_run")

    @dry_run.setter
    def dry_run(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dry_run", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group. **Note:** Once you set a value of this property, you cannot set it to an empty string anymore.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("alicloud:ga/acl:Acl")
class Acl(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl_entries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AclAclEntryArgs', 'AclAclEntryArgsDict']]]]] = None,
                 acl_name: Optional[pulumi.Input[_builtins.str]] = None,
                 address_ip_version: Optional[pulumi.Input[_builtins.str]] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Provides a Global Accelerator (GA) Acl resource.

        For information about Global Accelerator (GA) Acl and how to use it, see [What is Acl](https://www.alibabacloud.com/help/en/global-accelerator/latest/api-ga-2019-11-20-createacl).

        > **NOTE:** Available since v1.150.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.ga.Acl("default",
            acl_name="terraform-example",
            address_ip_version="IPv4")
        default_acl_entry_attachment = alicloud.ga.AclEntryAttachment("default",
            acl_id=default.id,
            entry="192.168.1.1/32",
            entry_description="terraform-example")
        ```

        ## Import

        Global Accelerator (GA) Acl can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ga/acl:Acl example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AclAclEntryArgs', 'AclAclEntryArgsDict']]]] acl_entries: The entries of the Acl. See `acl_entries` below. **NOTE:** "Field `acl_entries` has been deprecated from provider version 1.190.0 and it will be removed in the future version. Please use the new resource `ga.AclEntryAttachment`."
        :param pulumi.Input[_builtins.str] acl_name: The name of the ACL. The name must be `2` to `128` characters in length, and can contain letters, digits, periods (.), hyphens (-) and underscores (_). It must start with a letter.
        :param pulumi.Input[_builtins.str] address_ip_version: The IP version. Valid values: `IPv4` and `IPv6`.
        :param pulumi.Input[_builtins.bool] dry_run: The dry run.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group. **Note:** Once you set a value of this property, you cannot set it to an empty string anymore.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AclArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Global Accelerator (GA) Acl resource.

        For information about Global Accelerator (GA) Acl and how to use it, see [What is Acl](https://www.alibabacloud.com/help/en/global-accelerator/latest/api-ga-2019-11-20-createacl).

        > **NOTE:** Available since v1.150.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.ga.Acl("default",
            acl_name="terraform-example",
            address_ip_version="IPv4")
        default_acl_entry_attachment = alicloud.ga.AclEntryAttachment("default",
            acl_id=default.id,
            entry="192.168.1.1/32",
            entry_description="terraform-example")
        ```

        ## Import

        Global Accelerator (GA) Acl can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ga/acl:Acl example <id>
        ```

        :param str resource_name: The name of the resource.
        :param AclArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AclArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl_entries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AclAclEntryArgs', 'AclAclEntryArgsDict']]]]] = None,
                 acl_name: Optional[pulumi.Input[_builtins.str]] = None,
                 address_ip_version: Optional[pulumi.Input[_builtins.str]] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AclArgs.__new__(AclArgs)

            __props__.__dict__["acl_entries"] = acl_entries
            __props__.__dict__["acl_name"] = acl_name
            if address_ip_version is None and not opts.urn:
                raise TypeError("Missing required property 'address_ip_version'")
            __props__.__dict__["address_ip_version"] = address_ip_version
            __props__.__dict__["dry_run"] = dry_run
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["status"] = None
        super(Acl, __self__).__init__(
            'alicloud:ga/acl:Acl',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            acl_entries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AclAclEntryArgs', 'AclAclEntryArgsDict']]]]] = None,
            acl_name: Optional[pulumi.Input[_builtins.str]] = None,
            address_ip_version: Optional[pulumi.Input[_builtins.str]] = None,
            dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'Acl':
        """
        Get an existing Acl resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AclAclEntryArgs', 'AclAclEntryArgsDict']]]] acl_entries: The entries of the Acl. See `acl_entries` below. **NOTE:** "Field `acl_entries` has been deprecated from provider version 1.190.0 and it will be removed in the future version. Please use the new resource `ga.AclEntryAttachment`."
        :param pulumi.Input[_builtins.str] acl_name: The name of the ACL. The name must be `2` to `128` characters in length, and can contain letters, digits, periods (.), hyphens (-) and underscores (_). It must start with a letter.
        :param pulumi.Input[_builtins.str] address_ip_version: The IP version. Valid values: `IPv4` and `IPv6`.
        :param pulumi.Input[_builtins.bool] dry_run: The dry run.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group. **Note:** Once you set a value of this property, you cannot set it to an empty string anymore.
        :param pulumi.Input[_builtins.str] status: The status of the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AclState.__new__(_AclState)

        __props__.__dict__["acl_entries"] = acl_entries
        __props__.__dict__["acl_name"] = acl_name
        __props__.__dict__["address_ip_version"] = address_ip_version
        __props__.__dict__["dry_run"] = dry_run
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        return Acl(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="aclEntries")
    @_utilities.deprecated("""Field `acl_entries` has been deprecated from provider version 1.190.0 and it will be removed in the future version. Please use the new resource `ga.AclEntryAttachment`.""")
    def acl_entries(self) -> pulumi.Output[Sequence['outputs.AclAclEntry']]:
        """
        The entries of the Acl. See `acl_entries` below. **NOTE:** "Field `acl_entries` has been deprecated from provider version 1.190.0 and it will be removed in the future version. Please use the new resource `ga.AclEntryAttachment`."
        """
        return pulumi.get(self, "acl_entries")

    @_builtins.property
    @pulumi.getter(name="aclName")
    def acl_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the ACL. The name must be `2` to `128` characters in length, and can contain letters, digits, periods (.), hyphens (-) and underscores (_). It must start with a letter.
        """
        return pulumi.get(self, "acl_name")

    @_builtins.property
    @pulumi.getter(name="addressIpVersion")
    def address_ip_version(self) -> pulumi.Output[_builtins.str]:
        """
        The IP version. Valid values: `IPv4` and `IPv6`.
        """
        return pulumi.get(self, "address_ip_version")

    @_builtins.property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        The dry run.
        """
        return pulumi.get(self, "dry_run")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the resource group. **Note:** Once you set a value of this property, you cannot set it to an empty string anymore.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

