# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AdditionalCertificateArgs', 'AdditionalCertificate']

@pulumi.input_type
class AdditionalCertificateArgs:
    def __init__(__self__, *,
                 accelerator_id: pulumi.Input[_builtins.str],
                 certificate_id: pulumi.Input[_builtins.str],
                 domain: pulumi.Input[_builtins.str],
                 listener_id: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a AdditionalCertificate resource.
        :param pulumi.Input[_builtins.str] accelerator_id: The ID of the GA instance.
        :param pulumi.Input[_builtins.str] certificate_id: The Certificate ID. **NOTE:** From version 1.209.1, `certificate_id` can be modified.
        :param pulumi.Input[_builtins.str] domain: The domain name specified by the certificate. **NOTE:** You can associate each domain name with only one additional certificate.
        :param pulumi.Input[_builtins.str] listener_id: The ID of the listener. **NOTE:** Only HTTPS listeners support this parameter.
        """
        pulumi.set(__self__, "accelerator_id", accelerator_id)
        pulumi.set(__self__, "certificate_id", certificate_id)
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "listener_id", listener_id)

    @_builtins.property
    @pulumi.getter(name="acceleratorId")
    def accelerator_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the GA instance.
        """
        return pulumi.get(self, "accelerator_id")

    @accelerator_id.setter
    def accelerator_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "accelerator_id", value)

    @_builtins.property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> pulumi.Input[_builtins.str]:
        """
        The Certificate ID. **NOTE:** From version 1.209.1, `certificate_id` can be modified.
        """
        return pulumi.get(self, "certificate_id")

    @certificate_id.setter
    def certificate_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "certificate_id", value)

    @_builtins.property
    @pulumi.getter
    def domain(self) -> pulumi.Input[_builtins.str]:
        """
        The domain name specified by the certificate. **NOTE:** You can associate each domain name with only one additional certificate.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "domain", value)

    @_builtins.property
    @pulumi.getter(name="listenerId")
    def listener_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the listener. **NOTE:** Only HTTPS listeners support this parameter.
        """
        return pulumi.get(self, "listener_id")

    @listener_id.setter
    def listener_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "listener_id", value)


@pulumi.input_type
class _AdditionalCertificateState:
    def __init__(__self__, *,
                 accelerator_id: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate_id: Optional[pulumi.Input[_builtins.str]] = None,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 listener_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AdditionalCertificate resources.
        :param pulumi.Input[_builtins.str] accelerator_id: The ID of the GA instance.
        :param pulumi.Input[_builtins.str] certificate_id: The Certificate ID. **NOTE:** From version 1.209.1, `certificate_id` can be modified.
        :param pulumi.Input[_builtins.str] domain: The domain name specified by the certificate. **NOTE:** You can associate each domain name with only one additional certificate.
        :param pulumi.Input[_builtins.str] listener_id: The ID of the listener. **NOTE:** Only HTTPS listeners support this parameter.
        """
        if accelerator_id is not None:
            pulumi.set(__self__, "accelerator_id", accelerator_id)
        if certificate_id is not None:
            pulumi.set(__self__, "certificate_id", certificate_id)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if listener_id is not None:
            pulumi.set(__self__, "listener_id", listener_id)

    @_builtins.property
    @pulumi.getter(name="acceleratorId")
    def accelerator_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the GA instance.
        """
        return pulumi.get(self, "accelerator_id")

    @accelerator_id.setter
    def accelerator_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "accelerator_id", value)

    @_builtins.property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Certificate ID. **NOTE:** From version 1.209.1, `certificate_id` can be modified.
        """
        return pulumi.get(self, "certificate_id")

    @certificate_id.setter
    def certificate_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "certificate_id", value)

    @_builtins.property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The domain name specified by the certificate. **NOTE:** You can associate each domain name with only one additional certificate.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain", value)

    @_builtins.property
    @pulumi.getter(name="listenerId")
    def listener_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the listener. **NOTE:** Only HTTPS listeners support this parameter.
        """
        return pulumi.get(self, "listener_id")

    @listener_id.setter
    def listener_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "listener_id", value)


@pulumi.type_token("alicloud:ga/additionalCertificate:AdditionalCertificate")
class AdditionalCertificate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accelerator_id: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate_id: Optional[pulumi.Input[_builtins.str]] = None,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 listener_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Global Accelerator (GA) Additional Certificate resource.

        For information about Global Accelerator (GA) Additional Certificate and how to use it, see [What is Additional Certificate](https://www.alibabacloud.com/help/en/global-accelerator/latest/api-ga-2019-11-20-associateadditionalcertificateswithlistener).

        > **NOTE:** Available since v1.150.0.

        ## Import

        Global Accelerator (GA) Additional Certificate can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ga/additionalCertificate:AdditionalCertificate example <accelerator_id>:<listener_id>:<domain>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] accelerator_id: The ID of the GA instance.
        :param pulumi.Input[_builtins.str] certificate_id: The Certificate ID. **NOTE:** From version 1.209.1, `certificate_id` can be modified.
        :param pulumi.Input[_builtins.str] domain: The domain name specified by the certificate. **NOTE:** You can associate each domain name with only one additional certificate.
        :param pulumi.Input[_builtins.str] listener_id: The ID of the listener. **NOTE:** Only HTTPS listeners support this parameter.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AdditionalCertificateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Global Accelerator (GA) Additional Certificate resource.

        For information about Global Accelerator (GA) Additional Certificate and how to use it, see [What is Additional Certificate](https://www.alibabacloud.com/help/en/global-accelerator/latest/api-ga-2019-11-20-associateadditionalcertificateswithlistener).

        > **NOTE:** Available since v1.150.0.

        ## Import

        Global Accelerator (GA) Additional Certificate can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ga/additionalCertificate:AdditionalCertificate example <accelerator_id>:<listener_id>:<domain>
        ```

        :param str resource_name: The name of the resource.
        :param AdditionalCertificateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AdditionalCertificateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accelerator_id: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate_id: Optional[pulumi.Input[_builtins.str]] = None,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 listener_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AdditionalCertificateArgs.__new__(AdditionalCertificateArgs)

            if accelerator_id is None and not opts.urn:
                raise TypeError("Missing required property 'accelerator_id'")
            __props__.__dict__["accelerator_id"] = accelerator_id
            if certificate_id is None and not opts.urn:
                raise TypeError("Missing required property 'certificate_id'")
            __props__.__dict__["certificate_id"] = certificate_id
            if domain is None and not opts.urn:
                raise TypeError("Missing required property 'domain'")
            __props__.__dict__["domain"] = domain
            if listener_id is None and not opts.urn:
                raise TypeError("Missing required property 'listener_id'")
            __props__.__dict__["listener_id"] = listener_id
        super(AdditionalCertificate, __self__).__init__(
            'alicloud:ga/additionalCertificate:AdditionalCertificate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            accelerator_id: Optional[pulumi.Input[_builtins.str]] = None,
            certificate_id: Optional[pulumi.Input[_builtins.str]] = None,
            domain: Optional[pulumi.Input[_builtins.str]] = None,
            listener_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'AdditionalCertificate':
        """
        Get an existing AdditionalCertificate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] accelerator_id: The ID of the GA instance.
        :param pulumi.Input[_builtins.str] certificate_id: The Certificate ID. **NOTE:** From version 1.209.1, `certificate_id` can be modified.
        :param pulumi.Input[_builtins.str] domain: The domain name specified by the certificate. **NOTE:** You can associate each domain name with only one additional certificate.
        :param pulumi.Input[_builtins.str] listener_id: The ID of the listener. **NOTE:** Only HTTPS listeners support this parameter.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AdditionalCertificateState.__new__(_AdditionalCertificateState)

        __props__.__dict__["accelerator_id"] = accelerator_id
        __props__.__dict__["certificate_id"] = certificate_id
        __props__.__dict__["domain"] = domain
        __props__.__dict__["listener_id"] = listener_id
        return AdditionalCertificate(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="acceleratorId")
    def accelerator_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the GA instance.
        """
        return pulumi.get(self, "accelerator_id")

    @_builtins.property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Certificate ID. **NOTE:** From version 1.209.1, `certificate_id` can be modified.
        """
        return pulumi.get(self, "certificate_id")

    @_builtins.property
    @pulumi.getter
    def domain(self) -> pulumi.Output[_builtins.str]:
        """
        The domain name specified by the certificate. **NOTE:** You can associate each domain name with only one additional certificate.
        """
        return pulumi.get(self, "domain")

    @_builtins.property
    @pulumi.getter(name="listenerId")
    def listener_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the listener. **NOTE:** Only HTTPS listeners support this parameter.
        """
        return pulumi.get(self, "listener_id")

