# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetCustomRoutingEndpointGroupsResult',
    'AwaitableGetCustomRoutingEndpointGroupsResult',
    'get_custom_routing_endpoint_groups',
    'get_custom_routing_endpoint_groups_output',
]

@pulumi.output_type
class GetCustomRoutingEndpointGroupsResult:
    """
    A collection of values returned by getCustomRoutingEndpointGroups.
    """
    def __init__(__self__, accelerator_id=None, endpoint_group_id=None, groups=None, id=None, ids=None, listener_id=None, name_regex=None, names=None, output_file=None, page_number=None, page_size=None, status=None):
        if accelerator_id and not isinstance(accelerator_id, str):
            raise TypeError("Expected argument 'accelerator_id' to be a str")
        pulumi.set(__self__, "accelerator_id", accelerator_id)
        if endpoint_group_id and not isinstance(endpoint_group_id, str):
            raise TypeError("Expected argument 'endpoint_group_id' to be a str")
        pulumi.set(__self__, "endpoint_group_id", endpoint_group_id)
        if groups and not isinstance(groups, list):
            raise TypeError("Expected argument 'groups' to be a list")
        pulumi.set(__self__, "groups", groups)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if listener_id and not isinstance(listener_id, str):
            raise TypeError("Expected argument 'listener_id' to be a str")
        pulumi.set(__self__, "listener_id", listener_id)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if page_number and not isinstance(page_number, int):
            raise TypeError("Expected argument 'page_number' to be a int")
        pulumi.set(__self__, "page_number", page_number)
        if page_size and not isinstance(page_size, int):
            raise TypeError("Expected argument 'page_size' to be a int")
        pulumi.set(__self__, "page_size", page_size)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="acceleratorId")
    def accelerator_id(self) -> _builtins.str:
        """
        The ID of the GA instance.
        """
        return pulumi.get(self, "accelerator_id")

    @_builtins.property
    @pulumi.getter(name="endpointGroupId")
    def endpoint_group_id(self) -> Optional[_builtins.str]:
        """
        The ID of the Custom Routing Endpoint Group.
        """
        return pulumi.get(self, "endpoint_group_id")

    @_builtins.property
    @pulumi.getter
    def groups(self) -> Sequence['outputs.GetCustomRoutingEndpointGroupsGroupResult']:
        """
        A list of Custom Routing Endpoint Groups. Each element contains the following attributes:
        """
        return pulumi.get(self, "groups")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="listenerId")
    def listener_id(self) -> Optional[_builtins.str]:
        """
        The ID of the custom routing listener.
        """
        return pulumi.get(self, "listener_id")

    @_builtins.property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name_regex")

    @_builtins.property
    @pulumi.getter
    def names(self) -> Sequence[_builtins.str]:
        """
        A list of Custom Routing Endpoint Group names.
        """
        return pulumi.get(self, "names")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter(name="pageNumber")
    def page_number(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "page_number")

    @_builtins.property
    @pulumi.getter(name="pageSize")
    def page_size(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "page_size")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        The status of the endpoint group.
        """
        return pulumi.get(self, "status")


class AwaitableGetCustomRoutingEndpointGroupsResult(GetCustomRoutingEndpointGroupsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCustomRoutingEndpointGroupsResult(
            accelerator_id=self.accelerator_id,
            endpoint_group_id=self.endpoint_group_id,
            groups=self.groups,
            id=self.id,
            ids=self.ids,
            listener_id=self.listener_id,
            name_regex=self.name_regex,
            names=self.names,
            output_file=self.output_file,
            page_number=self.page_number,
            page_size=self.page_size,
            status=self.status)


def get_custom_routing_endpoint_groups(accelerator_id: Optional[_builtins.str] = None,
                                       endpoint_group_id: Optional[_builtins.str] = None,
                                       ids: Optional[Sequence[_builtins.str]] = None,
                                       listener_id: Optional[_builtins.str] = None,
                                       name_regex: Optional[_builtins.str] = None,
                                       output_file: Optional[_builtins.str] = None,
                                       page_number: Optional[_builtins.int] = None,
                                       page_size: Optional[_builtins.int] = None,
                                       status: Optional[_builtins.str] = None,
                                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCustomRoutingEndpointGroupsResult:
    """
    This data source provides the Global Accelerator (GA) Custom Routing Endpoint Groups of the current Alibaba Cloud user.

    > **NOTE:** Available since v1.197.0.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.ga.get_custom_routing_endpoint_groups(ids=["example_id"],
        accelerator_id="your_accelerator_id")
    pulumi.export("gaCustomRoutingEndpointGroupsId1", ids.groups[0].id)
    name_regex = alicloud.ga.get_custom_routing_endpoint_groups(name_regex="tf-example",
        accelerator_id="your_accelerator_id")
    pulumi.export("gaCustomRoutingEndpointGroupsId2", name_regex.groups[0].id)
    ```


    :param _builtins.str accelerator_id: The ID of the GA instance.
    :param _builtins.str endpoint_group_id: The ID of the endpoint group.
    :param Sequence[_builtins.str] ids: A list of Custom Routing Endpoint Group IDs.
    :param _builtins.str listener_id: The ID of the custom routing listener.
    :param _builtins.str name_regex: A regex string to filter results by Custom Routing Endpoint Group name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str status: The status of the endpoint group. Valid Values: `init`, `active`, `updating`, `deleting`.
    """
    __args__ = dict()
    __args__['acceleratorId'] = accelerator_id
    __args__['endpointGroupId'] = endpoint_group_id
    __args__['ids'] = ids
    __args__['listenerId'] = listener_id
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['pageNumber'] = page_number
    __args__['pageSize'] = page_size
    __args__['status'] = status
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:ga/getCustomRoutingEndpointGroups:getCustomRoutingEndpointGroups', __args__, opts=opts, typ=GetCustomRoutingEndpointGroupsResult).value

    return AwaitableGetCustomRoutingEndpointGroupsResult(
        accelerator_id=pulumi.get(__ret__, 'accelerator_id'),
        endpoint_group_id=pulumi.get(__ret__, 'endpoint_group_id'),
        groups=pulumi.get(__ret__, 'groups'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        listener_id=pulumi.get(__ret__, 'listener_id'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        output_file=pulumi.get(__ret__, 'output_file'),
        page_number=pulumi.get(__ret__, 'page_number'),
        page_size=pulumi.get(__ret__, 'page_size'),
        status=pulumi.get(__ret__, 'status'))
def get_custom_routing_endpoint_groups_output(accelerator_id: Optional[pulumi.Input[_builtins.str]] = None,
                                              endpoint_group_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                              ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                              listener_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                              name_regex: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                              output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                              page_number: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                                              page_size: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                                              status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCustomRoutingEndpointGroupsResult]:
    """
    This data source provides the Global Accelerator (GA) Custom Routing Endpoint Groups of the current Alibaba Cloud user.

    > **NOTE:** Available since v1.197.0.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.ga.get_custom_routing_endpoint_groups(ids=["example_id"],
        accelerator_id="your_accelerator_id")
    pulumi.export("gaCustomRoutingEndpointGroupsId1", ids.groups[0].id)
    name_regex = alicloud.ga.get_custom_routing_endpoint_groups(name_regex="tf-example",
        accelerator_id="your_accelerator_id")
    pulumi.export("gaCustomRoutingEndpointGroupsId2", name_regex.groups[0].id)
    ```


    :param _builtins.str accelerator_id: The ID of the GA instance.
    :param _builtins.str endpoint_group_id: The ID of the endpoint group.
    :param Sequence[_builtins.str] ids: A list of Custom Routing Endpoint Group IDs.
    :param _builtins.str listener_id: The ID of the custom routing listener.
    :param _builtins.str name_regex: A regex string to filter results by Custom Routing Endpoint Group name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str status: The status of the endpoint group. Valid Values: `init`, `active`, `updating`, `deleting`.
    """
    __args__ = dict()
    __args__['acceleratorId'] = accelerator_id
    __args__['endpointGroupId'] = endpoint_group_id
    __args__['ids'] = ids
    __args__['listenerId'] = listener_id
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['pageNumber'] = page_number
    __args__['pageSize'] = page_size
    __args__['status'] = status
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:ga/getCustomRoutingEndpointGroups:getCustomRoutingEndpointGroups', __args__, opts=opts, typ=GetCustomRoutingEndpointGroupsResult)
    return __ret__.apply(lambda __response__: GetCustomRoutingEndpointGroupsResult(
        accelerator_id=pulumi.get(__response__, 'accelerator_id'),
        endpoint_group_id=pulumi.get(__response__, 'endpoint_group_id'),
        groups=pulumi.get(__response__, 'groups'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        listener_id=pulumi.get(__response__, 'listener_id'),
        name_regex=pulumi.get(__response__, 'name_regex'),
        names=pulumi.get(__response__, 'names'),
        output_file=pulumi.get(__response__, 'output_file'),
        page_number=pulumi.get(__response__, 'page_number'),
        page_size=pulumi.get(__response__, 'page_size'),
        status=pulumi.get(__response__, 'status')))
