# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetSecretsResult',
    'AwaitableGetSecretsResult',
    'get_secrets',
    'get_secrets_output',
]

@pulumi.output_type
class GetSecretsResult:
    """
    A collection of values returned by getSecrets.
    """
    def __init__(__self__, enable_details=None, fetch_tags=None, filters=None, id=None, ids=None, name_regex=None, names=None, output_file=None, secrets=None, tags=None):
        if enable_details and not isinstance(enable_details, bool):
            raise TypeError("Expected argument 'enable_details' to be a bool")
        pulumi.set(__self__, "enable_details", enable_details)
        if fetch_tags and not isinstance(fetch_tags, bool):
            raise TypeError("Expected argument 'fetch_tags' to be a bool")
        pulumi.set(__self__, "fetch_tags", fetch_tags)
        if filters and not isinstance(filters, str):
            raise TypeError("Expected argument 'filters' to be a str")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if secrets and not isinstance(secrets, list):
            raise TypeError("Expected argument 'secrets' to be a list")
        pulumi.set(__self__, "secrets", secrets)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="enableDetails")
    def enable_details(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "enable_details")

    @_builtins.property
    @pulumi.getter(name="fetchTags")
    def fetch_tags(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "fetch_tags")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        """
        A list of Kms Secret ids. The value is same as KMS secret_name.
        """
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name_regex")

    @_builtins.property
    @pulumi.getter
    def names(self) -> Sequence[_builtins.str]:
        """
        A list of KMS Secret names.
        """
        return pulumi.get(self, "names")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter
    def secrets(self) -> Sequence['outputs.GetSecretsSecretResult']:
        """
        A list of KMS Secrets. Each element contains the following attributes:
        """
        return pulumi.get(self, "secrets")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")


class AwaitableGetSecretsResult(GetSecretsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSecretsResult(
            enable_details=self.enable_details,
            fetch_tags=self.fetch_tags,
            filters=self.filters,
            id=self.id,
            ids=self.ids,
            name_regex=self.name_regex,
            names=self.names,
            output_file=self.output_file,
            secrets=self.secrets,
            tags=self.tags)


def get_secrets(enable_details: Optional[_builtins.bool] = None,
                fetch_tags: Optional[_builtins.bool] = None,
                filters: Optional[_builtins.str] = None,
                ids: Optional[Sequence[_builtins.str]] = None,
                name_regex: Optional[_builtins.str] = None,
                output_file: Optional[_builtins.str] = None,
                tags: Optional[Mapping[str, _builtins.str]] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSecretsResult:
    """
    This data source provides a list of KMS Secrets in an Alibaba Cloud account according to the specified filters.

    > **NOTE:** Available since v1.86.0.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    # Declare the data source
    kms_secrets_ds = alicloud.kms.get_secrets(fetch_tags=True,
        name_regex="name_regex",
        tags={
            "k-aa": "v-aa",
            "k-bb": "v-bb",
        })
    pulumi.export("firstSecretId", kms_secrets_ds.secrets[0].id)
    ```


    :param _builtins.bool enable_details: Default to `false`. Set it to true can output more details.
    :param _builtins.bool fetch_tags: Whether to include the predetermined resource tag in the return value. Default to `false`.
    :param _builtins.str filters: The secret filter. The filter consists of one or more key-value pairs. 
           More details see API [ListSecrets](https://www.alibabacloud.com/help/en/key-management-service/latest/listsecrets).
    :param Sequence[_builtins.str] ids: A list of KMS Secret ids. The value is same as KMS secret_name.
    :param _builtins.str name_regex: A regex string to filter the results by the KMS secret_name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param Mapping[str, _builtins.str] tags: A mapping of tags to assign to the resource, and can be used to filter secrets.
    """
    __args__ = dict()
    __args__['enableDetails'] = enable_details
    __args__['fetchTags'] = fetch_tags
    __args__['filters'] = filters
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:kms/getSecrets:getSecrets', __args__, opts=opts, typ=GetSecretsResult).value

    return AwaitableGetSecretsResult(
        enable_details=pulumi.get(__ret__, 'enable_details'),
        fetch_tags=pulumi.get(__ret__, 'fetch_tags'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        output_file=pulumi.get(__ret__, 'output_file'),
        secrets=pulumi.get(__ret__, 'secrets'),
        tags=pulumi.get(__ret__, 'tags'))
def get_secrets_output(enable_details: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                       fetch_tags: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                       filters: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                       name_regex: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       tags: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSecretsResult]:
    """
    This data source provides a list of KMS Secrets in an Alibaba Cloud account according to the specified filters.

    > **NOTE:** Available since v1.86.0.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    # Declare the data source
    kms_secrets_ds = alicloud.kms.get_secrets(fetch_tags=True,
        name_regex="name_regex",
        tags={
            "k-aa": "v-aa",
            "k-bb": "v-bb",
        })
    pulumi.export("firstSecretId", kms_secrets_ds.secrets[0].id)
    ```


    :param _builtins.bool enable_details: Default to `false`. Set it to true can output more details.
    :param _builtins.bool fetch_tags: Whether to include the predetermined resource tag in the return value. Default to `false`.
    :param _builtins.str filters: The secret filter. The filter consists of one or more key-value pairs. 
           More details see API [ListSecrets](https://www.alibabacloud.com/help/en/key-management-service/latest/listsecrets).
    :param Sequence[_builtins.str] ids: A list of KMS Secret ids. The value is same as KMS secret_name.
    :param _builtins.str name_regex: A regex string to filter the results by the KMS secret_name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param Mapping[str, _builtins.str] tags: A mapping of tags to assign to the resource, and can be used to filter secrets.
    """
    __args__ = dict()
    __args__['enableDetails'] = enable_details
    __args__['fetchTags'] = fetch_tags
    __args__['filters'] = filters
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['tags'] = tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:kms/getSecrets:getSecrets', __args__, opts=opts, typ=GetSecretsResult)
    return __ret__.apply(lambda __response__: GetSecretsResult(
        enable_details=pulumi.get(__response__, 'enable_details'),
        fetch_tags=pulumi.get(__response__, 'fetch_tags'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        name_regex=pulumi.get(__response__, 'name_regex'),
        names=pulumi.get(__response__, 'names'),
        output_file=pulumi.get(__response__, 'output_file'),
        secrets=pulumi.get(__response__, 'secrets'),
        tags=pulumi.get(__response__, 'tags')))
