# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['NetworkRuleArgs', 'NetworkRule']

@pulumi.input_type
class NetworkRuleArgs:
    def __init__(__self__, *,
                 source_private_ips: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 network_rule_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a NetworkRule resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] source_private_ips: Allowed private network addresses.
        :param pulumi.Input[_builtins.str] description: Description.
        :param pulumi.Input[_builtins.str] network_rule_name: Network Rule Name.
        """
        pulumi.set(__self__, "source_private_ips", source_private_ips)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if network_rule_name is not None:
            pulumi.set(__self__, "network_rule_name", network_rule_name)

    @_builtins.property
    @pulumi.getter(name="sourcePrivateIps")
    def source_private_ips(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Allowed private network addresses.
        """
        return pulumi.get(self, "source_private_ips")

    @source_private_ips.setter
    def source_private_ips(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "source_private_ips", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="networkRuleName")
    def network_rule_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Network Rule Name.
        """
        return pulumi.get(self, "network_rule_name")

    @network_rule_name.setter
    def network_rule_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_rule_name", value)


@pulumi.input_type
class _NetworkRuleState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 network_rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 source_private_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering NetworkRule resources.
        :param pulumi.Input[_builtins.str] description: Description.
        :param pulumi.Input[_builtins.str] network_rule_name: Network Rule Name.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] source_private_ips: Allowed private network addresses.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if network_rule_name is not None:
            pulumi.set(__self__, "network_rule_name", network_rule_name)
        if source_private_ips is not None:
            pulumi.set(__self__, "source_private_ips", source_private_ips)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="networkRuleName")
    def network_rule_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Network Rule Name.
        """
        return pulumi.get(self, "network_rule_name")

    @network_rule_name.setter
    def network_rule_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_rule_name", value)

    @_builtins.property
    @pulumi.getter(name="sourcePrivateIps")
    def source_private_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Allowed private network addresses.
        """
        return pulumi.get(self, "source_private_ips")

    @source_private_ips.setter
    def source_private_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "source_private_ips", value)


@pulumi.type_token("alicloud:kms/networkRule:NetworkRule")
class NetworkRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 network_rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 source_private_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Provides a KMS Network Rule resource. Network rules that can be bound by Application Access Point's policies.

        For information about KMS Network Rule and how to use it, see [What is Network Rule](https://www.alibabacloud.com/help/zh/key-management-service/latest/api-createnetworkrule).

        > **NOTE:** Available since v1.210.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.kms.NetworkRule("default",
            description="example-description",
            source_private_ips=[
                "10.10.10.10/24",
                "192.168.17.13",
                "100.177.24.254",
            ],
            network_rule_name=name)
        ```

        ## Import

        KMS Network Rule can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:kms/networkRule:NetworkRule example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Description.
        :param pulumi.Input[_builtins.str] network_rule_name: Network Rule Name.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] source_private_ips: Allowed private network addresses.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NetworkRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a KMS Network Rule resource. Network rules that can be bound by Application Access Point's policies.

        For information about KMS Network Rule and how to use it, see [What is Network Rule](https://www.alibabacloud.com/help/zh/key-management-service/latest/api-createnetworkrule).

        > **NOTE:** Available since v1.210.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.kms.NetworkRule("default",
            description="example-description",
            source_private_ips=[
                "10.10.10.10/24",
                "192.168.17.13",
                "100.177.24.254",
            ],
            network_rule_name=name)
        ```

        ## Import

        KMS Network Rule can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:kms/networkRule:NetworkRule example <id>
        ```

        :param str resource_name: The name of the resource.
        :param NetworkRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NetworkRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 network_rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 source_private_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NetworkRuleArgs.__new__(NetworkRuleArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["network_rule_name"] = network_rule_name
            if source_private_ips is None and not opts.urn:
                raise TypeError("Missing required property 'source_private_ips'")
            __props__.__dict__["source_private_ips"] = source_private_ips
        super(NetworkRule, __self__).__init__(
            'alicloud:kms/networkRule:NetworkRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            network_rule_name: Optional[pulumi.Input[_builtins.str]] = None,
            source_private_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'NetworkRule':
        """
        Get an existing NetworkRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Description.
        :param pulumi.Input[_builtins.str] network_rule_name: Network Rule Name.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] source_private_ips: Allowed private network addresses.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NetworkRuleState.__new__(_NetworkRuleState)

        __props__.__dict__["description"] = description
        __props__.__dict__["network_rule_name"] = network_rule_name
        __props__.__dict__["source_private_ips"] = source_private_ips
        return NetworkRule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="networkRuleName")
    def network_rule_name(self) -> pulumi.Output[_builtins.str]:
        """
        Network Rule Name.
        """
        return pulumi.get(self, "network_rule_name")

    @_builtins.property
    @pulumi.getter(name="sourcePrivateIps")
    def source_private_ips(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Allowed private network addresses.
        """
        return pulumi.get(self, "source_private_ips")

