# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SecretArgs', 'Secret']

@pulumi.input_type
class SecretArgs:
    def __init__(__self__, *,
                 secret_data: pulumi.Input[_builtins.str],
                 secret_name: pulumi.Input[_builtins.str],
                 version_id: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dkms_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_automatic_rotation: Optional[pulumi.Input[_builtins.bool]] = None,
                 encryption_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 extended_config: Optional[pulumi.Input[_builtins.str]] = None,
                 force_delete_without_recovery: Optional[pulumi.Input[_builtins.bool]] = None,
                 policy: Optional[pulumi.Input[_builtins.str]] = None,
                 recovery_window_in_days: Optional[pulumi.Input[_builtins.int]] = None,
                 rotation_interval: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_data_type: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 version_stages: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Secret resource.
        :param pulumi.Input[_builtins.str] secret_data: The data of the secret. **NOTE:** From version 1.204.1, `secret_data` updating diff will be ignored when `secret_type` is not `Generic`.
        :param pulumi.Input[_builtins.str] secret_name: The name of the secret. For more information, see [How to use it](https://www.alibabacloud.com/help/en/key-management-service/latest/kms-createsecret).
        :param pulumi.Input[_builtins.str] version_id: The version number of the initial version.
        :param pulumi.Input[_builtins.str] description: The description of the secret.
        :param pulumi.Input[_builtins.str] dkms_instance_id: The ID of the KMS instance.
        :param pulumi.Input[_builtins.bool] enable_automatic_rotation: Specifies whether to enable automatic rotation. Default value: `false`. Valid values: `true`, `false`.
        :param pulumi.Input[_builtins.str] encryption_key_id: The ID of the KMS key.
        :param pulumi.Input[_builtins.str] extended_config: The extended configuration of the secret. For more information, see [How to use it](https://www.alibabacloud.com/help/en/key-management-service/latest/kms-createsecret).
        :param pulumi.Input[_builtins.bool] force_delete_without_recovery: Specifies whether to immediately delete a secret. Default value: `false`. Valid values: `true`, `false`.
        :param pulumi.Input[_builtins.str] policy: The content of the secret policy. The value is in the JSON format. The value can be up to 32,768 bytes in length. For more information, see [How to use it](https://www.alibabacloud.com/help/en/kms/developer-reference/api-setsecretpolicy).
        :param pulumi.Input[_builtins.int] recovery_window_in_days: Specifies the recovery period of the secret if you do not forcibly delete it. Unit: Days. Default value: `30`. Valid values: `7` to `30`. **NOTE:**  If `force_delete_without_recovery` is set to `true`, `recovery_window_in_days` will be ignored.
        :param pulumi.Input[_builtins.str] rotation_interval: The interval for automatic rotation. For more information, see [How to use it](https://www.alibabacloud.com/help/en/key-management-service/latest/kms-createsecret).
        :param pulumi.Input[_builtins.str] secret_data_type: The type of the secret value. Default value: `text`. Valid values: `text`, `binary`.
        :param pulumi.Input[_builtins.str] secret_type: The type of the secret. Valid values:
               - `Generic`: Generic secret.
               - `Rds`: ApsaraDB RDS secret.
               - `Redis`: (Available since v1.253.0) ApsaraDB for Redis secret.
               - `RAMCredentials`: RAM secret.
               - `ECS`: ECS secret.
               - `PolarDB`: (Available since v1.253.0) PolarDB secret.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] version_stages: The stage label that is used to mark the new version.
        """
        pulumi.set(__self__, "secret_data", secret_data)
        pulumi.set(__self__, "secret_name", secret_name)
        pulumi.set(__self__, "version_id", version_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dkms_instance_id is not None:
            pulumi.set(__self__, "dkms_instance_id", dkms_instance_id)
        if enable_automatic_rotation is not None:
            pulumi.set(__self__, "enable_automatic_rotation", enable_automatic_rotation)
        if encryption_key_id is not None:
            pulumi.set(__self__, "encryption_key_id", encryption_key_id)
        if extended_config is not None:
            pulumi.set(__self__, "extended_config", extended_config)
        if force_delete_without_recovery is not None:
            pulumi.set(__self__, "force_delete_without_recovery", force_delete_without_recovery)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if recovery_window_in_days is not None:
            pulumi.set(__self__, "recovery_window_in_days", recovery_window_in_days)
        if rotation_interval is not None:
            pulumi.set(__self__, "rotation_interval", rotation_interval)
        if secret_data_type is not None:
            pulumi.set(__self__, "secret_data_type", secret_data_type)
        if secret_type is not None:
            pulumi.set(__self__, "secret_type", secret_type)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if version_stages is not None:
            pulumi.set(__self__, "version_stages", version_stages)

    @_builtins.property
    @pulumi.getter(name="secretData")
    def secret_data(self) -> pulumi.Input[_builtins.str]:
        """
        The data of the secret. **NOTE:** From version 1.204.1, `secret_data` updating diff will be ignored when `secret_type` is not `Generic`.
        """
        return pulumi.get(self, "secret_data")

    @secret_data.setter
    def secret_data(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "secret_data", value)

    @_builtins.property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the secret. For more information, see [How to use it](https://www.alibabacloud.com/help/en/key-management-service/latest/kms-createsecret).
        """
        return pulumi.get(self, "secret_name")

    @secret_name.setter
    def secret_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "secret_name", value)

    @_builtins.property
    @pulumi.getter(name="versionId")
    def version_id(self) -> pulumi.Input[_builtins.str]:
        """
        The version number of the initial version.
        """
        return pulumi.get(self, "version_id")

    @version_id.setter
    def version_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "version_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the secret.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="dkmsInstanceId")
    def dkms_instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the KMS instance.
        """
        return pulumi.get(self, "dkms_instance_id")

    @dkms_instance_id.setter
    def dkms_instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dkms_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="enableAutomaticRotation")
    def enable_automatic_rotation(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable automatic rotation. Default value: `false`. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "enable_automatic_rotation")

    @enable_automatic_rotation.setter
    def enable_automatic_rotation(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_automatic_rotation", value)

    @_builtins.property
    @pulumi.getter(name="encryptionKeyId")
    def encryption_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the KMS key.
        """
        return pulumi.get(self, "encryption_key_id")

    @encryption_key_id.setter
    def encryption_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "encryption_key_id", value)

    @_builtins.property
    @pulumi.getter(name="extendedConfig")
    def extended_config(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The extended configuration of the secret. For more information, see [How to use it](https://www.alibabacloud.com/help/en/key-management-service/latest/kms-createsecret).
        """
        return pulumi.get(self, "extended_config")

    @extended_config.setter
    def extended_config(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "extended_config", value)

    @_builtins.property
    @pulumi.getter(name="forceDeleteWithoutRecovery")
    def force_delete_without_recovery(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to immediately delete a secret. Default value: `false`. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "force_delete_without_recovery")

    @force_delete_without_recovery.setter
    def force_delete_without_recovery(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_delete_without_recovery", value)

    @_builtins.property
    @pulumi.getter
    def policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The content of the secret policy. The value is in the JSON format. The value can be up to 32,768 bytes in length. For more information, see [How to use it](https://www.alibabacloud.com/help/en/kms/developer-reference/api-setsecretpolicy).
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy", value)

    @_builtins.property
    @pulumi.getter(name="recoveryWindowInDays")
    def recovery_window_in_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the recovery period of the secret if you do not forcibly delete it. Unit: Days. Default value: `30`. Valid values: `7` to `30`. **NOTE:**  If `force_delete_without_recovery` is set to `true`, `recovery_window_in_days` will be ignored.
        """
        return pulumi.get(self, "recovery_window_in_days")

    @recovery_window_in_days.setter
    def recovery_window_in_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "recovery_window_in_days", value)

    @_builtins.property
    @pulumi.getter(name="rotationInterval")
    def rotation_interval(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The interval for automatic rotation. For more information, see [How to use it](https://www.alibabacloud.com/help/en/key-management-service/latest/kms-createsecret).
        """
        return pulumi.get(self, "rotation_interval")

    @rotation_interval.setter
    def rotation_interval(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rotation_interval", value)

    @_builtins.property
    @pulumi.getter(name="secretDataType")
    def secret_data_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the secret value. Default value: `text`. Valid values: `text`, `binary`.
        """
        return pulumi.get(self, "secret_data_type")

    @secret_data_type.setter
    def secret_data_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secret_data_type", value)

    @_builtins.property
    @pulumi.getter(name="secretType")
    def secret_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the secret. Valid values:
        - `Generic`: Generic secret.
        - `Rds`: ApsaraDB RDS secret.
        - `Redis`: (Available since v1.253.0) ApsaraDB for Redis secret.
        - `RAMCredentials`: RAM secret.
        - `ECS`: ECS secret.
        - `PolarDB`: (Available since v1.253.0) PolarDB secret.
        """
        return pulumi.get(self, "secret_type")

    @secret_type.setter
    def secret_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secret_type", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="versionStages")
    def version_stages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The stage label that is used to mark the new version.
        """
        return pulumi.get(self, "version_stages")

    @version_stages.setter
    def version_stages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "version_stages", value)


@pulumi.input_type
class _SecretState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dkms_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_automatic_rotation: Optional[pulumi.Input[_builtins.bool]] = None,
                 encryption_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 extended_config: Optional[pulumi.Input[_builtins.str]] = None,
                 force_delete_without_recovery: Optional[pulumi.Input[_builtins.bool]] = None,
                 planned_delete_time: Optional[pulumi.Input[_builtins.str]] = None,
                 policy: Optional[pulumi.Input[_builtins.str]] = None,
                 recovery_window_in_days: Optional[pulumi.Input[_builtins.int]] = None,
                 rotation_interval: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_data: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_data_type: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_name: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 version_id: Optional[pulumi.Input[_builtins.str]] = None,
                 version_stages: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Secret resources.
        :param pulumi.Input[_builtins.str] arn: The ARN of the secret.
        :param pulumi.Input[_builtins.str] create_time: (Available since v1.224.0) The time when the secret is created.
        :param pulumi.Input[_builtins.str] description: The description of the secret.
        :param pulumi.Input[_builtins.str] dkms_instance_id: The ID of the KMS instance.
        :param pulumi.Input[_builtins.bool] enable_automatic_rotation: Specifies whether to enable automatic rotation. Default value: `false`. Valid values: `true`, `false`.
        :param pulumi.Input[_builtins.str] encryption_key_id: The ID of the KMS key.
        :param pulumi.Input[_builtins.str] extended_config: The extended configuration of the secret. For more information, see [How to use it](https://www.alibabacloud.com/help/en/key-management-service/latest/kms-createsecret).
        :param pulumi.Input[_builtins.bool] force_delete_without_recovery: Specifies whether to immediately delete a secret. Default value: `false`. Valid values: `true`, `false`.
        :param pulumi.Input[_builtins.str] planned_delete_time: The time when the secret is scheduled to be deleted.
        :param pulumi.Input[_builtins.str] policy: The content of the secret policy. The value is in the JSON format. The value can be up to 32,768 bytes in length. For more information, see [How to use it](https://www.alibabacloud.com/help/en/kms/developer-reference/api-setsecretpolicy).
        :param pulumi.Input[_builtins.int] recovery_window_in_days: Specifies the recovery period of the secret if you do not forcibly delete it. Unit: Days. Default value: `30`. Valid values: `7` to `30`. **NOTE:**  If `force_delete_without_recovery` is set to `true`, `recovery_window_in_days` will be ignored.
        :param pulumi.Input[_builtins.str] rotation_interval: The interval for automatic rotation. For more information, see [How to use it](https://www.alibabacloud.com/help/en/key-management-service/latest/kms-createsecret).
        :param pulumi.Input[_builtins.str] secret_data: The data of the secret. **NOTE:** From version 1.204.1, `secret_data` updating diff will be ignored when `secret_type` is not `Generic`.
        :param pulumi.Input[_builtins.str] secret_data_type: The type of the secret value. Default value: `text`. Valid values: `text`, `binary`.
        :param pulumi.Input[_builtins.str] secret_name: The name of the secret. For more information, see [How to use it](https://www.alibabacloud.com/help/en/key-management-service/latest/kms-createsecret).
        :param pulumi.Input[_builtins.str] secret_type: The type of the secret. Valid values:
               - `Generic`: Generic secret.
               - `Rds`: ApsaraDB RDS secret.
               - `Redis`: (Available since v1.253.0) ApsaraDB for Redis secret.
               - `RAMCredentials`: RAM secret.
               - `ECS`: ECS secret.
               - `PolarDB`: (Available since v1.253.0) PolarDB secret.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] version_id: The version number of the initial version.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] version_stages: The stage label that is used to mark the new version.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dkms_instance_id is not None:
            pulumi.set(__self__, "dkms_instance_id", dkms_instance_id)
        if enable_automatic_rotation is not None:
            pulumi.set(__self__, "enable_automatic_rotation", enable_automatic_rotation)
        if encryption_key_id is not None:
            pulumi.set(__self__, "encryption_key_id", encryption_key_id)
        if extended_config is not None:
            pulumi.set(__self__, "extended_config", extended_config)
        if force_delete_without_recovery is not None:
            pulumi.set(__self__, "force_delete_without_recovery", force_delete_without_recovery)
        if planned_delete_time is not None:
            pulumi.set(__self__, "planned_delete_time", planned_delete_time)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if recovery_window_in_days is not None:
            pulumi.set(__self__, "recovery_window_in_days", recovery_window_in_days)
        if rotation_interval is not None:
            pulumi.set(__self__, "rotation_interval", rotation_interval)
        if secret_data is not None:
            pulumi.set(__self__, "secret_data", secret_data)
        if secret_data_type is not None:
            pulumi.set(__self__, "secret_data_type", secret_data_type)
        if secret_name is not None:
            pulumi.set(__self__, "secret_name", secret_name)
        if secret_type is not None:
            pulumi.set(__self__, "secret_type", secret_type)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if version_id is not None:
            pulumi.set(__self__, "version_id", version_id)
        if version_stages is not None:
            pulumi.set(__self__, "version_stages", version_stages)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ARN of the secret.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Available since v1.224.0) The time when the secret is created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the secret.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="dkmsInstanceId")
    def dkms_instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the KMS instance.
        """
        return pulumi.get(self, "dkms_instance_id")

    @dkms_instance_id.setter
    def dkms_instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dkms_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="enableAutomaticRotation")
    def enable_automatic_rotation(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable automatic rotation. Default value: `false`. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "enable_automatic_rotation")

    @enable_automatic_rotation.setter
    def enable_automatic_rotation(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_automatic_rotation", value)

    @_builtins.property
    @pulumi.getter(name="encryptionKeyId")
    def encryption_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the KMS key.
        """
        return pulumi.get(self, "encryption_key_id")

    @encryption_key_id.setter
    def encryption_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "encryption_key_id", value)

    @_builtins.property
    @pulumi.getter(name="extendedConfig")
    def extended_config(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The extended configuration of the secret. For more information, see [How to use it](https://www.alibabacloud.com/help/en/key-management-service/latest/kms-createsecret).
        """
        return pulumi.get(self, "extended_config")

    @extended_config.setter
    def extended_config(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "extended_config", value)

    @_builtins.property
    @pulumi.getter(name="forceDeleteWithoutRecovery")
    def force_delete_without_recovery(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to immediately delete a secret. Default value: `false`. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "force_delete_without_recovery")

    @force_delete_without_recovery.setter
    def force_delete_without_recovery(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_delete_without_recovery", value)

    @_builtins.property
    @pulumi.getter(name="plannedDeleteTime")
    def planned_delete_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time when the secret is scheduled to be deleted.
        """
        return pulumi.get(self, "planned_delete_time")

    @planned_delete_time.setter
    def planned_delete_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "planned_delete_time", value)

    @_builtins.property
    @pulumi.getter
    def policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The content of the secret policy. The value is in the JSON format. The value can be up to 32,768 bytes in length. For more information, see [How to use it](https://www.alibabacloud.com/help/en/kms/developer-reference/api-setsecretpolicy).
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy", value)

    @_builtins.property
    @pulumi.getter(name="recoveryWindowInDays")
    def recovery_window_in_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the recovery period of the secret if you do not forcibly delete it. Unit: Days. Default value: `30`. Valid values: `7` to `30`. **NOTE:**  If `force_delete_without_recovery` is set to `true`, `recovery_window_in_days` will be ignored.
        """
        return pulumi.get(self, "recovery_window_in_days")

    @recovery_window_in_days.setter
    def recovery_window_in_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "recovery_window_in_days", value)

    @_builtins.property
    @pulumi.getter(name="rotationInterval")
    def rotation_interval(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The interval for automatic rotation. For more information, see [How to use it](https://www.alibabacloud.com/help/en/key-management-service/latest/kms-createsecret).
        """
        return pulumi.get(self, "rotation_interval")

    @rotation_interval.setter
    def rotation_interval(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rotation_interval", value)

    @_builtins.property
    @pulumi.getter(name="secretData")
    def secret_data(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The data of the secret. **NOTE:** From version 1.204.1, `secret_data` updating diff will be ignored when `secret_type` is not `Generic`.
        """
        return pulumi.get(self, "secret_data")

    @secret_data.setter
    def secret_data(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secret_data", value)

    @_builtins.property
    @pulumi.getter(name="secretDataType")
    def secret_data_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the secret value. Default value: `text`. Valid values: `text`, `binary`.
        """
        return pulumi.get(self, "secret_data_type")

    @secret_data_type.setter
    def secret_data_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secret_data_type", value)

    @_builtins.property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the secret. For more information, see [How to use it](https://www.alibabacloud.com/help/en/key-management-service/latest/kms-createsecret).
        """
        return pulumi.get(self, "secret_name")

    @secret_name.setter
    def secret_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secret_name", value)

    @_builtins.property
    @pulumi.getter(name="secretType")
    def secret_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the secret. Valid values:
        - `Generic`: Generic secret.
        - `Rds`: ApsaraDB RDS secret.
        - `Redis`: (Available since v1.253.0) ApsaraDB for Redis secret.
        - `RAMCredentials`: RAM secret.
        - `ECS`: ECS secret.
        - `PolarDB`: (Available since v1.253.0) PolarDB secret.
        """
        return pulumi.get(self, "secret_type")

    @secret_type.setter
    def secret_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secret_type", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="versionId")
    def version_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version number of the initial version.
        """
        return pulumi.get(self, "version_id")

    @version_id.setter
    def version_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version_id", value)

    @_builtins.property
    @pulumi.getter(name="versionStages")
    def version_stages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The stage label that is used to mark the new version.
        """
        return pulumi.get(self, "version_stages")

    @version_stages.setter
    def version_stages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "version_stages", value)


@pulumi.type_token("alicloud:kms/secret:Secret")
class Secret(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dkms_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_automatic_rotation: Optional[pulumi.Input[_builtins.bool]] = None,
                 encryption_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 extended_config: Optional[pulumi.Input[_builtins.str]] = None,
                 force_delete_without_recovery: Optional[pulumi.Input[_builtins.bool]] = None,
                 policy: Optional[pulumi.Input[_builtins.str]] = None,
                 recovery_window_in_days: Optional[pulumi.Input[_builtins.int]] = None,
                 rotation_interval: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_data: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_data_type: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_name: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 version_id: Optional[pulumi.Input[_builtins.str]] = None,
                 version_stages: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Provides a KMS Secret resource.

        For information about KMS Secret and how to use it, see [What is Secret](https://www.alibabacloud.com/help/en/kms/developer-reference/api-createsecret).

        > **NOTE:** Available since v1.76.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.kms.Secret("default",
            secret_name=name,
            secret_data="Secret data",
            version_id="v1",
            force_delete_without_recovery=True)
        ```

        ## Import

        KMS Secret can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:kms/secret:Secret example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: The description of the secret.
        :param pulumi.Input[_builtins.str] dkms_instance_id: The ID of the KMS instance.
        :param pulumi.Input[_builtins.bool] enable_automatic_rotation: Specifies whether to enable automatic rotation. Default value: `false`. Valid values: `true`, `false`.
        :param pulumi.Input[_builtins.str] encryption_key_id: The ID of the KMS key.
        :param pulumi.Input[_builtins.str] extended_config: The extended configuration of the secret. For more information, see [How to use it](https://www.alibabacloud.com/help/en/key-management-service/latest/kms-createsecret).
        :param pulumi.Input[_builtins.bool] force_delete_without_recovery: Specifies whether to immediately delete a secret. Default value: `false`. Valid values: `true`, `false`.
        :param pulumi.Input[_builtins.str] policy: The content of the secret policy. The value is in the JSON format. The value can be up to 32,768 bytes in length. For more information, see [How to use it](https://www.alibabacloud.com/help/en/kms/developer-reference/api-setsecretpolicy).
        :param pulumi.Input[_builtins.int] recovery_window_in_days: Specifies the recovery period of the secret if you do not forcibly delete it. Unit: Days. Default value: `30`. Valid values: `7` to `30`. **NOTE:**  If `force_delete_without_recovery` is set to `true`, `recovery_window_in_days` will be ignored.
        :param pulumi.Input[_builtins.str] rotation_interval: The interval for automatic rotation. For more information, see [How to use it](https://www.alibabacloud.com/help/en/key-management-service/latest/kms-createsecret).
        :param pulumi.Input[_builtins.str] secret_data: The data of the secret. **NOTE:** From version 1.204.1, `secret_data` updating diff will be ignored when `secret_type` is not `Generic`.
        :param pulumi.Input[_builtins.str] secret_data_type: The type of the secret value. Default value: `text`. Valid values: `text`, `binary`.
        :param pulumi.Input[_builtins.str] secret_name: The name of the secret. For more information, see [How to use it](https://www.alibabacloud.com/help/en/key-management-service/latest/kms-createsecret).
        :param pulumi.Input[_builtins.str] secret_type: The type of the secret. Valid values:
               - `Generic`: Generic secret.
               - `Rds`: ApsaraDB RDS secret.
               - `Redis`: (Available since v1.253.0) ApsaraDB for Redis secret.
               - `RAMCredentials`: RAM secret.
               - `ECS`: ECS secret.
               - `PolarDB`: (Available since v1.253.0) PolarDB secret.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] version_id: The version number of the initial version.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] version_stages: The stage label that is used to mark the new version.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SecretArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a KMS Secret resource.

        For information about KMS Secret and how to use it, see [What is Secret](https://www.alibabacloud.com/help/en/kms/developer-reference/api-createsecret).

        > **NOTE:** Available since v1.76.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.kms.Secret("default",
            secret_name=name,
            secret_data="Secret data",
            version_id="v1",
            force_delete_without_recovery=True)
        ```

        ## Import

        KMS Secret can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:kms/secret:Secret example <id>
        ```

        :param str resource_name: The name of the resource.
        :param SecretArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecretArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dkms_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_automatic_rotation: Optional[pulumi.Input[_builtins.bool]] = None,
                 encryption_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 extended_config: Optional[pulumi.Input[_builtins.str]] = None,
                 force_delete_without_recovery: Optional[pulumi.Input[_builtins.bool]] = None,
                 policy: Optional[pulumi.Input[_builtins.str]] = None,
                 recovery_window_in_days: Optional[pulumi.Input[_builtins.int]] = None,
                 rotation_interval: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_data: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_data_type: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_name: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 version_id: Optional[pulumi.Input[_builtins.str]] = None,
                 version_stages: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SecretArgs.__new__(SecretArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["dkms_instance_id"] = dkms_instance_id
            __props__.__dict__["enable_automatic_rotation"] = enable_automatic_rotation
            __props__.__dict__["encryption_key_id"] = encryption_key_id
            __props__.__dict__["extended_config"] = extended_config
            __props__.__dict__["force_delete_without_recovery"] = force_delete_without_recovery
            __props__.__dict__["policy"] = policy
            __props__.__dict__["recovery_window_in_days"] = recovery_window_in_days
            __props__.__dict__["rotation_interval"] = rotation_interval
            if secret_data is None and not opts.urn:
                raise TypeError("Missing required property 'secret_data'")
            __props__.__dict__["secret_data"] = None if secret_data is None else pulumi.Output.secret(secret_data)
            __props__.__dict__["secret_data_type"] = secret_data_type
            if secret_name is None and not opts.urn:
                raise TypeError("Missing required property 'secret_name'")
            __props__.__dict__["secret_name"] = secret_name
            __props__.__dict__["secret_type"] = secret_type
            __props__.__dict__["tags"] = tags
            if version_id is None and not opts.urn:
                raise TypeError("Missing required property 'version_id'")
            __props__.__dict__["version_id"] = version_id
            __props__.__dict__["version_stages"] = version_stages
            __props__.__dict__["arn"] = None
            __props__.__dict__["create_time"] = None
            __props__.__dict__["planned_delete_time"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["secretData"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Secret, __self__).__init__(
            'alicloud:kms/secret:Secret',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            dkms_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            enable_automatic_rotation: Optional[pulumi.Input[_builtins.bool]] = None,
            encryption_key_id: Optional[pulumi.Input[_builtins.str]] = None,
            extended_config: Optional[pulumi.Input[_builtins.str]] = None,
            force_delete_without_recovery: Optional[pulumi.Input[_builtins.bool]] = None,
            planned_delete_time: Optional[pulumi.Input[_builtins.str]] = None,
            policy: Optional[pulumi.Input[_builtins.str]] = None,
            recovery_window_in_days: Optional[pulumi.Input[_builtins.int]] = None,
            rotation_interval: Optional[pulumi.Input[_builtins.str]] = None,
            secret_data: Optional[pulumi.Input[_builtins.str]] = None,
            secret_data_type: Optional[pulumi.Input[_builtins.str]] = None,
            secret_name: Optional[pulumi.Input[_builtins.str]] = None,
            secret_type: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            version_id: Optional[pulumi.Input[_builtins.str]] = None,
            version_stages: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'Secret':
        """
        Get an existing Secret resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] arn: The ARN of the secret.
        :param pulumi.Input[_builtins.str] create_time: (Available since v1.224.0) The time when the secret is created.
        :param pulumi.Input[_builtins.str] description: The description of the secret.
        :param pulumi.Input[_builtins.str] dkms_instance_id: The ID of the KMS instance.
        :param pulumi.Input[_builtins.bool] enable_automatic_rotation: Specifies whether to enable automatic rotation. Default value: `false`. Valid values: `true`, `false`.
        :param pulumi.Input[_builtins.str] encryption_key_id: The ID of the KMS key.
        :param pulumi.Input[_builtins.str] extended_config: The extended configuration of the secret. For more information, see [How to use it](https://www.alibabacloud.com/help/en/key-management-service/latest/kms-createsecret).
        :param pulumi.Input[_builtins.bool] force_delete_without_recovery: Specifies whether to immediately delete a secret. Default value: `false`. Valid values: `true`, `false`.
        :param pulumi.Input[_builtins.str] planned_delete_time: The time when the secret is scheduled to be deleted.
        :param pulumi.Input[_builtins.str] policy: The content of the secret policy. The value is in the JSON format. The value can be up to 32,768 bytes in length. For more information, see [How to use it](https://www.alibabacloud.com/help/en/kms/developer-reference/api-setsecretpolicy).
        :param pulumi.Input[_builtins.int] recovery_window_in_days: Specifies the recovery period of the secret if you do not forcibly delete it. Unit: Days. Default value: `30`. Valid values: `7` to `30`. **NOTE:**  If `force_delete_without_recovery` is set to `true`, `recovery_window_in_days` will be ignored.
        :param pulumi.Input[_builtins.str] rotation_interval: The interval for automatic rotation. For more information, see [How to use it](https://www.alibabacloud.com/help/en/key-management-service/latest/kms-createsecret).
        :param pulumi.Input[_builtins.str] secret_data: The data of the secret. **NOTE:** From version 1.204.1, `secret_data` updating diff will be ignored when `secret_type` is not `Generic`.
        :param pulumi.Input[_builtins.str] secret_data_type: The type of the secret value. Default value: `text`. Valid values: `text`, `binary`.
        :param pulumi.Input[_builtins.str] secret_name: The name of the secret. For more information, see [How to use it](https://www.alibabacloud.com/help/en/key-management-service/latest/kms-createsecret).
        :param pulumi.Input[_builtins.str] secret_type: The type of the secret. Valid values:
               - `Generic`: Generic secret.
               - `Rds`: ApsaraDB RDS secret.
               - `Redis`: (Available since v1.253.0) ApsaraDB for Redis secret.
               - `RAMCredentials`: RAM secret.
               - `ECS`: ECS secret.
               - `PolarDB`: (Available since v1.253.0) PolarDB secret.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] version_id: The version number of the initial version.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] version_stages: The stage label that is used to mark the new version.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SecretState.__new__(_SecretState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["dkms_instance_id"] = dkms_instance_id
        __props__.__dict__["enable_automatic_rotation"] = enable_automatic_rotation
        __props__.__dict__["encryption_key_id"] = encryption_key_id
        __props__.__dict__["extended_config"] = extended_config
        __props__.__dict__["force_delete_without_recovery"] = force_delete_without_recovery
        __props__.__dict__["planned_delete_time"] = planned_delete_time
        __props__.__dict__["policy"] = policy
        __props__.__dict__["recovery_window_in_days"] = recovery_window_in_days
        __props__.__dict__["rotation_interval"] = rotation_interval
        __props__.__dict__["secret_data"] = secret_data
        __props__.__dict__["secret_data_type"] = secret_data_type
        __props__.__dict__["secret_name"] = secret_name
        __props__.__dict__["secret_type"] = secret_type
        __props__.__dict__["tags"] = tags
        __props__.__dict__["version_id"] = version_id
        __props__.__dict__["version_stages"] = version_stages
        return Secret(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        The ARN of the secret.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        (Available since v1.224.0) The time when the secret is created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the secret.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="dkmsInstanceId")
    def dkms_instance_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the KMS instance.
        """
        return pulumi.get(self, "dkms_instance_id")

    @_builtins.property
    @pulumi.getter(name="enableAutomaticRotation")
    def enable_automatic_rotation(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to enable automatic rotation. Default value: `false`. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "enable_automatic_rotation")

    @_builtins.property
    @pulumi.getter(name="encryptionKeyId")
    def encryption_key_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the KMS key.
        """
        return pulumi.get(self, "encryption_key_id")

    @_builtins.property
    @pulumi.getter(name="extendedConfig")
    def extended_config(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The extended configuration of the secret. For more information, see [How to use it](https://www.alibabacloud.com/help/en/key-management-service/latest/kms-createsecret).
        """
        return pulumi.get(self, "extended_config")

    @_builtins.property
    @pulumi.getter(name="forceDeleteWithoutRecovery")
    def force_delete_without_recovery(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to immediately delete a secret. Default value: `false`. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "force_delete_without_recovery")

    @_builtins.property
    @pulumi.getter(name="plannedDeleteTime")
    def planned_delete_time(self) -> pulumi.Output[_builtins.str]:
        """
        The time when the secret is scheduled to be deleted.
        """
        return pulumi.get(self, "planned_delete_time")

    @_builtins.property
    @pulumi.getter
    def policy(self) -> pulumi.Output[_builtins.str]:
        """
        The content of the secret policy. The value is in the JSON format. The value can be up to 32,768 bytes in length. For more information, see [How to use it](https://www.alibabacloud.com/help/en/kms/developer-reference/api-setsecretpolicy).
        """
        return pulumi.get(self, "policy")

    @_builtins.property
    @pulumi.getter(name="recoveryWindowInDays")
    def recovery_window_in_days(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Specifies the recovery period of the secret if you do not forcibly delete it. Unit: Days. Default value: `30`. Valid values: `7` to `30`. **NOTE:**  If `force_delete_without_recovery` is set to `true`, `recovery_window_in_days` will be ignored.
        """
        return pulumi.get(self, "recovery_window_in_days")

    @_builtins.property
    @pulumi.getter(name="rotationInterval")
    def rotation_interval(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The interval for automatic rotation. For more information, see [How to use it](https://www.alibabacloud.com/help/en/key-management-service/latest/kms-createsecret).
        """
        return pulumi.get(self, "rotation_interval")

    @_builtins.property
    @pulumi.getter(name="secretData")
    def secret_data(self) -> pulumi.Output[_builtins.str]:
        """
        The data of the secret. **NOTE:** From version 1.204.1, `secret_data` updating diff will be ignored when `secret_type` is not `Generic`.
        """
        return pulumi.get(self, "secret_data")

    @_builtins.property
    @pulumi.getter(name="secretDataType")
    def secret_data_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The type of the secret value. Default value: `text`. Valid values: `text`, `binary`.
        """
        return pulumi.get(self, "secret_data_type")

    @_builtins.property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the secret. For more information, see [How to use it](https://www.alibabacloud.com/help/en/key-management-service/latest/kms-createsecret).
        """
        return pulumi.get(self, "secret_name")

    @_builtins.property
    @pulumi.getter(name="secretType")
    def secret_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the secret. Valid values:
        - `Generic`: Generic secret.
        - `Rds`: ApsaraDB RDS secret.
        - `Redis`: (Available since v1.253.0) ApsaraDB for Redis secret.
        - `RAMCredentials`: RAM secret.
        - `ECS`: ECS secret.
        - `PolarDB`: (Available since v1.253.0) PolarDB secret.
        """
        return pulumi.get(self, "secret_type")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="versionId")
    def version_id(self) -> pulumi.Output[_builtins.str]:
        """
        The version number of the initial version.
        """
        return pulumi.get(self, "version_id")

    @_builtins.property
    @pulumi.getter(name="versionStages")
    def version_stages(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The stage label that is used to mark the new version.
        """
        return pulumi.get(self, "version_stages")

