# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AlertArgs', 'Alert']

@pulumi.input_type
class AlertArgs:
    def __init__(__self__, *,
                 alert_displayname: pulumi.Input[_builtins.str],
                 alert_name: pulumi.Input[_builtins.str],
                 project_name: pulumi.Input[_builtins.str],
                 alert_description: Optional[pulumi.Input[_builtins.str]] = None,
                 annotations: Optional[pulumi.Input[Sequence[pulumi.Input['AlertAnnotationArgs']]]] = None,
                 auto_annotation: Optional[pulumi.Input[_builtins.bool]] = None,
                 condition: Optional[pulumi.Input[_builtins.str]] = None,
                 dashboard: Optional[pulumi.Input[_builtins.str]] = None,
                 group_configuration: Optional[pulumi.Input['AlertGroupConfigurationArgs']] = None,
                 join_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['AlertJoinConfigurationArgs']]]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input['AlertLabelArgs']]]] = None,
                 mute_until: Optional[pulumi.Input[_builtins.int]] = None,
                 no_data_fire: Optional[pulumi.Input[_builtins.bool]] = None,
                 no_data_severity: Optional[pulumi.Input[_builtins.int]] = None,
                 notification_lists: Optional[pulumi.Input[Sequence[pulumi.Input['AlertNotificationListArgs']]]] = None,
                 notify_threshold: Optional[pulumi.Input[_builtins.int]] = None,
                 policy_configuration: Optional[pulumi.Input['AlertPolicyConfigurationArgs']] = None,
                 query_lists: Optional[pulumi.Input[Sequence[pulumi.Input['AlertQueryListArgs']]]] = None,
                 schedule: Optional[pulumi.Input['AlertScheduleArgs']] = None,
                 schedule_interval: Optional[pulumi.Input[_builtins.str]] = None,
                 schedule_type: Optional[pulumi.Input[_builtins.str]] = None,
                 send_resolved: Optional[pulumi.Input[_builtins.bool]] = None,
                 severity_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['AlertSeverityConfigurationArgs']]]] = None,
                 template_configuration: Optional[pulumi.Input['AlertTemplateConfigurationArgs']] = None,
                 threshold: Optional[pulumi.Input[_builtins.int]] = None,
                 throttling: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Alert resource.
        :param pulumi.Input[_builtins.str] alert_displayname: Alert displayname.
        :param pulumi.Input[_builtins.str] alert_name: Name of logstore for configuring alarm service.
        :param pulumi.Input[_builtins.str] project_name: The project name.
        :param pulumi.Input[_builtins.str] alert_description: Alert description.
        :param pulumi.Input[Sequence[pulumi.Input['AlertAnnotationArgs']]] annotations: Annotations for new alert.
        :param pulumi.Input[_builtins.bool] auto_annotation: whether to add automatic annotation, default is false.
        :param pulumi.Input[_builtins.str] condition: Conditional expression, such as: count> 100, Deprecated from 1.161.0+.
        :param pulumi.Input['AlertGroupConfigurationArgs'] group_configuration: Group configuration for new alert.
        :param pulumi.Input[Sequence[pulumi.Input['AlertJoinConfigurationArgs']]] join_configurations: Join configuration for different queries.
        :param pulumi.Input[Sequence[pulumi.Input['AlertLabelArgs']]] labels: Labels for new alert.
        :param pulumi.Input[_builtins.int] mute_until: Timestamp, notifications before closing again.
        :param pulumi.Input[_builtins.bool] no_data_fire: Switch for whether new alert fires when no data happens, default is false.
        :param pulumi.Input[_builtins.int] no_data_severity: when no data happens, the severity of new alert.
        :param pulumi.Input[Sequence[pulumi.Input['AlertNotificationListArgs']]] notification_lists: Alarm information notification list, Deprecated from 1.161.0+.
        :param pulumi.Input[_builtins.int] notify_threshold: Notification threshold, which is not notified until the number of triggers is reached. The default is 1, Deprecated from 1.161.0+.
        :param pulumi.Input['AlertPolicyConfigurationArgs'] policy_configuration: Policy configuration for new alert.
        :param pulumi.Input[Sequence[pulumi.Input['AlertQueryListArgs']]] query_lists: Multiple conditions for configured alarm query.
        :param pulumi.Input['AlertScheduleArgs'] schedule: schedule for alert.
        :param pulumi.Input[_builtins.str] schedule_interval: Execution interval. 60 seconds minimum, such as 60s, 1h. Deprecated from 1.176.0+. use interval in schedule.
        :param pulumi.Input[_builtins.str] schedule_type: Default FixedRate. No need to configure this parameter. Deprecated from 1.176.0+. use type in schedule.
        :param pulumi.Input[_builtins.bool] send_resolved: when new alert is resolved, whether to notify, default is false.
        :param pulumi.Input[Sequence[pulumi.Input['AlertSeverityConfigurationArgs']]] severity_configurations: Severity configuration for new alert.
        :param pulumi.Input['AlertTemplateConfigurationArgs'] template_configuration: Template configuration for alert, when `type` is `tpl`.
        :param pulumi.Input[_builtins.int] threshold: Evaluation threshold, alert will not fire until the number of triggers is reached. The default is 1.
        :param pulumi.Input[_builtins.str] throttling: Notification interval, default is no interval. Support number + unit type, for example 60s, 1h, Deprecated from 1.161.0+.
        :param pulumi.Input[_builtins.str] type: The type of new alert, `default` for custom alert, `tpl` for template alert.
        :param pulumi.Input[_builtins.str] version: The version of alert, new alert is 2.0.
        """
        pulumi.set(__self__, "alert_displayname", alert_displayname)
        pulumi.set(__self__, "alert_name", alert_name)
        pulumi.set(__self__, "project_name", project_name)
        if alert_description is not None:
            pulumi.set(__self__, "alert_description", alert_description)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if auto_annotation is not None:
            pulumi.set(__self__, "auto_annotation", auto_annotation)
        if condition is not None:
            warnings.warn("""Deprecated from 1.161.0+, use eval_condition in severity_configurations""", DeprecationWarning)
            pulumi.log.warn("""condition is deprecated: Deprecated from 1.161.0+, use eval_condition in severity_configurations""")
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if dashboard is not None:
            warnings.warn("""Deprecated from 1.161.0+, use dashboardId in query_list""", DeprecationWarning)
            pulumi.log.warn("""dashboard is deprecated: Deprecated from 1.161.0+, use dashboardId in query_list""")
        if dashboard is not None:
            pulumi.set(__self__, "dashboard", dashboard)
        if group_configuration is not None:
            pulumi.set(__self__, "group_configuration", group_configuration)
        if join_configurations is not None:
            pulumi.set(__self__, "join_configurations", join_configurations)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if mute_until is not None:
            pulumi.set(__self__, "mute_until", mute_until)
        if no_data_fire is not None:
            pulumi.set(__self__, "no_data_fire", no_data_fire)
        if no_data_severity is not None:
            pulumi.set(__self__, "no_data_severity", no_data_severity)
        if notification_lists is not None:
            warnings.warn("""Deprecated from 1.161.0+, use policy_configuration for notification""", DeprecationWarning)
            pulumi.log.warn("""notification_lists is deprecated: Deprecated from 1.161.0+, use policy_configuration for notification""")
        if notification_lists is not None:
            pulumi.set(__self__, "notification_lists", notification_lists)
        if notify_threshold is not None:
            warnings.warn("""Deprecated from 1.161.0+, use threshold""", DeprecationWarning)
            pulumi.log.warn("""notify_threshold is deprecated: Deprecated from 1.161.0+, use threshold""")
        if notify_threshold is not None:
            pulumi.set(__self__, "notify_threshold", notify_threshold)
        if policy_configuration is not None:
            pulumi.set(__self__, "policy_configuration", policy_configuration)
        if query_lists is not None:
            pulumi.set(__self__, "query_lists", query_lists)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)
        if schedule_interval is not None:
            warnings.warn("""Field 'schedule_interval' has been deprecated from provider version 1.176.0. New field 'schedule' instead.""", DeprecationWarning)
            pulumi.log.warn("""schedule_interval is deprecated: Field 'schedule_interval' has been deprecated from provider version 1.176.0. New field 'schedule' instead.""")
        if schedule_interval is not None:
            pulumi.set(__self__, "schedule_interval", schedule_interval)
        if schedule_type is not None:
            warnings.warn("""Field 'schedule_type' has been deprecated from provider version 1.176.0. New field 'schedule' instead.""", DeprecationWarning)
            pulumi.log.warn("""schedule_type is deprecated: Field 'schedule_type' has been deprecated from provider version 1.176.0. New field 'schedule' instead.""")
        if schedule_type is not None:
            pulumi.set(__self__, "schedule_type", schedule_type)
        if send_resolved is not None:
            pulumi.set(__self__, "send_resolved", send_resolved)
        if severity_configurations is not None:
            pulumi.set(__self__, "severity_configurations", severity_configurations)
        if template_configuration is not None:
            pulumi.set(__self__, "template_configuration", template_configuration)
        if threshold is not None:
            pulumi.set(__self__, "threshold", threshold)
        if throttling is not None:
            warnings.warn("""Deprecated from 1.161.0+, use repeat_interval in policy_configuration""", DeprecationWarning)
            pulumi.log.warn("""throttling is deprecated: Deprecated from 1.161.0+, use repeat_interval in policy_configuration""")
        if throttling is not None:
            pulumi.set(__self__, "throttling", throttling)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="alertDisplayname")
    def alert_displayname(self) -> pulumi.Input[_builtins.str]:
        """
        Alert displayname.
        """
        return pulumi.get(self, "alert_displayname")

    @alert_displayname.setter
    def alert_displayname(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "alert_displayname", value)

    @_builtins.property
    @pulumi.getter(name="alertName")
    def alert_name(self) -> pulumi.Input[_builtins.str]:
        """
        Name of logstore for configuring alarm service.
        """
        return pulumi.get(self, "alert_name")

    @alert_name.setter
    def alert_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "alert_name", value)

    @_builtins.property
    @pulumi.getter(name="projectName")
    def project_name(self) -> pulumi.Input[_builtins.str]:
        """
        The project name.
        """
        return pulumi.get(self, "project_name")

    @project_name.setter
    def project_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project_name", value)

    @_builtins.property
    @pulumi.getter(name="alertDescription")
    def alert_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Alert description.
        """
        return pulumi.get(self, "alert_description")

    @alert_description.setter
    def alert_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "alert_description", value)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlertAnnotationArgs']]]]:
        """
        Annotations for new alert.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlertAnnotationArgs']]]]):
        pulumi.set(self, "annotations", value)

    @_builtins.property
    @pulumi.getter(name="autoAnnotation")
    def auto_annotation(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        whether to add automatic annotation, default is false.
        """
        return pulumi.get(self, "auto_annotation")

    @auto_annotation.setter
    def auto_annotation(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_annotation", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Deprecated from 1.161.0+, use eval_condition in severity_configurations""")
    def condition(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Conditional expression, such as: count> 100, Deprecated from 1.161.0+.
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "condition", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Deprecated from 1.161.0+, use dashboardId in query_list""")
    def dashboard(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "dashboard")

    @dashboard.setter
    def dashboard(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dashboard", value)

    @_builtins.property
    @pulumi.getter(name="groupConfiguration")
    def group_configuration(self) -> Optional[pulumi.Input['AlertGroupConfigurationArgs']]:
        """
        Group configuration for new alert.
        """
        return pulumi.get(self, "group_configuration")

    @group_configuration.setter
    def group_configuration(self, value: Optional[pulumi.Input['AlertGroupConfigurationArgs']]):
        pulumi.set(self, "group_configuration", value)

    @_builtins.property
    @pulumi.getter(name="joinConfigurations")
    def join_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlertJoinConfigurationArgs']]]]:
        """
        Join configuration for different queries.
        """
        return pulumi.get(self, "join_configurations")

    @join_configurations.setter
    def join_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlertJoinConfigurationArgs']]]]):
        pulumi.set(self, "join_configurations", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlertLabelArgs']]]]:
        """
        Labels for new alert.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlertLabelArgs']]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="muteUntil")
    def mute_until(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Timestamp, notifications before closing again.
        """
        return pulumi.get(self, "mute_until")

    @mute_until.setter
    def mute_until(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "mute_until", value)

    @_builtins.property
    @pulumi.getter(name="noDataFire")
    def no_data_fire(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Switch for whether new alert fires when no data happens, default is false.
        """
        return pulumi.get(self, "no_data_fire")

    @no_data_fire.setter
    def no_data_fire(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "no_data_fire", value)

    @_builtins.property
    @pulumi.getter(name="noDataSeverity")
    def no_data_severity(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        when no data happens, the severity of new alert.
        """
        return pulumi.get(self, "no_data_severity")

    @no_data_severity.setter
    def no_data_severity(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "no_data_severity", value)

    @_builtins.property
    @pulumi.getter(name="notificationLists")
    @_utilities.deprecated("""Deprecated from 1.161.0+, use policy_configuration for notification""")
    def notification_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlertNotificationListArgs']]]]:
        """
        Alarm information notification list, Deprecated from 1.161.0+.
        """
        return pulumi.get(self, "notification_lists")

    @notification_lists.setter
    def notification_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlertNotificationListArgs']]]]):
        pulumi.set(self, "notification_lists", value)

    @_builtins.property
    @pulumi.getter(name="notifyThreshold")
    @_utilities.deprecated("""Deprecated from 1.161.0+, use threshold""")
    def notify_threshold(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Notification threshold, which is not notified until the number of triggers is reached. The default is 1, Deprecated from 1.161.0+.
        """
        return pulumi.get(self, "notify_threshold")

    @notify_threshold.setter
    def notify_threshold(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "notify_threshold", value)

    @_builtins.property
    @pulumi.getter(name="policyConfiguration")
    def policy_configuration(self) -> Optional[pulumi.Input['AlertPolicyConfigurationArgs']]:
        """
        Policy configuration for new alert.
        """
        return pulumi.get(self, "policy_configuration")

    @policy_configuration.setter
    def policy_configuration(self, value: Optional[pulumi.Input['AlertPolicyConfigurationArgs']]):
        pulumi.set(self, "policy_configuration", value)

    @_builtins.property
    @pulumi.getter(name="queryLists")
    def query_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlertQueryListArgs']]]]:
        """
        Multiple conditions for configured alarm query.
        """
        return pulumi.get(self, "query_lists")

    @query_lists.setter
    def query_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlertQueryListArgs']]]]):
        pulumi.set(self, "query_lists", value)

    @_builtins.property
    @pulumi.getter
    def schedule(self) -> Optional[pulumi.Input['AlertScheduleArgs']]:
        """
        schedule for alert.
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input['AlertScheduleArgs']]):
        pulumi.set(self, "schedule", value)

    @_builtins.property
    @pulumi.getter(name="scheduleInterval")
    @_utilities.deprecated("""Field 'schedule_interval' has been deprecated from provider version 1.176.0. New field 'schedule' instead.""")
    def schedule_interval(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Execution interval. 60 seconds minimum, such as 60s, 1h. Deprecated from 1.176.0+. use interval in schedule.
        """
        return pulumi.get(self, "schedule_interval")

    @schedule_interval.setter
    def schedule_interval(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schedule_interval", value)

    @_builtins.property
    @pulumi.getter(name="scheduleType")
    @_utilities.deprecated("""Field 'schedule_type' has been deprecated from provider version 1.176.0. New field 'schedule' instead.""")
    def schedule_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Default FixedRate. No need to configure this parameter. Deprecated from 1.176.0+. use type in schedule.
        """
        return pulumi.get(self, "schedule_type")

    @schedule_type.setter
    def schedule_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schedule_type", value)

    @_builtins.property
    @pulumi.getter(name="sendResolved")
    def send_resolved(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        when new alert is resolved, whether to notify, default is false.
        """
        return pulumi.get(self, "send_resolved")

    @send_resolved.setter
    def send_resolved(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "send_resolved", value)

    @_builtins.property
    @pulumi.getter(name="severityConfigurations")
    def severity_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlertSeverityConfigurationArgs']]]]:
        """
        Severity configuration for new alert.
        """
        return pulumi.get(self, "severity_configurations")

    @severity_configurations.setter
    def severity_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlertSeverityConfigurationArgs']]]]):
        pulumi.set(self, "severity_configurations", value)

    @_builtins.property
    @pulumi.getter(name="templateConfiguration")
    def template_configuration(self) -> Optional[pulumi.Input['AlertTemplateConfigurationArgs']]:
        """
        Template configuration for alert, when `type` is `tpl`.
        """
        return pulumi.get(self, "template_configuration")

    @template_configuration.setter
    def template_configuration(self, value: Optional[pulumi.Input['AlertTemplateConfigurationArgs']]):
        pulumi.set(self, "template_configuration", value)

    @_builtins.property
    @pulumi.getter
    def threshold(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Evaluation threshold, alert will not fire until the number of triggers is reached. The default is 1.
        """
        return pulumi.get(self, "threshold")

    @threshold.setter
    def threshold(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "threshold", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Deprecated from 1.161.0+, use repeat_interval in policy_configuration""")
    def throttling(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Notification interval, default is no interval. Support number + unit type, for example 60s, 1h, Deprecated from 1.161.0+.
        """
        return pulumi.get(self, "throttling")

    @throttling.setter
    def throttling(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "throttling", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of new alert, `default` for custom alert, `tpl` for template alert.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version of alert, new alert is 2.0.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class _AlertState:
    def __init__(__self__, *,
                 alert_description: Optional[pulumi.Input[_builtins.str]] = None,
                 alert_displayname: Optional[pulumi.Input[_builtins.str]] = None,
                 alert_name: Optional[pulumi.Input[_builtins.str]] = None,
                 annotations: Optional[pulumi.Input[Sequence[pulumi.Input['AlertAnnotationArgs']]]] = None,
                 auto_annotation: Optional[pulumi.Input[_builtins.bool]] = None,
                 condition: Optional[pulumi.Input[_builtins.str]] = None,
                 dashboard: Optional[pulumi.Input[_builtins.str]] = None,
                 group_configuration: Optional[pulumi.Input['AlertGroupConfigurationArgs']] = None,
                 join_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['AlertJoinConfigurationArgs']]]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input['AlertLabelArgs']]]] = None,
                 mute_until: Optional[pulumi.Input[_builtins.int]] = None,
                 no_data_fire: Optional[pulumi.Input[_builtins.bool]] = None,
                 no_data_severity: Optional[pulumi.Input[_builtins.int]] = None,
                 notification_lists: Optional[pulumi.Input[Sequence[pulumi.Input['AlertNotificationListArgs']]]] = None,
                 notify_threshold: Optional[pulumi.Input[_builtins.int]] = None,
                 policy_configuration: Optional[pulumi.Input['AlertPolicyConfigurationArgs']] = None,
                 project_name: Optional[pulumi.Input[_builtins.str]] = None,
                 query_lists: Optional[pulumi.Input[Sequence[pulumi.Input['AlertQueryListArgs']]]] = None,
                 schedule: Optional[pulumi.Input['AlertScheduleArgs']] = None,
                 schedule_interval: Optional[pulumi.Input[_builtins.str]] = None,
                 schedule_type: Optional[pulumi.Input[_builtins.str]] = None,
                 send_resolved: Optional[pulumi.Input[_builtins.bool]] = None,
                 severity_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['AlertSeverityConfigurationArgs']]]] = None,
                 template_configuration: Optional[pulumi.Input['AlertTemplateConfigurationArgs']] = None,
                 threshold: Optional[pulumi.Input[_builtins.int]] = None,
                 throttling: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Alert resources.
        :param pulumi.Input[_builtins.str] alert_description: Alert description.
        :param pulumi.Input[_builtins.str] alert_displayname: Alert displayname.
        :param pulumi.Input[_builtins.str] alert_name: Name of logstore for configuring alarm service.
        :param pulumi.Input[Sequence[pulumi.Input['AlertAnnotationArgs']]] annotations: Annotations for new alert.
        :param pulumi.Input[_builtins.bool] auto_annotation: whether to add automatic annotation, default is false.
        :param pulumi.Input[_builtins.str] condition: Conditional expression, such as: count> 100, Deprecated from 1.161.0+.
        :param pulumi.Input['AlertGroupConfigurationArgs'] group_configuration: Group configuration for new alert.
        :param pulumi.Input[Sequence[pulumi.Input['AlertJoinConfigurationArgs']]] join_configurations: Join configuration for different queries.
        :param pulumi.Input[Sequence[pulumi.Input['AlertLabelArgs']]] labels: Labels for new alert.
        :param pulumi.Input[_builtins.int] mute_until: Timestamp, notifications before closing again.
        :param pulumi.Input[_builtins.bool] no_data_fire: Switch for whether new alert fires when no data happens, default is false.
        :param pulumi.Input[_builtins.int] no_data_severity: when no data happens, the severity of new alert.
        :param pulumi.Input[Sequence[pulumi.Input['AlertNotificationListArgs']]] notification_lists: Alarm information notification list, Deprecated from 1.161.0+.
        :param pulumi.Input[_builtins.int] notify_threshold: Notification threshold, which is not notified until the number of triggers is reached. The default is 1, Deprecated from 1.161.0+.
        :param pulumi.Input['AlertPolicyConfigurationArgs'] policy_configuration: Policy configuration for new alert.
        :param pulumi.Input[_builtins.str] project_name: The project name.
        :param pulumi.Input[Sequence[pulumi.Input['AlertQueryListArgs']]] query_lists: Multiple conditions for configured alarm query.
        :param pulumi.Input['AlertScheduleArgs'] schedule: schedule for alert.
        :param pulumi.Input[_builtins.str] schedule_interval: Execution interval. 60 seconds minimum, such as 60s, 1h. Deprecated from 1.176.0+. use interval in schedule.
        :param pulumi.Input[_builtins.str] schedule_type: Default FixedRate. No need to configure this parameter. Deprecated from 1.176.0+. use type in schedule.
        :param pulumi.Input[_builtins.bool] send_resolved: when new alert is resolved, whether to notify, default is false.
        :param pulumi.Input[Sequence[pulumi.Input['AlertSeverityConfigurationArgs']]] severity_configurations: Severity configuration for new alert.
        :param pulumi.Input['AlertTemplateConfigurationArgs'] template_configuration: Template configuration for alert, when `type` is `tpl`.
        :param pulumi.Input[_builtins.int] threshold: Evaluation threshold, alert will not fire until the number of triggers is reached. The default is 1.
        :param pulumi.Input[_builtins.str] throttling: Notification interval, default is no interval. Support number + unit type, for example 60s, 1h, Deprecated from 1.161.0+.
        :param pulumi.Input[_builtins.str] type: The type of new alert, `default` for custom alert, `tpl` for template alert.
        :param pulumi.Input[_builtins.str] version: The version of alert, new alert is 2.0.
        """
        if alert_description is not None:
            pulumi.set(__self__, "alert_description", alert_description)
        if alert_displayname is not None:
            pulumi.set(__self__, "alert_displayname", alert_displayname)
        if alert_name is not None:
            pulumi.set(__self__, "alert_name", alert_name)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if auto_annotation is not None:
            pulumi.set(__self__, "auto_annotation", auto_annotation)
        if condition is not None:
            warnings.warn("""Deprecated from 1.161.0+, use eval_condition in severity_configurations""", DeprecationWarning)
            pulumi.log.warn("""condition is deprecated: Deprecated from 1.161.0+, use eval_condition in severity_configurations""")
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if dashboard is not None:
            warnings.warn("""Deprecated from 1.161.0+, use dashboardId in query_list""", DeprecationWarning)
            pulumi.log.warn("""dashboard is deprecated: Deprecated from 1.161.0+, use dashboardId in query_list""")
        if dashboard is not None:
            pulumi.set(__self__, "dashboard", dashboard)
        if group_configuration is not None:
            pulumi.set(__self__, "group_configuration", group_configuration)
        if join_configurations is not None:
            pulumi.set(__self__, "join_configurations", join_configurations)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if mute_until is not None:
            pulumi.set(__self__, "mute_until", mute_until)
        if no_data_fire is not None:
            pulumi.set(__self__, "no_data_fire", no_data_fire)
        if no_data_severity is not None:
            pulumi.set(__self__, "no_data_severity", no_data_severity)
        if notification_lists is not None:
            warnings.warn("""Deprecated from 1.161.0+, use policy_configuration for notification""", DeprecationWarning)
            pulumi.log.warn("""notification_lists is deprecated: Deprecated from 1.161.0+, use policy_configuration for notification""")
        if notification_lists is not None:
            pulumi.set(__self__, "notification_lists", notification_lists)
        if notify_threshold is not None:
            warnings.warn("""Deprecated from 1.161.0+, use threshold""", DeprecationWarning)
            pulumi.log.warn("""notify_threshold is deprecated: Deprecated from 1.161.0+, use threshold""")
        if notify_threshold is not None:
            pulumi.set(__self__, "notify_threshold", notify_threshold)
        if policy_configuration is not None:
            pulumi.set(__self__, "policy_configuration", policy_configuration)
        if project_name is not None:
            pulumi.set(__self__, "project_name", project_name)
        if query_lists is not None:
            pulumi.set(__self__, "query_lists", query_lists)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)
        if schedule_interval is not None:
            warnings.warn("""Field 'schedule_interval' has been deprecated from provider version 1.176.0. New field 'schedule' instead.""", DeprecationWarning)
            pulumi.log.warn("""schedule_interval is deprecated: Field 'schedule_interval' has been deprecated from provider version 1.176.0. New field 'schedule' instead.""")
        if schedule_interval is not None:
            pulumi.set(__self__, "schedule_interval", schedule_interval)
        if schedule_type is not None:
            warnings.warn("""Field 'schedule_type' has been deprecated from provider version 1.176.0. New field 'schedule' instead.""", DeprecationWarning)
            pulumi.log.warn("""schedule_type is deprecated: Field 'schedule_type' has been deprecated from provider version 1.176.0. New field 'schedule' instead.""")
        if schedule_type is not None:
            pulumi.set(__self__, "schedule_type", schedule_type)
        if send_resolved is not None:
            pulumi.set(__self__, "send_resolved", send_resolved)
        if severity_configurations is not None:
            pulumi.set(__self__, "severity_configurations", severity_configurations)
        if template_configuration is not None:
            pulumi.set(__self__, "template_configuration", template_configuration)
        if threshold is not None:
            pulumi.set(__self__, "threshold", threshold)
        if throttling is not None:
            warnings.warn("""Deprecated from 1.161.0+, use repeat_interval in policy_configuration""", DeprecationWarning)
            pulumi.log.warn("""throttling is deprecated: Deprecated from 1.161.0+, use repeat_interval in policy_configuration""")
        if throttling is not None:
            pulumi.set(__self__, "throttling", throttling)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="alertDescription")
    def alert_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Alert description.
        """
        return pulumi.get(self, "alert_description")

    @alert_description.setter
    def alert_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "alert_description", value)

    @_builtins.property
    @pulumi.getter(name="alertDisplayname")
    def alert_displayname(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Alert displayname.
        """
        return pulumi.get(self, "alert_displayname")

    @alert_displayname.setter
    def alert_displayname(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "alert_displayname", value)

    @_builtins.property
    @pulumi.getter(name="alertName")
    def alert_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of logstore for configuring alarm service.
        """
        return pulumi.get(self, "alert_name")

    @alert_name.setter
    def alert_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "alert_name", value)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlertAnnotationArgs']]]]:
        """
        Annotations for new alert.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlertAnnotationArgs']]]]):
        pulumi.set(self, "annotations", value)

    @_builtins.property
    @pulumi.getter(name="autoAnnotation")
    def auto_annotation(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        whether to add automatic annotation, default is false.
        """
        return pulumi.get(self, "auto_annotation")

    @auto_annotation.setter
    def auto_annotation(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_annotation", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Deprecated from 1.161.0+, use eval_condition in severity_configurations""")
    def condition(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Conditional expression, such as: count> 100, Deprecated from 1.161.0+.
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "condition", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Deprecated from 1.161.0+, use dashboardId in query_list""")
    def dashboard(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "dashboard")

    @dashboard.setter
    def dashboard(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dashboard", value)

    @_builtins.property
    @pulumi.getter(name="groupConfiguration")
    def group_configuration(self) -> Optional[pulumi.Input['AlertGroupConfigurationArgs']]:
        """
        Group configuration for new alert.
        """
        return pulumi.get(self, "group_configuration")

    @group_configuration.setter
    def group_configuration(self, value: Optional[pulumi.Input['AlertGroupConfigurationArgs']]):
        pulumi.set(self, "group_configuration", value)

    @_builtins.property
    @pulumi.getter(name="joinConfigurations")
    def join_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlertJoinConfigurationArgs']]]]:
        """
        Join configuration for different queries.
        """
        return pulumi.get(self, "join_configurations")

    @join_configurations.setter
    def join_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlertJoinConfigurationArgs']]]]):
        pulumi.set(self, "join_configurations", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlertLabelArgs']]]]:
        """
        Labels for new alert.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlertLabelArgs']]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="muteUntil")
    def mute_until(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Timestamp, notifications before closing again.
        """
        return pulumi.get(self, "mute_until")

    @mute_until.setter
    def mute_until(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "mute_until", value)

    @_builtins.property
    @pulumi.getter(name="noDataFire")
    def no_data_fire(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Switch for whether new alert fires when no data happens, default is false.
        """
        return pulumi.get(self, "no_data_fire")

    @no_data_fire.setter
    def no_data_fire(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "no_data_fire", value)

    @_builtins.property
    @pulumi.getter(name="noDataSeverity")
    def no_data_severity(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        when no data happens, the severity of new alert.
        """
        return pulumi.get(self, "no_data_severity")

    @no_data_severity.setter
    def no_data_severity(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "no_data_severity", value)

    @_builtins.property
    @pulumi.getter(name="notificationLists")
    @_utilities.deprecated("""Deprecated from 1.161.0+, use policy_configuration for notification""")
    def notification_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlertNotificationListArgs']]]]:
        """
        Alarm information notification list, Deprecated from 1.161.0+.
        """
        return pulumi.get(self, "notification_lists")

    @notification_lists.setter
    def notification_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlertNotificationListArgs']]]]):
        pulumi.set(self, "notification_lists", value)

    @_builtins.property
    @pulumi.getter(name="notifyThreshold")
    @_utilities.deprecated("""Deprecated from 1.161.0+, use threshold""")
    def notify_threshold(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Notification threshold, which is not notified until the number of triggers is reached. The default is 1, Deprecated from 1.161.0+.
        """
        return pulumi.get(self, "notify_threshold")

    @notify_threshold.setter
    def notify_threshold(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "notify_threshold", value)

    @_builtins.property
    @pulumi.getter(name="policyConfiguration")
    def policy_configuration(self) -> Optional[pulumi.Input['AlertPolicyConfigurationArgs']]:
        """
        Policy configuration for new alert.
        """
        return pulumi.get(self, "policy_configuration")

    @policy_configuration.setter
    def policy_configuration(self, value: Optional[pulumi.Input['AlertPolicyConfigurationArgs']]):
        pulumi.set(self, "policy_configuration", value)

    @_builtins.property
    @pulumi.getter(name="projectName")
    def project_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The project name.
        """
        return pulumi.get(self, "project_name")

    @project_name.setter
    def project_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_name", value)

    @_builtins.property
    @pulumi.getter(name="queryLists")
    def query_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlertQueryListArgs']]]]:
        """
        Multiple conditions for configured alarm query.
        """
        return pulumi.get(self, "query_lists")

    @query_lists.setter
    def query_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlertQueryListArgs']]]]):
        pulumi.set(self, "query_lists", value)

    @_builtins.property
    @pulumi.getter
    def schedule(self) -> Optional[pulumi.Input['AlertScheduleArgs']]:
        """
        schedule for alert.
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input['AlertScheduleArgs']]):
        pulumi.set(self, "schedule", value)

    @_builtins.property
    @pulumi.getter(name="scheduleInterval")
    @_utilities.deprecated("""Field 'schedule_interval' has been deprecated from provider version 1.176.0. New field 'schedule' instead.""")
    def schedule_interval(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Execution interval. 60 seconds minimum, such as 60s, 1h. Deprecated from 1.176.0+. use interval in schedule.
        """
        return pulumi.get(self, "schedule_interval")

    @schedule_interval.setter
    def schedule_interval(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schedule_interval", value)

    @_builtins.property
    @pulumi.getter(name="scheduleType")
    @_utilities.deprecated("""Field 'schedule_type' has been deprecated from provider version 1.176.0. New field 'schedule' instead.""")
    def schedule_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Default FixedRate. No need to configure this parameter. Deprecated from 1.176.0+. use type in schedule.
        """
        return pulumi.get(self, "schedule_type")

    @schedule_type.setter
    def schedule_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schedule_type", value)

    @_builtins.property
    @pulumi.getter(name="sendResolved")
    def send_resolved(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        when new alert is resolved, whether to notify, default is false.
        """
        return pulumi.get(self, "send_resolved")

    @send_resolved.setter
    def send_resolved(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "send_resolved", value)

    @_builtins.property
    @pulumi.getter(name="severityConfigurations")
    def severity_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlertSeverityConfigurationArgs']]]]:
        """
        Severity configuration for new alert.
        """
        return pulumi.get(self, "severity_configurations")

    @severity_configurations.setter
    def severity_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlertSeverityConfigurationArgs']]]]):
        pulumi.set(self, "severity_configurations", value)

    @_builtins.property
    @pulumi.getter(name="templateConfiguration")
    def template_configuration(self) -> Optional[pulumi.Input['AlertTemplateConfigurationArgs']]:
        """
        Template configuration for alert, when `type` is `tpl`.
        """
        return pulumi.get(self, "template_configuration")

    @template_configuration.setter
    def template_configuration(self, value: Optional[pulumi.Input['AlertTemplateConfigurationArgs']]):
        pulumi.set(self, "template_configuration", value)

    @_builtins.property
    @pulumi.getter
    def threshold(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Evaluation threshold, alert will not fire until the number of triggers is reached. The default is 1.
        """
        return pulumi.get(self, "threshold")

    @threshold.setter
    def threshold(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "threshold", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Deprecated from 1.161.0+, use repeat_interval in policy_configuration""")
    def throttling(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Notification interval, default is no interval. Support number + unit type, for example 60s, 1h, Deprecated from 1.161.0+.
        """
        return pulumi.get(self, "throttling")

    @throttling.setter
    def throttling(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "throttling", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of new alert, `default` for custom alert, `tpl` for template alert.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version of alert, new alert is 2.0.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("alicloud:log/alert:Alert")
class Alert(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alert_description: Optional[pulumi.Input[_builtins.str]] = None,
                 alert_displayname: Optional[pulumi.Input[_builtins.str]] = None,
                 alert_name: Optional[pulumi.Input[_builtins.str]] = None,
                 annotations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlertAnnotationArgs', 'AlertAnnotationArgsDict']]]]] = None,
                 auto_annotation: Optional[pulumi.Input[_builtins.bool]] = None,
                 condition: Optional[pulumi.Input[_builtins.str]] = None,
                 dashboard: Optional[pulumi.Input[_builtins.str]] = None,
                 group_configuration: Optional[pulumi.Input[Union['AlertGroupConfigurationArgs', 'AlertGroupConfigurationArgsDict']]] = None,
                 join_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlertJoinConfigurationArgs', 'AlertJoinConfigurationArgsDict']]]]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlertLabelArgs', 'AlertLabelArgsDict']]]]] = None,
                 mute_until: Optional[pulumi.Input[_builtins.int]] = None,
                 no_data_fire: Optional[pulumi.Input[_builtins.bool]] = None,
                 no_data_severity: Optional[pulumi.Input[_builtins.int]] = None,
                 notification_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlertNotificationListArgs', 'AlertNotificationListArgsDict']]]]] = None,
                 notify_threshold: Optional[pulumi.Input[_builtins.int]] = None,
                 policy_configuration: Optional[pulumi.Input[Union['AlertPolicyConfigurationArgs', 'AlertPolicyConfigurationArgsDict']]] = None,
                 project_name: Optional[pulumi.Input[_builtins.str]] = None,
                 query_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlertQueryListArgs', 'AlertQueryListArgsDict']]]]] = None,
                 schedule: Optional[pulumi.Input[Union['AlertScheduleArgs', 'AlertScheduleArgsDict']]] = None,
                 schedule_interval: Optional[pulumi.Input[_builtins.str]] = None,
                 schedule_type: Optional[pulumi.Input[_builtins.str]] = None,
                 send_resolved: Optional[pulumi.Input[_builtins.bool]] = None,
                 severity_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlertSeverityConfigurationArgs', 'AlertSeverityConfigurationArgsDict']]]]] = None,
                 template_configuration: Optional[pulumi.Input[Union['AlertTemplateConfigurationArgs', 'AlertTemplateConfigurationArgsDict']]] = None,
                 threshold: Optional[pulumi.Input[_builtins.int]] = None,
                 throttling: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Log alert is a unit of log service, which is used to monitor and alert the user's logstore status information.
        Log Service enables you to configure alerts based on the charts in a dashboard to monitor the service status in real time.

        For information about SLS Alert and how to use it, see [SLS Alert Overview](https://www.alibabacloud.com/help/en/doc-detail/209202.html)

        > **NOTE:** Available in 1.78.0

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default = random.index.Integer("default",
            max=99999,
            min=10000)
        example = alicloud.log.Project("example",
            name=f"terraform-example-{default['result']}",
            description="terraform-example")
        example_store = alicloud.log.Store("example",
            project=example.name,
            name="example-store",
            retention_period=3650,
            shard_count=3,
            auto_split=True,
            max_split_shard_count=60,
            append_meta=True)
        example_alert = alicloud.log.Alert("example",
            project_name=example.name,
            alert_name="example-alert",
            alert_displayname="example-alert",
            condition="count> 100",
            dashboard="example-dashboard",
            schedule={
                "type": "FixedRate",
                "interval": "5m",
                "hour": 0,
                "day_of_week": 0,
                "delay": 0,
                "run_immediately": False,
            },
            query_lists=[{
                "logstore": example_store.name,
                "chart_title": "chart_title",
                "start": "-60s",
                "end": "20s",
                "query": "* AND aliyun",
            }],
            notification_lists=[
                {
                    "type": "SMS",
                    "mobile_lists": [
                        "12345678",
                        "87654321",
                    ],
                    "content": "alert content",
                },
                {
                    "type": "Email",
                    "email_lists": [
                        "aliyun@alibaba-inc.com",
                        "tf-example@123.com",
                    ],
                    "content": "alert content",
                },
                {
                    "type": "DingTalk",
                    "service_uri": "www.aliyun.com",
                    "content": "alert content",
                },
            ])
        ```

        Basic Usage for new alert

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default = random.index.Integer("default",
            max=99999,
            min=10000)
        example = alicloud.log.Project("example",
            project_name=f"terraform-example-{default['result']}",
            description="terraform-example")
        example_store = alicloud.log.Store("example",
            project_name=example.project_name,
            logstore_name="example-store",
            retention_period=3650,
            shard_count=3,
            auto_split=True,
            max_split_shard_count=60,
            append_meta=True)
        example_2 = alicloud.log.Alert("example-2",
            version="2.0",
            type="default",
            project_name=example.project_name,
            alert_name="example-alert",
            alert_displayname="example-alert",
            mute_until=1632486684,
            no_data_fire=False,
            no_data_severity=8,
            send_resolved=True,
            auto_annotation=True,
            schedule={
                "type": "FixedRate",
                "interval": "5m",
                "hour": 0,
                "day_of_week": 0,
                "delay": 0,
                "run_immediately": False,
            },
            query_lists=[
                {
                    "store": example_store.logstore_name,
                    "store_type": "log",
                    "project": example.project_name,
                    "region": "cn-heyuan",
                    "chart_title": "chart_title",
                    "start": "-60s",
                    "end": "20s",
                    "query": "* AND aliyun | select count(1) as cnt",
                    "power_sql_mode": "auto",
                    "dashboard_id": "example-dashboard",
                },
                {
                    "store": example_store.logstore_name,
                    "store_type": "log",
                    "project": example.project_name,
                    "region": "cn-heyuan",
                    "chart_title": "chart_title",
                    "start": "-60s",
                    "end": "20s",
                    "query": "error | select count(1) as error_cnt",
                    "power_sql_mode": "enable",
                    "dashboard_id": "example-dashboard",
                },
            ],
            labels=[{
                "key": "env",
                "value": "test",
            }],
            annotations=[
                {
                    "key": "title",
                    "value": "alert title",
                },
                {
                    "key": "desc",
                    "value": "alert desc",
                },
                {
                    "key": "test_key",
                    "value": "test value",
                },
            ],
            group_configuration={
                "type": "custom",
                "fields": ["cnt"],
            },
            policy_configuration={
                "alert_policy_id": "sls.bultin",
                "action_policy_id": "sls_test_action",
                "repeat_interval": "4h",
            },
            severity_configurations=[
                {
                    "severity": 8,
                    "eval_condition": {
                        "condition": "cnt > 3",
                        "count_condition": "__count__ > 3",
                    },
                },
                {
                    "severity": 6,
                    "eval_condition": {
                        "condition": "",
                        "count_condition": "__count__ > 0",
                    },
                },
                {
                    "severity": 2,
                    "eval_condition": {
                        "condition": "",
                        "count_condition": "",
                    },
                },
            ],
            join_configurations=[{
                "type": "cross_join",
                "condition": "",
            }])
        ```

        Basic Usage for alert template

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default = random.index.Integer("default",
            max=99999,
            min=10000)
        example = alicloud.log.Project("example",
            project_name=f"terraform-example-{default['result']}",
            description="terraform-example")
        example_store = alicloud.log.Store("example",
            project_name=example.project_name,
            logstore_name="example-store",
            retention_period=3650,
            shard_count=3,
            auto_split=True,
            max_split_shard_count=60,
            append_meta=True)
        example_3 = alicloud.log.Alert("example-3",
            version="2.0",
            type="tpl",
            project_name=example.project_name,
            alert_name="example-alert",
            alert_displayname="example-alert",
            mute_until=1632486684,
            schedule={
                "type": "FixedRate",
                "interval": "5m",
                "hour": 0,
                "day_of_week": 0,
                "delay": 0,
                "run_immediately": False,
            },
            template_configuration={
                "id": "sls.app.sls_ack.node.down",
                "type": "sys",
                "lang": "cn",
                "annotations": {},
                "tokens": {
                    "interval_minute": "5",
                    "default.action_policy": "sls.app.ack.builtin",
                    "default.severity": "6",
                    "sendResolved": "false",
                    "default.project": example.project_name,
                    "default.logstore": "k8s-event",
                    "default.repeatInterval": "4h",
                    "trigger_threshold": "1",
                    "default.clusterId": "example-cluster-id",
                },
            })
        ```

        ## Import

        Log alert can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:log/alert:Alert example tf-log:tf-log-alert
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] alert_description: Alert description.
        :param pulumi.Input[_builtins.str] alert_displayname: Alert displayname.
        :param pulumi.Input[_builtins.str] alert_name: Name of logstore for configuring alarm service.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AlertAnnotationArgs', 'AlertAnnotationArgsDict']]]] annotations: Annotations for new alert.
        :param pulumi.Input[_builtins.bool] auto_annotation: whether to add automatic annotation, default is false.
        :param pulumi.Input[_builtins.str] condition: Conditional expression, such as: count> 100, Deprecated from 1.161.0+.
        :param pulumi.Input[Union['AlertGroupConfigurationArgs', 'AlertGroupConfigurationArgsDict']] group_configuration: Group configuration for new alert.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AlertJoinConfigurationArgs', 'AlertJoinConfigurationArgsDict']]]] join_configurations: Join configuration for different queries.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AlertLabelArgs', 'AlertLabelArgsDict']]]] labels: Labels for new alert.
        :param pulumi.Input[_builtins.int] mute_until: Timestamp, notifications before closing again.
        :param pulumi.Input[_builtins.bool] no_data_fire: Switch for whether new alert fires when no data happens, default is false.
        :param pulumi.Input[_builtins.int] no_data_severity: when no data happens, the severity of new alert.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AlertNotificationListArgs', 'AlertNotificationListArgsDict']]]] notification_lists: Alarm information notification list, Deprecated from 1.161.0+.
        :param pulumi.Input[_builtins.int] notify_threshold: Notification threshold, which is not notified until the number of triggers is reached. The default is 1, Deprecated from 1.161.0+.
        :param pulumi.Input[Union['AlertPolicyConfigurationArgs', 'AlertPolicyConfigurationArgsDict']] policy_configuration: Policy configuration for new alert.
        :param pulumi.Input[_builtins.str] project_name: The project name.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AlertQueryListArgs', 'AlertQueryListArgsDict']]]] query_lists: Multiple conditions for configured alarm query.
        :param pulumi.Input[Union['AlertScheduleArgs', 'AlertScheduleArgsDict']] schedule: schedule for alert.
        :param pulumi.Input[_builtins.str] schedule_interval: Execution interval. 60 seconds minimum, such as 60s, 1h. Deprecated from 1.176.0+. use interval in schedule.
        :param pulumi.Input[_builtins.str] schedule_type: Default FixedRate. No need to configure this parameter. Deprecated from 1.176.0+. use type in schedule.
        :param pulumi.Input[_builtins.bool] send_resolved: when new alert is resolved, whether to notify, default is false.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AlertSeverityConfigurationArgs', 'AlertSeverityConfigurationArgsDict']]]] severity_configurations: Severity configuration for new alert.
        :param pulumi.Input[Union['AlertTemplateConfigurationArgs', 'AlertTemplateConfigurationArgsDict']] template_configuration: Template configuration for alert, when `type` is `tpl`.
        :param pulumi.Input[_builtins.int] threshold: Evaluation threshold, alert will not fire until the number of triggers is reached. The default is 1.
        :param pulumi.Input[_builtins.str] throttling: Notification interval, default is no interval. Support number + unit type, for example 60s, 1h, Deprecated from 1.161.0+.
        :param pulumi.Input[_builtins.str] type: The type of new alert, `default` for custom alert, `tpl` for template alert.
        :param pulumi.Input[_builtins.str] version: The version of alert, new alert is 2.0.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AlertArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Log alert is a unit of log service, which is used to monitor and alert the user's logstore status information.
        Log Service enables you to configure alerts based on the charts in a dashboard to monitor the service status in real time.

        For information about SLS Alert and how to use it, see [SLS Alert Overview](https://www.alibabacloud.com/help/en/doc-detail/209202.html)

        > **NOTE:** Available in 1.78.0

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default = random.index.Integer("default",
            max=99999,
            min=10000)
        example = alicloud.log.Project("example",
            name=f"terraform-example-{default['result']}",
            description="terraform-example")
        example_store = alicloud.log.Store("example",
            project=example.name,
            name="example-store",
            retention_period=3650,
            shard_count=3,
            auto_split=True,
            max_split_shard_count=60,
            append_meta=True)
        example_alert = alicloud.log.Alert("example",
            project_name=example.name,
            alert_name="example-alert",
            alert_displayname="example-alert",
            condition="count> 100",
            dashboard="example-dashboard",
            schedule={
                "type": "FixedRate",
                "interval": "5m",
                "hour": 0,
                "day_of_week": 0,
                "delay": 0,
                "run_immediately": False,
            },
            query_lists=[{
                "logstore": example_store.name,
                "chart_title": "chart_title",
                "start": "-60s",
                "end": "20s",
                "query": "* AND aliyun",
            }],
            notification_lists=[
                {
                    "type": "SMS",
                    "mobile_lists": [
                        "12345678",
                        "87654321",
                    ],
                    "content": "alert content",
                },
                {
                    "type": "Email",
                    "email_lists": [
                        "aliyun@alibaba-inc.com",
                        "tf-example@123.com",
                    ],
                    "content": "alert content",
                },
                {
                    "type": "DingTalk",
                    "service_uri": "www.aliyun.com",
                    "content": "alert content",
                },
            ])
        ```

        Basic Usage for new alert

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default = random.index.Integer("default",
            max=99999,
            min=10000)
        example = alicloud.log.Project("example",
            project_name=f"terraform-example-{default['result']}",
            description="terraform-example")
        example_store = alicloud.log.Store("example",
            project_name=example.project_name,
            logstore_name="example-store",
            retention_period=3650,
            shard_count=3,
            auto_split=True,
            max_split_shard_count=60,
            append_meta=True)
        example_2 = alicloud.log.Alert("example-2",
            version="2.0",
            type="default",
            project_name=example.project_name,
            alert_name="example-alert",
            alert_displayname="example-alert",
            mute_until=1632486684,
            no_data_fire=False,
            no_data_severity=8,
            send_resolved=True,
            auto_annotation=True,
            schedule={
                "type": "FixedRate",
                "interval": "5m",
                "hour": 0,
                "day_of_week": 0,
                "delay": 0,
                "run_immediately": False,
            },
            query_lists=[
                {
                    "store": example_store.logstore_name,
                    "store_type": "log",
                    "project": example.project_name,
                    "region": "cn-heyuan",
                    "chart_title": "chart_title",
                    "start": "-60s",
                    "end": "20s",
                    "query": "* AND aliyun | select count(1) as cnt",
                    "power_sql_mode": "auto",
                    "dashboard_id": "example-dashboard",
                },
                {
                    "store": example_store.logstore_name,
                    "store_type": "log",
                    "project": example.project_name,
                    "region": "cn-heyuan",
                    "chart_title": "chart_title",
                    "start": "-60s",
                    "end": "20s",
                    "query": "error | select count(1) as error_cnt",
                    "power_sql_mode": "enable",
                    "dashboard_id": "example-dashboard",
                },
            ],
            labels=[{
                "key": "env",
                "value": "test",
            }],
            annotations=[
                {
                    "key": "title",
                    "value": "alert title",
                },
                {
                    "key": "desc",
                    "value": "alert desc",
                },
                {
                    "key": "test_key",
                    "value": "test value",
                },
            ],
            group_configuration={
                "type": "custom",
                "fields": ["cnt"],
            },
            policy_configuration={
                "alert_policy_id": "sls.bultin",
                "action_policy_id": "sls_test_action",
                "repeat_interval": "4h",
            },
            severity_configurations=[
                {
                    "severity": 8,
                    "eval_condition": {
                        "condition": "cnt > 3",
                        "count_condition": "__count__ > 3",
                    },
                },
                {
                    "severity": 6,
                    "eval_condition": {
                        "condition": "",
                        "count_condition": "__count__ > 0",
                    },
                },
                {
                    "severity": 2,
                    "eval_condition": {
                        "condition": "",
                        "count_condition": "",
                    },
                },
            ],
            join_configurations=[{
                "type": "cross_join",
                "condition": "",
            }])
        ```

        Basic Usage for alert template

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default = random.index.Integer("default",
            max=99999,
            min=10000)
        example = alicloud.log.Project("example",
            project_name=f"terraform-example-{default['result']}",
            description="terraform-example")
        example_store = alicloud.log.Store("example",
            project_name=example.project_name,
            logstore_name="example-store",
            retention_period=3650,
            shard_count=3,
            auto_split=True,
            max_split_shard_count=60,
            append_meta=True)
        example_3 = alicloud.log.Alert("example-3",
            version="2.0",
            type="tpl",
            project_name=example.project_name,
            alert_name="example-alert",
            alert_displayname="example-alert",
            mute_until=1632486684,
            schedule={
                "type": "FixedRate",
                "interval": "5m",
                "hour": 0,
                "day_of_week": 0,
                "delay": 0,
                "run_immediately": False,
            },
            template_configuration={
                "id": "sls.app.sls_ack.node.down",
                "type": "sys",
                "lang": "cn",
                "annotations": {},
                "tokens": {
                    "interval_minute": "5",
                    "default.action_policy": "sls.app.ack.builtin",
                    "default.severity": "6",
                    "sendResolved": "false",
                    "default.project": example.project_name,
                    "default.logstore": "k8s-event",
                    "default.repeatInterval": "4h",
                    "trigger_threshold": "1",
                    "default.clusterId": "example-cluster-id",
                },
            })
        ```

        ## Import

        Log alert can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:log/alert:Alert example tf-log:tf-log-alert
        ```

        :param str resource_name: The name of the resource.
        :param AlertArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AlertArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alert_description: Optional[pulumi.Input[_builtins.str]] = None,
                 alert_displayname: Optional[pulumi.Input[_builtins.str]] = None,
                 alert_name: Optional[pulumi.Input[_builtins.str]] = None,
                 annotations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlertAnnotationArgs', 'AlertAnnotationArgsDict']]]]] = None,
                 auto_annotation: Optional[pulumi.Input[_builtins.bool]] = None,
                 condition: Optional[pulumi.Input[_builtins.str]] = None,
                 dashboard: Optional[pulumi.Input[_builtins.str]] = None,
                 group_configuration: Optional[pulumi.Input[Union['AlertGroupConfigurationArgs', 'AlertGroupConfigurationArgsDict']]] = None,
                 join_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlertJoinConfigurationArgs', 'AlertJoinConfigurationArgsDict']]]]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlertLabelArgs', 'AlertLabelArgsDict']]]]] = None,
                 mute_until: Optional[pulumi.Input[_builtins.int]] = None,
                 no_data_fire: Optional[pulumi.Input[_builtins.bool]] = None,
                 no_data_severity: Optional[pulumi.Input[_builtins.int]] = None,
                 notification_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlertNotificationListArgs', 'AlertNotificationListArgsDict']]]]] = None,
                 notify_threshold: Optional[pulumi.Input[_builtins.int]] = None,
                 policy_configuration: Optional[pulumi.Input[Union['AlertPolicyConfigurationArgs', 'AlertPolicyConfigurationArgsDict']]] = None,
                 project_name: Optional[pulumi.Input[_builtins.str]] = None,
                 query_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlertQueryListArgs', 'AlertQueryListArgsDict']]]]] = None,
                 schedule: Optional[pulumi.Input[Union['AlertScheduleArgs', 'AlertScheduleArgsDict']]] = None,
                 schedule_interval: Optional[pulumi.Input[_builtins.str]] = None,
                 schedule_type: Optional[pulumi.Input[_builtins.str]] = None,
                 send_resolved: Optional[pulumi.Input[_builtins.bool]] = None,
                 severity_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlertSeverityConfigurationArgs', 'AlertSeverityConfigurationArgsDict']]]]] = None,
                 template_configuration: Optional[pulumi.Input[Union['AlertTemplateConfigurationArgs', 'AlertTemplateConfigurationArgsDict']]] = None,
                 threshold: Optional[pulumi.Input[_builtins.int]] = None,
                 throttling: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AlertArgs.__new__(AlertArgs)

            __props__.__dict__["alert_description"] = alert_description
            if alert_displayname is None and not opts.urn:
                raise TypeError("Missing required property 'alert_displayname'")
            __props__.__dict__["alert_displayname"] = alert_displayname
            if alert_name is None and not opts.urn:
                raise TypeError("Missing required property 'alert_name'")
            __props__.__dict__["alert_name"] = alert_name
            __props__.__dict__["annotations"] = annotations
            __props__.__dict__["auto_annotation"] = auto_annotation
            __props__.__dict__["condition"] = condition
            __props__.__dict__["dashboard"] = dashboard
            __props__.__dict__["group_configuration"] = group_configuration
            __props__.__dict__["join_configurations"] = join_configurations
            __props__.__dict__["labels"] = labels
            __props__.__dict__["mute_until"] = mute_until
            __props__.__dict__["no_data_fire"] = no_data_fire
            __props__.__dict__["no_data_severity"] = no_data_severity
            __props__.__dict__["notification_lists"] = notification_lists
            __props__.__dict__["notify_threshold"] = notify_threshold
            __props__.__dict__["policy_configuration"] = policy_configuration
            if project_name is None and not opts.urn:
                raise TypeError("Missing required property 'project_name'")
            __props__.__dict__["project_name"] = project_name
            __props__.__dict__["query_lists"] = query_lists
            __props__.__dict__["schedule"] = schedule
            __props__.__dict__["schedule_interval"] = schedule_interval
            __props__.__dict__["schedule_type"] = schedule_type
            __props__.__dict__["send_resolved"] = send_resolved
            __props__.__dict__["severity_configurations"] = severity_configurations
            __props__.__dict__["template_configuration"] = template_configuration
            __props__.__dict__["threshold"] = threshold
            __props__.__dict__["throttling"] = throttling
            __props__.__dict__["type"] = type
            __props__.__dict__["version"] = version
        super(Alert, __self__).__init__(
            'alicloud:log/alert:Alert',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            alert_description: Optional[pulumi.Input[_builtins.str]] = None,
            alert_displayname: Optional[pulumi.Input[_builtins.str]] = None,
            alert_name: Optional[pulumi.Input[_builtins.str]] = None,
            annotations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlertAnnotationArgs', 'AlertAnnotationArgsDict']]]]] = None,
            auto_annotation: Optional[pulumi.Input[_builtins.bool]] = None,
            condition: Optional[pulumi.Input[_builtins.str]] = None,
            dashboard: Optional[pulumi.Input[_builtins.str]] = None,
            group_configuration: Optional[pulumi.Input[Union['AlertGroupConfigurationArgs', 'AlertGroupConfigurationArgsDict']]] = None,
            join_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlertJoinConfigurationArgs', 'AlertJoinConfigurationArgsDict']]]]] = None,
            labels: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlertLabelArgs', 'AlertLabelArgsDict']]]]] = None,
            mute_until: Optional[pulumi.Input[_builtins.int]] = None,
            no_data_fire: Optional[pulumi.Input[_builtins.bool]] = None,
            no_data_severity: Optional[pulumi.Input[_builtins.int]] = None,
            notification_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlertNotificationListArgs', 'AlertNotificationListArgsDict']]]]] = None,
            notify_threshold: Optional[pulumi.Input[_builtins.int]] = None,
            policy_configuration: Optional[pulumi.Input[Union['AlertPolicyConfigurationArgs', 'AlertPolicyConfigurationArgsDict']]] = None,
            project_name: Optional[pulumi.Input[_builtins.str]] = None,
            query_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlertQueryListArgs', 'AlertQueryListArgsDict']]]]] = None,
            schedule: Optional[pulumi.Input[Union['AlertScheduleArgs', 'AlertScheduleArgsDict']]] = None,
            schedule_interval: Optional[pulumi.Input[_builtins.str]] = None,
            schedule_type: Optional[pulumi.Input[_builtins.str]] = None,
            send_resolved: Optional[pulumi.Input[_builtins.bool]] = None,
            severity_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlertSeverityConfigurationArgs', 'AlertSeverityConfigurationArgsDict']]]]] = None,
            template_configuration: Optional[pulumi.Input[Union['AlertTemplateConfigurationArgs', 'AlertTemplateConfigurationArgsDict']]] = None,
            threshold: Optional[pulumi.Input[_builtins.int]] = None,
            throttling: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            version: Optional[pulumi.Input[_builtins.str]] = None) -> 'Alert':
        """
        Get an existing Alert resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] alert_description: Alert description.
        :param pulumi.Input[_builtins.str] alert_displayname: Alert displayname.
        :param pulumi.Input[_builtins.str] alert_name: Name of logstore for configuring alarm service.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AlertAnnotationArgs', 'AlertAnnotationArgsDict']]]] annotations: Annotations for new alert.
        :param pulumi.Input[_builtins.bool] auto_annotation: whether to add automatic annotation, default is false.
        :param pulumi.Input[_builtins.str] condition: Conditional expression, such as: count> 100, Deprecated from 1.161.0+.
        :param pulumi.Input[Union['AlertGroupConfigurationArgs', 'AlertGroupConfigurationArgsDict']] group_configuration: Group configuration for new alert.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AlertJoinConfigurationArgs', 'AlertJoinConfigurationArgsDict']]]] join_configurations: Join configuration for different queries.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AlertLabelArgs', 'AlertLabelArgsDict']]]] labels: Labels for new alert.
        :param pulumi.Input[_builtins.int] mute_until: Timestamp, notifications before closing again.
        :param pulumi.Input[_builtins.bool] no_data_fire: Switch for whether new alert fires when no data happens, default is false.
        :param pulumi.Input[_builtins.int] no_data_severity: when no data happens, the severity of new alert.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AlertNotificationListArgs', 'AlertNotificationListArgsDict']]]] notification_lists: Alarm information notification list, Deprecated from 1.161.0+.
        :param pulumi.Input[_builtins.int] notify_threshold: Notification threshold, which is not notified until the number of triggers is reached. The default is 1, Deprecated from 1.161.0+.
        :param pulumi.Input[Union['AlertPolicyConfigurationArgs', 'AlertPolicyConfigurationArgsDict']] policy_configuration: Policy configuration for new alert.
        :param pulumi.Input[_builtins.str] project_name: The project name.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AlertQueryListArgs', 'AlertQueryListArgsDict']]]] query_lists: Multiple conditions for configured alarm query.
        :param pulumi.Input[Union['AlertScheduleArgs', 'AlertScheduleArgsDict']] schedule: schedule for alert.
        :param pulumi.Input[_builtins.str] schedule_interval: Execution interval. 60 seconds minimum, such as 60s, 1h. Deprecated from 1.176.0+. use interval in schedule.
        :param pulumi.Input[_builtins.str] schedule_type: Default FixedRate. No need to configure this parameter. Deprecated from 1.176.0+. use type in schedule.
        :param pulumi.Input[_builtins.bool] send_resolved: when new alert is resolved, whether to notify, default is false.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AlertSeverityConfigurationArgs', 'AlertSeverityConfigurationArgsDict']]]] severity_configurations: Severity configuration for new alert.
        :param pulumi.Input[Union['AlertTemplateConfigurationArgs', 'AlertTemplateConfigurationArgsDict']] template_configuration: Template configuration for alert, when `type` is `tpl`.
        :param pulumi.Input[_builtins.int] threshold: Evaluation threshold, alert will not fire until the number of triggers is reached. The default is 1.
        :param pulumi.Input[_builtins.str] throttling: Notification interval, default is no interval. Support number + unit type, for example 60s, 1h, Deprecated from 1.161.0+.
        :param pulumi.Input[_builtins.str] type: The type of new alert, `default` for custom alert, `tpl` for template alert.
        :param pulumi.Input[_builtins.str] version: The version of alert, new alert is 2.0.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AlertState.__new__(_AlertState)

        __props__.__dict__["alert_description"] = alert_description
        __props__.__dict__["alert_displayname"] = alert_displayname
        __props__.__dict__["alert_name"] = alert_name
        __props__.__dict__["annotations"] = annotations
        __props__.__dict__["auto_annotation"] = auto_annotation
        __props__.__dict__["condition"] = condition
        __props__.__dict__["dashboard"] = dashboard
        __props__.__dict__["group_configuration"] = group_configuration
        __props__.__dict__["join_configurations"] = join_configurations
        __props__.__dict__["labels"] = labels
        __props__.__dict__["mute_until"] = mute_until
        __props__.__dict__["no_data_fire"] = no_data_fire
        __props__.__dict__["no_data_severity"] = no_data_severity
        __props__.__dict__["notification_lists"] = notification_lists
        __props__.__dict__["notify_threshold"] = notify_threshold
        __props__.__dict__["policy_configuration"] = policy_configuration
        __props__.__dict__["project_name"] = project_name
        __props__.__dict__["query_lists"] = query_lists
        __props__.__dict__["schedule"] = schedule
        __props__.__dict__["schedule_interval"] = schedule_interval
        __props__.__dict__["schedule_type"] = schedule_type
        __props__.__dict__["send_resolved"] = send_resolved
        __props__.__dict__["severity_configurations"] = severity_configurations
        __props__.__dict__["template_configuration"] = template_configuration
        __props__.__dict__["threshold"] = threshold
        __props__.__dict__["throttling"] = throttling
        __props__.__dict__["type"] = type
        __props__.__dict__["version"] = version
        return Alert(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="alertDescription")
    def alert_description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Alert description.
        """
        return pulumi.get(self, "alert_description")

    @_builtins.property
    @pulumi.getter(name="alertDisplayname")
    def alert_displayname(self) -> pulumi.Output[_builtins.str]:
        """
        Alert displayname.
        """
        return pulumi.get(self, "alert_displayname")

    @_builtins.property
    @pulumi.getter(name="alertName")
    def alert_name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of logstore for configuring alarm service.
        """
        return pulumi.get(self, "alert_name")

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> pulumi.Output[Optional[Sequence['outputs.AlertAnnotation']]]:
        """
        Annotations for new alert.
        """
        return pulumi.get(self, "annotations")

    @_builtins.property
    @pulumi.getter(name="autoAnnotation")
    def auto_annotation(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        whether to add automatic annotation, default is false.
        """
        return pulumi.get(self, "auto_annotation")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Deprecated from 1.161.0+, use eval_condition in severity_configurations""")
    def condition(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Conditional expression, such as: count> 100, Deprecated from 1.161.0+.
        """
        return pulumi.get(self, "condition")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Deprecated from 1.161.0+, use dashboardId in query_list""")
    def dashboard(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "dashboard")

    @_builtins.property
    @pulumi.getter(name="groupConfiguration")
    def group_configuration(self) -> pulumi.Output[Optional['outputs.AlertGroupConfiguration']]:
        """
        Group configuration for new alert.
        """
        return pulumi.get(self, "group_configuration")

    @_builtins.property
    @pulumi.getter(name="joinConfigurations")
    def join_configurations(self) -> pulumi.Output[Optional[Sequence['outputs.AlertJoinConfiguration']]]:
        """
        Join configuration for different queries.
        """
        return pulumi.get(self, "join_configurations")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Sequence['outputs.AlertLabel']]]:
        """
        Labels for new alert.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter(name="muteUntil")
    def mute_until(self) -> pulumi.Output[_builtins.int]:
        """
        Timestamp, notifications before closing again.
        """
        return pulumi.get(self, "mute_until")

    @_builtins.property
    @pulumi.getter(name="noDataFire")
    def no_data_fire(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Switch for whether new alert fires when no data happens, default is false.
        """
        return pulumi.get(self, "no_data_fire")

    @_builtins.property
    @pulumi.getter(name="noDataSeverity")
    def no_data_severity(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        when no data happens, the severity of new alert.
        """
        return pulumi.get(self, "no_data_severity")

    @_builtins.property
    @pulumi.getter(name="notificationLists")
    @_utilities.deprecated("""Deprecated from 1.161.0+, use policy_configuration for notification""")
    def notification_lists(self) -> pulumi.Output[Optional[Sequence['outputs.AlertNotificationList']]]:
        """
        Alarm information notification list, Deprecated from 1.161.0+.
        """
        return pulumi.get(self, "notification_lists")

    @_builtins.property
    @pulumi.getter(name="notifyThreshold")
    @_utilities.deprecated("""Deprecated from 1.161.0+, use threshold""")
    def notify_threshold(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Notification threshold, which is not notified until the number of triggers is reached. The default is 1, Deprecated from 1.161.0+.
        """
        return pulumi.get(self, "notify_threshold")

    @_builtins.property
    @pulumi.getter(name="policyConfiguration")
    def policy_configuration(self) -> pulumi.Output[Optional['outputs.AlertPolicyConfiguration']]:
        """
        Policy configuration for new alert.
        """
        return pulumi.get(self, "policy_configuration")

    @_builtins.property
    @pulumi.getter(name="projectName")
    def project_name(self) -> pulumi.Output[_builtins.str]:
        """
        The project name.
        """
        return pulumi.get(self, "project_name")

    @_builtins.property
    @pulumi.getter(name="queryLists")
    def query_lists(self) -> pulumi.Output[Optional[Sequence['outputs.AlertQueryList']]]:
        """
        Multiple conditions for configured alarm query.
        """
        return pulumi.get(self, "query_lists")

    @_builtins.property
    @pulumi.getter
    def schedule(self) -> pulumi.Output[Optional['outputs.AlertSchedule']]:
        """
        schedule for alert.
        """
        return pulumi.get(self, "schedule")

    @_builtins.property
    @pulumi.getter(name="scheduleInterval")
    @_utilities.deprecated("""Field 'schedule_interval' has been deprecated from provider version 1.176.0. New field 'schedule' instead.""")
    def schedule_interval(self) -> pulumi.Output[_builtins.str]:
        """
        Execution interval. 60 seconds minimum, such as 60s, 1h. Deprecated from 1.176.0+. use interval in schedule.
        """
        return pulumi.get(self, "schedule_interval")

    @_builtins.property
    @pulumi.getter(name="scheduleType")
    @_utilities.deprecated("""Field 'schedule_type' has been deprecated from provider version 1.176.0. New field 'schedule' instead.""")
    def schedule_type(self) -> pulumi.Output[_builtins.str]:
        """
        Default FixedRate. No need to configure this parameter. Deprecated from 1.176.0+. use type in schedule.
        """
        return pulumi.get(self, "schedule_type")

    @_builtins.property
    @pulumi.getter(name="sendResolved")
    def send_resolved(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        when new alert is resolved, whether to notify, default is false.
        """
        return pulumi.get(self, "send_resolved")

    @_builtins.property
    @pulumi.getter(name="severityConfigurations")
    def severity_configurations(self) -> pulumi.Output[Optional[Sequence['outputs.AlertSeverityConfiguration']]]:
        """
        Severity configuration for new alert.
        """
        return pulumi.get(self, "severity_configurations")

    @_builtins.property
    @pulumi.getter(name="templateConfiguration")
    def template_configuration(self) -> pulumi.Output[Optional['outputs.AlertTemplateConfiguration']]:
        """
        Template configuration for alert, when `type` is `tpl`.
        """
        return pulumi.get(self, "template_configuration")

    @_builtins.property
    @pulumi.getter
    def threshold(self) -> pulumi.Output[_builtins.int]:
        """
        Evaluation threshold, alert will not fire until the number of triggers is reached. The default is 1.
        """
        return pulumi.get(self, "threshold")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Deprecated from 1.161.0+, use repeat_interval in policy_configuration""")
    def throttling(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Notification interval, default is no interval. Support number + unit type, for example 60s, 1h, Deprecated from 1.161.0+.
        """
        return pulumi.get(self, "throttling")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The type of new alert, `default` for custom alert, `tpl` for template alert.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The version of alert, new alert is 2.0.
        """
        return pulumi.get(self, "version")

