# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['QuotaPlanArgs', 'QuotaPlan']

@pulumi.input_type
class QuotaPlanArgs:
    def __init__(__self__, *,
                 nickname: pulumi.Input[_builtins.str],
                 plan_name: pulumi.Input[_builtins.str],
                 is_effective: Optional[pulumi.Input[_builtins.bool]] = None,
                 quota: Optional[pulumi.Input['QuotaPlanQuotaArgs']] = None):
        """
        The set of arguments for constructing a QuotaPlan resource.
        :param pulumi.Input[_builtins.str] nickname: Quota Name
        :param pulumi.Input[_builtins.str] plan_name: The Quota plan name. Start with a letter, containing letters, numbers, and underscores (_). It is no more than 64 characters long.
        :param pulumi.Input[_builtins.bool] is_effective: Whether to take effect immediately. “Valid values: true”  
               .> **NOTE:** when other quota plans in the same quota group take effect, the effective quota group will become invalid. That is, IsEffective will become false. The effective quota plan cannot be deleted.
        :param pulumi.Input['QuotaPlanQuotaArgs'] quota: Quota property See `quota` below.
        """
        pulumi.set(__self__, "nickname", nickname)
        pulumi.set(__self__, "plan_name", plan_name)
        if is_effective is not None:
            pulumi.set(__self__, "is_effective", is_effective)
        if quota is not None:
            pulumi.set(__self__, "quota", quota)

    @_builtins.property
    @pulumi.getter
    def nickname(self) -> pulumi.Input[_builtins.str]:
        """
        Quota Name
        """
        return pulumi.get(self, "nickname")

    @nickname.setter
    def nickname(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "nickname", value)

    @_builtins.property
    @pulumi.getter(name="planName")
    def plan_name(self) -> pulumi.Input[_builtins.str]:
        """
        The Quota plan name. Start with a letter, containing letters, numbers, and underscores (_). It is no more than 64 characters long.
        """
        return pulumi.get(self, "plan_name")

    @plan_name.setter
    def plan_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "plan_name", value)

    @_builtins.property
    @pulumi.getter(name="isEffective")
    def is_effective(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to take effect immediately. “Valid values: true”  
        .> **NOTE:** when other quota plans in the same quota group take effect, the effective quota group will become invalid. That is, IsEffective will become false. The effective quota plan cannot be deleted.
        """
        return pulumi.get(self, "is_effective")

    @is_effective.setter
    def is_effective(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_effective", value)

    @_builtins.property
    @pulumi.getter
    def quota(self) -> Optional[pulumi.Input['QuotaPlanQuotaArgs']]:
        """
        Quota property See `quota` below.
        """
        return pulumi.get(self, "quota")

    @quota.setter
    def quota(self, value: Optional[pulumi.Input['QuotaPlanQuotaArgs']]):
        pulumi.set(self, "quota", value)


@pulumi.input_type
class _QuotaPlanState:
    def __init__(__self__, *,
                 is_effective: Optional[pulumi.Input[_builtins.bool]] = None,
                 nickname: Optional[pulumi.Input[_builtins.str]] = None,
                 plan_name: Optional[pulumi.Input[_builtins.str]] = None,
                 quota: Optional[pulumi.Input['QuotaPlanQuotaArgs']] = None):
        """
        Input properties used for looking up and filtering QuotaPlan resources.
        :param pulumi.Input[_builtins.bool] is_effective: Whether to take effect immediately. “Valid values: true”  
               .> **NOTE:** when other quota plans in the same quota group take effect, the effective quota group will become invalid. That is, IsEffective will become false. The effective quota plan cannot be deleted.
        :param pulumi.Input[_builtins.str] nickname: Quota Name
        :param pulumi.Input[_builtins.str] plan_name: The Quota plan name. Start with a letter, containing letters, numbers, and underscores (_). It is no more than 64 characters long.
        :param pulumi.Input['QuotaPlanQuotaArgs'] quota: Quota property See `quota` below.
        """
        if is_effective is not None:
            pulumi.set(__self__, "is_effective", is_effective)
        if nickname is not None:
            pulumi.set(__self__, "nickname", nickname)
        if plan_name is not None:
            pulumi.set(__self__, "plan_name", plan_name)
        if quota is not None:
            pulumi.set(__self__, "quota", quota)

    @_builtins.property
    @pulumi.getter(name="isEffective")
    def is_effective(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to take effect immediately. “Valid values: true”  
        .> **NOTE:** when other quota plans in the same quota group take effect, the effective quota group will become invalid. That is, IsEffective will become false. The effective quota plan cannot be deleted.
        """
        return pulumi.get(self, "is_effective")

    @is_effective.setter
    def is_effective(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_effective", value)

    @_builtins.property
    @pulumi.getter
    def nickname(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Quota Name
        """
        return pulumi.get(self, "nickname")

    @nickname.setter
    def nickname(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "nickname", value)

    @_builtins.property
    @pulumi.getter(name="planName")
    def plan_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Quota plan name. Start with a letter, containing letters, numbers, and underscores (_). It is no more than 64 characters long.
        """
        return pulumi.get(self, "plan_name")

    @plan_name.setter
    def plan_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "plan_name", value)

    @_builtins.property
    @pulumi.getter
    def quota(self) -> Optional[pulumi.Input['QuotaPlanQuotaArgs']]:
        """
        Quota property See `quota` below.
        """
        return pulumi.get(self, "quota")

    @quota.setter
    def quota(self, value: Optional[pulumi.Input['QuotaPlanQuotaArgs']]):
        pulumi.set(self, "quota", value)


@pulumi.type_token("alicloud:maxcompute/quotaPlan:QuotaPlan")
class QuotaPlan(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 is_effective: Optional[pulumi.Input[_builtins.bool]] = None,
                 nickname: Optional[pulumi.Input[_builtins.str]] = None,
                 plan_name: Optional[pulumi.Input[_builtins.str]] = None,
                 quota: Optional[pulumi.Input[Union['QuotaPlanQuotaArgs', 'QuotaPlanQuotaArgsDict']]] = None,
                 __props__=None):
        """
        Provides a Max Compute Quota Plan resource.

        For information about Max Compute Quota Plan and how to use it, see [What is Quota Plan](https://www.alibabacloud.com/help/en/).

        > **NOTE:** Available since v1.242.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        elastic_reserved_cu = config.get("elasticReservedCu")
        if elastic_reserved_cu is None:
            elastic_reserved_cu = "50"
        default = alicloud.maxcompute.QuotaPlan("default",
            nickname="os_terrform_p",
            quota={
                "parameter": {
                    "elastic_reserved_cu": elastic_reserved_cu,
                },
                "sub_quota_info_lists": [
                    {
                        "nick_name": "sub_quota",
                        "parameter": {
                            "min_cu": 0,
                            "max_cu": 20,
                            "elastic_reserved_cu": elastic_reserved_cu,
                        },
                    },
                    {
                        "nick_name": "os_terrform",
                        "parameter": {
                            "min_cu": 50,
                            "max_cu": 50,
                            "elastic_reserved_cu": 0,
                        },
                    },
                ],
            },
            plan_name="quota_plan")
        ```

        ## Import

        Max Compute Quota Plan can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:maxcompute/quotaPlan:QuotaPlan example <nickname>:<plan_name>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] is_effective: Whether to take effect immediately. “Valid values: true”  
               .> **NOTE:** when other quota plans in the same quota group take effect, the effective quota group will become invalid. That is, IsEffective will become false. The effective quota plan cannot be deleted.
        :param pulumi.Input[_builtins.str] nickname: Quota Name
        :param pulumi.Input[_builtins.str] plan_name: The Quota plan name. Start with a letter, containing letters, numbers, and underscores (_). It is no more than 64 characters long.
        :param pulumi.Input[Union['QuotaPlanQuotaArgs', 'QuotaPlanQuotaArgsDict']] quota: Quota property See `quota` below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: QuotaPlanArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Max Compute Quota Plan resource.

        For information about Max Compute Quota Plan and how to use it, see [What is Quota Plan](https://www.alibabacloud.com/help/en/).

        > **NOTE:** Available since v1.242.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        elastic_reserved_cu = config.get("elasticReservedCu")
        if elastic_reserved_cu is None:
            elastic_reserved_cu = "50"
        default = alicloud.maxcompute.QuotaPlan("default",
            nickname="os_terrform_p",
            quota={
                "parameter": {
                    "elastic_reserved_cu": elastic_reserved_cu,
                },
                "sub_quota_info_lists": [
                    {
                        "nick_name": "sub_quota",
                        "parameter": {
                            "min_cu": 0,
                            "max_cu": 20,
                            "elastic_reserved_cu": elastic_reserved_cu,
                        },
                    },
                    {
                        "nick_name": "os_terrform",
                        "parameter": {
                            "min_cu": 50,
                            "max_cu": 50,
                            "elastic_reserved_cu": 0,
                        },
                    },
                ],
            },
            plan_name="quota_plan")
        ```

        ## Import

        Max Compute Quota Plan can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:maxcompute/quotaPlan:QuotaPlan example <nickname>:<plan_name>
        ```

        :param str resource_name: The name of the resource.
        :param QuotaPlanArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(QuotaPlanArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 is_effective: Optional[pulumi.Input[_builtins.bool]] = None,
                 nickname: Optional[pulumi.Input[_builtins.str]] = None,
                 plan_name: Optional[pulumi.Input[_builtins.str]] = None,
                 quota: Optional[pulumi.Input[Union['QuotaPlanQuotaArgs', 'QuotaPlanQuotaArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = QuotaPlanArgs.__new__(QuotaPlanArgs)

            __props__.__dict__["is_effective"] = is_effective
            if nickname is None and not opts.urn:
                raise TypeError("Missing required property 'nickname'")
            __props__.__dict__["nickname"] = nickname
            if plan_name is None and not opts.urn:
                raise TypeError("Missing required property 'plan_name'")
            __props__.__dict__["plan_name"] = plan_name
            __props__.__dict__["quota"] = quota
        super(QuotaPlan, __self__).__init__(
            'alicloud:maxcompute/quotaPlan:QuotaPlan',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            is_effective: Optional[pulumi.Input[_builtins.bool]] = None,
            nickname: Optional[pulumi.Input[_builtins.str]] = None,
            plan_name: Optional[pulumi.Input[_builtins.str]] = None,
            quota: Optional[pulumi.Input[Union['QuotaPlanQuotaArgs', 'QuotaPlanQuotaArgsDict']]] = None) -> 'QuotaPlan':
        """
        Get an existing QuotaPlan resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] is_effective: Whether to take effect immediately. “Valid values: true”  
               .> **NOTE:** when other quota plans in the same quota group take effect, the effective quota group will become invalid. That is, IsEffective will become false. The effective quota plan cannot be deleted.
        :param pulumi.Input[_builtins.str] nickname: Quota Name
        :param pulumi.Input[_builtins.str] plan_name: The Quota plan name. Start with a letter, containing letters, numbers, and underscores (_). It is no more than 64 characters long.
        :param pulumi.Input[Union['QuotaPlanQuotaArgs', 'QuotaPlanQuotaArgsDict']] quota: Quota property See `quota` below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _QuotaPlanState.__new__(_QuotaPlanState)

        __props__.__dict__["is_effective"] = is_effective
        __props__.__dict__["nickname"] = nickname
        __props__.__dict__["plan_name"] = plan_name
        __props__.__dict__["quota"] = quota
        return QuotaPlan(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="isEffective")
    def is_effective(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to take effect immediately. “Valid values: true”  
        .> **NOTE:** when other quota plans in the same quota group take effect, the effective quota group will become invalid. That is, IsEffective will become false. The effective quota plan cannot be deleted.
        """
        return pulumi.get(self, "is_effective")

    @_builtins.property
    @pulumi.getter
    def nickname(self) -> pulumi.Output[_builtins.str]:
        """
        Quota Name
        """
        return pulumi.get(self, "nickname")

    @_builtins.property
    @pulumi.getter(name="planName")
    def plan_name(self) -> pulumi.Output[_builtins.str]:
        """
        The Quota plan name. Start with a letter, containing letters, numbers, and underscores (_). It is no more than 64 characters long.
        """
        return pulumi.get(self, "plan_name")

    @_builtins.property
    @pulumi.getter
    def quota(self) -> pulumi.Output[Optional['outputs.QuotaPlanQuota']]:
        """
        Quota property See `quota` below.
        """
        return pulumi.get(self, "quota")

