# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ServiceQueueArgs', 'ServiceQueue']

@pulumi.input_type
class ServiceQueueArgs:
    def __init__(__self__, *,
                 queue_name: pulumi.Input[_builtins.str],
                 delay_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 dlq_policy: Optional[pulumi.Input['ServiceQueueDlqPolicyArgs']] = None,
                 logging_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 maximum_message_size: Optional[pulumi.Input[_builtins.int]] = None,
                 message_retention_period: Optional[pulumi.Input[_builtins.int]] = None,
                 polling_wait_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 visibility_timeout: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a ServiceQueue resource.
        :param pulumi.Input[_builtins.str] queue_name: The name of the queue.
        :param pulumi.Input[_builtins.int] delay_seconds: The period after which all messages sent to the queue are consumed. Default value: `0`. Valid values: `0` to `604800`. Unit: seconds.
        :param pulumi.Input['ServiceQueueDlqPolicyArgs'] dlq_policy: The dead-letter queue policy. See `dlq_policy` below.
        :param pulumi.Input[_builtins.bool] logging_enabled: Specifies whether to enable the logging feature. Default value: `false`. Valid values:
        :param pulumi.Input[_builtins.int] maximum_message_size: The maximum length of the message that is sent to the queue. Valid values: `1024` to `65536`. Unit: bytes. Default value: `65536`.
        :param pulumi.Input[_builtins.int] message_retention_period: The maximum duration for which a message is retained in the queue. After the specified retention period ends, the message is deleted regardless of whether the message is received. Valid values: `60` to `604800`. Unit: seconds. Default value: `345600`.
        :param pulumi.Input[_builtins.int] polling_wait_seconds: The maximum duration for which long polling requests are held after the ReceiveMessage operation is called. Valid values: `0` to `30`. Unit: seconds. Default value: `0`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.int] visibility_timeout: The duration for which a message stays in the Inactive state after the message is received from the queue. Valid values: `1` to `43200`. Unit: seconds. Default value: `30`.
        """
        pulumi.set(__self__, "queue_name", queue_name)
        if delay_seconds is not None:
            pulumi.set(__self__, "delay_seconds", delay_seconds)
        if dlq_policy is not None:
            pulumi.set(__self__, "dlq_policy", dlq_policy)
        if logging_enabled is not None:
            pulumi.set(__self__, "logging_enabled", logging_enabled)
        if maximum_message_size is not None:
            pulumi.set(__self__, "maximum_message_size", maximum_message_size)
        if message_retention_period is not None:
            pulumi.set(__self__, "message_retention_period", message_retention_period)
        if polling_wait_seconds is not None:
            pulumi.set(__self__, "polling_wait_seconds", polling_wait_seconds)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if visibility_timeout is not None:
            pulumi.set(__self__, "visibility_timeout", visibility_timeout)

    @_builtins.property
    @pulumi.getter(name="queueName")
    def queue_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the queue.
        """
        return pulumi.get(self, "queue_name")

    @queue_name.setter
    def queue_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "queue_name", value)

    @_builtins.property
    @pulumi.getter(name="delaySeconds")
    def delay_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The period after which all messages sent to the queue are consumed. Default value: `0`. Valid values: `0` to `604800`. Unit: seconds.
        """
        return pulumi.get(self, "delay_seconds")

    @delay_seconds.setter
    def delay_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "delay_seconds", value)

    @_builtins.property
    @pulumi.getter(name="dlqPolicy")
    def dlq_policy(self) -> Optional[pulumi.Input['ServiceQueueDlqPolicyArgs']]:
        """
        The dead-letter queue policy. See `dlq_policy` below.
        """
        return pulumi.get(self, "dlq_policy")

    @dlq_policy.setter
    def dlq_policy(self, value: Optional[pulumi.Input['ServiceQueueDlqPolicyArgs']]):
        pulumi.set(self, "dlq_policy", value)

    @_builtins.property
    @pulumi.getter(name="loggingEnabled")
    def logging_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable the logging feature. Default value: `false`. Valid values:
        """
        return pulumi.get(self, "logging_enabled")

    @logging_enabled.setter
    def logging_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "logging_enabled", value)

    @_builtins.property
    @pulumi.getter(name="maximumMessageSize")
    def maximum_message_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum length of the message that is sent to the queue. Valid values: `1024` to `65536`. Unit: bytes. Default value: `65536`.
        """
        return pulumi.get(self, "maximum_message_size")

    @maximum_message_size.setter
    def maximum_message_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "maximum_message_size", value)

    @_builtins.property
    @pulumi.getter(name="messageRetentionPeriod")
    def message_retention_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum duration for which a message is retained in the queue. After the specified retention period ends, the message is deleted regardless of whether the message is received. Valid values: `60` to `604800`. Unit: seconds. Default value: `345600`.
        """
        return pulumi.get(self, "message_retention_period")

    @message_retention_period.setter
    def message_retention_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "message_retention_period", value)

    @_builtins.property
    @pulumi.getter(name="pollingWaitSeconds")
    def polling_wait_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum duration for which long polling requests are held after the ReceiveMessage operation is called. Valid values: `0` to `30`. Unit: seconds. Default value: `0`.
        """
        return pulumi.get(self, "polling_wait_seconds")

    @polling_wait_seconds.setter
    def polling_wait_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "polling_wait_seconds", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="visibilityTimeout")
    def visibility_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The duration for which a message stays in the Inactive state after the message is received from the queue. Valid values: `1` to `43200`. Unit: seconds. Default value: `30`.
        """
        return pulumi.get(self, "visibility_timeout")

    @visibility_timeout.setter
    def visibility_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "visibility_timeout", value)


@pulumi.input_type
class _ServiceQueueState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[_builtins.int]] = None,
                 delay_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 dlq_policy: Optional[pulumi.Input['ServiceQueueDlqPolicyArgs']] = None,
                 logging_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 maximum_message_size: Optional[pulumi.Input[_builtins.int]] = None,
                 message_retention_period: Optional[pulumi.Input[_builtins.int]] = None,
                 polling_wait_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 queue_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 visibility_timeout: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering ServiceQueue resources.
        :param pulumi.Input[_builtins.int] create_time: (Available since v1.223.2) The time when the queue was created.
        :param pulumi.Input[_builtins.int] delay_seconds: The period after which all messages sent to the queue are consumed. Default value: `0`. Valid values: `0` to `604800`. Unit: seconds.
        :param pulumi.Input['ServiceQueueDlqPolicyArgs'] dlq_policy: The dead-letter queue policy. See `dlq_policy` below.
        :param pulumi.Input[_builtins.bool] logging_enabled: Specifies whether to enable the logging feature. Default value: `false`. Valid values:
        :param pulumi.Input[_builtins.int] maximum_message_size: The maximum length of the message that is sent to the queue. Valid values: `1024` to `65536`. Unit: bytes. Default value: `65536`.
        :param pulumi.Input[_builtins.int] message_retention_period: The maximum duration for which a message is retained in the queue. After the specified retention period ends, the message is deleted regardless of whether the message is received. Valid values: `60` to `604800`. Unit: seconds. Default value: `345600`.
        :param pulumi.Input[_builtins.int] polling_wait_seconds: The maximum duration for which long polling requests are held after the ReceiveMessage operation is called. Valid values: `0` to `30`. Unit: seconds. Default value: `0`.
        :param pulumi.Input[_builtins.str] queue_name: The name of the queue.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.int] visibility_timeout: The duration for which a message stays in the Inactive state after the message is received from the queue. Valid values: `1` to `43200`. Unit: seconds. Default value: `30`.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if delay_seconds is not None:
            pulumi.set(__self__, "delay_seconds", delay_seconds)
        if dlq_policy is not None:
            pulumi.set(__self__, "dlq_policy", dlq_policy)
        if logging_enabled is not None:
            pulumi.set(__self__, "logging_enabled", logging_enabled)
        if maximum_message_size is not None:
            pulumi.set(__self__, "maximum_message_size", maximum_message_size)
        if message_retention_period is not None:
            pulumi.set(__self__, "message_retention_period", message_retention_period)
        if polling_wait_seconds is not None:
            pulumi.set(__self__, "polling_wait_seconds", polling_wait_seconds)
        if queue_name is not None:
            pulumi.set(__self__, "queue_name", queue_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if visibility_timeout is not None:
            pulumi.set(__self__, "visibility_timeout", visibility_timeout)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Available since v1.223.2) The time when the queue was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="delaySeconds")
    def delay_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The period after which all messages sent to the queue are consumed. Default value: `0`. Valid values: `0` to `604800`. Unit: seconds.
        """
        return pulumi.get(self, "delay_seconds")

    @delay_seconds.setter
    def delay_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "delay_seconds", value)

    @_builtins.property
    @pulumi.getter(name="dlqPolicy")
    def dlq_policy(self) -> Optional[pulumi.Input['ServiceQueueDlqPolicyArgs']]:
        """
        The dead-letter queue policy. See `dlq_policy` below.
        """
        return pulumi.get(self, "dlq_policy")

    @dlq_policy.setter
    def dlq_policy(self, value: Optional[pulumi.Input['ServiceQueueDlqPolicyArgs']]):
        pulumi.set(self, "dlq_policy", value)

    @_builtins.property
    @pulumi.getter(name="loggingEnabled")
    def logging_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable the logging feature. Default value: `false`. Valid values:
        """
        return pulumi.get(self, "logging_enabled")

    @logging_enabled.setter
    def logging_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "logging_enabled", value)

    @_builtins.property
    @pulumi.getter(name="maximumMessageSize")
    def maximum_message_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum length of the message that is sent to the queue. Valid values: `1024` to `65536`. Unit: bytes. Default value: `65536`.
        """
        return pulumi.get(self, "maximum_message_size")

    @maximum_message_size.setter
    def maximum_message_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "maximum_message_size", value)

    @_builtins.property
    @pulumi.getter(name="messageRetentionPeriod")
    def message_retention_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum duration for which a message is retained in the queue. After the specified retention period ends, the message is deleted regardless of whether the message is received. Valid values: `60` to `604800`. Unit: seconds. Default value: `345600`.
        """
        return pulumi.get(self, "message_retention_period")

    @message_retention_period.setter
    def message_retention_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "message_retention_period", value)

    @_builtins.property
    @pulumi.getter(name="pollingWaitSeconds")
    def polling_wait_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum duration for which long polling requests are held after the ReceiveMessage operation is called. Valid values: `0` to `30`. Unit: seconds. Default value: `0`.
        """
        return pulumi.get(self, "polling_wait_seconds")

    @polling_wait_seconds.setter
    def polling_wait_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "polling_wait_seconds", value)

    @_builtins.property
    @pulumi.getter(name="queueName")
    def queue_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the queue.
        """
        return pulumi.get(self, "queue_name")

    @queue_name.setter
    def queue_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "queue_name", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="visibilityTimeout")
    def visibility_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The duration for which a message stays in the Inactive state after the message is received from the queue. Valid values: `1` to `43200`. Unit: seconds. Default value: `30`.
        """
        return pulumi.get(self, "visibility_timeout")

    @visibility_timeout.setter
    def visibility_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "visibility_timeout", value)


@pulumi.type_token("alicloud:message/serviceQueue:ServiceQueue")
class ServiceQueue(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 delay_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 dlq_policy: Optional[pulumi.Input[Union['ServiceQueueDlqPolicyArgs', 'ServiceQueueDlqPolicyArgsDict']]] = None,
                 logging_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 maximum_message_size: Optional[pulumi.Input[_builtins.int]] = None,
                 message_retention_period: Optional[pulumi.Input[_builtins.int]] = None,
                 polling_wait_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 queue_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 visibility_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Provides a Message Service Queue resource.

        For information about Message Service Queue and how to use it, see [What is Queue](https://www.alibabacloud.com/help/en/message-service/latest/createqueue).

        > **NOTE:** Available since v1.188.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.message.ServiceQueue("default",
            queue_name=name,
            delay_seconds=2,
            polling_wait_seconds=2,
            message_retention_period=566,
            maximum_message_size=1126,
            visibility_timeout=30)
        ```

        ## Import

        Message Service Queue can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:message/serviceQueue:ServiceQueue example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] delay_seconds: The period after which all messages sent to the queue are consumed. Default value: `0`. Valid values: `0` to `604800`. Unit: seconds.
        :param pulumi.Input[Union['ServiceQueueDlqPolicyArgs', 'ServiceQueueDlqPolicyArgsDict']] dlq_policy: The dead-letter queue policy. See `dlq_policy` below.
        :param pulumi.Input[_builtins.bool] logging_enabled: Specifies whether to enable the logging feature. Default value: `false`. Valid values:
        :param pulumi.Input[_builtins.int] maximum_message_size: The maximum length of the message that is sent to the queue. Valid values: `1024` to `65536`. Unit: bytes. Default value: `65536`.
        :param pulumi.Input[_builtins.int] message_retention_period: The maximum duration for which a message is retained in the queue. After the specified retention period ends, the message is deleted regardless of whether the message is received. Valid values: `60` to `604800`. Unit: seconds. Default value: `345600`.
        :param pulumi.Input[_builtins.int] polling_wait_seconds: The maximum duration for which long polling requests are held after the ReceiveMessage operation is called. Valid values: `0` to `30`. Unit: seconds. Default value: `0`.
        :param pulumi.Input[_builtins.str] queue_name: The name of the queue.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.int] visibility_timeout: The duration for which a message stays in the Inactive state after the message is received from the queue. Valid values: `1` to `43200`. Unit: seconds. Default value: `30`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServiceQueueArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Message Service Queue resource.

        For information about Message Service Queue and how to use it, see [What is Queue](https://www.alibabacloud.com/help/en/message-service/latest/createqueue).

        > **NOTE:** Available since v1.188.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.message.ServiceQueue("default",
            queue_name=name,
            delay_seconds=2,
            polling_wait_seconds=2,
            message_retention_period=566,
            maximum_message_size=1126,
            visibility_timeout=30)
        ```

        ## Import

        Message Service Queue can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:message/serviceQueue:ServiceQueue example <id>
        ```

        :param str resource_name: The name of the resource.
        :param ServiceQueueArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServiceQueueArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 delay_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 dlq_policy: Optional[pulumi.Input[Union['ServiceQueueDlqPolicyArgs', 'ServiceQueueDlqPolicyArgsDict']]] = None,
                 logging_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 maximum_message_size: Optional[pulumi.Input[_builtins.int]] = None,
                 message_retention_period: Optional[pulumi.Input[_builtins.int]] = None,
                 polling_wait_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 queue_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 visibility_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServiceQueueArgs.__new__(ServiceQueueArgs)

            __props__.__dict__["delay_seconds"] = delay_seconds
            __props__.__dict__["dlq_policy"] = dlq_policy
            __props__.__dict__["logging_enabled"] = logging_enabled
            __props__.__dict__["maximum_message_size"] = maximum_message_size
            __props__.__dict__["message_retention_period"] = message_retention_period
            __props__.__dict__["polling_wait_seconds"] = polling_wait_seconds
            if queue_name is None and not opts.urn:
                raise TypeError("Missing required property 'queue_name'")
            __props__.__dict__["queue_name"] = queue_name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["visibility_timeout"] = visibility_timeout
            __props__.__dict__["create_time"] = None
        super(ServiceQueue, __self__).__init__(
            'alicloud:message/serviceQueue:ServiceQueue',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[_builtins.int]] = None,
            delay_seconds: Optional[pulumi.Input[_builtins.int]] = None,
            dlq_policy: Optional[pulumi.Input[Union['ServiceQueueDlqPolicyArgs', 'ServiceQueueDlqPolicyArgsDict']]] = None,
            logging_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            maximum_message_size: Optional[pulumi.Input[_builtins.int]] = None,
            message_retention_period: Optional[pulumi.Input[_builtins.int]] = None,
            polling_wait_seconds: Optional[pulumi.Input[_builtins.int]] = None,
            queue_name: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            visibility_timeout: Optional[pulumi.Input[_builtins.int]] = None) -> 'ServiceQueue':
        """
        Get an existing ServiceQueue resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] create_time: (Available since v1.223.2) The time when the queue was created.
        :param pulumi.Input[_builtins.int] delay_seconds: The period after which all messages sent to the queue are consumed. Default value: `0`. Valid values: `0` to `604800`. Unit: seconds.
        :param pulumi.Input[Union['ServiceQueueDlqPolicyArgs', 'ServiceQueueDlqPolicyArgsDict']] dlq_policy: The dead-letter queue policy. See `dlq_policy` below.
        :param pulumi.Input[_builtins.bool] logging_enabled: Specifies whether to enable the logging feature. Default value: `false`. Valid values:
        :param pulumi.Input[_builtins.int] maximum_message_size: The maximum length of the message that is sent to the queue. Valid values: `1024` to `65536`. Unit: bytes. Default value: `65536`.
        :param pulumi.Input[_builtins.int] message_retention_period: The maximum duration for which a message is retained in the queue. After the specified retention period ends, the message is deleted regardless of whether the message is received. Valid values: `60` to `604800`. Unit: seconds. Default value: `345600`.
        :param pulumi.Input[_builtins.int] polling_wait_seconds: The maximum duration for which long polling requests are held after the ReceiveMessage operation is called. Valid values: `0` to `30`. Unit: seconds. Default value: `0`.
        :param pulumi.Input[_builtins.str] queue_name: The name of the queue.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.int] visibility_timeout: The duration for which a message stays in the Inactive state after the message is received from the queue. Valid values: `1` to `43200`. Unit: seconds. Default value: `30`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServiceQueueState.__new__(_ServiceQueueState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["delay_seconds"] = delay_seconds
        __props__.__dict__["dlq_policy"] = dlq_policy
        __props__.__dict__["logging_enabled"] = logging_enabled
        __props__.__dict__["maximum_message_size"] = maximum_message_size
        __props__.__dict__["message_retention_period"] = message_retention_period
        __props__.__dict__["polling_wait_seconds"] = polling_wait_seconds
        __props__.__dict__["queue_name"] = queue_name
        __props__.__dict__["tags"] = tags
        __props__.__dict__["visibility_timeout"] = visibility_timeout
        return ServiceQueue(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.int]:
        """
        (Available since v1.223.2) The time when the queue was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="delaySeconds")
    def delay_seconds(self) -> pulumi.Output[_builtins.int]:
        """
        The period after which all messages sent to the queue are consumed. Default value: `0`. Valid values: `0` to `604800`. Unit: seconds.
        """
        return pulumi.get(self, "delay_seconds")

    @_builtins.property
    @pulumi.getter(name="dlqPolicy")
    def dlq_policy(self) -> pulumi.Output['outputs.ServiceQueueDlqPolicy']:
        """
        The dead-letter queue policy. See `dlq_policy` below.
        """
        return pulumi.get(self, "dlq_policy")

    @_builtins.property
    @pulumi.getter(name="loggingEnabled")
    def logging_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to enable the logging feature. Default value: `false`. Valid values:
        """
        return pulumi.get(self, "logging_enabled")

    @_builtins.property
    @pulumi.getter(name="maximumMessageSize")
    def maximum_message_size(self) -> pulumi.Output[_builtins.int]:
        """
        The maximum length of the message that is sent to the queue. Valid values: `1024` to `65536`. Unit: bytes. Default value: `65536`.
        """
        return pulumi.get(self, "maximum_message_size")

    @_builtins.property
    @pulumi.getter(name="messageRetentionPeriod")
    def message_retention_period(self) -> pulumi.Output[_builtins.int]:
        """
        The maximum duration for which a message is retained in the queue. After the specified retention period ends, the message is deleted regardless of whether the message is received. Valid values: `60` to `604800`. Unit: seconds. Default value: `345600`.
        """
        return pulumi.get(self, "message_retention_period")

    @_builtins.property
    @pulumi.getter(name="pollingWaitSeconds")
    def polling_wait_seconds(self) -> pulumi.Output[_builtins.int]:
        """
        The maximum duration for which long polling requests are held after the ReceiveMessage operation is called. Valid values: `0` to `30`. Unit: seconds. Default value: `0`.
        """
        return pulumi.get(self, "polling_wait_seconds")

    @_builtins.property
    @pulumi.getter(name="queueName")
    def queue_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the queue.
        """
        return pulumi.get(self, "queue_name")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="visibilityTimeout")
    def visibility_timeout(self) -> pulumi.Output[_builtins.int]:
        """
        The duration for which a message stays in the Inactive state after the message is received from the queue. Valid values: `1` to `43200`. Unit: seconds. Default value: `30`.
        """
        return pulumi.get(self, "visibility_timeout")

