# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ReplicaSetRoleArgs', 'ReplicaSetRole']

@pulumi.input_type
class ReplicaSetRoleArgs:
    def __init__(__self__, *,
                 db_instance_id: pulumi.Input[_builtins.str],
                 network_type: pulumi.Input[_builtins.str],
                 role_id: pulumi.Input[_builtins.str],
                 connection_port: Optional[pulumi.Input[_builtins.int]] = None,
                 connection_prefix: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ReplicaSetRole resource.
        :param pulumi.Input[_builtins.str] db_instance_id: The instance ID.
        :param pulumi.Input[_builtins.str] network_type: The network type of the connection string. Valid values:
               - `VPC`: private network address.
               - `Public`: public network address.
        :param pulumi.Input[_builtins.str] role_id: The role ID in the replica set.
        :param pulumi.Input[_builtins.int] connection_port: The port of the connection string, will be computed if not specified.`
        :param pulumi.Input[_builtins.str] connection_prefix: The prefix of the connection string, will be computed if not specified.
        """
        pulumi.set(__self__, "db_instance_id", db_instance_id)
        pulumi.set(__self__, "network_type", network_type)
        pulumi.set(__self__, "role_id", role_id)
        if connection_port is not None:
            pulumi.set(__self__, "connection_port", connection_port)
        if connection_prefix is not None:
            pulumi.set(__self__, "connection_prefix", connection_prefix)

    @_builtins.property
    @pulumi.getter(name="dbInstanceId")
    def db_instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        The instance ID.
        """
        return pulumi.get(self, "db_instance_id")

    @db_instance_id.setter
    def db_instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "db_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="networkType")
    def network_type(self) -> pulumi.Input[_builtins.str]:
        """
        The network type of the connection string. Valid values:
        - `VPC`: private network address.
        - `Public`: public network address.
        """
        return pulumi.get(self, "network_type")

    @network_type.setter
    def network_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "network_type", value)

    @_builtins.property
    @pulumi.getter(name="roleId")
    def role_id(self) -> pulumi.Input[_builtins.str]:
        """
        The role ID in the replica set.
        """
        return pulumi.get(self, "role_id")

    @role_id.setter
    def role_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "role_id", value)

    @_builtins.property
    @pulumi.getter(name="connectionPort")
    def connection_port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The port of the connection string, will be computed if not specified.`
        """
        return pulumi.get(self, "connection_port")

    @connection_port.setter
    def connection_port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "connection_port", value)

    @_builtins.property
    @pulumi.getter(name="connectionPrefix")
    def connection_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The prefix of the connection string, will be computed if not specified.
        """
        return pulumi.get(self, "connection_prefix")

    @connection_prefix.setter
    def connection_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connection_prefix", value)


@pulumi.input_type
class _ReplicaSetRoleState:
    def __init__(__self__, *,
                 connection_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_port: Optional[pulumi.Input[_builtins.int]] = None,
                 connection_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 db_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 network_type: Optional[pulumi.Input[_builtins.str]] = None,
                 replica_set_role: Optional[pulumi.Input[_builtins.str]] = None,
                 role_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ReplicaSetRole resources.
        :param pulumi.Input[_builtins.str] connection_domain: The connection address of the role.
        :param pulumi.Input[_builtins.int] connection_port: The port of the connection string, will be computed if not specified.`
        :param pulumi.Input[_builtins.str] connection_prefix: The prefix of the connection string, will be computed if not specified.
        :param pulumi.Input[_builtins.str] db_instance_id: The instance ID.
        :param pulumi.Input[_builtins.str] network_type: The network type of the connection string. Valid values:
               - `VPC`: private network address.
               - `Public`: public network address.
        :param pulumi.Input[_builtins.str] replica_set_role: The role of the related connection string.
        :param pulumi.Input[_builtins.str] role_id: The role ID in the replica set.
        """
        if connection_domain is not None:
            pulumi.set(__self__, "connection_domain", connection_domain)
        if connection_port is not None:
            pulumi.set(__self__, "connection_port", connection_port)
        if connection_prefix is not None:
            pulumi.set(__self__, "connection_prefix", connection_prefix)
        if db_instance_id is not None:
            pulumi.set(__self__, "db_instance_id", db_instance_id)
        if network_type is not None:
            pulumi.set(__self__, "network_type", network_type)
        if replica_set_role is not None:
            pulumi.set(__self__, "replica_set_role", replica_set_role)
        if role_id is not None:
            pulumi.set(__self__, "role_id", role_id)

    @_builtins.property
    @pulumi.getter(name="connectionDomain")
    def connection_domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The connection address of the role.
        """
        return pulumi.get(self, "connection_domain")

    @connection_domain.setter
    def connection_domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connection_domain", value)

    @_builtins.property
    @pulumi.getter(name="connectionPort")
    def connection_port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The port of the connection string, will be computed if not specified.`
        """
        return pulumi.get(self, "connection_port")

    @connection_port.setter
    def connection_port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "connection_port", value)

    @_builtins.property
    @pulumi.getter(name="connectionPrefix")
    def connection_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The prefix of the connection string, will be computed if not specified.
        """
        return pulumi.get(self, "connection_prefix")

    @connection_prefix.setter
    def connection_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connection_prefix", value)

    @_builtins.property
    @pulumi.getter(name="dbInstanceId")
    def db_instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The instance ID.
        """
        return pulumi.get(self, "db_instance_id")

    @db_instance_id.setter
    def db_instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="networkType")
    def network_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The network type of the connection string. Valid values:
        - `VPC`: private network address.
        - `Public`: public network address.
        """
        return pulumi.get(self, "network_type")

    @network_type.setter
    def network_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_type", value)

    @_builtins.property
    @pulumi.getter(name="replicaSetRole")
    def replica_set_role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The role of the related connection string.
        """
        return pulumi.get(self, "replica_set_role")

    @replica_set_role.setter
    def replica_set_role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "replica_set_role", value)

    @_builtins.property
    @pulumi.getter(name="roleId")
    def role_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The role ID in the replica set.
        """
        return pulumi.get(self, "role_id")

    @role_id.setter
    def role_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role_id", value)


@pulumi.type_token("alicloud:mongodb/replicaSetRole:ReplicaSetRole")
class ReplicaSetRole(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 connection_port: Optional[pulumi.Input[_builtins.int]] = None,
                 connection_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 db_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 network_type: Optional[pulumi.Input[_builtins.str]] = None,
                 role_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides an Alicloud MongoDB replica set role resource to modify the connection string of the replica set.

        For information about how to modify connection string of MongoDB, see [Modify Connection String](https://alibabacloud.com/help/en/mongodb/user-guide/change-the-endpoint-and-port-of-an-instance).

        > **NOTE:** Available since v1.248.0.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default = alicloud.mongodb.get_zones()
        index = len(default.zones).apply(lambda length: length - 1)
        zone_id = default.zones[index].id
        default_network = alicloud.vpc.Network("default",
            cidr_block="10.0.0.0/8",
            vpc_name=name)
        default_switch = alicloud.vpc.Switch("default",
            vpc_id=default_network.id,
            zone_id=zone_id,
            cidr_block="10.0.0.0/24")
        default_instance = alicloud.mongodb.Instance("default",
            engine_version="4.4",
            storage_type="cloud_essd1",
            vswitch_id=default_switch.id,
            db_instance_storage=20,
            vpc_id=default_network.id,
            db_instance_class="mdb.shard.4x.large.d",
            storage_engine="WiredTiger",
            network_type="VPC",
            zone_id=zone_id)
        default_public_network_address = alicloud.mongodb.PublicNetworkAddress("default", db_instance_id=default_instance.id)
        # modify private network address.
        private = alicloud.mongodb.ReplicaSetRole("private",
            db_instance_id=default_instance.id,
            role_id=default_instance.replica_sets[0].role_id,
            connection_prefix="test-tf-private-change",
            connection_port=3718,
            network_type="VPC")
        # modify public network address.
        public = alicloud.mongodb.ReplicaSetRole("public",
            db_instance_id=default_instance.id,
            role_id=default_public_network_address.replica_sets[0].role_id,
            connection_prefix="test-tf-public-0",
            connection_port=3719,
            network_type="Public")
        ```

        ## Import

        MongoDB replica set role can be imported using the id, e.g. Composed of instance ID, network type and role ID with format `<db_instance_id>:<network_type>:<role_id>`.

        ```sh
        $ pulumi import alicloud:mongodb/replicaSetRole:ReplicaSetRole example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] connection_port: The port of the connection string, will be computed if not specified.`
        :param pulumi.Input[_builtins.str] connection_prefix: The prefix of the connection string, will be computed if not specified.
        :param pulumi.Input[_builtins.str] db_instance_id: The instance ID.
        :param pulumi.Input[_builtins.str] network_type: The network type of the connection string. Valid values:
               - `VPC`: private network address.
               - `Public`: public network address.
        :param pulumi.Input[_builtins.str] role_id: The role ID in the replica set.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ReplicaSetRoleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an Alicloud MongoDB replica set role resource to modify the connection string of the replica set.

        For information about how to modify connection string of MongoDB, see [Modify Connection String](https://alibabacloud.com/help/en/mongodb/user-guide/change-the-endpoint-and-port-of-an-instance).

        > **NOTE:** Available since v1.248.0.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default = alicloud.mongodb.get_zones()
        index = len(default.zones).apply(lambda length: length - 1)
        zone_id = default.zones[index].id
        default_network = alicloud.vpc.Network("default",
            cidr_block="10.0.0.0/8",
            vpc_name=name)
        default_switch = alicloud.vpc.Switch("default",
            vpc_id=default_network.id,
            zone_id=zone_id,
            cidr_block="10.0.0.0/24")
        default_instance = alicloud.mongodb.Instance("default",
            engine_version="4.4",
            storage_type="cloud_essd1",
            vswitch_id=default_switch.id,
            db_instance_storage=20,
            vpc_id=default_network.id,
            db_instance_class="mdb.shard.4x.large.d",
            storage_engine="WiredTiger",
            network_type="VPC",
            zone_id=zone_id)
        default_public_network_address = alicloud.mongodb.PublicNetworkAddress("default", db_instance_id=default_instance.id)
        # modify private network address.
        private = alicloud.mongodb.ReplicaSetRole("private",
            db_instance_id=default_instance.id,
            role_id=default_instance.replica_sets[0].role_id,
            connection_prefix="test-tf-private-change",
            connection_port=3718,
            network_type="VPC")
        # modify public network address.
        public = alicloud.mongodb.ReplicaSetRole("public",
            db_instance_id=default_instance.id,
            role_id=default_public_network_address.replica_sets[0].role_id,
            connection_prefix="test-tf-public-0",
            connection_port=3719,
            network_type="Public")
        ```

        ## Import

        MongoDB replica set role can be imported using the id, e.g. Composed of instance ID, network type and role ID with format `<db_instance_id>:<network_type>:<role_id>`.

        ```sh
        $ pulumi import alicloud:mongodb/replicaSetRole:ReplicaSetRole example <id>
        ```

        :param str resource_name: The name of the resource.
        :param ReplicaSetRoleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ReplicaSetRoleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 connection_port: Optional[pulumi.Input[_builtins.int]] = None,
                 connection_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 db_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 network_type: Optional[pulumi.Input[_builtins.str]] = None,
                 role_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ReplicaSetRoleArgs.__new__(ReplicaSetRoleArgs)

            __props__.__dict__["connection_port"] = connection_port
            __props__.__dict__["connection_prefix"] = connection_prefix
            if db_instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'db_instance_id'")
            __props__.__dict__["db_instance_id"] = db_instance_id
            if network_type is None and not opts.urn:
                raise TypeError("Missing required property 'network_type'")
            __props__.__dict__["network_type"] = network_type
            if role_id is None and not opts.urn:
                raise TypeError("Missing required property 'role_id'")
            __props__.__dict__["role_id"] = role_id
            __props__.__dict__["connection_domain"] = None
            __props__.__dict__["replica_set_role"] = None
        super(ReplicaSetRole, __self__).__init__(
            'alicloud:mongodb/replicaSetRole:ReplicaSetRole',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            connection_domain: Optional[pulumi.Input[_builtins.str]] = None,
            connection_port: Optional[pulumi.Input[_builtins.int]] = None,
            connection_prefix: Optional[pulumi.Input[_builtins.str]] = None,
            db_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            network_type: Optional[pulumi.Input[_builtins.str]] = None,
            replica_set_role: Optional[pulumi.Input[_builtins.str]] = None,
            role_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'ReplicaSetRole':
        """
        Get an existing ReplicaSetRole resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] connection_domain: The connection address of the role.
        :param pulumi.Input[_builtins.int] connection_port: The port of the connection string, will be computed if not specified.`
        :param pulumi.Input[_builtins.str] connection_prefix: The prefix of the connection string, will be computed if not specified.
        :param pulumi.Input[_builtins.str] db_instance_id: The instance ID.
        :param pulumi.Input[_builtins.str] network_type: The network type of the connection string. Valid values:
               - `VPC`: private network address.
               - `Public`: public network address.
        :param pulumi.Input[_builtins.str] replica_set_role: The role of the related connection string.
        :param pulumi.Input[_builtins.str] role_id: The role ID in the replica set.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ReplicaSetRoleState.__new__(_ReplicaSetRoleState)

        __props__.__dict__["connection_domain"] = connection_domain
        __props__.__dict__["connection_port"] = connection_port
        __props__.__dict__["connection_prefix"] = connection_prefix
        __props__.__dict__["db_instance_id"] = db_instance_id
        __props__.__dict__["network_type"] = network_type
        __props__.__dict__["replica_set_role"] = replica_set_role
        __props__.__dict__["role_id"] = role_id
        return ReplicaSetRole(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="connectionDomain")
    def connection_domain(self) -> pulumi.Output[_builtins.str]:
        """
        The connection address of the role.
        """
        return pulumi.get(self, "connection_domain")

    @_builtins.property
    @pulumi.getter(name="connectionPort")
    def connection_port(self) -> pulumi.Output[_builtins.int]:
        """
        The port of the connection string, will be computed if not specified.`
        """
        return pulumi.get(self, "connection_port")

    @_builtins.property
    @pulumi.getter(name="connectionPrefix")
    def connection_prefix(self) -> pulumi.Output[_builtins.str]:
        """
        The prefix of the connection string, will be computed if not specified.
        """
        return pulumi.get(self, "connection_prefix")

    @_builtins.property
    @pulumi.getter(name="dbInstanceId")
    def db_instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        The instance ID.
        """
        return pulumi.get(self, "db_instance_id")

    @_builtins.property
    @pulumi.getter(name="networkType")
    def network_type(self) -> pulumi.Output[_builtins.str]:
        """
        The network type of the connection string. Valid values:
        - `VPC`: private network address.
        - `Public`: public network address.
        """
        return pulumi.get(self, "network_type")

    @_builtins.property
    @pulumi.getter(name="replicaSetRole")
    def replica_set_role(self) -> pulumi.Output[_builtins.str]:
        """
        The role of the related connection string.
        """
        return pulumi.get(self, "replica_set_role")

    @_builtins.property
    @pulumi.getter(name="roleId")
    def role_id(self) -> pulumi.Output[_builtins.str]:
        """
        The role ID in the replica set.
        """
        return pulumi.get(self, "role_id")

