# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetEngineNamespacesResult',
    'AwaitableGetEngineNamespacesResult',
    'get_engine_namespaces',
    'get_engine_namespaces_output',
]

@pulumi.output_type
class GetEngineNamespacesResult:
    """
    A collection of values returned by getEngineNamespaces.
    """
    def __init__(__self__, accept_language=None, cluster_id=None, id=None, ids=None, instance_id=None, namespaces=None, output_file=None):
        if accept_language and not isinstance(accept_language, str):
            raise TypeError("Expected argument 'accept_language' to be a str")
        pulumi.set(__self__, "accept_language", accept_language)
        if cluster_id and not isinstance(cluster_id, str):
            raise TypeError("Expected argument 'cluster_id' to be a str")
        pulumi.set(__self__, "cluster_id", cluster_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if instance_id and not isinstance(instance_id, str):
            raise TypeError("Expected argument 'instance_id' to be a str")
        pulumi.set(__self__, "instance_id", instance_id)
        if namespaces and not isinstance(namespaces, list):
            raise TypeError("Expected argument 'namespaces' to be a list")
        pulumi.set(__self__, "namespaces", namespaces)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)

    @_builtins.property
    @pulumi.getter(name="acceptLanguage")
    def accept_language(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "accept_language")

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def namespaces(self) -> Sequence['outputs.GetEngineNamespacesNamespaceResult']:
        """
        A list of Mse Engine Namespaces. Each element contains the following attributes:
        """
        return pulumi.get(self, "namespaces")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")


class AwaitableGetEngineNamespacesResult(GetEngineNamespacesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEngineNamespacesResult(
            accept_language=self.accept_language,
            cluster_id=self.cluster_id,
            id=self.id,
            ids=self.ids,
            instance_id=self.instance_id,
            namespaces=self.namespaces,
            output_file=self.output_file)


def get_engine_namespaces(accept_language: Optional[_builtins.str] = None,
                          cluster_id: Optional[_builtins.str] = None,
                          ids: Optional[Sequence[_builtins.str]] = None,
                          instance_id: Optional[_builtins.str] = None,
                          output_file: Optional[_builtins.str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEngineNamespacesResult:
    """
    This data source provides the Mse Engine Namespaces of the current Alibaba Cloud user.

    > **NOTE:** Available since v1.166.0.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    example = alicloud.get_zones(available_resource_creation="VSwitch")
    example_network = alicloud.vpc.Network("example",
        vpc_name="terraform-example",
        cidr_block="172.17.3.0/24")
    example_switch = alicloud.vpc.Switch("example",
        vswitch_name="terraform-example",
        cidr_block="172.17.3.0/24",
        vpc_id=example_network.id,
        zone_id=example.zones[0].id)
    example_cluster = alicloud.mse.Cluster("example",
        cluster_specification="MSE_SC_1_2_60_c",
        cluster_type="Nacos-Ans",
        cluster_version="NACOS_2_0_0",
        instance_count=3,
        net_type="privatenet",
        pub_network_flow="1",
        connection_type="slb",
        cluster_alias_name="terraform-example",
        mse_version="mse_pro",
        vswitch_id=example_switch.id,
        vpc_id=example_network.id)
    example_engine_namespace = alicloud.mse.EngineNamespace("example",
        instance_id=example_cluster.id,
        namespace_show_name="terraform-example",
        namespace_id="terraform-example",
        namespace_desc="description")
    # Declare the data source
    example_get_engine_namespaces = alicloud.mse.get_engine_namespaces_output(instance_id=example_engine_namespace.instance_id)
    pulumi.export("mseEngineNamespaceIdPublic", example_get_engine_namespaces.namespaces[0].id)
    pulumi.export("mseEngineNamespaceIdExample", example_get_engine_namespaces.namespaces[1].id)
    ```


    :param _builtins.str accept_language: The language type of the returned information. Valid values: `zh`, `en`.
    :param _builtins.str cluster_id: The ID of the cluster.
    :param Sequence[_builtins.str] ids: A list of Engine Namespace IDs. It is formatted to `<instance_id>:<namespace_id>`.
    :param _builtins.str instance_id: The ID of the MSE Cluster Instance.It is formatted to `mse-cn-xxxxxxxxxxx`.Available since v1.232.0
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
           
           **NOTE:** You must set `cluster_id` or `instance_id` or both.
    """
    __args__ = dict()
    __args__['acceptLanguage'] = accept_language
    __args__['clusterId'] = cluster_id
    __args__['ids'] = ids
    __args__['instanceId'] = instance_id
    __args__['outputFile'] = output_file
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:mse/getEngineNamespaces:getEngineNamespaces', __args__, opts=opts, typ=GetEngineNamespacesResult).value

    return AwaitableGetEngineNamespacesResult(
        accept_language=pulumi.get(__ret__, 'accept_language'),
        cluster_id=pulumi.get(__ret__, 'cluster_id'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        instance_id=pulumi.get(__ret__, 'instance_id'),
        namespaces=pulumi.get(__ret__, 'namespaces'),
        output_file=pulumi.get(__ret__, 'output_file'))
def get_engine_namespaces_output(accept_language: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 cluster_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                 instance_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetEngineNamespacesResult]:
    """
    This data source provides the Mse Engine Namespaces of the current Alibaba Cloud user.

    > **NOTE:** Available since v1.166.0.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    example = alicloud.get_zones(available_resource_creation="VSwitch")
    example_network = alicloud.vpc.Network("example",
        vpc_name="terraform-example",
        cidr_block="172.17.3.0/24")
    example_switch = alicloud.vpc.Switch("example",
        vswitch_name="terraform-example",
        cidr_block="172.17.3.0/24",
        vpc_id=example_network.id,
        zone_id=example.zones[0].id)
    example_cluster = alicloud.mse.Cluster("example",
        cluster_specification="MSE_SC_1_2_60_c",
        cluster_type="Nacos-Ans",
        cluster_version="NACOS_2_0_0",
        instance_count=3,
        net_type="privatenet",
        pub_network_flow="1",
        connection_type="slb",
        cluster_alias_name="terraform-example",
        mse_version="mse_pro",
        vswitch_id=example_switch.id,
        vpc_id=example_network.id)
    example_engine_namespace = alicloud.mse.EngineNamespace("example",
        instance_id=example_cluster.id,
        namespace_show_name="terraform-example",
        namespace_id="terraform-example",
        namespace_desc="description")
    # Declare the data source
    example_get_engine_namespaces = alicloud.mse.get_engine_namespaces_output(instance_id=example_engine_namespace.instance_id)
    pulumi.export("mseEngineNamespaceIdPublic", example_get_engine_namespaces.namespaces[0].id)
    pulumi.export("mseEngineNamespaceIdExample", example_get_engine_namespaces.namespaces[1].id)
    ```


    :param _builtins.str accept_language: The language type of the returned information. Valid values: `zh`, `en`.
    :param _builtins.str cluster_id: The ID of the cluster.
    :param Sequence[_builtins.str] ids: A list of Engine Namespace IDs. It is formatted to `<instance_id>:<namespace_id>`.
    :param _builtins.str instance_id: The ID of the MSE Cluster Instance.It is formatted to `mse-cn-xxxxxxxxxxx`.Available since v1.232.0
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
           
           **NOTE:** You must set `cluster_id` or `instance_id` or both.
    """
    __args__ = dict()
    __args__['acceptLanguage'] = accept_language
    __args__['clusterId'] = cluster_id
    __args__['ids'] = ids
    __args__['instanceId'] = instance_id
    __args__['outputFile'] = output_file
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:mse/getEngineNamespaces:getEngineNamespaces', __args__, opts=opts, typ=GetEngineNamespacesResult)
    return __ret__.apply(lambda __response__: GetEngineNamespacesResult(
        accept_language=pulumi.get(__response__, 'accept_language'),
        cluster_id=pulumi.get(__response__, 'cluster_id'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        instance_id=pulumi.get(__response__, 'instance_id'),
        namespaces=pulumi.get(__response__, 'namespaces'),
        output_file=pulumi.get(__response__, 'output_file')))
