# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetNacosConfigsResult',
    'AwaitableGetNacosConfigsResult',
    'get_nacos_configs',
    'get_nacos_configs_output',
]

@pulumi.output_type
class GetNacosConfigsResult:
    """
    A collection of values returned by getNacosConfigs.
    """
    def __init__(__self__, accept_language=None, app_name=None, configs=None, data_id=None, enable_details=None, group=None, id=None, ids=None, instance_id=None, namespace_id=None, output_file=None, request_pars=None, tags=None):
        if accept_language and not isinstance(accept_language, str):
            raise TypeError("Expected argument 'accept_language' to be a str")
        pulumi.set(__self__, "accept_language", accept_language)
        if app_name and not isinstance(app_name, str):
            raise TypeError("Expected argument 'app_name' to be a str")
        pulumi.set(__self__, "app_name", app_name)
        if configs and not isinstance(configs, list):
            raise TypeError("Expected argument 'configs' to be a list")
        pulumi.set(__self__, "configs", configs)
        if data_id and not isinstance(data_id, str):
            raise TypeError("Expected argument 'data_id' to be a str")
        pulumi.set(__self__, "data_id", data_id)
        if enable_details and not isinstance(enable_details, bool):
            raise TypeError("Expected argument 'enable_details' to be a bool")
        pulumi.set(__self__, "enable_details", enable_details)
        if group and not isinstance(group, str):
            raise TypeError("Expected argument 'group' to be a str")
        pulumi.set(__self__, "group", group)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if instance_id and not isinstance(instance_id, str):
            raise TypeError("Expected argument 'instance_id' to be a str")
        pulumi.set(__self__, "instance_id", instance_id)
        if namespace_id and not isinstance(namespace_id, str):
            raise TypeError("Expected argument 'namespace_id' to be a str")
        pulumi.set(__self__, "namespace_id", namespace_id)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if request_pars and not isinstance(request_pars, str):
            raise TypeError("Expected argument 'request_pars' to be a str")
        pulumi.set(__self__, "request_pars", request_pars)
        if tags and not isinstance(tags, str):
            raise TypeError("Expected argument 'tags' to be a str")
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="acceptLanguage")
    def accept_language(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "accept_language")

    @_builtins.property
    @pulumi.getter(name="appName")
    def app_name(self) -> Optional[_builtins.str]:
        """
        The name of the application.
        """
        return pulumi.get(self, "app_name")

    @_builtins.property
    @pulumi.getter
    def configs(self) -> Sequence['outputs.GetNacosConfigsConfigResult']:
        """
        A list of Mse Nacos Configs. Each element contains the following attributes:
        """
        return pulumi.get(self, "configs")

    @_builtins.property
    @pulumi.getter(name="dataId")
    def data_id(self) -> Optional[_builtins.str]:
        """
        The ID of the data.
        """
        return pulumi.get(self, "data_id")

    @_builtins.property
    @pulumi.getter(name="enableDetails")
    def enable_details(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "enable_details")

    @_builtins.property
    @pulumi.getter
    def group(self) -> Optional[_builtins.str]:
        """
        The ID of the group.
        """
        return pulumi.get(self, "group")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="namespaceId")
    def namespace_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "namespace_id")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter(name="requestPars")
    def request_pars(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "request_pars")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[_builtins.str]:
        """
        The tags of the configuration.
        """
        return pulumi.get(self, "tags")


class AwaitableGetNacosConfigsResult(GetNacosConfigsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNacosConfigsResult(
            accept_language=self.accept_language,
            app_name=self.app_name,
            configs=self.configs,
            data_id=self.data_id,
            enable_details=self.enable_details,
            group=self.group,
            id=self.id,
            ids=self.ids,
            instance_id=self.instance_id,
            namespace_id=self.namespace_id,
            output_file=self.output_file,
            request_pars=self.request_pars,
            tags=self.tags)


def get_nacos_configs(accept_language: Optional[_builtins.str] = None,
                      app_name: Optional[_builtins.str] = None,
                      data_id: Optional[_builtins.str] = None,
                      enable_details: Optional[_builtins.bool] = None,
                      group: Optional[_builtins.str] = None,
                      ids: Optional[Sequence[_builtins.str]] = None,
                      instance_id: Optional[_builtins.str] = None,
                      namespace_id: Optional[_builtins.str] = None,
                      output_file: Optional[_builtins.str] = None,
                      request_pars: Optional[_builtins.str] = None,
                      tags: Optional[_builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNacosConfigsResult:
    """
    This data source provides the Mse Nacos Configs of the current Alibaba Cloud user.

    > **NOTE:** Available since v1.233.0.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    example = alicloud.get_zones(available_resource_creation="VSwitch")
    example_network = alicloud.vpc.Network("example",
        vpc_name="terraform-example",
        cidr_block="172.17.3.0/24")
    example_switch = alicloud.vpc.Switch("example",
        vswitch_name="terraform-example",
        cidr_block="172.17.3.0/24",
        vpc_id=example_network.id,
        zone_id=example.zones[0].id)
    example_cluster = alicloud.mse.Cluster("example",
        connection_type="slb",
        net_type="privatenet",
        vswitch_id=example_switch.id,
        cluster_specification="MSE_SC_1_2_60_c",
        cluster_version="NACOS_2_0_0",
        instance_count=3,
        pub_network_flow="1",
        cluster_alias_name="example",
        mse_version="mse_pro",
        cluster_type="Nacos-Ans")
    example_engine_namespace = alicloud.mse.EngineNamespace("example",
        instance_id=example_cluster.id,
        namespace_show_name="example",
        namespace_id="example")
    example_nacos_config = alicloud.mse.NacosConfig("example",
        instance_id=example_cluster.id,
        data_id="example",
        group="example",
        namespace_id=example_engine_namespace.namespace_id,
        content="example",
        type="text",
        tags="example",
        app_name="example",
        desc="example")
    example_get_nacos_configs = pulumi.Output.all(
        id=example_cluster.id,
        namespace_id=example_engine_namespace.namespace_id
    ).apply(lambda resolved_outputs: alicloud.mse.get_nacos_configs_output(instance_id=resolved_outputs['id'],
        enable_details=True,
        namespace_id=resolved_outputs['namespace_id']))
    ```


    :param _builtins.str accept_language: The language type of the returned information. Valid values: `zh`, `en`.
    :param _builtins.str app_name: The name of the application.
    :param _builtins.str data_id: The ID of the data.
    :param _builtins.bool enable_details: Default to `false`. Set it to `true` can output more details about resource attributes.
    :param _builtins.str group: The ID of the group.
    :param Sequence[_builtins.str] ids: A list of MSE Engine Configs ids. It is formatted to `<instance_id>:<namespace_id>:<data_id>:<group>`.
    :param _builtins.str instance_id: The ID of the instance.
    :param _builtins.str namespace_id: The id of Namespace.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
           *
    :param _builtins.str request_pars: The extended request parameters. The JSON format is supported.
    :param _builtins.str tags: The tags of the configuration.
    """
    __args__ = dict()
    __args__['acceptLanguage'] = accept_language
    __args__['appName'] = app_name
    __args__['dataId'] = data_id
    __args__['enableDetails'] = enable_details
    __args__['group'] = group
    __args__['ids'] = ids
    __args__['instanceId'] = instance_id
    __args__['namespaceId'] = namespace_id
    __args__['outputFile'] = output_file
    __args__['requestPars'] = request_pars
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:mse/getNacosConfigs:getNacosConfigs', __args__, opts=opts, typ=GetNacosConfigsResult).value

    return AwaitableGetNacosConfigsResult(
        accept_language=pulumi.get(__ret__, 'accept_language'),
        app_name=pulumi.get(__ret__, 'app_name'),
        configs=pulumi.get(__ret__, 'configs'),
        data_id=pulumi.get(__ret__, 'data_id'),
        enable_details=pulumi.get(__ret__, 'enable_details'),
        group=pulumi.get(__ret__, 'group'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        instance_id=pulumi.get(__ret__, 'instance_id'),
        namespace_id=pulumi.get(__ret__, 'namespace_id'),
        output_file=pulumi.get(__ret__, 'output_file'),
        request_pars=pulumi.get(__ret__, 'request_pars'),
        tags=pulumi.get(__ret__, 'tags'))
def get_nacos_configs_output(accept_language: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             app_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             data_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             enable_details: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                             group: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                             instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                             namespace_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             request_pars: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             tags: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetNacosConfigsResult]:
    """
    This data source provides the Mse Nacos Configs of the current Alibaba Cloud user.

    > **NOTE:** Available since v1.233.0.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    example = alicloud.get_zones(available_resource_creation="VSwitch")
    example_network = alicloud.vpc.Network("example",
        vpc_name="terraform-example",
        cidr_block="172.17.3.0/24")
    example_switch = alicloud.vpc.Switch("example",
        vswitch_name="terraform-example",
        cidr_block="172.17.3.0/24",
        vpc_id=example_network.id,
        zone_id=example.zones[0].id)
    example_cluster = alicloud.mse.Cluster("example",
        connection_type="slb",
        net_type="privatenet",
        vswitch_id=example_switch.id,
        cluster_specification="MSE_SC_1_2_60_c",
        cluster_version="NACOS_2_0_0",
        instance_count=3,
        pub_network_flow="1",
        cluster_alias_name="example",
        mse_version="mse_pro",
        cluster_type="Nacos-Ans")
    example_engine_namespace = alicloud.mse.EngineNamespace("example",
        instance_id=example_cluster.id,
        namespace_show_name="example",
        namespace_id="example")
    example_nacos_config = alicloud.mse.NacosConfig("example",
        instance_id=example_cluster.id,
        data_id="example",
        group="example",
        namespace_id=example_engine_namespace.namespace_id,
        content="example",
        type="text",
        tags="example",
        app_name="example",
        desc="example")
    example_get_nacos_configs = pulumi.Output.all(
        id=example_cluster.id,
        namespace_id=example_engine_namespace.namespace_id
    ).apply(lambda resolved_outputs: alicloud.mse.get_nacos_configs_output(instance_id=resolved_outputs['id'],
        enable_details=True,
        namespace_id=resolved_outputs['namespace_id']))
    ```


    :param _builtins.str accept_language: The language type of the returned information. Valid values: `zh`, `en`.
    :param _builtins.str app_name: The name of the application.
    :param _builtins.str data_id: The ID of the data.
    :param _builtins.bool enable_details: Default to `false`. Set it to `true` can output more details about resource attributes.
    :param _builtins.str group: The ID of the group.
    :param Sequence[_builtins.str] ids: A list of MSE Engine Configs ids. It is formatted to `<instance_id>:<namespace_id>:<data_id>:<group>`.
    :param _builtins.str instance_id: The ID of the instance.
    :param _builtins.str namespace_id: The id of Namespace.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
           *
    :param _builtins.str request_pars: The extended request parameters. The JSON format is supported.
    :param _builtins.str tags: The tags of the configuration.
    """
    __args__ = dict()
    __args__['acceptLanguage'] = accept_language
    __args__['appName'] = app_name
    __args__['dataId'] = data_id
    __args__['enableDetails'] = enable_details
    __args__['group'] = group
    __args__['ids'] = ids
    __args__['instanceId'] = instance_id
    __args__['namespaceId'] = namespace_id
    __args__['outputFile'] = output_file
    __args__['requestPars'] = request_pars
    __args__['tags'] = tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:mse/getNacosConfigs:getNacosConfigs', __args__, opts=opts, typ=GetNacosConfigsResult)
    return __ret__.apply(lambda __response__: GetNacosConfigsResult(
        accept_language=pulumi.get(__response__, 'accept_language'),
        app_name=pulumi.get(__response__, 'app_name'),
        configs=pulumi.get(__response__, 'configs'),
        data_id=pulumi.get(__response__, 'data_id'),
        enable_details=pulumi.get(__response__, 'enable_details'),
        group=pulumi.get(__response__, 'group'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        instance_id=pulumi.get(__response__, 'instance_id'),
        namespace_id=pulumi.get(__response__, 'namespace_id'),
        output_file=pulumi.get(__response__, 'output_file'),
        request_pars=pulumi.get(__response__, 'request_pars'),
        tags=pulumi.get(__response__, 'tags')))
