# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FileSystemArgs', 'FileSystem']

@pulumi.input_type
class FileSystemArgs:
    def __init__(__self__, *,
                 protocol_type: pulumi.Input[_builtins.str],
                 storage_type: pulumi.Input[_builtins.str],
                 capacity: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 encrypt_type: Optional[pulumi.Input[_builtins.int]] = None,
                 file_system_type: Optional[pulumi.Input[_builtins.str]] = None,
                 keytab: Optional[pulumi.Input[_builtins.str]] = None,
                 keytab_md5: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 nfs_acl: Optional[pulumi.Input['FileSystemNfsAclArgs']] = None,
                 options: Optional[pulumi.Input['FileSystemOptionsArgs']] = None,
                 recycle_bin: Optional[pulumi.Input['FileSystemRecycleBinArgs']] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 smb_acl: Optional[pulumi.Input['FileSystemSmbAclArgs']] = None,
                 snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a FileSystem resource.
        :param pulumi.Input[_builtins.str] protocol_type: File transfer protocol type.
               - When FileSystemType = standard, the values are NFS and SMB.
               - When FileSystemType = extreme, the value is NFS.
               - When FileSystemType = cpfs, the value is cpfs.
        :param pulumi.Input[_builtins.str] storage_type: The storage type.
               - When FileSystemType = standard, the values are Performance, Capacity, and Premium.
               - When FileSystemType = extreme, the value is standard or advance.
               - When FileSystemType = cpfs, the values are advance_100(100MB/s/TiB baseline) and advance_200(200MB/s/TiB baseline).
        :param pulumi.Input[_builtins.int] capacity: File system capacity.
               
               Unit: GiB, required and valid when FileSystemType = extreme or cpfs.
               
               For optional values, please refer to the actual specifications on the purchase page:
               -[Fast NAS Pay-As-You-Go Page](https://common-buy.aliyun.com/? commodityCode=nas_extreme_post#/buy)
               -[Fast NAS Package Monthly Purchase Page](https://common-buy.aliyun.com/? commodityCode=nas_extreme#/buy)
               -[Parallel File System CPFS Pay-As-You-Go Purchase Page](https://common-buy.aliyun.com/? commodityCode=nas_cpfs_post#/buy)
               -[Parallel File System CPFS Package Monthly Purchase Page](https://common-buy.aliyun.com/? commodityCode=cpfs#/buy)
        :param pulumi.Input[_builtins.str] description: File system description.
               
               Restrictions:
               - 2~128 English or Chinese characters in length.
               - Must start with upper and lower case letters or Chinese, and cannot start with'http: // 'and'https.
               - Can contain numbers, colons (:), underscores (_), or dashes (-).
        :param pulumi.Input[_builtins.int] encrypt_type: Whether the file system is encrypted.
               
               Use the KMS service hosting key to encrypt and store the file system disk data. When reading and writing encrypted data, there is no need to decrypt it.
               
               Value:
               - 0 (default): not encrypted.
               - 1:NAS managed key. NAS managed keys are supported when FileSystemType = standard or extreme.
               - 2: User management key. You can manage keys only when FileSystemType = extreme.
        :param pulumi.Input[_builtins.str] file_system_type: File system type.
               
               Value:
               - standard (default): Universal NAS
               - extreme: extreme NAS
               - cpfs: file storage CPFS
        :param pulumi.Input[_builtins.str] keytab: String of keytab file content encrypted by base64
        :param pulumi.Input[_builtins.str] keytab_md5: String of the keytab file content encrypted by MD5
        :param pulumi.Input[_builtins.str] kms_key_id: The ID of the KMS key.
               This parameter is required only when EncryptType = 2.
        :param pulumi.Input['FileSystemNfsAclArgs'] nfs_acl: NFS ACL See `nfs_acl` below.
        :param pulumi.Input['FileSystemOptionsArgs'] options: Option. See `options` below.
        :param pulumi.Input['FileSystemRecycleBinArgs'] recycle_bin: Recycle Bin See `recycle_bin` below.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group.
        :param pulumi.Input['FileSystemSmbAclArgs'] smb_acl: SMB ACL See `smb_acl` below.
        :param pulumi.Input[_builtins.str] snapshot_id: Only extreme NAS is supported.
               
               > **NOTE:** A file system is created from a snapshot. The version of the created file system is the same as that of the snapshot source file system. For example, if the source file system version of the snapshot is 1 and you need to create A file system of version 2, you can first create A file system A from the snapshot, then create A file system B that meets the configuration of version 2, copy the data in file system A to file system B, and migrate the business to file system B after the copy is completed.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Label information collection.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the VPC network.
               This parameter must be configured when FileSystemType = cpfs.
               When the FileSystemType is standard or extreme, this parameter is reserved for the interface and has not taken effect yet. You do not need to configure it.
        :param pulumi.Input[_builtins.str] vswitch_id: The ID of the switch.
               This parameter must be configured when FileSystemType = cpfs.
               When the FileSystemType is standard or extreme, this parameter is reserved for the interface and has not taken effect yet. You do not need to configure it.
        :param pulumi.Input[_builtins.str] zone_id: The zone ID.
               
               The usable area refers to the physical area where power and network are independent of each other in the same area.
               
               When the FileSystemType is set to standard, this parameter is optional. By default, a zone that meets the conditions is randomly selected based on the ProtocolType and StorageType configurations. This parameter is required when FileSystemType = extreme or FileSystemType = cpfs.
               
               > **NOTE:** - file systems in different zones in the same region communicate with ECS cloud servers.
               
               > **NOTE:** - We recommend that the file system and the ECS instance belong to the same zone to avoid cross-zone latency.
        """
        pulumi.set(__self__, "protocol_type", protocol_type)
        pulumi.set(__self__, "storage_type", storage_type)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypt_type is not None:
            pulumi.set(__self__, "encrypt_type", encrypt_type)
        if file_system_type is not None:
            pulumi.set(__self__, "file_system_type", file_system_type)
        if keytab is not None:
            pulumi.set(__self__, "keytab", keytab)
        if keytab_md5 is not None:
            pulumi.set(__self__, "keytab_md5", keytab_md5)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if nfs_acl is not None:
            pulumi.set(__self__, "nfs_acl", nfs_acl)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if recycle_bin is not None:
            pulumi.set(__self__, "recycle_bin", recycle_bin)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if smb_acl is not None:
            pulumi.set(__self__, "smb_acl", smb_acl)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="protocolType")
    def protocol_type(self) -> pulumi.Input[_builtins.str]:
        """
        File transfer protocol type.
        - When FileSystemType = standard, the values are NFS and SMB.
        - When FileSystemType = extreme, the value is NFS.
        - When FileSystemType = cpfs, the value is cpfs.
        """
        return pulumi.get(self, "protocol_type")

    @protocol_type.setter
    def protocol_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "protocol_type", value)

    @_builtins.property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> pulumi.Input[_builtins.str]:
        """
        The storage type.
        - When FileSystemType = standard, the values are Performance, Capacity, and Premium.
        - When FileSystemType = extreme, the value is standard or advance.
        - When FileSystemType = cpfs, the values are advance_100(100MB/s/TiB baseline) and advance_200(200MB/s/TiB baseline).
        """
        return pulumi.get(self, "storage_type")

    @storage_type.setter
    def storage_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "storage_type", value)

    @_builtins.property
    @pulumi.getter
    def capacity(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        File system capacity.

        Unit: GiB, required and valid when FileSystemType = extreme or cpfs.

        For optional values, please refer to the actual specifications on the purchase page:
        -[Fast NAS Pay-As-You-Go Page](https://common-buy.aliyun.com/? commodityCode=nas_extreme_post#/buy)
        -[Fast NAS Package Monthly Purchase Page](https://common-buy.aliyun.com/? commodityCode=nas_extreme#/buy)
        -[Parallel File System CPFS Pay-As-You-Go Purchase Page](https://common-buy.aliyun.com/? commodityCode=nas_cpfs_post#/buy)
        -[Parallel File System CPFS Package Monthly Purchase Page](https://common-buy.aliyun.com/? commodityCode=cpfs#/buy)
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "capacity", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        File system description.

        Restrictions:
        - 2~128 English or Chinese characters in length.
        - Must start with upper and lower case letters or Chinese, and cannot start with'http: // 'and'https.
        - Can contain numbers, colons (:), underscores (_), or dashes (-).
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="encryptType")
    def encrypt_type(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Whether the file system is encrypted.

        Use the KMS service hosting key to encrypt and store the file system disk data. When reading and writing encrypted data, there is no need to decrypt it.

        Value:
        - 0 (default): not encrypted.
        - 1:NAS managed key. NAS managed keys are supported when FileSystemType = standard or extreme.
        - 2: User management key. You can manage keys only when FileSystemType = extreme.
        """
        return pulumi.get(self, "encrypt_type")

    @encrypt_type.setter
    def encrypt_type(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "encrypt_type", value)

    @_builtins.property
    @pulumi.getter(name="fileSystemType")
    def file_system_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        File system type.

        Value:
        - standard (default): Universal NAS
        - extreme: extreme NAS
        - cpfs: file storage CPFS
        """
        return pulumi.get(self, "file_system_type")

    @file_system_type.setter
    def file_system_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "file_system_type", value)

    @_builtins.property
    @pulumi.getter
    def keytab(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        String of keytab file content encrypted by base64
        """
        return pulumi.get(self, "keytab")

    @keytab.setter
    def keytab(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "keytab", value)

    @_builtins.property
    @pulumi.getter(name="keytabMd5")
    def keytab_md5(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        String of the keytab file content encrypted by MD5
        """
        return pulumi.get(self, "keytab_md5")

    @keytab_md5.setter
    def keytab_md5(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "keytab_md5", value)

    @_builtins.property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the KMS key.
        This parameter is required only when EncryptType = 2.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_key_id", value)

    @_builtins.property
    @pulumi.getter(name="nfsAcl")
    def nfs_acl(self) -> Optional[pulumi.Input['FileSystemNfsAclArgs']]:
        """
        NFS ACL See `nfs_acl` below.
        """
        return pulumi.get(self, "nfs_acl")

    @nfs_acl.setter
    def nfs_acl(self, value: Optional[pulumi.Input['FileSystemNfsAclArgs']]):
        pulumi.set(self, "nfs_acl", value)

    @_builtins.property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input['FileSystemOptionsArgs']]:
        """
        Option. See `options` below.
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input['FileSystemOptionsArgs']]):
        pulumi.set(self, "options", value)

    @_builtins.property
    @pulumi.getter(name="recycleBin")
    def recycle_bin(self) -> Optional[pulumi.Input['FileSystemRecycleBinArgs']]:
        """
        Recycle Bin See `recycle_bin` below.
        """
        return pulumi.get(self, "recycle_bin")

    @recycle_bin.setter
    def recycle_bin(self, value: Optional[pulumi.Input['FileSystemRecycleBinArgs']]):
        pulumi.set(self, "recycle_bin", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="smbAcl")
    def smb_acl(self) -> Optional[pulumi.Input['FileSystemSmbAclArgs']]:
        """
        SMB ACL See `smb_acl` below.
        """
        return pulumi.get(self, "smb_acl")

    @smb_acl.setter
    def smb_acl(self, value: Optional[pulumi.Input['FileSystemSmbAclArgs']]):
        pulumi.set(self, "smb_acl", value)

    @_builtins.property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Only extreme NAS is supported.

        > **NOTE:** A file system is created from a snapshot. The version of the created file system is the same as that of the snapshot source file system. For example, if the source file system version of the snapshot is 1 and you need to create A file system of version 2, you can first create A file system A from the snapshot, then create A file system B that meets the configuration of version 2, copy the data in file system A to file system B, and migrate the business to file system B after the copy is completed.
        """
        return pulumi.get(self, "snapshot_id")

    @snapshot_id.setter
    def snapshot_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snapshot_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Label information collection.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the VPC network.
        This parameter must be configured when FileSystemType = cpfs.
        When the FileSystemType is standard or extreme, this parameter is reserved for the interface and has not taken effect yet. You do not need to configure it.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the switch.
        This parameter must be configured when FileSystemType = cpfs.
        When the FileSystemType is standard or extreme, this parameter is reserved for the interface and has not taken effect yet. You do not need to configure it.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vswitch_id", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The zone ID.

        The usable area refers to the physical area where power and network are independent of each other in the same area.

        When the FileSystemType is set to standard, this parameter is optional. By default, a zone that meets the conditions is randomly selected based on the ProtocolType and StorageType configurations. This parameter is required when FileSystemType = extreme or FileSystemType = cpfs.

        > **NOTE:** - file systems in different zones in the same region communicate with ECS cloud servers.

        > **NOTE:** - We recommend that the file system and the ECS instance belong to the same zone to avoid cross-zone latency.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.input_type
class _FileSystemState:
    def __init__(__self__, *,
                 capacity: Optional[pulumi.Input[_builtins.int]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 encrypt_type: Optional[pulumi.Input[_builtins.int]] = None,
                 file_system_type: Optional[pulumi.Input[_builtins.str]] = None,
                 keytab: Optional[pulumi.Input[_builtins.str]] = None,
                 keytab_md5: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 nfs_acl: Optional[pulumi.Input['FileSystemNfsAclArgs']] = None,
                 options: Optional[pulumi.Input['FileSystemOptionsArgs']] = None,
                 protocol_type: Optional[pulumi.Input[_builtins.str]] = None,
                 recycle_bin: Optional[pulumi.Input['FileSystemRecycleBinArgs']] = None,
                 region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 smb_acl: Optional[pulumi.Input['FileSystemSmbAclArgs']] = None,
                 snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering FileSystem resources.
        :param pulumi.Input[_builtins.int] capacity: File system capacity.
               
               Unit: GiB, required and valid when FileSystemType = extreme or cpfs.
               
               For optional values, please refer to the actual specifications on the purchase page:
               -[Fast NAS Pay-As-You-Go Page](https://common-buy.aliyun.com/? commodityCode=nas_extreme_post#/buy)
               -[Fast NAS Package Monthly Purchase Page](https://common-buy.aliyun.com/? commodityCode=nas_extreme#/buy)
               -[Parallel File System CPFS Pay-As-You-Go Purchase Page](https://common-buy.aliyun.com/? commodityCode=nas_cpfs_post#/buy)
               -[Parallel File System CPFS Package Monthly Purchase Page](https://common-buy.aliyun.com/? commodityCode=cpfs#/buy)
        :param pulumi.Input[_builtins.str] create_time: CreateTime
        :param pulumi.Input[_builtins.str] description: File system description.
               
               Restrictions:
               - 2~128 English or Chinese characters in length.
               - Must start with upper and lower case letters or Chinese, and cannot start with'http: // 'and'https.
               - Can contain numbers, colons (:), underscores (_), or dashes (-).
        :param pulumi.Input[_builtins.int] encrypt_type: Whether the file system is encrypted.
               
               Use the KMS service hosting key to encrypt and store the file system disk data. When reading and writing encrypted data, there is no need to decrypt it.
               
               Value:
               - 0 (default): not encrypted.
               - 1:NAS managed key. NAS managed keys are supported when FileSystemType = standard or extreme.
               - 2: User management key. You can manage keys only when FileSystemType = extreme.
        :param pulumi.Input[_builtins.str] file_system_type: File system type.
               
               Value:
               - standard (default): Universal NAS
               - extreme: extreme NAS
               - cpfs: file storage CPFS
        :param pulumi.Input[_builtins.str] keytab: String of keytab file content encrypted by base64
        :param pulumi.Input[_builtins.str] keytab_md5: String of the keytab file content encrypted by MD5
        :param pulumi.Input[_builtins.str] kms_key_id: The ID of the KMS key.
               This parameter is required only when EncryptType = 2.
        :param pulumi.Input['FileSystemNfsAclArgs'] nfs_acl: NFS ACL See `nfs_acl` below.
        :param pulumi.Input['FileSystemOptionsArgs'] options: Option. See `options` below.
        :param pulumi.Input[_builtins.str] protocol_type: File transfer protocol type.
               - When FileSystemType = standard, the values are NFS and SMB.
               - When FileSystemType = extreme, the value is NFS.
               - When FileSystemType = cpfs, the value is cpfs.
        :param pulumi.Input['FileSystemRecycleBinArgs'] recycle_bin: Recycle Bin See `recycle_bin` below.
        :param pulumi.Input[_builtins.str] region_id: RegionId
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group.
        :param pulumi.Input['FileSystemSmbAclArgs'] smb_acl: SMB ACL See `smb_acl` below.
        :param pulumi.Input[_builtins.str] snapshot_id: Only extreme NAS is supported.
               
               > **NOTE:** A file system is created from a snapshot. The version of the created file system is the same as that of the snapshot source file system. For example, if the source file system version of the snapshot is 1 and you need to create A file system of version 2, you can first create A file system A from the snapshot, then create A file system B that meets the configuration of version 2, copy the data in file system A to file system B, and migrate the business to file system B after the copy is completed.
        :param pulumi.Input[_builtins.str] status: File system status. Includes:(such as creating a mount point) can only be performed when the file system is in the Running state.
        :param pulumi.Input[_builtins.str] storage_type: The storage type.
               - When FileSystemType = standard, the values are Performance, Capacity, and Premium.
               - When FileSystemType = extreme, the value is standard or advance.
               - When FileSystemType = cpfs, the values are advance_100(100MB/s/TiB baseline) and advance_200(200MB/s/TiB baseline).
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Label information collection.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the VPC network.
               This parameter must be configured when FileSystemType = cpfs.
               When the FileSystemType is standard or extreme, this parameter is reserved for the interface and has not taken effect yet. You do not need to configure it.
        :param pulumi.Input[_builtins.str] vswitch_id: The ID of the switch.
               This parameter must be configured when FileSystemType = cpfs.
               When the FileSystemType is standard or extreme, this parameter is reserved for the interface and has not taken effect yet. You do not need to configure it.
        :param pulumi.Input[_builtins.str] zone_id: The zone ID.
               
               The usable area refers to the physical area where power and network are independent of each other in the same area.
               
               When the FileSystemType is set to standard, this parameter is optional. By default, a zone that meets the conditions is randomly selected based on the ProtocolType and StorageType configurations. This parameter is required when FileSystemType = extreme or FileSystemType = cpfs.
               
               > **NOTE:** - file systems in different zones in the same region communicate with ECS cloud servers.
               
               > **NOTE:** - We recommend that the file system and the ECS instance belong to the same zone to avoid cross-zone latency.
        """
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypt_type is not None:
            pulumi.set(__self__, "encrypt_type", encrypt_type)
        if file_system_type is not None:
            pulumi.set(__self__, "file_system_type", file_system_type)
        if keytab is not None:
            pulumi.set(__self__, "keytab", keytab)
        if keytab_md5 is not None:
            pulumi.set(__self__, "keytab_md5", keytab_md5)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if nfs_acl is not None:
            pulumi.set(__self__, "nfs_acl", nfs_acl)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if protocol_type is not None:
            pulumi.set(__self__, "protocol_type", protocol_type)
        if recycle_bin is not None:
            pulumi.set(__self__, "recycle_bin", recycle_bin)
        if region_id is not None:
            pulumi.set(__self__, "region_id", region_id)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if smb_acl is not None:
            pulumi.set(__self__, "smb_acl", smb_acl)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if storage_type is not None:
            pulumi.set(__self__, "storage_type", storage_type)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter
    def capacity(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        File system capacity.

        Unit: GiB, required and valid when FileSystemType = extreme or cpfs.

        For optional values, please refer to the actual specifications on the purchase page:
        -[Fast NAS Pay-As-You-Go Page](https://common-buy.aliyun.com/? commodityCode=nas_extreme_post#/buy)
        -[Fast NAS Package Monthly Purchase Page](https://common-buy.aliyun.com/? commodityCode=nas_extreme#/buy)
        -[Parallel File System CPFS Pay-As-You-Go Purchase Page](https://common-buy.aliyun.com/? commodityCode=nas_cpfs_post#/buy)
        -[Parallel File System CPFS Package Monthly Purchase Page](https://common-buy.aliyun.com/? commodityCode=cpfs#/buy)
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "capacity", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        CreateTime
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        File system description.

        Restrictions:
        - 2~128 English or Chinese characters in length.
        - Must start with upper and lower case letters or Chinese, and cannot start with'http: // 'and'https.
        - Can contain numbers, colons (:), underscores (_), or dashes (-).
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="encryptType")
    def encrypt_type(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Whether the file system is encrypted.

        Use the KMS service hosting key to encrypt and store the file system disk data. When reading and writing encrypted data, there is no need to decrypt it.

        Value:
        - 0 (default): not encrypted.
        - 1:NAS managed key. NAS managed keys are supported when FileSystemType = standard or extreme.
        - 2: User management key. You can manage keys only when FileSystemType = extreme.
        """
        return pulumi.get(self, "encrypt_type")

    @encrypt_type.setter
    def encrypt_type(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "encrypt_type", value)

    @_builtins.property
    @pulumi.getter(name="fileSystemType")
    def file_system_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        File system type.

        Value:
        - standard (default): Universal NAS
        - extreme: extreme NAS
        - cpfs: file storage CPFS
        """
        return pulumi.get(self, "file_system_type")

    @file_system_type.setter
    def file_system_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "file_system_type", value)

    @_builtins.property
    @pulumi.getter
    def keytab(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        String of keytab file content encrypted by base64
        """
        return pulumi.get(self, "keytab")

    @keytab.setter
    def keytab(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "keytab", value)

    @_builtins.property
    @pulumi.getter(name="keytabMd5")
    def keytab_md5(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        String of the keytab file content encrypted by MD5
        """
        return pulumi.get(self, "keytab_md5")

    @keytab_md5.setter
    def keytab_md5(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "keytab_md5", value)

    @_builtins.property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the KMS key.
        This parameter is required only when EncryptType = 2.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_key_id", value)

    @_builtins.property
    @pulumi.getter(name="nfsAcl")
    def nfs_acl(self) -> Optional[pulumi.Input['FileSystemNfsAclArgs']]:
        """
        NFS ACL See `nfs_acl` below.
        """
        return pulumi.get(self, "nfs_acl")

    @nfs_acl.setter
    def nfs_acl(self, value: Optional[pulumi.Input['FileSystemNfsAclArgs']]):
        pulumi.set(self, "nfs_acl", value)

    @_builtins.property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input['FileSystemOptionsArgs']]:
        """
        Option. See `options` below.
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input['FileSystemOptionsArgs']]):
        pulumi.set(self, "options", value)

    @_builtins.property
    @pulumi.getter(name="protocolType")
    def protocol_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        File transfer protocol type.
        - When FileSystemType = standard, the values are NFS and SMB.
        - When FileSystemType = extreme, the value is NFS.
        - When FileSystemType = cpfs, the value is cpfs.
        """
        return pulumi.get(self, "protocol_type")

    @protocol_type.setter
    def protocol_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protocol_type", value)

    @_builtins.property
    @pulumi.getter(name="recycleBin")
    def recycle_bin(self) -> Optional[pulumi.Input['FileSystemRecycleBinArgs']]:
        """
        Recycle Bin See `recycle_bin` below.
        """
        return pulumi.get(self, "recycle_bin")

    @recycle_bin.setter
    def recycle_bin(self, value: Optional[pulumi.Input['FileSystemRecycleBinArgs']]):
        pulumi.set(self, "recycle_bin", value)

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        RegionId
        """
        return pulumi.get(self, "region_id")

    @region_id.setter
    def region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="smbAcl")
    def smb_acl(self) -> Optional[pulumi.Input['FileSystemSmbAclArgs']]:
        """
        SMB ACL See `smb_acl` below.
        """
        return pulumi.get(self, "smb_acl")

    @smb_acl.setter
    def smb_acl(self, value: Optional[pulumi.Input['FileSystemSmbAclArgs']]):
        pulumi.set(self, "smb_acl", value)

    @_builtins.property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Only extreme NAS is supported.

        > **NOTE:** A file system is created from a snapshot. The version of the created file system is the same as that of the snapshot source file system. For example, if the source file system version of the snapshot is 1 and you need to create A file system of version 2, you can first create A file system A from the snapshot, then create A file system B that meets the configuration of version 2, copy the data in file system A to file system B, and migrate the business to file system B after the copy is completed.
        """
        return pulumi.get(self, "snapshot_id")

    @snapshot_id.setter
    def snapshot_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snapshot_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        File system status. Includes:(such as creating a mount point) can only be performed when the file system is in the Running state.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The storage type.
        - When FileSystemType = standard, the values are Performance, Capacity, and Premium.
        - When FileSystemType = extreme, the value is standard or advance.
        - When FileSystemType = cpfs, the values are advance_100(100MB/s/TiB baseline) and advance_200(200MB/s/TiB baseline).
        """
        return pulumi.get(self, "storage_type")

    @storage_type.setter
    def storage_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_type", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Label information collection.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the VPC network.
        This parameter must be configured when FileSystemType = cpfs.
        When the FileSystemType is standard or extreme, this parameter is reserved for the interface and has not taken effect yet. You do not need to configure it.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the switch.
        This parameter must be configured when FileSystemType = cpfs.
        When the FileSystemType is standard or extreme, this parameter is reserved for the interface and has not taken effect yet. You do not need to configure it.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vswitch_id", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The zone ID.

        The usable area refers to the physical area where power and network are independent of each other in the same area.

        When the FileSystemType is set to standard, this parameter is optional. By default, a zone that meets the conditions is randomly selected based on the ProtocolType and StorageType configurations. This parameter is required when FileSystemType = extreme or FileSystemType = cpfs.

        > **NOTE:** - file systems in different zones in the same region communicate with ECS cloud servers.

        > **NOTE:** - We recommend that the file system and the ECS instance belong to the same zone to avoid cross-zone latency.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.type_token("alicloud:nas/fileSystem:FileSystem")
class FileSystem(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 capacity: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 encrypt_type: Optional[pulumi.Input[_builtins.int]] = None,
                 file_system_type: Optional[pulumi.Input[_builtins.str]] = None,
                 keytab: Optional[pulumi.Input[_builtins.str]] = None,
                 keytab_md5: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 nfs_acl: Optional[pulumi.Input[Union['FileSystemNfsAclArgs', 'FileSystemNfsAclArgsDict']]] = None,
                 options: Optional[pulumi.Input[Union['FileSystemOptionsArgs', 'FileSystemOptionsArgsDict']]] = None,
                 protocol_type: Optional[pulumi.Input[_builtins.str]] = None,
                 recycle_bin: Optional[pulumi.Input[Union['FileSystemRecycleBinArgs', 'FileSystemRecycleBinArgsDict']]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 smb_acl: Optional[pulumi.Input[Union['FileSystemSmbAclArgs', 'FileSystemSmbAclArgsDict']]] = None,
                 snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a File Storage (NAS) File System resource.

        File System Instance.

        For information about File Storage (NAS) File System and how to use it, see [What is File System](https://www.alibabacloud.com/help/en/nas/developer-reference/api-nas-2017-06-26-createfilesystem).

        > **NOTE:** Available since v1.33.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.nas.get_zones(file_system_type="standard")
        default_file_system = alicloud.nas.FileSystem("default",
            protocol_type="NFS",
            storage_type="Capacity",
            description=name,
            encrypt_type=1,
            file_system_type="standard",
            recycle_bin={
                "status": "Enable",
                "reserved_days": 10,
            },
            nfs_acl={
                "enabled": True,
            },
            zone_id=default.zones[0].zone_id)
        ```

        ## Import

        File Storage (NAS) File System can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:nas/fileSystem:FileSystem example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] capacity: File system capacity.
               
               Unit: GiB, required and valid when FileSystemType = extreme or cpfs.
               
               For optional values, please refer to the actual specifications on the purchase page:
               -[Fast NAS Pay-As-You-Go Page](https://common-buy.aliyun.com/? commodityCode=nas_extreme_post#/buy)
               -[Fast NAS Package Monthly Purchase Page](https://common-buy.aliyun.com/? commodityCode=nas_extreme#/buy)
               -[Parallel File System CPFS Pay-As-You-Go Purchase Page](https://common-buy.aliyun.com/? commodityCode=nas_cpfs_post#/buy)
               -[Parallel File System CPFS Package Monthly Purchase Page](https://common-buy.aliyun.com/? commodityCode=cpfs#/buy)
        :param pulumi.Input[_builtins.str] description: File system description.
               
               Restrictions:
               - 2~128 English or Chinese characters in length.
               - Must start with upper and lower case letters or Chinese, and cannot start with'http: // 'and'https.
               - Can contain numbers, colons (:), underscores (_), or dashes (-).
        :param pulumi.Input[_builtins.int] encrypt_type: Whether the file system is encrypted.
               
               Use the KMS service hosting key to encrypt and store the file system disk data. When reading and writing encrypted data, there is no need to decrypt it.
               
               Value:
               - 0 (default): not encrypted.
               - 1:NAS managed key. NAS managed keys are supported when FileSystemType = standard or extreme.
               - 2: User management key. You can manage keys only when FileSystemType = extreme.
        :param pulumi.Input[_builtins.str] file_system_type: File system type.
               
               Value:
               - standard (default): Universal NAS
               - extreme: extreme NAS
               - cpfs: file storage CPFS
        :param pulumi.Input[_builtins.str] keytab: String of keytab file content encrypted by base64
        :param pulumi.Input[_builtins.str] keytab_md5: String of the keytab file content encrypted by MD5
        :param pulumi.Input[_builtins.str] kms_key_id: The ID of the KMS key.
               This parameter is required only when EncryptType = 2.
        :param pulumi.Input[Union['FileSystemNfsAclArgs', 'FileSystemNfsAclArgsDict']] nfs_acl: NFS ACL See `nfs_acl` below.
        :param pulumi.Input[Union['FileSystemOptionsArgs', 'FileSystemOptionsArgsDict']] options: Option. See `options` below.
        :param pulumi.Input[_builtins.str] protocol_type: File transfer protocol type.
               - When FileSystemType = standard, the values are NFS and SMB.
               - When FileSystemType = extreme, the value is NFS.
               - When FileSystemType = cpfs, the value is cpfs.
        :param pulumi.Input[Union['FileSystemRecycleBinArgs', 'FileSystemRecycleBinArgsDict']] recycle_bin: Recycle Bin See `recycle_bin` below.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[Union['FileSystemSmbAclArgs', 'FileSystemSmbAclArgsDict']] smb_acl: SMB ACL See `smb_acl` below.
        :param pulumi.Input[_builtins.str] snapshot_id: Only extreme NAS is supported.
               
               > **NOTE:** A file system is created from a snapshot. The version of the created file system is the same as that of the snapshot source file system. For example, if the source file system version of the snapshot is 1 and you need to create A file system of version 2, you can first create A file system A from the snapshot, then create A file system B that meets the configuration of version 2, copy the data in file system A to file system B, and migrate the business to file system B after the copy is completed.
        :param pulumi.Input[_builtins.str] storage_type: The storage type.
               - When FileSystemType = standard, the values are Performance, Capacity, and Premium.
               - When FileSystemType = extreme, the value is standard or advance.
               - When FileSystemType = cpfs, the values are advance_100(100MB/s/TiB baseline) and advance_200(200MB/s/TiB baseline).
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Label information collection.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the VPC network.
               This parameter must be configured when FileSystemType = cpfs.
               When the FileSystemType is standard or extreme, this parameter is reserved for the interface and has not taken effect yet. You do not need to configure it.
        :param pulumi.Input[_builtins.str] vswitch_id: The ID of the switch.
               This parameter must be configured when FileSystemType = cpfs.
               When the FileSystemType is standard or extreme, this parameter is reserved for the interface and has not taken effect yet. You do not need to configure it.
        :param pulumi.Input[_builtins.str] zone_id: The zone ID.
               
               The usable area refers to the physical area where power and network are independent of each other in the same area.
               
               When the FileSystemType is set to standard, this parameter is optional. By default, a zone that meets the conditions is randomly selected based on the ProtocolType and StorageType configurations. This parameter is required when FileSystemType = extreme or FileSystemType = cpfs.
               
               > **NOTE:** - file systems in different zones in the same region communicate with ECS cloud servers.
               
               > **NOTE:** - We recommend that the file system and the ECS instance belong to the same zone to avoid cross-zone latency.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FileSystemArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a File Storage (NAS) File System resource.

        File System Instance.

        For information about File Storage (NAS) File System and how to use it, see [What is File System](https://www.alibabacloud.com/help/en/nas/developer-reference/api-nas-2017-06-26-createfilesystem).

        > **NOTE:** Available since v1.33.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.nas.get_zones(file_system_type="standard")
        default_file_system = alicloud.nas.FileSystem("default",
            protocol_type="NFS",
            storage_type="Capacity",
            description=name,
            encrypt_type=1,
            file_system_type="standard",
            recycle_bin={
                "status": "Enable",
                "reserved_days": 10,
            },
            nfs_acl={
                "enabled": True,
            },
            zone_id=default.zones[0].zone_id)
        ```

        ## Import

        File Storage (NAS) File System can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:nas/fileSystem:FileSystem example <id>
        ```

        :param str resource_name: The name of the resource.
        :param FileSystemArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FileSystemArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 capacity: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 encrypt_type: Optional[pulumi.Input[_builtins.int]] = None,
                 file_system_type: Optional[pulumi.Input[_builtins.str]] = None,
                 keytab: Optional[pulumi.Input[_builtins.str]] = None,
                 keytab_md5: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 nfs_acl: Optional[pulumi.Input[Union['FileSystemNfsAclArgs', 'FileSystemNfsAclArgsDict']]] = None,
                 options: Optional[pulumi.Input[Union['FileSystemOptionsArgs', 'FileSystemOptionsArgsDict']]] = None,
                 protocol_type: Optional[pulumi.Input[_builtins.str]] = None,
                 recycle_bin: Optional[pulumi.Input[Union['FileSystemRecycleBinArgs', 'FileSystemRecycleBinArgsDict']]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 smb_acl: Optional[pulumi.Input[Union['FileSystemSmbAclArgs', 'FileSystemSmbAclArgsDict']]] = None,
                 snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FileSystemArgs.__new__(FileSystemArgs)

            __props__.__dict__["capacity"] = capacity
            __props__.__dict__["description"] = description
            __props__.__dict__["encrypt_type"] = encrypt_type
            __props__.__dict__["file_system_type"] = file_system_type
            __props__.__dict__["keytab"] = keytab
            __props__.__dict__["keytab_md5"] = keytab_md5
            __props__.__dict__["kms_key_id"] = kms_key_id
            __props__.__dict__["nfs_acl"] = nfs_acl
            __props__.__dict__["options"] = options
            if protocol_type is None and not opts.urn:
                raise TypeError("Missing required property 'protocol_type'")
            __props__.__dict__["protocol_type"] = protocol_type
            __props__.__dict__["recycle_bin"] = recycle_bin
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["smb_acl"] = smb_acl
            __props__.__dict__["snapshot_id"] = snapshot_id
            if storage_type is None and not opts.urn:
                raise TypeError("Missing required property 'storage_type'")
            __props__.__dict__["storage_type"] = storage_type
            __props__.__dict__["tags"] = tags
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["vswitch_id"] = vswitch_id
            __props__.__dict__["zone_id"] = zone_id
            __props__.__dict__["create_time"] = None
            __props__.__dict__["region_id"] = None
            __props__.__dict__["status"] = None
        super(FileSystem, __self__).__init__(
            'alicloud:nas/fileSystem:FileSystem',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            capacity: Optional[pulumi.Input[_builtins.int]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            encrypt_type: Optional[pulumi.Input[_builtins.int]] = None,
            file_system_type: Optional[pulumi.Input[_builtins.str]] = None,
            keytab: Optional[pulumi.Input[_builtins.str]] = None,
            keytab_md5: Optional[pulumi.Input[_builtins.str]] = None,
            kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
            nfs_acl: Optional[pulumi.Input[Union['FileSystemNfsAclArgs', 'FileSystemNfsAclArgsDict']]] = None,
            options: Optional[pulumi.Input[Union['FileSystemOptionsArgs', 'FileSystemOptionsArgsDict']]] = None,
            protocol_type: Optional[pulumi.Input[_builtins.str]] = None,
            recycle_bin: Optional[pulumi.Input[Union['FileSystemRecycleBinArgs', 'FileSystemRecycleBinArgsDict']]] = None,
            region_id: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            smb_acl: Optional[pulumi.Input[Union['FileSystemSmbAclArgs', 'FileSystemSmbAclArgsDict']]] = None,
            snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            storage_type: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
            vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
            zone_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'FileSystem':
        """
        Get an existing FileSystem resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] capacity: File system capacity.
               
               Unit: GiB, required and valid when FileSystemType = extreme or cpfs.
               
               For optional values, please refer to the actual specifications on the purchase page:
               -[Fast NAS Pay-As-You-Go Page](https://common-buy.aliyun.com/? commodityCode=nas_extreme_post#/buy)
               -[Fast NAS Package Monthly Purchase Page](https://common-buy.aliyun.com/? commodityCode=nas_extreme#/buy)
               -[Parallel File System CPFS Pay-As-You-Go Purchase Page](https://common-buy.aliyun.com/? commodityCode=nas_cpfs_post#/buy)
               -[Parallel File System CPFS Package Monthly Purchase Page](https://common-buy.aliyun.com/? commodityCode=cpfs#/buy)
        :param pulumi.Input[_builtins.str] create_time: CreateTime
        :param pulumi.Input[_builtins.str] description: File system description.
               
               Restrictions:
               - 2~128 English or Chinese characters in length.
               - Must start with upper and lower case letters or Chinese, and cannot start with'http: // 'and'https.
               - Can contain numbers, colons (:), underscores (_), or dashes (-).
        :param pulumi.Input[_builtins.int] encrypt_type: Whether the file system is encrypted.
               
               Use the KMS service hosting key to encrypt and store the file system disk data. When reading and writing encrypted data, there is no need to decrypt it.
               
               Value:
               - 0 (default): not encrypted.
               - 1:NAS managed key. NAS managed keys are supported when FileSystemType = standard or extreme.
               - 2: User management key. You can manage keys only when FileSystemType = extreme.
        :param pulumi.Input[_builtins.str] file_system_type: File system type.
               
               Value:
               - standard (default): Universal NAS
               - extreme: extreme NAS
               - cpfs: file storage CPFS
        :param pulumi.Input[_builtins.str] keytab: String of keytab file content encrypted by base64
        :param pulumi.Input[_builtins.str] keytab_md5: String of the keytab file content encrypted by MD5
        :param pulumi.Input[_builtins.str] kms_key_id: The ID of the KMS key.
               This parameter is required only when EncryptType = 2.
        :param pulumi.Input[Union['FileSystemNfsAclArgs', 'FileSystemNfsAclArgsDict']] nfs_acl: NFS ACL See `nfs_acl` below.
        :param pulumi.Input[Union['FileSystemOptionsArgs', 'FileSystemOptionsArgsDict']] options: Option. See `options` below.
        :param pulumi.Input[_builtins.str] protocol_type: File transfer protocol type.
               - When FileSystemType = standard, the values are NFS and SMB.
               - When FileSystemType = extreme, the value is NFS.
               - When FileSystemType = cpfs, the value is cpfs.
        :param pulumi.Input[Union['FileSystemRecycleBinArgs', 'FileSystemRecycleBinArgsDict']] recycle_bin: Recycle Bin See `recycle_bin` below.
        :param pulumi.Input[_builtins.str] region_id: RegionId
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[Union['FileSystemSmbAclArgs', 'FileSystemSmbAclArgsDict']] smb_acl: SMB ACL See `smb_acl` below.
        :param pulumi.Input[_builtins.str] snapshot_id: Only extreme NAS is supported.
               
               > **NOTE:** A file system is created from a snapshot. The version of the created file system is the same as that of the snapshot source file system. For example, if the source file system version of the snapshot is 1 and you need to create A file system of version 2, you can first create A file system A from the snapshot, then create A file system B that meets the configuration of version 2, copy the data in file system A to file system B, and migrate the business to file system B after the copy is completed.
        :param pulumi.Input[_builtins.str] status: File system status. Includes:(such as creating a mount point) can only be performed when the file system is in the Running state.
        :param pulumi.Input[_builtins.str] storage_type: The storage type.
               - When FileSystemType = standard, the values are Performance, Capacity, and Premium.
               - When FileSystemType = extreme, the value is standard or advance.
               - When FileSystemType = cpfs, the values are advance_100(100MB/s/TiB baseline) and advance_200(200MB/s/TiB baseline).
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Label information collection.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the VPC network.
               This parameter must be configured when FileSystemType = cpfs.
               When the FileSystemType is standard or extreme, this parameter is reserved for the interface and has not taken effect yet. You do not need to configure it.
        :param pulumi.Input[_builtins.str] vswitch_id: The ID of the switch.
               This parameter must be configured when FileSystemType = cpfs.
               When the FileSystemType is standard or extreme, this parameter is reserved for the interface and has not taken effect yet. You do not need to configure it.
        :param pulumi.Input[_builtins.str] zone_id: The zone ID.
               
               The usable area refers to the physical area where power and network are independent of each other in the same area.
               
               When the FileSystemType is set to standard, this parameter is optional. By default, a zone that meets the conditions is randomly selected based on the ProtocolType and StorageType configurations. This parameter is required when FileSystemType = extreme or FileSystemType = cpfs.
               
               > **NOTE:** - file systems in different zones in the same region communicate with ECS cloud servers.
               
               > **NOTE:** - We recommend that the file system and the ECS instance belong to the same zone to avoid cross-zone latency.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FileSystemState.__new__(_FileSystemState)

        __props__.__dict__["capacity"] = capacity
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["encrypt_type"] = encrypt_type
        __props__.__dict__["file_system_type"] = file_system_type
        __props__.__dict__["keytab"] = keytab
        __props__.__dict__["keytab_md5"] = keytab_md5
        __props__.__dict__["kms_key_id"] = kms_key_id
        __props__.__dict__["nfs_acl"] = nfs_acl
        __props__.__dict__["options"] = options
        __props__.__dict__["protocol_type"] = protocol_type
        __props__.__dict__["recycle_bin"] = recycle_bin
        __props__.__dict__["region_id"] = region_id
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["smb_acl"] = smb_acl
        __props__.__dict__["snapshot_id"] = snapshot_id
        __props__.__dict__["status"] = status
        __props__.__dict__["storage_type"] = storage_type
        __props__.__dict__["tags"] = tags
        __props__.__dict__["vpc_id"] = vpc_id
        __props__.__dict__["vswitch_id"] = vswitch_id
        __props__.__dict__["zone_id"] = zone_id
        return FileSystem(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def capacity(self) -> pulumi.Output[_builtins.int]:
        """
        File system capacity.

        Unit: GiB, required and valid when FileSystemType = extreme or cpfs.

        For optional values, please refer to the actual specifications on the purchase page:
        -[Fast NAS Pay-As-You-Go Page](https://common-buy.aliyun.com/? commodityCode=nas_extreme_post#/buy)
        -[Fast NAS Package Monthly Purchase Page](https://common-buy.aliyun.com/? commodityCode=nas_extreme#/buy)
        -[Parallel File System CPFS Pay-As-You-Go Purchase Page](https://common-buy.aliyun.com/? commodityCode=nas_cpfs_post#/buy)
        -[Parallel File System CPFS Package Monthly Purchase Page](https://common-buy.aliyun.com/? commodityCode=cpfs#/buy)
        """
        return pulumi.get(self, "capacity")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        CreateTime
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        File system description.

        Restrictions:
        - 2~128 English or Chinese characters in length.
        - Must start with upper and lower case letters or Chinese, and cannot start with'http: // 'and'https.
        - Can contain numbers, colons (:), underscores (_), or dashes (-).
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="encryptType")
    def encrypt_type(self) -> pulumi.Output[_builtins.int]:
        """
        Whether the file system is encrypted.

        Use the KMS service hosting key to encrypt and store the file system disk data. When reading and writing encrypted data, there is no need to decrypt it.

        Value:
        - 0 (default): not encrypted.
        - 1:NAS managed key. NAS managed keys are supported when FileSystemType = standard or extreme.
        - 2: User management key. You can manage keys only when FileSystemType = extreme.
        """
        return pulumi.get(self, "encrypt_type")

    @_builtins.property
    @pulumi.getter(name="fileSystemType")
    def file_system_type(self) -> pulumi.Output[_builtins.str]:
        """
        File system type.

        Value:
        - standard (default): Universal NAS
        - extreme: extreme NAS
        - cpfs: file storage CPFS
        """
        return pulumi.get(self, "file_system_type")

    @_builtins.property
    @pulumi.getter
    def keytab(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        String of keytab file content encrypted by base64
        """
        return pulumi.get(self, "keytab")

    @_builtins.property
    @pulumi.getter(name="keytabMd5")
    def keytab_md5(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        String of the keytab file content encrypted by MD5
        """
        return pulumi.get(self, "keytab_md5")

    @_builtins.property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the KMS key.
        This parameter is required only when EncryptType = 2.
        """
        return pulumi.get(self, "kms_key_id")

    @_builtins.property
    @pulumi.getter(name="nfsAcl")
    def nfs_acl(self) -> pulumi.Output['outputs.FileSystemNfsAcl']:
        """
        NFS ACL See `nfs_acl` below.
        """
        return pulumi.get(self, "nfs_acl")

    @_builtins.property
    @pulumi.getter
    def options(self) -> pulumi.Output['outputs.FileSystemOptions']:
        """
        Option. See `options` below.
        """
        return pulumi.get(self, "options")

    @_builtins.property
    @pulumi.getter(name="protocolType")
    def protocol_type(self) -> pulumi.Output[_builtins.str]:
        """
        File transfer protocol type.
        - When FileSystemType = standard, the values are NFS and SMB.
        - When FileSystemType = extreme, the value is NFS.
        - When FileSystemType = cpfs, the value is cpfs.
        """
        return pulumi.get(self, "protocol_type")

    @_builtins.property
    @pulumi.getter(name="recycleBin")
    def recycle_bin(self) -> pulumi.Output['outputs.FileSystemRecycleBin']:
        """
        Recycle Bin See `recycle_bin` below.
        """
        return pulumi.get(self, "recycle_bin")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> pulumi.Output[_builtins.str]:
        """
        RegionId
        """
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="smbAcl")
    def smb_acl(self) -> pulumi.Output['outputs.FileSystemSmbAcl']:
        """
        SMB ACL See `smb_acl` below.
        """
        return pulumi.get(self, "smb_acl")

    @_builtins.property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Only extreme NAS is supported.

        > **NOTE:** A file system is created from a snapshot. The version of the created file system is the same as that of the snapshot source file system. For example, if the source file system version of the snapshot is 1 and you need to create A file system of version 2, you can first create A file system A from the snapshot, then create A file system B that meets the configuration of version 2, copy the data in file system A to file system B, and migrate the business to file system B after the copy is completed.
        """
        return pulumi.get(self, "snapshot_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        File system status. Includes:(such as creating a mount point) can only be performed when the file system is in the Running state.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> pulumi.Output[_builtins.str]:
        """
        The storage type.
        - When FileSystemType = standard, the values are Performance, Capacity, and Premium.
        - When FileSystemType = extreme, the value is standard or advance.
        - When FileSystemType = cpfs, the values are advance_100(100MB/s/TiB baseline) and advance_200(200MB/s/TiB baseline).
        """
        return pulumi.get(self, "storage_type")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Label information collection.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the VPC network.
        This parameter must be configured when FileSystemType = cpfs.
        When the FileSystemType is standard or extreme, this parameter is reserved for the interface and has not taken effect yet. You do not need to configure it.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the switch.
        This parameter must be configured when FileSystemType = cpfs.
        When the FileSystemType is standard or extreme, this parameter is reserved for the interface and has not taken effect yet. You do not need to configure it.
        """
        return pulumi.get(self, "vswitch_id")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[_builtins.str]:
        """
        The zone ID.

        The usable area refers to the physical area where power and network are independent of each other in the same area.

        When the FileSystemType is set to standard, this parameter is optional. By default, a zone that meets the conditions is randomly selected based on the ProtocolType and StorageType configurations. This parameter is required when FileSystemType = extreme or FileSystemType = cpfs.

        > **NOTE:** - file systems in different zones in the same region communicate with ECS cloud servers.

        > **NOTE:** - We recommend that the file system and the ECS instance belong to the same zone to avoid cross-zone latency.
        """
        return pulumi.get(self, "zone_id")

