# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['LifecyclePolicyArgs', 'LifecyclePolicy']

@pulumi.input_type
class LifecyclePolicyArgs:
    def __init__(__self__, *,
                 file_system_id: pulumi.Input[_builtins.str],
                 lifecycle_policy_name: pulumi.Input[_builtins.str],
                 lifecycle_rule_name: pulumi.Input[_builtins.str],
                 paths: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 storage_type: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a LifecyclePolicy resource.
        :param pulumi.Input[_builtins.str] file_system_id: The ID of the file system.
        :param pulumi.Input[_builtins.str] lifecycle_policy_name: The name of the lifecycle management policy.
        :param pulumi.Input[_builtins.str] lifecycle_rule_name: The rules in the lifecycle management policy. Valid values: `DEFAULT_ATIME_14`, `DEFAULT_ATIME_30`, `DEFAULT_ATIME_60`, `DEFAULT_ATIME_90`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] paths: The absolute path of the directory for which the lifecycle management policy is configured. Set a maximum of `10` path. The path value must be prefixed by a forward slash (/) and must be an existing path in the mount target.
        :param pulumi.Input[_builtins.str] storage_type: The storage type of the data that is dumped to the IA storage medium. Valid values: `InfrequentAccess`.
        """
        pulumi.set(__self__, "file_system_id", file_system_id)
        pulumi.set(__self__, "lifecycle_policy_name", lifecycle_policy_name)
        pulumi.set(__self__, "lifecycle_rule_name", lifecycle_rule_name)
        pulumi.set(__self__, "paths", paths)
        pulumi.set(__self__, "storage_type", storage_type)

    @_builtins.property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the file system.
        """
        return pulumi.get(self, "file_system_id")

    @file_system_id.setter
    def file_system_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "file_system_id", value)

    @_builtins.property
    @pulumi.getter(name="lifecyclePolicyName")
    def lifecycle_policy_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the lifecycle management policy.
        """
        return pulumi.get(self, "lifecycle_policy_name")

    @lifecycle_policy_name.setter
    def lifecycle_policy_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "lifecycle_policy_name", value)

    @_builtins.property
    @pulumi.getter(name="lifecycleRuleName")
    def lifecycle_rule_name(self) -> pulumi.Input[_builtins.str]:
        """
        The rules in the lifecycle management policy. Valid values: `DEFAULT_ATIME_14`, `DEFAULT_ATIME_30`, `DEFAULT_ATIME_60`, `DEFAULT_ATIME_90`.
        """
        return pulumi.get(self, "lifecycle_rule_name")

    @lifecycle_rule_name.setter
    def lifecycle_rule_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "lifecycle_rule_name", value)

    @_builtins.property
    @pulumi.getter
    def paths(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The absolute path of the directory for which the lifecycle management policy is configured. Set a maximum of `10` path. The path value must be prefixed by a forward slash (/) and must be an existing path in the mount target.
        """
        return pulumi.get(self, "paths")

    @paths.setter
    def paths(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "paths", value)

    @_builtins.property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> pulumi.Input[_builtins.str]:
        """
        The storage type of the data that is dumped to the IA storage medium. Valid values: `InfrequentAccess`.
        """
        return pulumi.get(self, "storage_type")

    @storage_type.setter
    def storage_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "storage_type", value)


@pulumi.input_type
class _LifecyclePolicyState:
    def __init__(__self__, *,
                 file_system_id: Optional[pulumi.Input[_builtins.str]] = None,
                 lifecycle_policy_name: Optional[pulumi.Input[_builtins.str]] = None,
                 lifecycle_rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 paths: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 storage_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering LifecyclePolicy resources.
        :param pulumi.Input[_builtins.str] file_system_id: The ID of the file system.
        :param pulumi.Input[_builtins.str] lifecycle_policy_name: The name of the lifecycle management policy.
        :param pulumi.Input[_builtins.str] lifecycle_rule_name: The rules in the lifecycle management policy. Valid values: `DEFAULT_ATIME_14`, `DEFAULT_ATIME_30`, `DEFAULT_ATIME_60`, `DEFAULT_ATIME_90`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] paths: The absolute path of the directory for which the lifecycle management policy is configured. Set a maximum of `10` path. The path value must be prefixed by a forward slash (/) and must be an existing path in the mount target.
        :param pulumi.Input[_builtins.str] storage_type: The storage type of the data that is dumped to the IA storage medium. Valid values: `InfrequentAccess`.
        """
        if file_system_id is not None:
            pulumi.set(__self__, "file_system_id", file_system_id)
        if lifecycle_policy_name is not None:
            pulumi.set(__self__, "lifecycle_policy_name", lifecycle_policy_name)
        if lifecycle_rule_name is not None:
            pulumi.set(__self__, "lifecycle_rule_name", lifecycle_rule_name)
        if paths is not None:
            pulumi.set(__self__, "paths", paths)
        if storage_type is not None:
            pulumi.set(__self__, "storage_type", storage_type)

    @_builtins.property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the file system.
        """
        return pulumi.get(self, "file_system_id")

    @file_system_id.setter
    def file_system_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "file_system_id", value)

    @_builtins.property
    @pulumi.getter(name="lifecyclePolicyName")
    def lifecycle_policy_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the lifecycle management policy.
        """
        return pulumi.get(self, "lifecycle_policy_name")

    @lifecycle_policy_name.setter
    def lifecycle_policy_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lifecycle_policy_name", value)

    @_builtins.property
    @pulumi.getter(name="lifecycleRuleName")
    def lifecycle_rule_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The rules in the lifecycle management policy. Valid values: `DEFAULT_ATIME_14`, `DEFAULT_ATIME_30`, `DEFAULT_ATIME_60`, `DEFAULT_ATIME_90`.
        """
        return pulumi.get(self, "lifecycle_rule_name")

    @lifecycle_rule_name.setter
    def lifecycle_rule_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lifecycle_rule_name", value)

    @_builtins.property
    @pulumi.getter
    def paths(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The absolute path of the directory for which the lifecycle management policy is configured. Set a maximum of `10` path. The path value must be prefixed by a forward slash (/) and must be an existing path in the mount target.
        """
        return pulumi.get(self, "paths")

    @paths.setter
    def paths(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "paths", value)

    @_builtins.property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The storage type of the data that is dumped to the IA storage medium. Valid values: `InfrequentAccess`.
        """
        return pulumi.get(self, "storage_type")

    @storage_type.setter
    def storage_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_type", value)


@pulumi.type_token("alicloud:nas/lifecyclePolicy:LifecyclePolicy")
class LifecyclePolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 file_system_id: Optional[pulumi.Input[_builtins.str]] = None,
                 lifecycle_policy_name: Optional[pulumi.Input[_builtins.str]] = None,
                 lifecycle_rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 paths: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 storage_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a File Storage (NAS) Lifecycle Policy resource.

        For information about File Storage (NAS) Lifecycle Policy and how to use it, see [What is Lifecycle Policy](https://www.alibabacloud.com/help/en/doc-detail/169362.html).

        > **NOTE:** Available in v1.153.0+.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        example = alicloud.nas.FileSystem("example",
            protocol_type="NFS",
            storage_type="Capacity")
        example_lifecycle_policy = alicloud.nas.LifecyclePolicy("example",
            file_system_id=example.id,
            lifecycle_policy_name="terraform-example",
            lifecycle_rule_name="DEFAULT_ATIME_14",
            storage_type="InfrequentAccess",
            paths=["/"])
        ```

        ## Import

        File Storage (NAS) Lifecycle Policy can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:nas/lifecyclePolicy:LifecyclePolicy example <file_system_id>:<lifecycle_policy_name>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] file_system_id: The ID of the file system.
        :param pulumi.Input[_builtins.str] lifecycle_policy_name: The name of the lifecycle management policy.
        :param pulumi.Input[_builtins.str] lifecycle_rule_name: The rules in the lifecycle management policy. Valid values: `DEFAULT_ATIME_14`, `DEFAULT_ATIME_30`, `DEFAULT_ATIME_60`, `DEFAULT_ATIME_90`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] paths: The absolute path of the directory for which the lifecycle management policy is configured. Set a maximum of `10` path. The path value must be prefixed by a forward slash (/) and must be an existing path in the mount target.
        :param pulumi.Input[_builtins.str] storage_type: The storage type of the data that is dumped to the IA storage medium. Valid values: `InfrequentAccess`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LifecyclePolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a File Storage (NAS) Lifecycle Policy resource.

        For information about File Storage (NAS) Lifecycle Policy and how to use it, see [What is Lifecycle Policy](https://www.alibabacloud.com/help/en/doc-detail/169362.html).

        > **NOTE:** Available in v1.153.0+.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        example = alicloud.nas.FileSystem("example",
            protocol_type="NFS",
            storage_type="Capacity")
        example_lifecycle_policy = alicloud.nas.LifecyclePolicy("example",
            file_system_id=example.id,
            lifecycle_policy_name="terraform-example",
            lifecycle_rule_name="DEFAULT_ATIME_14",
            storage_type="InfrequentAccess",
            paths=["/"])
        ```

        ## Import

        File Storage (NAS) Lifecycle Policy can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:nas/lifecyclePolicy:LifecyclePolicy example <file_system_id>:<lifecycle_policy_name>
        ```

        :param str resource_name: The name of the resource.
        :param LifecyclePolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LifecyclePolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 file_system_id: Optional[pulumi.Input[_builtins.str]] = None,
                 lifecycle_policy_name: Optional[pulumi.Input[_builtins.str]] = None,
                 lifecycle_rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 paths: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 storage_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LifecyclePolicyArgs.__new__(LifecyclePolicyArgs)

            if file_system_id is None and not opts.urn:
                raise TypeError("Missing required property 'file_system_id'")
            __props__.__dict__["file_system_id"] = file_system_id
            if lifecycle_policy_name is None and not opts.urn:
                raise TypeError("Missing required property 'lifecycle_policy_name'")
            __props__.__dict__["lifecycle_policy_name"] = lifecycle_policy_name
            if lifecycle_rule_name is None and not opts.urn:
                raise TypeError("Missing required property 'lifecycle_rule_name'")
            __props__.__dict__["lifecycle_rule_name"] = lifecycle_rule_name
            if paths is None and not opts.urn:
                raise TypeError("Missing required property 'paths'")
            __props__.__dict__["paths"] = paths
            if storage_type is None and not opts.urn:
                raise TypeError("Missing required property 'storage_type'")
            __props__.__dict__["storage_type"] = storage_type
        super(LifecyclePolicy, __self__).__init__(
            'alicloud:nas/lifecyclePolicy:LifecyclePolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            file_system_id: Optional[pulumi.Input[_builtins.str]] = None,
            lifecycle_policy_name: Optional[pulumi.Input[_builtins.str]] = None,
            lifecycle_rule_name: Optional[pulumi.Input[_builtins.str]] = None,
            paths: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            storage_type: Optional[pulumi.Input[_builtins.str]] = None) -> 'LifecyclePolicy':
        """
        Get an existing LifecyclePolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] file_system_id: The ID of the file system.
        :param pulumi.Input[_builtins.str] lifecycle_policy_name: The name of the lifecycle management policy.
        :param pulumi.Input[_builtins.str] lifecycle_rule_name: The rules in the lifecycle management policy. Valid values: `DEFAULT_ATIME_14`, `DEFAULT_ATIME_30`, `DEFAULT_ATIME_60`, `DEFAULT_ATIME_90`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] paths: The absolute path of the directory for which the lifecycle management policy is configured. Set a maximum of `10` path. The path value must be prefixed by a forward slash (/) and must be an existing path in the mount target.
        :param pulumi.Input[_builtins.str] storage_type: The storage type of the data that is dumped to the IA storage medium. Valid values: `InfrequentAccess`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LifecyclePolicyState.__new__(_LifecyclePolicyState)

        __props__.__dict__["file_system_id"] = file_system_id
        __props__.__dict__["lifecycle_policy_name"] = lifecycle_policy_name
        __props__.__dict__["lifecycle_rule_name"] = lifecycle_rule_name
        __props__.__dict__["paths"] = paths
        __props__.__dict__["storage_type"] = storage_type
        return LifecyclePolicy(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the file system.
        """
        return pulumi.get(self, "file_system_id")

    @_builtins.property
    @pulumi.getter(name="lifecyclePolicyName")
    def lifecycle_policy_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the lifecycle management policy.
        """
        return pulumi.get(self, "lifecycle_policy_name")

    @_builtins.property
    @pulumi.getter(name="lifecycleRuleName")
    def lifecycle_rule_name(self) -> pulumi.Output[_builtins.str]:
        """
        The rules in the lifecycle management policy. Valid values: `DEFAULT_ATIME_14`, `DEFAULT_ATIME_30`, `DEFAULT_ATIME_60`, `DEFAULT_ATIME_90`.
        """
        return pulumi.get(self, "lifecycle_rule_name")

    @_builtins.property
    @pulumi.getter
    def paths(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The absolute path of the directory for which the lifecycle management policy is configured. Set a maximum of `10` path. The path value must be prefixed by a forward slash (/) and must be an existing path in the mount target.
        """
        return pulumi.get(self, "paths")

    @_builtins.property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> pulumi.Output[_builtins.str]:
        """
        The storage type of the data that is dumped to the IA storage medium. Valid values: `InfrequentAccess`.
        """
        return pulumi.get(self, "storage_type")

