# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SmbAclAttachmentArgs', 'SmbAclAttachment']

@pulumi.input_type
class SmbAclAttachmentArgs:
    def __init__(__self__, *,
                 file_system_id: pulumi.Input[_builtins.str],
                 keytab: pulumi.Input[_builtins.str],
                 keytab_md5: pulumi.Input[_builtins.str],
                 enable_anonymous_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 encrypt_data: Optional[pulumi.Input[_builtins.bool]] = None,
                 home_dir_path: Optional[pulumi.Input[_builtins.str]] = None,
                 reject_unencrypted_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 super_admin_sid: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a SmbAclAttachment resource.
        :param pulumi.Input[_builtins.str] file_system_id: The ID of the file system.
        :param pulumi.Input[_builtins.str] keytab: The string that is generated after the system encodes the keytab file by using Base64.
        :param pulumi.Input[_builtins.str] keytab_md5: RThe string that is generated after the system encodes the keytab file by using MD5.
        :param pulumi.Input[_builtins.bool] enable_anonymous_access: Specifies whether to allow anonymous access. Valid values:
               true: The file system allows anonymous access.
               false: The file system denies anonymous access. Default value: false.
        :param pulumi.Input[_builtins.bool] encrypt_data: Specifies whether to enable encryption in transit. Valid values:
               true: enables encryption in transit.
               false: disables encryption in transit. Default value: false.
        :param pulumi.Input[_builtins.str] home_dir_path: The home directory of each user. Each user-specific home directory must meet the following requirements:    
               Each segment starts with a forward slash (/) or a backslash (\\).
               Each segment does not contain the following special characters: <>":?*.
               Each segment is 0 to 255 characters in length.
               The total length is 0 to 32,767 characters.
               For example, if you create a user named A and the home directory is /home, the file system automatically creates a directory named /home/A when User A logs on to the file system. If the /home/A directory already exists, the file system does not create the directory.
        :param pulumi.Input[_builtins.bool] reject_unencrypted_access: Specifies whether to deny access from non-encrypted clients. Valid values:
               true: The file system denies access from non-encrypted clients.
               false: The file system allows access from non-encrypted clients. Default value: false.
        :param pulumi.Input[_builtins.str] super_admin_sid: The ID of a super admin. The ID must meet the following requirements:
               The ID starts with S and does not contain letters except S.
               The ID contains at least three hyphens (-) as delimiters.
               Example: S-1-5-22 and S-1-5-22-23.
        """
        pulumi.set(__self__, "file_system_id", file_system_id)
        pulumi.set(__self__, "keytab", keytab)
        pulumi.set(__self__, "keytab_md5", keytab_md5)
        if enable_anonymous_access is not None:
            pulumi.set(__self__, "enable_anonymous_access", enable_anonymous_access)
        if encrypt_data is not None:
            pulumi.set(__self__, "encrypt_data", encrypt_data)
        if home_dir_path is not None:
            pulumi.set(__self__, "home_dir_path", home_dir_path)
        if reject_unencrypted_access is not None:
            pulumi.set(__self__, "reject_unencrypted_access", reject_unencrypted_access)
        if super_admin_sid is not None:
            pulumi.set(__self__, "super_admin_sid", super_admin_sid)

    @_builtins.property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the file system.
        """
        return pulumi.get(self, "file_system_id")

    @file_system_id.setter
    def file_system_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "file_system_id", value)

    @_builtins.property
    @pulumi.getter
    def keytab(self) -> pulumi.Input[_builtins.str]:
        """
        The string that is generated after the system encodes the keytab file by using Base64.
        """
        return pulumi.get(self, "keytab")

    @keytab.setter
    def keytab(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "keytab", value)

    @_builtins.property
    @pulumi.getter(name="keytabMd5")
    def keytab_md5(self) -> pulumi.Input[_builtins.str]:
        """
        RThe string that is generated after the system encodes the keytab file by using MD5.
        """
        return pulumi.get(self, "keytab_md5")

    @keytab_md5.setter
    def keytab_md5(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "keytab_md5", value)

    @_builtins.property
    @pulumi.getter(name="enableAnonymousAccess")
    def enable_anonymous_access(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to allow anonymous access. Valid values:
        true: The file system allows anonymous access.
        false: The file system denies anonymous access. Default value: false.
        """
        return pulumi.get(self, "enable_anonymous_access")

    @enable_anonymous_access.setter
    def enable_anonymous_access(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_anonymous_access", value)

    @_builtins.property
    @pulumi.getter(name="encryptData")
    def encrypt_data(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable encryption in transit. Valid values:
        true: enables encryption in transit.
        false: disables encryption in transit. Default value: false.
        """
        return pulumi.get(self, "encrypt_data")

    @encrypt_data.setter
    def encrypt_data(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "encrypt_data", value)

    @_builtins.property
    @pulumi.getter(name="homeDirPath")
    def home_dir_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The home directory of each user. Each user-specific home directory must meet the following requirements:    
        Each segment starts with a forward slash (/) or a backslash (\\).
        Each segment does not contain the following special characters: <>":?*.
        Each segment is 0 to 255 characters in length.
        The total length is 0 to 32,767 characters.
        For example, if you create a user named A and the home directory is /home, the file system automatically creates a directory named /home/A when User A logs on to the file system. If the /home/A directory already exists, the file system does not create the directory.
        """
        return pulumi.get(self, "home_dir_path")

    @home_dir_path.setter
    def home_dir_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "home_dir_path", value)

    @_builtins.property
    @pulumi.getter(name="rejectUnencryptedAccess")
    def reject_unencrypted_access(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to deny access from non-encrypted clients. Valid values:
        true: The file system denies access from non-encrypted clients.
        false: The file system allows access from non-encrypted clients. Default value: false.
        """
        return pulumi.get(self, "reject_unencrypted_access")

    @reject_unencrypted_access.setter
    def reject_unencrypted_access(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "reject_unencrypted_access", value)

    @_builtins.property
    @pulumi.getter(name="superAdminSid")
    def super_admin_sid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of a super admin. The ID must meet the following requirements:
        The ID starts with S and does not contain letters except S.
        The ID contains at least three hyphens (-) as delimiters.
        Example: S-1-5-22 and S-1-5-22-23.
        """
        return pulumi.get(self, "super_admin_sid")

    @super_admin_sid.setter
    def super_admin_sid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "super_admin_sid", value)


@pulumi.input_type
class _SmbAclAttachmentState:
    def __init__(__self__, *,
                 auth_method: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_anonymous_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 enabled: Optional[pulumi.Input[_builtins.str]] = None,
                 encrypt_data: Optional[pulumi.Input[_builtins.bool]] = None,
                 file_system_id: Optional[pulumi.Input[_builtins.str]] = None,
                 home_dir_path: Optional[pulumi.Input[_builtins.str]] = None,
                 keytab: Optional[pulumi.Input[_builtins.str]] = None,
                 keytab_md5: Optional[pulumi.Input[_builtins.str]] = None,
                 reject_unencrypted_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 super_admin_sid: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SmbAclAttachment resources.
        :param pulumi.Input[_builtins.str] auth_method: The method that is used to authenticate network identities.
        :param pulumi.Input[_builtins.bool] enable_anonymous_access: Specifies whether to allow anonymous access. Valid values:
               true: The file system allows anonymous access.
               false: The file system denies anonymous access. Default value: false.
        :param pulumi.Input[_builtins.str] enabled: Specifies whether to enable the ACL feature.
               true: enables the ACL feature.
               false: disables the ACL feature.
        :param pulumi.Input[_builtins.bool] encrypt_data: Specifies whether to enable encryption in transit. Valid values:
               true: enables encryption in transit.
               false: disables encryption in transit. Default value: false.
        :param pulumi.Input[_builtins.str] file_system_id: The ID of the file system.
        :param pulumi.Input[_builtins.str] home_dir_path: The home directory of each user. Each user-specific home directory must meet the following requirements:    
               Each segment starts with a forward slash (/) or a backslash (\\).
               Each segment does not contain the following special characters: <>":?*.
               Each segment is 0 to 255 characters in length.
               The total length is 0 to 32,767 characters.
               For example, if you create a user named A and the home directory is /home, the file system automatically creates a directory named /home/A when User A logs on to the file system. If the /home/A directory already exists, the file system does not create the directory.
        :param pulumi.Input[_builtins.str] keytab: The string that is generated after the system encodes the keytab file by using Base64.
        :param pulumi.Input[_builtins.str] keytab_md5: RThe string that is generated after the system encodes the keytab file by using MD5.
        :param pulumi.Input[_builtins.bool] reject_unencrypted_access: Specifies whether to deny access from non-encrypted clients. Valid values:
               true: The file system denies access from non-encrypted clients.
               false: The file system allows access from non-encrypted clients. Default value: false.
        :param pulumi.Input[_builtins.str] super_admin_sid: The ID of a super admin. The ID must meet the following requirements:
               The ID starts with S and does not contain letters except S.
               The ID contains at least three hyphens (-) as delimiters.
               Example: S-1-5-22 and S-1-5-22-23.
        """
        if auth_method is not None:
            pulumi.set(__self__, "auth_method", auth_method)
        if enable_anonymous_access is not None:
            pulumi.set(__self__, "enable_anonymous_access", enable_anonymous_access)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if encrypt_data is not None:
            pulumi.set(__self__, "encrypt_data", encrypt_data)
        if file_system_id is not None:
            pulumi.set(__self__, "file_system_id", file_system_id)
        if home_dir_path is not None:
            pulumi.set(__self__, "home_dir_path", home_dir_path)
        if keytab is not None:
            pulumi.set(__self__, "keytab", keytab)
        if keytab_md5 is not None:
            pulumi.set(__self__, "keytab_md5", keytab_md5)
        if reject_unencrypted_access is not None:
            pulumi.set(__self__, "reject_unencrypted_access", reject_unencrypted_access)
        if super_admin_sid is not None:
            pulumi.set(__self__, "super_admin_sid", super_admin_sid)

    @_builtins.property
    @pulumi.getter(name="authMethod")
    def auth_method(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The method that is used to authenticate network identities.
        """
        return pulumi.get(self, "auth_method")

    @auth_method.setter
    def auth_method(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auth_method", value)

    @_builtins.property
    @pulumi.getter(name="enableAnonymousAccess")
    def enable_anonymous_access(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to allow anonymous access. Valid values:
        true: The file system allows anonymous access.
        false: The file system denies anonymous access. Default value: false.
        """
        return pulumi.get(self, "enable_anonymous_access")

    @enable_anonymous_access.setter
    def enable_anonymous_access(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_anonymous_access", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether to enable the ACL feature.
        true: enables the ACL feature.
        false: disables the ACL feature.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="encryptData")
    def encrypt_data(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable encryption in transit. Valid values:
        true: enables encryption in transit.
        false: disables encryption in transit. Default value: false.
        """
        return pulumi.get(self, "encrypt_data")

    @encrypt_data.setter
    def encrypt_data(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "encrypt_data", value)

    @_builtins.property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the file system.
        """
        return pulumi.get(self, "file_system_id")

    @file_system_id.setter
    def file_system_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "file_system_id", value)

    @_builtins.property
    @pulumi.getter(name="homeDirPath")
    def home_dir_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The home directory of each user. Each user-specific home directory must meet the following requirements:    
        Each segment starts with a forward slash (/) or a backslash (\\).
        Each segment does not contain the following special characters: <>":?*.
        Each segment is 0 to 255 characters in length.
        The total length is 0 to 32,767 characters.
        For example, if you create a user named A and the home directory is /home, the file system automatically creates a directory named /home/A when User A logs on to the file system. If the /home/A directory already exists, the file system does not create the directory.
        """
        return pulumi.get(self, "home_dir_path")

    @home_dir_path.setter
    def home_dir_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "home_dir_path", value)

    @_builtins.property
    @pulumi.getter
    def keytab(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The string that is generated after the system encodes the keytab file by using Base64.
        """
        return pulumi.get(self, "keytab")

    @keytab.setter
    def keytab(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "keytab", value)

    @_builtins.property
    @pulumi.getter(name="keytabMd5")
    def keytab_md5(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        RThe string that is generated after the system encodes the keytab file by using MD5.
        """
        return pulumi.get(self, "keytab_md5")

    @keytab_md5.setter
    def keytab_md5(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "keytab_md5", value)

    @_builtins.property
    @pulumi.getter(name="rejectUnencryptedAccess")
    def reject_unencrypted_access(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to deny access from non-encrypted clients. Valid values:
        true: The file system denies access from non-encrypted clients.
        false: The file system allows access from non-encrypted clients. Default value: false.
        """
        return pulumi.get(self, "reject_unencrypted_access")

    @reject_unencrypted_access.setter
    def reject_unencrypted_access(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "reject_unencrypted_access", value)

    @_builtins.property
    @pulumi.getter(name="superAdminSid")
    def super_admin_sid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of a super admin. The ID must meet the following requirements:
        The ID starts with S and does not contain letters except S.
        The ID contains at least three hyphens (-) as delimiters.
        Example: S-1-5-22 and S-1-5-22-23.
        """
        return pulumi.get(self, "super_admin_sid")

    @super_admin_sid.setter
    def super_admin_sid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "super_admin_sid", value)


@pulumi.type_token("alicloud:nas/smbAclAttachment:SmbAclAttachment")
class SmbAclAttachment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enable_anonymous_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 encrypt_data: Optional[pulumi.Input[_builtins.bool]] = None,
                 file_system_id: Optional[pulumi.Input[_builtins.str]] = None,
                 home_dir_path: Optional[pulumi.Input[_builtins.str]] = None,
                 keytab: Optional[pulumi.Input[_builtins.str]] = None,
                 keytab_md5: Optional[pulumi.Input[_builtins.str]] = None,
                 reject_unencrypted_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 super_admin_sid: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Nas Smb Acl resource.

        Alibaba Cloud SMB protocol file storage service supports user authentication based on AD domain system and permission access control at the file system level. Connecting and accessing the SMB file system as a domain user can implement the requirements for access control at the file and directory level in the SMB protocol file system. The current Alibaba Cloud SMB protocol file storage service does not support multi-user file and directory-level permission access control, and only provides file system-level authentication and access based on the whitelist mechanism that supports cloud accounts and source IP permission groups control.
        > **NOTE:** Available in 1.186.0+.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        example = alicloud.nas.get_zones(file_system_type="standard")
        example_file_system = alicloud.nas.FileSystem("example",
            protocol_type="SMB",
            storage_type="Capacity",
            description="terraform-example",
            encrypt_type=0,
            file_system_type="standard",
            zone_id=example.zones[0].zone_id)
        example_smb_acl_attachment = alicloud.nas.SmbAclAttachment("example",
            file_system_id=example_file_system.id,
            keytab="BQIAAABHAAIADUFMSUFEVEVTVC5DT00ABGNpZnMAGXNtYnNlcnZlcjI0LmFsaWFkdGVzdC5jb20AAAABAAAAAAEAAQAIqIx6v7p11oUAAABHAAIADUFMSUFEVEVTVC5DT00ABGNpZnMAGXNtYnNlcnZlcjI0LmFsaWFkdGVzdC5jb20AAAABAAAAAAEAAwAIqIx6v7p11oUAAABPAAIADUFMSUFEVEVTVC5DT00ABGNpZnMAGXNtYnNlcnZlcjI0LmFsaWFkdGVzdC5jb20AAAABAAAAAAEAFwAQnQZWB3RAPHU7PMIJyBWePAAAAF8AAgANQUxJQURURVNULkNPTQAEY2lmcwAZc21ic2VydmVyMjQuYWxpYWR0ZXN0LmNvbQAAAAEAAAAAAQASACAGJ7F0s+bcBjf6jD5HlvlRLmPSOW+qDZe0Qk0lQcf8WwAAAE8AAgANQUxJQURURVNULkNPTQAEY2lmcwAZc21ic2VydmVyMjQuYWxpYWR0ZXN0LmNvbQAAAAEAAAAAAQARABDdFmanrSIatnDDhoOXYadj",
            keytab_md5="E3CCF7E2416DF04FA958AA4513EA29E8")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] enable_anonymous_access: Specifies whether to allow anonymous access. Valid values:
               true: The file system allows anonymous access.
               false: The file system denies anonymous access. Default value: false.
        :param pulumi.Input[_builtins.bool] encrypt_data: Specifies whether to enable encryption in transit. Valid values:
               true: enables encryption in transit.
               false: disables encryption in transit. Default value: false.
        :param pulumi.Input[_builtins.str] file_system_id: The ID of the file system.
        :param pulumi.Input[_builtins.str] home_dir_path: The home directory of each user. Each user-specific home directory must meet the following requirements:    
               Each segment starts with a forward slash (/) or a backslash (\\).
               Each segment does not contain the following special characters: <>":?*.
               Each segment is 0 to 255 characters in length.
               The total length is 0 to 32,767 characters.
               For example, if you create a user named A and the home directory is /home, the file system automatically creates a directory named /home/A when User A logs on to the file system. If the /home/A directory already exists, the file system does not create the directory.
        :param pulumi.Input[_builtins.str] keytab: The string that is generated after the system encodes the keytab file by using Base64.
        :param pulumi.Input[_builtins.str] keytab_md5: RThe string that is generated after the system encodes the keytab file by using MD5.
        :param pulumi.Input[_builtins.bool] reject_unencrypted_access: Specifies whether to deny access from non-encrypted clients. Valid values:
               true: The file system denies access from non-encrypted clients.
               false: The file system allows access from non-encrypted clients. Default value: false.
        :param pulumi.Input[_builtins.str] super_admin_sid: The ID of a super admin. The ID must meet the following requirements:
               The ID starts with S and does not contain letters except S.
               The ID contains at least three hyphens (-) as delimiters.
               Example: S-1-5-22 and S-1-5-22-23.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SmbAclAttachmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Nas Smb Acl resource.

        Alibaba Cloud SMB protocol file storage service supports user authentication based on AD domain system and permission access control at the file system level. Connecting and accessing the SMB file system as a domain user can implement the requirements for access control at the file and directory level in the SMB protocol file system. The current Alibaba Cloud SMB protocol file storage service does not support multi-user file and directory-level permission access control, and only provides file system-level authentication and access based on the whitelist mechanism that supports cloud accounts and source IP permission groups control.
        > **NOTE:** Available in 1.186.0+.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        example = alicloud.nas.get_zones(file_system_type="standard")
        example_file_system = alicloud.nas.FileSystem("example",
            protocol_type="SMB",
            storage_type="Capacity",
            description="terraform-example",
            encrypt_type=0,
            file_system_type="standard",
            zone_id=example.zones[0].zone_id)
        example_smb_acl_attachment = alicloud.nas.SmbAclAttachment("example",
            file_system_id=example_file_system.id,
            keytab="BQIAAABHAAIADUFMSUFEVEVTVC5DT00ABGNpZnMAGXNtYnNlcnZlcjI0LmFsaWFkdGVzdC5jb20AAAABAAAAAAEAAQAIqIx6v7p11oUAAABHAAIADUFMSUFEVEVTVC5DT00ABGNpZnMAGXNtYnNlcnZlcjI0LmFsaWFkdGVzdC5jb20AAAABAAAAAAEAAwAIqIx6v7p11oUAAABPAAIADUFMSUFEVEVTVC5DT00ABGNpZnMAGXNtYnNlcnZlcjI0LmFsaWFkdGVzdC5jb20AAAABAAAAAAEAFwAQnQZWB3RAPHU7PMIJyBWePAAAAF8AAgANQUxJQURURVNULkNPTQAEY2lmcwAZc21ic2VydmVyMjQuYWxpYWR0ZXN0LmNvbQAAAAEAAAAAAQASACAGJ7F0s+bcBjf6jD5HlvlRLmPSOW+qDZe0Qk0lQcf8WwAAAE8AAgANQUxJQURURVNULkNPTQAEY2lmcwAZc21ic2VydmVyMjQuYWxpYWR0ZXN0LmNvbQAAAAEAAAAAAQARABDdFmanrSIatnDDhoOXYadj",
            keytab_md5="E3CCF7E2416DF04FA958AA4513EA29E8")
        ```

        :param str resource_name: The name of the resource.
        :param SmbAclAttachmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SmbAclAttachmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enable_anonymous_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 encrypt_data: Optional[pulumi.Input[_builtins.bool]] = None,
                 file_system_id: Optional[pulumi.Input[_builtins.str]] = None,
                 home_dir_path: Optional[pulumi.Input[_builtins.str]] = None,
                 keytab: Optional[pulumi.Input[_builtins.str]] = None,
                 keytab_md5: Optional[pulumi.Input[_builtins.str]] = None,
                 reject_unencrypted_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 super_admin_sid: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SmbAclAttachmentArgs.__new__(SmbAclAttachmentArgs)

            __props__.__dict__["enable_anonymous_access"] = enable_anonymous_access
            __props__.__dict__["encrypt_data"] = encrypt_data
            if file_system_id is None and not opts.urn:
                raise TypeError("Missing required property 'file_system_id'")
            __props__.__dict__["file_system_id"] = file_system_id
            __props__.__dict__["home_dir_path"] = home_dir_path
            if keytab is None and not opts.urn:
                raise TypeError("Missing required property 'keytab'")
            __props__.__dict__["keytab"] = keytab
            if keytab_md5 is None and not opts.urn:
                raise TypeError("Missing required property 'keytab_md5'")
            __props__.__dict__["keytab_md5"] = keytab_md5
            __props__.__dict__["reject_unencrypted_access"] = reject_unencrypted_access
            __props__.__dict__["super_admin_sid"] = super_admin_sid
            __props__.__dict__["auth_method"] = None
            __props__.__dict__["enabled"] = None
        super(SmbAclAttachment, __self__).__init__(
            'alicloud:nas/smbAclAttachment:SmbAclAttachment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auth_method: Optional[pulumi.Input[_builtins.str]] = None,
            enable_anonymous_access: Optional[pulumi.Input[_builtins.bool]] = None,
            enabled: Optional[pulumi.Input[_builtins.str]] = None,
            encrypt_data: Optional[pulumi.Input[_builtins.bool]] = None,
            file_system_id: Optional[pulumi.Input[_builtins.str]] = None,
            home_dir_path: Optional[pulumi.Input[_builtins.str]] = None,
            keytab: Optional[pulumi.Input[_builtins.str]] = None,
            keytab_md5: Optional[pulumi.Input[_builtins.str]] = None,
            reject_unencrypted_access: Optional[pulumi.Input[_builtins.bool]] = None,
            super_admin_sid: Optional[pulumi.Input[_builtins.str]] = None) -> 'SmbAclAttachment':
        """
        Get an existing SmbAclAttachment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] auth_method: The method that is used to authenticate network identities.
        :param pulumi.Input[_builtins.bool] enable_anonymous_access: Specifies whether to allow anonymous access. Valid values:
               true: The file system allows anonymous access.
               false: The file system denies anonymous access. Default value: false.
        :param pulumi.Input[_builtins.str] enabled: Specifies whether to enable the ACL feature.
               true: enables the ACL feature.
               false: disables the ACL feature.
        :param pulumi.Input[_builtins.bool] encrypt_data: Specifies whether to enable encryption in transit. Valid values:
               true: enables encryption in transit.
               false: disables encryption in transit. Default value: false.
        :param pulumi.Input[_builtins.str] file_system_id: The ID of the file system.
        :param pulumi.Input[_builtins.str] home_dir_path: The home directory of each user. Each user-specific home directory must meet the following requirements:    
               Each segment starts with a forward slash (/) or a backslash (\\).
               Each segment does not contain the following special characters: <>":?*.
               Each segment is 0 to 255 characters in length.
               The total length is 0 to 32,767 characters.
               For example, if you create a user named A and the home directory is /home, the file system automatically creates a directory named /home/A when User A logs on to the file system. If the /home/A directory already exists, the file system does not create the directory.
        :param pulumi.Input[_builtins.str] keytab: The string that is generated after the system encodes the keytab file by using Base64.
        :param pulumi.Input[_builtins.str] keytab_md5: RThe string that is generated after the system encodes the keytab file by using MD5.
        :param pulumi.Input[_builtins.bool] reject_unencrypted_access: Specifies whether to deny access from non-encrypted clients. Valid values:
               true: The file system denies access from non-encrypted clients.
               false: The file system allows access from non-encrypted clients. Default value: false.
        :param pulumi.Input[_builtins.str] super_admin_sid: The ID of a super admin. The ID must meet the following requirements:
               The ID starts with S and does not contain letters except S.
               The ID contains at least three hyphens (-) as delimiters.
               Example: S-1-5-22 and S-1-5-22-23.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SmbAclAttachmentState.__new__(_SmbAclAttachmentState)

        __props__.__dict__["auth_method"] = auth_method
        __props__.__dict__["enable_anonymous_access"] = enable_anonymous_access
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["encrypt_data"] = encrypt_data
        __props__.__dict__["file_system_id"] = file_system_id
        __props__.__dict__["home_dir_path"] = home_dir_path
        __props__.__dict__["keytab"] = keytab
        __props__.__dict__["keytab_md5"] = keytab_md5
        __props__.__dict__["reject_unencrypted_access"] = reject_unencrypted_access
        __props__.__dict__["super_admin_sid"] = super_admin_sid
        return SmbAclAttachment(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="authMethod")
    def auth_method(self) -> pulumi.Output[_builtins.str]:
        """
        The method that is used to authenticate network identities.
        """
        return pulumi.get(self, "auth_method")

    @_builtins.property
    @pulumi.getter(name="enableAnonymousAccess")
    def enable_anonymous_access(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to allow anonymous access. Valid values:
        true: The file system allows anonymous access.
        false: The file system denies anonymous access. Default value: false.
        """
        return pulumi.get(self, "enable_anonymous_access")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies whether to enable the ACL feature.
        true: enables the ACL feature.
        false: disables the ACL feature.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="encryptData")
    def encrypt_data(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to enable encryption in transit. Valid values:
        true: enables encryption in transit.
        false: disables encryption in transit. Default value: false.
        """
        return pulumi.get(self, "encrypt_data")

    @_builtins.property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the file system.
        """
        return pulumi.get(self, "file_system_id")

    @_builtins.property
    @pulumi.getter(name="homeDirPath")
    def home_dir_path(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The home directory of each user. Each user-specific home directory must meet the following requirements:    
        Each segment starts with a forward slash (/) or a backslash (\\).
        Each segment does not contain the following special characters: <>":?*.
        Each segment is 0 to 255 characters in length.
        The total length is 0 to 32,767 characters.
        For example, if you create a user named A and the home directory is /home, the file system automatically creates a directory named /home/A when User A logs on to the file system. If the /home/A directory already exists, the file system does not create the directory.
        """
        return pulumi.get(self, "home_dir_path")

    @_builtins.property
    @pulumi.getter
    def keytab(self) -> pulumi.Output[_builtins.str]:
        """
        The string that is generated after the system encodes the keytab file by using Base64.
        """
        return pulumi.get(self, "keytab")

    @_builtins.property
    @pulumi.getter(name="keytabMd5")
    def keytab_md5(self) -> pulumi.Output[_builtins.str]:
        """
        RThe string that is generated after the system encodes the keytab file by using MD5.
        """
        return pulumi.get(self, "keytab_md5")

    @_builtins.property
    @pulumi.getter(name="rejectUnencryptedAccess")
    def reject_unencrypted_access(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to deny access from non-encrypted clients. Valid values:
        true: The file system denies access from non-encrypted clients.
        false: The file system allows access from non-encrypted clients. Default value: false.
        """
        return pulumi.get(self, "reject_unencrypted_access")

    @_builtins.property
    @pulumi.getter(name="superAdminSid")
    def super_admin_sid(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of a super admin. The ID must meet the following requirements:
        The ID starts with S and does not contain letters except S.
        The ID contains at least three hyphens (-) as delimiters.
        Example: S-1-5-22 and S-1-5-22-23.
        """
        return pulumi.get(self, "super_admin_sid")

