# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ListenerProxyProtocolConfig',
    'LoadBalancerDeletionProtectionConfig',
    'LoadBalancerModificationProtectionConfig',
    'LoadBalancerZoneMapping',
    'ServerGroupHealthCheck',
    'GetListenersListenerResult',
    'GetLoadBalancersBalancerResult',
    'GetLoadBalancersBalancerOperationLockResult',
    'GetLoadBalancersBalancerZoneMappingResult',
    'GetSecurityPoliciesPolicyResult',
    'GetServerGroupServerAttachmentsAttachmentResult',
    'GetServerGroupsGroupResult',
    'GetServerGroupsGroupHealthCheckResult',
    'GetZonesZoneResult',
]

@pulumi.output_type
class ListenerProxyProtocolConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "proxyProtocolConfigPrivateLinkEpIdEnabled":
            suggest = "proxy_protocol_config_private_link_ep_id_enabled"
        elif key == "proxyProtocolConfigPrivateLinkEpsIdEnabled":
            suggest = "proxy_protocol_config_private_link_eps_id_enabled"
        elif key == "proxyProtocolConfigVpcIdEnabled":
            suggest = "proxy_protocol_config_vpc_id_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ListenerProxyProtocolConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ListenerProxyProtocolConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ListenerProxyProtocolConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 proxy_protocol_config_private_link_ep_id_enabled: Optional[_builtins.bool] = None,
                 proxy_protocol_config_private_link_eps_id_enabled: Optional[_builtins.bool] = None,
                 proxy_protocol_config_vpc_id_enabled: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool proxy_protocol_config_private_link_ep_id_enabled: Whether to enable carrying PrivateLinkEpId to backend servers through Proxy Protocol.
        :param _builtins.bool proxy_protocol_config_private_link_eps_id_enabled: Whether to enable carrying PrivateLinkEpsId to backend servers through the Proxy Protocol.
        :param _builtins.bool proxy_protocol_config_vpc_id_enabled: Whether to enable carrying VpcId to backend servers through Proxy Protocol.
        """
        if proxy_protocol_config_private_link_ep_id_enabled is not None:
            pulumi.set(__self__, "proxy_protocol_config_private_link_ep_id_enabled", proxy_protocol_config_private_link_ep_id_enabled)
        if proxy_protocol_config_private_link_eps_id_enabled is not None:
            pulumi.set(__self__, "proxy_protocol_config_private_link_eps_id_enabled", proxy_protocol_config_private_link_eps_id_enabled)
        if proxy_protocol_config_vpc_id_enabled is not None:
            pulumi.set(__self__, "proxy_protocol_config_vpc_id_enabled", proxy_protocol_config_vpc_id_enabled)

    @_builtins.property
    @pulumi.getter(name="proxyProtocolConfigPrivateLinkEpIdEnabled")
    def proxy_protocol_config_private_link_ep_id_enabled(self) -> Optional[_builtins.bool]:
        """
        Whether to enable carrying PrivateLinkEpId to backend servers through Proxy Protocol.
        """
        return pulumi.get(self, "proxy_protocol_config_private_link_ep_id_enabled")

    @_builtins.property
    @pulumi.getter(name="proxyProtocolConfigPrivateLinkEpsIdEnabled")
    def proxy_protocol_config_private_link_eps_id_enabled(self) -> Optional[_builtins.bool]:
        """
        Whether to enable carrying PrivateLinkEpsId to backend servers through the Proxy Protocol.
        """
        return pulumi.get(self, "proxy_protocol_config_private_link_eps_id_enabled")

    @_builtins.property
    @pulumi.getter(name="proxyProtocolConfigVpcIdEnabled")
    def proxy_protocol_config_vpc_id_enabled(self) -> Optional[_builtins.bool]:
        """
        Whether to enable carrying VpcId to backend servers through Proxy Protocol.
        """
        return pulumi.get(self, "proxy_protocol_config_vpc_id_enabled")


@pulumi.output_type
class LoadBalancerDeletionProtectionConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enabledTime":
            suggest = "enabled_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadBalancerDeletionProtectionConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadBalancerDeletionProtectionConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadBalancerDeletionProtectionConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: Optional[_builtins.bool] = None,
                 enabled_time: Optional[_builtins.str] = None,
                 reason: Optional[_builtins.str] = None):
        """
        :param _builtins.bool enabled: Specifies whether to enable deletion protection. Valid values:
        :param _builtins.str enabled_time: Opening time of the configuration read-only mode.
        :param _builtins.str reason: The reason why deletion protection is enabled. The reason must be 2 to 128 characters in length, and can contain letters, digits, periods (.), underscores (\\_), and hyphens (-). The reason must start with a letter.
               
               
               > **NOTE:**  This parameter takes effect only when `DeletionProtectionEnabled` is set to `true`.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if enabled_time is not None:
            pulumi.set(__self__, "enabled_time", enabled_time)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        Specifies whether to enable deletion protection. Valid values:
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="enabledTime")
    def enabled_time(self) -> Optional[_builtins.str]:
        """
        Opening time of the configuration read-only mode.
        """
        return pulumi.get(self, "enabled_time")

    @_builtins.property
    @pulumi.getter
    def reason(self) -> Optional[_builtins.str]:
        """
        The reason why deletion protection is enabled. The reason must be 2 to 128 characters in length, and can contain letters, digits, periods (.), underscores (\\_), and hyphens (-). The reason must start with a letter.


        > **NOTE:**  This parameter takes effect only when `DeletionProtectionEnabled` is set to `true`.
        """
        return pulumi.get(self, "reason")


@pulumi.output_type
class LoadBalancerModificationProtectionConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enabledTime":
            suggest = "enabled_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadBalancerModificationProtectionConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadBalancerModificationProtectionConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadBalancerModificationProtectionConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled_time: Optional[_builtins.str] = None,
                 reason: Optional[_builtins.str] = None,
                 status: Optional[_builtins.str] = None):
        """
        :param _builtins.str enabled_time: Opening time of the configuration read-only mode.
        :param _builtins.str reason: The reason why the configuration read-only mode is enabled. The value must be 2 to 128 characters in length, and can contain letters, digits, periods (.), underscores (\\_), and hyphens (-). The value must start with a letter.
               
               > **NOTE:**   This parameter takes effect only if the `status` parameter is set to `ConsoleProtection`.
        :param _builtins.str status: Specifies whether to enable the configuration read-only mode. Valid values:
               - `NonProtection`: disables the configuration read-only mode. In this case, you cannot set the `ModificationProtectionReason` parameter. If you specify `ModificationProtectionReason`, the value is cleared.
               - `ConsoleProtection`: enables the configuration read-only mode. In this case, you can specify `ModificationProtectionReason`.
               
               > **NOTE:**  If you set this parameter to `ConsoleProtection`, you cannot use the NLB console to modify instance configurations. However, you can call API operations to modify instance configurations.
        """
        if enabled_time is not None:
            pulumi.set(__self__, "enabled_time", enabled_time)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="enabledTime")
    def enabled_time(self) -> Optional[_builtins.str]:
        """
        Opening time of the configuration read-only mode.
        """
        return pulumi.get(self, "enabled_time")

    @_builtins.property
    @pulumi.getter
    def reason(self) -> Optional[_builtins.str]:
        """
        The reason why the configuration read-only mode is enabled. The value must be 2 to 128 characters in length, and can contain letters, digits, periods (.), underscores (\\_), and hyphens (-). The value must start with a letter.

        > **NOTE:**   This parameter takes effect only if the `status` parameter is set to `ConsoleProtection`.
        """
        return pulumi.get(self, "reason")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        Specifies whether to enable the configuration read-only mode. Valid values:
        - `NonProtection`: disables the configuration read-only mode. In this case, you cannot set the `ModificationProtectionReason` parameter. If you specify `ModificationProtectionReason`, the value is cleared.
        - `ConsoleProtection`: enables the configuration read-only mode. In this case, you can specify `ModificationProtectionReason`.

        > **NOTE:**  If you set this parameter to `ConsoleProtection`, you cannot use the NLB console to modify instance configurations. However, you can call API operations to modify instance configurations.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class LoadBalancerZoneMapping(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "vswitchId":
            suggest = "vswitch_id"
        elif key == "zoneId":
            suggest = "zone_id"
        elif key == "allocationId":
            suggest = "allocation_id"
        elif key == "eniId":
            suggest = "eni_id"
        elif key == "ipv4LocalAddresses":
            suggest = "ipv4_local_addresses"
        elif key == "ipv6Address":
            suggest = "ipv6_address"
        elif key == "ipv6LocalAddresses":
            suggest = "ipv6_local_addresses"
        elif key == "privateIpv4Address":
            suggest = "private_ipv4_address"
        elif key == "publicIpv4Address":
            suggest = "public_ipv4_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadBalancerZoneMapping. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadBalancerZoneMapping.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadBalancerZoneMapping.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 vswitch_id: _builtins.str,
                 zone_id: _builtins.str,
                 allocation_id: Optional[_builtins.str] = None,
                 eni_id: Optional[_builtins.str] = None,
                 ipv4_local_addresses: Optional[Sequence[_builtins.str]] = None,
                 ipv6_address: Optional[_builtins.str] = None,
                 ipv6_local_addresses: Optional[Sequence[_builtins.str]] = None,
                 private_ipv4_address: Optional[_builtins.str] = None,
                 public_ipv4_address: Optional[_builtins.str] = None,
                 status: Optional[_builtins.str] = None):
        """
        :param _builtins.str vswitch_id: The vSwitch in the zone. You can specify only one vSwitch (subnet) in each zone of an NLB instance. You must add at least two zones. You can add a maximum of 10 zones.
        :param _builtins.str zone_id: The ID of the zone of the NLB instance. You must add at least two zones. You can add a maximum of 10 zones.
               You can call the [DescribeZones](https://www.alibabacloud.com/help/en/doc-detail/443890.html) operation to query the most recent zone list.
        :param _builtins.str allocation_id: The ID of the elastic IP address (EIP) that is associated with the Internet-facing NLB instance. You can specify one EIP for each zone. You must add at least two zones. You can add a maximum of 10 zones.
        :param _builtins.str eni_id: The ID of the elastic network interface (ENI).
        :param Sequence[_builtins.str] ipv4_local_addresses: IPv4 Local address list. The list of addresses that NLB interacts with backend services.
        :param _builtins.str ipv6_address: The IPv6 address of the NLB instance.
        :param Sequence[_builtins.str] ipv6_local_addresses: IPv6 Local address list. The list of addresses that NLB interacts with backend services.
        :param _builtins.str private_ipv4_address: The private IP address. You must add at least two zones. You can add a maximum of 10 zones.
        :param _builtins.str public_ipv4_address: The public IPv4 address of the NLB instance.
        :param _builtins.str status: Zone Status
        """
        pulumi.set(__self__, "vswitch_id", vswitch_id)
        pulumi.set(__self__, "zone_id", zone_id)
        if allocation_id is not None:
            pulumi.set(__self__, "allocation_id", allocation_id)
        if eni_id is not None:
            pulumi.set(__self__, "eni_id", eni_id)
        if ipv4_local_addresses is not None:
            pulumi.set(__self__, "ipv4_local_addresses", ipv4_local_addresses)
        if ipv6_address is not None:
            pulumi.set(__self__, "ipv6_address", ipv6_address)
        if ipv6_local_addresses is not None:
            pulumi.set(__self__, "ipv6_local_addresses", ipv6_local_addresses)
        if private_ipv4_address is not None:
            pulumi.set(__self__, "private_ipv4_address", private_ipv4_address)
        if public_ipv4_address is not None:
            pulumi.set(__self__, "public_ipv4_address", public_ipv4_address)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> _builtins.str:
        """
        The vSwitch in the zone. You can specify only one vSwitch (subnet) in each zone of an NLB instance. You must add at least two zones. You can add a maximum of 10 zones.
        """
        return pulumi.get(self, "vswitch_id")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> _builtins.str:
        """
        The ID of the zone of the NLB instance. You must add at least two zones. You can add a maximum of 10 zones.
        You can call the [DescribeZones](https://www.alibabacloud.com/help/en/doc-detail/443890.html) operation to query the most recent zone list.
        """
        return pulumi.get(self, "zone_id")

    @_builtins.property
    @pulumi.getter(name="allocationId")
    def allocation_id(self) -> Optional[_builtins.str]:
        """
        The ID of the elastic IP address (EIP) that is associated with the Internet-facing NLB instance. You can specify one EIP for each zone. You must add at least two zones. You can add a maximum of 10 zones.
        """
        return pulumi.get(self, "allocation_id")

    @_builtins.property
    @pulumi.getter(name="eniId")
    def eni_id(self) -> Optional[_builtins.str]:
        """
        The ID of the elastic network interface (ENI).
        """
        return pulumi.get(self, "eni_id")

    @_builtins.property
    @pulumi.getter(name="ipv4LocalAddresses")
    def ipv4_local_addresses(self) -> Optional[Sequence[_builtins.str]]:
        """
        IPv4 Local address list. The list of addresses that NLB interacts with backend services.
        """
        return pulumi.get(self, "ipv4_local_addresses")

    @_builtins.property
    @pulumi.getter(name="ipv6Address")
    def ipv6_address(self) -> Optional[_builtins.str]:
        """
        The IPv6 address of the NLB instance.
        """
        return pulumi.get(self, "ipv6_address")

    @_builtins.property
    @pulumi.getter(name="ipv6LocalAddresses")
    def ipv6_local_addresses(self) -> Optional[Sequence[_builtins.str]]:
        """
        IPv6 Local address list. The list of addresses that NLB interacts with backend services.
        """
        return pulumi.get(self, "ipv6_local_addresses")

    @_builtins.property
    @pulumi.getter(name="privateIpv4Address")
    def private_ipv4_address(self) -> Optional[_builtins.str]:
        """
        The private IP address. You must add at least two zones. You can add a maximum of 10 zones.
        """
        return pulumi.get(self, "private_ipv4_address")

    @_builtins.property
    @pulumi.getter(name="publicIpv4Address")
    def public_ipv4_address(self) -> Optional[_builtins.str]:
        """
        The public IPv4 address of the NLB instance.
        """
        return pulumi.get(self, "public_ipv4_address")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        Zone Status
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class ServerGroupHealthCheck(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "healthCheckConnectPort":
            suggest = "health_check_connect_port"
        elif key == "healthCheckConnectTimeout":
            suggest = "health_check_connect_timeout"
        elif key == "healthCheckDomain":
            suggest = "health_check_domain"
        elif key == "healthCheckEnabled":
            suggest = "health_check_enabled"
        elif key == "healthCheckExp":
            suggest = "health_check_exp"
        elif key == "healthCheckHttpCodes":
            suggest = "health_check_http_codes"
        elif key == "healthCheckInterval":
            suggest = "health_check_interval"
        elif key == "healthCheckReq":
            suggest = "health_check_req"
        elif key == "healthCheckType":
            suggest = "health_check_type"
        elif key == "healthCheckUrl":
            suggest = "health_check_url"
        elif key == "healthyThreshold":
            suggest = "healthy_threshold"
        elif key == "httpCheckMethod":
            suggest = "http_check_method"
        elif key == "unhealthyThreshold":
            suggest = "unhealthy_threshold"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerGroupHealthCheck. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerGroupHealthCheck.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerGroupHealthCheck.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 health_check_connect_port: Optional[_builtins.int] = None,
                 health_check_connect_timeout: Optional[_builtins.int] = None,
                 health_check_domain: Optional[_builtins.str] = None,
                 health_check_enabled: Optional[_builtins.bool] = None,
                 health_check_exp: Optional[_builtins.str] = None,
                 health_check_http_codes: Optional[Sequence[_builtins.str]] = None,
                 health_check_interval: Optional[_builtins.int] = None,
                 health_check_req: Optional[_builtins.str] = None,
                 health_check_type: Optional[_builtins.str] = None,
                 health_check_url: Optional[_builtins.str] = None,
                 healthy_threshold: Optional[_builtins.int] = None,
                 http_check_method: Optional[_builtins.str] = None,
                 unhealthy_threshold: Optional[_builtins.int] = None):
        """
        :param _builtins.int health_check_connect_port: The port that you want to use for health checks on backend servers.
               Valid values: `0` to `65535`.
               Default value: `0`. If you set the value to 0, the port of the backend server is used for health checks.
        :param _builtins.int health_check_connect_timeout: The maximum timeout period of a health check. Unit: seconds. Valid values: `1` to `300`. Default value: `5`.
        :param _builtins.str health_check_domain: The domain name that you want to use for health checks. Valid values:
               - `$SERVER_IP`: the private IP address of a backend server.
        :param _builtins.bool health_check_enabled: Specifies whether to enable the health check feature. Valid values:
        :param _builtins.str health_check_exp: health check response character string. The value contains a maximum of 512 characters
        :param Sequence[_builtins.str] health_check_http_codes: The HTTP status codes to return for health checks. Separate multiple HTTP status codes with commas (,). Valid values: `http\\_2xx` (default), `http\\_3xx`, `http\\_4xx`, and `http\\_5xx`.
               
               > **NOTE:**  This parameter takes effect only when `HealthCheckType` is set to `HTTP`.
        :param _builtins.int health_check_interval: The interval at which health checks are performed. Unit: seconds.
               Valid values: `5` to `50`.
               Default value: `10`.
        :param _builtins.str health_check_req: UDP healthy check request string, the value is a character string of 512 characters
        :param _builtins.str health_check_type: The protocol that you want to use for health checks. Valid values: `TCP` (default) and `HTTP`.
        :param _builtins.str health_check_url: The path to which health check requests are sent.
               
               The path must be 1 to 80 characters in length, and can contain only letters, digits, and the following special characters: `- / . % ? # & =`. It can also contain the following extended characters: `_ ; ~ ! ( ) * [ ] @ $ ^ : ' , +`. The path must start with a forward slash (/).
               
               > **NOTE:**  This parameter takes effect only when `HealthCheckType` is set to `HTTP`.
        :param _builtins.int healthy_threshold: The number of times that an unhealthy backend server must consecutively pass health checks before it is declared healthy. In this case, the health status changes from `fail` to `success`.
               Valid values: `2` to `10`.
               Default value: `2`.
        :param _builtins.str http_check_method: The HTTP method that is used for health checks. Valid values: `GET` (default) and `HEAD`.
               
               > **NOTE:**  This parameter takes effect only when `HealthCheckType` is set to `HTTP`.
        :param _builtins.int unhealthy_threshold: The number of times that a healthy backend server must consecutively fail health checks before it is declared unhealthy. In this case, the health status changes from `success` to `fail`.
               Valid values: `2` to `10`.
               Default value: `2`.
        """
        if health_check_connect_port is not None:
            pulumi.set(__self__, "health_check_connect_port", health_check_connect_port)
        if health_check_connect_timeout is not None:
            pulumi.set(__self__, "health_check_connect_timeout", health_check_connect_timeout)
        if health_check_domain is not None:
            pulumi.set(__self__, "health_check_domain", health_check_domain)
        if health_check_enabled is not None:
            pulumi.set(__self__, "health_check_enabled", health_check_enabled)
        if health_check_exp is not None:
            pulumi.set(__self__, "health_check_exp", health_check_exp)
        if health_check_http_codes is not None:
            pulumi.set(__self__, "health_check_http_codes", health_check_http_codes)
        if health_check_interval is not None:
            pulumi.set(__self__, "health_check_interval", health_check_interval)
        if health_check_req is not None:
            pulumi.set(__self__, "health_check_req", health_check_req)
        if health_check_type is not None:
            pulumi.set(__self__, "health_check_type", health_check_type)
        if health_check_url is not None:
            pulumi.set(__self__, "health_check_url", health_check_url)
        if healthy_threshold is not None:
            pulumi.set(__self__, "healthy_threshold", healthy_threshold)
        if http_check_method is not None:
            pulumi.set(__self__, "http_check_method", http_check_method)
        if unhealthy_threshold is not None:
            pulumi.set(__self__, "unhealthy_threshold", unhealthy_threshold)

    @_builtins.property
    @pulumi.getter(name="healthCheckConnectPort")
    def health_check_connect_port(self) -> Optional[_builtins.int]:
        """
        The port that you want to use for health checks on backend servers.
        Valid values: `0` to `65535`.
        Default value: `0`. If you set the value to 0, the port of the backend server is used for health checks.
        """
        return pulumi.get(self, "health_check_connect_port")

    @_builtins.property
    @pulumi.getter(name="healthCheckConnectTimeout")
    def health_check_connect_timeout(self) -> Optional[_builtins.int]:
        """
        The maximum timeout period of a health check. Unit: seconds. Valid values: `1` to `300`. Default value: `5`.
        """
        return pulumi.get(self, "health_check_connect_timeout")

    @_builtins.property
    @pulumi.getter(name="healthCheckDomain")
    def health_check_domain(self) -> Optional[_builtins.str]:
        """
        The domain name that you want to use for health checks. Valid values:
        - `$SERVER_IP`: the private IP address of a backend server.
        """
        return pulumi.get(self, "health_check_domain")

    @_builtins.property
    @pulumi.getter(name="healthCheckEnabled")
    def health_check_enabled(self) -> Optional[_builtins.bool]:
        """
        Specifies whether to enable the health check feature. Valid values:
        """
        return pulumi.get(self, "health_check_enabled")

    @_builtins.property
    @pulumi.getter(name="healthCheckExp")
    def health_check_exp(self) -> Optional[_builtins.str]:
        """
        health check response character string. The value contains a maximum of 512 characters
        """
        return pulumi.get(self, "health_check_exp")

    @_builtins.property
    @pulumi.getter(name="healthCheckHttpCodes")
    def health_check_http_codes(self) -> Optional[Sequence[_builtins.str]]:
        """
        The HTTP status codes to return for health checks. Separate multiple HTTP status codes with commas (,). Valid values: `http\\_2xx` (default), `http\\_3xx`, `http\\_4xx`, and `http\\_5xx`.

        > **NOTE:**  This parameter takes effect only when `HealthCheckType` is set to `HTTP`.
        """
        return pulumi.get(self, "health_check_http_codes")

    @_builtins.property
    @pulumi.getter(name="healthCheckInterval")
    def health_check_interval(self) -> Optional[_builtins.int]:
        """
        The interval at which health checks are performed. Unit: seconds.
        Valid values: `5` to `50`.
        Default value: `10`.
        """
        return pulumi.get(self, "health_check_interval")

    @_builtins.property
    @pulumi.getter(name="healthCheckReq")
    def health_check_req(self) -> Optional[_builtins.str]:
        """
        UDP healthy check request string, the value is a character string of 512 characters
        """
        return pulumi.get(self, "health_check_req")

    @_builtins.property
    @pulumi.getter(name="healthCheckType")
    def health_check_type(self) -> Optional[_builtins.str]:
        """
        The protocol that you want to use for health checks. Valid values: `TCP` (default) and `HTTP`.
        """
        return pulumi.get(self, "health_check_type")

    @_builtins.property
    @pulumi.getter(name="healthCheckUrl")
    def health_check_url(self) -> Optional[_builtins.str]:
        """
        The path to which health check requests are sent.

        The path must be 1 to 80 characters in length, and can contain only letters, digits, and the following special characters: `- / . % ? # & =`. It can also contain the following extended characters: `_ ; ~ ! ( ) * [ ] @ $ ^ : ' , +`. The path must start with a forward slash (/).

        > **NOTE:**  This parameter takes effect only when `HealthCheckType` is set to `HTTP`.
        """
        return pulumi.get(self, "health_check_url")

    @_builtins.property
    @pulumi.getter(name="healthyThreshold")
    def healthy_threshold(self) -> Optional[_builtins.int]:
        """
        The number of times that an unhealthy backend server must consecutively pass health checks before it is declared healthy. In this case, the health status changes from `fail` to `success`.
        Valid values: `2` to `10`.
        Default value: `2`.
        """
        return pulumi.get(self, "healthy_threshold")

    @_builtins.property
    @pulumi.getter(name="httpCheckMethod")
    def http_check_method(self) -> Optional[_builtins.str]:
        """
        The HTTP method that is used for health checks. Valid values: `GET` (default) and `HEAD`.

        > **NOTE:**  This parameter takes effect only when `HealthCheckType` is set to `HTTP`.
        """
        return pulumi.get(self, "http_check_method")

    @_builtins.property
    @pulumi.getter(name="unhealthyThreshold")
    def unhealthy_threshold(self) -> Optional[_builtins.int]:
        """
        The number of times that a healthy backend server must consecutively fail health checks before it is declared unhealthy. In this case, the health status changes from `success` to `fail`.
        Valid values: `2` to `10`.
        Default value: `2`.
        """
        return pulumi.get(self, "unhealthy_threshold")


@pulumi.output_type
class GetListenersListenerResult(dict):
    def __init__(__self__, *,
                 alpn_enabled: _builtins.bool,
                 alpn_policy: _builtins.str,
                 ca_certificate_ids: Sequence[_builtins.str],
                 ca_enabled: _builtins.bool,
                 certificate_ids: Sequence[_builtins.str],
                 cps: _builtins.int,
                 end_port: _builtins.str,
                 id: _builtins.str,
                 idle_timeout: _builtins.int,
                 listener_description: _builtins.str,
                 listener_id: _builtins.str,
                 listener_port: _builtins.int,
                 listener_protocol: _builtins.str,
                 load_balancer_id: _builtins.str,
                 mss: _builtins.int,
                 proxy_protocol_enabled: _builtins.bool,
                 sec_sensor_enabled: _builtins.bool,
                 security_policy_id: _builtins.str,
                 server_group_id: _builtins.str,
                 start_port: _builtins.str,
                 status: _builtins.str):
        """
        :param _builtins.bool alpn_enabled: ndicates whether Application-Layer Protocol Negotiation (ALPN) is enabled.
        :param _builtins.str alpn_policy: The ALPN policy.
        :param Sequence[_builtins.str] ca_certificate_ids: CA certificate list information. Currently, only one CA certificate can be added. **NOTE:** This parameter only takes effect for `TCPSSL` listeners.
        :param _builtins.bool ca_enabled: Whether to start two-way authentication.
        :param Sequence[_builtins.str] certificate_ids: Server certificate list information. Currently, only one server certificate can be added. This parameter only takes effect for `TCPSSL` listeners.
        :param _builtins.int cps: The new connection speed limit for a network-based load balancing instance per second. Valid values: `0` ~ `1000000`. `0` indicates unlimited speed.
        :param _builtins.str end_port: Full port listening end port. Valid values: `0` ~ `65535`. The value of the end port is less than the start port.
        :param _builtins.str id: The ID of the Nlb Listener.
        :param _builtins.int idle_timeout: Connection idle timeout time. Unit: seconds. Valid values: `1` ~ `900`.
        :param _builtins.str listener_description: Custom listener name. The length is limited to 2 to 256 characters, supports Chinese and English letters, and can include numbers, commas (,), half-width periods (.), half-width semicolons (;), forward slashes (/), at(@), underscores (_), and dashes (-).
        :param _builtins.str listener_id: The ID of the listener.
        :param _builtins.int listener_port: Listening port. Valid values: `0` ~ `65535`. `0`: indicates that full port listening is used. When set to 0, you must configure `StartPort` and `EndPort`.
        :param _builtins.str listener_protocol: The listening protocol. Valid values: `TCP`, `UDP`, or `TCPSSL`.
        :param _builtins.str load_balancer_id: The ID of the network-based server load balancer instance.
        :param _builtins.int mss: The maximum segment size of the TCP message. Unit: Bytes. Valid values: `0` ~ `1500`. `0` indicates that the MSS value of the TCP message is not modified. only `TCP` and `TCPSSL` listeners support this field value.
        :param _builtins.bool proxy_protocol_enabled: Whether to enable the Proxy Protocol to carry the source address of the client to the backend server.
        :param _builtins.bool sec_sensor_enabled: Indicates whether fine-grained monitoring is enabled.
        :param _builtins.str security_policy_id: Security policy ID. Support system security policies and custom security policies. Valid values: `tls_cipher_policy_1_0`, `tls_cipher_policy_1_1`, `tls_cipher_policy_1_2`, `tls_cipher_policy_1_2_strict`, or `tls_cipher_policy_1_2_strict_with_1_3`. **Note:** This parameter only takes effect for `TCPSSL` listeners.
        :param _builtins.str server_group_id: The ID of the server group.
        :param _builtins.str start_port: Full Port listens to the starting port. Valid values: `0` ~ `65535`.
        :param _builtins.str status: The status of the resource.
        """
        pulumi.set(__self__, "alpn_enabled", alpn_enabled)
        pulumi.set(__self__, "alpn_policy", alpn_policy)
        pulumi.set(__self__, "ca_certificate_ids", ca_certificate_ids)
        pulumi.set(__self__, "ca_enabled", ca_enabled)
        pulumi.set(__self__, "certificate_ids", certificate_ids)
        pulumi.set(__self__, "cps", cps)
        pulumi.set(__self__, "end_port", end_port)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "idle_timeout", idle_timeout)
        pulumi.set(__self__, "listener_description", listener_description)
        pulumi.set(__self__, "listener_id", listener_id)
        pulumi.set(__self__, "listener_port", listener_port)
        pulumi.set(__self__, "listener_protocol", listener_protocol)
        pulumi.set(__self__, "load_balancer_id", load_balancer_id)
        pulumi.set(__self__, "mss", mss)
        pulumi.set(__self__, "proxy_protocol_enabled", proxy_protocol_enabled)
        pulumi.set(__self__, "sec_sensor_enabled", sec_sensor_enabled)
        pulumi.set(__self__, "security_policy_id", security_policy_id)
        pulumi.set(__self__, "server_group_id", server_group_id)
        pulumi.set(__self__, "start_port", start_port)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="alpnEnabled")
    def alpn_enabled(self) -> _builtins.bool:
        """
        ndicates whether Application-Layer Protocol Negotiation (ALPN) is enabled.
        """
        return pulumi.get(self, "alpn_enabled")

    @_builtins.property
    @pulumi.getter(name="alpnPolicy")
    def alpn_policy(self) -> _builtins.str:
        """
        The ALPN policy.
        """
        return pulumi.get(self, "alpn_policy")

    @_builtins.property
    @pulumi.getter(name="caCertificateIds")
    def ca_certificate_ids(self) -> Sequence[_builtins.str]:
        """
        CA certificate list information. Currently, only one CA certificate can be added. **NOTE:** This parameter only takes effect for `TCPSSL` listeners.
        """
        return pulumi.get(self, "ca_certificate_ids")

    @_builtins.property
    @pulumi.getter(name="caEnabled")
    def ca_enabled(self) -> _builtins.bool:
        """
        Whether to start two-way authentication.
        """
        return pulumi.get(self, "ca_enabled")

    @_builtins.property
    @pulumi.getter(name="certificateIds")
    def certificate_ids(self) -> Sequence[_builtins.str]:
        """
        Server certificate list information. Currently, only one server certificate can be added. This parameter only takes effect for `TCPSSL` listeners.
        """
        return pulumi.get(self, "certificate_ids")

    @_builtins.property
    @pulumi.getter
    def cps(self) -> _builtins.int:
        """
        The new connection speed limit for a network-based load balancing instance per second. Valid values: `0` ~ `1000000`. `0` indicates unlimited speed.
        """
        return pulumi.get(self, "cps")

    @_builtins.property
    @pulumi.getter(name="endPort")
    def end_port(self) -> _builtins.str:
        """
        Full port listening end port. Valid values: `0` ~ `65535`. The value of the end port is less than the start port.
        """
        return pulumi.get(self, "end_port")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Nlb Listener.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="idleTimeout")
    def idle_timeout(self) -> _builtins.int:
        """
        Connection idle timeout time. Unit: seconds. Valid values: `1` ~ `900`.
        """
        return pulumi.get(self, "idle_timeout")

    @_builtins.property
    @pulumi.getter(name="listenerDescription")
    def listener_description(self) -> _builtins.str:
        """
        Custom listener name. The length is limited to 2 to 256 characters, supports Chinese and English letters, and can include numbers, commas (,), half-width periods (.), half-width semicolons (;), forward slashes (/), at(@), underscores (_), and dashes (-).
        """
        return pulumi.get(self, "listener_description")

    @_builtins.property
    @pulumi.getter(name="listenerId")
    def listener_id(self) -> _builtins.str:
        """
        The ID of the listener.
        """
        return pulumi.get(self, "listener_id")

    @_builtins.property
    @pulumi.getter(name="listenerPort")
    def listener_port(self) -> _builtins.int:
        """
        Listening port. Valid values: `0` ~ `65535`. `0`: indicates that full port listening is used. When set to 0, you must configure `StartPort` and `EndPort`.
        """
        return pulumi.get(self, "listener_port")

    @_builtins.property
    @pulumi.getter(name="listenerProtocol")
    def listener_protocol(self) -> _builtins.str:
        """
        The listening protocol. Valid values: `TCP`, `UDP`, or `TCPSSL`.
        """
        return pulumi.get(self, "listener_protocol")

    @_builtins.property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> _builtins.str:
        """
        The ID of the network-based server load balancer instance.
        """
        return pulumi.get(self, "load_balancer_id")

    @_builtins.property
    @pulumi.getter
    def mss(self) -> _builtins.int:
        """
        The maximum segment size of the TCP message. Unit: Bytes. Valid values: `0` ~ `1500`. `0` indicates that the MSS value of the TCP message is not modified. only `TCP` and `TCPSSL` listeners support this field value.
        """
        return pulumi.get(self, "mss")

    @_builtins.property
    @pulumi.getter(name="proxyProtocolEnabled")
    def proxy_protocol_enabled(self) -> _builtins.bool:
        """
        Whether to enable the Proxy Protocol to carry the source address of the client to the backend server.
        """
        return pulumi.get(self, "proxy_protocol_enabled")

    @_builtins.property
    @pulumi.getter(name="secSensorEnabled")
    def sec_sensor_enabled(self) -> _builtins.bool:
        """
        Indicates whether fine-grained monitoring is enabled.
        """
        return pulumi.get(self, "sec_sensor_enabled")

    @_builtins.property
    @pulumi.getter(name="securityPolicyId")
    def security_policy_id(self) -> _builtins.str:
        """
        Security policy ID. Support system security policies and custom security policies. Valid values: `tls_cipher_policy_1_0`, `tls_cipher_policy_1_1`, `tls_cipher_policy_1_2`, `tls_cipher_policy_1_2_strict`, or `tls_cipher_policy_1_2_strict_with_1_3`. **Note:** This parameter only takes effect for `TCPSSL` listeners.
        """
        return pulumi.get(self, "security_policy_id")

    @_builtins.property
    @pulumi.getter(name="serverGroupId")
    def server_group_id(self) -> _builtins.str:
        """
        The ID of the server group.
        """
        return pulumi.get(self, "server_group_id")

    @_builtins.property
    @pulumi.getter(name="startPort")
    def start_port(self) -> _builtins.str:
        """
        Full Port listens to the starting port. Valid values: `0` ~ `65535`.
        """
        return pulumi.get(self, "start_port")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetLoadBalancersBalancerResult(dict):
    def __init__(__self__, *,
                 address_ip_version: _builtins.str,
                 address_type: _builtins.str,
                 bandwidth_package_id: _builtins.str,
                 create_time: _builtins.str,
                 cross_zone_enabled: _builtins.bool,
                 dns_name: _builtins.str,
                 id: _builtins.str,
                 ipv6_address_type: _builtins.str,
                 load_balancer_business_status: _builtins.str,
                 load_balancer_id: _builtins.str,
                 load_balancer_name: _builtins.str,
                 load_balancer_type: _builtins.str,
                 operation_locks: Sequence['outputs.GetLoadBalancersBalancerOperationLockResult'],
                 resource_group_id: _builtins.str,
                 security_group_ids: Sequence[_builtins.str],
                 status: _builtins.str,
                 vpc_id: _builtins.str,
                 zone_mappings: Sequence['outputs.GetLoadBalancersBalancerZoneMappingResult'],
                 tags: Optional[Mapping[str, _builtins.str]] = None):
        """
        :param _builtins.str address_ip_version: The IP version.
        :param _builtins.str address_type: The type of IPv4 address used by the NLB instance.
        :param _builtins.str bandwidth_package_id: The ID of the EIP bandwidth plan that is associated with the NLB instance if the NLB instance uses a public IP address.
        :param _builtins.str create_time: The time when the resource was created. The time is displayed in UTC in `yyyy-MM-ddTHH:mm:ssZ` format.
        :param _builtins.bool cross_zone_enabled: Indicates whether cross-zone load balancing is enabled for the NLB instance.
        :param _builtins.str dns_name: The domain name of the NLB instance.
        :param _builtins.str id: The ID of the NLB instance.
        :param _builtins.str ipv6_address_type: The type of IPv6 address used by the NLB instance.
        :param _builtins.str load_balancer_business_status: The business status of the NLB instance.
        :param _builtins.str load_balancer_id: The ID of the NLB instance.
        :param _builtins.str load_balancer_name: The name of the NLB instance.
        :param _builtins.str load_balancer_type: The type of the SLB instance. Only Network is supported, which indicates NLB.
        :param Sequence['GetLoadBalancersBalancerOperationLockArgs'] operation_locks: The configuration of the operation lock. This parameter takes effect if LoadBalancerBussinessStatus is Abnormal.
        :param _builtins.str resource_group_id: The ID of the resource group.
        :param Sequence[_builtins.str] security_group_ids: The security group to which the NLB instance belongs.
        :param _builtins.str status: The status of the NLB instance.
        :param _builtins.str vpc_id: The ID of the VPC where the NLB instance is deployed.
        :param Sequence['GetLoadBalancersBalancerZoneMappingArgs'] zone_mappings: The zones and the vSwitches in the zones. An NLB instance can be deployed across 2 to 10 zones.
        :param Mapping[str, _builtins.str] tags: The tag of the resource.
        """
        pulumi.set(__self__, "address_ip_version", address_ip_version)
        pulumi.set(__self__, "address_type", address_type)
        pulumi.set(__self__, "bandwidth_package_id", bandwidth_package_id)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "cross_zone_enabled", cross_zone_enabled)
        pulumi.set(__self__, "dns_name", dns_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ipv6_address_type", ipv6_address_type)
        pulumi.set(__self__, "load_balancer_business_status", load_balancer_business_status)
        pulumi.set(__self__, "load_balancer_id", load_balancer_id)
        pulumi.set(__self__, "load_balancer_name", load_balancer_name)
        pulumi.set(__self__, "load_balancer_type", load_balancer_type)
        pulumi.set(__self__, "operation_locks", operation_locks)
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        pulumi.set(__self__, "security_group_ids", security_group_ids)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "zone_mappings", zone_mappings)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="addressIpVersion")
    def address_ip_version(self) -> _builtins.str:
        """
        The IP version.
        """
        return pulumi.get(self, "address_ip_version")

    @_builtins.property
    @pulumi.getter(name="addressType")
    def address_type(self) -> _builtins.str:
        """
        The type of IPv4 address used by the NLB instance.
        """
        return pulumi.get(self, "address_type")

    @_builtins.property
    @pulumi.getter(name="bandwidthPackageId")
    def bandwidth_package_id(self) -> _builtins.str:
        """
        The ID of the EIP bandwidth plan that is associated with the NLB instance if the NLB instance uses a public IP address.
        """
        return pulumi.get(self, "bandwidth_package_id")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The time when the resource was created. The time is displayed in UTC in `yyyy-MM-ddTHH:mm:ssZ` format.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="crossZoneEnabled")
    def cross_zone_enabled(self) -> _builtins.bool:
        """
        Indicates whether cross-zone load balancing is enabled for the NLB instance.
        """
        return pulumi.get(self, "cross_zone_enabled")

    @_builtins.property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> _builtins.str:
        """
        The domain name of the NLB instance.
        """
        return pulumi.get(self, "dns_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the NLB instance.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ipv6AddressType")
    def ipv6_address_type(self) -> _builtins.str:
        """
        The type of IPv6 address used by the NLB instance.
        """
        return pulumi.get(self, "ipv6_address_type")

    @_builtins.property
    @pulumi.getter(name="loadBalancerBusinessStatus")
    def load_balancer_business_status(self) -> _builtins.str:
        """
        The business status of the NLB instance.
        """
        return pulumi.get(self, "load_balancer_business_status")

    @_builtins.property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> _builtins.str:
        """
        The ID of the NLB instance.
        """
        return pulumi.get(self, "load_balancer_id")

    @_builtins.property
    @pulumi.getter(name="loadBalancerName")
    def load_balancer_name(self) -> _builtins.str:
        """
        The name of the NLB instance.
        """
        return pulumi.get(self, "load_balancer_name")

    @_builtins.property
    @pulumi.getter(name="loadBalancerType")
    def load_balancer_type(self) -> _builtins.str:
        """
        The type of the SLB instance. Only Network is supported, which indicates NLB.
        """
        return pulumi.get(self, "load_balancer_type")

    @_builtins.property
    @pulumi.getter(name="operationLocks")
    def operation_locks(self) -> Sequence['outputs.GetLoadBalancersBalancerOperationLockResult']:
        """
        The configuration of the operation lock. This parameter takes effect if LoadBalancerBussinessStatus is Abnormal.
        """
        return pulumi.get(self, "operation_locks")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> _builtins.str:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Sequence[_builtins.str]:
        """
        The security group to which the NLB instance belongs.
        """
        return pulumi.get(self, "security_group_ids")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the NLB instance.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> _builtins.str:
        """
        The ID of the VPC where the NLB instance is deployed.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="zoneMappings")
    def zone_mappings(self) -> Sequence['outputs.GetLoadBalancersBalancerZoneMappingResult']:
        """
        The zones and the vSwitches in the zones. An NLB instance can be deployed across 2 to 10 zones.
        """
        return pulumi.get(self, "zone_mappings")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        The tag of the resource.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class GetLoadBalancersBalancerOperationLockResult(dict):
    def __init__(__self__, *,
                 lock_reason: _builtins.str,
                 lock_type: _builtins.str):
        """
        :param _builtins.str lock_reason: The reason why the NLB instance is locked.
        :param _builtins.str lock_type: The type of lock.
        """
        pulumi.set(__self__, "lock_reason", lock_reason)
        pulumi.set(__self__, "lock_type", lock_type)

    @_builtins.property
    @pulumi.getter(name="lockReason")
    def lock_reason(self) -> _builtins.str:
        """
        The reason why the NLB instance is locked.
        """
        return pulumi.get(self, "lock_reason")

    @_builtins.property
    @pulumi.getter(name="lockType")
    def lock_type(self) -> _builtins.str:
        """
        The type of lock.
        """
        return pulumi.get(self, "lock_type")


@pulumi.output_type
class GetLoadBalancersBalancerZoneMappingResult(dict):
    def __init__(__self__, *,
                 allocation_id: _builtins.str,
                 eni_id: _builtins.str,
                 ipv6_address: _builtins.str,
                 private_ipv4_address: _builtins.str,
                 public_ipv4_address: _builtins.str,
                 vswitch_id: _builtins.str,
                 zone_id: _builtins.str):
        """
        :param _builtins.str allocation_id: The ID of the elastic IP address (EIP).
        :param _builtins.str eni_id: The ID of the elastic network interface (ENI) attached to the NLB instance.
        :param _builtins.str ipv6_address: The IPv6 address of the NLB instance.
        :param _builtins.str private_ipv4_address: The private IPv4 address used by the NLB instance.
        :param _builtins.str public_ipv4_address: The public IPv4 address used by the NLB instance.
        :param _builtins.str vswitch_id: The ID of the vSwitch. By default, you can specify one vSwitch (subnet) in each zone of the NLB instance.
        :param _builtins.str zone_id: The name of the zone.
        """
        pulumi.set(__self__, "allocation_id", allocation_id)
        pulumi.set(__self__, "eni_id", eni_id)
        pulumi.set(__self__, "ipv6_address", ipv6_address)
        pulumi.set(__self__, "private_ipv4_address", private_ipv4_address)
        pulumi.set(__self__, "public_ipv4_address", public_ipv4_address)
        pulumi.set(__self__, "vswitch_id", vswitch_id)
        pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="allocationId")
    def allocation_id(self) -> _builtins.str:
        """
        The ID of the elastic IP address (EIP).
        """
        return pulumi.get(self, "allocation_id")

    @_builtins.property
    @pulumi.getter(name="eniId")
    def eni_id(self) -> _builtins.str:
        """
        The ID of the elastic network interface (ENI) attached to the NLB instance.
        """
        return pulumi.get(self, "eni_id")

    @_builtins.property
    @pulumi.getter(name="ipv6Address")
    def ipv6_address(self) -> _builtins.str:
        """
        The IPv6 address of the NLB instance.
        """
        return pulumi.get(self, "ipv6_address")

    @_builtins.property
    @pulumi.getter(name="privateIpv4Address")
    def private_ipv4_address(self) -> _builtins.str:
        """
        The private IPv4 address used by the NLB instance.
        """
        return pulumi.get(self, "private_ipv4_address")

    @_builtins.property
    @pulumi.getter(name="publicIpv4Address")
    def public_ipv4_address(self) -> _builtins.str:
        """
        The public IPv4 address used by the NLB instance.
        """
        return pulumi.get(self, "public_ipv4_address")

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> _builtins.str:
        """
        The ID of the vSwitch. By default, you can specify one vSwitch (subnet) in each zone of the NLB instance.
        """
        return pulumi.get(self, "vswitch_id")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> _builtins.str:
        """
        The name of the zone.
        """
        return pulumi.get(self, "zone_id")


@pulumi.output_type
class GetSecurityPoliciesPolicyResult(dict):
    def __init__(__self__, *,
                 ciphers: Sequence[_builtins.str],
                 id: _builtins.str,
                 resource_group_id: _builtins.str,
                 security_policy_name: _builtins.str,
                 status: _builtins.str,
                 tags: Mapping[str, _builtins.str],
                 tls_versions: Sequence[_builtins.str]):
        """
        :param Sequence[_builtins.str] ciphers: The supported cipher suites, which are determined by the TLS protocol version.
        :param _builtins.str id: The id of the TLS security policy.
        :param _builtins.str resource_group_id: The ID of the resource group.
        :param _builtins.str security_policy_name: The name of the TLS security policy.
        :param _builtins.str status: The status of the resource.
        :param Mapping[str, _builtins.str] tags: A mapping of tags to assign to the resource.
        :param Sequence[_builtins.str] tls_versions: The TLS protocol versions that are supported.
        """
        pulumi.set(__self__, "ciphers", ciphers)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        pulumi.set(__self__, "security_policy_name", security_policy_name)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "tls_versions", tls_versions)

    @_builtins.property
    @pulumi.getter
    def ciphers(self) -> Sequence[_builtins.str]:
        """
        The supported cipher suites, which are determined by the TLS protocol version.
        """
        return pulumi.get(self, "ciphers")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The id of the TLS security policy.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> _builtins.str:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="securityPolicyName")
    def security_policy_name(self) -> _builtins.str:
        """
        The name of the TLS security policy.
        """
        return pulumi.get(self, "security_policy_name")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tlsVersions")
    def tls_versions(self) -> Sequence[_builtins.str]:
        """
        The TLS protocol versions that are supported.
        """
        return pulumi.get(self, "tls_versions")


@pulumi.output_type
class GetServerGroupServerAttachmentsAttachmentResult(dict):
    def __init__(__self__, *,
                 description: _builtins.str,
                 id: _builtins.str,
                 port: _builtins.int,
                 server_group_id: _builtins.str,
                 server_id: _builtins.str,
                 server_ip: _builtins.str,
                 server_type: _builtins.str,
                 status: _builtins.str,
                 weight: _builtins.int,
                 zone_id: _builtins.str):
        """
        :param _builtins.str description: The description of the backend server.
        :param _builtins.str id: The ID of the server group. The value is formulated as `<server_group_id>:<server_id>:<server_type>:<port>`.
        :param _builtins.int port: The port used by the backend server.
        :param _builtins.str server_group_id: The ID of the server group.
        :param _builtins.str server_id: The ID of the server.
        :param _builtins.str server_ip: The IP address of the backend server.
        :param _builtins.str server_type: The type of the backend server.
        :param _builtins.str status: Indicates the status of the backend server.
        :param _builtins.int weight: The weight of the backend server.
        :param _builtins.str zone_id: The zone ID of the server.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "server_group_id", server_group_id)
        pulumi.set(__self__, "server_id", server_id)
        pulumi.set(__self__, "server_ip", server_ip)
        pulumi.set(__self__, "server_type", server_type)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "weight", weight)
        pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the backend server.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the server group. The value is formulated as `<server_group_id>:<server_id>:<server_type>:<port>`.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        The port used by the backend server.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="serverGroupId")
    def server_group_id(self) -> _builtins.str:
        """
        The ID of the server group.
        """
        return pulumi.get(self, "server_group_id")

    @_builtins.property
    @pulumi.getter(name="serverId")
    def server_id(self) -> _builtins.str:
        """
        The ID of the server.
        """
        return pulumi.get(self, "server_id")

    @_builtins.property
    @pulumi.getter(name="serverIp")
    def server_ip(self) -> _builtins.str:
        """
        The IP address of the backend server.
        """
        return pulumi.get(self, "server_ip")

    @_builtins.property
    @pulumi.getter(name="serverType")
    def server_type(self) -> _builtins.str:
        """
        The type of the backend server.
        """
        return pulumi.get(self, "server_type")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Indicates the status of the backend server.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def weight(self) -> _builtins.int:
        """
        The weight of the backend server.
        """
        return pulumi.get(self, "weight")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> _builtins.str:
        """
        The zone ID of the server.
        """
        return pulumi.get(self, "zone_id")


@pulumi.output_type
class GetServerGroupsGroupResult(dict):
    def __init__(__self__, *,
                 address_ip_version: _builtins.str,
                 connection_drain: _builtins.bool,
                 connection_drain_timeout: _builtins.int,
                 health_checks: Sequence['outputs.GetServerGroupsGroupHealthCheckResult'],
                 id: _builtins.str,
                 preserve_client_ip_enabled: _builtins.bool,
                 protocol: _builtins.str,
                 related_load_balancer_ids: Sequence[_builtins.str],
                 resource_group_id: _builtins.str,
                 scheduler: _builtins.str,
                 server_count: _builtins.int,
                 server_group_name: _builtins.str,
                 server_group_type: _builtins.str,
                 status: _builtins.str,
                 tags: Mapping[str, _builtins.str],
                 vpc_id: _builtins.str):
        """
        :param _builtins.str address_ip_version: The protocol version.
        :param _builtins.bool connection_drain: Indicates whether connection draining is enabled.
        :param _builtins.int connection_drain_timeout: The timeout period of connection draining. Unit: seconds.
        :param Sequence['GetServerGroupsGroupHealthCheckArgs'] health_checks: The configurations of health checks.
        :param _builtins.str id: The ID of the Server Group.
        :param _builtins.bool preserve_client_ip_enabled: Indicates whether client address retention is enabled.
        :param _builtins.str protocol: The protocol used to forward requests to the backend servers.
        :param Sequence[_builtins.str] related_load_balancer_ids: The NLB instance.
        :param _builtins.str resource_group_id: The ID of the resource group to which the security group belongs.
        :param _builtins.str scheduler: The routing algorithm.
        :param _builtins.int server_count: The number of server groups associated with the NLB instance.
        :param _builtins.str server_group_name: The name of the server group.
        :param _builtins.str server_group_type: The type of the server group.
        :param _builtins.str status: The status of the server group.
        :param Mapping[str, _builtins.str] tags: A mapping of tags to assign to the resource.
        :param _builtins.str vpc_id: The ID of the VPC to which the server group belongs.
        """
        pulumi.set(__self__, "address_ip_version", address_ip_version)
        pulumi.set(__self__, "connection_drain", connection_drain)
        pulumi.set(__self__, "connection_drain_timeout", connection_drain_timeout)
        pulumi.set(__self__, "health_checks", health_checks)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "preserve_client_ip_enabled", preserve_client_ip_enabled)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "related_load_balancer_ids", related_load_balancer_ids)
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        pulumi.set(__self__, "scheduler", scheduler)
        pulumi.set(__self__, "server_count", server_count)
        pulumi.set(__self__, "server_group_name", server_group_name)
        pulumi.set(__self__, "server_group_type", server_group_type)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter(name="addressIpVersion")
    def address_ip_version(self) -> _builtins.str:
        """
        The protocol version.
        """
        return pulumi.get(self, "address_ip_version")

    @_builtins.property
    @pulumi.getter(name="connectionDrain")
    def connection_drain(self) -> _builtins.bool:
        """
        Indicates whether connection draining is enabled.
        """
        return pulumi.get(self, "connection_drain")

    @_builtins.property
    @pulumi.getter(name="connectionDrainTimeout")
    def connection_drain_timeout(self) -> _builtins.int:
        """
        The timeout period of connection draining. Unit: seconds.
        """
        return pulumi.get(self, "connection_drain_timeout")

    @_builtins.property
    @pulumi.getter(name="healthChecks")
    def health_checks(self) -> Sequence['outputs.GetServerGroupsGroupHealthCheckResult']:
        """
        The configurations of health checks.
        """
        return pulumi.get(self, "health_checks")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Server Group.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="preserveClientIpEnabled")
    def preserve_client_ip_enabled(self) -> _builtins.bool:
        """
        Indicates whether client address retention is enabled.
        """
        return pulumi.get(self, "preserve_client_ip_enabled")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.str:
        """
        The protocol used to forward requests to the backend servers.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="relatedLoadBalancerIds")
    def related_load_balancer_ids(self) -> Sequence[_builtins.str]:
        """
        The NLB instance.
        """
        return pulumi.get(self, "related_load_balancer_ids")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> _builtins.str:
        """
        The ID of the resource group to which the security group belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter
    def scheduler(self) -> _builtins.str:
        """
        The routing algorithm.
        """
        return pulumi.get(self, "scheduler")

    @_builtins.property
    @pulumi.getter(name="serverCount")
    def server_count(self) -> _builtins.int:
        """
        The number of server groups associated with the NLB instance.
        """
        return pulumi.get(self, "server_count")

    @_builtins.property
    @pulumi.getter(name="serverGroupName")
    def server_group_name(self) -> _builtins.str:
        """
        The name of the server group.
        """
        return pulumi.get(self, "server_group_name")

    @_builtins.property
    @pulumi.getter(name="serverGroupType")
    def server_group_type(self) -> _builtins.str:
        """
        The type of the server group.
        """
        return pulumi.get(self, "server_group_type")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the server group.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> _builtins.str:
        """
        The ID of the VPC to which the server group belongs.
        """
        return pulumi.get(self, "vpc_id")


@pulumi.output_type
class GetServerGroupsGroupHealthCheckResult(dict):
    def __init__(__self__, *,
                 health_check_connect_port: _builtins.int,
                 health_check_connect_timeout: _builtins.int,
                 health_check_domain: _builtins.str,
                 health_check_enabled: _builtins.bool,
                 health_check_http_codes: Sequence[_builtins.str],
                 health_check_interval: _builtins.int,
                 health_check_type: _builtins.str,
                 health_check_url: _builtins.str,
                 healthy_threshold: _builtins.int,
                 http_check_method: _builtins.str,
                 unhealthy_threshold: _builtins.int):
        """
        :param _builtins.int health_check_connect_port: The backend port that is used for health checks.
        :param _builtins.int health_check_connect_timeout: The maximum timeout period of a health check response.
        :param _builtins.str health_check_domain: The domain name that is used for health checks.
        :param _builtins.bool health_check_enabled: Specifies whether to enable health checks.
        :param Sequence[_builtins.str] health_check_http_codes: The HTTP status codes returned for health checks.
        :param _builtins.int health_check_interval: The interval between two consecutive health checks.
        :param _builtins.str health_check_type: The protocol that is used for health checks.
        :param _builtins.str health_check_url: The path to which health check requests are sent.
        :param _builtins.int healthy_threshold: The number of times that an unhealthy backend server must consecutively pass health checks before it is declared healthy.
        :param _builtins.str http_check_method: The HTTP method that is used for health checks.
        :param _builtins.int unhealthy_threshold: The number of times that a healthy backend server must consecutively fail health checks before it is declared unhealthy.
        """
        pulumi.set(__self__, "health_check_connect_port", health_check_connect_port)
        pulumi.set(__self__, "health_check_connect_timeout", health_check_connect_timeout)
        pulumi.set(__self__, "health_check_domain", health_check_domain)
        pulumi.set(__self__, "health_check_enabled", health_check_enabled)
        pulumi.set(__self__, "health_check_http_codes", health_check_http_codes)
        pulumi.set(__self__, "health_check_interval", health_check_interval)
        pulumi.set(__self__, "health_check_type", health_check_type)
        pulumi.set(__self__, "health_check_url", health_check_url)
        pulumi.set(__self__, "healthy_threshold", healthy_threshold)
        pulumi.set(__self__, "http_check_method", http_check_method)
        pulumi.set(__self__, "unhealthy_threshold", unhealthy_threshold)

    @_builtins.property
    @pulumi.getter(name="healthCheckConnectPort")
    def health_check_connect_port(self) -> _builtins.int:
        """
        The backend port that is used for health checks.
        """
        return pulumi.get(self, "health_check_connect_port")

    @_builtins.property
    @pulumi.getter(name="healthCheckConnectTimeout")
    def health_check_connect_timeout(self) -> _builtins.int:
        """
        The maximum timeout period of a health check response.
        """
        return pulumi.get(self, "health_check_connect_timeout")

    @_builtins.property
    @pulumi.getter(name="healthCheckDomain")
    def health_check_domain(self) -> _builtins.str:
        """
        The domain name that is used for health checks.
        """
        return pulumi.get(self, "health_check_domain")

    @_builtins.property
    @pulumi.getter(name="healthCheckEnabled")
    def health_check_enabled(self) -> _builtins.bool:
        """
        Specifies whether to enable health checks.
        """
        return pulumi.get(self, "health_check_enabled")

    @_builtins.property
    @pulumi.getter(name="healthCheckHttpCodes")
    def health_check_http_codes(self) -> Sequence[_builtins.str]:
        """
        The HTTP status codes returned for health checks.
        """
        return pulumi.get(self, "health_check_http_codes")

    @_builtins.property
    @pulumi.getter(name="healthCheckInterval")
    def health_check_interval(self) -> _builtins.int:
        """
        The interval between two consecutive health checks.
        """
        return pulumi.get(self, "health_check_interval")

    @_builtins.property
    @pulumi.getter(name="healthCheckType")
    def health_check_type(self) -> _builtins.str:
        """
        The protocol that is used for health checks.
        """
        return pulumi.get(self, "health_check_type")

    @_builtins.property
    @pulumi.getter(name="healthCheckUrl")
    def health_check_url(self) -> _builtins.str:
        """
        The path to which health check requests are sent.
        """
        return pulumi.get(self, "health_check_url")

    @_builtins.property
    @pulumi.getter(name="healthyThreshold")
    def healthy_threshold(self) -> _builtins.int:
        """
        The number of times that an unhealthy backend server must consecutively pass health checks before it is declared healthy.
        """
        return pulumi.get(self, "healthy_threshold")

    @_builtins.property
    @pulumi.getter(name="httpCheckMethod")
    def http_check_method(self) -> _builtins.str:
        """
        The HTTP method that is used for health checks.
        """
        return pulumi.get(self, "http_check_method")

    @_builtins.property
    @pulumi.getter(name="unhealthyThreshold")
    def unhealthy_threshold(self) -> _builtins.int:
        """
        The number of times that a healthy backend server must consecutively fail health checks before it is declared unhealthy.
        """
        return pulumi.get(self, "unhealthy_threshold")


@pulumi.output_type
class GetZonesZoneResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 local_name: _builtins.str,
                 zone_id: _builtins.str):
        """
        :param _builtins.str id: The ID of zone.
        :param _builtins.str local_name: The local name.
        :param _builtins.str zone_id: The zone ID.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "local_name", local_name)
        pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of zone.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="localName")
    def local_name(self) -> _builtins.str:
        """
        The local name.
        """
        return pulumi.get(self, "local_name")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> _builtins.str:
        """
        The zone ID.
        """
        return pulumi.get(self, "zone_id")


