# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['BucketReplicationArgs', 'BucketReplication']

@pulumi.input_type
class BucketReplicationArgs:
    def __init__(__self__, *,
                 bucket: pulumi.Input[_builtins.str],
                 destination: pulumi.Input['BucketReplicationDestinationArgs'],
                 action: Optional[pulumi.Input[_builtins.str]] = None,
                 encryption_configuration: Optional[pulumi.Input['BucketReplicationEncryptionConfigurationArgs']] = None,
                 historical_object_replication: Optional[pulumi.Input[_builtins.str]] = None,
                 prefix_set: Optional[pulumi.Input['BucketReplicationPrefixSetArgs']] = None,
                 progress: Optional[pulumi.Input['BucketReplicationProgressArgs']] = None,
                 source_selection_criteria: Optional[pulumi.Input['BucketReplicationSourceSelectionCriteriaArgs']] = None,
                 sync_role: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a BucketReplication resource.
        :param pulumi.Input[_builtins.str] bucket: The name of the bucket.
        :param pulumi.Input['BucketReplicationDestinationArgs'] destination: Specifies the destination for the rule. See `destination` below.
        :param pulumi.Input[_builtins.str] action: The operations that can be synchronized to the destination bucket. You can set action to one or more of the following operation types. Valid values: `ALL`(contains PUT, DELETE, and ABORT), `PUT`, `DELETE` and `ABORT`. Defaults to `ALL`.
        :param pulumi.Input['BucketReplicationEncryptionConfigurationArgs'] encryption_configuration: Specifies the encryption configuration for the objects replicated to the destination bucket. See `encryption_configuration` below.
        :param pulumi.Input[_builtins.str] historical_object_replication: Specifies whether to replicate historical data from the source bucket to the destination bucket before data replication is enabled. Can be `enabled` or `disabled`. Defaults to `enabled`.
        :param pulumi.Input['BucketReplicationPrefixSetArgs'] prefix_set: The prefixes used to specify the object to replicate. Only objects that match the prefix are replicated to the destination bucket. See `prefix_set` below.
        :param pulumi.Input['BucketReplicationProgressArgs'] progress: Specifies the progress for querying the progress of a data replication task of a bucket.
        :param pulumi.Input['BucketReplicationSourceSelectionCriteriaArgs'] source_selection_criteria: Specifies other conditions used to filter the source objects to replicate. See `source_selection_criteria` below.
        :param pulumi.Input[_builtins.str] sync_role: Specifies the role that you authorize OSS to use to replicate data. If SSE-KMS is specified to encrypt the objects replicated to the destination bucket, it must be specified.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "destination", destination)
        if action is not None:
            pulumi.set(__self__, "action", action)
        if encryption_configuration is not None:
            pulumi.set(__self__, "encryption_configuration", encryption_configuration)
        if historical_object_replication is not None:
            pulumi.set(__self__, "historical_object_replication", historical_object_replication)
        if prefix_set is not None:
            pulumi.set(__self__, "prefix_set", prefix_set)
        if progress is not None:
            pulumi.set(__self__, "progress", progress)
        if source_selection_criteria is not None:
            pulumi.set(__self__, "source_selection_criteria", source_selection_criteria)
        if sync_role is not None:
            pulumi.set(__self__, "sync_role", sync_role)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the bucket.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "bucket", value)

    @_builtins.property
    @pulumi.getter
    def destination(self) -> pulumi.Input['BucketReplicationDestinationArgs']:
        """
        Specifies the destination for the rule. See `destination` below.
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: pulumi.Input['BucketReplicationDestinationArgs']):
        pulumi.set(self, "destination", value)

    @_builtins.property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The operations that can be synchronized to the destination bucket. You can set action to one or more of the following operation types. Valid values: `ALL`(contains PUT, DELETE, and ABORT), `PUT`, `DELETE` and `ABORT`. Defaults to `ALL`.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "action", value)

    @_builtins.property
    @pulumi.getter(name="encryptionConfiguration")
    def encryption_configuration(self) -> Optional[pulumi.Input['BucketReplicationEncryptionConfigurationArgs']]:
        """
        Specifies the encryption configuration for the objects replicated to the destination bucket. See `encryption_configuration` below.
        """
        return pulumi.get(self, "encryption_configuration")

    @encryption_configuration.setter
    def encryption_configuration(self, value: Optional[pulumi.Input['BucketReplicationEncryptionConfigurationArgs']]):
        pulumi.set(self, "encryption_configuration", value)

    @_builtins.property
    @pulumi.getter(name="historicalObjectReplication")
    def historical_object_replication(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether to replicate historical data from the source bucket to the destination bucket before data replication is enabled. Can be `enabled` or `disabled`. Defaults to `enabled`.
        """
        return pulumi.get(self, "historical_object_replication")

    @historical_object_replication.setter
    def historical_object_replication(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "historical_object_replication", value)

    @_builtins.property
    @pulumi.getter(name="prefixSet")
    def prefix_set(self) -> Optional[pulumi.Input['BucketReplicationPrefixSetArgs']]:
        """
        The prefixes used to specify the object to replicate. Only objects that match the prefix are replicated to the destination bucket. See `prefix_set` below.
        """
        return pulumi.get(self, "prefix_set")

    @prefix_set.setter
    def prefix_set(self, value: Optional[pulumi.Input['BucketReplicationPrefixSetArgs']]):
        pulumi.set(self, "prefix_set", value)

    @_builtins.property
    @pulumi.getter
    def progress(self) -> Optional[pulumi.Input['BucketReplicationProgressArgs']]:
        """
        Specifies the progress for querying the progress of a data replication task of a bucket.
        """
        return pulumi.get(self, "progress")

    @progress.setter
    def progress(self, value: Optional[pulumi.Input['BucketReplicationProgressArgs']]):
        pulumi.set(self, "progress", value)

    @_builtins.property
    @pulumi.getter(name="sourceSelectionCriteria")
    def source_selection_criteria(self) -> Optional[pulumi.Input['BucketReplicationSourceSelectionCriteriaArgs']]:
        """
        Specifies other conditions used to filter the source objects to replicate. See `source_selection_criteria` below.
        """
        return pulumi.get(self, "source_selection_criteria")

    @source_selection_criteria.setter
    def source_selection_criteria(self, value: Optional[pulumi.Input['BucketReplicationSourceSelectionCriteriaArgs']]):
        pulumi.set(self, "source_selection_criteria", value)

    @_builtins.property
    @pulumi.getter(name="syncRole")
    def sync_role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the role that you authorize OSS to use to replicate data. If SSE-KMS is specified to encrypt the objects replicated to the destination bucket, it must be specified.
        """
        return pulumi.get(self, "sync_role")

    @sync_role.setter
    def sync_role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sync_role", value)


@pulumi.input_type
class _BucketReplicationState:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input[_builtins.str]] = None,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 destination: Optional[pulumi.Input['BucketReplicationDestinationArgs']] = None,
                 encryption_configuration: Optional[pulumi.Input['BucketReplicationEncryptionConfigurationArgs']] = None,
                 historical_object_replication: Optional[pulumi.Input[_builtins.str]] = None,
                 prefix_set: Optional[pulumi.Input['BucketReplicationPrefixSetArgs']] = None,
                 progress: Optional[pulumi.Input['BucketReplicationProgressArgs']] = None,
                 rule_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_selection_criteria: Optional[pulumi.Input['BucketReplicationSourceSelectionCriteriaArgs']] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 sync_role: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering BucketReplication resources.
        :param pulumi.Input[_builtins.str] action: The operations that can be synchronized to the destination bucket. You can set action to one or more of the following operation types. Valid values: `ALL`(contains PUT, DELETE, and ABORT), `PUT`, `DELETE` and `ABORT`. Defaults to `ALL`.
        :param pulumi.Input[_builtins.str] bucket: The name of the bucket.
        :param pulumi.Input['BucketReplicationDestinationArgs'] destination: Specifies the destination for the rule. See `destination` below.
        :param pulumi.Input['BucketReplicationEncryptionConfigurationArgs'] encryption_configuration: Specifies the encryption configuration for the objects replicated to the destination bucket. See `encryption_configuration` below.
        :param pulumi.Input[_builtins.str] historical_object_replication: Specifies whether to replicate historical data from the source bucket to the destination bucket before data replication is enabled. Can be `enabled` or `disabled`. Defaults to `enabled`.
        :param pulumi.Input['BucketReplicationPrefixSetArgs'] prefix_set: The prefixes used to specify the object to replicate. Only objects that match the prefix are replicated to the destination bucket. See `prefix_set` below.
        :param pulumi.Input['BucketReplicationProgressArgs'] progress: Specifies the progress for querying the progress of a data replication task of a bucket.
        :param pulumi.Input[_builtins.str] rule_id: The ID of the data replication rule.
        :param pulumi.Input['BucketReplicationSourceSelectionCriteriaArgs'] source_selection_criteria: Specifies other conditions used to filter the source objects to replicate. See `source_selection_criteria` below.
        :param pulumi.Input[_builtins.str] status: The status of the data replication task. Can be starting, doing and closing.
        :param pulumi.Input[_builtins.str] sync_role: Specifies the role that you authorize OSS to use to replicate data. If SSE-KMS is specified to encrypt the objects replicated to the destination bucket, it must be specified.
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if destination is not None:
            pulumi.set(__self__, "destination", destination)
        if encryption_configuration is not None:
            pulumi.set(__self__, "encryption_configuration", encryption_configuration)
        if historical_object_replication is not None:
            pulumi.set(__self__, "historical_object_replication", historical_object_replication)
        if prefix_set is not None:
            pulumi.set(__self__, "prefix_set", prefix_set)
        if progress is not None:
            pulumi.set(__self__, "progress", progress)
        if rule_id is not None:
            pulumi.set(__self__, "rule_id", rule_id)
        if source_selection_criteria is not None:
            pulumi.set(__self__, "source_selection_criteria", source_selection_criteria)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if sync_role is not None:
            pulumi.set(__self__, "sync_role", sync_role)

    @_builtins.property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The operations that can be synchronized to the destination bucket. You can set action to one or more of the following operation types. Valid values: `ALL`(contains PUT, DELETE, and ABORT), `PUT`, `DELETE` and `ABORT`. Defaults to `ALL`.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "action", value)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the bucket.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bucket", value)

    @_builtins.property
    @pulumi.getter
    def destination(self) -> Optional[pulumi.Input['BucketReplicationDestinationArgs']]:
        """
        Specifies the destination for the rule. See `destination` below.
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: Optional[pulumi.Input['BucketReplicationDestinationArgs']]):
        pulumi.set(self, "destination", value)

    @_builtins.property
    @pulumi.getter(name="encryptionConfiguration")
    def encryption_configuration(self) -> Optional[pulumi.Input['BucketReplicationEncryptionConfigurationArgs']]:
        """
        Specifies the encryption configuration for the objects replicated to the destination bucket. See `encryption_configuration` below.
        """
        return pulumi.get(self, "encryption_configuration")

    @encryption_configuration.setter
    def encryption_configuration(self, value: Optional[pulumi.Input['BucketReplicationEncryptionConfigurationArgs']]):
        pulumi.set(self, "encryption_configuration", value)

    @_builtins.property
    @pulumi.getter(name="historicalObjectReplication")
    def historical_object_replication(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether to replicate historical data from the source bucket to the destination bucket before data replication is enabled. Can be `enabled` or `disabled`. Defaults to `enabled`.
        """
        return pulumi.get(self, "historical_object_replication")

    @historical_object_replication.setter
    def historical_object_replication(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "historical_object_replication", value)

    @_builtins.property
    @pulumi.getter(name="prefixSet")
    def prefix_set(self) -> Optional[pulumi.Input['BucketReplicationPrefixSetArgs']]:
        """
        The prefixes used to specify the object to replicate. Only objects that match the prefix are replicated to the destination bucket. See `prefix_set` below.
        """
        return pulumi.get(self, "prefix_set")

    @prefix_set.setter
    def prefix_set(self, value: Optional[pulumi.Input['BucketReplicationPrefixSetArgs']]):
        pulumi.set(self, "prefix_set", value)

    @_builtins.property
    @pulumi.getter
    def progress(self) -> Optional[pulumi.Input['BucketReplicationProgressArgs']]:
        """
        Specifies the progress for querying the progress of a data replication task of a bucket.
        """
        return pulumi.get(self, "progress")

    @progress.setter
    def progress(self, value: Optional[pulumi.Input['BucketReplicationProgressArgs']]):
        pulumi.set(self, "progress", value)

    @_builtins.property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the data replication rule.
        """
        return pulumi.get(self, "rule_id")

    @rule_id.setter
    def rule_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule_id", value)

    @_builtins.property
    @pulumi.getter(name="sourceSelectionCriteria")
    def source_selection_criteria(self) -> Optional[pulumi.Input['BucketReplicationSourceSelectionCriteriaArgs']]:
        """
        Specifies other conditions used to filter the source objects to replicate. See `source_selection_criteria` below.
        """
        return pulumi.get(self, "source_selection_criteria")

    @source_selection_criteria.setter
    def source_selection_criteria(self, value: Optional[pulumi.Input['BucketReplicationSourceSelectionCriteriaArgs']]):
        pulumi.set(self, "source_selection_criteria", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the data replication task. Can be starting, doing and closing.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="syncRole")
    def sync_role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the role that you authorize OSS to use to replicate data. If SSE-KMS is specified to encrypt the objects replicated to the destination bucket, it must be specified.
        """
        return pulumi.get(self, "sync_role")

    @sync_role.setter
    def sync_role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sync_role", value)


@pulumi.type_token("alicloud:oss/bucketReplication:BucketReplication")
class BucketReplication(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[_builtins.str]] = None,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 destination: Optional[pulumi.Input[Union['BucketReplicationDestinationArgs', 'BucketReplicationDestinationArgsDict']]] = None,
                 encryption_configuration: Optional[pulumi.Input[Union['BucketReplicationEncryptionConfigurationArgs', 'BucketReplicationEncryptionConfigurationArgsDict']]] = None,
                 historical_object_replication: Optional[pulumi.Input[_builtins.str]] = None,
                 prefix_set: Optional[pulumi.Input[Union['BucketReplicationPrefixSetArgs', 'BucketReplicationPrefixSetArgsDict']]] = None,
                 progress: Optional[pulumi.Input[Union['BucketReplicationProgressArgs', 'BucketReplicationProgressArgsDict']]] = None,
                 source_selection_criteria: Optional[pulumi.Input[Union['BucketReplicationSourceSelectionCriteriaArgs', 'BucketReplicationSourceSelectionCriteriaArgsDict']]] = None,
                 sync_role: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides an independent replication configuration resource for OSS bucket.

        For information about OSS replication and how to use it, see [What is cross-region replication](https://www.alibabacloud.com/help/doc-detail/31864.html) and [What is same-region replication](https://www.alibabacloud.com/help/doc-detail/254865.html).

        > **NOTE:** Available since v1.161.0.

        ## Example Usage

        Set bucket replication configuration

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default = random.index.Integer("default",
            max=99999,
            min=10000)
        bucket_src = alicloud.oss.Bucket("bucket_src", bucket=f"example-src-{default['result']}")
        bucket_dest = alicloud.oss.Bucket("bucket_dest", bucket=f"example-dest-{default['result']}")
        role = alicloud.ram.Role("role",
            name=f"example-role-{default['result']}",
            document=\"\"\"\\x09\\x09{
        \\x09\\x09  "Statement": [
        \\x09\\x09\\x09{
        \\x09\\x09\\x09  "Action": "sts:AssumeRole",
        \\x09\\x09\\x09  "Effect": "Allow",
        \\x09\\x09\\x09  "Principal": {
        \\x09\\x09\\x09\\x09"Service": [
        \\x09\\x09\\x09\\x09  "oss.aliyuncs.com"
        \\x09\\x09\\x09\\x09]
        \\x09\\x09\\x09  }
        \\x09\\x09\\x09}
        \\x09\\x09  ],
        \\x09\\x09  "Version": "1"
        \\x09\\x09}
        \"\"\",
            description="this is a test",
            force=True)
        policy = alicloud.ram.Policy("policy",
            policy_name=f"example-policy-{default['result']}",
            policy_document=\"\"\"\\x09\\x09{
        \\x09\\x09  "Statement": [
        \\x09\\x09\\x09{
        \\x09\\x09\\x09  "Action": [
        \\x09\\x09\\x09\\x09"*"
        \\x09\\x09\\x09  ],
        \\x09\\x09\\x09  "Effect": "Allow",
        \\x09\\x09\\x09  "Resource": [
        \\x09\\x09\\x09\\x09"*"
        \\x09\\x09\\x09  ]
        \\x09\\x09\\x09}
        \\x09\\x09  ],
        \\x09\\x09\\x09"Version": "1"
        \\x09\\x09}
        \"\"\",
            description="this is a policy test",
            force=True)
        attach = alicloud.ram.RolePolicyAttachment("attach",
            policy_name=policy.policy_name,
            policy_type=policy.type,
            role_name=role.name)
        key = alicloud.kms.Key("key",
            description="Hello KMS",
            pending_window_in_days=7,
            status="Enabled")
        cross_region_replication = alicloud.oss.BucketReplication("cross-region-replication",
            bucket=bucket_src.id,
            action="PUT,DELETE",
            historical_object_replication="enabled",
            prefix_set={
                "prefixes": [
                    "prefix1/",
                    "prefix2/",
                ],
            },
            destination={
                "bucket": bucket_dest.id,
                "location": bucket_dest.location,
            },
            sync_role=role.name,
            encryption_configuration={
                "replica_kms_key_id": key.id,
            },
            source_selection_criteria={
                "sse_kms_encrypted_objects": {
                    "status": "Enabled",
                },
            })
        ```

        ## Import

        Oss Bucket Replication can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:oss/bucketReplication:BucketReplication example 
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] action: The operations that can be synchronized to the destination bucket. You can set action to one or more of the following operation types. Valid values: `ALL`(contains PUT, DELETE, and ABORT), `PUT`, `DELETE` and `ABORT`. Defaults to `ALL`.
        :param pulumi.Input[_builtins.str] bucket: The name of the bucket.
        :param pulumi.Input[Union['BucketReplicationDestinationArgs', 'BucketReplicationDestinationArgsDict']] destination: Specifies the destination for the rule. See `destination` below.
        :param pulumi.Input[Union['BucketReplicationEncryptionConfigurationArgs', 'BucketReplicationEncryptionConfigurationArgsDict']] encryption_configuration: Specifies the encryption configuration for the objects replicated to the destination bucket. See `encryption_configuration` below.
        :param pulumi.Input[_builtins.str] historical_object_replication: Specifies whether to replicate historical data from the source bucket to the destination bucket before data replication is enabled. Can be `enabled` or `disabled`. Defaults to `enabled`.
        :param pulumi.Input[Union['BucketReplicationPrefixSetArgs', 'BucketReplicationPrefixSetArgsDict']] prefix_set: The prefixes used to specify the object to replicate. Only objects that match the prefix are replicated to the destination bucket. See `prefix_set` below.
        :param pulumi.Input[Union['BucketReplicationProgressArgs', 'BucketReplicationProgressArgsDict']] progress: Specifies the progress for querying the progress of a data replication task of a bucket.
        :param pulumi.Input[Union['BucketReplicationSourceSelectionCriteriaArgs', 'BucketReplicationSourceSelectionCriteriaArgsDict']] source_selection_criteria: Specifies other conditions used to filter the source objects to replicate. See `source_selection_criteria` below.
        :param pulumi.Input[_builtins.str] sync_role: Specifies the role that you authorize OSS to use to replicate data. If SSE-KMS is specified to encrypt the objects replicated to the destination bucket, it must be specified.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BucketReplicationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an independent replication configuration resource for OSS bucket.

        For information about OSS replication and how to use it, see [What is cross-region replication](https://www.alibabacloud.com/help/doc-detail/31864.html) and [What is same-region replication](https://www.alibabacloud.com/help/doc-detail/254865.html).

        > **NOTE:** Available since v1.161.0.

        ## Example Usage

        Set bucket replication configuration

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default = random.index.Integer("default",
            max=99999,
            min=10000)
        bucket_src = alicloud.oss.Bucket("bucket_src", bucket=f"example-src-{default['result']}")
        bucket_dest = alicloud.oss.Bucket("bucket_dest", bucket=f"example-dest-{default['result']}")
        role = alicloud.ram.Role("role",
            name=f"example-role-{default['result']}",
            document=\"\"\"\\x09\\x09{
        \\x09\\x09  "Statement": [
        \\x09\\x09\\x09{
        \\x09\\x09\\x09  "Action": "sts:AssumeRole",
        \\x09\\x09\\x09  "Effect": "Allow",
        \\x09\\x09\\x09  "Principal": {
        \\x09\\x09\\x09\\x09"Service": [
        \\x09\\x09\\x09\\x09  "oss.aliyuncs.com"
        \\x09\\x09\\x09\\x09]
        \\x09\\x09\\x09  }
        \\x09\\x09\\x09}
        \\x09\\x09  ],
        \\x09\\x09  "Version": "1"
        \\x09\\x09}
        \"\"\",
            description="this is a test",
            force=True)
        policy = alicloud.ram.Policy("policy",
            policy_name=f"example-policy-{default['result']}",
            policy_document=\"\"\"\\x09\\x09{
        \\x09\\x09  "Statement": [
        \\x09\\x09\\x09{
        \\x09\\x09\\x09  "Action": [
        \\x09\\x09\\x09\\x09"*"
        \\x09\\x09\\x09  ],
        \\x09\\x09\\x09  "Effect": "Allow",
        \\x09\\x09\\x09  "Resource": [
        \\x09\\x09\\x09\\x09"*"
        \\x09\\x09\\x09  ]
        \\x09\\x09\\x09}
        \\x09\\x09  ],
        \\x09\\x09\\x09"Version": "1"
        \\x09\\x09}
        \"\"\",
            description="this is a policy test",
            force=True)
        attach = alicloud.ram.RolePolicyAttachment("attach",
            policy_name=policy.policy_name,
            policy_type=policy.type,
            role_name=role.name)
        key = alicloud.kms.Key("key",
            description="Hello KMS",
            pending_window_in_days=7,
            status="Enabled")
        cross_region_replication = alicloud.oss.BucketReplication("cross-region-replication",
            bucket=bucket_src.id,
            action="PUT,DELETE",
            historical_object_replication="enabled",
            prefix_set={
                "prefixes": [
                    "prefix1/",
                    "prefix2/",
                ],
            },
            destination={
                "bucket": bucket_dest.id,
                "location": bucket_dest.location,
            },
            sync_role=role.name,
            encryption_configuration={
                "replica_kms_key_id": key.id,
            },
            source_selection_criteria={
                "sse_kms_encrypted_objects": {
                    "status": "Enabled",
                },
            })
        ```

        ## Import

        Oss Bucket Replication can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:oss/bucketReplication:BucketReplication example 
        ```

        :param str resource_name: The name of the resource.
        :param BucketReplicationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BucketReplicationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[_builtins.str]] = None,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 destination: Optional[pulumi.Input[Union['BucketReplicationDestinationArgs', 'BucketReplicationDestinationArgsDict']]] = None,
                 encryption_configuration: Optional[pulumi.Input[Union['BucketReplicationEncryptionConfigurationArgs', 'BucketReplicationEncryptionConfigurationArgsDict']]] = None,
                 historical_object_replication: Optional[pulumi.Input[_builtins.str]] = None,
                 prefix_set: Optional[pulumi.Input[Union['BucketReplicationPrefixSetArgs', 'BucketReplicationPrefixSetArgsDict']]] = None,
                 progress: Optional[pulumi.Input[Union['BucketReplicationProgressArgs', 'BucketReplicationProgressArgsDict']]] = None,
                 source_selection_criteria: Optional[pulumi.Input[Union['BucketReplicationSourceSelectionCriteriaArgs', 'BucketReplicationSourceSelectionCriteriaArgsDict']]] = None,
                 sync_role: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BucketReplicationArgs.__new__(BucketReplicationArgs)

            __props__.__dict__["action"] = action
            if bucket is None and not opts.urn:
                raise TypeError("Missing required property 'bucket'")
            __props__.__dict__["bucket"] = bucket
            if destination is None and not opts.urn:
                raise TypeError("Missing required property 'destination'")
            __props__.__dict__["destination"] = destination
            __props__.__dict__["encryption_configuration"] = encryption_configuration
            __props__.__dict__["historical_object_replication"] = historical_object_replication
            __props__.__dict__["prefix_set"] = prefix_set
            __props__.__dict__["progress"] = progress
            __props__.__dict__["source_selection_criteria"] = source_selection_criteria
            __props__.__dict__["sync_role"] = sync_role
            __props__.__dict__["rule_id"] = None
            __props__.__dict__["status"] = None
        super(BucketReplication, __self__).__init__(
            'alicloud:oss/bucketReplication:BucketReplication',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            action: Optional[pulumi.Input[_builtins.str]] = None,
            bucket: Optional[pulumi.Input[_builtins.str]] = None,
            destination: Optional[pulumi.Input[Union['BucketReplicationDestinationArgs', 'BucketReplicationDestinationArgsDict']]] = None,
            encryption_configuration: Optional[pulumi.Input[Union['BucketReplicationEncryptionConfigurationArgs', 'BucketReplicationEncryptionConfigurationArgsDict']]] = None,
            historical_object_replication: Optional[pulumi.Input[_builtins.str]] = None,
            prefix_set: Optional[pulumi.Input[Union['BucketReplicationPrefixSetArgs', 'BucketReplicationPrefixSetArgsDict']]] = None,
            progress: Optional[pulumi.Input[Union['BucketReplicationProgressArgs', 'BucketReplicationProgressArgsDict']]] = None,
            rule_id: Optional[pulumi.Input[_builtins.str]] = None,
            source_selection_criteria: Optional[pulumi.Input[Union['BucketReplicationSourceSelectionCriteriaArgs', 'BucketReplicationSourceSelectionCriteriaArgsDict']]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            sync_role: Optional[pulumi.Input[_builtins.str]] = None) -> 'BucketReplication':
        """
        Get an existing BucketReplication resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] action: The operations that can be synchronized to the destination bucket. You can set action to one or more of the following operation types. Valid values: `ALL`(contains PUT, DELETE, and ABORT), `PUT`, `DELETE` and `ABORT`. Defaults to `ALL`.
        :param pulumi.Input[_builtins.str] bucket: The name of the bucket.
        :param pulumi.Input[Union['BucketReplicationDestinationArgs', 'BucketReplicationDestinationArgsDict']] destination: Specifies the destination for the rule. See `destination` below.
        :param pulumi.Input[Union['BucketReplicationEncryptionConfigurationArgs', 'BucketReplicationEncryptionConfigurationArgsDict']] encryption_configuration: Specifies the encryption configuration for the objects replicated to the destination bucket. See `encryption_configuration` below.
        :param pulumi.Input[_builtins.str] historical_object_replication: Specifies whether to replicate historical data from the source bucket to the destination bucket before data replication is enabled. Can be `enabled` or `disabled`. Defaults to `enabled`.
        :param pulumi.Input[Union['BucketReplicationPrefixSetArgs', 'BucketReplicationPrefixSetArgsDict']] prefix_set: The prefixes used to specify the object to replicate. Only objects that match the prefix are replicated to the destination bucket. See `prefix_set` below.
        :param pulumi.Input[Union['BucketReplicationProgressArgs', 'BucketReplicationProgressArgsDict']] progress: Specifies the progress for querying the progress of a data replication task of a bucket.
        :param pulumi.Input[_builtins.str] rule_id: The ID of the data replication rule.
        :param pulumi.Input[Union['BucketReplicationSourceSelectionCriteriaArgs', 'BucketReplicationSourceSelectionCriteriaArgsDict']] source_selection_criteria: Specifies other conditions used to filter the source objects to replicate. See `source_selection_criteria` below.
        :param pulumi.Input[_builtins.str] status: The status of the data replication task. Can be starting, doing and closing.
        :param pulumi.Input[_builtins.str] sync_role: Specifies the role that you authorize OSS to use to replicate data. If SSE-KMS is specified to encrypt the objects replicated to the destination bucket, it must be specified.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BucketReplicationState.__new__(_BucketReplicationState)

        __props__.__dict__["action"] = action
        __props__.__dict__["bucket"] = bucket
        __props__.__dict__["destination"] = destination
        __props__.__dict__["encryption_configuration"] = encryption_configuration
        __props__.__dict__["historical_object_replication"] = historical_object_replication
        __props__.__dict__["prefix_set"] = prefix_set
        __props__.__dict__["progress"] = progress
        __props__.__dict__["rule_id"] = rule_id
        __props__.__dict__["source_selection_criteria"] = source_selection_criteria
        __props__.__dict__["status"] = status
        __props__.__dict__["sync_role"] = sync_role
        return BucketReplication(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def action(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The operations that can be synchronized to the destination bucket. You can set action to one or more of the following operation types. Valid values: `ALL`(contains PUT, DELETE, and ABORT), `PUT`, `DELETE` and `ABORT`. Defaults to `ALL`.
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the bucket.
        """
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter
    def destination(self) -> pulumi.Output['outputs.BucketReplicationDestination']:
        """
        Specifies the destination for the rule. See `destination` below.
        """
        return pulumi.get(self, "destination")

    @_builtins.property
    @pulumi.getter(name="encryptionConfiguration")
    def encryption_configuration(self) -> pulumi.Output[Optional['outputs.BucketReplicationEncryptionConfiguration']]:
        """
        Specifies the encryption configuration for the objects replicated to the destination bucket. See `encryption_configuration` below.
        """
        return pulumi.get(self, "encryption_configuration")

    @_builtins.property
    @pulumi.getter(name="historicalObjectReplication")
    def historical_object_replication(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies whether to replicate historical data from the source bucket to the destination bucket before data replication is enabled. Can be `enabled` or `disabled`. Defaults to `enabled`.
        """
        return pulumi.get(self, "historical_object_replication")

    @_builtins.property
    @pulumi.getter(name="prefixSet")
    def prefix_set(self) -> pulumi.Output[Optional['outputs.BucketReplicationPrefixSet']]:
        """
        The prefixes used to specify the object to replicate. Only objects that match the prefix are replicated to the destination bucket. See `prefix_set` below.
        """
        return pulumi.get(self, "prefix_set")

    @_builtins.property
    @pulumi.getter
    def progress(self) -> pulumi.Output['outputs.BucketReplicationProgress']:
        """
        Specifies the progress for querying the progress of a data replication task of a bucket.
        """
        return pulumi.get(self, "progress")

    @_builtins.property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the data replication rule.
        """
        return pulumi.get(self, "rule_id")

    @_builtins.property
    @pulumi.getter(name="sourceSelectionCriteria")
    def source_selection_criteria(self) -> pulumi.Output[Optional['outputs.BucketReplicationSourceSelectionCriteria']]:
        """
        Specifies other conditions used to filter the source objects to replicate. See `source_selection_criteria` below.
        """
        return pulumi.get(self, "source_selection_criteria")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the data replication task. Can be starting, doing and closing.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="syncRole")
    def sync_role(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the role that you authorize OSS to use to replicate data. If SSE-KMS is specified to encrypt the objects replicated to the destination bucket, it must be specified.
        """
        return pulumi.get(self, "sync_role")

