# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['InstanceArgs', 'Instance']

@pulumi.input_type
class InstanceArgs:
    def __init__(__self__, *,
                 accessed_by: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_source_acls: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 network_type_acls: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Instance resource.
        :param pulumi.Input[_builtins.str] accessed_by: The network limitation of accessing instance. Valid values:
               * `Any` - Allow all network to access the instance.
               * `Vpc` - Only can the attached VPC allow to access the instance.
               * `ConsoleOrVpc` - Allow web console or the attached VPC to access the instance.
               
               Default to "Any".
        :param pulumi.Input[_builtins.str] description: The description of the instance. Currently, it does not support modifying.
        :param pulumi.Input[_builtins.str] instance_type: The type of instance. Valid values are "Capacity" and "HighPerformance". Default to "HighPerformance".
        :param pulumi.Input[_builtins.str] name: The name of the instance.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] network_source_acls: The set of request sources that are allowed access. Valid optional values:
               * `TRUST_PROXY` - Trusted proxy, usually the Alibaba Cloud console.
               
               Default to ["TRUST_PROXY"].
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] network_type_acls: The set of network types that are allowed access. Valid optional values:
               * `CLASSIC` - Classic network.
               * `VPC` - VPC network.
               * `INTERNET` - Public internet.
               
               Default to ["VPC", "CLASSIC", "INTERNET"].
        :param pulumi.Input[_builtins.str] resource_group_id: The resource group the instance belongs to.
               Default to Alibaba Cloud default resource group.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the instance.
        """
        if accessed_by is not None:
            pulumi.set(__self__, "accessed_by", accessed_by)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_source_acls is not None:
            pulumi.set(__self__, "network_source_acls", network_source_acls)
        if network_type_acls is not None:
            pulumi.set(__self__, "network_type_acls", network_type_acls)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="accessedBy")
    def accessed_by(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The network limitation of accessing instance. Valid values:
        * `Any` - Allow all network to access the instance.
        * `Vpc` - Only can the attached VPC allow to access the instance.
        * `ConsoleOrVpc` - Allow web console or the attached VPC to access the instance.

        Default to "Any".
        """
        return pulumi.get(self, "accessed_by")

    @accessed_by.setter
    def accessed_by(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "accessed_by", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the instance. Currently, it does not support modifying.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of instance. Valid values are "Capacity" and "HighPerformance". Default to "HighPerformance".
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_type", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the instance.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkSourceAcls")
    def network_source_acls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The set of request sources that are allowed access. Valid optional values:
        * `TRUST_PROXY` - Trusted proxy, usually the Alibaba Cloud console.

        Default to ["TRUST_PROXY"].
        """
        return pulumi.get(self, "network_source_acls")

    @network_source_acls.setter
    def network_source_acls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "network_source_acls", value)

    @_builtins.property
    @pulumi.getter(name="networkTypeAcls")
    def network_type_acls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The set of network types that are allowed access. Valid optional values:
        * `CLASSIC` - Classic network.
        * `VPC` - VPC network.
        * `INTERNET` - Public internet.

        Default to ["VPC", "CLASSIC", "INTERNET"].
        """
        return pulumi.get(self, "network_type_acls")

    @network_type_acls.setter
    def network_type_acls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "network_type_acls", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource group the instance belongs to.
        Default to Alibaba Cloud default resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the instance.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _InstanceState:
    def __init__(__self__, *,
                 accessed_by: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_source_acls: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 network_type_acls: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Instance resources.
        :param pulumi.Input[_builtins.str] accessed_by: The network limitation of accessing instance. Valid values:
               * `Any` - Allow all network to access the instance.
               * `Vpc` - Only can the attached VPC allow to access the instance.
               * `ConsoleOrVpc` - Allow web console or the attached VPC to access the instance.
               
               Default to "Any".
        :param pulumi.Input[_builtins.str] description: The description of the instance. Currently, it does not support modifying.
        :param pulumi.Input[_builtins.str] instance_type: The type of instance. Valid values are "Capacity" and "HighPerformance". Default to "HighPerformance".
        :param pulumi.Input[_builtins.str] name: The name of the instance.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] network_source_acls: The set of request sources that are allowed access. Valid optional values:
               * `TRUST_PROXY` - Trusted proxy, usually the Alibaba Cloud console.
               
               Default to ["TRUST_PROXY"].
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] network_type_acls: The set of network types that are allowed access. Valid optional values:
               * `CLASSIC` - Classic network.
               * `VPC` - VPC network.
               * `INTERNET` - Public internet.
               
               Default to ["VPC", "CLASSIC", "INTERNET"].
        :param pulumi.Input[_builtins.str] resource_group_id: The resource group the instance belongs to.
               Default to Alibaba Cloud default resource group.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the instance.
        """
        if accessed_by is not None:
            pulumi.set(__self__, "accessed_by", accessed_by)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_source_acls is not None:
            pulumi.set(__self__, "network_source_acls", network_source_acls)
        if network_type_acls is not None:
            pulumi.set(__self__, "network_type_acls", network_type_acls)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="accessedBy")
    def accessed_by(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The network limitation of accessing instance. Valid values:
        * `Any` - Allow all network to access the instance.
        * `Vpc` - Only can the attached VPC allow to access the instance.
        * `ConsoleOrVpc` - Allow web console or the attached VPC to access the instance.

        Default to "Any".
        """
        return pulumi.get(self, "accessed_by")

    @accessed_by.setter
    def accessed_by(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "accessed_by", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the instance. Currently, it does not support modifying.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of instance. Valid values are "Capacity" and "HighPerformance". Default to "HighPerformance".
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_type", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the instance.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkSourceAcls")
    def network_source_acls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The set of request sources that are allowed access. Valid optional values:
        * `TRUST_PROXY` - Trusted proxy, usually the Alibaba Cloud console.

        Default to ["TRUST_PROXY"].
        """
        return pulumi.get(self, "network_source_acls")

    @network_source_acls.setter
    def network_source_acls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "network_source_acls", value)

    @_builtins.property
    @pulumi.getter(name="networkTypeAcls")
    def network_type_acls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The set of network types that are allowed access. Valid optional values:
        * `CLASSIC` - Classic network.
        * `VPC` - VPC network.
        * `INTERNET` - Public internet.

        Default to ["VPC", "CLASSIC", "INTERNET"].
        """
        return pulumi.get(self, "network_type_acls")

    @network_type_acls.setter
    def network_type_acls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "network_type_acls", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource group the instance belongs to.
        Default to Alibaba Cloud default resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the instance.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("alicloud:ots/instance:Instance")
class Instance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accessed_by: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_source_acls: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 network_type_acls: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        This resource will help you to manager a [Table Store](https://www.alibabacloud.com/help/doc-detail/27280.htm) Instance.
        It is foundation of creating data table.

        > **NOTE:** Available since v1.10.0.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default = random.index.Integer("default",
            min=10000,
            max=99999)
        default_instance = alicloud.ots.Instance("default",
            name=f"{name}-{default['result']}",
            description=name,
            accessed_by="Vpc",
            tags={
                "Created": "TF",
                "For": "Building table",
            })
        ```

        ## Import

        OTS instance can be imported using instance id or name, e.g.

        ```sh
        $ pulumi import alicloud:ots/instance:Instance foo "my-ots-instance"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] accessed_by: The network limitation of accessing instance. Valid values:
               * `Any` - Allow all network to access the instance.
               * `Vpc` - Only can the attached VPC allow to access the instance.
               * `ConsoleOrVpc` - Allow web console or the attached VPC to access the instance.
               
               Default to "Any".
        :param pulumi.Input[_builtins.str] description: The description of the instance. Currently, it does not support modifying.
        :param pulumi.Input[_builtins.str] instance_type: The type of instance. Valid values are "Capacity" and "HighPerformance". Default to "HighPerformance".
        :param pulumi.Input[_builtins.str] name: The name of the instance.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] network_source_acls: The set of request sources that are allowed access. Valid optional values:
               * `TRUST_PROXY` - Trusted proxy, usually the Alibaba Cloud console.
               
               Default to ["TRUST_PROXY"].
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] network_type_acls: The set of network types that are allowed access. Valid optional values:
               * `CLASSIC` - Classic network.
               * `VPC` - VPC network.
               * `INTERNET` - Public internet.
               
               Default to ["VPC", "CLASSIC", "INTERNET"].
        :param pulumi.Input[_builtins.str] resource_group_id: The resource group the instance belongs to.
               Default to Alibaba Cloud default resource group.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the instance.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[InstanceArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource will help you to manager a [Table Store](https://www.alibabacloud.com/help/doc-detail/27280.htm) Instance.
        It is foundation of creating data table.

        > **NOTE:** Available since v1.10.0.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default = random.index.Integer("default",
            min=10000,
            max=99999)
        default_instance = alicloud.ots.Instance("default",
            name=f"{name}-{default['result']}",
            description=name,
            accessed_by="Vpc",
            tags={
                "Created": "TF",
                "For": "Building table",
            })
        ```

        ## Import

        OTS instance can be imported using instance id or name, e.g.

        ```sh
        $ pulumi import alicloud:ots/instance:Instance foo "my-ots-instance"
        ```

        :param str resource_name: The name of the resource.
        :param InstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accessed_by: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_source_acls: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 network_type_acls: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceArgs.__new__(InstanceArgs)

            __props__.__dict__["accessed_by"] = accessed_by
            __props__.__dict__["description"] = description
            __props__.__dict__["instance_type"] = instance_type
            __props__.__dict__["name"] = name
            __props__.__dict__["network_source_acls"] = network_source_acls
            __props__.__dict__["network_type_acls"] = network_type_acls
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["tags"] = tags
        super(Instance, __self__).__init__(
            'alicloud:ots/instance:Instance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            accessed_by: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            instance_type: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network_source_acls: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            network_type_acls: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'Instance':
        """
        Get an existing Instance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] accessed_by: The network limitation of accessing instance. Valid values:
               * `Any` - Allow all network to access the instance.
               * `Vpc` - Only can the attached VPC allow to access the instance.
               * `ConsoleOrVpc` - Allow web console or the attached VPC to access the instance.
               
               Default to "Any".
        :param pulumi.Input[_builtins.str] description: The description of the instance. Currently, it does not support modifying.
        :param pulumi.Input[_builtins.str] instance_type: The type of instance. Valid values are "Capacity" and "HighPerformance". Default to "HighPerformance".
        :param pulumi.Input[_builtins.str] name: The name of the instance.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] network_source_acls: The set of request sources that are allowed access. Valid optional values:
               * `TRUST_PROXY` - Trusted proxy, usually the Alibaba Cloud console.
               
               Default to ["TRUST_PROXY"].
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] network_type_acls: The set of network types that are allowed access. Valid optional values:
               * `CLASSIC` - Classic network.
               * `VPC` - VPC network.
               * `INTERNET` - Public internet.
               
               Default to ["VPC", "CLASSIC", "INTERNET"].
        :param pulumi.Input[_builtins.str] resource_group_id: The resource group the instance belongs to.
               Default to Alibaba Cloud default resource group.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the instance.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceState.__new__(_InstanceState)

        __props__.__dict__["accessed_by"] = accessed_by
        __props__.__dict__["description"] = description
        __props__.__dict__["instance_type"] = instance_type
        __props__.__dict__["name"] = name
        __props__.__dict__["network_source_acls"] = network_source_acls
        __props__.__dict__["network_type_acls"] = network_type_acls
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["tags"] = tags
        return Instance(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accessedBy")
    def accessed_by(self) -> pulumi.Output[_builtins.str]:
        """
        The network limitation of accessing instance. Valid values:
        * `Any` - Allow all network to access the instance.
        * `Vpc` - Only can the attached VPC allow to access the instance.
        * `ConsoleOrVpc` - Allow web console or the attached VPC to access the instance.

        Default to "Any".
        """
        return pulumi.get(self, "accessed_by")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the instance. Currently, it does not support modifying.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The type of instance. Valid values are "Capacity" and "HighPerformance". Default to "HighPerformance".
        """
        return pulumi.get(self, "instance_type")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the instance.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkSourceAcls")
    def network_source_acls(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The set of request sources that are allowed access. Valid optional values:
        * `TRUST_PROXY` - Trusted proxy, usually the Alibaba Cloud console.

        Default to ["TRUST_PROXY"].
        """
        return pulumi.get(self, "network_source_acls")

    @_builtins.property
    @pulumi.getter(name="networkTypeAcls")
    def network_type_acls(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The set of network types that are allowed access. Valid optional values:
        * `CLASSIC` - Classic network.
        * `VPC` - VPC network.
        * `INTERNET` - Public internet.

        Default to ["VPC", "CLASSIC", "INTERNET"].
        """
        return pulumi.get(self, "network_type_acls")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The resource group the instance belongs to.
        Default to Alibaba Cloud default resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the instance.
        """
        return pulumi.get(self, "tags")

