# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'SearchIndexSchema',
    'SearchIndexSchemaFieldSchema',
    'SearchIndexSchemaIndexSetting',
    'SearchIndexSchemaIndexSort',
    'SearchIndexSchemaIndexSortSorter',
    'TableDefinedColumn',
    'TablePrimaryKey',
    'TunnelChannel',
    'GetInstanceAttachmentsAttachmentResult',
    'GetInstancesInstanceResult',
    'GetSearchIndexesIndexResult',
    'GetSecondaryIndexesIndexResult',
    'GetTablesTableResult',
    'GetTablesTableDefinedColumnResult',
    'GetTablesTablePrimaryKeyResult',
    'GetTunnelsTunnelResult',
    'GetTunnelsTunnelChannelResult',
]

@pulumi.output_type
class SearchIndexSchema(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fieldSchemas":
            suggest = "field_schemas"
        elif key == "indexSettings":
            suggest = "index_settings"
        elif key == "indexSorts":
            suggest = "index_sorts"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SearchIndexSchema. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SearchIndexSchema.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SearchIndexSchema.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 field_schemas: Sequence['outputs.SearchIndexSchemaFieldSchema'],
                 index_settings: Optional[Sequence['outputs.SearchIndexSchemaIndexSetting']] = None,
                 index_sorts: Optional[Sequence['outputs.SearchIndexSchemaIndexSort']] = None):
        """
        :param Sequence['SearchIndexSchemaFieldSchemaArgs'] field_schemas: A list of field schemas. See `field_schema` below.
        :param Sequence['SearchIndexSchemaIndexSettingArgs'] index_settings: The settings of the search index, including routingFields. See `index_setting` below.
        :param Sequence['SearchIndexSchemaIndexSortArgs'] index_sorts: The presorting settings of the search index, including sorters. If no value is specified for the indexSort parameter, field values are sorted by primary key by default. See `index_sort` below.
        """
        pulumi.set(__self__, "field_schemas", field_schemas)
        if index_settings is not None:
            pulumi.set(__self__, "index_settings", index_settings)
        if index_sorts is not None:
            pulumi.set(__self__, "index_sorts", index_sorts)

    @_builtins.property
    @pulumi.getter(name="fieldSchemas")
    def field_schemas(self) -> Sequence['outputs.SearchIndexSchemaFieldSchema']:
        """
        A list of field schemas. See `field_schema` below.
        """
        return pulumi.get(self, "field_schemas")

    @_builtins.property
    @pulumi.getter(name="indexSettings")
    def index_settings(self) -> Optional[Sequence['outputs.SearchIndexSchemaIndexSetting']]:
        """
        The settings of the search index, including routingFields. See `index_setting` below.
        """
        return pulumi.get(self, "index_settings")

    @_builtins.property
    @pulumi.getter(name="indexSorts")
    def index_sorts(self) -> Optional[Sequence['outputs.SearchIndexSchemaIndexSort']]:
        """
        The presorting settings of the search index, including sorters. If no value is specified for the indexSort parameter, field values are sorted by primary key by default. See `index_sort` below.
        """
        return pulumi.get(self, "index_sorts")


@pulumi.output_type
class SearchIndexSchemaFieldSchema(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fieldName":
            suggest = "field_name"
        elif key == "fieldType":
            suggest = "field_type"
        elif key == "enableSortAndAgg":
            suggest = "enable_sort_and_agg"
        elif key == "isArray":
            suggest = "is_array"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SearchIndexSchemaFieldSchema. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SearchIndexSchemaFieldSchema.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SearchIndexSchemaFieldSchema.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 field_name: _builtins.str,
                 field_type: _builtins.str,
                 analyzer: Optional[_builtins.str] = None,
                 enable_sort_and_agg: Optional[_builtins.bool] = None,
                 index: Optional[_builtins.bool] = None,
                 is_array: Optional[_builtins.bool] = None,
                 store: Optional[_builtins.bool] = None):
        """
        :param _builtins.str field_name: The name of the field that is used to sort data. only required if sorter_type is FieldSort.
        :param _builtins.str field_type: Specifies the type of the field. Valid values: Text, Long, Double, Boolean, Keyword, Date, GeoPoint, Nested.
        :param _builtins.str analyzer: Specifies the type of the analyzer that you want to use. If fieldType is set to Text, you can configure this parameter. Otherwise, the default analyzer type single-word tokenization is used.
        :param _builtins.bool enable_sort_and_agg: Specifies whether to enable sorting and aggregation. Type: Boolean. Sorting can be enabled only for fields for which enable_sort_and_agg is set to true.
        :param _builtins.bool index: Specifies whether to enable indexing for the column. Type: Boolean.
        :param _builtins.bool is_array: Specifies whether the value is an array. Type: Boolean.
        :param _builtins.bool store: Specifies whether to store the value of the field in the search index. Type: Boolean. If you set store to true, you can read the value of the field from the search index without querying the data table. This improves query performance.
        """
        pulumi.set(__self__, "field_name", field_name)
        pulumi.set(__self__, "field_type", field_type)
        if analyzer is not None:
            pulumi.set(__self__, "analyzer", analyzer)
        if enable_sort_and_agg is not None:
            pulumi.set(__self__, "enable_sort_and_agg", enable_sort_and_agg)
        if index is not None:
            pulumi.set(__self__, "index", index)
        if is_array is not None:
            pulumi.set(__self__, "is_array", is_array)
        if store is not None:
            pulumi.set(__self__, "store", store)

    @_builtins.property
    @pulumi.getter(name="fieldName")
    def field_name(self) -> _builtins.str:
        """
        The name of the field that is used to sort data. only required if sorter_type is FieldSort.
        """
        return pulumi.get(self, "field_name")

    @_builtins.property
    @pulumi.getter(name="fieldType")
    def field_type(self) -> _builtins.str:
        """
        Specifies the type of the field. Valid values: Text, Long, Double, Boolean, Keyword, Date, GeoPoint, Nested.
        """
        return pulumi.get(self, "field_type")

    @_builtins.property
    @pulumi.getter
    def analyzer(self) -> Optional[_builtins.str]:
        """
        Specifies the type of the analyzer that you want to use. If fieldType is set to Text, you can configure this parameter. Otherwise, the default analyzer type single-word tokenization is used.
        """
        return pulumi.get(self, "analyzer")

    @_builtins.property
    @pulumi.getter(name="enableSortAndAgg")
    def enable_sort_and_agg(self) -> Optional[_builtins.bool]:
        """
        Specifies whether to enable sorting and aggregation. Type: Boolean. Sorting can be enabled only for fields for which enable_sort_and_agg is set to true.
        """
        return pulumi.get(self, "enable_sort_and_agg")

    @_builtins.property
    @pulumi.getter
    def index(self) -> Optional[_builtins.bool]:
        """
        Specifies whether to enable indexing for the column. Type: Boolean.
        """
        return pulumi.get(self, "index")

    @_builtins.property
    @pulumi.getter(name="isArray")
    def is_array(self) -> Optional[_builtins.bool]:
        """
        Specifies whether the value is an array. Type: Boolean.
        """
        return pulumi.get(self, "is_array")

    @_builtins.property
    @pulumi.getter
    def store(self) -> Optional[_builtins.bool]:
        """
        Specifies whether to store the value of the field in the search index. Type: Boolean. If you set store to true, you can read the value of the field from the search index without querying the data table. This improves query performance.
        """
        return pulumi.get(self, "store")


@pulumi.output_type
class SearchIndexSchemaIndexSetting(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "routingFields":
            suggest = "routing_fields"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SearchIndexSchemaIndexSetting. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SearchIndexSchemaIndexSetting.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SearchIndexSchemaIndexSetting.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 routing_fields: Optional[Sequence[_builtins.str]] = None):
        """
        :param Sequence[_builtins.str] routing_fields: Specifies custom routing fields. You can specify some primary key columns as routing fields. Tablestore distributes data that is written to a search index across different partitions based on the specified routing fields. The data whose routing field values are the same is distributed to the same partition.
        """
        if routing_fields is not None:
            pulumi.set(__self__, "routing_fields", routing_fields)

    @_builtins.property
    @pulumi.getter(name="routingFields")
    def routing_fields(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies custom routing fields. You can specify some primary key columns as routing fields. Tablestore distributes data that is written to a search index across different partitions based on the specified routing fields. The data whose routing field values are the same is distributed to the same partition.
        """
        return pulumi.get(self, "routing_fields")


@pulumi.output_type
class SearchIndexSchemaIndexSort(dict):
    def __init__(__self__, *,
                 sorters: Sequence['outputs.SearchIndexSchemaIndexSortSorter']):
        """
        :param Sequence['SearchIndexSchemaIndexSortSorterArgs'] sorters: Specifies the presorting method for the search index. PrimaryKeySort and FieldSort are supported. See `sorter` below.
        """
        pulumi.set(__self__, "sorters", sorters)

    @_builtins.property
    @pulumi.getter
    def sorters(self) -> Sequence['outputs.SearchIndexSchemaIndexSortSorter']:
        """
        Specifies the presorting method for the search index. PrimaryKeySort and FieldSort are supported. See `sorter` below.
        """
        return pulumi.get(self, "sorters")


@pulumi.output_type
class SearchIndexSchemaIndexSortSorter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fieldName":
            suggest = "field_name"
        elif key == "sorterType":
            suggest = "sorter_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SearchIndexSchemaIndexSortSorter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SearchIndexSchemaIndexSortSorter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SearchIndexSchemaIndexSortSorter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 field_name: Optional[_builtins.str] = None,
                 mode: Optional[_builtins.str] = None,
                 order: Optional[_builtins.str] = None,
                 sorter_type: Optional[_builtins.str] = None):
        """
        :param _builtins.str field_name: The name of the field that is used to sort data. only required if sorter_type is FieldSort.
        :param _builtins.str mode: The sorting method that is used when the field contains multiple values. valid values: `Min`, `Max`, `Avg`. only required if sorter_type is FieldSort.
        :param _builtins.str order: The sort order. Data can be sorted in ascending(`Asc`) or descending(`Desc`) order. Default value: `Asc`.
        :param _builtins.str sorter_type: Data is sorted by Which fields or keys. valid values: `PrimaryKeySort`, `FieldSort`.
        """
        if field_name is not None:
            pulumi.set(__self__, "field_name", field_name)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if order is not None:
            pulumi.set(__self__, "order", order)
        if sorter_type is not None:
            pulumi.set(__self__, "sorter_type", sorter_type)

    @_builtins.property
    @pulumi.getter(name="fieldName")
    def field_name(self) -> Optional[_builtins.str]:
        """
        The name of the field that is used to sort data. only required if sorter_type is FieldSort.
        """
        return pulumi.get(self, "field_name")

    @_builtins.property
    @pulumi.getter
    def mode(self) -> Optional[_builtins.str]:
        """
        The sorting method that is used when the field contains multiple values. valid values: `Min`, `Max`, `Avg`. only required if sorter_type is FieldSort.
        """
        return pulumi.get(self, "mode")

    @_builtins.property
    @pulumi.getter
    def order(self) -> Optional[_builtins.str]:
        """
        The sort order. Data can be sorted in ascending(`Asc`) or descending(`Desc`) order. Default value: `Asc`.
        """
        return pulumi.get(self, "order")

    @_builtins.property
    @pulumi.getter(name="sorterType")
    def sorter_type(self) -> Optional[_builtins.str]:
        """
        Data is sorted by Which fields or keys. valid values: `PrimaryKeySort`, `FieldSort`.
        """
        return pulumi.get(self, "sorter_type")


@pulumi.output_type
class TableDefinedColumn(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str name: Name for defined column.
        :param _builtins.str type: Type for defined column. `Integer`, `String`, `Binary`, `Double`, `Boolean` is allowed.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name for defined column.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type for defined column. `Integer`, `String`, `Binary`, `Double`, `Boolean` is allowed.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class TablePrimaryKey(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str name: Name for primary key.
        :param _builtins.str type: Type for primary key. Only `Integer`, `String` or `Binary` is allowed.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name for primary key.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type for primary key. Only `Integer`, `String` or `Binary` is allowed.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class TunnelChannel(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "channelId":
            suggest = "channel_id"
        elif key == "channelRpo":
            suggest = "channel_rpo"
        elif key == "channelStatus":
            suggest = "channel_status"
        elif key == "channelType":
            suggest = "channel_type"
        elif key == "clientId":
            suggest = "client_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TunnelChannel. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TunnelChannel.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TunnelChannel.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 channel_id: Optional[_builtins.str] = None,
                 channel_rpo: Optional[_builtins.int] = None,
                 channel_status: Optional[_builtins.str] = None,
                 channel_type: Optional[_builtins.str] = None,
                 client_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str channel_id: The id of the channel.
        :param _builtins.int channel_rpo: The latest consumption time of the channel, unix time in nanosecond.
        :param _builtins.str channel_status: The status of the channel, valid values: `WAIT`, `OPEN`, `CLOSING`, `CLOSE`, `TERMINATED`.
        :param _builtins.str channel_type: The type of the channel, valid values: `BaseData`, `Stream`.
        :param _builtins.str client_id: The client id of the channel.
        """
        if channel_id is not None:
            pulumi.set(__self__, "channel_id", channel_id)
        if channel_rpo is not None:
            pulumi.set(__self__, "channel_rpo", channel_rpo)
        if channel_status is not None:
            pulumi.set(__self__, "channel_status", channel_status)
        if channel_type is not None:
            pulumi.set(__self__, "channel_type", channel_type)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)

    @_builtins.property
    @pulumi.getter(name="channelId")
    def channel_id(self) -> Optional[_builtins.str]:
        """
        The id of the channel.
        """
        return pulumi.get(self, "channel_id")

    @_builtins.property
    @pulumi.getter(name="channelRpo")
    def channel_rpo(self) -> Optional[_builtins.int]:
        """
        The latest consumption time of the channel, unix time in nanosecond.
        """
        return pulumi.get(self, "channel_rpo")

    @_builtins.property
    @pulumi.getter(name="channelStatus")
    def channel_status(self) -> Optional[_builtins.str]:
        """
        The status of the channel, valid values: `WAIT`, `OPEN`, `CLOSING`, `CLOSE`, `TERMINATED`.
        """
        return pulumi.get(self, "channel_status")

    @_builtins.property
    @pulumi.getter(name="channelType")
    def channel_type(self) -> Optional[_builtins.str]:
        """
        The type of the channel, valid values: `BaseData`, `Stream`.
        """
        return pulumi.get(self, "channel_type")

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[_builtins.str]:
        """
        The client id of the channel.
        """
        return pulumi.get(self, "client_id")


@pulumi.output_type
class GetInstanceAttachmentsAttachmentResult(dict):
    def __init__(__self__, *,
                 domain: _builtins.str,
                 endpoint: _builtins.str,
                 id: _builtins.str,
                 instance_name: _builtins.str,
                 region: _builtins.str,
                 vpc_id: _builtins.str,
                 vpc_name: _builtins.str):
        """
        :param _builtins.str domain: The domain of the instance attachment.
        :param _builtins.str endpoint: The access endpoint of the instance attachment.
        :param _builtins.str id: The resource ID, the value is same as "instance_name".
        :param _builtins.str instance_name: The name of OTS instance.
        :param _builtins.str region: The region of the instance attachment.
        :param _builtins.str vpc_id: The ID of attaching VPC to instance.
        :param _builtins.str vpc_name: The name of attaching VPC to instance.
        """
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "endpoint", endpoint)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_name", instance_name)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vpc_name", vpc_name)

    @_builtins.property
    @pulumi.getter
    def domain(self) -> _builtins.str:
        """
        The domain of the instance attachment.
        """
        return pulumi.get(self, "domain")

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> _builtins.str:
        """
        The access endpoint of the instance attachment.
        """
        return pulumi.get(self, "endpoint")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The resource ID, the value is same as "instance_name".
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> _builtins.str:
        """
        The name of OTS instance.
        """
        return pulumi.get(self, "instance_name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        The region of the instance attachment.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> _builtins.str:
        """
        The ID of attaching VPC to instance.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vpcName")
    def vpc_name(self) -> _builtins.str:
        """
        The name of attaching VPC to instance.
        """
        return pulumi.get(self, "vpc_name")


@pulumi.output_type
class GetInstancesInstanceResult(dict):
    def __init__(__self__, *,
                 cluster_type: _builtins.str,
                 create_time: _builtins.str,
                 description: _builtins.str,
                 entity_quota: _builtins.int,
                 id: _builtins.str,
                 name: _builtins.str,
                 network: _builtins.str,
                 network_source_acls: Sequence[_builtins.str],
                 network_type_acls: Sequence[_builtins.str],
                 policy: _builtins.str,
                 policy_version: _builtins.int,
                 resource_group_id: _builtins.str,
                 status: _builtins.str,
                 table_quota: _builtins.int,
                 tags: Mapping[str, _builtins.str],
                 user_id: _builtins.str):
        """
        :param _builtins.str cluster_type: The cluster type of the instance. Possible values: `SSD`, `HYBRID`.
        :param _builtins.str create_time: The create time of the instance.
        :param _builtins.str description: The description of the instance.
        :param _builtins.int entity_quota: (Removed since v1.221.0) The instance quota which indicating the maximum number of tables.
        :param _builtins.str id: ID of the instance.
        :param _builtins.str name: Instance name.
        :param _builtins.str network: (Removed since v1.221.0) The network type of the instance. Possible values: `NORMAL`, `VPC`, `VPC_CONSOLE`.
        :param Sequence[_builtins.str] network_source_acls: (Available since v1.221.0) The set of request sources that are allowed access. Possible values: `TRUST_PROXY`.
        :param Sequence[_builtins.str] network_type_acls: (Available since v1.221.0) The set of network types that are allowed access. Possible values: `CLASSIC`, `VPC`, `INTERNET`.
        :param _builtins.str policy: (Available since v1.221.0) instance policy, json string.
        :param _builtins.int policy_version: (Available since v1.221.0) instance policy version.
        :param _builtins.str resource_group_id: (Available since v1.221.0) The resource group the instance belongs to.
        :param _builtins.str status: Instance status. Possible values: `Running`, `Disabled`, `Deleting`.
        :param _builtins.int table_quota: (Available since v1.221.0) The instance quota which indicating the maximum number of tables.
        :param Mapping[str, _builtins.str] tags: A map of tags assigned to the instance. It must be in the format:
               ```python
               import pulumi
               import pulumi_alicloud as alicloud
               
               instances_ds = alicloud.ots.get_instances(tags={
                   "tagKey1": "tagValue1",
                   "tagKey2": "tagValue2",
               })
               ```
        :param _builtins.str user_id: The user id of the instance.
        """
        pulumi.set(__self__, "cluster_type", cluster_type)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "entity_quota", entity_quota)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "network", network)
        pulumi.set(__self__, "network_source_acls", network_source_acls)
        pulumi.set(__self__, "network_type_acls", network_type_acls)
        pulumi.set(__self__, "policy", policy)
        pulumi.set(__self__, "policy_version", policy_version)
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "table_quota", table_quota)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "user_id", user_id)

    @_builtins.property
    @pulumi.getter(name="clusterType")
    def cluster_type(self) -> _builtins.str:
        """
        The cluster type of the instance. Possible values: `SSD`, `HYBRID`.
        """
        return pulumi.get(self, "cluster_type")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The create time of the instance.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the instance.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="entityQuota")
    def entity_quota(self) -> _builtins.int:
        """
        (Removed since v1.221.0) The instance quota which indicating the maximum number of tables.
        """
        return pulumi.get(self, "entity_quota")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        ID of the instance.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Instance name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def network(self) -> _builtins.str:
        """
        (Removed since v1.221.0) The network type of the instance. Possible values: `NORMAL`, `VPC`, `VPC_CONSOLE`.
        """
        return pulumi.get(self, "network")

    @_builtins.property
    @pulumi.getter(name="networkSourceAcls")
    def network_source_acls(self) -> Sequence[_builtins.str]:
        """
        (Available since v1.221.0) The set of request sources that are allowed access. Possible values: `TRUST_PROXY`.
        """
        return pulumi.get(self, "network_source_acls")

    @_builtins.property
    @pulumi.getter(name="networkTypeAcls")
    def network_type_acls(self) -> Sequence[_builtins.str]:
        """
        (Available since v1.221.0) The set of network types that are allowed access. Possible values: `CLASSIC`, `VPC`, `INTERNET`.
        """
        return pulumi.get(self, "network_type_acls")

    @_builtins.property
    @pulumi.getter
    def policy(self) -> _builtins.str:
        """
        (Available since v1.221.0) instance policy, json string.
        """
        return pulumi.get(self, "policy")

    @_builtins.property
    @pulumi.getter(name="policyVersion")
    def policy_version(self) -> _builtins.int:
        """
        (Available since v1.221.0) instance policy version.
        """
        return pulumi.get(self, "policy_version")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> _builtins.str:
        """
        (Available since v1.221.0) The resource group the instance belongs to.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Instance status. Possible values: `Running`, `Disabled`, `Deleting`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="tableQuota")
    def table_quota(self) -> _builtins.int:
        """
        (Available since v1.221.0) The instance quota which indicating the maximum number of tables.
        """
        return pulumi.get(self, "table_quota")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        A map of tags assigned to the instance. It must be in the format:
        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        instances_ds = alicloud.ots.get_instances(tags={
            "tagKey1": "tagValue1",
            "tagKey2": "tagValue2",
        })
        ```
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> _builtins.str:
        """
        The user id of the instance.
        """
        return pulumi.get(self, "user_id")


@pulumi.output_type
class GetSearchIndexesIndexResult(dict):
    def __init__(__self__, *,
                 create_time: _builtins.int,
                 current_sync_timestamp: _builtins.int,
                 id: _builtins.str,
                 index_name: _builtins.str,
                 instance_name: _builtins.str,
                 metering_last_update_time: _builtins.int,
                 reserved_read_cu: _builtins.int,
                 row_count: _builtins.int,
                 schema: _builtins.str,
                 storage_size: _builtins.int,
                 sync_phase: _builtins.str,
                 table_name: _builtins.str,
                 time_to_live: _builtins.int):
        """
        :param _builtins.int create_time: The creation time of the index.
        :param _builtins.int current_sync_timestamp: Timestamp for sync phase.
        :param _builtins.str id: The resource ID. The value is `<instance_name>:<table_name>:<indexName>:<indexType>`.
        :param _builtins.str index_name: The index name of the OTS Table which could not be changed.
        :param _builtins.str instance_name: The name of OTS instance.
        :param _builtins.int metering_last_update_time: Last update time for metering data..
        :param _builtins.int reserved_read_cu: Reserve related resources for the index.
        :param _builtins.int row_count: The number of rows of data for index.
        :param _builtins.str schema: JSON representation of the schema of index.
        :param _builtins.int storage_size: Storage space occupied by index.
        :param _builtins.str sync_phase: The synchronization state of the index.
        :param _builtins.str table_name: The name of OTS table.
        :param _builtins.int time_to_live: TTL of index.
        """
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "current_sync_timestamp", current_sync_timestamp)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "index_name", index_name)
        pulumi.set(__self__, "instance_name", instance_name)
        pulumi.set(__self__, "metering_last_update_time", metering_last_update_time)
        pulumi.set(__self__, "reserved_read_cu", reserved_read_cu)
        pulumi.set(__self__, "row_count", row_count)
        pulumi.set(__self__, "schema", schema)
        pulumi.set(__self__, "storage_size", storage_size)
        pulumi.set(__self__, "sync_phase", sync_phase)
        pulumi.set(__self__, "table_name", table_name)
        pulumi.set(__self__, "time_to_live", time_to_live)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.int:
        """
        The creation time of the index.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="currentSyncTimestamp")
    def current_sync_timestamp(self) -> _builtins.int:
        """
        Timestamp for sync phase.
        """
        return pulumi.get(self, "current_sync_timestamp")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The resource ID. The value is `<instance_name>:<table_name>:<indexName>:<indexType>`.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="indexName")
    def index_name(self) -> _builtins.str:
        """
        The index name of the OTS Table which could not be changed.
        """
        return pulumi.get(self, "index_name")

    @_builtins.property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> _builtins.str:
        """
        The name of OTS instance.
        """
        return pulumi.get(self, "instance_name")

    @_builtins.property
    @pulumi.getter(name="meteringLastUpdateTime")
    def metering_last_update_time(self) -> _builtins.int:
        """
        Last update time for metering data..
        """
        return pulumi.get(self, "metering_last_update_time")

    @_builtins.property
    @pulumi.getter(name="reservedReadCu")
    def reserved_read_cu(self) -> _builtins.int:
        """
        Reserve related resources for the index.
        """
        return pulumi.get(self, "reserved_read_cu")

    @_builtins.property
    @pulumi.getter(name="rowCount")
    def row_count(self) -> _builtins.int:
        """
        The number of rows of data for index.
        """
        return pulumi.get(self, "row_count")

    @_builtins.property
    @pulumi.getter
    def schema(self) -> _builtins.str:
        """
        JSON representation of the schema of index.
        """
        return pulumi.get(self, "schema")

    @_builtins.property
    @pulumi.getter(name="storageSize")
    def storage_size(self) -> _builtins.int:
        """
        Storage space occupied by index.
        """
        return pulumi.get(self, "storage_size")

    @_builtins.property
    @pulumi.getter(name="syncPhase")
    def sync_phase(self) -> _builtins.str:
        """
        The synchronization state of the index.
        """
        return pulumi.get(self, "sync_phase")

    @_builtins.property
    @pulumi.getter(name="tableName")
    def table_name(self) -> _builtins.str:
        """
        The name of OTS table.
        """
        return pulumi.get(self, "table_name")

    @_builtins.property
    @pulumi.getter(name="timeToLive")
    def time_to_live(self) -> _builtins.int:
        """
        TTL of index.
        """
        return pulumi.get(self, "time_to_live")


@pulumi.output_type
class GetSecondaryIndexesIndexResult(dict):
    def __init__(__self__, *,
                 defined_columns: Sequence[_builtins.str],
                 id: _builtins.str,
                 index_name: _builtins.str,
                 index_type: _builtins.str,
                 instance_name: _builtins.str,
                 primary_keys: Sequence[_builtins.str],
                 table_name: _builtins.str):
        """
        :param Sequence[_builtins.str] defined_columns: A list of defined column for index, referenced from Table's primary keys or predefined columns.
        :param _builtins.str id: The resource ID. The value is `<instance_name>:<table_name>:<indexName>:<indexType>`.
        :param _builtins.str index_name: The index name of the OTS Table which could not be changed.
        :param _builtins.str index_type: The index type of the OTS Table which could not be changed.
        :param _builtins.str instance_name: The name of OTS instance.
        :param Sequence[_builtins.str] primary_keys: A list of primary keys for index, referenced from Table's primary keys or predefined columns.
        :param _builtins.str table_name: The name of OTS table.
        """
        pulumi.set(__self__, "defined_columns", defined_columns)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "index_name", index_name)
        pulumi.set(__self__, "index_type", index_type)
        pulumi.set(__self__, "instance_name", instance_name)
        pulumi.set(__self__, "primary_keys", primary_keys)
        pulumi.set(__self__, "table_name", table_name)

    @_builtins.property
    @pulumi.getter(name="definedColumns")
    def defined_columns(self) -> Sequence[_builtins.str]:
        """
        A list of defined column for index, referenced from Table's primary keys or predefined columns.
        """
        return pulumi.get(self, "defined_columns")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The resource ID. The value is `<instance_name>:<table_name>:<indexName>:<indexType>`.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="indexName")
    def index_name(self) -> _builtins.str:
        """
        The index name of the OTS Table which could not be changed.
        """
        return pulumi.get(self, "index_name")

    @_builtins.property
    @pulumi.getter(name="indexType")
    def index_type(self) -> _builtins.str:
        """
        The index type of the OTS Table which could not be changed.
        """
        return pulumi.get(self, "index_type")

    @_builtins.property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> _builtins.str:
        """
        The name of OTS instance.
        """
        return pulumi.get(self, "instance_name")

    @_builtins.property
    @pulumi.getter(name="primaryKeys")
    def primary_keys(self) -> Sequence[_builtins.str]:
        """
        A list of primary keys for index, referenced from Table's primary keys or predefined columns.
        """
        return pulumi.get(self, "primary_keys")

    @_builtins.property
    @pulumi.getter(name="tableName")
    def table_name(self) -> _builtins.str:
        """
        The name of OTS table.
        """
        return pulumi.get(self, "table_name")


@pulumi.output_type
class GetTablesTableResult(dict):
    def __init__(__self__, *,
                 defined_columns: Sequence['outputs.GetTablesTableDefinedColumnResult'],
                 id: _builtins.str,
                 instance_name: _builtins.str,
                 max_version: _builtins.int,
                 primary_keys: Sequence['outputs.GetTablesTablePrimaryKeyResult'],
                 table_name: _builtins.str,
                 time_to_live: _builtins.int):
        """
        :param _builtins.str id: ID of the table. The value is `<instance_name>:<table_name>`.
        :param _builtins.str instance_name: The name of OTS instance.
        :param _builtins.int max_version: The maximum number of versions stored in this table.
        :param Sequence['GetTablesTablePrimaryKeyArgs'] primary_keys: The property of `TableMeta` which indicates the structure information of a table.
        :param _builtins.str table_name: The table name of the OTS which could not be changed.
        :param _builtins.int time_to_live: The retention time of data stored in this table.
        """
        pulumi.set(__self__, "defined_columns", defined_columns)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_name", instance_name)
        pulumi.set(__self__, "max_version", max_version)
        pulumi.set(__self__, "primary_keys", primary_keys)
        pulumi.set(__self__, "table_name", table_name)
        pulumi.set(__self__, "time_to_live", time_to_live)

    @_builtins.property
    @pulumi.getter(name="definedColumns")
    def defined_columns(self) -> Sequence['outputs.GetTablesTableDefinedColumnResult']:
        return pulumi.get(self, "defined_columns")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        ID of the table. The value is `<instance_name>:<table_name>`.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> _builtins.str:
        """
        The name of OTS instance.
        """
        return pulumi.get(self, "instance_name")

    @_builtins.property
    @pulumi.getter(name="maxVersion")
    def max_version(self) -> _builtins.int:
        """
        The maximum number of versions stored in this table.
        """
        return pulumi.get(self, "max_version")

    @_builtins.property
    @pulumi.getter(name="primaryKeys")
    def primary_keys(self) -> Sequence['outputs.GetTablesTablePrimaryKeyResult']:
        """
        The property of `TableMeta` which indicates the structure information of a table.
        """
        return pulumi.get(self, "primary_keys")

    @_builtins.property
    @pulumi.getter(name="tableName")
    def table_name(self) -> _builtins.str:
        """
        The table name of the OTS which could not be changed.
        """
        return pulumi.get(self, "table_name")

    @_builtins.property
    @pulumi.getter(name="timeToLive")
    def time_to_live(self) -> _builtins.int:
        """
        The retention time of data stored in this table.
        """
        return pulumi.get(self, "time_to_live")


@pulumi.output_type
class GetTablesTableDefinedColumnResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 type: _builtins.str):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        return pulumi.get(self, "type")


@pulumi.output_type
class GetTablesTablePrimaryKeyResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 type: _builtins.str):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        return pulumi.get(self, "type")


@pulumi.output_type
class GetTunnelsTunnelResult(dict):
    def __init__(__self__, *,
                 channels: Sequence['outputs.GetTunnelsTunnelChannelResult'],
                 create_time: _builtins.int,
                 expired: _builtins.bool,
                 id: _builtins.str,
                 instance_name: _builtins.str,
                 table_name: _builtins.str,
                 tunnel_id: _builtins.str,
                 tunnel_name: _builtins.str,
                 tunnel_rpo: _builtins.int,
                 tunnel_stage: _builtins.str,
                 tunnel_type: _builtins.str):
        """
        :param Sequence['GetTunnelsTunnelChannelArgs'] channels: The channels of OTS tunnel. Each element contains the following attributes:
        :param _builtins.int create_time: The creation time of the Tunnel.
        :param _builtins.bool expired: Whether the tunnel has expired.
        :param _builtins.str id: The resource ID. The value is `<instance_name>:<table_name>:<tunnel_name>`.
        :param _builtins.str instance_name: The name of OTS instance.
        :param _builtins.str table_name: The name of OTS table.
        :param _builtins.str tunnel_id: The tunnel id of the OTS which could not be changed.
        :param _builtins.str tunnel_name: The tunnel name of the OTS which could not be changed.
        :param _builtins.int tunnel_rpo: The latest consumption time of the tunnel, unix time in nanosecond.
        :param _builtins.str tunnel_stage: The stage of OTS tunnel, valid values: `InitBaseDataAndStreamShard`, `ProcessBaseData`, `ProcessStream`.
        :param _builtins.str tunnel_type: The type of the OTS tunnel, valid values: `BaseAndStream`, `BaseData`, `Stream`.
        """
        pulumi.set(__self__, "channels", channels)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "expired", expired)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_name", instance_name)
        pulumi.set(__self__, "table_name", table_name)
        pulumi.set(__self__, "tunnel_id", tunnel_id)
        pulumi.set(__self__, "tunnel_name", tunnel_name)
        pulumi.set(__self__, "tunnel_rpo", tunnel_rpo)
        pulumi.set(__self__, "tunnel_stage", tunnel_stage)
        pulumi.set(__self__, "tunnel_type", tunnel_type)

    @_builtins.property
    @pulumi.getter
    def channels(self) -> Sequence['outputs.GetTunnelsTunnelChannelResult']:
        """
        The channels of OTS tunnel. Each element contains the following attributes:
        """
        return pulumi.get(self, "channels")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.int:
        """
        The creation time of the Tunnel.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def expired(self) -> _builtins.bool:
        """
        Whether the tunnel has expired.
        """
        return pulumi.get(self, "expired")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The resource ID. The value is `<instance_name>:<table_name>:<tunnel_name>`.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> _builtins.str:
        """
        The name of OTS instance.
        """
        return pulumi.get(self, "instance_name")

    @_builtins.property
    @pulumi.getter(name="tableName")
    def table_name(self) -> _builtins.str:
        """
        The name of OTS table.
        """
        return pulumi.get(self, "table_name")

    @_builtins.property
    @pulumi.getter(name="tunnelId")
    def tunnel_id(self) -> _builtins.str:
        """
        The tunnel id of the OTS which could not be changed.
        """
        return pulumi.get(self, "tunnel_id")

    @_builtins.property
    @pulumi.getter(name="tunnelName")
    def tunnel_name(self) -> _builtins.str:
        """
        The tunnel name of the OTS which could not be changed.
        """
        return pulumi.get(self, "tunnel_name")

    @_builtins.property
    @pulumi.getter(name="tunnelRpo")
    def tunnel_rpo(self) -> _builtins.int:
        """
        The latest consumption time of the tunnel, unix time in nanosecond.
        """
        return pulumi.get(self, "tunnel_rpo")

    @_builtins.property
    @pulumi.getter(name="tunnelStage")
    def tunnel_stage(self) -> _builtins.str:
        """
        The stage of OTS tunnel, valid values: `InitBaseDataAndStreamShard`, `ProcessBaseData`, `ProcessStream`.
        """
        return pulumi.get(self, "tunnel_stage")

    @_builtins.property
    @pulumi.getter(name="tunnelType")
    def tunnel_type(self) -> _builtins.str:
        """
        The type of the OTS tunnel, valid values: `BaseAndStream`, `BaseData`, `Stream`.
        """
        return pulumi.get(self, "tunnel_type")


@pulumi.output_type
class GetTunnelsTunnelChannelResult(dict):
    def __init__(__self__, *,
                 channel_id: _builtins.str,
                 channel_rpo: _builtins.int,
                 channel_status: _builtins.str,
                 channel_type: _builtins.str,
                 client_id: _builtins.str):
        """
        :param _builtins.str channel_id: The id of the channel.
        :param _builtins.int channel_rpo: The latest consumption time of the channel, unix time in nanosecond
        :param _builtins.str channel_status: The status of the channel, valid values: `WAIT`, `OPEN`, `CLOSING`, `CLOSE`, `TERMINATED`.
        :param _builtins.str channel_type: The type of the channel, valid values: `BaseData`, `Stream`.
        :param _builtins.str client_id: The client id of the channel.
        """
        pulumi.set(__self__, "channel_id", channel_id)
        pulumi.set(__self__, "channel_rpo", channel_rpo)
        pulumi.set(__self__, "channel_status", channel_status)
        pulumi.set(__self__, "channel_type", channel_type)
        pulumi.set(__self__, "client_id", client_id)

    @_builtins.property
    @pulumi.getter(name="channelId")
    def channel_id(self) -> _builtins.str:
        """
        The id of the channel.
        """
        return pulumi.get(self, "channel_id")

    @_builtins.property
    @pulumi.getter(name="channelRpo")
    def channel_rpo(self) -> _builtins.int:
        """
        The latest consumption time of the channel, unix time in nanosecond
        """
        return pulumi.get(self, "channel_rpo")

    @_builtins.property
    @pulumi.getter(name="channelStatus")
    def channel_status(self) -> _builtins.str:
        """
        The status of the channel, valid values: `WAIT`, `OPEN`, `CLOSING`, `CLOSE`, `TERMINATED`.
        """
        return pulumi.get(self, "channel_status")

    @_builtins.property
    @pulumi.getter(name="channelType")
    def channel_type(self) -> _builtins.str:
        """
        The type of the channel, valid values: `BaseData`, `Stream`.
        """
        return pulumi.get(self, "channel_type")

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> _builtins.str:
        """
        The client id of the channel.
        """
        return pulumi.get(self, "client_id")


