# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['WorkspaceCodeSourceArgs', 'WorkspaceCodeSource']

@pulumi.input_type
class WorkspaceCodeSourceArgs:
    def __init__(__self__, *,
                 accessibility: pulumi.Input[_builtins.str],
                 code_repo: pulumi.Input[_builtins.str],
                 display_name: pulumi.Input[_builtins.str],
                 mount_path: pulumi.Input[_builtins.str],
                 workspace_id: pulumi.Input[_builtins.str],
                 code_branch: Optional[pulumi.Input[_builtins.str]] = None,
                 code_commit: Optional[pulumi.Input[_builtins.str]] = None,
                 code_repo_access_token: Optional[pulumi.Input[_builtins.str]] = None,
                 code_repo_user_name: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a WorkspaceCodeSource resource.
        :param pulumi.Input[_builtins.str] accessibility: Visibility of the code configuration, possible values:
               - PRIVATE: In this workspace, it is only visible to you and the administrator.
               - PUBLIC: In this workspace, it is visible to everyone.
        :param pulumi.Input[_builtins.str] code_repo: Code repository address.
        :param pulumi.Input[_builtins.str] display_name: Code source configuration name.
        :param pulumi.Input[_builtins.str] mount_path: The local Mount Directory of the code.
        :param pulumi.Input[_builtins.str] workspace_id: The ID of the workspace.
        :param pulumi.Input[_builtins.str] code_branch: Code repository branch.
        :param pulumi.Input[_builtins.str] code_commit: The code CommitId.
        :param pulumi.Input[_builtins.str] code_repo_access_token: The Token used to access the code repository.
        :param pulumi.Input[_builtins.str] code_repo_user_name: The user name of the code repository.
        :param pulumi.Input[_builtins.str] description: A detailed description of the code configuration.
        """
        pulumi.set(__self__, "accessibility", accessibility)
        pulumi.set(__self__, "code_repo", code_repo)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "mount_path", mount_path)
        pulumi.set(__self__, "workspace_id", workspace_id)
        if code_branch is not None:
            pulumi.set(__self__, "code_branch", code_branch)
        if code_commit is not None:
            pulumi.set(__self__, "code_commit", code_commit)
        if code_repo_access_token is not None:
            pulumi.set(__self__, "code_repo_access_token", code_repo_access_token)
        if code_repo_user_name is not None:
            pulumi.set(__self__, "code_repo_user_name", code_repo_user_name)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def accessibility(self) -> pulumi.Input[_builtins.str]:
        """
        Visibility of the code configuration, possible values:
        - PRIVATE: In this workspace, it is only visible to you and the administrator.
        - PUBLIC: In this workspace, it is visible to everyone.
        """
        return pulumi.get(self, "accessibility")

    @accessibility.setter
    def accessibility(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "accessibility", value)

    @_builtins.property
    @pulumi.getter(name="codeRepo")
    def code_repo(self) -> pulumi.Input[_builtins.str]:
        """
        Code repository address.
        """
        return pulumi.get(self, "code_repo")

    @code_repo.setter
    def code_repo(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "code_repo", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        Code source configuration name.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="mountPath")
    def mount_path(self) -> pulumi.Input[_builtins.str]:
        """
        The local Mount Directory of the code.
        """
        return pulumi.get(self, "mount_path")

    @mount_path.setter
    def mount_path(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "mount_path", value)

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the workspace.
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "workspace_id", value)

    @_builtins.property
    @pulumi.getter(name="codeBranch")
    def code_branch(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Code repository branch.
        """
        return pulumi.get(self, "code_branch")

    @code_branch.setter
    def code_branch(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "code_branch", value)

    @_builtins.property
    @pulumi.getter(name="codeCommit")
    def code_commit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The code CommitId.
        """
        return pulumi.get(self, "code_commit")

    @code_commit.setter
    def code_commit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "code_commit", value)

    @_builtins.property
    @pulumi.getter(name="codeRepoAccessToken")
    def code_repo_access_token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Token used to access the code repository.
        """
        return pulumi.get(self, "code_repo_access_token")

    @code_repo_access_token.setter
    def code_repo_access_token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "code_repo_access_token", value)

    @_builtins.property
    @pulumi.getter(name="codeRepoUserName")
    def code_repo_user_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The user name of the code repository.
        """
        return pulumi.get(self, "code_repo_user_name")

    @code_repo_user_name.setter
    def code_repo_user_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "code_repo_user_name", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A detailed description of the code configuration.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class _WorkspaceCodeSourceState:
    def __init__(__self__, *,
                 accessibility: Optional[pulumi.Input[_builtins.str]] = None,
                 code_branch: Optional[pulumi.Input[_builtins.str]] = None,
                 code_commit: Optional[pulumi.Input[_builtins.str]] = None,
                 code_repo: Optional[pulumi.Input[_builtins.str]] = None,
                 code_repo_access_token: Optional[pulumi.Input[_builtins.str]] = None,
                 code_repo_user_name: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 mount_path: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering WorkspaceCodeSource resources.
        :param pulumi.Input[_builtins.str] accessibility: Visibility of the code configuration, possible values:
               - PRIVATE: In this workspace, it is only visible to you and the administrator.
               - PUBLIC: In this workspace, it is visible to everyone.
        :param pulumi.Input[_builtins.str] code_branch: Code repository branch.
        :param pulumi.Input[_builtins.str] code_commit: The code CommitId.
        :param pulumi.Input[_builtins.str] code_repo: Code repository address.
        :param pulumi.Input[_builtins.str] code_repo_access_token: The Token used to access the code repository.
        :param pulumi.Input[_builtins.str] code_repo_user_name: The user name of the code repository.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the resource
        :param pulumi.Input[_builtins.str] description: A detailed description of the code configuration.
        :param pulumi.Input[_builtins.str] display_name: Code source configuration name.
        :param pulumi.Input[_builtins.str] mount_path: The local Mount Directory of the code.
        :param pulumi.Input[_builtins.str] workspace_id: The ID of the workspace.
        """
        if accessibility is not None:
            pulumi.set(__self__, "accessibility", accessibility)
        if code_branch is not None:
            pulumi.set(__self__, "code_branch", code_branch)
        if code_commit is not None:
            pulumi.set(__self__, "code_commit", code_commit)
        if code_repo is not None:
            pulumi.set(__self__, "code_repo", code_repo)
        if code_repo_access_token is not None:
            pulumi.set(__self__, "code_repo_access_token", code_repo_access_token)
        if code_repo_user_name is not None:
            pulumi.set(__self__, "code_repo_user_name", code_repo_user_name)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if mount_path is not None:
            pulumi.set(__self__, "mount_path", mount_path)
        if workspace_id is not None:
            pulumi.set(__self__, "workspace_id", workspace_id)

    @_builtins.property
    @pulumi.getter
    def accessibility(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Visibility of the code configuration, possible values:
        - PRIVATE: In this workspace, it is only visible to you and the administrator.
        - PUBLIC: In this workspace, it is visible to everyone.
        """
        return pulumi.get(self, "accessibility")

    @accessibility.setter
    def accessibility(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "accessibility", value)

    @_builtins.property
    @pulumi.getter(name="codeBranch")
    def code_branch(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Code repository branch.
        """
        return pulumi.get(self, "code_branch")

    @code_branch.setter
    def code_branch(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "code_branch", value)

    @_builtins.property
    @pulumi.getter(name="codeCommit")
    def code_commit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The code CommitId.
        """
        return pulumi.get(self, "code_commit")

    @code_commit.setter
    def code_commit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "code_commit", value)

    @_builtins.property
    @pulumi.getter(name="codeRepo")
    def code_repo(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Code repository address.
        """
        return pulumi.get(self, "code_repo")

    @code_repo.setter
    def code_repo(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "code_repo", value)

    @_builtins.property
    @pulumi.getter(name="codeRepoAccessToken")
    def code_repo_access_token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Token used to access the code repository.
        """
        return pulumi.get(self, "code_repo_access_token")

    @code_repo_access_token.setter
    def code_repo_access_token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "code_repo_access_token", value)

    @_builtins.property
    @pulumi.getter(name="codeRepoUserName")
    def code_repo_user_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The user name of the code repository.
        """
        return pulumi.get(self, "code_repo_user_name")

    @code_repo_user_name.setter
    def code_repo_user_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "code_repo_user_name", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation time of the resource
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A detailed description of the code configuration.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Code source configuration name.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="mountPath")
    def mount_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The local Mount Directory of the code.
        """
        return pulumi.get(self, "mount_path")

    @mount_path.setter
    def mount_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mount_path", value)

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the workspace.
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "workspace_id", value)


@pulumi.type_token("alicloud:pai/workspaceCodeSource:WorkspaceCodeSource")
class WorkspaceCodeSource(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accessibility: Optional[pulumi.Input[_builtins.str]] = None,
                 code_branch: Optional[pulumi.Input[_builtins.str]] = None,
                 code_commit: Optional[pulumi.Input[_builtins.str]] = None,
                 code_repo: Optional[pulumi.Input[_builtins.str]] = None,
                 code_repo_access_token: Optional[pulumi.Input[_builtins.str]] = None,
                 code_repo_user_name: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 mount_path: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a PAI Workspace Code Source resource.

        For information about PAI Workspace Code Source and how to use it, see [What is Code Source](https://next.api.alibabacloud.com/document/AIWorkSpace/2021-02-04/CreateCodeSource).

        > **NOTE:** Available since v1.236.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform_example"
        defaultgkl_bn_m = alicloud.pai.WorkspaceWorkspace("defaultgklBnM",
            description="for-pop-example",
            display_name="CodeSourceTest_1732796227",
            workspace_name=name,
            env_types=["prod"])
        default = alicloud.pai.WorkspaceCodeSource("default",
            mount_path="/mnt/code/dir_01/",
            code_repo="https://github.com/mattn/go-sqlite3.git",
            description="desc-01",
            code_repo_access_token="token-01",
            accessibility="PRIVATE",
            display_name="codesource-example-01",
            workspace_id=defaultgkl_bn_m.id,
            code_branch="master",
            code_repo_user_name="user-01")
        ```

        ## Import

        PAI Workspace Code Source can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:pai/workspaceCodeSource:WorkspaceCodeSource example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] accessibility: Visibility of the code configuration, possible values:
               - PRIVATE: In this workspace, it is only visible to you and the administrator.
               - PUBLIC: In this workspace, it is visible to everyone.
        :param pulumi.Input[_builtins.str] code_branch: Code repository branch.
        :param pulumi.Input[_builtins.str] code_commit: The code CommitId.
        :param pulumi.Input[_builtins.str] code_repo: Code repository address.
        :param pulumi.Input[_builtins.str] code_repo_access_token: The Token used to access the code repository.
        :param pulumi.Input[_builtins.str] code_repo_user_name: The user name of the code repository.
        :param pulumi.Input[_builtins.str] description: A detailed description of the code configuration.
        :param pulumi.Input[_builtins.str] display_name: Code source configuration name.
        :param pulumi.Input[_builtins.str] mount_path: The local Mount Directory of the code.
        :param pulumi.Input[_builtins.str] workspace_id: The ID of the workspace.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WorkspaceCodeSourceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a PAI Workspace Code Source resource.

        For information about PAI Workspace Code Source and how to use it, see [What is Code Source](https://next.api.alibabacloud.com/document/AIWorkSpace/2021-02-04/CreateCodeSource).

        > **NOTE:** Available since v1.236.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform_example"
        defaultgkl_bn_m = alicloud.pai.WorkspaceWorkspace("defaultgklBnM",
            description="for-pop-example",
            display_name="CodeSourceTest_1732796227",
            workspace_name=name,
            env_types=["prod"])
        default = alicloud.pai.WorkspaceCodeSource("default",
            mount_path="/mnt/code/dir_01/",
            code_repo="https://github.com/mattn/go-sqlite3.git",
            description="desc-01",
            code_repo_access_token="token-01",
            accessibility="PRIVATE",
            display_name="codesource-example-01",
            workspace_id=defaultgkl_bn_m.id,
            code_branch="master",
            code_repo_user_name="user-01")
        ```

        ## Import

        PAI Workspace Code Source can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:pai/workspaceCodeSource:WorkspaceCodeSource example <id>
        ```

        :param str resource_name: The name of the resource.
        :param WorkspaceCodeSourceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WorkspaceCodeSourceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accessibility: Optional[pulumi.Input[_builtins.str]] = None,
                 code_branch: Optional[pulumi.Input[_builtins.str]] = None,
                 code_commit: Optional[pulumi.Input[_builtins.str]] = None,
                 code_repo: Optional[pulumi.Input[_builtins.str]] = None,
                 code_repo_access_token: Optional[pulumi.Input[_builtins.str]] = None,
                 code_repo_user_name: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 mount_path: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WorkspaceCodeSourceArgs.__new__(WorkspaceCodeSourceArgs)

            if accessibility is None and not opts.urn:
                raise TypeError("Missing required property 'accessibility'")
            __props__.__dict__["accessibility"] = accessibility
            __props__.__dict__["code_branch"] = code_branch
            __props__.__dict__["code_commit"] = code_commit
            if code_repo is None and not opts.urn:
                raise TypeError("Missing required property 'code_repo'")
            __props__.__dict__["code_repo"] = code_repo
            __props__.__dict__["code_repo_access_token"] = code_repo_access_token
            __props__.__dict__["code_repo_user_name"] = code_repo_user_name
            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            if mount_path is None and not opts.urn:
                raise TypeError("Missing required property 'mount_path'")
            __props__.__dict__["mount_path"] = mount_path
            if workspace_id is None and not opts.urn:
                raise TypeError("Missing required property 'workspace_id'")
            __props__.__dict__["workspace_id"] = workspace_id
            __props__.__dict__["create_time"] = None
        super(WorkspaceCodeSource, __self__).__init__(
            'alicloud:pai/workspaceCodeSource:WorkspaceCodeSource',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            accessibility: Optional[pulumi.Input[_builtins.str]] = None,
            code_branch: Optional[pulumi.Input[_builtins.str]] = None,
            code_commit: Optional[pulumi.Input[_builtins.str]] = None,
            code_repo: Optional[pulumi.Input[_builtins.str]] = None,
            code_repo_access_token: Optional[pulumi.Input[_builtins.str]] = None,
            code_repo_user_name: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            mount_path: Optional[pulumi.Input[_builtins.str]] = None,
            workspace_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'WorkspaceCodeSource':
        """
        Get an existing WorkspaceCodeSource resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] accessibility: Visibility of the code configuration, possible values:
               - PRIVATE: In this workspace, it is only visible to you and the administrator.
               - PUBLIC: In this workspace, it is visible to everyone.
        :param pulumi.Input[_builtins.str] code_branch: Code repository branch.
        :param pulumi.Input[_builtins.str] code_commit: The code CommitId.
        :param pulumi.Input[_builtins.str] code_repo: Code repository address.
        :param pulumi.Input[_builtins.str] code_repo_access_token: The Token used to access the code repository.
        :param pulumi.Input[_builtins.str] code_repo_user_name: The user name of the code repository.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the resource
        :param pulumi.Input[_builtins.str] description: A detailed description of the code configuration.
        :param pulumi.Input[_builtins.str] display_name: Code source configuration name.
        :param pulumi.Input[_builtins.str] mount_path: The local Mount Directory of the code.
        :param pulumi.Input[_builtins.str] workspace_id: The ID of the workspace.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WorkspaceCodeSourceState.__new__(_WorkspaceCodeSourceState)

        __props__.__dict__["accessibility"] = accessibility
        __props__.__dict__["code_branch"] = code_branch
        __props__.__dict__["code_commit"] = code_commit
        __props__.__dict__["code_repo"] = code_repo
        __props__.__dict__["code_repo_access_token"] = code_repo_access_token
        __props__.__dict__["code_repo_user_name"] = code_repo_user_name
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["mount_path"] = mount_path
        __props__.__dict__["workspace_id"] = workspace_id
        return WorkspaceCodeSource(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def accessibility(self) -> pulumi.Output[_builtins.str]:
        """
        Visibility of the code configuration, possible values:
        - PRIVATE: In this workspace, it is only visible to you and the administrator.
        - PUBLIC: In this workspace, it is visible to everyone.
        """
        return pulumi.get(self, "accessibility")

    @_builtins.property
    @pulumi.getter(name="codeBranch")
    def code_branch(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Code repository branch.
        """
        return pulumi.get(self, "code_branch")

    @_builtins.property
    @pulumi.getter(name="codeCommit")
    def code_commit(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The code CommitId.
        """
        return pulumi.get(self, "code_commit")

    @_builtins.property
    @pulumi.getter(name="codeRepo")
    def code_repo(self) -> pulumi.Output[_builtins.str]:
        """
        Code repository address.
        """
        return pulumi.get(self, "code_repo")

    @_builtins.property
    @pulumi.getter(name="codeRepoAccessToken")
    def code_repo_access_token(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Token used to access the code repository.
        """
        return pulumi.get(self, "code_repo_access_token")

    @_builtins.property
    @pulumi.getter(name="codeRepoUserName")
    def code_repo_user_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The user name of the code repository.
        """
        return pulumi.get(self, "code_repo_user_name")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The creation time of the resource
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A detailed description of the code configuration.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        Code source configuration name.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="mountPath")
    def mount_path(self) -> pulumi.Output[_builtins.str]:
        """
        The local Mount Directory of the code.
        """
        return pulumi.get(self, "mount_path")

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the workspace.
        """
        return pulumi.get(self, "workspace_id")

