# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from ._inputs import *

__all__ = ['ProviderArgs', 'Provider']

@pulumi.input_type
class ProviderArgs:
    def __init__(__self__, *,
                 access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 account_type: Optional[pulumi.Input[_builtins.str]] = None,
                 assume_role: Optional[pulumi.Input['ProviderAssumeRoleArgs']] = None,
                 assume_role_with_oidc: Optional[pulumi.Input['ProviderAssumeRoleWithOidcArgs']] = None,
                 client_connect_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 client_read_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 configuration_source: Optional[pulumi.Input[_builtins.str]] = None,
                 credentials_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 ecs_role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoints: Optional[pulumi.Input[Sequence[pulumi.Input['ProviderEndpointArgs']]]] = None,
                 fc: Optional[pulumi.Input[_builtins.str]] = None,
                 log_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 max_retry_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 mns_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 ots_instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 profile: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_key: Optional[pulumi.Input[_builtins.str]] = None,
                 secure_transport: Optional[pulumi.Input[_builtins.str]] = None,
                 security_token: Optional[pulumi.Input[_builtins.str]] = None,
                 security_transport: Optional[pulumi.Input[_builtins.str]] = None,
                 shared_credentials_file: Optional[pulumi.Input[_builtins.str]] = None,
                 sign_version: Optional[pulumi.Input['ProviderSignVersionArgs']] = None,
                 skip_region_validation: Optional[pulumi.Input[_builtins.bool]] = None,
                 source_ip: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Provider resource.
        :param pulumi.Input[_builtins.str] access_key: The access key for API operations. You can retrieve this from the 'Security Management' section of the Alibaba Cloud
               console.
        :param pulumi.Input[_builtins.str] account_id: The account ID for some service API operations. You can retrieve this from the 'Security Settings' section of the
               Alibaba Cloud console.
        :param pulumi.Input[_builtins.int] client_connect_timeout: The maximum timeout of the client connection server.
        :param pulumi.Input[_builtins.int] client_read_timeout: The maximum timeout of the client read request.
        :param pulumi.Input[_builtins.str] credentials_uri: The URI of sidecar credentials service.
        :param pulumi.Input[_builtins.str] ecs_role_name: The RAM Role Name attached on a ECS instance for API operations. You can retrieve this from the 'Access Control' section
               of the Alibaba Cloud console.
        :param pulumi.Input[_builtins.int] max_retry_timeout: The maximum retry timeout of the request.
        :param pulumi.Input[_builtins.str] profile: The profile for API operations. If not set, the default profile created with `aliyun configure` will be used.
        :param pulumi.Input[_builtins.str] region: The region where Alibaba Cloud operations will take place. Examples are cn-beijing, cn-hangzhou, eu-central-1, etc.
        :param pulumi.Input[_builtins.str] secret_key: The secret key for API operations. You can retrieve this from the 'Security Management' section of the Alibaba Cloud
               console.
        :param pulumi.Input[_builtins.str] secure_transport: The security transport for the assume role invoking.
        :param pulumi.Input[_builtins.str] security_token: security token. A security token is only required if you are using Security Token Service.
        :param pulumi.Input[_builtins.str] shared_credentials_file: The path to the shared credentials file. If not set this defaults to ~/.aliyun/config.json
        :param pulumi.Input[_builtins.bool] skip_region_validation: Skip static validation of region ID. Used by users of alternative AlibabaCloud-like APIs or users w/ access to regions
               that are not public (yet).
        :param pulumi.Input[_builtins.str] source_ip: The source ip for the assume role invoking.
        """
        if access_key is not None:
            pulumi.set(__self__, "access_key", access_key)
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if account_type is not None:
            pulumi.set(__self__, "account_type", account_type)
        if assume_role is not None:
            pulumi.set(__self__, "assume_role", assume_role)
        if assume_role_with_oidc is not None:
            pulumi.set(__self__, "assume_role_with_oidc", assume_role_with_oidc)
        if client_connect_timeout is not None:
            pulumi.set(__self__, "client_connect_timeout", client_connect_timeout)
        if client_read_timeout is not None:
            pulumi.set(__self__, "client_read_timeout", client_read_timeout)
        if configuration_source is not None:
            pulumi.set(__self__, "configuration_source", configuration_source)
        if credentials_uri is not None:
            pulumi.set(__self__, "credentials_uri", credentials_uri)
        if ecs_role_name is None:
            ecs_role_name = _utilities.get_env('ALICLOUD_ECS_ROLE_NAME')
        if ecs_role_name is not None:
            pulumi.set(__self__, "ecs_role_name", ecs_role_name)
        if endpoints is not None:
            pulumi.set(__self__, "endpoints", endpoints)
        if fc is not None:
            warnings.warn("""Field 'fc' has been deprecated from provider version 1.28.0. New field 'fc' which in nested endpoints instead.""", DeprecationWarning)
            pulumi.log.warn("""fc is deprecated: Field 'fc' has been deprecated from provider version 1.28.0. New field 'fc' which in nested endpoints instead.""")
        if fc is not None:
            pulumi.set(__self__, "fc", fc)
        if log_endpoint is not None:
            warnings.warn("""Field 'log_endpoint' has been deprecated from provider version 1.28.0. New field 'log' which in nested endpoints instead.""", DeprecationWarning)
            pulumi.log.warn("""log_endpoint is deprecated: Field 'log_endpoint' has been deprecated from provider version 1.28.0. New field 'log' which in nested endpoints instead.""")
        if log_endpoint is not None:
            pulumi.set(__self__, "log_endpoint", log_endpoint)
        if max_retry_timeout is not None:
            pulumi.set(__self__, "max_retry_timeout", max_retry_timeout)
        if mns_endpoint is not None:
            warnings.warn("""Field 'mns_endpoint' has been deprecated from provider version 1.28.0. New field 'mns' which in nested endpoints instead.""", DeprecationWarning)
            pulumi.log.warn("""mns_endpoint is deprecated: Field 'mns_endpoint' has been deprecated from provider version 1.28.0. New field 'mns' which in nested endpoints instead.""")
        if mns_endpoint is not None:
            pulumi.set(__self__, "mns_endpoint", mns_endpoint)
        if ots_instance_name is not None:
            warnings.warn("""Field 'ots_instance_name' has been deprecated from provider version 1.10.0. New field 'instance_name' of resource 'alicloud_ots_table' instead.""", DeprecationWarning)
            pulumi.log.warn("""ots_instance_name is deprecated: Field 'ots_instance_name' has been deprecated from provider version 1.10.0. New field 'instance_name' of resource 'alicloud_ots_table' instead.""")
        if ots_instance_name is not None:
            pulumi.set(__self__, "ots_instance_name", ots_instance_name)
        if profile is None:
            profile = _utilities.get_env('ALICLOUD_PROFILE')
        if profile is not None:
            pulumi.set(__self__, "profile", profile)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if region is None:
            region = _utilities.get_env('ALICLOUD_REGION')
        if region is not None:
            pulumi.set(__self__, "region", region)
        if secret_key is not None:
            pulumi.set(__self__, "secret_key", secret_key)
        if secure_transport is not None:
            pulumi.set(__self__, "secure_transport", secure_transport)
        if security_token is not None:
            pulumi.set(__self__, "security_token", security_token)
        if security_transport is not None:
            pulumi.set(__self__, "security_transport", security_transport)
        if shared_credentials_file is not None:
            pulumi.set(__self__, "shared_credentials_file", shared_credentials_file)
        if sign_version is not None:
            pulumi.set(__self__, "sign_version", sign_version)
        if skip_region_validation is not None:
            pulumi.set(__self__, "skip_region_validation", skip_region_validation)
        if source_ip is not None:
            pulumi.set(__self__, "source_ip", source_ip)

    @_builtins.property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The access key for API operations. You can retrieve this from the 'Security Management' section of the Alibaba Cloud
        console.
        """
        return pulumi.get(self, "access_key")

    @access_key.setter
    def access_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_key", value)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The account ID for some service API operations. You can retrieve this from the 'Security Settings' section of the
        Alibaba Cloud console.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter(name="accountType")
    def account_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "account_type")

    @account_type.setter
    def account_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_type", value)

    @_builtins.property
    @pulumi.getter(name="assumeRole")
    def assume_role(self) -> Optional[pulumi.Input['ProviderAssumeRoleArgs']]:
        return pulumi.get(self, "assume_role")

    @assume_role.setter
    def assume_role(self, value: Optional[pulumi.Input['ProviderAssumeRoleArgs']]):
        pulumi.set(self, "assume_role", value)

    @_builtins.property
    @pulumi.getter(name="assumeRoleWithOidc")
    def assume_role_with_oidc(self) -> Optional[pulumi.Input['ProviderAssumeRoleWithOidcArgs']]:
        return pulumi.get(self, "assume_role_with_oidc")

    @assume_role_with_oidc.setter
    def assume_role_with_oidc(self, value: Optional[pulumi.Input['ProviderAssumeRoleWithOidcArgs']]):
        pulumi.set(self, "assume_role_with_oidc", value)

    @_builtins.property
    @pulumi.getter(name="clientConnectTimeout")
    def client_connect_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum timeout of the client connection server.
        """
        return pulumi.get(self, "client_connect_timeout")

    @client_connect_timeout.setter
    def client_connect_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "client_connect_timeout", value)

    @_builtins.property
    @pulumi.getter(name="clientReadTimeout")
    def client_read_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum timeout of the client read request.
        """
        return pulumi.get(self, "client_read_timeout")

    @client_read_timeout.setter
    def client_read_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "client_read_timeout", value)

    @_builtins.property
    @pulumi.getter(name="configurationSource")
    def configuration_source(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "configuration_source")

    @configuration_source.setter
    def configuration_source(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "configuration_source", value)

    @_builtins.property
    @pulumi.getter(name="credentialsUri")
    def credentials_uri(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URI of sidecar credentials service.
        """
        return pulumi.get(self, "credentials_uri")

    @credentials_uri.setter
    def credentials_uri(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "credentials_uri", value)

    @_builtins.property
    @pulumi.getter(name="ecsRoleName")
    def ecs_role_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The RAM Role Name attached on a ECS instance for API operations. You can retrieve this from the 'Access Control' section
        of the Alibaba Cloud console.
        """
        return pulumi.get(self, "ecs_role_name")

    @ecs_role_name.setter
    def ecs_role_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ecs_role_name", value)

    @_builtins.property
    @pulumi.getter
    def endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProviderEndpointArgs']]]]:
        return pulumi.get(self, "endpoints")

    @endpoints.setter
    def endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProviderEndpointArgs']]]]):
        pulumi.set(self, "endpoints", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'fc' has been deprecated from provider version 1.28.0. New field 'fc' which in nested endpoints instead.""")
    def fc(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "fc")

    @fc.setter
    def fc(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fc", value)

    @_builtins.property
    @pulumi.getter(name="logEndpoint")
    @_utilities.deprecated("""Field 'log_endpoint' has been deprecated from provider version 1.28.0. New field 'log' which in nested endpoints instead.""")
    def log_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "log_endpoint")

    @log_endpoint.setter
    def log_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "log_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="maxRetryTimeout")
    def max_retry_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum retry timeout of the request.
        """
        return pulumi.get(self, "max_retry_timeout")

    @max_retry_timeout.setter
    def max_retry_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_retry_timeout", value)

    @_builtins.property
    @pulumi.getter(name="mnsEndpoint")
    @_utilities.deprecated("""Field 'mns_endpoint' has been deprecated from provider version 1.28.0. New field 'mns' which in nested endpoints instead.""")
    def mns_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "mns_endpoint")

    @mns_endpoint.setter
    def mns_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mns_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="otsInstanceName")
    @_utilities.deprecated("""Field 'ots_instance_name' has been deprecated from provider version 1.10.0. New field 'instance_name' of resource 'alicloud_ots_table' instead.""")
    def ots_instance_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "ots_instance_name")

    @ots_instance_name.setter
    def ots_instance_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ots_instance_name", value)

    @_builtins.property
    @pulumi.getter
    def profile(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The profile for API operations. If not set, the default profile created with `aliyun configure` will be used.
        """
        return pulumi.get(self, "profile")

    @profile.setter
    def profile(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "profile", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region where Alibaba Cloud operations will take place. Examples are cn-beijing, cn-hangzhou, eu-central-1, etc.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The secret key for API operations. You can retrieve this from the 'Security Management' section of the Alibaba Cloud
        console.
        """
        return pulumi.get(self, "secret_key")

    @secret_key.setter
    def secret_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secret_key", value)

    @_builtins.property
    @pulumi.getter(name="secureTransport")
    def secure_transport(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The security transport for the assume role invoking.
        """
        return pulumi.get(self, "secure_transport")

    @secure_transport.setter
    def secure_transport(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secure_transport", value)

    @_builtins.property
    @pulumi.getter(name="securityToken")
    def security_token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        security token. A security token is only required if you are using Security Token Service.
        """
        return pulumi.get(self, "security_token")

    @security_token.setter
    def security_token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_token", value)

    @_builtins.property
    @pulumi.getter(name="securityTransport")
    def security_transport(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "security_transport")

    @security_transport.setter
    def security_transport(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_transport", value)

    @_builtins.property
    @pulumi.getter(name="sharedCredentialsFile")
    def shared_credentials_file(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The path to the shared credentials file. If not set this defaults to ~/.aliyun/config.json
        """
        return pulumi.get(self, "shared_credentials_file")

    @shared_credentials_file.setter
    def shared_credentials_file(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "shared_credentials_file", value)

    @_builtins.property
    @pulumi.getter(name="signVersion")
    def sign_version(self) -> Optional[pulumi.Input['ProviderSignVersionArgs']]:
        return pulumi.get(self, "sign_version")

    @sign_version.setter
    def sign_version(self, value: Optional[pulumi.Input['ProviderSignVersionArgs']]):
        pulumi.set(self, "sign_version", value)

    @_builtins.property
    @pulumi.getter(name="skipRegionValidation")
    def skip_region_validation(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Skip static validation of region ID. Used by users of alternative AlibabaCloud-like APIs or users w/ access to regions
        that are not public (yet).
        """
        return pulumi.get(self, "skip_region_validation")

    @skip_region_validation.setter
    def skip_region_validation(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "skip_region_validation", value)

    @_builtins.property
    @pulumi.getter(name="sourceIp")
    def source_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The source ip for the assume role invoking.
        """
        return pulumi.get(self, "source_ip")

    @source_ip.setter
    def source_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_ip", value)


@pulumi.type_token("pulumi:providers:alicloud")
class Provider(pulumi.ProviderResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 account_type: Optional[pulumi.Input[_builtins.str]] = None,
                 assume_role: Optional[pulumi.Input[Union['ProviderAssumeRoleArgs', 'ProviderAssumeRoleArgsDict']]] = None,
                 assume_role_with_oidc: Optional[pulumi.Input[Union['ProviderAssumeRoleWithOidcArgs', 'ProviderAssumeRoleWithOidcArgsDict']]] = None,
                 client_connect_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 client_read_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 configuration_source: Optional[pulumi.Input[_builtins.str]] = None,
                 credentials_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 ecs_role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProviderEndpointArgs', 'ProviderEndpointArgsDict']]]]] = None,
                 fc: Optional[pulumi.Input[_builtins.str]] = None,
                 log_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 max_retry_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 mns_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 ots_instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 profile: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_key: Optional[pulumi.Input[_builtins.str]] = None,
                 secure_transport: Optional[pulumi.Input[_builtins.str]] = None,
                 security_token: Optional[pulumi.Input[_builtins.str]] = None,
                 security_transport: Optional[pulumi.Input[_builtins.str]] = None,
                 shared_credentials_file: Optional[pulumi.Input[_builtins.str]] = None,
                 sign_version: Optional[pulumi.Input[Union['ProviderSignVersionArgs', 'ProviderSignVersionArgsDict']]] = None,
                 skip_region_validation: Optional[pulumi.Input[_builtins.bool]] = None,
                 source_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        The provider type for the alicloud package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_key: The access key for API operations. You can retrieve this from the 'Security Management' section of the Alibaba Cloud
               console.
        :param pulumi.Input[_builtins.str] account_id: The account ID for some service API operations. You can retrieve this from the 'Security Settings' section of the
               Alibaba Cloud console.
        :param pulumi.Input[_builtins.int] client_connect_timeout: The maximum timeout of the client connection server.
        :param pulumi.Input[_builtins.int] client_read_timeout: The maximum timeout of the client read request.
        :param pulumi.Input[_builtins.str] credentials_uri: The URI of sidecar credentials service.
        :param pulumi.Input[_builtins.str] ecs_role_name: The RAM Role Name attached on a ECS instance for API operations. You can retrieve this from the 'Access Control' section
               of the Alibaba Cloud console.
        :param pulumi.Input[_builtins.int] max_retry_timeout: The maximum retry timeout of the request.
        :param pulumi.Input[_builtins.str] profile: The profile for API operations. If not set, the default profile created with `aliyun configure` will be used.
        :param pulumi.Input[_builtins.str] region: The region where Alibaba Cloud operations will take place. Examples are cn-beijing, cn-hangzhou, eu-central-1, etc.
        :param pulumi.Input[_builtins.str] secret_key: The secret key for API operations. You can retrieve this from the 'Security Management' section of the Alibaba Cloud
               console.
        :param pulumi.Input[_builtins.str] secure_transport: The security transport for the assume role invoking.
        :param pulumi.Input[_builtins.str] security_token: security token. A security token is only required if you are using Security Token Service.
        :param pulumi.Input[_builtins.str] shared_credentials_file: The path to the shared credentials file. If not set this defaults to ~/.aliyun/config.json
        :param pulumi.Input[_builtins.bool] skip_region_validation: Skip static validation of region ID. Used by users of alternative AlibabaCloud-like APIs or users w/ access to regions
               that are not public (yet).
        :param pulumi.Input[_builtins.str] source_ip: The source ip for the assume role invoking.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ProviderArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The provider type for the alicloud package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param ProviderArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProviderArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 account_type: Optional[pulumi.Input[_builtins.str]] = None,
                 assume_role: Optional[pulumi.Input[Union['ProviderAssumeRoleArgs', 'ProviderAssumeRoleArgsDict']]] = None,
                 assume_role_with_oidc: Optional[pulumi.Input[Union['ProviderAssumeRoleWithOidcArgs', 'ProviderAssumeRoleWithOidcArgsDict']]] = None,
                 client_connect_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 client_read_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 configuration_source: Optional[pulumi.Input[_builtins.str]] = None,
                 credentials_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 ecs_role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProviderEndpointArgs', 'ProviderEndpointArgsDict']]]]] = None,
                 fc: Optional[pulumi.Input[_builtins.str]] = None,
                 log_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 max_retry_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 mns_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 ots_instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 profile: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_key: Optional[pulumi.Input[_builtins.str]] = None,
                 secure_transport: Optional[pulumi.Input[_builtins.str]] = None,
                 security_token: Optional[pulumi.Input[_builtins.str]] = None,
                 security_transport: Optional[pulumi.Input[_builtins.str]] = None,
                 shared_credentials_file: Optional[pulumi.Input[_builtins.str]] = None,
                 sign_version: Optional[pulumi.Input[Union['ProviderSignVersionArgs', 'ProviderSignVersionArgsDict']]] = None,
                 skip_region_validation: Optional[pulumi.Input[_builtins.bool]] = None,
                 source_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProviderArgs.__new__(ProviderArgs)

            __props__.__dict__["access_key"] = access_key
            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["account_type"] = account_type
            __props__.__dict__["assume_role"] = pulumi.Output.from_input(assume_role).apply(pulumi.runtime.to_json) if assume_role is not None else None
            __props__.__dict__["assume_role_with_oidc"] = pulumi.Output.from_input(assume_role_with_oidc).apply(pulumi.runtime.to_json) if assume_role_with_oidc is not None else None
            __props__.__dict__["client_connect_timeout"] = pulumi.Output.from_input(client_connect_timeout).apply(pulumi.runtime.to_json) if client_connect_timeout is not None else None
            __props__.__dict__["client_read_timeout"] = pulumi.Output.from_input(client_read_timeout).apply(pulumi.runtime.to_json) if client_read_timeout is not None else None
            __props__.__dict__["configuration_source"] = configuration_source
            __props__.__dict__["credentials_uri"] = credentials_uri
            if ecs_role_name is None:
                ecs_role_name = _utilities.get_env('ALICLOUD_ECS_ROLE_NAME')
            __props__.__dict__["ecs_role_name"] = ecs_role_name
            __props__.__dict__["endpoints"] = pulumi.Output.from_input(endpoints).apply(pulumi.runtime.to_json) if endpoints is not None else None
            __props__.__dict__["fc"] = fc
            __props__.__dict__["log_endpoint"] = log_endpoint
            __props__.__dict__["max_retry_timeout"] = pulumi.Output.from_input(max_retry_timeout).apply(pulumi.runtime.to_json) if max_retry_timeout is not None else None
            __props__.__dict__["mns_endpoint"] = mns_endpoint
            __props__.__dict__["ots_instance_name"] = ots_instance_name
            if profile is None:
                profile = _utilities.get_env('ALICLOUD_PROFILE')
            __props__.__dict__["profile"] = profile
            __props__.__dict__["protocol"] = protocol
            if region is None:
                region = _utilities.get_env('ALICLOUD_REGION')
            __props__.__dict__["region"] = region
            __props__.__dict__["secret_key"] = secret_key
            __props__.__dict__["secure_transport"] = secure_transport
            __props__.__dict__["security_token"] = security_token
            __props__.__dict__["security_transport"] = security_transport
            __props__.__dict__["shared_credentials_file"] = shared_credentials_file
            __props__.__dict__["sign_version"] = pulumi.Output.from_input(sign_version).apply(pulumi.runtime.to_json) if sign_version is not None else None
            __props__.__dict__["skip_region_validation"] = pulumi.Output.from_input(skip_region_validation).apply(pulumi.runtime.to_json) if skip_region_validation is not None else None
            __props__.__dict__["source_ip"] = source_ip
        super(Provider, __self__).__init__(
            'alicloud',
            resource_name,
            __props__,
            opts)

    @_builtins.property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The access key for API operations. You can retrieve this from the 'Security Management' section of the Alibaba Cloud
        console.
        """
        return pulumi.get(self, "access_key")

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The account ID for some service API operations. You can retrieve this from the 'Security Settings' section of the
        Alibaba Cloud console.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="accountType")
    def account_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "account_type")

    @_builtins.property
    @pulumi.getter(name="configurationSource")
    def configuration_source(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "configuration_source")

    @_builtins.property
    @pulumi.getter(name="credentialsUri")
    def credentials_uri(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The URI of sidecar credentials service.
        """
        return pulumi.get(self, "credentials_uri")

    @_builtins.property
    @pulumi.getter(name="ecsRoleName")
    def ecs_role_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The RAM Role Name attached on a ECS instance for API operations. You can retrieve this from the 'Access Control' section
        of the Alibaba Cloud console.
        """
        return pulumi.get(self, "ecs_role_name")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'fc' has been deprecated from provider version 1.28.0. New field 'fc' which in nested endpoints instead.""")
    def fc(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "fc")

    @_builtins.property
    @pulumi.getter(name="logEndpoint")
    @_utilities.deprecated("""Field 'log_endpoint' has been deprecated from provider version 1.28.0. New field 'log' which in nested endpoints instead.""")
    def log_endpoint(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "log_endpoint")

    @_builtins.property
    @pulumi.getter(name="mnsEndpoint")
    @_utilities.deprecated("""Field 'mns_endpoint' has been deprecated from provider version 1.28.0. New field 'mns' which in nested endpoints instead.""")
    def mns_endpoint(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "mns_endpoint")

    @_builtins.property
    @pulumi.getter(name="otsInstanceName")
    @_utilities.deprecated("""Field 'ots_instance_name' has been deprecated from provider version 1.10.0. New field 'instance_name' of resource 'alicloud_ots_table' instead.""")
    def ots_instance_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "ots_instance_name")

    @_builtins.property
    @pulumi.getter
    def profile(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The profile for API operations. If not set, the default profile created with `aliyun configure` will be used.
        """
        return pulumi.get(self, "profile")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The region where Alibaba Cloud operations will take place. Examples are cn-beijing, cn-hangzhou, eu-central-1, etc.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The secret key for API operations. You can retrieve this from the 'Security Management' section of the Alibaba Cloud
        console.
        """
        return pulumi.get(self, "secret_key")

    @_builtins.property
    @pulumi.getter(name="secureTransport")
    def secure_transport(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The security transport for the assume role invoking.
        """
        return pulumi.get(self, "secure_transport")

    @_builtins.property
    @pulumi.getter(name="securityToken")
    def security_token(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        security token. A security token is only required if you are using Security Token Service.
        """
        return pulumi.get(self, "security_token")

    @_builtins.property
    @pulumi.getter(name="securityTransport")
    def security_transport(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "security_transport")

    @_builtins.property
    @pulumi.getter(name="sharedCredentialsFile")
    def shared_credentials_file(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The path to the shared credentials file. If not set this defaults to ~/.aliyun/config.json
        """
        return pulumi.get(self, "shared_credentials_file")

    @_builtins.property
    @pulumi.getter(name="sourceIp")
    def source_ip(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The source ip for the assume role invoking.
        """
        return pulumi.get(self, "source_ip")

    @pulumi.output_type
    class TerraformConfigResult:
        def __init__(__self__, result=None):
            if result and not isinstance(result, dict):
                raise TypeError("Expected argument 'result' to be a dict")
            pulumi.set(__self__, "result", result)

        @_builtins.property
        @pulumi.getter
        def result(self) -> Mapping[str, Any]:
            return pulumi.get(self, "result")

    def terraform_config(__self__) -> pulumi.Output['Provider.TerraformConfigResult']:
        """
        This function returns a Terraform config object with terraform-namecased keys,to be used with the Terraform Module Provider.
        """
        __args__ = dict()
        __args__['__self__'] = __self__
        return pulumi.runtime.call('pulumi:providers:alicloud/terraformConfig', __args__, res=__self__, typ=Provider.TerraformConfigResult)

