# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'EndpointIpConfigArgs',
    'EndpointIpConfigArgsDict',
    'RuleAttachmentVpcArgs',
    'RuleAttachmentVpcArgsDict',
    'RuleForwardIpArgs',
    'RuleForwardIpArgsDict',
    'ZoneAttachmentVpcArgs',
    'ZoneAttachmentVpcArgsDict',
    'ZoneUserInfoArgs',
    'ZoneUserInfoArgsDict',
]

MYPY = False

if not MYPY:
    class EndpointIpConfigArgsDict(TypedDict):
        cidr_block: pulumi.Input[_builtins.str]
        """
        The Subnet mask.
        """
        vswitch_id: pulumi.Input[_builtins.str]
        """
        The Vswitch id.
        """
        zone_id: pulumi.Input[_builtins.str]
        """
        The Zone ID.
        """
        ip: NotRequired[pulumi.Input[_builtins.str]]
        """
        The IP address within the parameter range of the subnet mask.  It is recommended to use the IP address assigned by the system.
        """
elif False:
    EndpointIpConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class EndpointIpConfigArgs:
    def __init__(__self__, *,
                 cidr_block: pulumi.Input[_builtins.str],
                 vswitch_id: pulumi.Input[_builtins.str],
                 zone_id: pulumi.Input[_builtins.str],
                 ip: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] cidr_block: The Subnet mask.
        :param pulumi.Input[_builtins.str] vswitch_id: The Vswitch id.
        :param pulumi.Input[_builtins.str] zone_id: The Zone ID.
        :param pulumi.Input[_builtins.str] ip: The IP address within the parameter range of the subnet mask.  It is recommended to use the IP address assigned by the system.
        """
        pulumi.set(__self__, "cidr_block", cidr_block)
        pulumi.set(__self__, "vswitch_id", vswitch_id)
        pulumi.set(__self__, "zone_id", zone_id)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)

    @_builtins.property
    @pulumi.getter(name="cidrBlock")
    def cidr_block(self) -> pulumi.Input[_builtins.str]:
        """
        The Subnet mask.
        """
        return pulumi.get(self, "cidr_block")

    @cidr_block.setter
    def cidr_block(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cidr_block", value)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Input[_builtins.str]:
        """
        The Vswitch id.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vswitch_id", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Input[_builtins.str]:
        """
        The Zone ID.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "zone_id", value)

    @_builtins.property
    @pulumi.getter
    def ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP address within the parameter range of the subnet mask.  It is recommended to use the IP address assigned by the system.
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip", value)


if not MYPY:
    class RuleAttachmentVpcArgsDict(TypedDict):
        region_id: pulumi.Input[_builtins.str]
        """
        The region of the vpc. If not set, the current region will instead of.
        """
        vpc_id: pulumi.Input[_builtins.str]
        """
        The ID of the VPC.  **NOTE:** The VPC that can be associated with the forwarding rule must belong to the same region as the Endpoint.
        """
elif False:
    RuleAttachmentVpcArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RuleAttachmentVpcArgs:
    def __init__(__self__, *,
                 region_id: pulumi.Input[_builtins.str],
                 vpc_id: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] region_id: The region of the vpc. If not set, the current region will instead of.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the VPC.  **NOTE:** The VPC that can be associated with the forwarding rule must belong to the same region as the Endpoint.
        """
        pulumi.set(__self__, "region_id", region_id)
        pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> pulumi.Input[_builtins.str]:
        """
        The region of the vpc. If not set, the current region will instead of.
        """
        return pulumi.get(self, "region_id")

    @region_id.setter
    def region_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "region_id", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the VPC.  **NOTE:** The VPC that can be associated with the forwarding rule must belong to the same region as the Endpoint.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vpc_id", value)


if not MYPY:
    class RuleForwardIpArgsDict(TypedDict):
        ip: pulumi.Input[_builtins.str]
        """
        The ip of the forwarding destination.
        """
        port: pulumi.Input[_builtins.int]
        """
        The port of the forwarding destination.
        """
elif False:
    RuleForwardIpArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RuleForwardIpArgs:
    def __init__(__self__, *,
                 ip: pulumi.Input[_builtins.str],
                 port: pulumi.Input[_builtins.int]):
        """
        :param pulumi.Input[_builtins.str] ip: The ip of the forwarding destination.
        :param pulumi.Input[_builtins.int] port: The port of the forwarding destination.
        """
        pulumi.set(__self__, "ip", ip)
        pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter
    def ip(self) -> pulumi.Input[_builtins.str]:
        """
        The ip of the forwarding destination.
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "ip", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> pulumi.Input[_builtins.int]:
        """
        The port of the forwarding destination.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "port", value)


if not MYPY:
    class ZoneAttachmentVpcArgsDict(TypedDict):
        vpc_id: pulumi.Input[_builtins.str]
        """
        The Id of the vpc.
        """
        region_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The region of the vpc. If not set, the current region will instead of.
        """
elif False:
    ZoneAttachmentVpcArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ZoneAttachmentVpcArgs:
    def __init__(__self__, *,
                 vpc_id: pulumi.Input[_builtins.str],
                 region_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] vpc_id: The Id of the vpc.
        :param pulumi.Input[_builtins.str] region_id: The region of the vpc. If not set, the current region will instead of.
        """
        pulumi.set(__self__, "vpc_id", vpc_id)
        if region_id is not None:
            pulumi.set(__self__, "region_id", region_id)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[_builtins.str]:
        """
        The Id of the vpc.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region of the vpc. If not set, the current region will instead of.
        """
        return pulumi.get(self, "region_id")

    @region_id.setter
    def region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region_id", value)


if not MYPY:
    class ZoneUserInfoArgsDict(TypedDict):
        region_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        The list of the region IDs.
        """
        user_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The user ID belonging to the region is used for cross-account synchronization scenarios.
        """
elif False:
    ZoneUserInfoArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ZoneUserInfoArgs:
    def __init__(__self__, *,
                 region_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 user_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] region_ids: The list of the region IDs.
        :param pulumi.Input[_builtins.str] user_id: The user ID belonging to the region is used for cross-account synchronization scenarios.
        """
        if region_ids is not None:
            pulumi.set(__self__, "region_ids", region_ids)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)

    @_builtins.property
    @pulumi.getter(name="regionIds")
    def region_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of the region IDs.
        """
        return pulumi.get(self, "region_ids")

    @region_ids.setter
    def region_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "region_ids", value)

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The user ID belonging to the region is used for cross-account synchronization scenarios.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_id", value)


