# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetZoneRecordsResult',
    'AwaitableGetZoneRecordsResult',
    'get_zone_records',
    'get_zone_records_output',
]

@pulumi.output_type
class GetZoneRecordsResult:
    """
    A collection of values returned by getZoneRecords.
    """
    def __init__(__self__, id=None, ids=None, keyword=None, lang=None, output_file=None, records=None, search_mode=None, status=None, tag=None, user_client_ip=None, zone_id=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if keyword and not isinstance(keyword, str):
            raise TypeError("Expected argument 'keyword' to be a str")
        pulumi.set(__self__, "keyword", keyword)
        if lang and not isinstance(lang, str):
            raise TypeError("Expected argument 'lang' to be a str")
        pulumi.set(__self__, "lang", lang)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if records and not isinstance(records, list):
            raise TypeError("Expected argument 'records' to be a list")
        pulumi.set(__self__, "records", records)
        if search_mode and not isinstance(search_mode, str):
            raise TypeError("Expected argument 'search_mode' to be a str")
        pulumi.set(__self__, "search_mode", search_mode)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tag and not isinstance(tag, str):
            raise TypeError("Expected argument 'tag' to be a str")
        pulumi.set(__self__, "tag", tag)
        if user_client_ip and not isinstance(user_client_ip, str):
            raise TypeError("Expected argument 'user_client_ip' to be a str")
        pulumi.set(__self__, "user_client_ip", user_client_ip)
        if zone_id and not isinstance(zone_id, str):
            raise TypeError("Expected argument 'zone_id' to be a str")
        pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter
    def keyword(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "keyword")

    @_builtins.property
    @pulumi.getter
    def lang(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "lang")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter
    def records(self) -> Sequence['outputs.GetZoneRecordsRecordResult']:
        """
        A list of Zone Record. Each element contains the following attributes:
        """
        return pulumi.get(self, "records")

    @_builtins.property
    @pulumi.getter(name="searchMode")
    def search_mode(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "search_mode")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        The state of the Private Zone Record.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tag(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "tag")

    @_builtins.property
    @pulumi.getter(name="userClientIp")
    def user_client_ip(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "user_client_ip")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> _builtins.str:
        return pulumi.get(self, "zone_id")


class AwaitableGetZoneRecordsResult(GetZoneRecordsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetZoneRecordsResult(
            id=self.id,
            ids=self.ids,
            keyword=self.keyword,
            lang=self.lang,
            output_file=self.output_file,
            records=self.records,
            search_mode=self.search_mode,
            status=self.status,
            tag=self.tag,
            user_client_ip=self.user_client_ip,
            zone_id=self.zone_id)


def get_zone_records(ids: Optional[Sequence[_builtins.str]] = None,
                     keyword: Optional[_builtins.str] = None,
                     lang: Optional[_builtins.str] = None,
                     output_file: Optional[_builtins.str] = None,
                     search_mode: Optional[_builtins.str] = None,
                     status: Optional[_builtins.str] = None,
                     tag: Optional[_builtins.str] = None,
                     user_client_ip: Optional[_builtins.str] = None,
                     zone_id: Optional[_builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetZoneRecordsResult:
    """
    This data source provides the Private Zone Records of the current Alibaba Cloud user.

    > **NOTE:** Available since v1.13.0.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "terraform-example.com"
    default = alicloud.pvtz.Zone("default", zone_name=name)
    default_zone_record = alicloud.pvtz.ZoneRecord("default",
        zone_id=default.id,
        rr="www",
        type="MX",
        value=name,
        ttl=60,
        priority=2,
        remark=name)
    ids = alicloud.pvtz.get_zone_records_output(zone_id=default_zone_record.zone_id,
        ids=[default_zone_record.record_id])
    pulumi.export("pvtzZoneRecordsId0", ids.records[0].id)
    ```


    :param Sequence[_builtins.str] ids: A list of Private Zone Record IDs.
    :param _builtins.str keyword: The keyword for record rr and value.
    :param _builtins.str lang: The language of the response. Default value: `en`. Valid values: `en`, `zh`.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str search_mode: The search mode. Default value: `EXACT`. Valid values:
           - `LIKE`: Fuzzy search.
           - `EXACT`: Exact search.
    :param _builtins.str status: The status of the Resolve record. Valid values:
           - `ENABLE`: Enable resolution.
           - `DISABLE`: Pause parsing.
    :param _builtins.str tag: The tag used to search for DNS records.
    :param _builtins.str user_client_ip: The IP address of the client.
    :param _builtins.str zone_id: The ID of the private zone.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['keyword'] = keyword
    __args__['lang'] = lang
    __args__['outputFile'] = output_file
    __args__['searchMode'] = search_mode
    __args__['status'] = status
    __args__['tag'] = tag
    __args__['userClientIp'] = user_client_ip
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:pvtz/getZoneRecords:getZoneRecords', __args__, opts=opts, typ=GetZoneRecordsResult).value

    return AwaitableGetZoneRecordsResult(
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        keyword=pulumi.get(__ret__, 'keyword'),
        lang=pulumi.get(__ret__, 'lang'),
        output_file=pulumi.get(__ret__, 'output_file'),
        records=pulumi.get(__ret__, 'records'),
        search_mode=pulumi.get(__ret__, 'search_mode'),
        status=pulumi.get(__ret__, 'status'),
        tag=pulumi.get(__ret__, 'tag'),
        user_client_ip=pulumi.get(__ret__, 'user_client_ip'),
        zone_id=pulumi.get(__ret__, 'zone_id'))
def get_zone_records_output(ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                            keyword: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            lang: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            search_mode: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            tag: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            user_client_ip: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetZoneRecordsResult]:
    """
    This data source provides the Private Zone Records of the current Alibaba Cloud user.

    > **NOTE:** Available since v1.13.0.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "terraform-example.com"
    default = alicloud.pvtz.Zone("default", zone_name=name)
    default_zone_record = alicloud.pvtz.ZoneRecord("default",
        zone_id=default.id,
        rr="www",
        type="MX",
        value=name,
        ttl=60,
        priority=2,
        remark=name)
    ids = alicloud.pvtz.get_zone_records_output(zone_id=default_zone_record.zone_id,
        ids=[default_zone_record.record_id])
    pulumi.export("pvtzZoneRecordsId0", ids.records[0].id)
    ```


    :param Sequence[_builtins.str] ids: A list of Private Zone Record IDs.
    :param _builtins.str keyword: The keyword for record rr and value.
    :param _builtins.str lang: The language of the response. Default value: `en`. Valid values: `en`, `zh`.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str search_mode: The search mode. Default value: `EXACT`. Valid values:
           - `LIKE`: Fuzzy search.
           - `EXACT`: Exact search.
    :param _builtins.str status: The status of the Resolve record. Valid values:
           - `ENABLE`: Enable resolution.
           - `DISABLE`: Pause parsing.
    :param _builtins.str tag: The tag used to search for DNS records.
    :param _builtins.str user_client_ip: The IP address of the client.
    :param _builtins.str zone_id: The ID of the private zone.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['keyword'] = keyword
    __args__['lang'] = lang
    __args__['outputFile'] = output_file
    __args__['searchMode'] = search_mode
    __args__['status'] = status
    __args__['tag'] = tag
    __args__['userClientIp'] = user_client_ip
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:pvtz/getZoneRecords:getZoneRecords', __args__, opts=opts, typ=GetZoneRecordsResult)
    return __ret__.apply(lambda __response__: GetZoneRecordsResult(
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        keyword=pulumi.get(__response__, 'keyword'),
        lang=pulumi.get(__response__, 'lang'),
        output_file=pulumi.get(__response__, 'output_file'),
        records=pulumi.get(__response__, 'records'),
        search_mode=pulumi.get(__response__, 'search_mode'),
        status=pulumi.get(__response__, 'status'),
        tag=pulumi.get(__response__, 'tag'),
        user_client_ip=pulumi.get(__response__, 'user_client_ip'),
        zone_id=pulumi.get(__response__, 'zone_id')))
