# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['CustomDiskArgs', 'CustomDisk']

@pulumi.input_type
class CustomDiskArgs:
    def __init__(__self__, *,
                 disk_category: pulumi.Input[_builtins.str],
                 size: pulumi.Input[_builtins.int],
                 zone_id: pulumi.Input[_builtins.str],
                 auto_pay: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_name: Optional[pulumi.Input[_builtins.str]] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 performance_level: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a CustomDisk resource.
        :param pulumi.Input[_builtins.str] disk_category: The type of the data disk. Value range:
        :param pulumi.Input[_builtins.int] size: Capacity size. Unit: GiB. You must pass in a parameter value for this parameter. Value range:
        :param pulumi.Input[_builtins.str] zone_id: The zone ID.
        :param pulumi.Input[_builtins.bool] auto_pay: Whether to pay automatically. Value range:
        :param pulumi.Input[_builtins.bool] auto_renew: Whether to automatically renew. This parameter is passed in only when you create a data disk. Valid values:
        :param pulumi.Input[_builtins.str] description: The disk description. It must be 2 to 256 characters in length and cannot start with 'http:// 'or 'https.
               Default value: empty.
        :param pulumi.Input[_builtins.str] disk_name: The disk name. It can be 2 to 128 characters in length. It supports letters in Unicode (including English, Chinese, and numbers). Can contain a colon (:), an underscore (_), a period (.), or a dash (-).
               Default value: empty.
        :param pulumi.Input[_builtins.bool] dry_run: Whether to pre-check the instance creation operation. Valid values:
        :param pulumi.Input[_builtins.str] instance_charge_type: The Payment type. Only `Postpaid`: Pay-As-You-Go is supported.
        :param pulumi.Input[_builtins.str] performance_level: When creating an ESSD cloud disk, set the performance level of the disk. Value range:
               - `PL0`: The maximum random read/write IOPS 10000 for a single disk.
               - `PL1` (default): The maximum number of random read/write IOPS 50000 for a single disk.
               - `PL2`: maximum random read/write IOPS 100000 for a single disk.
               - `PL3`: The maximum random read/write IOPS 1 million for a single disk.
               
               For more information about how to select an ESSD performance level, see ESSD cloud disk.
        :param pulumi.Input[_builtins.int] period: Reserved parameters, no need to fill in.
        :param pulumi.Input[_builtins.str] period_unit: Reserved parameters, no need to fill in.
        :param pulumi.Input[_builtins.str] snapshot_id: The snapshot used to create the cloud disk. Snapshots made on or before July 15, 2013 cannot be used to create cloud disks. The 'SnapshotId' parameter and the 'Size' parameter have the following limitations:
               - If the snapshot capacity corresponding to the 'SnapshotId' parameter is greater than the set 'Size' parameter value, the actual size of the cloud disk created is the size of the specified snapshot.
               - If the snapshot capacity corresponding to the 'SnapshotId' parameter is less than the set 'Size' parameter value, the size of the cloud disk created is the specified 'Size' parameter value.
               - Snapshots are not supported for creating elastic temporary disks.
        :param pulumi.Input[_builtins.str] type: The method of expanding the disk. Value range:
               offline (default): offline expansion. After the expansion, the instance must be restarted to take effect.
               online: online expansion, which can be completed without restarting the instance.
        """
        pulumi.set(__self__, "disk_category", disk_category)
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "zone_id", zone_id)
        if auto_pay is not None:
            pulumi.set(__self__, "auto_pay", auto_pay)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disk_name is not None:
            pulumi.set(__self__, "disk_name", disk_name)
        if dry_run is not None:
            pulumi.set(__self__, "dry_run", dry_run)
        if instance_charge_type is not None:
            pulumi.set(__self__, "instance_charge_type", instance_charge_type)
        if performance_level is not None:
            pulumi.set(__self__, "performance_level", performance_level)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="diskCategory")
    def disk_category(self) -> pulumi.Input[_builtins.str]:
        """
        The type of the data disk. Value range:
        """
        return pulumi.get(self, "disk_category")

    @disk_category.setter
    def disk_category(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "disk_category", value)

    @_builtins.property
    @pulumi.getter
    def size(self) -> pulumi.Input[_builtins.int]:
        """
        Capacity size. Unit: GiB. You must pass in a parameter value for this parameter. Value range:
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "size", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Input[_builtins.str]:
        """
        The zone ID.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "zone_id", value)

    @_builtins.property
    @pulumi.getter(name="autoPay")
    def auto_pay(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to pay automatically. Value range:
        """
        return pulumi.get(self, "auto_pay")

    @auto_pay.setter
    def auto_pay(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_pay", value)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to automatically renew. This parameter is passed in only when you create a data disk. Valid values:
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_renew", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The disk description. It must be 2 to 256 characters in length and cannot start with 'http:// 'or 'https.
        Default value: empty.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="diskName")
    def disk_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The disk name. It can be 2 to 128 characters in length. It supports letters in Unicode (including English, Chinese, and numbers). Can contain a colon (:), an underscore (_), a period (.), or a dash (-).
        Default value: empty.
        """
        return pulumi.get(self, "disk_name")

    @disk_name.setter
    def disk_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "disk_name", value)

    @_builtins.property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to pre-check the instance creation operation. Valid values:
        """
        return pulumi.get(self, "dry_run")

    @dry_run.setter
    def dry_run(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dry_run", value)

    @_builtins.property
    @pulumi.getter(name="instanceChargeType")
    def instance_charge_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Payment type. Only `Postpaid`: Pay-As-You-Go is supported.
        """
        return pulumi.get(self, "instance_charge_type")

    @instance_charge_type.setter
    def instance_charge_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_charge_type", value)

    @_builtins.property
    @pulumi.getter(name="performanceLevel")
    def performance_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When creating an ESSD cloud disk, set the performance level of the disk. Value range:
        - `PL0`: The maximum random read/write IOPS 10000 for a single disk.
        - `PL1` (default): The maximum number of random read/write IOPS 50000 for a single disk.
        - `PL2`: maximum random read/write IOPS 100000 for a single disk.
        - `PL3`: The maximum random read/write IOPS 1 million for a single disk.

        For more information about how to select an ESSD performance level, see ESSD cloud disk.
        """
        return pulumi.get(self, "performance_level")

    @performance_level.setter
    def performance_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "performance_level", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Reserved parameters, no need to fill in.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Reserved parameters, no need to fill in.
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "period_unit", value)

    @_builtins.property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The snapshot used to create the cloud disk. Snapshots made on or before July 15, 2013 cannot be used to create cloud disks. The 'SnapshotId' parameter and the 'Size' parameter have the following limitations:
        - If the snapshot capacity corresponding to the 'SnapshotId' parameter is greater than the set 'Size' parameter value, the actual size of the cloud disk created is the size of the specified snapshot.
        - If the snapshot capacity corresponding to the 'SnapshotId' parameter is less than the set 'Size' parameter value, the size of the cloud disk created is the specified 'Size' parameter value.
        - Snapshots are not supported for creating elastic temporary disks.
        """
        return pulumi.get(self, "snapshot_id")

    @snapshot_id.setter
    def snapshot_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snapshot_id", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The method of expanding the disk. Value range:
        offline (default): offline expansion. After the expansion, the instance must be restarted to take effect.
        online: online expansion, which can be completed without restarting the instance.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class _CustomDiskState:
    def __init__(__self__, *,
                 auto_pay: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_category: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_name: Optional[pulumi.Input[_builtins.str]] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 performance_level: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 size: Optional[pulumi.Input[_builtins.int]] = None,
                 snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering CustomDisk resources.
        :param pulumi.Input[_builtins.bool] auto_pay: Whether to pay automatically. Value range:
        :param pulumi.Input[_builtins.bool] auto_renew: Whether to automatically renew. This parameter is passed in only when you create a data disk. Valid values:
        :param pulumi.Input[_builtins.str] create_time: Creation time.
        :param pulumi.Input[_builtins.str] description: The disk description. It must be 2 to 256 characters in length and cannot start with 'http:// 'or 'https.
               Default value: empty.
        :param pulumi.Input[_builtins.str] disk_category: The type of the data disk. Value range:
        :param pulumi.Input[_builtins.str] disk_name: The disk name. It can be 2 to 128 characters in length. It supports letters in Unicode (including English, Chinese, and numbers). Can contain a colon (:), an underscore (_), a period (.), or a dash (-).
               Default value: empty.
        :param pulumi.Input[_builtins.bool] dry_run: Whether to pre-check the instance creation operation. Valid values:
        :param pulumi.Input[_builtins.str] instance_charge_type: The Payment type. Only `Postpaid`: Pay-As-You-Go is supported.
        :param pulumi.Input[_builtins.str] performance_level: When creating an ESSD cloud disk, set the performance level of the disk. Value range:
               - `PL0`: The maximum random read/write IOPS 10000 for a single disk.
               - `PL1` (default): The maximum number of random read/write IOPS 50000 for a single disk.
               - `PL2`: maximum random read/write IOPS 100000 for a single disk.
               - `PL3`: The maximum random read/write IOPS 1 million for a single disk.
               
               For more information about how to select an ESSD performance level, see ESSD cloud disk.
        :param pulumi.Input[_builtins.int] period: Reserved parameters, no need to fill in.
        :param pulumi.Input[_builtins.str] period_unit: Reserved parameters, no need to fill in.
        :param pulumi.Input[_builtins.str] region_id: The region ID. You can view the region ID through the DescribeRegions interface.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group to which the disk belongs.
        :param pulumi.Input[_builtins.int] size: Capacity size. Unit: GiB. You must pass in a parameter value for this parameter. Value range:
        :param pulumi.Input[_builtins.str] snapshot_id: The snapshot used to create the cloud disk. Snapshots made on or before July 15, 2013 cannot be used to create cloud disks. The 'SnapshotId' parameter and the 'Size' parameter have the following limitations:
               - If the snapshot capacity corresponding to the 'SnapshotId' parameter is greater than the set 'Size' parameter value, the actual size of the cloud disk created is the size of the specified snapshot.
               - If the snapshot capacity corresponding to the 'SnapshotId' parameter is less than the set 'Size' parameter value, the size of the cloud disk created is the specified 'Size' parameter value.
               - Snapshots are not supported for creating elastic temporary disks.
        :param pulumi.Input[_builtins.str] status: Disk status. Value Description:_use: In use.
        :param pulumi.Input[_builtins.str] type: The method of expanding the disk. Value range:
               offline (default): offline expansion. After the expansion, the instance must be restarted to take effect.
               online: online expansion, which can be completed without restarting the instance.
        :param pulumi.Input[_builtins.str] zone_id: The zone ID.
        """
        if auto_pay is not None:
            pulumi.set(__self__, "auto_pay", auto_pay)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disk_category is not None:
            pulumi.set(__self__, "disk_category", disk_category)
        if disk_name is not None:
            pulumi.set(__self__, "disk_name", disk_name)
        if dry_run is not None:
            pulumi.set(__self__, "dry_run", dry_run)
        if instance_charge_type is not None:
            pulumi.set(__self__, "instance_charge_type", instance_charge_type)
        if performance_level is not None:
            pulumi.set(__self__, "performance_level", performance_level)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if region_id is not None:
            pulumi.set(__self__, "region_id", region_id)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="autoPay")
    def auto_pay(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to pay automatically. Value range:
        """
        return pulumi.get(self, "auto_pay")

    @auto_pay.setter
    def auto_pay(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_pay", value)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to automatically renew. This parameter is passed in only when you create a data disk. Valid values:
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_renew", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Creation time.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The disk description. It must be 2 to 256 characters in length and cannot start with 'http:// 'or 'https.
        Default value: empty.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="diskCategory")
    def disk_category(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the data disk. Value range:
        """
        return pulumi.get(self, "disk_category")

    @disk_category.setter
    def disk_category(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "disk_category", value)

    @_builtins.property
    @pulumi.getter(name="diskName")
    def disk_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The disk name. It can be 2 to 128 characters in length. It supports letters in Unicode (including English, Chinese, and numbers). Can contain a colon (:), an underscore (_), a period (.), or a dash (-).
        Default value: empty.
        """
        return pulumi.get(self, "disk_name")

    @disk_name.setter
    def disk_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "disk_name", value)

    @_builtins.property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to pre-check the instance creation operation. Valid values:
        """
        return pulumi.get(self, "dry_run")

    @dry_run.setter
    def dry_run(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dry_run", value)

    @_builtins.property
    @pulumi.getter(name="instanceChargeType")
    def instance_charge_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Payment type. Only `Postpaid`: Pay-As-You-Go is supported.
        """
        return pulumi.get(self, "instance_charge_type")

    @instance_charge_type.setter
    def instance_charge_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_charge_type", value)

    @_builtins.property
    @pulumi.getter(name="performanceLevel")
    def performance_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When creating an ESSD cloud disk, set the performance level of the disk. Value range:
        - `PL0`: The maximum random read/write IOPS 10000 for a single disk.
        - `PL1` (default): The maximum number of random read/write IOPS 50000 for a single disk.
        - `PL2`: maximum random read/write IOPS 100000 for a single disk.
        - `PL3`: The maximum random read/write IOPS 1 million for a single disk.

        For more information about how to select an ESSD performance level, see ESSD cloud disk.
        """
        return pulumi.get(self, "performance_level")

    @performance_level.setter
    def performance_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "performance_level", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Reserved parameters, no need to fill in.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Reserved parameters, no need to fill in.
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "period_unit", value)

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region ID. You can view the region ID through the DescribeRegions interface.
        """
        return pulumi.get(self, "region_id")

    @region_id.setter
    def region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group to which the disk belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Capacity size. Unit: GiB. You must pass in a parameter value for this parameter. Value range:
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "size", value)

    @_builtins.property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The snapshot used to create the cloud disk. Snapshots made on or before July 15, 2013 cannot be used to create cloud disks. The 'SnapshotId' parameter and the 'Size' parameter have the following limitations:
        - If the snapshot capacity corresponding to the 'SnapshotId' parameter is greater than the set 'Size' parameter value, the actual size of the cloud disk created is the size of the specified snapshot.
        - If the snapshot capacity corresponding to the 'SnapshotId' parameter is less than the set 'Size' parameter value, the size of the cloud disk created is the specified 'Size' parameter value.
        - Snapshots are not supported for creating elastic temporary disks.
        """
        return pulumi.get(self, "snapshot_id")

    @snapshot_id.setter
    def snapshot_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snapshot_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Disk status. Value Description:_use: In use.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The method of expanding the disk. Value range:
        offline (default): offline expansion. After the expansion, the instance must be restarted to take effect.
        online: online expansion, which can be completed without restarting the instance.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The zone ID.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.type_token("alicloud:rds/customDisk:CustomDisk")
class CustomDisk(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_pay: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_category: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_name: Optional[pulumi.Input[_builtins.str]] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 performance_level: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 size: Optional[pulumi.Input[_builtins.int]] = None,
                 snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a RDS Custom Disk resource.

        RDS User dedicated host disk.

        For information about RDS Custom Disk and how to use it, see [What is Custom Disk](https://next.api.alibabacloud.com/document/Rds/2014-08-15/CreateRCDisk).

        > **NOTE:** Available since v1.247.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        region_id = config.get("regionId")
        if region_id is None:
            region_id = "cn-beijing"
        default = alicloud.rds.CustomDisk("default",
            description="zcc测试用例",
            zone_id="cn-beijing-i",
            size=40,
            performance_level="PL1",
            instance_charge_type="Postpaid",
            disk_category="cloud_essd",
            disk_name="custom_disk_001",
            auto_renew=False,
            period=1,
            auto_pay=True,
            period_unit="1")
        ```

        ## Import

        RDS Custom Disk can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:rds/customDisk:CustomDisk example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] auto_pay: Whether to pay automatically. Value range:
        :param pulumi.Input[_builtins.bool] auto_renew: Whether to automatically renew. This parameter is passed in only when you create a data disk. Valid values:
        :param pulumi.Input[_builtins.str] description: The disk description. It must be 2 to 256 characters in length and cannot start with 'http:// 'or 'https.
               Default value: empty.
        :param pulumi.Input[_builtins.str] disk_category: The type of the data disk. Value range:
        :param pulumi.Input[_builtins.str] disk_name: The disk name. It can be 2 to 128 characters in length. It supports letters in Unicode (including English, Chinese, and numbers). Can contain a colon (:), an underscore (_), a period (.), or a dash (-).
               Default value: empty.
        :param pulumi.Input[_builtins.bool] dry_run: Whether to pre-check the instance creation operation. Valid values:
        :param pulumi.Input[_builtins.str] instance_charge_type: The Payment type. Only `Postpaid`: Pay-As-You-Go is supported.
        :param pulumi.Input[_builtins.str] performance_level: When creating an ESSD cloud disk, set the performance level of the disk. Value range:
               - `PL0`: The maximum random read/write IOPS 10000 for a single disk.
               - `PL1` (default): The maximum number of random read/write IOPS 50000 for a single disk.
               - `PL2`: maximum random read/write IOPS 100000 for a single disk.
               - `PL3`: The maximum random read/write IOPS 1 million for a single disk.
               
               For more information about how to select an ESSD performance level, see ESSD cloud disk.
        :param pulumi.Input[_builtins.int] period: Reserved parameters, no need to fill in.
        :param pulumi.Input[_builtins.str] period_unit: Reserved parameters, no need to fill in.
        :param pulumi.Input[_builtins.int] size: Capacity size. Unit: GiB. You must pass in a parameter value for this parameter. Value range:
        :param pulumi.Input[_builtins.str] snapshot_id: The snapshot used to create the cloud disk. Snapshots made on or before July 15, 2013 cannot be used to create cloud disks. The 'SnapshotId' parameter and the 'Size' parameter have the following limitations:
               - If the snapshot capacity corresponding to the 'SnapshotId' parameter is greater than the set 'Size' parameter value, the actual size of the cloud disk created is the size of the specified snapshot.
               - If the snapshot capacity corresponding to the 'SnapshotId' parameter is less than the set 'Size' parameter value, the size of the cloud disk created is the specified 'Size' parameter value.
               - Snapshots are not supported for creating elastic temporary disks.
        :param pulumi.Input[_builtins.str] type: The method of expanding the disk. Value range:
               offline (default): offline expansion. After the expansion, the instance must be restarted to take effect.
               online: online expansion, which can be completed without restarting the instance.
        :param pulumi.Input[_builtins.str] zone_id: The zone ID.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CustomDiskArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a RDS Custom Disk resource.

        RDS User dedicated host disk.

        For information about RDS Custom Disk and how to use it, see [What is Custom Disk](https://next.api.alibabacloud.com/document/Rds/2014-08-15/CreateRCDisk).

        > **NOTE:** Available since v1.247.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        region_id = config.get("regionId")
        if region_id is None:
            region_id = "cn-beijing"
        default = alicloud.rds.CustomDisk("default",
            description="zcc测试用例",
            zone_id="cn-beijing-i",
            size=40,
            performance_level="PL1",
            instance_charge_type="Postpaid",
            disk_category="cloud_essd",
            disk_name="custom_disk_001",
            auto_renew=False,
            period=1,
            auto_pay=True,
            period_unit="1")
        ```

        ## Import

        RDS Custom Disk can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:rds/customDisk:CustomDisk example <id>
        ```

        :param str resource_name: The name of the resource.
        :param CustomDiskArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CustomDiskArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_pay: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_category: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_name: Optional[pulumi.Input[_builtins.str]] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 performance_level: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 size: Optional[pulumi.Input[_builtins.int]] = None,
                 snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CustomDiskArgs.__new__(CustomDiskArgs)

            __props__.__dict__["auto_pay"] = auto_pay
            __props__.__dict__["auto_renew"] = auto_renew
            __props__.__dict__["description"] = description
            if disk_category is None and not opts.urn:
                raise TypeError("Missing required property 'disk_category'")
            __props__.__dict__["disk_category"] = disk_category
            __props__.__dict__["disk_name"] = disk_name
            __props__.__dict__["dry_run"] = dry_run
            __props__.__dict__["instance_charge_type"] = instance_charge_type
            __props__.__dict__["performance_level"] = performance_level
            __props__.__dict__["period"] = period
            __props__.__dict__["period_unit"] = period_unit
            if size is None and not opts.urn:
                raise TypeError("Missing required property 'size'")
            __props__.__dict__["size"] = size
            __props__.__dict__["snapshot_id"] = snapshot_id
            __props__.__dict__["type"] = type
            if zone_id is None and not opts.urn:
                raise TypeError("Missing required property 'zone_id'")
            __props__.__dict__["zone_id"] = zone_id
            __props__.__dict__["create_time"] = None
            __props__.__dict__["region_id"] = None
            __props__.__dict__["resource_group_id"] = None
            __props__.__dict__["status"] = None
        super(CustomDisk, __self__).__init__(
            'alicloud:rds/customDisk:CustomDisk',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_pay: Optional[pulumi.Input[_builtins.bool]] = None,
            auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            disk_category: Optional[pulumi.Input[_builtins.str]] = None,
            disk_name: Optional[pulumi.Input[_builtins.str]] = None,
            dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
            instance_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
            performance_level: Optional[pulumi.Input[_builtins.str]] = None,
            period: Optional[pulumi.Input[_builtins.int]] = None,
            period_unit: Optional[pulumi.Input[_builtins.str]] = None,
            region_id: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            size: Optional[pulumi.Input[_builtins.int]] = None,
            snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            zone_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'CustomDisk':
        """
        Get an existing CustomDisk resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] auto_pay: Whether to pay automatically. Value range:
        :param pulumi.Input[_builtins.bool] auto_renew: Whether to automatically renew. This parameter is passed in only when you create a data disk. Valid values:
        :param pulumi.Input[_builtins.str] create_time: Creation time.
        :param pulumi.Input[_builtins.str] description: The disk description. It must be 2 to 256 characters in length and cannot start with 'http:// 'or 'https.
               Default value: empty.
        :param pulumi.Input[_builtins.str] disk_category: The type of the data disk. Value range:
        :param pulumi.Input[_builtins.str] disk_name: The disk name. It can be 2 to 128 characters in length. It supports letters in Unicode (including English, Chinese, and numbers). Can contain a colon (:), an underscore (_), a period (.), or a dash (-).
               Default value: empty.
        :param pulumi.Input[_builtins.bool] dry_run: Whether to pre-check the instance creation operation. Valid values:
        :param pulumi.Input[_builtins.str] instance_charge_type: The Payment type. Only `Postpaid`: Pay-As-You-Go is supported.
        :param pulumi.Input[_builtins.str] performance_level: When creating an ESSD cloud disk, set the performance level of the disk. Value range:
               - `PL0`: The maximum random read/write IOPS 10000 for a single disk.
               - `PL1` (default): The maximum number of random read/write IOPS 50000 for a single disk.
               - `PL2`: maximum random read/write IOPS 100000 for a single disk.
               - `PL3`: The maximum random read/write IOPS 1 million for a single disk.
               
               For more information about how to select an ESSD performance level, see ESSD cloud disk.
        :param pulumi.Input[_builtins.int] period: Reserved parameters, no need to fill in.
        :param pulumi.Input[_builtins.str] period_unit: Reserved parameters, no need to fill in.
        :param pulumi.Input[_builtins.str] region_id: The region ID. You can view the region ID through the DescribeRegions interface.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group to which the disk belongs.
        :param pulumi.Input[_builtins.int] size: Capacity size. Unit: GiB. You must pass in a parameter value for this parameter. Value range:
        :param pulumi.Input[_builtins.str] snapshot_id: The snapshot used to create the cloud disk. Snapshots made on or before July 15, 2013 cannot be used to create cloud disks. The 'SnapshotId' parameter and the 'Size' parameter have the following limitations:
               - If the snapshot capacity corresponding to the 'SnapshotId' parameter is greater than the set 'Size' parameter value, the actual size of the cloud disk created is the size of the specified snapshot.
               - If the snapshot capacity corresponding to the 'SnapshotId' parameter is less than the set 'Size' parameter value, the size of the cloud disk created is the specified 'Size' parameter value.
               - Snapshots are not supported for creating elastic temporary disks.
        :param pulumi.Input[_builtins.str] status: Disk status. Value Description:_use: In use.
        :param pulumi.Input[_builtins.str] type: The method of expanding the disk. Value range:
               offline (default): offline expansion. After the expansion, the instance must be restarted to take effect.
               online: online expansion, which can be completed without restarting the instance.
        :param pulumi.Input[_builtins.str] zone_id: The zone ID.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CustomDiskState.__new__(_CustomDiskState)

        __props__.__dict__["auto_pay"] = auto_pay
        __props__.__dict__["auto_renew"] = auto_renew
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["disk_category"] = disk_category
        __props__.__dict__["disk_name"] = disk_name
        __props__.__dict__["dry_run"] = dry_run
        __props__.__dict__["instance_charge_type"] = instance_charge_type
        __props__.__dict__["performance_level"] = performance_level
        __props__.__dict__["period"] = period
        __props__.__dict__["period_unit"] = period_unit
        __props__.__dict__["region_id"] = region_id
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["size"] = size
        __props__.__dict__["snapshot_id"] = snapshot_id
        __props__.__dict__["status"] = status
        __props__.__dict__["type"] = type
        __props__.__dict__["zone_id"] = zone_id
        return CustomDisk(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="autoPay")
    def auto_pay(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to pay automatically. Value range:
        """
        return pulumi.get(self, "auto_pay")

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to automatically renew. This parameter is passed in only when you create a data disk. Valid values:
        """
        return pulumi.get(self, "auto_renew")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        Creation time.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The disk description. It must be 2 to 256 characters in length and cannot start with 'http:// 'or 'https.
        Default value: empty.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="diskCategory")
    def disk_category(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the data disk. Value range:
        """
        return pulumi.get(self, "disk_category")

    @_builtins.property
    @pulumi.getter(name="diskName")
    def disk_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The disk name. It can be 2 to 128 characters in length. It supports letters in Unicode (including English, Chinese, and numbers). Can contain a colon (:), an underscore (_), a period (.), or a dash (-).
        Default value: empty.
        """
        return pulumi.get(self, "disk_name")

    @_builtins.property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to pre-check the instance creation operation. Valid values:
        """
        return pulumi.get(self, "dry_run")

    @_builtins.property
    @pulumi.getter(name="instanceChargeType")
    def instance_charge_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Payment type. Only `Postpaid`: Pay-As-You-Go is supported.
        """
        return pulumi.get(self, "instance_charge_type")

    @_builtins.property
    @pulumi.getter(name="performanceLevel")
    def performance_level(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        When creating an ESSD cloud disk, set the performance level of the disk. Value range:
        - `PL0`: The maximum random read/write IOPS 10000 for a single disk.
        - `PL1` (default): The maximum number of random read/write IOPS 50000 for a single disk.
        - `PL2`: maximum random read/write IOPS 100000 for a single disk.
        - `PL3`: The maximum random read/write IOPS 1 million for a single disk.

        For more information about how to select an ESSD performance level, see ESSD cloud disk.
        """
        return pulumi.get(self, "performance_level")

    @_builtins.property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Reserved parameters, no need to fill in.
        """
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Reserved parameters, no need to fill in.
        """
        return pulumi.get(self, "period_unit")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> pulumi.Output[_builtins.str]:
        """
        The region ID. You can view the region ID through the DescribeRegions interface.
        """
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the resource group to which the disk belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter
    def size(self) -> pulumi.Output[_builtins.int]:
        """
        Capacity size. Unit: GiB. You must pass in a parameter value for this parameter. Value range:
        """
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The snapshot used to create the cloud disk. Snapshots made on or before July 15, 2013 cannot be used to create cloud disks. The 'SnapshotId' parameter and the 'Size' parameter have the following limitations:
        - If the snapshot capacity corresponding to the 'SnapshotId' parameter is greater than the set 'Size' parameter value, the actual size of the cloud disk created is the size of the specified snapshot.
        - If the snapshot capacity corresponding to the 'SnapshotId' parameter is less than the set 'Size' parameter value, the size of the cloud disk created is the specified 'Size' parameter value.
        - Snapshots are not supported for creating elastic temporary disks.
        """
        return pulumi.get(self, "snapshot_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Disk status. Value Description:_use: In use.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The method of expanding the disk. Value range:
        offline (default): offline expansion. After the expansion, the instance must be restarted to take effect.
        online: online expansion, which can be completed without restarting the instance.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[_builtins.str]:
        """
        The zone ID.
        """
        return pulumi.get(self, "zone_id")

